/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"encoding/json"
	"fmt"
)

// UnprocessableContentErrorCode the model 'UnprocessableContentErrorCode'
type UnprocessableContentErrorCode string

// List of UnprocessableContentErrorCode
const (
	NO_THROTTLED_ERROR_CODE UnprocessableContentErrorCode = "no_throttled_error_code"
	THROTTLED_TIMEOUT_ERROR UnprocessableContentErrorCode = "throttled_timeout_error"
)

var allowedUnprocessableContentErrorCodeEnumValues = []UnprocessableContentErrorCode{
	"no_throttled_error_code",
	"throttled_timeout_error",
}

func (v *UnprocessableContentErrorCode) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := UnprocessableContentErrorCode(value)
	for _, existing := range allowedUnprocessableContentErrorCodeEnumValues {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid UnprocessableContentErrorCode", value)
}

// NewUnprocessableContentErrorCodeFromValue returns a pointer to a valid UnprocessableContentErrorCode
// for the value passed as argument, or an error if the value passed is not allowed by the enum
func NewUnprocessableContentErrorCodeFromValue(v string) (*UnprocessableContentErrorCode, error) {
	ev := UnprocessableContentErrorCode(v)
	if ev.IsValid() {
		return &ev, nil
	} else {
		return nil, fmt.Errorf("invalid value '%v' for UnprocessableContentErrorCode: valid values are %v", v, allowedUnprocessableContentErrorCodeEnumValues)
	}
}

// IsValid return true if the value is valid for the enum, false otherwise
func (v UnprocessableContentErrorCode) IsValid() bool {
	for _, existing := range allowedUnprocessableContentErrorCodeEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to UnprocessableContentErrorCode value
func (v UnprocessableContentErrorCode) Ptr() *UnprocessableContentErrorCode {
	return &v
}

type NullableUnprocessableContentErrorCode struct {
	value *UnprocessableContentErrorCode
	isSet bool
}

func (v NullableUnprocessableContentErrorCode) Get() *UnprocessableContentErrorCode {
	return v.value
}

func (v *NullableUnprocessableContentErrorCode) Set(val *UnprocessableContentErrorCode) {
	v.value = val
	v.isSet = true
}

func (v NullableUnprocessableContentErrorCode) IsSet() bool {
	return v.isSet
}

func (v *NullableUnprocessableContentErrorCode) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableUnprocessableContentErrorCode(val *UnprocessableContentErrorCode) *NullableUnprocessableContentErrorCode {
	return &NullableUnprocessableContentErrorCode{value: val, isSet: true}
}

func (v NullableUnprocessableContentErrorCode) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableUnprocessableContentErrorCode) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
