/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// TypedWildcard struct for TypedWildcard
type TypedWildcard struct {
	Type string `json:"type"yaml:"type"`
}

// NewTypedWildcard instantiates a new TypedWildcard object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTypedWildcard(type_ string) *TypedWildcard {
	this := TypedWildcard{}
	this.Type = type_
	return &this
}

// NewTypedWildcardWithDefaults instantiates a new TypedWildcard object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTypedWildcardWithDefaults() *TypedWildcard {
	this := TypedWildcard{}
	return &this
}

// GetType returns the Type field value
func (o *TypedWildcard) GetType() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Type
}

// GetTypeOk returns a tuple with the Type field value
// and a boolean to check if the value has been set.
func (o *TypedWildcard) GetTypeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Type, true
}

// SetType sets field value
func (o *TypedWildcard) SetType(v string) {
	o.Type = v
}

func (o TypedWildcard) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["type"] = o.Type
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableTypedWildcard struct {
	value *TypedWildcard
	isSet bool
}

func (v NullableTypedWildcard) Get() *TypedWildcard {
	return v.value
}

func (v *NullableTypedWildcard) Set(val *TypedWildcard) {
	v.value = val
	v.isSet = true
}

func (v NullableTypedWildcard) IsSet() bool {
	return v.isSet
}

func (v *NullableTypedWildcard) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTypedWildcard(val *TypedWildcard) *NullableTypedWildcard {
	return &NullableTypedWildcard{value: val, isSet: true}
}

func (v NullableTypedWildcard) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTypedWildcard) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
