/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// TupleKey struct for TupleKey
type TupleKey struct {
	User      string                 `json:"user"yaml:"user"`
	Relation  string                 `json:"relation"yaml:"relation"`
	Object    string                 `json:"object"yaml:"object"`
	Condition *RelationshipCondition `json:"condition,omitempty"yaml:"condition,omitempty"`
}

// NewTupleKey instantiates a new TupleKey object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTupleKey(user string, relation string, object string) *TupleKey {
	this := TupleKey{}
	this.User = user
	this.Relation = relation
	this.Object = object
	return &this
}

// NewTupleKeyWithDefaults instantiates a new TupleKey object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTupleKeyWithDefaults() *TupleKey {
	this := TupleKey{}
	return &this
}

// GetUser returns the User field value
func (o *TupleKey) GetUser() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.User
}

// GetUserOk returns a tuple with the User field value
// and a boolean to check if the value has been set.
func (o *TupleKey) GetUserOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.User, true
}

// SetUser sets field value
func (o *TupleKey) SetUser(v string) {
	o.User = v
}

// GetRelation returns the Relation field value
func (o *TupleKey) GetRelation() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Relation
}

// GetRelationOk returns a tuple with the Relation field value
// and a boolean to check if the value has been set.
func (o *TupleKey) GetRelationOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Relation, true
}

// SetRelation sets field value
func (o *TupleKey) SetRelation(v string) {
	o.Relation = v
}

// GetObject returns the Object field value
func (o *TupleKey) GetObject() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Object
}

// GetObjectOk returns a tuple with the Object field value
// and a boolean to check if the value has been set.
func (o *TupleKey) GetObjectOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Object, true
}

// SetObject sets field value
func (o *TupleKey) SetObject(v string) {
	o.Object = v
}

// GetCondition returns the Condition field value if set, zero value otherwise.
func (o *TupleKey) GetCondition() RelationshipCondition {
	if o == nil || o.Condition == nil {
		var ret RelationshipCondition
		return ret
	}
	return *o.Condition
}

// GetConditionOk returns a tuple with the Condition field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TupleKey) GetConditionOk() (*RelationshipCondition, bool) {
	if o == nil || o.Condition == nil {
		return nil, false
	}
	return o.Condition, true
}

// HasCondition returns a boolean if a field has been set.
func (o *TupleKey) HasCondition() bool {
	if o != nil && o.Condition != nil {
		return true
	}

	return false
}

// SetCondition gets a reference to the given RelationshipCondition and assigns it to the Condition field.
func (o *TupleKey) SetCondition(v RelationshipCondition) {
	o.Condition = &v
}

func (o TupleKey) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["user"] = o.User
	toSerialize["relation"] = o.Relation
	toSerialize["object"] = o.Object
	if o.Condition != nil {
		toSerialize["condition"] = o.Condition
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableTupleKey struct {
	value *TupleKey
	isSet bool
}

func (v NullableTupleKey) Get() *TupleKey {
	return v.value
}

func (v *NullableTupleKey) Set(val *TupleKey) {
	v.value = val
	v.isSet = true
}

func (v NullableTupleKey) IsSet() bool {
	return v.isSet
}

func (v *NullableTupleKey) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTupleKey(val *TupleKey) *NullableTupleKey {
	return &NullableTupleKey{value: val, isSet: true}
}

func (v NullableTupleKey) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTupleKey) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
