/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// ObjectOrUserset struct for ObjectOrUserset
type ObjectOrUserset struct {
	Object  *FgaObject   `json:"object,omitempty"yaml:"object,omitempty"`
	Userset *UsersetUser `json:"userset,omitempty"yaml:"userset,omitempty"`
}

// NewObjectOrUserset instantiates a new ObjectOrUserset object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewObjectOrUserset() *ObjectOrUserset {
	this := ObjectOrUserset{}
	return &this
}

// NewObjectOrUsersetWithDefaults instantiates a new ObjectOrUserset object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewObjectOrUsersetWithDefaults() *ObjectOrUserset {
	this := ObjectOrUserset{}
	return &this
}

// GetObject returns the Object field value if set, zero value otherwise.
func (o *ObjectOrUserset) GetObject() FgaObject {
	if o == nil || o.Object == nil {
		var ret FgaObject
		return ret
	}
	return *o.Object
}

// GetObjectOk returns a tuple with the Object field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ObjectOrUserset) GetObjectOk() (*FgaObject, bool) {
	if o == nil || o.Object == nil {
		return nil, false
	}
	return o.Object, true
}

// HasObject returns a boolean if a field has been set.
func (o *ObjectOrUserset) HasObject() bool {
	if o != nil && o.Object != nil {
		return true
	}

	return false
}

// SetObject gets a reference to the given FgaObject and assigns it to the Object field.
func (o *ObjectOrUserset) SetObject(v FgaObject) {
	o.Object = &v
}

// GetUserset returns the Userset field value if set, zero value otherwise.
func (o *ObjectOrUserset) GetUserset() UsersetUser {
	if o == nil || o.Userset == nil {
		var ret UsersetUser
		return ret
	}
	return *o.Userset
}

// GetUsersetOk returns a tuple with the Userset field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ObjectOrUserset) GetUsersetOk() (*UsersetUser, bool) {
	if o == nil || o.Userset == nil {
		return nil, false
	}
	return o.Userset, true
}

// HasUserset returns a boolean if a field has been set.
func (o *ObjectOrUserset) HasUserset() bool {
	if o != nil && o.Userset != nil {
		return true
	}

	return false
}

// SetUserset gets a reference to the given UsersetUser and assigns it to the Userset field.
func (o *ObjectOrUserset) SetUserset(v UsersetUser) {
	o.Userset = &v
}

func (o ObjectOrUserset) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Object != nil {
		toSerialize["object"] = o.Object
	}
	if o.Userset != nil {
		toSerialize["userset"] = o.Userset
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableObjectOrUserset struct {
	value *ObjectOrUserset
	isSet bool
}

func (v NullableObjectOrUserset) Get() *ObjectOrUserset {
	return v.value
}

func (v *NullableObjectOrUserset) Set(val *ObjectOrUserset) {
	v.value = val
	v.isSet = true
}

func (v NullableObjectOrUserset) IsSet() bool {
	return v.isSet
}

func (v *NullableObjectOrUserset) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableObjectOrUserset(val *ObjectOrUserset) *NullableObjectOrUserset {
	return &NullableObjectOrUserset{value: val, isSet: true}
}

func (v NullableObjectOrUserset) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableObjectOrUserset) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
