/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// ConditionParamTypeRef struct for ConditionParamTypeRef
type ConditionParamTypeRef struct {
	TypeName     TypeName                 `json:"type_name"yaml:"type_name"`
	GenericTypes *[]ConditionParamTypeRef `json:"generic_types,omitempty"yaml:"generic_types,omitempty"`
}

// NewConditionParamTypeRef instantiates a new ConditionParamTypeRef object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewConditionParamTypeRef(typeName TypeName) *ConditionParamTypeRef {
	this := ConditionParamTypeRef{}
	this.TypeName = typeName
	return &this
}

// NewConditionParamTypeRefWithDefaults instantiates a new ConditionParamTypeRef object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewConditionParamTypeRefWithDefaults() *ConditionParamTypeRef {
	this := ConditionParamTypeRef{}
	var typeName TypeName = UNSPECIFIED
	this.TypeName = typeName
	return &this
}

// GetTypeName returns the TypeName field value
func (o *ConditionParamTypeRef) GetTypeName() TypeName {
	if o == nil {
		var ret TypeName
		return ret
	}

	return o.TypeName
}

// GetTypeNameOk returns a tuple with the TypeName field value
// and a boolean to check if the value has been set.
func (o *ConditionParamTypeRef) GetTypeNameOk() (*TypeName, bool) {
	if o == nil {
		return nil, false
	}
	return &o.TypeName, true
}

// SetTypeName sets field value
func (o *ConditionParamTypeRef) SetTypeName(v TypeName) {
	o.TypeName = v
}

// GetGenericTypes returns the GenericTypes field value if set, zero value otherwise.
func (o *ConditionParamTypeRef) GetGenericTypes() []ConditionParamTypeRef {
	if o == nil || o.GenericTypes == nil {
		var ret []ConditionParamTypeRef
		return ret
	}
	return *o.GenericTypes
}

// GetGenericTypesOk returns a tuple with the GenericTypes field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ConditionParamTypeRef) GetGenericTypesOk() (*[]ConditionParamTypeRef, bool) {
	if o == nil || o.GenericTypes == nil {
		return nil, false
	}
	return o.GenericTypes, true
}

// HasGenericTypes returns a boolean if a field has been set.
func (o *ConditionParamTypeRef) HasGenericTypes() bool {
	if o != nil && o.GenericTypes != nil {
		return true
	}

	return false
}

// SetGenericTypes gets a reference to the given []ConditionParamTypeRef and assigns it to the GenericTypes field.
func (o *ConditionParamTypeRef) SetGenericTypes(v []ConditionParamTypeRef) {
	o.GenericTypes = &v
}

func (o ConditionParamTypeRef) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["type_name"] = o.TypeName
	if o.GenericTypes != nil {
		toSerialize["generic_types"] = o.GenericTypes
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableConditionParamTypeRef struct {
	value *ConditionParamTypeRef
	isSet bool
}

func (v NullableConditionParamTypeRef) Get() *ConditionParamTypeRef {
	return v.value
}

func (v *NullableConditionParamTypeRef) Set(val *ConditionParamTypeRef) {
	v.value = val
	v.isSet = true
}

func (v NullableConditionParamTypeRef) IsSet() bool {
	return v.isSet
}

func (v *NullableConditionParamTypeRef) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableConditionParamTypeRef(val *ConditionParamTypeRef) *NullableConditionParamTypeRef {
	return &NullableConditionParamTypeRef{value: val, isSet: true}
}

func (v NullableConditionParamTypeRef) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableConditionParamTypeRef) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
