/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// WriteAuthorizationModelRequest struct for WriteAuthorizationModelRequest
type WriteAuthorizationModelRequest struct {
	TypeDefinitions []TypeDefinition      `json:"type_definitions"yaml:"type_definitions"`
	SchemaVersion   string                `json:"schema_version"yaml:"schema_version"`
	Conditions      *map[string]Condition `json:"conditions,omitempty"yaml:"conditions,omitempty"`
}

// NewWriteAuthorizationModelRequest instantiates a new WriteAuthorizationModelRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewWriteAuthorizationModelRequest(typeDefinitions []TypeDefinition, schemaVersion string) *WriteAuthorizationModelRequest {
	this := WriteAuthorizationModelRequest{}
	this.TypeDefinitions = typeDefinitions
	this.SchemaVersion = schemaVersion
	return &this
}

// NewWriteAuthorizationModelRequestWithDefaults instantiates a new WriteAuthorizationModelRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewWriteAuthorizationModelRequestWithDefaults() *WriteAuthorizationModelRequest {
	this := WriteAuthorizationModelRequest{}
	return &this
}

// GetTypeDefinitions returns the TypeDefinitions field value
func (o *WriteAuthorizationModelRequest) GetTypeDefinitions() []TypeDefinition {
	if o == nil {
		var ret []TypeDefinition
		return ret
	}

	return o.TypeDefinitions
}

// GetTypeDefinitionsOk returns a tuple with the TypeDefinitions field value
// and a boolean to check if the value has been set.
func (o *WriteAuthorizationModelRequest) GetTypeDefinitionsOk() (*[]TypeDefinition, bool) {
	if o == nil {
		return nil, false
	}
	return &o.TypeDefinitions, true
}

// SetTypeDefinitions sets field value
func (o *WriteAuthorizationModelRequest) SetTypeDefinitions(v []TypeDefinition) {
	o.TypeDefinitions = v
}

// GetSchemaVersion returns the SchemaVersion field value
func (o *WriteAuthorizationModelRequest) GetSchemaVersion() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.SchemaVersion
}

// GetSchemaVersionOk returns a tuple with the SchemaVersion field value
// and a boolean to check if the value has been set.
func (o *WriteAuthorizationModelRequest) GetSchemaVersionOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.SchemaVersion, true
}

// SetSchemaVersion sets field value
func (o *WriteAuthorizationModelRequest) SetSchemaVersion(v string) {
	o.SchemaVersion = v
}

// GetConditions returns the Conditions field value if set, zero value otherwise.
func (o *WriteAuthorizationModelRequest) GetConditions() map[string]Condition {
	if o == nil || o.Conditions == nil {
		var ret map[string]Condition
		return ret
	}
	return *o.Conditions
}

// GetConditionsOk returns a tuple with the Conditions field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *WriteAuthorizationModelRequest) GetConditionsOk() (*map[string]Condition, bool) {
	if o == nil || o.Conditions == nil {
		return nil, false
	}
	return o.Conditions, true
}

// HasConditions returns a boolean if a field has been set.
func (o *WriteAuthorizationModelRequest) HasConditions() bool {
	if o != nil && o.Conditions != nil {
		return true
	}

	return false
}

// SetConditions gets a reference to the given map[string]Condition and assigns it to the Conditions field.
func (o *WriteAuthorizationModelRequest) SetConditions(v map[string]Condition) {
	o.Conditions = &v
}

func (o WriteAuthorizationModelRequest) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["type_definitions"] = o.TypeDefinitions
	toSerialize["schema_version"] = o.SchemaVersion
	if o.Conditions != nil {
		toSerialize["conditions"] = o.Conditions
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableWriteAuthorizationModelRequest struct {
	value *WriteAuthorizationModelRequest
	isSet bool
}

func (v NullableWriteAuthorizationModelRequest) Get() *WriteAuthorizationModelRequest {
	return v.value
}

func (v *NullableWriteAuthorizationModelRequest) Set(val *WriteAuthorizationModelRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableWriteAuthorizationModelRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableWriteAuthorizationModelRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableWriteAuthorizationModelRequest(val *WriteAuthorizationModelRequest) *NullableWriteAuthorizationModelRequest {
	return &NullableWriteAuthorizationModelRequest{value: val, isSet: true}
}

func (v NullableWriteAuthorizationModelRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableWriteAuthorizationModelRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
