/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"bytes"

	"encoding/json"
)

// ConditionMetadata struct for ConditionMetadata
type ConditionMetadata struct {
	Module     *string     `json:"module,omitempty"yaml:"module,omitempty"`
	SourceInfo *SourceInfo `json:"source_info,omitempty"yaml:"source_info,omitempty"`
}

// NewConditionMetadata instantiates a new ConditionMetadata object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewConditionMetadata() *ConditionMetadata {
	this := ConditionMetadata{}
	return &this
}

// NewConditionMetadataWithDefaults instantiates a new ConditionMetadata object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewConditionMetadataWithDefaults() *ConditionMetadata {
	this := ConditionMetadata{}
	return &this
}

// GetModule returns the Module field value if set, zero value otherwise.
func (o *ConditionMetadata) GetModule() string {
	if o == nil || o.Module == nil {
		var ret string
		return ret
	}
	return *o.Module
}

// GetModuleOk returns a tuple with the Module field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ConditionMetadata) GetModuleOk() (*string, bool) {
	if o == nil || o.Module == nil {
		return nil, false
	}
	return o.Module, true
}

// HasModule returns a boolean if a field has been set.
func (o *ConditionMetadata) HasModule() bool {
	if o != nil && o.Module != nil {
		return true
	}

	return false
}

// SetModule gets a reference to the given string and assigns it to the Module field.
func (o *ConditionMetadata) SetModule(v string) {
	o.Module = &v
}

// GetSourceInfo returns the SourceInfo field value if set, zero value otherwise.
func (o *ConditionMetadata) GetSourceInfo() SourceInfo {
	if o == nil || o.SourceInfo == nil {
		var ret SourceInfo
		return ret
	}
	return *o.SourceInfo
}

// GetSourceInfoOk returns a tuple with the SourceInfo field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *ConditionMetadata) GetSourceInfoOk() (*SourceInfo, bool) {
	if o == nil || o.SourceInfo == nil {
		return nil, false
	}
	return o.SourceInfo, true
}

// HasSourceInfo returns a boolean if a field has been set.
func (o *ConditionMetadata) HasSourceInfo() bool {
	if o != nil && o.SourceInfo != nil {
		return true
	}

	return false
}

// SetSourceInfo gets a reference to the given SourceInfo and assigns it to the SourceInfo field.
func (o *ConditionMetadata) SetSourceInfo(v SourceInfo) {
	o.SourceInfo = &v
}

func (o ConditionMetadata) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Module != nil {
		toSerialize["module"] = o.Module
	}
	if o.SourceInfo != nil {
		toSerialize["source_info"] = o.SourceInfo
	}
	var b bytes.Buffer
	enc := json.NewEncoder(&b)
	enc.SetEscapeHTML(false)
	err := enc.Encode(toSerialize)
	if err != nil {
		return nil, err
	}
	return b.Bytes(), nil
}

type NullableConditionMetadata struct {
	value *ConditionMetadata
	isSet bool
}

func (v NullableConditionMetadata) Get() *ConditionMetadata {
	return v.value
}

func (v *NullableConditionMetadata) Set(val *ConditionMetadata) {
	v.value = val
	v.isSet = true
}

func (v NullableConditionMetadata) IsSet() bool {
	return v.isSet
}

func (v *NullableConditionMetadata) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableConditionMetadata(val *ConditionMetadata) *NullableConditionMetadata {
	return &NullableConditionMetadata{value: val, isSet: true}
}

func (v NullableConditionMetadata) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableConditionMetadata) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
