/**
 * Go SDK for OpenFGA
 *
 * API version: 0.1
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://discord.gg/8naAwJfWN6
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package client

import (
	_context "context"
	"encoding/json"
	"fmt"
	"math"
	_nethttp "net/http"

	fgaSdk "github.com/openfga/go-sdk"
	"github.com/openfga/go-sdk/credentials"
	internalutils "github.com/openfga/go-sdk/internal/utils"
	"golang.org/x/sync/errgroup"
)

var (
	_ _context.Context
	// Ensure the SdkClient fits OpenFgaClient interface
	_ SdkClient = (*OpenFgaClient)(nil)
)

var DEFAULT_MAX_METHOD_PARALLEL_REQS = int32(10)

type ClientConfiguration struct {
	fgaSdk.Configuration
	// ApiScheme - defines the scheme for the API: http or https
	// Deprecated: use ApiUrl instead of ApiScheme and ApiHost
	ApiScheme string `json:"api_scheme"`
	// ApiHost - defines the host for the API without the scheme e.g. (api.fga.example)
	// Deprecated: use ApiUrl instead of ApiScheme and ApiHost
	ApiHost              string                   `json:"api_host"`
	ApiUrl               string                   `json:"api_url"`
	StoreId              string                   `json:"store_id"`
	AuthorizationModelId string                   `json:"authorization_model_id"`
	Credentials          *credentials.Credentials `json:"credentials"`
	DefaultHeaders       map[string]string        `json:"default_headers"`
	UserAgent            string                   `json:"user_agent"`
	Debug                bool                     `json:"debug"`
	HTTPClient           *_nethttp.Client
	RetryParams          *fgaSdk.RetryParams
}

func newClientConfiguration(cfg *fgaSdk.Configuration) ClientConfiguration {
	return ClientConfiguration{
		ApiScheme:      cfg.ApiScheme,
		ApiHost:        cfg.ApiHost,
		ApiUrl:         cfg.ApiUrl,
		StoreId:        cfg.StoreId,
		Credentials:    cfg.Credentials,
		DefaultHeaders: cfg.DefaultHeaders,
		UserAgent:      cfg.UserAgent,
		Debug:          cfg.Debug,
		RetryParams:    cfg.RetryParams,
	}
}

type OpenFgaClient struct {
	config ClientConfiguration
	SdkClient
	fgaSdk.APIClient
}

func NewSdkClient(cfg *ClientConfiguration) (*OpenFgaClient, error) {
	apiConfiguration, err := fgaSdk.NewConfiguration(fgaSdk.Configuration{
		ApiScheme:      cfg.ApiScheme,
		ApiHost:        cfg.ApiHost,
		ApiUrl:         cfg.ApiUrl,
		StoreId:        cfg.StoreId,
		Credentials:    cfg.Credentials,
		DefaultHeaders: cfg.DefaultHeaders,
		UserAgent:      cfg.UserAgent,
		Debug:          cfg.Debug,
		RetryParams:    cfg.RetryParams,
	})

	if err != nil {
		return nil, err
	}

	clientConfig := newClientConfiguration(apiConfiguration)
	clientConfig.AuthorizationModelId = cfg.AuthorizationModelId

	// store id is already validate as part of configuration validation

	if cfg.AuthorizationModelId != "" && !internalutils.IsWellFormedUlidString(cfg.AuthorizationModelId) {
		return nil, FgaInvalidError{param: "AuthorizationModelId", description: "ULID"}
	}

	apiClient := fgaSdk.NewAPIClient(apiConfiguration)

	return &OpenFgaClient{
		config:    clientConfig,
		APIClient: *apiClient,
	}, nil
}

type ClientRequestOptions struct {
	MaxRetry    *int `json:"max_retry,omitempty"`
	MinWaitInMs *int `json:"min_wait_in_ms,omitempty"`
}

type AuthorizationModelIdOptions struct {
	AuthorizationModelId *string `json:"authorization_model_id,omitempty"`
}

type ClientRequestOptionsWithAuthZModelId struct {
	ClientRequestOptions
	AuthorizationModelIdOptions
}

type ClientTupleKey = fgaSdk.TupleKey
type ClientTupleKeyWithoutCondition = fgaSdk.TupleKeyWithoutCondition
type ClientCheckRequestTupleKey = fgaSdk.CheckRequestTupleKey
type ClientReadRequestTupleKey = fgaSdk.ReadRequestTupleKey
type ClientExpandRequestTupleKey = fgaSdk.ExpandRequestTupleKey
type ClientContextualTupleKey = ClientTupleKey

type ClientPaginationOptions struct {
	PageSize          *int32  `json:"page_size,omitempty"`
	ContinuationToken *string `json:"continuation_token,omitempty"`
}

func getPageSizeFromRequest(options *ClientPaginationOptions) *int32 {
	if options == nil {
		return nil
	}
	return options.PageSize
}
func getContinuationTokenFromRequest(options *ClientPaginationOptions) *string {
	if options == nil {
		return nil
	}
	return options.ContinuationToken
}

type SdkClient interface {
	/* Stores */

	/*
	 * ListStores Get a paginated list of stores.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientListStoresRequestInterface
	 */
	ListStores(ctx _context.Context) SdkClientListStoresRequestInterface

	/*
	 * ListStoresExecute executes the ListStores request
	 * @return *ClientListStoresResponse
	 */
	ListStoresExecute(request SdkClientListStoresRequestInterface) (*ClientListStoresResponse, error)

	/*
	 * CreateStore Create and initialize a store
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientCreateStoreRequestInterface
	 */
	CreateStore(ctx _context.Context) SdkClientCreateStoreRequestInterface

	/*
	 * CreateStoreExecute executes the CreateStore request
	 * @return *ClientCreateStoreResponse
	 */
	CreateStoreExecute(request SdkClientCreateStoreRequestInterface) (*ClientCreateStoreResponse, error)

	/*
	 * GetStore Get information about the current store.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientGetStoreRequestInterface
	 */
	GetStore(ctx _context.Context) SdkClientGetStoreRequestInterface

	/*
	 * GetStoreExecute executes the GetStore request
	 * @return *ClientGetStoreResponse
	 */
	GetStoreExecute(request SdkClientGetStoreRequestInterface) (*ClientGetStoreResponse, error)

	/*
	 * DeleteStore Delete a store.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientDeleteStoreRequestInterface
	 */
	DeleteStore(ctx _context.Context) SdkClientDeleteStoreRequestInterface

	/*
	 * DeleteStoreExecute executes the DeleteStore request
	 * @return *ClientDeleteStoreResponse
	 */
	DeleteStoreExecute(request SdkClientDeleteStoreRequestInterface) (*ClientDeleteStoreResponse, error)

	/* Authorization Models */

	/*
	 * ReadAuthorizationModels Read all authorization models in the store.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientReadAuthorizationModelsRequest
	 */
	ReadAuthorizationModels(ctx _context.Context) SdkClientReadAuthorizationModelsRequestInterface

	/*
	 * ReadAuthorizationModelsExecute executes the ReadAuthorizationModels request
	 * @return *ClientReadAuthorizationModelsResponse
	 */
	ReadAuthorizationModelsExecute(request SdkClientReadAuthorizationModelsRequestInterface) (*ClientReadAuthorizationModelsResponse, error)

	/*
	 * WriteAuthorizationModel Create a new authorization model.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientWriteAuthorizationModelRequest
	 */
	WriteAuthorizationModel(ctx _context.Context) SdkClientWriteAuthorizationModelRequestInterface

	/*
	 * WriteAuthorizationModelExecute executes the WriteAuthorizationModel request
	 * @return *ClientWriteAuthorizationModelResponse
	 */
	WriteAuthorizationModelExecute(request SdkClientWriteAuthorizationModelRequestInterface) (*ClientWriteAuthorizationModelResponse, error)

	/*
	 * ReadAuthorizationModel Read a particular authorization model.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientReadAuthorizationModelRequestInterface
	 */
	ReadAuthorizationModel(ctx _context.Context) SdkClientReadAuthorizationModelRequestInterface

	/*
	 * ReadAuthorizationModelExecute executes the ReadAuthorizationModel request
	 * @return *ClientReadAuthorizationModelResponse
	 */
	ReadAuthorizationModelExecute(request SdkClientReadAuthorizationModelRequestInterface) (*ClientReadAuthorizationModelResponse, error)

	/*
	 * ReadLatestAuthorizationModel Reads the latest authorization model (note: this ignores the model id in configuration).
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientReadLatestAuthorizationModelRequestInterface
	 */
	ReadLatestAuthorizationModel(ctx _context.Context) SdkClientReadLatestAuthorizationModelRequestInterface

	/*
	 * ReadLatestAuthorizationModelExecute executes the ReadLatestAuthorizationModel request
	 * @return *ClientReadAuthorizationModelResponse
	 */
	ReadLatestAuthorizationModelExecute(request SdkClientReadLatestAuthorizationModelRequestInterface) (*ClientReadAuthorizationModelResponse, error)

	/* Relationship Tuples */

	/*
	 * ReadChanges Reads the list of historical relationship tuple writes and deletes.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientReadChangesRequestInterface
	 */
	ReadChanges(ctx _context.Context) SdkClientReadChangesRequestInterface

	/*
	 * ReadChangesExecute executes the ReadChanges request
	 * @return *ClientReadChangesResponse
	 */
	ReadChangesExecute(request SdkClientReadChangesRequestInterface) (*ClientReadChangesResponse, error)

	/*
	 * Read Reads the relationship tuples stored in the database. It does not evaluate nor exclude invalid tuples according to the authorization model.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientReadRequestInterface
	 */
	Read(ctx _context.Context) SdkClientReadRequestInterface

	/*
	 * ReadExecute executes the Read request
	 * @return *ClientReadResponse
	 */
	ReadExecute(request SdkClientReadRequestInterface) (*ClientReadResponse, error)

	/*
	 * Write Create and/or delete relationship tuples to update the system state.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientWriteRequestInterface
	 */
	Write(ctx _context.Context) SdkClientWriteRequestInterface

	/*
	 * WriteExecute executes the Write request
	 * @return *ClientWriteResponse
	 */
	WriteExecute(request SdkClientWriteRequestInterface) (*ClientWriteResponse, error)

	/*
	 * WriteTuples Utility method around Write
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientWriteTuplesRequestInterface
	 */
	WriteTuples(ctx _context.Context) SdkClientWriteTuplesRequestInterface

	/*
	 * WriteTuplesExecute executes the WriteTuples request
	 * @return *ClientWriteResponse
	 */
	WriteTuplesExecute(request SdkClientWriteTuplesRequestInterface) (*ClientWriteResponse, error)

	/*
	 * DeleteTuples Utility method around Write
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientDeleteTuplesRequestInterface
	 */
	DeleteTuples(ctx _context.Context) SdkClientDeleteTuplesRequestInterface

	/*
	 * DeleteTuplesExecute executes the DeleteTuples request
	 * @return *ClientWriteResponse
	 */
	DeleteTuplesExecute(request SdkClientDeleteTuplesRequestInterface) (*ClientWriteResponse, error)

	/* Relationship Queries */

	/*
	 * Check Check if a user has a particular relation with an object.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientCheckRequestInterface
	 */
	Check(ctx _context.Context) SdkClientCheckRequestInterface

	/*
	 * CheckExecute executes the Check request
	 * @return *ClientCheckResponse
	 */
	CheckExecute(request SdkClientCheckRequestInterface) (*ClientCheckResponse, error)

	/*
	 * BatchCheck Run a set of [checks](#check). Batch Check will return `allowed: false` if it encounters an error, and will return the error in the body.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientBatchCheckRequestInterface
	 */
	BatchCheck(ctx _context.Context) SdkClientBatchCheckRequestInterface

	/*
	 * BatchCheckExecute executes the BatchCheck request
	 * @return *ClientBatchCheckResponse
	 */
	BatchCheckExecute(request SdkClientBatchCheckRequestInterface) (*ClientBatchCheckResponse, error)

	/*
	 * Expand Expands the relationships in userset tree format.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientExpandRequestInterface
	 */
	Expand(ctx _context.Context) SdkClientExpandRequestInterface

	/*
	 * ExpandExecute executes the Expand request
	 * @return *ClientExpandResponse
	 */
	ExpandExecute(request SdkClientExpandRequestInterface) (*ClientExpandResponse, error)

	/*
	 * ListObjects List the objects of a particular type a user has access to.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientListObjectsRequestInterface
	 */
	ListObjects(ctx _context.Context) SdkClientListObjectsRequestInterface

	/*
	 * ListObjectsExecute executes the ListObjects request
	 * @return *ClientListObjectsResponse
	 */
	ListObjectsExecute(request SdkClientListObjectsRequestInterface) (*ClientListObjectsResponse, error)

	/*
	 * ListRelations List the relations a user has on an object.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientListRelationsRequestInterface
	 */
	ListRelations(ctx _context.Context) SdkClientListRelationsRequestInterface

	/*
	 * ListRelationsExecute executes the ListRelations request
	 * @return *ClientListRelationsResponse
	 */
	ListRelationsExecute(request SdkClientListRelationsRequestInterface) (*ClientListRelationsResponse, error)

	/* Assertions */

	/*
	 * ReadAssertions Read assertions for a particular authorization model.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientReadAssertionsRequestInterface
	 */
	ReadAssertions(ctx _context.Context) SdkClientReadAssertionsRequestInterface

	/*
	 * ReadAssertionsExecute executes the ReadAssertions request
	 * @return *ClientReadAssertionsResponse
	 */
	ReadAssertionsExecute(request SdkClientReadAssertionsRequestInterface) (*ClientReadAssertionsResponse, error)

	/*
	 * WriteAssertions Update the assertions for a particular authorization model.
	 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
	 * @return SdkClientWriteAssertionsRequestInterface
	 */
	WriteAssertions(ctx _context.Context) SdkClientWriteAssertionsRequestInterface

	/*
	 * WriteAssertionsExecute executes the WriteAssertions request
	 * @return *ClientWriteAssertionsResponse
	 */
	WriteAssertionsExecute(request SdkClientWriteAssertionsRequestInterface) (*ClientWriteAssertionsResponse, error)
}

func (client *OpenFgaClient) SetAuthorizationModelId(authorizationModelId string) error {
	if authorizationModelId != "" && !internalutils.IsWellFormedUlidString(authorizationModelId) {
		return FgaInvalidError{param: "AuthorizationModelId", description: "ULID"}
	}

	client.config.AuthorizationModelId = authorizationModelId

	return nil
}

func (client *OpenFgaClient) GetAuthorizationModelId() (string, error) {
	modelId := client.config.AuthorizationModelId
	if modelId != "" && !internalutils.IsWellFormedUlidString(modelId) {
		return "", FgaInvalidError{param: "AuthorizationModelId", description: "ULID"}
	}

	return modelId, nil
}

func (client *OpenFgaClient) getAuthorizationModelId(authorizationModelId *string) (*string, error) {
	modelId := client.config.AuthorizationModelId
	if authorizationModelId != nil && *authorizationModelId != "" {
		modelId = *authorizationModelId
	}

	if modelId != "" && !internalutils.IsWellFormedUlidString(modelId) {
		return nil, FgaInvalidError{param: "AuthorizationModelId", description: "ULID"}
	}
	return &modelId, nil
}

// helper function to validate the connection (i.e., get token)
func (client *OpenFgaClient) checkValidApiConnection(ctx _context.Context, authorizationModelId *string) error {
	if authorizationModelId != nil && *authorizationModelId != "" {
		_, _, err := client.OpenFgaApi.ReadAuthorizationModel(ctx, *authorizationModelId).Execute()
		return err
	} else {
		_, err := client.ReadAuthorizationModels(ctx).Options(ClientReadAuthorizationModelsOptions{
			PageSize: fgaSdk.PtrInt32(1),
		}).Execute()
		return err
	}
}

/* Stores */

// / ListStores
type SdkClientListStoresRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	options *ClientListStoresOptions
}

type SdkClientListStoresRequestInterface interface {
	Options(options ClientListStoresOptions) SdkClientListStoresRequestInterface
	Execute() (*ClientListStoresResponse, error)
	GetContext() _context.Context
	GetOptions() *ClientListStoresOptions
}

type ClientListStoresOptions struct {
	PageSize          *int32  `json:"page_size,omitempty"`
	ContinuationToken *string `json:"continuation_token,omitempty"`
}

type ClientListStoresResponse = fgaSdk.ListStoresResponse

func (request *SdkClientListStoresRequest) Options(options ClientListStoresOptions) SdkClientListStoresRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientListStoresRequest) Execute() (*ClientListStoresResponse, error) {
	return request.Client.ListStoresExecute(request)
}

func (request *SdkClientListStoresRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientListStoresRequest) GetOptions() *ClientListStoresOptions {
	return request.options
}

func (client *OpenFgaClient) ListStoresExecute(request SdkClientListStoresRequestInterface) (*ClientListStoresResponse, error) {
	req := client.OpenFgaApi.ListStores(request.GetContext())
	pageSize := getPageSizeFromRequest((*ClientPaginationOptions)(request.GetOptions()))
	if pageSize != nil {
		req = req.PageSize(*pageSize)
	}
	continuationToken := getContinuationTokenFromRequest((*ClientPaginationOptions)(request.GetOptions()))
	if continuationToken != nil {
		req = req.ContinuationToken(*continuationToken)
	}
	data, _, err := req.Execute()
	if err != nil {
		return nil, err
	}
	return &data, nil
}

func (client *OpenFgaClient) ListStores(ctx _context.Context) SdkClientListStoresRequestInterface {
	return &SdkClientListStoresRequest{
		ctx:    ctx,
		Client: client,
	}
}

// / CreateStore
type SdkClientCreateStoreRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientCreateStoreRequest
	options *ClientCreateStoreOptions
}

type SdkClientCreateStoreRequestInterface interface {
	Options(options ClientCreateStoreOptions) SdkClientCreateStoreRequestInterface
	Body(body ClientCreateStoreRequest) SdkClientCreateStoreRequestInterface
	Execute() (*ClientCreateStoreResponse, error)

	GetContext() _context.Context
	GetOptions() *ClientCreateStoreOptions
	GetBody() *ClientCreateStoreRequest
}

type ClientCreateStoreRequest struct {
	Name string `json:"name"`
}

type ClientCreateStoreOptions struct {
}

type ClientCreateStoreResponse = fgaSdk.CreateStoreResponse

func (request *SdkClientCreateStoreRequest) Options(options ClientCreateStoreOptions) SdkClientCreateStoreRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientCreateStoreRequest) Body(body ClientCreateStoreRequest) SdkClientCreateStoreRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientCreateStoreRequest) Execute() (*ClientCreateStoreResponse, error) {
	return request.Client.CreateStoreExecute(request)
}

func (request *SdkClientCreateStoreRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientCreateStoreRequest) GetOptions() *ClientCreateStoreOptions {
	return request.options
}

func (request *SdkClientCreateStoreRequest) GetBody() *ClientCreateStoreRequest {
	return request.body
}

func (client *OpenFgaClient) CreateStoreExecute(request SdkClientCreateStoreRequestInterface) (*ClientCreateStoreResponse, error) {
	data, _, err := client.OpenFgaApi.CreateStore(request.GetContext()).Body(fgaSdk.CreateStoreRequest{
		Name: request.GetBody().Name,
	}).Execute()
	if err != nil {
		return nil, err
	}
	return &data, nil
}

func (client *OpenFgaClient) CreateStore(ctx _context.Context) SdkClientCreateStoreRequestInterface {
	return &SdkClientCreateStoreRequest{
		Client: client,
		ctx:    ctx,
	}
}

// / GetStore
type SdkClientGetStoreRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	options *ClientGetStoreOptions
}

type SdkClientGetStoreRequestInterface interface {
	Options(options ClientGetStoreOptions) SdkClientGetStoreRequestInterface
	Execute() (*ClientGetStoreResponse, error)

	GetContext() _context.Context
	GetOptions() *ClientGetStoreOptions
}

type ClientGetStoreOptions struct {
}

type ClientGetStoreResponse = fgaSdk.GetStoreResponse

func (request *SdkClientGetStoreRequest) Options(options ClientGetStoreOptions) SdkClientGetStoreRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientGetStoreRequest) Execute() (*ClientGetStoreResponse, error) {
	return request.Client.GetStoreExecute(request)
}

func (request *SdkClientGetStoreRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientGetStoreRequest) GetOptions() *ClientGetStoreOptions {
	return request.options
}

func (client *OpenFgaClient) GetStoreExecute(request SdkClientGetStoreRequestInterface) (*ClientGetStoreResponse, error) {
	data, _, err := client.OpenFgaApi.GetStore(request.GetContext()).Execute()
	if err != nil {
		return nil, err
	}
	return &data, nil
}

func (client *OpenFgaClient) GetStore(ctx _context.Context) SdkClientGetStoreRequestInterface {
	return &SdkClientGetStoreRequest{
		Client: client,
		ctx:    ctx,
	}
}

// / DeleteStore
type SdkClientDeleteStoreRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	options *ClientDeleteStoreOptions
}

type SdkClientDeleteStoreRequestInterface interface {
	Options(options ClientDeleteStoreOptions) SdkClientDeleteStoreRequestInterface
	Execute() (*ClientDeleteStoreResponse, error)

	GetContext() _context.Context
	GetOptions() *ClientDeleteStoreOptions
}

type ClientDeleteStoreOptions struct {
}

type ClientDeleteStoreResponse struct{}

func (request *SdkClientDeleteStoreRequest) Options(options ClientDeleteStoreOptions) SdkClientDeleteStoreRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientDeleteStoreRequest) Execute() (*ClientDeleteStoreResponse, error) {
	return request.Client.DeleteStoreExecute(request)
}

func (request *SdkClientDeleteStoreRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientDeleteStoreRequest) GetOptions() *ClientDeleteStoreOptions {
	return request.options
}

func (client *OpenFgaClient) DeleteStoreExecute(request SdkClientDeleteStoreRequestInterface) (*ClientDeleteStoreResponse, error) {
	_, err := client.OpenFgaApi.DeleteStore(request.GetContext()).Execute()
	if err != nil {
		return nil, err
	}
	return &ClientDeleteStoreResponse{}, nil
}

func (client *OpenFgaClient) DeleteStore(ctx _context.Context) SdkClientDeleteStoreRequestInterface {
	return &SdkClientDeleteStoreRequest{
		Client: client,
		ctx:    ctx,
	}
}

/* Authorization Models */

// / ReadAuthorizationModels
type SdkClientReadAuthorizationModelsRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	options *ClientReadAuthorizationModelsOptions
}

type SdkClientReadAuthorizationModelsRequestInterface interface {
	Options(options ClientReadAuthorizationModelsOptions) SdkClientReadAuthorizationModelsRequestInterface
	Execute() (*ClientReadAuthorizationModelsResponse, error)

	GetContext() _context.Context
	GetOptions() *ClientReadAuthorizationModelsOptions
}

type ClientReadAuthorizationModelsOptions struct {
	PageSize          *int32  `json:"page_size,omitempty"`
	ContinuationToken *string `json:"continuation_token,omitempty"`
}

type ClientReadAuthorizationModelsResponse = fgaSdk.ReadAuthorizationModelsResponse

func (request *SdkClientReadAuthorizationModelsRequest) Options(options ClientReadAuthorizationModelsOptions) SdkClientReadAuthorizationModelsRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientReadAuthorizationModelsRequest) Execute() (*ClientReadAuthorizationModelsResponse, error) {
	return request.Client.ReadAuthorizationModelsExecute(request)
}

func (request *SdkClientReadAuthorizationModelsRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientReadAuthorizationModelsRequest) GetOptions() *ClientReadAuthorizationModelsOptions {
	return request.options
}

func (client *OpenFgaClient) ReadAuthorizationModelsExecute(request SdkClientReadAuthorizationModelsRequestInterface) (*ClientReadAuthorizationModelsResponse, error) {
	req := client.OpenFgaApi.ReadAuthorizationModels(request.GetContext())
	pageSize := getPageSizeFromRequest((*ClientPaginationOptions)(request.GetOptions()))
	if pageSize != nil {
		req = req.PageSize(*pageSize)
	}
	continuationToken := getContinuationTokenFromRequest((*ClientPaginationOptions)(request.GetOptions()))
	if continuationToken != nil {
		req = req.ContinuationToken(*continuationToken)
	}
	data, _, err := req.Execute()
	if err != nil {
		return nil, err
	}
	return &data, nil
}

func (client *OpenFgaClient) ReadAuthorizationModels(ctx _context.Context) SdkClientReadAuthorizationModelsRequestInterface {
	return &SdkClientReadAuthorizationModelsRequest{
		Client: client,
		ctx:    ctx,
	}
}

// / WriteAuthorizationModel
type SdkClientWriteAuthorizationModelRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientWriteAuthorizationModelRequest
	options *ClientWriteAuthorizationModelOptions
}

type SdkClientWriteAuthorizationModelRequestInterface interface {
	Options(options ClientWriteAuthorizationModelOptions) SdkClientWriteAuthorizationModelRequestInterface
	Body(body ClientWriteAuthorizationModelRequest) SdkClientWriteAuthorizationModelRequestInterface
	Execute() (*ClientWriteAuthorizationModelResponse, error)

	GetBody() *ClientWriteAuthorizationModelRequest
	GetOptions() *ClientWriteAuthorizationModelOptions
	GetContext() _context.Context
}

type ClientWriteAuthorizationModelRequest = fgaSdk.WriteAuthorizationModelRequest

type ClientWriteAuthorizationModelOptions struct {
}

type ClientWriteAuthorizationModelResponse = fgaSdk.WriteAuthorizationModelResponse

func (request *SdkClientWriteAuthorizationModelRequest) Options(options ClientWriteAuthorizationModelOptions) SdkClientWriteAuthorizationModelRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientWriteAuthorizationModelRequest) Body(body ClientWriteAuthorizationModelRequest) SdkClientWriteAuthorizationModelRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientWriteAuthorizationModelRequest) Execute() (*ClientWriteAuthorizationModelResponse, error) {
	return request.Client.WriteAuthorizationModelExecute(request)
}

func (request *SdkClientWriteAuthorizationModelRequest) GetBody() *ClientWriteAuthorizationModelRequest {
	return request.body
}

func (request *SdkClientWriteAuthorizationModelRequest) GetOptions() *ClientWriteAuthorizationModelOptions {
	return request.options
}

func (request *SdkClientWriteAuthorizationModelRequest) GetContext() _context.Context {
	return request.ctx
}

func (client *OpenFgaClient) WriteAuthorizationModelExecute(request SdkClientWriteAuthorizationModelRequestInterface) (*ClientWriteAuthorizationModelResponse, error) {
	data, _, err := client.OpenFgaApi.WriteAuthorizationModel(request.GetContext()).Body(fgaSdk.WriteAuthorizationModelRequest{
		TypeDefinitions: request.GetBody().TypeDefinitions,
		SchemaVersion:   request.GetBody().SchemaVersion,
	}).Execute()
	if err != nil {
		return nil, err
	}
	return &data, nil
}

func (client *OpenFgaClient) WriteAuthorizationModel(ctx _context.Context) SdkClientWriteAuthorizationModelRequestInterface {
	return &SdkClientWriteAuthorizationModelRequest{
		Client: client,
		ctx:    ctx,
	}
}

// / ReadAuthorizationModel
type SdkClientReadAuthorizationModelRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientReadAuthorizationModelRequest
	options *ClientReadAuthorizationModelOptions
}

type SdkClientReadAuthorizationModelRequestInterface interface {
	Options(options ClientReadAuthorizationModelOptions) SdkClientReadAuthorizationModelRequestInterface
	Body(body ClientReadAuthorizationModelRequest) SdkClientReadAuthorizationModelRequestInterface
	Execute() (*ClientReadAuthorizationModelResponse, error)
	GetAuthorizationModelIdOverride() *string

	GetContext() _context.Context
	GetBody() *ClientReadAuthorizationModelRequest
	GetOptions() *ClientReadAuthorizationModelOptions
}

type ClientReadAuthorizationModelRequest struct {
}

type ClientReadAuthorizationModelOptions struct {
	AuthorizationModelId *string `json:"authorization_model_id,omitempty"`
}

type ClientReadAuthorizationModelResponse = fgaSdk.ReadAuthorizationModelResponse

func (request *SdkClientReadAuthorizationModelRequest) Options(options ClientReadAuthorizationModelOptions) SdkClientReadAuthorizationModelRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientReadAuthorizationModelRequest) GetAuthorizationModelIdOverride() *string {
	if request.options == nil {
		return nil
	}
	return request.options.AuthorizationModelId
}

func (request *SdkClientReadAuthorizationModelRequest) Body(body ClientReadAuthorizationModelRequest) SdkClientReadAuthorizationModelRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientReadAuthorizationModelRequest) Execute() (*ClientReadAuthorizationModelResponse, error) {
	return request.Client.ReadAuthorizationModelExecute(request)
}

func (request *SdkClientReadAuthorizationModelRequest) GetBody() *ClientReadAuthorizationModelRequest {
	return request.body
}

func (request *SdkClientReadAuthorizationModelRequest) GetOptions() *ClientReadAuthorizationModelOptions {
	return request.options
}

func (request *SdkClientReadAuthorizationModelRequest) GetContext() _context.Context {
	return request.ctx
}

func (client *OpenFgaClient) ReadAuthorizationModelExecute(request SdkClientReadAuthorizationModelRequestInterface) (*ClientReadAuthorizationModelResponse, error) {
	authorizationModelId, err := client.getAuthorizationModelId(request.GetAuthorizationModelIdOverride())
	if err != nil {
		return nil, err
	}
	if authorizationModelId == nil || *authorizationModelId == "" {
		return nil, FgaRequiredParamError{param: "AuthorizationModelId"}
	}
	data, _, err := client.OpenFgaApi.ReadAuthorizationModel(request.GetContext(), *authorizationModelId).Execute()

	if err != nil {
		return nil, err
	}
	return &data, nil
}

func (client *OpenFgaClient) ReadAuthorizationModel(ctx _context.Context) SdkClientReadAuthorizationModelRequestInterface {
	return &SdkClientReadAuthorizationModelRequest{
		Client: client,
		ctx:    ctx,
	}
}

// / ReadLatestAuthorizationModel
type SdkClientReadLatestAuthorizationModelRequest struct {
	ctx    _context.Context
	Client OpenFgaClient

	options *ClientReadLatestAuthorizationModelOptions
}

type SdkClientReadLatestAuthorizationModelRequestInterface interface {
	Options(options ClientReadLatestAuthorizationModelOptions) SdkClientReadLatestAuthorizationModelRequestInterface
	Execute() (*ClientReadAuthorizationModelResponse, error)

	GetContext() _context.Context
	GetOptions() *ClientReadLatestAuthorizationModelOptions
}

type ClientReadLatestAuthorizationModelOptions struct {
}

func (client *OpenFgaClient) ReadLatestAuthorizationModel(ctx _context.Context) SdkClientReadLatestAuthorizationModelRequestInterface {
	return &SdkClientReadLatestAuthorizationModelRequest{
		Client: *client,
		ctx:    ctx,
	}
}

func (request *SdkClientReadLatestAuthorizationModelRequest) Options(options ClientReadLatestAuthorizationModelOptions) SdkClientReadLatestAuthorizationModelRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientReadLatestAuthorizationModelRequest) Execute() (*ClientReadAuthorizationModelResponse, error) {
	return request.Client.ReadLatestAuthorizationModelExecute(request)
}

func (request *SdkClientReadLatestAuthorizationModelRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientReadLatestAuthorizationModelRequest) GetOptions() *ClientReadLatestAuthorizationModelOptions {
	return request.options
}

func (client *OpenFgaClient) ReadLatestAuthorizationModelExecute(request SdkClientReadLatestAuthorizationModelRequestInterface) (*ClientReadAuthorizationModelResponse, error) {
	response, err := client.ReadAuthorizationModels(request.GetContext()).Options(ClientReadAuthorizationModelsOptions{
		PageSize: fgaSdk.PtrInt32(1),
	}).Execute()
	if err != nil {
		return nil, err
	}

	var authorizationModel *fgaSdk.AuthorizationModel

	if len(response.AuthorizationModels) > 0 {
		authorizationModels := response.AuthorizationModels
		authorizationModel = &(authorizationModels)[0]
	}

	return &fgaSdk.ReadAuthorizationModelResponse{
		AuthorizationModel: authorizationModel,
	}, nil
}

/* Relationship Tuples */

// / ReadChanges
type SdkClientReadChangesRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientReadChangesRequest
	options *ClientReadChangesOptions
}

type SdkClientReadChangesRequestInterface interface {
	Options(options ClientReadChangesOptions) SdkClientReadChangesRequestInterface
	Body(body ClientReadChangesRequest) SdkClientReadChangesRequestInterface
	Execute() (*ClientReadChangesResponse, error)

	GetContext() _context.Context
	GetBody() *ClientReadChangesRequest
	GetOptions() *ClientReadChangesOptions
}

type ClientReadChangesRequest struct {
	Type string `json:"type,omitempty"`
}

type ClientReadChangesOptions struct {
	PageSize          *int32  `json:"page_size,omitempty"`
	ContinuationToken *string `json:"continuation_token,omitempty"`
}

type ClientReadChangesResponse = fgaSdk.ReadChangesResponse

func (client *OpenFgaClient) ReadChanges(ctx _context.Context) SdkClientReadChangesRequestInterface {
	return &SdkClientReadChangesRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientReadChangesRequest) Options(options ClientReadChangesOptions) SdkClientReadChangesRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientReadChangesRequest) Body(body ClientReadChangesRequest) SdkClientReadChangesRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientReadChangesRequest) Execute() (*ClientReadChangesResponse, error) {
	return request.Client.ReadChangesExecute(request)
}

func (request *SdkClientReadChangesRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientReadChangesRequest) GetBody() *ClientReadChangesRequest {
	return request.body
}

func (request *SdkClientReadChangesRequest) GetOptions() *ClientReadChangesOptions {
	return request.options
}

func (client *OpenFgaClient) ReadChangesExecute(request SdkClientReadChangesRequestInterface) (*ClientReadChangesResponse, error) {
	req := client.OpenFgaApi.ReadChanges(request.GetContext())
	pageSize := getPageSizeFromRequest((*ClientPaginationOptions)(request.GetOptions()))
	if pageSize != nil {
		req = req.PageSize(*pageSize)
	}
	continuationToken := getContinuationTokenFromRequest((*ClientPaginationOptions)(request.GetOptions()))
	if continuationToken != nil {
		req = req.ContinuationToken(*continuationToken)
	}
	requestBody := request.GetBody()
	if requestBody != nil {
		req = req.Type_(requestBody.Type)
	}

	data, _, err := req.Execute()
	if err != nil {
		return nil, err
	}
	return &data, nil
}

// / Read
type SdkClientReadRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientReadRequest
	options *ClientReadOptions
}

type SdkClientReadRequestInterface interface {
	Options(options ClientReadOptions) SdkClientReadRequestInterface
	Body(body ClientReadRequest) SdkClientReadRequestInterface
	Execute() (*ClientReadResponse, error)

	GetContext() _context.Context
	GetBody() *ClientReadRequest
	GetOptions() *ClientReadOptions
}

type ClientReadRequest struct {
	User     *string `json:"user,omitempty"`
	Relation *string `json:"relation,omitempty"`
	Object   *string `json:"object,omitempty"`
}

type ClientReadOptions struct {
	PageSize          *int32  `json:"page_size,omitempty"`
	ContinuationToken *string `json:"continuation_token,omitempty"`
}

type ClientReadResponse = fgaSdk.ReadResponse

func (client *OpenFgaClient) Read(ctx _context.Context) SdkClientReadRequestInterface {
	return &SdkClientReadRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientReadRequest) Options(options ClientReadOptions) SdkClientReadRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientReadRequest) Body(body ClientReadRequest) SdkClientReadRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientReadRequest) Execute() (*ClientReadResponse, error) {
	return request.Client.ReadExecute(request)
}

func (request *SdkClientReadRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientReadRequest) GetBody() *ClientReadRequest {
	return request.body
}

func (request *SdkClientReadRequest) GetOptions() *ClientReadOptions {
	return request.options
}

func (client *OpenFgaClient) ReadExecute(request SdkClientReadRequestInterface) (*ClientReadResponse, error) {
	body := fgaSdk.ReadRequest{
		PageSize:          getPageSizeFromRequest((*ClientPaginationOptions)(request.GetOptions())),
		ContinuationToken: getContinuationTokenFromRequest((*ClientPaginationOptions)(request.GetOptions())),
	}
	if request.GetBody() != nil && (request.GetBody().User != nil || request.GetBody().Relation != nil || request.GetBody().Object != nil) {
		body.TupleKey = &fgaSdk.ReadRequestTupleKey{
			User:     request.GetBody().User,
			Relation: request.GetBody().Relation,
			Object:   request.GetBody().Object,
		}
	}
	data, _, err := client.OpenFgaApi.Read(request.GetContext()).Body(body).Execute()
	if err != nil {
		return nil, err
	}
	return &data, nil
}

// / Write
type SdkClientWriteRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientWriteRequest
	options *ClientWriteOptions
}

type SdkClientWriteRequestInterface interface {
	Options(options ClientWriteOptions) SdkClientWriteRequestInterface
	Body(body ClientWriteRequest) SdkClientWriteRequestInterface
	Execute() (*ClientWriteResponse, error)
	GetAuthorizationModelIdOverride() *string

	GetContext() _context.Context
	GetOptions() *ClientWriteOptions
	GetBody() *ClientWriteRequest
}

type ClientWriteRequest struct {
	Writes  []ClientTupleKey
	Deletes []ClientTupleKeyWithoutCondition
}

type TransactionOptions struct {
	// If set to true will disable running in transaction mode (transaction mode means everything is sent in a single transaction to the server)
	Disable bool `json:"disable,omitempty"`
	// When transaction mode is disabled, the requests are chunked and sent separately and each chunk is a transaction (default = 1)
	MaxPerChunk int32 `json:"max_per_chunk,omitempty"`
	// Number of requests to issue in parallel
	MaxParallelRequests int32 `json:"max_parallel_requests,omitempty"`
}

type ClientWriteOptions struct {
	AuthorizationModelId *string             `json:"authorization_model_id,omitempty"`
	Transaction          *TransactionOptions `json:"transaction_options,omitempty"`
}

type ClientWriteStatus string

// List of ClientWriteStatus
const (
	SUCCESS ClientWriteStatus = "CLIENT_WRITE_STATUS_SUCCESS"
	FAILURE ClientWriteStatus = "CLIENT_WRITE_STATUS_FAILURE"
)

type ClientWriteRequestWriteResponse struct {
	TupleKey     ClientTupleKey     `json:"tuple_key,omitempty"`
	Status       ClientWriteStatus  `json:"status,omitempty"`
	HttpResponse *_nethttp.Response `json:"http_response,omitempty"`
	Error        error              `json:"error,omitempty"`
}

func (o ClientWriteRequestWriteResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["tuple_key"] = o.TupleKey
	toSerialize["status"] = o.Status
	if o.HttpResponse != nil {
		toSerialize["http_response"] = o.HttpResponse
	}
	if o.Error != nil {
		toSerialize["error"] = o.Error
	}
	return json.Marshal(toSerialize)
}

type ClientWriteRequestDeleteResponse struct {
	TupleKey     ClientTupleKeyWithoutCondition `json:"tuple_key,omitempty"`
	Status       ClientWriteStatus              `json:"status,omitempty"`
	HttpResponse *_nethttp.Response             `json:"http_response,omitempty"`
	Error        error                          `json:"error,omitempty"`
}

func (o ClientWriteRequestDeleteResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["tuple_key"] = o.TupleKey
	toSerialize["status"] = o.Status
	if o.HttpResponse != nil {
		toSerialize["http_response"] = o.HttpResponse
	}
	if o.Error != nil {
		toSerialize["error"] = o.Error
	}
	return json.Marshal(toSerialize)
}

type ClientWriteResponse struct {
	Writes  []ClientWriteRequestWriteResponse  `json:"writes,omitempty"`
	Deletes []ClientWriteRequestDeleteResponse `json:"deletes,omitempty"`
}

func (o ClientWriteResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Writes != nil {
		toSerialize["writes"] = o.Writes
	}
	if o.Deletes != nil {
		toSerialize["deletes"] = o.Deletes
	}
	return json.Marshal(toSerialize)
}

func (client *OpenFgaClient) Write(ctx _context.Context) SdkClientWriteRequestInterface {
	return &SdkClientWriteRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientWriteRequest) Options(options ClientWriteOptions) SdkClientWriteRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientWriteRequest) GetAuthorizationModelIdOverride() *string {
	if request.options == nil {
		return nil
	}
	return request.options.AuthorizationModelId
}

func (request *SdkClientWriteRequest) Body(body ClientWriteRequest) SdkClientWriteRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientWriteRequest) Execute() (*ClientWriteResponse, error) {
	return request.Client.WriteExecute(request)
}

func (request *SdkClientWriteRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientWriteRequest) GetOptions() *ClientWriteOptions {
	return request.options
}

func (request *SdkClientWriteRequest) GetBody() *ClientWriteRequest {
	return request.body
}

func (client *OpenFgaClient) WriteExecute(request SdkClientWriteRequestInterface) (*ClientWriteResponse, error) {
	var maxPerChunk = int32(1) // 1 has to be the default otherwise the chunks will be sent in transactions
	if request.GetOptions() != nil && request.GetOptions().Transaction != nil {
		maxPerChunk = request.GetOptions().Transaction.MaxPerChunk
	}
	var maxParallelReqs = DEFAULT_MAX_METHOD_PARALLEL_REQS
	if request.GetOptions() != nil && request.GetOptions().Transaction != nil {
		maxParallelReqs = request.GetOptions().Transaction.MaxParallelRequests
	}

	response := ClientWriteResponse{
		Writes:  []ClientWriteRequestWriteResponse{},
		Deletes: []ClientWriteRequestDeleteResponse{},
	}

	authorizationModelId, err := client.getAuthorizationModelId(request.GetAuthorizationModelIdOverride())
	if err != nil {
		return nil, err
	}

	// Unless explicitly disabled, transaction mode is enabled
	// In transaction mode, the client will send the request to the server as is
	if request.GetOptions() == nil || request.GetOptions().Transaction == nil || !request.GetOptions().Transaction.Disable {
		writeRequest := fgaSdk.WriteRequest{
			AuthorizationModelId: authorizationModelId,
		}
		if request.GetBody().Writes != nil && len(request.GetBody().Writes) > 0 {
			writes := fgaSdk.WriteRequestWrites{}
			for index := 0; index < len(request.GetBody().Writes); index++ {
				writes.TupleKeys = append(writes.TupleKeys, (request.GetBody().Writes)[index])
			}
			writeRequest.Writes = &writes
		}
		if request.GetBody().Deletes != nil && len(request.GetBody().Deletes) > 0 {
			deletes := fgaSdk.WriteRequestDeletes{}
			for index := 0; index < len(request.GetBody().Deletes); index++ {
				deletes.TupleKeys = append(deletes.TupleKeys, (request.GetBody().Deletes)[index])
			}
			writeRequest.Deletes = &deletes
		}
		_, httpResponse, err := client.OpenFgaApi.Write(request.GetContext()).Body(writeRequest).Execute()

		clientWriteStatus := SUCCESS
		if err != nil {
			clientWriteStatus = FAILURE
		}

		if request.GetBody() != nil && request.GetBody().Writes != nil {
			writeRequestTupleKeys := request.GetBody().Writes
			for index := 0; index < len(writeRequestTupleKeys); index++ {
				response.Writes = append(response.Writes, ClientWriteRequestWriteResponse{
					TupleKey:     writeRequestTupleKeys[index],
					HttpResponse: httpResponse,
					Status:       clientWriteStatus,
					Error:        err,
				})
			}
		}

		if request.GetBody() != nil && request.GetBody().Deletes != nil {
			deleteRequestTupleKeys := request.GetBody().Deletes
			for index := 0; index < len(deleteRequestTupleKeys); index++ {
				response.Deletes = append(response.Deletes, ClientWriteRequestDeleteResponse{
					TupleKey:     deleteRequestTupleKeys[index],
					HttpResponse: httpResponse,
					Status:       clientWriteStatus,
					Error:        err,
				})
			}
		}

		return &response, err
	}

	// If the transaction mode is disabled:
	// - the client will attempt to chunk the writes and deletes into multiple requests
	// - each request is a transaction
	// - the max items in each request are based on maxPerChunk (default=1)
	var writeChunkSize = int(maxPerChunk)
	var writeChunks [][]ClientTupleKey
	if request.GetBody() != nil {
		for i := 0; i < len(request.GetBody().Writes); i += writeChunkSize {
			end := int(math.Min(float64(i+writeChunkSize), float64(len(request.GetBody().Writes))))

			writeChunks = append(writeChunks, (request.GetBody().Writes)[i:end])
		}
	}

	writeGroup, ctx := errgroup.WithContext(request.GetContext())
	err = client.checkValidApiConnection(ctx, authorizationModelId)
	if err != nil {
		return nil, err
	}

	writeGroup.SetLimit(int(maxParallelReqs))
	writeResponses := make([]ClientWriteResponse, len(writeChunks))
	for index, writeBody := range writeChunks {
		index, writeBody := index, writeBody
		writeGroup.Go(func() error {
			singleResponse, _ := client.WriteExecute(&SdkClientWriteRequest{
				ctx:    ctx,
				Client: client,
				body: &ClientWriteRequest{
					Writes: writeBody,
				},
				options: &ClientWriteOptions{
					AuthorizationModelId: authorizationModelId,
				},
			})

			writeResponses[index] = *singleResponse

			return nil
		})
	}

	_ = writeGroup.Wait()

	var deleteChunkSize = int(maxPerChunk)
	var deleteChunks [][]ClientTupleKeyWithoutCondition
	if request.GetBody() != nil {
		for i := 0; i < len(request.GetBody().Deletes); i += deleteChunkSize {
			end := int(math.Min(float64(i+writeChunkSize), float64(len(request.GetBody().Deletes))))

			deleteChunks = append(deleteChunks, (request.GetBody().Deletes)[i:end])
		}
	}

	deleteGroup, ctx := errgroup.WithContext(request.GetContext())
	deleteGroup.SetLimit(int(maxParallelReqs))
	deleteResponses := make([]ClientWriteResponse, len(deleteChunks))
	for index, deleteBody := range deleteChunks {
		index, deleteBody := index, deleteBody
		deleteGroup.Go(func() error {
			singleResponse, _ := client.WriteExecute(&SdkClientWriteRequest{
				ctx:    ctx,
				Client: client,
				body: &ClientWriteRequest{
					Deletes: deleteBody,
				},
				options: &ClientWriteOptions{
					AuthorizationModelId: authorizationModelId,
				},
			})

			deleteResponses[index] = *singleResponse

			return nil
		})
	}

	_ = deleteGroup.Wait()

	for _, writeResponse := range writeResponses {
		for _, writeSingleResponse := range writeResponse.Writes {
			response.Writes = append(response.Writes, writeSingleResponse)
		}
	}

	for _, deleteResponse := range deleteResponses {
		for _, deleteSingleResponse := range deleteResponse.Deletes {
			response.Deletes = append(response.Deletes, deleteSingleResponse)
		}
	}

	return &response, nil
}

// / WriteTuples
type SdkClientWriteTuplesRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientWriteTuplesBody
	options *ClientWriteOptions
}

type SdkClientWriteTuplesRequestInterface interface {
	Options(options ClientWriteOptions) SdkClientWriteTuplesRequestInterface
	Body(body ClientWriteTuplesBody) SdkClientWriteTuplesRequestInterface
	Execute() (*ClientWriteResponse, error)

	GetContext() _context.Context
	GetBody() *ClientWriteTuplesBody
	GetOptions() *ClientWriteOptions
}

type ClientWriteTuplesBody = []ClientTupleKey

func (client *OpenFgaClient) WriteTuples(ctx _context.Context) SdkClientWriteTuplesRequestInterface {
	return &SdkClientWriteTuplesRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientWriteTuplesRequest) Options(options ClientWriteOptions) SdkClientWriteTuplesRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientWriteTuplesRequest) Body(body ClientWriteTuplesBody) SdkClientWriteTuplesRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientWriteTuplesRequest) Execute() (*ClientWriteResponse, error) {
	return request.Client.WriteTuplesExecute(request)
}

func (request *SdkClientWriteTuplesRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientWriteTuplesRequest) GetBody() *ClientWriteTuplesBody {
	return request.body
}

func (request *SdkClientWriteTuplesRequest) GetOptions() *ClientWriteOptions {
	return request.options
}

func (client *OpenFgaClient) WriteTuplesExecute(request SdkClientWriteTuplesRequestInterface) (*ClientWriteResponse, error) {
	baseReq := client.Write(request.GetContext()).Body(ClientWriteRequest{
		Writes: *request.GetBody(),
	})
	if request.GetOptions() != nil {
		baseReq = baseReq.Options(*request.GetOptions())
	}
	return baseReq.Execute()
}

// / DeleteTuples
type SdkClientDeleteTuplesRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientDeleteTuplesBody
	options *ClientWriteOptions
}

type SdkClientDeleteTuplesRequestInterface interface {
	Options(options ClientWriteOptions) SdkClientDeleteTuplesRequestInterface
	Body(body ClientDeleteTuplesBody) SdkClientDeleteTuplesRequestInterface
	Execute() (*ClientWriteResponse, error)

	GetContext() _context.Context
	GetBody() *ClientDeleteTuplesBody
	GetOptions() *ClientWriteOptions
}

type ClientDeleteTuplesBody = []ClientTupleKeyWithoutCondition

func (client *OpenFgaClient) DeleteTuples(ctx _context.Context) SdkClientDeleteTuplesRequestInterface {
	return &SdkClientDeleteTuplesRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientDeleteTuplesRequest) Options(options ClientWriteOptions) SdkClientDeleteTuplesRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientDeleteTuplesRequest) Body(body ClientDeleteTuplesBody) SdkClientDeleteTuplesRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientDeleteTuplesRequest) Execute() (*ClientWriteResponse, error) {
	return request.Client.DeleteTuplesExecute(request)
}

func (request *SdkClientDeleteTuplesRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientDeleteTuplesRequest) GetBody() *ClientDeleteTuplesBody {
	return request.body
}

func (request *SdkClientDeleteTuplesRequest) GetOptions() *ClientWriteOptions {
	return request.options
}

func (client *OpenFgaClient) DeleteTuplesExecute(request SdkClientDeleteTuplesRequestInterface) (*ClientWriteResponse, error) {
	baseReq := client.Write(request.GetContext()).Body(ClientWriteRequest{
		Deletes: *request.GetBody(),
	})
	if request.GetOptions() != nil {
		baseReq = baseReq.Options(*request.GetOptions())
	}
	return baseReq.Execute()
}

/* Relationship Queries */

/// Check

type SdkClientCheckRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientCheckRequest
	options *ClientCheckOptions
}

type SdkClientCheckRequestInterface interface {
	Options(options ClientCheckOptions) SdkClientCheckRequestInterface
	Body(body ClientCheckRequest) SdkClientCheckRequestInterface
	Execute() (*ClientCheckResponse, error)
	GetAuthorizationModelIdOverride() *string

	GetContext() _context.Context
	GetBody() *ClientCheckRequest
	GetOptions() *ClientCheckOptions
}

type ClientCheckRequest struct {
	User             string                     `json:"user,omitempty"`
	Relation         string                     `json:"relation,omitempty"`
	Object           string                     `json:"object,omitempty"`
	Context          *map[string]interface{}    `json:"context,omitempty"`
	ContextualTuples []ClientContextualTupleKey `json:"contextual_tuples,omitempty"`
}

type ClientCheckOptions struct {
	AuthorizationModelId *string `json:"authorization_model_id,omitempty"`
}

type ClientCheckResponse struct {
	fgaSdk.CheckResponse
	HttpResponse *_nethttp.Response
}

func (client *OpenFgaClient) Check(ctx _context.Context) SdkClientCheckRequestInterface {
	return &SdkClientCheckRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientCheckRequest) Options(options ClientCheckOptions) SdkClientCheckRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientCheckRequest) GetAuthorizationModelIdOverride() *string {
	if request.options == nil {
		return nil
	}
	return request.options.AuthorizationModelId
}

func (request *SdkClientCheckRequest) Body(body ClientCheckRequest) SdkClientCheckRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientCheckRequest) Execute() (*ClientCheckResponse, error) {
	return request.Client.CheckExecute(request)
}

func (request *SdkClientCheckRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientCheckRequest) GetBody() *ClientCheckRequest {
	return request.body
}

func (request *SdkClientCheckRequest) GetOptions() *ClientCheckOptions {
	return request.options
}

func (client *OpenFgaClient) CheckExecute(request SdkClientCheckRequestInterface) (*ClientCheckResponse, error) {
	var contextualTuples []ClientContextualTupleKey
	if request.GetBody().ContextualTuples != nil {
		for index := 0; index < len(request.GetBody().ContextualTuples); index++ {
			contextualTuples = append(contextualTuples, (request.GetBody().ContextualTuples)[index])
		}
	}
	authorizationModelId, err := client.getAuthorizationModelId(request.GetAuthorizationModelIdOverride())
	if err != nil {
		return nil, err
	}
	requestBody := fgaSdk.CheckRequest{
		TupleKey: fgaSdk.CheckRequestTupleKey{
			User:     request.GetBody().User,
			Relation: request.GetBody().Relation,
			Object:   request.GetBody().Object,
		},
		Context:              request.GetBody().Context,
		ContextualTuples:     fgaSdk.NewContextualTupleKeys(contextualTuples),
		AuthorizationModelId: authorizationModelId,
	}

	data, httpResponse, err := client.OpenFgaApi.Check(request.GetContext()).Body(requestBody).Execute()
	return &ClientCheckResponse{CheckResponse: data, HttpResponse: httpResponse}, err
}

/// BatchCheck

type SdkClientBatchCheckRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientBatchCheckBody
	options *ClientBatchCheckOptions
}

type SdkClientBatchCheckRequestInterface interface {
	Options(options ClientBatchCheckOptions) SdkClientBatchCheckRequestInterface
	Body(body ClientBatchCheckBody) SdkClientBatchCheckRequestInterface
	Execute() (*ClientBatchCheckResponse, error)
	GetAuthorizationModelIdOverride() *string

	GetContext() _context.Context
	GetBody() *ClientBatchCheckBody
	GetOptions() *ClientBatchCheckOptions
}

type ClientBatchCheckBody = []ClientCheckRequest

type ClientBatchCheckOptions struct {
	AuthorizationModelId *string `json:"authorization_model_id,omitempty"`
	MaxParallelRequests  *int32  `json:"max_parallel_requests,omitempty"`
}

type ClientBatchCheckSingleResponse struct {
	ClientCheckResponse
	Request ClientCheckRequest
	Error   error
}

type ClientBatchCheckResponse = []ClientBatchCheckSingleResponse

func (client *OpenFgaClient) BatchCheck(ctx _context.Context) SdkClientBatchCheckRequestInterface {
	return &SdkClientBatchCheckRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientBatchCheckRequest) Options(options ClientBatchCheckOptions) SdkClientBatchCheckRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientBatchCheckRequest) GetAuthorizationModelIdOverride() *string {
	if request.options == nil {
		return nil
	}
	return request.options.AuthorizationModelId
}

func (request *SdkClientBatchCheckRequest) Body(body ClientBatchCheckBody) SdkClientBatchCheckRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientBatchCheckRequest) Execute() (*ClientBatchCheckResponse, error) {
	return request.Client.BatchCheckExecute(request)
}

func (request *SdkClientBatchCheckRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientBatchCheckRequest) GetBody() *ClientBatchCheckBody {
	return request.body
}

func (request *SdkClientBatchCheckRequest) GetOptions() *ClientBatchCheckOptions {
	return request.options
}

func (client *OpenFgaClient) BatchCheckExecute(request SdkClientBatchCheckRequestInterface) (*ClientBatchCheckResponse, error) {
	group, ctx := errgroup.WithContext(request.GetContext())
	var maxParallelReqs int
	if request.GetOptions() == nil || request.GetOptions().MaxParallelRequests == nil {
		maxParallelReqs = int(DEFAULT_MAX_METHOD_PARALLEL_REQS)
	} else {
		maxParallelReqs = int(*request.GetOptions().MaxParallelRequests)
	}
	group.SetLimit(maxParallelReqs)
	var numOfChecks = len(*request.GetBody())
	response := make(ClientBatchCheckResponse, numOfChecks)
	authorizationModelId, err := client.getAuthorizationModelId(request.GetAuthorizationModelIdOverride())
	if err != nil {
		return nil, err
	}

	group.Go(func() error {
		// if the connection is probelmatic, we will return error to the overall
		// response rather than individual response
		return client.checkValidApiConnection(ctx, authorizationModelId)
	})
	for index, checkBody := range *request.GetBody() {
		index, checkBody := index, checkBody
		group.Go(func() error {
			singleResponse, err := client.CheckExecute(&SdkClientCheckRequest{
				ctx:    ctx,
				Client: client,
				body:   &checkBody,
				options: &ClientCheckOptions{
					AuthorizationModelId: authorizationModelId,
				},
			})

			response[index] = ClientBatchCheckSingleResponse{
				Request:             checkBody,
				ClientCheckResponse: *singleResponse,
				Error:               err,
			}

			return nil
		})
	}

	if err := group.Wait(); err != nil {
		return nil, err
	}

	return &response, nil
}

// / Expand
type SdkClientExpandRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientExpandRequest
	options *ClientExpandOptions
}

type SdkClientExpandRequestInterface interface {
	Options(options ClientExpandOptions) SdkClientExpandRequestInterface
	Body(body ClientExpandRequest) SdkClientExpandRequestInterface
	Execute() (*ClientExpandResponse, error)
	GetAuthorizationModelIdOverride() *string

	GetContext() _context.Context
	GetBody() *ClientExpandRequest
	GetOptions() *ClientExpandOptions
}

type ClientExpandRequest struct {
	Relation string `json:"relation,omitempty"`
	Object   string `json:"object,omitempty"`
}

type ClientExpandOptions struct {
	AuthorizationModelId *string `json:"authorization_model_id,omitempty"`
}

type ClientExpandResponse = fgaSdk.ExpandResponse

func (client *OpenFgaClient) Expand(ctx _context.Context) SdkClientExpandRequestInterface {
	return &SdkClientExpandRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientExpandRequest) Options(options ClientExpandOptions) SdkClientExpandRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientExpandRequest) GetAuthorizationModelIdOverride() *string {
	if request.options == nil {
		return nil
	}
	return request.options.AuthorizationModelId
}

func (request *SdkClientExpandRequest) Body(body ClientExpandRequest) SdkClientExpandRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientExpandRequest) Execute() (*ClientExpandResponse, error) {
	return request.Client.ExpandExecute(request)
}

func (request *SdkClientExpandRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientExpandRequest) GetBody() *ClientExpandRequest {
	return request.body
}

func (request *SdkClientExpandRequest) GetOptions() *ClientExpandOptions {
	return request.options
}

func (client *OpenFgaClient) ExpandExecute(request SdkClientExpandRequestInterface) (*ClientExpandResponse, error) {
	authorizationModelId, err := client.getAuthorizationModelId(request.GetAuthorizationModelIdOverride())
	if err != nil {
		return nil, err
	}

	data, _, err := client.OpenFgaApi.Expand(request.GetContext()).Body(fgaSdk.ExpandRequest{
		TupleKey: fgaSdk.ExpandRequestTupleKey{
			Relation: request.GetBody().Relation,
			Object:   request.GetBody().Object,
		},
		AuthorizationModelId: authorizationModelId,
	}).Execute()
	if err != nil {
		return nil, err
	}
	return &data, nil
}

// / ListObjects
type SdkClientListObjectsRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientListObjectsRequest
	options *ClientListObjectsOptions
}

type SdkClientListObjectsRequestInterface interface {
	Options(options ClientListObjectsOptions) SdkClientListObjectsRequestInterface
	Body(body ClientListObjectsRequest) SdkClientListObjectsRequestInterface
	Execute() (*ClientListObjectsResponse, error)
	GetAuthorizationModelIdOverride() *string

	GetContext() _context.Context
	GetBody() *ClientListObjectsRequest
	GetOptions() *ClientListObjectsOptions
}

type ClientListObjectsRequest struct {
	User             string                     `json:"user,omitempty"`
	Relation         string                     `json:"relation,omitempty"`
	Type             string                     `json:"type,omitempty"`
	Context          *map[string]interface{}    `json:"context,omitempty"`
	ContextualTuples []ClientContextualTupleKey `json:"contextual_tuples,omitempty"`
}

type ClientListObjectsOptions struct {
	AuthorizationModelId *string `json:"authorization_model_id,omitempty"`
}

type ClientListObjectsResponse = fgaSdk.ListObjectsResponse

func (client *OpenFgaClient) ListObjects(ctx _context.Context) SdkClientListObjectsRequestInterface {
	return &SdkClientListObjectsRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientListObjectsRequest) Options(options ClientListObjectsOptions) SdkClientListObjectsRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientListObjectsRequest) GetAuthorizationModelIdOverride() *string {
	if request.options == nil {
		return nil
	}
	return request.options.AuthorizationModelId
}

func (request *SdkClientListObjectsRequest) Body(body ClientListObjectsRequest) SdkClientListObjectsRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientListObjectsRequest) Execute() (*ClientListObjectsResponse, error) {
	return request.Client.ListObjectsExecute(request)
}

func (request *SdkClientListObjectsRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientListObjectsRequest) GetBody() *ClientListObjectsRequest {
	return request.body
}

func (request *SdkClientListObjectsRequest) GetOptions() *ClientListObjectsOptions {
	return request.options
}

func (client *OpenFgaClient) ListObjectsExecute(request SdkClientListObjectsRequestInterface) (*ClientListObjectsResponse, error) {
	var contextualTuples []ClientContextualTupleKey
	if request.GetBody().ContextualTuples != nil {
		for index := 0; index < len(request.GetBody().ContextualTuples); index++ {
			contextualTuples = append(contextualTuples, (request.GetBody().ContextualTuples)[index])
		}
	}
	authorizationModelId, err := client.getAuthorizationModelId(request.GetAuthorizationModelIdOverride())
	if err != nil {
		return nil, err
	}
	data, _, err := client.OpenFgaApi.ListObjects(request.GetContext()).Body(fgaSdk.ListObjectsRequest{
		User:                 request.GetBody().User,
		Relation:             request.GetBody().Relation,
		Type:                 request.GetBody().Type,
		ContextualTuples:     fgaSdk.NewContextualTupleKeys(contextualTuples),
		Context:              request.GetBody().Context,
		AuthorizationModelId: authorizationModelId,
	}).Execute()
	if err != nil {
		return nil, err
	}
	return &data, nil
}

/// ListRelations

type SdkClientListRelationsRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientListRelationsRequest
	options *ClientListRelationsOptions
}

type SdkClientListRelationsRequestInterface interface {
	Options(options ClientListRelationsOptions) SdkClientListRelationsRequestInterface
	Body(body ClientListRelationsRequest) SdkClientListRelationsRequestInterface
	Execute() (*ClientListRelationsResponse, error)
	GetAuthorizationModelIdOverride() *string

	GetContext() _context.Context
	GetBody() *ClientListRelationsRequest
	GetOptions() *ClientListRelationsOptions
}

type ClientListRelationsRequest struct {
	User             string                     `json:"user,omitempty"`
	Object           string                     `json:"object,omitempty"`
	Relations        []string                   `json:"relations,omitempty"`
	Context          *map[string]interface{}    `json:"context,omitempty"`
	ContextualTuples []ClientContextualTupleKey `json:"contextual_tuples,omitempty"`
}

type ClientListRelationsOptions struct {
	AuthorizationModelId *string `json:"authorization_model_id,omitempty"`
}

type ClientListRelationsResponse struct {
	Relations []string `json:"response,omitempty"`
}

func (o ClientListRelationsResponse) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["relations"] = o.Relations
	return json.Marshal(toSerialize)
}

func (client *OpenFgaClient) ListRelations(ctx _context.Context) SdkClientListRelationsRequestInterface {
	return &SdkClientListRelationsRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientListRelationsRequest) Options(options ClientListRelationsOptions) SdkClientListRelationsRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientListRelationsRequest) GetAuthorizationModelIdOverride() *string {
	if request.options == nil {
		return nil
	}
	return request.options.AuthorizationModelId
}

func (request *SdkClientListRelationsRequest) Body(body ClientListRelationsRequest) SdkClientListRelationsRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientListRelationsRequest) Execute() (*ClientListRelationsResponse, error) {
	return request.Client.ListRelationsExecute(request)
}

func (request *SdkClientListRelationsRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientListRelationsRequest) GetBody() *ClientListRelationsRequest {
	return request.body
}

func (request *SdkClientListRelationsRequest) GetOptions() *ClientListRelationsOptions {
	return request.options
}

func (client *OpenFgaClient) ListRelationsExecute(request SdkClientListRelationsRequestInterface) (*ClientListRelationsResponse, error) {
	if len(request.GetBody().Relations) <= 0 {
		return nil, fmt.Errorf("ListRelations - expected len(Relations) > 0")
	}

	batchRequestBody := ClientBatchCheckBody{}
	for index := 0; index < len(request.GetBody().Relations); index++ {
		batchRequestBody = append(batchRequestBody, ClientCheckRequest{
			User:             request.GetBody().User,
			Relation:         request.GetBody().Relations[index],
			Object:           request.GetBody().Object,
			Context:          request.GetBody().Context,
			ContextualTuples: request.GetBody().ContextualTuples,
		})
	}
	authorizationModelId, err := client.getAuthorizationModelId(request.GetAuthorizationModelIdOverride())
	if err != nil {
		return nil, err
	}
	batchResponse, err := client.BatchCheckExecute(&SdkClientBatchCheckRequest{
		ctx:    request.GetContext(),
		Client: client,
		body:   &batchRequestBody,
		options: &ClientBatchCheckOptions{
			AuthorizationModelId: authorizationModelId,
		},
	})

	if err != nil {
		return nil, err
	}

	var relations []string
	for index := 0; index < len(*batchResponse); index++ {
		if (*batchResponse)[index].GetAllowed() {
			relations = append(relations, (*batchResponse)[index].Request.Relation)
		}
	}

	return &ClientListRelationsResponse{Relations: relations}, nil
}

// / ReadAssertions
type SdkClientReadAssertionsRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	options *ClientReadAssertionsOptions
}

type SdkClientReadAssertionsRequestInterface interface {
	Options(options ClientReadAssertionsOptions) SdkClientReadAssertionsRequestInterface
	Execute() (*ClientReadAssertionsResponse, error)
	GetAuthorizationModelIdOverride() *string

	GetContext() _context.Context
	GetOptions() *ClientReadAssertionsOptions
}

type ClientReadAssertionsOptions struct {
	AuthorizationModelId *string `json:"authorization_model_id,omitempty"`
}

type ClientReadAssertionsResponse = fgaSdk.ReadAssertionsResponse

func (client *OpenFgaClient) ReadAssertions(ctx _context.Context) SdkClientReadAssertionsRequestInterface {
	return &SdkClientReadAssertionsRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientReadAssertionsRequest) Options(options ClientReadAssertionsOptions) SdkClientReadAssertionsRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientReadAssertionsRequest) GetAuthorizationModelIdOverride() *string {
	if request.options == nil {
		return nil
	}
	return request.options.AuthorizationModelId
}

func (request *SdkClientReadAssertionsRequest) Execute() (*ClientReadAssertionsResponse, error) {
	return request.Client.ReadAssertionsExecute(request)
}

func (request *SdkClientReadAssertionsRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientReadAssertionsRequest) GetOptions() *ClientReadAssertionsOptions {
	return request.options
}

func (client *OpenFgaClient) ReadAssertionsExecute(request SdkClientReadAssertionsRequestInterface) (*ClientReadAssertionsResponse, error) {
	authorizationModelId, err := client.getAuthorizationModelId(request.GetAuthorizationModelIdOverride())
	if err != nil {
		return nil, err
	}
	if authorizationModelId == nil || *authorizationModelId == "" {
		return nil, FgaRequiredParamError{param: "AuthorizationModelId"}
	}
	data, _, err := client.OpenFgaApi.ReadAssertions(request.GetContext(), *authorizationModelId).Execute()
	if err != nil {
		return nil, err
	}
	return &data, nil
}

// / WriteAssertions
type SdkClientWriteAssertionsRequest struct {
	ctx    _context.Context
	Client *OpenFgaClient

	body    *ClientWriteAssertionsRequest
	options *ClientWriteAssertionsOptions
}

type SdkClientWriteAssertionsRequestInterface interface {
	Options(options ClientWriteAssertionsOptions) SdkClientWriteAssertionsRequestInterface
	Body(body ClientWriteAssertionsRequest) SdkClientWriteAssertionsRequestInterface
	Execute() (*ClientWriteAssertionsResponse, error)
	GetAuthorizationModelIdOverride() *string

	GetContext() _context.Context
	GetBody() *ClientWriteAssertionsRequest
	GetOptions() *ClientWriteAssertionsOptions
}

type ClientAssertion struct {
	User        string `json:"user,omitempty"`
	Relation    string `json:"relation,omitempty"`
	Object      string `json:"object,omitempty"`
	Expectation bool   `json:"expectation,omitempty"`
}

type ClientWriteAssertionsRequest = []ClientAssertion

func (clientAssertion ClientAssertion) ToAssertion() fgaSdk.Assertion {
	return fgaSdk.Assertion{
		TupleKey: fgaSdk.AssertionTupleKey{
			User:     clientAssertion.User,
			Relation: clientAssertion.Relation,
			Object:   clientAssertion.Object,
		},
		Expectation: clientAssertion.Expectation,
	}
}

type ClientWriteAssertionsOptions struct {
	AuthorizationModelId *string `json:"authorization_model_id,omitempty"`
}

type ClientWriteAssertionsResponse struct {
}

func (client *OpenFgaClient) WriteAssertions(ctx _context.Context) SdkClientWriteAssertionsRequestInterface {
	return &SdkClientWriteAssertionsRequest{
		Client: client,
		ctx:    ctx,
	}
}

func (request *SdkClientWriteAssertionsRequest) Options(options ClientWriteAssertionsOptions) SdkClientWriteAssertionsRequestInterface {
	request.options = &options
	return request
}

func (request *SdkClientWriteAssertionsRequest) GetAuthorizationModelIdOverride() *string {
	if request.options == nil {
		return nil
	}
	return request.options.AuthorizationModelId
}

func (request *SdkClientWriteAssertionsRequest) Body(body ClientWriteAssertionsRequest) SdkClientWriteAssertionsRequestInterface {
	request.body = &body
	return request
}

func (request *SdkClientWriteAssertionsRequest) Execute() (*ClientWriteAssertionsResponse, error) {
	return request.Client.WriteAssertionsExecute(request)
}

func (request *SdkClientWriteAssertionsRequest) GetContext() _context.Context {
	return request.ctx
}

func (request *SdkClientWriteAssertionsRequest) GetBody() *ClientWriteAssertionsRequest {
	return request.body
}

func (request *SdkClientWriteAssertionsRequest) GetOptions() *ClientWriteAssertionsOptions {
	return request.options
}

func (client *OpenFgaClient) WriteAssertionsExecute(request SdkClientWriteAssertionsRequestInterface) (*ClientWriteAssertionsResponse, error) {
	writeAssertionsRequest := fgaSdk.WriteAssertionsRequest{}
	authorizationModelId, err := client.getAuthorizationModelId(request.GetAuthorizationModelIdOverride())
	if err != nil {
		return nil, err
	}
	if authorizationModelId == nil || *authorizationModelId == "" {
		return nil, FgaRequiredParamError{param: "AuthorizationModelId"}
	}
	for index := 0; index < len(*request.GetBody()); index++ {
		clientAssertion := (*request.GetBody())[index]
		writeAssertionsRequest.Assertions = append(writeAssertionsRequest.Assertions, clientAssertion.ToAssertion())
	}
	_, err = client.OpenFgaApi.WriteAssertions(request.GetContext(), *authorizationModelId).Body(writeAssertionsRequest).Execute()

	if err != nil {
		return nil, err
	}
	return &ClientWriteAssertionsResponse{}, nil
}
