/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	_context "context"
	"fmt"
	_ioutil "io/ioutil"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// NetworkLoadBalancersApiService NetworkLoadBalancersApi service
type NetworkLoadBalancersApiService service

type ApiDatacentersNetworkloadbalancersDeleteRequest struct {
	ctx                   _context.Context
	ApiService            *NetworkLoadBalancersApiService
	datacenterId          string
	networkLoadBalancerId string
	pretty                *bool
	depth                 *int32
	xContractNumber       *int32
}

func (r ApiDatacentersNetworkloadbalancersDeleteRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersDeleteRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersDeleteRequest) Execute() (*APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersDeleteExecute(r)
}

/*
 * DatacentersNetworkloadbalancersDelete Delete Network Load Balancers
 * Remove the specified Network Load Balancer from the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @return ApiDatacentersNetworkloadbalancersDeleteRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersDelete(ctx _context.Context, datacenterId string, networkLoadBalancerId string) ApiDatacentersNetworkloadbalancersDeleteRequest {
	return ApiDatacentersNetworkloadbalancersDeleteRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
	}
}

/*
 * Execute executes the request
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersDeleteExecute(r ApiDatacentersNetworkloadbalancersDeleteRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersDelete")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarAPIResponse, newErr
	}

	return localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest struct {
	ctx                   _context.Context
	ApiService            *NetworkLoadBalancersApiService
	datacenterId          string
	networkLoadBalancerId string
	pretty                *bool
	depth                 *int32
	xContractNumber       *int32
}

func (r ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest) Execute() (NetworkLoadBalancer, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdExecute(r)
}

/*
 * DatacentersNetworkloadbalancersFindByNetworkLoadBalancerId Retrieve Network Load Balancers
 * Retrieve the properties of the specified Network Load Balancer within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @return ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFindByNetworkLoadBalancerId(ctx _context.Context, datacenterId string, networkLoadBalancerId string) ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest {
	return ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
	}
}

/*
 * Execute executes the request
 * @return NetworkLoadBalancer
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdExecute(r ApiDatacentersNetworkloadbalancersFindByNetworkLoadBalancerIdRequest) (NetworkLoadBalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NetworkLoadBalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersFindByNetworkLoadBalancerId")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersFindByNetworkLoadBalancerId",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest struct {
	ctx                   _context.Context
	ApiService            *NetworkLoadBalancersApiService
	datacenterId          string
	networkLoadBalancerId string
	flowLogId             string
	pretty                *bool
	depth                 *int32
	xContractNumber       *int32
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest) Execute() (*APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersFlowlogsDeleteExecute(r)
}

/*
 * DatacentersNetworkloadbalancersFlowlogsDelete Delete NLB Flow Logs
 * Delete the specified Network Load Balancer Flow Log.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @param flowLogId The unique ID of the Flow Log.
 * @return ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsDelete(ctx _context.Context, datacenterId string, networkLoadBalancerId string, flowLogId string) ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest {
	return ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
		flowLogId:             flowLogId,
	}
}

/*
 * Execute executes the request
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsDeleteExecute(r ApiDatacentersNetworkloadbalancersFlowlogsDeleteRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersFlowlogsDelete")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersFlowlogsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarAPIResponse, newErr
	}

	return localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest struct {
	ctx                   _context.Context
	ApiService            *NetworkLoadBalancersApiService
	datacenterId          string
	networkLoadBalancerId string
	flowLogId             string
	pretty                *bool
	depth                 *int32
	xContractNumber       *int32
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdExecute(r)
}

/*
 * DatacentersNetworkloadbalancersFlowlogsFindByFlowLogId Retrieve NLB Flow Logs
 * Retrieve the specified Network Load Balancer Flow Log.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @param flowLogId The unique ID of the Flow Log.
 * @return ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsFindByFlowLogId(ctx _context.Context, datacenterId string, networkLoadBalancerId string, flowLogId string) ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest {
	return ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
		flowLogId:             flowLogId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdExecute(r ApiDatacentersNetworkloadbalancersFlowlogsFindByFlowLogIdRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersFlowlogsFindByFlowLogId")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersFlowlogsFindByFlowLogId",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersFlowlogsGetRequest struct {
	ctx                   _context.Context
	ApiService            *NetworkLoadBalancersApiService
	filters               _neturl.Values
	orderBy               *string
	maxResults            *int32
	datacenterId          string
	networkLoadBalancerId string
	pretty                *bool
	depth                 *int32
	xContractNumber       *int32
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsGetRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersFlowlogsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsGetRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersFlowlogsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersFlowlogsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

// Filters query parameters limit results to those containing a matching value for a specific property.
func (r ApiDatacentersNetworkloadbalancersFlowlogsGetRequest) Filter(key string, value string) ApiDatacentersNetworkloadbalancersFlowlogsGetRequest {
	filterKey := fmt.Sprintf(FilterQueryParam, key)
	r.filters[filterKey] = []string{value}
	return r
}

// OrderBy query param sorts the results alphanumerically in ascending order based on the specified property.
func (r ApiDatacentersNetworkloadbalancersFlowlogsGetRequest) OrderBy(orderBy string) ApiDatacentersNetworkloadbalancersFlowlogsGetRequest {
	r.orderBy = &orderBy
	return r
}

// MaxResults query param limits the number of results returned.
func (r ApiDatacentersNetworkloadbalancersFlowlogsGetRequest) MaxResults(maxResults int32) ApiDatacentersNetworkloadbalancersFlowlogsGetRequest {
	r.maxResults = &maxResults
	return r
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsGetRequest) Execute() (FlowLogs, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersFlowlogsGetExecute(r)
}

/*
 * DatacentersNetworkloadbalancersFlowlogsGet List NLB Flow Logs
 * List all the Flow Logs for the specified Network Load Balancer.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @return ApiDatacentersNetworkloadbalancersFlowlogsGetRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsGet(ctx _context.Context, datacenterId string, networkLoadBalancerId string) ApiDatacentersNetworkloadbalancersFlowlogsGetRequest {
	return ApiDatacentersNetworkloadbalancersFlowlogsGetRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
		filters:               _neturl.Values{},
	}
}

/*
 * Execute executes the request
 * @return FlowLogs
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsGetExecute(r ApiDatacentersNetworkloadbalancersFlowlogsGetRequest) (FlowLogs, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLogs
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersFlowlogsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/flowlogs"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}
	if r.orderBy != nil {
		localVarQueryParams.Add("orderBy", parameterToString(*r.orderBy, ""))
	}
	if r.maxResults != nil {
		localVarQueryParams.Add("maxResults", parameterToString(*r.maxResults, ""))
	}
	if len(r.filters) > 0 {
		for k, v := range r.filters {
			for _, iv := range v {
				localVarQueryParams.Add(k, iv)
			}
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersFlowlogsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest struct {
	ctx                                  _context.Context
	ApiService                           *NetworkLoadBalancersApiService
	datacenterId                         string
	networkLoadBalancerId                string
	flowLogId                            string
	networkLoadBalancerFlowLogProperties *FlowLogProperties
	pretty                               *bool
	depth                                *int32
	xContractNumber                      *int32
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest) NetworkLoadBalancerFlowLogProperties(networkLoadBalancerFlowLogProperties FlowLogProperties) ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest {
	r.networkLoadBalancerFlowLogProperties = &networkLoadBalancerFlowLogProperties
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersFlowlogsPatchExecute(r)
}

/*
 * DatacentersNetworkloadbalancersFlowlogsPatch Partially modify NLB Flow Logs
 * Update the properties of the specified Network Load Balancer Flow Log.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @param flowLogId The unique ID of the Flow Log.
 * @return ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsPatch(ctx _context.Context, datacenterId string, networkLoadBalancerId string, flowLogId string) ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest {
	return ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
		flowLogId:             flowLogId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsPatchExecute(r ApiDatacentersNetworkloadbalancersFlowlogsPatchRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersFlowlogsPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.networkLoadBalancerFlowLogProperties == nil {
		return localVarReturnValue, nil, reportError("networkLoadBalancerFlowLogProperties is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.networkLoadBalancerFlowLogProperties
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersFlowlogsPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersFlowlogsPostRequest struct {
	ctx                        _context.Context
	ApiService                 *NetworkLoadBalancersApiService
	datacenterId               string
	networkLoadBalancerId      string
	networkLoadBalancerFlowLog *FlowLog
	pretty                     *bool
	depth                      *int32
	xContractNumber            *int32
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsPostRequest) NetworkLoadBalancerFlowLog(networkLoadBalancerFlowLog FlowLog) ApiDatacentersNetworkloadbalancersFlowlogsPostRequest {
	r.networkLoadBalancerFlowLog = &networkLoadBalancerFlowLog
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsPostRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersFlowlogsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsPostRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersFlowlogsPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersFlowlogsPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsPostRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersFlowlogsPostExecute(r)
}

/*
 * DatacentersNetworkloadbalancersFlowlogsPost Create NLB Flow Logs
 * Add a new Flow Log for the Network Load Balancer.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @return ApiDatacentersNetworkloadbalancersFlowlogsPostRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsPost(ctx _context.Context, datacenterId string, networkLoadBalancerId string) ApiDatacentersNetworkloadbalancersFlowlogsPostRequest {
	return ApiDatacentersNetworkloadbalancersFlowlogsPostRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsPostExecute(r ApiDatacentersNetworkloadbalancersFlowlogsPostRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersFlowlogsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/flowlogs"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.networkLoadBalancerFlowLog == nil {
		return localVarReturnValue, nil, reportError("networkLoadBalancerFlowLog is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.networkLoadBalancerFlowLog
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersFlowlogsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersFlowlogsPutRequest struct {
	ctx                        _context.Context
	ApiService                 *NetworkLoadBalancersApiService
	datacenterId               string
	networkLoadBalancerId      string
	flowLogId                  string
	networkLoadBalancerFlowLog *FlowLogPut
	pretty                     *bool
	depth                      *int32
	xContractNumber            *int32
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsPutRequest) NetworkLoadBalancerFlowLog(networkLoadBalancerFlowLog FlowLogPut) ApiDatacentersNetworkloadbalancersFlowlogsPutRequest {
	r.networkLoadBalancerFlowLog = &networkLoadBalancerFlowLog
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsPutRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersFlowlogsPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsPutRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersFlowlogsPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersFlowlogsPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersFlowlogsPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersFlowlogsPutRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersFlowlogsPutExecute(r)
}

/*
 * DatacentersNetworkloadbalancersFlowlogsPut Modify NLB Flow Logs
 * Modify the specified Network Load Balancer Flow Log.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @param flowLogId The unique ID of the Flow Log.
 * @return ApiDatacentersNetworkloadbalancersFlowlogsPutRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsPut(ctx _context.Context, datacenterId string, networkLoadBalancerId string, flowLogId string) ApiDatacentersNetworkloadbalancersFlowlogsPutRequest {
	return ApiDatacentersNetworkloadbalancersFlowlogsPutRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
		flowLogId:             flowLogId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersFlowlogsPutExecute(r ApiDatacentersNetworkloadbalancersFlowlogsPutRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersFlowlogsPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.networkLoadBalancerFlowLog == nil {
		return localVarReturnValue, nil, reportError("networkLoadBalancerFlowLog is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.networkLoadBalancerFlowLog
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersFlowlogsPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest struct {
	ctx                   _context.Context
	ApiService            *NetworkLoadBalancersApiService
	datacenterId          string
	networkLoadBalancerId string
	forwardingRuleId      string
	pretty                *bool
	depth                 *int32
	xContractNumber       *int32
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest) Execute() (*APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersForwardingrulesDeleteExecute(r)
}

/*
 * DatacentersNetworkloadbalancersForwardingrulesDelete Delete NLB forwarding rules
 * Delete the specified Network Load Balancer forwarding rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @param forwardingRuleId The unique ID of the forwarding rule.
 * @return ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesDelete(ctx _context.Context, datacenterId string, networkLoadBalancerId string, forwardingRuleId string) ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest {
	return ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
		forwardingRuleId:      forwardingRuleId,
	}
}

/*
 * Execute executes the request
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesDeleteExecute(r ApiDatacentersNetworkloadbalancersForwardingrulesDeleteRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersForwardingrulesDelete")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/forwardingrules/{forwardingRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"forwardingRuleId"+"}", _neturl.PathEscape(parameterToString(r.forwardingRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersForwardingrulesDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarAPIResponse, newErr
	}

	return localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest struct {
	ctx                   _context.Context
	ApiService            *NetworkLoadBalancersApiService
	datacenterId          string
	networkLoadBalancerId string
	forwardingRuleId      string
	pretty                *bool
	depth                 *int32
	xContractNumber       *int32
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest) Execute() (NetworkLoadBalancerForwardingRule, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdExecute(r)
}

/*
 * DatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleId Retrieve NLB forwarding rules
 * Retrieve the specified Network Load Balance forwarding rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @param forwardingRuleId The unique ID of the forwarding rule.
 * @return ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleId(ctx _context.Context, datacenterId string, networkLoadBalancerId string, forwardingRuleId string) ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest {
	return ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
		forwardingRuleId:      forwardingRuleId,
	}
}

/*
 * Execute executes the request
 * @return NetworkLoadBalancerForwardingRule
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdExecute(r ApiDatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleIdRequest) (NetworkLoadBalancerForwardingRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NetworkLoadBalancerForwardingRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleId")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/forwardingrules/{forwardingRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"forwardingRuleId"+"}", _neturl.PathEscape(parameterToString(r.forwardingRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersForwardingrulesFindByForwardingRuleId",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest struct {
	ctx                   _context.Context
	ApiService            *NetworkLoadBalancersApiService
	filters               _neturl.Values
	orderBy               *string
	maxResults            *int32
	datacenterId          string
	networkLoadBalancerId string
	pretty                *bool
	depth                 *int32
	xContractNumber       *int32
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

// Filters query parameters limit results to those containing a matching value for a specific property.
func (r ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest) Filter(key string, value string) ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest {
	filterKey := fmt.Sprintf(FilterQueryParam, key)
	r.filters[filterKey] = []string{value}
	return r
}

// OrderBy query param sorts the results alphanumerically in ascending order based on the specified property.
func (r ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest) OrderBy(orderBy string) ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest {
	r.orderBy = &orderBy
	return r
}

// MaxResults query param limits the number of results returned.
func (r ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest) MaxResults(maxResults int32) ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest {
	r.maxResults = &maxResults
	return r
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest) Execute() (NetworkLoadBalancerForwardingRules, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersForwardingrulesGetExecute(r)
}

/*
 * DatacentersNetworkloadbalancersForwardingrulesGet List NLB forwarding rules
 * List the forwarding rules for the specified Network Load Balancer.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @return ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesGet(ctx _context.Context, datacenterId string, networkLoadBalancerId string) ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest {
	return ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
		filters:               _neturl.Values{},
	}
}

/*
 * Execute executes the request
 * @return NetworkLoadBalancerForwardingRules
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesGetExecute(r ApiDatacentersNetworkloadbalancersForwardingrulesGetRequest) (NetworkLoadBalancerForwardingRules, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NetworkLoadBalancerForwardingRules
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersForwardingrulesGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/forwardingrules"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}
	if r.orderBy != nil {
		localVarQueryParams.Add("orderBy", parameterToString(*r.orderBy, ""))
	}
	if r.maxResults != nil {
		localVarQueryParams.Add("maxResults", parameterToString(*r.maxResults, ""))
	}
	if len(r.filters) > 0 {
		for k, v := range r.filters {
			for _, iv := range v {
				localVarQueryParams.Add(k, iv)
			}
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersForwardingrulesGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest struct {
	ctx                                         _context.Context
	ApiService                                  *NetworkLoadBalancersApiService
	datacenterId                                string
	networkLoadBalancerId                       string
	forwardingRuleId                            string
	networkLoadBalancerForwardingRuleProperties *NetworkLoadBalancerForwardingRuleProperties
	pretty                                      *bool
	depth                                       *int32
	xContractNumber                             *int32
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest) NetworkLoadBalancerForwardingRuleProperties(networkLoadBalancerForwardingRuleProperties NetworkLoadBalancerForwardingRuleProperties) ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest {
	r.networkLoadBalancerForwardingRuleProperties = &networkLoadBalancerForwardingRuleProperties
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest) Execute() (NetworkLoadBalancerForwardingRule, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersForwardingrulesPatchExecute(r)
}

/*
 * DatacentersNetworkloadbalancersForwardingrulesPatch Partially modify NLB forwarding rules
 * Update the properties of the specified Network Load Balancer forwarding rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @param forwardingRuleId The unique ID of the forwarding rule.
 * @return ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesPatch(ctx _context.Context, datacenterId string, networkLoadBalancerId string, forwardingRuleId string) ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest {
	return ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
		forwardingRuleId:      forwardingRuleId,
	}
}

/*
 * Execute executes the request
 * @return NetworkLoadBalancerForwardingRule
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesPatchExecute(r ApiDatacentersNetworkloadbalancersForwardingrulesPatchRequest) (NetworkLoadBalancerForwardingRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NetworkLoadBalancerForwardingRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersForwardingrulesPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/forwardingrules/{forwardingRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"forwardingRuleId"+"}", _neturl.PathEscape(parameterToString(r.forwardingRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.networkLoadBalancerForwardingRuleProperties == nil {
		return localVarReturnValue, nil, reportError("networkLoadBalancerForwardingRuleProperties is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.networkLoadBalancerForwardingRuleProperties
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersForwardingrulesPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest struct {
	ctx                               _context.Context
	ApiService                        *NetworkLoadBalancersApiService
	datacenterId                      string
	networkLoadBalancerId             string
	networkLoadBalancerForwardingRule *NetworkLoadBalancerForwardingRule
	pretty                            *bool
	depth                             *int32
	xContractNumber                   *int32
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest) NetworkLoadBalancerForwardingRule(networkLoadBalancerForwardingRule NetworkLoadBalancerForwardingRule) ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest {
	r.networkLoadBalancerForwardingRule = &networkLoadBalancerForwardingRule
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest) Execute() (NetworkLoadBalancerForwardingRule, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersForwardingrulesPostExecute(r)
}

/*
 * DatacentersNetworkloadbalancersForwardingrulesPost Create NLB forwarding rules
 * Create a forwarding rule for the specified Network Load Balancer.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @return ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesPost(ctx _context.Context, datacenterId string, networkLoadBalancerId string) ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest {
	return ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
	}
}

/*
 * Execute executes the request
 * @return NetworkLoadBalancerForwardingRule
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesPostExecute(r ApiDatacentersNetworkloadbalancersForwardingrulesPostRequest) (NetworkLoadBalancerForwardingRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NetworkLoadBalancerForwardingRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersForwardingrulesPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/forwardingrules"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.networkLoadBalancerForwardingRule == nil {
		return localVarReturnValue, nil, reportError("networkLoadBalancerForwardingRule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.networkLoadBalancerForwardingRule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersForwardingrulesPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest struct {
	ctx                               _context.Context
	ApiService                        *NetworkLoadBalancersApiService
	datacenterId                      string
	networkLoadBalancerId             string
	forwardingRuleId                  string
	networkLoadBalancerForwardingRule *NetworkLoadBalancerForwardingRulePut
	pretty                            *bool
	depth                             *int32
	xContractNumber                   *int32
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest) NetworkLoadBalancerForwardingRule(networkLoadBalancerForwardingRule NetworkLoadBalancerForwardingRulePut) ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest {
	r.networkLoadBalancerForwardingRule = &networkLoadBalancerForwardingRule
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest) Execute() (NetworkLoadBalancerForwardingRule, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersForwardingrulesPutExecute(r)
}

/*
 * DatacentersNetworkloadbalancersForwardingrulesPut Modify NLB forwarding rules
 * Modify the specified Network Load Balancer forwarding rule.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @param forwardingRuleId The unique ID of the forwarding rule.
 * @return ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesPut(ctx _context.Context, datacenterId string, networkLoadBalancerId string, forwardingRuleId string) ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest {
	return ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
		forwardingRuleId:      forwardingRuleId,
	}
}

/*
 * Execute executes the request
 * @return NetworkLoadBalancerForwardingRule
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersForwardingrulesPutExecute(r ApiDatacentersNetworkloadbalancersForwardingrulesPutRequest) (NetworkLoadBalancerForwardingRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NetworkLoadBalancerForwardingRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersForwardingrulesPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}/forwardingrules/{forwardingRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"forwardingRuleId"+"}", _neturl.PathEscape(parameterToString(r.forwardingRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.networkLoadBalancerForwardingRule == nil {
		return localVarReturnValue, nil, reportError("networkLoadBalancerForwardingRule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.networkLoadBalancerForwardingRule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersForwardingrulesPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersGetRequest struct {
	ctx             _context.Context
	ApiService      *NetworkLoadBalancersApiService
	filters         _neturl.Values
	orderBy         *string
	maxResults      *int32
	datacenterId    string
	pretty          *bool
	depth           *int32
	xContractNumber *int32
	offset          *int32
	limit           *int32
}

func (r ApiDatacentersNetworkloadbalancersGetRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersGetRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}
func (r ApiDatacentersNetworkloadbalancersGetRequest) Offset(offset int32) ApiDatacentersNetworkloadbalancersGetRequest {
	r.offset = &offset
	return r
}
func (r ApiDatacentersNetworkloadbalancersGetRequest) Limit(limit int32) ApiDatacentersNetworkloadbalancersGetRequest {
	r.limit = &limit
	return r
}

// Filters query parameters limit results to those containing a matching value for a specific property.
func (r ApiDatacentersNetworkloadbalancersGetRequest) Filter(key string, value string) ApiDatacentersNetworkloadbalancersGetRequest {
	filterKey := fmt.Sprintf(FilterQueryParam, key)
	r.filters[filterKey] = []string{value}
	return r
}

// OrderBy query param sorts the results alphanumerically in ascending order based on the specified property.
func (r ApiDatacentersNetworkloadbalancersGetRequest) OrderBy(orderBy string) ApiDatacentersNetworkloadbalancersGetRequest {
	r.orderBy = &orderBy
	return r
}

// MaxResults query param limits the number of results returned.
func (r ApiDatacentersNetworkloadbalancersGetRequest) MaxResults(maxResults int32) ApiDatacentersNetworkloadbalancersGetRequest {
	r.maxResults = &maxResults
	return r
}

func (r ApiDatacentersNetworkloadbalancersGetRequest) Execute() (NetworkLoadBalancers, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersGetExecute(r)
}

/*
 * DatacentersNetworkloadbalancersGet List Network Load Balancers
 * List all the Network Load Balancers within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @return ApiDatacentersNetworkloadbalancersGetRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersGet(ctx _context.Context, datacenterId string) ApiDatacentersNetworkloadbalancersGetRequest {
	return ApiDatacentersNetworkloadbalancersGetRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		filters:      _neturl.Values{},
	}
}

/*
 * Execute executes the request
 * @return NetworkLoadBalancers
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersGetExecute(r ApiDatacentersNetworkloadbalancersGetRequest) (NetworkLoadBalancers, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NetworkLoadBalancers
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}
	if r.offset != nil {
		localVarQueryParams.Add("offset", parameterToString(*r.offset, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("offset")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("offset", parameterToString(0, ""))
		}
	}
	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("limit")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("limit", parameterToString(1000, ""))
		}
	}
	if r.orderBy != nil {
		localVarQueryParams.Add("orderBy", parameterToString(*r.orderBy, ""))
	}
	if r.maxResults != nil {
		localVarQueryParams.Add("maxResults", parameterToString(*r.maxResults, ""))
	}
	if len(r.filters) > 0 {
		for k, v := range r.filters {
			for _, iv := range v {
				localVarQueryParams.Add(k, iv)
			}
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersPatchRequest struct {
	ctx                           _context.Context
	ApiService                    *NetworkLoadBalancersApiService
	datacenterId                  string
	networkLoadBalancerId         string
	networkLoadBalancerProperties *NetworkLoadBalancerProperties
	pretty                        *bool
	depth                         *int32
	xContractNumber               *int32
}

func (r ApiDatacentersNetworkloadbalancersPatchRequest) NetworkLoadBalancerProperties(networkLoadBalancerProperties NetworkLoadBalancerProperties) ApiDatacentersNetworkloadbalancersPatchRequest {
	r.networkLoadBalancerProperties = &networkLoadBalancerProperties
	return r
}
func (r ApiDatacentersNetworkloadbalancersPatchRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersPatchRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersPatchRequest) Execute() (NetworkLoadBalancer, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersPatchExecute(r)
}

/*
 * DatacentersNetworkloadbalancersPatch Partially modify Network Load Balancers
 * Update the properties of the specified Network Load Balancer within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @return ApiDatacentersNetworkloadbalancersPatchRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersPatch(ctx _context.Context, datacenterId string, networkLoadBalancerId string) ApiDatacentersNetworkloadbalancersPatchRequest {
	return ApiDatacentersNetworkloadbalancersPatchRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
	}
}

/*
 * Execute executes the request
 * @return NetworkLoadBalancer
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersPatchExecute(r ApiDatacentersNetworkloadbalancersPatchRequest) (NetworkLoadBalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NetworkLoadBalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.networkLoadBalancerProperties == nil {
		return localVarReturnValue, nil, reportError("networkLoadBalancerProperties is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.networkLoadBalancerProperties
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersPostRequest struct {
	ctx                 _context.Context
	ApiService          *NetworkLoadBalancersApiService
	datacenterId        string
	networkLoadBalancer *NetworkLoadBalancer
	pretty              *bool
	depth               *int32
	xContractNumber     *int32
}

func (r ApiDatacentersNetworkloadbalancersPostRequest) NetworkLoadBalancer(networkLoadBalancer NetworkLoadBalancer) ApiDatacentersNetworkloadbalancersPostRequest {
	r.networkLoadBalancer = &networkLoadBalancer
	return r
}
func (r ApiDatacentersNetworkloadbalancersPostRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersPostRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersPostRequest) Execute() (NetworkLoadBalancer, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersPostExecute(r)
}

/*
 * DatacentersNetworkloadbalancersPost Create Network Load Balancers
 * Create a Network Load Balancer within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @return ApiDatacentersNetworkloadbalancersPostRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersPost(ctx _context.Context, datacenterId string) ApiDatacentersNetworkloadbalancersPostRequest {
	return ApiDatacentersNetworkloadbalancersPostRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
	}
}

/*
 * Execute executes the request
 * @return NetworkLoadBalancer
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersPostExecute(r ApiDatacentersNetworkloadbalancersPostRequest) (NetworkLoadBalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NetworkLoadBalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.networkLoadBalancer == nil {
		return localVarReturnValue, nil, reportError("networkLoadBalancer is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.networkLoadBalancer
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersNetworkloadbalancersPutRequest struct {
	ctx                   _context.Context
	ApiService            *NetworkLoadBalancersApiService
	datacenterId          string
	networkLoadBalancerId string
	networkLoadBalancer   *NetworkLoadBalancerPut
	pretty                *bool
	depth                 *int32
	xContractNumber       *int32
}

func (r ApiDatacentersNetworkloadbalancersPutRequest) NetworkLoadBalancer(networkLoadBalancer NetworkLoadBalancerPut) ApiDatacentersNetworkloadbalancersPutRequest {
	r.networkLoadBalancer = &networkLoadBalancer
	return r
}
func (r ApiDatacentersNetworkloadbalancersPutRequest) Pretty(pretty bool) ApiDatacentersNetworkloadbalancersPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersNetworkloadbalancersPutRequest) Depth(depth int32) ApiDatacentersNetworkloadbalancersPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersNetworkloadbalancersPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersNetworkloadbalancersPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersNetworkloadbalancersPutRequest) Execute() (NetworkLoadBalancer, *APIResponse, error) {
	return r.ApiService.DatacentersNetworkloadbalancersPutExecute(r)
}

/*
 * DatacentersNetworkloadbalancersPut Modify Network Load Balancers
 * Modify the properties of the specified Network Load Balancer within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param networkLoadBalancerId The unique ID of the Network Load Balancer.
 * @return ApiDatacentersNetworkloadbalancersPutRequest
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersPut(ctx _context.Context, datacenterId string, networkLoadBalancerId string) ApiDatacentersNetworkloadbalancersPutRequest {
	return ApiDatacentersNetworkloadbalancersPutRequest{
		ApiService:            a,
		ctx:                   ctx,
		datacenterId:          datacenterId,
		networkLoadBalancerId: networkLoadBalancerId,
	}
}

/*
 * Execute executes the request
 * @return NetworkLoadBalancer
 */
func (a *NetworkLoadBalancersApiService) DatacentersNetworkloadbalancersPutExecute(r ApiDatacentersNetworkloadbalancersPutRequest) (NetworkLoadBalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  NetworkLoadBalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "NetworkLoadBalancersApiService.DatacentersNetworkloadbalancersPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/networkloadbalancers/{networkLoadBalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"networkLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.networkLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.networkLoadBalancer == nil {
		return localVarReturnValue, nil, reportError("networkLoadBalancer is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.networkLoadBalancer
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["Token Authentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersNetworkloadbalancersPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := _ioutil.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}
