/*
 * CLOUD API
 *
 * IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	"encoding/json"
)

// ConnectableDatacenter struct for ConnectableDatacenter
type ConnectableDatacenter struct {
	Id       *string `json:"id,omitempty"`
	Location *string `json:"location,omitempty"`
	Name     *string `json:"name,omitempty"`
}

// NewConnectableDatacenter instantiates a new ConnectableDatacenter object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewConnectableDatacenter() *ConnectableDatacenter {
	this := ConnectableDatacenter{}

	return &this
}

// NewConnectableDatacenterWithDefaults instantiates a new ConnectableDatacenter object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewConnectableDatacenterWithDefaults() *ConnectableDatacenter {
	this := ConnectableDatacenter{}
	return &this
}

// GetId returns the Id field value
// If the value is explicit nil, nil is returned
func (o *ConnectableDatacenter) GetId() *string {
	if o == nil {
		return nil
	}

	return o.Id

}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ConnectableDatacenter) GetIdOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Id, true
}

// SetId sets field value
func (o *ConnectableDatacenter) SetId(v string) {

	o.Id = &v

}

// HasId returns a boolean if a field has been set.
func (o *ConnectableDatacenter) HasId() bool {
	if o != nil && o.Id != nil {
		return true
	}

	return false
}

// GetLocation returns the Location field value
// If the value is explicit nil, nil is returned
func (o *ConnectableDatacenter) GetLocation() *string {
	if o == nil {
		return nil
	}

	return o.Location

}

// GetLocationOk returns a tuple with the Location field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ConnectableDatacenter) GetLocationOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Location, true
}

// SetLocation sets field value
func (o *ConnectableDatacenter) SetLocation(v string) {

	o.Location = &v

}

// HasLocation returns a boolean if a field has been set.
func (o *ConnectableDatacenter) HasLocation() bool {
	if o != nil && o.Location != nil {
		return true
	}

	return false
}

// GetName returns the Name field value
// If the value is explicit nil, nil is returned
func (o *ConnectableDatacenter) GetName() *string {
	if o == nil {
		return nil
	}

	return o.Name

}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ConnectableDatacenter) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}

	return o.Name, true
}

// SetName sets field value
func (o *ConnectableDatacenter) SetName(v string) {

	o.Name = &v

}

// HasName returns a boolean if a field has been set.
func (o *ConnectableDatacenter) HasName() bool {
	if o != nil && o.Name != nil {
		return true
	}

	return false
}

func (o ConnectableDatacenter) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.Id != nil {
		toSerialize["id"] = o.Id
	}

	if o.Location != nil {
		toSerialize["location"] = o.Location
	}

	if o.Name != nil {
		toSerialize["name"] = o.Name
	}

	return json.Marshal(toSerialize)
}

type NullableConnectableDatacenter struct {
	value *ConnectableDatacenter
	isSet bool
}

func (v NullableConnectableDatacenter) Get() *ConnectableDatacenter {
	return v.value
}

func (v *NullableConnectableDatacenter) Set(val *ConnectableDatacenter) {
	v.value = val
	v.isSet = true
}

func (v NullableConnectableDatacenter) IsSet() bool {
	return v.isSet
}

func (v *NullableConnectableDatacenter) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableConnectableDatacenter(val *ConnectableDatacenter) *NullableConnectableDatacenter {
	return &NullableConnectableDatacenter{value: val, isSet: true}
}

func (v NullableConnectableDatacenter) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableConnectableDatacenter) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
