### 乐观锁

要使用乐观锁，需要使用version标记
type User struct {
    Id int64
    Name string
    Version int `xorm:"version"`
}

在Insert时，version标记的字段将会被设置为1，在Update时，Update的内容必须包含version原来的值。

```Go
var user User
engine.Id(1).Get(&user)
// SELECT * FROM user WHERE id = ?
engine.Id(1).Update(&user)
// UPDATE user SET ..., version = version + 1 WHERE id = ? AND version = ?
```
