### Get方法

查询单条数据使用`Get`方法，在调用Get方法时需要传入一个对应结构体的指针，同时结构体中的非空field自动成为查询的条件和前面的方法条件组合在一起查询。

如：

1) 根据Id来获得单条数据:

```Go
user := new(User)
has, err := engine.Id(id).Get(user)
// 复合主键的获取方法
// has, errr := engine.Id(xorm.PK{1,2}).Get(user)
```

2) 根据Where来获得单条数据：

```Go
user := new(User)
has, err := engine.Where("name=?", "xlw").Get(user)
```

3) 根据user结构体中已有的非空数据来获得单条数据：

```Go
user := &User{Id:1}
has, err := engine.Get(user)
```

或者其它条件

```Go
user := &User{Name:"xlw"}
has, err := engine.Get(user)
```

返回的结果为两个参数，一个`has`为该条记录是否存在，第二个参数`err`为是否有错误。不管err是否为nil，has都有可能为true或者false。
