## 同步数据库结构

同步能够部分智能的根据结构体的变动检测表结构的变动，并自动同步。目前有两个实现：

* Sync

    * 自动检测和创建表，这个检测是根据表的名字
    * 自动检测和新增表中的字段，这个检测是根据字段名
    * 自动检测和创建索引和唯一索引，这个检测是根据索引的一个或多个字段名，而不根据索引名称

调用方法如下：

```Go
err := engine.Sync(new(User))
```

* Sync2对Sync进行了改进，目前推荐使用Sync2。

    * 自动检测和创建表，这个检测是根据表的名字
    * 自动检测和新增表中的字段，这个检测是根据字段名，同时对表中多余的字段给出警告信息
    * 自动检测，创建，和删除索引和唯一索引，这个检测是根据索引的一个或多个字段名，而不根据索引名称
    * 自动转换varchar字段类型到text字段类型，自动警告其它类型不一致的情况。
    * 自动警告字段的默认值，是否为空信息在模型和数据库之间不匹配的情况

    以上这些警告信息需要将`engine.ShowWarn` 设置为 `true`。调用方法和Sync一样：

```Go
err := engine.Sync2(new(User))
```


