### Column属性定义
我们在field对应的Tag中对Column的一些属性进行定义，定义的方法基本和我们写SQL定义表结构类似，比如：

```
type User struct {
    Id   int64
    Name string  `xorm:"varchar(25) not null unique 'usr_name'"`
}
```

对于不同的数据库系统，数据类型其实是有些差异的。因此xorm中对数据类型有自己的定义，基本的原则是尽量兼容各种数据库的字段类型，具体的字段对应关系可以查看[字段类型对应表](https://github.com/go-xorm/xorm/blob/master/docs/COLUMNTYPE.md)。对于使用者，一般只要使用自己熟悉的数据库字段定义即可。

具体的Tag规则如下，另Tag中的关键字均不区分大小写，但字段名根据不同的数据库是区分大小写：

<table>
    <tr>
        <td>name</td><td>当前field对应的字段的名称，可选，如不写，则自动根据field名字和转换规则命名，如与其它关键字冲突，请使用单引号括起来。</td>
    </tr>
    <tr>
        <td>pk</td><td>是否是Primary Key，如果在一个struct中有多个字段都使用了此标记，则这多个字段构成了复合主键，单主键当前支持int32,int,int64,uint32,uint,uint64,string这7种Go的数据类型，复合主键支持这7种Go的数据类型的组合。</td>
    </tr>
    <tr>
        <td>当前支持30多种字段类型，详情参见 [字段类型](https://github.com/go-xorm/xorm/blob/master/docs/COLUMNTYPE.md)</td><td>字段类型</td>
    </tr>
    <tr>
        <td>autoincr</td><td>是否是自增</td>
    </tr>
    <tr>
        <td>[not ]null 或 notnull</td><td>是否可以为空</td>
    </tr>
    <tr>
        <td>unique或unique(uniquename)</td><td>是否是唯一，如不加括号则该字段不允许重复；如加上括号，则括号中为联合唯一索引的名字，此时如果有另外一个或多个字段和本unique的uniquename相同，则这些uniquename相同的字段组成联合唯一索引</td>
    </tr>
    <tr>
        <td>index或index(indexname)</td><td>是否是索引，如不加括号则该字段自身为索引，如加上括号，则括号中为联合索引的名字，此时如果有另外一个或多个字段和本index的indexname相同，则这些indexname相同的字段组成联合索引</td>
    </tr>
    <tr>
        <td>extends</td><td>应用于一个匿名结构体之上，表示此匿名结构体的成员也映射到数据库中</td>
    </tr>
    <tr>
        <td>-</td><td>这个Field将不进行字段映射</td>
    </tr>
     <tr>
        <td>-></td><td>这个Field将只写入到数据库而不从数据库读取</td>
    </tr>
     <tr>
        <td>&lt;-</td><td>这个Field将只从数据库读取，而不写入到数据库</td>
    </tr>
     <tr>
        <td>created</td><td>这个Field将在Insert时自动赋值为当前时间</td>
    </tr>
     <tr>
        <td>updated</td><td>这个Field将在Insert或Update时自动赋值为当前时间</td>
    </tr>
     <tr>
        <td>version</td><td>这个Field将会在insert时默认为1，每次更新自动加1</td>
    </tr>
    <tr>
        <td>default 0</td><td>设置默认值，紧跟的内容如果是Varchar等需要加上单引号</td>
    </tr>
</table>

另外有如下几条自动映射的规则：

- 1.如果field名称为`Id`而且类型为`int64`并且没有定义tag，则会被xorm视为主键，并且拥有自增属性。如果想用`Id`以外的名字或非int64类型做为主键名，必须在对应的Tag上加上`xorm:"pk"`来定义主键，加上`xorm:"autoincr"`作为自增。这里需要注意的是，有些数据库并不允许非主键的自增属性。

- 2.string类型默认映射为varchar(255)，如果需要不同的定义，可以在tag中自定义

- 3.支持`type MyString string`等自定义的field，支持Slice, Map等field成员，这些成员默认存储为Text类型，并且默认将使用Json格式来序列化和反序列化。也支持数据库字段类型为Blob类型，如果是Blob类型，则先使用Json格式序列化再转成[]byte格式。当然[]byte或者[]uint8默认为Blob类型并且都以二进制方式存储。具体参见 [Go与字段类型对应表](chapter-02/5.types.md)

- 4.实现了Conversion接口的类型或者结构体，将根据接口的转换方式在类型和数据库记录之间进行相互转换，这个接口的优先级是最高的。
```Go
type Conversion interface {
    FromDB([]byte) error
    ToDB() ([]byte, error)
}
```

- 5.如果一个结构体包含一个Conversion的接口类型，那么在获取数据时，必须要预先设置一个实现此接口的struct或者struct的指针。此时可以在此struct中实现`BeforeSet(name string, cell xorm.Cell)`方法来进行预先给Conversion赋值。例子参见 [testConversion](https://github.com/go-xorm/tests/blob/master/base.go#L1826)


<table>
    <tr>
    <td>xorm
    </td>
    <td>mysql
    </td>
    <td>sqlite3
    </td>
    <td>postgres
    </td>
    <td>remark</td>
    </tr>
    
    <tr>
    <td>BIT
    </td>
    <td>BIT
    </td>
    <td>INTEGER
    </td>
    <td>BIT
    </td>
    <td></td>
    </tr>
    
    <tr>
    <td>TINYINT
    </td>
    <td>TINYINT
    </td>
    <td>INTEGER
    </td>
    <td>SMALLINT
    </td>
    <td></td>
    </tr>


<tr>
    <td>SMALLINT
    </td>
    <td>SMALLINT
    </td>
    <td>INTEGER
    </td>
    <td>SMALLINT
    </td>
    <td></td>
    </tr>


<tr>
    <td>MEDIUMINT
    </td>
    <td>MEDIUMINT
    </td>
    <td>INTEGER
    </td>
    <td>INTEGER
    </td>
    <td></td>
    </tr>


<tr>
    <td>INT
    </td>
    <td>INT
    </td>
    <td>INTEGER
    </td>
    <td>INTEGER
    </td>
    <td></td>
    </tr>

<tr>
    <td>INTEGER
    </td>
    <td>INTEGER
    </td>
    <td>INTEGER
    </td>
    <td>INTEGER
    </td>
    <td></td>
    </tr>


<tr>
    <td>BIGINT
    </td>
    <td>BIGINT
    </td>
    <td>INTEGER
    </td>
    <td>BIGINT
    </td>
    <td></td>
    </tr>
 <tr><td cols="5"></td></tr>

<tr>
    <td>CHAR
    </td>
    <td>CHAR
    </td>
    <td>TEXT
    </td>
    <td>CHAR
    </td>
    <td></td>
    </tr>


<tr>
    <td>VARCHAR
    </td>
    <td>VARCHAR
    </td>
    <td>TEXT
    </td>
    <td>VARCHAR
    </td>
    <td></td>
    </tr>


<tr>
    <td>TINYTEXT
    </td>
    <td>TINYTEXT
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td></td>
    </tr>

<tr>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td></td>
    </tr>
    
<tr>
    <td>MEDIUMTEXT
    </td>
    <td>MEDIUMTEXT
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td></td>
    </tr>


<tr>
    <td>LONGTEXT
    </td>
    <td>LONGTEXT
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td></td>
    </tr>
<tr><td cols="5"></td></tr>

<tr>
    <td>BINARY
    </td>
    <td>BINARY
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>


<tr>
    <td>VARBINARY
    </td>
    <td>VARBINARY
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>
<tr><td cols="5"></td></tr>

<tr>
    <td>DATE
    </td>
    <td>DATE
    </td>
    <td>NUMERIC
    </td>
    <td>DATE
    </td>
    <td></td>
    </tr>


<tr>
    <td>DATETIME
    </td>
    <td>DATETIME
    </td>
    <td>NUMERIC
    </td>
    <td>TIMESTAMP
    </td>
    <td></td>
    </tr>


<tr>
    <td>TIME
    </td>
    <td>TIME
    </td>
    <td>NUMERIC
    </td>
    <td>TIME
    </td>
    <td></td>
    </tr>


<tr>
    <td>TIMESTAMP
    </td>
    <td>TIMESTAMP
    </td>
    <td>NUMERIC
    </td>
    <td>TIMESTAMP
    </td>
    <td></td>
    </tr>
    
    
<tr>
    <td>TIMESTAMPZ
    </td>
    <td>TEXT
    </td>
    <td>TEXT
    </td>
    <td>TIMESTAMP with zone
    </td>
    <td>timestamp with zone info</td>
    </tr>

<tr><td cols="5"></td></tr>
<tr>
    <td>REAL
    </td>
    <td>REAL
    </td>
    <td>REAL
    </td>
    <td>REAL
    </td>
    <td></td>
    </tr>


<tr>
    <td>FLOAT
    </td>
    <td>FLOAT
    </td>
    <td>REAL
    </td>
    <td>REAL
    </td>
    <td></td>
    </tr>


<tr>
    <td>DOUBLE
    </td>
    <td>DOUBLE
    </td>
    <td>REAL
    </td>
    <td>DOUBLE PRECISION
    </td>
    <td></td>
    </tr>

<tr><td cols="5"></td></tr>
<tr>
    <td>DECIMAL
    </td>
    <td>DECIMAL
    </td>
    <td>NUMERIC
    </td>
    <td>DECIMAL
    </td>
    <td></td>
    </tr>


<tr>
    <td>NUMERIC
    </td>
    <td>NUMERIC
    </td>
    <td>NUMERIC
    </td>
    <td>NUMERIC
    </td>
    <td></td>
    </tr>

<tr><td cols="5"></td></tr>
<tr>
    <td>TINYBLOB
    </td>
    <td>TINYBLOB
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>


<tr>
    <td>BLOB
    </td>
    <td>BLOB
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>


<tr>
    <td>MEDIUMBLOB
    </td>
    <td>MEDIUMBLOB
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>


<tr>
    <td>LONGBLOB
    </td>
    <td>LONGBLOB
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>

<tr>
    <td>BYTEA
    </td>
    <td>BLOB
    </td>
    <td>BLOB
    </td>
    <td>BYTEA
    </td>
    <td></td>
    </tr>

<tr><td cols="5"></td></tr>

<tr>
    <td>BOOL
    </td>
    <td>TINYINT
    </td>
    <td>INTEGER
    </td>
    <td>BOOLEAN
    </td>
    <td></td>
    </tr>


<tr>
    <td>SERIAL
    </td>
    <td>INT
    </td>
    <td>INTEGER
    </td>
    <td>SERIAL
    </td>
    <td>auto increment</td>
    </tr>

<tr>
    <td>BIGSERIAL
    </td>
    <td>BIGINT
    </td>
    <td>INTEGER
    </td>
    <td>BIGSERIAL
    </td>
    <td>auto increment</td>
    </tr>


</table>
