### 使用Table和Tag改变名称映射

如果所有的命名都是按照IMapper的映射来操作的，那当然是最理想的。但是如果碰到某个表名或者某个字段名跟映射规则不匹配时，我们就需要别的机制来改变。

* 如果结构体拥有`TableName() string`的成员方法，那么此方法的返回值即是该结构体对应的数据库表名。

* 通过`engine.Table()`方法可以改变struct对应的数据库表的名称，通过sturct中field对应的Tag中使用`xorm:"'column_name'"`可以使该field对应的Column名称为指定名称。这里使用两个单引号将Column名称括起来是为了防止名称冲突，因为我们在Tag中还可以对这个Column进行更多的定义。如果名称不冲突的情况，单引号也可以不使用。

到此名称映射的所有方法都给出了，一共三种方式，那么这三种是有优先级顺序的。

* 表名的优先级顺序如下：

    * `engine.Table()` 指定的临时表名优先级最高
    * `TableName() string` 其次
    * `Mapper` 自动映射的表名优先级最后

* 字段名的优先级顺序如下：

    * 结构体tag指定的字段名优先级较高
    * `Mapper` 自动映射的表名优先级较低
