// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package entv2

import (
	"fmt"
	"strings"

	"github.com/facebook/ent/dialect/sql"
	"github.com/facebook/ent/entc/integration/migrate/entv2/media"
)

// Media is the model entity for the Media schema.
type Media struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// Source holds the value of the "source" field.
	Source string `json:"source,omitempty"`
	// SourceURI holds the value of the "source_uri" field.
	SourceURI string `json:"source_uri,omitempty"`
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Media) scanValues() []interface{} {
	return []interface{}{
		&sql.NullInt64{},  // id
		&sql.NullString{}, // source
		&sql.NullString{}, // source_uri
	}
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Media fields.
func (m *Media) assignValues(values ...interface{}) error {
	if m, n := len(values), len(media.Columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	value, ok := values[0].(*sql.NullInt64)
	if !ok {
		return fmt.Errorf("unexpected type %T for field id", value)
	}
	m.ID = int(value.Int64)
	values = values[1:]
	if value, ok := values[0].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field source", values[0])
	} else if value.Valid {
		m.Source = value.String
	}
	if value, ok := values[1].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field source_uri", values[1])
	} else if value.Valid {
		m.SourceURI = value.String
	}
	return nil
}

// Update returns a builder for updating this Media.
// Note that, you need to call Media.Unwrap() before calling this method, if this Media
// was returned from a transaction, and the transaction was committed or rolled back.
func (m *Media) Update() *MediaUpdateOne {
	return (&MediaClient{config: m.config}).UpdateOne(m)
}

// Unwrap unwraps the entity that was returned from a transaction after it was closed,
// so that all next queries will be executed through the driver which created the transaction.
func (m *Media) Unwrap() *Media {
	tx, ok := m.config.driver.(*txDriver)
	if !ok {
		panic("entv2: Media is not a transactional entity")
	}
	m.config.driver = tx.drv
	return m
}

// String implements the fmt.Stringer.
func (m *Media) String() string {
	var builder strings.Builder
	builder.WriteString("Media(")
	builder.WriteString(fmt.Sprintf("id=%v", m.ID))
	builder.WriteString(", source=")
	builder.WriteString(m.Source)
	builder.WriteString(", source_uri=")
	builder.WriteString(m.SourceURI)
	builder.WriteByte(')')
	return builder.String()
}

// MediaSlice is a parsable slice of Media.
type MediaSlice []*Media

func (m MediaSlice) config(cfg config) {
	for _i := range m {
		m[_i].config = cfg
	}
}
