// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package entv1

import (
	"context"
	"fmt"

	"github.com/facebook/ent/dialect/sql"
	"github.com/facebook/ent/dialect/sql/sqlgraph"
	"github.com/facebook/ent/entc/integration/migrate/entv1/conversion"
	"github.com/facebook/ent/entc/integration/migrate/entv1/predicate"
	"github.com/facebook/ent/schema/field"
)

// ConversionUpdate is the builder for updating Conversion entities.
type ConversionUpdate struct {
	config
	hooks    []Hook
	mutation *ConversionMutation
}

// Where adds a new predicate for the builder.
func (cu *ConversionUpdate) Where(ps ...predicate.Conversion) *ConversionUpdate {
	cu.mutation.predicates = append(cu.mutation.predicates, ps...)
	return cu
}

// SetName sets the name field.
func (cu *ConversionUpdate) SetName(s string) *ConversionUpdate {
	cu.mutation.SetName(s)
	return cu
}

// SetNillableName sets the name field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableName(s *string) *ConversionUpdate {
	if s != nil {
		cu.SetName(*s)
	}
	return cu
}

// ClearName clears the value of name.
func (cu *ConversionUpdate) ClearName() *ConversionUpdate {
	cu.mutation.ClearName()
	return cu
}

// SetInt8ToString sets the int8_to_string field.
func (cu *ConversionUpdate) SetInt8ToString(i int8) *ConversionUpdate {
	cu.mutation.ResetInt8ToString()
	cu.mutation.SetInt8ToString(i)
	return cu
}

// SetNillableInt8ToString sets the int8_to_string field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableInt8ToString(i *int8) *ConversionUpdate {
	if i != nil {
		cu.SetInt8ToString(*i)
	}
	return cu
}

// AddInt8ToString adds i to int8_to_string.
func (cu *ConversionUpdate) AddInt8ToString(i int8) *ConversionUpdate {
	cu.mutation.AddInt8ToString(i)
	return cu
}

// ClearInt8ToString clears the value of int8_to_string.
func (cu *ConversionUpdate) ClearInt8ToString() *ConversionUpdate {
	cu.mutation.ClearInt8ToString()
	return cu
}

// SetUint8ToString sets the uint8_to_string field.
func (cu *ConversionUpdate) SetUint8ToString(u uint8) *ConversionUpdate {
	cu.mutation.ResetUint8ToString()
	cu.mutation.SetUint8ToString(u)
	return cu
}

// SetNillableUint8ToString sets the uint8_to_string field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableUint8ToString(u *uint8) *ConversionUpdate {
	if u != nil {
		cu.SetUint8ToString(*u)
	}
	return cu
}

// AddUint8ToString adds u to uint8_to_string.
func (cu *ConversionUpdate) AddUint8ToString(u uint8) *ConversionUpdate {
	cu.mutation.AddUint8ToString(u)
	return cu
}

// ClearUint8ToString clears the value of uint8_to_string.
func (cu *ConversionUpdate) ClearUint8ToString() *ConversionUpdate {
	cu.mutation.ClearUint8ToString()
	return cu
}

// SetInt16ToString sets the int16_to_string field.
func (cu *ConversionUpdate) SetInt16ToString(i int16) *ConversionUpdate {
	cu.mutation.ResetInt16ToString()
	cu.mutation.SetInt16ToString(i)
	return cu
}

// SetNillableInt16ToString sets the int16_to_string field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableInt16ToString(i *int16) *ConversionUpdate {
	if i != nil {
		cu.SetInt16ToString(*i)
	}
	return cu
}

// AddInt16ToString adds i to int16_to_string.
func (cu *ConversionUpdate) AddInt16ToString(i int16) *ConversionUpdate {
	cu.mutation.AddInt16ToString(i)
	return cu
}

// ClearInt16ToString clears the value of int16_to_string.
func (cu *ConversionUpdate) ClearInt16ToString() *ConversionUpdate {
	cu.mutation.ClearInt16ToString()
	return cu
}

// SetUint16ToString sets the uint16_to_string field.
func (cu *ConversionUpdate) SetUint16ToString(u uint16) *ConversionUpdate {
	cu.mutation.ResetUint16ToString()
	cu.mutation.SetUint16ToString(u)
	return cu
}

// SetNillableUint16ToString sets the uint16_to_string field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableUint16ToString(u *uint16) *ConversionUpdate {
	if u != nil {
		cu.SetUint16ToString(*u)
	}
	return cu
}

// AddUint16ToString adds u to uint16_to_string.
func (cu *ConversionUpdate) AddUint16ToString(u uint16) *ConversionUpdate {
	cu.mutation.AddUint16ToString(u)
	return cu
}

// ClearUint16ToString clears the value of uint16_to_string.
func (cu *ConversionUpdate) ClearUint16ToString() *ConversionUpdate {
	cu.mutation.ClearUint16ToString()
	return cu
}

// SetInt32ToString sets the int32_to_string field.
func (cu *ConversionUpdate) SetInt32ToString(i int32) *ConversionUpdate {
	cu.mutation.ResetInt32ToString()
	cu.mutation.SetInt32ToString(i)
	return cu
}

// SetNillableInt32ToString sets the int32_to_string field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableInt32ToString(i *int32) *ConversionUpdate {
	if i != nil {
		cu.SetInt32ToString(*i)
	}
	return cu
}

// AddInt32ToString adds i to int32_to_string.
func (cu *ConversionUpdate) AddInt32ToString(i int32) *ConversionUpdate {
	cu.mutation.AddInt32ToString(i)
	return cu
}

// ClearInt32ToString clears the value of int32_to_string.
func (cu *ConversionUpdate) ClearInt32ToString() *ConversionUpdate {
	cu.mutation.ClearInt32ToString()
	return cu
}

// SetUint32ToString sets the uint32_to_string field.
func (cu *ConversionUpdate) SetUint32ToString(u uint32) *ConversionUpdate {
	cu.mutation.ResetUint32ToString()
	cu.mutation.SetUint32ToString(u)
	return cu
}

// SetNillableUint32ToString sets the uint32_to_string field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableUint32ToString(u *uint32) *ConversionUpdate {
	if u != nil {
		cu.SetUint32ToString(*u)
	}
	return cu
}

// AddUint32ToString adds u to uint32_to_string.
func (cu *ConversionUpdate) AddUint32ToString(u uint32) *ConversionUpdate {
	cu.mutation.AddUint32ToString(u)
	return cu
}

// ClearUint32ToString clears the value of uint32_to_string.
func (cu *ConversionUpdate) ClearUint32ToString() *ConversionUpdate {
	cu.mutation.ClearUint32ToString()
	return cu
}

// SetInt64ToString sets the int64_to_string field.
func (cu *ConversionUpdate) SetInt64ToString(i int64) *ConversionUpdate {
	cu.mutation.ResetInt64ToString()
	cu.mutation.SetInt64ToString(i)
	return cu
}

// SetNillableInt64ToString sets the int64_to_string field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableInt64ToString(i *int64) *ConversionUpdate {
	if i != nil {
		cu.SetInt64ToString(*i)
	}
	return cu
}

// AddInt64ToString adds i to int64_to_string.
func (cu *ConversionUpdate) AddInt64ToString(i int64) *ConversionUpdate {
	cu.mutation.AddInt64ToString(i)
	return cu
}

// ClearInt64ToString clears the value of int64_to_string.
func (cu *ConversionUpdate) ClearInt64ToString() *ConversionUpdate {
	cu.mutation.ClearInt64ToString()
	return cu
}

// SetUint64ToString sets the uint64_to_string field.
func (cu *ConversionUpdate) SetUint64ToString(u uint64) *ConversionUpdate {
	cu.mutation.ResetUint64ToString()
	cu.mutation.SetUint64ToString(u)
	return cu
}

// SetNillableUint64ToString sets the uint64_to_string field if the given value is not nil.
func (cu *ConversionUpdate) SetNillableUint64ToString(u *uint64) *ConversionUpdate {
	if u != nil {
		cu.SetUint64ToString(*u)
	}
	return cu
}

// AddUint64ToString adds u to uint64_to_string.
func (cu *ConversionUpdate) AddUint64ToString(u uint64) *ConversionUpdate {
	cu.mutation.AddUint64ToString(u)
	return cu
}

// ClearUint64ToString clears the value of uint64_to_string.
func (cu *ConversionUpdate) ClearUint64ToString() *ConversionUpdate {
	cu.mutation.ClearUint64ToString()
	return cu
}

// Mutation returns the ConversionMutation object of the builder.
func (cu *ConversionUpdate) Mutation() *ConversionMutation {
	return cu.mutation
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (cu *ConversionUpdate) Save(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(cu.hooks) == 0 {
		affected, err = cu.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*ConversionMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			cu.mutation = mutation
			affected, err = cu.sqlSave(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(cu.hooks) - 1; i >= 0; i-- {
			mut = cu.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, cu.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// SaveX is like Save, but panics if an error occurs.
func (cu *ConversionUpdate) SaveX(ctx context.Context) int {
	affected, err := cu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (cu *ConversionUpdate) Exec(ctx context.Context) error {
	_, err := cu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (cu *ConversionUpdate) ExecX(ctx context.Context) {
	if err := cu.Exec(ctx); err != nil {
		panic(err)
	}
}

func (cu *ConversionUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   conversion.Table,
			Columns: conversion.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: conversion.FieldID,
			},
		},
	}
	if ps := cu.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := cu.mutation.Name(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: conversion.FieldName,
		})
	}
	if cu.mutation.NameCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: conversion.FieldName,
		})
	}
	if value, ok := cu.mutation.Int8ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt8,
			Value:  value,
			Column: conversion.FieldInt8ToString,
		})
	}
	if value, ok := cu.mutation.AddedInt8ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt8,
			Value:  value,
			Column: conversion.FieldInt8ToString,
		})
	}
	if cu.mutation.Int8ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt8,
			Column: conversion.FieldInt8ToString,
		})
	}
	if value, ok := cu.mutation.Uint8ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeUint8,
			Value:  value,
			Column: conversion.FieldUint8ToString,
		})
	}
	if value, ok := cu.mutation.AddedUint8ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeUint8,
			Value:  value,
			Column: conversion.FieldUint8ToString,
		})
	}
	if cu.mutation.Uint8ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeUint8,
			Column: conversion.FieldUint8ToString,
		})
	}
	if value, ok := cu.mutation.Int16ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt16,
			Value:  value,
			Column: conversion.FieldInt16ToString,
		})
	}
	if value, ok := cu.mutation.AddedInt16ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt16,
			Value:  value,
			Column: conversion.FieldInt16ToString,
		})
	}
	if cu.mutation.Int16ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt16,
			Column: conversion.FieldInt16ToString,
		})
	}
	if value, ok := cu.mutation.Uint16ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeUint16,
			Value:  value,
			Column: conversion.FieldUint16ToString,
		})
	}
	if value, ok := cu.mutation.AddedUint16ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeUint16,
			Value:  value,
			Column: conversion.FieldUint16ToString,
		})
	}
	if cu.mutation.Uint16ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeUint16,
			Column: conversion.FieldUint16ToString,
		})
	}
	if value, ok := cu.mutation.Int32ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: conversion.FieldInt32ToString,
		})
	}
	if value, ok := cu.mutation.AddedInt32ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: conversion.FieldInt32ToString,
		})
	}
	if cu.mutation.Int32ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Column: conversion.FieldInt32ToString,
		})
	}
	if value, ok := cu.mutation.Uint32ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeUint32,
			Value:  value,
			Column: conversion.FieldUint32ToString,
		})
	}
	if value, ok := cu.mutation.AddedUint32ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeUint32,
			Value:  value,
			Column: conversion.FieldUint32ToString,
		})
	}
	if cu.mutation.Uint32ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeUint32,
			Column: conversion.FieldUint32ToString,
		})
	}
	if value, ok := cu.mutation.Int64ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt64,
			Value:  value,
			Column: conversion.FieldInt64ToString,
		})
	}
	if value, ok := cu.mutation.AddedInt64ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt64,
			Value:  value,
			Column: conversion.FieldInt64ToString,
		})
	}
	if cu.mutation.Int64ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt64,
			Column: conversion.FieldInt64ToString,
		})
	}
	if value, ok := cu.mutation.Uint64ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeUint64,
			Value:  value,
			Column: conversion.FieldUint64ToString,
		})
	}
	if value, ok := cu.mutation.AddedUint64ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeUint64,
			Value:  value,
			Column: conversion.FieldUint64ToString,
		})
	}
	if cu.mutation.Uint64ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeUint64,
			Column: conversion.FieldUint64ToString,
		})
	}
	if n, err = sqlgraph.UpdateNodes(ctx, cu.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{conversion.Label}
		} else if cerr, ok := isSQLConstraintError(err); ok {
			err = cerr
		}
		return 0, err
	}
	return n, nil
}

// ConversionUpdateOne is the builder for updating a single Conversion entity.
type ConversionUpdateOne struct {
	config
	hooks    []Hook
	mutation *ConversionMutation
}

// SetName sets the name field.
func (cuo *ConversionUpdateOne) SetName(s string) *ConversionUpdateOne {
	cuo.mutation.SetName(s)
	return cuo
}

// SetNillableName sets the name field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableName(s *string) *ConversionUpdateOne {
	if s != nil {
		cuo.SetName(*s)
	}
	return cuo
}

// ClearName clears the value of name.
func (cuo *ConversionUpdateOne) ClearName() *ConversionUpdateOne {
	cuo.mutation.ClearName()
	return cuo
}

// SetInt8ToString sets the int8_to_string field.
func (cuo *ConversionUpdateOne) SetInt8ToString(i int8) *ConversionUpdateOne {
	cuo.mutation.ResetInt8ToString()
	cuo.mutation.SetInt8ToString(i)
	return cuo
}

// SetNillableInt8ToString sets the int8_to_string field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableInt8ToString(i *int8) *ConversionUpdateOne {
	if i != nil {
		cuo.SetInt8ToString(*i)
	}
	return cuo
}

// AddInt8ToString adds i to int8_to_string.
func (cuo *ConversionUpdateOne) AddInt8ToString(i int8) *ConversionUpdateOne {
	cuo.mutation.AddInt8ToString(i)
	return cuo
}

// ClearInt8ToString clears the value of int8_to_string.
func (cuo *ConversionUpdateOne) ClearInt8ToString() *ConversionUpdateOne {
	cuo.mutation.ClearInt8ToString()
	return cuo
}

// SetUint8ToString sets the uint8_to_string field.
func (cuo *ConversionUpdateOne) SetUint8ToString(u uint8) *ConversionUpdateOne {
	cuo.mutation.ResetUint8ToString()
	cuo.mutation.SetUint8ToString(u)
	return cuo
}

// SetNillableUint8ToString sets the uint8_to_string field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableUint8ToString(u *uint8) *ConversionUpdateOne {
	if u != nil {
		cuo.SetUint8ToString(*u)
	}
	return cuo
}

// AddUint8ToString adds u to uint8_to_string.
func (cuo *ConversionUpdateOne) AddUint8ToString(u uint8) *ConversionUpdateOne {
	cuo.mutation.AddUint8ToString(u)
	return cuo
}

// ClearUint8ToString clears the value of uint8_to_string.
func (cuo *ConversionUpdateOne) ClearUint8ToString() *ConversionUpdateOne {
	cuo.mutation.ClearUint8ToString()
	return cuo
}

// SetInt16ToString sets the int16_to_string field.
func (cuo *ConversionUpdateOne) SetInt16ToString(i int16) *ConversionUpdateOne {
	cuo.mutation.ResetInt16ToString()
	cuo.mutation.SetInt16ToString(i)
	return cuo
}

// SetNillableInt16ToString sets the int16_to_string field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableInt16ToString(i *int16) *ConversionUpdateOne {
	if i != nil {
		cuo.SetInt16ToString(*i)
	}
	return cuo
}

// AddInt16ToString adds i to int16_to_string.
func (cuo *ConversionUpdateOne) AddInt16ToString(i int16) *ConversionUpdateOne {
	cuo.mutation.AddInt16ToString(i)
	return cuo
}

// ClearInt16ToString clears the value of int16_to_string.
func (cuo *ConversionUpdateOne) ClearInt16ToString() *ConversionUpdateOne {
	cuo.mutation.ClearInt16ToString()
	return cuo
}

// SetUint16ToString sets the uint16_to_string field.
func (cuo *ConversionUpdateOne) SetUint16ToString(u uint16) *ConversionUpdateOne {
	cuo.mutation.ResetUint16ToString()
	cuo.mutation.SetUint16ToString(u)
	return cuo
}

// SetNillableUint16ToString sets the uint16_to_string field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableUint16ToString(u *uint16) *ConversionUpdateOne {
	if u != nil {
		cuo.SetUint16ToString(*u)
	}
	return cuo
}

// AddUint16ToString adds u to uint16_to_string.
func (cuo *ConversionUpdateOne) AddUint16ToString(u uint16) *ConversionUpdateOne {
	cuo.mutation.AddUint16ToString(u)
	return cuo
}

// ClearUint16ToString clears the value of uint16_to_string.
func (cuo *ConversionUpdateOne) ClearUint16ToString() *ConversionUpdateOne {
	cuo.mutation.ClearUint16ToString()
	return cuo
}

// SetInt32ToString sets the int32_to_string field.
func (cuo *ConversionUpdateOne) SetInt32ToString(i int32) *ConversionUpdateOne {
	cuo.mutation.ResetInt32ToString()
	cuo.mutation.SetInt32ToString(i)
	return cuo
}

// SetNillableInt32ToString sets the int32_to_string field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableInt32ToString(i *int32) *ConversionUpdateOne {
	if i != nil {
		cuo.SetInt32ToString(*i)
	}
	return cuo
}

// AddInt32ToString adds i to int32_to_string.
func (cuo *ConversionUpdateOne) AddInt32ToString(i int32) *ConversionUpdateOne {
	cuo.mutation.AddInt32ToString(i)
	return cuo
}

// ClearInt32ToString clears the value of int32_to_string.
func (cuo *ConversionUpdateOne) ClearInt32ToString() *ConversionUpdateOne {
	cuo.mutation.ClearInt32ToString()
	return cuo
}

// SetUint32ToString sets the uint32_to_string field.
func (cuo *ConversionUpdateOne) SetUint32ToString(u uint32) *ConversionUpdateOne {
	cuo.mutation.ResetUint32ToString()
	cuo.mutation.SetUint32ToString(u)
	return cuo
}

// SetNillableUint32ToString sets the uint32_to_string field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableUint32ToString(u *uint32) *ConversionUpdateOne {
	if u != nil {
		cuo.SetUint32ToString(*u)
	}
	return cuo
}

// AddUint32ToString adds u to uint32_to_string.
func (cuo *ConversionUpdateOne) AddUint32ToString(u uint32) *ConversionUpdateOne {
	cuo.mutation.AddUint32ToString(u)
	return cuo
}

// ClearUint32ToString clears the value of uint32_to_string.
func (cuo *ConversionUpdateOne) ClearUint32ToString() *ConversionUpdateOne {
	cuo.mutation.ClearUint32ToString()
	return cuo
}

// SetInt64ToString sets the int64_to_string field.
func (cuo *ConversionUpdateOne) SetInt64ToString(i int64) *ConversionUpdateOne {
	cuo.mutation.ResetInt64ToString()
	cuo.mutation.SetInt64ToString(i)
	return cuo
}

// SetNillableInt64ToString sets the int64_to_string field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableInt64ToString(i *int64) *ConversionUpdateOne {
	if i != nil {
		cuo.SetInt64ToString(*i)
	}
	return cuo
}

// AddInt64ToString adds i to int64_to_string.
func (cuo *ConversionUpdateOne) AddInt64ToString(i int64) *ConversionUpdateOne {
	cuo.mutation.AddInt64ToString(i)
	return cuo
}

// ClearInt64ToString clears the value of int64_to_string.
func (cuo *ConversionUpdateOne) ClearInt64ToString() *ConversionUpdateOne {
	cuo.mutation.ClearInt64ToString()
	return cuo
}

// SetUint64ToString sets the uint64_to_string field.
func (cuo *ConversionUpdateOne) SetUint64ToString(u uint64) *ConversionUpdateOne {
	cuo.mutation.ResetUint64ToString()
	cuo.mutation.SetUint64ToString(u)
	return cuo
}

// SetNillableUint64ToString sets the uint64_to_string field if the given value is not nil.
func (cuo *ConversionUpdateOne) SetNillableUint64ToString(u *uint64) *ConversionUpdateOne {
	if u != nil {
		cuo.SetUint64ToString(*u)
	}
	return cuo
}

// AddUint64ToString adds u to uint64_to_string.
func (cuo *ConversionUpdateOne) AddUint64ToString(u uint64) *ConversionUpdateOne {
	cuo.mutation.AddUint64ToString(u)
	return cuo
}

// ClearUint64ToString clears the value of uint64_to_string.
func (cuo *ConversionUpdateOne) ClearUint64ToString() *ConversionUpdateOne {
	cuo.mutation.ClearUint64ToString()
	return cuo
}

// Mutation returns the ConversionMutation object of the builder.
func (cuo *ConversionUpdateOne) Mutation() *ConversionMutation {
	return cuo.mutation
}

// Save executes the query and returns the updated entity.
func (cuo *ConversionUpdateOne) Save(ctx context.Context) (*Conversion, error) {
	var (
		err  error
		node *Conversion
	)
	if len(cuo.hooks) == 0 {
		node, err = cuo.sqlSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*ConversionMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			cuo.mutation = mutation
			node, err = cuo.sqlSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(cuo.hooks) - 1; i >= 0; i-- {
			mut = cuo.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, cuo.mutation); err != nil {
			return nil, err
		}
	}
	return node, err
}

// SaveX is like Save, but panics if an error occurs.
func (cuo *ConversionUpdateOne) SaveX(ctx context.Context) *Conversion {
	node, err := cuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (cuo *ConversionUpdateOne) Exec(ctx context.Context) error {
	_, err := cuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (cuo *ConversionUpdateOne) ExecX(ctx context.Context) {
	if err := cuo.Exec(ctx); err != nil {
		panic(err)
	}
}

func (cuo *ConversionUpdateOne) sqlSave(ctx context.Context) (_node *Conversion, err error) {
	_spec := &sqlgraph.UpdateSpec{
		Node: &sqlgraph.NodeSpec{
			Table:   conversion.Table,
			Columns: conversion.Columns,
			ID: &sqlgraph.FieldSpec{
				Type:   field.TypeInt,
				Column: conversion.FieldID,
			},
		},
	}
	id, ok := cuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "ID", err: fmt.Errorf("missing Conversion.ID for update")}
	}
	_spec.Node.ID.Value = id
	if value, ok := cuo.mutation.Name(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Value:  value,
			Column: conversion.FieldName,
		})
	}
	if cuo.mutation.NameCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeString,
			Column: conversion.FieldName,
		})
	}
	if value, ok := cuo.mutation.Int8ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt8,
			Value:  value,
			Column: conversion.FieldInt8ToString,
		})
	}
	if value, ok := cuo.mutation.AddedInt8ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt8,
			Value:  value,
			Column: conversion.FieldInt8ToString,
		})
	}
	if cuo.mutation.Int8ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt8,
			Column: conversion.FieldInt8ToString,
		})
	}
	if value, ok := cuo.mutation.Uint8ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeUint8,
			Value:  value,
			Column: conversion.FieldUint8ToString,
		})
	}
	if value, ok := cuo.mutation.AddedUint8ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeUint8,
			Value:  value,
			Column: conversion.FieldUint8ToString,
		})
	}
	if cuo.mutation.Uint8ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeUint8,
			Column: conversion.FieldUint8ToString,
		})
	}
	if value, ok := cuo.mutation.Int16ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt16,
			Value:  value,
			Column: conversion.FieldInt16ToString,
		})
	}
	if value, ok := cuo.mutation.AddedInt16ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt16,
			Value:  value,
			Column: conversion.FieldInt16ToString,
		})
	}
	if cuo.mutation.Int16ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt16,
			Column: conversion.FieldInt16ToString,
		})
	}
	if value, ok := cuo.mutation.Uint16ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeUint16,
			Value:  value,
			Column: conversion.FieldUint16ToString,
		})
	}
	if value, ok := cuo.mutation.AddedUint16ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeUint16,
			Value:  value,
			Column: conversion.FieldUint16ToString,
		})
	}
	if cuo.mutation.Uint16ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeUint16,
			Column: conversion.FieldUint16ToString,
		})
	}
	if value, ok := cuo.mutation.Int32ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: conversion.FieldInt32ToString,
		})
	}
	if value, ok := cuo.mutation.AddedInt32ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Value:  value,
			Column: conversion.FieldInt32ToString,
		})
	}
	if cuo.mutation.Int32ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt32,
			Column: conversion.FieldInt32ToString,
		})
	}
	if value, ok := cuo.mutation.Uint32ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeUint32,
			Value:  value,
			Column: conversion.FieldUint32ToString,
		})
	}
	if value, ok := cuo.mutation.AddedUint32ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeUint32,
			Value:  value,
			Column: conversion.FieldUint32ToString,
		})
	}
	if cuo.mutation.Uint32ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeUint32,
			Column: conversion.FieldUint32ToString,
		})
	}
	if value, ok := cuo.mutation.Int64ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeInt64,
			Value:  value,
			Column: conversion.FieldInt64ToString,
		})
	}
	if value, ok := cuo.mutation.AddedInt64ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeInt64,
			Value:  value,
			Column: conversion.FieldInt64ToString,
		})
	}
	if cuo.mutation.Int64ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeInt64,
			Column: conversion.FieldInt64ToString,
		})
	}
	if value, ok := cuo.mutation.Uint64ToString(); ok {
		_spec.Fields.Set = append(_spec.Fields.Set, &sqlgraph.FieldSpec{
			Type:   field.TypeUint64,
			Value:  value,
			Column: conversion.FieldUint64ToString,
		})
	}
	if value, ok := cuo.mutation.AddedUint64ToString(); ok {
		_spec.Fields.Add = append(_spec.Fields.Add, &sqlgraph.FieldSpec{
			Type:   field.TypeUint64,
			Value:  value,
			Column: conversion.FieldUint64ToString,
		})
	}
	if cuo.mutation.Uint64ToStringCleared() {
		_spec.Fields.Clear = append(_spec.Fields.Clear, &sqlgraph.FieldSpec{
			Type:   field.TypeUint64,
			Column: conversion.FieldUint64ToString,
		})
	}
	_node = &Conversion{config: cuo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues()
	if err = sqlgraph.UpdateNode(ctx, cuo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{conversion.Label}
		} else if cerr, ok := isSQLConstraintError(err); ok {
			err = cerr
		}
		return nil, err
	}
	return _node, nil
}
