// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package entv1

import (
	"fmt"
	"strings"

	"github.com/facebook/ent/dialect/sql"
	"github.com/facebook/ent/entc/integration/migrate/entv1/conversion"
)

// Conversion is the model entity for the Conversion schema.
type Conversion struct {
	config `json:"-"`
	// ID of the ent.
	ID int `json:"id,omitempty"`
	// Name holds the value of the "name" field.
	Name string `json:"name,omitempty"`
	// Int8ToString holds the value of the "int8_to_string" field.
	Int8ToString int8 `json:"int8_to_string,omitempty"`
	// Uint8ToString holds the value of the "uint8_to_string" field.
	Uint8ToString uint8 `json:"uint8_to_string,omitempty"`
	// Int16ToString holds the value of the "int16_to_string" field.
	Int16ToString int16 `json:"int16_to_string,omitempty"`
	// Uint16ToString holds the value of the "uint16_to_string" field.
	Uint16ToString uint16 `json:"uint16_to_string,omitempty"`
	// Int32ToString holds the value of the "int32_to_string" field.
	Int32ToString int32 `json:"int32_to_string,omitempty"`
	// Uint32ToString holds the value of the "uint32_to_string" field.
	Uint32ToString uint32 `json:"uint32_to_string,omitempty"`
	// Int64ToString holds the value of the "int64_to_string" field.
	Int64ToString int64 `json:"int64_to_string,omitempty"`
	// Uint64ToString holds the value of the "uint64_to_string" field.
	Uint64ToString uint64 `json:"uint64_to_string,omitempty"`
}

// scanValues returns the types for scanning values from sql.Rows.
func (*Conversion) scanValues() []interface{} {
	return []interface{}{
		&sql.NullInt64{},  // id
		&sql.NullString{}, // name
		&sql.NullInt64{},  // int8_to_string
		&sql.NullInt64{},  // uint8_to_string
		&sql.NullInt64{},  // int16_to_string
		&sql.NullInt64{},  // uint16_to_string
		&sql.NullInt64{},  // int32_to_string
		&sql.NullInt64{},  // uint32_to_string
		&sql.NullInt64{},  // int64_to_string
		&sql.NullInt64{},  // uint64_to_string
	}
}

// assignValues assigns the values that were returned from sql.Rows (after scanning)
// to the Conversion fields.
func (c *Conversion) assignValues(values ...interface{}) error {
	if m, n := len(values), len(conversion.Columns); m < n {
		return fmt.Errorf("mismatch number of scan values: %d != %d", m, n)
	}
	value, ok := values[0].(*sql.NullInt64)
	if !ok {
		return fmt.Errorf("unexpected type %T for field id", value)
	}
	c.ID = int(value.Int64)
	values = values[1:]
	if value, ok := values[0].(*sql.NullString); !ok {
		return fmt.Errorf("unexpected type %T for field name", values[0])
	} else if value.Valid {
		c.Name = value.String
	}
	if value, ok := values[1].(*sql.NullInt64); !ok {
		return fmt.Errorf("unexpected type %T for field int8_to_string", values[1])
	} else if value.Valid {
		c.Int8ToString = int8(value.Int64)
	}
	if value, ok := values[2].(*sql.NullInt64); !ok {
		return fmt.Errorf("unexpected type %T for field uint8_to_string", values[2])
	} else if value.Valid {
		c.Uint8ToString = uint8(value.Int64)
	}
	if value, ok := values[3].(*sql.NullInt64); !ok {
		return fmt.Errorf("unexpected type %T for field int16_to_string", values[3])
	} else if value.Valid {
		c.Int16ToString = int16(value.Int64)
	}
	if value, ok := values[4].(*sql.NullInt64); !ok {
		return fmt.Errorf("unexpected type %T for field uint16_to_string", values[4])
	} else if value.Valid {
		c.Uint16ToString = uint16(value.Int64)
	}
	if value, ok := values[5].(*sql.NullInt64); !ok {
		return fmt.Errorf("unexpected type %T for field int32_to_string", values[5])
	} else if value.Valid {
		c.Int32ToString = int32(value.Int64)
	}
	if value, ok := values[6].(*sql.NullInt64); !ok {
		return fmt.Errorf("unexpected type %T for field uint32_to_string", values[6])
	} else if value.Valid {
		c.Uint32ToString = uint32(value.Int64)
	}
	if value, ok := values[7].(*sql.NullInt64); !ok {
		return fmt.Errorf("unexpected type %T for field int64_to_string", values[7])
	} else if value.Valid {
		c.Int64ToString = value.Int64
	}
	if value, ok := values[8].(*sql.NullInt64); !ok {
		return fmt.Errorf("unexpected type %T for field uint64_to_string", values[8])
	} else if value.Valid {
		c.Uint64ToString = uint64(value.Int64)
	}
	return nil
}

// Update returns a builder for updating this Conversion.
// Note that, you need to call Conversion.Unwrap() before calling this method, if this Conversion
// was returned from a transaction, and the transaction was committed or rolled back.
func (c *Conversion) Update() *ConversionUpdateOne {
	return (&ConversionClient{config: c.config}).UpdateOne(c)
}

// Unwrap unwraps the entity that was returned from a transaction after it was closed,
// so that all next queries will be executed through the driver which created the transaction.
func (c *Conversion) Unwrap() *Conversion {
	tx, ok := c.config.driver.(*txDriver)
	if !ok {
		panic("entv1: Conversion is not a transactional entity")
	}
	c.config.driver = tx.drv
	return c
}

// String implements the fmt.Stringer.
func (c *Conversion) String() string {
	var builder strings.Builder
	builder.WriteString("Conversion(")
	builder.WriteString(fmt.Sprintf("id=%v", c.ID))
	builder.WriteString(", name=")
	builder.WriteString(c.Name)
	builder.WriteString(", int8_to_string=")
	builder.WriteString(fmt.Sprintf("%v", c.Int8ToString))
	builder.WriteString(", uint8_to_string=")
	builder.WriteString(fmt.Sprintf("%v", c.Uint8ToString))
	builder.WriteString(", int16_to_string=")
	builder.WriteString(fmt.Sprintf("%v", c.Int16ToString))
	builder.WriteString(", uint16_to_string=")
	builder.WriteString(fmt.Sprintf("%v", c.Uint16ToString))
	builder.WriteString(", int32_to_string=")
	builder.WriteString(fmt.Sprintf("%v", c.Int32ToString))
	builder.WriteString(", uint32_to_string=")
	builder.WriteString(fmt.Sprintf("%v", c.Uint32ToString))
	builder.WriteString(", int64_to_string=")
	builder.WriteString(fmt.Sprintf("%v", c.Int64ToString))
	builder.WriteString(", uint64_to_string=")
	builder.WriteString(fmt.Sprintf("%v", c.Uint64ToString))
	builder.WriteByte(')')
	return builder.String()
}

// Conversions is a parsable slice of Conversion.
type Conversions []*Conversion

func (c Conversions) config(cfg config) {
	for _i := range c {
		c[_i].config = cfg
	}
}
