// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"context"
	"fmt"

	"github.com/facebook/ent/dialect/gremlin"
	"github.com/facebook/ent/dialect/gremlin/graph/dsl"
	"github.com/facebook/ent/dialect/gremlin/graph/dsl/__"
	"github.com/facebook/ent/dialect/gremlin/graph/dsl/g"
	"github.com/facebook/ent/dialect/gremlin/graph/dsl/p"
	"github.com/facebook/ent/entc/integration/gremlin/ent/predicate"
	"github.com/facebook/ent/entc/integration/gremlin/ent/user"
)

// UserUpdate is the builder for updating User entities.
type UserUpdate struct {
	config
	hooks    []Hook
	mutation *UserMutation
}

// Where adds a new predicate for the builder.
func (uu *UserUpdate) Where(ps ...predicate.User) *UserUpdate {
	uu.mutation.predicates = append(uu.mutation.predicates, ps...)
	return uu
}

// SetOptionalInt sets the optional_int field.
func (uu *UserUpdate) SetOptionalInt(i int) *UserUpdate {
	uu.mutation.ResetOptionalInt()
	uu.mutation.SetOptionalInt(i)
	return uu
}

// SetNillableOptionalInt sets the optional_int field if the given value is not nil.
func (uu *UserUpdate) SetNillableOptionalInt(i *int) *UserUpdate {
	if i != nil {
		uu.SetOptionalInt(*i)
	}
	return uu
}

// AddOptionalInt adds i to optional_int.
func (uu *UserUpdate) AddOptionalInt(i int) *UserUpdate {
	uu.mutation.AddOptionalInt(i)
	return uu
}

// ClearOptionalInt clears the value of optional_int.
func (uu *UserUpdate) ClearOptionalInt() *UserUpdate {
	uu.mutation.ClearOptionalInt()
	return uu
}

// SetAge sets the age field.
func (uu *UserUpdate) SetAge(i int) *UserUpdate {
	uu.mutation.ResetAge()
	uu.mutation.SetAge(i)
	return uu
}

// AddAge adds i to age.
func (uu *UserUpdate) AddAge(i int) *UserUpdate {
	uu.mutation.AddAge(i)
	return uu
}

// SetName sets the name field.
func (uu *UserUpdate) SetName(s string) *UserUpdate {
	uu.mutation.SetName(s)
	return uu
}

// SetLast sets the last field.
func (uu *UserUpdate) SetLast(s string) *UserUpdate {
	uu.mutation.SetLast(s)
	return uu
}

// SetNillableLast sets the last field if the given value is not nil.
func (uu *UserUpdate) SetNillableLast(s *string) *UserUpdate {
	if s != nil {
		uu.SetLast(*s)
	}
	return uu
}

// SetNickname sets the nickname field.
func (uu *UserUpdate) SetNickname(s string) *UserUpdate {
	uu.mutation.SetNickname(s)
	return uu
}

// SetNillableNickname sets the nickname field if the given value is not nil.
func (uu *UserUpdate) SetNillableNickname(s *string) *UserUpdate {
	if s != nil {
		uu.SetNickname(*s)
	}
	return uu
}

// ClearNickname clears the value of nickname.
func (uu *UserUpdate) ClearNickname() *UserUpdate {
	uu.mutation.ClearNickname()
	return uu
}

// SetPhone sets the phone field.
func (uu *UserUpdate) SetPhone(s string) *UserUpdate {
	uu.mutation.SetPhone(s)
	return uu
}

// SetNillablePhone sets the phone field if the given value is not nil.
func (uu *UserUpdate) SetNillablePhone(s *string) *UserUpdate {
	if s != nil {
		uu.SetPhone(*s)
	}
	return uu
}

// ClearPhone clears the value of phone.
func (uu *UserUpdate) ClearPhone() *UserUpdate {
	uu.mutation.ClearPhone()
	return uu
}

// SetPassword sets the password field.
func (uu *UserUpdate) SetPassword(s string) *UserUpdate {
	uu.mutation.SetPassword(s)
	return uu
}

// SetNillablePassword sets the password field if the given value is not nil.
func (uu *UserUpdate) SetNillablePassword(s *string) *UserUpdate {
	if s != nil {
		uu.SetPassword(*s)
	}
	return uu
}

// ClearPassword clears the value of password.
func (uu *UserUpdate) ClearPassword() *UserUpdate {
	uu.mutation.ClearPassword()
	return uu
}

// SetRole sets the role field.
func (uu *UserUpdate) SetRole(u user.Role) *UserUpdate {
	uu.mutation.SetRole(u)
	return uu
}

// SetNillableRole sets the role field if the given value is not nil.
func (uu *UserUpdate) SetNillableRole(u *user.Role) *UserUpdate {
	if u != nil {
		uu.SetRole(*u)
	}
	return uu
}

// SetSSOCert sets the SSOCert field.
func (uu *UserUpdate) SetSSOCert(s string) *UserUpdate {
	uu.mutation.SetSSOCert(s)
	return uu
}

// SetNillableSSOCert sets the SSOCert field if the given value is not nil.
func (uu *UserUpdate) SetNillableSSOCert(s *string) *UserUpdate {
	if s != nil {
		uu.SetSSOCert(*s)
	}
	return uu
}

// ClearSSOCert clears the value of SSOCert.
func (uu *UserUpdate) ClearSSOCert() *UserUpdate {
	uu.mutation.ClearSSOCert()
	return uu
}

// SetCardID sets the card edge to Card by id.
func (uu *UserUpdate) SetCardID(id string) *UserUpdate {
	uu.mutation.SetCardID(id)
	return uu
}

// SetNillableCardID sets the card edge to Card by id if the given value is not nil.
func (uu *UserUpdate) SetNillableCardID(id *string) *UserUpdate {
	if id != nil {
		uu = uu.SetCardID(*id)
	}
	return uu
}

// SetCard sets the card edge to Card.
func (uu *UserUpdate) SetCard(c *Card) *UserUpdate {
	return uu.SetCardID(c.ID)
}

// AddPetIDs adds the pets edge to Pet by ids.
func (uu *UserUpdate) AddPetIDs(ids ...string) *UserUpdate {
	uu.mutation.AddPetIDs(ids...)
	return uu
}

// AddPets adds the pets edges to Pet.
func (uu *UserUpdate) AddPets(p ...*Pet) *UserUpdate {
	ids := make([]string, len(p))
	for i := range p {
		ids[i] = p[i].ID
	}
	return uu.AddPetIDs(ids...)
}

// AddFileIDs adds the files edge to File by ids.
func (uu *UserUpdate) AddFileIDs(ids ...string) *UserUpdate {
	uu.mutation.AddFileIDs(ids...)
	return uu
}

// AddFiles adds the files edges to File.
func (uu *UserUpdate) AddFiles(f ...*File) *UserUpdate {
	ids := make([]string, len(f))
	for i := range f {
		ids[i] = f[i].ID
	}
	return uu.AddFileIDs(ids...)
}

// AddGroupIDs adds the groups edge to Group by ids.
func (uu *UserUpdate) AddGroupIDs(ids ...string) *UserUpdate {
	uu.mutation.AddGroupIDs(ids...)
	return uu
}

// AddGroups adds the groups edges to Group.
func (uu *UserUpdate) AddGroups(g ...*Group) *UserUpdate {
	ids := make([]string, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return uu.AddGroupIDs(ids...)
}

// AddFriendIDs adds the friends edge to User by ids.
func (uu *UserUpdate) AddFriendIDs(ids ...string) *UserUpdate {
	uu.mutation.AddFriendIDs(ids...)
	return uu
}

// AddFriends adds the friends edges to User.
func (uu *UserUpdate) AddFriends(u ...*User) *UserUpdate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uu.AddFriendIDs(ids...)
}

// AddFollowerIDs adds the followers edge to User by ids.
func (uu *UserUpdate) AddFollowerIDs(ids ...string) *UserUpdate {
	uu.mutation.AddFollowerIDs(ids...)
	return uu
}

// AddFollowers adds the followers edges to User.
func (uu *UserUpdate) AddFollowers(u ...*User) *UserUpdate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uu.AddFollowerIDs(ids...)
}

// AddFollowingIDs adds the following edge to User by ids.
func (uu *UserUpdate) AddFollowingIDs(ids ...string) *UserUpdate {
	uu.mutation.AddFollowingIDs(ids...)
	return uu
}

// AddFollowing adds the following edges to User.
func (uu *UserUpdate) AddFollowing(u ...*User) *UserUpdate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uu.AddFollowingIDs(ids...)
}

// SetTeamID sets the team edge to Pet by id.
func (uu *UserUpdate) SetTeamID(id string) *UserUpdate {
	uu.mutation.SetTeamID(id)
	return uu
}

// SetNillableTeamID sets the team edge to Pet by id if the given value is not nil.
func (uu *UserUpdate) SetNillableTeamID(id *string) *UserUpdate {
	if id != nil {
		uu = uu.SetTeamID(*id)
	}
	return uu
}

// SetTeam sets the team edge to Pet.
func (uu *UserUpdate) SetTeam(p *Pet) *UserUpdate {
	return uu.SetTeamID(p.ID)
}

// SetSpouseID sets the spouse edge to User by id.
func (uu *UserUpdate) SetSpouseID(id string) *UserUpdate {
	uu.mutation.SetSpouseID(id)
	return uu
}

// SetNillableSpouseID sets the spouse edge to User by id if the given value is not nil.
func (uu *UserUpdate) SetNillableSpouseID(id *string) *UserUpdate {
	if id != nil {
		uu = uu.SetSpouseID(*id)
	}
	return uu
}

// SetSpouse sets the spouse edge to User.
func (uu *UserUpdate) SetSpouse(u *User) *UserUpdate {
	return uu.SetSpouseID(u.ID)
}

// AddChildIDs adds the children edge to User by ids.
func (uu *UserUpdate) AddChildIDs(ids ...string) *UserUpdate {
	uu.mutation.AddChildIDs(ids...)
	return uu
}

// AddChildren adds the children edges to User.
func (uu *UserUpdate) AddChildren(u ...*User) *UserUpdate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uu.AddChildIDs(ids...)
}

// SetParentID sets the parent edge to User by id.
func (uu *UserUpdate) SetParentID(id string) *UserUpdate {
	uu.mutation.SetParentID(id)
	return uu
}

// SetNillableParentID sets the parent edge to User by id if the given value is not nil.
func (uu *UserUpdate) SetNillableParentID(id *string) *UserUpdate {
	if id != nil {
		uu = uu.SetParentID(*id)
	}
	return uu
}

// SetParent sets the parent edge to User.
func (uu *UserUpdate) SetParent(u *User) *UserUpdate {
	return uu.SetParentID(u.ID)
}

// Mutation returns the UserMutation object of the builder.
func (uu *UserUpdate) Mutation() *UserMutation {
	return uu.mutation
}

// ClearCard clears the "card" edge to type Card.
func (uu *UserUpdate) ClearCard() *UserUpdate {
	uu.mutation.ClearCard()
	return uu
}

// ClearPets clears all "pets" edges to type Pet.
func (uu *UserUpdate) ClearPets() *UserUpdate {
	uu.mutation.ClearPets()
	return uu
}

// RemovePetIDs removes the pets edge to Pet by ids.
func (uu *UserUpdate) RemovePetIDs(ids ...string) *UserUpdate {
	uu.mutation.RemovePetIDs(ids...)
	return uu
}

// RemovePets removes pets edges to Pet.
func (uu *UserUpdate) RemovePets(p ...*Pet) *UserUpdate {
	ids := make([]string, len(p))
	for i := range p {
		ids[i] = p[i].ID
	}
	return uu.RemovePetIDs(ids...)
}

// ClearFiles clears all "files" edges to type File.
func (uu *UserUpdate) ClearFiles() *UserUpdate {
	uu.mutation.ClearFiles()
	return uu
}

// RemoveFileIDs removes the files edge to File by ids.
func (uu *UserUpdate) RemoveFileIDs(ids ...string) *UserUpdate {
	uu.mutation.RemoveFileIDs(ids...)
	return uu
}

// RemoveFiles removes files edges to File.
func (uu *UserUpdate) RemoveFiles(f ...*File) *UserUpdate {
	ids := make([]string, len(f))
	for i := range f {
		ids[i] = f[i].ID
	}
	return uu.RemoveFileIDs(ids...)
}

// ClearGroups clears all "groups" edges to type Group.
func (uu *UserUpdate) ClearGroups() *UserUpdate {
	uu.mutation.ClearGroups()
	return uu
}

// RemoveGroupIDs removes the groups edge to Group by ids.
func (uu *UserUpdate) RemoveGroupIDs(ids ...string) *UserUpdate {
	uu.mutation.RemoveGroupIDs(ids...)
	return uu
}

// RemoveGroups removes groups edges to Group.
func (uu *UserUpdate) RemoveGroups(g ...*Group) *UserUpdate {
	ids := make([]string, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return uu.RemoveGroupIDs(ids...)
}

// ClearFriends clears all "friends" edges to type User.
func (uu *UserUpdate) ClearFriends() *UserUpdate {
	uu.mutation.ClearFriends()
	return uu
}

// RemoveFriendIDs removes the friends edge to User by ids.
func (uu *UserUpdate) RemoveFriendIDs(ids ...string) *UserUpdate {
	uu.mutation.RemoveFriendIDs(ids...)
	return uu
}

// RemoveFriends removes friends edges to User.
func (uu *UserUpdate) RemoveFriends(u ...*User) *UserUpdate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uu.RemoveFriendIDs(ids...)
}

// ClearFollowers clears all "followers" edges to type User.
func (uu *UserUpdate) ClearFollowers() *UserUpdate {
	uu.mutation.ClearFollowers()
	return uu
}

// RemoveFollowerIDs removes the followers edge to User by ids.
func (uu *UserUpdate) RemoveFollowerIDs(ids ...string) *UserUpdate {
	uu.mutation.RemoveFollowerIDs(ids...)
	return uu
}

// RemoveFollowers removes followers edges to User.
func (uu *UserUpdate) RemoveFollowers(u ...*User) *UserUpdate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uu.RemoveFollowerIDs(ids...)
}

// ClearFollowing clears all "following" edges to type User.
func (uu *UserUpdate) ClearFollowing() *UserUpdate {
	uu.mutation.ClearFollowing()
	return uu
}

// RemoveFollowingIDs removes the following edge to User by ids.
func (uu *UserUpdate) RemoveFollowingIDs(ids ...string) *UserUpdate {
	uu.mutation.RemoveFollowingIDs(ids...)
	return uu
}

// RemoveFollowing removes following edges to User.
func (uu *UserUpdate) RemoveFollowing(u ...*User) *UserUpdate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uu.RemoveFollowingIDs(ids...)
}

// ClearTeam clears the "team" edge to type Pet.
func (uu *UserUpdate) ClearTeam() *UserUpdate {
	uu.mutation.ClearTeam()
	return uu
}

// ClearSpouse clears the "spouse" edge to type User.
func (uu *UserUpdate) ClearSpouse() *UserUpdate {
	uu.mutation.ClearSpouse()
	return uu
}

// ClearChildren clears all "children" edges to type User.
func (uu *UserUpdate) ClearChildren() *UserUpdate {
	uu.mutation.ClearChildren()
	return uu
}

// RemoveChildIDs removes the children edge to User by ids.
func (uu *UserUpdate) RemoveChildIDs(ids ...string) *UserUpdate {
	uu.mutation.RemoveChildIDs(ids...)
	return uu
}

// RemoveChildren removes children edges to User.
func (uu *UserUpdate) RemoveChildren(u ...*User) *UserUpdate {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uu.RemoveChildIDs(ids...)
}

// ClearParent clears the "parent" edge to type User.
func (uu *UserUpdate) ClearParent() *UserUpdate {
	uu.mutation.ClearParent()
	return uu
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (uu *UserUpdate) Save(ctx context.Context) (int, error) {
	var (
		err      error
		affected int
	)
	if len(uu.hooks) == 0 {
		if err = uu.check(); err != nil {
			return 0, err
		}
		affected, err = uu.gremlinSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*UserMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = uu.check(); err != nil {
				return 0, err
			}
			uu.mutation = mutation
			affected, err = uu.gremlinSave(ctx)
			mutation.done = true
			return affected, err
		})
		for i := len(uu.hooks) - 1; i >= 0; i-- {
			mut = uu.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, uu.mutation); err != nil {
			return 0, err
		}
	}
	return affected, err
}

// SaveX is like Save, but panics if an error occurs.
func (uu *UserUpdate) SaveX(ctx context.Context) int {
	affected, err := uu.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (uu *UserUpdate) Exec(ctx context.Context) error {
	_, err := uu.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uu *UserUpdate) ExecX(ctx context.Context) {
	if err := uu.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (uu *UserUpdate) check() error {
	if v, ok := uu.mutation.OptionalInt(); ok {
		if err := user.OptionalIntValidator(v); err != nil {
			return &ValidationError{Name: "optional_int", err: fmt.Errorf("ent: validator failed for field \"optional_int\": %w", err)}
		}
	}
	if v, ok := uu.mutation.Role(); ok {
		if err := user.RoleValidator(v); err != nil {
			return &ValidationError{Name: "role", err: fmt.Errorf("ent: validator failed for field \"role\": %w", err)}
		}
	}
	return nil
}

func (uu *UserUpdate) gremlinSave(ctx context.Context) (int, error) {
	res := &gremlin.Response{}
	query, bindings := uu.gremlin().Query()
	if err := uu.driver.Exec(ctx, query, bindings, res); err != nil {
		return 0, err
	}
	if err, ok := isConstantError(res); ok {
		return 0, err
	}
	return res.ReadInt()
}

func (uu *UserUpdate) gremlin() *dsl.Traversal {
	type constraint struct {
		pred *dsl.Traversal // constraint predicate.
		test *dsl.Traversal // test matches and its constant.
	}
	constraints := make([]*constraint, 0, 8)
	v := g.V().HasLabel(user.Label)
	for _, p := range uu.mutation.predicates {
		p(v)
	}
	var (
		rv = v.Clone()
		_  = rv

		trs []*dsl.Traversal
	)
	if value, ok := uu.mutation.OptionalInt(); ok {
		v.Property(dsl.Single, user.FieldOptionalInt, value)
	}
	if value, ok := uu.mutation.AddedOptionalInt(); ok {
		v.Property(dsl.Single, user.FieldOptionalInt, __.Union(__.Values(user.FieldOptionalInt), __.Constant(value)).Sum())
	}
	if value, ok := uu.mutation.Age(); ok {
		v.Property(dsl.Single, user.FieldAge, value)
	}
	if value, ok := uu.mutation.AddedAge(); ok {
		v.Property(dsl.Single, user.FieldAge, __.Union(__.Values(user.FieldAge), __.Constant(value)).Sum())
	}
	if value, ok := uu.mutation.Name(); ok {
		v.Property(dsl.Single, user.FieldName, value)
	}
	if value, ok := uu.mutation.Last(); ok {
		v.Property(dsl.Single, user.FieldLast, value)
	}
	if value, ok := uu.mutation.Nickname(); ok {
		constraints = append(constraints, &constraint{
			pred: g.V().Has(user.Label, user.FieldNickname, value).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueField(user.Label, user.FieldNickname, value)),
		})
		v.Property(dsl.Single, user.FieldNickname, value)
	}
	if value, ok := uu.mutation.Phone(); ok {
		constraints = append(constraints, &constraint{
			pred: g.V().Has(user.Label, user.FieldPhone, value).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueField(user.Label, user.FieldPhone, value)),
		})
		v.Property(dsl.Single, user.FieldPhone, value)
	}
	if value, ok := uu.mutation.Password(); ok {
		v.Property(dsl.Single, user.FieldPassword, value)
	}
	if value, ok := uu.mutation.Role(); ok {
		v.Property(dsl.Single, user.FieldRole, value)
	}
	if value, ok := uu.mutation.SSOCert(); ok {
		v.Property(dsl.Single, user.FieldSSOCert, value)
	}
	var properties []interface{}
	if uu.mutation.OptionalIntCleared() {
		properties = append(properties, user.FieldOptionalInt)
	}
	if uu.mutation.NicknameCleared() {
		properties = append(properties, user.FieldNickname)
	}
	if uu.mutation.PhoneCleared() {
		properties = append(properties, user.FieldPhone)
	}
	if uu.mutation.PasswordCleared() {
		properties = append(properties, user.FieldPassword)
	}
	if uu.mutation.SSOCertCleared() {
		properties = append(properties, user.FieldSSOCert)
	}
	if len(properties) > 0 {
		v.SideEffect(__.Properties(properties...).Drop())
	}
	if uu.mutation.CardCleared() {
		tr := rv.Clone().OutE(user.CardLabel).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.CardIDs() {
		v.AddE(user.CardLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.CardLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.CardLabel, id)),
		})
	}
	for _, id := range uu.mutation.RemovedPetsIDs() {
		tr := rv.Clone().OutE(user.PetsLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.PetsIDs() {
		v.AddE(user.PetsLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.PetsLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.PetsLabel, id)),
		})
	}
	for _, id := range uu.mutation.RemovedFilesIDs() {
		tr := rv.Clone().OutE(user.FilesLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.FilesIDs() {
		v.AddE(user.FilesLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.FilesLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.FilesLabel, id)),
		})
	}
	for _, id := range uu.mutation.RemovedGroupsIDs() {
		tr := rv.Clone().OutE(user.GroupsLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.GroupsIDs() {
		v.AddE(user.GroupsLabel).To(g.V(id)).OutV()
	}
	for _, id := range uu.mutation.RemovedFriendsIDs() {
		tr := rv.Clone().BothE(user.FriendsLabel).Where(__.Or(__.InV().HasID(id), __.OutV().HasID(id))).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.FriendsIDs() {
		v.AddE(user.FriendsLabel).To(g.V(id)).OutV()
	}
	for _, id := range uu.mutation.RemovedFollowersIDs() {
		tr := rv.Clone().InE(user.FollowingLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.FollowersIDs() {
		v.AddE(user.FollowingLabel).From(g.V(id)).InV()
	}
	for _, id := range uu.mutation.RemovedFollowingIDs() {
		tr := rv.Clone().OutE(user.FollowingLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.FollowingIDs() {
		v.AddE(user.FollowingLabel).To(g.V(id)).OutV()
	}
	if uu.mutation.TeamCleared() {
		tr := rv.Clone().OutE(user.TeamLabel).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.TeamIDs() {
		v.AddE(user.TeamLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.TeamLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.TeamLabel, id)),
		})
	}
	if uu.mutation.SpouseCleared() {
		tr := rv.Clone().BothE(user.SpouseLabel).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.SpouseIDs() {
		v.AddE(user.SpouseLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: rv.Clone().Both(user.SpouseLabel).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.SpouseLabel, id)),
		})
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.SpouseLabel).Where(__.Or(__.InV().HasID(id), __.OutV().HasID(id))).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.SpouseLabel, id)),
		})
	}
	for _, id := range uu.mutation.RemovedChildrenIDs() {
		tr := rv.Clone().InE(user.ParentLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.ChildrenIDs() {
		v.AddE(user.ParentLabel).From(g.V(id)).InV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.ParentLabel).OutV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.ParentLabel, id)),
		})
	}
	if uu.mutation.ParentCleared() {
		tr := rv.Clone().OutE(user.ParentLabel).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uu.mutation.ParentIDs() {
		v.AddE(user.ParentLabel).To(g.V(id)).OutV()
	}
	v.Count()
	if len(constraints) > 0 {
		constraints = append(constraints, &constraint{
			pred: rv.Count(),
			test: __.Is(p.GT(1)).Constant(&ConstraintError{msg: "update traversal contains more than one vertex"}),
		})
		v = constraints[0].pred.Coalesce(constraints[0].test, v)
		for _, cr := range constraints[1:] {
			v = cr.pred.Coalesce(cr.test, v)
		}
	}
	trs = append(trs, v)
	return dsl.Join(trs...)
}

// UserUpdateOne is the builder for updating a single User entity.
type UserUpdateOne struct {
	config
	hooks    []Hook
	mutation *UserMutation
}

// SetOptionalInt sets the optional_int field.
func (uuo *UserUpdateOne) SetOptionalInt(i int) *UserUpdateOne {
	uuo.mutation.ResetOptionalInt()
	uuo.mutation.SetOptionalInt(i)
	return uuo
}

// SetNillableOptionalInt sets the optional_int field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableOptionalInt(i *int) *UserUpdateOne {
	if i != nil {
		uuo.SetOptionalInt(*i)
	}
	return uuo
}

// AddOptionalInt adds i to optional_int.
func (uuo *UserUpdateOne) AddOptionalInt(i int) *UserUpdateOne {
	uuo.mutation.AddOptionalInt(i)
	return uuo
}

// ClearOptionalInt clears the value of optional_int.
func (uuo *UserUpdateOne) ClearOptionalInt() *UserUpdateOne {
	uuo.mutation.ClearOptionalInt()
	return uuo
}

// SetAge sets the age field.
func (uuo *UserUpdateOne) SetAge(i int) *UserUpdateOne {
	uuo.mutation.ResetAge()
	uuo.mutation.SetAge(i)
	return uuo
}

// AddAge adds i to age.
func (uuo *UserUpdateOne) AddAge(i int) *UserUpdateOne {
	uuo.mutation.AddAge(i)
	return uuo
}

// SetName sets the name field.
func (uuo *UserUpdateOne) SetName(s string) *UserUpdateOne {
	uuo.mutation.SetName(s)
	return uuo
}

// SetLast sets the last field.
func (uuo *UserUpdateOne) SetLast(s string) *UserUpdateOne {
	uuo.mutation.SetLast(s)
	return uuo
}

// SetNillableLast sets the last field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableLast(s *string) *UserUpdateOne {
	if s != nil {
		uuo.SetLast(*s)
	}
	return uuo
}

// SetNickname sets the nickname field.
func (uuo *UserUpdateOne) SetNickname(s string) *UserUpdateOne {
	uuo.mutation.SetNickname(s)
	return uuo
}

// SetNillableNickname sets the nickname field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableNickname(s *string) *UserUpdateOne {
	if s != nil {
		uuo.SetNickname(*s)
	}
	return uuo
}

// ClearNickname clears the value of nickname.
func (uuo *UserUpdateOne) ClearNickname() *UserUpdateOne {
	uuo.mutation.ClearNickname()
	return uuo
}

// SetPhone sets the phone field.
func (uuo *UserUpdateOne) SetPhone(s string) *UserUpdateOne {
	uuo.mutation.SetPhone(s)
	return uuo
}

// SetNillablePhone sets the phone field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillablePhone(s *string) *UserUpdateOne {
	if s != nil {
		uuo.SetPhone(*s)
	}
	return uuo
}

// ClearPhone clears the value of phone.
func (uuo *UserUpdateOne) ClearPhone() *UserUpdateOne {
	uuo.mutation.ClearPhone()
	return uuo
}

// SetPassword sets the password field.
func (uuo *UserUpdateOne) SetPassword(s string) *UserUpdateOne {
	uuo.mutation.SetPassword(s)
	return uuo
}

// SetNillablePassword sets the password field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillablePassword(s *string) *UserUpdateOne {
	if s != nil {
		uuo.SetPassword(*s)
	}
	return uuo
}

// ClearPassword clears the value of password.
func (uuo *UserUpdateOne) ClearPassword() *UserUpdateOne {
	uuo.mutation.ClearPassword()
	return uuo
}

// SetRole sets the role field.
func (uuo *UserUpdateOne) SetRole(u user.Role) *UserUpdateOne {
	uuo.mutation.SetRole(u)
	return uuo
}

// SetNillableRole sets the role field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableRole(u *user.Role) *UserUpdateOne {
	if u != nil {
		uuo.SetRole(*u)
	}
	return uuo
}

// SetSSOCert sets the SSOCert field.
func (uuo *UserUpdateOne) SetSSOCert(s string) *UserUpdateOne {
	uuo.mutation.SetSSOCert(s)
	return uuo
}

// SetNillableSSOCert sets the SSOCert field if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableSSOCert(s *string) *UserUpdateOne {
	if s != nil {
		uuo.SetSSOCert(*s)
	}
	return uuo
}

// ClearSSOCert clears the value of SSOCert.
func (uuo *UserUpdateOne) ClearSSOCert() *UserUpdateOne {
	uuo.mutation.ClearSSOCert()
	return uuo
}

// SetCardID sets the card edge to Card by id.
func (uuo *UserUpdateOne) SetCardID(id string) *UserUpdateOne {
	uuo.mutation.SetCardID(id)
	return uuo
}

// SetNillableCardID sets the card edge to Card by id if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableCardID(id *string) *UserUpdateOne {
	if id != nil {
		uuo = uuo.SetCardID(*id)
	}
	return uuo
}

// SetCard sets the card edge to Card.
func (uuo *UserUpdateOne) SetCard(c *Card) *UserUpdateOne {
	return uuo.SetCardID(c.ID)
}

// AddPetIDs adds the pets edge to Pet by ids.
func (uuo *UserUpdateOne) AddPetIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.AddPetIDs(ids...)
	return uuo
}

// AddPets adds the pets edges to Pet.
func (uuo *UserUpdateOne) AddPets(p ...*Pet) *UserUpdateOne {
	ids := make([]string, len(p))
	for i := range p {
		ids[i] = p[i].ID
	}
	return uuo.AddPetIDs(ids...)
}

// AddFileIDs adds the files edge to File by ids.
func (uuo *UserUpdateOne) AddFileIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.AddFileIDs(ids...)
	return uuo
}

// AddFiles adds the files edges to File.
func (uuo *UserUpdateOne) AddFiles(f ...*File) *UserUpdateOne {
	ids := make([]string, len(f))
	for i := range f {
		ids[i] = f[i].ID
	}
	return uuo.AddFileIDs(ids...)
}

// AddGroupIDs adds the groups edge to Group by ids.
func (uuo *UserUpdateOne) AddGroupIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.AddGroupIDs(ids...)
	return uuo
}

// AddGroups adds the groups edges to Group.
func (uuo *UserUpdateOne) AddGroups(g ...*Group) *UserUpdateOne {
	ids := make([]string, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return uuo.AddGroupIDs(ids...)
}

// AddFriendIDs adds the friends edge to User by ids.
func (uuo *UserUpdateOne) AddFriendIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.AddFriendIDs(ids...)
	return uuo
}

// AddFriends adds the friends edges to User.
func (uuo *UserUpdateOne) AddFriends(u ...*User) *UserUpdateOne {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uuo.AddFriendIDs(ids...)
}

// AddFollowerIDs adds the followers edge to User by ids.
func (uuo *UserUpdateOne) AddFollowerIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.AddFollowerIDs(ids...)
	return uuo
}

// AddFollowers adds the followers edges to User.
func (uuo *UserUpdateOne) AddFollowers(u ...*User) *UserUpdateOne {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uuo.AddFollowerIDs(ids...)
}

// AddFollowingIDs adds the following edge to User by ids.
func (uuo *UserUpdateOne) AddFollowingIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.AddFollowingIDs(ids...)
	return uuo
}

// AddFollowing adds the following edges to User.
func (uuo *UserUpdateOne) AddFollowing(u ...*User) *UserUpdateOne {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uuo.AddFollowingIDs(ids...)
}

// SetTeamID sets the team edge to Pet by id.
func (uuo *UserUpdateOne) SetTeamID(id string) *UserUpdateOne {
	uuo.mutation.SetTeamID(id)
	return uuo
}

// SetNillableTeamID sets the team edge to Pet by id if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableTeamID(id *string) *UserUpdateOne {
	if id != nil {
		uuo = uuo.SetTeamID(*id)
	}
	return uuo
}

// SetTeam sets the team edge to Pet.
func (uuo *UserUpdateOne) SetTeam(p *Pet) *UserUpdateOne {
	return uuo.SetTeamID(p.ID)
}

// SetSpouseID sets the spouse edge to User by id.
func (uuo *UserUpdateOne) SetSpouseID(id string) *UserUpdateOne {
	uuo.mutation.SetSpouseID(id)
	return uuo
}

// SetNillableSpouseID sets the spouse edge to User by id if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableSpouseID(id *string) *UserUpdateOne {
	if id != nil {
		uuo = uuo.SetSpouseID(*id)
	}
	return uuo
}

// SetSpouse sets the spouse edge to User.
func (uuo *UserUpdateOne) SetSpouse(u *User) *UserUpdateOne {
	return uuo.SetSpouseID(u.ID)
}

// AddChildIDs adds the children edge to User by ids.
func (uuo *UserUpdateOne) AddChildIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.AddChildIDs(ids...)
	return uuo
}

// AddChildren adds the children edges to User.
func (uuo *UserUpdateOne) AddChildren(u ...*User) *UserUpdateOne {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uuo.AddChildIDs(ids...)
}

// SetParentID sets the parent edge to User by id.
func (uuo *UserUpdateOne) SetParentID(id string) *UserUpdateOne {
	uuo.mutation.SetParentID(id)
	return uuo
}

// SetNillableParentID sets the parent edge to User by id if the given value is not nil.
func (uuo *UserUpdateOne) SetNillableParentID(id *string) *UserUpdateOne {
	if id != nil {
		uuo = uuo.SetParentID(*id)
	}
	return uuo
}

// SetParent sets the parent edge to User.
func (uuo *UserUpdateOne) SetParent(u *User) *UserUpdateOne {
	return uuo.SetParentID(u.ID)
}

// Mutation returns the UserMutation object of the builder.
func (uuo *UserUpdateOne) Mutation() *UserMutation {
	return uuo.mutation
}

// ClearCard clears the "card" edge to type Card.
func (uuo *UserUpdateOne) ClearCard() *UserUpdateOne {
	uuo.mutation.ClearCard()
	return uuo
}

// ClearPets clears all "pets" edges to type Pet.
func (uuo *UserUpdateOne) ClearPets() *UserUpdateOne {
	uuo.mutation.ClearPets()
	return uuo
}

// RemovePetIDs removes the pets edge to Pet by ids.
func (uuo *UserUpdateOne) RemovePetIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.RemovePetIDs(ids...)
	return uuo
}

// RemovePets removes pets edges to Pet.
func (uuo *UserUpdateOne) RemovePets(p ...*Pet) *UserUpdateOne {
	ids := make([]string, len(p))
	for i := range p {
		ids[i] = p[i].ID
	}
	return uuo.RemovePetIDs(ids...)
}

// ClearFiles clears all "files" edges to type File.
func (uuo *UserUpdateOne) ClearFiles() *UserUpdateOne {
	uuo.mutation.ClearFiles()
	return uuo
}

// RemoveFileIDs removes the files edge to File by ids.
func (uuo *UserUpdateOne) RemoveFileIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.RemoveFileIDs(ids...)
	return uuo
}

// RemoveFiles removes files edges to File.
func (uuo *UserUpdateOne) RemoveFiles(f ...*File) *UserUpdateOne {
	ids := make([]string, len(f))
	for i := range f {
		ids[i] = f[i].ID
	}
	return uuo.RemoveFileIDs(ids...)
}

// ClearGroups clears all "groups" edges to type Group.
func (uuo *UserUpdateOne) ClearGroups() *UserUpdateOne {
	uuo.mutation.ClearGroups()
	return uuo
}

// RemoveGroupIDs removes the groups edge to Group by ids.
func (uuo *UserUpdateOne) RemoveGroupIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.RemoveGroupIDs(ids...)
	return uuo
}

// RemoveGroups removes groups edges to Group.
func (uuo *UserUpdateOne) RemoveGroups(g ...*Group) *UserUpdateOne {
	ids := make([]string, len(g))
	for i := range g {
		ids[i] = g[i].ID
	}
	return uuo.RemoveGroupIDs(ids...)
}

// ClearFriends clears all "friends" edges to type User.
func (uuo *UserUpdateOne) ClearFriends() *UserUpdateOne {
	uuo.mutation.ClearFriends()
	return uuo
}

// RemoveFriendIDs removes the friends edge to User by ids.
func (uuo *UserUpdateOne) RemoveFriendIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.RemoveFriendIDs(ids...)
	return uuo
}

// RemoveFriends removes friends edges to User.
func (uuo *UserUpdateOne) RemoveFriends(u ...*User) *UserUpdateOne {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uuo.RemoveFriendIDs(ids...)
}

// ClearFollowers clears all "followers" edges to type User.
func (uuo *UserUpdateOne) ClearFollowers() *UserUpdateOne {
	uuo.mutation.ClearFollowers()
	return uuo
}

// RemoveFollowerIDs removes the followers edge to User by ids.
func (uuo *UserUpdateOne) RemoveFollowerIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.RemoveFollowerIDs(ids...)
	return uuo
}

// RemoveFollowers removes followers edges to User.
func (uuo *UserUpdateOne) RemoveFollowers(u ...*User) *UserUpdateOne {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uuo.RemoveFollowerIDs(ids...)
}

// ClearFollowing clears all "following" edges to type User.
func (uuo *UserUpdateOne) ClearFollowing() *UserUpdateOne {
	uuo.mutation.ClearFollowing()
	return uuo
}

// RemoveFollowingIDs removes the following edge to User by ids.
func (uuo *UserUpdateOne) RemoveFollowingIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.RemoveFollowingIDs(ids...)
	return uuo
}

// RemoveFollowing removes following edges to User.
func (uuo *UserUpdateOne) RemoveFollowing(u ...*User) *UserUpdateOne {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uuo.RemoveFollowingIDs(ids...)
}

// ClearTeam clears the "team" edge to type Pet.
func (uuo *UserUpdateOne) ClearTeam() *UserUpdateOne {
	uuo.mutation.ClearTeam()
	return uuo
}

// ClearSpouse clears the "spouse" edge to type User.
func (uuo *UserUpdateOne) ClearSpouse() *UserUpdateOne {
	uuo.mutation.ClearSpouse()
	return uuo
}

// ClearChildren clears all "children" edges to type User.
func (uuo *UserUpdateOne) ClearChildren() *UserUpdateOne {
	uuo.mutation.ClearChildren()
	return uuo
}

// RemoveChildIDs removes the children edge to User by ids.
func (uuo *UserUpdateOne) RemoveChildIDs(ids ...string) *UserUpdateOne {
	uuo.mutation.RemoveChildIDs(ids...)
	return uuo
}

// RemoveChildren removes children edges to User.
func (uuo *UserUpdateOne) RemoveChildren(u ...*User) *UserUpdateOne {
	ids := make([]string, len(u))
	for i := range u {
		ids[i] = u[i].ID
	}
	return uuo.RemoveChildIDs(ids...)
}

// ClearParent clears the "parent" edge to type User.
func (uuo *UserUpdateOne) ClearParent() *UserUpdateOne {
	uuo.mutation.ClearParent()
	return uuo
}

// Save executes the query and returns the updated entity.
func (uuo *UserUpdateOne) Save(ctx context.Context) (*User, error) {
	var (
		err  error
		node *User
	)
	if len(uuo.hooks) == 0 {
		if err = uuo.check(); err != nil {
			return nil, err
		}
		node, err = uuo.gremlinSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*UserMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = uuo.check(); err != nil {
				return nil, err
			}
			uuo.mutation = mutation
			node, err = uuo.gremlinSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(uuo.hooks) - 1; i >= 0; i-- {
			mut = uuo.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, uuo.mutation); err != nil {
			return nil, err
		}
	}
	return node, err
}

// SaveX is like Save, but panics if an error occurs.
func (uuo *UserUpdateOne) SaveX(ctx context.Context) *User {
	node, err := uuo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (uuo *UserUpdateOne) Exec(ctx context.Context) error {
	_, err := uuo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (uuo *UserUpdateOne) ExecX(ctx context.Context) {
	if err := uuo.Exec(ctx); err != nil {
		panic(err)
	}
}

// check runs all checks and user-defined validators on the builder.
func (uuo *UserUpdateOne) check() error {
	if v, ok := uuo.mutation.OptionalInt(); ok {
		if err := user.OptionalIntValidator(v); err != nil {
			return &ValidationError{Name: "optional_int", err: fmt.Errorf("ent: validator failed for field \"optional_int\": %w", err)}
		}
	}
	if v, ok := uuo.mutation.Role(); ok {
		if err := user.RoleValidator(v); err != nil {
			return &ValidationError{Name: "role", err: fmt.Errorf("ent: validator failed for field \"role\": %w", err)}
		}
	}
	return nil
}

func (uuo *UserUpdateOne) gremlinSave(ctx context.Context) (*User, error) {
	res := &gremlin.Response{}
	id, ok := uuo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "ID", err: fmt.Errorf("missing User.ID for update")}
	}
	query, bindings := uuo.gremlin(id).Query()
	if err := uuo.driver.Exec(ctx, query, bindings, res); err != nil {
		return nil, err
	}
	if err, ok := isConstantError(res); ok {
		return nil, err
	}
	u := &User{config: uuo.config}
	if err := u.FromResponse(res); err != nil {
		return nil, err
	}
	return u, nil
}

func (uuo *UserUpdateOne) gremlin(id string) *dsl.Traversal {
	type constraint struct {
		pred *dsl.Traversal // constraint predicate.
		test *dsl.Traversal // test matches and its constant.
	}
	constraints := make([]*constraint, 0, 8)
	v := g.V(id)
	var (
		rv = v.Clone()
		_  = rv

		trs []*dsl.Traversal
	)
	if value, ok := uuo.mutation.OptionalInt(); ok {
		v.Property(dsl.Single, user.FieldOptionalInt, value)
	}
	if value, ok := uuo.mutation.AddedOptionalInt(); ok {
		v.Property(dsl.Single, user.FieldOptionalInt, __.Union(__.Values(user.FieldOptionalInt), __.Constant(value)).Sum())
	}
	if value, ok := uuo.mutation.Age(); ok {
		v.Property(dsl.Single, user.FieldAge, value)
	}
	if value, ok := uuo.mutation.AddedAge(); ok {
		v.Property(dsl.Single, user.FieldAge, __.Union(__.Values(user.FieldAge), __.Constant(value)).Sum())
	}
	if value, ok := uuo.mutation.Name(); ok {
		v.Property(dsl.Single, user.FieldName, value)
	}
	if value, ok := uuo.mutation.Last(); ok {
		v.Property(dsl.Single, user.FieldLast, value)
	}
	if value, ok := uuo.mutation.Nickname(); ok {
		constraints = append(constraints, &constraint{
			pred: g.V().Has(user.Label, user.FieldNickname, value).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueField(user.Label, user.FieldNickname, value)),
		})
		v.Property(dsl.Single, user.FieldNickname, value)
	}
	if value, ok := uuo.mutation.Phone(); ok {
		constraints = append(constraints, &constraint{
			pred: g.V().Has(user.Label, user.FieldPhone, value).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueField(user.Label, user.FieldPhone, value)),
		})
		v.Property(dsl.Single, user.FieldPhone, value)
	}
	if value, ok := uuo.mutation.Password(); ok {
		v.Property(dsl.Single, user.FieldPassword, value)
	}
	if value, ok := uuo.mutation.Role(); ok {
		v.Property(dsl.Single, user.FieldRole, value)
	}
	if value, ok := uuo.mutation.SSOCert(); ok {
		v.Property(dsl.Single, user.FieldSSOCert, value)
	}
	var properties []interface{}
	if uuo.mutation.OptionalIntCleared() {
		properties = append(properties, user.FieldOptionalInt)
	}
	if uuo.mutation.NicknameCleared() {
		properties = append(properties, user.FieldNickname)
	}
	if uuo.mutation.PhoneCleared() {
		properties = append(properties, user.FieldPhone)
	}
	if uuo.mutation.PasswordCleared() {
		properties = append(properties, user.FieldPassword)
	}
	if uuo.mutation.SSOCertCleared() {
		properties = append(properties, user.FieldSSOCert)
	}
	if len(properties) > 0 {
		v.SideEffect(__.Properties(properties...).Drop())
	}
	if uuo.mutation.CardCleared() {
		tr := rv.Clone().OutE(user.CardLabel).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.CardIDs() {
		v.AddE(user.CardLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.CardLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.CardLabel, id)),
		})
	}
	for _, id := range uuo.mutation.RemovedPetsIDs() {
		tr := rv.Clone().OutE(user.PetsLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.PetsIDs() {
		v.AddE(user.PetsLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.PetsLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.PetsLabel, id)),
		})
	}
	for _, id := range uuo.mutation.RemovedFilesIDs() {
		tr := rv.Clone().OutE(user.FilesLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.FilesIDs() {
		v.AddE(user.FilesLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.FilesLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.FilesLabel, id)),
		})
	}
	for _, id := range uuo.mutation.RemovedGroupsIDs() {
		tr := rv.Clone().OutE(user.GroupsLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.GroupsIDs() {
		v.AddE(user.GroupsLabel).To(g.V(id)).OutV()
	}
	for _, id := range uuo.mutation.RemovedFriendsIDs() {
		tr := rv.Clone().BothE(user.FriendsLabel).Where(__.Or(__.InV().HasID(id), __.OutV().HasID(id))).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.FriendsIDs() {
		v.AddE(user.FriendsLabel).To(g.V(id)).OutV()
	}
	for _, id := range uuo.mutation.RemovedFollowersIDs() {
		tr := rv.Clone().InE(user.FollowingLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.FollowersIDs() {
		v.AddE(user.FollowingLabel).From(g.V(id)).InV()
	}
	for _, id := range uuo.mutation.RemovedFollowingIDs() {
		tr := rv.Clone().OutE(user.FollowingLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.FollowingIDs() {
		v.AddE(user.FollowingLabel).To(g.V(id)).OutV()
	}
	if uuo.mutation.TeamCleared() {
		tr := rv.Clone().OutE(user.TeamLabel).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.TeamIDs() {
		v.AddE(user.TeamLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.TeamLabel).InV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.TeamLabel, id)),
		})
	}
	if uuo.mutation.SpouseCleared() {
		tr := rv.Clone().BothE(user.SpouseLabel).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.SpouseIDs() {
		v.AddE(user.SpouseLabel).To(g.V(id)).OutV()
		constraints = append(constraints, &constraint{
			pred: rv.Clone().Both(user.SpouseLabel).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.SpouseLabel, id)),
		})
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.SpouseLabel).Where(__.Or(__.InV().HasID(id), __.OutV().HasID(id))).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.SpouseLabel, id)),
		})
	}
	for _, id := range uuo.mutation.RemovedChildrenIDs() {
		tr := rv.Clone().InE(user.ParentLabel).Where(__.OtherV().HasID(id)).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.ChildrenIDs() {
		v.AddE(user.ParentLabel).From(g.V(id)).InV()
		constraints = append(constraints, &constraint{
			pred: g.E().HasLabel(user.ParentLabel).OutV().HasID(id).Count(),
			test: __.Is(p.NEQ(0)).Constant(NewErrUniqueEdge(user.Label, user.ParentLabel, id)),
		})
	}
	if uuo.mutation.ParentCleared() {
		tr := rv.Clone().OutE(user.ParentLabel).Drop().Iterate()
		trs = append(trs, tr)
	}
	for _, id := range uuo.mutation.ParentIDs() {
		v.AddE(user.ParentLabel).To(g.V(id)).OutV()
	}
	v.ValueMap(true)
	if len(constraints) > 0 {
		v = constraints[0].pred.Coalesce(constraints[0].test, v)
		for _, cr := range constraints[1:] {
			v = cr.pred.Coalesce(cr.test, v)
		}
	}
	trs = append(trs, v)
	return dsl.Join(trs...)
}
