// Copyright 2019-present Facebook Inc. All rights reserved.
// This source code is licensed under the Apache 2.0 license found
// in the LICENSE file in the root directory of this source tree.

// Code generated by entc, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"

	"github.com/facebook/ent/dialect/gremlin"
	"github.com/facebook/ent/dialect/gremlin/graph/dsl"
	"github.com/facebook/ent/dialect/gremlin/graph/dsl/g"
	"github.com/facebook/ent/entc/integration/ent/schema"
	"github.com/facebook/ent/entc/integration/gremlin/ent/task"
)

// TaskCreate is the builder for creating a Task entity.
type TaskCreate struct {
	config
	mutation *TaskMutation
	hooks    []Hook
}

// SetPriority sets the priority field.
func (tc *TaskCreate) SetPriority(s schema.Priority) *TaskCreate {
	tc.mutation.SetPriority(s)
	return tc
}

// SetNillablePriority sets the priority field if the given value is not nil.
func (tc *TaskCreate) SetNillablePriority(s *schema.Priority) *TaskCreate {
	if s != nil {
		tc.SetPriority(*s)
	}
	return tc
}

// Mutation returns the TaskMutation object of the builder.
func (tc *TaskCreate) Mutation() *TaskMutation {
	return tc.mutation
}

// Save creates the Task in the database.
func (tc *TaskCreate) Save(ctx context.Context) (*Task, error) {
	var (
		err  error
		node *Task
	)
	tc.defaults()
	if len(tc.hooks) == 0 {
		if err = tc.check(); err != nil {
			return nil, err
		}
		node, err = tc.gremlinSave(ctx)
	} else {
		var mut Mutator = MutateFunc(func(ctx context.Context, m Mutation) (Value, error) {
			mutation, ok := m.(*TaskMutation)
			if !ok {
				return nil, fmt.Errorf("unexpected mutation type %T", m)
			}
			if err = tc.check(); err != nil {
				return nil, err
			}
			tc.mutation = mutation
			node, err = tc.gremlinSave(ctx)
			mutation.done = true
			return node, err
		})
		for i := len(tc.hooks) - 1; i >= 0; i-- {
			mut = tc.hooks[i](mut)
		}
		if _, err := mut.Mutate(ctx, tc.mutation); err != nil {
			return nil, err
		}
	}
	return node, err
}

// SaveX calls Save and panics if Save returns an error.
func (tc *TaskCreate) SaveX(ctx context.Context) *Task {
	v, err := tc.Save(ctx)
	if err != nil {
		panic(err)
	}
	return v
}

// defaults sets the default values of the builder before save.
func (tc *TaskCreate) defaults() {
	if _, ok := tc.mutation.Priority(); !ok {
		v := task.DefaultPriority
		tc.mutation.SetPriority(v)
	}
}

// check runs all checks and user-defined validators on the builder.
func (tc *TaskCreate) check() error {
	if _, ok := tc.mutation.Priority(); !ok {
		return &ValidationError{Name: "priority", err: errors.New("ent: missing required field \"priority\"")}
	}
	if v, ok := tc.mutation.Priority(); ok {
		if err := task.PriorityValidator(int(v)); err != nil {
			return &ValidationError{Name: "priority", err: fmt.Errorf("ent: validator failed for field \"priority\": %w", err)}
		}
	}
	return nil
}

func (tc *TaskCreate) gremlinSave(ctx context.Context) (*Task, error) {
	res := &gremlin.Response{}
	query, bindings := tc.gremlin().Query()
	if err := tc.driver.Exec(ctx, query, bindings, res); err != nil {
		return nil, err
	}
	if err, ok := isConstantError(res); ok {
		return nil, err
	}
	t := &Task{config: tc.config}
	if err := t.FromResponse(res); err != nil {
		return nil, err
	}
	return t, nil
}

func (tc *TaskCreate) gremlin() *dsl.Traversal {
	v := g.AddV(task.Label)
	if value, ok := tc.mutation.Priority(); ok {
		v.Property(dsl.Single, task.FieldPriority, value)
	}
	return v.ValueMap(true)
}

// TaskCreateBulk is the builder for creating a bulk of Task entities.
type TaskCreateBulk struct {
	config
	builders []*TaskCreate
}
