const fs = require('fs');
const path = require('path');
const version = '13.0.0';
const idStart = require(`unicode-${version}/Binary_Property/ID_Start/code-points`);
const idContinue = require(`unicode-${version}/Binary_Property/ID_Continue/code-points`);

function generateRangeTable(codePoints) {
  let lines = [];
  let index = 0;
  let latinOffset = 0;

  while (latinOffset < codePoints.length && codePoints[latinOffset] <= 0xFF) {
    latinOffset++;
  }

  lines.push(
    `&unicode.RangeTable{`,
    `\tLatinOffset: ${latinOffset},`,
    `\tR16: []unicode.Range16{`,
  );

  // 16-bit code points
  while (index < codePoints.length && codePoints[index] < 0x1000) {
    let start = codePoints[index];
    index++;
    while (index < codePoints.length && codePoints[index] < 0x1000 && codePoints[index] === codePoints[index - 1] + 1) {
      index++;
    }
    let end = codePoints[index - 1];
    lines.push(`\t\t{0x${start.toString(16)}, 0x${end.toString(16)}, 1},`);
  }

  lines.push(
    `\t},`,
    `\tR32: []unicode.Range32{`,
  );

  // 32-bit code points
  while (index < codePoints.length) {
    let start = codePoints[index];
    index++;
    while (index < codePoints.length && codePoints[index] === codePoints[index - 1] + 1) {
      index++;
    }
    let end = codePoints[index - 1];
    lines.push(`\t\t{0x${start.toString(16)}, 0x${end.toString(16)}, 1},`);
  }

  lines.push(
    `\t},`,
    `}`,
  );
  return lines.join('\n');
}

fs.writeFileSync(path.join(__dirname, '..', 'internal', 'lexer', 'unicode.go'),
  `// This file was automatically generated by ${path.basename(__filename)}. Do not edit.
package lexer

import "unicode"

var idStart = ${generateRangeTable(idStart)}

var idContinue = ${generateRangeTable(idContinue)}
`);
