package tracing

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"errors"

	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// MemoryDumpConfig configuration for memory dump. Used only when
// "memory-infra" category is enabled.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#type-MemoryDumpConfig
type MemoryDumpConfig struct{}

// TraceConfig [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#type-TraceConfig
type TraceConfig struct {
	RecordMode           RecordMode        `json:"recordMode,omitempty"`           // Controls how the trace buffer stores data.
	EnableSampling       bool              `json:"enableSampling,omitempty"`       // Turns on JavaScript stack sampling.
	EnableSystrace       bool              `json:"enableSystrace,omitempty"`       // Turns on system tracing.
	EnableArgumentFilter bool              `json:"enableArgumentFilter,omitempty"` // Turns on argument filter.
	IncludedCategories   []string          `json:"includedCategories,omitempty"`   // Included category filters.
	ExcludedCategories   []string          `json:"excludedCategories,omitempty"`   // Excluded category filters.
	SyntheticDelays      []string          `json:"syntheticDelays,omitempty"`      // Configuration to synthesize the delays in tracing.
	MemoryDumpConfig     *MemoryDumpConfig `json:"memoryDumpConfig,omitempty"`     // Configuration for memory dump triggers. Used only when "memory-infra" category is enabled.
}

// StreamFormat data format of a trace. Can be either the legacy JSON format
// or the protocol buffer format. Note that the JSON format will be deprecated
// soon.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#type-StreamFormat
type StreamFormat string

// String returns the StreamFormat as string value.
func (t StreamFormat) String() string {
	return string(t)
}

// StreamFormat values.
const (
	StreamFormatJSON  StreamFormat = "json"
	StreamFormatProto StreamFormat = "proto"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t StreamFormat) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t StreamFormat) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *StreamFormat) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch StreamFormat(in.String()) {
	case StreamFormatJSON:
		*t = StreamFormatJSON
	case StreamFormatProto:
		*t = StreamFormatProto

	default:
		in.AddError(errors.New("unknown StreamFormat value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *StreamFormat) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// StreamCompression compression type to use for traces returned via streams.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#type-StreamCompression
type StreamCompression string

// String returns the StreamCompression as string value.
func (t StreamCompression) String() string {
	return string(t)
}

// StreamCompression values.
const (
	StreamCompressionNone StreamCompression = "none"
	StreamCompressionGzip StreamCompression = "gzip"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t StreamCompression) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t StreamCompression) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *StreamCompression) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch StreamCompression(in.String()) {
	case StreamCompressionNone:
		*t = StreamCompressionNone
	case StreamCompressionGzip:
		*t = StreamCompressionGzip

	default:
		in.AddError(errors.New("unknown StreamCompression value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *StreamCompression) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// MemoryDumpLevelOfDetail details exposed when memory request explicitly
// declared. Keep consistent with memory_dump_request_args.h and
// memory_instrumentation.mojom.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#type-MemoryDumpLevelOfDetail
type MemoryDumpLevelOfDetail string

// String returns the MemoryDumpLevelOfDetail as string value.
func (t MemoryDumpLevelOfDetail) String() string {
	return string(t)
}

// MemoryDumpLevelOfDetail values.
const (
	MemoryDumpLevelOfDetailBackground MemoryDumpLevelOfDetail = "background"
	MemoryDumpLevelOfDetailLight      MemoryDumpLevelOfDetail = "light"
	MemoryDumpLevelOfDetailDetailed   MemoryDumpLevelOfDetail = "detailed"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t MemoryDumpLevelOfDetail) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t MemoryDumpLevelOfDetail) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *MemoryDumpLevelOfDetail) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch MemoryDumpLevelOfDetail(in.String()) {
	case MemoryDumpLevelOfDetailBackground:
		*t = MemoryDumpLevelOfDetailBackground
	case MemoryDumpLevelOfDetailLight:
		*t = MemoryDumpLevelOfDetailLight
	case MemoryDumpLevelOfDetailDetailed:
		*t = MemoryDumpLevelOfDetailDetailed

	default:
		in.AddError(errors.New("unknown MemoryDumpLevelOfDetail value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *MemoryDumpLevelOfDetail) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// Backend backend type to use for tracing. chrome uses the Chrome-integrated
// tracing service and is supported on all platforms. system is only supported
// on Chrome OS and uses the Perfetto system tracing service. auto chooses
// system when the perfettoConfig provided to Tracing.start specifies at least
// one non-Chrome data source; otherwise uses chrome.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#type-TracingBackend
type Backend string

// String returns the Backend as string value.
func (t Backend) String() string {
	return string(t)
}

// Backend values.
const (
	BackendAuto   Backend = "auto"
	BackendChrome Backend = "chrome"
	BackendSystem Backend = "system"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t Backend) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t Backend) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *Backend) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch Backend(in.String()) {
	case BackendAuto:
		*t = BackendAuto
	case BackendChrome:
		*t = BackendChrome
	case BackendSystem:
		*t = BackendSystem

	default:
		in.AddError(errors.New("unknown Backend value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *Backend) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// RecordMode controls how the trace buffer stores data.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#type-TraceConfig
type RecordMode string

// String returns the RecordMode as string value.
func (t RecordMode) String() string {
	return string(t)
}

// RecordMode values.
const (
	RecordModeRecordUntilFull        RecordMode = "recordUntilFull"
	RecordModeRecordContinuously     RecordMode = "recordContinuously"
	RecordModeRecordAsMuchAsPossible RecordMode = "recordAsMuchAsPossible"
	RecordModeEchoToConsole          RecordMode = "echoToConsole"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t RecordMode) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t RecordMode) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *RecordMode) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch RecordMode(in.String()) {
	case RecordModeRecordUntilFull:
		*t = RecordModeRecordUntilFull
	case RecordModeRecordContinuously:
		*t = RecordModeRecordContinuously
	case RecordModeRecordAsMuchAsPossible:
		*t = RecordModeRecordAsMuchAsPossible
	case RecordModeEchoToConsole:
		*t = RecordModeEchoToConsole

	default:
		in.AddError(errors.New("unknown RecordMode value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *RecordMode) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// TransferMode whether to report trace events as series of dataCollected
// events or to save trace to a stream (defaults to ReportEvents).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#method-start
type TransferMode string

// String returns the TransferMode as string value.
func (t TransferMode) String() string {
	return string(t)
}

// TransferMode values.
const (
	TransferModeReportEvents   TransferMode = "ReportEvents"
	TransferModeReturnAsStream TransferMode = "ReturnAsStream"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t TransferMode) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t TransferMode) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *TransferMode) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch TransferMode(in.String()) {
	case TransferModeReportEvents:
		*t = TransferModeReportEvents
	case TransferModeReturnAsStream:
		*t = TransferModeReturnAsStream

	default:
		in.AddError(errors.New("unknown TransferMode value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *TransferMode) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
