// Package tracing provides the Chrome DevTools Protocol
// commands, types, and events for the Tracing domain.
//
// Generated by the cdproto-gen command.
package tracing

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// EndParams stop trace events collection.
type EndParams struct{}

// End stop trace events collection.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#method-end
func End() *EndParams {
	return &EndParams{}
}

// Do executes Tracing.end against the provided context.
func (p *EndParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnd, nil, nil)
}

// GetCategoriesParams gets supported tracing categories.
type GetCategoriesParams struct{}

// GetCategories gets supported tracing categories.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#method-getCategories
func GetCategories() *GetCategoriesParams {
	return &GetCategoriesParams{}
}

// GetCategoriesReturns return values.
type GetCategoriesReturns struct {
	Categories []string `json:"categories,omitempty"` // A list of supported tracing categories.
}

// Do executes Tracing.getCategories against the provided context.
//
// returns:
//   categories - A list of supported tracing categories.
func (p *GetCategoriesParams) Do(ctx context.Context) (categories []string, err error) {
	// execute
	var res GetCategoriesReturns
	err = cdp.Execute(ctx, CommandGetCategories, nil, &res)
	if err != nil {
		return nil, err
	}

	return res.Categories, nil
}

// RecordClockSyncMarkerParams record a clock sync marker in the trace.
type RecordClockSyncMarkerParams struct {
	SyncID string `json:"syncId"` // The ID of this clock sync marker
}

// RecordClockSyncMarker record a clock sync marker in the trace.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#method-recordClockSyncMarker
//
// parameters:
//   syncID - The ID of this clock sync marker
func RecordClockSyncMarker(syncID string) *RecordClockSyncMarkerParams {
	return &RecordClockSyncMarkerParams{
		SyncID: syncID,
	}
}

// Do executes Tracing.recordClockSyncMarker against the provided context.
func (p *RecordClockSyncMarkerParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandRecordClockSyncMarker, p, nil)
}

// RequestMemoryDumpParams request a global memory dump.
type RequestMemoryDumpParams struct {
	Deterministic bool                    `json:"deterministic,omitempty"` // Enables more deterministic results by forcing garbage collection
	LevelOfDetail MemoryDumpLevelOfDetail `json:"levelOfDetail,omitempty"` // Specifies level of details in memory dump. Defaults to "detailed".
}

// RequestMemoryDump request a global memory dump.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#method-requestMemoryDump
//
// parameters:
func RequestMemoryDump() *RequestMemoryDumpParams {
	return &RequestMemoryDumpParams{}
}

// WithDeterministic enables more deterministic results by forcing garbage
// collection.
func (p RequestMemoryDumpParams) WithDeterministic(deterministic bool) *RequestMemoryDumpParams {
	p.Deterministic = deterministic
	return &p
}

// WithLevelOfDetail specifies level of details in memory dump. Defaults to
// "detailed".
func (p RequestMemoryDumpParams) WithLevelOfDetail(levelOfDetail MemoryDumpLevelOfDetail) *RequestMemoryDumpParams {
	p.LevelOfDetail = levelOfDetail
	return &p
}

// RequestMemoryDumpReturns return values.
type RequestMemoryDumpReturns struct {
	DumpGUID string `json:"dumpGuid,omitempty"` // GUID of the resulting global memory dump.
	Success  bool   `json:"success,omitempty"`  // True iff the global memory dump succeeded.
}

// Do executes Tracing.requestMemoryDump against the provided context.
//
// returns:
//   dumpGUID - GUID of the resulting global memory dump.
//   success - True iff the global memory dump succeeded.
func (p *RequestMemoryDumpParams) Do(ctx context.Context) (dumpGUID string, success bool, err error) {
	// execute
	var res RequestMemoryDumpReturns
	err = cdp.Execute(ctx, CommandRequestMemoryDump, p, &res)
	if err != nil {
		return "", false, err
	}

	return res.DumpGUID, res.Success, nil
}

// StartParams start trace events collection.
type StartParams struct {
	BufferUsageReportingInterval float64           `json:"bufferUsageReportingInterval,omitempty"` // If set, the agent will issue bufferUsage events at this interval, specified in milliseconds
	TransferMode                 TransferMode      `json:"transferMode,omitempty"`                 // Whether to report trace events as series of dataCollected events or to save trace to a stream (defaults to ReportEvents).
	StreamFormat                 StreamFormat      `json:"streamFormat,omitempty"`                 // Trace data format to use. This only applies when using ReturnAsStream transfer mode (defaults to json).
	StreamCompression            StreamCompression `json:"streamCompression,omitempty"`            // Compression format to use. This only applies when using ReturnAsStream transfer mode (defaults to none)
	TraceConfig                  *TraceConfig      `json:"traceConfig,omitempty"`
	PerfettoConfig               string            `json:"perfettoConfig,omitempty"` // Base64-encoded serialized perfetto.protos.TraceConfig protobuf message When specified, the parameters categories, options, traceConfig are ignored.
	TracingBackend               Backend           `json:"tracingBackend,omitempty"` // Backend type (defaults to auto)
}

// Start start trace events collection.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Tracing#method-start
//
// parameters:
func Start() *StartParams {
	return &StartParams{}
}

// WithBufferUsageReportingInterval if set, the agent will issue bufferUsage
// events at this interval, specified in milliseconds.
func (p StartParams) WithBufferUsageReportingInterval(bufferUsageReportingInterval float64) *StartParams {
	p.BufferUsageReportingInterval = bufferUsageReportingInterval
	return &p
}

// WithTransferMode whether to report trace events as series of dataCollected
// events or to save trace to a stream (defaults to ReportEvents).
func (p StartParams) WithTransferMode(transferMode TransferMode) *StartParams {
	p.TransferMode = transferMode
	return &p
}

// WithStreamFormat trace data format to use. This only applies when using
// ReturnAsStream transfer mode (defaults to json).
func (p StartParams) WithStreamFormat(streamFormat StreamFormat) *StartParams {
	p.StreamFormat = streamFormat
	return &p
}

// WithStreamCompression compression format to use. This only applies when
// using ReturnAsStream transfer mode (defaults to none).
func (p StartParams) WithStreamCompression(streamCompression StreamCompression) *StartParams {
	p.StreamCompression = streamCompression
	return &p
}

// WithTraceConfig [no description].
func (p StartParams) WithTraceConfig(traceConfig *TraceConfig) *StartParams {
	p.TraceConfig = traceConfig
	return &p
}

// WithPerfettoConfig base64-encoded serialized perfetto.protos.TraceConfig
// protobuf message When specified, the parameters categories, options,
// traceConfig are ignored.
func (p StartParams) WithPerfettoConfig(perfettoConfig string) *StartParams {
	p.PerfettoConfig = perfettoConfig
	return &p
}

// WithTracingBackend backend type (defaults to auto).
func (p StartParams) WithTracingBackend(tracingBackend Backend) *StartParams {
	p.TracingBackend = tracingBackend
	return &p
}

// Do executes Tracing.start against the provided context.
func (p *StartParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandStart, p, nil)
}

// Command names.
const (
	CommandEnd                   = "Tracing.end"
	CommandGetCategories         = "Tracing.getCategories"
	CommandRecordClockSyncMarker = "Tracing.recordClockSyncMarker"
	CommandRequestMemoryDump     = "Tracing.requestMemoryDump"
	CommandStart                 = "Tracing.start"
)
