// Package overlay provides the Chrome DevTools Protocol
// commands, types, and events for the Overlay domain.
//
// This domain provides various functionality related to drawing atop the
// inspected page.
//
// Generated by the cdproto-gen command.
package overlay

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/dom"
	"github.com/chromedp/cdproto/runtime"
	"github.com/mailru/easyjson"
)

// DisableParams disables domain notifications.
type DisableParams struct{}

// Disable disables domain notifications.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-disable
func Disable() *DisableParams {
	return &DisableParams{}
}

// Do executes Overlay.disable against the provided context.
func (p *DisableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDisable, nil, nil)
}

// EnableParams enables domain notifications.
type EnableParams struct{}

// Enable enables domain notifications.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-enable
func Enable() *EnableParams {
	return &EnableParams{}
}

// Do executes Overlay.enable against the provided context.
func (p *EnableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnable, nil, nil)
}

// GetHighlightObjectForTestParams for testing.
type GetHighlightObjectForTestParams struct {
	NodeID                cdp.NodeID  `json:"nodeId"`                          // Id of the node to get highlight object for.
	IncludeDistance       bool        `json:"includeDistance,omitempty"`       // Whether to include distance info.
	IncludeStyle          bool        `json:"includeStyle,omitempty"`          // Whether to include style info.
	ColorFormat           ColorFormat `json:"colorFormat,omitempty"`           // The color format to get config with (default: hex).
	ShowAccessibilityInfo bool        `json:"showAccessibilityInfo,omitempty"` // Whether to show accessibility info (default: true).
}

// GetHighlightObjectForTest for testing.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-getHighlightObjectForTest
//
// parameters:
//   nodeID - Id of the node to get highlight object for.
func GetHighlightObjectForTest(nodeID cdp.NodeID) *GetHighlightObjectForTestParams {
	return &GetHighlightObjectForTestParams{
		NodeID: nodeID,
	}
}

// WithIncludeDistance whether to include distance info.
func (p GetHighlightObjectForTestParams) WithIncludeDistance(includeDistance bool) *GetHighlightObjectForTestParams {
	p.IncludeDistance = includeDistance
	return &p
}

// WithIncludeStyle whether to include style info.
func (p GetHighlightObjectForTestParams) WithIncludeStyle(includeStyle bool) *GetHighlightObjectForTestParams {
	p.IncludeStyle = includeStyle
	return &p
}

// WithColorFormat the color format to get config with (default: hex).
func (p GetHighlightObjectForTestParams) WithColorFormat(colorFormat ColorFormat) *GetHighlightObjectForTestParams {
	p.ColorFormat = colorFormat
	return &p
}

// WithShowAccessibilityInfo whether to show accessibility info (default:
// true).
func (p GetHighlightObjectForTestParams) WithShowAccessibilityInfo(showAccessibilityInfo bool) *GetHighlightObjectForTestParams {
	p.ShowAccessibilityInfo = showAccessibilityInfo
	return &p
}

// GetHighlightObjectForTestReturns return values.
type GetHighlightObjectForTestReturns struct {
	Highlight easyjson.RawMessage `json:"highlight,omitempty"`
}

// Do executes Overlay.getHighlightObjectForTest against the provided context.
//
// returns:
//   highlight - Highlight data for the node.
func (p *GetHighlightObjectForTestParams) Do(ctx context.Context) (highlight easyjson.RawMessage, err error) {
	// execute
	var res GetHighlightObjectForTestReturns
	err = cdp.Execute(ctx, CommandGetHighlightObjectForTest, p, &res)
	if err != nil {
		return nil, err
	}

	return res.Highlight, nil
}

// GetGridHighlightObjectsForTestParams for Persistent Grid testing.
type GetGridHighlightObjectsForTestParams struct {
	NodeIDs []cdp.NodeID `json:"nodeIds"` // Ids of the node to get highlight object for.
}

// GetGridHighlightObjectsForTest for Persistent Grid testing.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-getGridHighlightObjectsForTest
//
// parameters:
//   nodeIDs - Ids of the node to get highlight object for.
func GetGridHighlightObjectsForTest(nodeIDs []cdp.NodeID) *GetGridHighlightObjectsForTestParams {
	return &GetGridHighlightObjectsForTestParams{
		NodeIDs: nodeIDs,
	}
}

// GetGridHighlightObjectsForTestReturns return values.
type GetGridHighlightObjectsForTestReturns struct {
	Highlights easyjson.RawMessage `json:"highlights,omitempty"`
}

// Do executes Overlay.getGridHighlightObjectsForTest against the provided context.
//
// returns:
//   highlights - Grid Highlight data for the node ids provided.
func (p *GetGridHighlightObjectsForTestParams) Do(ctx context.Context) (highlights easyjson.RawMessage, err error) {
	// execute
	var res GetGridHighlightObjectsForTestReturns
	err = cdp.Execute(ctx, CommandGetGridHighlightObjectsForTest, p, &res)
	if err != nil {
		return nil, err
	}

	return res.Highlights, nil
}

// GetSourceOrderHighlightObjectForTestParams for Source Order Viewer
// testing.
type GetSourceOrderHighlightObjectForTestParams struct {
	NodeID cdp.NodeID `json:"nodeId"` // Id of the node to highlight.
}

// GetSourceOrderHighlightObjectForTest for Source Order Viewer testing.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-getSourceOrderHighlightObjectForTest
//
// parameters:
//   nodeID - Id of the node to highlight.
func GetSourceOrderHighlightObjectForTest(nodeID cdp.NodeID) *GetSourceOrderHighlightObjectForTestParams {
	return &GetSourceOrderHighlightObjectForTestParams{
		NodeID: nodeID,
	}
}

// GetSourceOrderHighlightObjectForTestReturns return values.
type GetSourceOrderHighlightObjectForTestReturns struct {
	Highlight easyjson.RawMessage `json:"highlight,omitempty"`
}

// Do executes Overlay.getSourceOrderHighlightObjectForTest against the provided context.
//
// returns:
//   highlight - Source order highlight data for the node id provided.
func (p *GetSourceOrderHighlightObjectForTestParams) Do(ctx context.Context) (highlight easyjson.RawMessage, err error) {
	// execute
	var res GetSourceOrderHighlightObjectForTestReturns
	err = cdp.Execute(ctx, CommandGetSourceOrderHighlightObjectForTest, p, &res)
	if err != nil {
		return nil, err
	}

	return res.Highlight, nil
}

// HideHighlightParams hides any highlight.
type HideHighlightParams struct{}

// HideHighlight hides any highlight.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-hideHighlight
func HideHighlight() *HideHighlightParams {
	return &HideHighlightParams{}
}

// Do executes Overlay.hideHighlight against the provided context.
func (p *HideHighlightParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandHideHighlight, nil, nil)
}

// HighlightNodeParams highlights DOM node with given id or with the given
// JavaScript object wrapper. Either nodeId or objectId must be specified.
type HighlightNodeParams struct {
	HighlightConfig *HighlightConfig       `json:"highlightConfig"`         // A descriptor for the highlight appearance.
	NodeID          cdp.NodeID             `json:"nodeId,omitempty"`        // Identifier of the node to highlight.
	BackendNodeID   cdp.BackendNodeID      `json:"backendNodeId,omitempty"` // Identifier of the backend node to highlight.
	ObjectID        runtime.RemoteObjectID `json:"objectId,omitempty"`      // JavaScript object id of the node to be highlighted.
	Selector        string                 `json:"selector,omitempty"`      // Selectors to highlight relevant nodes.
}

// HighlightNode highlights DOM node with given id or with the given
// JavaScript object wrapper. Either nodeId or objectId must be specified.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-highlightNode
//
// parameters:
//   highlightConfig - A descriptor for the highlight appearance.
func HighlightNode(highlightConfig *HighlightConfig) *HighlightNodeParams {
	return &HighlightNodeParams{
		HighlightConfig: highlightConfig,
	}
}

// WithNodeID identifier of the node to highlight.
func (p HighlightNodeParams) WithNodeID(nodeID cdp.NodeID) *HighlightNodeParams {
	p.NodeID = nodeID
	return &p
}

// WithBackendNodeID identifier of the backend node to highlight.
func (p HighlightNodeParams) WithBackendNodeID(backendNodeID cdp.BackendNodeID) *HighlightNodeParams {
	p.BackendNodeID = backendNodeID
	return &p
}

// WithObjectID JavaScript object id of the node to be highlighted.
func (p HighlightNodeParams) WithObjectID(objectID runtime.RemoteObjectID) *HighlightNodeParams {
	p.ObjectID = objectID
	return &p
}

// WithSelector selectors to highlight relevant nodes.
func (p HighlightNodeParams) WithSelector(selector string) *HighlightNodeParams {
	p.Selector = selector
	return &p
}

// Do executes Overlay.highlightNode against the provided context.
func (p *HighlightNodeParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandHighlightNode, p, nil)
}

// HighlightQuadParams highlights given quad. Coordinates are absolute with
// respect to the main frame viewport.
type HighlightQuadParams struct {
	Quad         dom.Quad  `json:"quad"`                   // Quad to highlight
	Color        *cdp.RGBA `json:"color,omitempty"`        // The highlight fill color (default: transparent).
	OutlineColor *cdp.RGBA `json:"outlineColor,omitempty"` // The highlight outline color (default: transparent).
}

// HighlightQuad highlights given quad. Coordinates are absolute with respect
// to the main frame viewport.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-highlightQuad
//
// parameters:
//   quad - Quad to highlight
func HighlightQuad(quad dom.Quad) *HighlightQuadParams {
	return &HighlightQuadParams{
		Quad: quad,
	}
}

// WithColor the highlight fill color (default: transparent).
func (p HighlightQuadParams) WithColor(color *cdp.RGBA) *HighlightQuadParams {
	p.Color = color
	return &p
}

// WithOutlineColor the highlight outline color (default: transparent).
func (p HighlightQuadParams) WithOutlineColor(outlineColor *cdp.RGBA) *HighlightQuadParams {
	p.OutlineColor = outlineColor
	return &p
}

// Do executes Overlay.highlightQuad against the provided context.
func (p *HighlightQuadParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandHighlightQuad, p, nil)
}

// HighlightRectParams highlights given rectangle. Coordinates are absolute
// with respect to the main frame viewport.
type HighlightRectParams struct {
	X            int64     `json:"x"`                      // X coordinate
	Y            int64     `json:"y"`                      // Y coordinate
	Width        int64     `json:"width"`                  // Rectangle width
	Height       int64     `json:"height"`                 // Rectangle height
	Color        *cdp.RGBA `json:"color,omitempty"`        // The highlight fill color (default: transparent).
	OutlineColor *cdp.RGBA `json:"outlineColor,omitempty"` // The highlight outline color (default: transparent).
}

// HighlightRect highlights given rectangle. Coordinates are absolute with
// respect to the main frame viewport.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-highlightRect
//
// parameters:
//   x - X coordinate
//   y - Y coordinate
//   width - Rectangle width
//   height - Rectangle height
func HighlightRect(x int64, y int64, width int64, height int64) *HighlightRectParams {
	return &HighlightRectParams{
		X:      x,
		Y:      y,
		Width:  width,
		Height: height,
	}
}

// WithColor the highlight fill color (default: transparent).
func (p HighlightRectParams) WithColor(color *cdp.RGBA) *HighlightRectParams {
	p.Color = color
	return &p
}

// WithOutlineColor the highlight outline color (default: transparent).
func (p HighlightRectParams) WithOutlineColor(outlineColor *cdp.RGBA) *HighlightRectParams {
	p.OutlineColor = outlineColor
	return &p
}

// Do executes Overlay.highlightRect against the provided context.
func (p *HighlightRectParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandHighlightRect, p, nil)
}

// HighlightSourceOrderParams highlights the source order of the children of
// the DOM node with given id or with the given JavaScript object wrapper.
// Either nodeId or objectId must be specified.
type HighlightSourceOrderParams struct {
	SourceOrderConfig *SourceOrderConfig     `json:"sourceOrderConfig"`       // A descriptor for the appearance of the overlay drawing.
	NodeID            cdp.NodeID             `json:"nodeId,omitempty"`        // Identifier of the node to highlight.
	BackendNodeID     cdp.BackendNodeID      `json:"backendNodeId,omitempty"` // Identifier of the backend node to highlight.
	ObjectID          runtime.RemoteObjectID `json:"objectId,omitempty"`      // JavaScript object id of the node to be highlighted.
}

// HighlightSourceOrder highlights the source order of the children of the
// DOM node with given id or with the given JavaScript object wrapper. Either
// nodeId or objectId must be specified.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-highlightSourceOrder
//
// parameters:
//   sourceOrderConfig - A descriptor for the appearance of the overlay drawing.
func HighlightSourceOrder(sourceOrderConfig *SourceOrderConfig) *HighlightSourceOrderParams {
	return &HighlightSourceOrderParams{
		SourceOrderConfig: sourceOrderConfig,
	}
}

// WithNodeID identifier of the node to highlight.
func (p HighlightSourceOrderParams) WithNodeID(nodeID cdp.NodeID) *HighlightSourceOrderParams {
	p.NodeID = nodeID
	return &p
}

// WithBackendNodeID identifier of the backend node to highlight.
func (p HighlightSourceOrderParams) WithBackendNodeID(backendNodeID cdp.BackendNodeID) *HighlightSourceOrderParams {
	p.BackendNodeID = backendNodeID
	return &p
}

// WithObjectID JavaScript object id of the node to be highlighted.
func (p HighlightSourceOrderParams) WithObjectID(objectID runtime.RemoteObjectID) *HighlightSourceOrderParams {
	p.ObjectID = objectID
	return &p
}

// Do executes Overlay.highlightSourceOrder against the provided context.
func (p *HighlightSourceOrderParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandHighlightSourceOrder, p, nil)
}

// SetInspectModeParams enters the 'inspect' mode. In this mode, elements
// that user is hovering over are highlighted. Backend then generates
// 'inspectNodeRequested' event upon element selection.
type SetInspectModeParams struct {
	Mode            InspectMode      `json:"mode"`                      // Set an inspection mode.
	HighlightConfig *HighlightConfig `json:"highlightConfig,omitempty"` // A descriptor for the highlight appearance of hovered-over nodes. May be omitted if enabled == false.
}

// SetInspectMode enters the 'inspect' mode. In this mode, elements that user
// is hovering over are highlighted. Backend then generates
// 'inspectNodeRequested' event upon element selection.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setInspectMode
//
// parameters:
//   mode - Set an inspection mode.
func SetInspectMode(mode InspectMode) *SetInspectModeParams {
	return &SetInspectModeParams{
		Mode: mode,
	}
}

// WithHighlightConfig a descriptor for the highlight appearance of
// hovered-over nodes. May be omitted if enabled == false.
func (p SetInspectModeParams) WithHighlightConfig(highlightConfig *HighlightConfig) *SetInspectModeParams {
	p.HighlightConfig = highlightConfig
	return &p
}

// Do executes Overlay.setInspectMode against the provided context.
func (p *SetInspectModeParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetInspectMode, p, nil)
}

// SetShowAdHighlightsParams highlights owner element of all frames detected
// to be ads.
type SetShowAdHighlightsParams struct {
	Show bool `json:"show"` // True for showing ad highlights
}

// SetShowAdHighlights highlights owner element of all frames detected to be
// ads.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowAdHighlights
//
// parameters:
//   show - True for showing ad highlights
func SetShowAdHighlights(show bool) *SetShowAdHighlightsParams {
	return &SetShowAdHighlightsParams{
		Show: show,
	}
}

// Do executes Overlay.setShowAdHighlights against the provided context.
func (p *SetShowAdHighlightsParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowAdHighlights, p, nil)
}

// SetPausedInDebuggerMessageParams [no description].
type SetPausedInDebuggerMessageParams struct {
	Message string `json:"message,omitempty"` // The message to display, also triggers resume and step over controls.
}

// SetPausedInDebuggerMessage [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setPausedInDebuggerMessage
//
// parameters:
func SetPausedInDebuggerMessage() *SetPausedInDebuggerMessageParams {
	return &SetPausedInDebuggerMessageParams{}
}

// WithMessage the message to display, also triggers resume and step over
// controls.
func (p SetPausedInDebuggerMessageParams) WithMessage(message string) *SetPausedInDebuggerMessageParams {
	p.Message = message
	return &p
}

// Do executes Overlay.setPausedInDebuggerMessage against the provided context.
func (p *SetPausedInDebuggerMessageParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetPausedInDebuggerMessage, p, nil)
}

// SetShowDebugBordersParams requests that backend shows debug borders on
// layers.
type SetShowDebugBordersParams struct {
	Show bool `json:"show"` // True for showing debug borders
}

// SetShowDebugBorders requests that backend shows debug borders on layers.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowDebugBorders
//
// parameters:
//   show - True for showing debug borders
func SetShowDebugBorders(show bool) *SetShowDebugBordersParams {
	return &SetShowDebugBordersParams{
		Show: show,
	}
}

// Do executes Overlay.setShowDebugBorders against the provided context.
func (p *SetShowDebugBordersParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowDebugBorders, p, nil)
}

// SetShowFPSCounterParams requests that backend shows the FPS counter.
type SetShowFPSCounterParams struct {
	Show bool `json:"show"` // True for showing the FPS counter
}

// SetShowFPSCounter requests that backend shows the FPS counter.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowFPSCounter
//
// parameters:
//   show - True for showing the FPS counter
func SetShowFPSCounter(show bool) *SetShowFPSCounterParams {
	return &SetShowFPSCounterParams{
		Show: show,
	}
}

// Do executes Overlay.setShowFPSCounter against the provided context.
func (p *SetShowFPSCounterParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowFPSCounter, p, nil)
}

// SetShowGridOverlaysParams highlight multiple elements with the CSS Grid
// overlay.
type SetShowGridOverlaysParams struct {
	GridNodeHighlightConfigs []*GridNodeHighlightConfig `json:"gridNodeHighlightConfigs"` // An array of node identifiers and descriptors for the highlight appearance.
}

// SetShowGridOverlays highlight multiple elements with the CSS Grid overlay.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowGridOverlays
//
// parameters:
//   gridNodeHighlightConfigs - An array of node identifiers and descriptors for the highlight appearance.
func SetShowGridOverlays(gridNodeHighlightConfigs []*GridNodeHighlightConfig) *SetShowGridOverlaysParams {
	return &SetShowGridOverlaysParams{
		GridNodeHighlightConfigs: gridNodeHighlightConfigs,
	}
}

// Do executes Overlay.setShowGridOverlays against the provided context.
func (p *SetShowGridOverlaysParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowGridOverlays, p, nil)
}

// SetShowFlexOverlaysParams [no description].
type SetShowFlexOverlaysParams struct {
	FlexNodeHighlightConfigs []*FlexNodeHighlightConfig `json:"flexNodeHighlightConfigs"` // An array of node identifiers and descriptors for the highlight appearance.
}

// SetShowFlexOverlays [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowFlexOverlays
//
// parameters:
//   flexNodeHighlightConfigs - An array of node identifiers and descriptors for the highlight appearance.
func SetShowFlexOverlays(flexNodeHighlightConfigs []*FlexNodeHighlightConfig) *SetShowFlexOverlaysParams {
	return &SetShowFlexOverlaysParams{
		FlexNodeHighlightConfigs: flexNodeHighlightConfigs,
	}
}

// Do executes Overlay.setShowFlexOverlays against the provided context.
func (p *SetShowFlexOverlaysParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowFlexOverlays, p, nil)
}

// SetShowScrollSnapOverlaysParams [no description].
type SetShowScrollSnapOverlaysParams struct {
	ScrollSnapHighlightConfigs []*ScrollSnapHighlightConfig `json:"scrollSnapHighlightConfigs"` // An array of node identifiers and descriptors for the highlight appearance.
}

// SetShowScrollSnapOverlays [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowScrollSnapOverlays
//
// parameters:
//   scrollSnapHighlightConfigs - An array of node identifiers and descriptors for the highlight appearance.
func SetShowScrollSnapOverlays(scrollSnapHighlightConfigs []*ScrollSnapHighlightConfig) *SetShowScrollSnapOverlaysParams {
	return &SetShowScrollSnapOverlaysParams{
		ScrollSnapHighlightConfigs: scrollSnapHighlightConfigs,
	}
}

// Do executes Overlay.setShowScrollSnapOverlays against the provided context.
func (p *SetShowScrollSnapOverlaysParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowScrollSnapOverlays, p, nil)
}

// SetShowContainerQueryOverlaysParams [no description].
type SetShowContainerQueryOverlaysParams struct {
	ContainerQueryHighlightConfigs []*ContainerQueryHighlightConfig `json:"containerQueryHighlightConfigs"` // An array of node identifiers and descriptors for the highlight appearance.
}

// SetShowContainerQueryOverlays [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowContainerQueryOverlays
//
// parameters:
//   containerQueryHighlightConfigs - An array of node identifiers and descriptors for the highlight appearance.
func SetShowContainerQueryOverlays(containerQueryHighlightConfigs []*ContainerQueryHighlightConfig) *SetShowContainerQueryOverlaysParams {
	return &SetShowContainerQueryOverlaysParams{
		ContainerQueryHighlightConfigs: containerQueryHighlightConfigs,
	}
}

// Do executes Overlay.setShowContainerQueryOverlays against the provided context.
func (p *SetShowContainerQueryOverlaysParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowContainerQueryOverlays, p, nil)
}

// SetShowPaintRectsParams requests that backend shows paint rectangles.
type SetShowPaintRectsParams struct {
	Result bool `json:"result"` // True for showing paint rectangles
}

// SetShowPaintRects requests that backend shows paint rectangles.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowPaintRects
//
// parameters:
//   result - True for showing paint rectangles
func SetShowPaintRects(result bool) *SetShowPaintRectsParams {
	return &SetShowPaintRectsParams{
		Result: result,
	}
}

// Do executes Overlay.setShowPaintRects against the provided context.
func (p *SetShowPaintRectsParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowPaintRects, p, nil)
}

// SetShowLayoutShiftRegionsParams requests that backend shows layout shift
// regions.
type SetShowLayoutShiftRegionsParams struct {
	Result bool `json:"result"` // True for showing layout shift regions
}

// SetShowLayoutShiftRegions requests that backend shows layout shift
// regions.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowLayoutShiftRegions
//
// parameters:
//   result - True for showing layout shift regions
func SetShowLayoutShiftRegions(result bool) *SetShowLayoutShiftRegionsParams {
	return &SetShowLayoutShiftRegionsParams{
		Result: result,
	}
}

// Do executes Overlay.setShowLayoutShiftRegions against the provided context.
func (p *SetShowLayoutShiftRegionsParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowLayoutShiftRegions, p, nil)
}

// SetShowScrollBottleneckRectsParams requests that backend shows scroll
// bottleneck rects.
type SetShowScrollBottleneckRectsParams struct {
	Show bool `json:"show"` // True for showing scroll bottleneck rects
}

// SetShowScrollBottleneckRects requests that backend shows scroll bottleneck
// rects.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowScrollBottleneckRects
//
// parameters:
//   show - True for showing scroll bottleneck rects
func SetShowScrollBottleneckRects(show bool) *SetShowScrollBottleneckRectsParams {
	return &SetShowScrollBottleneckRectsParams{
		Show: show,
	}
}

// Do executes Overlay.setShowScrollBottleneckRects against the provided context.
func (p *SetShowScrollBottleneckRectsParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowScrollBottleneckRects, p, nil)
}

// SetShowWebVitalsParams request that backend shows an overlay with web
// vital metrics.
type SetShowWebVitalsParams struct {
	Show bool `json:"show"`
}

// SetShowWebVitals request that backend shows an overlay with web vital
// metrics.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowWebVitals
//
// parameters:
//   show
func SetShowWebVitals(show bool) *SetShowWebVitalsParams {
	return &SetShowWebVitalsParams{
		Show: show,
	}
}

// Do executes Overlay.setShowWebVitals against the provided context.
func (p *SetShowWebVitalsParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowWebVitals, p, nil)
}

// SetShowViewportSizeOnResizeParams paints viewport size upon main frame
// resize.
type SetShowViewportSizeOnResizeParams struct {
	Show bool `json:"show"` // Whether to paint size or not.
}

// SetShowViewportSizeOnResize paints viewport size upon main frame resize.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowViewportSizeOnResize
//
// parameters:
//   show - Whether to paint size or not.
func SetShowViewportSizeOnResize(show bool) *SetShowViewportSizeOnResizeParams {
	return &SetShowViewportSizeOnResizeParams{
		Show: show,
	}
}

// Do executes Overlay.setShowViewportSizeOnResize against the provided context.
func (p *SetShowViewportSizeOnResizeParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowViewportSizeOnResize, p, nil)
}

// SetShowHingeParams add a dual screen device hinge.
type SetShowHingeParams struct {
	HingeConfig *HingeConfig `json:"hingeConfig,omitempty"` // hinge data, null means hideHinge
}

// SetShowHinge add a dual screen device hinge.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowHinge
//
// parameters:
func SetShowHinge() *SetShowHingeParams {
	return &SetShowHingeParams{}
}

// WithHingeConfig hinge data, null means hideHinge.
func (p SetShowHingeParams) WithHingeConfig(hingeConfig *HingeConfig) *SetShowHingeParams {
	p.HingeConfig = hingeConfig
	return &p
}

// Do executes Overlay.setShowHinge against the provided context.
func (p *SetShowHingeParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowHinge, p, nil)
}

// SetShowIsolatedElementsParams show elements in isolation mode with
// overlays.
type SetShowIsolatedElementsParams struct {
	IsolatedElementHighlightConfigs []*IsolatedElementHighlightConfig `json:"isolatedElementHighlightConfigs"` // An array of node identifiers and descriptors for the highlight appearance.
}

// SetShowIsolatedElements show elements in isolation mode with overlays.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Overlay#method-setShowIsolatedElements
//
// parameters:
//   isolatedElementHighlightConfigs - An array of node identifiers and descriptors for the highlight appearance.
func SetShowIsolatedElements(isolatedElementHighlightConfigs []*IsolatedElementHighlightConfig) *SetShowIsolatedElementsParams {
	return &SetShowIsolatedElementsParams{
		IsolatedElementHighlightConfigs: isolatedElementHighlightConfigs,
	}
}

// Do executes Overlay.setShowIsolatedElements against the provided context.
func (p *SetShowIsolatedElementsParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetShowIsolatedElements, p, nil)
}

// Command names.
const (
	CommandDisable                              = "Overlay.disable"
	CommandEnable                               = "Overlay.enable"
	CommandGetHighlightObjectForTest            = "Overlay.getHighlightObjectForTest"
	CommandGetGridHighlightObjectsForTest       = "Overlay.getGridHighlightObjectsForTest"
	CommandGetSourceOrderHighlightObjectForTest = "Overlay.getSourceOrderHighlightObjectForTest"
	CommandHideHighlight                        = "Overlay.hideHighlight"
	CommandHighlightNode                        = "Overlay.highlightNode"
	CommandHighlightQuad                        = "Overlay.highlightQuad"
	CommandHighlightRect                        = "Overlay.highlightRect"
	CommandHighlightSourceOrder                 = "Overlay.highlightSourceOrder"
	CommandSetInspectMode                       = "Overlay.setInspectMode"
	CommandSetShowAdHighlights                  = "Overlay.setShowAdHighlights"
	CommandSetPausedInDebuggerMessage           = "Overlay.setPausedInDebuggerMessage"
	CommandSetShowDebugBorders                  = "Overlay.setShowDebugBorders"
	CommandSetShowFPSCounter                    = "Overlay.setShowFPSCounter"
	CommandSetShowGridOverlays                  = "Overlay.setShowGridOverlays"
	CommandSetShowFlexOverlays                  = "Overlay.setShowFlexOverlays"
	CommandSetShowScrollSnapOverlays            = "Overlay.setShowScrollSnapOverlays"
	CommandSetShowContainerQueryOverlays        = "Overlay.setShowContainerQueryOverlays"
	CommandSetShowPaintRects                    = "Overlay.setShowPaintRects"
	CommandSetShowLayoutShiftRegions            = "Overlay.setShowLayoutShiftRegions"
	CommandSetShowScrollBottleneckRects         = "Overlay.setShowScrollBottleneckRects"
	CommandSetShowWebVitals                     = "Overlay.setShowWebVitals"
	CommandSetShowViewportSizeOnResize          = "Overlay.setShowViewportSizeOnResize"
	CommandSetShowHinge                         = "Overlay.setShowHinge"
	CommandSetShowIsolatedElements              = "Overlay.setShowIsolatedElements"
)
