// The code in this file was automatically generated by running httprequest-generate-client.
// DO NOT EDIT

package candidclient

import (
	"context"
	"github.com/canonical/candid/params"
	"gopkg.in/httprequest.v1"
	"gopkg.in/macaroon-bakery.v2/bakery"
)

type client struct {
	Client httprequest.Client
}

// ClearUserMFACredentials removes all MFA credentials for a user.
func (c *client) ClearUserMFACredentials(ctx context.Context, p *params.ClearUserMFACredentialsRequest) error {
	return c.Client.Call(ctx, p, nil)
}

// CreateAgent creates a new agent and returns the newly chosen username
// for the agent.
func (c *client) CreateAgent(ctx context.Context, p *params.CreateAgentRequest) (*params.CreateAgentResponse, error) {
	var r *params.CreateAgentResponse
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// DeleteSSHKeys removes all of the ssh keys specified from the keys
// stored for the given user. It is not an error to attempt to remove a
// key that is not associated with the user.
func (c *client) DeleteSSHKeys(ctx context.Context, p *params.DeleteSSHKeysRequest) error {
	return c.Client.Call(ctx, p, nil)
}

// DischargeTokenForUser allows an administrator to create a discharge
// token for the specified user.
func (c *client) DischargeTokenForUser(ctx context.Context, p *params.DischargeTokenForUserRequest) (params.DischargeTokenForUserResponse, error) {
	var r params.DischargeTokenForUserResponse
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// GetSSHKeys returns any SSH keys stored for the given user.
func (c *client) GetSSHKeys(ctx context.Context, p *params.SSHKeysRequest) (params.SSHKeysResponse, error) {
	var r params.SSHKeysResponse
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// GetUserGroupsWithID returns the groups for a user with the given ID.
func (c *client) GetUserGroupsWithID(ctx context.Context, p *params.GetUserGroupsWithIDRequest) (*params.GroupsResponse, error) {
	var r *params.GroupsResponse
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// GetUserWithID returns the user information for the request user.
func (c *client) GetUserWithID(ctx context.Context, p *params.GetUserWithIDRequest) (*params.User, error) {
	var r *params.User
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// ModifyUserGroups updates the groups stored for the given user. Groups
// can be either added or removed in a single query. It is an error to
// try and both add and remove groups at the same time.
func (c *client) ModifyUserGroups(ctx context.Context, p *params.ModifyUserGroupsRequest) error {
	return c.Client.Call(ctx, p, nil)
}

// PutSSHKeys updates the set of SSH keys stored for the given user. If
// the add parameter is set to true then keys that are already stored
// will be added to, otherwise they will be replaced.
func (c *client) PutSSHKeys(ctx context.Context, p *params.PutSSHKeysRequest) error {
	return c.Client.Call(ctx, p, nil)
}

// QueryUsers filters the user database for users that match the given
// request. If no filters are requested all usernames will be returned.
func (c *client) QueryUsers(ctx context.Context, p *params.QueryUsersRequest) ([]string, error) {
	var r []string
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// SetUserDeprecated creates or updates the user with the given username. If the
// user already exists then any IDPGroups or SSHKeys specified in the
// request will be ignored. See SetUserGroups, ModifyUserGroups,
// SetSSHKeys and DeleteSSHKeys if you wish to manipulate these for a
// user.
// TODO change this into a create-agent function.
func (c *client) SetUserDeprecated(ctx context.Context, p *params.SetUserRequest) error {
	return c.Client.Call(ctx, p, nil)
}

// SetUserExtraInfo updates extra-info for the given user. For each
// specified extra-info field the stored values will be updated to be the
// specified value. All other values will remain unchanged.
func (c *client) SetUserExtraInfo(ctx context.Context, p *params.SetUserExtraInfoRequest) error {
	return c.Client.Call(ctx, p, nil)
}

// SetUserExtraInfoItem updates the stored extra-info item with the given
// key for the given user.
func (c *client) SetUserExtraInfoItem(ctx context.Context, p *params.SetUserExtraInfoItemRequest) error {
	return c.Client.Call(ctx, p, nil)
}

// SetUserGroups updates the groups stored for the given user to the
// given value.
func (c *client) SetUserGroups(ctx context.Context, p *params.SetUserGroupsRequest) error {
	return c.Client.Call(ctx, p, nil)
}

// User returns the user information for the request user.
func (c *client) User(ctx context.Context, p *params.UserRequest) (*params.User, error) {
	var r *params.User
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// UserExtraInfo returns any stored extra-info for the given user.
func (c *client) UserExtraInfo(ctx context.Context, p *params.UserExtraInfoRequest) (map[string]interface{}, error) {
	var r map[string]interface{}
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// UserExtraInfoItem returns any stored extra-info item with the given
// key for the given user.
func (c *client) UserExtraInfoItem(ctx context.Context, p *params.UserExtraInfoItemRequest) (interface{}, error) {
	var r interface{}
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// UserGroups returns the list of groups associated with the requested
// user.
func (c *client) UserGroups(ctx context.Context, p *params.UserGroupsRequest) ([]string, error) {
	var r []string
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// UserIDPGroups returns the list of groups associated with the requested
// user. This is deprected and UserGroups should be used in preference.
func (c *client) UserIDPGroups(ctx context.Context, p *params.UserIDPGroupsRequest) ([]string, error) {
	var r []string
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// UserToken returns a token, in the form of a macaroon, identifying
// the user. This token can only be generated by an administrator.
func (c *client) UserToken(ctx context.Context, p *params.UserTokenRequest) (*bakery.Macaroon, error) {
	var r *bakery.Macaroon
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// VerifyToken verifies that the given token is a macaroon generated by
// this service and returns any declared values.
func (c *client) VerifyToken(ctx context.Context, p *params.VerifyTokenRequest) (map[string]string, error) {
	var r map[string]string
	err := c.Client.Call(ctx, p, &r)
	return r, err
}

// WhoAmI returns details of the authenticated user.
func (c *client) WhoAmI(ctx context.Context, p *params.WhoAmIRequest) (params.WhoAmIResponse, error) {
	var r params.WhoAmIResponse
	err := c.Client.Call(ctx, p, &r)
	return r, err
}
