package gatt

import (
	"bytes"
	"encoding/binary"
	"errors"
	"strings"
)

// ref. https://www.bluetooth.com/specifications/assigned-numbers/company-identifiers
var CompanyIdents = map[uint16]string{
	0x0000: "Ericsson Technology Licensing",
	0x0001: "Nokia Mobile Phones",
	0x0002: "Intel Corp.",
	0x0003: "IBM Corp.",
	0x0004: "Toshiba Corp.",
	0x0005: "3Com",
	0x0006: "Microsoft",
	0x0007: "Lucent",
	0x0008: "Motorola",
	0x0009: "Infineon Technologies AG",
	0x000A: "Qualcomm Technologies International, Ltd. (QTIL)",
	0x000B: "Silicon Wave",
	0x000C: "Digianswer A/S",
	0x000D: "Texas Instruments Inc.",
	0x000E: "Parthus Technologies Inc.",
	0x000F: "Broadcom Corporation",
	0x0010: "Mitel Semiconductor",
	0x0011: "Widcomm, Inc.",
	0x0012: "Zeevo, Inc.",
	0x0013: "Atmel Corporation",
	0x0014: "Mitsubishi Electric Corporation",
	0x0015: "RTX Telecom A/S",
	0x0016: "KC Technology Inc.",
	0x0017: "Newlogic",
	0x0018: "Transilica, Inc.",
	0x0019: "Rohde &amp; Schwarz GmbH &amp; Co. KG",
	0x001A: "TTPCom Limited",
	0x001B: "Signia Technologies, Inc.",
	0x001C: "Conexant Systems Inc.",
	0x001D: "Qualcomm",
	0x001E: "Inventel",
	0x001F: "AVM Berlin",
	0x0020: "BandSpeed, Inc.",
	0x0021: "Mansella Ltd",
	0x0022: "NEC Corporation",
	0x0023: "WavePlus Technology Co., Ltd.",
	0x0024: "Alcatel",
	0x0025: "NXP Semiconductors (formerly Philips Semiconductors)",
	0x0026: "C Technologies",
	0x0027: "Open Interface",
	0x0028: "R F Micro Devices",
	0x0029: "Hitachi Ltd",
	0x002A: "Symbol Technologies, Inc.",
	0x002B: "Tenovis",
	0x002C: "Macronix International Co. Ltd.",
	0x002D: "GCT Semiconductor",
	0x002E: "Norwood Systems",
	0x002F: "MewTel Technology Inc.",
	0x0030: "ST Microelectronics",
	0x0031: "Synopsys, Inc.",
	0x0032: "Red-M (Communications) Ltd",
	0x0033: "Commil Ltd",
	0x0034: "Computer Access Technology Corporation (CATC)",
	0x0035: "Eclipse (HQ Espana) S.L.",
	0x0036: "Renesas Electronics Corporation",
	0x0037: "Mobilian Corporation",
	0x0038: "Syntronix Corporation",
	0x0039: "Integrated System Solution Corp.",
	0x003A: "Matsushita Electric Industrial Co., Ltd.",
	0x003B: "Gennum Corporation",
	0x003C: "BlackBerry Limited  (formerly Research In Motion)",
	0x003D: "IPextreme, Inc.",
	0x003E: "Systems and Chips, Inc",
	0x003F: "Bluetooth SIG, Inc",
	0x0040: "Seiko Epson Corporation",
	0x0041: "Integrated Silicon Solution Taiwan, Inc.",
	0x0042: "CONWISE Technology Corporation Ltd",
	0x0043: "PARROT AUTOMOTIVE SAS",
	0x0044: "Socket Mobile",
	0x0045: "Atheros Communications, Inc.",
	0x0046: "MediaTek, Inc.",
	0x0047: "Bluegiga",
	0x0048: "Marvell Technology Group Ltd.",
	0x0049: "3DSP Corporation",
	0x004A: "Accel Semiconductor Ltd.",
	0x004B: "Continental Automotive Systems",
	0x004C: "Apple, Inc.",
	0x004D: "Staccato Communications, Inc.",
	0x004E: "Avago Technologies",
	0x004F: "APT Ltd.",
	0x0050: "SiRF Technology, Inc.",
	0x0051: "Tzero Technologies, Inc.",
	0x0052: "J&amp;M Corporation",
	0x0053: "Free2move AB",
	0x0054: "3DiJoy Corporation",
	0x0055: "Plantronics, Inc.",
	0x0056: "Sony Ericsson Mobile Communications",
	0x0057: "Harman International Industries, Inc.",
	0x0058: "Vizio, Inc.",
	0x0059: "Nordic Semiconductor ASA",
	0x005A: "EM Microelectronic-Marin SA",
	0x005B: "Ralink Technology Corporation",
	0x005C: "Belkin International, Inc. ",
	0x005D: "Realtek Semiconductor Corporation",
	0x005E: "Stonestreet One, LLC",
	0x005F: "Wicentric, Inc.",
	0x0060: "RivieraWaves S.A.S",
	0x0061: "RDA Microelectronics",
	0x0062: "Gibson Guitars",
	0x0063: "MiCommand Inc.",
	0x0064: "Band XI International, LLC",
	0x0065: "Hewlett-Packard Company",
	0x0066: "9Solutions Oy",
	0x0067: "GN Netcom A/S",
	0x0068: "General Motors",
	0x0069: "A&amp;D Engineering, Inc.",
	0x006A: "MindTree Ltd.",
	0x006B: "Polar Electro OY",
	0x006C: "Beautiful Enterprise Co., Ltd.",
	0x006D: "BriarTek, Inc",
	0x006E: "Summit Data Communications, Inc.",
	0x006F: "Sound ID",
	0x0070: "Monster, LLC",
	0x0071: "connectBlue AB",
	0x0072: "ShangHai Super Smart Electronics Co. Ltd.",
	0x0073: "Group Sense Ltd. ",
	0x0074: "Zomm, LLC",
	0x0075: "Samsung Electronics Co. Ltd.",
	0x0076: "Creative Technology Ltd.",
	0x0077: "Laird Technologies",
	0x0078: "Nike, Inc.",
	0x0079: "lesswire AG",
	0x007A: "MStar Semiconductor, Inc.",
	0x007B: "Hanlynn Technologies",
	0x007C: "A &amp; R Cambridge",
	0x007D: "Seers Technology Co., Ltd.",
	0x007E: "Sports Tracking Technologies Ltd.",
	0x007F: "Autonet Mobile",
	0x0080: "DeLorme Publishing Company, Inc.",
	0x0081: "WuXi Vimicro",
	0x0082: "Sennheiser Communications A/S",
	0x0083: "TimeKeeping Systems, Inc.",
	0x0084: "Ludus Helsinki Ltd.",
	0x0085: "BlueRadios, Inc.",
	0x0086: "Equinux AG",
	0x0087: "Garmin International, Inc.",
	0x0088: "Ecotest",
	0x0089: "GN ReSound A/S",
	0x008A: "Jawbone",
	0x008B: "Topcon Positioning Systems, LLC",
	0x008C: "Gimbal Inc. (formerly Qualcomm Labs, Inc. and Qualcomm Retail Solutions, Inc.)",
	0x008D: "Zscan Software",
	0x008E: "Quintic Corp",
	0x008F: "Telit Wireless Solutions GmbH (formerly Stollmann E+V GmbH)",
	0x0090: "Funai Electric Co., Ltd.",
	0x0091: "Advanced PANMOBIL systems GmbH &amp; Co. KG",
	0x0092: "ThinkOptics, Inc. ",
	0x0093: "Universal Electronics, Inc.",
	0x0094: "Airoha Technology Corp.",
	0x0095: "NEC Lighting, Ltd.",
	0x0096: "ODM Technology, Inc.",
	0x0097: "ConnecteDevice Ltd.",
	0x0098: "zero1.tv GmbH",
	0x0099: "i.Tech Dynamic Global Distribution Ltd.",
	0x009A: "Alpwise",
	0x009B: "Jiangsu Toppower Automotive Electronics Co., Ltd.",
	0x009C: "Colorfy, Inc.",
	0x009D: "Geoforce Inc.",
	0x009E: "Bose Corporation",
	0x009F: "Suunto Oy",
	0x00A0: "Kensington Computer Products Group",
	0x00A1: "SR-Medizinelektronik",
	0x00A2: "Vertu Corporation Limited",
	0x00A3: "Meta Watch Ltd.",
	0x00A4: "LINAK A/S",
	0x00A5: "OTL Dynamics LLC",
	0x00A6: "Panda Ocean Inc.",
	0x00A7: "Visteon Corporation",
	0x00A8: "ARP Devices Limited",
	0x00A9: "Magneti Marelli S.p.A",
	0x00AA: "CAEN RFID srl",
	0x00AB: "Ingenieur-Systemgruppe Zahn GmbH",
	0x00AC: "Green Throttle Games",
	0x00AD: "Peter Systemtechnik GmbH",
	0x00AE: "Omegawave Oy",
	0x00AF: "Cinetix",
	0x00B0: "Passif Semiconductor Corp",
	0x00B1: "Saris Cycling Group, Inc",
	0x00B2: "Bekey A/S",
	0x00B3: "Clarinox Technologies Pty. Ltd.",
	0x00B4: "BDE Technology Co., Ltd.",
	0x00B5: "Swirl Networks",
	0x00B6: "Meso international",
	0x00B7: "TreLab Ltd",
	0x00B8: "Qualcomm Innovation Center, Inc. (QuIC)",
	0x00B9: "Johnson Controls, Inc.",
	0x00BA: "Starkey Laboratories Inc.",
	0x00BB: "S-Power Electronics Limited",
	0x00BC: "Ace Sensor Inc",
	0x00BD: "Aplix Corporation",
	0x00BE: "AAMP of America",
	0x00BF: "Stalmart Technology Limited",
	0x00C0: "AMICCOM Electronics Corporation",
	0x00C1: "Shenzhen Excelsecu Data Technology Co.,Ltd",
	0x00C2: "Geneq Inc.",
	0x00C3: "adidas AG",
	0x00C4: "LG Electronics",
	0x00C5: "Onset Computer Corporation",
	0x00C6: "Selfly BV",
	0x00C7: "Quuppa Oy.",
	0x00C8: "GeLo Inc",
	0x00C9: "Evluma",
	0x00CA: "MC10",
	0x00CB: "Binauric SE",
	0x00CC: "Beats Electronics",
	0x00CD: "Microchip Technology Inc.",
	0x00CE: "Elgato Systems GmbH",
	0x00CF: "ARCHOS SA",
	0x00D0: "Dexcom, Inc.",
	0x00D1: "Polar Electro Europe B.V.",
	0x00D2: "Dialog Semiconductor B.V.",
	0x00D3: "Taixingbang Technology (HK) Co,. LTD.",
	0x00D4: "Kawantech",
	0x00D5: "Austco Communication Systems",
	0x00D6: "Timex Group USA, Inc.",
	0x00D7: "Qualcomm Technologies, Inc.",
	0x00D8: "Qualcomm Connected Experiences, Inc.",
	0x00D9: "Voyetra Turtle Beach",
	0x00DA: "txtr GmbH",
	0x00DB: "Biosentronics",
	0x00DC: "Procter &amp; Gamble",
	0x00DD: "Hosiden Corporation",
	0x00DE: "Muzik LLC",
	0x00DF: "Misfit Wearables Corp",
	0x00E0: "Google",
	0x00E1: "Danlers Ltd",
	0x00E2: "Semilink Inc",
	0x00E3: "inMusic Brands, Inc",
	0x00E4: "L.S. Research Inc.",
	0x00E5: "Eden Software Consultants Ltd.",
	0x00E6: "Freshtemp",
	0x00E7: "KS Technologies",
	0x00E8: "ACTS Technologies",
	0x00E9: "Vtrack Systems",
	0x00EA: "Nielsen-Kellerman Company",
	0x00EB: "Server Technology Inc.",
	0x00EC: "BioResearch Associates",
	0x00ED: "Jolly Logic, LLC",
	0x00EE: "Above Average Outcomes, Inc.",
	0x00EF: "Bitsplitters GmbH",
	0x00F0: "PayPal, Inc.",
	0x00F1: "Witron Technology Limited",
	0x00F2: "Morse Project Inc.",
	0x00F3: "Kent Displays Inc.",
	0x00F4: "Nautilus Inc.",
	0x00F5: "Smartifier Oy",
	0x00F6: "Elcometer Limited",
	0x00F7: "VSN Technologies, Inc.",
	0x00F8: "AceUni Corp., Ltd.",
	0x00F9: "StickNFind",
	0x00FA: "Crystal Code AB",
	0x00FB: "KOUKAAM a.s.",
	0x00FC: "Delphi Corporation",
	0x00FD: "ValenceTech Limited",
	0x00FE: "Stanley Black and Decker",
	0x00FF: "Typo Products, LLC",
	0x0100: "TomTom International BV",
	0x0101: "Fugoo, Inc.",
	0x0102: "Keiser Corporation",
	0x0103: "Bang &amp; Olufsen A/S",
	0x0104: "PLUS Location Systems Pty Ltd",
	0x0105: "Ubiquitous Computing Technology Corporation",
	0x0106: "Innovative Yachtter Solutions",
	0x0107: "William Demant Holding A/S",
	0x0108: "Chicony Electronics Co., Ltd.",
	0x0109: "Atus BV",
	0x010A: "Codegate Ltd",
	0x010B: "ERi, Inc",
	0x010C: "Transducers Direct, LLC",
	0x010D: "Fujitsu Ten LImited",
	0x010E: "Audi AG",
	0x010F: "HiSilicon Technologies Col, Ltd.",
	0x0110: "Nippon Seiki Co., Ltd.",
	0x0111: "Steelseries ApS",
	0x0112: "Visybl Inc.",
	0x0113: "Openbrain Technologies, Co., Ltd.",
	0x0114: "Xensr",
	0x0115: "e.solutions",
	0x0116: "10AK Technologies",
	0x0117: "Wimoto Technologies Inc",
	0x0118: "Radius Networks, Inc.",
	0x0119: "Wize Technology Co., Ltd.",
	0x011A: "Qualcomm Labs, Inc.",
	0x011B: "Hewlett Packard Enterprise",
	0x011C: "Baidu",
	0x011D: "Arendi AG",
	0x011E: "Skoda Auto a.s.",
	0x011F: "Volkswagen AG",
	0x0120: "Porsche AG",
	0x0121: "Sino Wealth Electronic Ltd.",
	0x0122: "AirTurn, Inc.",
	0x0123: "Kinsa, Inc",
	0x0124: "HID Global",
	0x0125: "SEAT es",
	0x0126: "Promethean Ltd.",
	0x0127: "Salutica Allied Solutions",
	0x0128: "GPSI Group Pty Ltd",
	0x0129: "Nimble Devices Oy",
	0x012A: "Changzhou Yongse Infotech  Co., Ltd.",
	0x012B: "SportIQ",
	0x012C: "TEMEC Instruments B.V.",
	0x012D: "Sony Corporation",
	0x012E: "ASSA ABLOY",
	0x012F: "Clarion Co. Inc.",
	0x0130: "Warehouse Innovations",
	0x0131: "Cypress Semiconductor",
	0x0132: "MADS Inc",
	0x0133: "Blue Maestro Limited",
	0x0134: "Resolution Products, Ltd.",
	0x0135: "Aireware LLC",
	0x0136: "Silvair, Inc.",
	0x0137: "Prestigio Plaza Ltd.",
	0x0138: "NTEO Inc.",
	0x0139: "Focus Systems Corporation",
	0x013A: "Tencent Holdings Ltd.",
	0x013B: "Allegion",
	0x013C: "Murata Manufacturing Co., Ltd. ",
	0x013D: "WirelessWERX",
	0x013E: "Nod, Inc.",
	0x013F: "B&amp;B Manufacturing Company",
	0x0140: "Alpine Electronics (China) Co., Ltd",
	0x0141: "FedEx Services",
	0x0142: "Grape Systems Inc.",
	0x0143: "Bkon Connect",
	0x0144: "Lintech GmbH",
	0x0145: "Novatel Wireless",
	0x0146: "Ciright",
	0x0147: "Mighty Cast, Inc.",
	0x0148: "Ambimat Electronics",
	0x0149: "Perytons Ltd.",
	0x014A: "Tivoli Audio, LLC",
	0x014B: "Master Lock",
	0x014C: "Mesh-Net Ltd",
	0x014D: "HUIZHOU DESAY SV AUTOMOTIVE CO., LTD.",
	0x014E: "Tangerine, Inc.",
	0x014F: "B&amp;W Group Ltd.",
	0x0150: "Pioneer Corporation",
	0x0151: "OnBeep",
	0x0152: "Vernier Software &amp; Technology",
	0x0153: "ROL Ergo",
	0x0154: "Pebble Technology",
	0x0155: "NETATMO",
	0x0156: "Accumulate AB",
	0x0157: "Anhui Huami Information Technology Co., Ltd.",
	0x0158: "Inmite s.r.o.",
	0x0159: "ChefSteps, Inc.",
	0x015A: "micas AG",
	0x015B: "Biomedical Research Ltd.",
	0x015C: "Pitius Tec S.L.",
	0x015D: "Estimote, Inc.",
	0x015E: "Unikey Technologies, Inc.",
	0x015F: "Timer Cap Co.",
	0x0160: "AwoX",
	0x0161: "yikes",
	0x0162: "MADSGlobalNZ Ltd.",
	0x0163: "PCH International",
	0x0164: "Qingdao Yeelink Information Technology Co., Ltd.",
	0x0165: "Milwaukee Tool (Formally Milwaukee Electric Tools) ",
	0x0166: "MISHIK Pte Ltd",
	0x0167: "Ascensia Diabetes Care US Inc.",
	0x0168: "Spicebox LLC",
	0x0169: "emberlight",
	0x016A: "Cooper-Atkins Corporation",
	0x016B: "Qblinks",
	0x016C: "MYSPHERA",
	0x016D: "LifeScan Inc",
	0x016E: "Volantic AB",
	0x016F: "Podo Labs, Inc",
	0x0170: "Roche Diabetes Care AG",
	0x0171: "Amazon Fulfillment Service",
	0x0172: "Connovate Technology Private Limited",
	0x0173: "Kocomojo, LLC",
	0x0174: "Everykey Inc. ",
	0x0175: "Dynamic Controls",
	0x0176: "SentriLock",
	0x0177: "I-SYST inc.",
	0x0178: "CASIO COMPUTER CO., LTD.",
	0x0179: "LAPIS Semiconductor Co., Ltd.",
	0x017A: "Telemonitor, Inc.",
	0x017B: "taskit GmbH",
	0x017C: "Daimler AG",
	0x017D: "BatAndCat",
	0x017E: "BluDotz Ltd",
	0x017F: "XTel Wireless ApS",
	0x0180: "Gigaset Communications GmbH",
	0x0181: "Gecko Health Innovations, Inc.",
	0x0182: "HOP Ubiquitous",
	0x0183: "Walt Disney",
	0x0184: "Nectar",
	0x0185: "bel&#39;apps LLC",
	0x0186: "CORE Lighting Ltd",
	0x0187: "Seraphim Sense Ltd",
	0x0188: "Unico RBC ",
	0x0189: "Physical Enterprises Inc.",
	0x018A: "Able Trend Technology Limited",
	0x018B: "Konica Minolta, Inc.",
	0x018C: "Wilo SE",
	0x018D: "Extron Design Services",
	0x018E: "Fitbit, Inc.",
	0x018F: "Fireflies Systems",
	0x0190: "Intelletto Technologies Inc.",
	0x0191: "FDK CORPORATION ",
	0x0192: "Cloudleaf, Inc",
	0x0193: "Maveric Automation LLC",
	0x0194: "Acoustic Stream Corporation",
	0x0195: "Zuli",
	0x0196: "Paxton Access Ltd",
	0x0197: "WiSilica Inc.",
	0x0198: "VENGIT Korlatolt Felelossegu Tarsasag",
	0x0199: "SALTO SYSTEMS S.L.",
	0x019A: "TRON Forum (formerly T-Engine Forum)",
	0x019B: "CUBETECH s.r.o.",
	0x019C: "Cokiya Incorporated",
	0x019D: "CVS Health",
	0x019E: "Ceruus",
	0x019F: "Strainstall Ltd",
	0x01A0: "Channel Enterprises (HK) Ltd.",
	0x01A1: "FIAMM",
	0x01A2: "GIGALANE.CO.,LTD",
	0x01A3: "EROAD",
	0x01A4: "Mine Safety Appliances",
	0x01A5: "Icon Health and Fitness",
	0x01A6: "Wille Engineering (formely as Asandoo GmbH)",
	0x01A7: "ENERGOUS CORPORATION",
	0x01A8: "Taobao",
	0x01A9: "Canon Inc.",
	0x01AA: "Geophysical Technology Inc.",
	0x01AB: "Facebook, Inc.",
	0x01AC: "Trividia Health, Inc.",
	0x01AD: "FlightSafety International",
	0x01AE: "Earlens Corporation",
	0x01AF: "Sunrise Micro Devices, Inc.",
	0x01B0: "Star Micronics Co., Ltd.",
	0x01B1: "Netizens Sp. z o.o.",
	0x01B2: "Nymi Inc.",
	0x01B3: "Nytec, Inc.",
	0x01B4: "Trineo Sp. z o.o.",
	0x01B5: "Nest Labs Inc.",
	0x01B6: "LM Technologies Ltd",
	0x01B7: "General Electric Company",
	0x01B8: "i+D3 S.L.",
	0x01B9: "HANA Micron",
	0x01BA: "Stages Cycling LLC",
	0x01BB: "Cochlear Bone Anchored Solutions AB",
	0x01BC: "SenionLab AB",
	0x01BD: "Syszone Co., Ltd",
	0x01BE: "Pulsate Mobile Ltd.",
	0x01BF: "Hong Kong HunterSun Electronic Limited",
	0x01C0: "pironex GmbH",
	0x01C1: "BRADATECH Corp.",
	0x01C2: "Transenergooil AG",
	0x01C3: "Bunch",
	0x01C4: "DME Microelectronics",
	0x01C5: "Bitcraze AB",
	0x01C6: "HASWARE Inc.",
	0x01C7: "Abiogenix Inc.",
	0x01C8: "Poly-Control ApS",
	0x01C9: "Avi-on",
	0x01CA: "Laerdal Medical AS",
	0x01CB: "Fetch My Pet",
	0x01CC: "Sam Labs Ltd.",
	0x01CD: "Chengdu Synwing Technology Ltd",
	0x01CE: "HOUWA SYSTEM DESIGN, k.k.",
	0x01CF: "BSH",
	0x01D0: "Primus Inter Pares Ltd",
	0x01D1: "August Home, Inc",
	0x01D2: "Gill Electronics",
	0x01D3: "Sky Wave Design",
	0x01D4: "Newlab S.r.l.",
	0x01D5: "ELAD srl",
	0x01D6: "G-wearables inc.",
	0x01D7: "Squadrone Systems Inc.",
	0x01D8: "Code Corporation",
	0x01D9: "Savant Systems LLC",
	0x01DA: "Logitech International SA",
	0x01DB: "Innblue Consulting",
	0x01DC: "iParking Ltd.",
	0x01DD: "Koninklijke Philips Electronics N.V.",
	0x01DE: "Minelab Electronics Pty Limited",
	0x01DF: "Bison Group Ltd.",
	0x01E0: "Widex A/S",
	0x01E1: "Jolla Ltd",
	0x01E2: "Lectronix, Inc.",
	0x01E3: "Caterpillar Inc",
	0x01E4: "Freedom Innovations",
	0x01E5: "Dynamic Devices Ltd",
	0x01E6: "Technology Solutions (UK) Ltd",
	0x01E7: "IPS Group Inc.",
	0x01E8: "STIR",
	0x01E9: "Sano, Inc.",
	0x01EA: "Advanced Application Design, Inc.",
	0x01EB: "AutoMap LLC",
	0x01EC: "Spreadtrum Communications Shanghai Ltd",
	0x01ED: "CuteCircuit LTD",
	0x01EE: "Valeo Service",
	0x01EF: "Fullpower Technologies, Inc. ",
	0x01F0: "KloudNation",
	0x01F1: "Zebra Technologies Corporation",
	0x01F2: "Itron, Inc. ",
	0x01F3: "The University of Tokyo",
	0x01F4: "UTC Fire and Security",
	0x01F5: "Cool Webthings Limited",
	0x01F6: "DJO Global",
	0x01F7: "Gelliner Limited",
	0x01F8: "Anyka (Guangzhou) Microelectronics Technology Co, LTD ",
	0x01F9: "Medtronic Inc.",
	0x01FA: "Gozio Inc.",
	0x01FB: "Form Lifting, LLC",
	0x01FC: "Wahoo Fitness, LLC",
	0x01FD: "Kontakt Micro-Location Sp. z o.o. ",
	0x01FE: "Radio Systems Corporation",
	0x01FF: "Freescale Semiconductor, Inc.",
	0x0200: "Verifone Systems Pte Ltd. Taiwan Branch",
	0x0201: "AR Timing",
	0x0202: "Rigado LLC",
	0x0203: "Kemppi Oy",
	0x0204: "Tapcentive Inc.",
	0x0205: "Smartbotics Inc.",
	0x0206: "Otter Products, LLC",
	0x0207: "STEMP Inc.",
	0x0208: "LumiGeek LLC",
	0x0209: "InvisionHeart Inc.",
	0x020A: "Macnica Inc. ",
	0x020B: "Jaguar Land Rover Limited",
	0x020C: "CoroWare Technologies, Inc",
	0x020D: "Simplo Technology Co., LTD",
	0x020E: "Omron Healthcare Co., LTD",
	0x020F: "Comodule GMBH",
	0x0210: "ikeGPS",
	0x0211: "Telink Semiconductor Co. Ltd",
	0x0212: "Interplan Co., Ltd",
	0x0213: "Wyler AG",
	0x0214: "IK Multimedia Production srl",
	0x0215: "Lukoton Experience Oy",
	0x0216: "MTI Ltd",
	0x0217: "Tech4home, Lda",
	0x0218: "Hiotech AB",
	0x0219: "DOTT Limited",
	0x021A: "Blue Speck Labs, LLC",
	0x021B: "Cisco Systems, Inc",
	0x021C: "Mobicomm Inc",
	0x021D: "Edamic",
	0x021E: "Goodnet, Ltd",
	0x021F: "Luster Leaf Products  Inc",
	0x0220: "Manus Machina BV",
	0x0221: "Mobiquity Networks Inc",
	0x0222: "Praxis Dynamics",
	0x0223: "Philip Morris Products S.A.",
	0x0224: "Comarch SA",
	0x0225: "Nestl Nespresso S.A.",
	0x0226: "Merlinia A/S",
	0x0227: "LifeBEAM Technologies",
	0x0228: "Twocanoes Labs, LLC",
	0x0229: "Muoverti Limited",
	0x022A: "Stamer Musikanlagen GMBH",
	0x022B: "Tesla Motors",
	0x022C: "Pharynks Corporation",
	0x022D: "Lupine",
	0x022E: "Siemens AG",
	0x022F: "Huami (Shanghai) Culture Communication CO., LTD",
	0x0230: "Foster Electric Company, Ltd",
	0x0231: "ETA SA",
	0x0232: "x-Senso Solutions Kft",
	0x0233: "Shenzhen SuLong Communication Ltd",
	0x0234: "FengFan (BeiJing) Technology Co, Ltd",
	0x0235: "Qrio Inc",
	0x0236: "Pitpatpet Ltd",
	0x0237: "MSHeli s.r.l.",
	0x0238: "Trakm8 Ltd",
	0x0239: "JIN CO, Ltd ",
	0x023A: "Alatech Tehnology",
	0x023B: "Beijing CarePulse Electronic Technology Co, Ltd",
	0x023C: "Awarepoint",
	0x023D: "ViCentra B.V.",
	0x023E: "Raven Industries",
	0x023F: "WaveWare Technologies Inc.",
	0x0240: "Argenox Technologies",
	0x0241: "Bragi GmbH",
	0x0242: "16Lab Inc",
	0x0243: "Masimo Corp",
	0x0244: "Iotera Inc",
	0x0245: "Endress+Hauser",
	0x0246: "ACKme Networks, Inc.",
	0x0247: "FiftyThree Inc.",
	0x0248: "Parker Hannifin Corp",
	0x0249: "Transcranial Ltd",
	0x024A: "Uwatec AG",
	0x024B: "Orlan LLC",
	0x024C: "Blue Clover Devices",
	0x024D: "M-Way Solutions GmbH",
	0x024E: "Microtronics Engineering GmbH",
	0x024F: "Schneider Schreibgerte GmbH",
	0x0250: "Sapphire Circuits LLC",
	0x0251: "Lumo Bodytech Inc.",
	0x0252: "UKC Technosolution",
	0x0253: "Xicato Inc.",
	0x0254: "Playbrush",
	0x0255: "Dai Nippon Printing Co., Ltd.",
	0x0256: "G24 Power Limited",
	0x0257: "AdBabble Local Commerce Inc.",
	0x0258: "Devialet SA",
	0x0259: "ALTYOR",
	0x025A: "University of Applied Sciences Valais/Haute Ecole Valaisanne",
	0x025B: "Five Interactive, LLC dba Zendo",
	0x025C: "NetEaseHangzhouNetwork co.Ltd.",
	0x025D: "Lexmark International Inc.",
	0x025E: "Fluke Corporation",
	0x025F: "Yardarm Technologies",
	0x0260: "SensaRx",
	0x0261: "SECVRE GmbH",
	0x0262: "Glacial Ridge Technologies",
	0x0263: "Identiv, Inc.",
	0x0264: "DDS, Inc.",
	0x0265: "SMK Corporation",
	0x0266: "Schawbel Technologies LLC",
	0x0267: "XMI Systems SA",
	0x0268: "Cerevo",
	0x0269: "Torrox GmbH &amp; Co KG",
	0x026A: "Gemalto",
	0x026B: "DEKA Research &amp; Development Corp.",
	0x026C: "Domster Tadeusz Szydlowski",
	0x026D: "Technogym SPA",
	0x026E: "FLEURBAEY BVBA",
	0x026F: "Aptcode Solutions",
	0x0270: "LSI ADL Technology",
	0x0271: "Animas Corp",
	0x0272: "Alps Electric Co., Ltd.",
	0x0273: "OCEASOFT",
	0x0274: "Motsai Research",
	0x0275: "Geotab",
	0x0276: "E.G.O. Elektro-Gertebau GmbH",
	0x0277: "bewhere inc",
	0x0278: "Johnson Outdoors Inc",
	0x0279: "steute Schaltgerate GmbH &amp; Co. KG",
	0x027A: "Ekomini inc.",
	0x027B: "DEFA AS",
	0x027C: "Aseptika Ltd",
	0x027D: "HUAWEI Technologies Co., Ltd. (  )",
	0x027E: "HabitAware, LLC",
	0x027F: "ruwido austria gmbh",
	0x0280: "ITEC corporation",
	0x0281: "StoneL",
	0x0282: "Sonova AG",
	0x0283: "Maven Machines, Inc.",
	0x0284: "Synapse Electronics",
	0x0285: "Standard Innovation Inc.",
	0x0286: "RF Code, Inc.",
	0x0287: "Wally Ventures S.L.",
	0x0288: "Willowbank Electronics Ltd",
	0x0289: "SK Telecom",
	0x028A: "Jetro AS",
	0x028B: "Code Gears LTD",
	0x028C: "NANOLINK APS",
	0x028D: "IF, LLC",
	0x028E: "RF Digital Corp",
	0x028F: "Church &amp; Dwight Co., Inc",
	0x0290: "Multibit Oy",
	0x0291: "CliniCloud Inc",
	0x0292: "SwiftSensors",
	0x0293: "Blue Bite",
	0x0294: "ELIAS GmbH",
	0x0295: "Sivantos GmbH",
	0x0296: "Petzl",
	0x0297: "storm power ltd",
	0x0298: "EISST Ltd",
	0x0299: "Inexess Technology Simma KG",
	0x029A: "Currant, Inc.",
	0x029B: "C2 Development, Inc.",
	0x029C: "Blue Sky Scientific, LLC",
	0x029D: "ALOTTAZS LABS, LLC",
	0x029E: "Kupson spol. s r.o.",
	0x029F: "Areus Engineering GmbH",
	0x02A0: "Impossible Camera GmbH",
	0x02A1: "InventureTrack Systems",
	0x02A2: "LockedUp",
	0x02A3: "Itude",
	0x02A4: "Pacific Lock Company",
	0x02A5: "Tendyron Corporation (  )",
	0x02A6: "Robert Bosch GmbH",
	0x02A7: "Illuxtron international B.V.",
	0x02A8: "miSport Ltd.",
	0x02A9: "Chargelib",
	0x02AA: "Doppler Lab",
	0x02AB: "BBPOS Limited",
	0x02AC: "RTB Elektronik GmbH &amp; Co. KG",
	0x02AD: "Rx Networks, Inc.",
	0x02AE: "WeatherFlow, Inc.",
	0x02AF: "Technicolor USA Inc.",
	0x02B0: "Bestechnic(Shanghai),Ltd",
	0x02B1: "Raden Inc",
	0x02B2: "JouZen Oy",
	0x02B3: "CLABER S.P.A.",
	0x02B4: "Hyginex, Inc.",
	0x02B5: "HANSHIN ELECTRIC RAILWAY CO.,LTD.",
	0x02B6: "Schneider Electric",
	0x02B7: "Oort Technologies LLC",
	0x02B8: "Chrono Therapeutics",
	0x02B9: "Rinnai Corporation",
	0x02BA: "Swissprime Technologies AG",
	0x02BB: "Koha.,Co.Ltd",
	0x02BC: "Genevac Ltd",
	0x02BD: "Chemtronics",
	0x02BE: "Seguro Technology Sp. z o.o.",
	0x02BF: "Redbird Flight Simulations",
	0x02C0: "Dash Robotics",
	0x02C1: "LINE Corporation",
	0x02C2: "Guillemot Corporation",
	0x02C3: "Techtronic Power Tools Technology Limited",
	0x02C4: "Wilson Sporting Goods",
	0x02C5: "Lenovo (Singapore) Pte Ltd. (  )",
	0x02C6: "Ayatan Sensors",
	0x02C7: "Electronics Tomorrow Limited",
	0x02C8: "VASCO Data Security International, Inc.",
	0x02C9: "PayRange Inc.",
	0x02CA: "ABOV Semiconductor",
	0x02CB: "AINA-Wireless Inc.",
	0x02CC: "Eijkelkamp Soil &amp; Water",
	0x02CD: "BMA ergonomics b.v.",
	0x02CE: "Teva Branded Pharmaceutical Products R&amp;D, Inc.",
	0x02CF: "Anima",
	0x02D0: "3M",
	0x02D1: "Empatica Srl",
	0x02D2: "Afero, Inc.",
	0x02D3: "Powercast Corporation",
	0x02D4: "Secuyou ApS",
	0x02D5: "OMRON Corporation",
	0x02D6: "Send Solutions",
	0x02D7: "NIPPON SYSTEMWARE CO.,LTD.",
	0x02D8: "Neosfar",
	0x02D9: "Fliegl Agrartechnik GmbH",
	0x02DA: "Gilvader",
	0x02DB: "Digi International Inc (R)",
	0x02DC: "DeWalch Technologies, Inc.",
	0x02DD: "Flint Rehabilitation Devices, LLC",
	0x02DE: "Samsung SDS Co., Ltd.",
	0x02DF: "Blur Product Development",
	0x02E0: "University of Michigan",
	0x02E1: "Victron Energy BV",
	0x02E2: "NTT docomo",
	0x02E3: "Carmanah Technologies Corp.",
	0x02E4: "Bytestorm Ltd.",
	0x02E5: "Espressif Incorporated ( () )",
	0x02E6: "Unwire",
	0x02E7: "Connected Yard, Inc.",
	0x02E8: "American Music Environments",
	0x02E9: "Sensogram Technologies, Inc.",
	0x02EA: "Fujitsu Limited",
	0x02EB: "Ardic Technology",
	0x02EC: "Delta Systems, Inc",
	0x02ED: "HTC Corporation",
	0x02EE: "Citizen Holdings Co., Ltd.",
	0x02EF: "SMART-INNOVATION.inc",
	0x02F0: "Blackrat Software",
	0x02F1: "The Idea Cave, LLC",
	0x02F2: "GoPro, Inc.",
	0x02F3: "AuthAir, Inc",
	0x02F4: "Vensi, Inc.",
	0x02F5: "Indagem Tech LLC",
	0x02F6: "Intemo Technologies",
	0x02F7: "DreamVisions co., Ltd.",
	0x02F8: "Runteq Oy Ltd",
	0x02F9: "IMAGINATION TECHNOLOGIES LTD",
	0x02FA: "CoSTAR TEchnologies",
	0x02FB: "Clarius Mobile Health Corp.",
	0x02FC: "Shanghai Frequen Microelectronics Co., Ltd.",
	0x02FD: "Uwanna, Inc.",
	0x02FE: "Lierda Science &amp; Technology Group Co., Ltd.",
	0x02FF: "Silicon Laboratories",
	0x0300: "World Moto Inc.",
	0x0301: "Giatec Scientific Inc.",
	0x0302: "Loop Devices, Inc",
	0x0303: "IACA electronique",
	0x0304: "Proxy Technologies, Inc.",
	0x0305: "Swipp ApS",
	0x0306: "Life Laboratory Inc.",
	0x0307: "FUJI INDUSTRIAL CO.,LTD. ",
	0x0308: "Surefire, LLC",
	0x0309: "Dolby Labs",
	0x030A: "Ellisys",
	0x030B: "Magnitude Lighting Converters",
	0x030C: "Hilti AG",
	0x030D: "Devdata S.r.l.",
	0x030E: "Deviceworx",
	0x030F: "Shortcut Labs",
	0x0310: "SGL Italia S.r.l.",
	0x0311: "PEEQ DATA",
	0x0312: "Ducere Technologies Pvt Ltd",
	0x0313: "DiveNav, Inc.",
	0x0314: "RIIG AI Sp. z o.o.",
	0x0315: "Thermo Fisher Scientific",
	0x0316: "AG Measurematics Pvt. Ltd.",
	0x0317: "CHUO Electronics CO., LTD.",
	0x0318: "Aspenta International",
	0x0319: "Eugster Frismag AG",
	0x031A: "Amber wireless GmbH",
	0x031B: "HQ Inc",
	0x031C: "Lab Sensor Solutions",
	0x031D: "Enterlab ApS",
	0x031E: "Eyefi, Inc.",
	0x031F: "MetaSystem S.p.A.",
	0x0320: "SONO ELECTRONICS. CO., LTD",
	0x0321: "Jewelbots",
	0x0322: "Compumedics Limited",
	0x0323: "Rotor Bike Components",
	0x0324: "Astro, Inc.",
	0x0325: "Amotus Solutions",
	0x0326: "Healthwear Technologies (Changzhou)Ltd",
	0x0327: "Essex Electronics",
	0x0328: "Grundfos A/S",
	0x0329: "Eargo, Inc.",
	0x032A: "Electronic Design Lab",
	0x032B: "ESYLUX",
	0x032C: "NIPPON SMT.CO.,Ltd",
	0x032D: "BM innovations GmbH",
	0x032E: "indoormap",
	0x032F: "OttoQ Inc",
	0x0330: "North Pole Engineering",
	0x0331: "3flares Technologies Inc.",
	0x0332: "Electrocompaniet A.S.",
	0x0333: "Mul-T-Lock",
	0x0334: "Corentium AS",
	0x0335: "Enlighted Inc",
	0x0336: "GISTIC",
	0x0337: "AJP2 Holdings, LLC",
	0x0338: "COBI GmbH",
	0x0339: "Blue Sky Scientific, LLC",
	0x033A: "Appception, Inc.",
	0x033B: "Courtney Thorne Limited",
	0x033C: "Virtuosys",
	0x033D: "TPV Technology Limited",
	0x033E: "Monitra SA",
	0x033F: "Automation Components, Inc.",
	0x0340: "Letsense s.r.l.",
	0x0341: "Etesian Technologies LLC",
	0x0342: "GERTEC BRASIL LTDA.",
	0x0343: "Drekker Development Pty. Ltd.",
	0x0344: "Whirl Inc",
	0x0345: "Locus Positioning",
	0x0346: "Acuity Brands Lighting, Inc",
	0x0347: "Prevent Biometrics",
	0x0348: "Arioneo",
	0x0349: "VersaMe",
	0x034A: "Vaddio",
	0x034B: "Libratone A/S",
	0x034C: "HM Electronics, Inc.",
	0x034D: "TASER International, Inc.",
	0x034E: "SafeTrust Inc.",
	0x034F: "Heartland Payment Systems",
	0x0350: "Bitstrata Systems Inc.",
	0x0351: "Pieps GmbH",
	0x0352: "iRiding(Xiamen)Technology Co.,Ltd.",
	0x0353: "Alpha Audiotronics, Inc.",
	0x0354: "TOPPAN FORMS CO.,LTD.",
	0x0355: "Sigma Designs, Inc.",
	0x0356: "Spectrum Brands, Inc.",
	0x0357: "Polymap Wireless",
	0x0358: "MagniWare Ltd. ",
	0x0359: "Novotec Medical GmbH",
	0x035A: "Medicom Innovation Partner a/s",
	0x035B: "Matrix Inc.",
	0x035C: "Eaton Corporation",
	0x035D: "KYS",
	0x035E: "Naya Health, Inc.",
	0x035F: "Acromag",
	0x0360: "Insulet Corporation",
	0x0361: "Wellinks Inc.",
	0x0362: "ON Semiconductor",
	0x0363: "FREELAP SA",
	0x0364: "Favero Electronics Srl",
	0x0365: "BioMech Sensor LLC",
	0x0366: "BOLTT Sports technologies Private limited",
	0x0367: "Saphe International",
	0x0368: "Metormote AB",
	0x0369: "littleBits",
	0x036A: "SetPoint Medical",
	0x036B: "BRControls Products BV",
	0x036C: "Zipcar",
	0x036D: "AirBolt Pty Ltd",
	0x036E: "KeepTruckin Inc",
	0x036F: "Motiv, Inc.",
	0x0370: "Wazombi Labs O",
	0x0371: "ORBCOMM",
	0x0372: "Nixie Labs, Inc.",
	0x0373: "AppNearMe Ltd",
	0x0374: "Holman Industries",
	0x0375: "Expain AS",
	0x0376: "Electronic Temperature Instruments Ltd",
	0x0377: "Plejd AB",
	0x0378: "Propeller Health",
	0x0379: "Shenzhen iMCO Electronic Technology Co.,Ltd",
	0x037A: "Algoria",
	0x037B: "Apption Labs Inc.",
	0x037C: "Cronologics Corporation",
	0x037D: "MICRODIA Ltd.",
	0x037E: "lulabytes S.L.",
	0x037F: "Nestec S.A.",
	0x0380: "LLC &quot;MEGA-F service&quot;",
	0x0381: "Sharp Corporation",
	0x0382: "Precision Outcomes Ltd",
	0x0383: "Kronos Incorporated",
	0x0384: "OCOSMOS Co., Ltd.",
	0x0385: "Embedded Electronic Solutions Ltd. dba e2Solutions",
	0x0386: "Aterica Inc.",
	0x0387: "BluStor PMC, Inc.",
	0x0388: "Kapsch TrafficCom AB",
	0x0389: "ActiveBlu Corporation",
	0x038A: "Kohler Mira Limited",
	0x038B: "Noke",
	0x038C: "Appion Inc.",
	0x038D: "Resmed Ltd",
	0x038E: "Crownstone B.V.",
	0x038F: "Xiaomi Inc.",
	0x0390: "INFOTECH s.r.o.",
	0x0391: "Thingsquare AB",
	0x0392: "T&amp;D",
	0x0393: "LAVAZZA S.p.A.",
	0x0394: "Netclearance Systems, Inc.",
	0x0395: "SDATAWAY",
	0x0396: "BLOKS GmbH",
	0x0397: "LEGO System A/S",
	0x0398: "Thetatronics Ltd",
	0x0399: "Nikon Corporation",
	0x039A: "NeST",
	0x039B: "South Silicon Valley Microelectronics",
	0x039C: "ALE International",
	0x039D: "CareView Communications, Inc.",
	0x039E: "SchoolBoard Limited",
	0x039F: "Molex Corporation",
	0x03A0: "IVT Wireless Limited",
	0x03A1: "Alpine Labs LLC",
	0x03A2: "Candura Instruments",
	0x03A3: "SmartMovt Technology Co., Ltd",
	0x03A4: "Token Zero Ltd",
	0x03A5: "ACE CAD Enterprise Co., Ltd. (ACECAD)",
	0x03A6: "Medela, Inc",
	0x03A7: "AeroScout",
	0x03A8: "Esrille Inc.",
	0x03A9: "THINKERLY SRL",
	0x03AA: "Exon Sp. z o.o.",
	0x03AB: "Meizu Technology Co., Ltd.",
	0x03AC: "Smablo LTD",
	0x03AD: "XiQ",
	0x03AE: "Allswell Inc.",
	0x03AF: "Comm-N-Sense Corp DBA Verigo",
	0x03B0: "VIBRADORM GmbH",
	0x03B1: "Otodata Wireless Network Inc.",
	0x03B2: "Propagation Systems Limited",
	0x03B3: "Midwest Instruments &amp; Controls",
	0x03B4: "Alpha Nodus, inc.",
	0x03B5: "petPOMM, Inc",
	0x03B6: "Mattel",
	0x03B7: "Airbly Inc.",
	0x03B8: "A-Safe Limited",
	0x03B9: "FREDERIQUE CONSTANT SA",
	0x03BA: "Maxscend Microelectronics Company Limited",
	0x03BB: "Abbott Diabetes Care",
	0x03BC: "ASB Bank Ltd",
	0x03BD: "amadas",
	0x03BE: "Applied Science, Inc.",
	0x03BF: "iLumi Solutions Inc.",
	0x03C0: "Arch Systems Inc.",
	0x03C1: "Ember Technologies, Inc.",
	0x03C2: "Snapchat Inc",
	0x03C3: "Casambi Technologies Oy",
	0x03C4: "Pico Technology Inc.",
	0x03C5: "St. Jude Medical, Inc.",
	0x03C6: "Intricon",
	0x03C7: "Structural Health Systems, Inc.",
	0x03C8: "Avvel International",
	0x03C9: "Gallagher Group",
	0x03CA: "In2things Automation Pvt. Ltd.",
	0x03CB: "SYSDEV Srl",
	0x03CC: "Vonkil Technologies Ltd",
	0x03CD: "Wynd Technologies, Inc.",
	0x03CE: "CONTRINEX S.A.",
	0x03CF: "MIRA, Inc.",
	0x03D0: "Watteam Ltd",
	0x03D1: "Density Inc.",
	0x03D2: "IOT Pot India Private Limited",
	0x03D3: "Sigma Connectivity AB",
	0x03D4: "PEG PEREGO SPA",
	0x03D5: "Wyzelink Systems Inc.",
	0x03D6: "Yota Devices LTD",
	0x03D7: "FINSECUR",
	0x03D8: "Zen-Me Labs Ltd",
	0x03D9: "3IWare Co., Ltd.",
	0x03DA: "EnOcean GmbH",
	0x03DB: "Instabeat, Inc",
	0x03DC: "Nima Labs",
	0x03DD: "Andreas Stihl AG &amp; Co. KG",
	0x03DE: "Nathan Rhoades LLC",
	0x03DF: "Grob Technologies, LLC",
	0x03E0: "Actions (Zhuhai) Technology Co., Limited",
	0x03E1: "SPD Development Company Ltd",
	0x03E2: "Sensoan Oy",
	0x03E3: "Qualcomm Life Inc",
	0x03E4: "Chip-ing AG",
	0x03E5: "ffly4u",
	0x03E6: "IoT Instruments Oy",
	0x03E7: "TRUE Fitness Technology",
	0x03E8: "Reiner Kartengeraete GmbH &amp; Co. KG.",
	0x03E9: "SHENZHEN LEMONJOY TECHNOLOGY CO., LTD.",
	0x03EA: "Hello Inc.",
	0x03EB: "Evollve Inc.",
	0x03EC: "Jigowatts Inc.",
	0x03ED: "BASIC MICRO.COM,INC.",
	0x03EE: "CUBE TECHNOLOGIES",
	0x03EF: "foolography GmbH",
	0x03F0: "CLINK",
	0x03F1: "Hestan Smart Cooking Inc.",
	0x03F2: "WindowMaster A/S",
	0x03F3: "Flowscape AB",
	0x03F4: "PAL Technologies Ltd",
	0x03F5: "WHERE, Inc.",
	0x03F6: "Iton Technology Corp.",
	0x03F7: "Owl Labs Inc.",
	0x03F8: "Rockford Corp.",
	0x03F9: "Becon Technologies Co.,Ltd.",
	0x03FA: "Vyassoft Technologies Inc",
	0x03FB: "Nox Medical",
	0x03FC: "Kimberly-Clark",
	0x03FD: "Trimble Navigation Ltd.",
	0x03FE: "Littelfuse",
	0x03FF: "Withings",
	0x0400: "i-developer IT Beratung UG",
	0x0401: "",
	0x0402: "Sears Holdings Corporation",
	0x0403: "Gantner Electronic GmbH",
	0x0404: "Authomate Inc",
	0x0405: "Vertex International, Inc.",
	0x0406: "Airtago",
	0x0407: "Swiss Audio SA",
	0x0408: "ToGetHome Inc.",
	0x0409: "AXIS",
	0x040A: "Openmatics",
	0x040B: "Jana Care Inc.",
	0x040C: "Senix Corporation",
	0x040D: "NorthStar Battery Company, LLC",
	0x040E: "SKF (U.K.) Limited",
	0x040F: "CO-AX Technology, Inc.",
	0x0410: "Fender Musical Instruments",
	0x0411: "Luidia Inc",
	0x0412: "SEFAM",
	0x0413: "Wireless Cables Inc",
	0x0414: "Lightning Protection International Pty Ltd",
	0x0415: "Uber Technologies Inc",
	0x0416: "SODA GmbH",
	0x0417: "Fatigue Science",
	0x0418: "Alpine Electronics Inc.",
	0x0419: "Novalogy LTD",
	0x041A: "Friday Labs Limited",
	0x041B: "OrthoAccel Technologies",
	0x041C: "WaterGuru, Inc.",
	0x041D: "Benning Elektrotechnik und Elektronik GmbH &amp; Co. KG",
	0x041E: "Dell Computer Corporation",
	0x041F: "Kopin Corporation",
	0x0420: "TecBakery GmbH",
	0x0421: "Backbone Labs, Inc.",
	0x0422: "DELSEY SA",
	0x0423: "Chargifi Limited",
	0x0424: "Trainesense Ltd.",
	0x0425: "Unify Software and Solutions GmbH &amp; Co. KG",
	0x0426: "Husqvarna AB",
	0x0427: "Focus fleet and fuel management inc",
	0x0428: "SmallLoop, LLC",
	0x0429: "Prolon Inc.",
	0x042A: "BD Medical",
	0x042B: "iMicroMed Incorporated",
	0x042C: "Ticto N.V.",
	0x042D: "Meshtech AS",
	0x042E: "MemCachier Inc.",
	0x042F: "Danfoss A/S",
	0x0430: "SnapStyk Inc.",
	0x0431: "Amway Corporation",
	0x0432: "Silk Labs, Inc.",
	0x0433: "Pillsy Inc.",
	0x0434: "Hatch Baby, Inc.",
	0x0435: "Blocks Wearables Ltd.",
	0x0436: "Drayson Technologies (Europe) Limited",
	0x0437: "eBest IOT Inc.",
	0x0438: "Helvar Ltd",
	0x0439: "Radiance Technologies",
	0x043A: "Nuheara Limited",
	0x043B: "Appside co., ltd.",
	0x043C: "DeLaval",
	0x043D: "Coiler Corporation",
	0x043E: "Thermomedics, Inc.",
	0x043F: "Tentacle Sync GmbH",
	0x0440: "Valencell, Inc.",
	0x0441: "iProtoXi Oy",
	0x0442: "SECOM CO., LTD.",
	0x0443: "Tucker International LLC",
	0x0444: "Metanate Limited",
	0x0445: "Kobian Canada Inc.",
	0x0446: "NETGEAR, Inc.",
	0x0447: "Fabtronics Australia Pty Ltd",
	0x0448: "Grand Centrix GmbH",
	0x0449: "1UP USA.com llc",
	0x044A: "SHIMANO INC.",
	0x044B: "Nain Inc.",
	0x044C: "LifeStyle Lock, LLC",
	0x044D: "VEGA Grieshaber KG",
	0x044E: "Xtrava Inc.",
	0x044F: "TTS Tooltechnic Systems AG &amp; Co. KG",
	0x0450: "Teenage Engineering AB",
	0x0451: "Tunstall Nordic AB",
	0x0452: "Svep Design Center AB",
	0x0453: "GreenPeak Technologies BV",
	0x0454: "Sphinx Electronics GmbH &amp; Co KG",
	0x0455: "Atomation",
	0x0456: "Nemik Consulting Inc ",
	0x0457: "RF INNOVATION",
	0x0458: "Mini Solution Co., Ltd.",
	0x0459: "Lumenetix, Inc",
	0x045A: "2048450 Ontario Inc",
	0x045B: "SPACEEK LTD",
	0x045C: "Delta T Corporation",
	0x045D: "Boston Scientific Corporation",
	0x045E: "Nuviz, Inc.",
	0x045F: "Real Time Automation, Inc.",
	0x0460: "Kolibree",
	0x0461: "vhf elektronik GmbH",
	0x0462: "Bonsai Systems GmbH",
	0x0463: "Fathom Systems Inc.",
	0x0464: "Bellman &amp; Symfon",
	0x0465: "International Forte Group LLC",
	0x0466: "CycleLabs Solutions inc.",
	0x0467: "Codenex Oy",
	0x0468: "Kynesim Ltd",
	0x0469: "Palago AB",
	0x046A: "INSIGMA INC.",
	0x046B: "PMD Solutions",
	0x046C: "Qingdao Realtime Technology Co., Ltd.",
	0x046D: "BEGA Gantenbrink-Leuchten KG",
	0x046E: "Pambor Ltd.",
	0x046F: "Develco Products A/S",
	0x0470: "iDesign s.r.l.",
	0x0471: "TiVo Corp",
	0x0472: "Control-J Pty Ltd",
	0x0473: "Steelcase, Inc.",
	0x0474: "iApartment co., ltd.",
	0x0475: "Icom inc.",
	0x0476: "Oxstren Wearable Technologies Private Limited",
	0x0477: "Blue Spark Technologies",
	0x0478: "FarSite Communications Limited",
	0x0479: "mywerk system GmbH",
	0x047A: "Sinosun Technology Co., Ltd.",
	0x047B: "MIYOSHI ELECTRONICS CORPORATION",
	0x047C: "POWERMAT LTD",
	0x047D: "Occly LLC",
	0x047E: "OurHub Dev IvS",
	0x047F: "Pro-Mark, Inc.",
	0x0480: "Dynometrics Inc.",
	0x0481: "Quintrax Limited",
	0x0482: "POS Tuning Udo Vosshenrich GmbH &amp; Co. KG",
	0x0483: "Multi Care Systems B.V.",
	0x0484: "Revol Technologies Inc",
	0x0485: "SKIDATA AG",
	0x0486: "DEV TECNOLOGIA INDUSTRIA, COMERCIO E MANUTENCAO DE EQUIPAMENTOS LTDA. - ME",
	0x0487: "Centrica Connected Home",
	0x0488: "Automotive Data Solutions Inc",
	0x0489: "Igarashi Engineering",
	0x048A: "Taelek Oy",
	0x048B: "CP Electronics Limited",
	0x048C: "Vectronix AG",
	0x048D: "S-Labs Sp. z o.o.",
	0x048E: "Companion Medical, Inc.",
	0x048F: "BlueKitchen GmbH",
	0x0490: "Matting AB",
	0x0491: "SOREX - Wireless Solutions GmbH",
	0x0492: "ADC Technology, Inc.",
	0x0493: "Lynxemi Pte Ltd",
	0x0494: "SENNHEISER electronic GmbH &amp; Co. KG",
	0x0495: "LMT Mercer Group, Inc",
	0x0496: "Polymorphic Labs LLC",
	0x0497: "Cochlear Limited",
	0x0498: "METER Group, Inc. USA",
	0x0499: "Ruuvi Innovations Ltd.",
	0x049A: "Situne AS",
	0x049B: "nVisti, LLC",
	0x049C: "DyOcean",
	0x049D: "Uhlmann &amp; Zacher GmbH",
	0x049E: "AND!XOR LLC",
	0x049F: "tictote AB",
	0x04A0: "Vypin, LLC",
	0x04A1: "PNI Sensor Corporation",
	0x04A2: "ovrEngineered, LLC",
	0x04A3: "GT-tronics HK Ltd",
	0x04A4: "Herbert Waldmann GmbH &amp; Co. KG",
	0x04A5: "Guangzhou FiiO Electronics Technology Co.,Ltd",
	0x04A6: "Vinetech Co., Ltd",
	0x04A7: "Dallas Logic Corporation",
	0x04A8: "BioTex, Inc.",
	0x04A9: "DISCOVERY SOUND TECHNOLOGY, LLC",
	0x04AA: "LINKIO SAS",
	0x04AB: "Harbortronics, Inc.",
	0x04AC: "Undagrid B.V.",
	0x04AD: "Shure Inc",
	0x04AE: "ERM Electronic Systems LTD",
	0x04AF: "BIOROWER Handelsagentur GmbH",
	0x04B0: "Weba Sport und Med. Artikel GmbH",
	0x04B1: "Kartographers Technologies Pvt. Ltd.",
	0x04B2: "The Shadow on the Moon",
	0x04B3: "mobike (Hong Kong) Limited",
	0x04B4: "Inuheat Group AB",
	0x04B5: "Swiftronix AB",
	0x04B6: "Diagnoptics Technologies",
	0x04B7: "Analog Devices, Inc.",
	0x04B8: "Soraa Inc.",
	0x04B9: "CSR Building Products Limited",
	0x04BA: "Crestron Electronics, Inc.",
	0x04BB: "Neatebox Ltd",
	0x04BC: "Draegerwerk AG &amp; Co. KGaA",
	0x04BD: "AlbynMedical",
	0x04BE: "Averos FZCO",
	0x04BF: "VIT Initiative, LLC",
	0x04C0: "Statsports International",
	0x04C1: "Sospitas, s.r.o.",
	0x04C2: "Dmet Products Corp.",
	0x04C3: "Mantracourt Electronics Limited",
	0x04C4: "TeAM Hutchins AB",
	0x04C5: "Seibert Williams Glass, LLC",
	0x04C6: "Insta GmbH",
	0x04C7: "Svantek Sp. z o.o.",
	0x04C8: "Shanghai Flyco Electrical Appliance Co., Ltd.",
	0x04C9: "Thornwave Labs Inc",
	0x04CA: "Steiner-Optik GmbH",
	0x04CB: "Novo Nordisk A/S",
	0x04CC: "Enflux Inc.",
	0x04CD: "Safetech Products LLC",
	0x04CE: "GOOOLED S.R.L.",
	0x04CF: "DOM Sicherheitstechnik GmbH &amp; Co. KG",
	0x04D0: "Olympus Corporation",
	0x04D1: "KTS GmbH",
	0x04D2: "Anloq Technologies Inc.",
	0x04D3: "Queercon, Inc",
	0x04D4: "5th Element Ltd",
	0x04D5: "Gooee Limited",
	0x04D6: "LUGLOC LLC",
	0x04D7: "Blincam, Inc.",
	0x04D8: "FUJIFILM Corporation",
	0x04D9: "RandMcNally",
	0x04DA: "Franceschi Marina snc",
	0x04DB: "Engineered Audio, LLC.",
	0x04DC: "IOTTIVE (OPC) PRIVATE LIMITED",
	0x04DD: "4MOD Technology",
	0x04DE: "Lutron Electronics Co., Inc.",
	0x04DF: "Emerson",
	0x04E0: "Guardtec, Inc.",
	0x04E1: "REACTEC LIMITED",
	0x04E2: "EllieGrid",
	0x04E3: "Under Armour",
	0x04E4: "Woodenshark",
	0x04E5: "Avack Oy",
	0x04E6: "Smart Solution Technology, Inc. ",
	0x04E7: "REHABTRONICS INC. ",
	0x04E8: "STABILO International",
	0x04E9: "Busch Jaeger Elektro GmbH",
	0x04EA: "Pacific Bioscience Laboratories, Inc",
	0x04EB: "Bird Home Automation GmbH",
	0x04EC: "Motorola Solutions",
	0x04ED: "R9 Technology, Inc.",
	0x04EE: "Auxivia",
	0x04EF: "DaisyWorks, Inc",
	0x04F0: "Kosi Limited",
	0x04F1: "Theben AG",
	0x04F2: "InDreamer Techsol Private Limited",
	0x04F3: "Cerevast Medical",
	0x04F4: "ZanCompute Inc.",
	0x04F5: "Pirelli Tyre S.P.A.",
	0x04F6: "McLear Limited",
	0x04F7: "Shenzhen Huiding Technology Co.,Ltd.",
	0x04F8: "Convergence Systems Limited",
	0x04F9: "Interactio",
	0x04FA: "Androtec GmbH",
	0x04FB: "Benchmark Drives GmbH &amp; Co. KG",
	0x04FC: "SwingLync L. L. C.",
	0x04FD: "Tapkey GmbH",
	0x04FE: "Woosim Systems Inc.",
	0x04FF: "Microsemi Corporation",
	0x0500: "Wiliot LTD.",
	0x0501: "Polaris IND",
	0x0502: "Specifi-Kali LLC",
	0x0503: "Locoroll, Inc",
	0x0504: "PHYPLUS Inc",
	0x0505: "Inplay Technologies LLC",
	0x0506: "Hager",
	0x0507: "Yellowcog",
	0x0508: "Axes System sp. z o. o.",
	0x0509: "myLIFTER Inc.",
	0x050A: "Shake-on B.V.",
	0x050B: "Vibrissa Inc.",
	0x050C: "OSRAM GmbH",
	0x050D: "TRSystems GmbH",
	0x050E: "Yichip Microelectronics (Hangzhou) Co.,Ltd.",
	0x050F: "Foundation Engineering LLC",
	0x0510: "UNI-ELECTRONICS, INC.",
	0x0511: "Brookfield Equinox LLC",
	0x0512: "Soprod SA",
	0x0513: "9974091 Canada Inc.",
	0x0514: "FIBRO GmbH",
	0x0515: "RB Controls Co., Ltd.",
	0x0516: "Footmarks",
	0x0517: "Amtronic Sverige AB (formerly Amcore AB)",
	0x0518: "MAMORIO.inc",
	0x0519: "Tyto Life LLC",
	0x051A: "Leica Camera AG",
	0x051B: "Angee Technologies Ltd.",
	0x051C: "EDPS",
	0x051D: "OFF Line Co., Ltd.",
	0x051E: "Detect Blue Limited",
	0x051F: "Setec Pty Ltd",
	0x0520: "Target Corporation",
	0x0521: "IAI Corporation",
	0x0522: "NS Tech, Inc.",
	0x0523: "MTG Co., Ltd.",
	0x0524: "Hangzhou iMagic Technology Co., Ltd",
	0x0525: "HONGKONG NANO IC TECHNOLOGIES  CO., LIMITED",
	0x0526: "Honeywell International Inc.",
	0x0527: "Albrecht JUNG",
	0x0528: "Lunera Lighting Inc.",
	0x0529: "Lumen UAB",
	0x052A: "Keynes Controls Ltd",
	0x052B: "Novartis AG",
	0x052C: "Geosatis SA",
	0x052D: "EXFO, Inc.",
	0x052E: "LEDVANCE GmbH",
	0x052F: "Center ID Corp.",
	0x0530: "Adolene, Inc.",
	0x0531: "D&amp;M Holdings Inc.",
	0x0532: "CRESCO Wireless, Inc.",
	0x0533: "Nura Operations Pty Ltd",
	0x0534: "Frontiergadget, Inc.",
	0x0535: "Smart Component Technologies Limited",
	0x0536: "ZTR Control Systems LLC",
	0x0537: "MetaLogics Corporation",
	0x0538: "Medela AG",
	0x0539: "OPPLE Lighting Co., Ltd",
	0x053A: "Savitech Corp.,",
	0x053B: "prodigy",
	0x053C: "Screenovate Technologies Ltd",
	0x053D: "TESA SA",
	0x053E: "CLIM8 LIMITED",
	0x053F: "Silergy Corp",
	0x0540: "SilverPlus, Inc",
	0x0541: "Sharknet srl",
	0x0542: "Mist Systems, Inc.",
	0x0543: "MIWA LOCK CO.,Ltd",
	0x0544: "OrthoSensor, Inc.",
	0x0545: "Candy Hoover Group s.r.l",
	0x0546: "Apexar Technologies S.A.",
	0x0547: "LOGICDATA d.o.o.",
	0x0548: "Knick Elektronische Messgeraete GmbH &amp; Co. KG",
	0x0549: "Smart Technologies and Investment Limited",
	0x054A: "Linough Inc.",
	0x054B: "Advanced Electronic Designs, Inc.",
	0x054C: "Carefree Scott Fetzer Co Inc",
	0x054D: "Sensome",
	0x054E: "FORTRONIK storitve d.o.o.",
	0x054F: "Sinnoz",
	0x0550: "Versa Networks, Inc.",
	0x0551: "Sylero",
	0x0552: "Avempace SARL",
	0x0553: "Nintendo Co., Ltd.",
	0x0554: "National Instruments",
	0x0555: "KROHNE Messtechnik GmbH",
	0x0556: "Otodynamics Ltd",
	0x0557: "Arwin Technology Limited",
	0x0558: "benegear, inc.",
	0x0559: "Newcon Optik",
	0x055A: "CANDY HOUSE, Inc.",
	0x055B: "FRANKLIN TECHNOLOGY INC",
	0x055C: "Lely",
	0x055D: "Valve Corporation",
	0x055E: "Hekatron Vertriebs GmbH",
	0x055F: "PROTECH S.A.S. DI GIRARDI ANDREA &amp; C.",
	0x0560: "Sarita CareTech APS (formerly Sarita CareTech IVS)",
	0x0561: "Finder S.p.A.",
	0x0562: "Thalmic Labs Inc.",
	0x0563: "Steinel Vertrieb GmbH",
	0x0564: "Beghelli Spa",
	0x0565: "Beijing Smartspace Technologies Inc.",
	0x0566: "CORE TRANSPORT TECHNOLOGIES NZ LIMITED",
	0x0567: "Xiamen Everesports Goods Co., Ltd",
	0x0568: "Bodyport Inc.",
	0x0569: "Audionics System, INC.",
	0x056A: "Flipnavi Co.,Ltd.",
	0x056B: "Rion Co., Ltd.",
	0x056C: "Long Range Systems, LLC",
	0x056D: "Redmond Industrial Group LLC",
	0x056E: "VIZPIN INC.",
	0x056F: "BikeFinder AS",
	0x0570: "Consumer Sleep Solutions LLC",
	0x0571: "PSIKICK, INC.",
	0x0572: "AntTail.com",
	0x0573: "Lighting Science Group Corp.",
	0x0574: "AFFORDABLE ELECTRONICS INC",
	0x0575: "Integral Memroy Plc",
	0x0576: "Globalstar, Inc.",
	0x0577: "True Wearables, Inc.",
	0x0578: "Wellington Drive Technologies Ltd",
	0x0579: "Ensemble Tech Private Limited",
	0x057A: "OMNI Remotes",
	0x057B: "Duracell U.S. Operations Inc.",
	0x057C: "Toor Technologies LLC",
	0x057D: "Instinct Performance",
	0x057E: "Beco, Inc",
	0x057F: "Scuf Gaming International, LLC",
	0x0580: "ARANZ Medical Limited",
	0x0581: "LYS TECHNOLOGIES LTD",
	0x0582: "Breakwall Analytics, LLC",
	0x0583: "Code Blue Communications",
	0x0584: "Gira Giersiepen GmbH &amp; Co. KG",
	0x0585: "Hearing Lab Technology",
	0x0586: "LEGRAND",
	0x0587: "Derichs GmbH",
	0x0588: "ALT-TEKNIK LLC",
	0x0589: "Star Technologies",
	0x058A: "START TODAY CO.,LTD.",
	0x058B: "Maxim Integrated Products",
	0x058C: "MERCK Kommanditgesellschaft auf Aktien",
	0x058D: "Jungheinrich Aktiengesellschaft",
	0x058E: "Oculus VR, LLC",
	0x058F: "HENDON SEMICONDUCTORS PTY LTD",
	0x0590: "Pur3 Ltd",
	0x0591: "Viasat Group S.p.A.",
	0x0592: "IZITHERM",
	0x0593: "Spaulding Clinical Research",
	0x0594: "Kohler Company",
	0x0595: "Inor Process AB",
	0x0596: "My Smart Blinds",
	0x0597: "RadioPulse Inc",
	0x0598: "rapitag GmbH",
	0x0599: "Lazlo326, LLC.",
	0x059A: "Teledyne Lecroy, Inc.",
	0x059B: "Dataflow Systems Limited",
	0x059C: "Macrogiga Electronics",
	0x059D: "Tandem Diabetes Care",
	0x059E: "Polycom, Inc.",
	0x059F: "Fisher &amp; Paykel Healthcare",
	0x05A0: "RCP Software Oy",
	0x05A1: "Shanghai Xiaoyi Technology Co.,Ltd.",
	0x05A2: "ADHERIUM(NZ) LIMITED",
	0x05A3: "Axiomware Systems Incorporated",
	0x05A4: "O. E. M. Controls, Inc.",
	0x05A5: "Kiiroo BV",
	0x05A6: "Telecon Mobile Limited",
	0x05A7: "Sonos Inc",
	0x05A8: "Tom Allebrandi Consulting",
	0x05A9: "Monidor",
	0x05AA: "Tramex Limited",
	0x05AB: "Nofence AS",
	0x05AC: "GoerTek Dynaudio Co., Ltd.",
	0x05AD: "INIA",
	0x05AE: "CARMATE MFG.CO.,LTD",
	0x05AF: "ONvocal",
	0x05B0: "NewTec GmbH",
	0x05B1: "Medallion Instrumentation Systems",
	0x05B2: "CAREL INDUSTRIES S.P.A.",
	0x05B3: "Parabit Systems, Inc.",
	0x05B4: "White Horse Scientific ltd",
	0x05B5: "verisilicon",
	0x05B6: "Elecs Industry Co.,Ltd.",
	0x05B7: "Beijing Pinecone Electronics Co.,Ltd.",
	0x05B8: "Ambystoma Labs Inc.",
	0x05B9: "Suzhou Pairlink Network Technology",
	0x05BA: "igloohome",
	0x05BB: "Oxford Metrics plc",
	0x05BC: "Leviton Mfg. Co., Inc.",
	0x05BD: "ULC Robotics Inc.",
	0x05BE: "RFID Global by Softwork SrL",
	0x05BF: "Real-World-Systems Corporation",
	0x05C0: "Nalu Medical, Inc.",
	0x05C1: "P.I.Engineering",
	0x05C2: "Grote Industries",
	0x05C3: "Runtime, Inc.",
	0x05C4: "Codecoup sp. z o.o. sp. k.",
	0x05C5: "SELVE GmbH &amp; Co. KG",
	0x05C6: "Smart Animal Training Systems, LLC",
	0x05C7: "Lippert Components, INC",
	0x05C8: "SOMFY SAS",
	0x05C9: "TBS Electronics B.V.",
	0x05CA: "MHL Custom Inc",
	0x05CB: "LucentWear LLC",
	0x05CC: "WATTS ELECTRONICS",
	0x05CD: "RJ Brands LLC",
	0x05CE: "V-ZUG Ltd",
	0x05CF: "Biowatch SA",
	0x05D0: "Anova Applied Electronics",
	0x05D1: "Lindab AB",
	0x05D2: "frogblue TECHNOLOGY GmbH",
	0x05D3: "Acurable Limited",
	0x05D4: "LAMPLIGHT Co., Ltd.",
	0x05D5: "TEGAM, Inc.",
	0x05D6: "Zhuhai Jieli technology Co.,Ltd",
	0x05D7: "modum.io AG",
	0x05D8: "Farm Jenny LLC",
	0x05D9: "Toyo Electronics Corporation",
	0x05DA: "Applied Neural Research Corp",
	0x05DB: "Avid Identification Systems, Inc.",
	0x05DC: "Petronics Inc.",
	0x05DD: "essentim GmbH",
	0x05DE: "QT Medical INC.",
	0x05DF: "VIRTUALCLINIC.DIRECT LIMITED",
	0x05E0: "Viper Design LLC",
	0x05E1: "Human, Incorporated",
	0x05E2: "stAPPtronics GmbH",
	0x05E3: "Elemental Machines, Inc.",
	0x05E4: "Taiyo Yuden Co., Ltd",
	0x05E5: "INEO ENERGY&amp; SYSTEMS",
	0x05E6: "Motion Instruments Inc.",
	0x05E7: "PressurePro",
	0x05E8: "COWBOY",
	0x05E9: "iconmobile GmbH",
	0x05EA: "ACS-Control-System GmbH",
	0x05EB: "Bayerische Motoren Werke AG",
	0x05EC: "Gycom Svenska AB",
	0x05ED: "Fuji Xerox Co., Ltd",
	0x05EE: "Glide Inc.",
	0x05EF: "SIKOM AS",
	0x05F0: "beken",
	0x05F1: "The Linux Foundation",
	0x05F2: "Try and E CO.,LTD.",
	0x05F3: "SeeScan",
	0x05F4: "Clearity, LLC",
	0x05F5: "GS TAG",
	0x05F6: "DPTechnics",
	0x05F7: "TRACMO, INC.",
	0x05F8: "Anki Inc.",
	0x05F9: "Hagleitner Hygiene International GmbH",
	0x05FA: "Konami Sports Life Co., Ltd.",
	0x05FB: "Arblet Inc.",
	0x05FC: "Masbando GmbH",
	0x05FD: "Innoseis",
	0x05FE: "Niko",
	0x05FF: "Wellnomics Ltd",
	0x0600: "iRobot Corporation",
	0x0601: "Schrader Electronics",
	0x0602: "Geberit International AG",
	0x0603: "Fourth Evolution Inc",
	0x0604: "Cell2Jack LLC",
	0x0605: "FMW electronic Futterer u. Maier-Wolf OHG",
	0x0606: "John Deere",
	0x0607: "Rookery Technology Ltd",
	0x0608: "KeySafe-Cloud",
	0x0609: "BUCHI Labortechnik AG",
	0x060A: "IQAir AG",
	0x060B: "Triax Technologies Inc",
	0x060C: "Vuzix Corporation",
	0x060D: "TDK Corporation",
	0x060E: "Blueair AB",
	0x060F: "Signify Netherlands ",
	0x0610: "ADH GUARDIAN USA LLC",
	0x0611: "Beurer GmbH",
	0x0612: "Playfinity AS",
	0x0613: "Hans Dinslage GmbH",
	0x0614: "OnAsset Intelligence, Inc.",
	0x0615: "INTER ACTION Corporation",
	0x0616: "OS42 UG (haftungsbeschraenkt)",
	0x0617: "WIZCONNECTED COMPANY LIMITED",
	0x0618: "Audio-Technica Corporation",
	0x0619: "Six Guys Labs, s.r.o.",
	0x061A: "R.W. Beckett Corporation",
	0x061B: "silex technology, inc.",
	0x061C: "Univations Limited",
	0x061D: "SENS Innovation ApS",
	0x061E: "Diamond Kinetics, Inc.",
	0x061F: "Phrame Inc.",
	0x0620: "Forciot Oy",
	0x0621: "Noordung d.o.o.",
	0x0622: "Beam Labs, LLC",
	0x0623: "Philadelphia Scientific (U.K.) Limited",
	0x0624: "Biovotion AG",
	0x0625: "Square Panda, Inc.",
	0x0626: "Amplifico",
	0x0627: "WEG S.A.",
	0x0628: "Ensto Oy",
	0x0629: "PHONEPE PVT LTD",
	0x062A: "Lunatico Astronomia SL",
	0x062B: "MinebeaMitsumi Inc.",
	0x062C: "ASPion GmbH",
	0x062D: "Vossloh-Schwabe Deutschland GmbH",
	0x062E: "Procept",
	0x062F: "ONKYO Corporation",
	0x0630: "Asthrea D.O.O.",
	0x0631: "Fortiori Design LLC",
	0x0632: "Hugo Muller GmbH &amp; Co KG",
	0x0633: "Wangi Lai PLT",
	0x0634: "Fanstel Corp",
	0x0635: "Crookwood",
	0x0636: "ELECTRONICA INTEGRAL DE SONIDO S.A.",
	0x0637: "GiP Innovation Tools GmbH",
	0x0638: "LX SOLUTIONS PTY LIMITED",
	0x0639: "Shenzhen Minew Technologies Co., Ltd.",
	0x063A: "Prolojik Limited",
	0x063B: "Kromek Group Plc",
	0x063C: "Contec Medical Systems Co., Ltd.",
	0x063D: "Xradio Technology Co.,Ltd.",
	0x063E: "The Indoor Lab, LLC",
	0x063F: "LDL TECHNOLOGY",
	0x0640: "Parkifi",
	0x0641: "Revenue Collection Systems FRANCE SAS",
	0x0642: "Bluetrum Technology Co.,Ltd",
	0x0643: "makita corporation",
	0x0644: "Apogee Instruments",
	0x0645: "BM3",
	0x0646: "SGV Group Holding GmbH &amp; Co. KG",
	0x0647: "MED-EL",
	0x0648: "Ultune Technologies",
	0x0649: "Ryeex Technology Co.,Ltd.",
	0x064A: "Open Research Institute, Inc.",
	0x064B: "Scale-Tec, Ltd",
	0x064C: "Zumtobel Group AG ",
	0x064D: "iLOQ Oy",
	0x064E: "KRUXWorks Technologies Private Limited",
	0x064F: "Digital Matter Pty Ltd",
	0x0650: "Coravin, Inc.",
	0x0651: "Stasis Labs, Inc.",
	0x0652: "ITZ Innovations- und Technologiezentrum GmbH",
	0x0653: "Meggitt SA",
	0x0654: "Ledlenser GmbH &amp; Co. KG",
	0x0655: "Renishaw PLC",
	0x0656: "ZhuHai AdvanPro Technology Company Limited",
	0x0657: "Meshtronix Limited",
	0x0658: "Payex Norge AS",
	0x0659: "UnSeen Technologies Oy",
	0x065A: "Zound Industries International AB",
	0x065B: "Sesam Solutions BV",
	0x065C: "PixArt Imaging Inc.",
	0x065D: "Panduit Corp.",
	0x065E: "Alo AB",
	0x065F: "Ricoh Company Ltd",
	0x0660: "RTC Industries, Inc.",
	0x0661: "Mode Lighting Limited",
	0x0662: "Particle Industries, Inc.",
	0x0663: "Advanced Telemetry Systems, Inc.",
	0x0664: "RHA TECHNOLOGIES LTD",
	0x0665: "Pure International Limited",
	0x0666: "WTO Werkzeug-Einrichtungen GmbH",
	0x0667: "Spark Technology Labs Inc.",
	0x0668: "Bleb Technology srl",
	0x0669: "Livanova USA, Inc.",
	0x066A: "Brady Worldwide Inc.",
	0x066B: "DewertOkin GmbH",
	0x066C: "Ztove ApS",
	0x066D: "Venso EcoSolutions AB",
	0x066E: "Eurotronik Kranj d.o.o.",
	0x066F: "Hug Technology Ltd",
	0x0670: "Gema Switzerland GmbH",
	0x0671: "Buzz Products Ltd.",
	0x0672: "Kopi",
	0x0673: "Innova Ideas Limited",
	0x0674: "BeSpoon",
	0x0675: "Deco Enterprises, Inc.",
	0x0676: "Expai Solutions Private Limited",
	0x0677: "Innovation First, Inc.",
	0x0678: "SABIK Offshore GmbH",
	0x0679: "4iiii Innovations Inc.",
	0x067A: "The Energy Conservatory, Inc.",
	0x067B: "I.FARM, INC.",
	0x067C: "Tile, Inc.",
	0x067D: "Form Athletica Inc.",
	0x067E: "MbientLab Inc",
	0x067F: "NETGRID S.N.C. DI BISSOLI MATTEO, CAMPOREALE SIMONE, TOGNETTI FEDERICO",
	0x0680: "Mannkind Corporation",
	0x0681: "Trade FIDES a.s.",
	0x0682: "Photron Limited",
	0x0683: "Eltako GmbH",
	0x0684: "Dermalapps, LLC",
	0x0685: "Greenwald Industries",
	0x0686: "inQs Co., Ltd.",
	0x0687: "Cherry GmbH",
	0x0688: "Amsted Digital Solutions Inc.",
	0x0689: "Tacx b.v.",
	0x068A: "Raytac Corporation",
	0x068B: "Jiangsu Teranovo Tech Co., Ltd.",
	0x068C: "Changzhou Sound Dragon Electronics and Acoustics Co., Ltd",
	0x068D: "JetBeep Inc.",
	0x068E: "Razer Inc.",
	0x068F: "JRM Group Limited",
	0x0690: "Eccrine Systems, Inc.",
	0x0691: "Curie Point AB",
	0x0692: "Georg Fischer AG",
	0x0693: "Hach - Danaher",
	0x0694: "T&amp;A Laboratories LLC",
	0x0695: "Koki Holdings Co., Ltd.",
	0x0696: "Gunakar Private Limited",
	0x0697: "Stemco Products Inc",
	0x0698: "Wood IT Security, LLC",
	0x0699: "RandomLab SAS",
	0x069A: "Adero, Inc. (formerly as TrackR, Inc.)",
	0x069B: "Dragonchip Limited",
	0x069C: "Noomi AB",
	0x069D: "Vakaros LLC",
	0x069E: "Delta Electronics, Inc.",
	0x069F: "FlowMotion Technologies AS",
	0x06A0: "OBIQ Location Technology Inc.",
	0x06A1: "Cardo Systems, Ltd",
	0x06A2: "Globalworx GmbH",
	0x06A3: "Nymbus, LLC",
	0x06A4: "Sanyo Techno Solutions Tottori Co., Ltd.",
	0x06A5: "TEKZITEL PTY LTD",
	0x06A6: "Roambee Corporation",
	0x06A7: "Chipsea Technologies (ShenZhen) Corp.",
	0x06A8: "GD Midea Air-Conditioning Equipment Co., Ltd.",
	0x06A9: "Soundmax Electronics Limited",
	0x06AA: "Produal Oy",
	0x06AB: "HMS Industrial Networks AB",
	0x06AC: "Ingchips Technology Co., Ltd.",
	0x06AD: "InnovaSea Systems Inc.",
	0x06AE: "SenseQ Inc.",
	0x06AF: "Shoof Technologies",
	0x06B0: "BRK Brands, Inc.",
	0x06B1: "SimpliSafe, Inc.",
	0x06B2: "Tussock Innovation 2013 Limited",
	0x06B3: "The Hablab ApS",
	0x06B4: "Sencilion Oy",
	0x06B5: "Wabilogic Ltd.",
	0x06B6: "Sociometric Solutions, Inc.",
	0x06B7: "iCOGNIZE GmbH",
	0x06B8: "ShadeCraft, Inc",
	0x06B9: "Beflex Inc.",
	0x06BA: "Beaconzone Ltd",
	0x06BB: "Leaftronix Analogic Solutions Private Limited",
	0x06BC: "TWS Srl",
	0x06BD: "ABB Oy",
	0x06BE: "HitSeed Oy",
	0x06BF: "Delcom Products Inc.",
	0x06C0: "CAME S.p.A.",
	0x06C1: "Alarm.com Holdings, Inc",
	0x06C2: "Measurlogic Inc.",
	0x06C3: "King I Electronics.Co.,Ltd",
	0x06C4: "Dream Labs GmbH",
	0x06C5: "Urban Compass, Inc",
	0x06C6: "Simm Tronic Limited",
	0x06C7: "Somatix Inc",
	0x06C8: "Storz &amp; Bickel GmbH &amp; Co. KG",
	0x06C9: "MYLAPS B.V.",
	0x06CA: "Shenzhen Zhongguang Infotech Technology Development Co., Ltd",
	0x06CB: "Dyeware, LLC",
	0x06CC: "Dongguan SmartAction Technology Co.,Ltd.",
	0x06CD: "DIG Corporation",
	0x06CE: "FIOR &amp; GENTZ",
	0x06CF: "Belparts N.V.",
	0x06D0: "Etekcity Corporation",
	0x06D1: "Meyer Sound Laboratories, Incorporated",
	0x06D2: "CeoTronics AG",
	0x06D3: "TriTeq Lock and Security, LLC",
	0x06D4: "DYNAKODE TECHNOLOGY PRIVATE LIMITED",
	0x06D5: "Sensirion AG",
	0x06D6: "JCT Healthcare Pty Ltd",
	0x06D7: "FUBA Automotive Electronics GmbH",
	0x06D8: "AW Company",
	0x06D9: "Shanghai Mountain View Silicon Co.,Ltd.",
	0x06DA: "Zliide Technologies ApS",
	0x06DB: "Automatic Labs, Inc.",
	0x06DC: "Industrial Network Controls, LLC",
	0x06DD: "Intellithings Ltd.",
	0x06DE: "Navcast, Inc.",
	0x06DF: "Hubbell Lighting, Inc.",
	0x06E0: "Avaya",
	0x06E1: "Milestone AV Technologies LLC",
	0x06E2: "Alango Technologies Ltd",
	0x06E3: "Spinlock Ltd",
	0x06E4: "Aluna",
	0x06E5: "OPTEX CO.,LTD.",
	0x06E6: "NIHON DENGYO KOUSAKU",
	0x06E7: "VELUX A/S",
	0x06E8: "Almendo Technologies GmbH",
	0x06E9: "Zmartfun Electronics, Inc.",
	0x06EA: "SafeLine Sweden AB",
	0x06EB: "Houston Radar LLC",
	0x06EC: "Sigur",
	0x06ED: "J Neades Ltd",
	0x06EE: "Avantis Systems Limited",
	0x06EF: "ALCARE Co., Ltd.",
	0x06F0: "Chargy Technologies, SL",
	0x06F1: "Shibutani Co., Ltd.",
	0x06F2: "Trapper Data AB",
	0x06F3: "Alfred International Inc.",
	0x06F4: "Near Field Solutions Ltd",
	0x06F5: "Vigil Technologies Inc.",
	0x06F6: "Vitulo Plus BV",
	0x06F7: "WILKA Schliesstechnik GmbH",
	0x06F8: "BodyPlus Technology Co.,Ltd",
	0x06F9: "happybrush GmbH",
	0x06FA: "Enequi AB",
	0x06FB: "Sartorius AG",
	0x06FC: "Tom Communication Industrial Co.,Ltd.",
	0x06FD: "ESS Embedded System Solutions Inc.",
	0x06FE: "Mahr GmbH",
	0x06FF: "Redpine Signals Inc",
	0x0700: "TraqFreq LLC",
	0x0701: "PAFERS TECH",
	0x0702: "Akciju sabiedriba &quot;SAF TEHNIKA&quot;",
	0x0703: "Beijing Jingdong Century Trading Co., Ltd.",
	0x0704: "JBX Designs Inc.",
	0x0705: "AB Electrolux",
	0x0706: "Wernher von Braun Center for ASdvanced Research",
	0x0707: "Essity Hygiene and Health Aktiebolag",
	0x0708: "Be Interactive Co., Ltd",
	0x0709: "Carewear Corp.",
	0x070A: "Huf Hlsbeck &amp; Frst GmbH &amp; Co. KG",
	0x070B: "Element Products, Inc.",
	0x070C: "Beijing Winner Microelectronics Co.,Ltd",
	0x070D: "SmartSnugg Pty Ltd",
	0x070E: "FiveCo Sarl",
	0x070F: "California Things Inc.",
	0x0710: "Audiodo AB",
	0x0711: "ABAX AS",
	0x0712: "Bull Group Company Limited",
	0x0713: "Respiri Limited",
	0x0714: "MindPeace Safety LLC",
	0x0715: "Vgyan Solutions",
	0x0716: "Altonics",
	0x0717: "iQsquare BV",
	0x0718: "IDIBAIX enginneering",
	0x0719: "ECSG",
	0x071A: "REVSMART WEARABLE HK CO LTD",
	0x071B: "Precor",
	0x071C: "F5 Sports, Inc",
	0x071D: "exoTIC Systems",
	0x071E: "DONGGUAN HELE ELECTRONICS CO., LTD",
	0x071F: "Dongguan Liesheng Electronic Co.Ltd",
	0x0720: "Oculeve, Inc.",
	0x0721: "Clover Network, Inc.",
	0x0722: "Xiamen Eholder Electronics Co.Ltd",
	0x0723: "Ford Motor Company",
	0x0724: "Guangzhou SuperSound Information Technology Co.,Ltd",
	0x0725: "Tedee Sp. z o.o.",
	0x0726: "PHC Corporation",
	0x0727: "STALKIT AS",
	0x0728: "Eli Lilly and Company",
	0x0729: "SwaraLink Technologies",
	0x072A: "JMR embedded systems GmbH",
	0x072B: "Bitkey Inc.",
	0x072C: "GWA Hygiene GmbH",
	0x072D: "Safera Oy",
	0x072E: "Open Platform Systems LLC",
	0x072F: "OnePlus Electronics (Shenzhen) Co., Ltd.",
	0x0730: "Wildlife Acoustics, Inc.",
	0x0731: "ABLIC Inc.",
	0x0732: "Dairy Tech, Inc.",
	0x0733: "Iguanavation, Inc.",
	0x0734: "DiUS Computing Pty Ltd",
	0x0735: "UpRight Technologies LTD",
	0x0736: "FrancisFund, LLC",
	0x0737: "LLC Navitek",
	0x0738: "Glass Security Pte Ltd",
	0x0739: "Jiangsu Qinheng Co., Ltd.",
	0x073A: "Chandler Systems Inc.",
	0x073B: "Fantini Cosmi s.p.a.",
	0x073C: "Acubit ApS",
	0x073D: "Beijing Hao Heng Tian Tech Co., Ltd.",
	0x073E: "Bluepack S.R.L.",
	0x073F: "Beijing Unisoc Technologies Co., Ltd.",
	0x0740: "HITIQ LIMITED",
	0x0741: "MAC SRL",
	0x0742: "DML LLC",
	0x0743: "Sanofi",
}

// MaxEIRPacketLength is the maximum allowed AdvertisingPacket
// and ScanResponsePacket length.
const MaxEIRPacketLength = 31

// ErrEIRPacketTooLong is the error returned when an AdvertisingPacket
// or ScanResponsePacket is too long.
var ErrEIRPacketTooLong = errors.New("max packet length is 31")

// Advertising data field types
const (
	typeFlags             = 0x01 // Flags
	typeSomeUUID16        = 0x02 // Incomplete List of 16-bit Service Class UUIDs
	typeAllUUID16         = 0x03 // Complete List of 16-bit Service Class UUIDs
	typeSomeUUID32        = 0x04 // Incomplete List of 32-bit Service Class UUIDs
	typeAllUUID32         = 0x05 // Complete List of 32-bit Service Class UUIDs
	typeSomeUUID128       = 0x06 // Incomplete List of 128-bit Service Class UUIDs
	typeAllUUID128        = 0x07 // Complete List of 128-bit Service Class UUIDs
	typeShortName         = 0x08 // Shortened Local Name
	typeCompleteName      = 0x09 // Complete Local Name
	typeTxPower           = 0x0A // Tx Power Level
	typeClassOfDevice     = 0x0D // Class of Device
	typeSimplePairingC192 = 0x0E // Simple Pairing Hash C-192
	typeSimplePairingR192 = 0x0F // Simple Pairing Randomizer R-192
	typeSecManagerTK      = 0x10 // Security Manager TK Value
	typeSecManagerOOB     = 0x11 // Security Manager Out of Band Flags
	typeSlaveConnInt      = 0x12 // Slave Connection Interval Range
	typeServiceSol16      = 0x14 // List of 16-bit Service Solicitation UUIDs
	typeServiceSol128     = 0x15 // List of 128-bit Service Solicitation UUIDs
	typeServiceData16     = 0x16 // Service Data - 16-bit UUID
	typePubTargetAddr     = 0x17 // Public Target Address
	typeRandTargetAddr    = 0x18 // Random Target Address
	typeAppearance        = 0x19 // Appearance
	typeAdvInterval       = 0x1A // Advertising Interval
	typeLEDeviceAddr      = 0x1B // LE Bluetooth Device Address
	typeLERole            = 0x1C // LE Role
	typeServiceSol32      = 0x1F // List of 32-bit Service Solicitation UUIDs
	typeServiceData32     = 0x20 // Service Data - 32-bit UUID
	typeServiceData128    = 0x21 // Service Data - 128-bit UUID
	typeLESecConfirm      = 0x22 // LE Secure Connections Confirmation Value
	typeLESecRandom       = 0x23 // LE Secure Connections Random Value
	typeManufacturerData  = 0xFF // Manufacturer Specific Data
)

// Advertising type flags
const (
	flagLimitedDiscoverable = 0x01 // LE Limited Discoverable Mode
	flagGeneralDiscoverable = 0x02 // LE General Discoverable Mode
	flagLEOnly              = 0x04 // BR/EDR Not Supported. Bit 37 of LMP Feature Mask Definitions (Page 0)
	flagBothController      = 0x08 // Simultaneous LE and BR/EDR to Same Device Capable (Controller).
	flagBothHost            = 0x10 // Simultaneous LE and BR/EDR to Same Device Capable (Host).
)

type Flags uint8

func (f Flags) String() string {
	bits := []string{}

	if f&flagLimitedDiscoverable != 0 {
		bits = append(bits, "Limited Discoverable")
	}

	/*
		if f&flagGeneralDiscoverable != 0 {
			bits = append(bits, "General Discoverable")
		}
	*/

	if f&flagLEOnly != 0 {
		bits = append(bits, "BR/EDR Not Supported")
	}

	if f&flagBothController != 0 {
		bits = append(bits, "LE + BR/EDR (controller)")
	}

	if f&flagBothHost != 0 {
		bits = append(bits, "LE + BR/EDR (host)")
	}

	return strings.Join(bits, ", ")
}

// FIXME: check the unmarshalling of this data structure.
type ServiceData struct {
	UUID UUID
	Data []byte
}

// This is borrowed from core bluetooth.
// Embedded/Linux folks might be interested in more details.
type Advertisement struct {
	LocalName        string
	Flags            Flags
	CompanyID        uint16
	Company          string
	ManufacturerData []byte
	ServiceData      []ServiceData
	Services         []UUID
	OverflowService  []UUID
	TxPowerLevel     int
	Connectable      bool
	SolicitedService []UUID
	Raw              []byte
}

// This is only used in Linux port.
func (a *Advertisement) unmarshall(b []byte) error {

	// Utility function for creating a list of uuids.
	uuidList := func(u []UUID, d []byte, w int) []UUID {
		// https://github.com/bettercap/gatt/issues/8
		defer func() {
			if recover() != nil {

			}
		}()

		for len(d) > 0 {
			u = append(u, UUID{d[:w]})
			d = d[w:]
		}
		return u
	}

	serviceDataList := func(sd []ServiceData, d []byte, w int) []ServiceData {
		serviceData := ServiceData{UUID{d[:w]}, make([]byte, len(d)-w)}
		copy(serviceData.Data, d[2:])
		return append(sd, serviceData)
	}

	for len(b) > 0 {
		if len(b) < 2 {
			return errors.New("invalid advertise data")
		}
		l, t := b[0], b[1]
		if int(l) < 1 || len(b) < int(1+l) {
			return errors.New("invalid advertise data")
		}

		d := b[2 : 1+l]
		a.Raw = d

		switch t {
		case typeFlags:
			a.Flags = Flags(d[0])
		case typeSomeUUID16:
			a.Services = uuidList(a.Services, d, 2)
		case typeAllUUID16:
			a.Services = uuidList(a.Services, d, 2)
		case typeSomeUUID32:
			a.Services = uuidList(a.Services, d, 4)
		case typeAllUUID32:
			a.Services = uuidList(a.Services, d, 4)
		case typeSomeUUID128:
			a.Services = uuidList(a.Services, d, 16)
		case typeAllUUID128:
			a.Services = uuidList(a.Services, d, 16)
		case typeShortName:
			a.LocalName = zeroTruncate(d)
		case typeCompleteName:
			a.LocalName = zeroTruncate(d)
		case typeTxPower:
			a.TxPowerLevel = int(d[0])
		case typeServiceSol16:
			a.SolicitedService = uuidList(a.SolicitedService, d, 2)
		case typeServiceSol128:
			a.SolicitedService = uuidList(a.SolicitedService, d, 16)
		case typeServiceSol32:
			a.SolicitedService = uuidList(a.SolicitedService, d, 4)
		case typeManufacturerData:
			sz := len(d)
			a.ManufacturerData = make([]byte, sz)
			copy(a.ManufacturerData, d)
			if sz >= 2 {
				a.CompanyID = binary.LittleEndian.Uint16(a.ManufacturerData[0:2])
				a.Company = CompanyIdents[a.CompanyID]
			}
		case typeServiceData16:
			a.ServiceData = serviceDataList(a.ServiceData, d, 2)
		case typeServiceData32:
			a.ServiceData = serviceDataList(a.ServiceData, d, 4)
		case typeServiceData128:
			a.ServiceData = serviceDataList(a.ServiceData, d, 16)
		default:
		}
		b = b[1+l:]
	}
	return nil
}

func zeroTruncate(b []byte) string {
	i := bytes.Index(b, []byte{0})
	if i < 0 {
		return string(b)
	}
	return string(b[:i])
}

// AdvPacket is an utility to help crafting advertisment or scan response data.
type AdvPacket struct {
	b []byte
}

// Bytes returns an 31-byte array, which contains up to 31 bytes of the packet.
func (a *AdvPacket) Bytes() [31]byte {
	b := [31]byte{}
	copy(b[:], a.b)
	return b
}

// Len returns the length of the packets with a maximum of 31.
func (a *AdvPacket) Len() int {
	if len(a.b) > 31 {
		return 31
	}
	return len(a.b)
}

// AppendField appends a BLE advertising packet field.
// TODO: refuse to append field if it'd make the packet too long.
func (a *AdvPacket) AppendField(typ byte, b []byte) *AdvPacket {
	// A field consists of len, typ, b.
	// Len is 1 byte for typ plus len(b).
	if len(a.b)+2+len(b) > MaxEIRPacketLength {
		b = b[:MaxEIRPacketLength-len(a.b)-2]
	}
	a.b = append(a.b, byte(len(b)+1))
	a.b = append(a.b, typ)
	a.b = append(a.b, b...)
	return a
}

// AppendFlags appends a flag field to the packet.
func (a *AdvPacket) AppendFlags(f byte) *AdvPacket {
	return a.AppendField(typeFlags, []byte{f})
}

// AppendFlags appends a name field to the packet.
// If the name fits in the space, it will be append as a complete name field, otherwise a short name field.
func (a *AdvPacket) AppendName(n string) *AdvPacket {
	typ := byte(typeCompleteName)
	if len(a.b)+2+len(n) > MaxEIRPacketLength {
		typ = byte(typeShortName)
	}
	return a.AppendField(typ, []byte(n))
}

// AppendManufacturerData appends a manufacturer data field to the packet.
func (a *AdvPacket) AppendManufacturerData(id uint16, b []byte) *AdvPacket {
	d := append([]byte{uint8(id), uint8(id >> 8)}, b...)
	return a.AppendField(typeManufacturerData, d)
}

// AppendUUIDFit appends a BLE advertised service UUID
// packet field if it fits in the packet, and reports whether the UUID fit.
func (a *AdvPacket) AppendUUIDFit(uu []UUID) bool {
	// Iterate all UUIDs to see if they fit in the packet or not.
	fit, l := true, len(a.b)
	for _, u := range uu {
		if u.Equal(attrGAPUUID) || u.Equal(attrGATTUUID) {
			continue
		}
		l += 2 + u.Len()
		if l > MaxEIRPacketLength {
			fit = false
			break
		}
	}

	// Append the UUIDs until they no longer fit.
	for _, u := range uu {
		if u.Equal(attrGAPUUID) || u.Equal(attrGATTUUID) {
			continue
		}
		if len(a.b)+2+u.Len() > MaxEIRPacketLength {
			break
		}
		switch l = u.Len(); {
		case l == 2 && fit:
			a.AppendField(typeAllUUID16, u.b)
		case l == 16 && fit:
			a.AppendField(typeAllUUID128, u.b)
		case l == 2 && !fit:
			a.AppendField(typeSomeUUID16, u.b)
		case l == 16 && !fit:
			a.AppendField(typeSomeUUID128, u.b)
		}
	}
	return fit
}
