package azblob

// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/base64"
	"encoding/xml"
	"io"
	"net/http"
	"reflect"
	"strconv"
	"strings"
	"time"
	"unsafe"
)

// ETag is an entity tag.
type ETag string

const (
	// ETagNone represents an empty entity tag.
	ETagNone ETag = ""

	// ETagAny matches any entity tag.
	ETagAny ETag = "*"
)

// Metadata contains metadata key/value pairs.
type Metadata map[string]string

const mdPrefix = "x-ms-meta-"

const mdPrefixLen = len(mdPrefix)

// UnmarshalXML implements the xml.Unmarshaler interface for Metadata.
func (md *Metadata) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	tokName := ""
	for t, err := d.Token(); err == nil; t, err = d.Token() {
		switch tt := t.(type) {
		case xml.StartElement:
			tokName = strings.ToLower(tt.Name.Local)
			break
		case xml.CharData:
			if *md == nil {
				*md = Metadata{}
			}
			(*md)[tokName] = string(tt)
			break
		}
	}
	return nil
}

// Marker represents an opaque value used in paged responses.
type Marker struct {
	val *string
}

// NotDone returns true if the list enumeration should be started or is not yet complete. Specifically, NotDone returns true
// for a just-initialized (zero value) Marker indicating that you should make an initial request to get a result portion from
// the service. NotDone also returns true whenever the service returns an interim result portion. NotDone returns false only
// after the service has returned the final result portion.
func (m Marker) NotDone() bool {
	return m.val == nil || *m.val != ""
}

// UnmarshalXML implements the xml.Unmarshaler interface for Marker.
func (m *Marker) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	var out string
	err := d.DecodeElement(&out, &start)
	m.val = &out
	return err
}

// concatenates a slice of const values with the specified separator between each item
func joinConst(s interface{}, sep string) string {
	v := reflect.ValueOf(s)
	if v.Kind() != reflect.Slice && v.Kind() != reflect.Array {
		panic("s wasn't a slice or array")
	}
	ss := make([]string, 0, v.Len())
	for i := 0; i < v.Len(); i++ {
		ss = append(ss, v.Index(i).String())
	}
	return strings.Join(ss, sep)
}

// AccessTierType enumerates the values for access tier type.
type AccessTierType string

const (
	// AccessTierArchive ...
	AccessTierArchive AccessTierType = "Archive"
	// AccessTierCool ...
	AccessTierCool AccessTierType = "Cool"
	// AccessTierHot ...
	AccessTierHot AccessTierType = "Hot"
	// AccessTierNone represents an empty AccessTierType.
	AccessTierNone AccessTierType = ""
	// AccessTierP10 ...
	AccessTierP10 AccessTierType = "P10"
	// AccessTierP20 ...
	AccessTierP20 AccessTierType = "P20"
	// AccessTierP30 ...
	AccessTierP30 AccessTierType = "P30"
	// AccessTierP4 ...
	AccessTierP4 AccessTierType = "P4"
	// AccessTierP40 ...
	AccessTierP40 AccessTierType = "P40"
	// AccessTierP50 ...
	AccessTierP50 AccessTierType = "P50"
	// AccessTierP6 ...
	AccessTierP6 AccessTierType = "P6"
)

// PossibleAccessTierTypeValues returns an array of possible values for the AccessTierType const type.
func PossibleAccessTierTypeValues() []AccessTierType {
	return []AccessTierType{AccessTierArchive, AccessTierCool, AccessTierHot, AccessTierNone, AccessTierP10, AccessTierP20, AccessTierP30, AccessTierP4, AccessTierP40, AccessTierP50, AccessTierP6}
}

// ArchiveStatusType enumerates the values for archive status type.
type ArchiveStatusType string

const (
	// ArchiveStatusNone represents an empty ArchiveStatusType.
	ArchiveStatusNone ArchiveStatusType = ""
	// ArchiveStatusRehydratePendingToCool ...
	ArchiveStatusRehydratePendingToCool ArchiveStatusType = "rehydrate-pending-to-cool"
	// ArchiveStatusRehydratePendingToHot ...
	ArchiveStatusRehydratePendingToHot ArchiveStatusType = "rehydrate-pending-to-hot"
)

// PossibleArchiveStatusTypeValues returns an array of possible values for the ArchiveStatusType const type.
func PossibleArchiveStatusTypeValues() []ArchiveStatusType {
	return []ArchiveStatusType{ArchiveStatusNone, ArchiveStatusRehydratePendingToCool, ArchiveStatusRehydratePendingToHot}
}

// BlobType enumerates the values for blob type.
type BlobType string

const (
	// BlobAppendBlob ...
	BlobAppendBlob BlobType = "AppendBlob"
	// BlobBlockBlob ...
	BlobBlockBlob BlobType = "BlockBlob"
	// BlobNone represents an empty BlobType.
	BlobNone BlobType = ""
	// BlobPageBlob ...
	BlobPageBlob BlobType = "PageBlob"
)

// PossibleBlobTypeValues returns an array of possible values for the BlobType const type.
func PossibleBlobTypeValues() []BlobType {
	return []BlobType{BlobAppendBlob, BlobBlockBlob, BlobNone, BlobPageBlob}
}

// BlockListType enumerates the values for block list type.
type BlockListType string

const (
	// BlockListAll ...
	BlockListAll BlockListType = "all"
	// BlockListCommitted ...
	BlockListCommitted BlockListType = "committed"
	// BlockListNone represents an empty BlockListType.
	BlockListNone BlockListType = ""
	// BlockListUncommitted ...
	BlockListUncommitted BlockListType = "uncommitted"
)

// PossibleBlockListTypeValues returns an array of possible values for the BlockListType const type.
func PossibleBlockListTypeValues() []BlockListType {
	return []BlockListType{BlockListAll, BlockListCommitted, BlockListNone, BlockListUncommitted}
}

// CopyStatusType enumerates the values for copy status type.
type CopyStatusType string

const (
	// CopyStatusAborted ...
	CopyStatusAborted CopyStatusType = "aborted"
	// CopyStatusFailed ...
	CopyStatusFailed CopyStatusType = "failed"
	// CopyStatusNone represents an empty CopyStatusType.
	CopyStatusNone CopyStatusType = ""
	// CopyStatusPending ...
	CopyStatusPending CopyStatusType = "pending"
	// CopyStatusSuccess ...
	CopyStatusSuccess CopyStatusType = "success"
)

// PossibleCopyStatusTypeValues returns an array of possible values for the CopyStatusType const type.
func PossibleCopyStatusTypeValues() []CopyStatusType {
	return []CopyStatusType{CopyStatusAborted, CopyStatusFailed, CopyStatusNone, CopyStatusPending, CopyStatusSuccess}
}

// DeleteSnapshotsOptionType enumerates the values for delete snapshots option type.
type DeleteSnapshotsOptionType string

const (
	// DeleteSnapshotsOptionInclude ...
	DeleteSnapshotsOptionInclude DeleteSnapshotsOptionType = "include"
	// DeleteSnapshotsOptionNone represents an empty DeleteSnapshotsOptionType.
	DeleteSnapshotsOptionNone DeleteSnapshotsOptionType = ""
	// DeleteSnapshotsOptionOnly ...
	DeleteSnapshotsOptionOnly DeleteSnapshotsOptionType = "only"
)

// PossibleDeleteSnapshotsOptionTypeValues returns an array of possible values for the DeleteSnapshotsOptionType const type.
func PossibleDeleteSnapshotsOptionTypeValues() []DeleteSnapshotsOptionType {
	return []DeleteSnapshotsOptionType{DeleteSnapshotsOptionInclude, DeleteSnapshotsOptionNone, DeleteSnapshotsOptionOnly}
}

// GeoReplicationStatusType enumerates the values for geo replication status type.
type GeoReplicationStatusType string

const (
	// GeoReplicationStatusBootstrap ...
	GeoReplicationStatusBootstrap GeoReplicationStatusType = "bootstrap"
	// GeoReplicationStatusLive ...
	GeoReplicationStatusLive GeoReplicationStatusType = "live"
	// GeoReplicationStatusNone represents an empty GeoReplicationStatusType.
	GeoReplicationStatusNone GeoReplicationStatusType = ""
	// GeoReplicationStatusUnavailable ...
	GeoReplicationStatusUnavailable GeoReplicationStatusType = "unavailable"
)

// PossibleGeoReplicationStatusTypeValues returns an array of possible values for the GeoReplicationStatusType const type.
func PossibleGeoReplicationStatusTypeValues() []GeoReplicationStatusType {
	return []GeoReplicationStatusType{GeoReplicationStatusBootstrap, GeoReplicationStatusLive, GeoReplicationStatusNone, GeoReplicationStatusUnavailable}
}

// LeaseDurationType enumerates the values for lease duration type.
type LeaseDurationType string

const (
	// LeaseDurationFixed ...
	LeaseDurationFixed LeaseDurationType = "fixed"
	// LeaseDurationInfinite ...
	LeaseDurationInfinite LeaseDurationType = "infinite"
	// LeaseDurationNone represents an empty LeaseDurationType.
	LeaseDurationNone LeaseDurationType = ""
)

// PossibleLeaseDurationTypeValues returns an array of possible values for the LeaseDurationType const type.
func PossibleLeaseDurationTypeValues() []LeaseDurationType {
	return []LeaseDurationType{LeaseDurationFixed, LeaseDurationInfinite, LeaseDurationNone}
}

// LeaseStateType enumerates the values for lease state type.
type LeaseStateType string

const (
	// LeaseStateAvailable ...
	LeaseStateAvailable LeaseStateType = "available"
	// LeaseStateBreaking ...
	LeaseStateBreaking LeaseStateType = "breaking"
	// LeaseStateBroken ...
	LeaseStateBroken LeaseStateType = "broken"
	// LeaseStateExpired ...
	LeaseStateExpired LeaseStateType = "expired"
	// LeaseStateLeased ...
	LeaseStateLeased LeaseStateType = "leased"
	// LeaseStateNone represents an empty LeaseStateType.
	LeaseStateNone LeaseStateType = ""
)

// PossibleLeaseStateTypeValues returns an array of possible values for the LeaseStateType const type.
func PossibleLeaseStateTypeValues() []LeaseStateType {
	return []LeaseStateType{LeaseStateAvailable, LeaseStateBreaking, LeaseStateBroken, LeaseStateExpired, LeaseStateLeased, LeaseStateNone}
}

// LeaseStatusType enumerates the values for lease status type.
type LeaseStatusType string

const (
	// LeaseStatusLocked ...
	LeaseStatusLocked LeaseStatusType = "locked"
	// LeaseStatusNone represents an empty LeaseStatusType.
	LeaseStatusNone LeaseStatusType = ""
	// LeaseStatusUnlocked ...
	LeaseStatusUnlocked LeaseStatusType = "unlocked"
)

// PossibleLeaseStatusTypeValues returns an array of possible values for the LeaseStatusType const type.
func PossibleLeaseStatusTypeValues() []LeaseStatusType {
	return []LeaseStatusType{LeaseStatusLocked, LeaseStatusNone, LeaseStatusUnlocked}
}

// ListBlobsIncludeItemType enumerates the values for list blobs include item type.
type ListBlobsIncludeItemType string

const (
	// ListBlobsIncludeItemCopy ...
	ListBlobsIncludeItemCopy ListBlobsIncludeItemType = "copy"
	// ListBlobsIncludeItemDeleted ...
	ListBlobsIncludeItemDeleted ListBlobsIncludeItemType = "deleted"
	// ListBlobsIncludeItemMetadata ...
	ListBlobsIncludeItemMetadata ListBlobsIncludeItemType = "metadata"
	// ListBlobsIncludeItemNone represents an empty ListBlobsIncludeItemType.
	ListBlobsIncludeItemNone ListBlobsIncludeItemType = ""
	// ListBlobsIncludeItemSnapshots ...
	ListBlobsIncludeItemSnapshots ListBlobsIncludeItemType = "snapshots"
	// ListBlobsIncludeItemUncommittedblobs ...
	ListBlobsIncludeItemUncommittedblobs ListBlobsIncludeItemType = "uncommittedblobs"
)

// PossibleListBlobsIncludeItemTypeValues returns an array of possible values for the ListBlobsIncludeItemType const type.
func PossibleListBlobsIncludeItemTypeValues() []ListBlobsIncludeItemType {
	return []ListBlobsIncludeItemType{ListBlobsIncludeItemCopy, ListBlobsIncludeItemDeleted, ListBlobsIncludeItemMetadata, ListBlobsIncludeItemNone, ListBlobsIncludeItemSnapshots, ListBlobsIncludeItemUncommittedblobs}
}

// ListContainersIncludeType enumerates the values for list containers include type.
type ListContainersIncludeType string

const (
	// ListContainersIncludeMetadata ...
	ListContainersIncludeMetadata ListContainersIncludeType = "metadata"
	// ListContainersIncludeNone represents an empty ListContainersIncludeType.
	ListContainersIncludeNone ListContainersIncludeType = ""
)

// PossibleListContainersIncludeTypeValues returns an array of possible values for the ListContainersIncludeType const type.
func PossibleListContainersIncludeTypeValues() []ListContainersIncludeType {
	return []ListContainersIncludeType{ListContainersIncludeMetadata, ListContainersIncludeNone}
}

// PublicAccessType enumerates the values for public access type.
type PublicAccessType string

const (
	// PublicAccessBlob ...
	PublicAccessBlob PublicAccessType = "blob"
	// PublicAccessContainer ...
	PublicAccessContainer PublicAccessType = "container"
	// PublicAccessNone represents an empty PublicAccessType.
	PublicAccessNone PublicAccessType = ""
)

// PossiblePublicAccessTypeValues returns an array of possible values for the PublicAccessType const type.
func PossiblePublicAccessTypeValues() []PublicAccessType {
	return []PublicAccessType{PublicAccessBlob, PublicAccessContainer, PublicAccessNone}
}

// SequenceNumberActionType enumerates the values for sequence number action type.
type SequenceNumberActionType string

const (
	// SequenceNumberActionIncrement ...
	SequenceNumberActionIncrement SequenceNumberActionType = "increment"
	// SequenceNumberActionMax ...
	SequenceNumberActionMax SequenceNumberActionType = "max"
	// SequenceNumberActionNone represents an empty SequenceNumberActionType.
	SequenceNumberActionNone SequenceNumberActionType = ""
	// SequenceNumberActionUpdate ...
	SequenceNumberActionUpdate SequenceNumberActionType = "update"
)

// PossibleSequenceNumberActionTypeValues returns an array of possible values for the SequenceNumberActionType const type.
func PossibleSequenceNumberActionTypeValues() []SequenceNumberActionType {
	return []SequenceNumberActionType{SequenceNumberActionIncrement, SequenceNumberActionMax, SequenceNumberActionNone, SequenceNumberActionUpdate}
}

// AccessPolicy - An Access policy
type AccessPolicy struct {
	// Start - the date-time the policy is active
	Start time.Time `xml:"Start"`
	// Expiry - the date-time the policy expires
	Expiry time.Time `xml:"Expiry"`
	// Permission - the permissions for the acl policy
	Permission string `xml:"Permission"`
}

// MarshalXML implements the xml.Marshaler interface for AccessPolicy.
func (ap AccessPolicy) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	if reflect.TypeOf((*AccessPolicy)(nil)).Elem().Size() != reflect.TypeOf((*accessPolicy)(nil)).Elem().Size() {
		panic("size mismatch between AccessPolicy and accessPolicy")
	}
	ap2 := (*accessPolicy)(unsafe.Pointer(&ap))
	return e.EncodeElement(*ap2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for AccessPolicy.
func (ap *AccessPolicy) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if reflect.TypeOf((*AccessPolicy)(nil)).Elem().Size() != reflect.TypeOf((*accessPolicy)(nil)).Elem().Size() {
		panic("size mismatch between AccessPolicy and accessPolicy")
	}
	ap2 := (*accessPolicy)(unsafe.Pointer(ap))
	return d.DecodeElement(ap2, &start)
}

// AppendBlobsAppendBlockResponse ...
type AppendBlobsAppendBlockResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (ababr AppendBlobsAppendBlockResponse) Response() *http.Response {
	return ababr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ababr AppendBlobsAppendBlockResponse) StatusCode() int {
	return ababr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ababr AppendBlobsAppendBlockResponse) Status() string {
	return ababr.rawResponse.Status
}

// BlobAppendOffset returns the value for header x-ms-blob-append-offset.
func (ababr AppendBlobsAppendBlockResponse) BlobAppendOffset() string {
	return ababr.rawResponse.Header.Get("x-ms-blob-append-offset")
}

// BlobCommittedBlockCount returns the value for header x-ms-blob-committed-block-count.
func (ababr AppendBlobsAppendBlockResponse) BlobCommittedBlockCount() int32 {
	s := ababr.rawResponse.Header.Get("x-ms-blob-committed-block-count")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		panic(err)
	}
	return int32(i)
}

// ContentMD5 returns the value for header Content-MD5.
func (ababr AppendBlobsAppendBlockResponse) ContentMD5() []byte {
	s := ababr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// Date returns the value for header Date.
func (ababr AppendBlobsAppendBlockResponse) Date() time.Time {
	s := ababr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (ababr AppendBlobsAppendBlockResponse) ETag() ETag {
	return ETag(ababr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (ababr AppendBlobsAppendBlockResponse) LastModified() time.Time {
	s := ababr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (ababr AppendBlobsAppendBlockResponse) RequestID() string {
	return ababr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ababr AppendBlobsAppendBlockResponse) Version() string {
	return ababr.rawResponse.Header.Get("x-ms-version")
}

// AppendBlobsCreateResponse ...
type AppendBlobsCreateResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (abcr AppendBlobsCreateResponse) Response() *http.Response {
	return abcr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (abcr AppendBlobsCreateResponse) StatusCode() int {
	return abcr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (abcr AppendBlobsCreateResponse) Status() string {
	return abcr.rawResponse.Status
}

// ContentMD5 returns the value for header Content-MD5.
func (abcr AppendBlobsCreateResponse) ContentMD5() []byte {
	s := abcr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// Date returns the value for header Date.
func (abcr AppendBlobsCreateResponse) Date() time.Time {
	s := abcr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (abcr AppendBlobsCreateResponse) ETag() ETag {
	return ETag(abcr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (abcr AppendBlobsCreateResponse) IsServerEncrypted() string {
	return abcr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (abcr AppendBlobsCreateResponse) LastModified() time.Time {
	s := abcr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (abcr AppendBlobsCreateResponse) RequestID() string {
	return abcr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (abcr AppendBlobsCreateResponse) Version() string {
	return abcr.rawResponse.Header.Get("x-ms-version")
}

// Blob - An Azure Storage blob
type Blob struct {
	Name       string         `xml:"Name"`
	Deleted    bool           `xml:"Deleted"`
	Snapshot   string         `xml:"Snapshot"`
	Properties BlobProperties `xml:"Properties"`
	Metadata   Metadata       `xml:"Metadata"`
}

// BlobFlatList ...
type BlobFlatList struct {
	Blob []Blob `xml:"Blob"`
}

// BlobHierarchyList ...
type BlobHierarchyList struct {
	BlobPrefix []BlobPrefix `xml:"BlobPrefix"`
	Blob       []Blob       `xml:"Blob"`
}

// BlobPrefix ...
type BlobPrefix struct {
	Name string `xml:"Name"`
}

// BlobProperties - Properties of a blob
type BlobProperties struct {
	LastModified time.Time `xml:"Last-Modified"`
	Etag         ETag      `xml:"Etag"`
	// ContentLength - Size in bytes
	ContentLength      *int64  `xml:"Content-Length"`
	ContentType        *string `xml:"Content-Type"`
	ContentEncoding    *string `xml:"Content-Encoding"`
	ContentLanguage    *string `xml:"Content-Language"`
	ContentMD5         []byte  `xml:"Content-MD5"`
	ContentDisposition *string `xml:"Content-Disposition"`
	CacheControl       *string `xml:"Cache-Control"`
	BlobSequenceNumber *int64  `xml:"x-ms-blob-sequence-number"`
	// BlobType - Possible values include: 'BlobBlockBlob', 'BlobPageBlob', 'BlobAppendBlob', 'BlobNone'
	BlobType BlobType `xml:"BlobType"`
	// LeaseStatus - Possible values include: 'LeaseStatusLocked', 'LeaseStatusUnlocked', 'LeaseStatusNone'
	LeaseStatus LeaseStatusType `xml:"LeaseStatus"`
	// LeaseState - Possible values include: 'LeaseStateAvailable', 'LeaseStateLeased', 'LeaseStateExpired', 'LeaseStateBreaking', 'LeaseStateBroken', 'LeaseStateNone'
	LeaseState LeaseStateType `xml:"LeaseState"`
	// LeaseDuration - Possible values include: 'LeaseDurationInfinite', 'LeaseDurationFixed', 'LeaseDurationNone'
	LeaseDuration LeaseDurationType `xml:"LeaseDuration"`
	CopyID        *string           `xml:"CopyId"`
	// CopyStatus - Possible values include: 'CopyStatusPending', 'CopyStatusSuccess', 'CopyStatusAborted', 'CopyStatusFailed', 'CopyStatusNone'
	CopyStatus             CopyStatusType `xml:"CopyStatus"`
	CopySource             *string        `xml:"CopySource"`
	CopyProgress           *string        `xml:"CopyProgress"`
	CopyCompletionTime     *time.Time     `xml:"CopyCompletionTime"`
	CopyStatusDescription  *string        `xml:"CopyStatusDescription"`
	ServerEncrypted        *bool          `xml:"ServerEncrypted"`
	IncrementalCopy        *bool          `xml:"IncrementalCopy"`
	DestinationSnapshot    *string        `xml:"DestinationSnapshot"`
	DeletedTime            *time.Time     `xml:"DeletedTime"`
	RemainingRetentionDays *int32         `xml:"RemainingRetentionDays"`
	// AccessTier - Possible values include: 'AccessTierP4', 'AccessTierP6', 'AccessTierP10', 'AccessTierP20', 'AccessTierP30', 'AccessTierP40', 'AccessTierP50', 'AccessTierHot', 'AccessTierCool', 'AccessTierArchive', 'AccessTierNone'
	AccessTier         AccessTierType `xml:"AccessTier"`
	AccessTierInferred *bool          `xml:"AccessTierInferred"`
	// ArchiveStatus - Possible values include: 'ArchiveStatusRehydratePendingToHot', 'ArchiveStatusRehydratePendingToCool', 'ArchiveStatusNone'
	ArchiveStatus ArchiveStatusType `xml:"ArchiveStatus"`
}

// MarshalXML implements the xml.Marshaler interface for BlobProperties.
func (bp BlobProperties) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	if reflect.TypeOf((*BlobProperties)(nil)).Elem().Size() != reflect.TypeOf((*blobProperties)(nil)).Elem().Size() {
		panic("size mismatch between BlobProperties and blobProperties")
	}
	bp2 := (*blobProperties)(unsafe.Pointer(&bp))
	return e.EncodeElement(*bp2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for BlobProperties.
func (bp *BlobProperties) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if reflect.TypeOf((*BlobProperties)(nil)).Elem().Size() != reflect.TypeOf((*blobProperties)(nil)).Elem().Size() {
		panic("size mismatch between BlobProperties and blobProperties")
	}
	bp2 := (*blobProperties)(unsafe.Pointer(bp))
	return d.DecodeElement(bp2, &start)
}

// BlobsAbortCopyFromURLResponse ...
type BlobsAbortCopyFromURLResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bacfur BlobsAbortCopyFromURLResponse) Response() *http.Response {
	return bacfur.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bacfur BlobsAbortCopyFromURLResponse) StatusCode() int {
	return bacfur.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bacfur BlobsAbortCopyFromURLResponse) Status() string {
	return bacfur.rawResponse.Status
}

// Date returns the value for header Date.
func (bacfur BlobsAbortCopyFromURLResponse) Date() time.Time {
	s := bacfur.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bacfur BlobsAbortCopyFromURLResponse) RequestID() string {
	return bacfur.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bacfur BlobsAbortCopyFromURLResponse) Version() string {
	return bacfur.rawResponse.Header.Get("x-ms-version")
}

// BlobsAcquireLeaseResponse ...
type BlobsAcquireLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (balr BlobsAcquireLeaseResponse) Response() *http.Response {
	return balr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (balr BlobsAcquireLeaseResponse) StatusCode() int {
	return balr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (balr BlobsAcquireLeaseResponse) Status() string {
	return balr.rawResponse.Status
}

// Date returns the value for header Date.
func (balr BlobsAcquireLeaseResponse) Date() time.Time {
	s := balr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (balr BlobsAcquireLeaseResponse) ETag() ETag {
	return ETag(balr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (balr BlobsAcquireLeaseResponse) LastModified() time.Time {
	s := balr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseID returns the value for header x-ms-lease-id.
func (balr BlobsAcquireLeaseResponse) LeaseID() string {
	return balr.rawResponse.Header.Get("x-ms-lease-id")
}

// RequestID returns the value for header x-ms-request-id.
func (balr BlobsAcquireLeaseResponse) RequestID() string {
	return balr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (balr BlobsAcquireLeaseResponse) Version() string {
	return balr.rawResponse.Header.Get("x-ms-version")
}

// BlobsBreakLeaseResponse ...
type BlobsBreakLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bblr BlobsBreakLeaseResponse) Response() *http.Response {
	return bblr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bblr BlobsBreakLeaseResponse) StatusCode() int {
	return bblr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bblr BlobsBreakLeaseResponse) Status() string {
	return bblr.rawResponse.Status
}

// Date returns the value for header Date.
func (bblr BlobsBreakLeaseResponse) Date() time.Time {
	s := bblr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bblr BlobsBreakLeaseResponse) ETag() ETag {
	return ETag(bblr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (bblr BlobsBreakLeaseResponse) LastModified() time.Time {
	s := bblr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseTime returns the value for header x-ms-lease-time.
func (bblr BlobsBreakLeaseResponse) LeaseTime() int32 {
	s := bblr.rawResponse.Header.Get("x-ms-lease-time")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		panic(err)
	}
	return int32(i)
}

// RequestID returns the value for header x-ms-request-id.
func (bblr BlobsBreakLeaseResponse) RequestID() string {
	return bblr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bblr BlobsBreakLeaseResponse) Version() string {
	return bblr.rawResponse.Header.Get("x-ms-version")
}

// BlobsChangeLeaseResponse ...
type BlobsChangeLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bclr BlobsChangeLeaseResponse) Response() *http.Response {
	return bclr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bclr BlobsChangeLeaseResponse) StatusCode() int {
	return bclr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bclr BlobsChangeLeaseResponse) Status() string {
	return bclr.rawResponse.Status
}

// Date returns the value for header Date.
func (bclr BlobsChangeLeaseResponse) Date() time.Time {
	s := bclr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bclr BlobsChangeLeaseResponse) ETag() ETag {
	return ETag(bclr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (bclr BlobsChangeLeaseResponse) LastModified() time.Time {
	s := bclr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseID returns the value for header x-ms-lease-id.
func (bclr BlobsChangeLeaseResponse) LeaseID() string {
	return bclr.rawResponse.Header.Get("x-ms-lease-id")
}

// RequestID returns the value for header x-ms-request-id.
func (bclr BlobsChangeLeaseResponse) RequestID() string {
	return bclr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bclr BlobsChangeLeaseResponse) Version() string {
	return bclr.rawResponse.Header.Get("x-ms-version")
}

// BlobsCreateSnapshotResponse ...
type BlobsCreateSnapshotResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bcsr BlobsCreateSnapshotResponse) Response() *http.Response {
	return bcsr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bcsr BlobsCreateSnapshotResponse) StatusCode() int {
	return bcsr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bcsr BlobsCreateSnapshotResponse) Status() string {
	return bcsr.rawResponse.Status
}

// Date returns the value for header Date.
func (bcsr BlobsCreateSnapshotResponse) Date() time.Time {
	s := bcsr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bcsr BlobsCreateSnapshotResponse) ETag() ETag {
	return ETag(bcsr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (bcsr BlobsCreateSnapshotResponse) LastModified() time.Time {
	s := bcsr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bcsr BlobsCreateSnapshotResponse) RequestID() string {
	return bcsr.rawResponse.Header.Get("x-ms-request-id")
}

// Snapshot returns the value for header x-ms-snapshot.
func (bcsr BlobsCreateSnapshotResponse) Snapshot() string {
	return bcsr.rawResponse.Header.Get("x-ms-snapshot")
}

// Version returns the value for header x-ms-version.
func (bcsr BlobsCreateSnapshotResponse) Version() string {
	return bcsr.rawResponse.Header.Get("x-ms-version")
}

// BlobsDeleteResponse ...
type BlobsDeleteResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bdr BlobsDeleteResponse) Response() *http.Response {
	return bdr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bdr BlobsDeleteResponse) StatusCode() int {
	return bdr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bdr BlobsDeleteResponse) Status() string {
	return bdr.rawResponse.Status
}

// Date returns the value for header Date.
func (bdr BlobsDeleteResponse) Date() time.Time {
	s := bdr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bdr BlobsDeleteResponse) RequestID() string {
	return bdr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bdr BlobsDeleteResponse) Version() string {
	return bdr.rawResponse.Header.Get("x-ms-version")
}

// BlobsGetPropertiesResponse ...
type BlobsGetPropertiesResponse struct {
	rawResponse *http.Response
}

// NewMetadata returns user-defined key/value pairs.
func (bgpr BlobsGetPropertiesResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range bgpr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// Response returns the raw HTTP response object.
func (bgpr BlobsGetPropertiesResponse) Response() *http.Response {
	return bgpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bgpr BlobsGetPropertiesResponse) StatusCode() int {
	return bgpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bgpr BlobsGetPropertiesResponse) Status() string {
	return bgpr.rawResponse.Status
}

// AcceptRanges returns the value for header Accept-Ranges.
func (bgpr BlobsGetPropertiesResponse) AcceptRanges() string {
	return bgpr.rawResponse.Header.Get("Accept-Ranges")
}

// AccessTier returns the value for header x-ms-access-tier.
func (bgpr BlobsGetPropertiesResponse) AccessTier() string {
	return bgpr.rawResponse.Header.Get("x-ms-access-tier")
}

// AccessTierInferred returns the value for header x-ms-access-tier-inferred.
func (bgpr BlobsGetPropertiesResponse) AccessTierInferred() string {
	return bgpr.rawResponse.Header.Get("x-ms-access-tier-inferred")
}

// ArchiveStatus returns the value for header x-ms-archive-status.
func (bgpr BlobsGetPropertiesResponse) ArchiveStatus() string {
	return bgpr.rawResponse.Header.Get("x-ms-archive-status")
}

// BlobCommittedBlockCount returns the value for header x-ms-blob-committed-block-count.
func (bgpr BlobsGetPropertiesResponse) BlobCommittedBlockCount() int32 {
	s := bgpr.rawResponse.Header.Get("x-ms-blob-committed-block-count")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		panic(err)
	}
	return int32(i)
}

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (bgpr BlobsGetPropertiesResponse) BlobSequenceNumber() int64 {
	s := bgpr.rawResponse.Header.Get("x-ms-blob-sequence-number")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// BlobType returns the value for header x-ms-blob-type.
func (bgpr BlobsGetPropertiesResponse) BlobType() BlobType {
	return BlobType(bgpr.rawResponse.Header.Get("x-ms-blob-type"))
}

// CacheControl returns the value for header Cache-Control.
func (bgpr BlobsGetPropertiesResponse) CacheControl() string {
	return bgpr.rawResponse.Header.Get("Cache-Control")
}

// ContentDisposition returns the value for header Content-Disposition.
func (bgpr BlobsGetPropertiesResponse) ContentDisposition() string {
	return bgpr.rawResponse.Header.Get("Content-Disposition")
}

// ContentEncoding returns the value for header Content-Encoding.
func (bgpr BlobsGetPropertiesResponse) ContentEncoding() string {
	return bgpr.rawResponse.Header.Get("Content-Encoding")
}

// ContentLanguage returns the value for header Content-Language.
func (bgpr BlobsGetPropertiesResponse) ContentLanguage() string {
	return bgpr.rawResponse.Header.Get("Content-Language")
}

// ContentLength returns the value for header Content-Length.
func (bgpr BlobsGetPropertiesResponse) ContentLength() int64 {
	s := bgpr.rawResponse.Header.Get("Content-Length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// ContentMD5 returns the value for header Content-MD5.
func (bgpr BlobsGetPropertiesResponse) ContentMD5() []byte {
	s := bgpr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// ContentType returns the value for header Content-Type.
func (bgpr BlobsGetPropertiesResponse) ContentType() string {
	return bgpr.rawResponse.Header.Get("Content-Type")
}

// CopyCompletionTime returns the value for header x-ms-copy-completion-time.
func (bgpr BlobsGetPropertiesResponse) CopyCompletionTime() time.Time {
	s := bgpr.rawResponse.Header.Get("x-ms-copy-completion-time")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// CopyID returns the value for header x-ms-copy-id.
func (bgpr BlobsGetPropertiesResponse) CopyID() string {
	return bgpr.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyProgress returns the value for header x-ms-copy-progress.
func (bgpr BlobsGetPropertiesResponse) CopyProgress() string {
	return bgpr.rawResponse.Header.Get("x-ms-copy-progress")
}

// CopySource returns the value for header x-ms-copy-source.
func (bgpr BlobsGetPropertiesResponse) CopySource() string {
	return bgpr.rawResponse.Header.Get("x-ms-copy-source")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (bgpr BlobsGetPropertiesResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(bgpr.rawResponse.Header.Get("x-ms-copy-status"))
}

// CopyStatusDescription returns the value for header x-ms-copy-status-description.
func (bgpr BlobsGetPropertiesResponse) CopyStatusDescription() string {
	return bgpr.rawResponse.Header.Get("x-ms-copy-status-description")
}

// Date returns the value for header Date.
func (bgpr BlobsGetPropertiesResponse) Date() time.Time {
	s := bgpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// DestinationSnapshot returns the value for header x-ms-copy-destination-snapshot.
func (bgpr BlobsGetPropertiesResponse) DestinationSnapshot() string {
	return bgpr.rawResponse.Header.Get("x-ms-copy-destination-snapshot")
}

// ETag returns the value for header ETag.
func (bgpr BlobsGetPropertiesResponse) ETag() ETag {
	return ETag(bgpr.rawResponse.Header.Get("ETag"))
}

// IsIncrementalCopy returns the value for header x-ms-incremental-copy.
func (bgpr BlobsGetPropertiesResponse) IsIncrementalCopy() string {
	return bgpr.rawResponse.Header.Get("x-ms-incremental-copy")
}

// IsServerEncrypted returns the value for header x-ms-server-encrypted.
func (bgpr BlobsGetPropertiesResponse) IsServerEncrypted() string {
	return bgpr.rawResponse.Header.Get("x-ms-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (bgpr BlobsGetPropertiesResponse) LastModified() time.Time {
	s := bgpr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseDuration returns the value for header x-ms-lease-duration.
func (bgpr BlobsGetPropertiesResponse) LeaseDuration() LeaseDurationType {
	return LeaseDurationType(bgpr.rawResponse.Header.Get("x-ms-lease-duration"))
}

// LeaseState returns the value for header x-ms-lease-state.
func (bgpr BlobsGetPropertiesResponse) LeaseState() LeaseStateType {
	return LeaseStateType(bgpr.rawResponse.Header.Get("x-ms-lease-state"))
}

// LeaseStatus returns the value for header x-ms-lease-status.
func (bgpr BlobsGetPropertiesResponse) LeaseStatus() LeaseStatusType {
	return LeaseStatusType(bgpr.rawResponse.Header.Get("x-ms-lease-status"))
}

// RequestID returns the value for header x-ms-request-id.
func (bgpr BlobsGetPropertiesResponse) RequestID() string {
	return bgpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bgpr BlobsGetPropertiesResponse) Version() string {
	return bgpr.rawResponse.Header.Get("x-ms-version")
}

// BlobsReleaseLeaseResponse ...
type BlobsReleaseLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (brlr BlobsReleaseLeaseResponse) Response() *http.Response {
	return brlr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (brlr BlobsReleaseLeaseResponse) StatusCode() int {
	return brlr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (brlr BlobsReleaseLeaseResponse) Status() string {
	return brlr.rawResponse.Status
}

// Date returns the value for header Date.
func (brlr BlobsReleaseLeaseResponse) Date() time.Time {
	s := brlr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (brlr BlobsReleaseLeaseResponse) ETag() ETag {
	return ETag(brlr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (brlr BlobsReleaseLeaseResponse) LastModified() time.Time {
	s := brlr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (brlr BlobsReleaseLeaseResponse) RequestID() string {
	return brlr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (brlr BlobsReleaseLeaseResponse) Version() string {
	return brlr.rawResponse.Header.Get("x-ms-version")
}

// BlobsRenewLeaseResponse ...
type BlobsRenewLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (brlr BlobsRenewLeaseResponse) Response() *http.Response {
	return brlr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (brlr BlobsRenewLeaseResponse) StatusCode() int {
	return brlr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (brlr BlobsRenewLeaseResponse) Status() string {
	return brlr.rawResponse.Status
}

// Date returns the value for header Date.
func (brlr BlobsRenewLeaseResponse) Date() time.Time {
	s := brlr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (brlr BlobsRenewLeaseResponse) ETag() ETag {
	return ETag(brlr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (brlr BlobsRenewLeaseResponse) LastModified() time.Time {
	s := brlr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseID returns the value for header x-ms-lease-id.
func (brlr BlobsRenewLeaseResponse) LeaseID() string {
	return brlr.rawResponse.Header.Get("x-ms-lease-id")
}

// RequestID returns the value for header x-ms-request-id.
func (brlr BlobsRenewLeaseResponse) RequestID() string {
	return brlr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (brlr BlobsRenewLeaseResponse) Version() string {
	return brlr.rawResponse.Header.Get("x-ms-version")
}

// BlobsSetHTTPHeadersResponse ...
type BlobsSetHTTPHeadersResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bshhr BlobsSetHTTPHeadersResponse) Response() *http.Response {
	return bshhr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bshhr BlobsSetHTTPHeadersResponse) StatusCode() int {
	return bshhr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bshhr BlobsSetHTTPHeadersResponse) Status() string {
	return bshhr.rawResponse.Status
}

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (bshhr BlobsSetHTTPHeadersResponse) BlobSequenceNumber() int64 {
	s := bshhr.rawResponse.Header.Get("x-ms-blob-sequence-number")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// Date returns the value for header Date.
func (bshhr BlobsSetHTTPHeadersResponse) Date() time.Time {
	s := bshhr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bshhr BlobsSetHTTPHeadersResponse) ETag() ETag {
	return ETag(bshhr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (bshhr BlobsSetHTTPHeadersResponse) LastModified() time.Time {
	s := bshhr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bshhr BlobsSetHTTPHeadersResponse) RequestID() string {
	return bshhr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bshhr BlobsSetHTTPHeadersResponse) Version() string {
	return bshhr.rawResponse.Header.Get("x-ms-version")
}

// BlobsSetMetadataResponse ...
type BlobsSetMetadataResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bsmr BlobsSetMetadataResponse) Response() *http.Response {
	return bsmr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bsmr BlobsSetMetadataResponse) StatusCode() int {
	return bsmr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bsmr BlobsSetMetadataResponse) Status() string {
	return bsmr.rawResponse.Status
}

// Date returns the value for header Date.
func (bsmr BlobsSetMetadataResponse) Date() time.Time {
	s := bsmr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bsmr BlobsSetMetadataResponse) ETag() ETag {
	return ETag(bsmr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (bsmr BlobsSetMetadataResponse) IsServerEncrypted() string {
	return bsmr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (bsmr BlobsSetMetadataResponse) LastModified() time.Time {
	s := bsmr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bsmr BlobsSetMetadataResponse) RequestID() string {
	return bsmr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bsmr BlobsSetMetadataResponse) Version() string {
	return bsmr.rawResponse.Header.Get("x-ms-version")
}

// BlobsSetTierResponse ...
type BlobsSetTierResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bstr BlobsSetTierResponse) Response() *http.Response {
	return bstr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bstr BlobsSetTierResponse) StatusCode() int {
	return bstr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bstr BlobsSetTierResponse) Status() string {
	return bstr.rawResponse.Status
}

// RequestID returns the value for header x-ms-request-id.
func (bstr BlobsSetTierResponse) RequestID() string {
	return bstr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bstr BlobsSetTierResponse) Version() string {
	return bstr.rawResponse.Header.Get("x-ms-version")
}

// BlobsStartCopyFromURLResponse ...
type BlobsStartCopyFromURLResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bscfur BlobsStartCopyFromURLResponse) Response() *http.Response {
	return bscfur.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bscfur BlobsStartCopyFromURLResponse) StatusCode() int {
	return bscfur.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bscfur BlobsStartCopyFromURLResponse) Status() string {
	return bscfur.rawResponse.Status
}

// CopyID returns the value for header x-ms-copy-id.
func (bscfur BlobsStartCopyFromURLResponse) CopyID() string {
	return bscfur.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (bscfur BlobsStartCopyFromURLResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(bscfur.rawResponse.Header.Get("x-ms-copy-status"))
}

// Date returns the value for header Date.
func (bscfur BlobsStartCopyFromURLResponse) Date() time.Time {
	s := bscfur.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bscfur BlobsStartCopyFromURLResponse) ETag() ETag {
	return ETag(bscfur.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (bscfur BlobsStartCopyFromURLResponse) LastModified() time.Time {
	s := bscfur.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bscfur BlobsStartCopyFromURLResponse) RequestID() string {
	return bscfur.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bscfur BlobsStartCopyFromURLResponse) Version() string {
	return bscfur.rawResponse.Header.Get("x-ms-version")
}

// BlobsUndeleteResponse ...
type BlobsUndeleteResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bur BlobsUndeleteResponse) Response() *http.Response {
	return bur.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bur BlobsUndeleteResponse) StatusCode() int {
	return bur.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bur BlobsUndeleteResponse) Status() string {
	return bur.rawResponse.Status
}

// Date returns the value for header Date.
func (bur BlobsUndeleteResponse) Date() time.Time {
	s := bur.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bur BlobsUndeleteResponse) RequestID() string {
	return bur.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bur BlobsUndeleteResponse) Version() string {
	return bur.rawResponse.Header.Get("x-ms-version")
}

// Block - Represents a single block in a block blob.  It describes the block's ID and size.
type Block struct {
	// Name - The base64 encoded block ID.
	Name string `xml:"Name"`
	// Size - The block size in bytes.
	Size int32 `xml:"Size"`
}

// BlockBlobsCommitBlockListResponse ...
type BlockBlobsCommitBlockListResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bbcblr BlockBlobsCommitBlockListResponse) Response() *http.Response {
	return bbcblr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bbcblr BlockBlobsCommitBlockListResponse) StatusCode() int {
	return bbcblr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bbcblr BlockBlobsCommitBlockListResponse) Status() string {
	return bbcblr.rawResponse.Status
}

// ContentMD5 returns the value for header Content-MD5.
func (bbcblr BlockBlobsCommitBlockListResponse) ContentMD5() []byte {
	s := bbcblr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// Date returns the value for header Date.
func (bbcblr BlockBlobsCommitBlockListResponse) Date() time.Time {
	s := bbcblr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bbcblr BlockBlobsCommitBlockListResponse) ETag() ETag {
	return ETag(bbcblr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (bbcblr BlockBlobsCommitBlockListResponse) IsServerEncrypted() string {
	return bbcblr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (bbcblr BlockBlobsCommitBlockListResponse) LastModified() time.Time {
	s := bbcblr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bbcblr BlockBlobsCommitBlockListResponse) RequestID() string {
	return bbcblr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bbcblr BlockBlobsCommitBlockListResponse) Version() string {
	return bbcblr.rawResponse.Header.Get("x-ms-version")
}

// BlockBlobsStageBlockResponse ...
type BlockBlobsStageBlockResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bbsbr BlockBlobsStageBlockResponse) Response() *http.Response {
	return bbsbr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bbsbr BlockBlobsStageBlockResponse) StatusCode() int {
	return bbsbr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bbsbr BlockBlobsStageBlockResponse) Status() string {
	return bbsbr.rawResponse.Status
}

// ContentMD5 returns the value for header Content-MD5.
func (bbsbr BlockBlobsStageBlockResponse) ContentMD5() []byte {
	s := bbsbr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// Date returns the value for header Date.
func (bbsbr BlockBlobsStageBlockResponse) Date() time.Time {
	s := bbsbr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (bbsbr BlockBlobsStageBlockResponse) IsServerEncrypted() string {
	return bbsbr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// RequestID returns the value for header x-ms-request-id.
func (bbsbr BlockBlobsStageBlockResponse) RequestID() string {
	return bbsbr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bbsbr BlockBlobsStageBlockResponse) Version() string {
	return bbsbr.rawResponse.Header.Get("x-ms-version")
}

// BlockBlobsUploadResponse ...
type BlockBlobsUploadResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bbur BlockBlobsUploadResponse) Response() *http.Response {
	return bbur.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bbur BlockBlobsUploadResponse) StatusCode() int {
	return bbur.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bbur BlockBlobsUploadResponse) Status() string {
	return bbur.rawResponse.Status
}

// ContentMD5 returns the value for header Content-MD5.
func (bbur BlockBlobsUploadResponse) ContentMD5() []byte {
	s := bbur.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// Date returns the value for header Date.
func (bbur BlockBlobsUploadResponse) Date() time.Time {
	s := bbur.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bbur BlockBlobsUploadResponse) ETag() ETag {
	return ETag(bbur.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (bbur BlockBlobsUploadResponse) IsServerEncrypted() string {
	return bbur.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (bbur BlockBlobsUploadResponse) LastModified() time.Time {
	s := bbur.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bbur BlockBlobsUploadResponse) RequestID() string {
	return bbur.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bbur BlockBlobsUploadResponse) Version() string {
	return bbur.rawResponse.Header.Get("x-ms-version")
}

// BlockList ...
type BlockList struct {
	rawResponse       *http.Response
	CommittedBlocks   []Block `xml:"CommittedBlocks>Block"`
	UncommittedBlocks []Block `xml:"UncommittedBlocks>Block"`
}

// Response returns the raw HTTP response object.
func (bl BlockList) Response() *http.Response {
	return bl.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bl BlockList) StatusCode() int {
	return bl.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bl BlockList) Status() string {
	return bl.rawResponse.Status
}

// BlobContentLength returns the value for header x-ms-blob-content-length.
func (bl BlockList) BlobContentLength() int64 {
	s := bl.rawResponse.Header.Get("x-ms-blob-content-length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// ContentType returns the value for header Content-Type.
func (bl BlockList) ContentType() string {
	return bl.rawResponse.Header.Get("Content-Type")
}

// Date returns the value for header Date.
func (bl BlockList) Date() time.Time {
	s := bl.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bl BlockList) ETag() ETag {
	return ETag(bl.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (bl BlockList) LastModified() time.Time {
	s := bl.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bl BlockList) RequestID() string {
	return bl.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bl BlockList) Version() string {
	return bl.rawResponse.Header.Get("x-ms-version")
}

// BlockLookupList ...
type BlockLookupList struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName     xml.Name `xml:"BlockList"`
	Committed   []string `xml:"Committed"`
	Uncommitted []string `xml:"Uncommitted"`
	Latest      []string `xml:"Latest"`
}

// ClearRange ...
type ClearRange struct {
	Start int64 `xml:"Start"`
	End   int64 `xml:"End"`
}

// Container - An Azure Storage container
type Container struct {
	Name       string              `xml:"Name"`
	Properties ContainerProperties `xml:"Properties"`
	Metadata   Metadata            `xml:"Metadata"`
}

// ContainerProperties - Properties of a container
type ContainerProperties struct {
	LastModified time.Time `xml:"Last-Modified"`
	Etag         ETag      `xml:"Etag"`
	// LeaseStatus - Possible values include: 'LeaseStatusLocked', 'LeaseStatusUnlocked', 'LeaseStatusNone'
	LeaseStatus LeaseStatusType `xml:"LeaseStatus"`
	// LeaseState - Possible values include: 'LeaseStateAvailable', 'LeaseStateLeased', 'LeaseStateExpired', 'LeaseStateBreaking', 'LeaseStateBroken', 'LeaseStateNone'
	LeaseState LeaseStateType `xml:"LeaseState"`
	// LeaseDuration - Possible values include: 'LeaseDurationInfinite', 'LeaseDurationFixed', 'LeaseDurationNone'
	LeaseDuration LeaseDurationType `xml:"LeaseDuration"`
	// PublicAccess - Possible values include: 'PublicAccessContainer', 'PublicAccessBlob', 'PublicAccessNone'
	PublicAccess PublicAccessType `xml:"PublicAccess"`
}

// MarshalXML implements the xml.Marshaler interface for ContainerProperties.
func (cp ContainerProperties) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	if reflect.TypeOf((*ContainerProperties)(nil)).Elem().Size() != reflect.TypeOf((*containerProperties)(nil)).Elem().Size() {
		panic("size mismatch between ContainerProperties and containerProperties")
	}
	cp2 := (*containerProperties)(unsafe.Pointer(&cp))
	return e.EncodeElement(*cp2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for ContainerProperties.
func (cp *ContainerProperties) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if reflect.TypeOf((*ContainerProperties)(nil)).Elem().Size() != reflect.TypeOf((*containerProperties)(nil)).Elem().Size() {
		panic("size mismatch between ContainerProperties and containerProperties")
	}
	cp2 := (*containerProperties)(unsafe.Pointer(cp))
	return d.DecodeElement(cp2, &start)
}

// ContainersAcquireLeaseResponse ...
type ContainersAcquireLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (calr ContainersAcquireLeaseResponse) Response() *http.Response {
	return calr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (calr ContainersAcquireLeaseResponse) StatusCode() int {
	return calr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (calr ContainersAcquireLeaseResponse) Status() string {
	return calr.rawResponse.Status
}

// Date returns the value for header Date.
func (calr ContainersAcquireLeaseResponse) Date() time.Time {
	s := calr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (calr ContainersAcquireLeaseResponse) ETag() ETag {
	return ETag(calr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (calr ContainersAcquireLeaseResponse) LastModified() time.Time {
	s := calr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseID returns the value for header x-ms-lease-id.
func (calr ContainersAcquireLeaseResponse) LeaseID() string {
	return calr.rawResponse.Header.Get("x-ms-lease-id")
}

// RequestID returns the value for header x-ms-request-id.
func (calr ContainersAcquireLeaseResponse) RequestID() string {
	return calr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (calr ContainersAcquireLeaseResponse) Version() string {
	return calr.rawResponse.Header.Get("x-ms-version")
}

// ContainersBreakLeaseResponse ...
type ContainersBreakLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (cblr ContainersBreakLeaseResponse) Response() *http.Response {
	return cblr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (cblr ContainersBreakLeaseResponse) StatusCode() int {
	return cblr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (cblr ContainersBreakLeaseResponse) Status() string {
	return cblr.rawResponse.Status
}

// Date returns the value for header Date.
func (cblr ContainersBreakLeaseResponse) Date() time.Time {
	s := cblr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (cblr ContainersBreakLeaseResponse) ETag() ETag {
	return ETag(cblr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (cblr ContainersBreakLeaseResponse) LastModified() time.Time {
	s := cblr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseTime returns the value for header x-ms-lease-time.
func (cblr ContainersBreakLeaseResponse) LeaseTime() int32 {
	s := cblr.rawResponse.Header.Get("x-ms-lease-time")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		panic(err)
	}
	return int32(i)
}

// RequestID returns the value for header x-ms-request-id.
func (cblr ContainersBreakLeaseResponse) RequestID() string {
	return cblr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (cblr ContainersBreakLeaseResponse) Version() string {
	return cblr.rawResponse.Header.Get("x-ms-version")
}

// ContainersChangeLeaseResponse ...
type ContainersChangeLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (cclr ContainersChangeLeaseResponse) Response() *http.Response {
	return cclr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (cclr ContainersChangeLeaseResponse) StatusCode() int {
	return cclr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (cclr ContainersChangeLeaseResponse) Status() string {
	return cclr.rawResponse.Status
}

// Date returns the value for header Date.
func (cclr ContainersChangeLeaseResponse) Date() time.Time {
	s := cclr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (cclr ContainersChangeLeaseResponse) ETag() ETag {
	return ETag(cclr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (cclr ContainersChangeLeaseResponse) LastModified() time.Time {
	s := cclr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseID returns the value for header x-ms-lease-id.
func (cclr ContainersChangeLeaseResponse) LeaseID() string {
	return cclr.rawResponse.Header.Get("x-ms-lease-id")
}

// RequestID returns the value for header x-ms-request-id.
func (cclr ContainersChangeLeaseResponse) RequestID() string {
	return cclr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (cclr ContainersChangeLeaseResponse) Version() string {
	return cclr.rawResponse.Header.Get("x-ms-version")
}

// ContainersCreateResponse ...
type ContainersCreateResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (ccr ContainersCreateResponse) Response() *http.Response {
	return ccr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ccr ContainersCreateResponse) StatusCode() int {
	return ccr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ccr ContainersCreateResponse) Status() string {
	return ccr.rawResponse.Status
}

// Date returns the value for header Date.
func (ccr ContainersCreateResponse) Date() time.Time {
	s := ccr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (ccr ContainersCreateResponse) ETag() ETag {
	return ETag(ccr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (ccr ContainersCreateResponse) LastModified() time.Time {
	s := ccr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (ccr ContainersCreateResponse) RequestID() string {
	return ccr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ccr ContainersCreateResponse) Version() string {
	return ccr.rawResponse.Header.Get("x-ms-version")
}

// ContainersDeleteResponse ...
type ContainersDeleteResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (cdr ContainersDeleteResponse) Response() *http.Response {
	return cdr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (cdr ContainersDeleteResponse) StatusCode() int {
	return cdr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (cdr ContainersDeleteResponse) Status() string {
	return cdr.rawResponse.Status
}

// Date returns the value for header Date.
func (cdr ContainersDeleteResponse) Date() time.Time {
	s := cdr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (cdr ContainersDeleteResponse) RequestID() string {
	return cdr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (cdr ContainersDeleteResponse) Version() string {
	return cdr.rawResponse.Header.Get("x-ms-version")
}

// ContainersGetPropertiesResponse ...
type ContainersGetPropertiesResponse struct {
	rawResponse *http.Response
}

// NewMetadata returns user-defined key/value pairs.
func (cgpr ContainersGetPropertiesResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range cgpr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// Response returns the raw HTTP response object.
func (cgpr ContainersGetPropertiesResponse) Response() *http.Response {
	return cgpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (cgpr ContainersGetPropertiesResponse) StatusCode() int {
	return cgpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (cgpr ContainersGetPropertiesResponse) Status() string {
	return cgpr.rawResponse.Status
}

// BlobPublicAccess returns the value for header x-ms-blob-public-access.
func (cgpr ContainersGetPropertiesResponse) BlobPublicAccess() PublicAccessType {
	return PublicAccessType(cgpr.rawResponse.Header.Get("x-ms-blob-public-access"))
}

// Date returns the value for header Date.
func (cgpr ContainersGetPropertiesResponse) Date() time.Time {
	s := cgpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (cgpr ContainersGetPropertiesResponse) ETag() ETag {
	return ETag(cgpr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (cgpr ContainersGetPropertiesResponse) LastModified() time.Time {
	s := cgpr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseDuration returns the value for header x-ms-lease-duration.
func (cgpr ContainersGetPropertiesResponse) LeaseDuration() LeaseDurationType {
	return LeaseDurationType(cgpr.rawResponse.Header.Get("x-ms-lease-duration"))
}

// LeaseState returns the value for header x-ms-lease-state.
func (cgpr ContainersGetPropertiesResponse) LeaseState() LeaseStateType {
	return LeaseStateType(cgpr.rawResponse.Header.Get("x-ms-lease-state"))
}

// LeaseStatus returns the value for header x-ms-lease-status.
func (cgpr ContainersGetPropertiesResponse) LeaseStatus() LeaseStatusType {
	return LeaseStatusType(cgpr.rawResponse.Header.Get("x-ms-lease-status"))
}

// RequestID returns the value for header x-ms-request-id.
func (cgpr ContainersGetPropertiesResponse) RequestID() string {
	return cgpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (cgpr ContainersGetPropertiesResponse) Version() string {
	return cgpr.rawResponse.Header.Get("x-ms-version")
}

// ContainersReleaseLeaseResponse ...
type ContainersReleaseLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (crlr ContainersReleaseLeaseResponse) Response() *http.Response {
	return crlr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (crlr ContainersReleaseLeaseResponse) StatusCode() int {
	return crlr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (crlr ContainersReleaseLeaseResponse) Status() string {
	return crlr.rawResponse.Status
}

// Date returns the value for header Date.
func (crlr ContainersReleaseLeaseResponse) Date() time.Time {
	s := crlr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (crlr ContainersReleaseLeaseResponse) ETag() ETag {
	return ETag(crlr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (crlr ContainersReleaseLeaseResponse) LastModified() time.Time {
	s := crlr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (crlr ContainersReleaseLeaseResponse) RequestID() string {
	return crlr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (crlr ContainersReleaseLeaseResponse) Version() string {
	return crlr.rawResponse.Header.Get("x-ms-version")
}

// ContainersRenewLeaseResponse ...
type ContainersRenewLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (crlr ContainersRenewLeaseResponse) Response() *http.Response {
	return crlr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (crlr ContainersRenewLeaseResponse) StatusCode() int {
	return crlr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (crlr ContainersRenewLeaseResponse) Status() string {
	return crlr.rawResponse.Status
}

// Date returns the value for header Date.
func (crlr ContainersRenewLeaseResponse) Date() time.Time {
	s := crlr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (crlr ContainersRenewLeaseResponse) ETag() ETag {
	return ETag(crlr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (crlr ContainersRenewLeaseResponse) LastModified() time.Time {
	s := crlr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseID returns the value for header x-ms-lease-id.
func (crlr ContainersRenewLeaseResponse) LeaseID() string {
	return crlr.rawResponse.Header.Get("x-ms-lease-id")
}

// RequestID returns the value for header x-ms-request-id.
func (crlr ContainersRenewLeaseResponse) RequestID() string {
	return crlr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (crlr ContainersRenewLeaseResponse) Version() string {
	return crlr.rawResponse.Header.Get("x-ms-version")
}

// ContainersSetAccessPolicyResponse ...
type ContainersSetAccessPolicyResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (csapr ContainersSetAccessPolicyResponse) Response() *http.Response {
	return csapr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (csapr ContainersSetAccessPolicyResponse) StatusCode() int {
	return csapr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (csapr ContainersSetAccessPolicyResponse) Status() string {
	return csapr.rawResponse.Status
}

// Date returns the value for header Date.
func (csapr ContainersSetAccessPolicyResponse) Date() time.Time {
	s := csapr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (csapr ContainersSetAccessPolicyResponse) ETag() ETag {
	return ETag(csapr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (csapr ContainersSetAccessPolicyResponse) LastModified() time.Time {
	s := csapr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (csapr ContainersSetAccessPolicyResponse) RequestID() string {
	return csapr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (csapr ContainersSetAccessPolicyResponse) Version() string {
	return csapr.rawResponse.Header.Get("x-ms-version")
}

// ContainersSetMetadataResponse ...
type ContainersSetMetadataResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (csmr ContainersSetMetadataResponse) Response() *http.Response {
	return csmr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (csmr ContainersSetMetadataResponse) StatusCode() int {
	return csmr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (csmr ContainersSetMetadataResponse) Status() string {
	return csmr.rawResponse.Status
}

// Date returns the value for header Date.
func (csmr ContainersSetMetadataResponse) Date() time.Time {
	s := csmr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (csmr ContainersSetMetadataResponse) ETag() ETag {
	return ETag(csmr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (csmr ContainersSetMetadataResponse) LastModified() time.Time {
	s := csmr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (csmr ContainersSetMetadataResponse) RequestID() string {
	return csmr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (csmr ContainersSetMetadataResponse) Version() string {
	return csmr.rawResponse.Header.Get("x-ms-version")
}

// CorsRule - CORS is an HTTP feature that enables a web application running under one domain to access
// resources in another domain. Web browsers implement a security restriction known as same-origin policy that
// prevents a web page from calling APIs in a different domain; CORS provides a secure way to allow one domain
// (the origin domain) to call APIs in another domain
type CorsRule struct {
	// AllowedOrigins - The origin domains that are permitted to make a request against the storage service via CORS. The origin domain is the domain from which the request originates. Note that the origin must be an exact case-sensitive match with the origin that the user age sends to the service. You can also use the wildcard character '*' to allow all origin domains to make requests via CORS.
	AllowedOrigins string `xml:"AllowedOrigins"`
	// AllowedMethods - The methods (HTTP request verbs) that the origin domain may use for a CORS request. (comma separated)
	AllowedMethods string `xml:"AllowedMethods"`
	// AllowedHeaders - the request headers that the origin domain may specify on the CORS request.
	AllowedHeaders string `xml:"AllowedHeaders"`
	// ExposedHeaders - The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer
	ExposedHeaders string `xml:"ExposedHeaders"`
	// MaxAgeInSeconds - The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds int32 `xml:"MaxAgeInSeconds"`
}

// downloadResponse ...
type downloadResponse struct {
	rawResponse *http.Response
}

// NewMetadata returns user-defined key/value pairs.
func (dr downloadResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range dr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// Response returns the raw HTTP response object.
func (dr downloadResponse) Response() *http.Response {
	return dr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (dr downloadResponse) StatusCode() int {
	return dr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (dr downloadResponse) Status() string {
	return dr.rawResponse.Status
}

// Body returns the raw HTTP response object's Body.
func (dr downloadResponse) Body() io.ReadCloser {
	return dr.rawResponse.Body
}

// AcceptRanges returns the value for header Accept-Ranges.
func (dr downloadResponse) AcceptRanges() string {
	return dr.rawResponse.Header.Get("Accept-Ranges")
}

// BlobCommittedBlockCount returns the value for header x-ms-blob-committed-block-count.
func (dr downloadResponse) BlobCommittedBlockCount() int32 {
	s := dr.rawResponse.Header.Get("x-ms-blob-committed-block-count")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		panic(err)
	}
	return int32(i)
}

// BlobContentMD5 returns the value for header x-ms-blob-content-md5.
func (dr downloadResponse) BlobContentMD5() []byte {
	s := dr.rawResponse.Header.Get("x-ms-blob-content-md5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (dr downloadResponse) BlobSequenceNumber() int64 {
	s := dr.rawResponse.Header.Get("x-ms-blob-sequence-number")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// BlobType returns the value for header x-ms-blob-type.
func (dr downloadResponse) BlobType() BlobType {
	return BlobType(dr.rawResponse.Header.Get("x-ms-blob-type"))
}

// CacheControl returns the value for header Cache-Control.
func (dr downloadResponse) CacheControl() string {
	return dr.rawResponse.Header.Get("Cache-Control")
}

// ContentDisposition returns the value for header Content-Disposition.
func (dr downloadResponse) ContentDisposition() string {
	return dr.rawResponse.Header.Get("Content-Disposition")
}

// ContentEncoding returns the value for header Content-Encoding.
func (dr downloadResponse) ContentEncoding() string {
	return dr.rawResponse.Header.Get("Content-Encoding")
}

// ContentLanguage returns the value for header Content-Language.
func (dr downloadResponse) ContentLanguage() string {
	return dr.rawResponse.Header.Get("Content-Language")
}

// ContentLength returns the value for header Content-Length.
func (dr downloadResponse) ContentLength() int64 {
	s := dr.rawResponse.Header.Get("Content-Length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// ContentMD5 returns the value for header Content-MD5.
func (dr downloadResponse) ContentMD5() []byte {
	s := dr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// ContentRange returns the value for header Content-Range.
func (dr downloadResponse) ContentRange() string {
	return dr.rawResponse.Header.Get("Content-Range")
}

// ContentType returns the value for header Content-Type.
func (dr downloadResponse) ContentType() string {
	return dr.rawResponse.Header.Get("Content-Type")
}

// CopyCompletionTime returns the value for header x-ms-copy-completion-time.
func (dr downloadResponse) CopyCompletionTime() time.Time {
	s := dr.rawResponse.Header.Get("x-ms-copy-completion-time")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// CopyID returns the value for header x-ms-copy-id.
func (dr downloadResponse) CopyID() string {
	return dr.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyProgress returns the value for header x-ms-copy-progress.
func (dr downloadResponse) CopyProgress() string {
	return dr.rawResponse.Header.Get("x-ms-copy-progress")
}

// CopySource returns the value for header x-ms-copy-source.
func (dr downloadResponse) CopySource() string {
	return dr.rawResponse.Header.Get("x-ms-copy-source")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (dr downloadResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(dr.rawResponse.Header.Get("x-ms-copy-status"))
}

// CopyStatusDescription returns the value for header x-ms-copy-status-description.
func (dr downloadResponse) CopyStatusDescription() string {
	return dr.rawResponse.Header.Get("x-ms-copy-status-description")
}

// Date returns the value for header Date.
func (dr downloadResponse) Date() time.Time {
	s := dr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (dr downloadResponse) ETag() ETag {
	return ETag(dr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-server-encrypted.
func (dr downloadResponse) IsServerEncrypted() string {
	return dr.rawResponse.Header.Get("x-ms-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (dr downloadResponse) LastModified() time.Time {
	s := dr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseDuration returns the value for header x-ms-lease-duration.
func (dr downloadResponse) LeaseDuration() LeaseDurationType {
	return LeaseDurationType(dr.rawResponse.Header.Get("x-ms-lease-duration"))
}

// LeaseState returns the value for header x-ms-lease-state.
func (dr downloadResponse) LeaseState() LeaseStateType {
	return LeaseStateType(dr.rawResponse.Header.Get("x-ms-lease-state"))
}

// LeaseStatus returns the value for header x-ms-lease-status.
func (dr downloadResponse) LeaseStatus() LeaseStatusType {
	return LeaseStatusType(dr.rawResponse.Header.Get("x-ms-lease-status"))
}

// RequestID returns the value for header x-ms-request-id.
func (dr downloadResponse) RequestID() string {
	return dr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (dr downloadResponse) Version() string {
	return dr.rawResponse.Header.Get("x-ms-version")
}

// GeoReplication ...
type GeoReplication struct {
	// Status - The status of the secondary location. Possible values include: 'GeoReplicationStatusLive', 'GeoReplicationStatusBootstrap', 'GeoReplicationStatusUnavailable', 'GeoReplicationStatusNone'
	Status GeoReplicationStatusType `xml:"Status"`
	// LastSyncTime - A GMT date/time value, to the second. All primary writes preceding this value are guaranteed to be available for read operations at the secondary. Primary writes after this point in time may or may not be available for reads.
	LastSyncTime time.Time `xml:"LastSyncTime"`
}

// MarshalXML implements the xml.Marshaler interface for GeoReplication.
func (gr GeoReplication) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	if reflect.TypeOf((*GeoReplication)(nil)).Elem().Size() != reflect.TypeOf((*geoReplication)(nil)).Elem().Size() {
		panic("size mismatch between GeoReplication and geoReplication")
	}
	gr2 := (*geoReplication)(unsafe.Pointer(&gr))
	return e.EncodeElement(*gr2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for GeoReplication.
func (gr *GeoReplication) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if reflect.TypeOf((*GeoReplication)(nil)).Elem().Size() != reflect.TypeOf((*geoReplication)(nil)).Elem().Size() {
		panic("size mismatch between GeoReplication and geoReplication")
	}
	gr2 := (*geoReplication)(unsafe.Pointer(gr))
	return d.DecodeElement(gr2, &start)
}

// ListBlobsFlatResponse - An enumeration of blobs
type ListBlobsFlatResponse struct {
	rawResponse *http.Response
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName         xml.Name     `xml:"EnumerationResults"`
	ServiceEndpoint string       `xml:"ServiceEndpoint,attr"`
	ContainerName   string       `xml:"ContainerName,attr"`
	Prefix          string       `xml:"Prefix"`
	Marker          string       `xml:"Marker"`
	MaxResults      int32        `xml:"MaxResults"`
	Delimiter       string       `xml:"Delimiter"`
	Blobs           BlobFlatList `xml:"Blobs"`
	NextMarker      Marker       `xml:"NextMarker"`
}

// Response returns the raw HTTP response object.
func (lbfr ListBlobsFlatResponse) Response() *http.Response {
	return lbfr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (lbfr ListBlobsFlatResponse) StatusCode() int {
	return lbfr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (lbfr ListBlobsFlatResponse) Status() string {
	return lbfr.rawResponse.Status
}

// ContentType returns the value for header Content-Type.
func (lbfr ListBlobsFlatResponse) ContentType() string {
	return lbfr.rawResponse.Header.Get("Content-Type")
}

// Date returns the value for header Date.
func (lbfr ListBlobsFlatResponse) Date() time.Time {
	s := lbfr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (lbfr ListBlobsFlatResponse) RequestID() string {
	return lbfr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (lbfr ListBlobsFlatResponse) Version() string {
	return lbfr.rawResponse.Header.Get("x-ms-version")
}

// ListBlobsHierarchyResponse - An enumeration of blobs
type ListBlobsHierarchyResponse struct {
	rawResponse *http.Response
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName         xml.Name          `xml:"EnumerationResults"`
	ServiceEndpoint string            `xml:"ServiceEndpoint,attr"`
	ContainerName   string            `xml:"ContainerName,attr"`
	Prefix          string            `xml:"Prefix"`
	Marker          string            `xml:"Marker"`
	MaxResults      int32             `xml:"MaxResults"`
	Delimiter       string            `xml:"Delimiter"`
	Blobs           BlobHierarchyList `xml:"Blobs"`
	NextMarker      Marker            `xml:"NextMarker"`
}

// Response returns the raw HTTP response object.
func (lbhr ListBlobsHierarchyResponse) Response() *http.Response {
	return lbhr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (lbhr ListBlobsHierarchyResponse) StatusCode() int {
	return lbhr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (lbhr ListBlobsHierarchyResponse) Status() string {
	return lbhr.rawResponse.Status
}

// ContentType returns the value for header Content-Type.
func (lbhr ListBlobsHierarchyResponse) ContentType() string {
	return lbhr.rawResponse.Header.Get("Content-Type")
}

// Date returns the value for header Date.
func (lbhr ListBlobsHierarchyResponse) Date() time.Time {
	s := lbhr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (lbhr ListBlobsHierarchyResponse) RequestID() string {
	return lbhr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (lbhr ListBlobsHierarchyResponse) Version() string {
	return lbhr.rawResponse.Header.Get("x-ms-version")
}

// ListContainersResponse - An enumeration of containers
type ListContainersResponse struct {
	rawResponse *http.Response
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName         xml.Name    `xml:"EnumerationResults"`
	ServiceEndpoint string      `xml:"ServiceEndpoint,attr"`
	Prefix          string      `xml:"Prefix"`
	Marker          *string     `xml:"Marker"`
	MaxResults      int32       `xml:"MaxResults"`
	Containers      []Container `xml:"Containers>Container"`
	NextMarker      Marker      `xml:"NextMarker"`
}

// Response returns the raw HTTP response object.
func (lcr ListContainersResponse) Response() *http.Response {
	return lcr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (lcr ListContainersResponse) StatusCode() int {
	return lcr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (lcr ListContainersResponse) Status() string {
	return lcr.rawResponse.Status
}

// RequestID returns the value for header x-ms-request-id.
func (lcr ListContainersResponse) RequestID() string {
	return lcr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (lcr ListContainersResponse) Version() string {
	return lcr.rawResponse.Header.Get("x-ms-version")
}

// Logging - Azure Analytics Logging settings.
type Logging struct {
	// Version - The version of Storage Analytics to configure.
	Version string `xml:"Version"`
	// Delete - Indicates whether all delete requests should be logged.
	Delete bool `xml:"Delete"`
	// Read - Indicates whether all read requests should be logged.
	Read bool `xml:"Read"`
	// Write - Indicates whether all write requests should be logged.
	Write           bool            `xml:"Write"`
	RetentionPolicy RetentionPolicy `xml:"RetentionPolicy"`
}

// Metrics ...
type Metrics struct {
	// Version - The version of Storage Analytics to configure.
	Version *string `xml:"Version"`
	// Enabled - Indicates whether metrics are enabled for the Blob service.
	Enabled bool `xml:"Enabled"`
	// IncludeAPIs - Indicates whether metrics should generate summary statistics for called API operations.
	IncludeAPIs     *bool            `xml:"IncludeAPIs"`
	RetentionPolicy *RetentionPolicy `xml:"RetentionPolicy"`
}

// PageBlobsClearPagesResponse ...
type PageBlobsClearPagesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (pbcpr PageBlobsClearPagesResponse) Response() *http.Response {
	return pbcpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pbcpr PageBlobsClearPagesResponse) StatusCode() int {
	return pbcpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pbcpr PageBlobsClearPagesResponse) Status() string {
	return pbcpr.rawResponse.Status
}

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (pbcpr PageBlobsClearPagesResponse) BlobSequenceNumber() int64 {
	s := pbcpr.rawResponse.Header.Get("x-ms-blob-sequence-number")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// ContentMD5 returns the value for header Content-MD5.
func (pbcpr PageBlobsClearPagesResponse) ContentMD5() []byte {
	s := pbcpr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// Date returns the value for header Date.
func (pbcpr PageBlobsClearPagesResponse) Date() time.Time {
	s := pbcpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (pbcpr PageBlobsClearPagesResponse) ETag() ETag {
	return ETag(pbcpr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (pbcpr PageBlobsClearPagesResponse) LastModified() time.Time {
	s := pbcpr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (pbcpr PageBlobsClearPagesResponse) RequestID() string {
	return pbcpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pbcpr PageBlobsClearPagesResponse) Version() string {
	return pbcpr.rawResponse.Header.Get("x-ms-version")
}

// PageBlobsCopyIncrementalResponse ...
type PageBlobsCopyIncrementalResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (pbcir PageBlobsCopyIncrementalResponse) Response() *http.Response {
	return pbcir.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pbcir PageBlobsCopyIncrementalResponse) StatusCode() int {
	return pbcir.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pbcir PageBlobsCopyIncrementalResponse) Status() string {
	return pbcir.rawResponse.Status
}

// CopyID returns the value for header x-ms-copy-id.
func (pbcir PageBlobsCopyIncrementalResponse) CopyID() string {
	return pbcir.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (pbcir PageBlobsCopyIncrementalResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(pbcir.rawResponse.Header.Get("x-ms-copy-status"))
}

// Date returns the value for header Date.
func (pbcir PageBlobsCopyIncrementalResponse) Date() time.Time {
	s := pbcir.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (pbcir PageBlobsCopyIncrementalResponse) ETag() ETag {
	return ETag(pbcir.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (pbcir PageBlobsCopyIncrementalResponse) LastModified() time.Time {
	s := pbcir.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (pbcir PageBlobsCopyIncrementalResponse) RequestID() string {
	return pbcir.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pbcir PageBlobsCopyIncrementalResponse) Version() string {
	return pbcir.rawResponse.Header.Get("x-ms-version")
}

// PageBlobsCreateResponse ...
type PageBlobsCreateResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (pbcr PageBlobsCreateResponse) Response() *http.Response {
	return pbcr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pbcr PageBlobsCreateResponse) StatusCode() int {
	return pbcr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pbcr PageBlobsCreateResponse) Status() string {
	return pbcr.rawResponse.Status
}

// ContentMD5 returns the value for header Content-MD5.
func (pbcr PageBlobsCreateResponse) ContentMD5() []byte {
	s := pbcr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// Date returns the value for header Date.
func (pbcr PageBlobsCreateResponse) Date() time.Time {
	s := pbcr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (pbcr PageBlobsCreateResponse) ETag() ETag {
	return ETag(pbcr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (pbcr PageBlobsCreateResponse) IsServerEncrypted() string {
	return pbcr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (pbcr PageBlobsCreateResponse) LastModified() time.Time {
	s := pbcr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (pbcr PageBlobsCreateResponse) RequestID() string {
	return pbcr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pbcr PageBlobsCreateResponse) Version() string {
	return pbcr.rawResponse.Header.Get("x-ms-version")
}

// PageBlobsResizeResponse ...
type PageBlobsResizeResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (pbrr PageBlobsResizeResponse) Response() *http.Response {
	return pbrr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pbrr PageBlobsResizeResponse) StatusCode() int {
	return pbrr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pbrr PageBlobsResizeResponse) Status() string {
	return pbrr.rawResponse.Status
}

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (pbrr PageBlobsResizeResponse) BlobSequenceNumber() int64 {
	s := pbrr.rawResponse.Header.Get("x-ms-blob-sequence-number")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// Date returns the value for header Date.
func (pbrr PageBlobsResizeResponse) Date() time.Time {
	s := pbrr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (pbrr PageBlobsResizeResponse) ETag() ETag {
	return ETag(pbrr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (pbrr PageBlobsResizeResponse) LastModified() time.Time {
	s := pbrr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (pbrr PageBlobsResizeResponse) RequestID() string {
	return pbrr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pbrr PageBlobsResizeResponse) Version() string {
	return pbrr.rawResponse.Header.Get("x-ms-version")
}

// PageBlobsUpdateSequenceNumberResponse ...
type PageBlobsUpdateSequenceNumberResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (pbusnr PageBlobsUpdateSequenceNumberResponse) Response() *http.Response {
	return pbusnr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pbusnr PageBlobsUpdateSequenceNumberResponse) StatusCode() int {
	return pbusnr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pbusnr PageBlobsUpdateSequenceNumberResponse) Status() string {
	return pbusnr.rawResponse.Status
}

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (pbusnr PageBlobsUpdateSequenceNumberResponse) BlobSequenceNumber() int64 {
	s := pbusnr.rawResponse.Header.Get("x-ms-blob-sequence-number")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// Date returns the value for header Date.
func (pbusnr PageBlobsUpdateSequenceNumberResponse) Date() time.Time {
	s := pbusnr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (pbusnr PageBlobsUpdateSequenceNumberResponse) ETag() ETag {
	return ETag(pbusnr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (pbusnr PageBlobsUpdateSequenceNumberResponse) LastModified() time.Time {
	s := pbusnr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (pbusnr PageBlobsUpdateSequenceNumberResponse) RequestID() string {
	return pbusnr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pbusnr PageBlobsUpdateSequenceNumberResponse) Version() string {
	return pbusnr.rawResponse.Header.Get("x-ms-version")
}

// PageBlobsUploadPagesResponse ...
type PageBlobsUploadPagesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (pbupr PageBlobsUploadPagesResponse) Response() *http.Response {
	return pbupr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pbupr PageBlobsUploadPagesResponse) StatusCode() int {
	return pbupr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pbupr PageBlobsUploadPagesResponse) Status() string {
	return pbupr.rawResponse.Status
}

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (pbupr PageBlobsUploadPagesResponse) BlobSequenceNumber() int64 {
	s := pbupr.rawResponse.Header.Get("x-ms-blob-sequence-number")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// ContentMD5 returns the value for header Content-MD5.
func (pbupr PageBlobsUploadPagesResponse) ContentMD5() []byte {
	s := pbupr.rawResponse.Header.Get("Content-MD5")
	if s == "" {
		return nil
	}
	b, err := base64.StdEncoding.DecodeString(s)
	if err != nil {
		panic(err)
	}
	return b
}

// Date returns the value for header Date.
func (pbupr PageBlobsUploadPagesResponse) Date() time.Time {
	s := pbupr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (pbupr PageBlobsUploadPagesResponse) ETag() ETag {
	return ETag(pbupr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (pbupr PageBlobsUploadPagesResponse) IsServerEncrypted() string {
	return pbupr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (pbupr PageBlobsUploadPagesResponse) LastModified() time.Time {
	s := pbupr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (pbupr PageBlobsUploadPagesResponse) RequestID() string {
	return pbupr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pbupr PageBlobsUploadPagesResponse) Version() string {
	return pbupr.rawResponse.Header.Get("x-ms-version")
}

// PageList - the list of pages
type PageList struct {
	rawResponse *http.Response
	PageRange   []PageRange  `xml:"PageRange"`
	ClearRange  []ClearRange `xml:"ClearRange"`
}

// Response returns the raw HTTP response object.
func (pl PageList) Response() *http.Response {
	return pl.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pl PageList) StatusCode() int {
	return pl.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pl PageList) Status() string {
	return pl.rawResponse.Status
}

// BlobContentLength returns the value for header x-ms-blob-content-length.
func (pl PageList) BlobContentLength() int64 {
	s := pl.rawResponse.Header.Get("x-ms-blob-content-length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// Date returns the value for header Date.
func (pl PageList) Date() time.Time {
	s := pl.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (pl PageList) ETag() ETag {
	return ETag(pl.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (pl PageList) LastModified() time.Time {
	s := pl.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (pl PageList) RequestID() string {
	return pl.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pl PageList) Version() string {
	return pl.rawResponse.Header.Get("x-ms-version")
}

// PageRange ...
type PageRange struct {
	Start int64 `xml:"Start"`
	End   int64 `xml:"End"`
}

// RetentionPolicy - the retention policy
type RetentionPolicy struct {
	// Enabled - Indicates whether a retention policy is enabled for the storage service
	Enabled bool `xml:"Enabled"`
	// Days - Indicates the number of days that metrics or logging or soft-deleted data should be retained. All data older than this value will be deleted
	Days *int32 `xml:"Days"`
}

// ServiceSetPropertiesResponse ...
type ServiceSetPropertiesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (sspr ServiceSetPropertiesResponse) Response() *http.Response {
	return sspr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (sspr ServiceSetPropertiesResponse) StatusCode() int {
	return sspr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (sspr ServiceSetPropertiesResponse) Status() string {
	return sspr.rawResponse.Status
}

// RequestID returns the value for header x-ms-request-id.
func (sspr ServiceSetPropertiesResponse) RequestID() string {
	return sspr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (sspr ServiceSetPropertiesResponse) Version() string {
	return sspr.rawResponse.Header.Get("x-ms-version")
}

// SignedIdentifier - signed identifier
type SignedIdentifier struct {
	// ID - a unique id
	ID string `xml:"Id"`
	// AccessPolicy - The access policy
	AccessPolicy AccessPolicy `xml:"AccessPolicy"`
}

// SignedIdentifiers ...
type SignedIdentifiers struct {
	rawResponse *http.Response
	Value       []SignedIdentifier `xml:"SignedIdentifier"`
}

// Response returns the raw HTTP response object.
func (si SignedIdentifiers) Response() *http.Response {
	return si.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (si SignedIdentifiers) StatusCode() int {
	return si.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (si SignedIdentifiers) Status() string {
	return si.rawResponse.Status
}

// BlobPublicAccess returns the value for header x-ms-blob-public-access.
func (si SignedIdentifiers) BlobPublicAccess() PublicAccessType {
	return PublicAccessType(si.rawResponse.Header.Get("x-ms-blob-public-access"))
}

// Date returns the value for header Date.
func (si SignedIdentifiers) Date() time.Time {
	s := si.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (si SignedIdentifiers) ETag() ETag {
	return ETag(si.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (si SignedIdentifiers) LastModified() time.Time {
	s := si.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (si SignedIdentifiers) RequestID() string {
	return si.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (si SignedIdentifiers) Version() string {
	return si.rawResponse.Header.Get("x-ms-version")
}

// StorageServiceProperties - Storage Service Properties.
type StorageServiceProperties struct {
	rawResponse *http.Response
	// Logging - Azure Analytics Logging settings
	Logging *Logging `xml:"Logging"`
	// HourMetrics - A summary of request statistics grouped by API in hourly aggregates for blobs
	HourMetrics *Metrics `xml:"HourMetrics"`
	// MinuteMetrics - a summary of request statistics grouped by API in minute aggregates for blobs
	MinuteMetrics *Metrics `xml:"MinuteMetrics"`
	// Cors - The set of CORS rules.
	Cors []CorsRule `xml:"Cors>CorsRule"`
	// DefaultServiceVersion - The default version to use for requests to the Blob service if an incoming request's version is not specified. Possible values include version 2008-10-27 and all more recent versions
	DefaultServiceVersion *string `xml:"DefaultServiceVersion"`
	// DeleteRetentionPolicy - The Delete Retention Policy for the service
	DeleteRetentionPolicy *RetentionPolicy `xml:"DeleteRetentionPolicy"`
}

// Response returns the raw HTTP response object.
func (ssp StorageServiceProperties) Response() *http.Response {
	return ssp.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ssp StorageServiceProperties) StatusCode() int {
	return ssp.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ssp StorageServiceProperties) Status() string {
	return ssp.rawResponse.Status
}

// RequestID returns the value for header x-ms-request-id.
func (ssp StorageServiceProperties) RequestID() string {
	return ssp.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ssp StorageServiceProperties) Version() string {
	return ssp.rawResponse.Header.Get("x-ms-version")
}

// StorageServiceStats - Stats for the storage service.
type StorageServiceStats struct {
	rawResponse *http.Response
	// GeoReplication - Geo-Replication information for the Secondary Storage Service
	GeoReplication *GeoReplication `xml:"GeoReplication"`
}

// Response returns the raw HTTP response object.
func (sss StorageServiceStats) Response() *http.Response {
	return sss.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (sss StorageServiceStats) StatusCode() int {
	return sss.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (sss StorageServiceStats) Status() string {
	return sss.rawResponse.Status
}

// Date returns the value for header Date.
func (sss StorageServiceStats) Date() time.Time {
	s := sss.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (sss StorageServiceStats) RequestID() string {
	return sss.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (sss StorageServiceStats) Version() string {
	return sss.rawResponse.Header.Get("x-ms-version")
}

const (
	rfc3339Format = "2006-01-02T15:04:05.0000000Z07:00"
)

// used to convert times from UTC to GMT before sending across the wire
var gmt = time.FixedZone("GMT", 0)

// internal type used for marshalling time in RFC1123 format
type timeRFC1123 struct {
	time.Time
}

// MarshalText implements the encoding.TextMarshaler interface for timeRFC1123.
func (t timeRFC1123) MarshalText() ([]byte, error) {
	return []byte(t.Format(time.RFC1123)), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface for timeRFC1123.
func (t *timeRFC1123) UnmarshalText(data []byte) (err error) {
	t.Time, err = time.Parse(time.RFC1123, string(data))
	return
}

// internal type used for marshalling time in RFC3339 format
type timeRFC3339 struct {
	time.Time
}

// MarshalText implements the encoding.TextMarshaler interface for timeRFC3339.
func (t timeRFC3339) MarshalText() ([]byte, error) {
	return []byte(t.Format(rfc3339Format)), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface for timeRFC3339.
func (t *timeRFC3339) UnmarshalText(data []byte) (err error) {
	t.Time, err = time.Parse(rfc3339Format, string(data))
	return
}

// internal type used for marshalling
type accessPolicy struct {
	Start      timeRFC3339 `xml:"Start"`
	Expiry     timeRFC3339 `xml:"Expiry"`
	Permission string      `xml:"Permission"`
}

// internal type used for marshalling
type blobProperties struct {
	LastModified           timeRFC1123       `xml:"Last-Modified"`
	Etag                   ETag              `xml:"Etag"`
	ContentLength          *int64            `xml:"Content-Length"`
	ContentType            *string           `xml:"Content-Type"`
	ContentEncoding        *string           `xml:"Content-Encoding"`
	ContentLanguage        *string           `xml:"Content-Language"`
	ContentMD5             []byte            `xml:"Content-MD5"`
	ContentDisposition     *string           `xml:"Content-Disposition"`
	CacheControl           *string           `xml:"Cache-Control"`
	BlobSequenceNumber     *int64            `xml:"x-ms-blob-sequence-number"`
	BlobType               BlobType          `xml:"BlobType"`
	LeaseStatus            LeaseStatusType   `xml:"LeaseStatus"`
	LeaseState             LeaseStateType    `xml:"LeaseState"`
	LeaseDuration          LeaseDurationType `xml:"LeaseDuration"`
	CopyID                 *string           `xml:"CopyId"`
	CopyStatus             CopyStatusType    `xml:"CopyStatus"`
	CopySource             *string           `xml:"CopySource"`
	CopyProgress           *string           `xml:"CopyProgress"`
	CopyCompletionTime     *timeRFC1123      `xml:"CopyCompletionTime"`
	CopyStatusDescription  *string           `xml:"CopyStatusDescription"`
	ServerEncrypted        *bool             `xml:"ServerEncrypted"`
	IncrementalCopy        *bool             `xml:"IncrementalCopy"`
	DestinationSnapshot    *string           `xml:"DestinationSnapshot"`
	DeletedTime            *timeRFC1123      `xml:"DeletedTime"`
	RemainingRetentionDays *int32            `xml:"RemainingRetentionDays"`
	AccessTier             AccessTierType    `xml:"AccessTier"`
	AccessTierInferred     *bool             `xml:"AccessTierInferred"`
	ArchiveStatus          ArchiveStatusType `xml:"ArchiveStatus"`
}

// internal type used for marshalling
type containerProperties struct {
	LastModified  timeRFC1123       `xml:"Last-Modified"`
	Etag          ETag              `xml:"Etag"`
	LeaseStatus   LeaseStatusType   `xml:"LeaseStatus"`
	LeaseState    LeaseStateType    `xml:"LeaseState"`
	LeaseDuration LeaseDurationType `xml:"LeaseDuration"`
	PublicAccess  PublicAccessType  `xml:"PublicAccess"`
}

// internal type used for marshalling
type geoReplication struct {
	Status       GeoReplicationStatusType `xml:"Status"`
	LastSyncTime timeRFC1123              `xml:"LastSyncTime"`
}
