package azblob

// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/xml"
	"io"
	"net/http"
	"strconv"
	"strings"
	"time"
)

// ETag is an entity tag.
type ETag string

const (
	// ETagNone represents an empty entity tag.
	ETagNone ETag = ""

	// ETagAny matches any entity tag.
	ETagAny ETag = "*"
)

// Metadata contains metadata key/value pairs.
type Metadata map[string]string

const mdPrefix = "x-ms-meta-"

const mdPrefixLen = len(mdPrefix)

// UnmarshalXML implements the xml.Unmarshaler interface for Metadata.
func (md *Metadata) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	tokName := ""
	for t, err := d.Token(); err == nil; t, err = d.Token() {
		switch tt := t.(type) {
		case xml.StartElement:
			tokName = strings.ToLower(tt.Name.Local)
			break
		case xml.CharData:
			if *md == nil {
				*md = Metadata{}
			}
			(*md)[tokName] = string(tt)
			break
		}
	}
	return nil
}

// Marker represents an opaque value used in paged responses.
type Marker struct {
	val *string
}

// NotDone returns true if the list enumeration should be started or is not yet complete. Specifically, NotDone returns true
// for a just-initialized (zero value) Marker indicating that you should make an initial request to get a result portion from
// the service. NotDone also returns true whenever the service returns an interim result portion. NotDone returns false only
// after the service has returned the final result portion.
func (m Marker) NotDone() bool {
	return m.val == nil || *m.val != ""
}

// UnmarshalXML implements the xml.Unmarshaler interface for Marker.
func (m *Marker) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	var out string
	err := d.DecodeElement(&out, &start)
	m.val = &out
	return err
}

// BlobType enumerates the values for blob type.
type BlobType string

const (
	// BlobAppendBlob ...
	BlobAppendBlob BlobType = "AppendBlob"
	// BlobBlockBlob ...
	BlobBlockBlob BlobType = "BlockBlob"
	// BlobNone represents an empty BlobType.
	BlobNone BlobType = ""
	// BlobPageBlob ...
	BlobPageBlob BlobType = "PageBlob"
)

// BlockListType enumerates the values for block list type.
type BlockListType string

const (
	// BlockListAll ...
	BlockListAll BlockListType = "all"
	// BlockListCommitted ...
	BlockListCommitted BlockListType = "committed"
	// BlockListNone represents an empty BlockListType.
	BlockListNone BlockListType = ""
	// BlockListUncommitted ...
	BlockListUncommitted BlockListType = "uncommitted"
)

// CopyStatusType enumerates the values for copy status type.
type CopyStatusType string

const (
	// CopyStatusAborted ...
	CopyStatusAborted CopyStatusType = "aborted"
	// CopyStatusFailed ...
	CopyStatusFailed CopyStatusType = "failed"
	// CopyStatusNone represents an empty CopyStatusType.
	CopyStatusNone CopyStatusType = ""
	// CopyStatusPending ...
	CopyStatusPending CopyStatusType = "pending"
	// CopyStatusSuccess ...
	CopyStatusSuccess CopyStatusType = "success"
)

// DeleteSnapshotsOptionType enumerates the values for delete snapshots option type.
type DeleteSnapshotsOptionType string

const (
	// DeleteSnapshotsOptionInclude ...
	DeleteSnapshotsOptionInclude DeleteSnapshotsOptionType = "include"
	// DeleteSnapshotsOptionNone represents an empty DeleteSnapshotsOptionType.
	DeleteSnapshotsOptionNone DeleteSnapshotsOptionType = ""
	// DeleteSnapshotsOptionOnly ...
	DeleteSnapshotsOptionOnly DeleteSnapshotsOptionType = "only"
)

// GeoReplicationStatusType enumerates the values for geo replication status type.
type GeoReplicationStatusType string

const (
	// GeoReplicationStatusBootstrap ...
	GeoReplicationStatusBootstrap GeoReplicationStatusType = "bootstrap"
	// GeoReplicationStatusLive ...
	GeoReplicationStatusLive GeoReplicationStatusType = "live"
	// GeoReplicationStatusNone represents an empty GeoReplicationStatusType.
	GeoReplicationStatusNone GeoReplicationStatusType = ""
	// GeoReplicationStatusUnavailable ...
	GeoReplicationStatusUnavailable GeoReplicationStatusType = "unavailable"
)

// LeaseActionType enumerates the values for lease action type.
type LeaseActionType string

const (
	// LeaseActionAcquire ...
	LeaseActionAcquire LeaseActionType = "acquire"
	// LeaseActionBreak ...
	LeaseActionBreak LeaseActionType = "break"
	// LeaseActionChange ...
	LeaseActionChange LeaseActionType = "change"
	// LeaseActionNone represents an empty LeaseActionType.
	LeaseActionNone LeaseActionType = ""
	// LeaseActionRelease ...
	LeaseActionRelease LeaseActionType = "release"
	// LeaseActionRenew ...
	LeaseActionRenew LeaseActionType = "renew"
)

// LeaseDurationType enumerates the values for lease duration type.
type LeaseDurationType string

const (
	// LeaseDurationFixed ...
	LeaseDurationFixed LeaseDurationType = "fixed"
	// LeaseDurationInfinite ...
	LeaseDurationInfinite LeaseDurationType = "infinite"
	// LeaseDurationNone represents an empty LeaseDurationType.
	LeaseDurationNone LeaseDurationType = ""
)

// LeaseStateType enumerates the values for lease state type.
type LeaseStateType string

const (
	// LeaseStateAvailable ...
	LeaseStateAvailable LeaseStateType = "available"
	// LeaseStateBreaking ...
	LeaseStateBreaking LeaseStateType = "breaking"
	// LeaseStateBroken ...
	LeaseStateBroken LeaseStateType = "broken"
	// LeaseStateExpired ...
	LeaseStateExpired LeaseStateType = "expired"
	// LeaseStateLeased ...
	LeaseStateLeased LeaseStateType = "leased"
	// LeaseStateNone represents an empty LeaseStateType.
	LeaseStateNone LeaseStateType = ""
)

// LeaseStatusType enumerates the values for lease status type.
type LeaseStatusType string

const (
	// LeaseStatusLocked ...
	LeaseStatusLocked LeaseStatusType = "locked"
	// LeaseStatusNone represents an empty LeaseStatusType.
	LeaseStatusNone LeaseStatusType = ""
	// LeaseStatusUnlocked ...
	LeaseStatusUnlocked LeaseStatusType = "unlocked"
)

// ListBlobsIncludeType enumerates the values for list blobs include type.
type ListBlobsIncludeType string

const (
	// ListBlobsIncludeCopy ...
	ListBlobsIncludeCopy ListBlobsIncludeType = "copy"
	// ListBlobsIncludeMetadata ...
	ListBlobsIncludeMetadata ListBlobsIncludeType = "metadata"
	// ListBlobsIncludeNone represents an empty ListBlobsIncludeType.
	ListBlobsIncludeNone ListBlobsIncludeType = ""
	// ListBlobsIncludeSnapshots ...
	ListBlobsIncludeSnapshots ListBlobsIncludeType = "snapshots"
	// ListBlobsIncludeUncommittedblobs ...
	ListBlobsIncludeUncommittedblobs ListBlobsIncludeType = "uncommittedblobs"
)

// ListContainersIncludeType enumerates the values for list containers include type.
type ListContainersIncludeType string

const (
	// ListContainersIncludeMetadata ...
	ListContainersIncludeMetadata ListContainersIncludeType = "metadata"
	// ListContainersIncludeNone represents an empty ListContainersIncludeType.
	ListContainersIncludeNone ListContainersIncludeType = ""
)

// PageWriteType enumerates the values for page write type.
type PageWriteType string

const (
	// PageWriteClear ...
	PageWriteClear PageWriteType = "clear"
	// PageWriteNone represents an empty PageWriteType.
	PageWriteNone PageWriteType = ""
	// PageWriteUpdate ...
	PageWriteUpdate PageWriteType = "update"
)

// PublicAccessType enumerates the values for public access type.
type PublicAccessType string

const (
	// PublicAccessBlob ...
	PublicAccessBlob PublicAccessType = "blob"
	// PublicAccessContainer ...
	PublicAccessContainer PublicAccessType = "container"
	// PublicAccessNone represents an empty PublicAccessType.
	PublicAccessNone PublicAccessType = ""
)

// SequenceNumberActionType enumerates the values for sequence number action type.
type SequenceNumberActionType string

const (
	// SequenceNumberActionIncrement ...
	SequenceNumberActionIncrement SequenceNumberActionType = "increment"
	// SequenceNumberActionMax ...
	SequenceNumberActionMax SequenceNumberActionType = "max"
	// SequenceNumberActionNone represents an empty SequenceNumberActionType.
	SequenceNumberActionNone SequenceNumberActionType = ""
	// SequenceNumberActionUpdate ...
	SequenceNumberActionUpdate SequenceNumberActionType = "update"
)

// AccessPolicy - An Access policy
type AccessPolicy struct {
	// Start - the date-time the policy is active
	Start time.Time `xml:"Start"`
	// Expiry - the date-time the policy expires
	Expiry time.Time `xml:"Expiry"`
	// Permission - the permissions for the acl policy
	Permission string `xml:"Permission"`
}

// AppendBlobsAppendBlockResponse ...
type AppendBlobsAppendBlockResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (ababr AppendBlobsAppendBlockResponse) Response() *http.Response {
	return ababr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ababr AppendBlobsAppendBlockResponse) StatusCode() int {
	return ababr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ababr AppendBlobsAppendBlockResponse) Status() string {
	return ababr.rawResponse.Status
}

// BlobAppendOffset returns the value for header x-ms-blob-append-offset.
func (ababr AppendBlobsAppendBlockResponse) BlobAppendOffset() string {
	return ababr.rawResponse.Header.Get("x-ms-blob-append-offset")
}

// BlobCommittedBlockCount returns the value for header x-ms-blob-committed-block-count.
func (ababr AppendBlobsAppendBlockResponse) BlobCommittedBlockCount() string {
	return ababr.rawResponse.Header.Get("x-ms-blob-committed-block-count")
}

/*// ContentMD5 returns the value for header Content-MD5.
func (ababr AppendBlobsAppendBlockResponse) ContentMD5() string {
	return ababr.rawResponse.Header.Get("Content-MD5")
}*/

// Date returns the value for header Date.
func (ababr AppendBlobsAppendBlockResponse) Date() time.Time {
	s := ababr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (ababr AppendBlobsAppendBlockResponse) ETag() ETag {
	return ETag(ababr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (ababr AppendBlobsAppendBlockResponse) LastModified() time.Time {
	s := ababr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (ababr AppendBlobsAppendBlockResponse) RequestID() string {
	return ababr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ababr AppendBlobsAppendBlockResponse) Version() string {
	return ababr.rawResponse.Header.Get("x-ms-version")
}

// Blob - An Azure Storage blob
type Blob struct {
	Name       string         `xml:"Name"`
	Snapshot   time.Time      `xml:"Snapshot"`
	Properties BlobProperties `xml:"Properties"`
	Metadata   Metadata       `xml:"Metadata"`
}

// BlobPrefix ...
type BlobPrefix struct {
	Name string `xml:"Name"`
}

// BlobProperties - Properties of a blob
type BlobProperties struct {
	LastModified time.Time `xml:"Last-Modified"`
	Etag         ETag      `xml:"Etag"`
	// ContentLength - Size in bytes
	ContentLength      *int64  `xml:"Content-Length"`
	ContentType        *string `xml:"Content-Type"`
	ContentEncoding    *string `xml:"Content-Encoding"`
	ContentLanguage    *string `xml:"Content-Language"`
	ContentMD5         *string `xml:"Content-MD5"`
	ContentDisposition *string `xml:"Content-Disposition"`
	CacheControl       *string `xml:"Cache-Control"`
	BlobSequenceNumber *int32  `xml:"x-ms-blob-sequence-number"`
	// BlobType - Possible values include: 'BlockBlob', 'PageBlob', 'AppendBlob', 'None'
	BlobType BlobType `xml:"BlobType"`
	// LeaseStatus - Possible values include: 'Locked', 'Unlocked', 'None'
	LeaseStatus LeaseStatusType `xml:"LeaseStatus"`
	// LeaseState - Possible values include: 'Available', 'Leased', 'Expired', 'Breaking', 'Broken', 'None'
	LeaseState LeaseStateType `xml:"LeaseState"`
	// LeaseDuration - Possible values include: 'Infinite', 'Fixed', 'None'
	LeaseDuration LeaseDurationType `xml:"LeaseDuration"`
	CopyID        *string           `xml:"CopyId"`
	// CopyStatus - Possible values include: 'Pending', 'Success', 'Aborted', 'Failed', 'None'
	CopyStatus            CopyStatusType `xml:"CopyStatus"`
	CopySource            *string        `xml:"CopySource"`
	CopyProgress          *string        `xml:"CopyProgress"`
	CopyCompletionTime    *time.Time     `xml:"CopyCompletionTime"`
	CopyStatusDescription *string        `xml:"CopyStatusDescription"`
	ServerEncrypted       *bool          `xml:"ServerEncrypted"`
	IncrementalCopy       *bool          `xml:"IncrementalCopy"`
}

// Blobs ...
type Blobs struct {
	BlobPrefix []BlobPrefix `xml:"BlobPrefix"`
	Blob       []Blob       `xml:"Blob"`
}

// BlobsAbortCopyResponse ...
type BlobsAbortCopyResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bacr BlobsAbortCopyResponse) Response() *http.Response {
	return bacr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bacr BlobsAbortCopyResponse) StatusCode() int {
	return bacr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bacr BlobsAbortCopyResponse) Status() string {
	return bacr.rawResponse.Status
}

// Date returns the value for header Date.
func (bacr BlobsAbortCopyResponse) Date() time.Time {
	s := bacr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bacr BlobsAbortCopyResponse) RequestID() string {
	return bacr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bacr BlobsAbortCopyResponse) Version() string {
	return bacr.rawResponse.Header.Get("x-ms-version")
}

// BlobsCopyResponse ...
type BlobsCopyResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bcr BlobsCopyResponse) Response() *http.Response {
	return bcr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bcr BlobsCopyResponse) StatusCode() int {
	return bcr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bcr BlobsCopyResponse) Status() string {
	return bcr.rawResponse.Status
}

// CopyID returns the value for header x-ms-copy-id.
func (bcr BlobsCopyResponse) CopyID() string {
	return bcr.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (bcr BlobsCopyResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(bcr.rawResponse.Header.Get("x-ms-copy-status"))
}

// Date returns the value for header Date.
func (bcr BlobsCopyResponse) Date() time.Time {
	s := bcr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bcr BlobsCopyResponse) ETag() ETag {
	return ETag(bcr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (bcr BlobsCopyResponse) LastModified() time.Time {
	s := bcr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bcr BlobsCopyResponse) RequestID() string {
	return bcr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bcr BlobsCopyResponse) Version() string {
	return bcr.rawResponse.Header.Get("x-ms-version")
}

// BlobsDeleteResponse ...
type BlobsDeleteResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bdr BlobsDeleteResponse) Response() *http.Response {
	return bdr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bdr BlobsDeleteResponse) StatusCode() int {
	return bdr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bdr BlobsDeleteResponse) Status() string {
	return bdr.rawResponse.Status
}

// Date returns the value for header Date.
func (bdr BlobsDeleteResponse) Date() time.Time {
	s := bdr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bdr BlobsDeleteResponse) RequestID() string {
	return bdr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bdr BlobsDeleteResponse) Version() string {
	return bdr.rawResponse.Header.Get("x-ms-version")
}

// BlobsGetMetadataResponse ...
type BlobsGetMetadataResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bgmr BlobsGetMetadataResponse) Response() *http.Response {
	return bgmr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bgmr BlobsGetMetadataResponse) StatusCode() int {
	return bgmr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bgmr BlobsGetMetadataResponse) Status() string {
	return bgmr.rawResponse.Status
}

// Date returns the value for header Date.
func (bgmr BlobsGetMetadataResponse) Date() time.Time {
	s := bgmr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bgmr BlobsGetMetadataResponse) ETag() ETag {
	return ETag(bgmr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (bgmr BlobsGetMetadataResponse) LastModified() time.Time {
	s := bgmr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bgmr BlobsGetMetadataResponse) RequestID() string {
	return bgmr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bgmr BlobsGetMetadataResponse) Version() string {
	return bgmr.rawResponse.Header.Get("x-ms-version")
}

// NewMetadata returns user-defined key/value pairs.
func (bgmr BlobsGetMetadataResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range bgmr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// BlobsGetPropertiesResponse ...
type BlobsGetPropertiesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bgpr BlobsGetPropertiesResponse) Response() *http.Response {
	return bgpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bgpr BlobsGetPropertiesResponse) StatusCode() int {
	return bgpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bgpr BlobsGetPropertiesResponse) Status() string {
	return bgpr.rawResponse.Status
}

// AcceptRanges returns the value for header Accept-Ranges.
func (bgpr BlobsGetPropertiesResponse) AcceptRanges() string {
	return bgpr.rawResponse.Header.Get("Accept-Ranges")
}

// BlobCommittedBlockCount returns the value for header x-ms-blob-committed-block-count.
func (bgpr BlobsGetPropertiesResponse) BlobCommittedBlockCount() string {
	return bgpr.rawResponse.Header.Get("x-ms-blob-committed-block-count")
}

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (bgpr BlobsGetPropertiesResponse) BlobSequenceNumber() string {
	return bgpr.rawResponse.Header.Get("x-ms-blob-sequence-number")
}

// BlobType returns the value for header x-ms-blob-type.
func (bgpr BlobsGetPropertiesResponse) BlobType() BlobType {
	return BlobType(bgpr.rawResponse.Header.Get("x-ms-blob-type"))
}

// CacheControl returns the value for header Cache-Control.
func (bgpr BlobsGetPropertiesResponse) CacheControl() string {
	return bgpr.rawResponse.Header.Get("Cache-Control")
}

// ContentDisposition returns the value for header Content-Disposition.
func (bgpr BlobsGetPropertiesResponse) ContentDisposition() string {
	return bgpr.rawResponse.Header.Get("Content-Disposition")
}

// ContentEncoding returns the value for header Content-Encoding.
func (bgpr BlobsGetPropertiesResponse) ContentEncoding() string {
	return bgpr.rawResponse.Header.Get("Content-Encoding")
}

// ContentLanguage returns the value for header Content-Language.
func (bgpr BlobsGetPropertiesResponse) ContentLanguage() string {
	return bgpr.rawResponse.Header.Get("Content-Language")
}

// ContentLength returns the value for header Content-Length.
func (bgpr BlobsGetPropertiesResponse) ContentLength() int64 {
	s := bgpr.rawResponse.Header.Get("Content-Length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

/*// ContentMD5 returns the value for header Content-MD5.
func (bgpr BlobsGetPropertiesResponse) ContentMD5() string {
	return bgpr.rawResponse.Header.Get("Content-MD5")
}*/

// ContentType returns the value for header Content-Type.
func (bgpr BlobsGetPropertiesResponse) ContentType() string {
	return bgpr.rawResponse.Header.Get("Content-Type")
}

// CopyCompletionTime returns the value for header x-ms-copy-completion-time.
func (bgpr BlobsGetPropertiesResponse) CopyCompletionTime() time.Time {
	s := bgpr.rawResponse.Header.Get("x-ms-copy-completion-time")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// CopyID returns the value for header x-ms-copy-id.
func (bgpr BlobsGetPropertiesResponse) CopyID() string {
	return bgpr.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyProgress returns the value for header x-ms-copy-progress.
func (bgpr BlobsGetPropertiesResponse) CopyProgress() string {
	return bgpr.rawResponse.Header.Get("x-ms-copy-progress")
}

// CopySource returns the value for header x-ms-copy-source.
func (bgpr BlobsGetPropertiesResponse) CopySource() string {
	return bgpr.rawResponse.Header.Get("x-ms-copy-source")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (bgpr BlobsGetPropertiesResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(bgpr.rawResponse.Header.Get("x-ms-copy-status"))
}

// CopyStatusDescription returns the value for header x-ms-copy-status-description.
func (bgpr BlobsGetPropertiesResponse) CopyStatusDescription() string {
	return bgpr.rawResponse.Header.Get("x-ms-copy-status-description")
}

// Date returns the value for header Date.
func (bgpr BlobsGetPropertiesResponse) Date() time.Time {
	s := bgpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bgpr BlobsGetPropertiesResponse) ETag() ETag {
	return ETag(bgpr.rawResponse.Header.Get("ETag"))
}

// IsIncrementalCopy returns the value for header x-ms-incremental-copy.
func (bgpr BlobsGetPropertiesResponse) IsIncrementalCopy() string {
	return bgpr.rawResponse.Header.Get("x-ms-incremental-copy")
}

// IsServerEncrypted returns the value for header x-ms-server-encrypted.
func (bgpr BlobsGetPropertiesResponse) IsServerEncrypted() string {
	return bgpr.rawResponse.Header.Get("x-ms-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (bgpr BlobsGetPropertiesResponse) LastModified() time.Time {
	s := bgpr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseDuration returns the value for header x-ms-lease-duration.
func (bgpr BlobsGetPropertiesResponse) LeaseDuration() LeaseDurationType {
	return LeaseDurationType(bgpr.rawResponse.Header.Get("x-ms-lease-duration"))
}

// LeaseState returns the value for header x-ms-lease-state.
func (bgpr BlobsGetPropertiesResponse) LeaseState() LeaseStateType {
	return LeaseStateType(bgpr.rawResponse.Header.Get("x-ms-lease-state"))
}

// LeaseStatus returns the value for header x-ms-lease-status.
func (bgpr BlobsGetPropertiesResponse) LeaseStatus() LeaseStatusType {
	return LeaseStatusType(bgpr.rawResponse.Header.Get("x-ms-lease-status"))
}

// RequestID returns the value for header x-ms-request-id.
func (bgpr BlobsGetPropertiesResponse) RequestID() string {
	return bgpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bgpr BlobsGetPropertiesResponse) Version() string {
	return bgpr.rawResponse.Header.Get("x-ms-version")
}

// NewMetadata returns user-defined key/value pairs.
func (bgpr BlobsGetPropertiesResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range bgpr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// BlobsLeaseResponse ...
type BlobsLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (blr BlobsLeaseResponse) Response() *http.Response {
	return blr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (blr BlobsLeaseResponse) StatusCode() int {
	return blr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (blr BlobsLeaseResponse) Status() string {
	return blr.rawResponse.Status
}

// Date returns the value for header Date.
func (blr BlobsLeaseResponse) Date() time.Time {
	s := blr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (blr BlobsLeaseResponse) ETag() ETag {
	return ETag(blr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (blr BlobsLeaseResponse) LastModified() time.Time {
	s := blr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseID returns the value for header x-ms-lease-id.
func (blr BlobsLeaseResponse) LeaseID() string {
	return blr.rawResponse.Header.Get("x-ms-lease-id")
}

// LeaseTime returns the value for header x-ms-lease-time.
func (blr BlobsLeaseResponse) LeaseTime() int32 {
	s := blr.rawResponse.Header.Get("x-ms-lease-time")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		panic(err)
	}
	return int32(i)
}

// RequestID returns the value for header x-ms-request-id.
func (blr BlobsLeaseResponse) RequestID() string {
	return blr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (blr BlobsLeaseResponse) Version() string {
	return blr.rawResponse.Header.Get("x-ms-version")
}

// BlobsPutResponse ...
type BlobsPutResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bpr BlobsPutResponse) Response() *http.Response {
	return bpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bpr BlobsPutResponse) StatusCode() int {
	return bpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bpr BlobsPutResponse) Status() string {
	return bpr.rawResponse.Status
}

/*// ContentMD5 returns the value for header Content-MD5.
func (bpr BlobsPutResponse) ContentMD5() string {
	return bpr.rawResponse.Header.Get("Content-MD5")
}*/

// Date returns the value for header Date.
func (bpr BlobsPutResponse) Date() time.Time {
	s := bpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bpr BlobsPutResponse) ETag() ETag {
	return ETag(bpr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (bpr BlobsPutResponse) IsServerEncrypted() string {
	return bpr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (bpr BlobsPutResponse) LastModified() time.Time {
	s := bpr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bpr BlobsPutResponse) RequestID() string {
	return bpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bpr BlobsPutResponse) Version() string {
	return bpr.rawResponse.Header.Get("x-ms-version")
}

// BlobsSetMetadataResponse ...
type BlobsSetMetadataResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bsmr BlobsSetMetadataResponse) Response() *http.Response {
	return bsmr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bsmr BlobsSetMetadataResponse) StatusCode() int {
	return bsmr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bsmr BlobsSetMetadataResponse) Status() string {
	return bsmr.rawResponse.Status
}

// Date returns the value for header Date.
func (bsmr BlobsSetMetadataResponse) Date() time.Time {
	s := bsmr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bsmr BlobsSetMetadataResponse) ETag() ETag {
	return ETag(bsmr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (bsmr BlobsSetMetadataResponse) IsServerEncrypted() string {
	return bsmr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (bsmr BlobsSetMetadataResponse) LastModified() time.Time {
	s := bsmr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bsmr BlobsSetMetadataResponse) RequestID() string {
	return bsmr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bsmr BlobsSetMetadataResponse) Version() string {
	return bsmr.rawResponse.Header.Get("x-ms-version")
}

// BlobsSetPropertiesResponse ...
type BlobsSetPropertiesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bspr BlobsSetPropertiesResponse) Response() *http.Response {
	return bspr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bspr BlobsSetPropertiesResponse) StatusCode() int {
	return bspr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bspr BlobsSetPropertiesResponse) Status() string {
	return bspr.rawResponse.Status
}

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (bspr BlobsSetPropertiesResponse) BlobSequenceNumber() string {
	return bspr.rawResponse.Header.Get("x-ms-blob-sequence-number")
}

// Date returns the value for header Date.
func (bspr BlobsSetPropertiesResponse) Date() time.Time {
	s := bspr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bspr BlobsSetPropertiesResponse) ETag() ETag {
	return ETag(bspr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (bspr BlobsSetPropertiesResponse) LastModified() time.Time {
	s := bspr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bspr BlobsSetPropertiesResponse) RequestID() string {
	return bspr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bspr BlobsSetPropertiesResponse) Version() string {
	return bspr.rawResponse.Header.Get("x-ms-version")
}

// BlobsTakeSnapshotResponse ...
type BlobsTakeSnapshotResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (btsr BlobsTakeSnapshotResponse) Response() *http.Response {
	return btsr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (btsr BlobsTakeSnapshotResponse) StatusCode() int {
	return btsr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (btsr BlobsTakeSnapshotResponse) Status() string {
	return btsr.rawResponse.Status
}

// Date returns the value for header Date.
func (btsr BlobsTakeSnapshotResponse) Date() time.Time {
	s := btsr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (btsr BlobsTakeSnapshotResponse) ETag() ETag {
	return ETag(btsr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (btsr BlobsTakeSnapshotResponse) LastModified() time.Time {
	s := btsr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (btsr BlobsTakeSnapshotResponse) RequestID() string {
	return btsr.rawResponse.Header.Get("x-ms-request-id")
}

// Snapshot returns the value for header x-ms-snapshot.
func (btsr BlobsTakeSnapshotResponse) Snapshot() time.Time {
	s := btsr.rawResponse.Header.Get("x-ms-snapshot")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(rfc3339Format, s)
	if err != nil {
		panic(err)
	}
	return t
}

// Version returns the value for header x-ms-version.
func (btsr BlobsTakeSnapshotResponse) Version() string {
	return btsr.rawResponse.Header.Get("x-ms-version")
}

// Block - Represents a single block in a block blob.  It describes the block's ID and size.
type Block struct {
	// Name - The base64 encoded block ID.
	Name string `xml:"Name"`
	// Size - The block size in bytes.
	Size int32 `xml:"Size"`
}

// BlockBlobsPutBlockListResponse ...
type BlockBlobsPutBlockListResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bbpblr BlockBlobsPutBlockListResponse) Response() *http.Response {
	return bbpblr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bbpblr BlockBlobsPutBlockListResponse) StatusCode() int {
	return bbpblr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bbpblr BlockBlobsPutBlockListResponse) Status() string {
	return bbpblr.rawResponse.Status
}

/*// ContentMD5 returns the value for header Content-MD5.
func (bbpblr BlockBlobsPutBlockListResponse) ContentMD5() string {
	return bbpblr.rawResponse.Header.Get("Content-MD5")
}*/

// Date returns the value for header Date.
func (bbpblr BlockBlobsPutBlockListResponse) Date() time.Time {
	s := bbpblr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bbpblr BlockBlobsPutBlockListResponse) ETag() ETag {
	return ETag(bbpblr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (bbpblr BlockBlobsPutBlockListResponse) IsServerEncrypted() string {
	return bbpblr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (bbpblr BlockBlobsPutBlockListResponse) LastModified() time.Time {
	s := bbpblr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bbpblr BlockBlobsPutBlockListResponse) RequestID() string {
	return bbpblr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bbpblr BlockBlobsPutBlockListResponse) Version() string {
	return bbpblr.rawResponse.Header.Get("x-ms-version")
}

// BlockBlobsPutBlockResponse ...
type BlockBlobsPutBlockResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (bbpbr BlockBlobsPutBlockResponse) Response() *http.Response {
	return bbpbr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bbpbr BlockBlobsPutBlockResponse) StatusCode() int {
	return bbpbr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bbpbr BlockBlobsPutBlockResponse) Status() string {
	return bbpbr.rawResponse.Status
}

/*// ContentMD5 returns the value for header Content-MD5.
func (bbpbr BlockBlobsPutBlockResponse) ContentMD5() string {
	return bbpbr.rawResponse.Header.Get("Content-MD5")
}*/

// Date returns the value for header Date.
func (bbpbr BlockBlobsPutBlockResponse) Date() time.Time {
	s := bbpbr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (bbpbr BlockBlobsPutBlockResponse) IsServerEncrypted() string {
	return bbpbr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// RequestID returns the value for header x-ms-request-id.
func (bbpbr BlockBlobsPutBlockResponse) RequestID() string {
	return bbpbr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bbpbr BlockBlobsPutBlockResponse) Version() string {
	return bbpbr.rawResponse.Header.Get("x-ms-version")
}

// BlockList ...
type BlockList struct {
	rawResponse       *http.Response
	CommittedBlocks   []Block `xml:"CommittedBlocks>Block"`
	UncommittedBlocks []Block `xml:"UncommittedBlocks>Block"`
}

// Response returns the raw HTTP response object.
func (bl BlockList) Response() *http.Response {
	return bl.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (bl BlockList) StatusCode() int {
	return bl.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (bl BlockList) Status() string {
	return bl.rawResponse.Status
}

// BlobContentLength returns the value for header x-ms-blob-content-length.
func (bl BlockList) BlobContentLength() int64 {
	s := bl.rawResponse.Header.Get("x-ms-blob-content-length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// ContentType returns the value for header Content-Type.
func (bl BlockList) ContentType() string {
	return bl.rawResponse.Header.Get("Content-Type")
}

// Date returns the value for header Date.
func (bl BlockList) Date() time.Time {
	s := bl.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (bl BlockList) ETag() ETag {
	return ETag(bl.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (bl BlockList) LastModified() time.Time {
	s := bl.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (bl BlockList) RequestID() string {
	return bl.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (bl BlockList) Version() string {
	return bl.rawResponse.Header.Get("x-ms-version")
}

// BlockLookupList ...
type BlockLookupList struct {
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName     xml.Name `xml:"BlockList"`
	Committed   []string `xml:"Committed"`
	Uncommitted []string `xml:"Uncommitted"`
	Latest      []string `xml:"Latest"`
}

// ClearRange ...
type ClearRange struct {
	Start int32 `xml:"Start"`
	End   int32 `xml:"End"`
}

// Container - An Azure Storage container
type Container struct {
	Name       string              `xml:"Name"`
	Properties ContainerProperties `xml:"Properties"`
	Metadata   Metadata            `xml:"Metadata"`
}

// ContainerCreateResponse ...
type ContainerCreateResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (ccr ContainerCreateResponse) Response() *http.Response {
	return ccr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ccr ContainerCreateResponse) StatusCode() int {
	return ccr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ccr ContainerCreateResponse) Status() string {
	return ccr.rawResponse.Status
}

// Date returns the value for header Date.
func (ccr ContainerCreateResponse) Date() time.Time {
	s := ccr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (ccr ContainerCreateResponse) ETag() ETag {
	return ETag(ccr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (ccr ContainerCreateResponse) LastModified() time.Time {
	s := ccr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (ccr ContainerCreateResponse) RequestID() string {
	return ccr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ccr ContainerCreateResponse) Version() string {
	return ccr.rawResponse.Header.Get("x-ms-version")
}

// ContainerDeleteResponse ...
type ContainerDeleteResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (cdr ContainerDeleteResponse) Response() *http.Response {
	return cdr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (cdr ContainerDeleteResponse) StatusCode() int {
	return cdr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (cdr ContainerDeleteResponse) Status() string {
	return cdr.rawResponse.Status
}

// Date returns the value for header Date.
func (cdr ContainerDeleteResponse) Date() time.Time {
	s := cdr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (cdr ContainerDeleteResponse) RequestID() string {
	return cdr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (cdr ContainerDeleteResponse) Version() string {
	return cdr.rawResponse.Header.Get("x-ms-version")
}

// ContainerGetMetadataResponse ...
type ContainerGetMetadataResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (cgmr ContainerGetMetadataResponse) Response() *http.Response {
	return cgmr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (cgmr ContainerGetMetadataResponse) StatusCode() int {
	return cgmr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (cgmr ContainerGetMetadataResponse) Status() string {
	return cgmr.rawResponse.Status
}

// Date returns the value for header Date.
func (cgmr ContainerGetMetadataResponse) Date() time.Time {
	s := cgmr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (cgmr ContainerGetMetadataResponse) ETag() ETag {
	return ETag(cgmr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (cgmr ContainerGetMetadataResponse) LastModified() time.Time {
	s := cgmr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (cgmr ContainerGetMetadataResponse) RequestID() string {
	return cgmr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (cgmr ContainerGetMetadataResponse) Version() string {
	return cgmr.rawResponse.Header.Get("x-ms-version")
}

// NewMetadata returns user-defined key/value pairs.
func (cgmr ContainerGetMetadataResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range cgmr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// ContainerGetPropertiesResponse ...
type ContainerGetPropertiesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (cgpr ContainerGetPropertiesResponse) Response() *http.Response {
	return cgpr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (cgpr ContainerGetPropertiesResponse) StatusCode() int {
	return cgpr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (cgpr ContainerGetPropertiesResponse) Status() string {
	return cgpr.rawResponse.Status
}

// BlobPublicAccess returns the value for header x-ms-blob-public-access.
func (cgpr ContainerGetPropertiesResponse) BlobPublicAccess() PublicAccessType {
	return PublicAccessType(cgpr.rawResponse.Header.Get("x-ms-blob-public-access"))
}

// Date returns the value for header Date.
func (cgpr ContainerGetPropertiesResponse) Date() time.Time {
	s := cgpr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (cgpr ContainerGetPropertiesResponse) ETag() ETag {
	return ETag(cgpr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (cgpr ContainerGetPropertiesResponse) LastModified() time.Time {
	s := cgpr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseDuration returns the value for header x-ms-lease-duration.
func (cgpr ContainerGetPropertiesResponse) LeaseDuration() LeaseDurationType {
	return LeaseDurationType(cgpr.rawResponse.Header.Get("x-ms-lease-duration"))
}

// LeaseState returns the value for header x-ms-lease-state.
func (cgpr ContainerGetPropertiesResponse) LeaseState() LeaseStateType {
	return LeaseStateType(cgpr.rawResponse.Header.Get("x-ms-lease-state"))
}

// LeaseStatus returns the value for header x-ms-lease-status.
func (cgpr ContainerGetPropertiesResponse) LeaseStatus() LeaseStatusType {
	return LeaseStatusType(cgpr.rawResponse.Header.Get("x-ms-lease-status"))
}

// RequestID returns the value for header x-ms-request-id.
func (cgpr ContainerGetPropertiesResponse) RequestID() string {
	return cgpr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (cgpr ContainerGetPropertiesResponse) Version() string {
	return cgpr.rawResponse.Header.Get("x-ms-version")
}

// NewMetadata returns user-defined key/value pairs.
func (cgpr ContainerGetPropertiesResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range cgpr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// ContainerLeaseResponse ...
type ContainerLeaseResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (clr ContainerLeaseResponse) Response() *http.Response {
	return clr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (clr ContainerLeaseResponse) StatusCode() int {
	return clr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (clr ContainerLeaseResponse) Status() string {
	return clr.rawResponse.Status
}

// Date returns the value for header Date.
func (clr ContainerLeaseResponse) Date() time.Time {
	s := clr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (clr ContainerLeaseResponse) ETag() ETag {
	return ETag(clr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (clr ContainerLeaseResponse) LastModified() time.Time {
	s := clr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseID returns the value for header x-ms-lease-id.
func (clr ContainerLeaseResponse) LeaseID() string {
	return clr.rawResponse.Header.Get("x-ms-lease-id")
}

// LeaseTime returns the value for header x-ms-lease-time.
func (clr ContainerLeaseResponse) LeaseTime() int32 {
	s := clr.rawResponse.Header.Get("x-ms-lease-time")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		panic(err)
	}
	return int32(i)
}

// RequestID returns the value for header x-ms-request-id.
func (clr ContainerLeaseResponse) RequestID() string {
	return clr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (clr ContainerLeaseResponse) Version() string {
	return clr.rawResponse.Header.Get("x-ms-version")
}

// ContainerProperties - Properties of a container
type ContainerProperties struct {
	LastModified time.Time `xml:"Last-Modified"`
	Etag         ETag      `xml:"Etag"`
	// LeaseStatus - Possible values include: 'Locked', 'Unlocked', 'None'
	LeaseStatus LeaseStatusType `xml:"LeaseStatus"`
	// LeaseState - Possible values include: 'Available', 'Leased', 'Expired', 'Breaking', 'Broken', 'None'
	LeaseState LeaseStateType `xml:"LeaseState"`
	// LeaseDuration - Possible values include: 'Infinite', 'Fixed', 'None'
	LeaseDuration LeaseDurationType `xml:"LeaseDuration"`
	// PublicAccess - Possible values include: 'Container', 'Blob', 'None'
	PublicAccess PublicAccessType `xml:"PublicAccess"`
}

// ContainerSetACLResponse ...
type ContainerSetACLResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (csar ContainerSetACLResponse) Response() *http.Response {
	return csar.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (csar ContainerSetACLResponse) StatusCode() int {
	return csar.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (csar ContainerSetACLResponse) Status() string {
	return csar.rawResponse.Status
}

// Date returns the value for header Date.
func (csar ContainerSetACLResponse) Date() time.Time {
	s := csar.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (csar ContainerSetACLResponse) ETag() ETag {
	return ETag(csar.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (csar ContainerSetACLResponse) LastModified() time.Time {
	s := csar.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (csar ContainerSetACLResponse) RequestID() string {
	return csar.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (csar ContainerSetACLResponse) Version() string {
	return csar.rawResponse.Header.Get("x-ms-version")
}

// ContainerSetMetadataResponse ...
type ContainerSetMetadataResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (csmr ContainerSetMetadataResponse) Response() *http.Response {
	return csmr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (csmr ContainerSetMetadataResponse) StatusCode() int {
	return csmr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (csmr ContainerSetMetadataResponse) Status() string {
	return csmr.rawResponse.Status
}

// Date returns the value for header Date.
func (csmr ContainerSetMetadataResponse) Date() time.Time {
	s := csmr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (csmr ContainerSetMetadataResponse) ETag() ETag {
	return ETag(csmr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (csmr ContainerSetMetadataResponse) LastModified() time.Time {
	s := csmr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (csmr ContainerSetMetadataResponse) RequestID() string {
	return csmr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (csmr ContainerSetMetadataResponse) Version() string {
	return csmr.rawResponse.Header.Get("x-ms-version")
}

// CorsRule - CORS is an HTTP feature that enables a web application running under one domain to access resources in
// another domain. Web browsers implement a security restriction known as same-origin policy that prevents a web page
// from calling APIs in a different domain; CORS provides a secure way to allow one domain (the origin domain) to call
// APIs in another domain
type CorsRule struct {
	// AllowedOrigins - The origin domains that are permitted to make a request against the storage service via CORS. The origin domain is the domain from which the request originates. Note that the origin must be an exact case-sensitive match with the origin that the user age sends to the service. You can also use the wildcard character '*' to allow all origin domains to make requests via CORS.
	AllowedOrigins string `xml:"AllowedOrigins"`
	// AllowedMethods - The methods (HTTP request verbs) that the origin domain may use for a CORS request. (comma separated)
	AllowedMethods string `xml:"AllowedMethods"`
	// AllowedHeaders - the request headers that the origin domain may specify on the CORS request.
	AllowedHeaders string `xml:"AllowedHeaders"`
	// ExposedHeaders - The response headers that may be sent in the response to the CORS request and exposed by the browser to the request issuer
	ExposedHeaders string `xml:"ExposedHeaders"`
	// MaxAgeInSeconds - The maximum amount time that a browser should cache the preflight OPTIONS request.
	MaxAgeInSeconds int32 `xml:"MaxAgeInSeconds"`
}

// GeoReplication ...
type GeoReplication struct {
	// Status - The status of the secondary location. Possible values include: 'Live', 'Bootstrap', 'Unavailable', 'None'
	Status GeoReplicationStatusType `xml:"Status"`
	// LastSyncTime - A GMT date/time value, to the second. All primary writes preceding this value are guaranteed to be available for read operations at the secondary. Primary writes after this point in time may or may not be available for reads.
	LastSyncTime time.Time `xml:"LastSyncTime"`
}

// GetResponse ...
type GetResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (gr GetResponse) Response() *http.Response {
	return gr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (gr GetResponse) StatusCode() int {
	return gr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (gr GetResponse) Status() string {
	return gr.rawResponse.Status
}

// Body returns the raw HTTP response object's Body.
func (gr GetResponse) Body() io.ReadCloser {
	return gr.rawResponse.Body
}

// AcceptRanges returns the value for header Accept-Ranges.
func (gr GetResponse) AcceptRanges() string {
	return gr.rawResponse.Header.Get("Accept-Ranges")
}

// BlobCommittedBlockCount returns the value for header x-ms-blob-committed-block-count.
func (gr GetResponse) BlobCommittedBlockCount() string {
	return gr.rawResponse.Header.Get("x-ms-blob-committed-block-count")
}

/*// BlobContentMD5 returns the value for header x-ms-blob-content-md5.
func (gr GetResponse) BlobContentMD5() string {
	return gr.rawResponse.Header.Get("x-ms-blob-content-md5")
}*/

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (gr GetResponse) BlobSequenceNumber() string {
	return gr.rawResponse.Header.Get("x-ms-blob-sequence-number")
}

// BlobType returns the value for header x-ms-blob-type.
func (gr GetResponse) BlobType() BlobType {
	return BlobType(gr.rawResponse.Header.Get("x-ms-blob-type"))
}

// CacheControl returns the value for header Cache-Control.
func (gr GetResponse) CacheControl() string {
	return gr.rawResponse.Header.Get("Cache-Control")
}

// ContentDisposition returns the value for header Content-Disposition.
func (gr GetResponse) ContentDisposition() string {
	return gr.rawResponse.Header.Get("Content-Disposition")
}

// ContentEncoding returns the value for header Content-Encoding.
func (gr GetResponse) ContentEncoding() string {
	return gr.rawResponse.Header.Get("Content-Encoding")
}

// ContentLanguage returns the value for header Content-Language.
func (gr GetResponse) ContentLanguage() string {
	return gr.rawResponse.Header.Get("Content-Language")
}

// ContentLength returns the value for header Content-Length.
func (gr GetResponse) ContentLength() int64 {
	s := gr.rawResponse.Header.Get("Content-Length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

/*// ContentMD5 returns the value for header Content-MD5.
func (gr GetResponse) ContentMD5() string {
	return gr.rawResponse.Header.Get("Content-MD5")
}*/

// ContentRange returns the value for header Content-Range.
func (gr GetResponse) ContentRange() string {
	return gr.rawResponse.Header.Get("Content-Range")
}

// ContentType returns the value for header Content-Type.
func (gr GetResponse) ContentType() string {
	return gr.rawResponse.Header.Get("Content-Type")
}

// CopyCompletionTime returns the value for header x-ms-copy-completion-time.
func (gr GetResponse) CopyCompletionTime() time.Time {
	s := gr.rawResponse.Header.Get("x-ms-copy-completion-time")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// CopyID returns the value for header x-ms-copy-id.
func (gr GetResponse) CopyID() string {
	return gr.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyProgress returns the value for header x-ms-copy-progress.
func (gr GetResponse) CopyProgress() string {
	return gr.rawResponse.Header.Get("x-ms-copy-progress")
}

// CopySource returns the value for header x-ms-copy-source.
func (gr GetResponse) CopySource() string {
	return gr.rawResponse.Header.Get("x-ms-copy-source")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (gr GetResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(gr.rawResponse.Header.Get("x-ms-copy-status"))
}

// CopyStatusDescription returns the value for header x-ms-copy-status-description.
func (gr GetResponse) CopyStatusDescription() string {
	return gr.rawResponse.Header.Get("x-ms-copy-status-description")
}

// Date returns the value for header Date.
func (gr GetResponse) Date() time.Time {
	s := gr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (gr GetResponse) ETag() ETag {
	return ETag(gr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-server-encrypted.
func (gr GetResponse) IsServerEncrypted() string {
	return gr.rawResponse.Header.Get("x-ms-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (gr GetResponse) LastModified() time.Time {
	s := gr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// LeaseDuration returns the value for header x-ms-lease-duration.
func (gr GetResponse) LeaseDuration() LeaseDurationType {
	return LeaseDurationType(gr.rawResponse.Header.Get("x-ms-lease-duration"))
}

// LeaseState returns the value for header x-ms-lease-state.
func (gr GetResponse) LeaseState() LeaseStateType {
	return LeaseStateType(gr.rawResponse.Header.Get("x-ms-lease-state"))
}

// LeaseStatus returns the value for header x-ms-lease-status.
func (gr GetResponse) LeaseStatus() LeaseStatusType {
	return LeaseStatusType(gr.rawResponse.Header.Get("x-ms-lease-status"))
}

// RequestID returns the value for header x-ms-request-id.
func (gr GetResponse) RequestID() string {
	return gr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (gr GetResponse) Version() string {
	return gr.rawResponse.Header.Get("x-ms-version")
}

// NewMetadata returns user-defined key/value pairs.
func (gr GetResponse) NewMetadata() Metadata {
	md := Metadata{}
	for k, v := range gr.rawResponse.Header {
		if len(k) > mdPrefixLen {
			if prefix := k[0:mdPrefixLen]; strings.EqualFold(prefix, mdPrefix) {
				md[strings.ToLower(k[mdPrefixLen:])] = v[0]
			}
		}
	}
	return md
}

// ListBlobsResponse - An enumeration of blobs
type ListBlobsResponse struct {
	rawResponse *http.Response
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName         xml.Name `xml:"EnumerationResults"`
	ServiceEndpoint string   `xml:"ServiceEndpoint,attr"`
	ContainerName   string   `xml:"ContainerName,attr"`
	Prefix          string   `xml:"Prefix"`
	Marker          string   `xml:"Marker"`
	MaxResults      int32    `xml:"MaxResults"`
	Delimiter       string   `xml:"Delimiter"`
	Blobs           Blobs    `xml:"Blobs"`
	NextMarker      Marker   `xml:"NextMarker"`
}

// Response returns the raw HTTP response object.
func (lbr ListBlobsResponse) Response() *http.Response {
	return lbr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (lbr ListBlobsResponse) StatusCode() int {
	return lbr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (lbr ListBlobsResponse) Status() string {
	return lbr.rawResponse.Status
}

// ContentType returns the value for header Content-Type.
func (lbr ListBlobsResponse) ContentType() string {
	return lbr.rawResponse.Header.Get("Content-Type")
}

// Date returns the value for header Date.
func (lbr ListBlobsResponse) Date() time.Time {
	s := lbr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (lbr ListBlobsResponse) RequestID() string {
	return lbr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (lbr ListBlobsResponse) Version() string {
	return lbr.rawResponse.Header.Get("x-ms-version")
}

// ListContainersResponse - An enumeration of containers
type ListContainersResponse struct {
	rawResponse *http.Response
	// XMLName is used for marshalling and is subject to removal in a future release.
	XMLName         xml.Name    `xml:"EnumerationResults"`
	ServiceEndpoint string      `xml:"ServiceEndpoint,attr"`
	Prefix          string      `xml:"Prefix"`
	Marker          *string     `xml:"Marker"`
	MaxResults      int32       `xml:"MaxResults"`
	Containers      []Container `xml:"Containers>Container"`
	NextMarker      Marker      `xml:"NextMarker"`
}

// Response returns the raw HTTP response object.
func (lcr ListContainersResponse) Response() *http.Response {
	return lcr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (lcr ListContainersResponse) StatusCode() int {
	return lcr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (lcr ListContainersResponse) Status() string {
	return lcr.rawResponse.Status
}

// RequestID returns the value for header x-ms-request-id.
func (lcr ListContainersResponse) RequestID() string {
	return lcr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (lcr ListContainersResponse) Version() string {
	return lcr.rawResponse.Header.Get("x-ms-version")
}

// Logging - Azure Analytics Logging settings.
type Logging struct {
	// Version - The version of Storage Analytics to configure.
	Version string `xml:"Version"`
	// Delete - Indicates whether all delete requests should be logged.
	Delete bool `xml:"Delete"`
	// Read - Indicates whether all read requests should be logged.
	Read bool `xml:"Read"`
	// Write - Indicates whether all write requests should be logged.
	Write           bool            `xml:"Write"`
	RetentionPolicy RetentionPolicy `xml:"RetentionPolicy"`
}

// Metrics ...
type Metrics struct {
	// Version - The version of Storage Analytics to configure.
	Version string `xml:"Version"`
	// Enabled - Indicates whether metrics are enabled for the Blob service.
	Enabled bool `xml:"Enabled"`
	// IncludeAPIs - Indicates whether metrics should generate summary statistics for called API operations.
	IncludeAPIs     bool            `xml:"IncludeAPIs"`
	RetentionPolicy RetentionPolicy `xml:"RetentionPolicy"`
}

// PageBlobsIncrementalCopyResponse ...
type PageBlobsIncrementalCopyResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (pbicr PageBlobsIncrementalCopyResponse) Response() *http.Response {
	return pbicr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pbicr PageBlobsIncrementalCopyResponse) StatusCode() int {
	return pbicr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pbicr PageBlobsIncrementalCopyResponse) Status() string {
	return pbicr.rawResponse.Status
}

// CopyID returns the value for header x-ms-copy-id.
func (pbicr PageBlobsIncrementalCopyResponse) CopyID() string {
	return pbicr.rawResponse.Header.Get("x-ms-copy-id")
}

// CopyStatus returns the value for header x-ms-copy-status.
func (pbicr PageBlobsIncrementalCopyResponse) CopyStatus() CopyStatusType {
	return CopyStatusType(pbicr.rawResponse.Header.Get("x-ms-copy-status"))
}

// Date returns the value for header Date.
func (pbicr PageBlobsIncrementalCopyResponse) Date() time.Time {
	s := pbicr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (pbicr PageBlobsIncrementalCopyResponse) ETag() ETag {
	return ETag(pbicr.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (pbicr PageBlobsIncrementalCopyResponse) LastModified() time.Time {
	s := pbicr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (pbicr PageBlobsIncrementalCopyResponse) RequestID() string {
	return pbicr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pbicr PageBlobsIncrementalCopyResponse) Version() string {
	return pbicr.rawResponse.Header.Get("x-ms-version")
}

// PageBlobsPutPageResponse ...
type PageBlobsPutPageResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (pbppr PageBlobsPutPageResponse) Response() *http.Response {
	return pbppr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pbppr PageBlobsPutPageResponse) StatusCode() int {
	return pbppr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pbppr PageBlobsPutPageResponse) Status() string {
	return pbppr.rawResponse.Status
}

// BlobSequenceNumber returns the value for header x-ms-blob-sequence-number.
func (pbppr PageBlobsPutPageResponse) BlobSequenceNumber() int32 {
	s := pbppr.rawResponse.Header.Get("x-ms-blob-sequence-number")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 32)
	if err != nil {
		panic(err)
	}
	return int32(i)
}

/*// ContentMD5 returns the value for header Content-MD5.
func (pbppr PageBlobsPutPageResponse) ContentMD5() string {
	return pbppr.rawResponse.Header.Get("Content-MD5")
}*/

// Date returns the value for header Date.
func (pbppr PageBlobsPutPageResponse) Date() time.Time {
	s := pbppr.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (pbppr PageBlobsPutPageResponse) ETag() ETag {
	return ETag(pbppr.rawResponse.Header.Get("ETag"))
}

// IsServerEncrypted returns the value for header x-ms-request-server-encrypted.
func (pbppr PageBlobsPutPageResponse) IsServerEncrypted() string {
	return pbppr.rawResponse.Header.Get("x-ms-request-server-encrypted")
}

// LastModified returns the value for header Last-Modified.
func (pbppr PageBlobsPutPageResponse) LastModified() time.Time {
	s := pbppr.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (pbppr PageBlobsPutPageResponse) RequestID() string {
	return pbppr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pbppr PageBlobsPutPageResponse) Version() string {
	return pbppr.rawResponse.Header.Get("x-ms-version")
}

// PageList - the list of pages
type PageList struct {
	rawResponse *http.Response
	PageRange   []PageRange  `xml:"PageRange"`
	ClearRange  []ClearRange `xml:"ClearRange"`
}

// Response returns the raw HTTP response object.
func (pl PageList) Response() *http.Response {
	return pl.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (pl PageList) StatusCode() int {
	return pl.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (pl PageList) Status() string {
	return pl.rawResponse.Status
}

// BlobContentLength returns the value for header x-ms-blob-content-length.
func (pl PageList) BlobContentLength() int64 {
	s := pl.rawResponse.Header.Get("x-ms-blob-content-length")
	if s == "" {
		return -1
	}
	i, err := strconv.ParseInt(s, 10, 64)
	if err != nil {
		panic(err)
	}
	return i
}

// Date returns the value for header Date.
func (pl PageList) Date() time.Time {
	s := pl.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (pl PageList) ETag() ETag {
	return ETag(pl.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (pl PageList) LastModified() time.Time {
	s := pl.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (pl PageList) RequestID() string {
	return pl.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (pl PageList) Version() string {
	return pl.rawResponse.Header.Get("x-ms-version")
}

// PageRange ...
type PageRange struct {
	Start int32 `xml:"Start"`
	End   int32 `xml:"End"`
}

// RetentionPolicy - the retention policy
type RetentionPolicy struct {
	// Enabled - Indicates whether a retention policy is enabled for the storage service
	Enabled bool `xml:"Enabled"`
	// Days - Indicates the number of days that metrics or logging data should be retained. All data older than this value will be deleted
	Days int32 `xml:"Days"`
}

// ServiceSetPropertiesResponse ...
type ServiceSetPropertiesResponse struct {
	rawResponse *http.Response
}

// Response returns the raw HTTP response object.
func (sspr ServiceSetPropertiesResponse) Response() *http.Response {
	return sspr.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (sspr ServiceSetPropertiesResponse) StatusCode() int {
	return sspr.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (sspr ServiceSetPropertiesResponse) Status() string {
	return sspr.rawResponse.Status
}

// RequestID returns the value for header x-ms-request-id.
func (sspr ServiceSetPropertiesResponse) RequestID() string {
	return sspr.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (sspr ServiceSetPropertiesResponse) Version() string {
	return sspr.rawResponse.Header.Get("x-ms-version")
}

// SignedIdentifier - signed identifier
type SignedIdentifier struct {
	// ID - a unique id
	ID string `xml:"Id"`
	// AccessPolicy - The access policy
	AccessPolicy AccessPolicy `xml:"AccessPolicy"`
}

// SignedIdentifiers ...
type SignedIdentifiers struct {
	rawResponse *http.Response
	Value       []SignedIdentifier `xml:"SignedIdentifier"`
}

// Response returns the raw HTTP response object.
func (si SignedIdentifiers) Response() *http.Response {
	return si.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (si SignedIdentifiers) StatusCode() int {
	return si.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (si SignedIdentifiers) Status() string {
	return si.rawResponse.Status
}

// BlobPublicAccess returns the value for header x-ms-blob-public-access.
func (si SignedIdentifiers) BlobPublicAccess() PublicAccessType {
	return PublicAccessType(si.rawResponse.Header.Get("x-ms-blob-public-access"))
}

// Date returns the value for header Date.
func (si SignedIdentifiers) Date() time.Time {
	s := si.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// ETag returns the value for header ETag.
func (si SignedIdentifiers) ETag() ETag {
	return ETag(si.rawResponse.Header.Get("ETag"))
}

// LastModified returns the value for header Last-Modified.
func (si SignedIdentifiers) LastModified() time.Time {
	s := si.rawResponse.Header.Get("Last-Modified")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (si SignedIdentifiers) RequestID() string {
	return si.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (si SignedIdentifiers) Version() string {
	return si.rawResponse.Header.Get("x-ms-version")
}

// StorageServiceProperties - Storage Service Properties.
type StorageServiceProperties struct {
	rawResponse *http.Response
	// Logging - Azure Analytics Logging settings
	Logging Logging `xml:"Logging"`
	// HourMetrics - A summary of request statistics grouped by API in hourly aggregates for blobs
	HourMetrics Metrics `xml:"HourMetrics"`
	// MinuteMetrics - a summary of request statistics grouped by API in minute aggregates for blobs
	MinuteMetrics Metrics `xml:"MinuteMetrics"`
	// Cors - The set of CORS rules.
	Cors []CorsRule `xml:"Cors>CorsRule"`
	// DefaultServiceVersion - The default version to use for requests to the Blob service if an incoming request's version is not specified. Possible values include version 2008-10-27 and all more recent versions
	DefaultServiceVersion string `xml:"DefaultServiceVersion"`
}

// Response returns the raw HTTP response object.
func (ssp StorageServiceProperties) Response() *http.Response {
	return ssp.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (ssp StorageServiceProperties) StatusCode() int {
	return ssp.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (ssp StorageServiceProperties) Status() string {
	return ssp.rawResponse.Status
}

// RequestID returns the value for header x-ms-request-id.
func (ssp StorageServiceProperties) RequestID() string {
	return ssp.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (ssp StorageServiceProperties) Version() string {
	return ssp.rawResponse.Header.Get("x-ms-version")
}

// StorageServiceStats - Stats for the storage service.
type StorageServiceStats struct {
	rawResponse *http.Response
	// GeoReplication - Geo-Replication information for the Secondary Storage Service
	GeoReplication *GeoReplication `xml:"GeoReplication"`
}

// Response returns the raw HTTP response object.
func (sss StorageServiceStats) Response() *http.Response {
	return sss.rawResponse
}

// StatusCode returns the HTTP status code of the response, e.g. 200.
func (sss StorageServiceStats) StatusCode() int {
	return sss.rawResponse.StatusCode
}

// Status returns the HTTP status message of the response, e.g. "200 OK".
func (sss StorageServiceStats) Status() string {
	return sss.rawResponse.Status
}

// Date returns the value for header Date.
func (sss StorageServiceStats) Date() time.Time {
	s := sss.rawResponse.Header.Get("Date")
	if s == "" {
		return time.Time{}
	}
	t, err := time.Parse(time.RFC1123, s)
	if err != nil {
		panic(err)
	}
	return t
}

// RequestID returns the value for header x-ms-request-id.
func (sss StorageServiceStats) RequestID() string {
	return sss.rawResponse.Header.Get("x-ms-request-id")
}

// Version returns the value for header x-ms-version.
func (sss StorageServiceStats) Version() string {
	return sss.rawResponse.Header.Get("x-ms-version")
}
