package azblob

// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/xml"
	"reflect"
	"time"
	"unsafe"
)

const (
	rfc3339Format = "2006-01-02T15:04:05.0000000Z07:00"
)

// used to convert times from UTC to GMT before sending across the wire
var gmt = time.FixedZone("GMT", 0)

// internal type used for marshalling time in RFC1123 format
type timeRFC1123 struct {
	time.Time
}

// MarshalText implements the encoding.TextMarshaler interface for timeRFC1123.
func (t timeRFC1123) MarshalText() ([]byte, error) {
	return []byte(t.Format(time.RFC1123)), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface for timeRFC1123.
func (t *timeRFC1123) UnmarshalText(data []byte) (err error) {
	t.Time, err = time.Parse(time.RFC1123, string(data))
	return
}

// internal type used for marshalling time in RFC3339 format
type timeRFC3339 struct {
	time.Time
}

// MarshalText implements the encoding.TextMarshaler interface for timeRFC3339.
func (t timeRFC3339) MarshalText() ([]byte, error) {
	return []byte(t.Format(rfc3339Format)), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface for timeRFC3339.
func (t *timeRFC3339) UnmarshalText(data []byte) (err error) {
	t.Time, err = time.Parse(rfc3339Format, string(data))
	return
}

// internal type used for marshalling
type accessPolicy struct {
	Start      timeRFC3339 `xml:"Start"`
	Expiry     timeRFC3339 `xml:"Expiry"`
	Permission string      `xml:"Permission"`
}

// MarshalXML implements the xml.Marshaler interface for AccessPolicy.
func (ap AccessPolicy) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	if reflect.TypeOf((*AccessPolicy)(nil)).Elem().Size() != reflect.TypeOf((*accessPolicy)(nil)).Elem().Size() {
		panic("size mismatch between AccessPolicy and accessPolicy")
	}
	ap2 := (*accessPolicy)(unsafe.Pointer(&ap))
	return e.EncodeElement(*ap2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for AccessPolicy.
func (ap *AccessPolicy) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if reflect.TypeOf((*AccessPolicy)(nil)).Elem().Size() != reflect.TypeOf((*accessPolicy)(nil)).Elem().Size() {
		panic("size mismatch between AccessPolicy and accessPolicy")
	}
	ap2 := (*accessPolicy)(unsafe.Pointer(ap))
	err := d.DecodeElement(ap2, &start)
	if err != nil {
		ap = (*AccessPolicy)(unsafe.Pointer(ap2))
	}
	return err
}

// internal type used for marshalling
type blobProperties struct {
	LastModified          timeRFC1123       `xml:"Last-Modified"`
	Etag                  ETag              `xml:"Etag"`
	ContentLength         *int64            `xml:"Content-Length"`
	ContentType           *string           `xml:"Content-Type"`
	ContentEncoding       *string           `xml:"Content-Encoding"`
	ContentLanguage       *string           `xml:"Content-Language"`
	ContentMD5            *string           `xml:"Content-MD5"`
	ContentDisposition    *string           `xml:"Content-Disposition"`
	CacheControl          *string           `xml:"Cache-Control"`
	BlobSequenceNumber    *int32            `xml:"x-ms-blob-sequence-number"`
	BlobType              BlobType          `xml:"BlobType"`
	LeaseStatus           LeaseStatusType   `xml:"LeaseStatus"`
	LeaseState            LeaseStateType    `xml:"LeaseState"`
	LeaseDuration         LeaseDurationType `xml:"LeaseDuration"`
	CopyID                *string           `xml:"CopyId"`
	CopyStatus            CopyStatusType    `xml:"CopyStatus"`
	CopySource            *string           `xml:"CopySource"`
	CopyProgress          *string           `xml:"CopyProgress"`
	CopyCompletionTime    *timeRFC1123      `xml:"CopyCompletionTime"`
	CopyStatusDescription *string           `xml:"CopyStatusDescription"`
	ServerEncrypted       *bool             `xml:"ServerEncrypted"`
	IncrementalCopy       *bool             `xml:"IncrementalCopy"`
}

// MarshalXML implements the xml.Marshaler interface for BlobProperties.
func (bp BlobProperties) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	if reflect.TypeOf((*BlobProperties)(nil)).Elem().Size() != reflect.TypeOf((*blobProperties)(nil)).Elem().Size() {
		panic("size mismatch between BlobProperties and blobProperties")
	}
	bp2 := (*blobProperties)(unsafe.Pointer(&bp))
	return e.EncodeElement(*bp2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for BlobProperties.
func (bp *BlobProperties) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if reflect.TypeOf((*BlobProperties)(nil)).Elem().Size() != reflect.TypeOf((*blobProperties)(nil)).Elem().Size() {
		panic("size mismatch between BlobProperties and blobProperties")
	}
	bp2 := (*blobProperties)(unsafe.Pointer(bp))
	return d.DecodeElement(bp2, &start)
}

// internal type used for marshalling
type blob struct {
	Name       string         `xml:"Name"`
	Snapshot   timeRFC3339    `xml:"Snapshot"`
	Properties BlobProperties `xml:"Properties"`
	Metadata   Metadata       `xml:"Metadata"`
}

// MarshalXML implements the xml.Marshaler interface for Blob.
func (b Blob) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	if reflect.TypeOf((*Blob)(nil)).Elem().Size() != reflect.TypeOf((*blob)(nil)).Elem().Size() {
		panic("size mismatch between Blob and blob")
	}
	b2 := (*blob)(unsafe.Pointer(&b))
	return e.EncodeElement(*b2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for Blob.
func (b *Blob) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if reflect.TypeOf((*Blob)(nil)).Elem().Size() != reflect.TypeOf((*blob)(nil)).Elem().Size() {
		panic("size mismatch between Blob and blob")
	}
	b2 := (*blob)(unsafe.Pointer(b))
	return d.DecodeElement(b2, &start)
}

// internal type used for marshalling
type containerProperties struct {
	LastModified  timeRFC1123       `xml:"Last-Modified"`
	Etag          ETag              `xml:"Etag"`
	LeaseStatus   LeaseStatusType   `xml:"LeaseStatus"`
	LeaseState    LeaseStateType    `xml:"LeaseState"`
	LeaseDuration LeaseDurationType `xml:"LeaseDuration"`
	PublicAccess  PublicAccessType  `xml:"PublicAccess"`
}

// MarshalXML implements the xml.Marshaler interface for ContainerProperties.
func (cp ContainerProperties) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	if reflect.TypeOf((*ContainerProperties)(nil)).Elem().Size() != reflect.TypeOf((*containerProperties)(nil)).Elem().Size() {
		panic("size mismatch between ContainerProperties and containerProperties")
	}
	cp2 := (*containerProperties)(unsafe.Pointer(&cp))
	return e.EncodeElement(*cp2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for ContainerProperties.
func (cp *ContainerProperties) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if reflect.TypeOf((*ContainerProperties)(nil)).Elem().Size() != reflect.TypeOf((*containerProperties)(nil)).Elem().Size() {
		panic("size mismatch between ContainerProperties and containerProperties")
	}
	cp2 := (*containerProperties)(unsafe.Pointer(cp))
	return d.DecodeElement(cp2, &start)
}

// internal type used for marshalling
type geoReplication struct {
	Status       GeoReplicationStatusType `xml:"Status"`
	LastSyncTime timeRFC1123              `xml:"LastSyncTime"`
}

// MarshalXML implements the xml.Marshaler interface for GeoReplication.
func (gr GeoReplication) MarshalXML(e *xml.Encoder, start xml.StartElement) error {
	if reflect.TypeOf((*GeoReplication)(nil)).Elem().Size() != reflect.TypeOf((*geoReplication)(nil)).Elem().Size() {
		panic("size mismatch between GeoReplication and geoReplication")
	}
	gr2 := (*geoReplication)(unsafe.Pointer(&gr))
	return e.EncodeElement(*gr2, start)
}

// UnmarshalXML implements the xml.Unmarshaler interface for GeoReplication.
func (gr *GeoReplication) UnmarshalXML(d *xml.Decoder, start xml.StartElement) error {
	if reflect.TypeOf((*GeoReplication)(nil)).Elem().Size() != reflect.TypeOf((*geoReplication)(nil)).Elem().Size() {
		panic("size mismatch between GeoReplication and geoReplication")
	}
	gr2 := (*geoReplication)(unsafe.Pointer(gr))
	return d.DecodeElement(gr2, &start)
}
