// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package osisiface provides an interface to enable mocking the Amazon OpenSearch Ingestion service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package osisiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/osis"
)

// OSISAPI provides an interface to enable mocking the
// osis.OSIS service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Amazon OpenSearch Ingestion.
//	func myFunc(svc osisiface.OSISAPI) bool {
//	    // Make svc.CreatePipeline request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := osis.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockOSISClient struct {
//	    osisiface.OSISAPI
//	}
//	func (m *mockOSISClient) CreatePipeline(input *osis.CreatePipelineInput) (*osis.CreatePipelineOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockOSISClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type OSISAPI interface {
	CreatePipeline(*osis.CreatePipelineInput) (*osis.CreatePipelineOutput, error)
	CreatePipelineWithContext(aws.Context, *osis.CreatePipelineInput, ...request.Option) (*osis.CreatePipelineOutput, error)
	CreatePipelineRequest(*osis.CreatePipelineInput) (*request.Request, *osis.CreatePipelineOutput)

	DeletePipeline(*osis.DeletePipelineInput) (*osis.DeletePipelineOutput, error)
	DeletePipelineWithContext(aws.Context, *osis.DeletePipelineInput, ...request.Option) (*osis.DeletePipelineOutput, error)
	DeletePipelineRequest(*osis.DeletePipelineInput) (*request.Request, *osis.DeletePipelineOutput)

	GetPipeline(*osis.GetPipelineInput) (*osis.GetPipelineOutput, error)
	GetPipelineWithContext(aws.Context, *osis.GetPipelineInput, ...request.Option) (*osis.GetPipelineOutput, error)
	GetPipelineRequest(*osis.GetPipelineInput) (*request.Request, *osis.GetPipelineOutput)

	GetPipelineBlueprint(*osis.GetPipelineBlueprintInput) (*osis.GetPipelineBlueprintOutput, error)
	GetPipelineBlueprintWithContext(aws.Context, *osis.GetPipelineBlueprintInput, ...request.Option) (*osis.GetPipelineBlueprintOutput, error)
	GetPipelineBlueprintRequest(*osis.GetPipelineBlueprintInput) (*request.Request, *osis.GetPipelineBlueprintOutput)

	GetPipelineChangeProgress(*osis.GetPipelineChangeProgressInput) (*osis.GetPipelineChangeProgressOutput, error)
	GetPipelineChangeProgressWithContext(aws.Context, *osis.GetPipelineChangeProgressInput, ...request.Option) (*osis.GetPipelineChangeProgressOutput, error)
	GetPipelineChangeProgressRequest(*osis.GetPipelineChangeProgressInput) (*request.Request, *osis.GetPipelineChangeProgressOutput)

	ListPipelineBlueprints(*osis.ListPipelineBlueprintsInput) (*osis.ListPipelineBlueprintsOutput, error)
	ListPipelineBlueprintsWithContext(aws.Context, *osis.ListPipelineBlueprintsInput, ...request.Option) (*osis.ListPipelineBlueprintsOutput, error)
	ListPipelineBlueprintsRequest(*osis.ListPipelineBlueprintsInput) (*request.Request, *osis.ListPipelineBlueprintsOutput)

	ListPipelines(*osis.ListPipelinesInput) (*osis.ListPipelinesOutput, error)
	ListPipelinesWithContext(aws.Context, *osis.ListPipelinesInput, ...request.Option) (*osis.ListPipelinesOutput, error)
	ListPipelinesRequest(*osis.ListPipelinesInput) (*request.Request, *osis.ListPipelinesOutput)

	ListPipelinesPages(*osis.ListPipelinesInput, func(*osis.ListPipelinesOutput, bool) bool) error
	ListPipelinesPagesWithContext(aws.Context, *osis.ListPipelinesInput, func(*osis.ListPipelinesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*osis.ListTagsForResourceInput) (*osis.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *osis.ListTagsForResourceInput, ...request.Option) (*osis.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*osis.ListTagsForResourceInput) (*request.Request, *osis.ListTagsForResourceOutput)

	StartPipeline(*osis.StartPipelineInput) (*osis.StartPipelineOutput, error)
	StartPipelineWithContext(aws.Context, *osis.StartPipelineInput, ...request.Option) (*osis.StartPipelineOutput, error)
	StartPipelineRequest(*osis.StartPipelineInput) (*request.Request, *osis.StartPipelineOutput)

	StopPipeline(*osis.StopPipelineInput) (*osis.StopPipelineOutput, error)
	StopPipelineWithContext(aws.Context, *osis.StopPipelineInput, ...request.Option) (*osis.StopPipelineOutput, error)
	StopPipelineRequest(*osis.StopPipelineInput) (*request.Request, *osis.StopPipelineOutput)

	TagResource(*osis.TagResourceInput) (*osis.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *osis.TagResourceInput, ...request.Option) (*osis.TagResourceOutput, error)
	TagResourceRequest(*osis.TagResourceInput) (*request.Request, *osis.TagResourceOutput)

	UntagResource(*osis.UntagResourceInput) (*osis.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *osis.UntagResourceInput, ...request.Option) (*osis.UntagResourceOutput, error)
	UntagResourceRequest(*osis.UntagResourceInput) (*request.Request, *osis.UntagResourceOutput)

	UpdatePipeline(*osis.UpdatePipelineInput) (*osis.UpdatePipelineOutput, error)
	UpdatePipelineWithContext(aws.Context, *osis.UpdatePipelineInput, ...request.Option) (*osis.UpdatePipelineOutput, error)
	UpdatePipelineRequest(*osis.UpdatePipelineInput) (*request.Request, *osis.UpdatePipelineOutput)

	ValidatePipeline(*osis.ValidatePipelineInput) (*osis.ValidatePipelineOutput, error)
	ValidatePipelineWithContext(aws.Context, *osis.ValidatePipelineInput, ...request.Option) (*osis.ValidatePipelineOutput, error)
	ValidatePipelineRequest(*osis.ValidatePipelineInput) (*request.Request, *osis.ValidatePipelineOutput)
}

var _ OSISAPI = (*osis.OSIS)(nil)
