// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package firehose

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateDeliveryStream = "CreateDeliveryStream"

// CreateDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeliveryStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeliveryStream for more information on using the CreateDeliveryStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateDeliveryStreamRequest method.
//	req, resp := client.CreateDeliveryStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/CreateDeliveryStream
func (c *Firehose) CreateDeliveryStreamRequest(input *CreateDeliveryStreamInput) (req *request.Request, output *CreateDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opCreateDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDeliveryStreamInput{}
	}

	output = &CreateDeliveryStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Creates a Kinesis Data Firehose delivery stream.
//
// By default, you can create up to 50 delivery streams per Amazon Web Services
// Region.
//
// This is an asynchronous operation that immediately returns. The initial status
// of the delivery stream is CREATING. After the delivery stream is created,
// its status is ACTIVE and it now accepts data. If the delivery stream creation
// fails, the status transitions to CREATING_FAILED. Attempts to send data to
// a delivery stream that is not in the ACTIVE state cause an exception. To
// check the state of a delivery stream, use DescribeDeliveryStream.
//
// If the status of a delivery stream is CREATING_FAILED, this status doesn't
// change, and you can't invoke CreateDeliveryStream again on it. However, you
// can invoke the DeleteDeliveryStream operation to delete it.
//
// A Kinesis Data Firehose delivery stream can be configured to receive records
// directly from providers using PutRecord or PutRecordBatch, or it can be configured
// to use an existing Kinesis stream as its source. To specify a Kinesis data
// stream as input, set the DeliveryStreamType parameter to KinesisStreamAsSource,
// and provide the Kinesis stream Amazon Resource Name (ARN) and role ARN in
// the KinesisStreamSourceConfiguration parameter.
//
// To create a delivery stream with server-side encryption (SSE) enabled, include
// DeliveryStreamEncryptionConfigurationInput in your request. This is optional.
// You can also invoke StartDeliveryStreamEncryption to turn on SSE for an existing
// delivery stream that doesn't have SSE enabled.
//
// A delivery stream is configured with a single destination, such as Amazon
// Simple Storage Service (Amazon S3), Amazon Redshift, Amazon OpenSearch Service,
// Amazon OpenSearch Serverless, Splunk, and any custom HTTP endpoint or HTTP
// endpoints owned by or supported by third-party service providers, including
// Datadog, Dynatrace, LogicMonitor, MongoDB, New Relic, and Sumo Logic. You
// must specify only one of the following destination configuration parameters:
// ExtendedS3DestinationConfiguration, S3DestinationConfiguration, ElasticsearchDestinationConfiguration,
// RedshiftDestinationConfiguration, or SplunkDestinationConfiguration.
//
// When you specify S3DestinationConfiguration, you can also provide the following
// optional values: BufferingHints, EncryptionConfiguration, and CompressionFormat.
// By default, if no BufferingHints value is provided, Kinesis Data Firehose
// buffers data up to 5 MB or for 5 minutes, whichever condition is satisfied
// first. BufferingHints is a hint, so there are some cases where the service
// cannot adhere to these conditions strictly. For example, record boundaries
// might be such that the size is a little over or under the configured buffering
// size. By default, no encryption is performed. We strongly recommend that
// you enable encryption to ensure secure data storage in Amazon S3.
//
// A few notes about Amazon Redshift as a destination:
//
//   - An Amazon Redshift destination requires an S3 bucket as intermediate
//     location. Kinesis Data Firehose first delivers data to Amazon S3 and then
//     uses COPY syntax to load data into an Amazon Redshift table. This is specified
//     in the RedshiftDestinationConfiguration.S3Configuration parameter.
//
//   - The compression formats SNAPPY or ZIP cannot be specified in RedshiftDestinationConfiguration.S3Configuration
//     because the Amazon Redshift COPY operation that reads from the S3 bucket
//     doesn't support these compression formats.
//
//   - We strongly recommend that you use the user name and password you provide
//     exclusively with Kinesis Data Firehose, and that the permissions for the
//     account are restricted for Amazon Redshift INSERT permissions.
//
// Kinesis Data Firehose assumes the IAM role that is configured as part of
// the destination. The role should allow the Kinesis Data Firehose principal
// to assume the role, and the role should have permissions that allow the service
// to deliver the data. For more information, see Grant Kinesis Data Firehose
// Access to an Amazon S3 Destination (https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3)
// in the Amazon Kinesis Data Firehose Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation CreateDeliveryStream for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     The specified input parameter has a value that is not valid.
//
//   - LimitExceededException
//     You have already reached the limit for a requested resource.
//
//   - ResourceInUseException
//     The resource is already in use and not available for this operation.
//
//   - InvalidKMSResourceException
//     Kinesis Data Firehose throws this exception when an attempt to put records
//     or to start or stop delivery stream encryption fails. This happens when the
//     KMS service throws one of the following exception types: AccessDeniedException,
//     InvalidStateException, DisabledException, or NotFoundException.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/CreateDeliveryStream
func (c *Firehose) CreateDeliveryStream(input *CreateDeliveryStreamInput) (*CreateDeliveryStreamOutput, error) {
	req, out := c.CreateDeliveryStreamRequest(input)
	return out, req.Send()
}

// CreateDeliveryStreamWithContext is the same as CreateDeliveryStream with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeliveryStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) CreateDeliveryStreamWithContext(ctx aws.Context, input *CreateDeliveryStreamInput, opts ...request.Option) (*CreateDeliveryStreamOutput, error) {
	req, out := c.CreateDeliveryStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeliveryStream = "DeleteDeliveryStream"

// DeleteDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeliveryStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeliveryStream for more information on using the DeleteDeliveryStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteDeliveryStreamRequest method.
//	req, resp := client.DeleteDeliveryStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DeleteDeliveryStream
func (c *Firehose) DeleteDeliveryStreamRequest(input *DeleteDeliveryStreamInput) (req *request.Request, output *DeleteDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opDeleteDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteDeliveryStreamInput{}
	}

	output = &DeleteDeliveryStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Deletes a delivery stream and its data.
//
// To check the state of a delivery stream, use DescribeDeliveryStream. You
// can delete a delivery stream only if it is in one of the following states:
// ACTIVE, DELETING, CREATING_FAILED, or DELETING_FAILED. You can't delete a
// delivery stream that is in the CREATING state. While the deletion request
// is in process, the delivery stream is in the DELETING state.
//
// While the delivery stream is in the DELETING state, the service might continue
// to accept records, but it doesn't make any guarantees with respect to delivering
// the data. Therefore, as a best practice, first stop any applications that
// are sending records before you delete a delivery stream.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation DeleteDeliveryStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceInUseException
//     The resource is already in use and not available for this operation.
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DeleteDeliveryStream
func (c *Firehose) DeleteDeliveryStream(input *DeleteDeliveryStreamInput) (*DeleteDeliveryStreamOutput, error) {
	req, out := c.DeleteDeliveryStreamRequest(input)
	return out, req.Send()
}

// DeleteDeliveryStreamWithContext is the same as DeleteDeliveryStream with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeliveryStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) DeleteDeliveryStreamWithContext(ctx aws.Context, input *DeleteDeliveryStreamInput, opts ...request.Option) (*DeleteDeliveryStreamOutput, error) {
	req, out := c.DeleteDeliveryStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeliveryStream = "DescribeDeliveryStream"

// DescribeDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeliveryStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeliveryStream for more information on using the DescribeDeliveryStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeDeliveryStreamRequest method.
//	req, resp := client.DescribeDeliveryStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DescribeDeliveryStream
func (c *Firehose) DescribeDeliveryStreamRequest(input *DescribeDeliveryStreamInput) (req *request.Request, output *DescribeDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opDescribeDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeDeliveryStreamInput{}
	}

	output = &DescribeDeliveryStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Describes the specified delivery stream and its status. For example, after
// your delivery stream is created, call DescribeDeliveryStream to see whether
// the delivery stream is ACTIVE and therefore ready for data to be sent to
// it.
//
// If the status of a delivery stream is CREATING_FAILED, this status doesn't
// change, and you can't invoke CreateDeliveryStream again on it. However, you
// can invoke the DeleteDeliveryStream operation to delete it. If the status
// is DELETING_FAILED, you can force deletion by invoking DeleteDeliveryStream
// again but with DeleteDeliveryStreamInput$AllowForceDelete set to true.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation DescribeDeliveryStream for usage and error information.
//
// Returned Error Types:
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/DescribeDeliveryStream
func (c *Firehose) DescribeDeliveryStream(input *DescribeDeliveryStreamInput) (*DescribeDeliveryStreamOutput, error) {
	req, out := c.DescribeDeliveryStreamRequest(input)
	return out, req.Send()
}

// DescribeDeliveryStreamWithContext is the same as DescribeDeliveryStream with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeliveryStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) DescribeDeliveryStreamWithContext(ctx aws.Context, input *DescribeDeliveryStreamInput, opts ...request.Option) (*DescribeDeliveryStreamOutput, error) {
	req, out := c.DescribeDeliveryStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeliveryStreams = "ListDeliveryStreams"

// ListDeliveryStreamsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeliveryStreams operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeliveryStreams for more information on using the ListDeliveryStreams
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDeliveryStreamsRequest method.
//	req, resp := client.ListDeliveryStreamsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/ListDeliveryStreams
func (c *Firehose) ListDeliveryStreamsRequest(input *ListDeliveryStreamsInput) (req *request.Request, output *ListDeliveryStreamsOutput) {
	op := &request.Operation{
		Name:       opListDeliveryStreams,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDeliveryStreamsInput{}
	}

	output = &ListDeliveryStreamsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeliveryStreams API operation for Amazon Kinesis Firehose.
//
// Lists your delivery streams in alphabetical order of their names.
//
// The number of delivery streams might be too large to return using a single
// call to ListDeliveryStreams. You can limit the number of delivery streams
// returned, using the Limit parameter. To determine whether there are more
// delivery streams to list, check the value of HasMoreDeliveryStreams in the
// output. If there are more delivery streams to list, you can request them
// by calling this operation again and setting the ExclusiveStartDeliveryStreamName
// parameter to the name of the last delivery stream returned in the last call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation ListDeliveryStreams for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/ListDeliveryStreams
func (c *Firehose) ListDeliveryStreams(input *ListDeliveryStreamsInput) (*ListDeliveryStreamsOutput, error) {
	req, out := c.ListDeliveryStreamsRequest(input)
	return out, req.Send()
}

// ListDeliveryStreamsWithContext is the same as ListDeliveryStreams with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeliveryStreams for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) ListDeliveryStreamsWithContext(ctx aws.Context, input *ListDeliveryStreamsInput, opts ...request.Option) (*ListDeliveryStreamsOutput, error) {
	req, out := c.ListDeliveryStreamsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForDeliveryStream = "ListTagsForDeliveryStream"

// ListTagsForDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForDeliveryStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForDeliveryStream for more information on using the ListTagsForDeliveryStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForDeliveryStreamRequest method.
//	req, resp := client.ListTagsForDeliveryStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/ListTagsForDeliveryStream
func (c *Firehose) ListTagsForDeliveryStreamRequest(input *ListTagsForDeliveryStreamInput) (req *request.Request, output *ListTagsForDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opListTagsForDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForDeliveryStreamInput{}
	}

	output = &ListTagsForDeliveryStreamOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Lists the tags for the specified delivery stream. This operation has a limit
// of five transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation ListTagsForDeliveryStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - InvalidArgumentException
//     The specified input parameter has a value that is not valid.
//
//   - LimitExceededException
//     You have already reached the limit for a requested resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/ListTagsForDeliveryStream
func (c *Firehose) ListTagsForDeliveryStream(input *ListTagsForDeliveryStreamInput) (*ListTagsForDeliveryStreamOutput, error) {
	req, out := c.ListTagsForDeliveryStreamRequest(input)
	return out, req.Send()
}

// ListTagsForDeliveryStreamWithContext is the same as ListTagsForDeliveryStream with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForDeliveryStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) ListTagsForDeliveryStreamWithContext(ctx aws.Context, input *ListTagsForDeliveryStreamInput, opts ...request.Option) (*ListTagsForDeliveryStreamOutput, error) {
	req, out := c.ListTagsForDeliveryStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecord = "PutRecord"

// PutRecordRequest generates a "aws/request.Request" representing the
// client's request for the PutRecord operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRecord for more information on using the PutRecord
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRecordRequest method.
//	req, resp := client.PutRecordRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/PutRecord
func (c *Firehose) PutRecordRequest(input *PutRecordInput) (req *request.Request, output *PutRecordOutput) {
	op := &request.Operation{
		Name:       opPutRecord,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordInput{}
	}

	output = &PutRecordOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRecord API operation for Amazon Kinesis Firehose.
//
// Writes a single data record into an Amazon Kinesis Data Firehose delivery
// stream. To write multiple data records into a delivery stream, use PutRecordBatch.
// Applications using these operations are referred to as producers.
//
// By default, each delivery stream can take in up to 2,000 transactions per
// second, 5,000 records per second, or 5 MB per second. If you use PutRecord
// and PutRecordBatch, the limits are an aggregate across these two operations
// for each delivery stream. For more information about limits and how to request
// an increase, see Amazon Kinesis Data Firehose Limits (https://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// You must specify the name of the delivery stream and the data record when
// using PutRecord. The data record consists of a data blob that can be up to
// 1,000 KiB in size, and any kind of data. For example, it can be a segment
// from a log file, geographic location data, website clickstream data, and
// so on.
//
// Kinesis Data Firehose buffers records before delivering them to the destination.
// To disambiguate the data blobs at the destination, a common solution is to
// use delimiters in the data, such as a newline (\n) or some other character
// unique within the data. This allows the consumer application to parse individual
// data items when reading the data from the destination.
//
// The PutRecord operation returns a RecordId, which is a unique string assigned
// to each record. Producer applications can use this ID for purposes such as
// auditability and investigation.
//
// If the PutRecord operation throws a ServiceUnavailableException, back off
// and retry. If the exception persists, it is possible that the throughput
// limits have been exceeded for the delivery stream.
//
// Data records sent to Kinesis Data Firehose are stored for 24 hours from the
// time they are added to a delivery stream as it tries to send the records
// to the destination. If the destination is unreachable for more than 24 hours,
// the data is no longer available.
//
// Don't concatenate two or more base64 strings to form the data fields of your
// records. Instead, concatenate the raw data, then perform base64 encoding.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation PutRecord for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - InvalidArgumentException
//     The specified input parameter has a value that is not valid.
//
//   - InvalidKMSResourceException
//     Kinesis Data Firehose throws this exception when an attempt to put records
//     or to start or stop delivery stream encryption fails. This happens when the
//     KMS service throws one of the following exception types: AccessDeniedException,
//     InvalidStateException, DisabledException, or NotFoundException.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation. If you continue
//     to see the exception, throughput limits for the delivery stream may have
//     been exceeded. For more information about limits and how to request an increase,
//     see Amazon Kinesis Data Firehose Limits (https://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/PutRecord
func (c *Firehose) PutRecord(input *PutRecordInput) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	return out, req.Send()
}

// PutRecordWithContext is the same as PutRecord with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecord for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) PutRecordWithContext(ctx aws.Context, input *PutRecordInput, opts ...request.Option) (*PutRecordOutput, error) {
	req, out := c.PutRecordRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRecordBatch = "PutRecordBatch"

// PutRecordBatchRequest generates a "aws/request.Request" representing the
// client's request for the PutRecordBatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRecordBatch for more information on using the PutRecordBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutRecordBatchRequest method.
//	req, resp := client.PutRecordBatchRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/PutRecordBatch
func (c *Firehose) PutRecordBatchRequest(input *PutRecordBatchInput) (req *request.Request, output *PutRecordBatchOutput) {
	op := &request.Operation{
		Name:       opPutRecordBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutRecordBatchInput{}
	}

	output = &PutRecordBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutRecordBatch API operation for Amazon Kinesis Firehose.
//
// Writes multiple data records into a delivery stream in a single call, which
// can achieve higher throughput per producer than when writing single records.
// To write single data records into a delivery stream, use PutRecord. Applications
// using these operations are referred to as producers.
//
// For information about service quota, see Amazon Kinesis Data Firehose Quota
// (https://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// Each PutRecordBatch request supports up to 500 records. Each record in the
// request can be as large as 1,000 KB (before base64 encoding), up to a limit
// of 4 MB for the entire request. These limits cannot be changed.
//
// You must specify the name of the delivery stream and the data record when
// using PutRecord. The data record consists of a data blob that can be up to
// 1,000 KB in size, and any kind of data. For example, it could be a segment
// from a log file, geographic location data, website clickstream data, and
// so on.
//
// Kinesis Data Firehose buffers records before delivering them to the destination.
// To disambiguate the data blobs at the destination, a common solution is to
// use delimiters in the data, such as a newline (\n) or some other character
// unique within the data. This allows the consumer application to parse individual
// data items when reading the data from the destination.
//
// The PutRecordBatch response includes a count of failed records, FailedPutCount,
// and an array of responses, RequestResponses. Even if the PutRecordBatch call
// succeeds, the value of FailedPutCount may be greater than 0, indicating that
// there are records for which the operation didn't succeed. Each entry in the
// RequestResponses array provides additional information about the processed
// record. It directly correlates with a record in the request array using the
// same ordering, from the top to the bottom. The response array always includes
// the same number of records as the request array. RequestResponses includes
// both successfully and unsuccessfully processed records. Kinesis Data Firehose
// tries to process all records in each PutRecordBatch request. A single record
// failure does not stop the processing of subsequent records.
//
// A successfully processed record includes a RecordId value, which is unique
// for the record. An unsuccessfully processed record includes ErrorCode and
// ErrorMessage values. ErrorCode reflects the type of error, and is one of
// the following values: ServiceUnavailableException or InternalFailure. ErrorMessage
// provides more detailed information about the error.
//
// If there is an internal server error or a timeout, the write might have completed
// or it might have failed. If FailedPutCount is greater than 0, retry the request,
// resending only those records that might have failed processing. This minimizes
// the possible duplicate records and also reduces the total bytes sent (and
// corresponding charges). We recommend that you handle any duplicates at the
// destination.
//
// If PutRecordBatch throws ServiceUnavailableException, back off and retry.
// If the exception persists, it is possible that the throughput limits have
// been exceeded for the delivery stream.
//
// Data records sent to Kinesis Data Firehose are stored for 24 hours from the
// time they are added to a delivery stream as it attempts to send the records
// to the destination. If the destination is unreachable for more than 24 hours,
// the data is no longer available.
//
// Don't concatenate two or more base64 strings to form the data fields of your
// records. Instead, concatenate the raw data, then perform base64 encoding.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation PutRecordBatch for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - InvalidArgumentException
//     The specified input parameter has a value that is not valid.
//
//   - InvalidKMSResourceException
//     Kinesis Data Firehose throws this exception when an attempt to put records
//     or to start or stop delivery stream encryption fails. This happens when the
//     KMS service throws one of the following exception types: AccessDeniedException,
//     InvalidStateException, DisabledException, or NotFoundException.
//
//   - ServiceUnavailableException
//     The service is unavailable. Back off and retry the operation. If you continue
//     to see the exception, throughput limits for the delivery stream may have
//     been exceeded. For more information about limits and how to request an increase,
//     see Amazon Kinesis Data Firehose Limits (https://docs.aws.amazon.com/firehose/latest/dev/limits.html).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/PutRecordBatch
func (c *Firehose) PutRecordBatch(input *PutRecordBatchInput) (*PutRecordBatchOutput, error) {
	req, out := c.PutRecordBatchRequest(input)
	return out, req.Send()
}

// PutRecordBatchWithContext is the same as PutRecordBatch with the addition of
// the ability to pass a context and additional request options.
//
// See PutRecordBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) PutRecordBatchWithContext(ctx aws.Context, input *PutRecordBatchInput, opts ...request.Option) (*PutRecordBatchOutput, error) {
	req, out := c.PutRecordBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDeliveryStreamEncryption = "StartDeliveryStreamEncryption"

// StartDeliveryStreamEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the StartDeliveryStreamEncryption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDeliveryStreamEncryption for more information on using the StartDeliveryStreamEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDeliveryStreamEncryptionRequest method.
//	req, resp := client.StartDeliveryStreamEncryptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/StartDeliveryStreamEncryption
func (c *Firehose) StartDeliveryStreamEncryptionRequest(input *StartDeliveryStreamEncryptionInput) (req *request.Request, output *StartDeliveryStreamEncryptionOutput) {
	op := &request.Operation{
		Name:       opStartDeliveryStreamEncryption,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDeliveryStreamEncryptionInput{}
	}

	output = &StartDeliveryStreamEncryptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartDeliveryStreamEncryption API operation for Amazon Kinesis Firehose.
//
// Enables server-side encryption (SSE) for the delivery stream.
//
// This operation is asynchronous. It returns immediately. When you invoke it,
// Kinesis Data Firehose first sets the encryption status of the stream to ENABLING,
// and then to ENABLED. The encryption status of a delivery stream is the Status
// property in DeliveryStreamEncryptionConfiguration. If the operation fails,
// the encryption status changes to ENABLING_FAILED. You can continue to read
// and write data to your delivery stream while the encryption status is ENABLING,
// but the data is not encrypted. It can take up to 5 seconds after the encryption
// status changes to ENABLED before all records written to the delivery stream
// are encrypted. To find out whether a record or a batch of records was encrypted,
// check the response elements PutRecordOutput$Encrypted and PutRecordBatchOutput$Encrypted,
// respectively.
//
// To check the encryption status of a delivery stream, use DescribeDeliveryStream.
//
// Even if encryption is currently enabled for a delivery stream, you can still
// invoke this operation on it to change the ARN of the CMK or both its type
// and ARN. If you invoke this method to change the CMK, and the old CMK is
// of type CUSTOMER_MANAGED_CMK, Kinesis Data Firehose schedules the grant it
// had on the old CMK for retirement. If the new CMK is of type CUSTOMER_MANAGED_CMK,
// Kinesis Data Firehose creates a grant that enables it to use the new CMK
// to encrypt and decrypt data and to manage the grant.
//
// If a delivery stream already has encryption enabled and then you invoke this
// operation to change the ARN of the CMK or both its type and ARN and you get
// ENABLING_FAILED, this only means that the attempt to change the CMK failed.
// In this case, encryption remains enabled with the old CMK.
//
// If the encryption status of your delivery stream is ENABLING_FAILED, you
// can invoke this operation again with a valid CMK. The CMK must be enabled
// and the key policy mustn't explicitly deny the permission for Kinesis Data
// Firehose to invoke KMS encrypt and decrypt operations.
//
// You can enable SSE for a delivery stream only if it's a delivery stream that
// uses DirectPut as its source.
//
// The StartDeliveryStreamEncryption and StopDeliveryStreamEncryption operations
// have a combined limit of 25 calls per delivery stream per 24 hours. For example,
// you reach the limit if you call StartDeliveryStreamEncryption 13 times and
// StopDeliveryStreamEncryption 12 times for the same delivery stream in a 24-hour
// period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation StartDeliveryStreamEncryption for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ResourceInUseException
//     The resource is already in use and not available for this operation.
//
//   - InvalidArgumentException
//     The specified input parameter has a value that is not valid.
//
//   - LimitExceededException
//     You have already reached the limit for a requested resource.
//
//   - InvalidKMSResourceException
//     Kinesis Data Firehose throws this exception when an attempt to put records
//     or to start or stop delivery stream encryption fails. This happens when the
//     KMS service throws one of the following exception types: AccessDeniedException,
//     InvalidStateException, DisabledException, or NotFoundException.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/StartDeliveryStreamEncryption
func (c *Firehose) StartDeliveryStreamEncryption(input *StartDeliveryStreamEncryptionInput) (*StartDeliveryStreamEncryptionOutput, error) {
	req, out := c.StartDeliveryStreamEncryptionRequest(input)
	return out, req.Send()
}

// StartDeliveryStreamEncryptionWithContext is the same as StartDeliveryStreamEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See StartDeliveryStreamEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) StartDeliveryStreamEncryptionWithContext(ctx aws.Context, input *StartDeliveryStreamEncryptionInput, opts ...request.Option) (*StartDeliveryStreamEncryptionOutput, error) {
	req, out := c.StartDeliveryStreamEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopDeliveryStreamEncryption = "StopDeliveryStreamEncryption"

// StopDeliveryStreamEncryptionRequest generates a "aws/request.Request" representing the
// client's request for the StopDeliveryStreamEncryption operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopDeliveryStreamEncryption for more information on using the StopDeliveryStreamEncryption
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopDeliveryStreamEncryptionRequest method.
//	req, resp := client.StopDeliveryStreamEncryptionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/StopDeliveryStreamEncryption
func (c *Firehose) StopDeliveryStreamEncryptionRequest(input *StopDeliveryStreamEncryptionInput) (req *request.Request, output *StopDeliveryStreamEncryptionOutput) {
	op := &request.Operation{
		Name:       opStopDeliveryStreamEncryption,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopDeliveryStreamEncryptionInput{}
	}

	output = &StopDeliveryStreamEncryptionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopDeliveryStreamEncryption API operation for Amazon Kinesis Firehose.
//
// Disables server-side encryption (SSE) for the delivery stream.
//
// This operation is asynchronous. It returns immediately. When you invoke it,
// Kinesis Data Firehose first sets the encryption status of the stream to DISABLING,
// and then to DISABLED. You can continue to read and write data to your stream
// while its status is DISABLING. It can take up to 5 seconds after the encryption
// status changes to DISABLED before all records written to the delivery stream
// are no longer subject to encryption. To find out whether a record or a batch
// of records was encrypted, check the response elements PutRecordOutput$Encrypted
// and PutRecordBatchOutput$Encrypted, respectively.
//
// To check the encryption state of a delivery stream, use DescribeDeliveryStream.
//
// If SSE is enabled using a customer managed CMK and then you invoke StopDeliveryStreamEncryption,
// Kinesis Data Firehose schedules the related KMS grant for retirement and
// then retires it after it ensures that it is finished delivering records to
// the destination.
//
// The StartDeliveryStreamEncryption and StopDeliveryStreamEncryption operations
// have a combined limit of 25 calls per delivery stream per 24 hours. For example,
// you reach the limit if you call StartDeliveryStreamEncryption 13 times and
// StopDeliveryStreamEncryption 12 times for the same delivery stream in a 24-hour
// period.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation StopDeliveryStreamEncryption for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ResourceInUseException
//     The resource is already in use and not available for this operation.
//
//   - InvalidArgumentException
//     The specified input parameter has a value that is not valid.
//
//   - LimitExceededException
//     You have already reached the limit for a requested resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/StopDeliveryStreamEncryption
func (c *Firehose) StopDeliveryStreamEncryption(input *StopDeliveryStreamEncryptionInput) (*StopDeliveryStreamEncryptionOutput, error) {
	req, out := c.StopDeliveryStreamEncryptionRequest(input)
	return out, req.Send()
}

// StopDeliveryStreamEncryptionWithContext is the same as StopDeliveryStreamEncryption with the addition of
// the ability to pass a context and additional request options.
//
// See StopDeliveryStreamEncryption for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) StopDeliveryStreamEncryptionWithContext(ctx aws.Context, input *StopDeliveryStreamEncryptionInput, opts ...request.Option) (*StopDeliveryStreamEncryptionOutput, error) {
	req, out := c.StopDeliveryStreamEncryptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagDeliveryStream = "TagDeliveryStream"

// TagDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the TagDeliveryStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagDeliveryStream for more information on using the TagDeliveryStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagDeliveryStreamRequest method.
//	req, resp := client.TagDeliveryStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/TagDeliveryStream
func (c *Firehose) TagDeliveryStreamRequest(input *TagDeliveryStreamInput) (req *request.Request, output *TagDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opTagDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagDeliveryStreamInput{}
	}

	output = &TagDeliveryStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Adds or updates tags for the specified delivery stream. A tag is a key-value
// pair that you can define and assign to Amazon Web Services resources. If
// you specify a tag that already exists, the tag value is replaced with the
// value that you specify in the request. Tags are metadata. For example, you
// can add friendly names and descriptions or other types of information that
// can help you distinguish the delivery stream. For more information about
// tags, see Using Cost Allocation Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
// in the Amazon Web Services Billing and Cost Management User Guide.
//
// Each delivery stream can have up to 50 tags.
//
// This operation has a limit of five transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation TagDeliveryStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ResourceInUseException
//     The resource is already in use and not available for this operation.
//
//   - InvalidArgumentException
//     The specified input parameter has a value that is not valid.
//
//   - LimitExceededException
//     You have already reached the limit for a requested resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/TagDeliveryStream
func (c *Firehose) TagDeliveryStream(input *TagDeliveryStreamInput) (*TagDeliveryStreamOutput, error) {
	req, out := c.TagDeliveryStreamRequest(input)
	return out, req.Send()
}

// TagDeliveryStreamWithContext is the same as TagDeliveryStream with the addition of
// the ability to pass a context and additional request options.
//
// See TagDeliveryStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) TagDeliveryStreamWithContext(ctx aws.Context, input *TagDeliveryStreamInput, opts ...request.Option) (*TagDeliveryStreamOutput, error) {
	req, out := c.TagDeliveryStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagDeliveryStream = "UntagDeliveryStream"

// UntagDeliveryStreamRequest generates a "aws/request.Request" representing the
// client's request for the UntagDeliveryStream operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagDeliveryStream for more information on using the UntagDeliveryStream
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagDeliveryStreamRequest method.
//	req, resp := client.UntagDeliveryStreamRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/UntagDeliveryStream
func (c *Firehose) UntagDeliveryStreamRequest(input *UntagDeliveryStreamInput) (req *request.Request, output *UntagDeliveryStreamOutput) {
	op := &request.Operation{
		Name:       opUntagDeliveryStream,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagDeliveryStreamInput{}
	}

	output = &UntagDeliveryStreamOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagDeliveryStream API operation for Amazon Kinesis Firehose.
//
// Removes tags from the specified delivery stream. Removed tags are deleted,
// and you can't recover them after this operation successfully completes.
//
// If you specify a tag that doesn't exist, the operation ignores it.
//
// This operation has a limit of five transactions per second per account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation UntagDeliveryStream for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ResourceInUseException
//     The resource is already in use and not available for this operation.
//
//   - InvalidArgumentException
//     The specified input parameter has a value that is not valid.
//
//   - LimitExceededException
//     You have already reached the limit for a requested resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/UntagDeliveryStream
func (c *Firehose) UntagDeliveryStream(input *UntagDeliveryStreamInput) (*UntagDeliveryStreamOutput, error) {
	req, out := c.UntagDeliveryStreamRequest(input)
	return out, req.Send()
}

// UntagDeliveryStreamWithContext is the same as UntagDeliveryStream with the addition of
// the ability to pass a context and additional request options.
//
// See UntagDeliveryStream for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) UntagDeliveryStreamWithContext(ctx aws.Context, input *UntagDeliveryStreamInput, opts ...request.Option) (*UntagDeliveryStreamOutput, error) {
	req, out := c.UntagDeliveryStreamRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDestination = "UpdateDestination"

// UpdateDestinationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDestination operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDestination for more information on using the UpdateDestination
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateDestinationRequest method.
//	req, resp := client.UpdateDestinationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/UpdateDestination
func (c *Firehose) UpdateDestinationRequest(input *UpdateDestinationInput) (req *request.Request, output *UpdateDestinationOutput) {
	op := &request.Operation{
		Name:       opUpdateDestination,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDestinationInput{}
	}

	output = &UpdateDestinationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDestination API operation for Amazon Kinesis Firehose.
//
// Updates the specified destination of the specified delivery stream.
//
// Use this operation to change the destination type (for example, to replace
// the Amazon S3 destination with Amazon Redshift) or change the parameters
// associated with a destination (for example, to change the bucket name of
// the Amazon S3 destination). The update might not occur immediately. The target
// delivery stream remains active while the configurations are updated, so data
// writes to the delivery stream can continue during this process. The updated
// configurations are usually effective within a few minutes.
//
// Switching between Amazon OpenSearch Service and other services is not supported.
// For an Amazon OpenSearch Service destination, you can only update to another
// Amazon OpenSearch Service destination.
//
// If the destination type is the same, Kinesis Data Firehose merges the configuration
// parameters specified with the destination configuration that already exists
// on the delivery stream. If any of the parameters are not specified in the
// call, the existing values are retained. For example, in the Amazon S3 destination,
// if EncryptionConfiguration is not specified, then the existing EncryptionConfiguration
// is maintained on the destination.
//
// If the destination type is not the same, for example, changing the destination
// from Amazon S3 to Amazon Redshift, Kinesis Data Firehose does not merge any
// parameters. In this case, all parameters must be specified.
//
// Kinesis Data Firehose uses CurrentDeliveryStreamVersionId to avoid race conditions
// and conflicting merges. This is a required field, and the service updates
// the configuration only if the existing configuration has a version ID that
// matches. After the update is applied successfully, the version ID is updated,
// and can be retrieved using DescribeDeliveryStream. Use the new version ID
// to set CurrentDeliveryStreamVersionId in the next call.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Kinesis Firehose's
// API operation UpdateDestination for usage and error information.
//
// Returned Error Types:
//
//   - InvalidArgumentException
//     The specified input parameter has a value that is not valid.
//
//   - ResourceInUseException
//     The resource is already in use and not available for this operation.
//
//   - ResourceNotFoundException
//     The specified resource could not be found.
//
//   - ConcurrentModificationException
//     Another modification has already happened. Fetch VersionId again and use
//     it to update the destination.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/firehose-2015-08-04/UpdateDestination
func (c *Firehose) UpdateDestination(input *UpdateDestinationInput) (*UpdateDestinationOutput, error) {
	req, out := c.UpdateDestinationRequest(input)
	return out, req.Send()
}

// UpdateDestinationWithContext is the same as UpdateDestination with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDestination for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Firehose) UpdateDestinationWithContext(ctx aws.Context, input *UpdateDestinationInput, opts ...request.Option) (*UpdateDestinationOutput, error) {
	req, out := c.UpdateDestinationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Describes the buffering to perform before delivering data to the Serverless
// offering for Amazon OpenSearch Service destination.
type AmazonOpenSearchServerlessBufferingHints struct {
	_ struct{} `type:"structure"`

	// Buffer incoming data for the specified period of time, in seconds, before
	// delivering it to the destination. The default value is 300 (5 minutes).
	IntervalInSeconds *int64 `min:"60" type:"integer"`

	// Buffer incoming data to the specified size, in MBs, before delivering it
	// to the destination. The default value is 5.
	//
	// We recommend setting this parameter to a value greater than the amount of
	// data you typically ingest into the delivery stream in 10 seconds. For example,
	// if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
	SizeInMBs *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchServerlessBufferingHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchServerlessBufferingHints) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonOpenSearchServerlessBufferingHints) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonOpenSearchServerlessBufferingHints"}
	if s.IntervalInSeconds != nil && *s.IntervalInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalInSeconds", 60))
	}
	if s.SizeInMBs != nil && *s.SizeInMBs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SizeInMBs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntervalInSeconds sets the IntervalInSeconds field's value.
func (s *AmazonOpenSearchServerlessBufferingHints) SetIntervalInSeconds(v int64) *AmazonOpenSearchServerlessBufferingHints {
	s.IntervalInSeconds = &v
	return s
}

// SetSizeInMBs sets the SizeInMBs field's value.
func (s *AmazonOpenSearchServerlessBufferingHints) SetSizeInMBs(v int64) *AmazonOpenSearchServerlessBufferingHints {
	s.SizeInMBs = &v
	return s
}

// Describes the configuration of a destination in the Serverless offering for
// Amazon OpenSearch Service.
type AmazonOpenSearchServerlessDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints
	// are used.
	BufferingHints *AmazonOpenSearchServerlessBufferingHints `type:"structure"`

	// Describes the Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The endpoint to use when communicating with the collection in the Serverless
	// offering for Amazon OpenSearch Service.
	CollectionEndpoint *string `min:"1" type:"string"`

	// The Serverless offering for Amazon OpenSearch Service index name.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// Describes a data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver documents
	// to the Serverless offering for Amazon OpenSearch Service. The default value
	// is 300 (5 minutes).
	RetryOptions *AmazonOpenSearchServerlessRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data
	// Firehose for calling the Serverless offering for Amazon OpenSearch Service
	// Configuration API and for indexing documents.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// Defines how documents should be delivered to Amazon S3. When it is set to
	// FailedDocumentsOnly, Kinesis Data Firehose writes any documents that could
	// not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/
	// appended to the key prefix. When set to AllDocuments, Kinesis Data Firehose
	// delivers all incoming records to Amazon S3, and also writes failed documents
	// with AmazonOpenSearchService-failed/ appended to the prefix.
	S3BackupMode *string `type:"string" enum:"AmazonOpenSearchServerlessS3BackupMode"`

	// Describes the configuration of a destination in Amazon S3.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`

	// The details of the VPC of the Amazon OpenSearch or Amazon OpenSearch Serverless
	// destination.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchServerlessDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchServerlessDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonOpenSearchServerlessDestinationConfiguration"}
	if s.CollectionEndpoint != nil && len(*s.CollectionEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionEndpoint", 1))
	}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) SetBufferingHints(v *AmazonOpenSearchServerlessBufferingHints) *AmazonOpenSearchServerlessDestinationConfiguration {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *AmazonOpenSearchServerlessDestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCollectionEndpoint sets the CollectionEndpoint field's value.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) SetCollectionEndpoint(v string) *AmazonOpenSearchServerlessDestinationConfiguration {
	s.CollectionEndpoint = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) SetIndexName(v string) *AmazonOpenSearchServerlessDestinationConfiguration {
	s.IndexName = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *AmazonOpenSearchServerlessDestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) SetRetryOptions(v *AmazonOpenSearchServerlessRetryOptions) *AmazonOpenSearchServerlessDestinationConfiguration {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) SetRoleARN(v string) *AmazonOpenSearchServerlessDestinationConfiguration {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) SetS3BackupMode(v string) *AmazonOpenSearchServerlessDestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) SetS3Configuration(v *S3DestinationConfiguration) *AmazonOpenSearchServerlessDestinationConfiguration {
	s.S3Configuration = v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *AmazonOpenSearchServerlessDestinationConfiguration) SetVpcConfiguration(v *VpcConfiguration) *AmazonOpenSearchServerlessDestinationConfiguration {
	s.VpcConfiguration = v
	return s
}

// The destination description in the Serverless offering for Amazon OpenSearch
// Service.
type AmazonOpenSearchServerlessDestinationDescription struct {
	_ struct{} `type:"structure"`

	// The buffering options.
	BufferingHints *AmazonOpenSearchServerlessBufferingHints `type:"structure"`

	// Describes the Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The endpoint to use when communicating with the collection in the Serverless
	// offering for Amazon OpenSearch Service.
	CollectionEndpoint *string `min:"1" type:"string"`

	// The Serverless offering for Amazon OpenSearch Service index name.
	IndexName *string `min:"1" type:"string"`

	// Describes a data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The Serverless offering for Amazon OpenSearch Service retry options.
	RetryOptions *AmazonOpenSearchServerlessRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials.
	RoleARN *string `min:"1" type:"string"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"AmazonOpenSearchServerlessS3BackupMode"`

	// Describes a destination in Amazon S3.
	S3DestinationDescription *S3DestinationDescription `type:"structure"`

	// The details of the VPC of the Amazon ES destination.
	VpcConfigurationDescription *VpcConfigurationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchServerlessDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchServerlessDestinationDescription) GoString() string {
	return s.String()
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *AmazonOpenSearchServerlessDestinationDescription) SetBufferingHints(v *AmazonOpenSearchServerlessBufferingHints) *AmazonOpenSearchServerlessDestinationDescription {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *AmazonOpenSearchServerlessDestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *AmazonOpenSearchServerlessDestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCollectionEndpoint sets the CollectionEndpoint field's value.
func (s *AmazonOpenSearchServerlessDestinationDescription) SetCollectionEndpoint(v string) *AmazonOpenSearchServerlessDestinationDescription {
	s.CollectionEndpoint = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AmazonOpenSearchServerlessDestinationDescription) SetIndexName(v string) *AmazonOpenSearchServerlessDestinationDescription {
	s.IndexName = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *AmazonOpenSearchServerlessDestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *AmazonOpenSearchServerlessDestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *AmazonOpenSearchServerlessDestinationDescription) SetRetryOptions(v *AmazonOpenSearchServerlessRetryOptions) *AmazonOpenSearchServerlessDestinationDescription {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *AmazonOpenSearchServerlessDestinationDescription) SetRoleARN(v string) *AmazonOpenSearchServerlessDestinationDescription {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *AmazonOpenSearchServerlessDestinationDescription) SetS3BackupMode(v string) *AmazonOpenSearchServerlessDestinationDescription {
	s.S3BackupMode = &v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *AmazonOpenSearchServerlessDestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *AmazonOpenSearchServerlessDestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// SetVpcConfigurationDescription sets the VpcConfigurationDescription field's value.
func (s *AmazonOpenSearchServerlessDestinationDescription) SetVpcConfigurationDescription(v *VpcConfigurationDescription) *AmazonOpenSearchServerlessDestinationDescription {
	s.VpcConfigurationDescription = v
	return s
}

// Describes an update for a destination in the Serverless offering for Amazon
// OpenSearch Service.
type AmazonOpenSearchServerlessDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The buffering options. If no value is specified, AmazonopensearchBufferingHints
	// object default values are used.
	BufferingHints *AmazonOpenSearchServerlessBufferingHints `type:"structure"`

	// Describes the Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The endpoint to use when communicating with the collection in the Serverless
	// offering for Amazon OpenSearch Service.
	CollectionEndpoint *string `min:"1" type:"string"`

	// The Serverless offering for Amazon OpenSearch Service index name.
	IndexName *string `min:"1" type:"string"`

	// Describes a data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver documents
	// to the Serverless offering for Amazon OpenSearch Service. The default value
	// is 300 (5 minutes).
	RetryOptions *AmazonOpenSearchServerlessRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data
	// Firehose for calling the Serverless offering for Amazon OpenSearch Service
	// Configuration API and for indexing documents.
	RoleARN *string `min:"1" type:"string"`

	// Describes an update for a destination in Amazon S3.
	S3Update *S3DestinationUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchServerlessDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchServerlessDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonOpenSearchServerlessDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonOpenSearchServerlessDestinationUpdate"}
	if s.CollectionEndpoint != nil && len(*s.CollectionEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CollectionEndpoint", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *AmazonOpenSearchServerlessDestinationUpdate) SetBufferingHints(v *AmazonOpenSearchServerlessBufferingHints) *AmazonOpenSearchServerlessDestinationUpdate {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *AmazonOpenSearchServerlessDestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *AmazonOpenSearchServerlessDestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCollectionEndpoint sets the CollectionEndpoint field's value.
func (s *AmazonOpenSearchServerlessDestinationUpdate) SetCollectionEndpoint(v string) *AmazonOpenSearchServerlessDestinationUpdate {
	s.CollectionEndpoint = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AmazonOpenSearchServerlessDestinationUpdate) SetIndexName(v string) *AmazonOpenSearchServerlessDestinationUpdate {
	s.IndexName = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *AmazonOpenSearchServerlessDestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *AmazonOpenSearchServerlessDestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *AmazonOpenSearchServerlessDestinationUpdate) SetRetryOptions(v *AmazonOpenSearchServerlessRetryOptions) *AmazonOpenSearchServerlessDestinationUpdate {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *AmazonOpenSearchServerlessDestinationUpdate) SetRoleARN(v string) *AmazonOpenSearchServerlessDestinationUpdate {
	s.RoleARN = &v
	return s
}

// SetS3Update sets the S3Update field's value.
func (s *AmazonOpenSearchServerlessDestinationUpdate) SetS3Update(v *S3DestinationUpdate) *AmazonOpenSearchServerlessDestinationUpdate {
	s.S3Update = v
	return s
}

// Configures retry behavior in case Kinesis Data Firehose is unable to deliver
// documents to the Serverless offering for Amazon OpenSearch Service.
type AmazonOpenSearchServerlessRetryOptions struct {
	_ struct{} `type:"structure"`

	// After an initial failure to deliver to the Serverless offering for Amazon
	// OpenSearch Service, the total amount of time during which Kinesis Data Firehose
	// retries delivery (including the first attempt). After this time has elapsed,
	// the failed documents are written to Amazon S3. Default value is 300 seconds
	// (5 minutes). A value of 0 (zero) results in no retries.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchServerlessRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonOpenSearchServerlessRetryOptions) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *AmazonOpenSearchServerlessRetryOptions) SetDurationInSeconds(v int64) *AmazonOpenSearchServerlessRetryOptions {
	s.DurationInSeconds = &v
	return s
}

// Describes the buffering to perform before delivering data to the Amazon OpenSearch
// Service destination.
type AmazonopensearchserviceBufferingHints struct {
	_ struct{} `type:"structure"`

	// Buffer incoming data for the specified period of time, in seconds, before
	// delivering it to the destination. The default value is 300 (5 minutes).
	IntervalInSeconds *int64 `min:"60" type:"integer"`

	// Buffer incoming data to the specified size, in MBs, before delivering it
	// to the destination. The default value is 5.
	//
	// We recommend setting this parameter to a value greater than the amount of
	// data you typically ingest into the delivery stream in 10 seconds. For example,
	// if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
	SizeInMBs *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonopensearchserviceBufferingHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonopensearchserviceBufferingHints) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonopensearchserviceBufferingHints) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonopensearchserviceBufferingHints"}
	if s.IntervalInSeconds != nil && *s.IntervalInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalInSeconds", 60))
	}
	if s.SizeInMBs != nil && *s.SizeInMBs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SizeInMBs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntervalInSeconds sets the IntervalInSeconds field's value.
func (s *AmazonopensearchserviceBufferingHints) SetIntervalInSeconds(v int64) *AmazonopensearchserviceBufferingHints {
	s.IntervalInSeconds = &v
	return s
}

// SetSizeInMBs sets the SizeInMBs field's value.
func (s *AmazonopensearchserviceBufferingHints) SetSizeInMBs(v int64) *AmazonopensearchserviceBufferingHints {
	s.SizeInMBs = &v
	return s
}

// Describes the configuration of a destination in Amazon OpenSearch Service
type AmazonopensearchserviceDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The buffering options. If no value is specified, the default values for AmazonopensearchserviceBufferingHints
	// are used.
	BufferingHints *AmazonopensearchserviceBufferingHints `type:"structure"`

	// Describes the Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The endpoint to use when communicating with the cluster. Specify either this
	// ClusterEndpoint or the DomainARN field.
	ClusterEndpoint *string `min:"1" type:"string"`

	// Indicates the method for setting up document ID. The supported methods are
	// Kinesis Data Firehose generated document ID and OpenSearch Service generated
	// document ID.
	DocumentIdOptions *DocumentIdOptions `type:"structure"`

	// The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions
	// for DescribeElasticsearchDomain, DescribeElasticsearchDomains, and DescribeElasticsearchDomainConfig
	// after assuming the role specified in RoleARN.
	DomainARN *string `min:"1" type:"string"`

	// The ElasticsearAmazon OpenSearch Service index name.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// The Amazon OpenSearch Service index rotation period. Index rotation appends
	// a timestamp to the IndexName to facilitate the expiration of old data.
	IndexRotationPeriod *string `type:"string" enum:"AmazonopensearchserviceIndexRotationPeriod"`

	// Describes a data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver documents
	// to Amazon OpenSearch Service. The default value is 300 (5 minutes).
	RetryOptions *AmazonopensearchserviceRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data
	// Firehose for calling the Amazon OpenSearch Service Configuration API and
	// for indexing documents.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// Defines how documents should be delivered to Amazon S3. When it is set to
	// FailedDocumentsOnly, Kinesis Data Firehose writes any documents that could
	// not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/
	// appended to the key prefix. When set to AllDocuments, Kinesis Data Firehose
	// delivers all incoming records to Amazon S3, and also writes failed documents
	// with AmazonOpenSearchService-failed/ appended to the prefix.
	S3BackupMode *string `type:"string" enum:"AmazonopensearchserviceS3BackupMode"`

	// Describes the configuration of a destination in Amazon S3.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`

	// The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can
	// be only one type per index. If you try to specify a new type for an existing
	// index that already has another type, Kinesis Data Firehose returns an error
	// during run time.
	TypeName *string `type:"string"`

	// The details of the VPC of the Amazon OpenSearch or Amazon OpenSearch Serverless
	// destination.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonopensearchserviceDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonopensearchserviceDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonopensearchserviceDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonopensearchserviceDestinationConfiguration"}
	if s.ClusterEndpoint != nil && len(*s.ClusterEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterEndpoint", 1))
	}
	if s.DomainARN != nil && len(*s.DomainARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainARN", 1))
	}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.DocumentIdOptions != nil {
		if err := s.DocumentIdOptions.Validate(); err != nil {
			invalidParams.AddNested("DocumentIdOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetBufferingHints(v *AmazonopensearchserviceBufferingHints) *AmazonopensearchserviceDestinationConfiguration {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *AmazonopensearchserviceDestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterEndpoint sets the ClusterEndpoint field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetClusterEndpoint(v string) *AmazonopensearchserviceDestinationConfiguration {
	s.ClusterEndpoint = &v
	return s
}

// SetDocumentIdOptions sets the DocumentIdOptions field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetDocumentIdOptions(v *DocumentIdOptions) *AmazonopensearchserviceDestinationConfiguration {
	s.DocumentIdOptions = v
	return s
}

// SetDomainARN sets the DomainARN field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetDomainARN(v string) *AmazonopensearchserviceDestinationConfiguration {
	s.DomainARN = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetIndexName(v string) *AmazonopensearchserviceDestinationConfiguration {
	s.IndexName = &v
	return s
}

// SetIndexRotationPeriod sets the IndexRotationPeriod field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetIndexRotationPeriod(v string) *AmazonopensearchserviceDestinationConfiguration {
	s.IndexRotationPeriod = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *AmazonopensearchserviceDestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetRetryOptions(v *AmazonopensearchserviceRetryOptions) *AmazonopensearchserviceDestinationConfiguration {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetRoleARN(v string) *AmazonopensearchserviceDestinationConfiguration {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetS3BackupMode(v string) *AmazonopensearchserviceDestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetS3Configuration(v *S3DestinationConfiguration) *AmazonopensearchserviceDestinationConfiguration {
	s.S3Configuration = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetTypeName(v string) *AmazonopensearchserviceDestinationConfiguration {
	s.TypeName = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *AmazonopensearchserviceDestinationConfiguration) SetVpcConfiguration(v *VpcConfiguration) *AmazonopensearchserviceDestinationConfiguration {
	s.VpcConfiguration = v
	return s
}

// The destination description in Amazon OpenSearch Service.
type AmazonopensearchserviceDestinationDescription struct {
	_ struct{} `type:"structure"`

	// The buffering options.
	BufferingHints *AmazonopensearchserviceBufferingHints `type:"structure"`

	// Describes the Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The endpoint to use when communicating with the cluster. Kinesis Data Firehose
	// uses either this ClusterEndpoint or the DomainARN field to send data to Amazon
	// OpenSearch Service.
	ClusterEndpoint *string `min:"1" type:"string"`

	// Indicates the method for setting up document ID. The supported methods are
	// Kinesis Data Firehose generated document ID and OpenSearch Service generated
	// document ID.
	DocumentIdOptions *DocumentIdOptions `type:"structure"`

	// The ARN of the Amazon OpenSearch Service domain.
	DomainARN *string `min:"1" type:"string"`

	// The Amazon OpenSearch Service index name.
	IndexName *string `min:"1" type:"string"`

	// The Amazon OpenSearch Service index rotation period
	IndexRotationPeriod *string `type:"string" enum:"AmazonopensearchserviceIndexRotationPeriod"`

	// Describes a data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The Amazon OpenSearch Service retry options.
	RetryOptions *AmazonopensearchserviceRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials.
	RoleARN *string `min:"1" type:"string"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"AmazonopensearchserviceS3BackupMode"`

	// Describes a destination in Amazon S3.
	S3DestinationDescription *S3DestinationDescription `type:"structure"`

	// The Amazon OpenSearch Service type name. This applies to Elasticsearch 6.x
	// and lower versions. For Elasticsearch 7.x and OpenSearch Service 1.x, there's
	// no value for TypeName.
	TypeName *string `type:"string"`

	// The details of the VPC of the Amazon ES destination.
	VpcConfigurationDescription *VpcConfigurationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonopensearchserviceDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonopensearchserviceDestinationDescription) GoString() string {
	return s.String()
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetBufferingHints(v *AmazonopensearchserviceBufferingHints) *AmazonopensearchserviceDestinationDescription {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *AmazonopensearchserviceDestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterEndpoint sets the ClusterEndpoint field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetClusterEndpoint(v string) *AmazonopensearchserviceDestinationDescription {
	s.ClusterEndpoint = &v
	return s
}

// SetDocumentIdOptions sets the DocumentIdOptions field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetDocumentIdOptions(v *DocumentIdOptions) *AmazonopensearchserviceDestinationDescription {
	s.DocumentIdOptions = v
	return s
}

// SetDomainARN sets the DomainARN field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetDomainARN(v string) *AmazonopensearchserviceDestinationDescription {
	s.DomainARN = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetIndexName(v string) *AmazonopensearchserviceDestinationDescription {
	s.IndexName = &v
	return s
}

// SetIndexRotationPeriod sets the IndexRotationPeriod field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetIndexRotationPeriod(v string) *AmazonopensearchserviceDestinationDescription {
	s.IndexRotationPeriod = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *AmazonopensearchserviceDestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetRetryOptions(v *AmazonopensearchserviceRetryOptions) *AmazonopensearchserviceDestinationDescription {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetRoleARN(v string) *AmazonopensearchserviceDestinationDescription {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetS3BackupMode(v string) *AmazonopensearchserviceDestinationDescription {
	s.S3BackupMode = &v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *AmazonopensearchserviceDestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetTypeName(v string) *AmazonopensearchserviceDestinationDescription {
	s.TypeName = &v
	return s
}

// SetVpcConfigurationDescription sets the VpcConfigurationDescription field's value.
func (s *AmazonopensearchserviceDestinationDescription) SetVpcConfigurationDescription(v *VpcConfigurationDescription) *AmazonopensearchserviceDestinationDescription {
	s.VpcConfigurationDescription = v
	return s
}

// Describes an update for a destination in Amazon OpenSearch Service.
type AmazonopensearchserviceDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The buffering options. If no value is specified, AmazonopensearchBufferingHints
	// object default values are used.
	BufferingHints *AmazonopensearchserviceBufferingHints `type:"structure"`

	// Describes the Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The endpoint to use when communicating with the cluster. Specify either this
	// ClusterEndpoint or the DomainARN field.
	ClusterEndpoint *string `min:"1" type:"string"`

	// Indicates the method for setting up document ID. The supported methods are
	// Kinesis Data Firehose generated document ID and OpenSearch Service generated
	// document ID.
	DocumentIdOptions *DocumentIdOptions `type:"structure"`

	// The ARN of the Amazon OpenSearch Service domain. The IAM role must have permissions
	// for DescribeDomain, DescribeDomains, and DescribeDomainConfig after assuming
	// the IAM role specified in RoleARN.
	DomainARN *string `min:"1" type:"string"`

	// The Amazon OpenSearch Service index name.
	IndexName *string `min:"1" type:"string"`

	// The Amazon OpenSearch Service index rotation period. Index rotation appends
	// a timestamp to IndexName to facilitate the expiration of old data.
	IndexRotationPeriod *string `type:"string" enum:"AmazonopensearchserviceIndexRotationPeriod"`

	// Describes a data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver documents
	// to Amazon OpenSearch Service. The default value is 300 (5 minutes).
	RetryOptions *AmazonopensearchserviceRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data
	// Firehose for calling the Amazon OpenSearch Service Configuration API and
	// for indexing documents.
	RoleARN *string `min:"1" type:"string"`

	// Describes an update for a destination in Amazon S3.
	S3Update *S3DestinationUpdate `type:"structure"`

	// The Amazon OpenSearch Service type name. For Elasticsearch 6.x, there can
	// be only one type per index. If you try to specify a new type for an existing
	// index that already has another type, Kinesis Data Firehose returns an error
	// during runtime.
	//
	// If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery
	// stream, Kinesis Data Firehose still delivers data to Elasticsearch with the
	// old index name and type name. If you want to update your delivery stream
	// with a new index name, provide an empty string for TypeName.
	TypeName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonopensearchserviceDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonopensearchserviceDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AmazonopensearchserviceDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AmazonopensearchserviceDestinationUpdate"}
	if s.ClusterEndpoint != nil && len(*s.ClusterEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterEndpoint", 1))
	}
	if s.DomainARN != nil && len(*s.DomainARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainARN", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.DocumentIdOptions != nil {
		if err := s.DocumentIdOptions.Validate(); err != nil {
			invalidParams.AddNested("DocumentIdOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetBufferingHints(v *AmazonopensearchserviceBufferingHints) *AmazonopensearchserviceDestinationUpdate {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *AmazonopensearchserviceDestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterEndpoint sets the ClusterEndpoint field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetClusterEndpoint(v string) *AmazonopensearchserviceDestinationUpdate {
	s.ClusterEndpoint = &v
	return s
}

// SetDocumentIdOptions sets the DocumentIdOptions field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetDocumentIdOptions(v *DocumentIdOptions) *AmazonopensearchserviceDestinationUpdate {
	s.DocumentIdOptions = v
	return s
}

// SetDomainARN sets the DomainARN field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetDomainARN(v string) *AmazonopensearchserviceDestinationUpdate {
	s.DomainARN = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetIndexName(v string) *AmazonopensearchserviceDestinationUpdate {
	s.IndexName = &v
	return s
}

// SetIndexRotationPeriod sets the IndexRotationPeriod field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetIndexRotationPeriod(v string) *AmazonopensearchserviceDestinationUpdate {
	s.IndexRotationPeriod = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *AmazonopensearchserviceDestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetRetryOptions(v *AmazonopensearchserviceRetryOptions) *AmazonopensearchserviceDestinationUpdate {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetRoleARN(v string) *AmazonopensearchserviceDestinationUpdate {
	s.RoleARN = &v
	return s
}

// SetS3Update sets the S3Update field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetS3Update(v *S3DestinationUpdate) *AmazonopensearchserviceDestinationUpdate {
	s.S3Update = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *AmazonopensearchserviceDestinationUpdate) SetTypeName(v string) *AmazonopensearchserviceDestinationUpdate {
	s.TypeName = &v
	return s
}

// Configures retry behavior in case Kinesis Data Firehose is unable to deliver
// documents to Amazon OpenSearch Service.
type AmazonopensearchserviceRetryOptions struct {
	_ struct{} `type:"structure"`

	// After an initial failure to deliver to Amazon OpenSearch Service, the total
	// amount of time during which Kinesis Data Firehose retries delivery (including
	// the first attempt). After this time has elapsed, the failed documents are
	// written to Amazon S3. Default value is 300 seconds (5 minutes). A value of
	// 0 (zero) results in no retries.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonopensearchserviceRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AmazonopensearchserviceRetryOptions) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *AmazonopensearchserviceRetryOptions) SetDurationInSeconds(v int64) *AmazonopensearchserviceRetryOptions {
	s.DurationInSeconds = &v
	return s
}

// Describes hints for the buffering to perform before delivering data to the
// destination. These options are treated as hints, and therefore Kinesis Data
// Firehose might choose to use different values when it is optimal. The SizeInMBs
// and IntervalInSeconds parameters are optional. However, if specify a value
// for one of them, you must also provide a value for the other.
type BufferingHints struct {
	_ struct{} `type:"structure"`

	// Buffer incoming data for the specified period of time, in seconds, before
	// delivering it to the destination. The default value is 300. This parameter
	// is optional but if you specify a value for it, you must also specify a value
	// for SizeInMBs, and vice versa.
	IntervalInSeconds *int64 `min:"60" type:"integer"`

	// Buffer incoming data to the specified size, in MiBs, before delivering it
	// to the destination. The default value is 5. This parameter is optional but
	// if you specify a value for it, you must also specify a value for IntervalInSeconds,
	// and vice versa.
	//
	// We recommend setting this parameter to a value greater than the amount of
	// data you typically ingest into the delivery stream in 10 seconds. For example,
	// if you typically ingest data at 1 MiB/sec, the value should be 10 MiB or
	// higher.
	SizeInMBs *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BufferingHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BufferingHints) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BufferingHints) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BufferingHints"}
	if s.IntervalInSeconds != nil && *s.IntervalInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalInSeconds", 60))
	}
	if s.SizeInMBs != nil && *s.SizeInMBs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SizeInMBs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntervalInSeconds sets the IntervalInSeconds field's value.
func (s *BufferingHints) SetIntervalInSeconds(v int64) *BufferingHints {
	s.IntervalInSeconds = &v
	return s
}

// SetSizeInMBs sets the SizeInMBs field's value.
func (s *BufferingHints) SetSizeInMBs(v int64) *BufferingHints {
	s.SizeInMBs = &v
	return s
}

// Describes the Amazon CloudWatch logging options for your delivery stream.
type CloudWatchLoggingOptions struct {
	_ struct{} `type:"structure"`

	// Enables or disables CloudWatch logging.
	Enabled *bool `type:"boolean"`

	// The CloudWatch group name for logging. This value is required if CloudWatch
	// logging is enabled.
	LogGroupName *string `type:"string"`

	// The CloudWatch log stream name for logging. This value is required if CloudWatch
	// logging is enabled.
	LogStreamName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLoggingOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CloudWatchLoggingOptions) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *CloudWatchLoggingOptions) SetEnabled(v bool) *CloudWatchLoggingOptions {
	s.Enabled = &v
	return s
}

// SetLogGroupName sets the LogGroupName field's value.
func (s *CloudWatchLoggingOptions) SetLogGroupName(v string) *CloudWatchLoggingOptions {
	s.LogGroupName = &v
	return s
}

// SetLogStreamName sets the LogStreamName field's value.
func (s *CloudWatchLoggingOptions) SetLogStreamName(v string) *CloudWatchLoggingOptions {
	s.LogStreamName = &v
	return s
}

// Another modification has already happened. Fetch VersionId again and use
// it to update the destination.
type ConcurrentModificationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConcurrentModificationException) GoString() string {
	return s.String()
}

func newErrorConcurrentModificationException(v protocol.ResponseMetadata) error {
	return &ConcurrentModificationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentModificationException) Code() string {
	return "ConcurrentModificationException"
}

// Message returns the exception's message.
func (s *ConcurrentModificationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentModificationException) OrigErr() error {
	return nil
}

func (s *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentModificationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentModificationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a COPY command for Amazon Redshift.
type CopyCommand struct {
	_ struct{} `type:"structure"`

	// Optional parameters to use with the Amazon Redshift COPY command. For more
	// information, see the "Optional Parameters" section of Amazon Redshift COPY
	// command (https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html). Some
	// possible examples that would apply to Kinesis Data Firehose are as follows:
	//
	// delimiter '\t' lzop; - fields are delimited with "\t" (TAB character) and
	// compressed using lzop.
	//
	// delimiter '|' - fields are delimited with "|" (this is the default delimiter).
	//
	// delimiter '|' escape - the delimiter should be escaped.
	//
	// fixedwidth 'venueid:3,venuename:25,venuecity:12,venuestate:2,venueseats:6'
	// - fields are fixed width in the source, with each width specified after every
	// column in the table.
	//
	// JSON 's3://mybucket/jsonpaths.txt' - data is in JSON format, and the path
	// specified is the format of the data.
	//
	// For more examples, see Amazon Redshift COPY command examples (https://docs.aws.amazon.com/redshift/latest/dg/r_COPY_command_examples.html).
	CopyOptions *string `type:"string"`

	// A comma-separated list of column names.
	DataTableColumns *string `type:"string"`

	// The name of the target table. The table must already exist in the database.
	//
	// DataTableName is a required field
	DataTableName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyCommand) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyCommand) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyCommand) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyCommand"}
	if s.DataTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("DataTableName"))
	}
	if s.DataTableName != nil && len(*s.DataTableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataTableName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCopyOptions sets the CopyOptions field's value.
func (s *CopyCommand) SetCopyOptions(v string) *CopyCommand {
	s.CopyOptions = &v
	return s
}

// SetDataTableColumns sets the DataTableColumns field's value.
func (s *CopyCommand) SetDataTableColumns(v string) *CopyCommand {
	s.DataTableColumns = &v
	return s
}

// SetDataTableName sets the DataTableName field's value.
func (s *CopyCommand) SetDataTableName(v string) *CopyCommand {
	s.DataTableName = &v
	return s
}

type CreateDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The destination in the Serverless offering for Amazon OpenSearch Service.
	// You can specify only one destination.
	AmazonOpenSearchServerlessDestinationConfiguration *AmazonOpenSearchServerlessDestinationConfiguration `type:"structure"`

	// The destination in Amazon OpenSearch Service. You can specify only one destination.
	AmazonopensearchserviceDestinationConfiguration *AmazonopensearchserviceDestinationConfiguration `type:"structure"`

	// Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed
	// for Server-Side Encryption (SSE).
	DeliveryStreamEncryptionConfigurationInput *DeliveryStreamEncryptionConfigurationInput `type:"structure"`

	// The name of the delivery stream. This name must be unique per Amazon Web
	// Services account in the same Amazon Web Services Region. If the delivery
	// streams are in different accounts or different Regions, you can have multiple
	// delivery streams with the same name.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The delivery stream type. This parameter can be one of the following values:
	//
	//    * DirectPut: Provider applications access the delivery stream directly.
	//
	//    * KinesisStreamAsSource: The delivery stream uses a Kinesis data stream
	//    as a source.
	DeliveryStreamType *string `type:"string" enum:"DeliveryStreamType"`

	// The destination in Amazon ES. You can specify only one destination.
	ElasticsearchDestinationConfiguration *ElasticsearchDestinationConfiguration `type:"structure"`

	// The destination in Amazon S3. You can specify only one destination.
	ExtendedS3DestinationConfiguration *ExtendedS3DestinationConfiguration `type:"structure"`

	// Enables configuring Kinesis Firehose to deliver data to any HTTP endpoint
	// destination. You can specify only one destination.
	HttpEndpointDestinationConfiguration *HttpEndpointDestinationConfiguration `type:"structure"`

	// When a Kinesis data stream is used as the source for the delivery stream,
	// a KinesisStreamSourceConfiguration containing the Kinesis data stream Amazon
	// Resource Name (ARN) and the role ARN for the source stream.
	KinesisStreamSourceConfiguration *KinesisStreamSourceConfiguration `type:"structure"`

	// The destination in Amazon Redshift. You can specify only one destination.
	RedshiftDestinationConfiguration *RedshiftDestinationConfiguration `type:"structure"`

	// [Deprecated] The destination in Amazon S3. You can specify only one destination.
	//
	// Deprecated: S3DestinationConfiguration has been deprecated
	S3DestinationConfiguration *S3DestinationConfiguration `deprecated:"true" type:"structure"`

	// The destination in Splunk. You can specify only one destination.
	SplunkDestinationConfiguration *SplunkDestinationConfiguration `type:"structure"`

	// A set of tags to assign to the delivery stream. A tag is a key-value pair
	// that you can define and assign to Amazon Web Services resources. Tags are
	// metadata. For example, you can add friendly names and descriptions or other
	// types of information that can help you distinguish the delivery stream. For
	// more information about tags, see Using Cost Allocation Tags (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
	// in the Amazon Web Services Billing and Cost Management User Guide.
	//
	// You can specify up to 50 tags when creating a delivery stream.
	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.AmazonOpenSearchServerlessDestinationConfiguration != nil {
		if err := s.AmazonOpenSearchServerlessDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AmazonOpenSearchServerlessDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.AmazonopensearchserviceDestinationConfiguration != nil {
		if err := s.AmazonopensearchserviceDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("AmazonopensearchserviceDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.DeliveryStreamEncryptionConfigurationInput != nil {
		if err := s.DeliveryStreamEncryptionConfigurationInput.Validate(); err != nil {
			invalidParams.AddNested("DeliveryStreamEncryptionConfigurationInput", err.(request.ErrInvalidParams))
		}
	}
	if s.ElasticsearchDestinationConfiguration != nil {
		if err := s.ElasticsearchDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ExtendedS3DestinationConfiguration != nil {
		if err := s.ExtendedS3DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ExtendedS3DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.HttpEndpointDestinationConfiguration != nil {
		if err := s.HttpEndpointDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("HttpEndpointDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.KinesisStreamSourceConfiguration != nil {
		if err := s.KinesisStreamSourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("KinesisStreamSourceConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftDestinationConfiguration != nil {
		if err := s.RedshiftDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RedshiftDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3DestinationConfiguration != nil {
		if err := s.S3DestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3DestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SplunkDestinationConfiguration != nil {
		if err := s.SplunkDestinationConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SplunkDestinationConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmazonOpenSearchServerlessDestinationConfiguration sets the AmazonOpenSearchServerlessDestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetAmazonOpenSearchServerlessDestinationConfiguration(v *AmazonOpenSearchServerlessDestinationConfiguration) *CreateDeliveryStreamInput {
	s.AmazonOpenSearchServerlessDestinationConfiguration = v
	return s
}

// SetAmazonopensearchserviceDestinationConfiguration sets the AmazonopensearchserviceDestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetAmazonopensearchserviceDestinationConfiguration(v *AmazonopensearchserviceDestinationConfiguration) *CreateDeliveryStreamInput {
	s.AmazonopensearchserviceDestinationConfiguration = v
	return s
}

// SetDeliveryStreamEncryptionConfigurationInput sets the DeliveryStreamEncryptionConfigurationInput field's value.
func (s *CreateDeliveryStreamInput) SetDeliveryStreamEncryptionConfigurationInput(v *DeliveryStreamEncryptionConfigurationInput) *CreateDeliveryStreamInput {
	s.DeliveryStreamEncryptionConfigurationInput = v
	return s
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *CreateDeliveryStreamInput) SetDeliveryStreamName(v string) *CreateDeliveryStreamInput {
	s.DeliveryStreamName = &v
	return s
}

// SetDeliveryStreamType sets the DeliveryStreamType field's value.
func (s *CreateDeliveryStreamInput) SetDeliveryStreamType(v string) *CreateDeliveryStreamInput {
	s.DeliveryStreamType = &v
	return s
}

// SetElasticsearchDestinationConfiguration sets the ElasticsearchDestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetElasticsearchDestinationConfiguration(v *ElasticsearchDestinationConfiguration) *CreateDeliveryStreamInput {
	s.ElasticsearchDestinationConfiguration = v
	return s
}

// SetExtendedS3DestinationConfiguration sets the ExtendedS3DestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetExtendedS3DestinationConfiguration(v *ExtendedS3DestinationConfiguration) *CreateDeliveryStreamInput {
	s.ExtendedS3DestinationConfiguration = v
	return s
}

// SetHttpEndpointDestinationConfiguration sets the HttpEndpointDestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetHttpEndpointDestinationConfiguration(v *HttpEndpointDestinationConfiguration) *CreateDeliveryStreamInput {
	s.HttpEndpointDestinationConfiguration = v
	return s
}

// SetKinesisStreamSourceConfiguration sets the KinesisStreamSourceConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetKinesisStreamSourceConfiguration(v *KinesisStreamSourceConfiguration) *CreateDeliveryStreamInput {
	s.KinesisStreamSourceConfiguration = v
	return s
}

// SetRedshiftDestinationConfiguration sets the RedshiftDestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetRedshiftDestinationConfiguration(v *RedshiftDestinationConfiguration) *CreateDeliveryStreamInput {
	s.RedshiftDestinationConfiguration = v
	return s
}

// SetS3DestinationConfiguration sets the S3DestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetS3DestinationConfiguration(v *S3DestinationConfiguration) *CreateDeliveryStreamInput {
	s.S3DestinationConfiguration = v
	return s
}

// SetSplunkDestinationConfiguration sets the SplunkDestinationConfiguration field's value.
func (s *CreateDeliveryStreamInput) SetSplunkDestinationConfiguration(v *SplunkDestinationConfiguration) *CreateDeliveryStreamInput {
	s.SplunkDestinationConfiguration = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDeliveryStreamInput) SetTags(v []*Tag) *CreateDeliveryStreamInput {
	s.Tags = v
	return s
}

type CreateDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the delivery stream.
	DeliveryStreamARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeliveryStreamOutput) GoString() string {
	return s.String()
}

// SetDeliveryStreamARN sets the DeliveryStreamARN field's value.
func (s *CreateDeliveryStreamOutput) SetDeliveryStreamARN(v string) *CreateDeliveryStreamOutput {
	s.DeliveryStreamARN = &v
	return s
}

// Specifies that you want Kinesis Data Firehose to convert data from the JSON
// format to the Parquet or ORC format before writing it to Amazon S3. Kinesis
// Data Firehose uses the serializer and deserializer that you specify, in addition
// to the column information from the Amazon Web Services Glue table, to deserialize
// your input data from JSON and then serialize it to the Parquet or ORC format.
// For more information, see Kinesis Data Firehose Record Format Conversion
// (https://docs.aws.amazon.com/firehose/latest/dev/record-format-conversion.html).
type DataFormatConversionConfiguration struct {
	_ struct{} `type:"structure"`

	// Defaults to true. Set it to false if you want to disable format conversion
	// while preserving the configuration details.
	Enabled *bool `type:"boolean"`

	// Specifies the deserializer that you want Kinesis Data Firehose to use to
	// convert the format of your data from JSON. This parameter is required if
	// Enabled is set to true.
	InputFormatConfiguration *InputFormatConfiguration `type:"structure"`

	// Specifies the serializer that you want Kinesis Data Firehose to use to convert
	// the format of your data to the Parquet or ORC format. This parameter is required
	// if Enabled is set to true.
	OutputFormatConfiguration *OutputFormatConfiguration `type:"structure"`

	// Specifies the Amazon Web Services Glue Data Catalog table that contains the
	// column information. This parameter is required if Enabled is set to true.
	SchemaConfiguration *SchemaConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataFormatConversionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataFormatConversionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataFormatConversionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataFormatConversionConfiguration"}
	if s.OutputFormatConfiguration != nil {
		if err := s.OutputFormatConfiguration.Validate(); err != nil {
			invalidParams.AddNested("OutputFormatConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.SchemaConfiguration != nil {
		if err := s.SchemaConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SchemaConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *DataFormatConversionConfiguration) SetEnabled(v bool) *DataFormatConversionConfiguration {
	s.Enabled = &v
	return s
}

// SetInputFormatConfiguration sets the InputFormatConfiguration field's value.
func (s *DataFormatConversionConfiguration) SetInputFormatConfiguration(v *InputFormatConfiguration) *DataFormatConversionConfiguration {
	s.InputFormatConfiguration = v
	return s
}

// SetOutputFormatConfiguration sets the OutputFormatConfiguration field's value.
func (s *DataFormatConversionConfiguration) SetOutputFormatConfiguration(v *OutputFormatConfiguration) *DataFormatConversionConfiguration {
	s.OutputFormatConfiguration = v
	return s
}

// SetSchemaConfiguration sets the SchemaConfiguration field's value.
func (s *DataFormatConversionConfiguration) SetSchemaConfiguration(v *SchemaConfiguration) *DataFormatConversionConfiguration {
	s.SchemaConfiguration = v
	return s
}

type DeleteDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// Set this to true if you want to delete the delivery stream even if Kinesis
	// Data Firehose is unable to retire the grant for the CMK. Kinesis Data Firehose
	// might be unable to retire the grant due to a customer error, such as when
	// the CMK or the grant are in an invalid state. If you force deletion, you
	// can then use the RevokeGrant (https://docs.aws.amazon.com/kms/latest/APIReference/API_RevokeGrant.html)
	// operation to revoke the grant you gave to Kinesis Data Firehose. If a failure
	// to retire the grant happens due to an Amazon Web Services KMS issue, Kinesis
	// Data Firehose keeps retrying the delete operation.
	//
	// The default value is false.
	AllowForceDelete *bool `type:"boolean"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowForceDelete sets the AllowForceDelete field's value.
func (s *DeleteDeliveryStreamInput) SetAllowForceDelete(v bool) *DeleteDeliveryStreamInput {
	s.AllowForceDelete = &v
	return s
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *DeleteDeliveryStreamInput) SetDeliveryStreamName(v string) *DeleteDeliveryStreamInput {
	s.DeliveryStreamName = &v
	return s
}

type DeleteDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeliveryStreamOutput) GoString() string {
	return s.String()
}

// Contains information about a delivery stream.
type DeliveryStreamDescription struct {
	_ struct{} `type:"structure"`

	// The date and time that the delivery stream was created.
	CreateTimestamp *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the delivery stream. For more information,
	// see Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// DeliveryStreamARN is a required field
	DeliveryStreamARN *string `min:"1" type:"string" required:"true"`

	// Indicates the server-side encryption (SSE) status for the delivery stream.
	DeliveryStreamEncryptionConfiguration *DeliveryStreamEncryptionConfiguration `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The status of the delivery stream. If the status of a delivery stream is
	// CREATING_FAILED, this status doesn't change, and you can't invoke CreateDeliveryStream
	// again on it. However, you can invoke the DeleteDeliveryStream operation to
	// delete it.
	//
	// DeliveryStreamStatus is a required field
	DeliveryStreamStatus *string `type:"string" required:"true" enum:"DeliveryStreamStatus"`

	// The delivery stream type. This can be one of the following values:
	//
	//    * DirectPut: Provider applications access the delivery stream directly.
	//
	//    * KinesisStreamAsSource: The delivery stream uses a Kinesis data stream
	//    as a source.
	//
	// DeliveryStreamType is a required field
	DeliveryStreamType *string `type:"string" required:"true" enum:"DeliveryStreamType"`

	// The destinations.
	//
	// Destinations is a required field
	Destinations []*DestinationDescription `type:"list" required:"true"`

	// Provides details in case one of the following operations fails due to an
	// error related to KMS: CreateDeliveryStream, DeleteDeliveryStream, StartDeliveryStreamEncryption,
	// StopDeliveryStreamEncryption.
	FailureDescription *FailureDescription `type:"structure"`

	// Indicates whether there are more destinations available to list.
	//
	// HasMoreDestinations is a required field
	HasMoreDestinations *bool `type:"boolean" required:"true"`

	// The date and time that the delivery stream was last updated.
	LastUpdateTimestamp *time.Time `type:"timestamp"`

	// If the DeliveryStreamType parameter is KinesisStreamAsSource, a SourceDescription
	// object describing the source Kinesis data stream.
	Source *SourceDescription `type:"structure"`

	// Each time the destination is updated for a delivery stream, the version ID
	// is changed, and the current version ID is required when updating the destination.
	// This is so that the service knows it is applying the changes to the correct
	// version of the delivery stream.
	//
	// VersionId is a required field
	VersionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryStreamDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryStreamDescription) GoString() string {
	return s.String()
}

// SetCreateTimestamp sets the CreateTimestamp field's value.
func (s *DeliveryStreamDescription) SetCreateTimestamp(v time.Time) *DeliveryStreamDescription {
	s.CreateTimestamp = &v
	return s
}

// SetDeliveryStreamARN sets the DeliveryStreamARN field's value.
func (s *DeliveryStreamDescription) SetDeliveryStreamARN(v string) *DeliveryStreamDescription {
	s.DeliveryStreamARN = &v
	return s
}

// SetDeliveryStreamEncryptionConfiguration sets the DeliveryStreamEncryptionConfiguration field's value.
func (s *DeliveryStreamDescription) SetDeliveryStreamEncryptionConfiguration(v *DeliveryStreamEncryptionConfiguration) *DeliveryStreamDescription {
	s.DeliveryStreamEncryptionConfiguration = v
	return s
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *DeliveryStreamDescription) SetDeliveryStreamName(v string) *DeliveryStreamDescription {
	s.DeliveryStreamName = &v
	return s
}

// SetDeliveryStreamStatus sets the DeliveryStreamStatus field's value.
func (s *DeliveryStreamDescription) SetDeliveryStreamStatus(v string) *DeliveryStreamDescription {
	s.DeliveryStreamStatus = &v
	return s
}

// SetDeliveryStreamType sets the DeliveryStreamType field's value.
func (s *DeliveryStreamDescription) SetDeliveryStreamType(v string) *DeliveryStreamDescription {
	s.DeliveryStreamType = &v
	return s
}

// SetDestinations sets the Destinations field's value.
func (s *DeliveryStreamDescription) SetDestinations(v []*DestinationDescription) *DeliveryStreamDescription {
	s.Destinations = v
	return s
}

// SetFailureDescription sets the FailureDescription field's value.
func (s *DeliveryStreamDescription) SetFailureDescription(v *FailureDescription) *DeliveryStreamDescription {
	s.FailureDescription = v
	return s
}

// SetHasMoreDestinations sets the HasMoreDestinations field's value.
func (s *DeliveryStreamDescription) SetHasMoreDestinations(v bool) *DeliveryStreamDescription {
	s.HasMoreDestinations = &v
	return s
}

// SetLastUpdateTimestamp sets the LastUpdateTimestamp field's value.
func (s *DeliveryStreamDescription) SetLastUpdateTimestamp(v time.Time) *DeliveryStreamDescription {
	s.LastUpdateTimestamp = &v
	return s
}

// SetSource sets the Source field's value.
func (s *DeliveryStreamDescription) SetSource(v *SourceDescription) *DeliveryStreamDescription {
	s.Source = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *DeliveryStreamDescription) SetVersionId(v string) *DeliveryStreamDescription {
	s.VersionId = &v
	return s
}

// Contains information about the server-side encryption (SSE) status for the
// delivery stream, the type customer master key (CMK) in use, if any, and the
// ARN of the CMK. You can get DeliveryStreamEncryptionConfiguration by invoking
// the DescribeDeliveryStream operation.
type DeliveryStreamEncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// Provides details in case one of the following operations fails due to an
	// error related to KMS: CreateDeliveryStream, DeleteDeliveryStream, StartDeliveryStreamEncryption,
	// StopDeliveryStreamEncryption.
	FailureDescription *FailureDescription `type:"structure"`

	// If KeyType is CUSTOMER_MANAGED_CMK, this field contains the ARN of the customer
	// managed CMK. If KeyType is Amazon Web Services_OWNED_CMK, DeliveryStreamEncryptionConfiguration
	// doesn't contain a value for KeyARN.
	KeyARN *string `min:"1" type:"string"`

	// Indicates the type of customer master key (CMK) that is used for encryption.
	// The default setting is Amazon Web Services_OWNED_CMK. For more information
	// about CMKs, see Customer Master Keys (CMKs) (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys).
	KeyType *string `type:"string" enum:"KeyType"`

	// This is the server-side encryption (SSE) status for the delivery stream.
	// For a full description of the different values of this status, see StartDeliveryStreamEncryption
	// and StopDeliveryStreamEncryption. If this status is ENABLING_FAILED or DISABLING_FAILED,
	// it is the status of the most recent attempt to enable or disable SSE, respectively.
	Status *string `type:"string" enum:"DeliveryStreamEncryptionStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryStreamEncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryStreamEncryptionConfiguration) GoString() string {
	return s.String()
}

// SetFailureDescription sets the FailureDescription field's value.
func (s *DeliveryStreamEncryptionConfiguration) SetFailureDescription(v *FailureDescription) *DeliveryStreamEncryptionConfiguration {
	s.FailureDescription = v
	return s
}

// SetKeyARN sets the KeyARN field's value.
func (s *DeliveryStreamEncryptionConfiguration) SetKeyARN(v string) *DeliveryStreamEncryptionConfiguration {
	s.KeyARN = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *DeliveryStreamEncryptionConfiguration) SetKeyType(v string) *DeliveryStreamEncryptionConfiguration {
	s.KeyType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeliveryStreamEncryptionConfiguration) SetStatus(v string) *DeliveryStreamEncryptionConfiguration {
	s.Status = &v
	return s
}

// Specifies the type and Amazon Resource Name (ARN) of the CMK to use for Server-Side
// Encryption (SSE).
type DeliveryStreamEncryptionConfigurationInput struct {
	_ struct{} `type:"structure"`

	// If you set KeyType to CUSTOMER_MANAGED_CMK, you must specify the Amazon Resource
	// Name (ARN) of the CMK. If you set KeyType to Amazon Web Services_OWNED_CMK,
	// Kinesis Data Firehose uses a service-account CMK.
	KeyARN *string `min:"1" type:"string"`

	// Indicates the type of customer master key (CMK) to use for encryption. The
	// default setting is Amazon Web Services_OWNED_CMK. For more information about
	// CMKs, see Customer Master Keys (CMKs) (https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys).
	// When you invoke CreateDeliveryStream or StartDeliveryStreamEncryption with
	// KeyType set to CUSTOMER_MANAGED_CMK, Kinesis Data Firehose invokes the Amazon
	// KMS operation CreateGrant (https://docs.aws.amazon.com/kms/latest/APIReference/API_CreateGrant.html)
	// to create a grant that allows the Kinesis Data Firehose service to use the
	// customer managed CMK to perform encryption and decryption. Kinesis Data Firehose
	// manages that grant.
	//
	// When you invoke StartDeliveryStreamEncryption to change the CMK for a delivery
	// stream that is encrypted with a customer managed CMK, Kinesis Data Firehose
	// schedules the grant it had on the old CMK for retirement.
	//
	// You can use a CMK of type CUSTOMER_MANAGED_CMK to encrypt up to 500 delivery
	// streams. If a CreateDeliveryStream or StartDeliveryStreamEncryption operation
	// exceeds this limit, Kinesis Data Firehose throws a LimitExceededException.
	//
	// To encrypt your delivery stream, use symmetric CMKs. Kinesis Data Firehose
	// doesn't support asymmetric CMKs. For information about symmetric and asymmetric
	// CMKs, see About Symmetric and Asymmetric CMKs (https://docs.aws.amazon.com/kms/latest/developerguide/symm-asymm-concepts.html)
	// in the Amazon Web Services Key Management Service developer guide.
	//
	// KeyType is a required field
	KeyType *string `type:"string" required:"true" enum:"KeyType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryStreamEncryptionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeliveryStreamEncryptionConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeliveryStreamEncryptionConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeliveryStreamEncryptionConfigurationInput"}
	if s.KeyARN != nil && len(*s.KeyARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyARN", 1))
	}
	if s.KeyType == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyARN sets the KeyARN field's value.
func (s *DeliveryStreamEncryptionConfigurationInput) SetKeyARN(v string) *DeliveryStreamEncryptionConfigurationInput {
	s.KeyARN = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *DeliveryStreamEncryptionConfigurationInput) SetKeyType(v string) *DeliveryStreamEncryptionConfigurationInput {
	s.KeyType = &v
	return s
}

type DescribeDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The ID of the destination to start returning the destination information.
	// Kinesis Data Firehose supports one destination per delivery stream.
	ExclusiveStartDestinationId *string `min:"1" type:"string"`

	// The limit on the number of destinations to return. You can have one destination
	// per delivery stream.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.ExclusiveStartDestinationId != nil && len(*s.ExclusiveStartDestinationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartDestinationId", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *DescribeDeliveryStreamInput) SetDeliveryStreamName(v string) *DescribeDeliveryStreamInput {
	s.DeliveryStreamName = &v
	return s
}

// SetExclusiveStartDestinationId sets the ExclusiveStartDestinationId field's value.
func (s *DescribeDeliveryStreamInput) SetExclusiveStartDestinationId(v string) *DescribeDeliveryStreamInput {
	s.ExclusiveStartDestinationId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeDeliveryStreamInput) SetLimit(v int64) *DescribeDeliveryStreamInput {
	s.Limit = &v
	return s
}

type DescribeDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`

	// Information about the delivery stream.
	//
	// DeliveryStreamDescription is a required field
	DeliveryStreamDescription *DeliveryStreamDescription `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeDeliveryStreamOutput) GoString() string {
	return s.String()
}

// SetDeliveryStreamDescription sets the DeliveryStreamDescription field's value.
func (s *DescribeDeliveryStreamOutput) SetDeliveryStreamDescription(v *DeliveryStreamDescription) *DescribeDeliveryStreamOutput {
	s.DeliveryStreamDescription = v
	return s
}

// The deserializer you want Kinesis Data Firehose to use for converting the
// input data from JSON. Kinesis Data Firehose then serializes the data to its
// final format using the Serializer. Kinesis Data Firehose supports two types
// of deserializers: the Apache Hive JSON SerDe (https://cwiki.apache.org/confluence/display/Hive/LanguageManual+DDL#LanguageManualDDL-JSON)
// and the OpenX JSON SerDe (https://github.com/rcongiu/Hive-JSON-Serde).
type Deserializer struct {
	_ struct{} `type:"structure"`

	// The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing
	// data, which means converting it from the JSON format in preparation for serializing
	// it to the Parquet or ORC format. This is one of two deserializers you can
	// choose, depending on which one offers the functionality you need. The other
	// option is the OpenX SerDe.
	HiveJsonSerDe *HiveJsonSerDe `type:"structure"`

	// The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which
	// means converting it from the JSON format in preparation for serializing it
	// to the Parquet or ORC format. This is one of two deserializers you can choose,
	// depending on which one offers the functionality you need. The other option
	// is the native Hive / HCatalog JsonSerDe.
	OpenXJsonSerDe *OpenXJsonSerDe `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deserializer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deserializer) GoString() string {
	return s.String()
}

// SetHiveJsonSerDe sets the HiveJsonSerDe field's value.
func (s *Deserializer) SetHiveJsonSerDe(v *HiveJsonSerDe) *Deserializer {
	s.HiveJsonSerDe = v
	return s
}

// SetOpenXJsonSerDe sets the OpenXJsonSerDe field's value.
func (s *Deserializer) SetOpenXJsonSerDe(v *OpenXJsonSerDe) *Deserializer {
	s.OpenXJsonSerDe = v
	return s
}

// Describes the destination for a delivery stream.
type DestinationDescription struct {
	_ struct{} `type:"structure"`

	// The destination in the Serverless offering for Amazon OpenSearch Service.
	AmazonOpenSearchServerlessDestinationDescription *AmazonOpenSearchServerlessDestinationDescription `type:"structure"`

	// The destination in Amazon OpenSearch Service.
	AmazonopensearchserviceDestinationDescription *AmazonopensearchserviceDestinationDescription `type:"structure"`

	// The ID of the destination.
	//
	// DestinationId is a required field
	DestinationId *string `min:"1" type:"string" required:"true"`

	// The destination in Amazon ES.
	ElasticsearchDestinationDescription *ElasticsearchDestinationDescription `type:"structure"`

	// The destination in Amazon S3.
	ExtendedS3DestinationDescription *ExtendedS3DestinationDescription `type:"structure"`

	// Describes the specified HTTP endpoint destination.
	HttpEndpointDestinationDescription *HttpEndpointDestinationDescription `type:"structure"`

	// The destination in Amazon Redshift.
	RedshiftDestinationDescription *RedshiftDestinationDescription `type:"structure"`

	// [Deprecated] The destination in Amazon S3.
	S3DestinationDescription *S3DestinationDescription `type:"structure"`

	// The destination in Splunk.
	SplunkDestinationDescription *SplunkDestinationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DestinationDescription) GoString() string {
	return s.String()
}

// SetAmazonOpenSearchServerlessDestinationDescription sets the AmazonOpenSearchServerlessDestinationDescription field's value.
func (s *DestinationDescription) SetAmazonOpenSearchServerlessDestinationDescription(v *AmazonOpenSearchServerlessDestinationDescription) *DestinationDescription {
	s.AmazonOpenSearchServerlessDestinationDescription = v
	return s
}

// SetAmazonopensearchserviceDestinationDescription sets the AmazonopensearchserviceDestinationDescription field's value.
func (s *DestinationDescription) SetAmazonopensearchserviceDestinationDescription(v *AmazonopensearchserviceDestinationDescription) *DestinationDescription {
	s.AmazonopensearchserviceDestinationDescription = v
	return s
}

// SetDestinationId sets the DestinationId field's value.
func (s *DestinationDescription) SetDestinationId(v string) *DestinationDescription {
	s.DestinationId = &v
	return s
}

// SetElasticsearchDestinationDescription sets the ElasticsearchDestinationDescription field's value.
func (s *DestinationDescription) SetElasticsearchDestinationDescription(v *ElasticsearchDestinationDescription) *DestinationDescription {
	s.ElasticsearchDestinationDescription = v
	return s
}

// SetExtendedS3DestinationDescription sets the ExtendedS3DestinationDescription field's value.
func (s *DestinationDescription) SetExtendedS3DestinationDescription(v *ExtendedS3DestinationDescription) *DestinationDescription {
	s.ExtendedS3DestinationDescription = v
	return s
}

// SetHttpEndpointDestinationDescription sets the HttpEndpointDestinationDescription field's value.
func (s *DestinationDescription) SetHttpEndpointDestinationDescription(v *HttpEndpointDestinationDescription) *DestinationDescription {
	s.HttpEndpointDestinationDescription = v
	return s
}

// SetRedshiftDestinationDescription sets the RedshiftDestinationDescription field's value.
func (s *DestinationDescription) SetRedshiftDestinationDescription(v *RedshiftDestinationDescription) *DestinationDescription {
	s.RedshiftDestinationDescription = v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *DestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *DestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// SetSplunkDestinationDescription sets the SplunkDestinationDescription field's value.
func (s *DestinationDescription) SetSplunkDestinationDescription(v *SplunkDestinationDescription) *DestinationDescription {
	s.SplunkDestinationDescription = v
	return s
}

// Indicates the method for setting up document ID. The supported methods are
// Kinesis Data Firehose generated document ID and OpenSearch Service generated
// document ID.
type DocumentIdOptions struct {
	_ struct{} `type:"structure"`

	// When the FIREHOSE_DEFAULT option is chosen, Kinesis Data Firehose generates
	// a unique document ID for each record based on a unique internal identifier.
	// The generated document ID is stable across multiple delivery attempts, which
	// helps prevent the same record from being indexed multiple times with different
	// document IDs.
	//
	// When the NO_DOCUMENT_ID option is chosen, Kinesis Data Firehose does not
	// include any document IDs in the requests it sends to the Amazon OpenSearch
	// Service. This causes the Amazon OpenSearch Service domain to generate document
	// IDs. In case of multiple delivery attempts, this may cause the same record
	// to be indexed more than once with different document IDs. This option enables
	// write-heavy operations, such as the ingestion of logs and observability data,
	// to consume less resources in the Amazon OpenSearch Service domain, resulting
	// in improved performance.
	//
	// DefaultDocumentIdFormat is a required field
	DefaultDocumentIdFormat *string `type:"string" required:"true" enum:"DefaultDocumentIdFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentIdOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentIdOptions) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentIdOptions) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentIdOptions"}
	if s.DefaultDocumentIdFormat == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultDocumentIdFormat"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultDocumentIdFormat sets the DefaultDocumentIdFormat field's value.
func (s *DocumentIdOptions) SetDefaultDocumentIdFormat(v string) *DocumentIdOptions {
	s.DefaultDocumentIdFormat = &v
	return s
}

// The configuration of the dynamic partitioning mechanism that creates smaller
// data sets from the streaming data by partitioning it based on partition keys.
// Currently, dynamic partitioning is only supported for Amazon S3 destinations.
type DynamicPartitioningConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies that the dynamic partitioning is enabled for this Kinesis Data
	// Firehose delivery stream.
	Enabled *bool `type:"boolean"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver data
	// to an Amazon S3 prefix.
	RetryOptions *RetryOptions `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DynamicPartitioningConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DynamicPartitioningConfiguration) GoString() string {
	return s.String()
}

// SetEnabled sets the Enabled field's value.
func (s *DynamicPartitioningConfiguration) SetEnabled(v bool) *DynamicPartitioningConfiguration {
	s.Enabled = &v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *DynamicPartitioningConfiguration) SetRetryOptions(v *RetryOptions) *DynamicPartitioningConfiguration {
	s.RetryOptions = v
	return s
}

// Describes the buffering to perform before delivering data to the Amazon ES
// destination.
type ElasticsearchBufferingHints struct {
	_ struct{} `type:"structure"`

	// Buffer incoming data for the specified period of time, in seconds, before
	// delivering it to the destination. The default value is 300 (5 minutes).
	IntervalInSeconds *int64 `min:"60" type:"integer"`

	// Buffer incoming data to the specified size, in MBs, before delivering it
	// to the destination. The default value is 5.
	//
	// We recommend setting this parameter to a value greater than the amount of
	// data you typically ingest into the delivery stream in 10 seconds. For example,
	// if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
	SizeInMBs *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchBufferingHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchBufferingHints) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchBufferingHints) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchBufferingHints"}
	if s.IntervalInSeconds != nil && *s.IntervalInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalInSeconds", 60))
	}
	if s.SizeInMBs != nil && *s.SizeInMBs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SizeInMBs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntervalInSeconds sets the IntervalInSeconds field's value.
func (s *ElasticsearchBufferingHints) SetIntervalInSeconds(v int64) *ElasticsearchBufferingHints {
	s.IntervalInSeconds = &v
	return s
}

// SetSizeInMBs sets the SizeInMBs field's value.
func (s *ElasticsearchBufferingHints) SetSizeInMBs(v int64) *ElasticsearchBufferingHints {
	s.SizeInMBs = &v
	return s
}

// Describes the configuration of a destination in Amazon ES.
type ElasticsearchDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The buffering options. If no value is specified, the default values for ElasticsearchBufferingHints
	// are used.
	BufferingHints *ElasticsearchBufferingHints `type:"structure"`

	// The Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The endpoint to use when communicating with the cluster. Specify either this
	// ClusterEndpoint or the DomainARN field.
	ClusterEndpoint *string `min:"1" type:"string"`

	// Indicates the method for setting up document ID. The supported methods are
	// Kinesis Data Firehose generated document ID and OpenSearch Service generated
	// document ID.
	DocumentIdOptions *DocumentIdOptions `type:"structure"`

	// The ARN of the Amazon ES domain. The IAM role must have permissions for DescribeDomain,
	// DescribeDomains, and DescribeDomainConfig after assuming the role specified
	// in RoleARN. For more information, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// Specify either ClusterEndpoint or DomainARN.
	DomainARN *string `min:"1" type:"string"`

	// The Elasticsearch index name.
	//
	// IndexName is a required field
	IndexName *string `min:"1" type:"string" required:"true"`

	// The Elasticsearch index rotation period. Index rotation appends a timestamp
	// to the IndexName to facilitate the expiration of old data. For more information,
	// see Index Rotation for the Amazon ES Destination (https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation).
	// The default value is OneDay.
	IndexRotationPeriod *string `type:"string" enum:"ElasticsearchIndexRotationPeriod"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver documents
	// to Amazon ES. The default value is 300 (5 minutes).
	RetryOptions *ElasticsearchRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data
	// Firehose for calling the Amazon ES Configuration API and for indexing documents.
	// For more information, see Grant Kinesis Data Firehose Access to an Amazon
	// S3 Destination (https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3)
	// and Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// Defines how documents should be delivered to Amazon S3. When it is set to
	// FailedDocumentsOnly, Kinesis Data Firehose writes any documents that could
	// not be indexed to the configured Amazon S3 destination, with AmazonOpenSearchService-failed/
	// appended to the key prefix. When set to AllDocuments, Kinesis Data Firehose
	// delivers all incoming records to Amazon S3, and also writes failed documents
	// with AmazonOpenSearchService-failed/ appended to the prefix. For more information,
	// see Amazon S3 Backup for the Amazon ES Destination (https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-s3-backup).
	// Default value is FailedDocumentsOnly.
	//
	// You can't change this backup mode after you create the delivery stream.
	S3BackupMode *string `type:"string" enum:"ElasticsearchS3BackupMode"`

	// The configuration for the backup Amazon S3 location.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`

	// The Elasticsearch type name. For Elasticsearch 6.x, there can be only one
	// type per index. If you try to specify a new type for an existing index that
	// already has another type, Kinesis Data Firehose returns an error during run
	// time.
	//
	// For Elasticsearch 7.x, don't specify a TypeName.
	TypeName *string `type:"string"`

	// The details of the VPC of the Amazon destination.
	VpcConfiguration *VpcConfiguration `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchDestinationConfiguration"}
	if s.ClusterEndpoint != nil && len(*s.ClusterEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterEndpoint", 1))
	}
	if s.DomainARN != nil && len(*s.DomainARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainARN", 1))
	}
	if s.IndexName == nil {
		invalidParams.Add(request.NewErrParamRequired("IndexName"))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.DocumentIdOptions != nil {
		if err := s.DocumentIdOptions.Validate(); err != nil {
			invalidParams.AddNested("DocumentIdOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}
	if s.VpcConfiguration != nil {
		if err := s.VpcConfiguration.Validate(); err != nil {
			invalidParams.AddNested("VpcConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ElasticsearchDestinationConfiguration) SetBufferingHints(v *ElasticsearchBufferingHints) *ElasticsearchDestinationConfiguration {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ElasticsearchDestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ElasticsearchDestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterEndpoint sets the ClusterEndpoint field's value.
func (s *ElasticsearchDestinationConfiguration) SetClusterEndpoint(v string) *ElasticsearchDestinationConfiguration {
	s.ClusterEndpoint = &v
	return s
}

// SetDocumentIdOptions sets the DocumentIdOptions field's value.
func (s *ElasticsearchDestinationConfiguration) SetDocumentIdOptions(v *DocumentIdOptions) *ElasticsearchDestinationConfiguration {
	s.DocumentIdOptions = v
	return s
}

// SetDomainARN sets the DomainARN field's value.
func (s *ElasticsearchDestinationConfiguration) SetDomainARN(v string) *ElasticsearchDestinationConfiguration {
	s.DomainARN = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ElasticsearchDestinationConfiguration) SetIndexName(v string) *ElasticsearchDestinationConfiguration {
	s.IndexName = &v
	return s
}

// SetIndexRotationPeriod sets the IndexRotationPeriod field's value.
func (s *ElasticsearchDestinationConfiguration) SetIndexRotationPeriod(v string) *ElasticsearchDestinationConfiguration {
	s.IndexRotationPeriod = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ElasticsearchDestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *ElasticsearchDestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *ElasticsearchDestinationConfiguration) SetRetryOptions(v *ElasticsearchRetryOptions) *ElasticsearchDestinationConfiguration {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ElasticsearchDestinationConfiguration) SetRoleARN(v string) *ElasticsearchDestinationConfiguration {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *ElasticsearchDestinationConfiguration) SetS3BackupMode(v string) *ElasticsearchDestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *ElasticsearchDestinationConfiguration) SetS3Configuration(v *S3DestinationConfiguration) *ElasticsearchDestinationConfiguration {
	s.S3Configuration = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ElasticsearchDestinationConfiguration) SetTypeName(v string) *ElasticsearchDestinationConfiguration {
	s.TypeName = &v
	return s
}

// SetVpcConfiguration sets the VpcConfiguration field's value.
func (s *ElasticsearchDestinationConfiguration) SetVpcConfiguration(v *VpcConfiguration) *ElasticsearchDestinationConfiguration {
	s.VpcConfiguration = v
	return s
}

// The destination description in Amazon ES.
type ElasticsearchDestinationDescription struct {
	_ struct{} `type:"structure"`

	// The buffering options.
	BufferingHints *ElasticsearchBufferingHints `type:"structure"`

	// The Amazon CloudWatch logging options.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The endpoint to use when communicating with the cluster. Kinesis Data Firehose
	// uses either this ClusterEndpoint or the DomainARN field to send data to Amazon
	// ES.
	ClusterEndpoint *string `min:"1" type:"string"`

	// Indicates the method for setting up document ID. The supported methods are
	// Kinesis Data Firehose generated document ID and OpenSearch Service generated
	// document ID.
	DocumentIdOptions *DocumentIdOptions `type:"structure"`

	// The ARN of the Amazon ES domain. For more information, see Amazon Resource
	// Names (ARNs) and Amazon Web Services Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// Kinesis Data Firehose uses either ClusterEndpoint or DomainARN to send data
	// to Amazon ES.
	DomainARN *string `min:"1" type:"string"`

	// The Elasticsearch index name.
	IndexName *string `min:"1" type:"string"`

	// The Elasticsearch index rotation period
	IndexRotationPeriod *string `type:"string" enum:"ElasticsearchIndexRotationPeriod"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The Amazon ES retry options.
	RetryOptions *ElasticsearchRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	RoleARN *string `min:"1" type:"string"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"ElasticsearchS3BackupMode"`

	// The Amazon S3 destination.
	S3DestinationDescription *S3DestinationDescription `type:"structure"`

	// The Elasticsearch type name. This applies to Elasticsearch 6.x and lower
	// versions. For Elasticsearch 7.x and OpenSearch Service 1.x, there's no value
	// for TypeName.
	TypeName *string `type:"string"`

	// The details of the VPC of the Amazon OpenSearch or the Amazon OpenSearch
	// Serverless destination.
	VpcConfigurationDescription *VpcConfigurationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchDestinationDescription) GoString() string {
	return s.String()
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ElasticsearchDestinationDescription) SetBufferingHints(v *ElasticsearchBufferingHints) *ElasticsearchDestinationDescription {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ElasticsearchDestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ElasticsearchDestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterEndpoint sets the ClusterEndpoint field's value.
func (s *ElasticsearchDestinationDescription) SetClusterEndpoint(v string) *ElasticsearchDestinationDescription {
	s.ClusterEndpoint = &v
	return s
}

// SetDocumentIdOptions sets the DocumentIdOptions field's value.
func (s *ElasticsearchDestinationDescription) SetDocumentIdOptions(v *DocumentIdOptions) *ElasticsearchDestinationDescription {
	s.DocumentIdOptions = v
	return s
}

// SetDomainARN sets the DomainARN field's value.
func (s *ElasticsearchDestinationDescription) SetDomainARN(v string) *ElasticsearchDestinationDescription {
	s.DomainARN = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ElasticsearchDestinationDescription) SetIndexName(v string) *ElasticsearchDestinationDescription {
	s.IndexName = &v
	return s
}

// SetIndexRotationPeriod sets the IndexRotationPeriod field's value.
func (s *ElasticsearchDestinationDescription) SetIndexRotationPeriod(v string) *ElasticsearchDestinationDescription {
	s.IndexRotationPeriod = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ElasticsearchDestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *ElasticsearchDestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *ElasticsearchDestinationDescription) SetRetryOptions(v *ElasticsearchRetryOptions) *ElasticsearchDestinationDescription {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ElasticsearchDestinationDescription) SetRoleARN(v string) *ElasticsearchDestinationDescription {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *ElasticsearchDestinationDescription) SetS3BackupMode(v string) *ElasticsearchDestinationDescription {
	s.S3BackupMode = &v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *ElasticsearchDestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *ElasticsearchDestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ElasticsearchDestinationDescription) SetTypeName(v string) *ElasticsearchDestinationDescription {
	s.TypeName = &v
	return s
}

// SetVpcConfigurationDescription sets the VpcConfigurationDescription field's value.
func (s *ElasticsearchDestinationDescription) SetVpcConfigurationDescription(v *VpcConfigurationDescription) *ElasticsearchDestinationDescription {
	s.VpcConfigurationDescription = v
	return s
}

// Describes an update for a destination in Amazon ES.
type ElasticsearchDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The buffering options. If no value is specified, ElasticsearchBufferingHints
	// object default values are used.
	BufferingHints *ElasticsearchBufferingHints `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The endpoint to use when communicating with the cluster. Specify either this
	// ClusterEndpoint or the DomainARN field.
	ClusterEndpoint *string `min:"1" type:"string"`

	// Indicates the method for setting up document ID. The supported methods are
	// Kinesis Data Firehose generated document ID and OpenSearch Service generated
	// document ID.
	DocumentIdOptions *DocumentIdOptions `type:"structure"`

	// The ARN of the Amazon ES domain. The IAM role must have permissions for DescribeDomain,
	// DescribeDomains, and DescribeDomainConfig after assuming the IAM role specified
	// in RoleARN. For more information, see Amazon Resource Names (ARNs) and Amazon
	// Web Services Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// Specify either ClusterEndpoint or DomainARN.
	DomainARN *string `min:"1" type:"string"`

	// The Elasticsearch index name.
	IndexName *string `min:"1" type:"string"`

	// The Elasticsearch index rotation period. Index rotation appends a timestamp
	// to IndexName to facilitate the expiration of old data. For more information,
	// see Index Rotation for the Amazon ES Destination (https://docs.aws.amazon.com/firehose/latest/dev/basic-deliver.html#es-index-rotation).
	// Default value is OneDay.
	IndexRotationPeriod *string `type:"string" enum:"ElasticsearchIndexRotationPeriod"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver documents
	// to Amazon ES. The default value is 300 (5 minutes).
	RetryOptions *ElasticsearchRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM role to be assumed by Kinesis Data
	// Firehose for calling the Amazon ES Configuration API and for indexing documents.
	// For more information, see Grant Kinesis Data Firehose Access to an Amazon
	// S3 Destination (https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-s3)
	// and Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	RoleARN *string `min:"1" type:"string"`

	// The Amazon S3 destination.
	S3Update *S3DestinationUpdate `type:"structure"`

	// The Elasticsearch type name. For Elasticsearch 6.x, there can be only one
	// type per index. If you try to specify a new type for an existing index that
	// already has another type, Kinesis Data Firehose returns an error during runtime.
	//
	// If you upgrade Elasticsearch from 6.x to 7.x and don’t update your delivery
	// stream, Kinesis Data Firehose still delivers data to Elasticsearch with the
	// old index name and type name. If you want to update your delivery stream
	// with a new index name, provide an empty string for TypeName.
	TypeName *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchDestinationUpdate"}
	if s.ClusterEndpoint != nil && len(*s.ClusterEndpoint) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterEndpoint", 1))
	}
	if s.DomainARN != nil && len(*s.DomainARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainARN", 1))
	}
	if s.IndexName != nil && len(*s.IndexName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IndexName", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.DocumentIdOptions != nil {
		if err := s.DocumentIdOptions.Validate(); err != nil {
			invalidParams.AddNested("DocumentIdOptions", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ElasticsearchDestinationUpdate) SetBufferingHints(v *ElasticsearchBufferingHints) *ElasticsearchDestinationUpdate {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ElasticsearchDestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ElasticsearchDestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterEndpoint sets the ClusterEndpoint field's value.
func (s *ElasticsearchDestinationUpdate) SetClusterEndpoint(v string) *ElasticsearchDestinationUpdate {
	s.ClusterEndpoint = &v
	return s
}

// SetDocumentIdOptions sets the DocumentIdOptions field's value.
func (s *ElasticsearchDestinationUpdate) SetDocumentIdOptions(v *DocumentIdOptions) *ElasticsearchDestinationUpdate {
	s.DocumentIdOptions = v
	return s
}

// SetDomainARN sets the DomainARN field's value.
func (s *ElasticsearchDestinationUpdate) SetDomainARN(v string) *ElasticsearchDestinationUpdate {
	s.DomainARN = &v
	return s
}

// SetIndexName sets the IndexName field's value.
func (s *ElasticsearchDestinationUpdate) SetIndexName(v string) *ElasticsearchDestinationUpdate {
	s.IndexName = &v
	return s
}

// SetIndexRotationPeriod sets the IndexRotationPeriod field's value.
func (s *ElasticsearchDestinationUpdate) SetIndexRotationPeriod(v string) *ElasticsearchDestinationUpdate {
	s.IndexRotationPeriod = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ElasticsearchDestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *ElasticsearchDestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *ElasticsearchDestinationUpdate) SetRetryOptions(v *ElasticsearchRetryOptions) *ElasticsearchDestinationUpdate {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ElasticsearchDestinationUpdate) SetRoleARN(v string) *ElasticsearchDestinationUpdate {
	s.RoleARN = &v
	return s
}

// SetS3Update sets the S3Update field's value.
func (s *ElasticsearchDestinationUpdate) SetS3Update(v *S3DestinationUpdate) *ElasticsearchDestinationUpdate {
	s.S3Update = v
	return s
}

// SetTypeName sets the TypeName field's value.
func (s *ElasticsearchDestinationUpdate) SetTypeName(v string) *ElasticsearchDestinationUpdate {
	s.TypeName = &v
	return s
}

// Configures retry behavior in case Kinesis Data Firehose is unable to deliver
// documents to Amazon ES.
type ElasticsearchRetryOptions struct {
	_ struct{} `type:"structure"`

	// After an initial failure to deliver to Amazon ES, the total amount of time
	// during which Kinesis Data Firehose retries delivery (including the first
	// attempt). After this time has elapsed, the failed documents are written to
	// Amazon S3. Default value is 300 seconds (5 minutes). A value of 0 (zero)
	// results in no retries.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ElasticsearchRetryOptions) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *ElasticsearchRetryOptions) SetDurationInSeconds(v int64) *ElasticsearchRetryOptions {
	s.DurationInSeconds = &v
	return s
}

// Describes the encryption for a destination in Amazon S3.
type EncryptionConfiguration struct {
	_ struct{} `type:"structure"`

	// The encryption key.
	KMSEncryptionConfig *KMSEncryptionConfig `type:"structure"`

	// Specifically override existing encryption information to ensure that no encryption
	// is used.
	NoEncryptionConfig *string `type:"string" enum:"NoEncryptionConfig"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EncryptionConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EncryptionConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EncryptionConfiguration"}
	if s.KMSEncryptionConfig != nil {
		if err := s.KMSEncryptionConfig.Validate(); err != nil {
			invalidParams.AddNested("KMSEncryptionConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKMSEncryptionConfig sets the KMSEncryptionConfig field's value.
func (s *EncryptionConfiguration) SetKMSEncryptionConfig(v *KMSEncryptionConfig) *EncryptionConfiguration {
	s.KMSEncryptionConfig = v
	return s
}

// SetNoEncryptionConfig sets the NoEncryptionConfig field's value.
func (s *EncryptionConfiguration) SetNoEncryptionConfig(v string) *EncryptionConfiguration {
	s.NoEncryptionConfig = &v
	return s
}

// Describes the configuration of a destination in Amazon S3.
type ExtendedS3DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket. For more information, see Amazon Resource Names
	// (ARNs) and Amazon Web Services Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The buffering option.
	BufferingHints *BufferingHints `type:"structure"`

	// The Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The serializer, deserializer, and schema for converting data from the JSON
	// format to the Parquet or ORC format before writing it to Amazon S3.
	DataFormatConversionConfiguration *DataFormatConversionConfiguration `type:"structure"`

	// The configuration of the dynamic partitioning mechanism that creates smaller
	// data sets from the streaming data by partitioning it based on partition keys.
	// Currently, dynamic partitioning is only supported for Amazon S3 destinations.
	DynamicPartitioningConfiguration *DynamicPartitioningConfiguration `type:"structure"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// A prefix that Kinesis Data Firehose evaluates and adds to failed records
	// before writing them to S3. This prefix appears immediately following the
	// bucket name. For information about how to specify this prefix, see Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	ErrorOutputPrefix *string `type:"string"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// Amazon S3 files. You can also specify a custom prefix, as described in Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	Prefix *string `type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The configuration for backup in Amazon S3.
	S3BackupConfiguration *S3DestinationConfiguration `type:"structure"`

	// The Amazon S3 backup mode. After you create a delivery stream, you can update
	// it to enable Amazon S3 backup if it is disabled. If backup is enabled, you
	// can't update the delivery stream to disable it.
	S3BackupMode *string `type:"string" enum:"S3BackupMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendedS3DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendedS3DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtendedS3DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtendedS3DestinationConfiguration"}
	if s.BucketARN == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.DataFormatConversionConfiguration != nil {
		if err := s.DataFormatConversionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataFormatConversionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3BackupConfiguration != nil {
		if err := s.S3BackupConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3BackupConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *ExtendedS3DestinationConfiguration) SetBucketARN(v string) *ExtendedS3DestinationConfiguration {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ExtendedS3DestinationConfiguration) SetBufferingHints(v *BufferingHints) *ExtendedS3DestinationConfiguration {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ExtendedS3DestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ExtendedS3DestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *ExtendedS3DestinationConfiguration) SetCompressionFormat(v string) *ExtendedS3DestinationConfiguration {
	s.CompressionFormat = &v
	return s
}

// SetDataFormatConversionConfiguration sets the DataFormatConversionConfiguration field's value.
func (s *ExtendedS3DestinationConfiguration) SetDataFormatConversionConfiguration(v *DataFormatConversionConfiguration) *ExtendedS3DestinationConfiguration {
	s.DataFormatConversionConfiguration = v
	return s
}

// SetDynamicPartitioningConfiguration sets the DynamicPartitioningConfiguration field's value.
func (s *ExtendedS3DestinationConfiguration) SetDynamicPartitioningConfiguration(v *DynamicPartitioningConfiguration) *ExtendedS3DestinationConfiguration {
	s.DynamicPartitioningConfiguration = v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ExtendedS3DestinationConfiguration) SetEncryptionConfiguration(v *EncryptionConfiguration) *ExtendedS3DestinationConfiguration {
	s.EncryptionConfiguration = v
	return s
}

// SetErrorOutputPrefix sets the ErrorOutputPrefix field's value.
func (s *ExtendedS3DestinationConfiguration) SetErrorOutputPrefix(v string) *ExtendedS3DestinationConfiguration {
	s.ErrorOutputPrefix = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ExtendedS3DestinationConfiguration) SetPrefix(v string) *ExtendedS3DestinationConfiguration {
	s.Prefix = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ExtendedS3DestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *ExtendedS3DestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ExtendedS3DestinationConfiguration) SetRoleARN(v string) *ExtendedS3DestinationConfiguration {
	s.RoleARN = &v
	return s
}

// SetS3BackupConfiguration sets the S3BackupConfiguration field's value.
func (s *ExtendedS3DestinationConfiguration) SetS3BackupConfiguration(v *S3DestinationConfiguration) *ExtendedS3DestinationConfiguration {
	s.S3BackupConfiguration = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *ExtendedS3DestinationConfiguration) SetS3BackupMode(v string) *ExtendedS3DestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// Describes a destination in Amazon S3.
type ExtendedS3DestinationDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket. For more information, see Amazon Resource Names
	// (ARNs) and Amazon Web Services Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The buffering option.
	//
	// BufferingHints is a required field
	BufferingHints *BufferingHints `type:"structure" required:"true"`

	// The Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	//
	// CompressionFormat is a required field
	CompressionFormat *string `type:"string" required:"true" enum:"CompressionFormat"`

	// The serializer, deserializer, and schema for converting data from the JSON
	// format to the Parquet or ORC format before writing it to Amazon S3.
	DataFormatConversionConfiguration *DataFormatConversionConfiguration `type:"structure"`

	// The configuration of the dynamic partitioning mechanism that creates smaller
	// data sets from the streaming data by partitioning it based on partition keys.
	// Currently, dynamic partitioning is only supported for Amazon S3 destinations.
	DynamicPartitioningConfiguration *DynamicPartitioningConfiguration `type:"structure"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	//
	// EncryptionConfiguration is a required field
	EncryptionConfiguration *EncryptionConfiguration `type:"structure" required:"true"`

	// A prefix that Kinesis Data Firehose evaluates and adds to failed records
	// before writing them to S3. This prefix appears immediately following the
	// bucket name. For information about how to specify this prefix, see Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	ErrorOutputPrefix *string `type:"string"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// Amazon S3 files. You can also specify a custom prefix, as described in Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	Prefix *string `type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The configuration for backup in Amazon S3.
	S3BackupDescription *S3DestinationDescription `type:"structure"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"S3BackupMode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendedS3DestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendedS3DestinationDescription) GoString() string {
	return s.String()
}

// SetBucketARN sets the BucketARN field's value.
func (s *ExtendedS3DestinationDescription) SetBucketARN(v string) *ExtendedS3DestinationDescription {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ExtendedS3DestinationDescription) SetBufferingHints(v *BufferingHints) *ExtendedS3DestinationDescription {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ExtendedS3DestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ExtendedS3DestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *ExtendedS3DestinationDescription) SetCompressionFormat(v string) *ExtendedS3DestinationDescription {
	s.CompressionFormat = &v
	return s
}

// SetDataFormatConversionConfiguration sets the DataFormatConversionConfiguration field's value.
func (s *ExtendedS3DestinationDescription) SetDataFormatConversionConfiguration(v *DataFormatConversionConfiguration) *ExtendedS3DestinationDescription {
	s.DataFormatConversionConfiguration = v
	return s
}

// SetDynamicPartitioningConfiguration sets the DynamicPartitioningConfiguration field's value.
func (s *ExtendedS3DestinationDescription) SetDynamicPartitioningConfiguration(v *DynamicPartitioningConfiguration) *ExtendedS3DestinationDescription {
	s.DynamicPartitioningConfiguration = v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ExtendedS3DestinationDescription) SetEncryptionConfiguration(v *EncryptionConfiguration) *ExtendedS3DestinationDescription {
	s.EncryptionConfiguration = v
	return s
}

// SetErrorOutputPrefix sets the ErrorOutputPrefix field's value.
func (s *ExtendedS3DestinationDescription) SetErrorOutputPrefix(v string) *ExtendedS3DestinationDescription {
	s.ErrorOutputPrefix = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ExtendedS3DestinationDescription) SetPrefix(v string) *ExtendedS3DestinationDescription {
	s.Prefix = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ExtendedS3DestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *ExtendedS3DestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ExtendedS3DestinationDescription) SetRoleARN(v string) *ExtendedS3DestinationDescription {
	s.RoleARN = &v
	return s
}

// SetS3BackupDescription sets the S3BackupDescription field's value.
func (s *ExtendedS3DestinationDescription) SetS3BackupDescription(v *S3DestinationDescription) *ExtendedS3DestinationDescription {
	s.S3BackupDescription = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *ExtendedS3DestinationDescription) SetS3BackupMode(v string) *ExtendedS3DestinationDescription {
	s.S3BackupMode = &v
	return s
}

// Describes an update for a destination in Amazon S3.
type ExtendedS3DestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket. For more information, see Amazon Resource Names
	// (ARNs) and Amazon Web Services Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	BucketARN *string `min:"1" type:"string"`

	// The buffering option.
	BufferingHints *BufferingHints `type:"structure"`

	// The Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The serializer, deserializer, and schema for converting data from the JSON
	// format to the Parquet or ORC format before writing it to Amazon S3.
	DataFormatConversionConfiguration *DataFormatConversionConfiguration `type:"structure"`

	// The configuration of the dynamic partitioning mechanism that creates smaller
	// data sets from the streaming data by partitioning it based on partition keys.
	// Currently, dynamic partitioning is only supported for Amazon S3 destinations.
	DynamicPartitioningConfiguration *DynamicPartitioningConfiguration `type:"structure"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// A prefix that Kinesis Data Firehose evaluates and adds to failed records
	// before writing them to S3. This prefix appears immediately following the
	// bucket name. For information about how to specify this prefix, see Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	ErrorOutputPrefix *string `type:"string"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// Amazon S3 files. You can also specify a custom prefix, as described in Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	Prefix *string `type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	RoleARN *string `min:"1" type:"string"`

	// You can update a delivery stream to enable Amazon S3 backup if it is disabled.
	// If backup is enabled, you can't update the delivery stream to disable it.
	S3BackupMode *string `type:"string" enum:"S3BackupMode"`

	// The Amazon S3 destination for backup.
	S3BackupUpdate *S3DestinationUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendedS3DestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExtendedS3DestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExtendedS3DestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExtendedS3DestinationUpdate"}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.DataFormatConversionConfiguration != nil {
		if err := s.DataFormatConversionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("DataFormatConversionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3BackupUpdate != nil {
		if err := s.S3BackupUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3BackupUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *ExtendedS3DestinationUpdate) SetBucketARN(v string) *ExtendedS3DestinationUpdate {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *ExtendedS3DestinationUpdate) SetBufferingHints(v *BufferingHints) *ExtendedS3DestinationUpdate {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *ExtendedS3DestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *ExtendedS3DestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *ExtendedS3DestinationUpdate) SetCompressionFormat(v string) *ExtendedS3DestinationUpdate {
	s.CompressionFormat = &v
	return s
}

// SetDataFormatConversionConfiguration sets the DataFormatConversionConfiguration field's value.
func (s *ExtendedS3DestinationUpdate) SetDataFormatConversionConfiguration(v *DataFormatConversionConfiguration) *ExtendedS3DestinationUpdate {
	s.DataFormatConversionConfiguration = v
	return s
}

// SetDynamicPartitioningConfiguration sets the DynamicPartitioningConfiguration field's value.
func (s *ExtendedS3DestinationUpdate) SetDynamicPartitioningConfiguration(v *DynamicPartitioningConfiguration) *ExtendedS3DestinationUpdate {
	s.DynamicPartitioningConfiguration = v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *ExtendedS3DestinationUpdate) SetEncryptionConfiguration(v *EncryptionConfiguration) *ExtendedS3DestinationUpdate {
	s.EncryptionConfiguration = v
	return s
}

// SetErrorOutputPrefix sets the ErrorOutputPrefix field's value.
func (s *ExtendedS3DestinationUpdate) SetErrorOutputPrefix(v string) *ExtendedS3DestinationUpdate {
	s.ErrorOutputPrefix = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *ExtendedS3DestinationUpdate) SetPrefix(v string) *ExtendedS3DestinationUpdate {
	s.Prefix = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *ExtendedS3DestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *ExtendedS3DestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *ExtendedS3DestinationUpdate) SetRoleARN(v string) *ExtendedS3DestinationUpdate {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *ExtendedS3DestinationUpdate) SetS3BackupMode(v string) *ExtendedS3DestinationUpdate {
	s.S3BackupMode = &v
	return s
}

// SetS3BackupUpdate sets the S3BackupUpdate field's value.
func (s *ExtendedS3DestinationUpdate) SetS3BackupUpdate(v *S3DestinationUpdate) *ExtendedS3DestinationUpdate {
	s.S3BackupUpdate = v
	return s
}

// Provides details in case one of the following operations fails due to an
// error related to KMS: CreateDeliveryStream, DeleteDeliveryStream, StartDeliveryStreamEncryption,
// StopDeliveryStreamEncryption.
type FailureDescription struct {
	_ struct{} `type:"structure"`

	// A message providing details about the error that caused the failure.
	//
	// Details is a required field
	Details *string `min:"1" type:"string" required:"true"`

	// The type of error that caused the failure.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"DeliveryStreamFailureType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailureDescription) GoString() string {
	return s.String()
}

// SetDetails sets the Details field's value.
func (s *FailureDescription) SetDetails(v string) *FailureDescription {
	s.Details = &v
	return s
}

// SetType sets the Type field's value.
func (s *FailureDescription) SetType(v string) *FailureDescription {
	s.Type = &v
	return s
}

// The native Hive / HCatalog JsonSerDe. Used by Kinesis Data Firehose for deserializing
// data, which means converting it from the JSON format in preparation for serializing
// it to the Parquet or ORC format. This is one of two deserializers you can
// choose, depending on which one offers the functionality you need. The other
// option is the OpenX SerDe.
type HiveJsonSerDe struct {
	_ struct{} `type:"structure"`

	// Indicates how you want Kinesis Data Firehose to parse the date and timestamps
	// that may be present in your input data JSON. To specify these format strings,
	// follow the pattern syntax of JodaTime's DateTimeFormat format strings. For
	// more information, see Class DateTimeFormat (https://www.joda.org/joda-time/apidocs/org/joda/time/format/DateTimeFormat.html).
	// You can also use the special value millis to parse timestamps in epoch milliseconds.
	// If you don't specify a format, Kinesis Data Firehose uses java.sql.Timestamp::valueOf
	// by default.
	TimestampFormats []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HiveJsonSerDe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HiveJsonSerDe) GoString() string {
	return s.String()
}

// SetTimestampFormats sets the TimestampFormats field's value.
func (s *HiveJsonSerDe) SetTimestampFormats(v []*string) *HiveJsonSerDe {
	s.TimestampFormats = v
	return s
}

// Describes the buffering options that can be applied before data is delivered
// to the HTTP endpoint destination. Kinesis Data Firehose treats these options
// as hints, and it might choose to use more optimal values. The SizeInMBs and
// IntervalInSeconds parameters are optional. However, if specify a value for
// one of them, you must also provide a value for the other.
type HttpEndpointBufferingHints struct {
	_ struct{} `type:"structure"`

	// Buffer incoming data for the specified period of time, in seconds, before
	// delivering it to the destination. The default value is 300 (5 minutes).
	IntervalInSeconds *int64 `min:"60" type:"integer"`

	// Buffer incoming data to the specified size, in MBs, before delivering it
	// to the destination. The default value is 5.
	//
	// We recommend setting this parameter to a value greater than the amount of
	// data you typically ingest into the delivery stream in 10 seconds. For example,
	// if you typically ingest data at 1 MB/sec, the value should be 10 MB or higher.
	SizeInMBs *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointBufferingHints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointBufferingHints) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpEndpointBufferingHints) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpEndpointBufferingHints"}
	if s.IntervalInSeconds != nil && *s.IntervalInSeconds < 60 {
		invalidParams.Add(request.NewErrParamMinValue("IntervalInSeconds", 60))
	}
	if s.SizeInMBs != nil && *s.SizeInMBs < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SizeInMBs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIntervalInSeconds sets the IntervalInSeconds field's value.
func (s *HttpEndpointBufferingHints) SetIntervalInSeconds(v int64) *HttpEndpointBufferingHints {
	s.IntervalInSeconds = &v
	return s
}

// SetSizeInMBs sets the SizeInMBs field's value.
func (s *HttpEndpointBufferingHints) SetSizeInMBs(v int64) *HttpEndpointBufferingHints {
	s.SizeInMBs = &v
	return s
}

// Describes the metadata that's delivered to the specified HTTP endpoint destination.
type HttpEndpointCommonAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the HTTP endpoint common attribute.
	//
	// AttributeName is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by HttpEndpointCommonAttribute's
	// String and GoString methods.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true" sensitive:"true"`

	// The value of the HTTP endpoint common attribute.
	//
	// AttributeValue is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by HttpEndpointCommonAttribute's
	// String and GoString methods.
	//
	// AttributeValue is a required field
	AttributeValue *string `type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointCommonAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointCommonAttribute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpEndpointCommonAttribute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpEndpointCommonAttribute"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.AttributeValue == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeValue"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *HttpEndpointCommonAttribute) SetAttributeName(v string) *HttpEndpointCommonAttribute {
	s.AttributeName = &v
	return s
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *HttpEndpointCommonAttribute) SetAttributeValue(v string) *HttpEndpointCommonAttribute {
	s.AttributeValue = &v
	return s
}

// Describes the configuration of the HTTP endpoint to which Kinesis Firehose
// delivers data.
type HttpEndpointConfiguration struct {
	_ struct{} `type:"structure"`

	// The access key required for Kinesis Firehose to authenticate with the HTTP
	// endpoint selected as the destination.
	//
	// AccessKey is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by HttpEndpointConfiguration's
	// String and GoString methods.
	AccessKey *string `type:"string" sensitive:"true"`

	// The name of the HTTP endpoint selected as the destination.
	Name *string `min:"1" type:"string"`

	// The URL of the HTTP endpoint selected as the destination.
	//
	// If you choose an HTTP endpoint as your destination, review and follow the
	// instructions in the Appendix - HTTP Endpoint Delivery Request and Response
	// Specifications (https://docs.aws.amazon.com/firehose/latest/dev/httpdeliveryrequestresponse.html).
	//
	// Url is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by HttpEndpointConfiguration's
	// String and GoString methods.
	//
	// Url is a required field
	Url *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpEndpointConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpEndpointConfiguration"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Url == nil {
		invalidParams.Add(request.NewErrParamRequired("Url"))
	}
	if s.Url != nil && len(*s.Url) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Url", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessKey sets the AccessKey field's value.
func (s *HttpEndpointConfiguration) SetAccessKey(v string) *HttpEndpointConfiguration {
	s.AccessKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *HttpEndpointConfiguration) SetName(v string) *HttpEndpointConfiguration {
	s.Name = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *HttpEndpointConfiguration) SetUrl(v string) *HttpEndpointConfiguration {
	s.Url = &v
	return s
}

// Describes the HTTP endpoint selected as the destination.
type HttpEndpointDescription struct {
	_ struct{} `type:"structure"`

	// The name of the HTTP endpoint selected as the destination.
	Name *string `min:"1" type:"string"`

	// The URL of the HTTP endpoint selected as the destination.
	//
	// Url is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by HttpEndpointDescription's
	// String and GoString methods.
	Url *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointDescription) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *HttpEndpointDescription) SetName(v string) *HttpEndpointDescription {
	s.Name = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *HttpEndpointDescription) SetUrl(v string) *HttpEndpointDescription {
	s.Url = &v
	return s
}

// Describes the configuration of the HTTP endpoint destination.
type HttpEndpointDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The buffering options that can be used before data is delivered to the specified
	// destination. Kinesis Data Firehose treats these options as hints, and it
	// might choose to use more optimal values. The SizeInMBs and IntervalInSeconds
	// parameters are optional. However, if you specify a value for one of them,
	// you must also provide a value for the other.
	BufferingHints *HttpEndpointBufferingHints `type:"structure"`

	// Describes the Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The configuration of the HTTP endpoint selected as the destination.
	//
	// EndpointConfiguration is a required field
	EndpointConfiguration *HttpEndpointConfiguration `type:"structure" required:"true"`

	// Describes a data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The configuration of the requeste sent to the HTTP endpoint specified as
	// the destination.
	RequestConfiguration *HttpEndpointRequestConfiguration `type:"structure"`

	// Describes the retry behavior in case Kinesis Data Firehose is unable to deliver
	// data to the specified HTTP endpoint destination, or if it doesn't receive
	// a valid acknowledgment of receipt from the specified HTTP endpoint destination.
	RetryOptions *HttpEndpointRetryOptions `type:"structure"`

	// Kinesis Data Firehose uses this IAM role for all the permissions that the
	// delivery stream needs.
	RoleARN *string `min:"1" type:"string"`

	// Describes the S3 bucket backup options for the data that Kinesis Data Firehose
	// delivers to the HTTP endpoint destination. You can back up all documents
	// (AllData) or only the documents that Kinesis Data Firehose could not deliver
	// to the specified HTTP endpoint destination (FailedDataOnly).
	S3BackupMode *string `type:"string" enum:"HttpEndpointS3BackupMode"`

	// Describes the configuration of a destination in Amazon S3.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpEndpointDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpEndpointDestinationConfiguration"}
	if s.EndpointConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointConfiguration"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.EndpointConfiguration != nil {
		if err := s.EndpointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EndpointConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RequestConfiguration != nil {
		if err := s.RequestConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RequestConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *HttpEndpointDestinationConfiguration) SetBufferingHints(v *HttpEndpointBufferingHints) *HttpEndpointDestinationConfiguration {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *HttpEndpointDestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *HttpEndpointDestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetEndpointConfiguration sets the EndpointConfiguration field's value.
func (s *HttpEndpointDestinationConfiguration) SetEndpointConfiguration(v *HttpEndpointConfiguration) *HttpEndpointDestinationConfiguration {
	s.EndpointConfiguration = v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *HttpEndpointDestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *HttpEndpointDestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRequestConfiguration sets the RequestConfiguration field's value.
func (s *HttpEndpointDestinationConfiguration) SetRequestConfiguration(v *HttpEndpointRequestConfiguration) *HttpEndpointDestinationConfiguration {
	s.RequestConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *HttpEndpointDestinationConfiguration) SetRetryOptions(v *HttpEndpointRetryOptions) *HttpEndpointDestinationConfiguration {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *HttpEndpointDestinationConfiguration) SetRoleARN(v string) *HttpEndpointDestinationConfiguration {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *HttpEndpointDestinationConfiguration) SetS3BackupMode(v string) *HttpEndpointDestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *HttpEndpointDestinationConfiguration) SetS3Configuration(v *S3DestinationConfiguration) *HttpEndpointDestinationConfiguration {
	s.S3Configuration = v
	return s
}

// Describes the HTTP endpoint destination.
type HttpEndpointDestinationDescription struct {
	_ struct{} `type:"structure"`

	// Describes buffering options that can be applied to the data before it is
	// delivered to the HTTPS endpoint destination. Kinesis Data Firehose teats
	// these options as hints, and it might choose to use more optimal values. The
	// SizeInMBs and IntervalInSeconds parameters are optional. However, if specify
	// a value for one of them, you must also provide a value for the other.
	BufferingHints *HttpEndpointBufferingHints `type:"structure"`

	// Describes the Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The configuration of the specified HTTP endpoint destination.
	EndpointConfiguration *HttpEndpointDescription `type:"structure"`

	// Describes a data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The configuration of request sent to the HTTP endpoint specified as the destination.
	RequestConfiguration *HttpEndpointRequestConfiguration `type:"structure"`

	// Describes the retry behavior in case Kinesis Data Firehose is unable to deliver
	// data to the specified HTTP endpoint destination, or if it doesn't receive
	// a valid acknowledgment of receipt from the specified HTTP endpoint destination.
	RetryOptions *HttpEndpointRetryOptions `type:"structure"`

	// Kinesis Data Firehose uses this IAM role for all the permissions that the
	// delivery stream needs.
	RoleARN *string `min:"1" type:"string"`

	// Describes the S3 bucket backup options for the data that Kinesis Firehose
	// delivers to the HTTP endpoint destination. You can back up all documents
	// (AllData) or only the documents that Kinesis Data Firehose could not deliver
	// to the specified HTTP endpoint destination (FailedDataOnly).
	S3BackupMode *string `type:"string" enum:"HttpEndpointS3BackupMode"`

	// Describes a destination in Amazon S3.
	S3DestinationDescription *S3DestinationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointDestinationDescription) GoString() string {
	return s.String()
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *HttpEndpointDestinationDescription) SetBufferingHints(v *HttpEndpointBufferingHints) *HttpEndpointDestinationDescription {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *HttpEndpointDestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *HttpEndpointDestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetEndpointConfiguration sets the EndpointConfiguration field's value.
func (s *HttpEndpointDestinationDescription) SetEndpointConfiguration(v *HttpEndpointDescription) *HttpEndpointDestinationDescription {
	s.EndpointConfiguration = v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *HttpEndpointDestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *HttpEndpointDestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRequestConfiguration sets the RequestConfiguration field's value.
func (s *HttpEndpointDestinationDescription) SetRequestConfiguration(v *HttpEndpointRequestConfiguration) *HttpEndpointDestinationDescription {
	s.RequestConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *HttpEndpointDestinationDescription) SetRetryOptions(v *HttpEndpointRetryOptions) *HttpEndpointDestinationDescription {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *HttpEndpointDestinationDescription) SetRoleARN(v string) *HttpEndpointDestinationDescription {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *HttpEndpointDestinationDescription) SetS3BackupMode(v string) *HttpEndpointDestinationDescription {
	s.S3BackupMode = &v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *HttpEndpointDestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *HttpEndpointDestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// Updates the specified HTTP endpoint destination.
type HttpEndpointDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// Describes buffering options that can be applied to the data before it is
	// delivered to the HTTPS endpoint destination. Kinesis Data Firehose teats
	// these options as hints, and it might choose to use more optimal values. The
	// SizeInMBs and IntervalInSeconds parameters are optional. However, if specify
	// a value for one of them, you must also provide a value for the other.
	BufferingHints *HttpEndpointBufferingHints `type:"structure"`

	// Describes the Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// Describes the configuration of the HTTP endpoint destination.
	EndpointConfiguration *HttpEndpointConfiguration `type:"structure"`

	// Describes a data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The configuration of the request sent to the HTTP endpoint specified as the
	// destination.
	RequestConfiguration *HttpEndpointRequestConfiguration `type:"structure"`

	// Describes the retry behavior in case Kinesis Data Firehose is unable to deliver
	// data to the specified HTTP endpoint destination, or if it doesn't receive
	// a valid acknowledgment of receipt from the specified HTTP endpoint destination.
	RetryOptions *HttpEndpointRetryOptions `type:"structure"`

	// Kinesis Data Firehose uses this IAM role for all the permissions that the
	// delivery stream needs.
	RoleARN *string `min:"1" type:"string"`

	// Describes the S3 bucket backup options for the data that Kinesis Firehose
	// delivers to the HTTP endpoint destination. You can back up all documents
	// (AllData) or only the documents that Kinesis Data Firehose could not deliver
	// to the specified HTTP endpoint destination (FailedDataOnly).
	S3BackupMode *string `type:"string" enum:"HttpEndpointS3BackupMode"`

	// Describes an update for a destination in Amazon S3.
	S3Update *S3DestinationUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpEndpointDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpEndpointDestinationUpdate"}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.EndpointConfiguration != nil {
		if err := s.EndpointConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EndpointConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.RequestConfiguration != nil {
		if err := s.RequestConfiguration.Validate(); err != nil {
			invalidParams.AddNested("RequestConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *HttpEndpointDestinationUpdate) SetBufferingHints(v *HttpEndpointBufferingHints) *HttpEndpointDestinationUpdate {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *HttpEndpointDestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *HttpEndpointDestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetEndpointConfiguration sets the EndpointConfiguration field's value.
func (s *HttpEndpointDestinationUpdate) SetEndpointConfiguration(v *HttpEndpointConfiguration) *HttpEndpointDestinationUpdate {
	s.EndpointConfiguration = v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *HttpEndpointDestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *HttpEndpointDestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRequestConfiguration sets the RequestConfiguration field's value.
func (s *HttpEndpointDestinationUpdate) SetRequestConfiguration(v *HttpEndpointRequestConfiguration) *HttpEndpointDestinationUpdate {
	s.RequestConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *HttpEndpointDestinationUpdate) SetRetryOptions(v *HttpEndpointRetryOptions) *HttpEndpointDestinationUpdate {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *HttpEndpointDestinationUpdate) SetRoleARN(v string) *HttpEndpointDestinationUpdate {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *HttpEndpointDestinationUpdate) SetS3BackupMode(v string) *HttpEndpointDestinationUpdate {
	s.S3BackupMode = &v
	return s
}

// SetS3Update sets the S3Update field's value.
func (s *HttpEndpointDestinationUpdate) SetS3Update(v *S3DestinationUpdate) *HttpEndpointDestinationUpdate {
	s.S3Update = v
	return s
}

// The configuration of the HTTP endpoint request.
type HttpEndpointRequestConfiguration struct {
	_ struct{} `type:"structure"`

	// Describes the metadata sent to the HTTP endpoint destination.
	CommonAttributes []*HttpEndpointCommonAttribute `type:"list"`

	// Kinesis Data Firehose uses the content encoding to compress the body of a
	// request before sending the request to the destination. For more information,
	// see Content-Encoding (https://developer.mozilla.org/en-US/docs/Web/HTTP/Headers/Content-Encoding)
	// in MDN Web Docs, the official Mozilla documentation.
	ContentEncoding *string `type:"string" enum:"ContentEncoding"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointRequestConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointRequestConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HttpEndpointRequestConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HttpEndpointRequestConfiguration"}
	if s.CommonAttributes != nil {
		for i, v := range s.CommonAttributes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CommonAttributes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommonAttributes sets the CommonAttributes field's value.
func (s *HttpEndpointRequestConfiguration) SetCommonAttributes(v []*HttpEndpointCommonAttribute) *HttpEndpointRequestConfiguration {
	s.CommonAttributes = v
	return s
}

// SetContentEncoding sets the ContentEncoding field's value.
func (s *HttpEndpointRequestConfiguration) SetContentEncoding(v string) *HttpEndpointRequestConfiguration {
	s.ContentEncoding = &v
	return s
}

// Describes the retry behavior in case Kinesis Data Firehose is unable to deliver
// data to the specified HTTP endpoint destination, or if it doesn't receive
// a valid acknowledgment of receipt from the specified HTTP endpoint destination.
type HttpEndpointRetryOptions struct {
	_ struct{} `type:"structure"`

	// The total amount of time that Kinesis Data Firehose spends on retries. This
	// duration starts after the initial attempt to send data to the custom destination
	// via HTTPS endpoint fails. It doesn't include the periods during which Kinesis
	// Data Firehose waits for acknowledgment from the specified destination after
	// each attempt.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HttpEndpointRetryOptions) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *HttpEndpointRetryOptions) SetDurationInSeconds(v int64) *HttpEndpointRetryOptions {
	s.DurationInSeconds = &v
	return s
}

// Specifies the deserializer you want to use to convert the format of the input
// data. This parameter is required if Enabled is set to true.
type InputFormatConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies which deserializer to use. You can choose either the Apache Hive
	// JSON SerDe or the OpenX JSON SerDe. If both are non-null, the server rejects
	// the request.
	Deserializer *Deserializer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputFormatConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InputFormatConfiguration) GoString() string {
	return s.String()
}

// SetDeserializer sets the Deserializer field's value.
func (s *InputFormatConfiguration) SetDeserializer(v *Deserializer) *InputFormatConfiguration {
	s.Deserializer = v
	return s
}

// The specified input parameter has a value that is not valid.
type InvalidArgumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidArgumentException) GoString() string {
	return s.String()
}

func newErrorInvalidArgumentException(v protocol.ResponseMetadata) error {
	return &InvalidArgumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidArgumentException) Code() string {
	return "InvalidArgumentException"
}

// Message returns the exception's message.
func (s *InvalidArgumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidArgumentException) OrigErr() error {
	return nil
}

func (s *InvalidArgumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidArgumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidArgumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Kinesis Data Firehose throws this exception when an attempt to put records
// or to start or stop delivery stream encryption fails. This happens when the
// KMS service throws one of the following exception types: AccessDeniedException,
// InvalidStateException, DisabledException, or NotFoundException.
type InvalidKMSResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidKMSResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidKMSResourceException) GoString() string {
	return s.String()
}

func newErrorInvalidKMSResourceException(v protocol.ResponseMetadata) error {
	return &InvalidKMSResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidKMSResourceException) Code() string {
	return "InvalidKMSResourceException"
}

// Message returns the exception's message.
func (s *InvalidKMSResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidKMSResourceException) OrigErr() error {
	return nil
}

func (s *InvalidKMSResourceException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidKMSResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidKMSResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes an encryption key for a destination in Amazon S3.
type KMSEncryptionConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the encryption key. Must belong to the
	// same Amazon Web Services Region as the destination Amazon S3 bucket. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// AWSKMSKeyARN is a required field
	AWSKMSKeyARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSEncryptionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KMSEncryptionConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KMSEncryptionConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KMSEncryptionConfig"}
	if s.AWSKMSKeyARN == nil {
		invalidParams.Add(request.NewErrParamRequired("AWSKMSKeyARN"))
	}
	if s.AWSKMSKeyARN != nil && len(*s.AWSKMSKeyARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AWSKMSKeyARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAWSKMSKeyARN sets the AWSKMSKeyARN field's value.
func (s *KMSEncryptionConfig) SetAWSKMSKeyARN(v string) *KMSEncryptionConfig {
	s.AWSKMSKeyARN = &v
	return s
}

// The stream and role Amazon Resource Names (ARNs) for a Kinesis data stream
// used as the source for a delivery stream.
type KinesisStreamSourceConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the source Kinesis data stream. For more information, see Amazon
	// Kinesis Data Streams ARN Format (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
	//
	// KinesisStreamARN is a required field
	KinesisStreamARN *string `min:"1" type:"string" required:"true"`

	// The ARN of the role that provides access to the source Kinesis data stream.
	// For more information, see Amazon Web Services Identity and Access Management
	// (IAM) ARN Format (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam).
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamSourceConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamSourceConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *KinesisStreamSourceConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "KinesisStreamSourceConfiguration"}
	if s.KinesisStreamARN == nil {
		invalidParams.Add(request.NewErrParamRequired("KinesisStreamARN"))
	}
	if s.KinesisStreamARN != nil && len(*s.KinesisStreamARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KinesisStreamARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKinesisStreamARN sets the KinesisStreamARN field's value.
func (s *KinesisStreamSourceConfiguration) SetKinesisStreamARN(v string) *KinesisStreamSourceConfiguration {
	s.KinesisStreamARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamSourceConfiguration) SetRoleARN(v string) *KinesisStreamSourceConfiguration {
	s.RoleARN = &v
	return s
}

// Details about a Kinesis data stream used as the source for a Kinesis Data
// Firehose delivery stream.
type KinesisStreamSourceDescription struct {
	_ struct{} `type:"structure"`

	// Kinesis Data Firehose starts retrieving records from the Kinesis data stream
	// starting with this timestamp.
	DeliveryStartTimestamp *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the source Kinesis data stream. For more
	// information, see Amazon Kinesis Data Streams ARN Format (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-kinesis-streams).
	KinesisStreamARN *string `min:"1" type:"string"`

	// The ARN of the role used by the source Kinesis data stream. For more information,
	// see Amazon Web Services Identity and Access Management (IAM) ARN Format (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam).
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamSourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s KinesisStreamSourceDescription) GoString() string {
	return s.String()
}

// SetDeliveryStartTimestamp sets the DeliveryStartTimestamp field's value.
func (s *KinesisStreamSourceDescription) SetDeliveryStartTimestamp(v time.Time) *KinesisStreamSourceDescription {
	s.DeliveryStartTimestamp = &v
	return s
}

// SetKinesisStreamARN sets the KinesisStreamARN field's value.
func (s *KinesisStreamSourceDescription) SetKinesisStreamARN(v string) *KinesisStreamSourceDescription {
	s.KinesisStreamARN = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *KinesisStreamSourceDescription) SetRoleARN(v string) *KinesisStreamSourceDescription {
	s.RoleARN = &v
	return s
}

// You have already reached the limit for a requested resource.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDeliveryStreamsInput struct {
	_ struct{} `type:"structure"`

	// The delivery stream type. This can be one of the following values:
	//
	//    * DirectPut: Provider applications access the delivery stream directly.
	//
	//    * KinesisStreamAsSource: The delivery stream uses a Kinesis data stream
	//    as a source.
	//
	// This parameter is optional. If this parameter is omitted, delivery streams
	// of all types are returned.
	DeliveryStreamType *string `type:"string" enum:"DeliveryStreamType"`

	// The list of delivery streams returned by this call to ListDeliveryStreams
	// will start with the delivery stream whose name comes alphabetically immediately
	// after the name you specify in ExclusiveStartDeliveryStreamName.
	ExclusiveStartDeliveryStreamName *string `min:"1" type:"string"`

	// The maximum number of delivery streams to list. The default value is 10.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeliveryStreamsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeliveryStreamsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeliveryStreamsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeliveryStreamsInput"}
	if s.ExclusiveStartDeliveryStreamName != nil && len(*s.ExclusiveStartDeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartDeliveryStreamName", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamType sets the DeliveryStreamType field's value.
func (s *ListDeliveryStreamsInput) SetDeliveryStreamType(v string) *ListDeliveryStreamsInput {
	s.DeliveryStreamType = &v
	return s
}

// SetExclusiveStartDeliveryStreamName sets the ExclusiveStartDeliveryStreamName field's value.
func (s *ListDeliveryStreamsInput) SetExclusiveStartDeliveryStreamName(v string) *ListDeliveryStreamsInput {
	s.ExclusiveStartDeliveryStreamName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListDeliveryStreamsInput) SetLimit(v int64) *ListDeliveryStreamsInput {
	s.Limit = &v
	return s
}

type ListDeliveryStreamsOutput struct {
	_ struct{} `type:"structure"`

	// The names of the delivery streams.
	//
	// DeliveryStreamNames is a required field
	DeliveryStreamNames []*string `type:"list" required:"true"`

	// Indicates whether there are more delivery streams available to list.
	//
	// HasMoreDeliveryStreams is a required field
	HasMoreDeliveryStreams *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeliveryStreamsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDeliveryStreamsOutput) GoString() string {
	return s.String()
}

// SetDeliveryStreamNames sets the DeliveryStreamNames field's value.
func (s *ListDeliveryStreamsOutput) SetDeliveryStreamNames(v []*string) *ListDeliveryStreamsOutput {
	s.DeliveryStreamNames = v
	return s
}

// SetHasMoreDeliveryStreams sets the HasMoreDeliveryStreams field's value.
func (s *ListDeliveryStreamsOutput) SetHasMoreDeliveryStreams(v bool) *ListDeliveryStreamsOutput {
	s.HasMoreDeliveryStreams = &v
	return s
}

type ListTagsForDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream whose tags you want to list.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The key to use as the starting point for the list of tags. If you set this
	// parameter, ListTagsForDeliveryStream gets all tags that occur after ExclusiveStartTagKey.
	ExclusiveStartTagKey *string `min:"1" type:"string"`

	// The number of tags to return. If this number is less than the total number
	// of tags associated with the delivery stream, HasMoreTags is set to true in
	// the response. To list additional tags, set ExclusiveStartTagKey to the last
	// key in the response.
	Limit *int64 `min:"1" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.ExclusiveStartTagKey != nil && len(*s.ExclusiveStartTagKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExclusiveStartTagKey", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *ListTagsForDeliveryStreamInput) SetDeliveryStreamName(v string) *ListTagsForDeliveryStreamInput {
	s.DeliveryStreamName = &v
	return s
}

// SetExclusiveStartTagKey sets the ExclusiveStartTagKey field's value.
func (s *ListTagsForDeliveryStreamInput) SetExclusiveStartTagKey(v string) *ListTagsForDeliveryStreamInput {
	s.ExclusiveStartTagKey = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForDeliveryStreamInput) SetLimit(v int64) *ListTagsForDeliveryStreamInput {
	s.Limit = &v
	return s
}

type ListTagsForDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`

	// If this is true in the response, more tags are available. To list the remaining
	// tags, set ExclusiveStartTagKey to the key of the last tag returned and call
	// ListTagsForDeliveryStream again.
	//
	// HasMoreTags is a required field
	HasMoreTags *bool `type:"boolean" required:"true"`

	// A list of tags associated with DeliveryStreamName, starting with the first
	// tag after ExclusiveStartTagKey and up to the specified Limit.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForDeliveryStreamOutput) GoString() string {
	return s.String()
}

// SetHasMoreTags sets the HasMoreTags field's value.
func (s *ListTagsForDeliveryStreamOutput) SetHasMoreTags(v bool) *ListTagsForDeliveryStreamOutput {
	s.HasMoreTags = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ListTagsForDeliveryStreamOutput) SetTags(v []*Tag) *ListTagsForDeliveryStreamOutput {
	s.Tags = v
	return s
}

// The OpenX SerDe. Used by Kinesis Data Firehose for deserializing data, which
// means converting it from the JSON format in preparation for serializing it
// to the Parquet or ORC format. This is one of two deserializers you can choose,
// depending on which one offers the functionality you need. The other option
// is the native Hive / HCatalog JsonSerDe.
type OpenXJsonSerDe struct {
	_ struct{} `type:"structure"`

	// When set to true, which is the default, Kinesis Data Firehose converts JSON
	// keys to lowercase before deserializing them.
	CaseInsensitive *bool `type:"boolean"`

	// Maps column names to JSON keys that aren't identical to the column names.
	// This is useful when the JSON contains keys that are Hive keywords. For example,
	// timestamp is a Hive keyword. If you have a JSON key named timestamp, set
	// this parameter to {"ts": "timestamp"} to map this key to a column named ts.
	ColumnToJsonKeyMappings map[string]*string `type:"map"`

	// When set to true, specifies that the names of the keys include dots and that
	// you want Kinesis Data Firehose to replace them with underscores. This is
	// useful because Apache Hive does not allow dots in column names. For example,
	// if the JSON contains a key whose name is "a.b", you can define the column
	// name to be "a_b" when using this option.
	//
	// The default is false.
	ConvertDotsInJsonKeysToUnderscores *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenXJsonSerDe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OpenXJsonSerDe) GoString() string {
	return s.String()
}

// SetCaseInsensitive sets the CaseInsensitive field's value.
func (s *OpenXJsonSerDe) SetCaseInsensitive(v bool) *OpenXJsonSerDe {
	s.CaseInsensitive = &v
	return s
}

// SetColumnToJsonKeyMappings sets the ColumnToJsonKeyMappings field's value.
func (s *OpenXJsonSerDe) SetColumnToJsonKeyMappings(v map[string]*string) *OpenXJsonSerDe {
	s.ColumnToJsonKeyMappings = v
	return s
}

// SetConvertDotsInJsonKeysToUnderscores sets the ConvertDotsInJsonKeysToUnderscores field's value.
func (s *OpenXJsonSerDe) SetConvertDotsInJsonKeysToUnderscores(v bool) *OpenXJsonSerDe {
	s.ConvertDotsInJsonKeysToUnderscores = &v
	return s
}

// A serializer to use for converting data to the ORC format before storing
// it in Amazon S3. For more information, see Apache ORC (https://orc.apache.org/docs/).
type OrcSerDe struct {
	_ struct{} `type:"structure"`

	// The Hadoop Distributed File System (HDFS) block size. This is useful if you
	// intend to copy the data from Amazon S3 to HDFS before querying. The default
	// is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value
	// for padding calculations.
	BlockSizeBytes *int64 `min:"6.7108864e+07" type:"integer"`

	// The column names for which you want Kinesis Data Firehose to create bloom
	// filters. The default is null.
	BloomFilterColumns []*string `type:"list"`

	// The Bloom filter false positive probability (FPP). The lower the FPP, the
	// bigger the Bloom filter. The default value is 0.05, the minimum is 0, and
	// the maximum is 1.
	BloomFilterFalsePositiveProbability *float64 `type:"double"`

	// The compression code to use over data blocks. The default is SNAPPY.
	Compression *string `type:"string" enum:"OrcCompression"`

	// Represents the fraction of the total number of non-null rows. To turn off
	// dictionary encoding, set this fraction to a number that is less than the
	// number of distinct keys in a dictionary. To always use dictionary encoding,
	// set this threshold to 1.
	DictionaryKeyThreshold *float64 `type:"double"`

	// Set this to true to indicate that you want stripes to be padded to the HDFS
	// block boundaries. This is useful if you intend to copy the data from Amazon
	// S3 to HDFS before querying. The default is false.
	EnablePadding *bool `type:"boolean"`

	// The version of the file to write. The possible values are V0_11 and V0_12.
	// The default is V0_12.
	FormatVersion *string `type:"string" enum:"OrcFormatVersion"`

	// A number between 0 and 1 that defines the tolerance for block padding as
	// a decimal fraction of stripe size. The default value is 0.05, which means
	// 5 percent of stripe size.
	//
	// For the default values of 64 MiB ORC stripes and 256 MiB HDFS blocks, the
	// default block padding tolerance of 5 percent reserves a maximum of 3.2 MiB
	// for padding within the 256 MiB block. In such a case, if the available size
	// within the block is more than 3.2 MiB, a new, smaller stripe is inserted
	// to fit within that space. This ensures that no stripe crosses block boundaries
	// and causes remote reads within a node-local task.
	//
	// Kinesis Data Firehose ignores this parameter when OrcSerDe$EnablePadding
	// is false.
	PaddingTolerance *float64 `type:"double"`

	// The number of rows between index entries. The default is 10,000 and the minimum
	// is 1,000.
	RowIndexStride *int64 `min:"1000" type:"integer"`

	// The number of bytes in each stripe. The default is 64 MiB and the minimum
	// is 8 MiB.
	StripeSizeBytes *int64 `min:"8.388608e+06" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrcSerDe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OrcSerDe) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrcSerDe) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OrcSerDe"}
	if s.BlockSizeBytes != nil && *s.BlockSizeBytes < 6.7108864e+07 {
		invalidParams.Add(request.NewErrParamMinValue("BlockSizeBytes", 6.7108864e+07))
	}
	if s.RowIndexStride != nil && *s.RowIndexStride < 1000 {
		invalidParams.Add(request.NewErrParamMinValue("RowIndexStride", 1000))
	}
	if s.StripeSizeBytes != nil && *s.StripeSizeBytes < 8.388608e+06 {
		invalidParams.Add(request.NewErrParamMinValue("StripeSizeBytes", 8.388608e+06))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockSizeBytes sets the BlockSizeBytes field's value.
func (s *OrcSerDe) SetBlockSizeBytes(v int64) *OrcSerDe {
	s.BlockSizeBytes = &v
	return s
}

// SetBloomFilterColumns sets the BloomFilterColumns field's value.
func (s *OrcSerDe) SetBloomFilterColumns(v []*string) *OrcSerDe {
	s.BloomFilterColumns = v
	return s
}

// SetBloomFilterFalsePositiveProbability sets the BloomFilterFalsePositiveProbability field's value.
func (s *OrcSerDe) SetBloomFilterFalsePositiveProbability(v float64) *OrcSerDe {
	s.BloomFilterFalsePositiveProbability = &v
	return s
}

// SetCompression sets the Compression field's value.
func (s *OrcSerDe) SetCompression(v string) *OrcSerDe {
	s.Compression = &v
	return s
}

// SetDictionaryKeyThreshold sets the DictionaryKeyThreshold field's value.
func (s *OrcSerDe) SetDictionaryKeyThreshold(v float64) *OrcSerDe {
	s.DictionaryKeyThreshold = &v
	return s
}

// SetEnablePadding sets the EnablePadding field's value.
func (s *OrcSerDe) SetEnablePadding(v bool) *OrcSerDe {
	s.EnablePadding = &v
	return s
}

// SetFormatVersion sets the FormatVersion field's value.
func (s *OrcSerDe) SetFormatVersion(v string) *OrcSerDe {
	s.FormatVersion = &v
	return s
}

// SetPaddingTolerance sets the PaddingTolerance field's value.
func (s *OrcSerDe) SetPaddingTolerance(v float64) *OrcSerDe {
	s.PaddingTolerance = &v
	return s
}

// SetRowIndexStride sets the RowIndexStride field's value.
func (s *OrcSerDe) SetRowIndexStride(v int64) *OrcSerDe {
	s.RowIndexStride = &v
	return s
}

// SetStripeSizeBytes sets the StripeSizeBytes field's value.
func (s *OrcSerDe) SetStripeSizeBytes(v int64) *OrcSerDe {
	s.StripeSizeBytes = &v
	return s
}

// Specifies the serializer that you want Kinesis Data Firehose to use to convert
// the format of your data before it writes it to Amazon S3. This parameter
// is required if Enabled is set to true.
type OutputFormatConfiguration struct {
	_ struct{} `type:"structure"`

	// Specifies which serializer to use. You can choose either the ORC SerDe or
	// the Parquet SerDe. If both are non-null, the server rejects the request.
	Serializer *Serializer `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputFormatConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputFormatConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputFormatConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputFormatConfiguration"}
	if s.Serializer != nil {
		if err := s.Serializer.Validate(); err != nil {
			invalidParams.AddNested("Serializer", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSerializer sets the Serializer field's value.
func (s *OutputFormatConfiguration) SetSerializer(v *Serializer) *OutputFormatConfiguration {
	s.Serializer = v
	return s
}

// A serializer to use for converting data to the Parquet format before storing
// it in Amazon S3. For more information, see Apache Parquet (https://parquet.apache.org/documentation/latest/).
type ParquetSerDe struct {
	_ struct{} `type:"structure"`

	// The Hadoop Distributed File System (HDFS) block size. This is useful if you
	// intend to copy the data from Amazon S3 to HDFS before querying. The default
	// is 256 MiB and the minimum is 64 MiB. Kinesis Data Firehose uses this value
	// for padding calculations.
	BlockSizeBytes *int64 `min:"6.7108864e+07" type:"integer"`

	// The compression code to use over data blocks. The possible values are UNCOMPRESSED,
	// SNAPPY, and GZIP, with the default being SNAPPY. Use SNAPPY for higher decompression
	// speed. Use GZIP if the compression ratio is more important than speed.
	Compression *string `type:"string" enum:"ParquetCompression"`

	// Indicates whether to enable dictionary compression.
	EnableDictionaryCompression *bool `type:"boolean"`

	// The maximum amount of padding to apply. This is useful if you intend to copy
	// the data from Amazon S3 to HDFS before querying. The default is 0.
	MaxPaddingBytes *int64 `type:"integer"`

	// The Parquet page size. Column chunks are divided into pages. A page is conceptually
	// an indivisible unit (in terms of compression and encoding). The minimum value
	// is 64 KiB and the default is 1 MiB.
	PageSizeBytes *int64 `min:"65536" type:"integer"`

	// Indicates the version of row format to output. The possible values are V1
	// and V2. The default is V1.
	WriterVersion *string `type:"string" enum:"ParquetWriterVersion"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParquetSerDe) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ParquetSerDe) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ParquetSerDe) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ParquetSerDe"}
	if s.BlockSizeBytes != nil && *s.BlockSizeBytes < 6.7108864e+07 {
		invalidParams.Add(request.NewErrParamMinValue("BlockSizeBytes", 6.7108864e+07))
	}
	if s.PageSizeBytes != nil && *s.PageSizeBytes < 65536 {
		invalidParams.Add(request.NewErrParamMinValue("PageSizeBytes", 65536))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBlockSizeBytes sets the BlockSizeBytes field's value.
func (s *ParquetSerDe) SetBlockSizeBytes(v int64) *ParquetSerDe {
	s.BlockSizeBytes = &v
	return s
}

// SetCompression sets the Compression field's value.
func (s *ParquetSerDe) SetCompression(v string) *ParquetSerDe {
	s.Compression = &v
	return s
}

// SetEnableDictionaryCompression sets the EnableDictionaryCompression field's value.
func (s *ParquetSerDe) SetEnableDictionaryCompression(v bool) *ParquetSerDe {
	s.EnableDictionaryCompression = &v
	return s
}

// SetMaxPaddingBytes sets the MaxPaddingBytes field's value.
func (s *ParquetSerDe) SetMaxPaddingBytes(v int64) *ParquetSerDe {
	s.MaxPaddingBytes = &v
	return s
}

// SetPageSizeBytes sets the PageSizeBytes field's value.
func (s *ParquetSerDe) SetPageSizeBytes(v int64) *ParquetSerDe {
	s.PageSizeBytes = &v
	return s
}

// SetWriterVersion sets the WriterVersion field's value.
func (s *ParquetSerDe) SetWriterVersion(v string) *ParquetSerDe {
	s.WriterVersion = &v
	return s
}

// Describes a data processing configuration.
type ProcessingConfiguration struct {
	_ struct{} `type:"structure"`

	// Enables or disables data processing.
	Enabled *bool `type:"boolean"`

	// The data processors.
	Processors []*Processor `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProcessingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProcessingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProcessingConfiguration"}
	if s.Processors != nil {
		for i, v := range s.Processors {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Processors", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ProcessingConfiguration) SetEnabled(v bool) *ProcessingConfiguration {
	s.Enabled = &v
	return s
}

// SetProcessors sets the Processors field's value.
func (s *ProcessingConfiguration) SetProcessors(v []*Processor) *ProcessingConfiguration {
	s.Processors = v
	return s
}

// Describes a data processor.
type Processor struct {
	_ struct{} `type:"structure"`

	// The processor parameters.
	Parameters []*ProcessorParameter `type:"list"`

	// The type of processor.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ProcessorType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Processor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Processor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Processor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Processor"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Parameters != nil {
		for i, v := range s.Parameters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Parameters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *Processor) SetParameters(v []*ProcessorParameter) *Processor {
	s.Parameters = v
	return s
}

// SetType sets the Type field's value.
func (s *Processor) SetType(v string) *Processor {
	s.Type = &v
	return s
}

// Describes the processor parameter.
type ProcessorParameter struct {
	_ struct{} `type:"structure"`

	// The name of the parameter. Currently the following default values are supported:
	// 3 for NumberOfRetries and 60 for the BufferIntervalInSeconds. The BufferSizeInMBs
	// ranges between 0.2 MB and up to 3MB. The default buffering hint is 1MB for
	// all destinations, except Splunk. For Splunk, the default buffering hint is
	// 256 KB.
	//
	// ParameterName is a required field
	ParameterName *string `type:"string" required:"true" enum:"ProcessorParameterName"`

	// The parameter value.
	//
	// ParameterValue is a required field
	ParameterValue *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProcessorParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProcessorParameter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ProcessorParameter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ProcessorParameter"}
	if s.ParameterName == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterName"))
	}
	if s.ParameterValue == nil {
		invalidParams.Add(request.NewErrParamRequired("ParameterValue"))
	}
	if s.ParameterValue != nil && len(*s.ParameterValue) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParameterValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameterName sets the ParameterName field's value.
func (s *ProcessorParameter) SetParameterName(v string) *ProcessorParameter {
	s.ParameterName = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ProcessorParameter) SetParameterValue(v string) *ProcessorParameter {
	s.ParameterValue = &v
	return s
}

type PutRecordBatchInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// One or more records.
	//
	// Records is a required field
	Records []*Record `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordBatchInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.Records == nil {
		invalidParams.Add(request.NewErrParamRequired("Records"))
	}
	if s.Records != nil && len(s.Records) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Records", 1))
	}
	if s.Records != nil {
		for i, v := range s.Records {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Records", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *PutRecordBatchInput) SetDeliveryStreamName(v string) *PutRecordBatchInput {
	s.DeliveryStreamName = &v
	return s
}

// SetRecords sets the Records field's value.
func (s *PutRecordBatchInput) SetRecords(v []*Record) *PutRecordBatchInput {
	s.Records = v
	return s
}

type PutRecordBatchOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether server-side encryption (SSE) was enabled during this operation.
	Encrypted *bool `type:"boolean"`

	// The number of records that might have failed processing. This number might
	// be greater than 0 even if the PutRecordBatch call succeeds. Check FailedPutCount
	// to determine whether there are records that you need to resend.
	//
	// FailedPutCount is a required field
	FailedPutCount *int64 `type:"integer" required:"true"`

	// The results array. For each record, the index of the response element is
	// the same as the index used in the request array.
	//
	// RequestResponses is a required field
	RequestResponses []*PutRecordBatchResponseEntry `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordBatchOutput) GoString() string {
	return s.String()
}

// SetEncrypted sets the Encrypted field's value.
func (s *PutRecordBatchOutput) SetEncrypted(v bool) *PutRecordBatchOutput {
	s.Encrypted = &v
	return s
}

// SetFailedPutCount sets the FailedPutCount field's value.
func (s *PutRecordBatchOutput) SetFailedPutCount(v int64) *PutRecordBatchOutput {
	s.FailedPutCount = &v
	return s
}

// SetRequestResponses sets the RequestResponses field's value.
func (s *PutRecordBatchOutput) SetRequestResponses(v []*PutRecordBatchResponseEntry) *PutRecordBatchOutput {
	s.RequestResponses = v
	return s
}

// Contains the result for an individual record from a PutRecordBatch request.
// If the record is successfully added to your delivery stream, it receives
// a record ID. If the record fails to be added to your delivery stream, the
// result includes an error code and an error message.
type PutRecordBatchResponseEntry struct {
	_ struct{} `type:"structure"`

	// The error code for an individual record result.
	ErrorCode *string `type:"string"`

	// The error message for an individual record result.
	ErrorMessage *string `type:"string"`

	// The ID of the record.
	RecordId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordBatchResponseEntry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordBatchResponseEntry) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *PutRecordBatchResponseEntry) SetErrorCode(v string) *PutRecordBatchResponseEntry {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *PutRecordBatchResponseEntry) SetErrorMessage(v string) *PutRecordBatchResponseEntry {
	s.ErrorMessage = &v
	return s
}

// SetRecordId sets the RecordId field's value.
func (s *PutRecordBatchResponseEntry) SetRecordId(v string) *PutRecordBatchResponseEntry {
	s.RecordId = &v
	return s
}

type PutRecordInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The record.
	//
	// Record is a required field
	Record *Record `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRecordInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRecordInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.Record == nil {
		invalidParams.Add(request.NewErrParamRequired("Record"))
	}
	if s.Record != nil {
		if err := s.Record.Validate(); err != nil {
			invalidParams.AddNested("Record", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *PutRecordInput) SetDeliveryStreamName(v string) *PutRecordInput {
	s.DeliveryStreamName = &v
	return s
}

// SetRecord sets the Record field's value.
func (s *PutRecordInput) SetRecord(v *Record) *PutRecordInput {
	s.Record = v
	return s
}

type PutRecordOutput struct {
	_ struct{} `type:"structure"`

	// Indicates whether server-side encryption (SSE) was enabled during this operation.
	Encrypted *bool `type:"boolean"`

	// The ID of the record.
	//
	// RecordId is a required field
	RecordId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRecordOutput) GoString() string {
	return s.String()
}

// SetEncrypted sets the Encrypted field's value.
func (s *PutRecordOutput) SetEncrypted(v bool) *PutRecordOutput {
	s.Encrypted = &v
	return s
}

// SetRecordId sets the RecordId field's value.
func (s *PutRecordOutput) SetRecordId(v string) *PutRecordOutput {
	s.RecordId = &v
	return s
}

// The unit of data in a delivery stream.
type Record struct {
	_ struct{} `type:"structure"`

	// The data blob, which is base64-encoded when the blob is serialized. The maximum
	// size of the data blob, before base64-encoding, is 1,000 KiB.
	// Data is automatically base64 encoded/decoded by the SDK.
	//
	// Data is a required field
	Data []byte `type:"blob" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Record) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Record) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Record"}
	if s.Data == nil {
		invalidParams.Add(request.NewErrParamRequired("Data"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *Record) SetData(v []byte) *Record {
	s.Data = v
	return s
}

// Describes the configuration of a destination in Amazon Redshift.
type RedshiftDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The database connection string.
	//
	// ClusterJDBCURL is a required field
	ClusterJDBCURL *string `min:"1" type:"string" required:"true"`

	// The COPY command.
	//
	// CopyCommand is a required field
	CopyCommand *CopyCommand `type:"structure" required:"true"`

	// The user password.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RedshiftDestinationConfiguration's
	// String and GoString methods.
	//
	// Password is a required field
	Password *string `min:"6" type:"string" required:"true" sensitive:"true"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver documents
	// to Amazon Redshift. Default value is 3600 (60 minutes).
	RetryOptions *RedshiftRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The configuration for backup in Amazon S3.
	S3BackupConfiguration *S3DestinationConfiguration `type:"structure"`

	// The Amazon S3 backup mode. After you create a delivery stream, you can update
	// it to enable Amazon S3 backup if it is disabled. If backup is enabled, you
	// can't update the delivery stream to disable it.
	S3BackupMode *string `type:"string" enum:"RedshiftS3BackupMode"`

	// The configuration for the intermediate Amazon S3 location from which Amazon
	// Redshift obtains data. Restrictions are described in the topic for CreateDeliveryStream.
	//
	// The compression formats SNAPPY or ZIP cannot be specified in RedshiftDestinationConfiguration.S3Configuration
	// because the Amazon Redshift COPY operation that reads from the S3 bucket
	// doesn't support these compression formats.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`

	// The name of the user.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RedshiftDestinationConfiguration's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDestinationConfiguration"}
	if s.ClusterJDBCURL == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterJDBCURL"))
	}
	if s.ClusterJDBCURL != nil && len(*s.ClusterJDBCURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterJDBCURL", 1))
	}
	if s.CopyCommand == nil {
		invalidParams.Add(request.NewErrParamRequired("CopyCommand"))
	}
	if s.Password == nil {
		invalidParams.Add(request.NewErrParamRequired("Password"))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.CopyCommand != nil {
		if err := s.CopyCommand.Validate(); err != nil {
			invalidParams.AddNested("CopyCommand", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3BackupConfiguration != nil {
		if err := s.S3BackupConfiguration.Validate(); err != nil {
			invalidParams.AddNested("S3BackupConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *RedshiftDestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *RedshiftDestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterJDBCURL sets the ClusterJDBCURL field's value.
func (s *RedshiftDestinationConfiguration) SetClusterJDBCURL(v string) *RedshiftDestinationConfiguration {
	s.ClusterJDBCURL = &v
	return s
}

// SetCopyCommand sets the CopyCommand field's value.
func (s *RedshiftDestinationConfiguration) SetCopyCommand(v *CopyCommand) *RedshiftDestinationConfiguration {
	s.CopyCommand = v
	return s
}

// SetPassword sets the Password field's value.
func (s *RedshiftDestinationConfiguration) SetPassword(v string) *RedshiftDestinationConfiguration {
	s.Password = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *RedshiftDestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *RedshiftDestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *RedshiftDestinationConfiguration) SetRetryOptions(v *RedshiftRetryOptions) *RedshiftDestinationConfiguration {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *RedshiftDestinationConfiguration) SetRoleARN(v string) *RedshiftDestinationConfiguration {
	s.RoleARN = &v
	return s
}

// SetS3BackupConfiguration sets the S3BackupConfiguration field's value.
func (s *RedshiftDestinationConfiguration) SetS3BackupConfiguration(v *S3DestinationConfiguration) *RedshiftDestinationConfiguration {
	s.S3BackupConfiguration = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *RedshiftDestinationConfiguration) SetS3BackupMode(v string) *RedshiftDestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *RedshiftDestinationConfiguration) SetS3Configuration(v *S3DestinationConfiguration) *RedshiftDestinationConfiguration {
	s.S3Configuration = v
	return s
}

// SetUsername sets the Username field's value.
func (s *RedshiftDestinationConfiguration) SetUsername(v string) *RedshiftDestinationConfiguration {
	s.Username = &v
	return s
}

// Describes a destination in Amazon Redshift.
type RedshiftDestinationDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The database connection string.
	//
	// ClusterJDBCURL is a required field
	ClusterJDBCURL *string `min:"1" type:"string" required:"true"`

	// The COPY command.
	//
	// CopyCommand is a required field
	CopyCommand *CopyCommand `type:"structure" required:"true"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver documents
	// to Amazon Redshift. Default value is 3600 (60 minutes).
	RetryOptions *RedshiftRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The configuration for backup in Amazon S3.
	S3BackupDescription *S3DestinationDescription `type:"structure"`

	// The Amazon S3 backup mode.
	S3BackupMode *string `type:"string" enum:"RedshiftS3BackupMode"`

	// The Amazon S3 destination.
	//
	// S3DestinationDescription is a required field
	S3DestinationDescription *S3DestinationDescription `type:"structure" required:"true"`

	// The name of the user.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RedshiftDestinationDescription's
	// String and GoString methods.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDestinationDescription) GoString() string {
	return s.String()
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *RedshiftDestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *RedshiftDestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterJDBCURL sets the ClusterJDBCURL field's value.
func (s *RedshiftDestinationDescription) SetClusterJDBCURL(v string) *RedshiftDestinationDescription {
	s.ClusterJDBCURL = &v
	return s
}

// SetCopyCommand sets the CopyCommand field's value.
func (s *RedshiftDestinationDescription) SetCopyCommand(v *CopyCommand) *RedshiftDestinationDescription {
	s.CopyCommand = v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *RedshiftDestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *RedshiftDestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *RedshiftDestinationDescription) SetRetryOptions(v *RedshiftRetryOptions) *RedshiftDestinationDescription {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *RedshiftDestinationDescription) SetRoleARN(v string) *RedshiftDestinationDescription {
	s.RoleARN = &v
	return s
}

// SetS3BackupDescription sets the S3BackupDescription field's value.
func (s *RedshiftDestinationDescription) SetS3BackupDescription(v *S3DestinationDescription) *RedshiftDestinationDescription {
	s.S3BackupDescription = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *RedshiftDestinationDescription) SetS3BackupMode(v string) *RedshiftDestinationDescription {
	s.S3BackupMode = &v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *RedshiftDestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *RedshiftDestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// SetUsername sets the Username field's value.
func (s *RedshiftDestinationDescription) SetUsername(v string) *RedshiftDestinationDescription {
	s.Username = &v
	return s
}

// Describes an update for a destination in Amazon Redshift.
type RedshiftDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The database connection string.
	ClusterJDBCURL *string `min:"1" type:"string"`

	// The COPY command.
	CopyCommand *CopyCommand `type:"structure"`

	// The user password.
	//
	// Password is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RedshiftDestinationUpdate's
	// String and GoString methods.
	Password *string `min:"6" type:"string" sensitive:"true"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver documents
	// to Amazon Redshift. Default value is 3600 (60 minutes).
	RetryOptions *RedshiftRetryOptions `type:"structure"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	RoleARN *string `min:"1" type:"string"`

	// You can update a delivery stream to enable Amazon S3 backup if it is disabled.
	// If backup is enabled, you can't update the delivery stream to disable it.
	S3BackupMode *string `type:"string" enum:"RedshiftS3BackupMode"`

	// The Amazon S3 destination for backup.
	S3BackupUpdate *S3DestinationUpdate `type:"structure"`

	// The Amazon S3 destination.
	//
	// The compression formats SNAPPY or ZIP cannot be specified in RedshiftDestinationUpdate.S3Update
	// because the Amazon Redshift COPY operation that reads from the S3 bucket
	// doesn't support these compression formats.
	S3Update *S3DestinationUpdate `type:"structure"`

	// The name of the user.
	//
	// Username is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by RedshiftDestinationUpdate's
	// String and GoString methods.
	Username *string `min:"1" type:"string" sensitive:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RedshiftDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RedshiftDestinationUpdate"}
	if s.ClusterJDBCURL != nil && len(*s.ClusterJDBCURL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClusterJDBCURL", 1))
	}
	if s.Password != nil && len(*s.Password) < 6 {
		invalidParams.Add(request.NewErrParamMinLen("Password", 6))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.CopyCommand != nil {
		if err := s.CopyCommand.Validate(); err != nil {
			invalidParams.AddNested("CopyCommand", err.(request.ErrInvalidParams))
		}
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3BackupUpdate != nil {
		if err := s.S3BackupUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3BackupUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *RedshiftDestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *RedshiftDestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetClusterJDBCURL sets the ClusterJDBCURL field's value.
func (s *RedshiftDestinationUpdate) SetClusterJDBCURL(v string) *RedshiftDestinationUpdate {
	s.ClusterJDBCURL = &v
	return s
}

// SetCopyCommand sets the CopyCommand field's value.
func (s *RedshiftDestinationUpdate) SetCopyCommand(v *CopyCommand) *RedshiftDestinationUpdate {
	s.CopyCommand = v
	return s
}

// SetPassword sets the Password field's value.
func (s *RedshiftDestinationUpdate) SetPassword(v string) *RedshiftDestinationUpdate {
	s.Password = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *RedshiftDestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *RedshiftDestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *RedshiftDestinationUpdate) SetRetryOptions(v *RedshiftRetryOptions) *RedshiftDestinationUpdate {
	s.RetryOptions = v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *RedshiftDestinationUpdate) SetRoleARN(v string) *RedshiftDestinationUpdate {
	s.RoleARN = &v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *RedshiftDestinationUpdate) SetS3BackupMode(v string) *RedshiftDestinationUpdate {
	s.S3BackupMode = &v
	return s
}

// SetS3BackupUpdate sets the S3BackupUpdate field's value.
func (s *RedshiftDestinationUpdate) SetS3BackupUpdate(v *S3DestinationUpdate) *RedshiftDestinationUpdate {
	s.S3BackupUpdate = v
	return s
}

// SetS3Update sets the S3Update field's value.
func (s *RedshiftDestinationUpdate) SetS3Update(v *S3DestinationUpdate) *RedshiftDestinationUpdate {
	s.S3Update = v
	return s
}

// SetUsername sets the Username field's value.
func (s *RedshiftDestinationUpdate) SetUsername(v string) *RedshiftDestinationUpdate {
	s.Username = &v
	return s
}

// Configures retry behavior in case Kinesis Data Firehose is unable to deliver
// documents to Amazon Redshift.
type RedshiftRetryOptions struct {
	_ struct{} `type:"structure"`

	// The length of time during which Kinesis Data Firehose retries delivery after
	// a failure, starting from the initial request and including the first attempt.
	// The default value is 3600 seconds (60 minutes). Kinesis Data Firehose does
	// not retry if the value of DurationInSeconds is 0 (zero) or if the first delivery
	// attempt takes longer than the current value.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RedshiftRetryOptions) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *RedshiftRetryOptions) SetDurationInSeconds(v int64) *RedshiftRetryOptions {
	s.DurationInSeconds = &v
	return s
}

// The resource is already in use and not available for this operation.
type ResourceInUseException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInUseException) GoString() string {
	return s.String()
}

func newErrorResourceInUseException(v protocol.ResponseMetadata) error {
	return &ResourceInUseException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUseException) Code() string {
	return "ResourceInUseException"
}

// Message returns the exception's message.
func (s *ResourceInUseException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUseException) OrigErr() error {
	return nil
}

func (s *ResourceInUseException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUseException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUseException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The retry behavior in case Kinesis Data Firehose is unable to deliver data
// to an Amazon S3 prefix.
type RetryOptions struct {
	_ struct{} `type:"structure"`

	// The period of time during which Kinesis Data Firehose retries to deliver
	// data to the specified Amazon S3 prefix.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RetryOptions) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *RetryOptions) SetDurationInSeconds(v int64) *RetryOptions {
	s.DurationInSeconds = &v
	return s
}

// Describes the configuration of a destination in Amazon S3.
type S3DestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket. For more information, see Amazon Resource Names
	// (ARNs) and Amazon Web Services Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The buffering option. If no value is specified, BufferingHints object default
	// values are used.
	BufferingHints *BufferingHints `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	//
	// The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
	// destinations because they are not supported by the Amazon Redshift COPY operation
	// that reads from the S3 bucket.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// A prefix that Kinesis Data Firehose evaluates and adds to failed records
	// before writing them to S3. This prefix appears immediately following the
	// bucket name. For information about how to specify this prefix, see Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	ErrorOutputPrefix *string `type:"string"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// Amazon S3 files. You can also specify a custom prefix, as described in Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	Prefix *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationConfiguration"}
	if s.BucketARN == nil {
		invalidParams.Add(request.NewErrParamRequired("BucketARN"))
	}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3DestinationConfiguration) SetBucketARN(v string) *S3DestinationConfiguration {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *S3DestinationConfiguration) SetBufferingHints(v *BufferingHints) *S3DestinationConfiguration {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *S3DestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *S3DestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *S3DestinationConfiguration) SetCompressionFormat(v string) *S3DestinationConfiguration {
	s.CompressionFormat = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *S3DestinationConfiguration) SetEncryptionConfiguration(v *EncryptionConfiguration) *S3DestinationConfiguration {
	s.EncryptionConfiguration = v
	return s
}

// SetErrorOutputPrefix sets the ErrorOutputPrefix field's value.
func (s *S3DestinationConfiguration) SetErrorOutputPrefix(v string) *S3DestinationConfiguration {
	s.ErrorOutputPrefix = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3DestinationConfiguration) SetPrefix(v string) *S3DestinationConfiguration {
	s.Prefix = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *S3DestinationConfiguration) SetRoleARN(v string) *S3DestinationConfiguration {
	s.RoleARN = &v
	return s
}

// Describes a destination in Amazon S3.
type S3DestinationDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket. For more information, see Amazon Resource Names
	// (ARNs) and Amazon Web Services Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// BucketARN is a required field
	BucketARN *string `min:"1" type:"string" required:"true"`

	// The buffering option. If no value is specified, BufferingHints object default
	// values are used.
	//
	// BufferingHints is a required field
	BufferingHints *BufferingHints `type:"structure" required:"true"`

	// The Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	//
	// CompressionFormat is a required field
	CompressionFormat *string `type:"string" required:"true" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	//
	// EncryptionConfiguration is a required field
	EncryptionConfiguration *EncryptionConfiguration `type:"structure" required:"true"`

	// A prefix that Kinesis Data Firehose evaluates and adds to failed records
	// before writing them to S3. This prefix appears immediately following the
	// bucket name. For information about how to specify this prefix, see Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	ErrorOutputPrefix *string `type:"string"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// Amazon S3 files. You can also specify a custom prefix, as described in Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	Prefix *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationDescription) GoString() string {
	return s.String()
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3DestinationDescription) SetBucketARN(v string) *S3DestinationDescription {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *S3DestinationDescription) SetBufferingHints(v *BufferingHints) *S3DestinationDescription {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *S3DestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *S3DestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *S3DestinationDescription) SetCompressionFormat(v string) *S3DestinationDescription {
	s.CompressionFormat = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *S3DestinationDescription) SetEncryptionConfiguration(v *EncryptionConfiguration) *S3DestinationDescription {
	s.EncryptionConfiguration = v
	return s
}

// SetErrorOutputPrefix sets the ErrorOutputPrefix field's value.
func (s *S3DestinationDescription) SetErrorOutputPrefix(v string) *S3DestinationDescription {
	s.ErrorOutputPrefix = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3DestinationDescription) SetPrefix(v string) *S3DestinationDescription {
	s.Prefix = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *S3DestinationDescription) SetRoleARN(v string) *S3DestinationDescription {
	s.RoleARN = &v
	return s
}

// Describes an update for a destination in Amazon S3.
type S3DestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The ARN of the S3 bucket. For more information, see Amazon Resource Names
	// (ARNs) and Amazon Web Services Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	BucketARN *string `min:"1" type:"string"`

	// The buffering option. If no value is specified, BufferingHints object default
	// values are used.
	BufferingHints *BufferingHints `type:"structure"`

	// The CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The compression format. If no value is specified, the default is UNCOMPRESSED.
	//
	// The compression formats SNAPPY or ZIP cannot be specified for Amazon Redshift
	// destinations because they are not supported by the Amazon Redshift COPY operation
	// that reads from the S3 bucket.
	CompressionFormat *string `type:"string" enum:"CompressionFormat"`

	// The encryption configuration. If no value is specified, the default is no
	// encryption.
	EncryptionConfiguration *EncryptionConfiguration `type:"structure"`

	// A prefix that Kinesis Data Firehose evaluates and adds to failed records
	// before writing them to S3. This prefix appears immediately following the
	// bucket name. For information about how to specify this prefix, see Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	ErrorOutputPrefix *string `type:"string"`

	// The "YYYY/MM/DD/HH" time format prefix is automatically used for delivered
	// Amazon S3 files. You can also specify a custom prefix, as described in Custom
	// Prefixes for Amazon S3 Objects (https://docs.aws.amazon.com/firehose/latest/dev/s3-prefixes.html).
	Prefix *string `type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon Web Services credentials. For
	// more information, see Amazon Resource Names (ARNs) and Amazon Web Services
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html).
	RoleARN *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3DestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3DestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3DestinationUpdate"}
	if s.BucketARN != nil && len(*s.BucketARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BucketARN", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.BufferingHints != nil {
		if err := s.BufferingHints.Validate(); err != nil {
			invalidParams.AddNested("BufferingHints", err.(request.ErrInvalidParams))
		}
	}
	if s.EncryptionConfiguration != nil {
		if err := s.EncryptionConfiguration.Validate(); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucketARN sets the BucketARN field's value.
func (s *S3DestinationUpdate) SetBucketARN(v string) *S3DestinationUpdate {
	s.BucketARN = &v
	return s
}

// SetBufferingHints sets the BufferingHints field's value.
func (s *S3DestinationUpdate) SetBufferingHints(v *BufferingHints) *S3DestinationUpdate {
	s.BufferingHints = v
	return s
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *S3DestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *S3DestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetCompressionFormat sets the CompressionFormat field's value.
func (s *S3DestinationUpdate) SetCompressionFormat(v string) *S3DestinationUpdate {
	s.CompressionFormat = &v
	return s
}

// SetEncryptionConfiguration sets the EncryptionConfiguration field's value.
func (s *S3DestinationUpdate) SetEncryptionConfiguration(v *EncryptionConfiguration) *S3DestinationUpdate {
	s.EncryptionConfiguration = v
	return s
}

// SetErrorOutputPrefix sets the ErrorOutputPrefix field's value.
func (s *S3DestinationUpdate) SetErrorOutputPrefix(v string) *S3DestinationUpdate {
	s.ErrorOutputPrefix = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *S3DestinationUpdate) SetPrefix(v string) *S3DestinationUpdate {
	s.Prefix = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *S3DestinationUpdate) SetRoleARN(v string) *S3DestinationUpdate {
	s.RoleARN = &v
	return s
}

// Specifies the schema to which you want Kinesis Data Firehose to configure
// your data before it writes it to Amazon S3. This parameter is required if
// Enabled is set to true.
type SchemaConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID of the Amazon Web Services Glue Data Catalog. If you don't supply
	// this, the Amazon Web Services account ID is used by default.
	CatalogId *string `min:"1" type:"string"`

	// Specifies the name of the Amazon Web Services Glue database that contains
	// the schema for the output data.
	//
	// If the SchemaConfiguration request parameter is used as part of invoking
	// the CreateDeliveryStream API, then the DatabaseName property is required
	// and its value must be specified.
	DatabaseName *string `min:"1" type:"string"`

	// If you don't specify an Amazon Web Services Region, the default is the current
	// Region.
	Region *string `min:"1" type:"string"`

	// The role that Kinesis Data Firehose can use to access Amazon Web Services
	// Glue. This role must be in the same account you use for Kinesis Data Firehose.
	// Cross-account roles aren't allowed.
	//
	// If the SchemaConfiguration request parameter is used as part of invoking
	// the CreateDeliveryStream API, then the RoleARN property is required and its
	// value must be specified.
	RoleARN *string `min:"1" type:"string"`

	// Specifies the Amazon Web Services Glue table that contains the column information
	// that constitutes your data schema.
	//
	// If the SchemaConfiguration request parameter is used as part of invoking
	// the CreateDeliveryStream API, then the TableName property is required and
	// its value must be specified.
	TableName *string `min:"1" type:"string"`

	// Specifies the table version for the output data schema. If you don't specify
	// this version ID, or if you set it to LATEST, Kinesis Data Firehose uses the
	// most recent version. This means that any updates to the table are automatically
	// picked up.
	VersionId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SchemaConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SchemaConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SchemaConfiguration"}
	if s.CatalogId != nil && len(*s.CatalogId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CatalogId", 1))
	}
	if s.DatabaseName != nil && len(*s.DatabaseName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DatabaseName", 1))
	}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Region", 1))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.TableName != nil && len(*s.TableName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TableName", 1))
	}
	if s.VersionId != nil && len(*s.VersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCatalogId sets the CatalogId field's value.
func (s *SchemaConfiguration) SetCatalogId(v string) *SchemaConfiguration {
	s.CatalogId = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *SchemaConfiguration) SetDatabaseName(v string) *SchemaConfiguration {
	s.DatabaseName = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *SchemaConfiguration) SetRegion(v string) *SchemaConfiguration {
	s.Region = &v
	return s
}

// SetRoleARN sets the RoleARN field's value.
func (s *SchemaConfiguration) SetRoleARN(v string) *SchemaConfiguration {
	s.RoleARN = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *SchemaConfiguration) SetTableName(v string) *SchemaConfiguration {
	s.TableName = &v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *SchemaConfiguration) SetVersionId(v string) *SchemaConfiguration {
	s.VersionId = &v
	return s
}

// The serializer that you want Kinesis Data Firehose to use to convert data
// to the target format before writing it to Amazon S3. Kinesis Data Firehose
// supports two types of serializers: the ORC SerDe (https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/orc/OrcSerde.html)
// and the Parquet SerDe (https://hive.apache.org/javadocs/r1.2.2/api/org/apache/hadoop/hive/ql/io/parquet/serde/ParquetHiveSerDe.html).
type Serializer struct {
	_ struct{} `type:"structure"`

	// A serializer to use for converting data to the ORC format before storing
	// it in Amazon S3. For more information, see Apache ORC (https://orc.apache.org/docs/).
	OrcSerDe *OrcSerDe `type:"structure"`

	// A serializer to use for converting data to the Parquet format before storing
	// it in Amazon S3. For more information, see Apache Parquet (https://parquet.apache.org/documentation/latest/).
	ParquetSerDe *ParquetSerDe `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Serializer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Serializer) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Serializer) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Serializer"}
	if s.OrcSerDe != nil {
		if err := s.OrcSerDe.Validate(); err != nil {
			invalidParams.AddNested("OrcSerDe", err.(request.ErrInvalidParams))
		}
	}
	if s.ParquetSerDe != nil {
		if err := s.ParquetSerDe.Validate(); err != nil {
			invalidParams.AddNested("ParquetSerDe", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOrcSerDe sets the OrcSerDe field's value.
func (s *Serializer) SetOrcSerDe(v *OrcSerDe) *Serializer {
	s.OrcSerDe = v
	return s
}

// SetParquetSerDe sets the ParquetSerDe field's value.
func (s *Serializer) SetParquetSerDe(v *ParquetSerDe) *Serializer {
	s.ParquetSerDe = v
	return s
}

// The service is unavailable. Back off and retry the operation. If you continue
// to see the exception, throughput limits for the delivery stream may have
// been exceeded. For more information about limits and how to request an increase,
// see Amazon Kinesis Data Firehose Limits (https://docs.aws.amazon.com/firehose/latest/dev/limits.html).
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// A message that provides information about the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Details about a Kinesis data stream used as the source for a Kinesis Data
// Firehose delivery stream.
type SourceDescription struct {
	_ struct{} `type:"structure"`

	// The KinesisStreamSourceDescription value for the source Kinesis data stream.
	KinesisStreamSourceDescription *KinesisStreamSourceDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SourceDescription) GoString() string {
	return s.String()
}

// SetKinesisStreamSourceDescription sets the KinesisStreamSourceDescription field's value.
func (s *SourceDescription) SetKinesisStreamSourceDescription(v *KinesisStreamSourceDescription) *SourceDescription {
	s.KinesisStreamSourceDescription = v
	return s
}

// Describes the configuration of a destination in Splunk.
type SplunkDestinationConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The amount of time that Kinesis Data Firehose waits to receive an acknowledgment
	// from Splunk after it sends it data. At the end of the timeout period, Kinesis
	// Data Firehose either tries to send the data again or considers it an error,
	// based on your retry settings.
	HECAcknowledgmentTimeoutInSeconds *int64 `min:"180" type:"integer"`

	// The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends
	// your data.
	//
	// HECEndpoint is a required field
	HECEndpoint *string `type:"string" required:"true"`

	// This type can be either "Raw" or "Event."
	//
	// HECEndpointType is a required field
	HECEndpointType *string `type:"string" required:"true" enum:"HECEndpointType"`

	// This is a GUID that you obtain from your Splunk cluster when you create a
	// new HEC endpoint.
	//
	// HECToken is a required field
	HECToken *string `type:"string" required:"true"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver data
	// to Splunk, or if it doesn't receive an acknowledgment of receipt from Splunk.
	RetryOptions *SplunkRetryOptions `type:"structure"`

	// Defines how documents should be delivered to Amazon S3. When set to FailedEventsOnly,
	// Kinesis Data Firehose writes any data that could not be indexed to the configured
	// Amazon S3 destination. When set to AllEvents, Kinesis Data Firehose delivers
	// all incoming records to Amazon S3, and also writes failed documents to Amazon
	// S3. The default value is FailedEventsOnly.
	//
	// You can update this backup mode from FailedEventsOnly to AllEvents. You can't
	// update it from AllEvents to FailedEventsOnly.
	S3BackupMode *string `type:"string" enum:"SplunkS3BackupMode"`

	// The configuration for the backup Amazon S3 location.
	//
	// S3Configuration is a required field
	S3Configuration *S3DestinationConfiguration `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplunkDestinationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplunkDestinationConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SplunkDestinationConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SplunkDestinationConfiguration"}
	if s.HECAcknowledgmentTimeoutInSeconds != nil && *s.HECAcknowledgmentTimeoutInSeconds < 180 {
		invalidParams.Add(request.NewErrParamMinValue("HECAcknowledgmentTimeoutInSeconds", 180))
	}
	if s.HECEndpoint == nil {
		invalidParams.Add(request.NewErrParamRequired("HECEndpoint"))
	}
	if s.HECEndpointType == nil {
		invalidParams.Add(request.NewErrParamRequired("HECEndpointType"))
	}
	if s.HECToken == nil {
		invalidParams.Add(request.NewErrParamRequired("HECToken"))
	}
	if s.S3Configuration == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Configuration"))
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Configuration != nil {
		if err := s.S3Configuration.Validate(); err != nil {
			invalidParams.AddNested("S3Configuration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *SplunkDestinationConfiguration) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *SplunkDestinationConfiguration {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetHECAcknowledgmentTimeoutInSeconds sets the HECAcknowledgmentTimeoutInSeconds field's value.
func (s *SplunkDestinationConfiguration) SetHECAcknowledgmentTimeoutInSeconds(v int64) *SplunkDestinationConfiguration {
	s.HECAcknowledgmentTimeoutInSeconds = &v
	return s
}

// SetHECEndpoint sets the HECEndpoint field's value.
func (s *SplunkDestinationConfiguration) SetHECEndpoint(v string) *SplunkDestinationConfiguration {
	s.HECEndpoint = &v
	return s
}

// SetHECEndpointType sets the HECEndpointType field's value.
func (s *SplunkDestinationConfiguration) SetHECEndpointType(v string) *SplunkDestinationConfiguration {
	s.HECEndpointType = &v
	return s
}

// SetHECToken sets the HECToken field's value.
func (s *SplunkDestinationConfiguration) SetHECToken(v string) *SplunkDestinationConfiguration {
	s.HECToken = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *SplunkDestinationConfiguration) SetProcessingConfiguration(v *ProcessingConfiguration) *SplunkDestinationConfiguration {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *SplunkDestinationConfiguration) SetRetryOptions(v *SplunkRetryOptions) *SplunkDestinationConfiguration {
	s.RetryOptions = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *SplunkDestinationConfiguration) SetS3BackupMode(v string) *SplunkDestinationConfiguration {
	s.S3BackupMode = &v
	return s
}

// SetS3Configuration sets the S3Configuration field's value.
func (s *SplunkDestinationConfiguration) SetS3Configuration(v *S3DestinationConfiguration) *SplunkDestinationConfiguration {
	s.S3Configuration = v
	return s
}

// Describes a destination in Splunk.
type SplunkDestinationDescription struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The amount of time that Kinesis Data Firehose waits to receive an acknowledgment
	// from Splunk after it sends it data. At the end of the timeout period, Kinesis
	// Data Firehose either tries to send the data again or considers it an error,
	// based on your retry settings.
	HECAcknowledgmentTimeoutInSeconds *int64 `min:"180" type:"integer"`

	// The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends
	// your data.
	HECEndpoint *string `type:"string"`

	// This type can be either "Raw" or "Event."
	HECEndpointType *string `type:"string" enum:"HECEndpointType"`

	// A GUID you obtain from your Splunk cluster when you create a new HEC endpoint.
	HECToken *string `type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver data
	// to Splunk or if it doesn't receive an acknowledgment of receipt from Splunk.
	RetryOptions *SplunkRetryOptions `type:"structure"`

	// Defines how documents should be delivered to Amazon S3. When set to FailedDocumentsOnly,
	// Kinesis Data Firehose writes any data that could not be indexed to the configured
	// Amazon S3 destination. When set to AllDocuments, Kinesis Data Firehose delivers
	// all incoming records to Amazon S3, and also writes failed documents to Amazon
	// S3. Default value is FailedDocumentsOnly.
	S3BackupMode *string `type:"string" enum:"SplunkS3BackupMode"`

	// The Amazon S3 destination.>
	S3DestinationDescription *S3DestinationDescription `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplunkDestinationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplunkDestinationDescription) GoString() string {
	return s.String()
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *SplunkDestinationDescription) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *SplunkDestinationDescription {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetHECAcknowledgmentTimeoutInSeconds sets the HECAcknowledgmentTimeoutInSeconds field's value.
func (s *SplunkDestinationDescription) SetHECAcknowledgmentTimeoutInSeconds(v int64) *SplunkDestinationDescription {
	s.HECAcknowledgmentTimeoutInSeconds = &v
	return s
}

// SetHECEndpoint sets the HECEndpoint field's value.
func (s *SplunkDestinationDescription) SetHECEndpoint(v string) *SplunkDestinationDescription {
	s.HECEndpoint = &v
	return s
}

// SetHECEndpointType sets the HECEndpointType field's value.
func (s *SplunkDestinationDescription) SetHECEndpointType(v string) *SplunkDestinationDescription {
	s.HECEndpointType = &v
	return s
}

// SetHECToken sets the HECToken field's value.
func (s *SplunkDestinationDescription) SetHECToken(v string) *SplunkDestinationDescription {
	s.HECToken = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *SplunkDestinationDescription) SetProcessingConfiguration(v *ProcessingConfiguration) *SplunkDestinationDescription {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *SplunkDestinationDescription) SetRetryOptions(v *SplunkRetryOptions) *SplunkDestinationDescription {
	s.RetryOptions = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *SplunkDestinationDescription) SetS3BackupMode(v string) *SplunkDestinationDescription {
	s.S3BackupMode = &v
	return s
}

// SetS3DestinationDescription sets the S3DestinationDescription field's value.
func (s *SplunkDestinationDescription) SetS3DestinationDescription(v *S3DestinationDescription) *SplunkDestinationDescription {
	s.S3DestinationDescription = v
	return s
}

// Describes an update for a destination in Splunk.
type SplunkDestinationUpdate struct {
	_ struct{} `type:"structure"`

	// The Amazon CloudWatch logging options for your delivery stream.
	CloudWatchLoggingOptions *CloudWatchLoggingOptions `type:"structure"`

	// The amount of time that Kinesis Data Firehose waits to receive an acknowledgment
	// from Splunk after it sends data. At the end of the timeout period, Kinesis
	// Data Firehose either tries to send the data again or considers it an error,
	// based on your retry settings.
	HECAcknowledgmentTimeoutInSeconds *int64 `min:"180" type:"integer"`

	// The HTTP Event Collector (HEC) endpoint to which Kinesis Data Firehose sends
	// your data.
	HECEndpoint *string `type:"string"`

	// This type can be either "Raw" or "Event."
	HECEndpointType *string `type:"string" enum:"HECEndpointType"`

	// A GUID that you obtain from your Splunk cluster when you create a new HEC
	// endpoint.
	HECToken *string `type:"string"`

	// The data processing configuration.
	ProcessingConfiguration *ProcessingConfiguration `type:"structure"`

	// The retry behavior in case Kinesis Data Firehose is unable to deliver data
	// to Splunk or if it doesn't receive an acknowledgment of receipt from Splunk.
	RetryOptions *SplunkRetryOptions `type:"structure"`

	// Specifies how you want Kinesis Data Firehose to back up documents to Amazon
	// S3. When set to FailedDocumentsOnly, Kinesis Data Firehose writes any data
	// that could not be indexed to the configured Amazon S3 destination. When set
	// to AllEvents, Kinesis Data Firehose delivers all incoming records to Amazon
	// S3, and also writes failed documents to Amazon S3. The default value is FailedEventsOnly.
	//
	// You can update this backup mode from FailedEventsOnly to AllEvents. You can't
	// update it from AllEvents to FailedEventsOnly.
	S3BackupMode *string `type:"string" enum:"SplunkS3BackupMode"`

	// Your update to the configuration of the backup Amazon S3 location.
	S3Update *S3DestinationUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplunkDestinationUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplunkDestinationUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SplunkDestinationUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SplunkDestinationUpdate"}
	if s.HECAcknowledgmentTimeoutInSeconds != nil && *s.HECAcknowledgmentTimeoutInSeconds < 180 {
		invalidParams.Add(request.NewErrParamMinValue("HECAcknowledgmentTimeoutInSeconds", 180))
	}
	if s.ProcessingConfiguration != nil {
		if err := s.ProcessingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("ProcessingConfiguration", err.(request.ErrInvalidParams))
		}
	}
	if s.S3Update != nil {
		if err := s.S3Update.Validate(); err != nil {
			invalidParams.AddNested("S3Update", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudWatchLoggingOptions sets the CloudWatchLoggingOptions field's value.
func (s *SplunkDestinationUpdate) SetCloudWatchLoggingOptions(v *CloudWatchLoggingOptions) *SplunkDestinationUpdate {
	s.CloudWatchLoggingOptions = v
	return s
}

// SetHECAcknowledgmentTimeoutInSeconds sets the HECAcknowledgmentTimeoutInSeconds field's value.
func (s *SplunkDestinationUpdate) SetHECAcknowledgmentTimeoutInSeconds(v int64) *SplunkDestinationUpdate {
	s.HECAcknowledgmentTimeoutInSeconds = &v
	return s
}

// SetHECEndpoint sets the HECEndpoint field's value.
func (s *SplunkDestinationUpdate) SetHECEndpoint(v string) *SplunkDestinationUpdate {
	s.HECEndpoint = &v
	return s
}

// SetHECEndpointType sets the HECEndpointType field's value.
func (s *SplunkDestinationUpdate) SetHECEndpointType(v string) *SplunkDestinationUpdate {
	s.HECEndpointType = &v
	return s
}

// SetHECToken sets the HECToken field's value.
func (s *SplunkDestinationUpdate) SetHECToken(v string) *SplunkDestinationUpdate {
	s.HECToken = &v
	return s
}

// SetProcessingConfiguration sets the ProcessingConfiguration field's value.
func (s *SplunkDestinationUpdate) SetProcessingConfiguration(v *ProcessingConfiguration) *SplunkDestinationUpdate {
	s.ProcessingConfiguration = v
	return s
}

// SetRetryOptions sets the RetryOptions field's value.
func (s *SplunkDestinationUpdate) SetRetryOptions(v *SplunkRetryOptions) *SplunkDestinationUpdate {
	s.RetryOptions = v
	return s
}

// SetS3BackupMode sets the S3BackupMode field's value.
func (s *SplunkDestinationUpdate) SetS3BackupMode(v string) *SplunkDestinationUpdate {
	s.S3BackupMode = &v
	return s
}

// SetS3Update sets the S3Update field's value.
func (s *SplunkDestinationUpdate) SetS3Update(v *S3DestinationUpdate) *SplunkDestinationUpdate {
	s.S3Update = v
	return s
}

// Configures retry behavior in case Kinesis Data Firehose is unable to deliver
// documents to Splunk, or if it doesn't receive an acknowledgment from Splunk.
type SplunkRetryOptions struct {
	_ struct{} `type:"structure"`

	// The total amount of time that Kinesis Data Firehose spends on retries. This
	// duration starts after the initial attempt to send data to Splunk fails. It
	// doesn't include the periods during which Kinesis Data Firehose waits for
	// acknowledgment from Splunk after each attempt.
	DurationInSeconds *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplunkRetryOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SplunkRetryOptions) GoString() string {
	return s.String()
}

// SetDurationInSeconds sets the DurationInSeconds field's value.
func (s *SplunkRetryOptions) SetDurationInSeconds(v int64) *SplunkRetryOptions {
	s.DurationInSeconds = &v
	return s
}

type StartDeliveryStreamEncryptionInput struct {
	_ struct{} `type:"structure"`

	// Used to specify the type and Amazon Resource Name (ARN) of the KMS key needed
	// for Server-Side Encryption (SSE).
	DeliveryStreamEncryptionConfigurationInput *DeliveryStreamEncryptionConfigurationInput `type:"structure"`

	// The name of the delivery stream for which you want to enable server-side
	// encryption (SSE).
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeliveryStreamEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeliveryStreamEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDeliveryStreamEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDeliveryStreamEncryptionInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.DeliveryStreamEncryptionConfigurationInput != nil {
		if err := s.DeliveryStreamEncryptionConfigurationInput.Validate(); err != nil {
			invalidParams.AddNested("DeliveryStreamEncryptionConfigurationInput", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamEncryptionConfigurationInput sets the DeliveryStreamEncryptionConfigurationInput field's value.
func (s *StartDeliveryStreamEncryptionInput) SetDeliveryStreamEncryptionConfigurationInput(v *DeliveryStreamEncryptionConfigurationInput) *StartDeliveryStreamEncryptionInput {
	s.DeliveryStreamEncryptionConfigurationInput = v
	return s
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *StartDeliveryStreamEncryptionInput) SetDeliveryStreamName(v string) *StartDeliveryStreamEncryptionInput {
	s.DeliveryStreamName = &v
	return s
}

type StartDeliveryStreamEncryptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeliveryStreamEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDeliveryStreamEncryptionOutput) GoString() string {
	return s.String()
}

type StopDeliveryStreamEncryptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream for which you want to disable server-side
	// encryption (SSE).
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDeliveryStreamEncryptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDeliveryStreamEncryptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopDeliveryStreamEncryptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopDeliveryStreamEncryptionInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *StopDeliveryStreamEncryptionInput) SetDeliveryStreamName(v string) *StopDeliveryStreamEncryptionInput {
	s.DeliveryStreamName = &v
	return s
}

type StopDeliveryStreamEncryptionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDeliveryStreamEncryptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopDeliveryStreamEncryptionOutput) GoString() string {
	return s.String()
}

// Metadata that you can assign to a delivery stream, consisting of a key-value
// pair.
type Tag struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the tag. Maximum length: 128 characters. Valid characters:
	// Unicode letters, digits, white space, _ . / = + - % @
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// An optional string, which you can use to describe or define the tag. Maximum
	// length: 256 characters. Valid characters: Unicode letters, digits, white
	// space, _ . / = + - % @
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream to which you want to add the tags.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// A set of key-value pairs to use to create the tags.
	//
	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *TagDeliveryStreamInput) SetDeliveryStreamName(v string) *TagDeliveryStreamInput {
	s.DeliveryStreamName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagDeliveryStreamInput) SetTags(v []*Tag) *TagDeliveryStreamInput {
	s.Tags = v
	return s
}

type TagDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagDeliveryStreamOutput) GoString() string {
	return s.String()
}

type UntagDeliveryStreamInput struct {
	_ struct{} `type:"structure"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// A list of tag keys. Each corresponding tag is removed from the delivery stream.
	//
	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagDeliveryStreamInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagDeliveryStreamInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagDeliveryStreamInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagDeliveryStreamInput"}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *UntagDeliveryStreamInput) SetDeliveryStreamName(v string) *UntagDeliveryStreamInput {
	s.DeliveryStreamName = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagDeliveryStreamInput) SetTagKeys(v []*string) *UntagDeliveryStreamInput {
	s.TagKeys = v
	return s
}

type UntagDeliveryStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagDeliveryStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagDeliveryStreamOutput) GoString() string {
	return s.String()
}

type UpdateDestinationInput struct {
	_ struct{} `type:"structure"`

	// Describes an update for a destination in the Serverless offering for Amazon
	// OpenSearch Service.
	AmazonOpenSearchServerlessDestinationUpdate *AmazonOpenSearchServerlessDestinationUpdate `type:"structure"`

	// Describes an update for a destination in Amazon OpenSearch Service.
	AmazonopensearchserviceDestinationUpdate *AmazonopensearchserviceDestinationUpdate `type:"structure"`

	// Obtain this value from the VersionId result of DeliveryStreamDescription.
	// This value is required, and helps the service perform conditional operations.
	// For example, if there is an interleaving update and this value is null, then
	// the update destination fails. After the update is successful, the VersionId
	// value is updated. The service then performs a merge of the old configuration
	// with the new configuration.
	//
	// CurrentDeliveryStreamVersionId is a required field
	CurrentDeliveryStreamVersionId *string `min:"1" type:"string" required:"true"`

	// The name of the delivery stream.
	//
	// DeliveryStreamName is a required field
	DeliveryStreamName *string `min:"1" type:"string" required:"true"`

	// The ID of the destination.
	//
	// DestinationId is a required field
	DestinationId *string `min:"1" type:"string" required:"true"`

	// Describes an update for a destination in Amazon ES.
	ElasticsearchDestinationUpdate *ElasticsearchDestinationUpdate `type:"structure"`

	// Describes an update for a destination in Amazon S3.
	ExtendedS3DestinationUpdate *ExtendedS3DestinationUpdate `type:"structure"`

	// Describes an update to the specified HTTP endpoint destination.
	HttpEndpointDestinationUpdate *HttpEndpointDestinationUpdate `type:"structure"`

	// Describes an update for a destination in Amazon Redshift.
	RedshiftDestinationUpdate *RedshiftDestinationUpdate `type:"structure"`

	// [Deprecated] Describes an update for a destination in Amazon S3.
	//
	// Deprecated: S3DestinationUpdate has been deprecated
	S3DestinationUpdate *S3DestinationUpdate `deprecated:"true" type:"structure"`

	// Describes an update for a destination in Splunk.
	SplunkDestinationUpdate *SplunkDestinationUpdate `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDestinationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDestinationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDestinationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDestinationInput"}
	if s.CurrentDeliveryStreamVersionId == nil {
		invalidParams.Add(request.NewErrParamRequired("CurrentDeliveryStreamVersionId"))
	}
	if s.CurrentDeliveryStreamVersionId != nil && len(*s.CurrentDeliveryStreamVersionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentDeliveryStreamVersionId", 1))
	}
	if s.DeliveryStreamName == nil {
		invalidParams.Add(request.NewErrParamRequired("DeliveryStreamName"))
	}
	if s.DeliveryStreamName != nil && len(*s.DeliveryStreamName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeliveryStreamName", 1))
	}
	if s.DestinationId == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationId"))
	}
	if s.DestinationId != nil && len(*s.DestinationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DestinationId", 1))
	}
	if s.AmazonOpenSearchServerlessDestinationUpdate != nil {
		if err := s.AmazonOpenSearchServerlessDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("AmazonOpenSearchServerlessDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.AmazonopensearchserviceDestinationUpdate != nil {
		if err := s.AmazonopensearchserviceDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("AmazonopensearchserviceDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.ElasticsearchDestinationUpdate != nil {
		if err := s.ElasticsearchDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.ExtendedS3DestinationUpdate != nil {
		if err := s.ExtendedS3DestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("ExtendedS3DestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.HttpEndpointDestinationUpdate != nil {
		if err := s.HttpEndpointDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("HttpEndpointDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.RedshiftDestinationUpdate != nil {
		if err := s.RedshiftDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("RedshiftDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.S3DestinationUpdate != nil {
		if err := s.S3DestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("S3DestinationUpdate", err.(request.ErrInvalidParams))
		}
	}
	if s.SplunkDestinationUpdate != nil {
		if err := s.SplunkDestinationUpdate.Validate(); err != nil {
			invalidParams.AddNested("SplunkDestinationUpdate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmazonOpenSearchServerlessDestinationUpdate sets the AmazonOpenSearchServerlessDestinationUpdate field's value.
func (s *UpdateDestinationInput) SetAmazonOpenSearchServerlessDestinationUpdate(v *AmazonOpenSearchServerlessDestinationUpdate) *UpdateDestinationInput {
	s.AmazonOpenSearchServerlessDestinationUpdate = v
	return s
}

// SetAmazonopensearchserviceDestinationUpdate sets the AmazonopensearchserviceDestinationUpdate field's value.
func (s *UpdateDestinationInput) SetAmazonopensearchserviceDestinationUpdate(v *AmazonopensearchserviceDestinationUpdate) *UpdateDestinationInput {
	s.AmazonopensearchserviceDestinationUpdate = v
	return s
}

// SetCurrentDeliveryStreamVersionId sets the CurrentDeliveryStreamVersionId field's value.
func (s *UpdateDestinationInput) SetCurrentDeliveryStreamVersionId(v string) *UpdateDestinationInput {
	s.CurrentDeliveryStreamVersionId = &v
	return s
}

// SetDeliveryStreamName sets the DeliveryStreamName field's value.
func (s *UpdateDestinationInput) SetDeliveryStreamName(v string) *UpdateDestinationInput {
	s.DeliveryStreamName = &v
	return s
}

// SetDestinationId sets the DestinationId field's value.
func (s *UpdateDestinationInput) SetDestinationId(v string) *UpdateDestinationInput {
	s.DestinationId = &v
	return s
}

// SetElasticsearchDestinationUpdate sets the ElasticsearchDestinationUpdate field's value.
func (s *UpdateDestinationInput) SetElasticsearchDestinationUpdate(v *ElasticsearchDestinationUpdate) *UpdateDestinationInput {
	s.ElasticsearchDestinationUpdate = v
	return s
}

// SetExtendedS3DestinationUpdate sets the ExtendedS3DestinationUpdate field's value.
func (s *UpdateDestinationInput) SetExtendedS3DestinationUpdate(v *ExtendedS3DestinationUpdate) *UpdateDestinationInput {
	s.ExtendedS3DestinationUpdate = v
	return s
}

// SetHttpEndpointDestinationUpdate sets the HttpEndpointDestinationUpdate field's value.
func (s *UpdateDestinationInput) SetHttpEndpointDestinationUpdate(v *HttpEndpointDestinationUpdate) *UpdateDestinationInput {
	s.HttpEndpointDestinationUpdate = v
	return s
}

// SetRedshiftDestinationUpdate sets the RedshiftDestinationUpdate field's value.
func (s *UpdateDestinationInput) SetRedshiftDestinationUpdate(v *RedshiftDestinationUpdate) *UpdateDestinationInput {
	s.RedshiftDestinationUpdate = v
	return s
}

// SetS3DestinationUpdate sets the S3DestinationUpdate field's value.
func (s *UpdateDestinationInput) SetS3DestinationUpdate(v *S3DestinationUpdate) *UpdateDestinationInput {
	s.S3DestinationUpdate = v
	return s
}

// SetSplunkDestinationUpdate sets the SplunkDestinationUpdate field's value.
func (s *UpdateDestinationInput) SetSplunkDestinationUpdate(v *SplunkDestinationUpdate) *UpdateDestinationInput {
	s.SplunkDestinationUpdate = v
	return s
}

type UpdateDestinationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDestinationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDestinationOutput) GoString() string {
	return s.String()
}

// The details of the VPC of the Amazon OpenSearch or Amazon OpenSearch Serverless
// destination.
type VpcConfiguration struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that you want the delivery stream to use to create
	// endpoints in the destination VPC. You can use your existing Kinesis Data
	// Firehose delivery role or you can specify a new role. In either case, make
	// sure that the role trusts the Kinesis Data Firehose service principal and
	// that it grants the following permissions:
	//
	//    * ec2:DescribeVpcs
	//
	//    * ec2:DescribeVpcAttribute
	//
	//    * ec2:DescribeSubnets
	//
	//    * ec2:DescribeSecurityGroups
	//
	//    * ec2:DescribeNetworkInterfaces
	//
	//    * ec2:CreateNetworkInterface
	//
	//    * ec2:CreateNetworkInterfacePermission
	//
	//    * ec2:DeleteNetworkInterface
	//
	// If you revoke these permissions after you create the delivery stream, Kinesis
	// Data Firehose can't scale out by creating more ENIs when necessary. You might
	// therefore see a degradation in performance.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The IDs of the security groups that you want Kinesis Data Firehose to use
	// when it creates ENIs in the VPC of the Amazon ES destination. You can use
	// the same security group that the Amazon ES domain uses or different ones.
	// If you specify different security groups here, ensure that they allow outbound
	// HTTPS traffic to the Amazon ES domain's security group. Also ensure that
	// the Amazon ES domain's security group allows HTTPS traffic from the security
	// groups specified here. If you use the same security group for both your delivery
	// stream and the Amazon ES domain, make sure the security group inbound rule
	// allows HTTPS traffic. For more information about security group rules, see
	// Security group rules (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules)
	// in the Amazon VPC documentation.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `min:"1" type:"list" required:"true"`

	// The IDs of the subnets that you want Kinesis Data Firehose to use to create
	// ENIs in the VPC of the Amazon ES destination. Make sure that the routing
	// tables and inbound and outbound rules allow traffic to flow from the subnets
	// whose IDs are specified here to the subnets that have the destination Amazon
	// ES endpoints. Kinesis Data Firehose creates at least one ENI in each of the
	// subnets that are specified here. Do not delete or modify these ENIs.
	//
	// The number of ENIs that Kinesis Data Firehose creates in the subnets specified
	// here scales up and down automatically based on throughput. To enable Kinesis
	// Data Firehose to scale up the number of ENIs to match throughput, ensure
	// that you have sufficient quota. To help you calculate the quota you need,
	// assume that Kinesis Data Firehose can create up to three ENIs for this delivery
	// stream for each of the subnets specified here. For more information about
	// ENI quota, see Network Interfaces (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis)
	// in the Amazon VPC Quotas topic.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VpcConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VpcConfiguration"}
	if s.RoleARN == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleARN"))
	}
	if s.RoleARN != nil && len(*s.RoleARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoleARN", 1))
	}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SecurityGroupIds != nil && len(s.SecurityGroupIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroupIds", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.SubnetIds != nil && len(s.SubnetIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SubnetIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleARN sets the RoleARN field's value.
func (s *VpcConfiguration) SetRoleARN(v string) *VpcConfiguration {
	s.RoleARN = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfiguration) SetSecurityGroupIds(v []*string) *VpcConfiguration {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfiguration) SetSubnetIds(v []*string) *VpcConfiguration {
	s.SubnetIds = v
	return s
}

// The details of the VPC of the Amazon ES destination.
type VpcConfigurationDescription struct {
	_ struct{} `type:"structure"`

	// The ARN of the IAM role that the delivery stream uses to create endpoints
	// in the destination VPC. You can use your existing Kinesis Data Firehose delivery
	// role or you can specify a new role. In either case, make sure that the role
	// trusts the Kinesis Data Firehose service principal and that it grants the
	// following permissions:
	//
	//    * ec2:DescribeVpcs
	//
	//    * ec2:DescribeVpcAttribute
	//
	//    * ec2:DescribeSubnets
	//
	//    * ec2:DescribeSecurityGroups
	//
	//    * ec2:DescribeNetworkInterfaces
	//
	//    * ec2:CreateNetworkInterface
	//
	//    * ec2:CreateNetworkInterfacePermission
	//
	//    * ec2:DeleteNetworkInterface
	//
	// If you revoke these permissions after you create the delivery stream, Kinesis
	// Data Firehose can't scale out by creating more ENIs when necessary. You might
	// therefore see a degradation in performance.
	//
	// RoleARN is a required field
	RoleARN *string `min:"1" type:"string" required:"true"`

	// The IDs of the security groups that Kinesis Data Firehose uses when it creates
	// ENIs in the VPC of the Amazon ES destination. You can use the same security
	// group that the Amazon ES domain uses or different ones. If you specify different
	// security groups, ensure that they allow outbound HTTPS traffic to the Amazon
	// ES domain's security group. Also ensure that the Amazon ES domain's security
	// group allows HTTPS traffic from the security groups specified here. If you
	// use the same security group for both your delivery stream and the Amazon
	// ES domain, make sure the security group inbound rule allows HTTPS traffic.
	// For more information about security group rules, see Security group rules
	// (https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html#SecurityGroupRules)
	// in the Amazon VPC documentation.
	//
	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `min:"1" type:"list" required:"true"`

	// The IDs of the subnets that Kinesis Data Firehose uses to create ENIs in
	// the VPC of the Amazon ES destination. Make sure that the routing tables and
	// inbound and outbound rules allow traffic to flow from the subnets whose IDs
	// are specified here to the subnets that have the destination Amazon ES endpoints.
	// Kinesis Data Firehose creates at least one ENI in each of the subnets that
	// are specified here. Do not delete or modify these ENIs.
	//
	// The number of ENIs that Kinesis Data Firehose creates in the subnets specified
	// here scales up and down automatically based on throughput. To enable Kinesis
	// Data Firehose to scale up the number of ENIs to match throughput, ensure
	// that you have sufficient quota. To help you calculate the quota you need,
	// assume that Kinesis Data Firehose can create up to three ENIs for this delivery
	// stream for each of the subnets specified here. For more information about
	// ENI quota, see Network Interfaces (https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html#vpc-limits-enis)
	// in the Amazon VPC Quotas topic.
	//
	// SubnetIds is a required field
	SubnetIds []*string `min:"1" type:"list" required:"true"`

	// The ID of the Amazon ES destination's VPC.
	//
	// VpcId is a required field
	VpcId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigurationDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcConfigurationDescription) GoString() string {
	return s.String()
}

// SetRoleARN sets the RoleARN field's value.
func (s *VpcConfigurationDescription) SetRoleARN(v string) *VpcConfigurationDescription {
	s.RoleARN = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *VpcConfigurationDescription) SetSecurityGroupIds(v []*string) *VpcConfigurationDescription {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *VpcConfigurationDescription) SetSubnetIds(v []*string) *VpcConfigurationDescription {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcConfigurationDescription) SetVpcId(v string) *VpcConfigurationDescription {
	s.VpcId = &v
	return s
}

const (
	// AmazonOpenSearchServerlessS3BackupModeFailedDocumentsOnly is a AmazonOpenSearchServerlessS3BackupMode enum value
	AmazonOpenSearchServerlessS3BackupModeFailedDocumentsOnly = "FailedDocumentsOnly"

	// AmazonOpenSearchServerlessS3BackupModeAllDocuments is a AmazonOpenSearchServerlessS3BackupMode enum value
	AmazonOpenSearchServerlessS3BackupModeAllDocuments = "AllDocuments"
)

// AmazonOpenSearchServerlessS3BackupMode_Values returns all elements of the AmazonOpenSearchServerlessS3BackupMode enum
func AmazonOpenSearchServerlessS3BackupMode_Values() []string {
	return []string{
		AmazonOpenSearchServerlessS3BackupModeFailedDocumentsOnly,
		AmazonOpenSearchServerlessS3BackupModeAllDocuments,
	}
}

const (
	// AmazonopensearchserviceIndexRotationPeriodNoRotation is a AmazonopensearchserviceIndexRotationPeriod enum value
	AmazonopensearchserviceIndexRotationPeriodNoRotation = "NoRotation"

	// AmazonopensearchserviceIndexRotationPeriodOneHour is a AmazonopensearchserviceIndexRotationPeriod enum value
	AmazonopensearchserviceIndexRotationPeriodOneHour = "OneHour"

	// AmazonopensearchserviceIndexRotationPeriodOneDay is a AmazonopensearchserviceIndexRotationPeriod enum value
	AmazonopensearchserviceIndexRotationPeriodOneDay = "OneDay"

	// AmazonopensearchserviceIndexRotationPeriodOneWeek is a AmazonopensearchserviceIndexRotationPeriod enum value
	AmazonopensearchserviceIndexRotationPeriodOneWeek = "OneWeek"

	// AmazonopensearchserviceIndexRotationPeriodOneMonth is a AmazonopensearchserviceIndexRotationPeriod enum value
	AmazonopensearchserviceIndexRotationPeriodOneMonth = "OneMonth"
)

// AmazonopensearchserviceIndexRotationPeriod_Values returns all elements of the AmazonopensearchserviceIndexRotationPeriod enum
func AmazonopensearchserviceIndexRotationPeriod_Values() []string {
	return []string{
		AmazonopensearchserviceIndexRotationPeriodNoRotation,
		AmazonopensearchserviceIndexRotationPeriodOneHour,
		AmazonopensearchserviceIndexRotationPeriodOneDay,
		AmazonopensearchserviceIndexRotationPeriodOneWeek,
		AmazonopensearchserviceIndexRotationPeriodOneMonth,
	}
}

const (
	// AmazonopensearchserviceS3BackupModeFailedDocumentsOnly is a AmazonopensearchserviceS3BackupMode enum value
	AmazonopensearchserviceS3BackupModeFailedDocumentsOnly = "FailedDocumentsOnly"

	// AmazonopensearchserviceS3BackupModeAllDocuments is a AmazonopensearchserviceS3BackupMode enum value
	AmazonopensearchserviceS3BackupModeAllDocuments = "AllDocuments"
)

// AmazonopensearchserviceS3BackupMode_Values returns all elements of the AmazonopensearchserviceS3BackupMode enum
func AmazonopensearchserviceS3BackupMode_Values() []string {
	return []string{
		AmazonopensearchserviceS3BackupModeFailedDocumentsOnly,
		AmazonopensearchserviceS3BackupModeAllDocuments,
	}
}

const (
	// CompressionFormatUncompressed is a CompressionFormat enum value
	CompressionFormatUncompressed = "UNCOMPRESSED"

	// CompressionFormatGzip is a CompressionFormat enum value
	CompressionFormatGzip = "GZIP"

	// CompressionFormatZip is a CompressionFormat enum value
	CompressionFormatZip = "ZIP"

	// CompressionFormatSnappy is a CompressionFormat enum value
	CompressionFormatSnappy = "Snappy"

	// CompressionFormatHadoopSnappy is a CompressionFormat enum value
	CompressionFormatHadoopSnappy = "HADOOP_SNAPPY"
)

// CompressionFormat_Values returns all elements of the CompressionFormat enum
func CompressionFormat_Values() []string {
	return []string{
		CompressionFormatUncompressed,
		CompressionFormatGzip,
		CompressionFormatZip,
		CompressionFormatSnappy,
		CompressionFormatHadoopSnappy,
	}
}

const (
	// ContentEncodingNone is a ContentEncoding enum value
	ContentEncodingNone = "NONE"

	// ContentEncodingGzip is a ContentEncoding enum value
	ContentEncodingGzip = "GZIP"
)

// ContentEncoding_Values returns all elements of the ContentEncoding enum
func ContentEncoding_Values() []string {
	return []string{
		ContentEncodingNone,
		ContentEncodingGzip,
	}
}

const (
	// DefaultDocumentIdFormatFirehoseDefault is a DefaultDocumentIdFormat enum value
	DefaultDocumentIdFormatFirehoseDefault = "FIREHOSE_DEFAULT"

	// DefaultDocumentIdFormatNoDocumentId is a DefaultDocumentIdFormat enum value
	DefaultDocumentIdFormatNoDocumentId = "NO_DOCUMENT_ID"
)

// DefaultDocumentIdFormat_Values returns all elements of the DefaultDocumentIdFormat enum
func DefaultDocumentIdFormat_Values() []string {
	return []string{
		DefaultDocumentIdFormatFirehoseDefault,
		DefaultDocumentIdFormatNoDocumentId,
	}
}

const (
	// DeliveryStreamEncryptionStatusEnabled is a DeliveryStreamEncryptionStatus enum value
	DeliveryStreamEncryptionStatusEnabled = "ENABLED"

	// DeliveryStreamEncryptionStatusEnabling is a DeliveryStreamEncryptionStatus enum value
	DeliveryStreamEncryptionStatusEnabling = "ENABLING"

	// DeliveryStreamEncryptionStatusEnablingFailed is a DeliveryStreamEncryptionStatus enum value
	DeliveryStreamEncryptionStatusEnablingFailed = "ENABLING_FAILED"

	// DeliveryStreamEncryptionStatusDisabled is a DeliveryStreamEncryptionStatus enum value
	DeliveryStreamEncryptionStatusDisabled = "DISABLED"

	// DeliveryStreamEncryptionStatusDisabling is a DeliveryStreamEncryptionStatus enum value
	DeliveryStreamEncryptionStatusDisabling = "DISABLING"

	// DeliveryStreamEncryptionStatusDisablingFailed is a DeliveryStreamEncryptionStatus enum value
	DeliveryStreamEncryptionStatusDisablingFailed = "DISABLING_FAILED"
)

// DeliveryStreamEncryptionStatus_Values returns all elements of the DeliveryStreamEncryptionStatus enum
func DeliveryStreamEncryptionStatus_Values() []string {
	return []string{
		DeliveryStreamEncryptionStatusEnabled,
		DeliveryStreamEncryptionStatusEnabling,
		DeliveryStreamEncryptionStatusEnablingFailed,
		DeliveryStreamEncryptionStatusDisabled,
		DeliveryStreamEncryptionStatusDisabling,
		DeliveryStreamEncryptionStatusDisablingFailed,
	}
}

const (
	// DeliveryStreamFailureTypeRetireKmsGrantFailed is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeRetireKmsGrantFailed = "RETIRE_KMS_GRANT_FAILED"

	// DeliveryStreamFailureTypeCreateKmsGrantFailed is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeCreateKmsGrantFailed = "CREATE_KMS_GRANT_FAILED"

	// DeliveryStreamFailureTypeKmsAccessDenied is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeKmsAccessDenied = "KMS_ACCESS_DENIED"

	// DeliveryStreamFailureTypeDisabledKmsKey is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeDisabledKmsKey = "DISABLED_KMS_KEY"

	// DeliveryStreamFailureTypeInvalidKmsKey is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeInvalidKmsKey = "INVALID_KMS_KEY"

	// DeliveryStreamFailureTypeKmsKeyNotFound is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeKmsKeyNotFound = "KMS_KEY_NOT_FOUND"

	// DeliveryStreamFailureTypeKmsOptInRequired is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeKmsOptInRequired = "KMS_OPT_IN_REQUIRED"

	// DeliveryStreamFailureTypeCreateEniFailed is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeCreateEniFailed = "CREATE_ENI_FAILED"

	// DeliveryStreamFailureTypeDeleteEniFailed is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeDeleteEniFailed = "DELETE_ENI_FAILED"

	// DeliveryStreamFailureTypeSubnetNotFound is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeSubnetNotFound = "SUBNET_NOT_FOUND"

	// DeliveryStreamFailureTypeSecurityGroupNotFound is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeSecurityGroupNotFound = "SECURITY_GROUP_NOT_FOUND"

	// DeliveryStreamFailureTypeEniAccessDenied is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeEniAccessDenied = "ENI_ACCESS_DENIED"

	// DeliveryStreamFailureTypeSubnetAccessDenied is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeSubnetAccessDenied = "SUBNET_ACCESS_DENIED"

	// DeliveryStreamFailureTypeSecurityGroupAccessDenied is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeSecurityGroupAccessDenied = "SECURITY_GROUP_ACCESS_DENIED"

	// DeliveryStreamFailureTypeUnknownError is a DeliveryStreamFailureType enum value
	DeliveryStreamFailureTypeUnknownError = "UNKNOWN_ERROR"
)

// DeliveryStreamFailureType_Values returns all elements of the DeliveryStreamFailureType enum
func DeliveryStreamFailureType_Values() []string {
	return []string{
		DeliveryStreamFailureTypeRetireKmsGrantFailed,
		DeliveryStreamFailureTypeCreateKmsGrantFailed,
		DeliveryStreamFailureTypeKmsAccessDenied,
		DeliveryStreamFailureTypeDisabledKmsKey,
		DeliveryStreamFailureTypeInvalidKmsKey,
		DeliveryStreamFailureTypeKmsKeyNotFound,
		DeliveryStreamFailureTypeKmsOptInRequired,
		DeliveryStreamFailureTypeCreateEniFailed,
		DeliveryStreamFailureTypeDeleteEniFailed,
		DeliveryStreamFailureTypeSubnetNotFound,
		DeliveryStreamFailureTypeSecurityGroupNotFound,
		DeliveryStreamFailureTypeEniAccessDenied,
		DeliveryStreamFailureTypeSubnetAccessDenied,
		DeliveryStreamFailureTypeSecurityGroupAccessDenied,
		DeliveryStreamFailureTypeUnknownError,
	}
}

const (
	// DeliveryStreamStatusCreating is a DeliveryStreamStatus enum value
	DeliveryStreamStatusCreating = "CREATING"

	// DeliveryStreamStatusCreatingFailed is a DeliveryStreamStatus enum value
	DeliveryStreamStatusCreatingFailed = "CREATING_FAILED"

	// DeliveryStreamStatusDeleting is a DeliveryStreamStatus enum value
	DeliveryStreamStatusDeleting = "DELETING"

	// DeliveryStreamStatusDeletingFailed is a DeliveryStreamStatus enum value
	DeliveryStreamStatusDeletingFailed = "DELETING_FAILED"

	// DeliveryStreamStatusActive is a DeliveryStreamStatus enum value
	DeliveryStreamStatusActive = "ACTIVE"
)

// DeliveryStreamStatus_Values returns all elements of the DeliveryStreamStatus enum
func DeliveryStreamStatus_Values() []string {
	return []string{
		DeliveryStreamStatusCreating,
		DeliveryStreamStatusCreatingFailed,
		DeliveryStreamStatusDeleting,
		DeliveryStreamStatusDeletingFailed,
		DeliveryStreamStatusActive,
	}
}

const (
	// DeliveryStreamTypeDirectPut is a DeliveryStreamType enum value
	DeliveryStreamTypeDirectPut = "DirectPut"

	// DeliveryStreamTypeKinesisStreamAsSource is a DeliveryStreamType enum value
	DeliveryStreamTypeKinesisStreamAsSource = "KinesisStreamAsSource"
)

// DeliveryStreamType_Values returns all elements of the DeliveryStreamType enum
func DeliveryStreamType_Values() []string {
	return []string{
		DeliveryStreamTypeDirectPut,
		DeliveryStreamTypeKinesisStreamAsSource,
	}
}

const (
	// ElasticsearchIndexRotationPeriodNoRotation is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodNoRotation = "NoRotation"

	// ElasticsearchIndexRotationPeriodOneHour is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneHour = "OneHour"

	// ElasticsearchIndexRotationPeriodOneDay is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneDay = "OneDay"

	// ElasticsearchIndexRotationPeriodOneWeek is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneWeek = "OneWeek"

	// ElasticsearchIndexRotationPeriodOneMonth is a ElasticsearchIndexRotationPeriod enum value
	ElasticsearchIndexRotationPeriodOneMonth = "OneMonth"
)

// ElasticsearchIndexRotationPeriod_Values returns all elements of the ElasticsearchIndexRotationPeriod enum
func ElasticsearchIndexRotationPeriod_Values() []string {
	return []string{
		ElasticsearchIndexRotationPeriodNoRotation,
		ElasticsearchIndexRotationPeriodOneHour,
		ElasticsearchIndexRotationPeriodOneDay,
		ElasticsearchIndexRotationPeriodOneWeek,
		ElasticsearchIndexRotationPeriodOneMonth,
	}
}

const (
	// ElasticsearchS3BackupModeFailedDocumentsOnly is a ElasticsearchS3BackupMode enum value
	ElasticsearchS3BackupModeFailedDocumentsOnly = "FailedDocumentsOnly"

	// ElasticsearchS3BackupModeAllDocuments is a ElasticsearchS3BackupMode enum value
	ElasticsearchS3BackupModeAllDocuments = "AllDocuments"
)

// ElasticsearchS3BackupMode_Values returns all elements of the ElasticsearchS3BackupMode enum
func ElasticsearchS3BackupMode_Values() []string {
	return []string{
		ElasticsearchS3BackupModeFailedDocumentsOnly,
		ElasticsearchS3BackupModeAllDocuments,
	}
}

const (
	// HECEndpointTypeRaw is a HECEndpointType enum value
	HECEndpointTypeRaw = "Raw"

	// HECEndpointTypeEvent is a HECEndpointType enum value
	HECEndpointTypeEvent = "Event"
)

// HECEndpointType_Values returns all elements of the HECEndpointType enum
func HECEndpointType_Values() []string {
	return []string{
		HECEndpointTypeRaw,
		HECEndpointTypeEvent,
	}
}

const (
	// HttpEndpointS3BackupModeFailedDataOnly is a HttpEndpointS3BackupMode enum value
	HttpEndpointS3BackupModeFailedDataOnly = "FailedDataOnly"

	// HttpEndpointS3BackupModeAllData is a HttpEndpointS3BackupMode enum value
	HttpEndpointS3BackupModeAllData = "AllData"
)

// HttpEndpointS3BackupMode_Values returns all elements of the HttpEndpointS3BackupMode enum
func HttpEndpointS3BackupMode_Values() []string {
	return []string{
		HttpEndpointS3BackupModeFailedDataOnly,
		HttpEndpointS3BackupModeAllData,
	}
}

const (
	// KeyTypeAwsOwnedCmk is a KeyType enum value
	KeyTypeAwsOwnedCmk = "AWS_OWNED_CMK"

	// KeyTypeCustomerManagedCmk is a KeyType enum value
	KeyTypeCustomerManagedCmk = "CUSTOMER_MANAGED_CMK"
)

// KeyType_Values returns all elements of the KeyType enum
func KeyType_Values() []string {
	return []string{
		KeyTypeAwsOwnedCmk,
		KeyTypeCustomerManagedCmk,
	}
}

const (
	// NoEncryptionConfigNoEncryption is a NoEncryptionConfig enum value
	NoEncryptionConfigNoEncryption = "NoEncryption"
)

// NoEncryptionConfig_Values returns all elements of the NoEncryptionConfig enum
func NoEncryptionConfig_Values() []string {
	return []string{
		NoEncryptionConfigNoEncryption,
	}
}

const (
	// OrcCompressionNone is a OrcCompression enum value
	OrcCompressionNone = "NONE"

	// OrcCompressionZlib is a OrcCompression enum value
	OrcCompressionZlib = "ZLIB"

	// OrcCompressionSnappy is a OrcCompression enum value
	OrcCompressionSnappy = "SNAPPY"
)

// OrcCompression_Values returns all elements of the OrcCompression enum
func OrcCompression_Values() []string {
	return []string{
		OrcCompressionNone,
		OrcCompressionZlib,
		OrcCompressionSnappy,
	}
}

const (
	// OrcFormatVersionV011 is a OrcFormatVersion enum value
	OrcFormatVersionV011 = "V0_11"

	// OrcFormatVersionV012 is a OrcFormatVersion enum value
	OrcFormatVersionV012 = "V0_12"
)

// OrcFormatVersion_Values returns all elements of the OrcFormatVersion enum
func OrcFormatVersion_Values() []string {
	return []string{
		OrcFormatVersionV011,
		OrcFormatVersionV012,
	}
}

const (
	// ParquetCompressionUncompressed is a ParquetCompression enum value
	ParquetCompressionUncompressed = "UNCOMPRESSED"

	// ParquetCompressionGzip is a ParquetCompression enum value
	ParquetCompressionGzip = "GZIP"

	// ParquetCompressionSnappy is a ParquetCompression enum value
	ParquetCompressionSnappy = "SNAPPY"
)

// ParquetCompression_Values returns all elements of the ParquetCompression enum
func ParquetCompression_Values() []string {
	return []string{
		ParquetCompressionUncompressed,
		ParquetCompressionGzip,
		ParquetCompressionSnappy,
	}
}

const (
	// ParquetWriterVersionV1 is a ParquetWriterVersion enum value
	ParquetWriterVersionV1 = "V1"

	// ParquetWriterVersionV2 is a ParquetWriterVersion enum value
	ParquetWriterVersionV2 = "V2"
)

// ParquetWriterVersion_Values returns all elements of the ParquetWriterVersion enum
func ParquetWriterVersion_Values() []string {
	return []string{
		ParquetWriterVersionV1,
		ParquetWriterVersionV2,
	}
}

const (
	// ProcessorParameterNameLambdaArn is a ProcessorParameterName enum value
	ProcessorParameterNameLambdaArn = "LambdaArn"

	// ProcessorParameterNameNumberOfRetries is a ProcessorParameterName enum value
	ProcessorParameterNameNumberOfRetries = "NumberOfRetries"

	// ProcessorParameterNameMetadataExtractionQuery is a ProcessorParameterName enum value
	ProcessorParameterNameMetadataExtractionQuery = "MetadataExtractionQuery"

	// ProcessorParameterNameJsonParsingEngine is a ProcessorParameterName enum value
	ProcessorParameterNameJsonParsingEngine = "JsonParsingEngine"

	// ProcessorParameterNameRoleArn is a ProcessorParameterName enum value
	ProcessorParameterNameRoleArn = "RoleArn"

	// ProcessorParameterNameBufferSizeInMbs is a ProcessorParameterName enum value
	ProcessorParameterNameBufferSizeInMbs = "BufferSizeInMBs"

	// ProcessorParameterNameBufferIntervalInSeconds is a ProcessorParameterName enum value
	ProcessorParameterNameBufferIntervalInSeconds = "BufferIntervalInSeconds"

	// ProcessorParameterNameSubRecordType is a ProcessorParameterName enum value
	ProcessorParameterNameSubRecordType = "SubRecordType"

	// ProcessorParameterNameDelimiter is a ProcessorParameterName enum value
	ProcessorParameterNameDelimiter = "Delimiter"
)

// ProcessorParameterName_Values returns all elements of the ProcessorParameterName enum
func ProcessorParameterName_Values() []string {
	return []string{
		ProcessorParameterNameLambdaArn,
		ProcessorParameterNameNumberOfRetries,
		ProcessorParameterNameMetadataExtractionQuery,
		ProcessorParameterNameJsonParsingEngine,
		ProcessorParameterNameRoleArn,
		ProcessorParameterNameBufferSizeInMbs,
		ProcessorParameterNameBufferIntervalInSeconds,
		ProcessorParameterNameSubRecordType,
		ProcessorParameterNameDelimiter,
	}
}

const (
	// ProcessorTypeRecordDeAggregation is a ProcessorType enum value
	ProcessorTypeRecordDeAggregation = "RecordDeAggregation"

	// ProcessorTypeLambda is a ProcessorType enum value
	ProcessorTypeLambda = "Lambda"

	// ProcessorTypeMetadataExtraction is a ProcessorType enum value
	ProcessorTypeMetadataExtraction = "MetadataExtraction"

	// ProcessorTypeAppendDelimiterToRecord is a ProcessorType enum value
	ProcessorTypeAppendDelimiterToRecord = "AppendDelimiterToRecord"
)

// ProcessorType_Values returns all elements of the ProcessorType enum
func ProcessorType_Values() []string {
	return []string{
		ProcessorTypeRecordDeAggregation,
		ProcessorTypeLambda,
		ProcessorTypeMetadataExtraction,
		ProcessorTypeAppendDelimiterToRecord,
	}
}

const (
	// RedshiftS3BackupModeDisabled is a RedshiftS3BackupMode enum value
	RedshiftS3BackupModeDisabled = "Disabled"

	// RedshiftS3BackupModeEnabled is a RedshiftS3BackupMode enum value
	RedshiftS3BackupModeEnabled = "Enabled"
)

// RedshiftS3BackupMode_Values returns all elements of the RedshiftS3BackupMode enum
func RedshiftS3BackupMode_Values() []string {
	return []string{
		RedshiftS3BackupModeDisabled,
		RedshiftS3BackupModeEnabled,
	}
}

const (
	// S3BackupModeDisabled is a S3BackupMode enum value
	S3BackupModeDisabled = "Disabled"

	// S3BackupModeEnabled is a S3BackupMode enum value
	S3BackupModeEnabled = "Enabled"
)

// S3BackupMode_Values returns all elements of the S3BackupMode enum
func S3BackupMode_Values() []string {
	return []string{
		S3BackupModeDisabled,
		S3BackupModeEnabled,
	}
}

const (
	// SplunkS3BackupModeFailedEventsOnly is a SplunkS3BackupMode enum value
	SplunkS3BackupModeFailedEventsOnly = "FailedEventsOnly"

	// SplunkS3BackupModeAllEvents is a SplunkS3BackupMode enum value
	SplunkS3BackupModeAllEvents = "AllEvents"
)

// SplunkS3BackupMode_Values returns all elements of the SplunkS3BackupMode enum
func SplunkS3BackupMode_Values() []string {
	return []string{
		SplunkS3BackupModeFailedEventsOnly,
		SplunkS3BackupModeAllEvents,
	}
}
