// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package robomaker

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opBatchDeleteWorlds = "BatchDeleteWorlds"

// BatchDeleteWorldsRequest generates a "aws/request.Request" representing the
// client's request for the BatchDeleteWorlds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDeleteWorlds for more information on using the BatchDeleteWorlds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDeleteWorldsRequest method.
//    req, resp := client.BatchDeleteWorldsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDeleteWorlds
func (c *RoboMaker) BatchDeleteWorldsRequest(input *BatchDeleteWorldsInput) (req *request.Request, output *BatchDeleteWorldsOutput) {
	op := &request.Operation{
		Name:       opBatchDeleteWorlds,
		HTTPMethod: "POST",
		HTTPPath:   "/batchDeleteWorlds",
	}

	if input == nil {
		input = &BatchDeleteWorldsInput{}
	}

	output = &BatchDeleteWorldsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDeleteWorlds API operation for AWS RoboMaker.
//
// Deletes one or more worlds in a batch operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation BatchDeleteWorlds for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDeleteWorlds
func (c *RoboMaker) BatchDeleteWorlds(input *BatchDeleteWorldsInput) (*BatchDeleteWorldsOutput, error) {
	req, out := c.BatchDeleteWorldsRequest(input)
	return out, req.Send()
}

// BatchDeleteWorldsWithContext is the same as BatchDeleteWorlds with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDeleteWorlds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) BatchDeleteWorldsWithContext(ctx aws.Context, input *BatchDeleteWorldsInput, opts ...request.Option) (*BatchDeleteWorldsOutput, error) {
	req, out := c.BatchDeleteWorldsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchDescribeSimulationJob = "BatchDescribeSimulationJob"

// BatchDescribeSimulationJobRequest generates a "aws/request.Request" representing the
// client's request for the BatchDescribeSimulationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See BatchDescribeSimulationJob for more information on using the BatchDescribeSimulationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the BatchDescribeSimulationJobRequest method.
//    req, resp := client.BatchDescribeSimulationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDescribeSimulationJob
func (c *RoboMaker) BatchDescribeSimulationJobRequest(input *BatchDescribeSimulationJobInput) (req *request.Request, output *BatchDescribeSimulationJobOutput) {
	op := &request.Operation{
		Name:       opBatchDescribeSimulationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/batchDescribeSimulationJob",
	}

	if input == nil {
		input = &BatchDescribeSimulationJobInput{}
	}

	output = &BatchDescribeSimulationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// BatchDescribeSimulationJob API operation for AWS RoboMaker.
//
// Describes one or more simulation jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation BatchDescribeSimulationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/BatchDescribeSimulationJob
func (c *RoboMaker) BatchDescribeSimulationJob(input *BatchDescribeSimulationJobInput) (*BatchDescribeSimulationJobOutput, error) {
	req, out := c.BatchDescribeSimulationJobRequest(input)
	return out, req.Send()
}

// BatchDescribeSimulationJobWithContext is the same as BatchDescribeSimulationJob with the addition of
// the ability to pass a context and additional request options.
//
// See BatchDescribeSimulationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) BatchDescribeSimulationJobWithContext(ctx aws.Context, input *BatchDescribeSimulationJobInput, opts ...request.Option) (*BatchDescribeSimulationJobOutput, error) {
	req, out := c.BatchDescribeSimulationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelDeploymentJob = "CancelDeploymentJob"

// CancelDeploymentJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelDeploymentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelDeploymentJob for more information on using the CancelDeploymentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelDeploymentJobRequest method.
//    req, resp := client.CancelDeploymentJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelDeploymentJob
func (c *RoboMaker) CancelDeploymentJobRequest(input *CancelDeploymentJobInput) (req *request.Request, output *CancelDeploymentJobOutput) {
	op := &request.Operation{
		Name:       opCancelDeploymentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/cancelDeploymentJob",
	}

	if input == nil {
		input = &CancelDeploymentJobInput{}
	}

	output = &CancelDeploymentJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelDeploymentJob API operation for AWS RoboMaker.
//
// Cancels the specified deployment job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CancelDeploymentJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelDeploymentJob
func (c *RoboMaker) CancelDeploymentJob(input *CancelDeploymentJobInput) (*CancelDeploymentJobOutput, error) {
	req, out := c.CancelDeploymentJobRequest(input)
	return out, req.Send()
}

// CancelDeploymentJobWithContext is the same as CancelDeploymentJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelDeploymentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CancelDeploymentJobWithContext(ctx aws.Context, input *CancelDeploymentJobInput, opts ...request.Option) (*CancelDeploymentJobOutput, error) {
	req, out := c.CancelDeploymentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSimulationJob = "CancelSimulationJob"

// CancelSimulationJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelSimulationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSimulationJob for more information on using the CancelSimulationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelSimulationJobRequest method.
//    req, resp := client.CancelSimulationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJob
func (c *RoboMaker) CancelSimulationJobRequest(input *CancelSimulationJobInput) (req *request.Request, output *CancelSimulationJobOutput) {
	op := &request.Operation{
		Name:       opCancelSimulationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/cancelSimulationJob",
	}

	if input == nil {
		input = &CancelSimulationJobInput{}
	}

	output = &CancelSimulationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelSimulationJob API operation for AWS RoboMaker.
//
// Cancels the specified simulation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CancelSimulationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJob
func (c *RoboMaker) CancelSimulationJob(input *CancelSimulationJobInput) (*CancelSimulationJobOutput, error) {
	req, out := c.CancelSimulationJobRequest(input)
	return out, req.Send()
}

// CancelSimulationJobWithContext is the same as CancelSimulationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSimulationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CancelSimulationJobWithContext(ctx aws.Context, input *CancelSimulationJobInput, opts ...request.Option) (*CancelSimulationJobOutput, error) {
	req, out := c.CancelSimulationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelSimulationJobBatch = "CancelSimulationJobBatch"

// CancelSimulationJobBatchRequest generates a "aws/request.Request" representing the
// client's request for the CancelSimulationJobBatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelSimulationJobBatch for more information on using the CancelSimulationJobBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelSimulationJobBatchRequest method.
//    req, resp := client.CancelSimulationJobBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJobBatch
func (c *RoboMaker) CancelSimulationJobBatchRequest(input *CancelSimulationJobBatchInput) (req *request.Request, output *CancelSimulationJobBatchOutput) {
	op := &request.Operation{
		Name:       opCancelSimulationJobBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/cancelSimulationJobBatch",
	}

	if input == nil {
		input = &CancelSimulationJobBatchInput{}
	}

	output = &CancelSimulationJobBatchOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelSimulationJobBatch API operation for AWS RoboMaker.
//
// Cancels a simulation job batch. When you cancel a simulation job batch, you
// are also cancelling all of the active simulation jobs created as part of
// the batch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CancelSimulationJobBatch for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelSimulationJobBatch
func (c *RoboMaker) CancelSimulationJobBatch(input *CancelSimulationJobBatchInput) (*CancelSimulationJobBatchOutput, error) {
	req, out := c.CancelSimulationJobBatchRequest(input)
	return out, req.Send()
}

// CancelSimulationJobBatchWithContext is the same as CancelSimulationJobBatch with the addition of
// the ability to pass a context and additional request options.
//
// See CancelSimulationJobBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CancelSimulationJobBatchWithContext(ctx aws.Context, input *CancelSimulationJobBatchInput, opts ...request.Option) (*CancelSimulationJobBatchOutput, error) {
	req, out := c.CancelSimulationJobBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelWorldExportJob = "CancelWorldExportJob"

// CancelWorldExportJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelWorldExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelWorldExportJob for more information on using the CancelWorldExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelWorldExportJobRequest method.
//    req, resp := client.CancelWorldExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldExportJob
func (c *RoboMaker) CancelWorldExportJobRequest(input *CancelWorldExportJobInput) (req *request.Request, output *CancelWorldExportJobOutput) {
	op := &request.Operation{
		Name:       opCancelWorldExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/cancelWorldExportJob",
	}

	if input == nil {
		input = &CancelWorldExportJobInput{}
	}

	output = &CancelWorldExportJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelWorldExportJob API operation for AWS RoboMaker.
//
// Cancels the specified export job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CancelWorldExportJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldExportJob
func (c *RoboMaker) CancelWorldExportJob(input *CancelWorldExportJobInput) (*CancelWorldExportJobOutput, error) {
	req, out := c.CancelWorldExportJobRequest(input)
	return out, req.Send()
}

// CancelWorldExportJobWithContext is the same as CancelWorldExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelWorldExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CancelWorldExportJobWithContext(ctx aws.Context, input *CancelWorldExportJobInput, opts ...request.Option) (*CancelWorldExportJobOutput, error) {
	req, out := c.CancelWorldExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelWorldGenerationJob = "CancelWorldGenerationJob"

// CancelWorldGenerationJobRequest generates a "aws/request.Request" representing the
// client's request for the CancelWorldGenerationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelWorldGenerationJob for more information on using the CancelWorldGenerationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelWorldGenerationJobRequest method.
//    req, resp := client.CancelWorldGenerationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldGenerationJob
func (c *RoboMaker) CancelWorldGenerationJobRequest(input *CancelWorldGenerationJobInput) (req *request.Request, output *CancelWorldGenerationJobOutput) {
	op := &request.Operation{
		Name:       opCancelWorldGenerationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/cancelWorldGenerationJob",
	}

	if input == nil {
		input = &CancelWorldGenerationJobInput{}
	}

	output = &CancelWorldGenerationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CancelWorldGenerationJob API operation for AWS RoboMaker.
//
// Cancels the specified world generator job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CancelWorldGenerationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CancelWorldGenerationJob
func (c *RoboMaker) CancelWorldGenerationJob(input *CancelWorldGenerationJobInput) (*CancelWorldGenerationJobOutput, error) {
	req, out := c.CancelWorldGenerationJobRequest(input)
	return out, req.Send()
}

// CancelWorldGenerationJobWithContext is the same as CancelWorldGenerationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CancelWorldGenerationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CancelWorldGenerationJobWithContext(ctx aws.Context, input *CancelWorldGenerationJobInput, opts ...request.Option) (*CancelWorldGenerationJobOutput, error) {
	req, out := c.CancelWorldGenerationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeploymentJob = "CreateDeploymentJob"

// CreateDeploymentJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeploymentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeploymentJob for more information on using the CreateDeploymentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeploymentJobRequest method.
//    req, resp := client.CreateDeploymentJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateDeploymentJob
func (c *RoboMaker) CreateDeploymentJobRequest(input *CreateDeploymentJobInput) (req *request.Request, output *CreateDeploymentJobOutput) {
	op := &request.Operation{
		Name:       opCreateDeploymentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/createDeploymentJob",
	}

	if input == nil {
		input = &CreateDeploymentJobInput{}
	}

	output = &CreateDeploymentJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeploymentJob API operation for AWS RoboMaker.
//
// Deploys a specific version of a robot application to robots in a fleet.
//
// The robot application must have a numbered applicationVersion for consistency
// reasons. To create a new version, use CreateRobotApplicationVersion or see
// Creating a Robot Application Version (https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html).
//
// After 90 days, deployment jobs expire and will be deleted. They will no longer
// be accessible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateDeploymentJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ConcurrentDeploymentException
//   The failure percentage threshold percentage was met.
//
//   * IdempotentParameterMismatchException
//   The request uses the same client token as a previous, but non-identical request.
//   Do not reuse a client token with different requests, unless the requests
//   are identical.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateDeploymentJob
func (c *RoboMaker) CreateDeploymentJob(input *CreateDeploymentJobInput) (*CreateDeploymentJobOutput, error) {
	req, out := c.CreateDeploymentJobRequest(input)
	return out, req.Send()
}

// CreateDeploymentJobWithContext is the same as CreateDeploymentJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeploymentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateDeploymentJobWithContext(ctx aws.Context, input *CreateDeploymentJobInput, opts ...request.Option) (*CreateDeploymentJobOutput, error) {
	req, out := c.CreateDeploymentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateFleet = "CreateFleet"

// CreateFleetRequest generates a "aws/request.Request" representing the
// client's request for the CreateFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateFleet for more information on using the CreateFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateFleetRequest method.
//    req, resp := client.CreateFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateFleet
func (c *RoboMaker) CreateFleetRequest(input *CreateFleetInput) (req *request.Request, output *CreateFleetOutput) {
	op := &request.Operation{
		Name:       opCreateFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/createFleet",
	}

	if input == nil {
		input = &CreateFleetInput{}
	}

	output = &CreateFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateFleet API operation for AWS RoboMaker.
//
// Creates a fleet, a logical group of robots running the same robot application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateFleet for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateFleet
func (c *RoboMaker) CreateFleet(input *CreateFleetInput) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	return out, req.Send()
}

// CreateFleetWithContext is the same as CreateFleet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateFleetWithContext(ctx aws.Context, input *CreateFleetInput, opts ...request.Option) (*CreateFleetOutput, error) {
	req, out := c.CreateFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRobot = "CreateRobot"

// CreateRobotRequest generates a "aws/request.Request" representing the
// client's request for the CreateRobot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRobot for more information on using the CreateRobot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRobotRequest method.
//    req, resp := client.CreateRobotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobot
func (c *RoboMaker) CreateRobotRequest(input *CreateRobotInput) (req *request.Request, output *CreateRobotOutput) {
	op := &request.Operation{
		Name:       opCreateRobot,
		HTTPMethod: "POST",
		HTTPPath:   "/createRobot",
	}

	if input == nil {
		input = &CreateRobotInput{}
	}

	output = &CreateRobotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRobot API operation for AWS RoboMaker.
//
// Creates a robot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateRobot for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobot
func (c *RoboMaker) CreateRobot(input *CreateRobotInput) (*CreateRobotOutput, error) {
	req, out := c.CreateRobotRequest(input)
	return out, req.Send()
}

// CreateRobotWithContext is the same as CreateRobot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRobot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateRobotWithContext(ctx aws.Context, input *CreateRobotInput, opts ...request.Option) (*CreateRobotOutput, error) {
	req, out := c.CreateRobotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRobotApplication = "CreateRobotApplication"

// CreateRobotApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateRobotApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRobotApplication for more information on using the CreateRobotApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRobotApplicationRequest method.
//    req, resp := client.CreateRobotApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplication
func (c *RoboMaker) CreateRobotApplicationRequest(input *CreateRobotApplicationInput) (req *request.Request, output *CreateRobotApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateRobotApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/createRobotApplication",
	}

	if input == nil {
		input = &CreateRobotApplicationInput{}
	}

	output = &CreateRobotApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRobotApplication API operation for AWS RoboMaker.
//
// Creates a robot application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateRobotApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * IdempotentParameterMismatchException
//   The request uses the same client token as a previous, but non-identical request.
//   Do not reuse a client token with different requests, unless the requests
//   are identical.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplication
func (c *RoboMaker) CreateRobotApplication(input *CreateRobotApplicationInput) (*CreateRobotApplicationOutput, error) {
	req, out := c.CreateRobotApplicationRequest(input)
	return out, req.Send()
}

// CreateRobotApplicationWithContext is the same as CreateRobotApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRobotApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateRobotApplicationWithContext(ctx aws.Context, input *CreateRobotApplicationInput, opts ...request.Option) (*CreateRobotApplicationOutput, error) {
	req, out := c.CreateRobotApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRobotApplicationVersion = "CreateRobotApplicationVersion"

// CreateRobotApplicationVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateRobotApplicationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRobotApplicationVersion for more information on using the CreateRobotApplicationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRobotApplicationVersionRequest method.
//    req, resp := client.CreateRobotApplicationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplicationVersion
func (c *RoboMaker) CreateRobotApplicationVersionRequest(input *CreateRobotApplicationVersionInput) (req *request.Request, output *CreateRobotApplicationVersionOutput) {
	op := &request.Operation{
		Name:       opCreateRobotApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/createRobotApplicationVersion",
	}

	if input == nil {
		input = &CreateRobotApplicationVersionInput{}
	}

	output = &CreateRobotApplicationVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRobotApplicationVersion API operation for AWS RoboMaker.
//
// Creates a version of a robot application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateRobotApplicationVersion for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * IdempotentParameterMismatchException
//   The request uses the same client token as a previous, but non-identical request.
//   Do not reuse a client token with different requests, unless the requests
//   are identical.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateRobotApplicationVersion
func (c *RoboMaker) CreateRobotApplicationVersion(input *CreateRobotApplicationVersionInput) (*CreateRobotApplicationVersionOutput, error) {
	req, out := c.CreateRobotApplicationVersionRequest(input)
	return out, req.Send()
}

// CreateRobotApplicationVersionWithContext is the same as CreateRobotApplicationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRobotApplicationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateRobotApplicationVersionWithContext(ctx aws.Context, input *CreateRobotApplicationVersionInput, opts ...request.Option) (*CreateRobotApplicationVersionOutput, error) {
	req, out := c.CreateRobotApplicationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSimulationApplication = "CreateSimulationApplication"

// CreateSimulationApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSimulationApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSimulationApplication for more information on using the CreateSimulationApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSimulationApplicationRequest method.
//    req, resp := client.CreateSimulationApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplication
func (c *RoboMaker) CreateSimulationApplicationRequest(input *CreateSimulationApplicationInput) (req *request.Request, output *CreateSimulationApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateSimulationApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/createSimulationApplication",
	}

	if input == nil {
		input = &CreateSimulationApplicationInput{}
	}

	output = &CreateSimulationApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSimulationApplication API operation for AWS RoboMaker.
//
// Creates a simulation application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateSimulationApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * IdempotentParameterMismatchException
//   The request uses the same client token as a previous, but non-identical request.
//   Do not reuse a client token with different requests, unless the requests
//   are identical.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplication
func (c *RoboMaker) CreateSimulationApplication(input *CreateSimulationApplicationInput) (*CreateSimulationApplicationOutput, error) {
	req, out := c.CreateSimulationApplicationRequest(input)
	return out, req.Send()
}

// CreateSimulationApplicationWithContext is the same as CreateSimulationApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSimulationApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateSimulationApplicationWithContext(ctx aws.Context, input *CreateSimulationApplicationInput, opts ...request.Option) (*CreateSimulationApplicationOutput, error) {
	req, out := c.CreateSimulationApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSimulationApplicationVersion = "CreateSimulationApplicationVersion"

// CreateSimulationApplicationVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateSimulationApplicationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSimulationApplicationVersion for more information on using the CreateSimulationApplicationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSimulationApplicationVersionRequest method.
//    req, resp := client.CreateSimulationApplicationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplicationVersion
func (c *RoboMaker) CreateSimulationApplicationVersionRequest(input *CreateSimulationApplicationVersionInput) (req *request.Request, output *CreateSimulationApplicationVersionOutput) {
	op := &request.Operation{
		Name:       opCreateSimulationApplicationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/createSimulationApplicationVersion",
	}

	if input == nil {
		input = &CreateSimulationApplicationVersionInput{}
	}

	output = &CreateSimulationApplicationVersionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSimulationApplicationVersion API operation for AWS RoboMaker.
//
// Creates a simulation application with a specific revision id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateSimulationApplicationVersion for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * IdempotentParameterMismatchException
//   The request uses the same client token as a previous, but non-identical request.
//   Do not reuse a client token with different requests, unless the requests
//   are identical.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationApplicationVersion
func (c *RoboMaker) CreateSimulationApplicationVersion(input *CreateSimulationApplicationVersionInput) (*CreateSimulationApplicationVersionOutput, error) {
	req, out := c.CreateSimulationApplicationVersionRequest(input)
	return out, req.Send()
}

// CreateSimulationApplicationVersionWithContext is the same as CreateSimulationApplicationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSimulationApplicationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateSimulationApplicationVersionWithContext(ctx aws.Context, input *CreateSimulationApplicationVersionInput, opts ...request.Option) (*CreateSimulationApplicationVersionOutput, error) {
	req, out := c.CreateSimulationApplicationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSimulationJob = "CreateSimulationJob"

// CreateSimulationJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateSimulationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSimulationJob for more information on using the CreateSimulationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSimulationJobRequest method.
//    req, resp := client.CreateSimulationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationJob
func (c *RoboMaker) CreateSimulationJobRequest(input *CreateSimulationJobInput) (req *request.Request, output *CreateSimulationJobOutput) {
	op := &request.Operation{
		Name:       opCreateSimulationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/createSimulationJob",
	}

	if input == nil {
		input = &CreateSimulationJobInput{}
	}

	output = &CreateSimulationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSimulationJob API operation for AWS RoboMaker.
//
// Creates a simulation job.
//
// After 90 days, simulation jobs expire and will be deleted. They will no longer
// be accessible.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateSimulationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * IdempotentParameterMismatchException
//   The request uses the same client token as a previous, but non-identical request.
//   Do not reuse a client token with different requests, unless the requests
//   are identical.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateSimulationJob
func (c *RoboMaker) CreateSimulationJob(input *CreateSimulationJobInput) (*CreateSimulationJobOutput, error) {
	req, out := c.CreateSimulationJobRequest(input)
	return out, req.Send()
}

// CreateSimulationJobWithContext is the same as CreateSimulationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSimulationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateSimulationJobWithContext(ctx aws.Context, input *CreateSimulationJobInput, opts ...request.Option) (*CreateSimulationJobOutput, error) {
	req, out := c.CreateSimulationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorldExportJob = "CreateWorldExportJob"

// CreateWorldExportJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorldExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorldExportJob for more information on using the CreateWorldExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorldExportJobRequest method.
//    req, resp := client.CreateWorldExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldExportJob
func (c *RoboMaker) CreateWorldExportJobRequest(input *CreateWorldExportJobInput) (req *request.Request, output *CreateWorldExportJobOutput) {
	op := &request.Operation{
		Name:       opCreateWorldExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/createWorldExportJob",
	}

	if input == nil {
		input = &CreateWorldExportJobInput{}
	}

	output = &CreateWorldExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorldExportJob API operation for AWS RoboMaker.
//
// Creates a world export job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateWorldExportJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * IdempotentParameterMismatchException
//   The request uses the same client token as a previous, but non-identical request.
//   Do not reuse a client token with different requests, unless the requests
//   are identical.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldExportJob
func (c *RoboMaker) CreateWorldExportJob(input *CreateWorldExportJobInput) (*CreateWorldExportJobOutput, error) {
	req, out := c.CreateWorldExportJobRequest(input)
	return out, req.Send()
}

// CreateWorldExportJobWithContext is the same as CreateWorldExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorldExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateWorldExportJobWithContext(ctx aws.Context, input *CreateWorldExportJobInput, opts ...request.Option) (*CreateWorldExportJobOutput, error) {
	req, out := c.CreateWorldExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorldGenerationJob = "CreateWorldGenerationJob"

// CreateWorldGenerationJobRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorldGenerationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorldGenerationJob for more information on using the CreateWorldGenerationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorldGenerationJobRequest method.
//    req, resp := client.CreateWorldGenerationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldGenerationJob
func (c *RoboMaker) CreateWorldGenerationJobRequest(input *CreateWorldGenerationJobInput) (req *request.Request, output *CreateWorldGenerationJobOutput) {
	op := &request.Operation{
		Name:       opCreateWorldGenerationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/createWorldGenerationJob",
	}

	if input == nil {
		input = &CreateWorldGenerationJobInput{}
	}

	output = &CreateWorldGenerationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorldGenerationJob API operation for AWS RoboMaker.
//
// Creates worlds using the specified template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateWorldGenerationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * IdempotentParameterMismatchException
//   The request uses the same client token as a previous, but non-identical request.
//   Do not reuse a client token with different requests, unless the requests
//   are identical.
//
//   * ServiceUnavailableException
//   The request has failed due to a temporary failure of the server.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldGenerationJob
func (c *RoboMaker) CreateWorldGenerationJob(input *CreateWorldGenerationJobInput) (*CreateWorldGenerationJobOutput, error) {
	req, out := c.CreateWorldGenerationJobRequest(input)
	return out, req.Send()
}

// CreateWorldGenerationJobWithContext is the same as CreateWorldGenerationJob with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorldGenerationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateWorldGenerationJobWithContext(ctx aws.Context, input *CreateWorldGenerationJobInput, opts ...request.Option) (*CreateWorldGenerationJobOutput, error) {
	req, out := c.CreateWorldGenerationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorldTemplate = "CreateWorldTemplate"

// CreateWorldTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorldTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorldTemplate for more information on using the CreateWorldTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorldTemplateRequest method.
//    req, resp := client.CreateWorldTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldTemplate
func (c *RoboMaker) CreateWorldTemplateRequest(input *CreateWorldTemplateInput) (req *request.Request, output *CreateWorldTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateWorldTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/createWorldTemplate",
	}

	if input == nil {
		input = &CreateWorldTemplateInput{}
	}

	output = &CreateWorldTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorldTemplate API operation for AWS RoboMaker.
//
// Creates a world template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation CreateWorldTemplate for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/CreateWorldTemplate
func (c *RoboMaker) CreateWorldTemplate(input *CreateWorldTemplateInput) (*CreateWorldTemplateOutput, error) {
	req, out := c.CreateWorldTemplateRequest(input)
	return out, req.Send()
}

// CreateWorldTemplateWithContext is the same as CreateWorldTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorldTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) CreateWorldTemplateWithContext(ctx aws.Context, input *CreateWorldTemplateInput, opts ...request.Option) (*CreateWorldTemplateOutput, error) {
	req, out := c.CreateWorldTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteFleet = "DeleteFleet"

// DeleteFleetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteFleet for more information on using the DeleteFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteFleetRequest method.
//    req, resp := client.DeleteFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteFleet
func (c *RoboMaker) DeleteFleetRequest(input *DeleteFleetInput) (req *request.Request, output *DeleteFleetOutput) {
	op := &request.Operation{
		Name:       opDeleteFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteFleet",
	}

	if input == nil {
		input = &DeleteFleetInput{}
	}

	output = &DeleteFleetOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteFleet API operation for AWS RoboMaker.
//
// Deletes a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DeleteFleet for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteFleet
func (c *RoboMaker) DeleteFleet(input *DeleteFleetInput) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	return out, req.Send()
}

// DeleteFleetWithContext is the same as DeleteFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DeleteFleetWithContext(ctx aws.Context, input *DeleteFleetInput, opts ...request.Option) (*DeleteFleetOutput, error) {
	req, out := c.DeleteFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRobot = "DeleteRobot"

// DeleteRobotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRobot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRobot for more information on using the DeleteRobot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRobotRequest method.
//    req, resp := client.DeleteRobotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobot
func (c *RoboMaker) DeleteRobotRequest(input *DeleteRobotInput) (req *request.Request, output *DeleteRobotOutput) {
	op := &request.Operation{
		Name:       opDeleteRobot,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteRobot",
	}

	if input == nil {
		input = &DeleteRobotInput{}
	}

	output = &DeleteRobotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRobot API operation for AWS RoboMaker.
//
// Deletes a robot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DeleteRobot for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobot
func (c *RoboMaker) DeleteRobot(input *DeleteRobotInput) (*DeleteRobotOutput, error) {
	req, out := c.DeleteRobotRequest(input)
	return out, req.Send()
}

// DeleteRobotWithContext is the same as DeleteRobot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRobot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DeleteRobotWithContext(ctx aws.Context, input *DeleteRobotInput, opts ...request.Option) (*DeleteRobotOutput, error) {
	req, out := c.DeleteRobotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRobotApplication = "DeleteRobotApplication"

// DeleteRobotApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRobotApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRobotApplication for more information on using the DeleteRobotApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRobotApplicationRequest method.
//    req, resp := client.DeleteRobotApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobotApplication
func (c *RoboMaker) DeleteRobotApplicationRequest(input *DeleteRobotApplicationInput) (req *request.Request, output *DeleteRobotApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteRobotApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteRobotApplication",
	}

	if input == nil {
		input = &DeleteRobotApplicationInput{}
	}

	output = &DeleteRobotApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRobotApplication API operation for AWS RoboMaker.
//
// Deletes a robot application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DeleteRobotApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteRobotApplication
func (c *RoboMaker) DeleteRobotApplication(input *DeleteRobotApplicationInput) (*DeleteRobotApplicationOutput, error) {
	req, out := c.DeleteRobotApplicationRequest(input)
	return out, req.Send()
}

// DeleteRobotApplicationWithContext is the same as DeleteRobotApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRobotApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DeleteRobotApplicationWithContext(ctx aws.Context, input *DeleteRobotApplicationInput, opts ...request.Option) (*DeleteRobotApplicationOutput, error) {
	req, out := c.DeleteRobotApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSimulationApplication = "DeleteSimulationApplication"

// DeleteSimulationApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSimulationApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSimulationApplication for more information on using the DeleteSimulationApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSimulationApplicationRequest method.
//    req, resp := client.DeleteSimulationApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteSimulationApplication
func (c *RoboMaker) DeleteSimulationApplicationRequest(input *DeleteSimulationApplicationInput) (req *request.Request, output *DeleteSimulationApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteSimulationApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteSimulationApplication",
	}

	if input == nil {
		input = &DeleteSimulationApplicationInput{}
	}

	output = &DeleteSimulationApplicationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSimulationApplication API operation for AWS RoboMaker.
//
// Deletes a simulation application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DeleteSimulationApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteSimulationApplication
func (c *RoboMaker) DeleteSimulationApplication(input *DeleteSimulationApplicationInput) (*DeleteSimulationApplicationOutput, error) {
	req, out := c.DeleteSimulationApplicationRequest(input)
	return out, req.Send()
}

// DeleteSimulationApplicationWithContext is the same as DeleteSimulationApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSimulationApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DeleteSimulationApplicationWithContext(ctx aws.Context, input *DeleteSimulationApplicationInput, opts ...request.Option) (*DeleteSimulationApplicationOutput, error) {
	req, out := c.DeleteSimulationApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorldTemplate = "DeleteWorldTemplate"

// DeleteWorldTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorldTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorldTemplate for more information on using the DeleteWorldTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorldTemplateRequest method.
//    req, resp := client.DeleteWorldTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteWorldTemplate
func (c *RoboMaker) DeleteWorldTemplateRequest(input *DeleteWorldTemplateInput) (req *request.Request, output *DeleteWorldTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteWorldTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteWorldTemplate",
	}

	if input == nil {
		input = &DeleteWorldTemplateInput{}
	}

	output = &DeleteWorldTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorldTemplate API operation for AWS RoboMaker.
//
// Deletes a world template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DeleteWorldTemplate for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeleteWorldTemplate
func (c *RoboMaker) DeleteWorldTemplate(input *DeleteWorldTemplateInput) (*DeleteWorldTemplateOutput, error) {
	req, out := c.DeleteWorldTemplateRequest(input)
	return out, req.Send()
}

// DeleteWorldTemplateWithContext is the same as DeleteWorldTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorldTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DeleteWorldTemplateWithContext(ctx aws.Context, input *DeleteWorldTemplateInput, opts ...request.Option) (*DeleteWorldTemplateOutput, error) {
	req, out := c.DeleteWorldTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterRobot = "DeregisterRobot"

// DeregisterRobotRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterRobot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterRobot for more information on using the DeregisterRobot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterRobotRequest method.
//    req, resp := client.DeregisterRobotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeregisterRobot
func (c *RoboMaker) DeregisterRobotRequest(input *DeregisterRobotInput) (req *request.Request, output *DeregisterRobotOutput) {
	op := &request.Operation{
		Name:       opDeregisterRobot,
		HTTPMethod: "POST",
		HTTPPath:   "/deregisterRobot",
	}

	if input == nil {
		input = &DeregisterRobotInput{}
	}

	output = &DeregisterRobotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterRobot API operation for AWS RoboMaker.
//
// Deregisters a robot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DeregisterRobot for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DeregisterRobot
func (c *RoboMaker) DeregisterRobot(input *DeregisterRobotInput) (*DeregisterRobotOutput, error) {
	req, out := c.DeregisterRobotRequest(input)
	return out, req.Send()
}

// DeregisterRobotWithContext is the same as DeregisterRobot with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterRobot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DeregisterRobotWithContext(ctx aws.Context, input *DeregisterRobotInput, opts ...request.Option) (*DeregisterRobotOutput, error) {
	req, out := c.DeregisterRobotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeDeploymentJob = "DescribeDeploymentJob"

// DescribeDeploymentJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeDeploymentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeDeploymentJob for more information on using the DescribeDeploymentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeDeploymentJobRequest method.
//    req, resp := client.DescribeDeploymentJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeDeploymentJob
func (c *RoboMaker) DescribeDeploymentJobRequest(input *DescribeDeploymentJobInput) (req *request.Request, output *DescribeDeploymentJobOutput) {
	op := &request.Operation{
		Name:       opDescribeDeploymentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/describeDeploymentJob",
	}

	if input == nil {
		input = &DescribeDeploymentJobInput{}
	}

	output = &DescribeDeploymentJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeDeploymentJob API operation for AWS RoboMaker.
//
// Describes a deployment job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeDeploymentJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeDeploymentJob
func (c *RoboMaker) DescribeDeploymentJob(input *DescribeDeploymentJobInput) (*DescribeDeploymentJobOutput, error) {
	req, out := c.DescribeDeploymentJobRequest(input)
	return out, req.Send()
}

// DescribeDeploymentJobWithContext is the same as DescribeDeploymentJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeDeploymentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeDeploymentJobWithContext(ctx aws.Context, input *DescribeDeploymentJobInput, opts ...request.Option) (*DescribeDeploymentJobOutput, error) {
	req, out := c.DescribeDeploymentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFleet = "DescribeFleet"

// DescribeFleetRequest generates a "aws/request.Request" representing the
// client's request for the DescribeFleet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeFleet for more information on using the DescribeFleet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeFleetRequest method.
//    req, resp := client.DescribeFleetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeFleet
func (c *RoboMaker) DescribeFleetRequest(input *DescribeFleetInput) (req *request.Request, output *DescribeFleetOutput) {
	op := &request.Operation{
		Name:       opDescribeFleet,
		HTTPMethod: "POST",
		HTTPPath:   "/describeFleet",
	}

	if input == nil {
		input = &DescribeFleetInput{}
	}

	output = &DescribeFleetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeFleet API operation for AWS RoboMaker.
//
// Describes a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeFleet for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeFleet
func (c *RoboMaker) DescribeFleet(input *DescribeFleetInput) (*DescribeFleetOutput, error) {
	req, out := c.DescribeFleetRequest(input)
	return out, req.Send()
}

// DescribeFleetWithContext is the same as DescribeFleet with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFleet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeFleetWithContext(ctx aws.Context, input *DescribeFleetInput, opts ...request.Option) (*DescribeFleetOutput, error) {
	req, out := c.DescribeFleetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRobot = "DescribeRobot"

// DescribeRobotRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRobot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRobot for more information on using the DescribeRobot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRobotRequest method.
//    req, resp := client.DescribeRobotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobot
func (c *RoboMaker) DescribeRobotRequest(input *DescribeRobotInput) (req *request.Request, output *DescribeRobotOutput) {
	op := &request.Operation{
		Name:       opDescribeRobot,
		HTTPMethod: "POST",
		HTTPPath:   "/describeRobot",
	}

	if input == nil {
		input = &DescribeRobotInput{}
	}

	output = &DescribeRobotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRobot API operation for AWS RoboMaker.
//
// Describes a robot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeRobot for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobot
func (c *RoboMaker) DescribeRobot(input *DescribeRobotInput) (*DescribeRobotOutput, error) {
	req, out := c.DescribeRobotRequest(input)
	return out, req.Send()
}

// DescribeRobotWithContext is the same as DescribeRobot with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRobot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeRobotWithContext(ctx aws.Context, input *DescribeRobotInput, opts ...request.Option) (*DescribeRobotOutput, error) {
	req, out := c.DescribeRobotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRobotApplication = "DescribeRobotApplication"

// DescribeRobotApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRobotApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRobotApplication for more information on using the DescribeRobotApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRobotApplicationRequest method.
//    req, resp := client.DescribeRobotApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobotApplication
func (c *RoboMaker) DescribeRobotApplicationRequest(input *DescribeRobotApplicationInput) (req *request.Request, output *DescribeRobotApplicationOutput) {
	op := &request.Operation{
		Name:       opDescribeRobotApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/describeRobotApplication",
	}

	if input == nil {
		input = &DescribeRobotApplicationInput{}
	}

	output = &DescribeRobotApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRobotApplication API operation for AWS RoboMaker.
//
// Describes a robot application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeRobotApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeRobotApplication
func (c *RoboMaker) DescribeRobotApplication(input *DescribeRobotApplicationInput) (*DescribeRobotApplicationOutput, error) {
	req, out := c.DescribeRobotApplicationRequest(input)
	return out, req.Send()
}

// DescribeRobotApplicationWithContext is the same as DescribeRobotApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRobotApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeRobotApplicationWithContext(ctx aws.Context, input *DescribeRobotApplicationInput, opts ...request.Option) (*DescribeRobotApplicationOutput, error) {
	req, out := c.DescribeRobotApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSimulationApplication = "DescribeSimulationApplication"

// DescribeSimulationApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSimulationApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSimulationApplication for more information on using the DescribeSimulationApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSimulationApplicationRequest method.
//    req, resp := client.DescribeSimulationApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationApplication
func (c *RoboMaker) DescribeSimulationApplicationRequest(input *DescribeSimulationApplicationInput) (req *request.Request, output *DescribeSimulationApplicationOutput) {
	op := &request.Operation{
		Name:       opDescribeSimulationApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/describeSimulationApplication",
	}

	if input == nil {
		input = &DescribeSimulationApplicationInput{}
	}

	output = &DescribeSimulationApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSimulationApplication API operation for AWS RoboMaker.
//
// Describes a simulation application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeSimulationApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationApplication
func (c *RoboMaker) DescribeSimulationApplication(input *DescribeSimulationApplicationInput) (*DescribeSimulationApplicationOutput, error) {
	req, out := c.DescribeSimulationApplicationRequest(input)
	return out, req.Send()
}

// DescribeSimulationApplicationWithContext is the same as DescribeSimulationApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSimulationApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeSimulationApplicationWithContext(ctx aws.Context, input *DescribeSimulationApplicationInput, opts ...request.Option) (*DescribeSimulationApplicationOutput, error) {
	req, out := c.DescribeSimulationApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSimulationJob = "DescribeSimulationJob"

// DescribeSimulationJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSimulationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSimulationJob for more information on using the DescribeSimulationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSimulationJobRequest method.
//    req, resp := client.DescribeSimulationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJob
func (c *RoboMaker) DescribeSimulationJobRequest(input *DescribeSimulationJobInput) (req *request.Request, output *DescribeSimulationJobOutput) {
	op := &request.Operation{
		Name:       opDescribeSimulationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/describeSimulationJob",
	}

	if input == nil {
		input = &DescribeSimulationJobInput{}
	}

	output = &DescribeSimulationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSimulationJob API operation for AWS RoboMaker.
//
// Describes a simulation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeSimulationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJob
func (c *RoboMaker) DescribeSimulationJob(input *DescribeSimulationJobInput) (*DescribeSimulationJobOutput, error) {
	req, out := c.DescribeSimulationJobRequest(input)
	return out, req.Send()
}

// DescribeSimulationJobWithContext is the same as DescribeSimulationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSimulationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeSimulationJobWithContext(ctx aws.Context, input *DescribeSimulationJobInput, opts ...request.Option) (*DescribeSimulationJobOutput, error) {
	req, out := c.DescribeSimulationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSimulationJobBatch = "DescribeSimulationJobBatch"

// DescribeSimulationJobBatchRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSimulationJobBatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSimulationJobBatch for more information on using the DescribeSimulationJobBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSimulationJobBatchRequest method.
//    req, resp := client.DescribeSimulationJobBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJobBatch
func (c *RoboMaker) DescribeSimulationJobBatchRequest(input *DescribeSimulationJobBatchInput) (req *request.Request, output *DescribeSimulationJobBatchOutput) {
	op := &request.Operation{
		Name:       opDescribeSimulationJobBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/describeSimulationJobBatch",
	}

	if input == nil {
		input = &DescribeSimulationJobBatchInput{}
	}

	output = &DescribeSimulationJobBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSimulationJobBatch API operation for AWS RoboMaker.
//
// Describes a simulation job batch.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeSimulationJobBatch for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeSimulationJobBatch
func (c *RoboMaker) DescribeSimulationJobBatch(input *DescribeSimulationJobBatchInput) (*DescribeSimulationJobBatchOutput, error) {
	req, out := c.DescribeSimulationJobBatchRequest(input)
	return out, req.Send()
}

// DescribeSimulationJobBatchWithContext is the same as DescribeSimulationJobBatch with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSimulationJobBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeSimulationJobBatchWithContext(ctx aws.Context, input *DescribeSimulationJobBatchInput, opts ...request.Option) (*DescribeSimulationJobBatchOutput, error) {
	req, out := c.DescribeSimulationJobBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorld = "DescribeWorld"

// DescribeWorldRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorld operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorld for more information on using the DescribeWorld
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorldRequest method.
//    req, resp := client.DescribeWorldRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorld
func (c *RoboMaker) DescribeWorldRequest(input *DescribeWorldInput) (req *request.Request, output *DescribeWorldOutput) {
	op := &request.Operation{
		Name:       opDescribeWorld,
		HTTPMethod: "POST",
		HTTPPath:   "/describeWorld",
	}

	if input == nil {
		input = &DescribeWorldInput{}
	}

	output = &DescribeWorldOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorld API operation for AWS RoboMaker.
//
// Describes a world.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeWorld for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorld
func (c *RoboMaker) DescribeWorld(input *DescribeWorldInput) (*DescribeWorldOutput, error) {
	req, out := c.DescribeWorldRequest(input)
	return out, req.Send()
}

// DescribeWorldWithContext is the same as DescribeWorld with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorld for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeWorldWithContext(ctx aws.Context, input *DescribeWorldInput, opts ...request.Option) (*DescribeWorldOutput, error) {
	req, out := c.DescribeWorldRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorldExportJob = "DescribeWorldExportJob"

// DescribeWorldExportJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorldExportJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorldExportJob for more information on using the DescribeWorldExportJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorldExportJobRequest method.
//    req, resp := client.DescribeWorldExportJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldExportJob
func (c *RoboMaker) DescribeWorldExportJobRequest(input *DescribeWorldExportJobInput) (req *request.Request, output *DescribeWorldExportJobOutput) {
	op := &request.Operation{
		Name:       opDescribeWorldExportJob,
		HTTPMethod: "POST",
		HTTPPath:   "/describeWorldExportJob",
	}

	if input == nil {
		input = &DescribeWorldExportJobInput{}
	}

	output = &DescribeWorldExportJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorldExportJob API operation for AWS RoboMaker.
//
// Describes a world export job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeWorldExportJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldExportJob
func (c *RoboMaker) DescribeWorldExportJob(input *DescribeWorldExportJobInput) (*DescribeWorldExportJobOutput, error) {
	req, out := c.DescribeWorldExportJobRequest(input)
	return out, req.Send()
}

// DescribeWorldExportJobWithContext is the same as DescribeWorldExportJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorldExportJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeWorldExportJobWithContext(ctx aws.Context, input *DescribeWorldExportJobInput, opts ...request.Option) (*DescribeWorldExportJobOutput, error) {
	req, out := c.DescribeWorldExportJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorldGenerationJob = "DescribeWorldGenerationJob"

// DescribeWorldGenerationJobRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorldGenerationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorldGenerationJob for more information on using the DescribeWorldGenerationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorldGenerationJobRequest method.
//    req, resp := client.DescribeWorldGenerationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldGenerationJob
func (c *RoboMaker) DescribeWorldGenerationJobRequest(input *DescribeWorldGenerationJobInput) (req *request.Request, output *DescribeWorldGenerationJobOutput) {
	op := &request.Operation{
		Name:       opDescribeWorldGenerationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/describeWorldGenerationJob",
	}

	if input == nil {
		input = &DescribeWorldGenerationJobInput{}
	}

	output = &DescribeWorldGenerationJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorldGenerationJob API operation for AWS RoboMaker.
//
// Describes a world generation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeWorldGenerationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldGenerationJob
func (c *RoboMaker) DescribeWorldGenerationJob(input *DescribeWorldGenerationJobInput) (*DescribeWorldGenerationJobOutput, error) {
	req, out := c.DescribeWorldGenerationJobRequest(input)
	return out, req.Send()
}

// DescribeWorldGenerationJobWithContext is the same as DescribeWorldGenerationJob with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorldGenerationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeWorldGenerationJobWithContext(ctx aws.Context, input *DescribeWorldGenerationJobInput, opts ...request.Option) (*DescribeWorldGenerationJobOutput, error) {
	req, out := c.DescribeWorldGenerationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorldTemplate = "DescribeWorldTemplate"

// DescribeWorldTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorldTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorldTemplate for more information on using the DescribeWorldTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorldTemplateRequest method.
//    req, resp := client.DescribeWorldTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldTemplate
func (c *RoboMaker) DescribeWorldTemplateRequest(input *DescribeWorldTemplateInput) (req *request.Request, output *DescribeWorldTemplateOutput) {
	op := &request.Operation{
		Name:       opDescribeWorldTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/describeWorldTemplate",
	}

	if input == nil {
		input = &DescribeWorldTemplateInput{}
	}

	output = &DescribeWorldTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorldTemplate API operation for AWS RoboMaker.
//
// Describes a world template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation DescribeWorldTemplate for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/DescribeWorldTemplate
func (c *RoboMaker) DescribeWorldTemplate(input *DescribeWorldTemplateInput) (*DescribeWorldTemplateOutput, error) {
	req, out := c.DescribeWorldTemplateRequest(input)
	return out, req.Send()
}

// DescribeWorldTemplateWithContext is the same as DescribeWorldTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorldTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) DescribeWorldTemplateWithContext(ctx aws.Context, input *DescribeWorldTemplateInput, opts ...request.Option) (*DescribeWorldTemplateOutput, error) {
	req, out := c.DescribeWorldTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorldTemplateBody = "GetWorldTemplateBody"

// GetWorldTemplateBodyRequest generates a "aws/request.Request" representing the
// client's request for the GetWorldTemplateBody operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorldTemplateBody for more information on using the GetWorldTemplateBody
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWorldTemplateBodyRequest method.
//    req, resp := client.GetWorldTemplateBodyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/GetWorldTemplateBody
func (c *RoboMaker) GetWorldTemplateBodyRequest(input *GetWorldTemplateBodyInput) (req *request.Request, output *GetWorldTemplateBodyOutput) {
	op := &request.Operation{
		Name:       opGetWorldTemplateBody,
		HTTPMethod: "POST",
		HTTPPath:   "/getWorldTemplateBody",
	}

	if input == nil {
		input = &GetWorldTemplateBodyInput{}
	}

	output = &GetWorldTemplateBodyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorldTemplateBody API operation for AWS RoboMaker.
//
// Gets the world template body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation GetWorldTemplateBody for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/GetWorldTemplateBody
func (c *RoboMaker) GetWorldTemplateBody(input *GetWorldTemplateBodyInput) (*GetWorldTemplateBodyOutput, error) {
	req, out := c.GetWorldTemplateBodyRequest(input)
	return out, req.Send()
}

// GetWorldTemplateBodyWithContext is the same as GetWorldTemplateBody with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorldTemplateBody for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) GetWorldTemplateBodyWithContext(ctx aws.Context, input *GetWorldTemplateBodyInput, opts ...request.Option) (*GetWorldTemplateBodyOutput, error) {
	req, out := c.GetWorldTemplateBodyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDeploymentJobs = "ListDeploymentJobs"

// ListDeploymentJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListDeploymentJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDeploymentJobs for more information on using the ListDeploymentJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDeploymentJobsRequest method.
//    req, resp := client.ListDeploymentJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs
func (c *RoboMaker) ListDeploymentJobsRequest(input *ListDeploymentJobsInput) (req *request.Request, output *ListDeploymentJobsOutput) {
	op := &request.Operation{
		Name:       opListDeploymentJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/listDeploymentJobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDeploymentJobsInput{}
	}

	output = &ListDeploymentJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDeploymentJobs API operation for AWS RoboMaker.
//
// Returns a list of deployment jobs for a fleet. You can optionally provide
// filters to retrieve specific deployment jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListDeploymentJobs for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListDeploymentJobs
func (c *RoboMaker) ListDeploymentJobs(input *ListDeploymentJobsInput) (*ListDeploymentJobsOutput, error) {
	req, out := c.ListDeploymentJobsRequest(input)
	return out, req.Send()
}

// ListDeploymentJobsWithContext is the same as ListDeploymentJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListDeploymentJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListDeploymentJobsWithContext(ctx aws.Context, input *ListDeploymentJobsInput, opts ...request.Option) (*ListDeploymentJobsOutput, error) {
	req, out := c.ListDeploymentJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDeploymentJobsPages iterates over the pages of a ListDeploymentJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDeploymentJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListDeploymentJobs operation.
//    pageNum := 0
//    err := client.ListDeploymentJobsPages(params,
//        func(page *robomaker.ListDeploymentJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListDeploymentJobsPages(input *ListDeploymentJobsInput, fn func(*ListDeploymentJobsOutput, bool) bool) error {
	return c.ListDeploymentJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDeploymentJobsPagesWithContext same as ListDeploymentJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListDeploymentJobsPagesWithContext(ctx aws.Context, input *ListDeploymentJobsInput, fn func(*ListDeploymentJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDeploymentJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDeploymentJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDeploymentJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListFleets = "ListFleets"

// ListFleetsRequest generates a "aws/request.Request" representing the
// client's request for the ListFleets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListFleets for more information on using the ListFleets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListFleetsRequest method.
//    req, resp := client.ListFleetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets
func (c *RoboMaker) ListFleetsRequest(input *ListFleetsInput) (req *request.Request, output *ListFleetsOutput) {
	op := &request.Operation{
		Name:       opListFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/listFleets",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFleetsInput{}
	}

	output = &ListFleetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListFleets API operation for AWS RoboMaker.
//
// Returns a list of fleets. You can optionally provide filters to retrieve
// specific fleets.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListFleets for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListFleets
func (c *RoboMaker) ListFleets(input *ListFleetsInput) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	return out, req.Send()
}

// ListFleetsWithContext is the same as ListFleets with the addition of
// the ability to pass a context and additional request options.
//
// See ListFleets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListFleetsWithContext(ctx aws.Context, input *ListFleetsInput, opts ...request.Option) (*ListFleetsOutput, error) {
	req, out := c.ListFleetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListFleetsPages iterates over the pages of a ListFleets operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListFleets method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListFleets operation.
//    pageNum := 0
//    err := client.ListFleetsPages(params,
//        func(page *robomaker.ListFleetsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListFleetsPages(input *ListFleetsInput, fn func(*ListFleetsOutput, bool) bool) error {
	return c.ListFleetsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListFleetsPagesWithContext same as ListFleetsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListFleetsPagesWithContext(ctx aws.Context, input *ListFleetsInput, fn func(*ListFleetsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListFleetsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListFleetsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListFleetsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRobotApplications = "ListRobotApplications"

// ListRobotApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListRobotApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRobotApplications for more information on using the ListRobotApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRobotApplicationsRequest method.
//    req, resp := client.ListRobotApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications
func (c *RoboMaker) ListRobotApplicationsRequest(input *ListRobotApplicationsInput) (req *request.Request, output *ListRobotApplicationsOutput) {
	op := &request.Operation{
		Name:       opListRobotApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/listRobotApplications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRobotApplicationsInput{}
	}

	output = &ListRobotApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRobotApplications API operation for AWS RoboMaker.
//
// Returns a list of robot application. You can optionally provide filters to
// retrieve specific robot applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListRobotApplications for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobotApplications
func (c *RoboMaker) ListRobotApplications(input *ListRobotApplicationsInput) (*ListRobotApplicationsOutput, error) {
	req, out := c.ListRobotApplicationsRequest(input)
	return out, req.Send()
}

// ListRobotApplicationsWithContext is the same as ListRobotApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListRobotApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListRobotApplicationsWithContext(ctx aws.Context, input *ListRobotApplicationsInput, opts ...request.Option) (*ListRobotApplicationsOutput, error) {
	req, out := c.ListRobotApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRobotApplicationsPages iterates over the pages of a ListRobotApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRobotApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRobotApplications operation.
//    pageNum := 0
//    err := client.ListRobotApplicationsPages(params,
//        func(page *robomaker.ListRobotApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListRobotApplicationsPages(input *ListRobotApplicationsInput, fn func(*ListRobotApplicationsOutput, bool) bool) error {
	return c.ListRobotApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRobotApplicationsPagesWithContext same as ListRobotApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListRobotApplicationsPagesWithContext(ctx aws.Context, input *ListRobotApplicationsInput, fn func(*ListRobotApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRobotApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRobotApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRobotApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRobots = "ListRobots"

// ListRobotsRequest generates a "aws/request.Request" representing the
// client's request for the ListRobots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRobots for more information on using the ListRobots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRobotsRequest method.
//    req, resp := client.ListRobotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots
func (c *RoboMaker) ListRobotsRequest(input *ListRobotsInput) (req *request.Request, output *ListRobotsOutput) {
	op := &request.Operation{
		Name:       opListRobots,
		HTTPMethod: "POST",
		HTTPPath:   "/listRobots",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRobotsInput{}
	}

	output = &ListRobotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRobots API operation for AWS RoboMaker.
//
// Returns a list of robots. You can optionally provide filters to retrieve
// specific robots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListRobots for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListRobots
func (c *RoboMaker) ListRobots(input *ListRobotsInput) (*ListRobotsOutput, error) {
	req, out := c.ListRobotsRequest(input)
	return out, req.Send()
}

// ListRobotsWithContext is the same as ListRobots with the addition of
// the ability to pass a context and additional request options.
//
// See ListRobots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListRobotsWithContext(ctx aws.Context, input *ListRobotsInput, opts ...request.Option) (*ListRobotsOutput, error) {
	req, out := c.ListRobotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRobotsPages iterates over the pages of a ListRobots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRobots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListRobots operation.
//    pageNum := 0
//    err := client.ListRobotsPages(params,
//        func(page *robomaker.ListRobotsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListRobotsPages(input *ListRobotsInput, fn func(*ListRobotsOutput, bool) bool) error {
	return c.ListRobotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRobotsPagesWithContext same as ListRobotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListRobotsPagesWithContext(ctx aws.Context, input *ListRobotsInput, fn func(*ListRobotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRobotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRobotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRobotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSimulationApplications = "ListSimulationApplications"

// ListSimulationApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSimulationApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSimulationApplications for more information on using the ListSimulationApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSimulationApplicationsRequest method.
//    req, resp := client.ListSimulationApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications
func (c *RoboMaker) ListSimulationApplicationsRequest(input *ListSimulationApplicationsInput) (req *request.Request, output *ListSimulationApplicationsOutput) {
	op := &request.Operation{
		Name:       opListSimulationApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/listSimulationApplications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSimulationApplicationsInput{}
	}

	output = &ListSimulationApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSimulationApplications API operation for AWS RoboMaker.
//
// Returns a list of simulation applications. You can optionally provide filters
// to retrieve specific simulation applications.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListSimulationApplications for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationApplications
func (c *RoboMaker) ListSimulationApplications(input *ListSimulationApplicationsInput) (*ListSimulationApplicationsOutput, error) {
	req, out := c.ListSimulationApplicationsRequest(input)
	return out, req.Send()
}

// ListSimulationApplicationsWithContext is the same as ListSimulationApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListSimulationApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListSimulationApplicationsWithContext(ctx aws.Context, input *ListSimulationApplicationsInput, opts ...request.Option) (*ListSimulationApplicationsOutput, error) {
	req, out := c.ListSimulationApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSimulationApplicationsPages iterates over the pages of a ListSimulationApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSimulationApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSimulationApplications operation.
//    pageNum := 0
//    err := client.ListSimulationApplicationsPages(params,
//        func(page *robomaker.ListSimulationApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListSimulationApplicationsPages(input *ListSimulationApplicationsInput, fn func(*ListSimulationApplicationsOutput, bool) bool) error {
	return c.ListSimulationApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSimulationApplicationsPagesWithContext same as ListSimulationApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListSimulationApplicationsPagesWithContext(ctx aws.Context, input *ListSimulationApplicationsInput, fn func(*ListSimulationApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSimulationApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSimulationApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSimulationApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSimulationJobBatches = "ListSimulationJobBatches"

// ListSimulationJobBatchesRequest generates a "aws/request.Request" representing the
// client's request for the ListSimulationJobBatches operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSimulationJobBatches for more information on using the ListSimulationJobBatches
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSimulationJobBatchesRequest method.
//    req, resp := client.ListSimulationJobBatchesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches
func (c *RoboMaker) ListSimulationJobBatchesRequest(input *ListSimulationJobBatchesInput) (req *request.Request, output *ListSimulationJobBatchesOutput) {
	op := &request.Operation{
		Name:       opListSimulationJobBatches,
		HTTPMethod: "POST",
		HTTPPath:   "/listSimulationJobBatches",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSimulationJobBatchesInput{}
	}

	output = &ListSimulationJobBatchesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSimulationJobBatches API operation for AWS RoboMaker.
//
// Returns a list simulation job batches. You can optionally provide filters
// to retrieve specific simulation batch jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListSimulationJobBatches for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobBatches
func (c *RoboMaker) ListSimulationJobBatches(input *ListSimulationJobBatchesInput) (*ListSimulationJobBatchesOutput, error) {
	req, out := c.ListSimulationJobBatchesRequest(input)
	return out, req.Send()
}

// ListSimulationJobBatchesWithContext is the same as ListSimulationJobBatches with the addition of
// the ability to pass a context and additional request options.
//
// See ListSimulationJobBatches for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListSimulationJobBatchesWithContext(ctx aws.Context, input *ListSimulationJobBatchesInput, opts ...request.Option) (*ListSimulationJobBatchesOutput, error) {
	req, out := c.ListSimulationJobBatchesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSimulationJobBatchesPages iterates over the pages of a ListSimulationJobBatches operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSimulationJobBatches method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSimulationJobBatches operation.
//    pageNum := 0
//    err := client.ListSimulationJobBatchesPages(params,
//        func(page *robomaker.ListSimulationJobBatchesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListSimulationJobBatchesPages(input *ListSimulationJobBatchesInput, fn func(*ListSimulationJobBatchesOutput, bool) bool) error {
	return c.ListSimulationJobBatchesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSimulationJobBatchesPagesWithContext same as ListSimulationJobBatchesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListSimulationJobBatchesPagesWithContext(ctx aws.Context, input *ListSimulationJobBatchesInput, fn func(*ListSimulationJobBatchesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSimulationJobBatchesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSimulationJobBatchesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSimulationJobBatchesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSimulationJobs = "ListSimulationJobs"

// ListSimulationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListSimulationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSimulationJobs for more information on using the ListSimulationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSimulationJobsRequest method.
//    req, resp := client.ListSimulationJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs
func (c *RoboMaker) ListSimulationJobsRequest(input *ListSimulationJobsInput) (req *request.Request, output *ListSimulationJobsOutput) {
	op := &request.Operation{
		Name:       opListSimulationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/listSimulationJobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSimulationJobsInput{}
	}

	output = &ListSimulationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSimulationJobs API operation for AWS RoboMaker.
//
// Returns a list of simulation jobs. You can optionally provide filters to
// retrieve specific simulation jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListSimulationJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListSimulationJobs
func (c *RoboMaker) ListSimulationJobs(input *ListSimulationJobsInput) (*ListSimulationJobsOutput, error) {
	req, out := c.ListSimulationJobsRequest(input)
	return out, req.Send()
}

// ListSimulationJobsWithContext is the same as ListSimulationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListSimulationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListSimulationJobsWithContext(ctx aws.Context, input *ListSimulationJobsInput, opts ...request.Option) (*ListSimulationJobsOutput, error) {
	req, out := c.ListSimulationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSimulationJobsPages iterates over the pages of a ListSimulationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSimulationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSimulationJobs operation.
//    pageNum := 0
//    err := client.ListSimulationJobsPages(params,
//        func(page *robomaker.ListSimulationJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListSimulationJobsPages(input *ListSimulationJobsInput, fn func(*ListSimulationJobsOutput, bool) bool) error {
	return c.ListSimulationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSimulationJobsPagesWithContext same as ListSimulationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListSimulationJobsPagesWithContext(ctx aws.Context, input *ListSimulationJobsInput, fn func(*ListSimulationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSimulationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSimulationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSimulationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListTagsForResource
func (c *RoboMaker) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS RoboMaker.
//
// Lists all tags on a AWS RoboMaker resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListTagsForResource
func (c *RoboMaker) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWorldExportJobs = "ListWorldExportJobs"

// ListWorldExportJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorldExportJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorldExportJobs for more information on using the ListWorldExportJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorldExportJobsRequest method.
//    req, resp := client.ListWorldExportJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs
func (c *RoboMaker) ListWorldExportJobsRequest(input *ListWorldExportJobsInput) (req *request.Request, output *ListWorldExportJobsOutput) {
	op := &request.Operation{
		Name:       opListWorldExportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/listWorldExportJobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorldExportJobsInput{}
	}

	output = &ListWorldExportJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorldExportJobs API operation for AWS RoboMaker.
//
// Lists world export jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListWorldExportJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldExportJobs
func (c *RoboMaker) ListWorldExportJobs(input *ListWorldExportJobsInput) (*ListWorldExportJobsOutput, error) {
	req, out := c.ListWorldExportJobsRequest(input)
	return out, req.Send()
}

// ListWorldExportJobsWithContext is the same as ListWorldExportJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorldExportJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListWorldExportJobsWithContext(ctx aws.Context, input *ListWorldExportJobsInput, opts ...request.Option) (*ListWorldExportJobsOutput, error) {
	req, out := c.ListWorldExportJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorldExportJobsPages iterates over the pages of a ListWorldExportJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorldExportJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorldExportJobs operation.
//    pageNum := 0
//    err := client.ListWorldExportJobsPages(params,
//        func(page *robomaker.ListWorldExportJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListWorldExportJobsPages(input *ListWorldExportJobsInput, fn func(*ListWorldExportJobsOutput, bool) bool) error {
	return c.ListWorldExportJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorldExportJobsPagesWithContext same as ListWorldExportJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListWorldExportJobsPagesWithContext(ctx aws.Context, input *ListWorldExportJobsInput, fn func(*ListWorldExportJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorldExportJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorldExportJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorldExportJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorldGenerationJobs = "ListWorldGenerationJobs"

// ListWorldGenerationJobsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorldGenerationJobs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorldGenerationJobs for more information on using the ListWorldGenerationJobs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorldGenerationJobsRequest method.
//    req, resp := client.ListWorldGenerationJobsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs
func (c *RoboMaker) ListWorldGenerationJobsRequest(input *ListWorldGenerationJobsInput) (req *request.Request, output *ListWorldGenerationJobsOutput) {
	op := &request.Operation{
		Name:       opListWorldGenerationJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/listWorldGenerationJobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorldGenerationJobsInput{}
	}

	output = &ListWorldGenerationJobsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorldGenerationJobs API operation for AWS RoboMaker.
//
// Lists world generator jobs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListWorldGenerationJobs for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldGenerationJobs
func (c *RoboMaker) ListWorldGenerationJobs(input *ListWorldGenerationJobsInput) (*ListWorldGenerationJobsOutput, error) {
	req, out := c.ListWorldGenerationJobsRequest(input)
	return out, req.Send()
}

// ListWorldGenerationJobsWithContext is the same as ListWorldGenerationJobs with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorldGenerationJobs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListWorldGenerationJobsWithContext(ctx aws.Context, input *ListWorldGenerationJobsInput, opts ...request.Option) (*ListWorldGenerationJobsOutput, error) {
	req, out := c.ListWorldGenerationJobsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorldGenerationJobsPages iterates over the pages of a ListWorldGenerationJobs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorldGenerationJobs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorldGenerationJobs operation.
//    pageNum := 0
//    err := client.ListWorldGenerationJobsPages(params,
//        func(page *robomaker.ListWorldGenerationJobsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListWorldGenerationJobsPages(input *ListWorldGenerationJobsInput, fn func(*ListWorldGenerationJobsOutput, bool) bool) error {
	return c.ListWorldGenerationJobsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorldGenerationJobsPagesWithContext same as ListWorldGenerationJobsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListWorldGenerationJobsPagesWithContext(ctx aws.Context, input *ListWorldGenerationJobsInput, fn func(*ListWorldGenerationJobsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorldGenerationJobsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorldGenerationJobsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorldGenerationJobsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorldTemplates = "ListWorldTemplates"

// ListWorldTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListWorldTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorldTemplates for more information on using the ListWorldTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorldTemplatesRequest method.
//    req, resp := client.ListWorldTemplatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates
func (c *RoboMaker) ListWorldTemplatesRequest(input *ListWorldTemplatesInput) (req *request.Request, output *ListWorldTemplatesOutput) {
	op := &request.Operation{
		Name:       opListWorldTemplates,
		HTTPMethod: "POST",
		HTTPPath:   "/listWorldTemplates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorldTemplatesInput{}
	}

	output = &ListWorldTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorldTemplates API operation for AWS RoboMaker.
//
// Lists world templates.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListWorldTemplates for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorldTemplates
func (c *RoboMaker) ListWorldTemplates(input *ListWorldTemplatesInput) (*ListWorldTemplatesOutput, error) {
	req, out := c.ListWorldTemplatesRequest(input)
	return out, req.Send()
}

// ListWorldTemplatesWithContext is the same as ListWorldTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorldTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListWorldTemplatesWithContext(ctx aws.Context, input *ListWorldTemplatesInput, opts ...request.Option) (*ListWorldTemplatesOutput, error) {
	req, out := c.ListWorldTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorldTemplatesPages iterates over the pages of a ListWorldTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorldTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorldTemplates operation.
//    pageNum := 0
//    err := client.ListWorldTemplatesPages(params,
//        func(page *robomaker.ListWorldTemplatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListWorldTemplatesPages(input *ListWorldTemplatesInput, fn func(*ListWorldTemplatesOutput, bool) bool) error {
	return c.ListWorldTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorldTemplatesPagesWithContext same as ListWorldTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListWorldTemplatesPagesWithContext(ctx aws.Context, input *ListWorldTemplatesInput, fn func(*ListWorldTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorldTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorldTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorldTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorlds = "ListWorlds"

// ListWorldsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorlds operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorlds for more information on using the ListWorlds
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorldsRequest method.
//    req, resp := client.ListWorldsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds
func (c *RoboMaker) ListWorldsRequest(input *ListWorldsInput) (req *request.Request, output *ListWorldsOutput) {
	op := &request.Operation{
		Name:       opListWorlds,
		HTTPMethod: "POST",
		HTTPPath:   "/listWorlds",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorldsInput{}
	}

	output = &ListWorldsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorlds API operation for AWS RoboMaker.
//
// Lists worlds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation ListWorlds for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/ListWorlds
func (c *RoboMaker) ListWorlds(input *ListWorldsInput) (*ListWorldsOutput, error) {
	req, out := c.ListWorldsRequest(input)
	return out, req.Send()
}

// ListWorldsWithContext is the same as ListWorlds with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorlds for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListWorldsWithContext(ctx aws.Context, input *ListWorldsInput, opts ...request.Option) (*ListWorldsOutput, error) {
	req, out := c.ListWorldsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorldsPages iterates over the pages of a ListWorlds operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorlds method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorlds operation.
//    pageNum := 0
//    err := client.ListWorldsPages(params,
//        func(page *robomaker.ListWorldsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *RoboMaker) ListWorldsPages(input *ListWorldsInput, fn func(*ListWorldsOutput, bool) bool) error {
	return c.ListWorldsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorldsPagesWithContext same as ListWorldsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) ListWorldsPagesWithContext(ctx aws.Context, input *ListWorldsInput, fn func(*ListWorldsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorldsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorldsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorldsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opRegisterRobot = "RegisterRobot"

// RegisterRobotRequest generates a "aws/request.Request" representing the
// client's request for the RegisterRobot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterRobot for more information on using the RegisterRobot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterRobotRequest method.
//    req, resp := client.RegisterRobotRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RegisterRobot
func (c *RoboMaker) RegisterRobotRequest(input *RegisterRobotInput) (req *request.Request, output *RegisterRobotOutput) {
	op := &request.Operation{
		Name:       opRegisterRobot,
		HTTPMethod: "POST",
		HTTPPath:   "/registerRobot",
	}

	if input == nil {
		input = &RegisterRobotInput{}
	}

	output = &RegisterRobotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterRobot API operation for AWS RoboMaker.
//
// Registers a robot with a fleet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation RegisterRobot for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RegisterRobot
func (c *RoboMaker) RegisterRobot(input *RegisterRobotInput) (*RegisterRobotOutput, error) {
	req, out := c.RegisterRobotRequest(input)
	return out, req.Send()
}

// RegisterRobotWithContext is the same as RegisterRobot with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterRobot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) RegisterRobotWithContext(ctx aws.Context, input *RegisterRobotInput, opts ...request.Option) (*RegisterRobotOutput, error) {
	req, out := c.RegisterRobotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestartSimulationJob = "RestartSimulationJob"

// RestartSimulationJobRequest generates a "aws/request.Request" representing the
// client's request for the RestartSimulationJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestartSimulationJob for more information on using the RestartSimulationJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestartSimulationJobRequest method.
//    req, resp := client.RestartSimulationJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RestartSimulationJob
func (c *RoboMaker) RestartSimulationJobRequest(input *RestartSimulationJobInput) (req *request.Request, output *RestartSimulationJobOutput) {
	op := &request.Operation{
		Name:       opRestartSimulationJob,
		HTTPMethod: "POST",
		HTTPPath:   "/restartSimulationJob",
	}

	if input == nil {
		input = &RestartSimulationJobInput{}
	}

	output = &RestartSimulationJobOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RestartSimulationJob API operation for AWS RoboMaker.
//
// Restarts a running simulation job.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation RestartSimulationJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/RestartSimulationJob
func (c *RoboMaker) RestartSimulationJob(input *RestartSimulationJobInput) (*RestartSimulationJobOutput, error) {
	req, out := c.RestartSimulationJobRequest(input)
	return out, req.Send()
}

// RestartSimulationJobWithContext is the same as RestartSimulationJob with the addition of
// the ability to pass a context and additional request options.
//
// See RestartSimulationJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) RestartSimulationJobWithContext(ctx aws.Context, input *RestartSimulationJobInput, opts ...request.Option) (*RestartSimulationJobOutput, error) {
	req, out := c.RestartSimulationJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartSimulationJobBatch = "StartSimulationJobBatch"

// StartSimulationJobBatchRequest generates a "aws/request.Request" representing the
// client's request for the StartSimulationJobBatch operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartSimulationJobBatch for more information on using the StartSimulationJobBatch
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartSimulationJobBatchRequest method.
//    req, resp := client.StartSimulationJobBatchRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/StartSimulationJobBatch
func (c *RoboMaker) StartSimulationJobBatchRequest(input *StartSimulationJobBatchInput) (req *request.Request, output *StartSimulationJobBatchOutput) {
	op := &request.Operation{
		Name:       opStartSimulationJobBatch,
		HTTPMethod: "POST",
		HTTPPath:   "/startSimulationJobBatch",
	}

	if input == nil {
		input = &StartSimulationJobBatchInput{}
	}

	output = &StartSimulationJobBatchOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartSimulationJobBatch API operation for AWS RoboMaker.
//
// Starts a new simulation job batch. The batch is defined using one or more
// SimulationJobRequest objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation StartSimulationJobBatch for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * IdempotentParameterMismatchException
//   The request uses the same client token as a previous, but non-identical request.
//   Do not reuse a client token with different requests, unless the requests
//   are identical.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/StartSimulationJobBatch
func (c *RoboMaker) StartSimulationJobBatch(input *StartSimulationJobBatchInput) (*StartSimulationJobBatchOutput, error) {
	req, out := c.StartSimulationJobBatchRequest(input)
	return out, req.Send()
}

// StartSimulationJobBatchWithContext is the same as StartSimulationJobBatch with the addition of
// the ability to pass a context and additional request options.
//
// See StartSimulationJobBatch for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) StartSimulationJobBatchWithContext(ctx aws.Context, input *StartSimulationJobBatchInput, opts ...request.Option) (*StartSimulationJobBatchOutput, error) {
	req, out := c.StartSimulationJobBatchRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSyncDeploymentJob = "SyncDeploymentJob"

// SyncDeploymentJobRequest generates a "aws/request.Request" representing the
// client's request for the SyncDeploymentJob operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SyncDeploymentJob for more information on using the SyncDeploymentJob
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SyncDeploymentJobRequest method.
//    req, resp := client.SyncDeploymentJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SyncDeploymentJob
func (c *RoboMaker) SyncDeploymentJobRequest(input *SyncDeploymentJobInput) (req *request.Request, output *SyncDeploymentJobOutput) {
	op := &request.Operation{
		Name:       opSyncDeploymentJob,
		HTTPMethod: "POST",
		HTTPPath:   "/syncDeploymentJob",
	}

	if input == nil {
		input = &SyncDeploymentJobInput{}
	}

	output = &SyncDeploymentJobOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SyncDeploymentJob API operation for AWS RoboMaker.
//
// Syncrhonizes robots in a fleet to the latest deployment. This is helpful
// if robots were added after a deployment.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation SyncDeploymentJob for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ConcurrentDeploymentException
//   The failure percentage threshold percentage was met.
//
//   * IdempotentParameterMismatchException
//   The request uses the same client token as a previous, but non-identical request.
//   Do not reuse a client token with different requests, unless the requests
//   are identical.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/SyncDeploymentJob
func (c *RoboMaker) SyncDeploymentJob(input *SyncDeploymentJobInput) (*SyncDeploymentJobOutput, error) {
	req, out := c.SyncDeploymentJobRequest(input)
	return out, req.Send()
}

// SyncDeploymentJobWithContext is the same as SyncDeploymentJob with the addition of
// the ability to pass a context and additional request options.
//
// See SyncDeploymentJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) SyncDeploymentJobWithContext(ctx aws.Context, input *SyncDeploymentJobInput, opts ...request.Option) (*SyncDeploymentJobOutput, error) {
	req, out := c.SyncDeploymentJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/TagResource
func (c *RoboMaker) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS RoboMaker.
//
// Adds or edits tags for a AWS RoboMaker resource.
//
// Each tag consists of a tag key and a tag value. Tag keys and tag values are
// both required, but tag values can be empty strings.
//
// For information about the rules that apply to tag keys and tag values, see
// User-Defined Tag Restrictions (https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html)
// in the AWS Billing and Cost Management User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/TagResource
func (c *RoboMaker) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UntagResource
func (c *RoboMaker) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS RoboMaker.
//
// Removes the specified tags from the specified AWS RoboMaker resource.
//
// To remove a tag, specify the tag key. To change the tag value of an existing
// tag key, use TagResource (https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UntagResource
func (c *RoboMaker) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRobotApplication = "UpdateRobotApplication"

// UpdateRobotApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRobotApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRobotApplication for more information on using the UpdateRobotApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRobotApplicationRequest method.
//    req, resp := client.UpdateRobotApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateRobotApplication
func (c *RoboMaker) UpdateRobotApplicationRequest(input *UpdateRobotApplicationInput) (req *request.Request, output *UpdateRobotApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateRobotApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/updateRobotApplication",
	}

	if input == nil {
		input = &UpdateRobotApplicationInput{}
	}

	output = &UpdateRobotApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRobotApplication API operation for AWS RoboMaker.
//
// Updates a robot application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation UpdateRobotApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateRobotApplication
func (c *RoboMaker) UpdateRobotApplication(input *UpdateRobotApplicationInput) (*UpdateRobotApplicationOutput, error) {
	req, out := c.UpdateRobotApplicationRequest(input)
	return out, req.Send()
}

// UpdateRobotApplicationWithContext is the same as UpdateRobotApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRobotApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) UpdateRobotApplicationWithContext(ctx aws.Context, input *UpdateRobotApplicationInput, opts ...request.Option) (*UpdateRobotApplicationOutput, error) {
	req, out := c.UpdateRobotApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSimulationApplication = "UpdateSimulationApplication"

// UpdateSimulationApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSimulationApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSimulationApplication for more information on using the UpdateSimulationApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSimulationApplicationRequest method.
//    req, resp := client.UpdateSimulationApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateSimulationApplication
func (c *RoboMaker) UpdateSimulationApplicationRequest(input *UpdateSimulationApplicationInput) (req *request.Request, output *UpdateSimulationApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateSimulationApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/updateSimulationApplication",
	}

	if input == nil {
		input = &UpdateSimulationApplicationInput{}
	}

	output = &UpdateSimulationApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSimulationApplication API operation for AWS RoboMaker.
//
// Updates a simulation application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation UpdateSimulationApplication for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * LimitExceededException
//   The requested resource exceeds the maximum number allowed, or the number
//   of concurrent stream requests exceeds the maximum number allowed.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateSimulationApplication
func (c *RoboMaker) UpdateSimulationApplication(input *UpdateSimulationApplicationInput) (*UpdateSimulationApplicationOutput, error) {
	req, out := c.UpdateSimulationApplicationRequest(input)
	return out, req.Send()
}

// UpdateSimulationApplicationWithContext is the same as UpdateSimulationApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSimulationApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) UpdateSimulationApplicationWithContext(ctx aws.Context, input *UpdateSimulationApplicationInput, opts ...request.Option) (*UpdateSimulationApplicationOutput, error) {
	req, out := c.UpdateSimulationApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorldTemplate = "UpdateWorldTemplate"

// UpdateWorldTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorldTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorldTemplate for more information on using the UpdateWorldTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorldTemplateRequest method.
//    req, resp := client.UpdateWorldTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateWorldTemplate
func (c *RoboMaker) UpdateWorldTemplateRequest(input *UpdateWorldTemplateInput) (req *request.Request, output *UpdateWorldTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateWorldTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/updateWorldTemplate",
	}

	if input == nil {
		input = &UpdateWorldTemplateInput{}
	}

	output = &UpdateWorldTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorldTemplate API operation for AWS RoboMaker.
//
// Updates a world template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS RoboMaker's
// API operation UpdateWorldTemplate for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterException
//   A parameter specified in a request is not valid, is unsupported, or cannot
//   be used. The returned message provides an explanation of the error value.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ThrottlingException
//   AWS RoboMaker is temporarily unable to process the request. Try your call
//   again.
//
//   * InternalServerException
//   AWS RoboMaker experienced a service issue. Try your call again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/robomaker-2018-06-29/UpdateWorldTemplate
func (c *RoboMaker) UpdateWorldTemplate(input *UpdateWorldTemplateInput) (*UpdateWorldTemplateOutput, error) {
	req, out := c.UpdateWorldTemplateRequest(input)
	return out, req.Send()
}

// UpdateWorldTemplateWithContext is the same as UpdateWorldTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorldTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RoboMaker) UpdateWorldTemplateWithContext(ctx aws.Context, input *UpdateWorldTemplateInput, opts ...request.Option) (*UpdateWorldTemplateOutput, error) {
	req, out := c.UpdateWorldTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BatchDeleteWorldsInput struct {
	_ struct{} `type:"structure"`

	// A list of Amazon Resource Names (arns) that correspond to worlds to delete.
	//
	// Worlds is a required field
	Worlds []*string `locationName:"worlds" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDeleteWorldsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteWorldsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDeleteWorldsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDeleteWorldsInput"}
	if s.Worlds == nil {
		invalidParams.Add(request.NewErrParamRequired("Worlds"))
	}
	if s.Worlds != nil && len(s.Worlds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Worlds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorlds sets the Worlds field's value.
func (s *BatchDeleteWorldsInput) SetWorlds(v []*string) *BatchDeleteWorldsInput {
	s.Worlds = v
	return s
}

type BatchDeleteWorldsOutput struct {
	_ struct{} `type:"structure"`

	// A list of unprocessed worlds associated with the call. These worlds were
	// not deleted.
	UnprocessedWorlds []*string `locationName:"unprocessedWorlds" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchDeleteWorldsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDeleteWorldsOutput) GoString() string {
	return s.String()
}

// SetUnprocessedWorlds sets the UnprocessedWorlds field's value.
func (s *BatchDeleteWorldsOutput) SetUnprocessedWorlds(v []*string) *BatchDeleteWorldsOutput {
	s.UnprocessedWorlds = v
	return s
}

type BatchDescribeSimulationJobInput struct {
	_ struct{} `type:"structure"`

	// A list of Amazon Resource Names (ARNs) of simulation jobs to describe.
	//
	// Jobs is a required field
	Jobs []*string `locationName:"jobs" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s BatchDescribeSimulationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDescribeSimulationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchDescribeSimulationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchDescribeSimulationJobInput"}
	if s.Jobs == nil {
		invalidParams.Add(request.NewErrParamRequired("Jobs"))
	}
	if s.Jobs != nil && len(s.Jobs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Jobs", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobs sets the Jobs field's value.
func (s *BatchDescribeSimulationJobInput) SetJobs(v []*string) *BatchDescribeSimulationJobInput {
	s.Jobs = v
	return s
}

type BatchDescribeSimulationJobOutput struct {
	_ struct{} `type:"structure"`

	// A list of simulation jobs.
	Jobs []*SimulationJob `locationName:"jobs" type:"list"`

	// A list of unprocessed simulation job Amazon Resource Names (ARNs).
	UnprocessedJobs []*string `locationName:"unprocessedJobs" min:"1" type:"list"`
}

// String returns the string representation
func (s BatchDescribeSimulationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchDescribeSimulationJobOutput) GoString() string {
	return s.String()
}

// SetJobs sets the Jobs field's value.
func (s *BatchDescribeSimulationJobOutput) SetJobs(v []*SimulationJob) *BatchDescribeSimulationJobOutput {
	s.Jobs = v
	return s
}

// SetUnprocessedJobs sets the UnprocessedJobs field's value.
func (s *BatchDescribeSimulationJobOutput) SetUnprocessedJobs(v []*string) *BatchDescribeSimulationJobOutput {
	s.UnprocessedJobs = v
	return s
}

// Information about the batch policy.
type BatchPolicy struct {
	_ struct{} `type:"structure"`

	// The number of active simulation jobs create as part of the batch that can
	// be in an active state at the same time.
	//
	// Active states include: Pending,Preparing, Running, Restarting, RunningFailed
	// and Terminating. All other states are terminal states.
	MaxConcurrency *int64 `locationName:"maxConcurrency" type:"integer"`

	// The amount of time, in seconds, to wait for the batch to complete.
	//
	// If a batch times out, and there are pending requests that were failing due
	// to an internal failure (like InternalServiceError), they will be moved to
	// the failed list and the batch status will be Failed. If the pending requests
	// were failing for any other reason, the failed pending requests will be moved
	// to the failed list and the batch status will be TimedOut.
	TimeoutInSeconds *int64 `locationName:"timeoutInSeconds" type:"long"`
}

// String returns the string representation
func (s BatchPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchPolicy) GoString() string {
	return s.String()
}

// SetMaxConcurrency sets the MaxConcurrency field's value.
func (s *BatchPolicy) SetMaxConcurrency(v int64) *BatchPolicy {
	s.MaxConcurrency = &v
	return s
}

// SetTimeoutInSeconds sets the TimeoutInSeconds field's value.
func (s *BatchPolicy) SetTimeoutInSeconds(v int64) *BatchPolicy {
	s.TimeoutInSeconds = &v
	return s
}

type CancelDeploymentJobInput struct {
	_ struct{} `type:"structure"`

	// The deployment job ARN to cancel.
	//
	// Job is a required field
	Job *string `locationName:"job" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelDeploymentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelDeploymentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelDeploymentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelDeploymentJobInput"}
	if s.Job == nil {
		invalidParams.Add(request.NewErrParamRequired("Job"))
	}
	if s.Job != nil && len(*s.Job) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Job", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJob sets the Job field's value.
func (s *CancelDeploymentJobInput) SetJob(v string) *CancelDeploymentJobInput {
	s.Job = &v
	return s
}

type CancelDeploymentJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelDeploymentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelDeploymentJobOutput) GoString() string {
	return s.String()
}

type CancelSimulationJobBatchInput struct {
	_ struct{} `type:"structure"`

	// The id of the batch to cancel.
	//
	// Batch is a required field
	Batch *string `locationName:"batch" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelSimulationJobBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSimulationJobBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelSimulationJobBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelSimulationJobBatchInput"}
	if s.Batch == nil {
		invalidParams.Add(request.NewErrParamRequired("Batch"))
	}
	if s.Batch != nil && len(*s.Batch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Batch", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatch sets the Batch field's value.
func (s *CancelSimulationJobBatchInput) SetBatch(v string) *CancelSimulationJobBatchInput {
	s.Batch = &v
	return s
}

type CancelSimulationJobBatchOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelSimulationJobBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSimulationJobBatchOutput) GoString() string {
	return s.String()
}

type CancelSimulationJobInput struct {
	_ struct{} `type:"structure"`

	// The simulation job ARN to cancel.
	//
	// Job is a required field
	Job *string `locationName:"job" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelSimulationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSimulationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelSimulationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelSimulationJobInput"}
	if s.Job == nil {
		invalidParams.Add(request.NewErrParamRequired("Job"))
	}
	if s.Job != nil && len(*s.Job) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Job", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJob sets the Job field's value.
func (s *CancelSimulationJobInput) SetJob(v string) *CancelSimulationJobInput {
	s.Job = &v
	return s
}

type CancelSimulationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelSimulationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelSimulationJobOutput) GoString() string {
	return s.String()
}

type CancelWorldExportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the world export job to cancel.
	//
	// Job is a required field
	Job *string `locationName:"job" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelWorldExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelWorldExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelWorldExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelWorldExportJobInput"}
	if s.Job == nil {
		invalidParams.Add(request.NewErrParamRequired("Job"))
	}
	if s.Job != nil && len(*s.Job) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Job", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJob sets the Job field's value.
func (s *CancelWorldExportJobInput) SetJob(v string) *CancelWorldExportJobInput {
	s.Job = &v
	return s
}

type CancelWorldExportJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelWorldExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelWorldExportJobOutput) GoString() string {
	return s.String()
}

type CancelWorldGenerationJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the world generator job to cancel.
	//
	// Job is a required field
	Job *string `locationName:"job" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CancelWorldGenerationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelWorldGenerationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelWorldGenerationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelWorldGenerationJobInput"}
	if s.Job == nil {
		invalidParams.Add(request.NewErrParamRequired("Job"))
	}
	if s.Job != nil && len(*s.Job) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Job", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJob sets the Job field's value.
func (s *CancelWorldGenerationJobInput) SetJob(v string) *CancelWorldGenerationJobInput {
	s.Job = &v
	return s
}

type CancelWorldGenerationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s CancelWorldGenerationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelWorldGenerationJobOutput) GoString() string {
	return s.String()
}

// Compute information for the simulation job.
type Compute struct {
	_ struct{} `type:"structure"`

	// The simulation unit limit. Your simulation is allocated CPU and memory proportional
	// to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB
	// of memory. You are only billed for the SU utilization you consume up to the
	// maximim value provided. The default is 15.
	SimulationUnitLimit *int64 `locationName:"simulationUnitLimit" min:"1" type:"integer"`
}

// String returns the string representation
func (s Compute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Compute) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Compute) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Compute"}
	if s.SimulationUnitLimit != nil && *s.SimulationUnitLimit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("SimulationUnitLimit", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSimulationUnitLimit sets the SimulationUnitLimit field's value.
func (s *Compute) SetSimulationUnitLimit(v int64) *Compute {
	s.SimulationUnitLimit = &v
	return s
}

// Compute information for the simulation job
type ComputeResponse struct {
	_ struct{} `type:"structure"`

	// The simulation unit limit. Your simulation is allocated CPU and memory proportional
	// to the supplied simulation unit limit. A simulation unit is 1 vcpu and 2GB
	// of memory. You are only billed for the SU utilization you consume up to the
	// maximim value provided. The default is 15.
	SimulationUnitLimit *int64 `locationName:"simulationUnitLimit" min:"1" type:"integer"`
}

// String returns the string representation
func (s ComputeResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeResponse) GoString() string {
	return s.String()
}

// SetSimulationUnitLimit sets the SimulationUnitLimit field's value.
func (s *ComputeResponse) SetSimulationUnitLimit(v int64) *ComputeResponse {
	s.SimulationUnitLimit = &v
	return s
}

// The failure percentage threshold percentage was met.
type ConcurrentDeploymentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ConcurrentDeploymentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConcurrentDeploymentException) GoString() string {
	return s.String()
}

func newErrorConcurrentDeploymentException(v protocol.ResponseMetadata) error {
	return &ConcurrentDeploymentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConcurrentDeploymentException) Code() string {
	return "ConcurrentDeploymentException"
}

// Message returns the exception's message.
func (s *ConcurrentDeploymentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConcurrentDeploymentException) OrigErr() error {
	return nil
}

func (s *ConcurrentDeploymentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConcurrentDeploymentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConcurrentDeploymentException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDeploymentJobInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The deployment application configuration.
	//
	// DeploymentApplicationConfigs is a required field
	DeploymentApplicationConfigs []*DeploymentApplicationConfig `locationName:"deploymentApplicationConfigs" min:"1" type:"list" required:"true"`

	// The requested deployment configuration.
	DeploymentConfig *DeploymentConfig `locationName:"deploymentConfig" type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet to deploy.
	//
	// Fleet is a required field
	Fleet *string `locationName:"fleet" min:"1" type:"string" required:"true"`

	// A map that contains tag keys and tag values that are attached to the deployment
	// job.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateDeploymentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DeploymentApplicationConfigs == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentApplicationConfigs"))
	}
	if s.DeploymentApplicationConfigs != nil && len(s.DeploymentApplicationConfigs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentApplicationConfigs", 1))
	}
	if s.Fleet == nil {
		invalidParams.Add(request.NewErrParamRequired("Fleet"))
	}
	if s.Fleet != nil && len(*s.Fleet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fleet", 1))
	}
	if s.DeploymentApplicationConfigs != nil {
		for i, v := range s.DeploymentApplicationConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DeploymentApplicationConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.DeploymentConfig != nil {
		if err := s.DeploymentConfig.Validate(); err != nil {
			invalidParams.AddNested("DeploymentConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateDeploymentJobInput) SetClientRequestToken(v string) *CreateDeploymentJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetDeploymentApplicationConfigs sets the DeploymentApplicationConfigs field's value.
func (s *CreateDeploymentJobInput) SetDeploymentApplicationConfigs(v []*DeploymentApplicationConfig) *CreateDeploymentJobInput {
	s.DeploymentApplicationConfigs = v
	return s
}

// SetDeploymentConfig sets the DeploymentConfig field's value.
func (s *CreateDeploymentJobInput) SetDeploymentConfig(v *DeploymentConfig) *CreateDeploymentJobInput {
	s.DeploymentConfig = v
	return s
}

// SetFleet sets the Fleet field's value.
func (s *CreateDeploymentJobInput) SetFleet(v string) *CreateDeploymentJobInput {
	s.Fleet = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDeploymentJobInput) SetTags(v map[string]*string) *CreateDeploymentJobInput {
	s.Tags = v
	return s
}

type CreateDeploymentJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deployment job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the fleet was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The deployment application configuration.
	DeploymentApplicationConfigs []*DeploymentApplicationConfig `locationName:"deploymentApplicationConfigs" min:"1" type:"list"`

	// The deployment configuration.
	DeploymentConfig *DeploymentConfig `locationName:"deploymentConfig" type:"structure"`

	// The failure code of the simulation job if it failed:
	//
	// BadPermissionError
	//
	// AWS Greengrass requires a service-level role permission to access other services.
	// The role must include the AWSGreengrassResourceAccessRolePolicy managed policy
	// (https://console.aws.amazon.com/iam/home?#/policies/arn:aws:iam::aws:policy/service-role/AWSGreengrassResourceAccessRolePolicy$jsonEditor).
	//
	// ExtractingBundleFailure
	//
	// The robot application could not be extracted from the bundle.
	//
	// FailureThresholdBreached
	//
	// The percentage of robots that could not be updated exceeded the percentage
	// set for the deployment.
	//
	// GreengrassDeploymentFailed
	//
	// The robot application could not be deployed to the robot.
	//
	// GreengrassGroupVersionDoesNotExist
	//
	// The AWS Greengrass group or version associated with a robot is missing.
	//
	// InternalServerError
	//
	// An internal error has occurred. Retry your request, but if the problem persists,
	// contact us with details.
	//
	// MissingRobotApplicationArchitecture
	//
	// The robot application does not have a source that matches the architecture
	// of the robot.
	//
	// MissingRobotDeploymentResource
	//
	// One or more of the resources specified for the robot application are missing.
	// For example, does the robot application have the correct launch package and
	// launch file?
	//
	// PostLaunchFileFailure
	//
	// The post-launch script failed.
	//
	// PreLaunchFileFailure
	//
	// The pre-launch script failed.
	//
	// ResourceNotFound
	//
	// One or more deployment resources are missing. For example, do robot application
	// source bundles still exist?
	//
	// RobotDeploymentNoResponse
	//
	// There is no response from the robot. It might not be powered on or connected
	// to the internet.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"DeploymentJobErrorCode"`

	// The failure reason of the deployment job if it failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The target fleet for the deployment job.
	Fleet *string `locationName:"fleet" min:"1" type:"string"`

	// The status of the deployment job.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`

	// The list of all tags added to the deployment job.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateDeploymentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDeploymentJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDeploymentJobOutput) SetArn(v string) *CreateDeploymentJobOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateDeploymentJobOutput) SetCreatedAt(v time.Time) *CreateDeploymentJobOutput {
	s.CreatedAt = &v
	return s
}

// SetDeploymentApplicationConfigs sets the DeploymentApplicationConfigs field's value.
func (s *CreateDeploymentJobOutput) SetDeploymentApplicationConfigs(v []*DeploymentApplicationConfig) *CreateDeploymentJobOutput {
	s.DeploymentApplicationConfigs = v
	return s
}

// SetDeploymentConfig sets the DeploymentConfig field's value.
func (s *CreateDeploymentJobOutput) SetDeploymentConfig(v *DeploymentConfig) *CreateDeploymentJobOutput {
	s.DeploymentConfig = v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *CreateDeploymentJobOutput) SetFailureCode(v string) *CreateDeploymentJobOutput {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *CreateDeploymentJobOutput) SetFailureReason(v string) *CreateDeploymentJobOutput {
	s.FailureReason = &v
	return s
}

// SetFleet sets the Fleet field's value.
func (s *CreateDeploymentJobOutput) SetFleet(v string) *CreateDeploymentJobOutput {
	s.Fleet = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateDeploymentJobOutput) SetStatus(v string) *CreateDeploymentJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDeploymentJobOutput) SetTags(v map[string]*string) *CreateDeploymentJobOutput {
	s.Tags = v
	return s
}

type CreateFleetInput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A map that contains tag keys and tag values that are attached to the fleet.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateFleetInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateFleetInput) SetName(v string) *CreateFleetInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFleetInput) SetTags(v map[string]*string) *CreateFleetInput {
	s.Tags = v
	return s
}

type CreateFleetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the fleet was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The name of the fleet.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The list of all tags added to the fleet.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFleetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateFleetOutput) SetArn(v string) *CreateFleetOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateFleetOutput) SetCreatedAt(v time.Time) *CreateFleetOutput {
	s.CreatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateFleetOutput) SetName(v string) *CreateFleetOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateFleetOutput) SetTags(v map[string]*string) *CreateFleetOutput {
	s.Tags = v
	return s
}

type CreateRobotApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the robot application.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The robot software suite (ROS distribuition) used by the robot application.
	//
	// RobotSoftwareSuite is a required field
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure" required:"true"`

	// The sources of the robot application.
	//
	// Sources is a required field
	Sources []*SourceConfig `locationName:"sources" type:"list" required:"true"`

	// A map that contains tag keys and tag values that are attached to the robot
	// application.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateRobotApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRobotApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRobotApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRobotApplicationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RobotSoftwareSuite == nil {
		invalidParams.Add(request.NewErrParamRequired("RobotSoftwareSuite"))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateRobotApplicationInput) SetName(v string) *CreateRobotApplicationInput {
	s.Name = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *CreateRobotApplicationInput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *CreateRobotApplicationInput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateRobotApplicationInput) SetSources(v []*SourceConfig) *CreateRobotApplicationInput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRobotApplicationInput) SetTags(v map[string]*string) *CreateRobotApplicationInput {
	s.Tags = v
	return s
}

type CreateRobotApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot application was
	// last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the robot application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The revision id of the robot application.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// The robot software suite (ROS distribution) used by the robot application.
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The sources of the robot application.
	Sources []*Source `locationName:"sources" type:"list"`

	// The list of all tags added to the robot application.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The version of the robot application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateRobotApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRobotApplicationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateRobotApplicationOutput) SetArn(v string) *CreateRobotApplicationOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *CreateRobotApplicationOutput) SetLastUpdatedAt(v time.Time) *CreateRobotApplicationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRobotApplicationOutput) SetName(v string) *CreateRobotApplicationOutput {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *CreateRobotApplicationOutput) SetRevisionId(v string) *CreateRobotApplicationOutput {
	s.RevisionId = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *CreateRobotApplicationOutput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *CreateRobotApplicationOutput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateRobotApplicationOutput) SetSources(v []*Source) *CreateRobotApplicationOutput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRobotApplicationOutput) SetTags(v map[string]*string) *CreateRobotApplicationOutput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateRobotApplicationOutput) SetVersion(v string) *CreateRobotApplicationOutput {
	s.Version = &v
	return s
}

type CreateRobotApplicationVersionInput struct {
	_ struct{} `type:"structure"`

	// The application information for the robot application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The current revision id for the robot application. If you provide a value
	// and it matches the latest revision ID, a new version will be created.
	CurrentRevisionId *string `locationName:"currentRevisionId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateRobotApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRobotApplicationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRobotApplicationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRobotApplicationVersionInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.CurrentRevisionId != nil && len(*s.CurrentRevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentRevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *CreateRobotApplicationVersionInput) SetApplication(v string) *CreateRobotApplicationVersionInput {
	s.Application = &v
	return s
}

// SetCurrentRevisionId sets the CurrentRevisionId field's value.
func (s *CreateRobotApplicationVersionInput) SetCurrentRevisionId(v string) *CreateRobotApplicationVersionInput {
	s.CurrentRevisionId = &v
	return s
}

type CreateRobotApplicationVersionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot application was
	// last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the robot application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The revision id of the robot application.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// The robot software suite (ROS distribution) used by the robot application.
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The sources of the robot application.
	Sources []*Source `locationName:"sources" type:"list"`

	// The version of the robot application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateRobotApplicationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRobotApplicationVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateRobotApplicationVersionOutput) SetArn(v string) *CreateRobotApplicationVersionOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *CreateRobotApplicationVersionOutput) SetLastUpdatedAt(v time.Time) *CreateRobotApplicationVersionOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRobotApplicationVersionOutput) SetName(v string) *CreateRobotApplicationVersionOutput {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *CreateRobotApplicationVersionOutput) SetRevisionId(v string) *CreateRobotApplicationVersionOutput {
	s.RevisionId = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *CreateRobotApplicationVersionOutput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *CreateRobotApplicationVersionOutput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateRobotApplicationVersionOutput) SetSources(v []*Source) *CreateRobotApplicationVersionOutput {
	s.Sources = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateRobotApplicationVersionOutput) SetVersion(v string) *CreateRobotApplicationVersionOutput {
	s.Version = &v
	return s
}

type CreateRobotInput struct {
	_ struct{} `type:"structure"`

	// The target architecture of the robot.
	//
	// Architecture is a required field
	Architecture *string `locationName:"architecture" type:"string" required:"true" enum:"Architecture"`

	// The Greengrass group id.
	//
	// GreengrassGroupId is a required field
	GreengrassGroupId *string `locationName:"greengrassGroupId" min:"1" type:"string" required:"true"`

	// The name for the robot.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// A map that contains tag keys and tag values that are attached to the robot.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateRobotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRobotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRobotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRobotInput"}
	if s.Architecture == nil {
		invalidParams.Add(request.NewErrParamRequired("Architecture"))
	}
	if s.GreengrassGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GreengrassGroupId"))
	}
	if s.GreengrassGroupId != nil && len(*s.GreengrassGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GreengrassGroupId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchitecture sets the Architecture field's value.
func (s *CreateRobotInput) SetArchitecture(v string) *CreateRobotInput {
	s.Architecture = &v
	return s
}

// SetGreengrassGroupId sets the GreengrassGroupId field's value.
func (s *CreateRobotInput) SetGreengrassGroupId(v string) *CreateRobotInput {
	s.GreengrassGroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRobotInput) SetName(v string) *CreateRobotInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRobotInput) SetTags(v map[string]*string) *CreateRobotInput {
	s.Tags = v
	return s
}

type CreateRobotOutput struct {
	_ struct{} `type:"structure"`

	// The target architecture of the robot.
	Architecture *string `locationName:"architecture" type:"string" enum:"Architecture"`

	// The Amazon Resource Name (ARN) of the robot.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the Greengrass group associated with the
	// robot.
	GreengrassGroupId *string `locationName:"greengrassGroupId" min:"1" type:"string"`

	// The name of the robot.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The list of all tags added to the robot.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateRobotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRobotOutput) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *CreateRobotOutput) SetArchitecture(v string) *CreateRobotOutput {
	s.Architecture = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *CreateRobotOutput) SetArn(v string) *CreateRobotOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateRobotOutput) SetCreatedAt(v time.Time) *CreateRobotOutput {
	s.CreatedAt = &v
	return s
}

// SetGreengrassGroupId sets the GreengrassGroupId field's value.
func (s *CreateRobotOutput) SetGreengrassGroupId(v string) *CreateRobotOutput {
	s.GreengrassGroupId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRobotOutput) SetName(v string) *CreateRobotOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRobotOutput) SetTags(v map[string]*string) *CreateRobotOutput {
	s.Tags = v
	return s
}

type CreateSimulationApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name of the simulation application.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The rendering engine for the simulation application.
	RenderingEngine *RenderingEngine `locationName:"renderingEngine" type:"structure"`

	// The robot software suite (ROS distribution) used by the simulation application.
	//
	// RobotSoftwareSuite is a required field
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure" required:"true"`

	// The simulation software suite used by the simulation application.
	//
	// SimulationSoftwareSuite is a required field
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure" required:"true"`

	// The sources of the simulation application.
	//
	// Sources is a required field
	Sources []*SourceConfig `locationName:"sources" type:"list" required:"true"`

	// A map that contains tag keys and tag values that are attached to the simulation
	// application.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateSimulationApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSimulationApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSimulationApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSimulationApplicationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RobotSoftwareSuite == nil {
		invalidParams.Add(request.NewErrParamRequired("RobotSoftwareSuite"))
	}
	if s.SimulationSoftwareSuite == nil {
		invalidParams.Add(request.NewErrParamRequired("SimulationSoftwareSuite"))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.RenderingEngine != nil {
		if err := s.RenderingEngine.Validate(); err != nil {
			invalidParams.AddNested("RenderingEngine", err.(request.ErrInvalidParams))
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateSimulationApplicationInput) SetName(v string) *CreateSimulationApplicationInput {
	s.Name = &v
	return s
}

// SetRenderingEngine sets the RenderingEngine field's value.
func (s *CreateSimulationApplicationInput) SetRenderingEngine(v *RenderingEngine) *CreateSimulationApplicationInput {
	s.RenderingEngine = v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *CreateSimulationApplicationInput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *CreateSimulationApplicationInput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSimulationSoftwareSuite sets the SimulationSoftwareSuite field's value.
func (s *CreateSimulationApplicationInput) SetSimulationSoftwareSuite(v *SimulationSoftwareSuite) *CreateSimulationApplicationInput {
	s.SimulationSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateSimulationApplicationInput) SetSources(v []*SourceConfig) *CreateSimulationApplicationInput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSimulationApplicationInput) SetTags(v map[string]*string) *CreateSimulationApplicationInput {
	s.Tags = v
	return s
}

type CreateSimulationApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation application
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the simulation application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The rendering engine for the simulation application.
	RenderingEngine *RenderingEngine `locationName:"renderingEngine" type:"structure"`

	// The revision id of the simulation application.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// Information about the robot software suite (ROS distribution).
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The simulation software suite used by the simulation application.
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure"`

	// The sources of the simulation application.
	Sources []*Source `locationName:"sources" type:"list"`

	// The list of all tags added to the simulation application.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The version of the simulation application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateSimulationApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSimulationApplicationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSimulationApplicationOutput) SetArn(v string) *CreateSimulationApplicationOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *CreateSimulationApplicationOutput) SetLastUpdatedAt(v time.Time) *CreateSimulationApplicationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSimulationApplicationOutput) SetName(v string) *CreateSimulationApplicationOutput {
	s.Name = &v
	return s
}

// SetRenderingEngine sets the RenderingEngine field's value.
func (s *CreateSimulationApplicationOutput) SetRenderingEngine(v *RenderingEngine) *CreateSimulationApplicationOutput {
	s.RenderingEngine = v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *CreateSimulationApplicationOutput) SetRevisionId(v string) *CreateSimulationApplicationOutput {
	s.RevisionId = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *CreateSimulationApplicationOutput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *CreateSimulationApplicationOutput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSimulationSoftwareSuite sets the SimulationSoftwareSuite field's value.
func (s *CreateSimulationApplicationOutput) SetSimulationSoftwareSuite(v *SimulationSoftwareSuite) *CreateSimulationApplicationOutput {
	s.SimulationSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateSimulationApplicationOutput) SetSources(v []*Source) *CreateSimulationApplicationOutput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSimulationApplicationOutput) SetTags(v map[string]*string) *CreateSimulationApplicationOutput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateSimulationApplicationOutput) SetVersion(v string) *CreateSimulationApplicationOutput {
	s.Version = &v
	return s
}

type CreateSimulationApplicationVersionInput struct {
	_ struct{} `type:"structure"`

	// The application information for the simulation application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The current revision id for the simulation application. If you provide a
	// value and it matches the latest revision ID, a new version will be created.
	CurrentRevisionId *string `locationName:"currentRevisionId" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateSimulationApplicationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSimulationApplicationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSimulationApplicationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSimulationApplicationVersionInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.CurrentRevisionId != nil && len(*s.CurrentRevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentRevisionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *CreateSimulationApplicationVersionInput) SetApplication(v string) *CreateSimulationApplicationVersionInput {
	s.Application = &v
	return s
}

// SetCurrentRevisionId sets the CurrentRevisionId field's value.
func (s *CreateSimulationApplicationVersionInput) SetCurrentRevisionId(v string) *CreateSimulationApplicationVersionInput {
	s.CurrentRevisionId = &v
	return s
}

type CreateSimulationApplicationVersionOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation application
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the simulation application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The rendering engine for the simulation application.
	RenderingEngine *RenderingEngine `locationName:"renderingEngine" type:"structure"`

	// The revision ID of the simulation application.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// Information about the robot software suite (ROS distribution).
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The simulation software suite used by the simulation application.
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure"`

	// The sources of the simulation application.
	Sources []*Source `locationName:"sources" type:"list"`

	// The version of the simulation application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s CreateSimulationApplicationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSimulationApplicationVersionOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSimulationApplicationVersionOutput) SetArn(v string) *CreateSimulationApplicationVersionOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *CreateSimulationApplicationVersionOutput) SetLastUpdatedAt(v time.Time) *CreateSimulationApplicationVersionOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSimulationApplicationVersionOutput) SetName(v string) *CreateSimulationApplicationVersionOutput {
	s.Name = &v
	return s
}

// SetRenderingEngine sets the RenderingEngine field's value.
func (s *CreateSimulationApplicationVersionOutput) SetRenderingEngine(v *RenderingEngine) *CreateSimulationApplicationVersionOutput {
	s.RenderingEngine = v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *CreateSimulationApplicationVersionOutput) SetRevisionId(v string) *CreateSimulationApplicationVersionOutput {
	s.RevisionId = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *CreateSimulationApplicationVersionOutput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *CreateSimulationApplicationVersionOutput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSimulationSoftwareSuite sets the SimulationSoftwareSuite field's value.
func (s *CreateSimulationApplicationVersionOutput) SetSimulationSoftwareSuite(v *SimulationSoftwareSuite) *CreateSimulationApplicationVersionOutput {
	s.SimulationSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *CreateSimulationApplicationVersionOutput) SetSources(v []*Source) *CreateSimulationApplicationVersionOutput {
	s.Sources = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateSimulationApplicationVersionOutput) SetVersion(v string) *CreateSimulationApplicationVersionOutput {
	s.Version = &v
	return s
}

type CreateSimulationJobInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// Compute information for the simulation job.
	Compute *Compute `locationName:"compute" type:"structure"`

	// Specify data sources to mount read-only files from S3 into your simulation.
	// These files are available under /opt/robomaker/datasources/data_source_name.
	//
	// There is a limit of 100 files and a combined size of 25GB for all DataSourceConfig
	// objects.
	DataSources []*DataSourceConfig `locationName:"dataSources" min:"1" type:"list"`

	// The failure behavior the simulation job.
	//
	// Continue
	//
	// Restart the simulation job in the same host instance.
	//
	// Fail
	//
	// Stop the simulation job and terminate the instance.
	FailureBehavior *string `locationName:"failureBehavior" type:"string" enum:"FailureBehavior"`

	// The IAM role name that allows the simulation instance to call the AWS APIs
	// that are specified in its associated policies on your behalf. This is how
	// credentials are passed in to your simulation job.
	//
	// IamRole is a required field
	IamRole *string `locationName:"iamRole" min:"1" type:"string" required:"true"`

	// The logging configuration.
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure"`

	// The maximum simulation job duration in seconds (up to 14 days or 1,209,600
	// seconds. When maxJobDurationInSeconds is reached, the simulation job will
	// status will transition to Completed.
	//
	// MaxJobDurationInSeconds is a required field
	MaxJobDurationInSeconds *int64 `locationName:"maxJobDurationInSeconds" type:"long" required:"true"`

	// Location for output files generated by the simulation job.
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure"`

	// The robot application to use in the simulation job.
	RobotApplications []*RobotApplicationConfig `locationName:"robotApplications" min:"1" type:"list"`

	// The simulation application to use in the simulation job.
	SimulationApplications []*SimulationApplicationConfig `locationName:"simulationApplications" min:"1" type:"list"`

	// A map that contains tag keys and tag values that are attached to the simulation
	// job.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// If your simulation job accesses resources in a VPC, you provide this parameter
	// identifying the list of security group IDs and subnet IDs. These must belong
	// to the same VPC. You must provide at least one security group and one subnet
	// ID.
	VpcConfig *VPCConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s CreateSimulationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSimulationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSimulationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSimulationJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DataSources != nil && len(s.DataSources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSources", 1))
	}
	if s.IamRole == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRole"))
	}
	if s.IamRole != nil && len(*s.IamRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IamRole", 1))
	}
	if s.MaxJobDurationInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxJobDurationInSeconds"))
	}
	if s.RobotApplications != nil && len(s.RobotApplications) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RobotApplications", 1))
	}
	if s.SimulationApplications != nil && len(s.SimulationApplications) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SimulationApplications", 1))
	}
	if s.Compute != nil {
		if err := s.Compute.Validate(); err != nil {
			invalidParams.AddNested("Compute", err.(request.ErrInvalidParams))
		}
	}
	if s.DataSources != nil {
		for i, v := range s.DataSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LoggingConfig != nil {
		if err := s.LoggingConfig.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.RobotApplications != nil {
		for i, v := range s.RobotApplications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RobotApplications", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SimulationApplications != nil {
		for i, v := range s.SimulationApplications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SimulationApplications", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateSimulationJobInput) SetClientRequestToken(v string) *CreateSimulationJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetCompute sets the Compute field's value.
func (s *CreateSimulationJobInput) SetCompute(v *Compute) *CreateSimulationJobInput {
	s.Compute = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *CreateSimulationJobInput) SetDataSources(v []*DataSourceConfig) *CreateSimulationJobInput {
	s.DataSources = v
	return s
}

// SetFailureBehavior sets the FailureBehavior field's value.
func (s *CreateSimulationJobInput) SetFailureBehavior(v string) *CreateSimulationJobInput {
	s.FailureBehavior = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *CreateSimulationJobInput) SetIamRole(v string) *CreateSimulationJobInput {
	s.IamRole = &v
	return s
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *CreateSimulationJobInput) SetLoggingConfig(v *LoggingConfig) *CreateSimulationJobInput {
	s.LoggingConfig = v
	return s
}

// SetMaxJobDurationInSeconds sets the MaxJobDurationInSeconds field's value.
func (s *CreateSimulationJobInput) SetMaxJobDurationInSeconds(v int64) *CreateSimulationJobInput {
	s.MaxJobDurationInSeconds = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *CreateSimulationJobInput) SetOutputLocation(v *OutputLocation) *CreateSimulationJobInput {
	s.OutputLocation = v
	return s
}

// SetRobotApplications sets the RobotApplications field's value.
func (s *CreateSimulationJobInput) SetRobotApplications(v []*RobotApplicationConfig) *CreateSimulationJobInput {
	s.RobotApplications = v
	return s
}

// SetSimulationApplications sets the SimulationApplications field's value.
func (s *CreateSimulationJobInput) SetSimulationApplications(v []*SimulationApplicationConfig) *CreateSimulationJobInput {
	s.SimulationApplications = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSimulationJobInput) SetTags(v map[string]*string) *CreateSimulationJobInput {
	s.Tags = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateSimulationJobInput) SetVpcConfig(v *VPCConfig) *CreateSimulationJobInput {
	s.VpcConfig = v
	return s
}

type CreateSimulationJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// Compute information for the simulation job.
	Compute *ComputeResponse `locationName:"compute" type:"structure"`

	// The data sources for the simulation job.
	DataSources []*DataSource `locationName:"dataSources" type:"list"`

	// the failure behavior for the simulation job.
	FailureBehavior *string `locationName:"failureBehavior" type:"string" enum:"FailureBehavior"`

	// The failure code of the simulation job if it failed:
	//
	// InternalServiceError
	//
	// Internal service error.
	//
	// RobotApplicationCrash
	//
	// Robot application exited abnormally.
	//
	// SimulationApplicationCrash
	//
	// Simulation application exited abnormally.
	//
	// BadPermissionsRobotApplication
	//
	// Robot application bundle could not be downloaded.
	//
	// BadPermissionsSimulationApplication
	//
	// Simulation application bundle could not be downloaded.
	//
	// BadPermissionsS3Output
	//
	// Unable to publish outputs to customer-provided S3 bucket.
	//
	// BadPermissionsCloudwatchLogs
	//
	// Unable to publish logs to customer-provided CloudWatch Logs resource.
	//
	// SubnetIpLimitExceeded
	//
	// Subnet IP limit exceeded.
	//
	// ENILimitExceeded
	//
	// ENI limit exceeded.
	//
	// BadPermissionsUserCredentials
	//
	// Unable to use the Role provided.
	//
	// InvalidBundleRobotApplication
	//
	// Robot bundle cannot be extracted (invalid format, bundling error, or other
	// issue).
	//
	// InvalidBundleSimulationApplication
	//
	// Simulation bundle cannot be extracted (invalid format, bundling error, or
	// other issue).
	//
	// RobotApplicationVersionMismatchedEtag
	//
	// Etag for RobotApplication does not match value during version creation.
	//
	// SimulationApplicationVersionMismatchedEtag
	//
	// Etag for SimulationApplication does not match value during version creation.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"SimulationJobErrorCode"`

	// The IAM role that allows the simulation job to call the AWS APIs that are
	// specified in its associated policies on your behalf.
	IamRole *string `locationName:"iamRole" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// started.
	LastStartedAt *time.Time `locationName:"lastStartedAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The logging configuration.
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure"`

	// The maximum simulation job duration in seconds.
	MaxJobDurationInSeconds *int64 `locationName:"maxJobDurationInSeconds" type:"long"`

	// Simulation job output files location.
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure"`

	// The robot application used by the simulation job.
	RobotApplications []*RobotApplicationConfig `locationName:"robotApplications" min:"1" type:"list"`

	// The simulation application used by the simulation job.
	SimulationApplications []*SimulationApplicationConfig `locationName:"simulationApplications" min:"1" type:"list"`

	// The simulation job execution duration in milliseconds.
	SimulationTimeMillis *int64 `locationName:"simulationTimeMillis" type:"long"`

	// The status of the simulation job.
	Status *string `locationName:"status" type:"string" enum:"SimulationJobStatus"`

	// The list of all tags added to the simulation job.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Information about the vpc configuration.
	VpcConfig *VPCConfigResponse `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s CreateSimulationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSimulationJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateSimulationJobOutput) SetArn(v string) *CreateSimulationJobOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateSimulationJobOutput) SetClientRequestToken(v string) *CreateSimulationJobOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCompute sets the Compute field's value.
func (s *CreateSimulationJobOutput) SetCompute(v *ComputeResponse) *CreateSimulationJobOutput {
	s.Compute = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *CreateSimulationJobOutput) SetDataSources(v []*DataSource) *CreateSimulationJobOutput {
	s.DataSources = v
	return s
}

// SetFailureBehavior sets the FailureBehavior field's value.
func (s *CreateSimulationJobOutput) SetFailureBehavior(v string) *CreateSimulationJobOutput {
	s.FailureBehavior = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *CreateSimulationJobOutput) SetFailureCode(v string) *CreateSimulationJobOutput {
	s.FailureCode = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *CreateSimulationJobOutput) SetIamRole(v string) *CreateSimulationJobOutput {
	s.IamRole = &v
	return s
}

// SetLastStartedAt sets the LastStartedAt field's value.
func (s *CreateSimulationJobOutput) SetLastStartedAt(v time.Time) *CreateSimulationJobOutput {
	s.LastStartedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *CreateSimulationJobOutput) SetLastUpdatedAt(v time.Time) *CreateSimulationJobOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *CreateSimulationJobOutput) SetLoggingConfig(v *LoggingConfig) *CreateSimulationJobOutput {
	s.LoggingConfig = v
	return s
}

// SetMaxJobDurationInSeconds sets the MaxJobDurationInSeconds field's value.
func (s *CreateSimulationJobOutput) SetMaxJobDurationInSeconds(v int64) *CreateSimulationJobOutput {
	s.MaxJobDurationInSeconds = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *CreateSimulationJobOutput) SetOutputLocation(v *OutputLocation) *CreateSimulationJobOutput {
	s.OutputLocation = v
	return s
}

// SetRobotApplications sets the RobotApplications field's value.
func (s *CreateSimulationJobOutput) SetRobotApplications(v []*RobotApplicationConfig) *CreateSimulationJobOutput {
	s.RobotApplications = v
	return s
}

// SetSimulationApplications sets the SimulationApplications field's value.
func (s *CreateSimulationJobOutput) SetSimulationApplications(v []*SimulationApplicationConfig) *CreateSimulationJobOutput {
	s.SimulationApplications = v
	return s
}

// SetSimulationTimeMillis sets the SimulationTimeMillis field's value.
func (s *CreateSimulationJobOutput) SetSimulationTimeMillis(v int64) *CreateSimulationJobOutput {
	s.SimulationTimeMillis = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateSimulationJobOutput) SetStatus(v string) *CreateSimulationJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSimulationJobOutput) SetTags(v map[string]*string) *CreateSimulationJobOutput {
	s.Tags = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *CreateSimulationJobOutput) SetVpcConfig(v *VPCConfigResponse) *CreateSimulationJobOutput {
	s.VpcConfig = v
	return s
}

type CreateWorldExportJobInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The IAM role that the world export process uses to access the Amazon S3 bucket
	// and put the export.
	//
	// IamRole is a required field
	IamRole *string `locationName:"iamRole" min:"1" type:"string" required:"true"`

	// The output location.
	//
	// OutputLocation is a required field
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure" required:"true"`

	// A map that contains tag keys and tag values that are attached to the world
	// export job.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of Amazon Resource Names (arns) that correspond to worlds to export.
	//
	// Worlds is a required field
	Worlds []*string `locationName:"worlds" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s CreateWorldExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorldExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorldExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorldExportJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.IamRole == nil {
		invalidParams.Add(request.NewErrParamRequired("IamRole"))
	}
	if s.IamRole != nil && len(*s.IamRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IamRole", 1))
	}
	if s.OutputLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("OutputLocation"))
	}
	if s.Worlds == nil {
		invalidParams.Add(request.NewErrParamRequired("Worlds"))
	}
	if s.Worlds != nil && len(s.Worlds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Worlds", 1))
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWorldExportJobInput) SetClientRequestToken(v string) *CreateWorldExportJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *CreateWorldExportJobInput) SetIamRole(v string) *CreateWorldExportJobInput {
	s.IamRole = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *CreateWorldExportJobInput) SetOutputLocation(v *OutputLocation) *CreateWorldExportJobInput {
	s.OutputLocation = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorldExportJobInput) SetTags(v map[string]*string) *CreateWorldExportJobInput {
	s.Tags = v
	return s
}

// SetWorlds sets the Worlds field's value.
func (s *CreateWorldExportJobInput) SetWorlds(v []*string) *CreateWorldExportJobInput {
	s.Worlds = v
	return s
}

type CreateWorldExportJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the world export job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world export job was
	// created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The failure code of the world export job if it failed:
	//
	// InternalServiceError
	//
	// Internal service error.
	//
	// LimitExceeded
	//
	// The requested resource exceeds the maximum number allowed, or the number
	// of concurrent stream requests exceeds the maximum number allowed.
	//
	// ResourceNotFound
	//
	// The specified resource could not be found.
	//
	// RequestThrottled
	//
	// The request was throttled.
	//
	// InvalidInput
	//
	// An input parameter in the request is not valid.
	//
	// AllWorldGenerationFailed
	//
	// All of the worlds in the world generation job failed. This can happen if
	// your worldCount is greater than 50 or less than 1.
	//
	// For more information about troubleshooting WorldForge, see Troubleshooting
	// Simulation WorldForge (https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting-worldforge.html).
	FailureCode *string `locationName:"failureCode" type:"string" enum:"WorldExportJobErrorCode"`

	// The IAM role that the world export process uses to access the Amazon S3 bucket
	// and put the export.
	IamRole *string `locationName:"iamRole" min:"1" type:"string"`

	// The output location.
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure"`

	// The status of the world export job.
	//
	// Pending
	//
	// The world export job request is pending.
	//
	// Running
	//
	// The world export job is running.
	//
	// Completed
	//
	// The world export job completed.
	//
	// Failed
	//
	// The world export job failed. See failureCode for more information.
	//
	// Canceled
	//
	// The world export job was cancelled.
	//
	// Canceling
	//
	// The world export job is being cancelled.
	Status *string `locationName:"status" type:"string" enum:"WorldExportJobStatus"`

	// A map that contains tag keys and tag values that are attached to the world
	// export job.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateWorldExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorldExportJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWorldExportJobOutput) SetArn(v string) *CreateWorldExportJobOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWorldExportJobOutput) SetClientRequestToken(v string) *CreateWorldExportJobOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateWorldExportJobOutput) SetCreatedAt(v time.Time) *CreateWorldExportJobOutput {
	s.CreatedAt = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *CreateWorldExportJobOutput) SetFailureCode(v string) *CreateWorldExportJobOutput {
	s.FailureCode = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *CreateWorldExportJobOutput) SetIamRole(v string) *CreateWorldExportJobOutput {
	s.IamRole = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *CreateWorldExportJobOutput) SetOutputLocation(v *OutputLocation) *CreateWorldExportJobOutput {
	s.OutputLocation = v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateWorldExportJobOutput) SetStatus(v string) *CreateWorldExportJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorldExportJobOutput) SetTags(v map[string]*string) *CreateWorldExportJobOutput {
	s.Tags = v
	return s
}

type CreateWorldGenerationJobInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// A map that contains tag keys and tag values that are attached to the world
	// generator job.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Amazon Resource Name (arn) of the world template describing the worlds
	// you want to create.
	//
	// Template is a required field
	Template *string `locationName:"template" min:"1" type:"string" required:"true"`

	// Information about the world count.
	//
	// WorldCount is a required field
	WorldCount *WorldCount `locationName:"worldCount" type:"structure" required:"true"`

	// A map that contains tag keys and tag values that are attached to the generated
	// worlds.
	WorldTags map[string]*string `locationName:"worldTags" type:"map"`
}

// String returns the string representation
func (s CreateWorldGenerationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorldGenerationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorldGenerationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorldGenerationJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Template == nil {
		invalidParams.Add(request.NewErrParamRequired("Template"))
	}
	if s.Template != nil && len(*s.Template) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Template", 1))
	}
	if s.WorldCount == nil {
		invalidParams.Add(request.NewErrParamRequired("WorldCount"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWorldGenerationJobInput) SetClientRequestToken(v string) *CreateWorldGenerationJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorldGenerationJobInput) SetTags(v map[string]*string) *CreateWorldGenerationJobInput {
	s.Tags = v
	return s
}

// SetTemplate sets the Template field's value.
func (s *CreateWorldGenerationJobInput) SetTemplate(v string) *CreateWorldGenerationJobInput {
	s.Template = &v
	return s
}

// SetWorldCount sets the WorldCount field's value.
func (s *CreateWorldGenerationJobInput) SetWorldCount(v *WorldCount) *CreateWorldGenerationJobInput {
	s.WorldCount = v
	return s
}

// SetWorldTags sets the WorldTags field's value.
func (s *CreateWorldGenerationJobInput) SetWorldTags(v map[string]*string) *CreateWorldGenerationJobInput {
	s.WorldTags = v
	return s
}

type CreateWorldGenerationJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the world generator job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world generator job was
	// created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The failure code of the world generator job if it failed:
	//
	// InternalServiceError
	//
	// Internal service error.
	//
	// LimitExceeded
	//
	// The requested resource exceeds the maximum number allowed, or the number
	// of concurrent stream requests exceeds the maximum number allowed.
	//
	// ResourceNotFound
	//
	// The specified resource could not be found.
	//
	// RequestThrottled
	//
	// The request was throttled.
	//
	// InvalidInput
	//
	// An input parameter in the request is not valid.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"WorldGenerationJobErrorCode"`

	// The status of the world generator job.
	//
	// Pending
	//
	// The world generator job request is pending.
	//
	// Running
	//
	// The world generator job is running.
	//
	// Completed
	//
	// The world generator job completed.
	//
	// Failed
	//
	// The world generator job failed. See failureCode for more information.
	//
	// PartialFailed
	//
	// Some worlds did not generate.
	//
	// Canceled
	//
	// The world generator job was cancelled.
	//
	// Canceling
	//
	// The world generator job is being cancelled.
	Status *string `locationName:"status" type:"string" enum:"WorldGenerationJobStatus"`

	// A map that contains tag keys and tag values that are attached to the world
	// generator job.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Amazon Resource Name (arn) of the world template.
	Template *string `locationName:"template" min:"1" type:"string"`

	// Information about the world count.
	WorldCount *WorldCount `locationName:"worldCount" type:"structure"`

	// A map that contains tag keys and tag values that are attached to the generated
	// worlds.
	WorldTags map[string]*string `locationName:"worldTags" type:"map"`
}

// String returns the string representation
func (s CreateWorldGenerationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorldGenerationJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWorldGenerationJobOutput) SetArn(v string) *CreateWorldGenerationJobOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWorldGenerationJobOutput) SetClientRequestToken(v string) *CreateWorldGenerationJobOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateWorldGenerationJobOutput) SetCreatedAt(v time.Time) *CreateWorldGenerationJobOutput {
	s.CreatedAt = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *CreateWorldGenerationJobOutput) SetFailureCode(v string) *CreateWorldGenerationJobOutput {
	s.FailureCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateWorldGenerationJobOutput) SetStatus(v string) *CreateWorldGenerationJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorldGenerationJobOutput) SetTags(v map[string]*string) *CreateWorldGenerationJobOutput {
	s.Tags = v
	return s
}

// SetTemplate sets the Template field's value.
func (s *CreateWorldGenerationJobOutput) SetTemplate(v string) *CreateWorldGenerationJobOutput {
	s.Template = &v
	return s
}

// SetWorldCount sets the WorldCount field's value.
func (s *CreateWorldGenerationJobOutput) SetWorldCount(v *WorldCount) *CreateWorldGenerationJobOutput {
	s.WorldCount = v
	return s
}

// SetWorldTags sets the WorldTags field's value.
func (s *CreateWorldGenerationJobOutput) SetWorldTags(v map[string]*string) *CreateWorldGenerationJobOutput {
	s.WorldTags = v
	return s
}

type CreateWorldTemplateInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The name of the world template.
	Name *string `locationName:"name" type:"string"`

	// A map that contains tag keys and tag values that are attached to the world
	// template.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The world template body.
	TemplateBody *string `locationName:"templateBody" min:"1" type:"string"`

	// The location of the world template.
	TemplateLocation *TemplateLocation `locationName:"templateLocation" type:"structure"`
}

// String returns the string representation
func (s CreateWorldTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorldTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorldTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorldTemplateInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateLocation != nil {
		if err := s.TemplateLocation.Validate(); err != nil {
			invalidParams.AddNested("TemplateLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWorldTemplateInput) SetClientRequestToken(v string) *CreateWorldTemplateInput {
	s.ClientRequestToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorldTemplateInput) SetName(v string) *CreateWorldTemplateInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorldTemplateInput) SetTags(v map[string]*string) *CreateWorldTemplateInput {
	s.Tags = v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *CreateWorldTemplateInput) SetTemplateBody(v string) *CreateWorldTemplateInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateLocation sets the TemplateLocation field's value.
func (s *CreateWorldTemplateInput) SetTemplateLocation(v *TemplateLocation) *CreateWorldTemplateInput {
	s.TemplateLocation = v
	return s
}

type CreateWorldTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the world template.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world template was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The name of the world template.
	Name *string `locationName:"name" type:"string"`

	// A map that contains tag keys and tag values that are attached to the world
	// template.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s CreateWorldTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWorldTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWorldTemplateOutput) SetArn(v string) *CreateWorldTemplateOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *CreateWorldTemplateOutput) SetClientRequestToken(v string) *CreateWorldTemplateOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateWorldTemplateOutput) SetCreatedAt(v time.Time) *CreateWorldTemplateOutput {
	s.CreatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWorldTemplateOutput) SetName(v string) *CreateWorldTemplateOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorldTemplateOutput) SetTags(v map[string]*string) *CreateWorldTemplateOutput {
	s.Tags = v
	return s
}

// Information about a data source.
type DataSource struct {
	_ struct{} `type:"structure"`

	// The name of the data source.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The S3 bucket where the data files are located.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The list of S3 keys identifying the data source files.
	S3Keys []*S3KeyOutput `locationName:"s3Keys" type:"list"`
}

// String returns the string representation
func (s DataSource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSource) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *DataSource) SetName(v string) *DataSource {
	s.Name = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *DataSource) SetS3Bucket(v string) *DataSource {
	s.S3Bucket = &v
	return s
}

// SetS3Keys sets the S3Keys field's value.
func (s *DataSource) SetS3Keys(v []*S3KeyOutput) *DataSource {
	s.S3Keys = v
	return s
}

// Information about a data source.
type DataSourceConfig struct {
	_ struct{} `type:"structure"`

	// The name of the data source.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The S3 bucket where the data files are located.
	//
	// S3Bucket is a required field
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string" required:"true"`

	// The list of S3 keys identifying the data source files.
	//
	// S3Keys is a required field
	S3Keys []*string `locationName:"s3Keys" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s DataSourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataSourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DataSourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DataSourceConfig"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Keys == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Keys"))
	}
	if s.S3Keys != nil && len(s.S3Keys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Keys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DataSourceConfig) SetName(v string) *DataSourceConfig {
	s.Name = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *DataSourceConfig) SetS3Bucket(v string) *DataSourceConfig {
	s.S3Bucket = &v
	return s
}

// SetS3Keys sets the S3Keys field's value.
func (s *DataSourceConfig) SetS3Keys(v []*string) *DataSourceConfig {
	s.S3Keys = v
	return s
}

type DeleteFleetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// Fleet is a required field
	Fleet *string `locationName:"fleet" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteFleetInput"}
	if s.Fleet == nil {
		invalidParams.Add(request.NewErrParamRequired("Fleet"))
	}
	if s.Fleet != nil && len(*s.Fleet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fleet", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleet sets the Fleet field's value.
func (s *DeleteFleetInput) SetFleet(v string) *DeleteFleetInput {
	s.Fleet = &v
	return s
}

type DeleteFleetOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFleetOutput) GoString() string {
	return s.String()
}

type DeleteRobotApplicationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the the robot application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the robot application to delete.
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteRobotApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRobotApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRobotApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRobotApplicationInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *DeleteRobotApplicationInput) SetApplication(v string) *DeleteRobotApplicationInput {
	s.Application = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *DeleteRobotApplicationInput) SetApplicationVersion(v string) *DeleteRobotApplicationInput {
	s.ApplicationVersion = &v
	return s
}

type DeleteRobotApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRobotApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRobotApplicationOutput) GoString() string {
	return s.String()
}

type DeleteRobotInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot.
	//
	// Robot is a required field
	Robot *string `locationName:"robot" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRobotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRobotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRobotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRobotInput"}
	if s.Robot == nil {
		invalidParams.Add(request.NewErrParamRequired("Robot"))
	}
	if s.Robot != nil && len(*s.Robot) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Robot", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRobot sets the Robot field's value.
func (s *DeleteRobotInput) SetRobot(v string) *DeleteRobotInput {
	s.Robot = &v
	return s
}

type DeleteRobotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRobotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRobotOutput) GoString() string {
	return s.String()
}

type DeleteSimulationApplicationInput struct {
	_ struct{} `type:"structure"`

	// The application information for the simulation application to delete.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the simulation application to delete.
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSimulationApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSimulationApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSimulationApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSimulationApplicationInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *DeleteSimulationApplicationInput) SetApplication(v string) *DeleteSimulationApplicationInput {
	s.Application = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *DeleteSimulationApplicationInput) SetApplicationVersion(v string) *DeleteSimulationApplicationInput {
	s.ApplicationVersion = &v
	return s
}

type DeleteSimulationApplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteSimulationApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSimulationApplicationOutput) GoString() string {
	return s.String()
}

type DeleteWorldTemplateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the world template you want to delete.
	//
	// Template is a required field
	Template *string `locationName:"template" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWorldTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorldTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorldTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorldTemplateInput"}
	if s.Template == nil {
		invalidParams.Add(request.NewErrParamRequired("Template"))
	}
	if s.Template != nil && len(*s.Template) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Template", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplate sets the Template field's value.
func (s *DeleteWorldTemplateInput) SetTemplate(v string) *DeleteWorldTemplateInput {
	s.Template = &v
	return s
}

type DeleteWorldTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteWorldTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWorldTemplateOutput) GoString() string {
	return s.String()
}

// Information about a deployment application configuration.
type DeploymentApplicationConfig struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the application.
	//
	// ApplicationVersion is a required field
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string" required:"true"`

	// The launch configuration.
	//
	// LaunchConfig is a required field
	LaunchConfig *DeploymentLaunchConfig `locationName:"launchConfig" type:"structure" required:"true"`
}

// String returns the string representation
func (s DeploymentApplicationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentApplicationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentApplicationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentApplicationConfig"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationVersion"))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationVersion", 1))
	}
	if s.LaunchConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchConfig"))
	}
	if s.LaunchConfig != nil {
		if err := s.LaunchConfig.Validate(); err != nil {
			invalidParams.AddNested("LaunchConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *DeploymentApplicationConfig) SetApplication(v string) *DeploymentApplicationConfig {
	s.Application = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *DeploymentApplicationConfig) SetApplicationVersion(v string) *DeploymentApplicationConfig {
	s.ApplicationVersion = &v
	return s
}

// SetLaunchConfig sets the LaunchConfig field's value.
func (s *DeploymentApplicationConfig) SetLaunchConfig(v *DeploymentLaunchConfig) *DeploymentApplicationConfig {
	s.LaunchConfig = v
	return s
}

// Information about a deployment configuration.
type DeploymentConfig struct {
	_ struct{} `type:"structure"`

	// The percentage of robots receiving the deployment at the same time.
	ConcurrentDeploymentPercentage *int64 `locationName:"concurrentDeploymentPercentage" min:"1" type:"integer"`

	// The download condition file.
	DownloadConditionFile *S3Object `locationName:"downloadConditionFile" type:"structure"`

	// The percentage of deployments that need to fail before stopping deployment.
	FailureThresholdPercentage *int64 `locationName:"failureThresholdPercentage" min:"1" type:"integer"`

	// The amount of time, in seconds, to wait for deployment to a single robot
	// to complete. Choose a time between 1 minute and 7 days. The default is 5
	// hours.
	RobotDeploymentTimeoutInSeconds *int64 `locationName:"robotDeploymentTimeoutInSeconds" type:"long"`
}

// String returns the string representation
func (s DeploymentConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentConfig"}
	if s.ConcurrentDeploymentPercentage != nil && *s.ConcurrentDeploymentPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("ConcurrentDeploymentPercentage", 1))
	}
	if s.FailureThresholdPercentage != nil && *s.FailureThresholdPercentage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FailureThresholdPercentage", 1))
	}
	if s.DownloadConditionFile != nil {
		if err := s.DownloadConditionFile.Validate(); err != nil {
			invalidParams.AddNested("DownloadConditionFile", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConcurrentDeploymentPercentage sets the ConcurrentDeploymentPercentage field's value.
func (s *DeploymentConfig) SetConcurrentDeploymentPercentage(v int64) *DeploymentConfig {
	s.ConcurrentDeploymentPercentage = &v
	return s
}

// SetDownloadConditionFile sets the DownloadConditionFile field's value.
func (s *DeploymentConfig) SetDownloadConditionFile(v *S3Object) *DeploymentConfig {
	s.DownloadConditionFile = v
	return s
}

// SetFailureThresholdPercentage sets the FailureThresholdPercentage field's value.
func (s *DeploymentConfig) SetFailureThresholdPercentage(v int64) *DeploymentConfig {
	s.FailureThresholdPercentage = &v
	return s
}

// SetRobotDeploymentTimeoutInSeconds sets the RobotDeploymentTimeoutInSeconds field's value.
func (s *DeploymentConfig) SetRobotDeploymentTimeoutInSeconds(v int64) *DeploymentConfig {
	s.RobotDeploymentTimeoutInSeconds = &v
	return s
}

// Information about a deployment job.
type DeploymentJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deployment job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the deployment job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The deployment application configuration.
	DeploymentApplicationConfigs []*DeploymentApplicationConfig `locationName:"deploymentApplicationConfigs" min:"1" type:"list"`

	// The deployment configuration.
	DeploymentConfig *DeploymentConfig `locationName:"deploymentConfig" type:"structure"`

	// The deployment job failure code.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"DeploymentJobErrorCode"`

	// A short description of the reason why the deployment job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The Amazon Resource Name (ARN) of the fleet.
	Fleet *string `locationName:"fleet" min:"1" type:"string"`

	// The status of the deployment job.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`
}

// String returns the string representation
func (s DeploymentJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentJob) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DeploymentJob) SetArn(v string) *DeploymentJob {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DeploymentJob) SetCreatedAt(v time.Time) *DeploymentJob {
	s.CreatedAt = &v
	return s
}

// SetDeploymentApplicationConfigs sets the DeploymentApplicationConfigs field's value.
func (s *DeploymentJob) SetDeploymentApplicationConfigs(v []*DeploymentApplicationConfig) *DeploymentJob {
	s.DeploymentApplicationConfigs = v
	return s
}

// SetDeploymentConfig sets the DeploymentConfig field's value.
func (s *DeploymentJob) SetDeploymentConfig(v *DeploymentConfig) *DeploymentJob {
	s.DeploymentConfig = v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *DeploymentJob) SetFailureCode(v string) *DeploymentJob {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DeploymentJob) SetFailureReason(v string) *DeploymentJob {
	s.FailureReason = &v
	return s
}

// SetFleet sets the Fleet field's value.
func (s *DeploymentJob) SetFleet(v string) *DeploymentJob {
	s.Fleet = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeploymentJob) SetStatus(v string) *DeploymentJob {
	s.Status = &v
	return s
}

// Configuration information for a deployment launch.
type DeploymentLaunchConfig struct {
	_ struct{} `type:"structure"`

	// An array of key/value pairs specifying environment variables for the robot
	// application
	EnvironmentVariables map[string]*string `locationName:"environmentVariables" type:"map"`

	// The launch file name.
	//
	// LaunchFile is a required field
	LaunchFile *string `locationName:"launchFile" min:"1" type:"string" required:"true"`

	// The package name.
	//
	// PackageName is a required field
	PackageName *string `locationName:"packageName" min:"1" type:"string" required:"true"`

	// The deployment post-launch file. This file will be executed after the launch
	// file.
	PostLaunchFile *string `locationName:"postLaunchFile" min:"1" type:"string"`

	// The deployment pre-launch file. This file will be executed prior to the launch
	// file.
	PreLaunchFile *string `locationName:"preLaunchFile" min:"1" type:"string"`
}

// String returns the string representation
func (s DeploymentLaunchConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentLaunchConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeploymentLaunchConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeploymentLaunchConfig"}
	if s.LaunchFile == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchFile"))
	}
	if s.LaunchFile != nil && len(*s.LaunchFile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchFile", 1))
	}
	if s.PackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageName", 1))
	}
	if s.PostLaunchFile != nil && len(*s.PostLaunchFile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PostLaunchFile", 1))
	}
	if s.PreLaunchFile != nil && len(*s.PreLaunchFile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PreLaunchFile", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *DeploymentLaunchConfig) SetEnvironmentVariables(v map[string]*string) *DeploymentLaunchConfig {
	s.EnvironmentVariables = v
	return s
}

// SetLaunchFile sets the LaunchFile field's value.
func (s *DeploymentLaunchConfig) SetLaunchFile(v string) *DeploymentLaunchConfig {
	s.LaunchFile = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *DeploymentLaunchConfig) SetPackageName(v string) *DeploymentLaunchConfig {
	s.PackageName = &v
	return s
}

// SetPostLaunchFile sets the PostLaunchFile field's value.
func (s *DeploymentLaunchConfig) SetPostLaunchFile(v string) *DeploymentLaunchConfig {
	s.PostLaunchFile = &v
	return s
}

// SetPreLaunchFile sets the PreLaunchFile field's value.
func (s *DeploymentLaunchConfig) SetPreLaunchFile(v string) *DeploymentLaunchConfig {
	s.PreLaunchFile = &v
	return s
}

type DeregisterRobotInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// Fleet is a required field
	Fleet *string `locationName:"fleet" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the robot.
	//
	// Robot is a required field
	Robot *string `locationName:"robot" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterRobotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterRobotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterRobotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterRobotInput"}
	if s.Fleet == nil {
		invalidParams.Add(request.NewErrParamRequired("Fleet"))
	}
	if s.Fleet != nil && len(*s.Fleet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fleet", 1))
	}
	if s.Robot == nil {
		invalidParams.Add(request.NewErrParamRequired("Robot"))
	}
	if s.Robot != nil && len(*s.Robot) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Robot", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleet sets the Fleet field's value.
func (s *DeregisterRobotInput) SetFleet(v string) *DeregisterRobotInput {
	s.Fleet = &v
	return s
}

// SetRobot sets the Robot field's value.
func (s *DeregisterRobotInput) SetRobot(v string) *DeregisterRobotInput {
	s.Robot = &v
	return s
}

type DeregisterRobotOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	Fleet *string `locationName:"fleet" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the robot.
	Robot *string `locationName:"robot" min:"1" type:"string"`
}

// String returns the string representation
func (s DeregisterRobotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterRobotOutput) GoString() string {
	return s.String()
}

// SetFleet sets the Fleet field's value.
func (s *DeregisterRobotOutput) SetFleet(v string) *DeregisterRobotOutput {
	s.Fleet = &v
	return s
}

// SetRobot sets the Robot field's value.
func (s *DeregisterRobotOutput) SetRobot(v string) *DeregisterRobotOutput {
	s.Robot = &v
	return s
}

type DescribeDeploymentJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deployment job.
	//
	// Job is a required field
	Job *string `locationName:"job" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeDeploymentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeploymentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeDeploymentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeDeploymentJobInput"}
	if s.Job == nil {
		invalidParams.Add(request.NewErrParamRequired("Job"))
	}
	if s.Job != nil && len(*s.Job) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Job", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJob sets the Job field's value.
func (s *DescribeDeploymentJobInput) SetJob(v string) *DescribeDeploymentJobInput {
	s.Job = &v
	return s
}

type DescribeDeploymentJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deployment job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the deployment job was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The deployment application configuration.
	DeploymentApplicationConfigs []*DeploymentApplicationConfig `locationName:"deploymentApplicationConfigs" min:"1" type:"list"`

	// The deployment configuration.
	DeploymentConfig *DeploymentConfig `locationName:"deploymentConfig" type:"structure"`

	// The deployment job failure code.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"DeploymentJobErrorCode"`

	// A short description of the reason why the deployment job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The Amazon Resource Name (ARN) of the fleet.
	Fleet *string `locationName:"fleet" min:"1" type:"string"`

	// A list of robot deployment summaries.
	RobotDeploymentSummary []*RobotDeployment `locationName:"robotDeploymentSummary" type:"list"`

	// The status of the deployment job.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`

	// The list of all tags added to the specified deployment job.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeDeploymentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeDeploymentJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeDeploymentJobOutput) SetArn(v string) *DescribeDeploymentJobOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeDeploymentJobOutput) SetCreatedAt(v time.Time) *DescribeDeploymentJobOutput {
	s.CreatedAt = &v
	return s
}

// SetDeploymentApplicationConfigs sets the DeploymentApplicationConfigs field's value.
func (s *DescribeDeploymentJobOutput) SetDeploymentApplicationConfigs(v []*DeploymentApplicationConfig) *DescribeDeploymentJobOutput {
	s.DeploymentApplicationConfigs = v
	return s
}

// SetDeploymentConfig sets the DeploymentConfig field's value.
func (s *DescribeDeploymentJobOutput) SetDeploymentConfig(v *DeploymentConfig) *DescribeDeploymentJobOutput {
	s.DeploymentConfig = v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *DescribeDeploymentJobOutput) SetFailureCode(v string) *DescribeDeploymentJobOutput {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeDeploymentJobOutput) SetFailureReason(v string) *DescribeDeploymentJobOutput {
	s.FailureReason = &v
	return s
}

// SetFleet sets the Fleet field's value.
func (s *DescribeDeploymentJobOutput) SetFleet(v string) *DescribeDeploymentJobOutput {
	s.Fleet = &v
	return s
}

// SetRobotDeploymentSummary sets the RobotDeploymentSummary field's value.
func (s *DescribeDeploymentJobOutput) SetRobotDeploymentSummary(v []*RobotDeployment) *DescribeDeploymentJobOutput {
	s.RobotDeploymentSummary = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeDeploymentJobOutput) SetStatus(v string) *DescribeDeploymentJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeDeploymentJobOutput) SetTags(v map[string]*string) *DescribeDeploymentJobOutput {
	s.Tags = v
	return s
}

type DescribeFleetInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// Fleet is a required field
	Fleet *string `locationName:"fleet" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeFleetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFleetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFleetInput"}
	if s.Fleet == nil {
		invalidParams.Add(request.NewErrParamRequired("Fleet"))
	}
	if s.Fleet != nil && len(*s.Fleet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fleet", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleet sets the Fleet field's value.
func (s *DescribeFleetInput) SetFleet(v string) *DescribeFleetInput {
	s.Fleet = &v
	return s
}

type DescribeFleetOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the fleet was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the last deployment job.
	LastDeploymentJob *string `locationName:"lastDeploymentJob" min:"1" type:"string"`

	// The status of the last deployment.
	LastDeploymentStatus *string `locationName:"lastDeploymentStatus" type:"string" enum:"DeploymentStatus"`

	// The time of the last deployment.
	LastDeploymentTime *time.Time `locationName:"lastDeploymentTime" type:"timestamp"`

	// The name of the fleet.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A list of robots.
	Robots []*Robot `locationName:"robots" type:"list"`

	// The list of all tags added to the specified fleet.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeFleetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFleetOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeFleetOutput) SetArn(v string) *DescribeFleetOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeFleetOutput) SetCreatedAt(v time.Time) *DescribeFleetOutput {
	s.CreatedAt = &v
	return s
}

// SetLastDeploymentJob sets the LastDeploymentJob field's value.
func (s *DescribeFleetOutput) SetLastDeploymentJob(v string) *DescribeFleetOutput {
	s.LastDeploymentJob = &v
	return s
}

// SetLastDeploymentStatus sets the LastDeploymentStatus field's value.
func (s *DescribeFleetOutput) SetLastDeploymentStatus(v string) *DescribeFleetOutput {
	s.LastDeploymentStatus = &v
	return s
}

// SetLastDeploymentTime sets the LastDeploymentTime field's value.
func (s *DescribeFleetOutput) SetLastDeploymentTime(v time.Time) *DescribeFleetOutput {
	s.LastDeploymentTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeFleetOutput) SetName(v string) *DescribeFleetOutput {
	s.Name = &v
	return s
}

// SetRobots sets the Robots field's value.
func (s *DescribeFleetOutput) SetRobots(v []*Robot) *DescribeFleetOutput {
	s.Robots = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeFleetOutput) SetTags(v map[string]*string) *DescribeFleetOutput {
	s.Tags = v
	return s
}

type DescribeRobotApplicationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the robot application to describe.
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeRobotApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRobotApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRobotApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRobotApplicationInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *DescribeRobotApplicationInput) SetApplication(v string) *DescribeRobotApplicationInput {
	s.Application = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *DescribeRobotApplicationInput) SetApplicationVersion(v string) *DescribeRobotApplicationInput {
	s.ApplicationVersion = &v
	return s
}

type DescribeRobotApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot application was
	// last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the robot application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The revision id of the robot application.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// The robot software suite (ROS distribution) used by the robot application.
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The sources of the robot application.
	Sources []*Source `locationName:"sources" type:"list"`

	// The list of all tags added to the specified robot application.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The version of the robot application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeRobotApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRobotApplicationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeRobotApplicationOutput) SetArn(v string) *DescribeRobotApplicationOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DescribeRobotApplicationOutput) SetLastUpdatedAt(v time.Time) *DescribeRobotApplicationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeRobotApplicationOutput) SetName(v string) *DescribeRobotApplicationOutput {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *DescribeRobotApplicationOutput) SetRevisionId(v string) *DescribeRobotApplicationOutput {
	s.RevisionId = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *DescribeRobotApplicationOutput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *DescribeRobotApplicationOutput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *DescribeRobotApplicationOutput) SetSources(v []*Source) *DescribeRobotApplicationOutput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeRobotApplicationOutput) SetTags(v map[string]*string) *DescribeRobotApplicationOutput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *DescribeRobotApplicationOutput) SetVersion(v string) *DescribeRobotApplicationOutput {
	s.Version = &v
	return s
}

type DescribeRobotInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot to be described.
	//
	// Robot is a required field
	Robot *string `locationName:"robot" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRobotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRobotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRobotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRobotInput"}
	if s.Robot == nil {
		invalidParams.Add(request.NewErrParamRequired("Robot"))
	}
	if s.Robot != nil && len(*s.Robot) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Robot", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRobot sets the Robot field's value.
func (s *DescribeRobotInput) SetRobot(v string) *DescribeRobotInput {
	s.Robot = &v
	return s
}

type DescribeRobotOutput struct {
	_ struct{} `type:"structure"`

	// The target architecture of the robot application.
	Architecture *string `locationName:"architecture" type:"string" enum:"Architecture"`

	// The Amazon Resource Name (ARN) of the robot.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the fleet.
	FleetArn *string `locationName:"fleetArn" min:"1" type:"string"`

	// The Greengrass group id.
	GreengrassGroupId *string `locationName:"greengrassGroupId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the last deployment job.
	LastDeploymentJob *string `locationName:"lastDeploymentJob" min:"1" type:"string"`

	// The time of the last deployment job.
	LastDeploymentTime *time.Time `locationName:"lastDeploymentTime" type:"timestamp"`

	// The name of the robot.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the fleet.
	Status *string `locationName:"status" type:"string" enum:"RobotStatus"`

	// The list of all tags added to the specified robot.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeRobotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRobotOutput) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *DescribeRobotOutput) SetArchitecture(v string) *DescribeRobotOutput {
	s.Architecture = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *DescribeRobotOutput) SetArn(v string) *DescribeRobotOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeRobotOutput) SetCreatedAt(v time.Time) *DescribeRobotOutput {
	s.CreatedAt = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *DescribeRobotOutput) SetFleetArn(v string) *DescribeRobotOutput {
	s.FleetArn = &v
	return s
}

// SetGreengrassGroupId sets the GreengrassGroupId field's value.
func (s *DescribeRobotOutput) SetGreengrassGroupId(v string) *DescribeRobotOutput {
	s.GreengrassGroupId = &v
	return s
}

// SetLastDeploymentJob sets the LastDeploymentJob field's value.
func (s *DescribeRobotOutput) SetLastDeploymentJob(v string) *DescribeRobotOutput {
	s.LastDeploymentJob = &v
	return s
}

// SetLastDeploymentTime sets the LastDeploymentTime field's value.
func (s *DescribeRobotOutput) SetLastDeploymentTime(v time.Time) *DescribeRobotOutput {
	s.LastDeploymentTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeRobotOutput) SetName(v string) *DescribeRobotOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeRobotOutput) SetStatus(v string) *DescribeRobotOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeRobotOutput) SetTags(v map[string]*string) *DescribeRobotOutput {
	s.Tags = v
	return s
}

type DescribeSimulationApplicationInput struct {
	_ struct{} `type:"structure"`

	// The application information for the simulation application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the simulation application to describe.
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeSimulationApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSimulationApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSimulationApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSimulationApplicationInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationVersion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *DescribeSimulationApplicationInput) SetApplication(v string) *DescribeSimulationApplicationInput {
	s.Application = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *DescribeSimulationApplicationInput) SetApplicationVersion(v string) *DescribeSimulationApplicationInput {
	s.ApplicationVersion = &v
	return s
}

type DescribeSimulationApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot simulation application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation application
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the simulation application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The rendering engine for the simulation application.
	RenderingEngine *RenderingEngine `locationName:"renderingEngine" type:"structure"`

	// The revision id of the simulation application.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// Information about the robot software suite (ROS distribution).
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The simulation software suite used by the simulation application.
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure"`

	// The sources of the simulation application.
	Sources []*Source `locationName:"sources" type:"list"`

	// The list of all tags added to the specified simulation application.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The version of the simulation application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeSimulationApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSimulationApplicationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeSimulationApplicationOutput) SetArn(v string) *DescribeSimulationApplicationOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DescribeSimulationApplicationOutput) SetLastUpdatedAt(v time.Time) *DescribeSimulationApplicationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeSimulationApplicationOutput) SetName(v string) *DescribeSimulationApplicationOutput {
	s.Name = &v
	return s
}

// SetRenderingEngine sets the RenderingEngine field's value.
func (s *DescribeSimulationApplicationOutput) SetRenderingEngine(v *RenderingEngine) *DescribeSimulationApplicationOutput {
	s.RenderingEngine = v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *DescribeSimulationApplicationOutput) SetRevisionId(v string) *DescribeSimulationApplicationOutput {
	s.RevisionId = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *DescribeSimulationApplicationOutput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *DescribeSimulationApplicationOutput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSimulationSoftwareSuite sets the SimulationSoftwareSuite field's value.
func (s *DescribeSimulationApplicationOutput) SetSimulationSoftwareSuite(v *SimulationSoftwareSuite) *DescribeSimulationApplicationOutput {
	s.SimulationSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *DescribeSimulationApplicationOutput) SetSources(v []*Source) *DescribeSimulationApplicationOutput {
	s.Sources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeSimulationApplicationOutput) SetTags(v map[string]*string) *DescribeSimulationApplicationOutput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *DescribeSimulationApplicationOutput) SetVersion(v string) *DescribeSimulationApplicationOutput {
	s.Version = &v
	return s
}

type DescribeSimulationJobBatchInput struct {
	_ struct{} `type:"structure"`

	// The id of the batch to describe.
	//
	// Batch is a required field
	Batch *string `locationName:"batch" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSimulationJobBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSimulationJobBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSimulationJobBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSimulationJobBatchInput"}
	if s.Batch == nil {
		invalidParams.Add(request.NewErrParamRequired("Batch"))
	}
	if s.Batch != nil && len(*s.Batch) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Batch", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatch sets the Batch field's value.
func (s *DescribeSimulationJobBatchInput) SetBatch(v string) *DescribeSimulationJobBatchInput {
	s.Batch = &v
	return s
}

type DescribeSimulationJobBatchOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the batch.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The batch policy.
	BatchPolicy *BatchPolicy `locationName:"batchPolicy" type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A list of created simulation job summaries.
	CreatedRequests []*SimulationJobSummary `locationName:"createdRequests" type:"list"`

	// A list of failed create simulation job requests. The request failed to be
	// created into a simulation job. Failed requests do not have a simulation job
	// ID.
	FailedRequests []*FailedCreateSimulationJobRequest `locationName:"failedRequests" type:"list"`

	// The failure code of the simulation job batch.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"SimulationJobBatchErrorCode"`

	// The reason the simulation job batch failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// A list of pending simulation job requests. These requests have not yet been
	// created into simulation jobs.
	PendingRequests []*SimulationJobRequest `locationName:"pendingRequests" min:"1" type:"list"`

	// The status of the batch.
	//
	// Pending
	//
	// The simulation job batch request is pending.
	//
	// InProgress
	//
	// The simulation job batch is in progress.
	//
	// Failed
	//
	// The simulation job batch failed. One or more simulation job requests could
	// not be completed due to an internal failure (like InternalServiceError).
	// See failureCode and failureReason for more information.
	//
	// Completed
	//
	// The simulation batch job completed. A batch is complete when (1) there are
	// no pending simulation job requests in the batch and none of the failed simulation
	// job requests are due to InternalServiceError and (2) when all created simulation
	// jobs have reached a terminal state (for example, Completed or Failed).
	//
	// Canceled
	//
	// The simulation batch job was cancelled.
	//
	// Canceling
	//
	// The simulation batch job is being cancelled.
	//
	// Completing
	//
	// The simulation batch job is completing.
	//
	// TimingOut
	//
	// The simulation job batch is timing out.
	//
	// If a batch timing out, and there are pending requests that were failing due
	// to an internal failure (like InternalServiceError), the batch status will
	// be Failed. If there are no such failing request, the batch status will be
	// TimedOut.
	//
	// TimedOut
	//
	// The simulation batch job timed out.
	Status *string `locationName:"status" type:"string" enum:"SimulationJobBatchStatus"`

	// A map that contains tag keys and tag values that are attached to the simulation
	// job batch.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s DescribeSimulationJobBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSimulationJobBatchOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeSimulationJobBatchOutput) SetArn(v string) *DescribeSimulationJobBatchOutput {
	s.Arn = &v
	return s
}

// SetBatchPolicy sets the BatchPolicy field's value.
func (s *DescribeSimulationJobBatchOutput) SetBatchPolicy(v *BatchPolicy) *DescribeSimulationJobBatchOutput {
	s.BatchPolicy = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DescribeSimulationJobBatchOutput) SetClientRequestToken(v string) *DescribeSimulationJobBatchOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeSimulationJobBatchOutput) SetCreatedAt(v time.Time) *DescribeSimulationJobBatchOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedRequests sets the CreatedRequests field's value.
func (s *DescribeSimulationJobBatchOutput) SetCreatedRequests(v []*SimulationJobSummary) *DescribeSimulationJobBatchOutput {
	s.CreatedRequests = v
	return s
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *DescribeSimulationJobBatchOutput) SetFailedRequests(v []*FailedCreateSimulationJobRequest) *DescribeSimulationJobBatchOutput {
	s.FailedRequests = v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *DescribeSimulationJobBatchOutput) SetFailureCode(v string) *DescribeSimulationJobBatchOutput {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeSimulationJobBatchOutput) SetFailureReason(v string) *DescribeSimulationJobBatchOutput {
	s.FailureReason = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DescribeSimulationJobBatchOutput) SetLastUpdatedAt(v time.Time) *DescribeSimulationJobBatchOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetPendingRequests sets the PendingRequests field's value.
func (s *DescribeSimulationJobBatchOutput) SetPendingRequests(v []*SimulationJobRequest) *DescribeSimulationJobBatchOutput {
	s.PendingRequests = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeSimulationJobBatchOutput) SetStatus(v string) *DescribeSimulationJobBatchOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeSimulationJobBatchOutput) SetTags(v map[string]*string) *DescribeSimulationJobBatchOutput {
	s.Tags = v
	return s
}

type DescribeSimulationJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation job to be described.
	//
	// Job is a required field
	Job *string `locationName:"job" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeSimulationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSimulationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSimulationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSimulationJobInput"}
	if s.Job == nil {
		invalidParams.Add(request.NewErrParamRequired("Job"))
	}
	if s.Job != nil && len(*s.Job) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Job", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJob sets the Job field's value.
func (s *DescribeSimulationJobInput) SetJob(v string) *DescribeSimulationJobInput {
	s.Job = &v
	return s
}

type DescribeSimulationJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// Compute information for the simulation job.
	Compute *ComputeResponse `locationName:"compute" type:"structure"`

	// The data sources for the simulation job.
	DataSources []*DataSource `locationName:"dataSources" type:"list"`

	// The failure behavior for the simulation job.
	FailureBehavior *string `locationName:"failureBehavior" type:"string" enum:"FailureBehavior"`

	// The failure code of the simulation job if it failed:
	//
	// InternalServiceError
	//
	// Internal service error.
	//
	// RobotApplicationCrash
	//
	// Robot application exited abnormally.
	//
	// SimulationApplicationCrash
	//
	// Simulation application exited abnormally.
	//
	// BadPermissionsRobotApplication
	//
	// Robot application bundle could not be downloaded.
	//
	// BadPermissionsSimulationApplication
	//
	// Simulation application bundle could not be downloaded.
	//
	// BadPermissionsS3Output
	//
	// Unable to publish outputs to customer-provided S3 bucket.
	//
	// BadPermissionsCloudwatchLogs
	//
	// Unable to publish logs to customer-provided CloudWatch Logs resource.
	//
	// SubnetIpLimitExceeded
	//
	// Subnet IP limit exceeded.
	//
	// ENILimitExceeded
	//
	// ENI limit exceeded.
	//
	// BadPermissionsUserCredentials
	//
	// Unable to use the Role provided.
	//
	// InvalidBundleRobotApplication
	//
	// Robot bundle cannot be extracted (invalid format, bundling error, or other
	// issue).
	//
	// InvalidBundleSimulationApplication
	//
	// Simulation bundle cannot be extracted (invalid format, bundling error, or
	// other issue).
	//
	// RobotApplicationVersionMismatchedEtag
	//
	// Etag for RobotApplication does not match value during version creation.
	//
	// SimulationApplicationVersionMismatchedEtag
	//
	// Etag for SimulationApplication does not match value during version creation.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"SimulationJobErrorCode"`

	// Details about why the simulation job failed. For more information about troubleshooting,
	// see Troubleshooting (https://docs.aws.amazon.com/robomaker/latest/dg/troubleshooting.html).
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The IAM role that allows the simulation instance to call the AWS APIs that
	// are specified in its associated policies on your behalf.
	IamRole *string `locationName:"iamRole" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// started.
	LastStartedAt *time.Time `locationName:"lastStartedAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The logging configuration.
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure"`

	// The maximum job duration in seconds. The value must be 8 days (691,200 seconds)
	// or less.
	MaxJobDurationInSeconds *int64 `locationName:"maxJobDurationInSeconds" type:"long"`

	// The name of the simulation job.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The network interface information for the simulation job.
	NetworkInterface *NetworkInterface `locationName:"networkInterface" type:"structure"`

	// Location for output files generated by the simulation job.
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure"`

	// A list of robot applications.
	RobotApplications []*RobotApplicationConfig `locationName:"robotApplications" min:"1" type:"list"`

	// A list of simulation applications.
	SimulationApplications []*SimulationApplicationConfig `locationName:"simulationApplications" min:"1" type:"list"`

	// The simulation job execution duration in milliseconds.
	SimulationTimeMillis *int64 `locationName:"simulationTimeMillis" type:"long"`

	// The status of the simulation job.
	Status *string `locationName:"status" type:"string" enum:"SimulationJobStatus"`

	// The list of all tags added to the specified simulation job.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The VPC configuration.
	VpcConfig *VPCConfigResponse `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s DescribeSimulationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSimulationJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeSimulationJobOutput) SetArn(v string) *DescribeSimulationJobOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DescribeSimulationJobOutput) SetClientRequestToken(v string) *DescribeSimulationJobOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCompute sets the Compute field's value.
func (s *DescribeSimulationJobOutput) SetCompute(v *ComputeResponse) *DescribeSimulationJobOutput {
	s.Compute = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *DescribeSimulationJobOutput) SetDataSources(v []*DataSource) *DescribeSimulationJobOutput {
	s.DataSources = v
	return s
}

// SetFailureBehavior sets the FailureBehavior field's value.
func (s *DescribeSimulationJobOutput) SetFailureBehavior(v string) *DescribeSimulationJobOutput {
	s.FailureBehavior = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *DescribeSimulationJobOutput) SetFailureCode(v string) *DescribeSimulationJobOutput {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeSimulationJobOutput) SetFailureReason(v string) *DescribeSimulationJobOutput {
	s.FailureReason = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *DescribeSimulationJobOutput) SetIamRole(v string) *DescribeSimulationJobOutput {
	s.IamRole = &v
	return s
}

// SetLastStartedAt sets the LastStartedAt field's value.
func (s *DescribeSimulationJobOutput) SetLastStartedAt(v time.Time) *DescribeSimulationJobOutput {
	s.LastStartedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DescribeSimulationJobOutput) SetLastUpdatedAt(v time.Time) *DescribeSimulationJobOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *DescribeSimulationJobOutput) SetLoggingConfig(v *LoggingConfig) *DescribeSimulationJobOutput {
	s.LoggingConfig = v
	return s
}

// SetMaxJobDurationInSeconds sets the MaxJobDurationInSeconds field's value.
func (s *DescribeSimulationJobOutput) SetMaxJobDurationInSeconds(v int64) *DescribeSimulationJobOutput {
	s.MaxJobDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeSimulationJobOutput) SetName(v string) *DescribeSimulationJobOutput {
	s.Name = &v
	return s
}

// SetNetworkInterface sets the NetworkInterface field's value.
func (s *DescribeSimulationJobOutput) SetNetworkInterface(v *NetworkInterface) *DescribeSimulationJobOutput {
	s.NetworkInterface = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *DescribeSimulationJobOutput) SetOutputLocation(v *OutputLocation) *DescribeSimulationJobOutput {
	s.OutputLocation = v
	return s
}

// SetRobotApplications sets the RobotApplications field's value.
func (s *DescribeSimulationJobOutput) SetRobotApplications(v []*RobotApplicationConfig) *DescribeSimulationJobOutput {
	s.RobotApplications = v
	return s
}

// SetSimulationApplications sets the SimulationApplications field's value.
func (s *DescribeSimulationJobOutput) SetSimulationApplications(v []*SimulationApplicationConfig) *DescribeSimulationJobOutput {
	s.SimulationApplications = v
	return s
}

// SetSimulationTimeMillis sets the SimulationTimeMillis field's value.
func (s *DescribeSimulationJobOutput) SetSimulationTimeMillis(v int64) *DescribeSimulationJobOutput {
	s.SimulationTimeMillis = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeSimulationJobOutput) SetStatus(v string) *DescribeSimulationJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeSimulationJobOutput) SetTags(v map[string]*string) *DescribeSimulationJobOutput {
	s.Tags = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *DescribeSimulationJobOutput) SetVpcConfig(v *VPCConfigResponse) *DescribeSimulationJobOutput {
	s.VpcConfig = v
	return s
}

type DescribeWorldExportJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the world export job to describe.
	//
	// Job is a required field
	Job *string `locationName:"job" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeWorldExportJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorldExportJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorldExportJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorldExportJobInput"}
	if s.Job == nil {
		invalidParams.Add(request.NewErrParamRequired("Job"))
	}
	if s.Job != nil && len(*s.Job) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Job", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJob sets the Job field's value.
func (s *DescribeWorldExportJobInput) SetJob(v string) *DescribeWorldExportJobInput {
	s.Job = &v
	return s
}

type DescribeWorldExportJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the world export job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world export job was
	// created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The failure code of the world export job if it failed:
	//
	// InternalServiceError
	//
	// Internal service error.
	//
	// LimitExceeded
	//
	// The requested resource exceeds the maximum number allowed, or the number
	// of concurrent stream requests exceeds the maximum number allowed.
	//
	// ResourceNotFound
	//
	// The specified resource could not be found.
	//
	// RequestThrottled
	//
	// The request was throttled.
	//
	// InvalidInput
	//
	// An input parameter in the request is not valid.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"WorldExportJobErrorCode"`

	// The reason why the world export job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The IAM role that the world export process uses to access the Amazon S3 bucket
	// and put the export.
	IamRole *string `locationName:"iamRole" min:"1" type:"string"`

	// The output location.
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure"`

	// The status of the world export job.
	//
	// Pending
	//
	// The world export job request is pending.
	//
	// Running
	//
	// The world export job is running.
	//
	// Completed
	//
	// The world export job completed.
	//
	// Failed
	//
	// The world export job failed. See failureCode and failureReason for more information.
	//
	// Canceled
	//
	// The world export job was cancelled.
	//
	// Canceling
	//
	// The world export job is being cancelled.
	Status *string `locationName:"status" type:"string" enum:"WorldExportJobStatus"`

	// A map that contains tag keys and tag values that are attached to the world
	// export job.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A list of Amazon Resource Names (arns) that correspond to worlds to be exported.
	Worlds []*string `locationName:"worlds" min:"1" type:"list"`
}

// String returns the string representation
func (s DescribeWorldExportJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorldExportJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeWorldExportJobOutput) SetArn(v string) *DescribeWorldExportJobOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DescribeWorldExportJobOutput) SetClientRequestToken(v string) *DescribeWorldExportJobOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeWorldExportJobOutput) SetCreatedAt(v time.Time) *DescribeWorldExportJobOutput {
	s.CreatedAt = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *DescribeWorldExportJobOutput) SetFailureCode(v string) *DescribeWorldExportJobOutput {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeWorldExportJobOutput) SetFailureReason(v string) *DescribeWorldExportJobOutput {
	s.FailureReason = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *DescribeWorldExportJobOutput) SetIamRole(v string) *DescribeWorldExportJobOutput {
	s.IamRole = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *DescribeWorldExportJobOutput) SetOutputLocation(v *OutputLocation) *DescribeWorldExportJobOutput {
	s.OutputLocation = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeWorldExportJobOutput) SetStatus(v string) *DescribeWorldExportJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeWorldExportJobOutput) SetTags(v map[string]*string) *DescribeWorldExportJobOutput {
	s.Tags = v
	return s
}

// SetWorlds sets the Worlds field's value.
func (s *DescribeWorldExportJobOutput) SetWorlds(v []*string) *DescribeWorldExportJobOutput {
	s.Worlds = v
	return s
}

type DescribeWorldGenerationJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the world generation job to describe.
	//
	// Job is a required field
	Job *string `locationName:"job" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeWorldGenerationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorldGenerationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorldGenerationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorldGenerationJobInput"}
	if s.Job == nil {
		invalidParams.Add(request.NewErrParamRequired("Job"))
	}
	if s.Job != nil && len(*s.Job) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Job", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJob sets the Job field's value.
func (s *DescribeWorldGenerationJobInput) SetJob(v string) *DescribeWorldGenerationJobInput {
	s.Job = &v
	return s
}

type DescribeWorldGenerationJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the world generation job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world generation job
	// was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The failure code of the world generation job if it failed:
	//
	// InternalServiceError
	//
	// Internal service error.
	//
	// LimitExceeded
	//
	// The requested resource exceeds the maximum number allowed, or the number
	// of concurrent stream requests exceeds the maximum number allowed.
	//
	// ResourceNotFound
	//
	// The specified resource could not be found.
	//
	// RequestThrottled
	//
	// The request was throttled.
	//
	// InvalidInput
	//
	// An input parameter in the request is not valid.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"WorldGenerationJobErrorCode"`

	// The reason why the world generation job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// Summary information about finished worlds.
	FinishedWorldsSummary *FinishedWorldsSummary `locationName:"finishedWorldsSummary" type:"structure"`

	// The status of the world generation job:
	//
	// Pending
	//
	// The world generation job request is pending.
	//
	// Running
	//
	// The world generation job is running.
	//
	// Completed
	//
	// The world generation job completed.
	//
	// Failed
	//
	// The world generation job failed. See failureCode for more information.
	//
	// PartialFailed
	//
	// Some worlds did not generate.
	//
	// Canceled
	//
	// The world generation job was cancelled.
	//
	// Canceling
	//
	// The world generation job is being cancelled.
	Status *string `locationName:"status" type:"string" enum:"WorldGenerationJobStatus"`

	// A map that contains tag keys and tag values that are attached to the world
	// generation job.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The Amazon Resource Name (arn) of the world template.
	Template *string `locationName:"template" min:"1" type:"string"`

	// Information about the world count.
	WorldCount *WorldCount `locationName:"worldCount" type:"structure"`

	// A map that contains tag keys and tag values that are attached to the generated
	// worlds.
	WorldTags map[string]*string `locationName:"worldTags" type:"map"`
}

// String returns the string representation
func (s DescribeWorldGenerationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorldGenerationJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeWorldGenerationJobOutput) SetArn(v string) *DescribeWorldGenerationJobOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DescribeWorldGenerationJobOutput) SetClientRequestToken(v string) *DescribeWorldGenerationJobOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeWorldGenerationJobOutput) SetCreatedAt(v time.Time) *DescribeWorldGenerationJobOutput {
	s.CreatedAt = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *DescribeWorldGenerationJobOutput) SetFailureCode(v string) *DescribeWorldGenerationJobOutput {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *DescribeWorldGenerationJobOutput) SetFailureReason(v string) *DescribeWorldGenerationJobOutput {
	s.FailureReason = &v
	return s
}

// SetFinishedWorldsSummary sets the FinishedWorldsSummary field's value.
func (s *DescribeWorldGenerationJobOutput) SetFinishedWorldsSummary(v *FinishedWorldsSummary) *DescribeWorldGenerationJobOutput {
	s.FinishedWorldsSummary = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DescribeWorldGenerationJobOutput) SetStatus(v string) *DescribeWorldGenerationJobOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeWorldGenerationJobOutput) SetTags(v map[string]*string) *DescribeWorldGenerationJobOutput {
	s.Tags = v
	return s
}

// SetTemplate sets the Template field's value.
func (s *DescribeWorldGenerationJobOutput) SetTemplate(v string) *DescribeWorldGenerationJobOutput {
	s.Template = &v
	return s
}

// SetWorldCount sets the WorldCount field's value.
func (s *DescribeWorldGenerationJobOutput) SetWorldCount(v *WorldCount) *DescribeWorldGenerationJobOutput {
	s.WorldCount = v
	return s
}

// SetWorldTags sets the WorldTags field's value.
func (s *DescribeWorldGenerationJobOutput) SetWorldTags(v map[string]*string) *DescribeWorldGenerationJobOutput {
	s.WorldTags = v
	return s
}

type DescribeWorldInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the world you want to describe.
	//
	// World is a required field
	World *string `locationName:"world" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeWorldInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorldInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorldInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorldInput"}
	if s.World == nil {
		invalidParams.Add(request.NewErrParamRequired("World"))
	}
	if s.World != nil && len(*s.World) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("World", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorld sets the World field's value.
func (s *DescribeWorldInput) SetWorld(v string) *DescribeWorldInput {
	s.World = &v
	return s
}

type DescribeWorldOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the world.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (arn) of the world generation job that generated
	// the world.
	GenerationJob *string `locationName:"generationJob" min:"1" type:"string"`

	// A map that contains tag keys and tag values that are attached to the world.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The world template.
	Template *string `locationName:"template" min:"1" type:"string"`

	// Returns the JSON formatted string that describes the contents of your world.
	WorldDescriptionBody *string `locationName:"worldDescriptionBody" min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeWorldOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorldOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeWorldOutput) SetArn(v string) *DescribeWorldOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeWorldOutput) SetCreatedAt(v time.Time) *DescribeWorldOutput {
	s.CreatedAt = &v
	return s
}

// SetGenerationJob sets the GenerationJob field's value.
func (s *DescribeWorldOutput) SetGenerationJob(v string) *DescribeWorldOutput {
	s.GenerationJob = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeWorldOutput) SetTags(v map[string]*string) *DescribeWorldOutput {
	s.Tags = v
	return s
}

// SetTemplate sets the Template field's value.
func (s *DescribeWorldOutput) SetTemplate(v string) *DescribeWorldOutput {
	s.Template = &v
	return s
}

// SetWorldDescriptionBody sets the WorldDescriptionBody field's value.
func (s *DescribeWorldOutput) SetWorldDescriptionBody(v string) *DescribeWorldOutput {
	s.WorldDescriptionBody = &v
	return s
}

type DescribeWorldTemplateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the world template you want to describe.
	//
	// Template is a required field
	Template *string `locationName:"template" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeWorldTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorldTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorldTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorldTemplateInput"}
	if s.Template == nil {
		invalidParams.Add(request.NewErrParamRequired("Template"))
	}
	if s.Template != nil && len(*s.Template) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Template", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTemplate sets the Template field's value.
func (s *DescribeWorldTemplateInput) SetTemplate(v string) *DescribeWorldTemplateInput {
	s.Template = &v
	return s
}

type DescribeWorldTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the world template.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world template was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the world template was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the world template.
	Name *string `locationName:"name" type:"string"`

	// A map that contains tag keys and tag values that are attached to the world
	// template.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The version of the world template that you're using.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s DescribeWorldTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeWorldTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DescribeWorldTemplateOutput) SetArn(v string) *DescribeWorldTemplateOutput {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *DescribeWorldTemplateOutput) SetClientRequestToken(v string) *DescribeWorldTemplateOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *DescribeWorldTemplateOutput) SetCreatedAt(v time.Time) *DescribeWorldTemplateOutput {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *DescribeWorldTemplateOutput) SetLastUpdatedAt(v time.Time) *DescribeWorldTemplateOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *DescribeWorldTemplateOutput) SetName(v string) *DescribeWorldTemplateOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DescribeWorldTemplateOutput) SetTags(v map[string]*string) *DescribeWorldTemplateOutput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *DescribeWorldTemplateOutput) SetVersion(v string) *DescribeWorldTemplateOutput {
	s.Version = &v
	return s
}

// Information about a failed create simulation job request.
type FailedCreateSimulationJobRequest struct {
	_ struct{} `type:"structure"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// failed.
	FailedAt *time.Time `locationName:"failedAt" type:"timestamp"`

	// The failure code.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"SimulationJobErrorCode"`

	// The failure reason of the simulation job request.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The simulation job request.
	Request *SimulationJobRequest `locationName:"request" type:"structure"`
}

// String returns the string representation
func (s FailedCreateSimulationJobRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailedCreateSimulationJobRequest) GoString() string {
	return s.String()
}

// SetFailedAt sets the FailedAt field's value.
func (s *FailedCreateSimulationJobRequest) SetFailedAt(v time.Time) *FailedCreateSimulationJobRequest {
	s.FailedAt = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *FailedCreateSimulationJobRequest) SetFailureCode(v string) *FailedCreateSimulationJobRequest {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *FailedCreateSimulationJobRequest) SetFailureReason(v string) *FailedCreateSimulationJobRequest {
	s.FailureReason = &v
	return s
}

// SetRequest sets the Request field's value.
func (s *FailedCreateSimulationJobRequest) SetRequest(v *SimulationJobRequest) *FailedCreateSimulationJobRequest {
	s.Request = v
	return s
}

// Information about worlds that failed.
type FailureSummary struct {
	_ struct{} `type:"structure"`

	// The worlds that failed.
	Failures []*WorldFailure `locationName:"failures" type:"list"`

	// The total number of failures.
	TotalFailureCount *int64 `locationName:"totalFailureCount" type:"integer"`
}

// String returns the string representation
func (s FailureSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailureSummary) GoString() string {
	return s.String()
}

// SetFailures sets the Failures field's value.
func (s *FailureSummary) SetFailures(v []*WorldFailure) *FailureSummary {
	s.Failures = v
	return s
}

// SetTotalFailureCount sets the TotalFailureCount field's value.
func (s *FailureSummary) SetTotalFailureCount(v int64) *FailureSummary {
	s.TotalFailureCount = &v
	return s
}

// Information about a filter.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A list of values.
	Values []*string `locationName:"values" min:"1" type:"list"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Values != nil && len(s.Values) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Values", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// Information about worlds that finished.
type FinishedWorldsSummary struct {
	_ struct{} `type:"structure"`

	// Information about worlds that failed.
	FailureSummary *FailureSummary `locationName:"failureSummary" type:"structure"`

	// The total number of finished worlds.
	FinishedCount *int64 `locationName:"finishedCount" type:"integer"`

	// A list of worlds that succeeded.
	SucceededWorlds []*string `locationName:"succeededWorlds" min:"1" type:"list"`
}

// String returns the string representation
func (s FinishedWorldsSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FinishedWorldsSummary) GoString() string {
	return s.String()
}

// SetFailureSummary sets the FailureSummary field's value.
func (s *FinishedWorldsSummary) SetFailureSummary(v *FailureSummary) *FinishedWorldsSummary {
	s.FailureSummary = v
	return s
}

// SetFinishedCount sets the FinishedCount field's value.
func (s *FinishedWorldsSummary) SetFinishedCount(v int64) *FinishedWorldsSummary {
	s.FinishedCount = &v
	return s
}

// SetSucceededWorlds sets the SucceededWorlds field's value.
func (s *FinishedWorldsSummary) SetSucceededWorlds(v []*string) *FinishedWorldsSummary {
	s.SucceededWorlds = v
	return s
}

// Information about a fleet.
type Fleet struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the fleet was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the last deployment job.
	LastDeploymentJob *string `locationName:"lastDeploymentJob" min:"1" type:"string"`

	// The status of the last fleet deployment.
	LastDeploymentStatus *string `locationName:"lastDeploymentStatus" type:"string" enum:"DeploymentStatus"`

	// The time of the last deployment.
	LastDeploymentTime *time.Time `locationName:"lastDeploymentTime" type:"timestamp"`

	// The name of the fleet.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation
func (s Fleet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Fleet) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Fleet) SetArn(v string) *Fleet {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Fleet) SetCreatedAt(v time.Time) *Fleet {
	s.CreatedAt = &v
	return s
}

// SetLastDeploymentJob sets the LastDeploymentJob field's value.
func (s *Fleet) SetLastDeploymentJob(v string) *Fleet {
	s.LastDeploymentJob = &v
	return s
}

// SetLastDeploymentStatus sets the LastDeploymentStatus field's value.
func (s *Fleet) SetLastDeploymentStatus(v string) *Fleet {
	s.LastDeploymentStatus = &v
	return s
}

// SetLastDeploymentTime sets the LastDeploymentTime field's value.
func (s *Fleet) SetLastDeploymentTime(v time.Time) *Fleet {
	s.LastDeploymentTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Fleet) SetName(v string) *Fleet {
	s.Name = &v
	return s
}

type GetWorldTemplateBodyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the world generator job.
	GenerationJob *string `locationName:"generationJob" min:"1" type:"string"`

	// The Amazon Resource Name (arn) of the world template.
	Template *string `locationName:"template" min:"1" type:"string"`
}

// String returns the string representation
func (s GetWorldTemplateBodyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWorldTemplateBodyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorldTemplateBodyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorldTemplateBodyInput"}
	if s.GenerationJob != nil && len(*s.GenerationJob) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GenerationJob", 1))
	}
	if s.Template != nil && len(*s.Template) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Template", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGenerationJob sets the GenerationJob field's value.
func (s *GetWorldTemplateBodyInput) SetGenerationJob(v string) *GetWorldTemplateBodyInput {
	s.GenerationJob = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *GetWorldTemplateBodyInput) SetTemplate(v string) *GetWorldTemplateBodyInput {
	s.Template = &v
	return s
}

type GetWorldTemplateBodyOutput struct {
	_ struct{} `type:"structure"`

	// The world template body.
	TemplateBody *string `locationName:"templateBody" min:"1" type:"string"`
}

// String returns the string representation
func (s GetWorldTemplateBodyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWorldTemplateBodyOutput) GoString() string {
	return s.String()
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *GetWorldTemplateBodyOutput) SetTemplateBody(v string) *GetWorldTemplateBodyOutput {
	s.TemplateBody = &v
	return s
}

// The request uses the same client token as a previous, but non-identical request.
// Do not reuse a client token with different requests, unless the requests
// are identical.
type IdempotentParameterMismatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s IdempotentParameterMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IdempotentParameterMismatchException) GoString() string {
	return s.String()
}

func newErrorIdempotentParameterMismatchException(v protocol.ResponseMetadata) error {
	return &IdempotentParameterMismatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IdempotentParameterMismatchException) Code() string {
	return "IdempotentParameterMismatchException"
}

// Message returns the exception's message.
func (s *IdempotentParameterMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IdempotentParameterMismatchException) OrigErr() error {
	return nil
}

func (s *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IdempotentParameterMismatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IdempotentParameterMismatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// AWS RoboMaker experienced a service issue. Try your call again.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A parameter specified in a request is not valid, is unsupported, or cannot
// be used. The returned message provides an explanation of the error value.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a launch configuration.
type LaunchConfig struct {
	_ struct{} `type:"structure"`

	// The environment variables for the application launch.
	EnvironmentVariables map[string]*string `locationName:"environmentVariables" type:"map"`

	// The launch file name.
	//
	// LaunchFile is a required field
	LaunchFile *string `locationName:"launchFile" min:"1" type:"string" required:"true"`

	// The package name.
	//
	// PackageName is a required field
	PackageName *string `locationName:"packageName" min:"1" type:"string" required:"true"`

	// The port forwarding configuration.
	PortForwardingConfig *PortForwardingConfig `locationName:"portForwardingConfig" type:"structure"`

	// Boolean indicating whether a streaming session will be configured for the
	// application. If True, AWS RoboMaker will configure a connection so you can
	// interact with your application as it is running in the simulation. You must
	// configure and launch the component. It must have a graphical user interface.
	StreamUI *bool `locationName:"streamUI" type:"boolean"`
}

// String returns the string representation
func (s LaunchConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LaunchConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LaunchConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LaunchConfig"}
	if s.LaunchFile == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchFile"))
	}
	if s.LaunchFile != nil && len(*s.LaunchFile) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LaunchFile", 1))
	}
	if s.PackageName == nil {
		invalidParams.Add(request.NewErrParamRequired("PackageName"))
	}
	if s.PackageName != nil && len(*s.PackageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PackageName", 1))
	}
	if s.PortForwardingConfig != nil {
		if err := s.PortForwardingConfig.Validate(); err != nil {
			invalidParams.AddNested("PortForwardingConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnvironmentVariables sets the EnvironmentVariables field's value.
func (s *LaunchConfig) SetEnvironmentVariables(v map[string]*string) *LaunchConfig {
	s.EnvironmentVariables = v
	return s
}

// SetLaunchFile sets the LaunchFile field's value.
func (s *LaunchConfig) SetLaunchFile(v string) *LaunchConfig {
	s.LaunchFile = &v
	return s
}

// SetPackageName sets the PackageName field's value.
func (s *LaunchConfig) SetPackageName(v string) *LaunchConfig {
	s.PackageName = &v
	return s
}

// SetPortForwardingConfig sets the PortForwardingConfig field's value.
func (s *LaunchConfig) SetPortForwardingConfig(v *PortForwardingConfig) *LaunchConfig {
	s.PortForwardingConfig = v
	return s
}

// SetStreamUI sets the StreamUI field's value.
func (s *LaunchConfig) SetStreamUI(v bool) *LaunchConfig {
	s.StreamUI = &v
	return s
}

// The requested resource exceeds the maximum number allowed, or the number
// of concurrent stream requests exceeds the maximum number allowed.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDeploymentJobsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters to limit results.
	//
	// The filter names status and fleetName are supported. When filtering, you
	// must use the complete value of the filtered item. You can use up to three
	// filters, but they must be for the same named item. For example, if you are
	// looking for items with the status InProgress or the status Pending.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListDeploymentJobs only returns maxResults results
	// in a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListDeploymentJobs
	// request with the returned nextToken value. This value can be between 1 and
	// 200. If this parameter is not used, then ListDeploymentJobs returns up to
	// 200 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListDeploymentJobs again and assign that token
	// to the request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListDeploymentJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDeploymentJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDeploymentJobsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListDeploymentJobsInput) SetFilters(v []*Filter) *ListDeploymentJobsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDeploymentJobsInput) SetMaxResults(v int64) *ListDeploymentJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentJobsInput) SetNextToken(v string) *ListDeploymentJobsInput {
	s.NextToken = &v
	return s
}

type ListDeploymentJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of deployment jobs that meet the criteria of the request.
	DeploymentJobs []*DeploymentJob `locationName:"deploymentJobs" type:"list"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListDeploymentJobs again and assign that token
	// to the request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListDeploymentJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDeploymentJobsOutput) GoString() string {
	return s.String()
}

// SetDeploymentJobs sets the DeploymentJobs field's value.
func (s *ListDeploymentJobsOutput) SetDeploymentJobs(v []*DeploymentJob) *ListDeploymentJobsOutput {
	s.DeploymentJobs = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDeploymentJobsOutput) SetNextToken(v string) *ListDeploymentJobsOutput {
	s.NextToken = &v
	return s
}

type ListFleetsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters to limit results.
	//
	// The filter name name is supported. When filtering, you must use the complete
	// value of the filtered item. You can use up to three filters.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListFleets only returns maxResults results in
	// a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListFleets request
	// with the returned nextToken value. This value can be between 1 and 200. If
	// this parameter is not used, then ListFleets returns up to 200 results and
	// a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListFleets again and assign that token to the
	// request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFleetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListFleetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListFleetsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListFleetsInput) SetFilters(v []*Filter) *ListFleetsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListFleetsInput) SetMaxResults(v int64) *ListFleetsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsInput) SetNextToken(v string) *ListFleetsInput {
	s.NextToken = &v
	return s
}

type ListFleetsOutput struct {
	_ struct{} `type:"structure"`

	// A list of fleet details meeting the request criteria.
	FleetDetails []*Fleet `locationName:"fleetDetails" type:"list"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListFleets again and assign that token to the
	// request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFleetsOutput) GoString() string {
	return s.String()
}

// SetFleetDetails sets the FleetDetails field's value.
func (s *ListFleetsOutput) SetFleetDetails(v []*Fleet) *ListFleetsOutput {
	s.FleetDetails = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListFleetsOutput) SetNextToken(v string) *ListFleetsOutput {
	s.NextToken = &v
	return s
}

type ListRobotApplicationsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters to limit results.
	//
	// The filter name name is supported. When filtering, you must use the complete
	// value of the filtered item. You can use up to three filters.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListRobotApplications only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListRobotApplications
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter is not used, then ListRobotApplications returns up
	// to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListRobotApplications again and assign that
	// token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The version qualifier of the robot application.
	VersionQualifier *string `locationName:"versionQualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s ListRobotApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRobotApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRobotApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRobotApplicationsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.VersionQualifier != nil && len(*s.VersionQualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionQualifier", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListRobotApplicationsInput) SetFilters(v []*Filter) *ListRobotApplicationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRobotApplicationsInput) SetMaxResults(v int64) *ListRobotApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRobotApplicationsInput) SetNextToken(v string) *ListRobotApplicationsInput {
	s.NextToken = &v
	return s
}

// SetVersionQualifier sets the VersionQualifier field's value.
func (s *ListRobotApplicationsInput) SetVersionQualifier(v string) *ListRobotApplicationsInput {
	s.VersionQualifier = &v
	return s
}

type ListRobotApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListRobotApplications again and assign that
	// token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of robot application summaries that meet the criteria of the request.
	RobotApplicationSummaries []*RobotApplicationSummary `locationName:"robotApplicationSummaries" type:"list"`
}

// String returns the string representation
func (s ListRobotApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRobotApplicationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRobotApplicationsOutput) SetNextToken(v string) *ListRobotApplicationsOutput {
	s.NextToken = &v
	return s
}

// SetRobotApplicationSummaries sets the RobotApplicationSummaries field's value.
func (s *ListRobotApplicationsOutput) SetRobotApplicationSummaries(v []*RobotApplicationSummary) *ListRobotApplicationsOutput {
	s.RobotApplicationSummaries = v
	return s
}

type ListRobotsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters to limit results.
	//
	// The filter names status and fleetName are supported. When filtering, you
	// must use the complete value of the filtered item. You can use up to three
	// filters, but they must be for the same named item. For example, if you are
	// looking for items with the status Registered or the status Available.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListRobots only returns maxResults results in
	// a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListRobots request
	// with the returned nextToken value. This value can be between 1 and 200. If
	// this parameter is not used, then ListRobots returns up to 200 results and
	// a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListRobots again and assign that token to the
	// request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListRobotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRobotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRobotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRobotsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListRobotsInput) SetFilters(v []*Filter) *ListRobotsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRobotsInput) SetMaxResults(v int64) *ListRobotsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRobotsInput) SetNextToken(v string) *ListRobotsInput {
	s.NextToken = &v
	return s
}

type ListRobotsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListRobots again and assign that token to the
	// request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of robots that meet the criteria of the request.
	Robots []*Robot `locationName:"robots" type:"list"`
}

// String returns the string representation
func (s ListRobotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRobotsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRobotsOutput) SetNextToken(v string) *ListRobotsOutput {
	s.NextToken = &v
	return s
}

// SetRobots sets the Robots field's value.
func (s *ListRobotsOutput) SetRobots(v []*Robot) *ListRobotsOutput {
	s.Robots = v
	return s
}

type ListSimulationApplicationsInput struct {
	_ struct{} `type:"structure"`

	// Optional list of filters to limit results.
	//
	// The filter name name is supported. When filtering, you must use the complete
	// value of the filtered item. You can use up to three filters.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListSimulationApplications only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListSimulationApplications
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter is not used, then ListSimulationApplications returns
	// up to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListSimulationApplications again and assign
	// that token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// The version qualifier of the simulation application.
	VersionQualifier *string `locationName:"versionQualifier" min:"1" type:"string"`
}

// String returns the string representation
func (s ListSimulationApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSimulationApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSimulationApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSimulationApplicationsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.VersionQualifier != nil && len(*s.VersionQualifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VersionQualifier", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListSimulationApplicationsInput) SetFilters(v []*Filter) *ListSimulationApplicationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSimulationApplicationsInput) SetMaxResults(v int64) *ListSimulationApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSimulationApplicationsInput) SetNextToken(v string) *ListSimulationApplicationsInput {
	s.NextToken = &v
	return s
}

// SetVersionQualifier sets the VersionQualifier field's value.
func (s *ListSimulationApplicationsInput) SetVersionQualifier(v string) *ListSimulationApplicationsInput {
	s.VersionQualifier = &v
	return s
}

type ListSimulationApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListSimulationApplications again and assign
	// that token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of simulation application summaries that meet the criteria of the
	// request.
	SimulationApplicationSummaries []*SimulationApplicationSummary `locationName:"simulationApplicationSummaries" type:"list"`
}

// String returns the string representation
func (s ListSimulationApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSimulationApplicationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSimulationApplicationsOutput) SetNextToken(v string) *ListSimulationApplicationsOutput {
	s.NextToken = &v
	return s
}

// SetSimulationApplicationSummaries sets the SimulationApplicationSummaries field's value.
func (s *ListSimulationApplicationsOutput) SetSimulationApplicationSummaries(v []*SimulationApplicationSummary) *ListSimulationApplicationsOutput {
	s.SimulationApplicationSummaries = v
	return s
}

type ListSimulationJobBatchesInput struct {
	_ struct{} `type:"structure"`

	// Optional filters to limit results.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListSimulationJobBatches only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListSimulationJobBatches
	// request with the returned nextToken value.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListSimulationJobBatches again and assign that
	// token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListSimulationJobBatchesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSimulationJobBatchesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSimulationJobBatchesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSimulationJobBatchesInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListSimulationJobBatchesInput) SetFilters(v []*Filter) *ListSimulationJobBatchesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSimulationJobBatchesInput) SetMaxResults(v int64) *ListSimulationJobBatchesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSimulationJobBatchesInput) SetNextToken(v string) *ListSimulationJobBatchesInput {
	s.NextToken = &v
	return s
}

type ListSimulationJobBatchesOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListSimulationJobBatches again and assign that
	// token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of simulation job batch summaries.
	SimulationJobBatchSummaries []*SimulationJobBatchSummary `locationName:"simulationJobBatchSummaries" type:"list"`
}

// String returns the string representation
func (s ListSimulationJobBatchesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSimulationJobBatchesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSimulationJobBatchesOutput) SetNextToken(v string) *ListSimulationJobBatchesOutput {
	s.NextToken = &v
	return s
}

// SetSimulationJobBatchSummaries sets the SimulationJobBatchSummaries field's value.
func (s *ListSimulationJobBatchesOutput) SetSimulationJobBatchSummaries(v []*SimulationJobBatchSummary) *ListSimulationJobBatchesOutput {
	s.SimulationJobBatchSummaries = v
	return s
}

type ListSimulationJobsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters to limit results.
	//
	// The filter names status and simulationApplicationName and robotApplicationName
	// are supported. When filtering, you must use the complete value of the filtered
	// item. You can use up to three filters, but they must be for the same named
	// item. For example, if you are looking for items with the status Preparing
	// or the status Running.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListSimulationJobs only returns maxResults results
	// in a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListSimulationJobs
	// request with the returned nextToken value. This value can be between 1 and
	// 1000. If this parameter is not used, then ListSimulationJobs returns up to
	// 1000 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListSimulationJobs again and assign that token
	// to the request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListSimulationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSimulationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSimulationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSimulationJobsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListSimulationJobsInput) SetFilters(v []*Filter) *ListSimulationJobsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSimulationJobsInput) SetMaxResults(v int64) *ListSimulationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSimulationJobsInput) SetNextToken(v string) *ListSimulationJobsInput {
	s.NextToken = &v
	return s
}

type ListSimulationJobsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListSimulationJobs again and assign that token
	// to the request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// A list of simulation job summaries that meet the criteria of the request.
	//
	// SimulationJobSummaries is a required field
	SimulationJobSummaries []*SimulationJobSummary `locationName:"simulationJobSummaries" type:"list" required:"true"`
}

// String returns the string representation
func (s ListSimulationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSimulationJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSimulationJobsOutput) SetNextToken(v string) *ListSimulationJobsOutput {
	s.NextToken = &v
	return s
}

// SetSimulationJobSummaries sets the SimulationJobSummaries field's value.
func (s *ListSimulationJobsOutput) SetSimulationJobSummaries(v []*SimulationJobSummary) *ListSimulationJobsOutput {
	s.SimulationJobSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The AWS RoboMaker Amazon Resource Name (ARN) with tags to be listed.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of all tags added to the specified resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListWorldExportJobsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters to limit results. You can use generationJobId and templateId.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListWorldExportJobs only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListWorldExportJobs
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter is not used, then ListWorldExportJobs returns up to
	// 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListWorldExportJobs again and assign that token
	// to the request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListWorldExportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorldExportJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorldExportJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorldExportJobsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListWorldExportJobsInput) SetFilters(v []*Filter) *ListWorldExportJobsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorldExportJobsInput) SetMaxResults(v int64) *ListWorldExportJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorldExportJobsInput) SetNextToken(v string) *ListWorldExportJobsInput {
	s.NextToken = &v
	return s
}

type ListWorldExportJobsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListWorldExportJobsRequest again and assign
	// that token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Summary information for world export jobs.
	//
	// WorldExportJobSummaries is a required field
	WorldExportJobSummaries []*WorldExportJobSummary `locationName:"worldExportJobSummaries" type:"list" required:"true"`
}

// String returns the string representation
func (s ListWorldExportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorldExportJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorldExportJobsOutput) SetNextToken(v string) *ListWorldExportJobsOutput {
	s.NextToken = &v
	return s
}

// SetWorldExportJobSummaries sets the WorldExportJobSummaries field's value.
func (s *ListWorldExportJobsOutput) SetWorldExportJobSummaries(v []*WorldExportJobSummary) *ListWorldExportJobsOutput {
	s.WorldExportJobSummaries = v
	return s
}

type ListWorldGenerationJobsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters to limit results. You can use status and templateId.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListWorldGeneratorJobs only returns maxResults
	// results in a single page along with a nextToken response element. The remaining
	// results of the initial request can be seen by sending another ListWorldGeneratorJobs
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter is not used, then ListWorldGeneratorJobs returns up
	// to 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListWorldGenerationJobsRequest again and assign
	// that token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListWorldGenerationJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorldGenerationJobsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorldGenerationJobsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorldGenerationJobsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListWorldGenerationJobsInput) SetFilters(v []*Filter) *ListWorldGenerationJobsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorldGenerationJobsInput) SetMaxResults(v int64) *ListWorldGenerationJobsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorldGenerationJobsInput) SetNextToken(v string) *ListWorldGenerationJobsInput {
	s.NextToken = &v
	return s
}

type ListWorldGenerationJobsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListWorldGeneratorJobsRequest again and assign
	// that token to the request object's nextToken parameter. If there are no remaining
	// results, the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Summary information for world generator jobs.
	//
	// WorldGenerationJobSummaries is a required field
	WorldGenerationJobSummaries []*WorldGenerationJobSummary `locationName:"worldGenerationJobSummaries" type:"list" required:"true"`
}

// String returns the string representation
func (s ListWorldGenerationJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorldGenerationJobsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorldGenerationJobsOutput) SetNextToken(v string) *ListWorldGenerationJobsOutput {
	s.NextToken = &v
	return s
}

// SetWorldGenerationJobSummaries sets the WorldGenerationJobSummaries field's value.
func (s *ListWorldGenerationJobsOutput) SetWorldGenerationJobSummaries(v []*WorldGenerationJobSummary) *ListWorldGenerationJobsOutput {
	s.WorldGenerationJobSummaries = v
	return s
}

type ListWorldTemplatesInput struct {
	_ struct{} `type:"structure"`

	// When this parameter is used, ListWorldTemplates only returns maxResults results
	// in a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListWorldTemplates
	// request with the returned nextToken value. This value can be between 1 and
	// 100. If this parameter is not used, then ListWorldTemplates returns up to
	// 100 results and a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListWorldTemplates again and assign that token
	// to the request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListWorldTemplatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorldTemplatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorldTemplatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorldTemplatesInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorldTemplatesInput) SetMaxResults(v int64) *ListWorldTemplatesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorldTemplatesInput) SetNextToken(v string) *ListWorldTemplatesInput {
	s.NextToken = &v
	return s
}

type ListWorldTemplatesOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListWorldTemplates again and assign that token
	// to the request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Summary information for templates.
	TemplateSummaries []*TemplateSummary `locationName:"templateSummaries" type:"list"`
}

// String returns the string representation
func (s ListWorldTemplatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorldTemplatesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorldTemplatesOutput) SetNextToken(v string) *ListWorldTemplatesOutput {
	s.NextToken = &v
	return s
}

// SetTemplateSummaries sets the TemplateSummaries field's value.
func (s *ListWorldTemplatesOutput) SetTemplateSummaries(v []*TemplateSummary) *ListWorldTemplatesOutput {
	s.TemplateSummaries = v
	return s
}

type ListWorldsInput struct {
	_ struct{} `type:"structure"`

	// Optional filters to limit results. You can use status.
	Filters []*Filter `locationName:"filters" min:"1" type:"list"`

	// When this parameter is used, ListWorlds only returns maxResults results in
	// a single page along with a nextToken response element. The remaining results
	// of the initial request can be seen by sending another ListWorlds request
	// with the returned nextToken value. This value can be between 1 and 100. If
	// this parameter is not used, then ListWorlds returns up to 100 results and
	// a nextToken value if applicable.
	MaxResults *int64 `locationName:"maxResults" type:"integer"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListWorlds again and assign that token to the
	// request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListWorldsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorldsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorldsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorldsInput"}
	if s.Filters != nil && len(s.Filters) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Filters", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListWorldsInput) SetFilters(v []*Filter) *ListWorldsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorldsInput) SetMaxResults(v int64) *ListWorldsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorldsInput) SetNextToken(v string) *ListWorldsInput {
	s.NextToken = &v
	return s
}

type ListWorldsOutput struct {
	_ struct{} `type:"structure"`

	// If the previous paginated request did not return all of the remaining results,
	// the response object's nextToken parameter value is set to a token. To retrieve
	// the next set of results, call ListWorlds again and assign that token to the
	// request object's nextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Summary information for worlds.
	WorldSummaries []*WorldSummary `locationName:"worldSummaries" type:"list"`
}

// String returns the string representation
func (s ListWorldsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWorldsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorldsOutput) SetNextToken(v string) *ListWorldsOutput {
	s.NextToken = &v
	return s
}

// SetWorldSummaries sets the WorldSummaries field's value.
func (s *ListWorldsOutput) SetWorldSummaries(v []*WorldSummary) *ListWorldsOutput {
	s.WorldSummaries = v
	return s
}

// The logging configuration.
type LoggingConfig struct {
	_ struct{} `type:"structure"`

	// A boolean indicating whether to record all ROS topics.
	//
	// RecordAllRosTopics is a required field
	RecordAllRosTopics *bool `locationName:"recordAllRosTopics" type:"boolean" required:"true"`
}

// String returns the string representation
func (s LoggingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingConfig"}
	if s.RecordAllRosTopics == nil {
		invalidParams.Add(request.NewErrParamRequired("RecordAllRosTopics"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecordAllRosTopics sets the RecordAllRosTopics field's value.
func (s *LoggingConfig) SetRecordAllRosTopics(v bool) *LoggingConfig {
	s.RecordAllRosTopics = &v
	return s
}

// Describes a network interface.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The ID of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The IPv4 address of the network interface within the subnet.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The IPv4 public address of the network interface.
	PublicIpAddress *string `locationName:"publicIpAddress" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *NetworkInterface) SetNetworkInterfaceId(v string) *NetworkInterface {
	s.NetworkInterfaceId = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *NetworkInterface) SetPrivateIpAddress(v string) *NetworkInterface {
	s.PrivateIpAddress = &v
	return s
}

// SetPublicIpAddress sets the PublicIpAddress field's value.
func (s *NetworkInterface) SetPublicIpAddress(v string) *NetworkInterface {
	s.PublicIpAddress = &v
	return s
}

// The output location.
type OutputLocation struct {
	_ struct{} `type:"structure"`

	// The S3 bucket for output.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The S3 folder in the s3Bucket where output files will be placed.
	S3Prefix *string `locationName:"s3Prefix" min:"1" type:"string"`
}

// String returns the string representation
func (s OutputLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputLocation"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *OutputLocation) SetS3Bucket(v string) *OutputLocation {
	s.S3Bucket = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *OutputLocation) SetS3Prefix(v string) *OutputLocation {
	s.S3Prefix = &v
	return s
}

// Configuration information for port forwarding.
type PortForwardingConfig struct {
	_ struct{} `type:"structure"`

	// The port mappings for the configuration.
	PortMappings []*PortMapping `locationName:"portMappings" type:"list"`
}

// String returns the string representation
func (s PortForwardingConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortForwardingConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortForwardingConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortForwardingConfig"}
	if s.PortMappings != nil {
		for i, v := range s.PortMappings {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PortMappings", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPortMappings sets the PortMappings field's value.
func (s *PortForwardingConfig) SetPortMappings(v []*PortMapping) *PortForwardingConfig {
	s.PortMappings = v
	return s
}

// An object representing a port mapping.
type PortMapping struct {
	_ struct{} `type:"structure"`

	// The port number on the application.
	//
	// ApplicationPort is a required field
	ApplicationPort *int64 `locationName:"applicationPort" min:"1024" type:"integer" required:"true"`

	// A Boolean indicating whether to enable this port mapping on public IP.
	EnableOnPublicIp *bool `locationName:"enableOnPublicIp" type:"boolean"`

	// The port number on the simulation job instance to use as a remote connection
	// point.
	//
	// JobPort is a required field
	JobPort *int64 `locationName:"jobPort" min:"1" type:"integer" required:"true"`
}

// String returns the string representation
func (s PortMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PortMapping) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PortMapping) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PortMapping"}
	if s.ApplicationPort == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationPort"))
	}
	if s.ApplicationPort != nil && *s.ApplicationPort < 1024 {
		invalidParams.Add(request.NewErrParamMinValue("ApplicationPort", 1024))
	}
	if s.JobPort == nil {
		invalidParams.Add(request.NewErrParamRequired("JobPort"))
	}
	if s.JobPort != nil && *s.JobPort < 1 {
		invalidParams.Add(request.NewErrParamMinValue("JobPort", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationPort sets the ApplicationPort field's value.
func (s *PortMapping) SetApplicationPort(v int64) *PortMapping {
	s.ApplicationPort = &v
	return s
}

// SetEnableOnPublicIp sets the EnableOnPublicIp field's value.
func (s *PortMapping) SetEnableOnPublicIp(v bool) *PortMapping {
	s.EnableOnPublicIp = &v
	return s
}

// SetJobPort sets the JobPort field's value.
func (s *PortMapping) SetJobPort(v int64) *PortMapping {
	s.JobPort = &v
	return s
}

// Information about the progress of a deployment job.
type ProgressDetail struct {
	_ struct{} `type:"structure"`

	// The current progress status.
	//
	// Validating
	//
	// Validating the deployment.
	//
	// DownloadingExtracting
	//
	// Downloading and extracting the bundle on the robot.
	//
	// ExecutingPreLaunch
	//
	// Executing pre-launch script(s) if provided.
	//
	// Launching
	//
	// Launching the robot application.
	//
	// ExecutingPostLaunch
	//
	// Executing post-launch script(s) if provided.
	//
	// Finished
	//
	// Deployment is complete.
	CurrentProgress *string `locationName:"currentProgress" type:"string" enum:"RobotDeploymentStep"`

	// Estimated amount of time in seconds remaining in the step. This currently
	// only applies to the Downloading/Extracting step of the deployment. It is
	// empty for other steps.
	EstimatedTimeRemainingSeconds *int64 `locationName:"estimatedTimeRemainingSeconds" type:"integer"`

	// Precentage of the step that is done. This currently only applies to the Downloading/Extracting
	// step of the deployment. It is empty for other steps.
	PercentDone *float64 `locationName:"percentDone" type:"float"`

	// The Amazon Resource Name (ARN) of the deployment job.
	TargetResource *string `locationName:"targetResource" type:"string"`
}

// String returns the string representation
func (s ProgressDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProgressDetail) GoString() string {
	return s.String()
}

// SetCurrentProgress sets the CurrentProgress field's value.
func (s *ProgressDetail) SetCurrentProgress(v string) *ProgressDetail {
	s.CurrentProgress = &v
	return s
}

// SetEstimatedTimeRemainingSeconds sets the EstimatedTimeRemainingSeconds field's value.
func (s *ProgressDetail) SetEstimatedTimeRemainingSeconds(v int64) *ProgressDetail {
	s.EstimatedTimeRemainingSeconds = &v
	return s
}

// SetPercentDone sets the PercentDone field's value.
func (s *ProgressDetail) SetPercentDone(v float64) *ProgressDetail {
	s.PercentDone = &v
	return s
}

// SetTargetResource sets the TargetResource field's value.
func (s *ProgressDetail) SetTargetResource(v string) *ProgressDetail {
	s.TargetResource = &v
	return s
}

type RegisterRobotInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet.
	//
	// Fleet is a required field
	Fleet *string `locationName:"fleet" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the robot.
	//
	// Robot is a required field
	Robot *string `locationName:"robot" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterRobotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterRobotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterRobotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterRobotInput"}
	if s.Fleet == nil {
		invalidParams.Add(request.NewErrParamRequired("Fleet"))
	}
	if s.Fleet != nil && len(*s.Fleet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fleet", 1))
	}
	if s.Robot == nil {
		invalidParams.Add(request.NewErrParamRequired("Robot"))
	}
	if s.Robot != nil && len(*s.Robot) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Robot", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFleet sets the Fleet field's value.
func (s *RegisterRobotInput) SetFleet(v string) *RegisterRobotInput {
	s.Fleet = &v
	return s
}

// SetRobot sets the Robot field's value.
func (s *RegisterRobotInput) SetRobot(v string) *RegisterRobotInput {
	s.Robot = &v
	return s
}

type RegisterRobotOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the fleet that the robot will join.
	Fleet *string `locationName:"fleet" min:"1" type:"string"`

	// Information about the robot registration.
	Robot *string `locationName:"robot" min:"1" type:"string"`
}

// String returns the string representation
func (s RegisterRobotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterRobotOutput) GoString() string {
	return s.String()
}

// SetFleet sets the Fleet field's value.
func (s *RegisterRobotOutput) SetFleet(v string) *RegisterRobotOutput {
	s.Fleet = &v
	return s
}

// SetRobot sets the Robot field's value.
func (s *RegisterRobotOutput) SetRobot(v string) *RegisterRobotOutput {
	s.Robot = &v
	return s
}

// Information about a rendering engine.
type RenderingEngine struct {
	_ struct{} `type:"structure"`

	// The name of the rendering engine.
	Name *string `locationName:"name" type:"string" enum:"RenderingEngineType"`

	// The version of the rendering engine.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s RenderingEngine) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RenderingEngine) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenderingEngine) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RenderingEngine"}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *RenderingEngine) SetName(v string) *RenderingEngine {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *RenderingEngine) SetVersion(v string) *RenderingEngine {
	s.Version = &v
	return s
}

// The specified resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestartSimulationJobInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation job.
	//
	// Job is a required field
	Job *string `locationName:"job" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RestartSimulationJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestartSimulationJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestartSimulationJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestartSimulationJobInput"}
	if s.Job == nil {
		invalidParams.Add(request.NewErrParamRequired("Job"))
	}
	if s.Job != nil && len(*s.Job) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Job", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJob sets the Job field's value.
func (s *RestartSimulationJobInput) SetJob(v string) *RestartSimulationJobInput {
	s.Job = &v
	return s
}

type RestartSimulationJobOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestartSimulationJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestartSimulationJobOutput) GoString() string {
	return s.String()
}

// Information about a robot.
type Robot struct {
	_ struct{} `type:"structure"`

	// The architecture of the robot.
	Architecture *string `locationName:"architecture" type:"string" enum:"Architecture"`

	// The Amazon Resource Name (ARN) of the robot.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (ARN) of the fleet.
	FleetArn *string `locationName:"fleetArn" min:"1" type:"string"`

	// The Greengrass group associated with the robot.
	GreenGrassGroupId *string `locationName:"greenGrassGroupId" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the last deployment job.
	LastDeploymentJob *string `locationName:"lastDeploymentJob" min:"1" type:"string"`

	// The time of the last deployment.
	LastDeploymentTime *time.Time `locationName:"lastDeploymentTime" type:"timestamp"`

	// The name of the robot.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The status of the robot.
	Status *string `locationName:"status" type:"string" enum:"RobotStatus"`
}

// String returns the string representation
func (s Robot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Robot) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *Robot) SetArchitecture(v string) *Robot {
	s.Architecture = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *Robot) SetArn(v string) *Robot {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Robot) SetCreatedAt(v time.Time) *Robot {
	s.CreatedAt = &v
	return s
}

// SetFleetArn sets the FleetArn field's value.
func (s *Robot) SetFleetArn(v string) *Robot {
	s.FleetArn = &v
	return s
}

// SetGreenGrassGroupId sets the GreenGrassGroupId field's value.
func (s *Robot) SetGreenGrassGroupId(v string) *Robot {
	s.GreenGrassGroupId = &v
	return s
}

// SetLastDeploymentJob sets the LastDeploymentJob field's value.
func (s *Robot) SetLastDeploymentJob(v string) *Robot {
	s.LastDeploymentJob = &v
	return s
}

// SetLastDeploymentTime sets the LastDeploymentTime field's value.
func (s *Robot) SetLastDeploymentTime(v time.Time) *Robot {
	s.LastDeploymentTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Robot) SetName(v string) *Robot {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Robot) SetStatus(v string) *Robot {
	s.Status = &v
	return s
}

// Application configuration information for a robot.
type RobotApplicationConfig struct {
	_ struct{} `type:"structure"`

	// The application information for the robot application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the robot application.
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string"`

	// The launch configuration for the robot application.
	//
	// LaunchConfig is a required field
	LaunchConfig *LaunchConfig `locationName:"launchConfig" type:"structure" required:"true"`

	// Information about tools configured for the robot application.
	Tools []*Tool `locationName:"tools" type:"list"`

	// The upload configurations for the robot application.
	UploadConfigurations []*UploadConfiguration `locationName:"uploadConfigurations" type:"list"`

	// A Boolean indicating whether to use default robot application tools. The
	// default tools are rviz, rqt, terminal and rosbag record. The default is False.
	UseDefaultTools *bool `locationName:"useDefaultTools" type:"boolean"`

	// A Boolean indicating whether to use default upload configurations. By default,
	// .ros and .gazebo files are uploaded when the application terminates and all
	// ROS topics will be recorded.
	//
	// If you set this value, you must specify an outputLocation.
	UseDefaultUploadConfigurations *bool `locationName:"useDefaultUploadConfigurations" type:"boolean"`
}

// String returns the string representation
func (s RobotApplicationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RobotApplicationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RobotApplicationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RobotApplicationConfig"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationVersion", 1))
	}
	if s.LaunchConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchConfig"))
	}
	if s.LaunchConfig != nil {
		if err := s.LaunchConfig.Validate(); err != nil {
			invalidParams.AddNested("LaunchConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tools != nil {
		for i, v := range s.Tools {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tools", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UploadConfigurations != nil {
		for i, v := range s.UploadConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UploadConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *RobotApplicationConfig) SetApplication(v string) *RobotApplicationConfig {
	s.Application = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *RobotApplicationConfig) SetApplicationVersion(v string) *RobotApplicationConfig {
	s.ApplicationVersion = &v
	return s
}

// SetLaunchConfig sets the LaunchConfig field's value.
func (s *RobotApplicationConfig) SetLaunchConfig(v *LaunchConfig) *RobotApplicationConfig {
	s.LaunchConfig = v
	return s
}

// SetTools sets the Tools field's value.
func (s *RobotApplicationConfig) SetTools(v []*Tool) *RobotApplicationConfig {
	s.Tools = v
	return s
}

// SetUploadConfigurations sets the UploadConfigurations field's value.
func (s *RobotApplicationConfig) SetUploadConfigurations(v []*UploadConfiguration) *RobotApplicationConfig {
	s.UploadConfigurations = v
	return s
}

// SetUseDefaultTools sets the UseDefaultTools field's value.
func (s *RobotApplicationConfig) SetUseDefaultTools(v bool) *RobotApplicationConfig {
	s.UseDefaultTools = &v
	return s
}

// SetUseDefaultUploadConfigurations sets the UseDefaultUploadConfigurations field's value.
func (s *RobotApplicationConfig) SetUseDefaultUploadConfigurations(v bool) *RobotApplicationConfig {
	s.UseDefaultUploadConfigurations = &v
	return s
}

// Summary information for a robot application.
type RobotApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the robot.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot application was
	// last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the robot application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Information about a robot software suite (ROS distribution).
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The version of the robot application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s RobotApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RobotApplicationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RobotApplicationSummary) SetArn(v string) *RobotApplicationSummary {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *RobotApplicationSummary) SetLastUpdatedAt(v time.Time) *RobotApplicationSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *RobotApplicationSummary) SetName(v string) *RobotApplicationSummary {
	s.Name = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *RobotApplicationSummary) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *RobotApplicationSummary {
	s.RobotSoftwareSuite = v
	return s
}

// SetVersion sets the Version field's value.
func (s *RobotApplicationSummary) SetVersion(v string) *RobotApplicationSummary {
	s.Version = &v
	return s
}

// Information about a robot deployment.
type RobotDeployment struct {
	_ struct{} `type:"structure"`

	// The robot deployment Amazon Resource Name (ARN).
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the deployment finished.
	DeploymentFinishTime *time.Time `locationName:"deploymentFinishTime" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the deployment was started.
	DeploymentStartTime *time.Time `locationName:"deploymentStartTime" type:"timestamp"`

	// The robot deployment failure code.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"DeploymentJobErrorCode"`

	// A short description of the reason why the robot deployment failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// Information about how the deployment is progressing.
	ProgressDetail *ProgressDetail `locationName:"progressDetail" type:"structure"`

	// The status of the robot deployment.
	Status *string `locationName:"status" type:"string" enum:"RobotStatus"`
}

// String returns the string representation
func (s RobotDeployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RobotDeployment) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *RobotDeployment) SetArn(v string) *RobotDeployment {
	s.Arn = &v
	return s
}

// SetDeploymentFinishTime sets the DeploymentFinishTime field's value.
func (s *RobotDeployment) SetDeploymentFinishTime(v time.Time) *RobotDeployment {
	s.DeploymentFinishTime = &v
	return s
}

// SetDeploymentStartTime sets the DeploymentStartTime field's value.
func (s *RobotDeployment) SetDeploymentStartTime(v time.Time) *RobotDeployment {
	s.DeploymentStartTime = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *RobotDeployment) SetFailureCode(v string) *RobotDeployment {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *RobotDeployment) SetFailureReason(v string) *RobotDeployment {
	s.FailureReason = &v
	return s
}

// SetProgressDetail sets the ProgressDetail field's value.
func (s *RobotDeployment) SetProgressDetail(v *ProgressDetail) *RobotDeployment {
	s.ProgressDetail = v
	return s
}

// SetStatus sets the Status field's value.
func (s *RobotDeployment) SetStatus(v string) *RobotDeployment {
	s.Status = &v
	return s
}

// Information about a robot software suite (ROS distribution).
type RobotSoftwareSuite struct {
	_ struct{} `type:"structure"`

	// The name of the robot software suite (ROS distribution).
	Name *string `locationName:"name" type:"string" enum:"RobotSoftwareSuiteType"`

	// The version of the robot software suite (ROS distribution).
	Version *string `locationName:"version" type:"string" enum:"RobotSoftwareSuiteVersionType"`
}

// String returns the string representation
func (s RobotSoftwareSuite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RobotSoftwareSuite) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RobotSoftwareSuite) SetName(v string) *RobotSoftwareSuite {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *RobotSoftwareSuite) SetVersion(v string) *RobotSoftwareSuite {
	s.Version = &v
	return s
}

// Information about S3 keys.
type S3KeyOutput struct {
	_ struct{} `type:"structure"`

	// The etag for the object.
	Etag *string `locationName:"etag" type:"string"`

	// The S3 key.
	S3Key *string `locationName:"s3Key" min:"1" type:"string"`
}

// String returns the string representation
func (s S3KeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3KeyOutput) GoString() string {
	return s.String()
}

// SetEtag sets the Etag field's value.
func (s *S3KeyOutput) SetEtag(v string) *S3KeyOutput {
	s.Etag = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *S3KeyOutput) SetS3Key(v string) *S3KeyOutput {
	s.S3Key = &v
	return s
}

// Information about an S3 object.
type S3Object struct {
	_ struct{} `type:"structure"`

	// The bucket containing the object.
	//
	// Bucket is a required field
	Bucket *string `locationName:"bucket" min:"3" type:"string" required:"true"`

	// The etag of the object.
	Etag *string `locationName:"etag" type:"string"`

	// The key of the object.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s S3Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Object) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Object) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Object"}
	if s.Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("Bucket"))
	}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Object) SetBucket(v string) *S3Object {
	s.Bucket = &v
	return s
}

// SetEtag sets the Etag field's value.
func (s *S3Object) SetEtag(v string) *S3Object {
	s.Etag = &v
	return s
}

// SetKey sets the Key field's value.
func (s *S3Object) SetKey(v string) *S3Object {
	s.Key = &v
	return s
}

// The request has failed due to a temporary failure of the server.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a simulation application configuration.
type SimulationApplicationConfig struct {
	_ struct{} `type:"structure"`

	// The application information for the simulation application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The version of the simulation application.
	ApplicationVersion *string `locationName:"applicationVersion" min:"1" type:"string"`

	// The launch configuration for the simulation application.
	//
	// LaunchConfig is a required field
	LaunchConfig *LaunchConfig `locationName:"launchConfig" type:"structure" required:"true"`

	// Information about tools configured for the simulation application.
	Tools []*Tool `locationName:"tools" type:"list"`

	// Information about upload configurations for the simulation application.
	UploadConfigurations []*UploadConfiguration `locationName:"uploadConfigurations" type:"list"`

	// A Boolean indicating whether to use default simulation application tools.
	// The default tools are rviz, rqt, terminal and rosbag record. The default
	// is False.
	UseDefaultTools *bool `locationName:"useDefaultTools" type:"boolean"`

	// A Boolean indicating whether to use default upload configurations. By default,
	// .ros and .gazebo files are uploaded when the application terminates and all
	// ROS topics will be recorded.
	//
	// If you set this value, you must specify an outputLocation.
	UseDefaultUploadConfigurations *bool `locationName:"useDefaultUploadConfigurations" type:"boolean"`

	// A list of world configurations.
	WorldConfigs []*WorldConfig `locationName:"worldConfigs" type:"list"`
}

// String returns the string representation
func (s SimulationApplicationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulationApplicationConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SimulationApplicationConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SimulationApplicationConfig"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.ApplicationVersion != nil && len(*s.ApplicationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApplicationVersion", 1))
	}
	if s.LaunchConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("LaunchConfig"))
	}
	if s.LaunchConfig != nil {
		if err := s.LaunchConfig.Validate(); err != nil {
			invalidParams.AddNested("LaunchConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tools != nil {
		for i, v := range s.Tools {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tools", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UploadConfigurations != nil {
		for i, v := range s.UploadConfigurations {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "UploadConfigurations", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.WorldConfigs != nil {
		for i, v := range s.WorldConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "WorldConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *SimulationApplicationConfig) SetApplication(v string) *SimulationApplicationConfig {
	s.Application = &v
	return s
}

// SetApplicationVersion sets the ApplicationVersion field's value.
func (s *SimulationApplicationConfig) SetApplicationVersion(v string) *SimulationApplicationConfig {
	s.ApplicationVersion = &v
	return s
}

// SetLaunchConfig sets the LaunchConfig field's value.
func (s *SimulationApplicationConfig) SetLaunchConfig(v *LaunchConfig) *SimulationApplicationConfig {
	s.LaunchConfig = v
	return s
}

// SetTools sets the Tools field's value.
func (s *SimulationApplicationConfig) SetTools(v []*Tool) *SimulationApplicationConfig {
	s.Tools = v
	return s
}

// SetUploadConfigurations sets the UploadConfigurations field's value.
func (s *SimulationApplicationConfig) SetUploadConfigurations(v []*UploadConfiguration) *SimulationApplicationConfig {
	s.UploadConfigurations = v
	return s
}

// SetUseDefaultTools sets the UseDefaultTools field's value.
func (s *SimulationApplicationConfig) SetUseDefaultTools(v bool) *SimulationApplicationConfig {
	s.UseDefaultTools = &v
	return s
}

// SetUseDefaultUploadConfigurations sets the UseDefaultUploadConfigurations field's value.
func (s *SimulationApplicationConfig) SetUseDefaultUploadConfigurations(v bool) *SimulationApplicationConfig {
	s.UseDefaultUploadConfigurations = &v
	return s
}

// SetWorldConfigs sets the WorldConfigs field's value.
func (s *SimulationApplicationConfig) SetWorldConfigs(v []*WorldConfig) *SimulationApplicationConfig {
	s.WorldConfigs = v
	return s
}

// Summary information for a simulation application.
type SimulationApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation application
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the simulation application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Information about a robot software suite (ROS distribution).
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// Information about a simulation software suite.
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure"`

	// The version of the simulation application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s SimulationApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulationApplicationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SimulationApplicationSummary) SetArn(v string) *SimulationApplicationSummary {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *SimulationApplicationSummary) SetLastUpdatedAt(v time.Time) *SimulationApplicationSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *SimulationApplicationSummary) SetName(v string) *SimulationApplicationSummary {
	s.Name = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *SimulationApplicationSummary) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *SimulationApplicationSummary {
	s.RobotSoftwareSuite = v
	return s
}

// SetSimulationSoftwareSuite sets the SimulationSoftwareSuite field's value.
func (s *SimulationApplicationSummary) SetSimulationSoftwareSuite(v *SimulationSoftwareSuite) *SimulationApplicationSummary {
	s.SimulationSoftwareSuite = v
	return s
}

// SetVersion sets the Version field's value.
func (s *SimulationApplicationSummary) SetVersion(v string) *SimulationApplicationSummary {
	s.Version = &v
	return s
}

// Information about a simulation job.
type SimulationJob struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// A unique identifier for this SimulationJob request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// Compute information for the simulation job
	Compute *ComputeResponse `locationName:"compute" type:"structure"`

	// The data sources for the simulation job.
	DataSources []*DataSource `locationName:"dataSources" type:"list"`

	// The failure behavior the simulation job.
	//
	// Continue
	//
	// Restart the simulation job in the same host instance.
	//
	// Fail
	//
	// Stop the simulation job and terminate the instance.
	FailureBehavior *string `locationName:"failureBehavior" type:"string" enum:"FailureBehavior"`

	// The failure code of the simulation job if it failed.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"SimulationJobErrorCode"`

	// The reason why the simulation job failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The IAM role that allows the simulation instance to call the AWS APIs that
	// are specified in its associated policies on your behalf. This is how credentials
	// are passed in to your simulation job.
	IamRole *string `locationName:"iamRole" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// started.
	LastStartedAt *time.Time `locationName:"lastStartedAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The logging configuration.
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure"`

	// The maximum simulation job duration in seconds. The value must be 8 days
	// (691,200 seconds) or less.
	MaxJobDurationInSeconds *int64 `locationName:"maxJobDurationInSeconds" type:"long"`

	// The name of the simulation job.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Information about a network interface.
	NetworkInterface *NetworkInterface `locationName:"networkInterface" type:"structure"`

	// Location for output files generated by the simulation job.
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure"`

	// A list of robot applications.
	RobotApplications []*RobotApplicationConfig `locationName:"robotApplications" min:"1" type:"list"`

	// A list of simulation applications.
	SimulationApplications []*SimulationApplicationConfig `locationName:"simulationApplications" min:"1" type:"list"`

	// The simulation job execution duration in milliseconds.
	SimulationTimeMillis *int64 `locationName:"simulationTimeMillis" type:"long"`

	// Status of the simulation job.
	Status *string `locationName:"status" type:"string" enum:"SimulationJobStatus"`

	// A map that contains tag keys and tag values that are attached to the simulation
	// job.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// VPC configuration information.
	VpcConfig *VPCConfigResponse `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s SimulationJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulationJob) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SimulationJob) SetArn(v string) *SimulationJob {
	s.Arn = &v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *SimulationJob) SetClientRequestToken(v string) *SimulationJob {
	s.ClientRequestToken = &v
	return s
}

// SetCompute sets the Compute field's value.
func (s *SimulationJob) SetCompute(v *ComputeResponse) *SimulationJob {
	s.Compute = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *SimulationJob) SetDataSources(v []*DataSource) *SimulationJob {
	s.DataSources = v
	return s
}

// SetFailureBehavior sets the FailureBehavior field's value.
func (s *SimulationJob) SetFailureBehavior(v string) *SimulationJob {
	s.FailureBehavior = &v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *SimulationJob) SetFailureCode(v string) *SimulationJob {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *SimulationJob) SetFailureReason(v string) *SimulationJob {
	s.FailureReason = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *SimulationJob) SetIamRole(v string) *SimulationJob {
	s.IamRole = &v
	return s
}

// SetLastStartedAt sets the LastStartedAt field's value.
func (s *SimulationJob) SetLastStartedAt(v time.Time) *SimulationJob {
	s.LastStartedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *SimulationJob) SetLastUpdatedAt(v time.Time) *SimulationJob {
	s.LastUpdatedAt = &v
	return s
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *SimulationJob) SetLoggingConfig(v *LoggingConfig) *SimulationJob {
	s.LoggingConfig = v
	return s
}

// SetMaxJobDurationInSeconds sets the MaxJobDurationInSeconds field's value.
func (s *SimulationJob) SetMaxJobDurationInSeconds(v int64) *SimulationJob {
	s.MaxJobDurationInSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *SimulationJob) SetName(v string) *SimulationJob {
	s.Name = &v
	return s
}

// SetNetworkInterface sets the NetworkInterface field's value.
func (s *SimulationJob) SetNetworkInterface(v *NetworkInterface) *SimulationJob {
	s.NetworkInterface = v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *SimulationJob) SetOutputLocation(v *OutputLocation) *SimulationJob {
	s.OutputLocation = v
	return s
}

// SetRobotApplications sets the RobotApplications field's value.
func (s *SimulationJob) SetRobotApplications(v []*RobotApplicationConfig) *SimulationJob {
	s.RobotApplications = v
	return s
}

// SetSimulationApplications sets the SimulationApplications field's value.
func (s *SimulationJob) SetSimulationApplications(v []*SimulationApplicationConfig) *SimulationJob {
	s.SimulationApplications = v
	return s
}

// SetSimulationTimeMillis sets the SimulationTimeMillis field's value.
func (s *SimulationJob) SetSimulationTimeMillis(v int64) *SimulationJob {
	s.SimulationTimeMillis = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SimulationJob) SetStatus(v string) *SimulationJob {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *SimulationJob) SetTags(v map[string]*string) *SimulationJob {
	s.Tags = v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *SimulationJob) SetVpcConfig(v *VPCConfigResponse) *SimulationJob {
	s.VpcConfig = v
	return s
}

// Information about a simulation job batch.
type SimulationJobBatchSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the batch.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The number of created simulation job requests.
	CreatedRequestCount *int64 `locationName:"createdRequestCount" type:"integer"`

	// The number of failed simulation job requests.
	FailedRequestCount *int64 `locationName:"failedRequestCount" type:"integer"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The number of pending simulation job requests.
	PendingRequestCount *int64 `locationName:"pendingRequestCount" type:"integer"`

	// The status of the simulation job batch.
	//
	// Pending
	//
	// The simulation job batch request is pending.
	//
	// InProgress
	//
	// The simulation job batch is in progress.
	//
	// Failed
	//
	// The simulation job batch failed. One or more simulation job requests could
	// not be completed due to an internal failure (like InternalServiceError).
	// See failureCode and failureReason for more information.
	//
	// Completed
	//
	// The simulation batch job completed. A batch is complete when (1) there are
	// no pending simulation job requests in the batch and none of the failed simulation
	// job requests are due to InternalServiceError and (2) when all created simulation
	// jobs have reached a terminal state (for example, Completed or Failed).
	//
	// Canceled
	//
	// The simulation batch job was cancelled.
	//
	// Canceling
	//
	// The simulation batch job is being cancelled.
	//
	// Completing
	//
	// The simulation batch job is completing.
	//
	// TimingOut
	//
	// The simulation job batch is timing out.
	//
	// If a batch timing out, and there are pending requests that were failing due
	// to an internal failure (like InternalServiceError), the batch status will
	// be Failed. If there are no such failing request, the batch status will be
	// TimedOut.
	//
	// TimedOut
	//
	// The simulation batch job timed out.
	Status *string `locationName:"status" type:"string" enum:"SimulationJobBatchStatus"`
}

// String returns the string representation
func (s SimulationJobBatchSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulationJobBatchSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SimulationJobBatchSummary) SetArn(v string) *SimulationJobBatchSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SimulationJobBatchSummary) SetCreatedAt(v time.Time) *SimulationJobBatchSummary {
	s.CreatedAt = &v
	return s
}

// SetCreatedRequestCount sets the CreatedRequestCount field's value.
func (s *SimulationJobBatchSummary) SetCreatedRequestCount(v int64) *SimulationJobBatchSummary {
	s.CreatedRequestCount = &v
	return s
}

// SetFailedRequestCount sets the FailedRequestCount field's value.
func (s *SimulationJobBatchSummary) SetFailedRequestCount(v int64) *SimulationJobBatchSummary {
	s.FailedRequestCount = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *SimulationJobBatchSummary) SetLastUpdatedAt(v time.Time) *SimulationJobBatchSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetPendingRequestCount sets the PendingRequestCount field's value.
func (s *SimulationJobBatchSummary) SetPendingRequestCount(v int64) *SimulationJobBatchSummary {
	s.PendingRequestCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SimulationJobBatchSummary) SetStatus(v string) *SimulationJobBatchSummary {
	s.Status = &v
	return s
}

// Information about a simulation job request.
type SimulationJobRequest struct {
	_ struct{} `type:"structure"`

	// Compute information for the simulation job
	Compute *Compute `locationName:"compute" type:"structure"`

	// Specify data sources to mount read-only files from S3 into your simulation.
	// These files are available under /opt/robomaker/datasources/data_source_name.
	//
	// There is a limit of 100 files and a combined size of 25GB for all DataSourceConfig
	// objects.
	DataSources []*DataSourceConfig `locationName:"dataSources" min:"1" type:"list"`

	// The failure behavior the simulation job.
	//
	// Continue
	//
	// Restart the simulation job in the same host instance.
	//
	// Fail
	//
	// Stop the simulation job and terminate the instance.
	FailureBehavior *string `locationName:"failureBehavior" type:"string" enum:"FailureBehavior"`

	// The IAM role name that allows the simulation instance to call the AWS APIs
	// that are specified in its associated policies on your behalf. This is how
	// credentials are passed in to your simulation job.
	IamRole *string `locationName:"iamRole" min:"1" type:"string"`

	// The logging configuration.
	LoggingConfig *LoggingConfig `locationName:"loggingConfig" type:"structure"`

	// The maximum simulation job duration in seconds. The value must be 8 days
	// (691,200 seconds) or less.
	//
	// MaxJobDurationInSeconds is a required field
	MaxJobDurationInSeconds *int64 `locationName:"maxJobDurationInSeconds" type:"long" required:"true"`

	// The output location.
	OutputLocation *OutputLocation `locationName:"outputLocation" type:"structure"`

	// The robot applications to use in the simulation job.
	RobotApplications []*RobotApplicationConfig `locationName:"robotApplications" min:"1" type:"list"`

	// The simulation applications to use in the simulation job.
	SimulationApplications []*SimulationApplicationConfig `locationName:"simulationApplications" min:"1" type:"list"`

	// A map that contains tag keys and tag values that are attached to the simulation
	// job request.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A Boolean indicating whether to use default applications in the simulation
	// job. Default applications include Gazebo, rqt, rviz and terminal access.
	UseDefaultApplications *bool `locationName:"useDefaultApplications" type:"boolean"`

	// If your simulation job accesses resources in a VPC, you provide this parameter
	// identifying the list of security group IDs and subnet IDs. These must belong
	// to the same VPC. You must provide at least one security group and two subnet
	// IDs.
	VpcConfig *VPCConfig `locationName:"vpcConfig" type:"structure"`
}

// String returns the string representation
func (s SimulationJobRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulationJobRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SimulationJobRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SimulationJobRequest"}
	if s.DataSources != nil && len(s.DataSources) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataSources", 1))
	}
	if s.IamRole != nil && len(*s.IamRole) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IamRole", 1))
	}
	if s.MaxJobDurationInSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxJobDurationInSeconds"))
	}
	if s.RobotApplications != nil && len(s.RobotApplications) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RobotApplications", 1))
	}
	if s.SimulationApplications != nil && len(s.SimulationApplications) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SimulationApplications", 1))
	}
	if s.Compute != nil {
		if err := s.Compute.Validate(); err != nil {
			invalidParams.AddNested("Compute", err.(request.ErrInvalidParams))
		}
	}
	if s.DataSources != nil {
		for i, v := range s.DataSources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DataSources", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.LoggingConfig != nil {
		if err := s.LoggingConfig.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputLocation != nil {
		if err := s.OutputLocation.Validate(); err != nil {
			invalidParams.AddNested("OutputLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.RobotApplications != nil {
		for i, v := range s.RobotApplications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RobotApplications", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.SimulationApplications != nil {
		for i, v := range s.SimulationApplications {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "SimulationApplications", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCompute sets the Compute field's value.
func (s *SimulationJobRequest) SetCompute(v *Compute) *SimulationJobRequest {
	s.Compute = v
	return s
}

// SetDataSources sets the DataSources field's value.
func (s *SimulationJobRequest) SetDataSources(v []*DataSourceConfig) *SimulationJobRequest {
	s.DataSources = v
	return s
}

// SetFailureBehavior sets the FailureBehavior field's value.
func (s *SimulationJobRequest) SetFailureBehavior(v string) *SimulationJobRequest {
	s.FailureBehavior = &v
	return s
}

// SetIamRole sets the IamRole field's value.
func (s *SimulationJobRequest) SetIamRole(v string) *SimulationJobRequest {
	s.IamRole = &v
	return s
}

// SetLoggingConfig sets the LoggingConfig field's value.
func (s *SimulationJobRequest) SetLoggingConfig(v *LoggingConfig) *SimulationJobRequest {
	s.LoggingConfig = v
	return s
}

// SetMaxJobDurationInSeconds sets the MaxJobDurationInSeconds field's value.
func (s *SimulationJobRequest) SetMaxJobDurationInSeconds(v int64) *SimulationJobRequest {
	s.MaxJobDurationInSeconds = &v
	return s
}

// SetOutputLocation sets the OutputLocation field's value.
func (s *SimulationJobRequest) SetOutputLocation(v *OutputLocation) *SimulationJobRequest {
	s.OutputLocation = v
	return s
}

// SetRobotApplications sets the RobotApplications field's value.
func (s *SimulationJobRequest) SetRobotApplications(v []*RobotApplicationConfig) *SimulationJobRequest {
	s.RobotApplications = v
	return s
}

// SetSimulationApplications sets the SimulationApplications field's value.
func (s *SimulationJobRequest) SetSimulationApplications(v []*SimulationApplicationConfig) *SimulationJobRequest {
	s.SimulationApplications = v
	return s
}

// SetTags sets the Tags field's value.
func (s *SimulationJobRequest) SetTags(v map[string]*string) *SimulationJobRequest {
	s.Tags = v
	return s
}

// SetUseDefaultApplications sets the UseDefaultApplications field's value.
func (s *SimulationJobRequest) SetUseDefaultApplications(v bool) *SimulationJobRequest {
	s.UseDefaultApplications = &v
	return s
}

// SetVpcConfig sets the VpcConfig field's value.
func (s *SimulationJobRequest) SetVpcConfig(v *VPCConfig) *SimulationJobRequest {
	s.VpcConfig = v
	return s
}

// Summary information for a simulation job.
type SimulationJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the simulation job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The names of the data sources.
	DataSourceNames []*string `locationName:"dataSourceNames" type:"list"`

	// The time, in milliseconds since the epoch, when the simulation job was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the simulation job.
	Name *string `locationName:"name" min:"1" type:"string"`

	// A list of simulation job robot application names.
	RobotApplicationNames []*string `locationName:"robotApplicationNames" type:"list"`

	// A list of simulation job simulation application names.
	SimulationApplicationNames []*string `locationName:"simulationApplicationNames" type:"list"`

	// The status of the simulation job.
	Status *string `locationName:"status" type:"string" enum:"SimulationJobStatus"`
}

// String returns the string representation
func (s SimulationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulationJobSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SimulationJobSummary) SetArn(v string) *SimulationJobSummary {
	s.Arn = &v
	return s
}

// SetDataSourceNames sets the DataSourceNames field's value.
func (s *SimulationJobSummary) SetDataSourceNames(v []*string) *SimulationJobSummary {
	s.DataSourceNames = v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *SimulationJobSummary) SetLastUpdatedAt(v time.Time) *SimulationJobSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *SimulationJobSummary) SetName(v string) *SimulationJobSummary {
	s.Name = &v
	return s
}

// SetRobotApplicationNames sets the RobotApplicationNames field's value.
func (s *SimulationJobSummary) SetRobotApplicationNames(v []*string) *SimulationJobSummary {
	s.RobotApplicationNames = v
	return s
}

// SetSimulationApplicationNames sets the SimulationApplicationNames field's value.
func (s *SimulationJobSummary) SetSimulationApplicationNames(v []*string) *SimulationJobSummary {
	s.SimulationApplicationNames = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SimulationJobSummary) SetStatus(v string) *SimulationJobSummary {
	s.Status = &v
	return s
}

// Information about a simulation software suite.
type SimulationSoftwareSuite struct {
	_ struct{} `type:"structure"`

	// The name of the simulation software suite.
	Name *string `locationName:"name" type:"string" enum:"SimulationSoftwareSuiteType"`

	// The version of the simulation software suite.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s SimulationSoftwareSuite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SimulationSoftwareSuite) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SimulationSoftwareSuite) SetName(v string) *SimulationSoftwareSuite {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *SimulationSoftwareSuite) SetVersion(v string) *SimulationSoftwareSuite {
	s.Version = &v
	return s
}

// Information about a source.
type Source struct {
	_ struct{} `type:"structure"`

	// The taget processor architecture for the application.
	Architecture *string `locationName:"architecture" type:"string" enum:"Architecture"`

	// A hash of the object specified by s3Bucket and s3Key.
	Etag *string `locationName:"etag" type:"string"`

	// The s3 bucket name.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The s3 object key.
	S3Key *string `locationName:"s3Key" min:"1" type:"string"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Source) GoString() string {
	return s.String()
}

// SetArchitecture sets the Architecture field's value.
func (s *Source) SetArchitecture(v string) *Source {
	s.Architecture = &v
	return s
}

// SetEtag sets the Etag field's value.
func (s *Source) SetEtag(v string) *Source {
	s.Etag = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *Source) SetS3Bucket(v string) *Source {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *Source) SetS3Key(v string) *Source {
	s.S3Key = &v
	return s
}

// Information about a source configuration.
type SourceConfig struct {
	_ struct{} `type:"structure"`

	// The target processor architecture for the application.
	Architecture *string `locationName:"architecture" type:"string" enum:"Architecture"`

	// The Amazon S3 bucket name.
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string"`

	// The s3 object key.
	S3Key *string `locationName:"s3Key" min:"1" type:"string"`
}

// String returns the string representation
func (s SourceConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SourceConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SourceConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SourceConfig"}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetArchitecture sets the Architecture field's value.
func (s *SourceConfig) SetArchitecture(v string) *SourceConfig {
	s.Architecture = &v
	return s
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *SourceConfig) SetS3Bucket(v string) *SourceConfig {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *SourceConfig) SetS3Key(v string) *SourceConfig {
	s.S3Key = &v
	return s
}

type StartSimulationJobBatchInput struct {
	_ struct{} `type:"structure"`

	// The batch policy.
	BatchPolicy *BatchPolicy `locationName:"batchPolicy" type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// A list of simulation job requests to create in the batch.
	//
	// CreateSimulationJobRequests is a required field
	CreateSimulationJobRequests []*SimulationJobRequest `locationName:"createSimulationJobRequests" min:"1" type:"list" required:"true"`

	// A map that contains tag keys and tag values that are attached to the deployment
	// job batch.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StartSimulationJobBatchInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSimulationJobBatchInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartSimulationJobBatchInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartSimulationJobBatchInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.CreateSimulationJobRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("CreateSimulationJobRequests"))
	}
	if s.CreateSimulationJobRequests != nil && len(s.CreateSimulationJobRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CreateSimulationJobRequests", 1))
	}
	if s.CreateSimulationJobRequests != nil {
		for i, v := range s.CreateSimulationJobRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "CreateSimulationJobRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBatchPolicy sets the BatchPolicy field's value.
func (s *StartSimulationJobBatchInput) SetBatchPolicy(v *BatchPolicy) *StartSimulationJobBatchInput {
	s.BatchPolicy = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartSimulationJobBatchInput) SetClientRequestToken(v string) *StartSimulationJobBatchInput {
	s.ClientRequestToken = &v
	return s
}

// SetCreateSimulationJobRequests sets the CreateSimulationJobRequests field's value.
func (s *StartSimulationJobBatchInput) SetCreateSimulationJobRequests(v []*SimulationJobRequest) *StartSimulationJobBatchInput {
	s.CreateSimulationJobRequests = v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartSimulationJobBatchInput) SetTags(v map[string]*string) *StartSimulationJobBatchInput {
	s.Tags = v
	return s
}

type StartSimulationJobBatchOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the batch.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The batch policy.
	BatchPolicy *BatchPolicy `locationName:"batchPolicy" type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation job batch
	// was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// A list of created simulation job request summaries.
	CreatedRequests []*SimulationJobSummary `locationName:"createdRequests" type:"list"`

	// A list of failed simulation job requests. The request failed to be created
	// into a simulation job. Failed requests do not have a simulation job ID.
	FailedRequests []*FailedCreateSimulationJobRequest `locationName:"failedRequests" type:"list"`

	// The failure code if the simulation job batch failed.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"SimulationJobBatchErrorCode"`

	// The reason the simulation job batch failed.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// A list of pending simulation job requests. These requests have not yet been
	// created into simulation jobs.
	PendingRequests []*SimulationJobRequest `locationName:"pendingRequests" min:"1" type:"list"`

	// The status of the simulation job batch.
	//
	// Pending
	//
	// The simulation job batch request is pending.
	//
	// InProgress
	//
	// The simulation job batch is in progress.
	//
	// Failed
	//
	// The simulation job batch failed. One or more simulation job requests could
	// not be completed due to an internal failure (like InternalServiceError).
	// See failureCode and failureReason for more information.
	//
	// Completed
	//
	// The simulation batch job completed. A batch is complete when (1) there are
	// no pending simulation job requests in the batch and none of the failed simulation
	// job requests are due to InternalServiceError and (2) when all created simulation
	// jobs have reached a terminal state (for example, Completed or Failed).
	//
	// Canceled
	//
	// The simulation batch job was cancelled.
	//
	// Canceling
	//
	// The simulation batch job is being cancelled.
	//
	// Completing
	//
	// The simulation batch job is completing.
	//
	// TimingOut
	//
	// The simulation job batch is timing out.
	//
	// If a batch timing out, and there are pending requests that were failing due
	// to an internal failure (like InternalServiceError), the batch status will
	// be Failed. If there are no such failing request, the batch status will be
	// TimedOut.
	//
	// TimedOut
	//
	// The simulation batch job timed out.
	Status *string `locationName:"status" type:"string" enum:"SimulationJobBatchStatus"`

	// A map that contains tag keys and tag values that are attached to the deployment
	// job batch.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation
func (s StartSimulationJobBatchOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartSimulationJobBatchOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *StartSimulationJobBatchOutput) SetArn(v string) *StartSimulationJobBatchOutput {
	s.Arn = &v
	return s
}

// SetBatchPolicy sets the BatchPolicy field's value.
func (s *StartSimulationJobBatchOutput) SetBatchPolicy(v *BatchPolicy) *StartSimulationJobBatchOutput {
	s.BatchPolicy = v
	return s
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartSimulationJobBatchOutput) SetClientRequestToken(v string) *StartSimulationJobBatchOutput {
	s.ClientRequestToken = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *StartSimulationJobBatchOutput) SetCreatedAt(v time.Time) *StartSimulationJobBatchOutput {
	s.CreatedAt = &v
	return s
}

// SetCreatedRequests sets the CreatedRequests field's value.
func (s *StartSimulationJobBatchOutput) SetCreatedRequests(v []*SimulationJobSummary) *StartSimulationJobBatchOutput {
	s.CreatedRequests = v
	return s
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StartSimulationJobBatchOutput) SetFailedRequests(v []*FailedCreateSimulationJobRequest) *StartSimulationJobBatchOutput {
	s.FailedRequests = v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *StartSimulationJobBatchOutput) SetFailureCode(v string) *StartSimulationJobBatchOutput {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *StartSimulationJobBatchOutput) SetFailureReason(v string) *StartSimulationJobBatchOutput {
	s.FailureReason = &v
	return s
}

// SetPendingRequests sets the PendingRequests field's value.
func (s *StartSimulationJobBatchOutput) SetPendingRequests(v []*SimulationJobRequest) *StartSimulationJobBatchOutput {
	s.PendingRequests = v
	return s
}

// SetStatus sets the Status field's value.
func (s *StartSimulationJobBatchOutput) SetStatus(v string) *StartSimulationJobBatchOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *StartSimulationJobBatchOutput) SetTags(v map[string]*string) *StartSimulationJobBatchOutput {
	s.Tags = v
	return s
}

type SyncDeploymentJobInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" min:"1" type:"string" idempotencyToken:"true"`

	// The target fleet for the synchronization.
	//
	// Fleet is a required field
	Fleet *string `locationName:"fleet" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SyncDeploymentJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SyncDeploymentJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SyncDeploymentJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SyncDeploymentJobInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.Fleet == nil {
		invalidParams.Add(request.NewErrParamRequired("Fleet"))
	}
	if s.Fleet != nil && len(*s.Fleet) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Fleet", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *SyncDeploymentJobInput) SetClientRequestToken(v string) *SyncDeploymentJobInput {
	s.ClientRequestToken = &v
	return s
}

// SetFleet sets the Fleet field's value.
func (s *SyncDeploymentJobInput) SetFleet(v string) *SyncDeploymentJobInput {
	s.Fleet = &v
	return s
}

type SyncDeploymentJobOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the synchronization request.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the fleet was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// Information about the deployment application configurations.
	DeploymentApplicationConfigs []*DeploymentApplicationConfig `locationName:"deploymentApplicationConfigs" min:"1" type:"list"`

	// Information about the deployment configuration.
	DeploymentConfig *DeploymentConfig `locationName:"deploymentConfig" type:"structure"`

	// The failure code if the job fails:
	//
	// InternalServiceError
	//
	// Internal service error.
	//
	// RobotApplicationCrash
	//
	// Robot application exited abnormally.
	//
	// SimulationApplicationCrash
	//
	// Simulation application exited abnormally.
	//
	// BadPermissionsRobotApplication
	//
	// Robot application bundle could not be downloaded.
	//
	// BadPermissionsSimulationApplication
	//
	// Simulation application bundle could not be downloaded.
	//
	// BadPermissionsS3Output
	//
	// Unable to publish outputs to customer-provided S3 bucket.
	//
	// BadPermissionsCloudwatchLogs
	//
	// Unable to publish logs to customer-provided CloudWatch Logs resource.
	//
	// SubnetIpLimitExceeded
	//
	// Subnet IP limit exceeded.
	//
	// ENILimitExceeded
	//
	// ENI limit exceeded.
	//
	// BadPermissionsUserCredentials
	//
	// Unable to use the Role provided.
	//
	// InvalidBundleRobotApplication
	//
	// Robot bundle cannot be extracted (invalid format, bundling error, or other
	// issue).
	//
	// InvalidBundleSimulationApplication
	//
	// Simulation bundle cannot be extracted (invalid format, bundling error, or
	// other issue).
	//
	// RobotApplicationVersionMismatchedEtag
	//
	// Etag for RobotApplication does not match value during version creation.
	//
	// SimulationApplicationVersionMismatchedEtag
	//
	// Etag for SimulationApplication does not match value during version creation.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"DeploymentJobErrorCode"`

	// The failure reason if the job fails.
	FailureReason *string `locationName:"failureReason" type:"string"`

	// The Amazon Resource Name (ARN) of the fleet.
	Fleet *string `locationName:"fleet" min:"1" type:"string"`

	// The status of the synchronization job.
	Status *string `locationName:"status" type:"string" enum:"DeploymentStatus"`
}

// String returns the string representation
func (s SyncDeploymentJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SyncDeploymentJobOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *SyncDeploymentJobOutput) SetArn(v string) *SyncDeploymentJobOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *SyncDeploymentJobOutput) SetCreatedAt(v time.Time) *SyncDeploymentJobOutput {
	s.CreatedAt = &v
	return s
}

// SetDeploymentApplicationConfigs sets the DeploymentApplicationConfigs field's value.
func (s *SyncDeploymentJobOutput) SetDeploymentApplicationConfigs(v []*DeploymentApplicationConfig) *SyncDeploymentJobOutput {
	s.DeploymentApplicationConfigs = v
	return s
}

// SetDeploymentConfig sets the DeploymentConfig field's value.
func (s *SyncDeploymentJobOutput) SetDeploymentConfig(v *DeploymentConfig) *SyncDeploymentJobOutput {
	s.DeploymentConfig = v
	return s
}

// SetFailureCode sets the FailureCode field's value.
func (s *SyncDeploymentJobOutput) SetFailureCode(v string) *SyncDeploymentJobOutput {
	s.FailureCode = &v
	return s
}

// SetFailureReason sets the FailureReason field's value.
func (s *SyncDeploymentJobOutput) SetFailureReason(v string) *SyncDeploymentJobOutput {
	s.FailureReason = &v
	return s
}

// SetFleet sets the Fleet field's value.
func (s *SyncDeploymentJobOutput) SetFleet(v string) *SyncDeploymentJobOutput {
	s.Fleet = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SyncDeploymentJobOutput) SetStatus(v string) *SyncDeploymentJobOutput {
	s.Status = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are tagging.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A map that contains tag keys and tag values that are attached to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Information about a template location.
type TemplateLocation struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket name.
	//
	// S3Bucket is a required field
	S3Bucket *string `locationName:"s3Bucket" min:"3" type:"string" required:"true"`

	// The list of S3 keys identifying the data source files.
	//
	// S3Key is a required field
	S3Key *string `locationName:"s3Key" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s TemplateLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TemplateLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TemplateLocation"}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Key == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Key"))
	}
	if s.S3Key != nil && len(*s.S3Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *TemplateLocation) SetS3Bucket(v string) *TemplateLocation {
	s.S3Bucket = &v
	return s
}

// SetS3Key sets the S3Key field's value.
func (s *TemplateLocation) SetS3Key(v string) *TemplateLocation {
	s.S3Key = &v
	return s
}

// Summary information for a template.
type TemplateSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the template.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the template was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the template was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the template.
	Name *string `locationName:"name" type:"string"`

	// The version of the template that you're using.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s TemplateSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *TemplateSummary) SetArn(v string) *TemplateSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *TemplateSummary) SetCreatedAt(v time.Time) *TemplateSummary {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *TemplateSummary) SetLastUpdatedAt(v time.Time) *TemplateSummary {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *TemplateSummary) SetName(v string) *TemplateSummary {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *TemplateSummary) SetVersion(v string) *TemplateSummary {
	s.Version = &v
	return s
}

// AWS RoboMaker is temporarily unable to process the request. Try your call
// again.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about a tool. Tools are used in a simulation job.
type Tool struct {
	_ struct{} `type:"structure"`

	// Command-line arguments for the tool. It must include the tool executable
	// name.
	//
	// Command is a required field
	Command *string `locationName:"command" min:"1" type:"string" required:"true"`

	// Exit behavior determines what happens when your tool quits running. RESTART
	// will cause your tool to be restarted. FAIL will cause your job to exit. The
	// default is RESTART.
	ExitBehavior *string `locationName:"exitBehavior" type:"string" enum:"ExitBehavior"`

	// The name of the tool.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Boolean indicating whether logs will be recorded in CloudWatch for the tool.
	// The default is False.
	StreamOutputToCloudWatch *bool `locationName:"streamOutputToCloudWatch" type:"boolean"`

	// Boolean indicating whether a streaming session will be configured for the
	// tool. If True, AWS RoboMaker will configure a connection so you can interact
	// with the tool as it is running in the simulation. It must have a graphical
	// user interface. The default is False.
	StreamUI *bool `locationName:"streamUI" type:"boolean"`
}

// String returns the string representation
func (s Tool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tool) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tool) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tool"}
	if s.Command == nil {
		invalidParams.Add(request.NewErrParamRequired("Command"))
	}
	if s.Command != nil && len(*s.Command) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Command", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCommand sets the Command field's value.
func (s *Tool) SetCommand(v string) *Tool {
	s.Command = &v
	return s
}

// SetExitBehavior sets the ExitBehavior field's value.
func (s *Tool) SetExitBehavior(v string) *Tool {
	s.ExitBehavior = &v
	return s
}

// SetName sets the Name field's value.
func (s *Tool) SetName(v string) *Tool {
	s.Name = &v
	return s
}

// SetStreamOutputToCloudWatch sets the StreamOutputToCloudWatch field's value.
func (s *Tool) SetStreamOutputToCloudWatch(v bool) *Tool {
	s.StreamOutputToCloudWatch = &v
	return s
}

// SetStreamUI sets the StreamUI field's value.
func (s *Tool) SetStreamUI(v bool) *Tool {
	s.StreamUI = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS RoboMaker resource you are removing
	// tags.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A map that contains tag keys and tag values that will be unattached from
	// the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateRobotApplicationInput struct {
	_ struct{} `type:"structure"`

	// The application information for the robot application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The revision id for the robot application.
	CurrentRevisionId *string `locationName:"currentRevisionId" min:"1" type:"string"`

	// The robot software suite (ROS distribution) used by the robot application.
	//
	// RobotSoftwareSuite is a required field
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure" required:"true"`

	// The sources of the robot application.
	//
	// Sources is a required field
	Sources []*SourceConfig `locationName:"sources" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRobotApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRobotApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRobotApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRobotApplicationInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.CurrentRevisionId != nil && len(*s.CurrentRevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentRevisionId", 1))
	}
	if s.RobotSoftwareSuite == nil {
		invalidParams.Add(request.NewErrParamRequired("RobotSoftwareSuite"))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *UpdateRobotApplicationInput) SetApplication(v string) *UpdateRobotApplicationInput {
	s.Application = &v
	return s
}

// SetCurrentRevisionId sets the CurrentRevisionId field's value.
func (s *UpdateRobotApplicationInput) SetCurrentRevisionId(v string) *UpdateRobotApplicationInput {
	s.CurrentRevisionId = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *UpdateRobotApplicationInput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *UpdateRobotApplicationInput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *UpdateRobotApplicationInput) SetSources(v []*SourceConfig) *UpdateRobotApplicationInput {
	s.Sources = v
	return s
}

type UpdateRobotApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated robot application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the robot application was
	// last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the robot application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The revision id of the robot application.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// The robot software suite (ROS distribution) used by the robot application.
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The sources of the robot application.
	Sources []*Source `locationName:"sources" type:"list"`

	// The version of the robot application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRobotApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRobotApplicationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateRobotApplicationOutput) SetArn(v string) *UpdateRobotApplicationOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *UpdateRobotApplicationOutput) SetLastUpdatedAt(v time.Time) *UpdateRobotApplicationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRobotApplicationOutput) SetName(v string) *UpdateRobotApplicationOutput {
	s.Name = &v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateRobotApplicationOutput) SetRevisionId(v string) *UpdateRobotApplicationOutput {
	s.RevisionId = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *UpdateRobotApplicationOutput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *UpdateRobotApplicationOutput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *UpdateRobotApplicationOutput) SetSources(v []*Source) *UpdateRobotApplicationOutput {
	s.Sources = v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateRobotApplicationOutput) SetVersion(v string) *UpdateRobotApplicationOutput {
	s.Version = &v
	return s
}

type UpdateSimulationApplicationInput struct {
	_ struct{} `type:"structure"`

	// The application information for the simulation application.
	//
	// Application is a required field
	Application *string `locationName:"application" min:"1" type:"string" required:"true"`

	// The revision id for the robot application.
	CurrentRevisionId *string `locationName:"currentRevisionId" min:"1" type:"string"`

	// The rendering engine for the simulation application.
	RenderingEngine *RenderingEngine `locationName:"renderingEngine" type:"structure"`

	// Information about the robot software suite (ROS distribution).
	//
	// RobotSoftwareSuite is a required field
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure" required:"true"`

	// The simulation software suite used by the simulation application.
	//
	// SimulationSoftwareSuite is a required field
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure" required:"true"`

	// The sources of the simulation application.
	//
	// Sources is a required field
	Sources []*SourceConfig `locationName:"sources" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateSimulationApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSimulationApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSimulationApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSimulationApplicationInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.CurrentRevisionId != nil && len(*s.CurrentRevisionId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CurrentRevisionId", 1))
	}
	if s.RobotSoftwareSuite == nil {
		invalidParams.Add(request.NewErrParamRequired("RobotSoftwareSuite"))
	}
	if s.SimulationSoftwareSuite == nil {
		invalidParams.Add(request.NewErrParamRequired("SimulationSoftwareSuite"))
	}
	if s.Sources == nil {
		invalidParams.Add(request.NewErrParamRequired("Sources"))
	}
	if s.RenderingEngine != nil {
		if err := s.RenderingEngine.Validate(); err != nil {
			invalidParams.AddNested("RenderingEngine", err.(request.ErrInvalidParams))
		}
	}
	if s.Sources != nil {
		for i, v := range s.Sources {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Sources", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *UpdateSimulationApplicationInput) SetApplication(v string) *UpdateSimulationApplicationInput {
	s.Application = &v
	return s
}

// SetCurrentRevisionId sets the CurrentRevisionId field's value.
func (s *UpdateSimulationApplicationInput) SetCurrentRevisionId(v string) *UpdateSimulationApplicationInput {
	s.CurrentRevisionId = &v
	return s
}

// SetRenderingEngine sets the RenderingEngine field's value.
func (s *UpdateSimulationApplicationInput) SetRenderingEngine(v *RenderingEngine) *UpdateSimulationApplicationInput {
	s.RenderingEngine = v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *UpdateSimulationApplicationInput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *UpdateSimulationApplicationInput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSimulationSoftwareSuite sets the SimulationSoftwareSuite field's value.
func (s *UpdateSimulationApplicationInput) SetSimulationSoftwareSuite(v *SimulationSoftwareSuite) *UpdateSimulationApplicationInput {
	s.SimulationSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *UpdateSimulationApplicationInput) SetSources(v []*SourceConfig) *UpdateSimulationApplicationInput {
	s.Sources = v
	return s
}

type UpdateSimulationApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the updated simulation application.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the simulation application
	// was last updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the simulation application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The rendering engine for the simulation application.
	RenderingEngine *RenderingEngine `locationName:"renderingEngine" type:"structure"`

	// The revision id of the simulation application.
	RevisionId *string `locationName:"revisionId" min:"1" type:"string"`

	// Information about the robot software suite (ROS distribution).
	RobotSoftwareSuite *RobotSoftwareSuite `locationName:"robotSoftwareSuite" type:"structure"`

	// The simulation software suite used by the simulation application.
	SimulationSoftwareSuite *SimulationSoftwareSuite `locationName:"simulationSoftwareSuite" type:"structure"`

	// The sources of the simulation application.
	Sources []*Source `locationName:"sources" type:"list"`

	// The version of the robot application.
	Version *string `locationName:"version" min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateSimulationApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSimulationApplicationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateSimulationApplicationOutput) SetArn(v string) *UpdateSimulationApplicationOutput {
	s.Arn = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *UpdateSimulationApplicationOutput) SetLastUpdatedAt(v time.Time) *UpdateSimulationApplicationOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateSimulationApplicationOutput) SetName(v string) *UpdateSimulationApplicationOutput {
	s.Name = &v
	return s
}

// SetRenderingEngine sets the RenderingEngine field's value.
func (s *UpdateSimulationApplicationOutput) SetRenderingEngine(v *RenderingEngine) *UpdateSimulationApplicationOutput {
	s.RenderingEngine = v
	return s
}

// SetRevisionId sets the RevisionId field's value.
func (s *UpdateSimulationApplicationOutput) SetRevisionId(v string) *UpdateSimulationApplicationOutput {
	s.RevisionId = &v
	return s
}

// SetRobotSoftwareSuite sets the RobotSoftwareSuite field's value.
func (s *UpdateSimulationApplicationOutput) SetRobotSoftwareSuite(v *RobotSoftwareSuite) *UpdateSimulationApplicationOutput {
	s.RobotSoftwareSuite = v
	return s
}

// SetSimulationSoftwareSuite sets the SimulationSoftwareSuite field's value.
func (s *UpdateSimulationApplicationOutput) SetSimulationSoftwareSuite(v *SimulationSoftwareSuite) *UpdateSimulationApplicationOutput {
	s.SimulationSoftwareSuite = v
	return s
}

// SetSources sets the Sources field's value.
func (s *UpdateSimulationApplicationOutput) SetSources(v []*Source) *UpdateSimulationApplicationOutput {
	s.Sources = v
	return s
}

// SetVersion sets the Version field's value.
func (s *UpdateSimulationApplicationOutput) SetVersion(v string) *UpdateSimulationApplicationOutput {
	s.Version = &v
	return s
}

type UpdateWorldTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the template.
	Name *string `locationName:"name" type:"string"`

	// The Amazon Resource Name (arn) of the world template to update.
	//
	// Template is a required field
	Template *string `locationName:"template" min:"1" type:"string" required:"true"`

	// The world template body.
	TemplateBody *string `locationName:"templateBody" min:"1" type:"string"`

	// The location of the world template.
	TemplateLocation *TemplateLocation `locationName:"templateLocation" type:"structure"`
}

// String returns the string representation
func (s UpdateWorldTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWorldTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorldTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorldTemplateInput"}
	if s.Template == nil {
		invalidParams.Add(request.NewErrParamRequired("Template"))
	}
	if s.Template != nil && len(*s.Template) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Template", 1))
	}
	if s.TemplateBody != nil && len(*s.TemplateBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TemplateBody", 1))
	}
	if s.TemplateLocation != nil {
		if err := s.TemplateLocation.Validate(); err != nil {
			invalidParams.AddNested("TemplateLocation", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateWorldTemplateInput) SetName(v string) *UpdateWorldTemplateInput {
	s.Name = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *UpdateWorldTemplateInput) SetTemplate(v string) *UpdateWorldTemplateInput {
	s.Template = &v
	return s
}

// SetTemplateBody sets the TemplateBody field's value.
func (s *UpdateWorldTemplateInput) SetTemplateBody(v string) *UpdateWorldTemplateInput {
	s.TemplateBody = &v
	return s
}

// SetTemplateLocation sets the TemplateLocation field's value.
func (s *UpdateWorldTemplateInput) SetTemplateLocation(v *TemplateLocation) *UpdateWorldTemplateInput {
	s.TemplateLocation = v
	return s
}

type UpdateWorldTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (arn) of the world template.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world template was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The time, in milliseconds since the epoch, when the world template was last
	// updated.
	LastUpdatedAt *time.Time `locationName:"lastUpdatedAt" type:"timestamp"`

	// The name of the world template.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s UpdateWorldTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWorldTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *UpdateWorldTemplateOutput) SetArn(v string) *UpdateWorldTemplateOutput {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *UpdateWorldTemplateOutput) SetCreatedAt(v time.Time) *UpdateWorldTemplateOutput {
	s.CreatedAt = &v
	return s
}

// SetLastUpdatedAt sets the LastUpdatedAt field's value.
func (s *UpdateWorldTemplateOutput) SetLastUpdatedAt(v time.Time) *UpdateWorldTemplateOutput {
	s.LastUpdatedAt = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateWorldTemplateOutput) SetName(v string) *UpdateWorldTemplateOutput {
	s.Name = &v
	return s
}

// Provides upload configuration information. Files are uploaded from the simulation
// job to a location you specify.
type UploadConfiguration struct {
	_ struct{} `type:"structure"`

	// A prefix that specifies where files will be uploaded in Amazon S3. It is
	// appended to the simulation output location to determine the final path.
	//
	// For example, if your simulation output location is s3://my-bucket and your
	// upload configuration name is robot-test, your files will be uploaded to s3://my-bucket/<simid>/<runid>/robot-test.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Specifies the path of the file(s) to upload. Standard Unix glob matching
	// rules are accepted, with the addition of ** as a super asterisk. For example,
	// specifying /var/log/**.log causes all .log files in the /var/log directory
	// tree to be collected. For more examples, see Glob Library (https://github.com/gobwas/glob).
	//
	// Path is a required field
	Path *string `locationName:"path" min:"1" type:"string" required:"true"`

	// Specifies when to upload the files:
	//
	// UPLOAD_ON_TERMINATE
	//
	// Matching files are uploaded once the simulation enters the TERMINATING state.
	// Matching files are not uploaded until all of your code (including tools)
	// have stopped.
	//
	// If there is a problem uploading a file, the upload is retried. If problems
	// persist, no further upload attempts will be made.
	//
	// UPLOAD_ROLLING_AUTO_REMOVE
	//
	// Matching files are uploaded as they are created. They are deleted after they
	// are uploaded. The specified path is checked every 5 seconds. A final check
	// is made when all of your code (including tools) have stopped.
	//
	// UploadBehavior is a required field
	UploadBehavior *string `locationName:"uploadBehavior" type:"string" required:"true" enum:"UploadBehavior"`
}

// String returns the string representation
func (s UploadConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UploadConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UploadConfiguration"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Path == nil {
		invalidParams.Add(request.NewErrParamRequired("Path"))
	}
	if s.Path != nil && len(*s.Path) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Path", 1))
	}
	if s.UploadBehavior == nil {
		invalidParams.Add(request.NewErrParamRequired("UploadBehavior"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UploadConfiguration) SetName(v string) *UploadConfiguration {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *UploadConfiguration) SetPath(v string) *UploadConfiguration {
	s.Path = &v
	return s
}

// SetUploadBehavior sets the UploadBehavior field's value.
func (s *UploadConfiguration) SetUploadBehavior(v string) *UploadConfiguration {
	s.UploadBehavior = &v
	return s
}

// If your simulation job accesses resources in a VPC, you provide this parameter
// identifying the list of security group IDs and subnet IDs. These must belong
// to the same VPC. You must provide at least one security group and two subnet
// IDs.
type VPCConfig struct {
	_ struct{} `type:"structure"`

	// A boolean indicating whether to assign a public IP address.
	AssignPublicIp *bool `locationName:"assignPublicIp" type:"boolean"`

	// A list of one or more security groups IDs in your VPC.
	SecurityGroups []*string `locationName:"securityGroups" min:"1" type:"list"`

	// A list of one or more subnet IDs in your VPC.
	//
	// Subnets is a required field
	Subnets []*string `locationName:"subnets" min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s VPCConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VPCConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VPCConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VPCConfig"}
	if s.SecurityGroups != nil && len(s.SecurityGroups) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityGroups", 1))
	}
	if s.Subnets == nil {
		invalidParams.Add(request.NewErrParamRequired("Subnets"))
	}
	if s.Subnets != nil && len(s.Subnets) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Subnets", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssignPublicIp sets the AssignPublicIp field's value.
func (s *VPCConfig) SetAssignPublicIp(v bool) *VPCConfig {
	s.AssignPublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *VPCConfig) SetSecurityGroups(v []*string) *VPCConfig {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *VPCConfig) SetSubnets(v []*string) *VPCConfig {
	s.Subnets = v
	return s
}

// VPC configuration associated with your simulation job.
type VPCConfigResponse struct {
	_ struct{} `type:"structure"`

	// A boolean indicating if a public IP was assigned.
	AssignPublicIp *bool `locationName:"assignPublicIp" type:"boolean"`

	// A list of security group IDs associated with the simulation job.
	SecurityGroups []*string `locationName:"securityGroups" min:"1" type:"list"`

	// A list of subnet IDs associated with the simulation job.
	Subnets []*string `locationName:"subnets" min:"1" type:"list"`

	// The VPC ID associated with your simulation job.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s VPCConfigResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VPCConfigResponse) GoString() string {
	return s.String()
}

// SetAssignPublicIp sets the AssignPublicIp field's value.
func (s *VPCConfigResponse) SetAssignPublicIp(v bool) *VPCConfigResponse {
	s.AssignPublicIp = &v
	return s
}

// SetSecurityGroups sets the SecurityGroups field's value.
func (s *VPCConfigResponse) SetSecurityGroups(v []*string) *VPCConfigResponse {
	s.SecurityGroups = v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *VPCConfigResponse) SetSubnets(v []*string) *VPCConfigResponse {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VPCConfigResponse) SetVpcId(v string) *VPCConfigResponse {
	s.VpcId = &v
	return s
}

// Configuration information for a world.
type WorldConfig struct {
	_ struct{} `type:"structure"`

	// The world generated by Simulation WorldForge.
	World *string `locationName:"world" min:"1" type:"string"`
}

// String returns the string representation
func (s WorldConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorldConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorldConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorldConfig"}
	if s.World != nil && len(*s.World) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("World", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorld sets the World field's value.
func (s *WorldConfig) SetWorld(v string) *WorldConfig {
	s.World = &v
	return s
}

// The number of worlds that will be created. You can configure the number of
// unique floorplans and the number of unique interiors for each floor plan.
// For example, if you want 1 world with 20 unique interiors, you set floorplanCount
// = 1 and interiorCountPerFloorplan = 20. This will result in 20 worlds (floorplanCount
// * interiorCountPerFloorplan).
//
// If you set floorplanCount = 4 and interiorCountPerFloorplan = 5, there will
// be 20 worlds with 5 unique floor plans.
type WorldCount struct {
	_ struct{} `type:"structure"`

	// The number of unique floorplans.
	FloorplanCount *int64 `locationName:"floorplanCount" type:"integer"`

	// The number of unique interiors per floorplan.
	InteriorCountPerFloorplan *int64 `locationName:"interiorCountPerFloorplan" type:"integer"`
}

// String returns the string representation
func (s WorldCount) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorldCount) GoString() string {
	return s.String()
}

// SetFloorplanCount sets the FloorplanCount field's value.
func (s *WorldCount) SetFloorplanCount(v int64) *WorldCount {
	s.FloorplanCount = &v
	return s
}

// SetInteriorCountPerFloorplan sets the InteriorCountPerFloorplan field's value.
func (s *WorldCount) SetInteriorCountPerFloorplan(v int64) *WorldCount {
	s.InteriorCountPerFloorplan = &v
	return s
}

// Information about a world export job.
type WorldExportJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the world export job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world export job was
	// created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The status of the world export job.
	//
	// Pending
	//
	// The world export job request is pending.
	//
	// Running
	//
	// The world export job is running.
	//
	// Completed
	//
	// The world export job completed.
	//
	// Failed
	//
	// The world export job failed. See failureCode for more information.
	//
	// Canceled
	//
	// The world export job was cancelled.
	//
	// Canceling
	//
	// The world export job is being cancelled.
	Status *string `locationName:"status" type:"string" enum:"WorldExportJobStatus"`

	// A list of worlds.
	Worlds []*string `locationName:"worlds" min:"1" type:"list"`
}

// String returns the string representation
func (s WorldExportJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorldExportJobSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *WorldExportJobSummary) SetArn(v string) *WorldExportJobSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WorldExportJobSummary) SetCreatedAt(v time.Time) *WorldExportJobSummary {
	s.CreatedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorldExportJobSummary) SetStatus(v string) *WorldExportJobSummary {
	s.Status = &v
	return s
}

// SetWorlds sets the Worlds field's value.
func (s *WorldExportJobSummary) SetWorlds(v []*string) *WorldExportJobSummary {
	s.Worlds = v
	return s
}

// Information about a failed world.
type WorldFailure struct {
	_ struct{} `type:"structure"`

	// The failure code of the world export job if it failed:
	//
	// InternalServiceError
	//
	// Internal service error.
	//
	// LimitExceeded
	//
	// The requested resource exceeds the maximum number allowed, or the number
	// of concurrent stream requests exceeds the maximum number allowed.
	//
	// ResourceNotFound
	//
	// The specified resource could not be found.
	//
	// RequestThrottled
	//
	// The request was throttled.
	//
	// InvalidInput
	//
	// An input parameter in the request is not valid.
	FailureCode *string `locationName:"failureCode" type:"string" enum:"WorldGenerationJobErrorCode"`

	// The number of failed worlds.
	FailureCount *int64 `locationName:"failureCount" type:"integer"`

	// The sample reason why the world failed. World errors are aggregated. A sample
	// is used as the sampleFailureReason.
	SampleFailureReason *string `locationName:"sampleFailureReason" type:"string"`
}

// String returns the string representation
func (s WorldFailure) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorldFailure) GoString() string {
	return s.String()
}

// SetFailureCode sets the FailureCode field's value.
func (s *WorldFailure) SetFailureCode(v string) *WorldFailure {
	s.FailureCode = &v
	return s
}

// SetFailureCount sets the FailureCount field's value.
func (s *WorldFailure) SetFailureCount(v int64) *WorldFailure {
	s.FailureCount = &v
	return s
}

// SetSampleFailureReason sets the SampleFailureReason field's value.
func (s *WorldFailure) SetSampleFailureReason(v string) *WorldFailure {
	s.SampleFailureReason = &v
	return s
}

// Information about a world generator job.
type WorldGenerationJobSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the world generator job.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world generator job was
	// created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The number of worlds that failed.
	FailedWorldCount *int64 `locationName:"failedWorldCount" type:"integer"`

	// The status of the world generator job:
	//
	// Pending
	//
	// The world generator job request is pending.
	//
	// Running
	//
	// The world generator job is running.
	//
	// Completed
	//
	// The world generator job completed.
	//
	// Failed
	//
	// The world generator job failed. See failureCode for more information.
	//
	// PartialFailed
	//
	// Some worlds did not generate.
	//
	// Canceled
	//
	// The world generator job was cancelled.
	//
	// Canceling
	//
	// The world generator job is being cancelled.
	Status *string `locationName:"status" type:"string" enum:"WorldGenerationJobStatus"`

	// The number of worlds that were generated.
	SucceededWorldCount *int64 `locationName:"succeededWorldCount" type:"integer"`

	// The Amazon Resource Name (arn) of the world template.
	Template *string `locationName:"template" min:"1" type:"string"`

	// Information about the world count.
	WorldCount *WorldCount `locationName:"worldCount" type:"structure"`
}

// String returns the string representation
func (s WorldGenerationJobSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorldGenerationJobSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *WorldGenerationJobSummary) SetArn(v string) *WorldGenerationJobSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WorldGenerationJobSummary) SetCreatedAt(v time.Time) *WorldGenerationJobSummary {
	s.CreatedAt = &v
	return s
}

// SetFailedWorldCount sets the FailedWorldCount field's value.
func (s *WorldGenerationJobSummary) SetFailedWorldCount(v int64) *WorldGenerationJobSummary {
	s.FailedWorldCount = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorldGenerationJobSummary) SetStatus(v string) *WorldGenerationJobSummary {
	s.Status = &v
	return s
}

// SetSucceededWorldCount sets the SucceededWorldCount field's value.
func (s *WorldGenerationJobSummary) SetSucceededWorldCount(v int64) *WorldGenerationJobSummary {
	s.SucceededWorldCount = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *WorldGenerationJobSummary) SetTemplate(v string) *WorldGenerationJobSummary {
	s.Template = &v
	return s
}

// SetWorldCount sets the WorldCount field's value.
func (s *WorldGenerationJobSummary) SetWorldCount(v *WorldCount) *WorldGenerationJobSummary {
	s.WorldCount = v
	return s
}

// Information about a world.
type WorldSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the world.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The time, in milliseconds since the epoch, when the world was created.
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp"`

	// The Amazon Resource Name (arn) of the world generation job.
	GenerationJob *string `locationName:"generationJob" min:"1" type:"string"`

	// The Amazon Resource Name (arn) of the world template.
	Template *string `locationName:"template" min:"1" type:"string"`
}

// String returns the string representation
func (s WorldSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WorldSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *WorldSummary) SetArn(v string) *WorldSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WorldSummary) SetCreatedAt(v time.Time) *WorldSummary {
	s.CreatedAt = &v
	return s
}

// SetGenerationJob sets the GenerationJob field's value.
func (s *WorldSummary) SetGenerationJob(v string) *WorldSummary {
	s.GenerationJob = &v
	return s
}

// SetTemplate sets the Template field's value.
func (s *WorldSummary) SetTemplate(v string) *WorldSummary {
	s.Template = &v
	return s
}

const (
	// ArchitectureX8664 is a Architecture enum value
	ArchitectureX8664 = "X86_64"

	// ArchitectureArm64 is a Architecture enum value
	ArchitectureArm64 = "ARM64"

	// ArchitectureArmhf is a Architecture enum value
	ArchitectureArmhf = "ARMHF"
)

// Architecture_Values returns all elements of the Architecture enum
func Architecture_Values() []string {
	return []string{
		ArchitectureX8664,
		ArchitectureArm64,
		ArchitectureArmhf,
	}
}

const (
	// DeploymentJobErrorCodeResourceNotFound is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeResourceNotFound = "ResourceNotFound"

	// DeploymentJobErrorCodeEnvironmentSetupError is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeEnvironmentSetupError = "EnvironmentSetupError"

	// DeploymentJobErrorCodeEtagMismatch is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeEtagMismatch = "EtagMismatch"

	// DeploymentJobErrorCodeFailureThresholdBreached is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeFailureThresholdBreached = "FailureThresholdBreached"

	// DeploymentJobErrorCodeRobotDeploymentAborted is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeRobotDeploymentAborted = "RobotDeploymentAborted"

	// DeploymentJobErrorCodeRobotDeploymentNoResponse is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeRobotDeploymentNoResponse = "RobotDeploymentNoResponse"

	// DeploymentJobErrorCodeRobotAgentConnectionTimeout is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeRobotAgentConnectionTimeout = "RobotAgentConnectionTimeout"

	// DeploymentJobErrorCodeGreengrassDeploymentFailed is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeGreengrassDeploymentFailed = "GreengrassDeploymentFailed"

	// DeploymentJobErrorCodeInvalidGreengrassGroup is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeInvalidGreengrassGroup = "InvalidGreengrassGroup"

	// DeploymentJobErrorCodeMissingRobotArchitecture is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeMissingRobotArchitecture = "MissingRobotArchitecture"

	// DeploymentJobErrorCodeMissingRobotApplicationArchitecture is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeMissingRobotApplicationArchitecture = "MissingRobotApplicationArchitecture"

	// DeploymentJobErrorCodeMissingRobotDeploymentResource is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeMissingRobotDeploymentResource = "MissingRobotDeploymentResource"

	// DeploymentJobErrorCodeGreengrassGroupVersionDoesNotExist is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeGreengrassGroupVersionDoesNotExist = "GreengrassGroupVersionDoesNotExist"

	// DeploymentJobErrorCodeLambdaDeleted is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeLambdaDeleted = "LambdaDeleted"

	// DeploymentJobErrorCodeExtractingBundleFailure is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeExtractingBundleFailure = "ExtractingBundleFailure"

	// DeploymentJobErrorCodePreLaunchFileFailure is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodePreLaunchFileFailure = "PreLaunchFileFailure"

	// DeploymentJobErrorCodePostLaunchFileFailure is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodePostLaunchFileFailure = "PostLaunchFileFailure"

	// DeploymentJobErrorCodeBadPermissionError is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeBadPermissionError = "BadPermissionError"

	// DeploymentJobErrorCodeDownloadConditionFailed is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeDownloadConditionFailed = "DownloadConditionFailed"

	// DeploymentJobErrorCodeBadLambdaAssociated is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeBadLambdaAssociated = "BadLambdaAssociated"

	// DeploymentJobErrorCodeInternalServerError is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeInternalServerError = "InternalServerError"

	// DeploymentJobErrorCodeRobotApplicationDoesNotExist is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeRobotApplicationDoesNotExist = "RobotApplicationDoesNotExist"

	// DeploymentJobErrorCodeDeploymentFleetDoesNotExist is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeDeploymentFleetDoesNotExist = "DeploymentFleetDoesNotExist"

	// DeploymentJobErrorCodeFleetDeploymentTimeout is a DeploymentJobErrorCode enum value
	DeploymentJobErrorCodeFleetDeploymentTimeout = "FleetDeploymentTimeout"
)

// DeploymentJobErrorCode_Values returns all elements of the DeploymentJobErrorCode enum
func DeploymentJobErrorCode_Values() []string {
	return []string{
		DeploymentJobErrorCodeResourceNotFound,
		DeploymentJobErrorCodeEnvironmentSetupError,
		DeploymentJobErrorCodeEtagMismatch,
		DeploymentJobErrorCodeFailureThresholdBreached,
		DeploymentJobErrorCodeRobotDeploymentAborted,
		DeploymentJobErrorCodeRobotDeploymentNoResponse,
		DeploymentJobErrorCodeRobotAgentConnectionTimeout,
		DeploymentJobErrorCodeGreengrassDeploymentFailed,
		DeploymentJobErrorCodeInvalidGreengrassGroup,
		DeploymentJobErrorCodeMissingRobotArchitecture,
		DeploymentJobErrorCodeMissingRobotApplicationArchitecture,
		DeploymentJobErrorCodeMissingRobotDeploymentResource,
		DeploymentJobErrorCodeGreengrassGroupVersionDoesNotExist,
		DeploymentJobErrorCodeLambdaDeleted,
		DeploymentJobErrorCodeExtractingBundleFailure,
		DeploymentJobErrorCodePreLaunchFileFailure,
		DeploymentJobErrorCodePostLaunchFileFailure,
		DeploymentJobErrorCodeBadPermissionError,
		DeploymentJobErrorCodeDownloadConditionFailed,
		DeploymentJobErrorCodeBadLambdaAssociated,
		DeploymentJobErrorCodeInternalServerError,
		DeploymentJobErrorCodeRobotApplicationDoesNotExist,
		DeploymentJobErrorCodeDeploymentFleetDoesNotExist,
		DeploymentJobErrorCodeFleetDeploymentTimeout,
	}
}

const (
	// DeploymentStatusPending is a DeploymentStatus enum value
	DeploymentStatusPending = "Pending"

	// DeploymentStatusPreparing is a DeploymentStatus enum value
	DeploymentStatusPreparing = "Preparing"

	// DeploymentStatusInProgress is a DeploymentStatus enum value
	DeploymentStatusInProgress = "InProgress"

	// DeploymentStatusFailed is a DeploymentStatus enum value
	DeploymentStatusFailed = "Failed"

	// DeploymentStatusSucceeded is a DeploymentStatus enum value
	DeploymentStatusSucceeded = "Succeeded"

	// DeploymentStatusCanceled is a DeploymentStatus enum value
	DeploymentStatusCanceled = "Canceled"
)

// DeploymentStatus_Values returns all elements of the DeploymentStatus enum
func DeploymentStatus_Values() []string {
	return []string{
		DeploymentStatusPending,
		DeploymentStatusPreparing,
		DeploymentStatusInProgress,
		DeploymentStatusFailed,
		DeploymentStatusSucceeded,
		DeploymentStatusCanceled,
	}
}

const (
	// ExitBehaviorFail is a ExitBehavior enum value
	ExitBehaviorFail = "FAIL"

	// ExitBehaviorRestart is a ExitBehavior enum value
	ExitBehaviorRestart = "RESTART"
)

// ExitBehavior_Values returns all elements of the ExitBehavior enum
func ExitBehavior_Values() []string {
	return []string{
		ExitBehaviorFail,
		ExitBehaviorRestart,
	}
}

const (
	// FailureBehaviorFail is a FailureBehavior enum value
	FailureBehaviorFail = "Fail"

	// FailureBehaviorContinue is a FailureBehavior enum value
	FailureBehaviorContinue = "Continue"
)

// FailureBehavior_Values returns all elements of the FailureBehavior enum
func FailureBehavior_Values() []string {
	return []string{
		FailureBehaviorFail,
		FailureBehaviorContinue,
	}
}

const (
	// RenderingEngineTypeOgre is a RenderingEngineType enum value
	RenderingEngineTypeOgre = "OGRE"
)

// RenderingEngineType_Values returns all elements of the RenderingEngineType enum
func RenderingEngineType_Values() []string {
	return []string{
		RenderingEngineTypeOgre,
	}
}

const (
	// RobotDeploymentStepValidating is a RobotDeploymentStep enum value
	RobotDeploymentStepValidating = "Validating"

	// RobotDeploymentStepDownloadingExtracting is a RobotDeploymentStep enum value
	RobotDeploymentStepDownloadingExtracting = "DownloadingExtracting"

	// RobotDeploymentStepExecutingDownloadCondition is a RobotDeploymentStep enum value
	RobotDeploymentStepExecutingDownloadCondition = "ExecutingDownloadCondition"

	// RobotDeploymentStepExecutingPreLaunch is a RobotDeploymentStep enum value
	RobotDeploymentStepExecutingPreLaunch = "ExecutingPreLaunch"

	// RobotDeploymentStepLaunching is a RobotDeploymentStep enum value
	RobotDeploymentStepLaunching = "Launching"

	// RobotDeploymentStepExecutingPostLaunch is a RobotDeploymentStep enum value
	RobotDeploymentStepExecutingPostLaunch = "ExecutingPostLaunch"

	// RobotDeploymentStepFinished is a RobotDeploymentStep enum value
	RobotDeploymentStepFinished = "Finished"
)

// RobotDeploymentStep_Values returns all elements of the RobotDeploymentStep enum
func RobotDeploymentStep_Values() []string {
	return []string{
		RobotDeploymentStepValidating,
		RobotDeploymentStepDownloadingExtracting,
		RobotDeploymentStepExecutingDownloadCondition,
		RobotDeploymentStepExecutingPreLaunch,
		RobotDeploymentStepLaunching,
		RobotDeploymentStepExecutingPostLaunch,
		RobotDeploymentStepFinished,
	}
}

const (
	// RobotSoftwareSuiteTypeRos is a RobotSoftwareSuiteType enum value
	RobotSoftwareSuiteTypeRos = "ROS"

	// RobotSoftwareSuiteTypeRos2 is a RobotSoftwareSuiteType enum value
	RobotSoftwareSuiteTypeRos2 = "ROS2"
)

// RobotSoftwareSuiteType_Values returns all elements of the RobotSoftwareSuiteType enum
func RobotSoftwareSuiteType_Values() []string {
	return []string{
		RobotSoftwareSuiteTypeRos,
		RobotSoftwareSuiteTypeRos2,
	}
}

const (
	// RobotSoftwareSuiteVersionTypeKinetic is a RobotSoftwareSuiteVersionType enum value
	RobotSoftwareSuiteVersionTypeKinetic = "Kinetic"

	// RobotSoftwareSuiteVersionTypeMelodic is a RobotSoftwareSuiteVersionType enum value
	RobotSoftwareSuiteVersionTypeMelodic = "Melodic"

	// RobotSoftwareSuiteVersionTypeDashing is a RobotSoftwareSuiteVersionType enum value
	RobotSoftwareSuiteVersionTypeDashing = "Dashing"

	// RobotSoftwareSuiteVersionTypeFoxy is a RobotSoftwareSuiteVersionType enum value
	RobotSoftwareSuiteVersionTypeFoxy = "Foxy"
)

// RobotSoftwareSuiteVersionType_Values returns all elements of the RobotSoftwareSuiteVersionType enum
func RobotSoftwareSuiteVersionType_Values() []string {
	return []string{
		RobotSoftwareSuiteVersionTypeKinetic,
		RobotSoftwareSuiteVersionTypeMelodic,
		RobotSoftwareSuiteVersionTypeDashing,
		RobotSoftwareSuiteVersionTypeFoxy,
	}
}

const (
	// RobotStatusAvailable is a RobotStatus enum value
	RobotStatusAvailable = "Available"

	// RobotStatusRegistered is a RobotStatus enum value
	RobotStatusRegistered = "Registered"

	// RobotStatusPendingNewDeployment is a RobotStatus enum value
	RobotStatusPendingNewDeployment = "PendingNewDeployment"

	// RobotStatusDeploying is a RobotStatus enum value
	RobotStatusDeploying = "Deploying"

	// RobotStatusFailed is a RobotStatus enum value
	RobotStatusFailed = "Failed"

	// RobotStatusInSync is a RobotStatus enum value
	RobotStatusInSync = "InSync"

	// RobotStatusNoResponse is a RobotStatus enum value
	RobotStatusNoResponse = "NoResponse"
)

// RobotStatus_Values returns all elements of the RobotStatus enum
func RobotStatus_Values() []string {
	return []string{
		RobotStatusAvailable,
		RobotStatusRegistered,
		RobotStatusPendingNewDeployment,
		RobotStatusDeploying,
		RobotStatusFailed,
		RobotStatusInSync,
		RobotStatusNoResponse,
	}
}

const (
	// SimulationJobBatchErrorCodeInternalServiceError is a SimulationJobBatchErrorCode enum value
	SimulationJobBatchErrorCodeInternalServiceError = "InternalServiceError"
)

// SimulationJobBatchErrorCode_Values returns all elements of the SimulationJobBatchErrorCode enum
func SimulationJobBatchErrorCode_Values() []string {
	return []string{
		SimulationJobBatchErrorCodeInternalServiceError,
	}
}

const (
	// SimulationJobBatchStatusPending is a SimulationJobBatchStatus enum value
	SimulationJobBatchStatusPending = "Pending"

	// SimulationJobBatchStatusInProgress is a SimulationJobBatchStatus enum value
	SimulationJobBatchStatusInProgress = "InProgress"

	// SimulationJobBatchStatusFailed is a SimulationJobBatchStatus enum value
	SimulationJobBatchStatusFailed = "Failed"

	// SimulationJobBatchStatusCompleted is a SimulationJobBatchStatus enum value
	SimulationJobBatchStatusCompleted = "Completed"

	// SimulationJobBatchStatusCanceled is a SimulationJobBatchStatus enum value
	SimulationJobBatchStatusCanceled = "Canceled"

	// SimulationJobBatchStatusCanceling is a SimulationJobBatchStatus enum value
	SimulationJobBatchStatusCanceling = "Canceling"

	// SimulationJobBatchStatusCompleting is a SimulationJobBatchStatus enum value
	SimulationJobBatchStatusCompleting = "Completing"

	// SimulationJobBatchStatusTimingOut is a SimulationJobBatchStatus enum value
	SimulationJobBatchStatusTimingOut = "TimingOut"

	// SimulationJobBatchStatusTimedOut is a SimulationJobBatchStatus enum value
	SimulationJobBatchStatusTimedOut = "TimedOut"
)

// SimulationJobBatchStatus_Values returns all elements of the SimulationJobBatchStatus enum
func SimulationJobBatchStatus_Values() []string {
	return []string{
		SimulationJobBatchStatusPending,
		SimulationJobBatchStatusInProgress,
		SimulationJobBatchStatusFailed,
		SimulationJobBatchStatusCompleted,
		SimulationJobBatchStatusCanceled,
		SimulationJobBatchStatusCanceling,
		SimulationJobBatchStatusCompleting,
		SimulationJobBatchStatusTimingOut,
		SimulationJobBatchStatusTimedOut,
	}
}

const (
	// SimulationJobErrorCodeInternalServiceError is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeInternalServiceError = "InternalServiceError"

	// SimulationJobErrorCodeRobotApplicationCrash is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeRobotApplicationCrash = "RobotApplicationCrash"

	// SimulationJobErrorCodeSimulationApplicationCrash is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeSimulationApplicationCrash = "SimulationApplicationCrash"

	// SimulationJobErrorCodeRobotApplicationHealthCheckFailure is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeRobotApplicationHealthCheckFailure = "RobotApplicationHealthCheckFailure"

	// SimulationJobErrorCodeSimulationApplicationHealthCheckFailure is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeSimulationApplicationHealthCheckFailure = "SimulationApplicationHealthCheckFailure"

	// SimulationJobErrorCodeBadPermissionsRobotApplication is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeBadPermissionsRobotApplication = "BadPermissionsRobotApplication"

	// SimulationJobErrorCodeBadPermissionsSimulationApplication is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeBadPermissionsSimulationApplication = "BadPermissionsSimulationApplication"

	// SimulationJobErrorCodeBadPermissionsS3object is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeBadPermissionsS3object = "BadPermissionsS3Object"

	// SimulationJobErrorCodeBadPermissionsS3output is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeBadPermissionsS3output = "BadPermissionsS3Output"

	// SimulationJobErrorCodeBadPermissionsCloudwatchLogs is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeBadPermissionsCloudwatchLogs = "BadPermissionsCloudwatchLogs"

	// SimulationJobErrorCodeSubnetIpLimitExceeded is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeSubnetIpLimitExceeded = "SubnetIpLimitExceeded"

	// SimulationJobErrorCodeEnilimitExceeded is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeEnilimitExceeded = "ENILimitExceeded"

	// SimulationJobErrorCodeBadPermissionsUserCredentials is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeBadPermissionsUserCredentials = "BadPermissionsUserCredentials"

	// SimulationJobErrorCodeInvalidBundleRobotApplication is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeInvalidBundleRobotApplication = "InvalidBundleRobotApplication"

	// SimulationJobErrorCodeInvalidBundleSimulationApplication is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeInvalidBundleSimulationApplication = "InvalidBundleSimulationApplication"

	// SimulationJobErrorCodeInvalidS3resource is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeInvalidS3resource = "InvalidS3Resource"

	// SimulationJobErrorCodeThrottlingError is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeThrottlingError = "ThrottlingError"

	// SimulationJobErrorCodeLimitExceeded is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeLimitExceeded = "LimitExceeded"

	// SimulationJobErrorCodeMismatchedEtag is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeMismatchedEtag = "MismatchedEtag"

	// SimulationJobErrorCodeRobotApplicationVersionMismatchedEtag is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeRobotApplicationVersionMismatchedEtag = "RobotApplicationVersionMismatchedEtag"

	// SimulationJobErrorCodeSimulationApplicationVersionMismatchedEtag is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeSimulationApplicationVersionMismatchedEtag = "SimulationApplicationVersionMismatchedEtag"

	// SimulationJobErrorCodeResourceNotFound is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeResourceNotFound = "ResourceNotFound"

	// SimulationJobErrorCodeRequestThrottled is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeRequestThrottled = "RequestThrottled"

	// SimulationJobErrorCodeBatchTimedOut is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeBatchTimedOut = "BatchTimedOut"

	// SimulationJobErrorCodeBatchCanceled is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeBatchCanceled = "BatchCanceled"

	// SimulationJobErrorCodeInvalidInput is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeInvalidInput = "InvalidInput"

	// SimulationJobErrorCodeWrongRegionS3bucket is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeWrongRegionS3bucket = "WrongRegionS3Bucket"

	// SimulationJobErrorCodeWrongRegionS3output is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeWrongRegionS3output = "WrongRegionS3Output"

	// SimulationJobErrorCodeWrongRegionRobotApplication is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeWrongRegionRobotApplication = "WrongRegionRobotApplication"

	// SimulationJobErrorCodeWrongRegionSimulationApplication is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeWrongRegionSimulationApplication = "WrongRegionSimulationApplication"

	// SimulationJobErrorCodeUploadContentMismatchError is a SimulationJobErrorCode enum value
	SimulationJobErrorCodeUploadContentMismatchError = "UploadContentMismatchError"
)

// SimulationJobErrorCode_Values returns all elements of the SimulationJobErrorCode enum
func SimulationJobErrorCode_Values() []string {
	return []string{
		SimulationJobErrorCodeInternalServiceError,
		SimulationJobErrorCodeRobotApplicationCrash,
		SimulationJobErrorCodeSimulationApplicationCrash,
		SimulationJobErrorCodeRobotApplicationHealthCheckFailure,
		SimulationJobErrorCodeSimulationApplicationHealthCheckFailure,
		SimulationJobErrorCodeBadPermissionsRobotApplication,
		SimulationJobErrorCodeBadPermissionsSimulationApplication,
		SimulationJobErrorCodeBadPermissionsS3object,
		SimulationJobErrorCodeBadPermissionsS3output,
		SimulationJobErrorCodeBadPermissionsCloudwatchLogs,
		SimulationJobErrorCodeSubnetIpLimitExceeded,
		SimulationJobErrorCodeEnilimitExceeded,
		SimulationJobErrorCodeBadPermissionsUserCredentials,
		SimulationJobErrorCodeInvalidBundleRobotApplication,
		SimulationJobErrorCodeInvalidBundleSimulationApplication,
		SimulationJobErrorCodeInvalidS3resource,
		SimulationJobErrorCodeThrottlingError,
		SimulationJobErrorCodeLimitExceeded,
		SimulationJobErrorCodeMismatchedEtag,
		SimulationJobErrorCodeRobotApplicationVersionMismatchedEtag,
		SimulationJobErrorCodeSimulationApplicationVersionMismatchedEtag,
		SimulationJobErrorCodeResourceNotFound,
		SimulationJobErrorCodeRequestThrottled,
		SimulationJobErrorCodeBatchTimedOut,
		SimulationJobErrorCodeBatchCanceled,
		SimulationJobErrorCodeInvalidInput,
		SimulationJobErrorCodeWrongRegionS3bucket,
		SimulationJobErrorCodeWrongRegionS3output,
		SimulationJobErrorCodeWrongRegionRobotApplication,
		SimulationJobErrorCodeWrongRegionSimulationApplication,
		SimulationJobErrorCodeUploadContentMismatchError,
	}
}

const (
	// SimulationJobStatusPending is a SimulationJobStatus enum value
	SimulationJobStatusPending = "Pending"

	// SimulationJobStatusPreparing is a SimulationJobStatus enum value
	SimulationJobStatusPreparing = "Preparing"

	// SimulationJobStatusRunning is a SimulationJobStatus enum value
	SimulationJobStatusRunning = "Running"

	// SimulationJobStatusRestarting is a SimulationJobStatus enum value
	SimulationJobStatusRestarting = "Restarting"

	// SimulationJobStatusCompleted is a SimulationJobStatus enum value
	SimulationJobStatusCompleted = "Completed"

	// SimulationJobStatusFailed is a SimulationJobStatus enum value
	SimulationJobStatusFailed = "Failed"

	// SimulationJobStatusRunningFailed is a SimulationJobStatus enum value
	SimulationJobStatusRunningFailed = "RunningFailed"

	// SimulationJobStatusTerminating is a SimulationJobStatus enum value
	SimulationJobStatusTerminating = "Terminating"

	// SimulationJobStatusTerminated is a SimulationJobStatus enum value
	SimulationJobStatusTerminated = "Terminated"

	// SimulationJobStatusCanceled is a SimulationJobStatus enum value
	SimulationJobStatusCanceled = "Canceled"
)

// SimulationJobStatus_Values returns all elements of the SimulationJobStatus enum
func SimulationJobStatus_Values() []string {
	return []string{
		SimulationJobStatusPending,
		SimulationJobStatusPreparing,
		SimulationJobStatusRunning,
		SimulationJobStatusRestarting,
		SimulationJobStatusCompleted,
		SimulationJobStatusFailed,
		SimulationJobStatusRunningFailed,
		SimulationJobStatusTerminating,
		SimulationJobStatusTerminated,
		SimulationJobStatusCanceled,
	}
}

const (
	// SimulationSoftwareSuiteTypeGazebo is a SimulationSoftwareSuiteType enum value
	SimulationSoftwareSuiteTypeGazebo = "Gazebo"

	// SimulationSoftwareSuiteTypeRosbagPlay is a SimulationSoftwareSuiteType enum value
	SimulationSoftwareSuiteTypeRosbagPlay = "RosbagPlay"
)

// SimulationSoftwareSuiteType_Values returns all elements of the SimulationSoftwareSuiteType enum
func SimulationSoftwareSuiteType_Values() []string {
	return []string{
		SimulationSoftwareSuiteTypeGazebo,
		SimulationSoftwareSuiteTypeRosbagPlay,
	}
}

const (
	// UploadBehaviorUploadOnTerminate is a UploadBehavior enum value
	UploadBehaviorUploadOnTerminate = "UPLOAD_ON_TERMINATE"

	// UploadBehaviorUploadRollingAutoRemove is a UploadBehavior enum value
	UploadBehaviorUploadRollingAutoRemove = "UPLOAD_ROLLING_AUTO_REMOVE"
)

// UploadBehavior_Values returns all elements of the UploadBehavior enum
func UploadBehavior_Values() []string {
	return []string{
		UploadBehaviorUploadOnTerminate,
		UploadBehaviorUploadRollingAutoRemove,
	}
}

const (
	// WorldExportJobErrorCodeInternalServiceError is a WorldExportJobErrorCode enum value
	WorldExportJobErrorCodeInternalServiceError = "InternalServiceError"

	// WorldExportJobErrorCodeLimitExceeded is a WorldExportJobErrorCode enum value
	WorldExportJobErrorCodeLimitExceeded = "LimitExceeded"

	// WorldExportJobErrorCodeResourceNotFound is a WorldExportJobErrorCode enum value
	WorldExportJobErrorCodeResourceNotFound = "ResourceNotFound"

	// WorldExportJobErrorCodeRequestThrottled is a WorldExportJobErrorCode enum value
	WorldExportJobErrorCodeRequestThrottled = "RequestThrottled"

	// WorldExportJobErrorCodeInvalidInput is a WorldExportJobErrorCode enum value
	WorldExportJobErrorCodeInvalidInput = "InvalidInput"

	// WorldExportJobErrorCodeAccessDenied is a WorldExportJobErrorCode enum value
	WorldExportJobErrorCodeAccessDenied = "AccessDenied"
)

// WorldExportJobErrorCode_Values returns all elements of the WorldExportJobErrorCode enum
func WorldExportJobErrorCode_Values() []string {
	return []string{
		WorldExportJobErrorCodeInternalServiceError,
		WorldExportJobErrorCodeLimitExceeded,
		WorldExportJobErrorCodeResourceNotFound,
		WorldExportJobErrorCodeRequestThrottled,
		WorldExportJobErrorCodeInvalidInput,
		WorldExportJobErrorCodeAccessDenied,
	}
}

const (
	// WorldExportJobStatusPending is a WorldExportJobStatus enum value
	WorldExportJobStatusPending = "Pending"

	// WorldExportJobStatusRunning is a WorldExportJobStatus enum value
	WorldExportJobStatusRunning = "Running"

	// WorldExportJobStatusCompleted is a WorldExportJobStatus enum value
	WorldExportJobStatusCompleted = "Completed"

	// WorldExportJobStatusFailed is a WorldExportJobStatus enum value
	WorldExportJobStatusFailed = "Failed"

	// WorldExportJobStatusCanceling is a WorldExportJobStatus enum value
	WorldExportJobStatusCanceling = "Canceling"

	// WorldExportJobStatusCanceled is a WorldExportJobStatus enum value
	WorldExportJobStatusCanceled = "Canceled"
)

// WorldExportJobStatus_Values returns all elements of the WorldExportJobStatus enum
func WorldExportJobStatus_Values() []string {
	return []string{
		WorldExportJobStatusPending,
		WorldExportJobStatusRunning,
		WorldExportJobStatusCompleted,
		WorldExportJobStatusFailed,
		WorldExportJobStatusCanceling,
		WorldExportJobStatusCanceled,
	}
}

const (
	// WorldGenerationJobErrorCodeInternalServiceError is a WorldGenerationJobErrorCode enum value
	WorldGenerationJobErrorCodeInternalServiceError = "InternalServiceError"

	// WorldGenerationJobErrorCodeLimitExceeded is a WorldGenerationJobErrorCode enum value
	WorldGenerationJobErrorCodeLimitExceeded = "LimitExceeded"

	// WorldGenerationJobErrorCodeResourceNotFound is a WorldGenerationJobErrorCode enum value
	WorldGenerationJobErrorCodeResourceNotFound = "ResourceNotFound"

	// WorldGenerationJobErrorCodeRequestThrottled is a WorldGenerationJobErrorCode enum value
	WorldGenerationJobErrorCodeRequestThrottled = "RequestThrottled"

	// WorldGenerationJobErrorCodeInvalidInput is a WorldGenerationJobErrorCode enum value
	WorldGenerationJobErrorCodeInvalidInput = "InvalidInput"

	// WorldGenerationJobErrorCodeAllWorldGenerationFailed is a WorldGenerationJobErrorCode enum value
	WorldGenerationJobErrorCodeAllWorldGenerationFailed = "AllWorldGenerationFailed"
)

// WorldGenerationJobErrorCode_Values returns all elements of the WorldGenerationJobErrorCode enum
func WorldGenerationJobErrorCode_Values() []string {
	return []string{
		WorldGenerationJobErrorCodeInternalServiceError,
		WorldGenerationJobErrorCodeLimitExceeded,
		WorldGenerationJobErrorCodeResourceNotFound,
		WorldGenerationJobErrorCodeRequestThrottled,
		WorldGenerationJobErrorCodeInvalidInput,
		WorldGenerationJobErrorCodeAllWorldGenerationFailed,
	}
}

const (
	// WorldGenerationJobStatusPending is a WorldGenerationJobStatus enum value
	WorldGenerationJobStatusPending = "Pending"

	// WorldGenerationJobStatusRunning is a WorldGenerationJobStatus enum value
	WorldGenerationJobStatusRunning = "Running"

	// WorldGenerationJobStatusCompleted is a WorldGenerationJobStatus enum value
	WorldGenerationJobStatusCompleted = "Completed"

	// WorldGenerationJobStatusFailed is a WorldGenerationJobStatus enum value
	WorldGenerationJobStatusFailed = "Failed"

	// WorldGenerationJobStatusPartialFailed is a WorldGenerationJobStatus enum value
	WorldGenerationJobStatusPartialFailed = "PartialFailed"

	// WorldGenerationJobStatusCanceling is a WorldGenerationJobStatus enum value
	WorldGenerationJobStatusCanceling = "Canceling"

	// WorldGenerationJobStatusCanceled is a WorldGenerationJobStatus enum value
	WorldGenerationJobStatusCanceled = "Canceled"
)

// WorldGenerationJobStatus_Values returns all elements of the WorldGenerationJobStatus enum
func WorldGenerationJobStatus_Values() []string {
	return []string{
		WorldGenerationJobStatusPending,
		WorldGenerationJobStatusRunning,
		WorldGenerationJobStatusCompleted,
		WorldGenerationJobStatusFailed,
		WorldGenerationJobStatusPartialFailed,
		WorldGenerationJobStatusCanceling,
		WorldGenerationJobStatusCanceled,
	}
}
