// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAddTagsToResource = "AddTagsToResource"

// AddTagsToResourceRequest generates a "aws/request.Request" representing the
// client's request for the AddTagsToResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AddTagsToResource for more information on using the AddTagsToResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AddTagsToResourceRequest method.
//    req, resp := client.AddTagsToResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource
func (c *DatabaseMigrationService) AddTagsToResourceRequest(input *AddTagsToResourceInput) (req *request.Request, output *AddTagsToResourceOutput) {
	op := &request.Operation{
		Name:       opAddTagsToResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsToResourceInput{}
	}

	output = &AddTagsToResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTagsToResource API operation for AWS Database Migration Service.
//
// Adds metadata tags to an DMS resource, including replication instance, endpoint,
// security group, and migration task. These tags can also be used with cost
// allocation reporting to track cost associated with DMS resources, or used
// in a Condition statement in an IAM policy for DMS. For more information,
// see Tag (https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html)
// data type description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation AddTagsToResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/AddTagsToResource
func (c *DatabaseMigrationService) AddTagsToResource(input *AddTagsToResourceInput) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	return out, req.Send()
}

// AddTagsToResourceWithContext is the same as AddTagsToResource with the addition of
// the ability to pass a context and additional request options.
//
// See AddTagsToResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) AddTagsToResourceWithContext(ctx aws.Context, input *AddTagsToResourceInput, opts ...request.Option) (*AddTagsToResourceOutput, error) {
	req, out := c.AddTagsToResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opApplyPendingMaintenanceAction = "ApplyPendingMaintenanceAction"

// ApplyPendingMaintenanceActionRequest generates a "aws/request.Request" representing the
// client's request for the ApplyPendingMaintenanceAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ApplyPendingMaintenanceAction for more information on using the ApplyPendingMaintenanceAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ApplyPendingMaintenanceActionRequest method.
//    req, resp := client.ApplyPendingMaintenanceActionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction
func (c *DatabaseMigrationService) ApplyPendingMaintenanceActionRequest(input *ApplyPendingMaintenanceActionInput) (req *request.Request, output *ApplyPendingMaintenanceActionOutput) {
	op := &request.Operation{
		Name:       opApplyPendingMaintenanceAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ApplyPendingMaintenanceActionInput{}
	}

	output = &ApplyPendingMaintenanceActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ApplyPendingMaintenanceAction API operation for AWS Database Migration Service.
//
// Applies a pending maintenance action to a resource (for example, to a replication
// instance).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ApplyPendingMaintenanceAction for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ApplyPendingMaintenanceAction
func (c *DatabaseMigrationService) ApplyPendingMaintenanceAction(input *ApplyPendingMaintenanceActionInput) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	return out, req.Send()
}

// ApplyPendingMaintenanceActionWithContext is the same as ApplyPendingMaintenanceAction with the addition of
// the ability to pass a context and additional request options.
//
// See ApplyPendingMaintenanceAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ApplyPendingMaintenanceActionWithContext(ctx aws.Context, input *ApplyPendingMaintenanceActionInput, opts ...request.Option) (*ApplyPendingMaintenanceActionOutput, error) {
	req, out := c.ApplyPendingMaintenanceActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCancelReplicationTaskAssessmentRun = "CancelReplicationTaskAssessmentRun"

// CancelReplicationTaskAssessmentRunRequest generates a "aws/request.Request" representing the
// client's request for the CancelReplicationTaskAssessmentRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CancelReplicationTaskAssessmentRun for more information on using the CancelReplicationTaskAssessmentRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CancelReplicationTaskAssessmentRunRequest method.
//    req, resp := client.CancelReplicationTaskAssessmentRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) CancelReplicationTaskAssessmentRunRequest(input *CancelReplicationTaskAssessmentRunInput) (req *request.Request, output *CancelReplicationTaskAssessmentRunOutput) {
	op := &request.Operation{
		Name:       opCancelReplicationTaskAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelReplicationTaskAssessmentRunInput{}
	}

	output = &CancelReplicationTaskAssessmentRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CancelReplicationTaskAssessmentRun API operation for AWS Database Migration Service.
//
// Cancels a single premigration assessment run.
//
// This operation prevents any individual assessments from running if they haven't
// started running. It also attempts to cancel any individual assessments that
// are currently running.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CancelReplicationTaskAssessmentRun for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CancelReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) CancelReplicationTaskAssessmentRun(input *CancelReplicationTaskAssessmentRunInput) (*CancelReplicationTaskAssessmentRunOutput, error) {
	req, out := c.CancelReplicationTaskAssessmentRunRequest(input)
	return out, req.Send()
}

// CancelReplicationTaskAssessmentRunWithContext is the same as CancelReplicationTaskAssessmentRun with the addition of
// the ability to pass a context and additional request options.
//
// See CancelReplicationTaskAssessmentRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CancelReplicationTaskAssessmentRunWithContext(ctx aws.Context, input *CancelReplicationTaskAssessmentRunInput, opts ...request.Option) (*CancelReplicationTaskAssessmentRunOutput, error) {
	req, out := c.CancelReplicationTaskAssessmentRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpoint = "CreateEndpoint"

// CreateEndpointRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpoint for more information on using the CreateEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEndpointRequest method.
//    req, resp := client.CreateEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint
func (c *DatabaseMigrationService) CreateEndpointRequest(input *CreateEndpointInput) (req *request.Request, output *CreateEndpointOutput) {
	op := &request.Operation{
		Name:       opCreateEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointInput{}
	}

	output = &CreateEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpoint API operation for AWS Database Migration Service.
//
// Creates an endpoint using the provided settings.
//
// For a MySQL source or target endpoint, don't explicitly specify the database
// using the DatabaseName request parameter on the CreateEndpoint API call.
// Specifying DatabaseName when you create a MySQL endpoint replicates all the
// task tables to this single database. For MySQL endpoints, you specify the
// database only when you specify the schema in the table-mapping rules of the
// DMS task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateEndpoint for usage and error information.
//
// Returned Error Types:
//   * KMSKeyNotAccessibleFault
//   DMS cannot access the KMS key.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * S3AccessDeniedFault
//   Insufficient privileges are preventing access to an Amazon S3 object.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEndpoint
func (c *DatabaseMigrationService) CreateEndpoint(input *CreateEndpointInput) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	return out, req.Send()
}

// CreateEndpointWithContext is the same as CreateEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateEndpointWithContext(ctx aws.Context, input *CreateEndpointInput, opts ...request.Option) (*CreateEndpointOutput, error) {
	req, out := c.CreateEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventSubscription = "CreateEventSubscription"

// CreateEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventSubscription for more information on using the CreateEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventSubscriptionRequest method.
//    req, resp := client.CreateEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription
func (c *DatabaseMigrationService) CreateEventSubscriptionRequest(input *CreateEventSubscriptionInput) (req *request.Request, output *CreateEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opCreateEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEventSubscriptionInput{}
	}

	output = &CreateEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventSubscription API operation for AWS Database Migration Service.
//
// Creates an DMS event notification subscription.
//
// You can specify the type of source (SourceType) you want to be notified of,
// provide a list of DMS source IDs (SourceIds) that triggers the events, and
// provide a list of event categories (EventCategories) for events you want
// to be notified of. If you specify both the SourceType and SourceIds, such
// as SourceType = replication-instance and SourceIdentifier = my-replinstance,
// you will be notified of all the replication instance events for the specified
// source. If you specify a SourceType but don't specify a SourceIdentifier,
// you receive notice of the events for that source type for all your DMS sources.
// If you don't specify either SourceType nor SourceIdentifier, you will be
// notified of events generated from all DMS sources belonging to your customer
// account.
//
// For more information about DMS events, see Working with Events and Notifications
// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html) in the
// Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateEventSubscription for usage and error information.
//
// Returned Error Types:
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * SNSInvalidTopicFault
//   The SNS topic is invalid.
//
//   * SNSNoAuthorizationFault
//   You are not authorized for the SNS subscription.
//
//   * KMSAccessDeniedFault
//   The ciphertext references a key that doesn't exist or that the DMS account
//   doesn't have access to.
//
//   * KMSDisabledFault
//   The specified master key (CMK) isn't enabled.
//
//   * KMSInvalidStateFault
//   The state of the specified KMS resource isn't valid for this request.
//
//   * KMSNotFoundFault
//   The specified KMS entity or resource can't be found.
//
//   * KMSThrottlingFault
//   This request triggered KMS request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateEventSubscription
func (c *DatabaseMigrationService) CreateEventSubscription(input *CreateEventSubscriptionInput) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	return out, req.Send()
}

// CreateEventSubscriptionWithContext is the same as CreateEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateEventSubscriptionWithContext(ctx aws.Context, input *CreateEventSubscriptionInput, opts ...request.Option) (*CreateEventSubscriptionOutput, error) {
	req, out := c.CreateEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationInstance = "CreateReplicationInstance"

// CreateReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationInstance for more information on using the CreateReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReplicationInstanceRequest method.
//    req, resp := client.CreateReplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance
func (c *DatabaseMigrationService) CreateReplicationInstanceRequest(input *CreateReplicationInstanceInput) (req *request.Request, output *CreateReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationInstanceInput{}
	}

	output = &CreateReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationInstance API operation for AWS Database Migration Service.
//
// Creates the replication instance using the specified parameters.
//
// DMS requires that your account have certain roles with appropriate permissions
// before you can create a replication instance. For information on the required
// roles, see Creating the IAM Roles to Use With the CLI and DMS API (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.APIRole).
// For information on the required permissions, see IAM Permissions Needed to
// Use DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#CHAP_Security.IAMPermissions).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationInstance for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * InsufficientResourceCapacityFault
//   There are not enough resources allocated to the database migration.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * StorageQuotaExceededFault
//   The storage quota has been exceeded.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * ReplicationSubnetGroupDoesNotCoverEnoughAZs
//   The replication subnet group does not cover enough Availability Zones (AZs).
//   Edit the replication subnet group and add more AZs.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * InvalidSubnet
//   The subnet provided is invalid.
//
//   * KMSKeyNotAccessibleFault
//   DMS cannot access the KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationInstance
func (c *DatabaseMigrationService) CreateReplicationInstance(input *CreateReplicationInstanceInput) (*CreateReplicationInstanceOutput, error) {
	req, out := c.CreateReplicationInstanceRequest(input)
	return out, req.Send()
}

// CreateReplicationInstanceWithContext is the same as CreateReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateReplicationInstanceWithContext(ctx aws.Context, input *CreateReplicationInstanceInput, opts ...request.Option) (*CreateReplicationInstanceOutput, error) {
	req, out := c.CreateReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationSubnetGroup = "CreateReplicationSubnetGroup"

// CreateReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationSubnetGroup for more information on using the CreateReplicationSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReplicationSubnetGroupRequest method.
//    req, resp := client.CreateReplicationSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup
func (c *DatabaseMigrationService) CreateReplicationSubnetGroupRequest(input *CreateReplicationSubnetGroupInput) (req *request.Request, output *CreateReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationSubnetGroupInput{}
	}

	output = &CreateReplicationSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Creates a replication subnet group given a list of the subnet IDs in a VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationSubnetGroup for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * ReplicationSubnetGroupDoesNotCoverEnoughAZs
//   The replication subnet group does not cover enough Availability Zones (AZs).
//   Edit the replication subnet group and add more AZs.
//
//   * InvalidSubnet
//   The subnet provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationSubnetGroup
func (c *DatabaseMigrationService) CreateReplicationSubnetGroup(input *CreateReplicationSubnetGroupInput) (*CreateReplicationSubnetGroupOutput, error) {
	req, out := c.CreateReplicationSubnetGroupRequest(input)
	return out, req.Send()
}

// CreateReplicationSubnetGroupWithContext is the same as CreateReplicationSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateReplicationSubnetGroupWithContext(ctx aws.Context, input *CreateReplicationSubnetGroupInput, opts ...request.Option) (*CreateReplicationSubnetGroupOutput, error) {
	req, out := c.CreateReplicationSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateReplicationTask = "CreateReplicationTask"

// CreateReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the CreateReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateReplicationTask for more information on using the CreateReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateReplicationTaskRequest method.
//    req, resp := client.CreateReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask
func (c *DatabaseMigrationService) CreateReplicationTaskRequest(input *CreateReplicationTaskInput) (req *request.Request, output *CreateReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opCreateReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateReplicationTaskInput{}
	}

	output = &CreateReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateReplicationTask API operation for AWS Database Migration Service.
//
// Creates a replication task using the specified parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation CreateReplicationTask for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * KMSKeyNotAccessibleFault
//   DMS cannot access the KMS key.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/CreateReplicationTask
func (c *DatabaseMigrationService) CreateReplicationTask(input *CreateReplicationTaskInput) (*CreateReplicationTaskOutput, error) {
	req, out := c.CreateReplicationTaskRequest(input)
	return out, req.Send()
}

// CreateReplicationTaskWithContext is the same as CreateReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) CreateReplicationTaskWithContext(ctx aws.Context, input *CreateReplicationTaskInput, opts ...request.Option) (*CreateReplicationTaskOutput, error) {
	req, out := c.CreateReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCertificate = "DeleteCertificate"

// DeleteCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCertificate for more information on using the DeleteCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteCertificateRequest method.
//    req, resp := client.DeleteCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate
func (c *DatabaseMigrationService) DeleteCertificateRequest(input *DeleteCertificateInput) (req *request.Request, output *DeleteCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCertificateInput{}
	}

	output = &DeleteCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteCertificate API operation for AWS Database Migration Service.
//
// Deletes the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteCertificate for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteCertificate
func (c *DatabaseMigrationService) DeleteCertificate(input *DeleteCertificateInput) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	return out, req.Send()
}

// DeleteCertificateWithContext is the same as DeleteCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteCertificateWithContext(ctx aws.Context, input *DeleteCertificateInput, opts ...request.Option) (*DeleteCertificateOutput, error) {
	req, out := c.DeleteCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnection for more information on using the DeleteConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectionRequest method.
//    req, resp := client.DeleteConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection
func (c *DatabaseMigrationService) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *DeleteConnectionOutput) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	output = &DeleteConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteConnection API operation for AWS Database Migration Service.
//
// Deletes the connection between a replication instance and an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteConnection for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteConnection
func (c *DatabaseMigrationService) DeleteConnection(input *DeleteConnectionInput) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	return out, req.Send()
}

// DeleteConnectionWithContext is the same as DeleteConnection with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteConnectionWithContext(ctx aws.Context, input *DeleteConnectionInput, opts ...request.Option) (*DeleteConnectionOutput, error) {
	req, out := c.DeleteConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpoint for more information on using the DeleteEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEndpointRequest method.
//    req, resp := client.DeleteEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint
func (c *DatabaseMigrationService) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	output = &DeleteEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEndpoint API operation for AWS Database Migration Service.
//
// Deletes the specified endpoint.
//
// All tasks associated with the endpoint must be deleted before you can delete
// the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteEndpoint for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEndpoint
func (c *DatabaseMigrationService) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	return out, req.Send()
}

// DeleteEndpointWithContext is the same as DeleteEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteEndpointWithContext(ctx aws.Context, input *DeleteEndpointInput, opts ...request.Option) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventSubscription = "DeleteEventSubscription"

// DeleteEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventSubscription for more information on using the DeleteEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventSubscriptionRequest method.
//    req, resp := client.DeleteEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription
func (c *DatabaseMigrationService) DeleteEventSubscriptionRequest(input *DeleteEventSubscriptionInput) (req *request.Request, output *DeleteEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opDeleteEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEventSubscriptionInput{}
	}

	output = &DeleteEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEventSubscription API operation for AWS Database Migration Service.
//
// Deletes an DMS event subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteEventSubscription for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteEventSubscription
func (c *DatabaseMigrationService) DeleteEventSubscription(input *DeleteEventSubscriptionInput) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	return out, req.Send()
}

// DeleteEventSubscriptionWithContext is the same as DeleteEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteEventSubscriptionWithContext(ctx aws.Context, input *DeleteEventSubscriptionInput, opts ...request.Option) (*DeleteEventSubscriptionOutput, error) {
	req, out := c.DeleteEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationInstance = "DeleteReplicationInstance"

// DeleteReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationInstance for more information on using the DeleteReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReplicationInstanceRequest method.
//    req, resp := client.DeleteReplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance
func (c *DatabaseMigrationService) DeleteReplicationInstanceRequest(input *DeleteReplicationInstanceInput) (req *request.Request, output *DeleteReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationInstanceInput{}
	}

	output = &DeleteReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationInstance API operation for AWS Database Migration Service.
//
// Deletes the specified replication instance.
//
// You must delete any migration tasks that are associated with the replication
// instance before you can delete it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationInstance for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationInstance
func (c *DatabaseMigrationService) DeleteReplicationInstance(input *DeleteReplicationInstanceInput) (*DeleteReplicationInstanceOutput, error) {
	req, out := c.DeleteReplicationInstanceRequest(input)
	return out, req.Send()
}

// DeleteReplicationInstanceWithContext is the same as DeleteReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationInstanceWithContext(ctx aws.Context, input *DeleteReplicationInstanceInput, opts ...request.Option) (*DeleteReplicationInstanceOutput, error) {
	req, out := c.DeleteReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationSubnetGroup = "DeleteReplicationSubnetGroup"

// DeleteReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationSubnetGroup for more information on using the DeleteReplicationSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReplicationSubnetGroupRequest method.
//    req, resp := client.DeleteReplicationSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroupRequest(input *DeleteReplicationSubnetGroupInput) (req *request.Request, output *DeleteReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationSubnetGroupInput{}
	}

	output = &DeleteReplicationSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Deletes a subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationSubnetGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationSubnetGroup
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroup(input *DeleteReplicationSubnetGroupInput) (*DeleteReplicationSubnetGroupOutput, error) {
	req, out := c.DeleteReplicationSubnetGroupRequest(input)
	return out, req.Send()
}

// DeleteReplicationSubnetGroupWithContext is the same as DeleteReplicationSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationSubnetGroupWithContext(ctx aws.Context, input *DeleteReplicationSubnetGroupInput, opts ...request.Option) (*DeleteReplicationSubnetGroupOutput, error) {
	req, out := c.DeleteReplicationSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationTask = "DeleteReplicationTask"

// DeleteReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationTask for more information on using the DeleteReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReplicationTaskRequest method.
//    req, resp := client.DeleteReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask
func (c *DatabaseMigrationService) DeleteReplicationTaskRequest(input *DeleteReplicationTaskInput) (req *request.Request, output *DeleteReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationTaskInput{}
	}

	output = &DeleteReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationTask API operation for AWS Database Migration Service.
//
// Deletes the specified replication task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationTask for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTask
func (c *DatabaseMigrationService) DeleteReplicationTask(input *DeleteReplicationTaskInput) (*DeleteReplicationTaskOutput, error) {
	req, out := c.DeleteReplicationTaskRequest(input)
	return out, req.Send()
}

// DeleteReplicationTaskWithContext is the same as DeleteReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationTaskWithContext(ctx aws.Context, input *DeleteReplicationTaskInput, opts ...request.Option) (*DeleteReplicationTaskOutput, error) {
	req, out := c.DeleteReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteReplicationTaskAssessmentRun = "DeleteReplicationTaskAssessmentRun"

// DeleteReplicationTaskAssessmentRunRequest generates a "aws/request.Request" representing the
// client's request for the DeleteReplicationTaskAssessmentRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteReplicationTaskAssessmentRun for more information on using the DeleteReplicationTaskAssessmentRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteReplicationTaskAssessmentRunRequest method.
//    req, resp := client.DeleteReplicationTaskAssessmentRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) DeleteReplicationTaskAssessmentRunRequest(input *DeleteReplicationTaskAssessmentRunInput) (req *request.Request, output *DeleteReplicationTaskAssessmentRunOutput) {
	op := &request.Operation{
		Name:       opDeleteReplicationTaskAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteReplicationTaskAssessmentRunInput{}
	}

	output = &DeleteReplicationTaskAssessmentRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteReplicationTaskAssessmentRun API operation for AWS Database Migration Service.
//
// Deletes the record of a single premigration assessment run.
//
// This operation removes all metadata that DMS maintains about this assessment
// run. However, the operation leaves untouched all information about this assessment
// run that is stored in your Amazon S3 bucket.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DeleteReplicationTaskAssessmentRun for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DeleteReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) DeleteReplicationTaskAssessmentRun(input *DeleteReplicationTaskAssessmentRunInput) (*DeleteReplicationTaskAssessmentRunOutput, error) {
	req, out := c.DeleteReplicationTaskAssessmentRunRequest(input)
	return out, req.Send()
}

// DeleteReplicationTaskAssessmentRunWithContext is the same as DeleteReplicationTaskAssessmentRun with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteReplicationTaskAssessmentRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DeleteReplicationTaskAssessmentRunWithContext(ctx aws.Context, input *DeleteReplicationTaskAssessmentRunInput, opts ...request.Option) (*DeleteReplicationTaskAssessmentRunOutput, error) {
	req, out := c.DeleteReplicationTaskAssessmentRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes
func (c *DatabaseMigrationService) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for AWS Database Migration Service.
//
// Lists all of the DMS attributes for a customer account. These attributes
// include DMS quotas for the account and a unique account identifier in a particular
// DMS region. DMS quotas include a list of resource quotas supported by the
// account, such as the number of replication instances allowed. The description
// for each resource quota, includes the quota name, current usage toward that
// quota, and the quota's maximum value. DMS uses the unique account identifier
// to name each artifact used by DMS in the given region.
//
// This command does not take any parameters.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeAccountAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeAccountAttributes
func (c *DatabaseMigrationService) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeApplicableIndividualAssessments = "DescribeApplicableIndividualAssessments"

// DescribeApplicableIndividualAssessmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeApplicableIndividualAssessments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeApplicableIndividualAssessments for more information on using the DescribeApplicableIndividualAssessments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeApplicableIndividualAssessmentsRequest method.
//    req, resp := client.DescribeApplicableIndividualAssessmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments
func (c *DatabaseMigrationService) DescribeApplicableIndividualAssessmentsRequest(input *DescribeApplicableIndividualAssessmentsInput) (req *request.Request, output *DescribeApplicableIndividualAssessmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeApplicableIndividualAssessments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeApplicableIndividualAssessmentsInput{}
	}

	output = &DescribeApplicableIndividualAssessmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeApplicableIndividualAssessments API operation for AWS Database Migration Service.
//
// Provides a list of individual assessments that you can specify for a new
// premigration assessment run, given one or more parameters.
//
// If you specify an existing migration task, this operation provides the default
// individual assessments you can specify for that task. Otherwise, the specified
// parameters model elements of a possible migration task on which to base a
// premigration assessment run.
//
// To use these migration task modeling parameters, you must specify an existing
// replication instance, a source database engine, a target database engine,
// and a migration type. This combination of parameters potentially limits the
// default individual assessments available for an assessment run created for
// a corresponding migration task.
//
// If you specify no parameters, this operation provides a list of all possible
// individual assessments that you can specify for an assessment run. If you
// specify any one of the task modeling parameters, you must specify all of
// them or the operation cannot provide a list of individual assessments. The
// only parameter that you can specify alone is for an existing migration task.
// The specified task definition then determines the default list of individual
// assessments that you can specify in an assessment run for the task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeApplicableIndividualAssessments for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeApplicableIndividualAssessments
func (c *DatabaseMigrationService) DescribeApplicableIndividualAssessments(input *DescribeApplicableIndividualAssessmentsInput) (*DescribeApplicableIndividualAssessmentsOutput, error) {
	req, out := c.DescribeApplicableIndividualAssessmentsRequest(input)
	return out, req.Send()
}

// DescribeApplicableIndividualAssessmentsWithContext is the same as DescribeApplicableIndividualAssessments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeApplicableIndividualAssessments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeApplicableIndividualAssessmentsWithContext(ctx aws.Context, input *DescribeApplicableIndividualAssessmentsInput, opts ...request.Option) (*DescribeApplicableIndividualAssessmentsOutput, error) {
	req, out := c.DescribeApplicableIndividualAssessmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeApplicableIndividualAssessmentsPages iterates over the pages of a DescribeApplicableIndividualAssessments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeApplicableIndividualAssessments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeApplicableIndividualAssessments operation.
//    pageNum := 0
//    err := client.DescribeApplicableIndividualAssessmentsPages(params,
//        func(page *databasemigrationservice.DescribeApplicableIndividualAssessmentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeApplicableIndividualAssessmentsPages(input *DescribeApplicableIndividualAssessmentsInput, fn func(*DescribeApplicableIndividualAssessmentsOutput, bool) bool) error {
	return c.DescribeApplicableIndividualAssessmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeApplicableIndividualAssessmentsPagesWithContext same as DescribeApplicableIndividualAssessmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeApplicableIndividualAssessmentsPagesWithContext(ctx aws.Context, input *DescribeApplicableIndividualAssessmentsInput, fn func(*DescribeApplicableIndividualAssessmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeApplicableIndividualAssessmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeApplicableIndividualAssessmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeApplicableIndividualAssessmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeCertificates = "DescribeCertificates"

// DescribeCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeCertificates for more information on using the DescribeCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeCertificatesRequest method.
//    req, resp := client.DescribeCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates
func (c *DatabaseMigrationService) DescribeCertificatesRequest(input *DescribeCertificatesInput) (req *request.Request, output *DescribeCertificatesOutput) {
	op := &request.Operation{
		Name:       opDescribeCertificates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeCertificatesInput{}
	}

	output = &DescribeCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeCertificates API operation for AWS Database Migration Service.
//
// Provides a description of the certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeCertificates for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeCertificates
func (c *DatabaseMigrationService) DescribeCertificates(input *DescribeCertificatesInput) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	return out, req.Send()
}

// DescribeCertificatesWithContext is the same as DescribeCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeCertificatesWithContext(ctx aws.Context, input *DescribeCertificatesInput, opts ...request.Option) (*DescribeCertificatesOutput, error) {
	req, out := c.DescribeCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeCertificatesPages iterates over the pages of a DescribeCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeCertificates operation.
//    pageNum := 0
//    err := client.DescribeCertificatesPages(params,
//        func(page *databasemigrationservice.DescribeCertificatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeCertificatesPages(input *DescribeCertificatesInput, fn func(*DescribeCertificatesOutput, bool) bool) error {
	return c.DescribeCertificatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeCertificatesPagesWithContext same as DescribeCertificatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeCertificatesPagesWithContext(ctx aws.Context, input *DescribeCertificatesInput, fn func(*DescribeCertificatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeCertificatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeCertificatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeCertificatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeConnections = "DescribeConnections"

// DescribeConnectionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnections operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnections for more information on using the DescribeConnections
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectionsRequest method.
//    req, resp := client.DescribeConnectionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections
func (c *DatabaseMigrationService) DescribeConnectionsRequest(input *DescribeConnectionsInput) (req *request.Request, output *DescribeConnectionsOutput) {
	op := &request.Operation{
		Name:       opDescribeConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeConnectionsInput{}
	}

	output = &DescribeConnectionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnections API operation for AWS Database Migration Service.
//
// Describes the status of the connections that have been made between the replication
// instance and an endpoint. Connections are created when you test an endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeConnections for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeConnections
func (c *DatabaseMigrationService) DescribeConnections(input *DescribeConnectionsInput) (*DescribeConnectionsOutput, error) {
	req, out := c.DescribeConnectionsRequest(input)
	return out, req.Send()
}

// DescribeConnectionsWithContext is the same as DescribeConnections with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnections for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeConnectionsWithContext(ctx aws.Context, input *DescribeConnectionsInput, opts ...request.Option) (*DescribeConnectionsOutput, error) {
	req, out := c.DescribeConnectionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeConnectionsPages iterates over the pages of a DescribeConnections operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeConnections method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeConnections operation.
//    pageNum := 0
//    err := client.DescribeConnectionsPages(params,
//        func(page *databasemigrationservice.DescribeConnectionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeConnectionsPages(input *DescribeConnectionsInput, fn func(*DescribeConnectionsOutput, bool) bool) error {
	return c.DescribeConnectionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeConnectionsPagesWithContext same as DescribeConnectionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeConnectionsPagesWithContext(ctx aws.Context, input *DescribeConnectionsInput, fn func(*DescribeConnectionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeConnectionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeConnectionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeConnectionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEndpointSettings = "DescribeEndpointSettings"

// DescribeEndpointSettingsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointSettings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpointSettings for more information on using the DescribeEndpointSettings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointSettingsRequest method.
//    req, resp := client.DescribeEndpointSettingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings
func (c *DatabaseMigrationService) DescribeEndpointSettingsRequest(input *DescribeEndpointSettingsInput) (req *request.Request, output *DescribeEndpointSettingsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEndpointSettingsInput{}
	}

	output = &DescribeEndpointSettingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpointSettings API operation for AWS Database Migration Service.
//
// Returns information about the possible endpoint settings available when you
// create an endpoint for a specific database engine.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEndpointSettings for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointSettings
func (c *DatabaseMigrationService) DescribeEndpointSettings(input *DescribeEndpointSettingsInput) (*DescribeEndpointSettingsOutput, error) {
	req, out := c.DescribeEndpointSettingsRequest(input)
	return out, req.Send()
}

// DescribeEndpointSettingsWithContext is the same as DescribeEndpointSettings with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpointSettings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointSettingsWithContext(ctx aws.Context, input *DescribeEndpointSettingsInput, opts ...request.Option) (*DescribeEndpointSettingsOutput, error) {
	req, out := c.DescribeEndpointSettingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEndpointSettingsPages iterates over the pages of a DescribeEndpointSettings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEndpointSettings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEndpointSettings operation.
//    pageNum := 0
//    err := client.DescribeEndpointSettingsPages(params,
//        func(page *databasemigrationservice.DescribeEndpointSettingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeEndpointSettingsPages(input *DescribeEndpointSettingsInput, fn func(*DescribeEndpointSettingsOutput, bool) bool) error {
	return c.DescribeEndpointSettingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEndpointSettingsPagesWithContext same as DescribeEndpointSettingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointSettingsPagesWithContext(ctx aws.Context, input *DescribeEndpointSettingsInput, fn func(*DescribeEndpointSettingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEndpointSettingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEndpointSettingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEndpointSettingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEndpointTypes = "DescribeEndpointTypes"

// DescribeEndpointTypesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpointTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpointTypes for more information on using the DescribeEndpointTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointTypesRequest method.
//    req, resp := client.DescribeEndpointTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes
func (c *DatabaseMigrationService) DescribeEndpointTypesRequest(input *DescribeEndpointTypesInput) (req *request.Request, output *DescribeEndpointTypesOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpointTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEndpointTypesInput{}
	}

	output = &DescribeEndpointTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpointTypes API operation for AWS Database Migration Service.
//
// Returns information about the type of endpoints available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEndpointTypes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpointTypes
func (c *DatabaseMigrationService) DescribeEndpointTypes(input *DescribeEndpointTypesInput) (*DescribeEndpointTypesOutput, error) {
	req, out := c.DescribeEndpointTypesRequest(input)
	return out, req.Send()
}

// DescribeEndpointTypesWithContext is the same as DescribeEndpointTypes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpointTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointTypesWithContext(ctx aws.Context, input *DescribeEndpointTypesInput, opts ...request.Option) (*DescribeEndpointTypesOutput, error) {
	req, out := c.DescribeEndpointTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEndpointTypesPages iterates over the pages of a DescribeEndpointTypes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEndpointTypes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEndpointTypes operation.
//    pageNum := 0
//    err := client.DescribeEndpointTypesPages(params,
//        func(page *databasemigrationservice.DescribeEndpointTypesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeEndpointTypesPages(input *DescribeEndpointTypesInput, fn func(*DescribeEndpointTypesOutput, bool) bool) error {
	return c.DescribeEndpointTypesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEndpointTypesPagesWithContext same as DescribeEndpointTypesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointTypesPagesWithContext(ctx aws.Context, input *DescribeEndpointTypesInput, fn func(*DescribeEndpointTypesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEndpointTypesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEndpointTypesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEndpointTypesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEndpoints = "DescribeEndpoints"

// DescribeEndpointsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEndpoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEndpoints for more information on using the DescribeEndpoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEndpointsRequest method.
//    req, resp := client.DescribeEndpointsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints
func (c *DatabaseMigrationService) DescribeEndpointsRequest(input *DescribeEndpointsInput) (req *request.Request, output *DescribeEndpointsOutput) {
	op := &request.Operation{
		Name:       opDescribeEndpoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEndpointsInput{}
	}

	output = &DescribeEndpointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEndpoints API operation for AWS Database Migration Service.
//
// Returns information about the endpoints for your account in the current region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEndpoints for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEndpoints
func (c *DatabaseMigrationService) DescribeEndpoints(input *DescribeEndpointsInput) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	return out, req.Send()
}

// DescribeEndpointsWithContext is the same as DescribeEndpoints with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEndpoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointsWithContext(ctx aws.Context, input *DescribeEndpointsInput, opts ...request.Option) (*DescribeEndpointsOutput, error) {
	req, out := c.DescribeEndpointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEndpointsPages iterates over the pages of a DescribeEndpoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEndpoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEndpoints operation.
//    pageNum := 0
//    err := client.DescribeEndpointsPages(params,
//        func(page *databasemigrationservice.DescribeEndpointsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeEndpointsPages(input *DescribeEndpointsInput, fn func(*DescribeEndpointsOutput, bool) bool) error {
	return c.DescribeEndpointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEndpointsPagesWithContext same as DescribeEndpointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEndpointsPagesWithContext(ctx aws.Context, input *DescribeEndpointsInput, fn func(*DescribeEndpointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEndpointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEndpointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEndpointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEventCategories = "DescribeEventCategories"

// DescribeEventCategoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventCategories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventCategories for more information on using the DescribeEventCategories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventCategoriesRequest method.
//    req, resp := client.DescribeEventCategoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories
func (c *DatabaseMigrationService) DescribeEventCategoriesRequest(input *DescribeEventCategoriesInput) (req *request.Request, output *DescribeEventCategoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeEventCategories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventCategoriesInput{}
	}

	output = &DescribeEventCategoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventCategories API operation for AWS Database Migration Service.
//
// Lists categories for all event source types, or, if specified, for a specified
// source type. You can see a list of the event categories and source types
// in Working with Events and Notifications (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html)
// in the Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEventCategories for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventCategories
func (c *DatabaseMigrationService) DescribeEventCategories(input *DescribeEventCategoriesInput) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	return out, req.Send()
}

// DescribeEventCategoriesWithContext is the same as DescribeEventCategories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventCategories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventCategoriesWithContext(ctx aws.Context, input *DescribeEventCategoriesInput, opts ...request.Option) (*DescribeEventCategoriesOutput, error) {
	req, out := c.DescribeEventCategoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEventSubscriptions = "DescribeEventSubscriptions"

// DescribeEventSubscriptionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEventSubscriptions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEventSubscriptions for more information on using the DescribeEventSubscriptions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventSubscriptionsRequest method.
//    req, resp := client.DescribeEventSubscriptionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions
func (c *DatabaseMigrationService) DescribeEventSubscriptionsRequest(input *DescribeEventSubscriptionsInput) (req *request.Request, output *DescribeEventSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opDescribeEventSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventSubscriptionsInput{}
	}

	output = &DescribeEventSubscriptionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEventSubscriptions API operation for AWS Database Migration Service.
//
// Lists all the event subscriptions for a customer account. The description
// of a subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType,
// SourceID, CreationTime, and Status.
//
// If you specify SubscriptionName, this action lists the description for that
// subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEventSubscriptions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEventSubscriptions
func (c *DatabaseMigrationService) DescribeEventSubscriptions(input *DescribeEventSubscriptionsInput) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	return out, req.Send()
}

// DescribeEventSubscriptionsWithContext is the same as DescribeEventSubscriptions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEventSubscriptions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventSubscriptionsWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, opts ...request.Option) (*DescribeEventSubscriptionsOutput, error) {
	req, out := c.DescribeEventSubscriptionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventSubscriptionsPages iterates over the pages of a DescribeEventSubscriptions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEventSubscriptions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEventSubscriptions operation.
//    pageNum := 0
//    err := client.DescribeEventSubscriptionsPages(params,
//        func(page *databasemigrationservice.DescribeEventSubscriptionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeEventSubscriptionsPages(input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool) error {
	return c.DescribeEventSubscriptionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventSubscriptionsPagesWithContext same as DescribeEventSubscriptionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventSubscriptionsPagesWithContext(ctx aws.Context, input *DescribeEventSubscriptionsInput, fn func(*DescribeEventSubscriptionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventSubscriptionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventSubscriptionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventSubscriptionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents
func (c *DatabaseMigrationService) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for AWS Database Migration Service.
//
// Lists events for a given source identifier and source type. You can also
// specify a start and end time. For more information on DMS events, see Working
// with Events and Notifications (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html)
// in the Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeEvents for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeEvents
func (c *DatabaseMigrationService) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeEventsPages iterates over the pages of a DescribeEvents operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeEvents method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeEvents operation.
//    pageNum := 0
//    err := client.DescribeEventsPages(params,
//        func(page *databasemigrationservice.DescribeEventsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeEventsPages(input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool) error {
	return c.DescribeEventsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeEventsPagesWithContext same as DescribeEventsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeEventsPagesWithContext(ctx aws.Context, input *DescribeEventsInput, fn func(*DescribeEventsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeEventsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeEventsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeEventsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeOrderableReplicationInstances = "DescribeOrderableReplicationInstances"

// DescribeOrderableReplicationInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeOrderableReplicationInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeOrderableReplicationInstances for more information on using the DescribeOrderableReplicationInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeOrderableReplicationInstancesRequest method.
//    req, resp := client.DescribeOrderableReplicationInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesRequest(input *DescribeOrderableReplicationInstancesInput) (req *request.Request, output *DescribeOrderableReplicationInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeOrderableReplicationInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeOrderableReplicationInstancesInput{}
	}

	output = &DescribeOrderableReplicationInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeOrderableReplicationInstances API operation for AWS Database Migration Service.
//
// Returns information about the replication instance types that can be created
// in the specified region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeOrderableReplicationInstances for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeOrderableReplicationInstances
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstances(input *DescribeOrderableReplicationInstancesInput) (*DescribeOrderableReplicationInstancesOutput, error) {
	req, out := c.DescribeOrderableReplicationInstancesRequest(input)
	return out, req.Send()
}

// DescribeOrderableReplicationInstancesWithContext is the same as DescribeOrderableReplicationInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeOrderableReplicationInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesWithContext(ctx aws.Context, input *DescribeOrderableReplicationInstancesInput, opts ...request.Option) (*DescribeOrderableReplicationInstancesOutput, error) {
	req, out := c.DescribeOrderableReplicationInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeOrderableReplicationInstancesPages iterates over the pages of a DescribeOrderableReplicationInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeOrderableReplicationInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeOrderableReplicationInstances operation.
//    pageNum := 0
//    err := client.DescribeOrderableReplicationInstancesPages(params,
//        func(page *databasemigrationservice.DescribeOrderableReplicationInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesPages(input *DescribeOrderableReplicationInstancesInput, fn func(*DescribeOrderableReplicationInstancesOutput, bool) bool) error {
	return c.DescribeOrderableReplicationInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeOrderableReplicationInstancesPagesWithContext same as DescribeOrderableReplicationInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeOrderableReplicationInstancesPagesWithContext(ctx aws.Context, input *DescribeOrderableReplicationInstancesInput, fn func(*DescribeOrderableReplicationInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeOrderableReplicationInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeOrderableReplicationInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeOrderableReplicationInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribePendingMaintenanceActions = "DescribePendingMaintenanceActions"

// DescribePendingMaintenanceActionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribePendingMaintenanceActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePendingMaintenanceActions for more information on using the DescribePendingMaintenanceActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribePendingMaintenanceActionsRequest method.
//    req, resp := client.DescribePendingMaintenanceActionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions
func (c *DatabaseMigrationService) DescribePendingMaintenanceActionsRequest(input *DescribePendingMaintenanceActionsInput) (req *request.Request, output *DescribePendingMaintenanceActionsOutput) {
	op := &request.Operation{
		Name:       opDescribePendingMaintenanceActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePendingMaintenanceActionsInput{}
	}

	output = &DescribePendingMaintenanceActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePendingMaintenanceActions API operation for AWS Database Migration Service.
//
// For internal use only
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribePendingMaintenanceActions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions
func (c *DatabaseMigrationService) DescribePendingMaintenanceActions(input *DescribePendingMaintenanceActionsInput) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	return out, req.Send()
}

// DescribePendingMaintenanceActionsWithContext is the same as DescribePendingMaintenanceActions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePendingMaintenanceActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribePendingMaintenanceActionsWithContext(ctx aws.Context, input *DescribePendingMaintenanceActionsInput, opts ...request.Option) (*DescribePendingMaintenanceActionsOutput, error) {
	req, out := c.DescribePendingMaintenanceActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribePendingMaintenanceActionsPages iterates over the pages of a DescribePendingMaintenanceActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribePendingMaintenanceActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribePendingMaintenanceActions operation.
//    pageNum := 0
//    err := client.DescribePendingMaintenanceActionsPages(params,
//        func(page *databasemigrationservice.DescribePendingMaintenanceActionsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribePendingMaintenanceActionsPages(input *DescribePendingMaintenanceActionsInput, fn func(*DescribePendingMaintenanceActionsOutput, bool) bool) error {
	return c.DescribePendingMaintenanceActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribePendingMaintenanceActionsPagesWithContext same as DescribePendingMaintenanceActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribePendingMaintenanceActionsPagesWithContext(ctx aws.Context, input *DescribePendingMaintenanceActionsInput, fn func(*DescribePendingMaintenanceActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribePendingMaintenanceActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribePendingMaintenanceActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribePendingMaintenanceActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeRefreshSchemasStatus = "DescribeRefreshSchemasStatus"

// DescribeRefreshSchemasStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRefreshSchemasStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRefreshSchemasStatus for more information on using the DescribeRefreshSchemasStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeRefreshSchemasStatusRequest method.
//    req, resp := client.DescribeRefreshSchemasStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatusRequest(input *DescribeRefreshSchemasStatusInput) (req *request.Request, output *DescribeRefreshSchemasStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeRefreshSchemasStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeRefreshSchemasStatusInput{}
	}

	output = &DescribeRefreshSchemasStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRefreshSchemasStatus API operation for AWS Database Migration Service.
//
// Returns the status of the RefreshSchemas operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeRefreshSchemasStatus for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeRefreshSchemasStatus
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatus(input *DescribeRefreshSchemasStatusInput) (*DescribeRefreshSchemasStatusOutput, error) {
	req, out := c.DescribeRefreshSchemasStatusRequest(input)
	return out, req.Send()
}

// DescribeRefreshSchemasStatusWithContext is the same as DescribeRefreshSchemasStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRefreshSchemasStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeRefreshSchemasStatusWithContext(ctx aws.Context, input *DescribeRefreshSchemasStatusInput, opts ...request.Option) (*DescribeRefreshSchemasStatusOutput, error) {
	req, out := c.DescribeRefreshSchemasStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeReplicationInstanceTaskLogs = "DescribeReplicationInstanceTaskLogs"

// DescribeReplicationInstanceTaskLogsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationInstanceTaskLogs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationInstanceTaskLogs for more information on using the DescribeReplicationInstanceTaskLogs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationInstanceTaskLogsRequest method.
//    req, resp := client.DescribeReplicationInstanceTaskLogsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs
func (c *DatabaseMigrationService) DescribeReplicationInstanceTaskLogsRequest(input *DescribeReplicationInstanceTaskLogsInput) (req *request.Request, output *DescribeReplicationInstanceTaskLogsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationInstanceTaskLogs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationInstanceTaskLogsInput{}
	}

	output = &DescribeReplicationInstanceTaskLogsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationInstanceTaskLogs API operation for AWS Database Migration Service.
//
// Returns information about the task logs for the specified task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationInstanceTaskLogs for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstanceTaskLogs
func (c *DatabaseMigrationService) DescribeReplicationInstanceTaskLogs(input *DescribeReplicationInstanceTaskLogsInput) (*DescribeReplicationInstanceTaskLogsOutput, error) {
	req, out := c.DescribeReplicationInstanceTaskLogsRequest(input)
	return out, req.Send()
}

// DescribeReplicationInstanceTaskLogsWithContext is the same as DescribeReplicationInstanceTaskLogs with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationInstanceTaskLogs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationInstanceTaskLogsWithContext(ctx aws.Context, input *DescribeReplicationInstanceTaskLogsInput, opts ...request.Option) (*DescribeReplicationInstanceTaskLogsOutput, error) {
	req, out := c.DescribeReplicationInstanceTaskLogsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationInstanceTaskLogsPages iterates over the pages of a DescribeReplicationInstanceTaskLogs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationInstanceTaskLogs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationInstanceTaskLogs operation.
//    pageNum := 0
//    err := client.DescribeReplicationInstanceTaskLogsPages(params,
//        func(page *databasemigrationservice.DescribeReplicationInstanceTaskLogsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationInstanceTaskLogsPages(input *DescribeReplicationInstanceTaskLogsInput, fn func(*DescribeReplicationInstanceTaskLogsOutput, bool) bool) error {
	return c.DescribeReplicationInstanceTaskLogsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationInstanceTaskLogsPagesWithContext same as DescribeReplicationInstanceTaskLogsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationInstanceTaskLogsPagesWithContext(ctx aws.Context, input *DescribeReplicationInstanceTaskLogsInput, fn func(*DescribeReplicationInstanceTaskLogsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationInstanceTaskLogsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationInstanceTaskLogsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationInstanceTaskLogsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationInstances = "DescribeReplicationInstances"

// DescribeReplicationInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationInstances for more information on using the DescribeReplicationInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationInstancesRequest method.
//    req, resp := client.DescribeReplicationInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances
func (c *DatabaseMigrationService) DescribeReplicationInstancesRequest(input *DescribeReplicationInstancesInput) (req *request.Request, output *DescribeReplicationInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationInstancesInput{}
	}

	output = &DescribeReplicationInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationInstances API operation for AWS Database Migration Service.
//
// Returns information about replication instances for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationInstances for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationInstances
func (c *DatabaseMigrationService) DescribeReplicationInstances(input *DescribeReplicationInstancesInput) (*DescribeReplicationInstancesOutput, error) {
	req, out := c.DescribeReplicationInstancesRequest(input)
	return out, req.Send()
}

// DescribeReplicationInstancesWithContext is the same as DescribeReplicationInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationInstancesWithContext(ctx aws.Context, input *DescribeReplicationInstancesInput, opts ...request.Option) (*DescribeReplicationInstancesOutput, error) {
	req, out := c.DescribeReplicationInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationInstancesPages iterates over the pages of a DescribeReplicationInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationInstances operation.
//    pageNum := 0
//    err := client.DescribeReplicationInstancesPages(params,
//        func(page *databasemigrationservice.DescribeReplicationInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationInstancesPages(input *DescribeReplicationInstancesInput, fn func(*DescribeReplicationInstancesOutput, bool) bool) error {
	return c.DescribeReplicationInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationInstancesPagesWithContext same as DescribeReplicationInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationInstancesPagesWithContext(ctx aws.Context, input *DescribeReplicationInstancesInput, fn func(*DescribeReplicationInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationSubnetGroups = "DescribeReplicationSubnetGroups"

// DescribeReplicationSubnetGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationSubnetGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationSubnetGroups for more information on using the DescribeReplicationSubnetGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationSubnetGroupsRequest method.
//    req, resp := client.DescribeReplicationSubnetGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsRequest(input *DescribeReplicationSubnetGroupsInput) (req *request.Request, output *DescribeReplicationSubnetGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationSubnetGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationSubnetGroupsInput{}
	}

	output = &DescribeReplicationSubnetGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationSubnetGroups API operation for AWS Database Migration Service.
//
// Returns information about the replication subnet groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationSubnetGroups for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationSubnetGroups
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroups(input *DescribeReplicationSubnetGroupsInput) (*DescribeReplicationSubnetGroupsOutput, error) {
	req, out := c.DescribeReplicationSubnetGroupsRequest(input)
	return out, req.Send()
}

// DescribeReplicationSubnetGroupsWithContext is the same as DescribeReplicationSubnetGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationSubnetGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsWithContext(ctx aws.Context, input *DescribeReplicationSubnetGroupsInput, opts ...request.Option) (*DescribeReplicationSubnetGroupsOutput, error) {
	req, out := c.DescribeReplicationSubnetGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationSubnetGroupsPages iterates over the pages of a DescribeReplicationSubnetGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationSubnetGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationSubnetGroups operation.
//    pageNum := 0
//    err := client.DescribeReplicationSubnetGroupsPages(params,
//        func(page *databasemigrationservice.DescribeReplicationSubnetGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsPages(input *DescribeReplicationSubnetGroupsInput, fn func(*DescribeReplicationSubnetGroupsOutput, bool) bool) error {
	return c.DescribeReplicationSubnetGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationSubnetGroupsPagesWithContext same as DescribeReplicationSubnetGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationSubnetGroupsPagesWithContext(ctx aws.Context, input *DescribeReplicationSubnetGroupsInput, fn func(*DescribeReplicationSubnetGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationSubnetGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationSubnetGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationSubnetGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationTaskAssessmentResults = "DescribeReplicationTaskAssessmentResults"

// DescribeReplicationTaskAssessmentResultsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTaskAssessmentResults operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTaskAssessmentResults for more information on using the DescribeReplicationTaskAssessmentResults
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationTaskAssessmentResultsRequest method.
//    req, resp := client.DescribeReplicationTaskAssessmentResultsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsRequest(input *DescribeReplicationTaskAssessmentResultsInput) (req *request.Request, output *DescribeReplicationTaskAssessmentResultsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTaskAssessmentResults,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTaskAssessmentResultsInput{}
	}

	output = &DescribeReplicationTaskAssessmentResultsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTaskAssessmentResults API operation for AWS Database Migration Service.
//
// Returns the task assessment results from the Amazon S3 bucket that DMS creates
// in your account. This action always returns the latest results.
//
// For more information about DMS task assessments, see Creating a task assessment
// report (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html)
// in the Database Migration Service User Guide (https://docs.aws.amazon.com/https:/docs.aws.amazon.com/dms/latest/userguide/Welcome.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTaskAssessmentResults for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentResults
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResults(input *DescribeReplicationTaskAssessmentResultsInput) (*DescribeReplicationTaskAssessmentResultsOutput, error) {
	req, out := c.DescribeReplicationTaskAssessmentResultsRequest(input)
	return out, req.Send()
}

// DescribeReplicationTaskAssessmentResultsWithContext is the same as DescribeReplicationTaskAssessmentResults with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTaskAssessmentResults for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsWithContext(ctx aws.Context, input *DescribeReplicationTaskAssessmentResultsInput, opts ...request.Option) (*DescribeReplicationTaskAssessmentResultsOutput, error) {
	req, out := c.DescribeReplicationTaskAssessmentResultsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTaskAssessmentResultsPages iterates over the pages of a DescribeReplicationTaskAssessmentResults operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTaskAssessmentResults method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationTaskAssessmentResults operation.
//    pageNum := 0
//    err := client.DescribeReplicationTaskAssessmentResultsPages(params,
//        func(page *databasemigrationservice.DescribeReplicationTaskAssessmentResultsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsPages(input *DescribeReplicationTaskAssessmentResultsInput, fn func(*DescribeReplicationTaskAssessmentResultsOutput, bool) bool) error {
	return c.DescribeReplicationTaskAssessmentResultsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTaskAssessmentResultsPagesWithContext same as DescribeReplicationTaskAssessmentResultsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentResultsPagesWithContext(ctx aws.Context, input *DescribeReplicationTaskAssessmentResultsInput, fn func(*DescribeReplicationTaskAssessmentResultsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTaskAssessmentResultsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTaskAssessmentResultsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationTaskAssessmentResultsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationTaskAssessmentRuns = "DescribeReplicationTaskAssessmentRuns"

// DescribeReplicationTaskAssessmentRunsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTaskAssessmentRuns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTaskAssessmentRuns for more information on using the DescribeReplicationTaskAssessmentRuns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationTaskAssessmentRunsRequest method.
//    req, resp := client.DescribeReplicationTaskAssessmentRunsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentRunsRequest(input *DescribeReplicationTaskAssessmentRunsInput) (req *request.Request, output *DescribeReplicationTaskAssessmentRunsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTaskAssessmentRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTaskAssessmentRunsInput{}
	}

	output = &DescribeReplicationTaskAssessmentRunsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTaskAssessmentRuns API operation for AWS Database Migration Service.
//
// Returns a paginated list of premigration assessment runs based on filter
// settings.
//
// These filter settings can specify a combination of premigration assessment
// runs, migration tasks, replication instances, and assessment run status values.
//
// This operation doesn't return information about individual assessments. For
// this information, see the DescribeReplicationTaskIndividualAssessments operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTaskAssessmentRuns for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskAssessmentRuns
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentRuns(input *DescribeReplicationTaskAssessmentRunsInput) (*DescribeReplicationTaskAssessmentRunsOutput, error) {
	req, out := c.DescribeReplicationTaskAssessmentRunsRequest(input)
	return out, req.Send()
}

// DescribeReplicationTaskAssessmentRunsWithContext is the same as DescribeReplicationTaskAssessmentRuns with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTaskAssessmentRuns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentRunsWithContext(ctx aws.Context, input *DescribeReplicationTaskAssessmentRunsInput, opts ...request.Option) (*DescribeReplicationTaskAssessmentRunsOutput, error) {
	req, out := c.DescribeReplicationTaskAssessmentRunsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTaskAssessmentRunsPages iterates over the pages of a DescribeReplicationTaskAssessmentRuns operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTaskAssessmentRuns method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationTaskAssessmentRuns operation.
//    pageNum := 0
//    err := client.DescribeReplicationTaskAssessmentRunsPages(params,
//        func(page *databasemigrationservice.DescribeReplicationTaskAssessmentRunsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentRunsPages(input *DescribeReplicationTaskAssessmentRunsInput, fn func(*DescribeReplicationTaskAssessmentRunsOutput, bool) bool) error {
	return c.DescribeReplicationTaskAssessmentRunsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTaskAssessmentRunsPagesWithContext same as DescribeReplicationTaskAssessmentRunsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskAssessmentRunsPagesWithContext(ctx aws.Context, input *DescribeReplicationTaskAssessmentRunsInput, fn func(*DescribeReplicationTaskAssessmentRunsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTaskAssessmentRunsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTaskAssessmentRunsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationTaskAssessmentRunsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationTaskIndividualAssessments = "DescribeReplicationTaskIndividualAssessments"

// DescribeReplicationTaskIndividualAssessmentsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTaskIndividualAssessments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTaskIndividualAssessments for more information on using the DescribeReplicationTaskIndividualAssessments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationTaskIndividualAssessmentsRequest method.
//    req, resp := client.DescribeReplicationTaskIndividualAssessmentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments
func (c *DatabaseMigrationService) DescribeReplicationTaskIndividualAssessmentsRequest(input *DescribeReplicationTaskIndividualAssessmentsInput) (req *request.Request, output *DescribeReplicationTaskIndividualAssessmentsOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTaskIndividualAssessments,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTaskIndividualAssessmentsInput{}
	}

	output = &DescribeReplicationTaskIndividualAssessmentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTaskIndividualAssessments API operation for AWS Database Migration Service.
//
// Returns a paginated list of individual assessments based on filter settings.
//
// These filter settings can specify a combination of premigration assessment
// runs, migration tasks, and assessment status values.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTaskIndividualAssessments for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTaskIndividualAssessments
func (c *DatabaseMigrationService) DescribeReplicationTaskIndividualAssessments(input *DescribeReplicationTaskIndividualAssessmentsInput) (*DescribeReplicationTaskIndividualAssessmentsOutput, error) {
	req, out := c.DescribeReplicationTaskIndividualAssessmentsRequest(input)
	return out, req.Send()
}

// DescribeReplicationTaskIndividualAssessmentsWithContext is the same as DescribeReplicationTaskIndividualAssessments with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTaskIndividualAssessments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskIndividualAssessmentsWithContext(ctx aws.Context, input *DescribeReplicationTaskIndividualAssessmentsInput, opts ...request.Option) (*DescribeReplicationTaskIndividualAssessmentsOutput, error) {
	req, out := c.DescribeReplicationTaskIndividualAssessmentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTaskIndividualAssessmentsPages iterates over the pages of a DescribeReplicationTaskIndividualAssessments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTaskIndividualAssessments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationTaskIndividualAssessments operation.
//    pageNum := 0
//    err := client.DescribeReplicationTaskIndividualAssessmentsPages(params,
//        func(page *databasemigrationservice.DescribeReplicationTaskIndividualAssessmentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationTaskIndividualAssessmentsPages(input *DescribeReplicationTaskIndividualAssessmentsInput, fn func(*DescribeReplicationTaskIndividualAssessmentsOutput, bool) bool) error {
	return c.DescribeReplicationTaskIndividualAssessmentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTaskIndividualAssessmentsPagesWithContext same as DescribeReplicationTaskIndividualAssessmentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTaskIndividualAssessmentsPagesWithContext(ctx aws.Context, input *DescribeReplicationTaskIndividualAssessmentsInput, fn func(*DescribeReplicationTaskIndividualAssessmentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTaskIndividualAssessmentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTaskIndividualAssessmentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationTaskIndividualAssessmentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeReplicationTasks = "DescribeReplicationTasks"

// DescribeReplicationTasksRequest generates a "aws/request.Request" representing the
// client's request for the DescribeReplicationTasks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeReplicationTasks for more information on using the DescribeReplicationTasks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeReplicationTasksRequest method.
//    req, resp := client.DescribeReplicationTasksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks
func (c *DatabaseMigrationService) DescribeReplicationTasksRequest(input *DescribeReplicationTasksInput) (req *request.Request, output *DescribeReplicationTasksOutput) {
	op := &request.Operation{
		Name:       opDescribeReplicationTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeReplicationTasksInput{}
	}

	output = &DescribeReplicationTasksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeReplicationTasks API operation for AWS Database Migration Service.
//
// Returns information about replication tasks for your account in the current
// region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeReplicationTasks for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeReplicationTasks
func (c *DatabaseMigrationService) DescribeReplicationTasks(input *DescribeReplicationTasksInput) (*DescribeReplicationTasksOutput, error) {
	req, out := c.DescribeReplicationTasksRequest(input)
	return out, req.Send()
}

// DescribeReplicationTasksWithContext is the same as DescribeReplicationTasks with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeReplicationTasks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTasksWithContext(ctx aws.Context, input *DescribeReplicationTasksInput, opts ...request.Option) (*DescribeReplicationTasksOutput, error) {
	req, out := c.DescribeReplicationTasksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeReplicationTasksPages iterates over the pages of a DescribeReplicationTasks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeReplicationTasks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeReplicationTasks operation.
//    pageNum := 0
//    err := client.DescribeReplicationTasksPages(params,
//        func(page *databasemigrationservice.DescribeReplicationTasksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeReplicationTasksPages(input *DescribeReplicationTasksInput, fn func(*DescribeReplicationTasksOutput, bool) bool) error {
	return c.DescribeReplicationTasksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeReplicationTasksPagesWithContext same as DescribeReplicationTasksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeReplicationTasksPagesWithContext(ctx aws.Context, input *DescribeReplicationTasksInput, fn func(*DescribeReplicationTasksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeReplicationTasksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeReplicationTasksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeReplicationTasksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeSchemas = "DescribeSchemas"

// DescribeSchemasRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSchemas for more information on using the DescribeSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeSchemasRequest method.
//    req, resp := client.DescribeSchemasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas
func (c *DatabaseMigrationService) DescribeSchemasRequest(input *DescribeSchemasInput) (req *request.Request, output *DescribeSchemasOutput) {
	op := &request.Operation{
		Name:       opDescribeSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeSchemasInput{}
	}

	output = &DescribeSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSchemas API operation for AWS Database Migration Service.
//
// Returns information about the schema for the specified endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeSchemas for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeSchemas
func (c *DatabaseMigrationService) DescribeSchemas(input *DescribeSchemasInput) (*DescribeSchemasOutput, error) {
	req, out := c.DescribeSchemasRequest(input)
	return out, req.Send()
}

// DescribeSchemasWithContext is the same as DescribeSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeSchemasWithContext(ctx aws.Context, input *DescribeSchemasInput, opts ...request.Option) (*DescribeSchemasOutput, error) {
	req, out := c.DescribeSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeSchemasPages iterates over the pages of a DescribeSchemas operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeSchemas method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeSchemas operation.
//    pageNum := 0
//    err := client.DescribeSchemasPages(params,
//        func(page *databasemigrationservice.DescribeSchemasOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeSchemasPages(input *DescribeSchemasInput, fn func(*DescribeSchemasOutput, bool) bool) error {
	return c.DescribeSchemasPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeSchemasPagesWithContext same as DescribeSchemasPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeSchemasPagesWithContext(ctx aws.Context, input *DescribeSchemasInput, fn func(*DescribeSchemasOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeSchemasInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeSchemasRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeSchemasOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeTableStatistics = "DescribeTableStatistics"

// DescribeTableStatisticsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTableStatistics operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTableStatistics for more information on using the DescribeTableStatistics
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTableStatisticsRequest method.
//    req, resp := client.DescribeTableStatisticsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics
func (c *DatabaseMigrationService) DescribeTableStatisticsRequest(input *DescribeTableStatisticsInput) (req *request.Request, output *DescribeTableStatisticsOutput) {
	op := &request.Operation{
		Name:       opDescribeTableStatistics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeTableStatisticsInput{}
	}

	output = &DescribeTableStatisticsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTableStatistics API operation for AWS Database Migration Service.
//
// Returns table statistics on the database migration task, including table
// name, rows inserted, rows updated, and rows deleted.
//
// Note that the "last updated" column the DMS console only indicates the time
// that DMS last updated the table statistics record for a table. It does not
// indicate the time of the last update to the table.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation DescribeTableStatistics for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribeTableStatistics
func (c *DatabaseMigrationService) DescribeTableStatistics(input *DescribeTableStatisticsInput) (*DescribeTableStatisticsOutput, error) {
	req, out := c.DescribeTableStatisticsRequest(input)
	return out, req.Send()
}

// DescribeTableStatisticsWithContext is the same as DescribeTableStatistics with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTableStatistics for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeTableStatisticsWithContext(ctx aws.Context, input *DescribeTableStatisticsInput, opts ...request.Option) (*DescribeTableStatisticsOutput, error) {
	req, out := c.DescribeTableStatisticsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeTableStatisticsPages iterates over the pages of a DescribeTableStatistics operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeTableStatistics method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeTableStatistics operation.
//    pageNum := 0
//    err := client.DescribeTableStatisticsPages(params,
//        func(page *databasemigrationservice.DescribeTableStatisticsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *DatabaseMigrationService) DescribeTableStatisticsPages(input *DescribeTableStatisticsInput, fn func(*DescribeTableStatisticsOutput, bool) bool) error {
	return c.DescribeTableStatisticsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeTableStatisticsPagesWithContext same as DescribeTableStatisticsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) DescribeTableStatisticsPagesWithContext(ctx aws.Context, input *DescribeTableStatisticsInput, fn func(*DescribeTableStatisticsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeTableStatisticsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeTableStatisticsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeTableStatisticsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opImportCertificate = "ImportCertificate"

// ImportCertificateRequest generates a "aws/request.Request" representing the
// client's request for the ImportCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportCertificate for more information on using the ImportCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportCertificateRequest method.
//    req, resp := client.ImportCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate
func (c *DatabaseMigrationService) ImportCertificateRequest(input *ImportCertificateInput) (req *request.Request, output *ImportCertificateOutput) {
	op := &request.Operation{
		Name:       opImportCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportCertificateInput{}
	}

	output = &ImportCertificateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportCertificate API operation for AWS Database Migration Service.
//
// Uploads the specified certificate.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ImportCertificate for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * InvalidCertificateFault
//   The certificate was not valid.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ImportCertificate
func (c *DatabaseMigrationService) ImportCertificate(input *ImportCertificateInput) (*ImportCertificateOutput, error) {
	req, out := c.ImportCertificateRequest(input)
	return out, req.Send()
}

// ImportCertificateWithContext is the same as ImportCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See ImportCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ImportCertificateWithContext(ctx aws.Context, input *ImportCertificateInput, opts ...request.Option) (*ImportCertificateOutput, error) {
	req, out := c.ImportCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource
func (c *DatabaseMigrationService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Database Migration Service.
//
// Lists all metadata tags attached to an DMS resource, including replication
// instance, endpoint, security group, and migration task. For more information,
// see Tag (https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html)
// data type description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ListTagsForResource
func (c *DatabaseMigrationService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyEndpoint = "ModifyEndpoint"

// ModifyEndpointRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEndpoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyEndpoint for more information on using the ModifyEndpoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyEndpointRequest method.
//    req, resp := client.ModifyEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint
func (c *DatabaseMigrationService) ModifyEndpointRequest(input *ModifyEndpointInput) (req *request.Request, output *ModifyEndpointOutput) {
	op := &request.Operation{
		Name:       opModifyEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEndpointInput{}
	}

	output = &ModifyEndpointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEndpoint API operation for AWS Database Migration Service.
//
// Modifies the specified endpoint.
//
// For a MySQL source or target endpoint, don't explicitly specify the database
// using the DatabaseName request parameter on the ModifyEndpoint API call.
// Specifying DatabaseName when you modify a MySQL endpoint replicates all the
// task tables to this single database. For MySQL endpoints, you specify the
// database only when you specify the schema in the table-mapping rules of the
// DMS task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyEndpoint for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * KMSKeyNotAccessibleFault
//   DMS cannot access the KMS key.
//
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEndpoint
func (c *DatabaseMigrationService) ModifyEndpoint(input *ModifyEndpointInput) (*ModifyEndpointOutput, error) {
	req, out := c.ModifyEndpointRequest(input)
	return out, req.Send()
}

// ModifyEndpointWithContext is the same as ModifyEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyEndpointWithContext(ctx aws.Context, input *ModifyEndpointInput, opts ...request.Option) (*ModifyEndpointOutput, error) {
	req, out := c.ModifyEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyEventSubscription = "ModifyEventSubscription"

// ModifyEventSubscriptionRequest generates a "aws/request.Request" representing the
// client's request for the ModifyEventSubscription operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyEventSubscription for more information on using the ModifyEventSubscription
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyEventSubscriptionRequest method.
//    req, resp := client.ModifyEventSubscriptionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription
func (c *DatabaseMigrationService) ModifyEventSubscriptionRequest(input *ModifyEventSubscriptionInput) (req *request.Request, output *ModifyEventSubscriptionOutput) {
	op := &request.Operation{
		Name:       opModifyEventSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyEventSubscriptionInput{}
	}

	output = &ModifyEventSubscriptionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyEventSubscription API operation for AWS Database Migration Service.
//
// Modifies an existing DMS event notification subscription.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyEventSubscription for usage and error information.
//
// Returned Error Types:
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * SNSInvalidTopicFault
//   The SNS topic is invalid.
//
//   * SNSNoAuthorizationFault
//   You are not authorized for the SNS subscription.
//
//   * KMSAccessDeniedFault
//   The ciphertext references a key that doesn't exist or that the DMS account
//   doesn't have access to.
//
//   * KMSDisabledFault
//   The specified master key (CMK) isn't enabled.
//
//   * KMSInvalidStateFault
//   The state of the specified KMS resource isn't valid for this request.
//
//   * KMSNotFoundFault
//   The specified KMS entity or resource can't be found.
//
//   * KMSThrottlingFault
//   This request triggered KMS request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyEventSubscription
func (c *DatabaseMigrationService) ModifyEventSubscription(input *ModifyEventSubscriptionInput) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	return out, req.Send()
}

// ModifyEventSubscriptionWithContext is the same as ModifyEventSubscription with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyEventSubscription for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyEventSubscriptionWithContext(ctx aws.Context, input *ModifyEventSubscriptionInput, opts ...request.Option) (*ModifyEventSubscriptionOutput, error) {
	req, out := c.ModifyEventSubscriptionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationInstance = "ModifyReplicationInstance"

// ModifyReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationInstance for more information on using the ModifyReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyReplicationInstanceRequest method.
//    req, resp := client.ModifyReplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance
func (c *DatabaseMigrationService) ModifyReplicationInstanceRequest(input *ModifyReplicationInstanceInput) (req *request.Request, output *ModifyReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationInstanceInput{}
	}

	output = &ModifyReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationInstance API operation for AWS Database Migration Service.
//
// Modifies the replication instance to apply new settings. You can change one
// or more parameters by specifying these parameters and the new values in the
// request.
//
// Some settings are applied during the maintenance window.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationInstance for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InsufficientResourceCapacityFault
//   There are not enough resources allocated to the database migration.
//
//   * StorageQuotaExceededFault
//   The storage quota has been exceeded.
//
//   * UpgradeDependencyFailureFault
//   An upgrade dependency is preventing the database migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationInstance
func (c *DatabaseMigrationService) ModifyReplicationInstance(input *ModifyReplicationInstanceInput) (*ModifyReplicationInstanceOutput, error) {
	req, out := c.ModifyReplicationInstanceRequest(input)
	return out, req.Send()
}

// ModifyReplicationInstanceWithContext is the same as ModifyReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyReplicationInstanceWithContext(ctx aws.Context, input *ModifyReplicationInstanceInput, opts ...request.Option) (*ModifyReplicationInstanceOutput, error) {
	req, out := c.ModifyReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationSubnetGroup = "ModifyReplicationSubnetGroup"

// ModifyReplicationSubnetGroupRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationSubnetGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationSubnetGroup for more information on using the ModifyReplicationSubnetGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyReplicationSubnetGroupRequest method.
//    req, resp := client.ModifyReplicationSubnetGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroupRequest(input *ModifyReplicationSubnetGroupInput) (req *request.Request, output *ModifyReplicationSubnetGroupOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationSubnetGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationSubnetGroupInput{}
	}

	output = &ModifyReplicationSubnetGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationSubnetGroup API operation for AWS Database Migration Service.
//
// Modifies the settings for the specified replication subnet group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationSubnetGroup for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * SubnetAlreadyInUse
//   The specified subnet is already in use.
//
//   * ReplicationSubnetGroupDoesNotCoverEnoughAZs
//   The replication subnet group does not cover enough Availability Zones (AZs).
//   Edit the replication subnet group and add more AZs.
//
//   * InvalidSubnet
//   The subnet provided is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationSubnetGroup
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroup(input *ModifyReplicationSubnetGroupInput) (*ModifyReplicationSubnetGroupOutput, error) {
	req, out := c.ModifyReplicationSubnetGroupRequest(input)
	return out, req.Send()
}

// ModifyReplicationSubnetGroupWithContext is the same as ModifyReplicationSubnetGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationSubnetGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyReplicationSubnetGroupWithContext(ctx aws.Context, input *ModifyReplicationSubnetGroupInput, opts ...request.Option) (*ModifyReplicationSubnetGroupOutput, error) {
	req, out := c.ModifyReplicationSubnetGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyReplicationTask = "ModifyReplicationTask"

// ModifyReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the ModifyReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyReplicationTask for more information on using the ModifyReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyReplicationTaskRequest method.
//    req, resp := client.ModifyReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask
func (c *DatabaseMigrationService) ModifyReplicationTaskRequest(input *ModifyReplicationTaskInput) (req *request.Request, output *ModifyReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opModifyReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyReplicationTaskInput{}
	}

	output = &ModifyReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ModifyReplicationTask API operation for AWS Database Migration Service.
//
// Modifies the specified replication task.
//
// You can't modify the task endpoints. The task must be stopped before you
// can modify it.
//
// For more information about DMS tasks, see Working with Migration Tasks (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html)
// in the Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ModifyReplicationTask for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
//   * KMSKeyNotAccessibleFault
//   DMS cannot access the KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ModifyReplicationTask
func (c *DatabaseMigrationService) ModifyReplicationTask(input *ModifyReplicationTaskInput) (*ModifyReplicationTaskOutput, error) {
	req, out := c.ModifyReplicationTaskRequest(input)
	return out, req.Send()
}

// ModifyReplicationTaskWithContext is the same as ModifyReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ModifyReplicationTaskWithContext(ctx aws.Context, input *ModifyReplicationTaskInput, opts ...request.Option) (*ModifyReplicationTaskOutput, error) {
	req, out := c.ModifyReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMoveReplicationTask = "MoveReplicationTask"

// MoveReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the MoveReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MoveReplicationTask for more information on using the MoveReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the MoveReplicationTaskRequest method.
//    req, resp := client.MoveReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask
func (c *DatabaseMigrationService) MoveReplicationTaskRequest(input *MoveReplicationTaskInput) (req *request.Request, output *MoveReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opMoveReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MoveReplicationTaskInput{}
	}

	output = &MoveReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MoveReplicationTask API operation for AWS Database Migration Service.
//
// Moves a replication task from its current replication instance to a different
// target replication instance using the specified parameters. The target replication
// instance must be created with the same or later DMS version as the current
// replication instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation MoveReplicationTask for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * KMSKeyNotAccessibleFault
//   DMS cannot access the KMS key.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/MoveReplicationTask
func (c *DatabaseMigrationService) MoveReplicationTask(input *MoveReplicationTaskInput) (*MoveReplicationTaskOutput, error) {
	req, out := c.MoveReplicationTaskRequest(input)
	return out, req.Send()
}

// MoveReplicationTaskWithContext is the same as MoveReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See MoveReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) MoveReplicationTaskWithContext(ctx aws.Context, input *MoveReplicationTaskInput, opts ...request.Option) (*MoveReplicationTaskOutput, error) {
	req, out := c.MoveReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootReplicationInstance = "RebootReplicationInstance"

// RebootReplicationInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RebootReplicationInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootReplicationInstance for more information on using the RebootReplicationInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootReplicationInstanceRequest method.
//    req, resp := client.RebootReplicationInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance
func (c *DatabaseMigrationService) RebootReplicationInstanceRequest(input *RebootReplicationInstanceInput) (req *request.Request, output *RebootReplicationInstanceOutput) {
	op := &request.Operation{
		Name:       opRebootReplicationInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootReplicationInstanceInput{}
	}

	output = &RebootReplicationInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootReplicationInstance API operation for AWS Database Migration Service.
//
// Reboots a replication instance. Rebooting results in a momentary outage,
// until the replication instance becomes available again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RebootReplicationInstance for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RebootReplicationInstance
func (c *DatabaseMigrationService) RebootReplicationInstance(input *RebootReplicationInstanceInput) (*RebootReplicationInstanceOutput, error) {
	req, out := c.RebootReplicationInstanceRequest(input)
	return out, req.Send()
}

// RebootReplicationInstanceWithContext is the same as RebootReplicationInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RebootReplicationInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) RebootReplicationInstanceWithContext(ctx aws.Context, input *RebootReplicationInstanceInput, opts ...request.Option) (*RebootReplicationInstanceOutput, error) {
	req, out := c.RebootReplicationInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRefreshSchemas = "RefreshSchemas"

// RefreshSchemasRequest generates a "aws/request.Request" representing the
// client's request for the RefreshSchemas operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RefreshSchemas for more information on using the RefreshSchemas
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RefreshSchemasRequest method.
//    req, resp := client.RefreshSchemasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas
func (c *DatabaseMigrationService) RefreshSchemasRequest(input *RefreshSchemasInput) (req *request.Request, output *RefreshSchemasOutput) {
	op := &request.Operation{
		Name:       opRefreshSchemas,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RefreshSchemasInput{}
	}

	output = &RefreshSchemasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RefreshSchemas API operation for AWS Database Migration Service.
//
// Populates the schema for the specified endpoint. This is an asynchronous
// operation and can take several minutes. You can check the status of this
// operation by calling the DescribeRefreshSchemasStatus operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RefreshSchemas for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * KMSKeyNotAccessibleFault
//   DMS cannot access the KMS key.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RefreshSchemas
func (c *DatabaseMigrationService) RefreshSchemas(input *RefreshSchemasInput) (*RefreshSchemasOutput, error) {
	req, out := c.RefreshSchemasRequest(input)
	return out, req.Send()
}

// RefreshSchemasWithContext is the same as RefreshSchemas with the addition of
// the ability to pass a context and additional request options.
//
// See RefreshSchemas for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) RefreshSchemasWithContext(ctx aws.Context, input *RefreshSchemasInput, opts ...request.Option) (*RefreshSchemasOutput, error) {
	req, out := c.RefreshSchemasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReloadTables = "ReloadTables"

// ReloadTablesRequest generates a "aws/request.Request" representing the
// client's request for the ReloadTables operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReloadTables for more information on using the ReloadTables
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ReloadTablesRequest method.
//    req, resp := client.ReloadTablesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables
func (c *DatabaseMigrationService) ReloadTablesRequest(input *ReloadTablesInput) (req *request.Request, output *ReloadTablesOutput) {
	op := &request.Operation{
		Name:       opReloadTables,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ReloadTablesInput{}
	}

	output = &ReloadTablesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReloadTables API operation for AWS Database Migration Service.
//
// Reloads the target database table with the source data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation ReloadTables for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/ReloadTables
func (c *DatabaseMigrationService) ReloadTables(input *ReloadTablesInput) (*ReloadTablesOutput, error) {
	req, out := c.ReloadTablesRequest(input)
	return out, req.Send()
}

// ReloadTablesWithContext is the same as ReloadTables with the addition of
// the ability to pass a context and additional request options.
//
// See ReloadTables for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) ReloadTablesWithContext(ctx aws.Context, input *ReloadTablesInput, opts ...request.Option) (*ReloadTablesOutput, error) {
	req, out := c.ReloadTablesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRemoveTagsFromResource = "RemoveTagsFromResource"

// RemoveTagsFromResourceRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTagsFromResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RemoveTagsFromResource for more information on using the RemoveTagsFromResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RemoveTagsFromResourceRequest method.
//    req, resp := client.RemoveTagsFromResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource
func (c *DatabaseMigrationService) RemoveTagsFromResourceRequest(input *RemoveTagsFromResourceInput) (req *request.Request, output *RemoveTagsFromResourceOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsFromResourceInput{}
	}

	output = &RemoveTagsFromResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTagsFromResource API operation for AWS Database Migration Service.
//
// Removes metadata tags from an DMS resource, including replication instance,
// endpoint, security group, and migration task. For more information, see Tag
// (https://docs.aws.amazon.com/dms/latest/APIReference/API_Tag.html) data type
// description.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation RemoveTagsFromResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/RemoveTagsFromResource
func (c *DatabaseMigrationService) RemoveTagsFromResource(input *RemoveTagsFromResourceInput) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	return out, req.Send()
}

// RemoveTagsFromResourceWithContext is the same as RemoveTagsFromResource with the addition of
// the ability to pass a context and additional request options.
//
// See RemoveTagsFromResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) RemoveTagsFromResourceWithContext(ctx aws.Context, input *RemoveTagsFromResourceInput, opts ...request.Option) (*RemoveTagsFromResourceOutput, error) {
	req, out := c.RemoveTagsFromResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplicationTask = "StartReplicationTask"

// StartReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StartReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplicationTask for more information on using the StartReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartReplicationTaskRequest method.
//    req, resp := client.StartReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask
func (c *DatabaseMigrationService) StartReplicationTaskRequest(input *StartReplicationTaskInput) (req *request.Request, output *StartReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opStartReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplicationTaskInput{}
	}

	output = &StartReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplicationTask API operation for AWS Database Migration Service.
//
// Starts the replication task.
//
// For more information about DMS tasks, see Working with Migration Tasks (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.html)
// in the Database Migration Service User Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartReplicationTask for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTask
func (c *DatabaseMigrationService) StartReplicationTask(input *StartReplicationTaskInput) (*StartReplicationTaskOutput, error) {
	req, out := c.StartReplicationTaskRequest(input)
	return out, req.Send()
}

// StartReplicationTaskWithContext is the same as StartReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartReplicationTaskWithContext(ctx aws.Context, input *StartReplicationTaskInput, opts ...request.Option) (*StartReplicationTaskOutput, error) {
	req, out := c.StartReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplicationTaskAssessment = "StartReplicationTaskAssessment"

// StartReplicationTaskAssessmentRequest generates a "aws/request.Request" representing the
// client's request for the StartReplicationTaskAssessment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplicationTaskAssessment for more information on using the StartReplicationTaskAssessment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartReplicationTaskAssessmentRequest method.
//    req, resp := client.StartReplicationTaskAssessmentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentRequest(input *StartReplicationTaskAssessmentInput) (req *request.Request, output *StartReplicationTaskAssessmentOutput) {
	op := &request.Operation{
		Name:       opStartReplicationTaskAssessment,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplicationTaskAssessmentInput{}
	}

	output = &StartReplicationTaskAssessmentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplicationTaskAssessment API operation for AWS Database Migration Service.
//
// Starts the replication task assessment for unsupported data types in the
// source database.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartReplicationTaskAssessment for usage and error information.
//
// Returned Error Types:
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessment
func (c *DatabaseMigrationService) StartReplicationTaskAssessment(input *StartReplicationTaskAssessmentInput) (*StartReplicationTaskAssessmentOutput, error) {
	req, out := c.StartReplicationTaskAssessmentRequest(input)
	return out, req.Send()
}

// StartReplicationTaskAssessmentWithContext is the same as StartReplicationTaskAssessment with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplicationTaskAssessment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentWithContext(ctx aws.Context, input *StartReplicationTaskAssessmentInput, opts ...request.Option) (*StartReplicationTaskAssessmentOutput, error) {
	req, out := c.StartReplicationTaskAssessmentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartReplicationTaskAssessmentRun = "StartReplicationTaskAssessmentRun"

// StartReplicationTaskAssessmentRunRequest generates a "aws/request.Request" representing the
// client's request for the StartReplicationTaskAssessmentRun operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartReplicationTaskAssessmentRun for more information on using the StartReplicationTaskAssessmentRun
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartReplicationTaskAssessmentRunRequest method.
//    req, resp := client.StartReplicationTaskAssessmentRunRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentRunRequest(input *StartReplicationTaskAssessmentRunInput) (req *request.Request, output *StartReplicationTaskAssessmentRunOutput) {
	op := &request.Operation{
		Name:       opStartReplicationTaskAssessmentRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartReplicationTaskAssessmentRunInput{}
	}

	output = &StartReplicationTaskAssessmentRunOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartReplicationTaskAssessmentRun API operation for AWS Database Migration Service.
//
// Starts a new premigration assessment run for one or more individual assessments
// of a migration task.
//
// The assessments that you can specify depend on the source and target database
// engine and the migration type defined for the given task. To run this operation,
// your migration task must already be created. After you run this operation,
// you can review the status of each individual assessment. You can also run
// the migration task manually after the assessment run and its individual assessments
// complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StartReplicationTaskAssessmentRun for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * KMSAccessDeniedFault
//   The ciphertext references a key that doesn't exist or that the DMS account
//   doesn't have access to.
//
//   * KMSDisabledFault
//   The specified master key (CMK) isn't enabled.
//
//   * KMSFault
//   An Key Management Service (KMS) error is preventing access to KMS.
//
//   * KMSInvalidStateFault
//   The state of the specified KMS resource isn't valid for this request.
//
//   * KMSNotFoundFault
//   The specified KMS entity or resource can't be found.
//
//   * KMSKeyNotAccessibleFault
//   DMS cannot access the KMS key.
//
//   * S3AccessDeniedFault
//   Insufficient privileges are preventing access to an Amazon S3 object.
//
//   * S3ResourceNotFoundFault
//   A specified Amazon S3 bucket, bucket folder, or other object can't be found.
//
//   * ResourceAlreadyExistsFault
//   The resource you are attempting to create already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StartReplicationTaskAssessmentRun
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentRun(input *StartReplicationTaskAssessmentRunInput) (*StartReplicationTaskAssessmentRunOutput, error) {
	req, out := c.StartReplicationTaskAssessmentRunRequest(input)
	return out, req.Send()
}

// StartReplicationTaskAssessmentRunWithContext is the same as StartReplicationTaskAssessmentRun with the addition of
// the ability to pass a context and additional request options.
//
// See StartReplicationTaskAssessmentRun for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StartReplicationTaskAssessmentRunWithContext(ctx aws.Context, input *StartReplicationTaskAssessmentRunInput, opts ...request.Option) (*StartReplicationTaskAssessmentRunOutput, error) {
	req, out := c.StartReplicationTaskAssessmentRunRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopReplicationTask = "StopReplicationTask"

// StopReplicationTaskRequest generates a "aws/request.Request" representing the
// client's request for the StopReplicationTask operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopReplicationTask for more information on using the StopReplicationTask
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopReplicationTaskRequest method.
//    req, resp := client.StopReplicationTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask
func (c *DatabaseMigrationService) StopReplicationTaskRequest(input *StopReplicationTaskInput) (req *request.Request, output *StopReplicationTaskOutput) {
	op := &request.Operation{
		Name:       opStopReplicationTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopReplicationTaskInput{}
	}

	output = &StopReplicationTaskOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopReplicationTask API operation for AWS Database Migration Service.
//
// Stops the replication task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation StopReplicationTask for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/StopReplicationTask
func (c *DatabaseMigrationService) StopReplicationTask(input *StopReplicationTaskInput) (*StopReplicationTaskOutput, error) {
	req, out := c.StopReplicationTaskRequest(input)
	return out, req.Send()
}

// StopReplicationTaskWithContext is the same as StopReplicationTask with the addition of
// the ability to pass a context and additional request options.
//
// See StopReplicationTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) StopReplicationTaskWithContext(ctx aws.Context, input *StopReplicationTaskInput, opts ...request.Option) (*StopReplicationTaskOutput, error) {
	req, out := c.StopReplicationTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestConnection = "TestConnection"

// TestConnectionRequest generates a "aws/request.Request" representing the
// client's request for the TestConnection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestConnection for more information on using the TestConnection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestConnectionRequest method.
//    req, resp := client.TestConnectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection
func (c *DatabaseMigrationService) TestConnectionRequest(input *TestConnectionInput) (req *request.Request, output *TestConnectionOutput) {
	op := &request.Operation{
		Name:       opTestConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TestConnectionInput{}
	}

	output = &TestConnectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestConnection API operation for AWS Database Migration Service.
//
// Tests the connection between the replication instance and the endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Database Migration Service's
// API operation TestConnection for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundFault
//   The resource could not be found.
//
//   * InvalidResourceStateFault
//   The resource is in a state that prevents it from being used for database
//   migration.
//
//   * KMSKeyNotAccessibleFault
//   DMS cannot access the KMS key.
//
//   * ResourceQuotaExceededFault
//   The quota for this resource quota has been exceeded.
//
//   * AccessDeniedFault
//   DMS was denied access to the endpoint. Check that the role is correctly configured.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/TestConnection
func (c *DatabaseMigrationService) TestConnection(input *TestConnectionInput) (*TestConnectionOutput, error) {
	req, out := c.TestConnectionRequest(input)
	return out, req.Send()
}

// TestConnectionWithContext is the same as TestConnection with the addition of
// the ability to pass a context and additional request options.
//
// See TestConnection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DatabaseMigrationService) TestConnectionWithContext(ctx aws.Context, input *TestConnectionInput, opts ...request.Option) (*TestConnectionOutput, error) {
	req, out := c.TestConnectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DMS was denied access to the endpoint. Check that the role is correctly configured.
type AccessDeniedFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s AccessDeniedFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedFault) GoString() string {
	return s.String()
}

func newErrorAccessDeniedFault(v protocol.ResponseMetadata) error {
	return &AccessDeniedFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedFault) Code() string {
	return "AccessDeniedFault"
}

// Message returns the exception's message.
func (s *AccessDeniedFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedFault) OrigErr() error {
	return nil
}

func (s *AccessDeniedFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a quota for an account, for example the number of replication instances
// allowed.
type AccountQuota struct {
	_ struct{} `type:"structure"`

	// The name of the DMS quota for this account.
	AccountQuotaName *string `type:"string"`

	// The maximum allowed value for the quota.
	Max *int64 `type:"long"`

	// The amount currently used toward the quota maximum.
	Used *int64 `type:"long"`
}

// String returns the string representation
func (s AccountQuota) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountQuota) GoString() string {
	return s.String()
}

// SetAccountQuotaName sets the AccountQuotaName field's value.
func (s *AccountQuota) SetAccountQuotaName(v string) *AccountQuota {
	s.AccountQuotaName = &v
	return s
}

// SetMax sets the Max field's value.
func (s *AccountQuota) SetMax(v int64) *AccountQuota {
	s.Max = &v
	return s
}

// SetUsed sets the Used field's value.
func (s *AccountQuota) SetUsed(v int64) *AccountQuota {
	s.Used = &v
	return s
}

// Associates a set of tags with an DMS resource.
type AddTagsToResourceInput struct {
	_ struct{} `type:"structure"`

	// Identifies the DMS resource to which tags should be added. The value for
	// this parameter is an Amazon Resource Name (ARN).
	//
	// For DMS, you can tag a replication instance, an endpoint, or a replication
	// task.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// One or more tags to be assigned to the resource.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsToResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsToResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsToResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AddTagsToResourceInput) SetResourceArn(v string) *AddTagsToResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AddTagsToResourceInput) SetTags(v []*Tag) *AddTagsToResourceInput {
	s.Tags = v
	return s
}

type AddTagsToResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsToResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToResourceOutput) GoString() string {
	return s.String()
}

type ApplyPendingMaintenanceActionInput struct {
	_ struct{} `type:"structure"`

	// The pending maintenance action to apply to this resource.
	//
	// ApplyAction is a required field
	ApplyAction *string `type:"string" required:"true"`

	// A value that specifies the type of opt-in request, or undoes an opt-in request.
	// You can't undo an opt-in request of type immediate.
	//
	// Valid values:
	//
	//    * immediate - Apply the maintenance action immediately.
	//
	//    * next-maintenance - Apply the maintenance action during the next maintenance
	//    window for the resource.
	//
	//    * undo-opt-in - Cancel any existing next-maintenance opt-in requests.
	//
	// OptInType is a required field
	OptInType *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance
	// action applies to.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ApplyPendingMaintenanceActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ApplyPendingMaintenanceActionInput"}
	if s.ApplyAction == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplyAction"))
	}
	if s.OptInType == nil {
		invalidParams.Add(request.NewErrParamRequired("OptInType"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplyAction sets the ApplyAction field's value.
func (s *ApplyPendingMaintenanceActionInput) SetApplyAction(v string) *ApplyPendingMaintenanceActionInput {
	s.ApplyAction = &v
	return s
}

// SetOptInType sets the OptInType field's value.
func (s *ApplyPendingMaintenanceActionInput) SetOptInType(v string) *ApplyPendingMaintenanceActionInput {
	s.OptInType = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *ApplyPendingMaintenanceActionInput) SetReplicationInstanceArn(v string) *ApplyPendingMaintenanceActionInput {
	s.ReplicationInstanceArn = &v
	return s
}

type ApplyPendingMaintenanceActionOutput struct {
	_ struct{} `type:"structure"`

	// The DMS resource that the pending maintenance action will be applied to.
	ResourcePendingMaintenanceActions *ResourcePendingMaintenanceActions `type:"structure"`
}

// String returns the string representation
func (s ApplyPendingMaintenanceActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ApplyPendingMaintenanceActionOutput) GoString() string {
	return s.String()
}

// SetResourcePendingMaintenanceActions sets the ResourcePendingMaintenanceActions field's value.
func (s *ApplyPendingMaintenanceActionOutput) SetResourcePendingMaintenanceActions(v *ResourcePendingMaintenanceActions) *ApplyPendingMaintenanceActionOutput {
	s.ResourcePendingMaintenanceActions = v
	return s
}

// The name of an Availability Zone for use during database migration. AvailabilityZone
// is an optional parameter to the CreateReplicationInstance (https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationInstance.html)
// operation, and it’s value relates to the Region of an endpoint. For example,
// the availability zone of an endpoint in the us-east-1 region might be us-east-1a,
// us-east-1b, us-east-1c, or us-east-1d.
type AvailabilityZone struct {
	_ struct{} `type:"structure"`

	// The name of the Availability Zone.
	Name *string `type:"string"`
}

// String returns the string representation
func (s AvailabilityZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZone) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AvailabilityZone) SetName(v string) *AvailabilityZone {
	s.Name = &v
	return s
}

type CancelReplicationTaskAssessmentRunInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the premigration assessment run to be canceled.
	//
	// ReplicationTaskAssessmentRunArn is a required field
	ReplicationTaskAssessmentRunArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CancelReplicationTaskAssessmentRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelReplicationTaskAssessmentRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CancelReplicationTaskAssessmentRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CancelReplicationTaskAssessmentRunInput"}
	if s.ReplicationTaskAssessmentRunArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskAssessmentRunArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskAssessmentRunArn sets the ReplicationTaskAssessmentRunArn field's value.
func (s *CancelReplicationTaskAssessmentRunInput) SetReplicationTaskAssessmentRunArn(v string) *CancelReplicationTaskAssessmentRunInput {
	s.ReplicationTaskAssessmentRunArn = &v
	return s
}

type CancelReplicationTaskAssessmentRunOutput struct {
	_ struct{} `type:"structure"`

	// The ReplicationTaskAssessmentRun object for the canceled assessment run.
	ReplicationTaskAssessmentRun *ReplicationTaskAssessmentRun `type:"structure"`
}

// String returns the string representation
func (s CancelReplicationTaskAssessmentRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelReplicationTaskAssessmentRunOutput) GoString() string {
	return s.String()
}

// SetReplicationTaskAssessmentRun sets the ReplicationTaskAssessmentRun field's value.
func (s *CancelReplicationTaskAssessmentRunOutput) SetReplicationTaskAssessmentRun(v *ReplicationTaskAssessmentRun) *CancelReplicationTaskAssessmentRunOutput {
	s.ReplicationTaskAssessmentRun = v
	return s
}

// The SSL certificate that can be used to encrypt connections between the endpoints
// and the replication instance.
type Certificate struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The date that the certificate was created.
	CertificateCreationDate *time.Time `type:"timestamp"`

	// A customer-assigned name for the certificate. Identifiers must begin with
	// a letter and must contain only ASCII letters, digits, and hyphens. They can't
	// end with a hyphen or contain two consecutive hyphens.
	CertificateIdentifier *string `type:"string"`

	// The owner of the certificate.
	CertificateOwner *string `type:"string"`

	// The contents of a .pem file, which contains an X.509 certificate.
	CertificatePem *string `type:"string"`

	// The location of an imported Oracle Wallet certificate for use with SSL.
	//
	// CertificateWallet is automatically base64 encoded/decoded by the SDK.
	CertificateWallet []byte `type:"blob"`

	// The key length of the cryptographic algorithm being used.
	KeyLength *int64 `type:"integer"`

	// The signing algorithm for the certificate.
	SigningAlgorithm *string `type:"string"`

	// The beginning date that the certificate is valid.
	ValidFromDate *time.Time `type:"timestamp"`

	// The final date that the certificate is valid.
	ValidToDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Certificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Certificate) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Certificate) SetCertificateArn(v string) *Certificate {
	s.CertificateArn = &v
	return s
}

// SetCertificateCreationDate sets the CertificateCreationDate field's value.
func (s *Certificate) SetCertificateCreationDate(v time.Time) *Certificate {
	s.CertificateCreationDate = &v
	return s
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *Certificate) SetCertificateIdentifier(v string) *Certificate {
	s.CertificateIdentifier = &v
	return s
}

// SetCertificateOwner sets the CertificateOwner field's value.
func (s *Certificate) SetCertificateOwner(v string) *Certificate {
	s.CertificateOwner = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *Certificate) SetCertificatePem(v string) *Certificate {
	s.CertificatePem = &v
	return s
}

// SetCertificateWallet sets the CertificateWallet field's value.
func (s *Certificate) SetCertificateWallet(v []byte) *Certificate {
	s.CertificateWallet = v
	return s
}

// SetKeyLength sets the KeyLength field's value.
func (s *Certificate) SetKeyLength(v int64) *Certificate {
	s.KeyLength = &v
	return s
}

// SetSigningAlgorithm sets the SigningAlgorithm field's value.
func (s *Certificate) SetSigningAlgorithm(v string) *Certificate {
	s.SigningAlgorithm = &v
	return s
}

// SetValidFromDate sets the ValidFromDate field's value.
func (s *Certificate) SetValidFromDate(v time.Time) *Certificate {
	s.ValidFromDate = &v
	return s
}

// SetValidToDate sets the ValidToDate field's value.
func (s *Certificate) SetValidToDate(v time.Time) *Certificate {
	s.ValidToDate = &v
	return s
}

// Status of the connection between an endpoint and a replication instance,
// including Amazon Resource Names (ARNs) and the last error message issued.
type Connection struct {
	_ struct{} `type:"structure"`

	// The ARN string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The identifier of the endpoint. Identifiers must begin with a letter and
	// must contain only ASCII letters, digits, and hyphens. They can't end with
	// a hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The error message when the connection last failed.
	LastFailureMessage *string `type:"string"`

	// The ARN of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	ReplicationInstanceIdentifier *string `type:"string"`

	// The connection status. This parameter can return one of the following values:
	//
	//    * "successful"
	//
	//    * "testing"
	//
	//    * "failed"
	//
	//    * "deleting"
	Status *string `type:"string"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connection) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *Connection) SetEndpointArn(v string) *Connection {
	s.EndpointArn = &v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *Connection) SetEndpointIdentifier(v string) *Connection {
	s.EndpointIdentifier = &v
	return s
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *Connection) SetLastFailureMessage(v string) *Connection {
	s.LastFailureMessage = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *Connection) SetReplicationInstanceArn(v string) *Connection {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationInstanceIdentifier sets the ReplicationInstanceIdentifier field's value.
func (s *Connection) SetReplicationInstanceIdentifier(v string) *Connection {
	s.ReplicationInstanceIdentifier = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Connection) SetStatus(v string) *Connection {
	s.Status = &v
	return s
}

type CreateEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the certificate.
	CertificateArn *string `type:"string"`

	// The name of the endpoint database. For a MySQL source or target endpoint,
	// do not specify DatabaseName.
	DatabaseName *string `type:"string"`

	// The settings in JSON format for the DMS transfer type of source endpoint.
	//
	// Possible settings include the following:
	//
	//    * ServiceAccessRoleArn - The IAM role that has permission to access the
	//    Amazon S3 bucket. The role must allow the iam:PassRole action.
	//
	//    * BucketName - The name of the S3 bucket to use.
	//
	// Shorthand syntax for these settings is as follows: ServiceAccessRoleArn=string,BucketName=string
	//
	// JSON syntax for these settings is as follows: { "ServiceAccessRoleArn": "string",
	// "BucketName": "string", }
	DmsTransferSettings *DmsTransferSettings `type:"structure"`

	// Provides information that defines a DocumentDB endpoint.
	DocDbSettings *DocDbSettings `type:"structure"`

	// Settings in JSON format for the target Amazon DynamoDB endpoint. For information
	// about other available settings, see Using Object Mapping to Migrate Data
	// to DynamoDB (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping)
	// in the Database Migration Service User Guide.
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// Settings in JSON format for the target Elasticsearch endpoint. For more information
	// about the available settings, see Extra Connection Attributes When Using
	// Elasticsearch as a Target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration)
	// in the Database Migration Service User Guide.
	ElasticsearchSettings *ElasticsearchSettings `type:"structure"`

	// The database endpoint identifier. Identifiers must begin with a letter and
	// must contain only ASCII letters, digits, and hyphens. They can't end with
	// a hyphen, or contain two consecutive hyphens.
	//
	// EndpointIdentifier is a required field
	EndpointIdentifier *string `type:"string" required:"true"`

	// The type of endpoint. Valid values are source and target.
	//
	// EndpointType is a required field
	EndpointType *string `type:"string" required:"true" enum:"ReplicationEndpointTypeValue"`

	// The type of engine for the endpoint. Valid values, depending on the EndpointType
	// value, include "mysql", "oracle", "postgres", "mariadb", "aurora", "aurora-postgresql",
	// "redshift", "s3", "db2", "azuredb", "sybase", "dynamodb", "mongodb", "kinesis",
	// "kafka", "elasticsearch", "docdb", "sqlserver", and "neptune".
	//
	// EngineName is a required field
	EngineName *string `type:"string" required:"true"`

	// The external table definition.
	ExternalTableDefinition *string `type:"string"`

	// Additional attributes associated with the connection. Each attribute is specified
	// as a name-value pair associated by an equal sign (=). Multiple attributes
	// are separated by a semicolon (;) with no additional white space. For information
	// on the attributes available for connecting your source or target endpoint,
	// see Working with DMS Endpoints (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Endpoints.html)
	// in the Database Migration Service User Guide.
	ExtraConnectionAttributes *string `type:"string"`

	// Settings in JSON format for the source IBM Db2 LUW endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// Db2 LUW as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	IBMDb2Settings *IBMDb2Settings `type:"structure"`

	// Settings in JSON format for the target Apache Kafka endpoint. For more information
	// about the available settings, see Using object mapping to migrate data to
	// a Kafka topic (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping)
	// in the Database Migration Service User Guide.
	KafkaSettings *KafkaSettings `type:"structure"`

	// Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
	// For more information about the available settings, see Using object mapping
	// to migrate data to a Kinesis data stream (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping)
	// in the Database Migration Service User Guide.
	KinesisSettings *KinesisSettings `type:"structure"`

	// An KMS key identifier that is used to encrypt the connection parameters for
	// the endpoint.
	//
	// If you don't specify a value for the KmsKeyId parameter, then DMS uses your
	// default encryption key.
	//
	// KMS creates the default encryption key for your account. Your account has
	// a different default encryption key for each Region.
	KmsKeyId *string `type:"string"`

	// Settings in JSON format for the source and target Microsoft SQL Server endpoint.
	// For information about other available settings, see Extra connection attributes
	// when using SQL Server as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib)
	// and Extra connection attributes when using SQL Server as a target for DMS
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	MicrosoftSQLServerSettings *MicrosoftSQLServerSettings `type:"structure"`

	// Settings in JSON format for the source MongoDB endpoint. For more information
	// about the available settings, see Endpoint configuration settings when using
	// MongoDB as a source for Database Migration Service (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration)
	// in the Database Migration Service User Guide.
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// Settings in JSON format for the source and target MySQL endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// MySQL as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib)
	// and Extra connection attributes when using a MySQL-compatible database as
	// a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	MySQLSettings *MySQLSettings `type:"structure"`

	// Settings in JSON format for the target Amazon Neptune endpoint. For more
	// information about the available settings, see Specifying graph-mapping rules
	// using Gremlin and R2RML for Amazon Neptune as a target (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings)
	// in the Database Migration Service User Guide.
	NeptuneSettings *NeptuneSettings `type:"structure"`

	// Settings in JSON format for the source and target Oracle endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// Oracle as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib)
	// and Extra connection attributes when using Oracle as a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	OracleSettings *OracleSettings `type:"structure"`

	// The password to be used to log in to the endpoint database.
	Password *string `type:"string" sensitive:"true"`

	// The port used by the endpoint database.
	Port *int64 `type:"integer"`

	// Settings in JSON format for the source and target PostgreSQL endpoint. For
	// information about other available settings, see Extra connection attributes
	// when using PostgreSQL as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib)
	// and Extra connection attributes when using PostgreSQL as a target for DMS
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	PostgreSQLSettings *PostgreSQLSettings `type:"structure"`

	// Provides information that defines an Amazon Redshift endpoint.
	RedshiftSettings *RedshiftSettings `type:"structure"`

	// A friendly name for the resource identifier at the end of the EndpointArn
	// response parameter that is returned in the created Endpoint object. The value
	// for this parameter can have up to 31 characters. It can contain only ASCII
	// letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain
	// two consecutive hyphens, and can only begin with a letter, such as Example-App-ARN1.
	// For example, this value might result in the EndpointArn value arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1.
	// If you don't specify a ResourceIdentifier value, DMS generates a default
	// identifier value for the end of EndpointArn.
	ResourceIdentifier *string `type:"string"`

	// Settings in JSON format for the target Amazon S3 endpoint. For more information
	// about the available settings, see Extra Connection Attributes When Using
	// Amazon S3 as a Target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring)
	// in the Database Migration Service User Guide.
	S3Settings *S3Settings `type:"structure"`

	// The name of the server where the endpoint database resides.
	ServerName *string `type:"string"`

	// The Amazon Resource Name (ARN) for the service access role that you want
	// to use to create the endpoint. The role must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`

	// The Secure Sockets Layer (SSL) mode to use for the SSL connection. The default
	// is none
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// Settings in JSON format for the source and target SAP ASE endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// SAP ASE as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib)
	// and Extra connection attributes when using SAP ASE as a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	SybaseSettings *SybaseSettings `type:"structure"`

	// One or more tags to be assigned to the endpoint.
	Tags []*Tag `type:"list"`

	// The user name to be used to log in to the endpoint database.
	Username *string `type:"string"`
}

// String returns the string representation
func (s CreateEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointInput"}
	if s.EndpointIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointIdentifier"))
	}
	if s.EndpointType == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointType"))
	}
	if s.EngineName == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineName"))
	}
	if s.DynamoDbSettings != nil {
		if err := s.DynamoDbSettings.Validate(); err != nil {
			invalidParams.AddNested("DynamoDbSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.ElasticsearchSettings != nil {
		if err := s.ElasticsearchSettings.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.NeptuneSettings != nil {
		if err := s.NeptuneSettings.Validate(); err != nil {
			invalidParams.AddNested("NeptuneSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateEndpointInput) SetCertificateArn(v string) *CreateEndpointInput {
	s.CertificateArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *CreateEndpointInput) SetDatabaseName(v string) *CreateEndpointInput {
	s.DatabaseName = &v
	return s
}

// SetDmsTransferSettings sets the DmsTransferSettings field's value.
func (s *CreateEndpointInput) SetDmsTransferSettings(v *DmsTransferSettings) *CreateEndpointInput {
	s.DmsTransferSettings = v
	return s
}

// SetDocDbSettings sets the DocDbSettings field's value.
func (s *CreateEndpointInput) SetDocDbSettings(v *DocDbSettings) *CreateEndpointInput {
	s.DocDbSettings = v
	return s
}

// SetDynamoDbSettings sets the DynamoDbSettings field's value.
func (s *CreateEndpointInput) SetDynamoDbSettings(v *DynamoDbSettings) *CreateEndpointInput {
	s.DynamoDbSettings = v
	return s
}

// SetElasticsearchSettings sets the ElasticsearchSettings field's value.
func (s *CreateEndpointInput) SetElasticsearchSettings(v *ElasticsearchSettings) *CreateEndpointInput {
	s.ElasticsearchSettings = v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *CreateEndpointInput) SetEndpointIdentifier(v string) *CreateEndpointInput {
	s.EndpointIdentifier = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *CreateEndpointInput) SetEndpointType(v string) *CreateEndpointInput {
	s.EndpointType = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *CreateEndpointInput) SetEngineName(v string) *CreateEndpointInput {
	s.EngineName = &v
	return s
}

// SetExternalTableDefinition sets the ExternalTableDefinition field's value.
func (s *CreateEndpointInput) SetExternalTableDefinition(v string) *CreateEndpointInput {
	s.ExternalTableDefinition = &v
	return s
}

// SetExtraConnectionAttributes sets the ExtraConnectionAttributes field's value.
func (s *CreateEndpointInput) SetExtraConnectionAttributes(v string) *CreateEndpointInput {
	s.ExtraConnectionAttributes = &v
	return s
}

// SetIBMDb2Settings sets the IBMDb2Settings field's value.
func (s *CreateEndpointInput) SetIBMDb2Settings(v *IBMDb2Settings) *CreateEndpointInput {
	s.IBMDb2Settings = v
	return s
}

// SetKafkaSettings sets the KafkaSettings field's value.
func (s *CreateEndpointInput) SetKafkaSettings(v *KafkaSettings) *CreateEndpointInput {
	s.KafkaSettings = v
	return s
}

// SetKinesisSettings sets the KinesisSettings field's value.
func (s *CreateEndpointInput) SetKinesisSettings(v *KinesisSettings) *CreateEndpointInput {
	s.KinesisSettings = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateEndpointInput) SetKmsKeyId(v string) *CreateEndpointInput {
	s.KmsKeyId = &v
	return s
}

// SetMicrosoftSQLServerSettings sets the MicrosoftSQLServerSettings field's value.
func (s *CreateEndpointInput) SetMicrosoftSQLServerSettings(v *MicrosoftSQLServerSettings) *CreateEndpointInput {
	s.MicrosoftSQLServerSettings = v
	return s
}

// SetMongoDbSettings sets the MongoDbSettings field's value.
func (s *CreateEndpointInput) SetMongoDbSettings(v *MongoDbSettings) *CreateEndpointInput {
	s.MongoDbSettings = v
	return s
}

// SetMySQLSettings sets the MySQLSettings field's value.
func (s *CreateEndpointInput) SetMySQLSettings(v *MySQLSettings) *CreateEndpointInput {
	s.MySQLSettings = v
	return s
}

// SetNeptuneSettings sets the NeptuneSettings field's value.
func (s *CreateEndpointInput) SetNeptuneSettings(v *NeptuneSettings) *CreateEndpointInput {
	s.NeptuneSettings = v
	return s
}

// SetOracleSettings sets the OracleSettings field's value.
func (s *CreateEndpointInput) SetOracleSettings(v *OracleSettings) *CreateEndpointInput {
	s.OracleSettings = v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateEndpointInput) SetPassword(v string) *CreateEndpointInput {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateEndpointInput) SetPort(v int64) *CreateEndpointInput {
	s.Port = &v
	return s
}

// SetPostgreSQLSettings sets the PostgreSQLSettings field's value.
func (s *CreateEndpointInput) SetPostgreSQLSettings(v *PostgreSQLSettings) *CreateEndpointInput {
	s.PostgreSQLSettings = v
	return s
}

// SetRedshiftSettings sets the RedshiftSettings field's value.
func (s *CreateEndpointInput) SetRedshiftSettings(v *RedshiftSettings) *CreateEndpointInput {
	s.RedshiftSettings = v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CreateEndpointInput) SetResourceIdentifier(v string) *CreateEndpointInput {
	s.ResourceIdentifier = &v
	return s
}

// SetS3Settings sets the S3Settings field's value.
func (s *CreateEndpointInput) SetS3Settings(v *S3Settings) *CreateEndpointInput {
	s.S3Settings = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *CreateEndpointInput) SetServerName(v string) *CreateEndpointInput {
	s.ServerName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *CreateEndpointInput) SetServiceAccessRoleArn(v string) *CreateEndpointInput {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetSslMode sets the SslMode field's value.
func (s *CreateEndpointInput) SetSslMode(v string) *CreateEndpointInput {
	s.SslMode = &v
	return s
}

// SetSybaseSettings sets the SybaseSettings field's value.
func (s *CreateEndpointInput) SetSybaseSettings(v *SybaseSettings) *CreateEndpointInput {
	s.SybaseSettings = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEndpointInput) SetTags(v []*Tag) *CreateEndpointInput {
	s.Tags = v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateEndpointInput) SetUsername(v string) *CreateEndpointInput {
	s.Username = &v
	return s
}

type CreateEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint that was created.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s CreateEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *CreateEndpointOutput) SetEndpoint(v *Endpoint) *CreateEndpointOutput {
	s.Endpoint = v
	return s
}

type CreateEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription, or set to false
	// to create the subscription but not activate it.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a source type that you want to subscribe to.
	// For more information, see Working with Events and Notifications (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Events.html)
	// in the Database Migration Service User Guide.
	EventCategories []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic created for event
	// notification. The ARN is created by Amazon SNS when you create a topic and
	// subscribe to it.
	//
	// SnsTopicArn is a required field
	SnsTopicArn *string `type:"string" required:"true"`

	// A list of identifiers for which DMS provides notification events.
	//
	// If you don't specify a value, notifications are provided for all sources.
	//
	// If you specify multiple values, they must be of the same type. For example,
	// if you specify a database instance ID, then all of the other values must
	// be database instance IDs.
	SourceIds []*string `type:"list"`

	// The type of DMS resource that generates the events. For example, if you want
	// to be notified of events generated by a replication instance, you set this
	// parameter to replication-instance. If this value isn't specified, all events
	// are returned.
	//
	// Valid values: replication-instance | replication-task
	SourceType *string `type:"string"`

	// The name of the DMS event notification subscription. This name must be less
	// than 255 characters.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`

	// One or more tags to be assigned to the event subscription.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventSubscriptionInput"}
	if s.SnsTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SnsTopicArn"))
	}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateEventSubscriptionInput) SetEnabled(v bool) *CreateEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *CreateEventSubscriptionInput) SetEventCategories(v []*string) *CreateEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *CreateEventSubscriptionInput) SetSnsTopicArn(v string) *CreateEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIds sets the SourceIds field's value.
func (s *CreateEventSubscriptionInput) SetSourceIds(v []*string) *CreateEventSubscriptionInput {
	s.SourceIds = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateEventSubscriptionInput) SetSourceType(v string) *CreateEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *CreateEventSubscriptionInput) SetSubscriptionName(v string) *CreateEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventSubscriptionInput) SetTags(v []*Tag) *CreateEventSubscriptionInput {
	s.Tags = v
	return s
}

type CreateEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The event subscription that was created.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s CreateEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *CreateEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *CreateEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type CreateReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be initially allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// A value that indicates whether minor engine upgrades are applied automatically
	// to the replication instance during the maintenance window. This parameter
	// defaults to true.
	//
	// Default: true
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Availability Zone where the replication instance will be created. The
	// default value is a random, system-chosen Availability Zone in the endpoint's
	// Region, for example: us-east-1d
	AvailabilityZone *string `type:"string"`

	// A list of custom DNS name servers supported for the replication instance
	// to access your on-premise source or target database. This list overrides
	// the default name servers supported by the replication instance. You can specify
	// a comma-separated list of internet addresses for up to four on-premise DNS
	// name servers. For example: "1.1.1.1,2.2.2.2,3.3.3.3,4.4.4.4"
	DnsNameServers *string `type:"string"`

	// The engine version number of the replication instance.
	//
	// If an engine version number is not specified when a replication instance
	// is created, the default is the latest engine version available.
	EngineVersion *string `type:"string"`

	// An KMS key identifier that is used to encrypt the data on the replication
	// instance.
	//
	// If you don't specify a value for the KmsKeyId parameter, then DMS uses your
	// default encryption key.
	//
	// KMS creates the default encryption key for your account. Your account has
	// a different default encryption key for each Region.
	KmsKeyId *string `type:"string"`

	// Specifies whether the replication instance is a Multi-AZ deployment. You
	// can't set the AvailabilityZone parameter if the Multi-AZ parameter is set
	// to true.
	MultiAZ *bool `type:"boolean"`

	// The weekly time range during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Default: A 30-minute window selected at random from an 8-hour block of time
	// per Region, occurring on a random day of the week.
	//
	// Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the accessibility options for the replication instance. A value
	// of true represents an instance with a public IP address. A value of false
	// represents an instance with a private IP address. The default value is true.
	PubliclyAccessible *bool `type:"boolean"`

	// The compute and memory capacity of the replication instance as defined for
	// the specified replication instance class. For example to specify the instance
	// class dms.c4.large, set this parameter to "dms.c4.large".
	//
	// For more information on the settings and capacities for the available replication
	// instance classes, see Selecting the right DMS replication instance for your
	// migration (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth).
	//
	// ReplicationInstanceClass is a required field
	ReplicationInstanceClass *string `type:"string" required:"true"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	//
	// Constraints:
	//
	//    * Must contain 1-63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Can't end with a hyphen or contain two consecutive hyphens.
	//
	// Example: myrepinstance
	//
	// ReplicationInstanceIdentifier is a required field
	ReplicationInstanceIdentifier *string `type:"string" required:"true"`

	// A subnet group to associate with the replication instance.
	ReplicationSubnetGroupIdentifier *string `type:"string"`

	// A friendly name for the resource identifier at the end of the EndpointArn
	// response parameter that is returned in the created Endpoint object. The value
	// for this parameter can have up to 31 characters. It can contain only ASCII
	// letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain
	// two consecutive hyphens, and can only begin with a letter, such as Example-App-ARN1.
	// For example, this value might result in the EndpointArn value arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1.
	// If you don't specify a ResourceIdentifier value, DMS generates a default
	// identifier value for the end of EndpointArn.
	ResourceIdentifier *string `type:"string"`

	// One or more tags to be assigned to the replication instance.
	Tags []*Tag `type:"list"`

	// Specifies the VPC security group to be used with the replication instance.
	// The VPC security group must work with the VPC containing the replication
	// instance.
	VpcSecurityGroupIds []*string `type:"list"`
}

// String returns the string representation
func (s CreateReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationInstanceInput"}
	if s.ReplicationInstanceClass == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceClass"))
	}
	if s.ReplicationInstanceIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *CreateReplicationInstanceInput) SetAllocatedStorage(v int64) *CreateReplicationInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *CreateReplicationInstanceInput) SetAutoMinorVersionUpgrade(v bool) *CreateReplicationInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateReplicationInstanceInput) SetAvailabilityZone(v string) *CreateReplicationInstanceInput {
	s.AvailabilityZone = &v
	return s
}

// SetDnsNameServers sets the DnsNameServers field's value.
func (s *CreateReplicationInstanceInput) SetDnsNameServers(v string) *CreateReplicationInstanceInput {
	s.DnsNameServers = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateReplicationInstanceInput) SetEngineVersion(v string) *CreateReplicationInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateReplicationInstanceInput) SetKmsKeyId(v string) *CreateReplicationInstanceInput {
	s.KmsKeyId = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *CreateReplicationInstanceInput) SetMultiAZ(v bool) *CreateReplicationInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateReplicationInstanceInput) SetPreferredMaintenanceWindow(v string) *CreateReplicationInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateReplicationInstanceInput) SetPubliclyAccessible(v bool) *CreateReplicationInstanceInput {
	s.PubliclyAccessible = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *CreateReplicationInstanceInput) SetReplicationInstanceClass(v string) *CreateReplicationInstanceInput {
	s.ReplicationInstanceClass = &v
	return s
}

// SetReplicationInstanceIdentifier sets the ReplicationInstanceIdentifier field's value.
func (s *CreateReplicationInstanceInput) SetReplicationInstanceIdentifier(v string) *CreateReplicationInstanceInput {
	s.ReplicationInstanceIdentifier = &v
	return s
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *CreateReplicationInstanceInput) SetReplicationSubnetGroupIdentifier(v string) *CreateReplicationInstanceInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CreateReplicationInstanceInput) SetResourceIdentifier(v string) *CreateReplicationInstanceInput {
	s.ResourceIdentifier = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationInstanceInput) SetTags(v []*Tag) *CreateReplicationInstanceInput {
	s.Tags = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateReplicationInstanceInput) SetVpcSecurityGroupIds(v []*string) *CreateReplicationInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

type CreateReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The replication instance that was created.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetReplicationInstance sets the ReplicationInstance field's value.
func (s *CreateReplicationInstanceOutput) SetReplicationInstance(v *ReplicationInstance) *CreateReplicationInstanceOutput {
	s.ReplicationInstance = v
	return s
}

type CreateReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The description for the subnet group.
	//
	// ReplicationSubnetGroupDescription is a required field
	ReplicationSubnetGroupDescription *string `type:"string" required:"true"`

	// The name for the replication subnet group. This value is stored as a lowercase
	// string.
	//
	// Constraints: Must contain no more than 255 alphanumeric characters, periods,
	// spaces, underscores, or hyphens. Must not be "default".
	//
	// Example: mySubnetgroup
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`

	// One or more subnet IDs to be assigned to the subnet group.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`

	// One or more tags to be assigned to the subnet group.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupDescription"))
	}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationSubnetGroupDescription sets the ReplicationSubnetGroupDescription field's value.
func (s *CreateReplicationSubnetGroupInput) SetReplicationSubnetGroupDescription(v string) *CreateReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupDescription = &v
	return s
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *CreateReplicationSubnetGroupInput) SetReplicationSubnetGroupIdentifier(v string) *CreateReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateReplicationSubnetGroupInput) SetSubnetIds(v []*string) *CreateReplicationSubnetGroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationSubnetGroupInput) SetTags(v []*Tag) *CreateReplicationSubnetGroupInput {
	s.Tags = v
	return s
}

type CreateReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The replication subnet group that was created.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetReplicationSubnetGroup sets the ReplicationSubnetGroup field's value.
func (s *CreateReplicationSubnetGroupOutput) SetReplicationSubnetGroup(v *ReplicationSubnetGroup) *CreateReplicationSubnetGroupOutput {
	s.ReplicationSubnetGroup = v
	return s
}

type CreateReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// Indicates when you want a change data capture (CDC) operation to start. Use
	// either CdcStartPosition or CdcStartTime to specify when you want a CDC operation
	// to start. Specifying both values results in an error.
	//
	// The value can be in date, checkpoint, or LSN/SCN format.
	//
	// Date Example: --cdc-start-position “2018-03-08T12:12:12”
	//
	// Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
	//
	// LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
	//
	// When you use this task setting with a source PostgreSQL database, a logical
	// replication slot should already be created and associated with the source
	// endpoint. You can verify this by setting the slotName extra connection attribute
	// to the name of this logical replication slot. For more information, see Extra
	// Connection Attributes When Using PostgreSQL as a Source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib).
	CdcStartPosition *string `type:"string"`

	// Indicates the start time for a change data capture (CDC) operation. Use either
	// CdcStartTime or CdcStartPosition to specify when you want a CDC operation
	// to start. Specifying both values results in an error.
	//
	// Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
	CdcStartTime *time.Time `type:"timestamp"`

	// Indicates when you want a change data capture (CDC) operation to stop. The
	// value can be either server time or commit time.
	//
	// Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
	//
	// Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12
	// “
	CdcStopPosition *string `type:"string"`

	// The migration type. Valid values: full-load | cdc | full-load-and-cdc
	//
	// MigrationType is a required field
	MigrationType *string `type:"string" required:"true" enum:"MigrationTypeValue"`

	// The Amazon Resource Name (ARN) of a replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`

	// An identifier for the replication task.
	//
	// Constraints:
	//
	//    * Must contain 1-255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// ReplicationTaskIdentifier is a required field
	ReplicationTaskIdentifier *string `type:"string" required:"true"`

	// Overall settings for the task, in JSON format. For more information, see
	// Specifying Task Settings for Database Migration Service Tasks (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TaskSettings.html)
	// in the Database Migration Service User Guide.
	ReplicationTaskSettings *string `type:"string"`

	// A friendly name for the resource identifier at the end of the EndpointArn
	// response parameter that is returned in the created Endpoint object. The value
	// for this parameter can have up to 31 characters. It can contain only ASCII
	// letters, digits, and hyphen ('-'). Also, it can't end with a hyphen or contain
	// two consecutive hyphens, and can only begin with a letter, such as Example-App-ARN1.
	// For example, this value might result in the EndpointArn value arn:aws:dms:eu-west-1:012345678901:rep:Example-App-ARN1.
	// If you don't specify a ResourceIdentifier value, DMS generates a default
	// identifier value for the end of EndpointArn.
	ResourceIdentifier *string `type:"string"`

	// An Amazon Resource Name (ARN) that uniquely identifies the source endpoint.
	//
	// SourceEndpointArn is a required field
	SourceEndpointArn *string `type:"string" required:"true"`

	// The table mappings for the task, in JSON format. For more information, see
	// Using Table Mapping to Specify Task Settings (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.CustomizingTasks.TableMapping.html)
	// in the Database Migration Service User Guide.
	//
	// TableMappings is a required field
	TableMappings *string `type:"string" required:"true"`

	// One or more tags to be assigned to the replication task.
	Tags []*Tag `type:"list"`

	// An Amazon Resource Name (ARN) that uniquely identifies the target endpoint.
	//
	// TargetEndpointArn is a required field
	TargetEndpointArn *string `type:"string" required:"true"`

	// Supplemental information that the task requires to migrate the data for certain
	// source and target endpoints. For more information, see Specifying Supplemental
	// Data for Task Settings (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
	// in the Database Migration Service User Guide.
	TaskData *string `type:"string"`
}

// String returns the string representation
func (s CreateReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateReplicationTaskInput"}
	if s.MigrationType == nil {
		invalidParams.Add(request.NewErrParamRequired("MigrationType"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}
	if s.ReplicationTaskIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskIdentifier"))
	}
	if s.SourceEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceEndpointArn"))
	}
	if s.TableMappings == nil {
		invalidParams.Add(request.NewErrParamRequired("TableMappings"))
	}
	if s.TargetEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetEndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCdcStartPosition sets the CdcStartPosition field's value.
func (s *CreateReplicationTaskInput) SetCdcStartPosition(v string) *CreateReplicationTaskInput {
	s.CdcStartPosition = &v
	return s
}

// SetCdcStartTime sets the CdcStartTime field's value.
func (s *CreateReplicationTaskInput) SetCdcStartTime(v time.Time) *CreateReplicationTaskInput {
	s.CdcStartTime = &v
	return s
}

// SetCdcStopPosition sets the CdcStopPosition field's value.
func (s *CreateReplicationTaskInput) SetCdcStopPosition(v string) *CreateReplicationTaskInput {
	s.CdcStopPosition = &v
	return s
}

// SetMigrationType sets the MigrationType field's value.
func (s *CreateReplicationTaskInput) SetMigrationType(v string) *CreateReplicationTaskInput {
	s.MigrationType = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *CreateReplicationTaskInput) SetReplicationInstanceArn(v string) *CreateReplicationTaskInput {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationTaskIdentifier sets the ReplicationTaskIdentifier field's value.
func (s *CreateReplicationTaskInput) SetReplicationTaskIdentifier(v string) *CreateReplicationTaskInput {
	s.ReplicationTaskIdentifier = &v
	return s
}

// SetReplicationTaskSettings sets the ReplicationTaskSettings field's value.
func (s *CreateReplicationTaskInput) SetReplicationTaskSettings(v string) *CreateReplicationTaskInput {
	s.ReplicationTaskSettings = &v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *CreateReplicationTaskInput) SetResourceIdentifier(v string) *CreateReplicationTaskInput {
	s.ResourceIdentifier = &v
	return s
}

// SetSourceEndpointArn sets the SourceEndpointArn field's value.
func (s *CreateReplicationTaskInput) SetSourceEndpointArn(v string) *CreateReplicationTaskInput {
	s.SourceEndpointArn = &v
	return s
}

// SetTableMappings sets the TableMappings field's value.
func (s *CreateReplicationTaskInput) SetTableMappings(v string) *CreateReplicationTaskInput {
	s.TableMappings = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateReplicationTaskInput) SetTags(v []*Tag) *CreateReplicationTaskInput {
	s.Tags = v
	return s
}

// SetTargetEndpointArn sets the TargetEndpointArn field's value.
func (s *CreateReplicationTaskInput) SetTargetEndpointArn(v string) *CreateReplicationTaskInput {
	s.TargetEndpointArn = &v
	return s
}

// SetTaskData sets the TaskData field's value.
func (s *CreateReplicationTaskInput) SetTaskData(v string) *CreateReplicationTaskInput {
	s.TaskData = &v
	return s
}

type CreateReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task that was created.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s CreateReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *CreateReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *CreateReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

type DeleteCertificateInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the deleted certificate.
	//
	// CertificateArn is a required field
	CertificateArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCertificateInput"}
	if s.CertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *DeleteCertificateInput) SetCertificateArn(v string) *DeleteCertificateInput {
	s.CertificateArn = &v
	return s
}

type DeleteCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The Secure Sockets Layer (SSL) certificate.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation
func (s DeleteCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *DeleteCertificateOutput) SetCertificate(v *Certificate) *DeleteCertificateOutput {
	s.Certificate = v
	return s
}

type DeleteConnectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DeleteConnectionInput) SetEndpointArn(v string) *DeleteConnectionInput {
	s.EndpointArn = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DeleteConnectionInput) SetReplicationInstanceArn(v string) *DeleteConnectionInput {
	s.ReplicationInstanceArn = &v
	return s
}

type DeleteConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The connection that is being deleted.
	Connection *Connection `type:"structure"`
}

// String returns the string representation
func (s DeleteConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *DeleteConnectionOutput) SetConnection(v *Connection) *DeleteConnectionOutput {
	s.Connection = v
	return s
}

type DeleteEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DeleteEndpointInput) SetEndpointArn(v string) *DeleteEndpointInput {
	s.EndpointArn = &v
	return s
}

type DeleteEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The endpoint that was deleted.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *DeleteEndpointOutput) SetEndpoint(v *Endpoint) *DeleteEndpointOutput {
	s.Endpoint = v
	return s
}

type DeleteEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// The name of the DMS event notification subscription to be deleted.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DeleteEventSubscriptionInput) SetSubscriptionName(v string) *DeleteEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type DeleteEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The event subscription that was deleted.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s DeleteEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *DeleteEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *DeleteEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type DeleteReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication instance to be deleted.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationInstanceInput"}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DeleteReplicationInstanceInput) SetReplicationInstanceArn(v string) *DeleteReplicationInstanceInput {
	s.ReplicationInstanceArn = &v
	return s
}

type DeleteReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The replication instance that was deleted.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetReplicationInstance sets the ReplicationInstance field's value.
func (s *DeleteReplicationInstanceOutput) SetReplicationInstance(v *ReplicationInstance) *DeleteReplicationInstanceOutput {
	s.ReplicationInstance = v
	return s
}

type DeleteReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// The subnet group name of the replication instance.
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *DeleteReplicationSubnetGroupInput) SetReplicationSubnetGroupIdentifier(v string) *DeleteReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

type DeleteReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

type DeleteReplicationTaskAssessmentRunInput struct {
	_ struct{} `type:"structure"`

	// Amazon Resource Name (ARN) of the premigration assessment run to be deleted.
	//
	// ReplicationTaskAssessmentRunArn is a required field
	ReplicationTaskAssessmentRunArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationTaskAssessmentRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationTaskAssessmentRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationTaskAssessmentRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationTaskAssessmentRunInput"}
	if s.ReplicationTaskAssessmentRunArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskAssessmentRunArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskAssessmentRunArn sets the ReplicationTaskAssessmentRunArn field's value.
func (s *DeleteReplicationTaskAssessmentRunInput) SetReplicationTaskAssessmentRunArn(v string) *DeleteReplicationTaskAssessmentRunInput {
	s.ReplicationTaskAssessmentRunArn = &v
	return s
}

type DeleteReplicationTaskAssessmentRunOutput struct {
	_ struct{} `type:"structure"`

	// The ReplicationTaskAssessmentRun object for the deleted assessment run.
	ReplicationTaskAssessmentRun *ReplicationTaskAssessmentRun `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationTaskAssessmentRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationTaskAssessmentRunOutput) GoString() string {
	return s.String()
}

// SetReplicationTaskAssessmentRun sets the ReplicationTaskAssessmentRun field's value.
func (s *DeleteReplicationTaskAssessmentRunOutput) SetReplicationTaskAssessmentRun(v *ReplicationTaskAssessmentRun) *DeleteReplicationTaskAssessmentRunOutput {
	s.ReplicationTaskAssessmentRun = v
	return s
}

type DeleteReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication task to be deleted.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DeleteReplicationTaskInput) SetReplicationTaskArn(v string) *DeleteReplicationTaskInput {
	s.ReplicationTaskArn = &v
	return s
}

type DeleteReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The deleted replication task.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s DeleteReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *DeleteReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *DeleteReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Account quota information.
	AccountQuotas []*AccountQuota `type:"list"`

	// A unique DMS identifier for an account in a particular Region. The value
	// of this identifier has the following format: c99999999999. DMS uses this
	// identifier to name artifacts. For example, DMS uses this identifier to name
	// the default Amazon S3 bucket for storing task assessment reports in a given
	// Region. The format of this S3 bucket name is the following: dms-AccountNumber-UniqueAccountIdentifier.
	// Here is an example name for this default S3 bucket: dms-111122223333-c44445555666.
	//
	// DMS supports the UniqueAccountIdentifier parameter in versions 3.1.4 and
	// later.
	UniqueAccountIdentifier *string `type:"string"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

// SetAccountQuotas sets the AccountQuotas field's value.
func (s *DescribeAccountAttributesOutput) SetAccountQuotas(v []*AccountQuota) *DescribeAccountAttributesOutput {
	s.AccountQuotas = v
	return s
}

// SetUniqueAccountIdentifier sets the UniqueAccountIdentifier field's value.
func (s *DescribeAccountAttributesOutput) SetUniqueAccountIdentifier(v string) *DescribeAccountAttributesOutput {
	s.UniqueAccountIdentifier = &v
	return s
}

type DescribeApplicableIndividualAssessmentsInput struct {
	_ struct{} `type:"structure"`

	// Optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// Maximum number of records to include in the response. If more records exist
	// than the specified MaxRecords value, a pagination token called a marker is
	// included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`

	// Name of the migration type that each provided individual assessment must
	// support.
	MigrationType *string `type:"string" enum:"MigrationTypeValue"`

	// ARN of a replication instance on which you want to base the default list
	// of individual assessments.
	ReplicationInstanceArn *string `type:"string"`

	// Amazon Resource Name (ARN) of a migration task on which you want to base
	// the default list of individual assessments.
	ReplicationTaskArn *string `type:"string"`

	// Name of a database engine that the specified replication instance supports
	// as a source.
	SourceEngineName *string `type:"string"`

	// Name of a database engine that the specified replication instance supports
	// as a target.
	TargetEngineName *string `type:"string"`
}

// String returns the string representation
func (s DescribeApplicableIndividualAssessmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicableIndividualAssessmentsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetMarker(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetMaxRecords(v int64) *DescribeApplicableIndividualAssessmentsInput {
	s.MaxRecords = &v
	return s
}

// SetMigrationType sets the MigrationType field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetMigrationType(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.MigrationType = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetReplicationInstanceArn(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetReplicationTaskArn(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.ReplicationTaskArn = &v
	return s
}

// SetSourceEngineName sets the SourceEngineName field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetSourceEngineName(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.SourceEngineName = &v
	return s
}

// SetTargetEngineName sets the TargetEngineName field's value.
func (s *DescribeApplicableIndividualAssessmentsInput) SetTargetEngineName(v string) *DescribeApplicableIndividualAssessmentsInput {
	s.TargetEngineName = &v
	return s
}

type DescribeApplicableIndividualAssessmentsOutput struct {
	_ struct{} `type:"structure"`

	// List of names for the individual assessments supported by the premigration
	// assessment run that you start based on the specified request parameters.
	// For more information on the available individual assessments, including compatibility
	// with different migration task configurations, see Working with premigration
	// assessment runs (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.AssessmentReport.html)
	// in the Database Migration Service User Guide.
	IndividualAssessmentNames []*string `type:"list"`

	// Pagination token returned for you to pass to a subsequent request. If you
	// pass this token as the Marker value in a subsequent request, the response
	// includes only records beyond the marker, up to the value specified in the
	// request by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeApplicableIndividualAssessmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeApplicableIndividualAssessmentsOutput) GoString() string {
	return s.String()
}

// SetIndividualAssessmentNames sets the IndividualAssessmentNames field's value.
func (s *DescribeApplicableIndividualAssessmentsOutput) SetIndividualAssessmentNames(v []*string) *DescribeApplicableIndividualAssessmentsOutput {
	s.IndividualAssessmentNames = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeApplicableIndividualAssessmentsOutput) SetMarker(v string) *DescribeApplicableIndividualAssessmentsOutput {
	s.Marker = &v
	return s
}

type DescribeCertificatesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the certificates described in the form of key-value pairs.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 10
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCertificatesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCertificatesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeCertificatesInput) SetFilters(v []*Filter) *DescribeCertificatesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesInput) SetMarker(v string) *DescribeCertificatesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeCertificatesInput) SetMaxRecords(v int64) *DescribeCertificatesInput {
	s.MaxRecords = &v
	return s
}

type DescribeCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The Secure Sockets Layer (SSL) certificates associated with the replication
	// instance.
	Certificates []*Certificate `type:"list"`

	// The pagination token.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCertificatesOutput) GoString() string {
	return s.String()
}

// SetCertificates sets the Certificates field's value.
func (s *DescribeCertificatesOutput) SetCertificates(v []*Certificate) *DescribeCertificatesOutput {
	s.Certificates = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeCertificatesOutput) SetMarker(v string) *DescribeCertificatesOutput {
	s.Marker = &v
	return s
}

type DescribeConnectionsInput struct {
	_ struct{} `type:"structure"`

	// The filters applied to the connection.
	//
	// Valid filter names: endpoint-arn | replication-instance-arn
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeConnectionsInput) SetFilters(v []*Filter) *DescribeConnectionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeConnectionsInput) SetMarker(v string) *DescribeConnectionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeConnectionsInput) SetMaxRecords(v int64) *DescribeConnectionsInput {
	s.MaxRecords = &v
	return s
}

type DescribeConnectionsOutput struct {
	_ struct{} `type:"structure"`

	// A description of the connections.
	Connections []*Connection `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeConnectionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsOutput) GoString() string {
	return s.String()
}

// SetConnections sets the Connections field's value.
func (s *DescribeConnectionsOutput) SetConnections(v []*Connection) *DescribeConnectionsOutput {
	s.Connections = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeConnectionsOutput) SetMarker(v string) *DescribeConnectionsOutput {
	s.Marker = &v
	return s
}

type DescribeEndpointSettingsInput struct {
	_ struct{} `type:"structure"`

	// The databse engine used for your source or target endpoint.
	//
	// EngineName is a required field
	EngineName *string `type:"string" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEndpointSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointSettingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointSettingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointSettingsInput"}
	if s.EngineName == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineName sets the EngineName field's value.
func (s *DescribeEndpointSettingsInput) SetEngineName(v string) *DescribeEndpointSettingsInput {
	s.EngineName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointSettingsInput) SetMarker(v string) *DescribeEndpointSettingsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEndpointSettingsInput) SetMaxRecords(v int64) *DescribeEndpointSettingsInput {
	s.MaxRecords = &v
	return s
}

type DescribeEndpointSettingsOutput struct {
	_ struct{} `type:"structure"`

	// Descriptions of the endpoint settings available for your source or target
	// database engine.
	EndpointSettings []*EndpointSetting `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEndpointSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointSettingsOutput) GoString() string {
	return s.String()
}

// SetEndpointSettings sets the EndpointSettings field's value.
func (s *DescribeEndpointSettingsOutput) SetEndpointSettings(v []*EndpointSetting) *DescribeEndpointSettingsOutput {
	s.EndpointSettings = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointSettingsOutput) SetMarker(v string) *DescribeEndpointSettingsOutput {
	s.Marker = &v
	return s
}

type DescribeEndpointTypesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the endpoint types.
	//
	// Valid filter names: engine-name | endpoint-type
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEndpointTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointTypesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEndpointTypesInput) SetFilters(v []*Filter) *DescribeEndpointTypesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointTypesInput) SetMarker(v string) *DescribeEndpointTypesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEndpointTypesInput) SetMaxRecords(v int64) *DescribeEndpointTypesInput {
	s.MaxRecords = &v
	return s
}

type DescribeEndpointTypesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The types of endpoints that are supported.
	SupportedEndpointTypes []*SupportedEndpointType `type:"list"`
}

// String returns the string representation
func (s DescribeEndpointTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointTypesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointTypesOutput) SetMarker(v string) *DescribeEndpointTypesOutput {
	s.Marker = &v
	return s
}

// SetSupportedEndpointTypes sets the SupportedEndpointTypes field's value.
func (s *DescribeEndpointTypesOutput) SetSupportedEndpointTypes(v []*SupportedEndpointType) *DescribeEndpointTypesOutput {
	s.SupportedEndpointTypes = v
	return s
}

type DescribeEndpointsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the endpoints.
	//
	// Valid filter names: endpoint-arn | endpoint-type | endpoint-id | engine-name
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeEndpointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEndpointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEndpointsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEndpointsInput) SetFilters(v []*Filter) *DescribeEndpointsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointsInput) SetMarker(v string) *DescribeEndpointsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEndpointsInput) SetMaxRecords(v int64) *DescribeEndpointsInput {
	s.MaxRecords = &v
	return s
}

type DescribeEndpointsOutput struct {
	_ struct{} `type:"structure"`

	// Endpoint description.
	Endpoints []*Endpoint `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEndpointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEndpointsOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *DescribeEndpointsOutput) SetEndpoints(v []*Endpoint) *DescribeEndpointsOutput {
	s.Endpoints = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEndpointsOutput) SetMarker(v string) *DescribeEndpointsOutput {
	s.Marker = &v
	return s
}

type DescribeEventCategoriesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the event categories.
	Filters []*Filter `type:"list"`

	// The type of DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-task
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventCategoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventCategoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventCategoriesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventCategoriesInput) SetFilters(v []*Filter) *DescribeEventCategoriesInput {
	s.Filters = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventCategoriesInput) SetSourceType(v string) *DescribeEventCategoriesInput {
	s.SourceType = &v
	return s
}

type DescribeEventCategoriesOutput struct {
	_ struct{} `type:"structure"`

	// A list of event categories.
	EventCategoryGroupList []*EventCategoryGroup `type:"list"`
}

// String returns the string representation
func (s DescribeEventCategoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventCategoriesOutput) GoString() string {
	return s.String()
}

// SetEventCategoryGroupList sets the EventCategoryGroupList field's value.
func (s *DescribeEventCategoriesOutput) SetEventCategoryGroupList(v []*EventCategoryGroup) *DescribeEventCategoriesOutput {
	s.EventCategoryGroupList = v
	return s
}

type DescribeEventSubscriptionsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to event subscriptions.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The name of the DMS event subscription to be described.
	SubscriptionName *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventSubscriptionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventSubscriptionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventSubscriptionsInput) SetFilters(v []*Filter) *DescribeEventSubscriptionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsInput) SetMarker(v string) *DescribeEventSubscriptionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventSubscriptionsInput) SetMaxRecords(v int64) *DescribeEventSubscriptionsInput {
	s.MaxRecords = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *DescribeEventSubscriptionsInput) SetSubscriptionName(v string) *DescribeEventSubscriptionsInput {
	s.SubscriptionName = &v
	return s
}

type DescribeEventSubscriptionsOutput struct {
	_ struct{} `type:"structure"`

	// A list of event subscriptions.
	EventSubscriptionsList []*EventSubscription `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventSubscriptionsOutput) GoString() string {
	return s.String()
}

// SetEventSubscriptionsList sets the EventSubscriptionsList field's value.
func (s *DescribeEventSubscriptionsOutput) SetEventSubscriptionsList(v []*EventSubscription) *DescribeEventSubscriptionsOutput {
	s.EventSubscriptionsList = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventSubscriptionsOutput) SetMarker(v string) *DescribeEventSubscriptionsOutput {
	s.Marker = &v
	return s
}

type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// The duration of the events to be listed.
	Duration *int64 `type:"integer"`

	// The end time for the events to be listed.
	EndTime *time.Time `type:"timestamp"`

	// A list of event categories for the source type that you've chosen.
	EventCategories []*string `type:"list"`

	// Filters applied to events.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The identifier of an event source.
	SourceIdentifier *string `type:"string"`

	// The type of DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-task
	SourceType *string `type:"string" enum:"SourceType"`

	// The start time for the events to be listed.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDuration sets the Duration field's value.
func (s *DescribeEventsInput) SetDuration(v int64) *DescribeEventsInput {
	s.Duration = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *DescribeEventsInput) SetEndTime(v time.Time) *DescribeEventsInput {
	s.EndTime = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *DescribeEventsInput) SetEventCategories(v []*string) *DescribeEventsInput {
	s.EventCategories = v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeEventsInput) SetFilters(v []*Filter) *DescribeEventsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsInput) SetMarker(v string) *DescribeEventsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeEventsInput) SetMaxRecords(v int64) *DescribeEventsInput {
	s.MaxRecords = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *DescribeEventsInput) SetSourceIdentifier(v string) *DescribeEventsInput {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *DescribeEventsInput) SetSourceType(v string) *DescribeEventsInput {
	s.SourceType = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *DescribeEventsInput) SetStartTime(v time.Time) *DescribeEventsInput {
	s.StartTime = &v
	return s
}

type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// The events described.
	Events []*Event `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetEvents sets the Events field's value.
func (s *DescribeEventsOutput) SetEvents(v []*Event) *DescribeEventsOutput {
	s.Events = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeEventsOutput) SetMarker(v string) *DescribeEventsOutput {
	s.Marker = &v
	return s
}

type DescribeOrderableReplicationInstancesInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeOrderableReplicationInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableReplicationInstancesInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableReplicationInstancesInput) SetMarker(v string) *DescribeOrderableReplicationInstancesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeOrderableReplicationInstancesInput) SetMaxRecords(v int64) *DescribeOrderableReplicationInstancesInput {
	s.MaxRecords = &v
	return s
}

type DescribeOrderableReplicationInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The order-able replication instances available.
	OrderableReplicationInstances []*OrderableReplicationInstance `type:"list"`
}

// String returns the string representation
func (s DescribeOrderableReplicationInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeOrderableReplicationInstancesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeOrderableReplicationInstancesOutput) SetMarker(v string) *DescribeOrderableReplicationInstancesOutput {
	s.Marker = &v
	return s
}

// SetOrderableReplicationInstances sets the OrderableReplicationInstances field's value.
func (s *DescribeOrderableReplicationInstancesOutput) SetOrderableReplicationInstances(v []*OrderableReplicationInstance) *DescribeOrderableReplicationInstancesOutput {
	s.OrderableReplicationInstances = v
	return s
}

type DescribePendingMaintenanceActionsInput struct {
	_ struct{} `type:"structure"`

	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingMaintenanceActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePendingMaintenanceActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribePendingMaintenanceActionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribePendingMaintenanceActionsInput) SetFilters(v []*Filter) *DescribePendingMaintenanceActionsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribePendingMaintenanceActionsInput) SetMarker(v string) *DescribePendingMaintenanceActionsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribePendingMaintenanceActionsInput) SetMaxRecords(v int64) *DescribePendingMaintenanceActionsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DescribePendingMaintenanceActionsInput) SetReplicationInstanceArn(v string) *DescribePendingMaintenanceActionsInput {
	s.ReplicationInstanceArn = &v
	return s
}

type DescribePendingMaintenanceActionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The pending maintenance action.
	PendingMaintenanceActions []*ResourcePendingMaintenanceActions `type:"list"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribePendingMaintenanceActionsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribePendingMaintenanceActionsOutput) SetMarker(v string) *DescribePendingMaintenanceActionsOutput {
	s.Marker = &v
	return s
}

// SetPendingMaintenanceActions sets the PendingMaintenanceActions field's value.
func (s *DescribePendingMaintenanceActionsOutput) SetPendingMaintenanceActions(v []*ResourcePendingMaintenanceActions) *DescribePendingMaintenanceActionsOutput {
	s.PendingMaintenanceActions = v
	return s
}

type DescribeRefreshSchemasStatusInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeRefreshSchemasStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRefreshSchemasStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeRefreshSchemasStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeRefreshSchemasStatusInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DescribeRefreshSchemasStatusInput) SetEndpointArn(v string) *DescribeRefreshSchemasStatusInput {
	s.EndpointArn = &v
	return s
}

type DescribeRefreshSchemasStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the schema.
	RefreshSchemasStatus *RefreshSchemasStatus `type:"structure"`
}

// String returns the string representation
func (s DescribeRefreshSchemasStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeRefreshSchemasStatusOutput) GoString() string {
	return s.String()
}

// SetRefreshSchemasStatus sets the RefreshSchemasStatus field's value.
func (s *DescribeRefreshSchemasStatusOutput) SetRefreshSchemasStatus(v *RefreshSchemasStatus) *DescribeRefreshSchemasStatusOutput {
	s.RefreshSchemasStatus = v
	return s
}

type DescribeReplicationInstanceTaskLogsInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeReplicationInstanceTaskLogsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationInstanceTaskLogsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationInstanceTaskLogsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationInstanceTaskLogsInput"}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationInstanceTaskLogsInput) SetMarker(v string) *DescribeReplicationInstanceTaskLogsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationInstanceTaskLogsInput) SetMaxRecords(v int64) *DescribeReplicationInstanceTaskLogsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DescribeReplicationInstanceTaskLogsInput) SetReplicationInstanceArn(v string) *DescribeReplicationInstanceTaskLogsInput {
	s.ReplicationInstanceArn = &v
	return s
}

type DescribeReplicationInstanceTaskLogsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// An array of replication task log metadata. Each member of the array contains
	// the replication task name, ARN, and task log size (in bytes).
	ReplicationInstanceTaskLogs []*ReplicationInstanceTaskLog `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationInstanceTaskLogsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationInstanceTaskLogsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationInstanceTaskLogsOutput) SetMarker(v string) *DescribeReplicationInstanceTaskLogsOutput {
	s.Marker = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *DescribeReplicationInstanceTaskLogsOutput) SetReplicationInstanceArn(v string) *DescribeReplicationInstanceTaskLogsOutput {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationInstanceTaskLogs sets the ReplicationInstanceTaskLogs field's value.
func (s *DescribeReplicationInstanceTaskLogsOutput) SetReplicationInstanceTaskLogs(v []*ReplicationInstanceTaskLog) *DescribeReplicationInstanceTaskLogsOutput {
	s.ReplicationInstanceTaskLogs = v
	return s
}

type DescribeReplicationInstancesInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to replication instances.
	//
	// Valid filter names: replication-instance-arn | replication-instance-id |
	// replication-instance-class | engine-version
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationInstancesInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationInstancesInput) SetFilters(v []*Filter) *DescribeReplicationInstancesInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationInstancesInput) SetMarker(v string) *DescribeReplicationInstancesInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationInstancesInput) SetMaxRecords(v int64) *DescribeReplicationInstancesInput {
	s.MaxRecords = &v
	return s
}

type DescribeReplicationInstancesOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The replication instances described.
	ReplicationInstances []*ReplicationInstance `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationInstancesOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationInstancesOutput) SetMarker(v string) *DescribeReplicationInstancesOutput {
	s.Marker = &v
	return s
}

// SetReplicationInstances sets the ReplicationInstances field's value.
func (s *DescribeReplicationInstancesOutput) SetReplicationInstances(v []*ReplicationInstance) *DescribeReplicationInstancesOutput {
	s.ReplicationInstances = v
	return s
}

type DescribeReplicationSubnetGroupsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to replication subnet groups.
	//
	// Valid filter names: replication-subnet-group-id
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationSubnetGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationSubnetGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationSubnetGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationSubnetGroupsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationSubnetGroupsInput) SetFilters(v []*Filter) *DescribeReplicationSubnetGroupsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationSubnetGroupsInput) SetMarker(v string) *DescribeReplicationSubnetGroupsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationSubnetGroupsInput) SetMaxRecords(v int64) *DescribeReplicationSubnetGroupsInput {
	s.MaxRecords = &v
	return s
}

type DescribeReplicationSubnetGroupsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A description of the replication subnet groups.
	ReplicationSubnetGroups []*ReplicationSubnetGroup `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationSubnetGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationSubnetGroupsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationSubnetGroupsOutput) SetMarker(v string) *DescribeReplicationSubnetGroupsOutput {
	s.Marker = &v
	return s
}

// SetReplicationSubnetGroups sets the ReplicationSubnetGroups field's value.
func (s *DescribeReplicationSubnetGroupsOutput) SetReplicationSubnetGroups(v []*ReplicationSubnetGroup) *DescribeReplicationSubnetGroupsOutput {
	s.ReplicationSubnetGroups = v
	return s
}

type DescribeReplicationTaskAssessmentResultsInput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the task.
	// When this input parameter is specified, the API returns only one result and
	// ignore the values of the MaxRecords and Marker parameters.
	ReplicationTaskArn *string `type:"string"`
}

// String returns the string representation
func (s DescribeReplicationTaskAssessmentResultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTaskAssessmentResultsInput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskAssessmentResultsInput) SetMarker(v string) *DescribeReplicationTaskAssessmentResultsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTaskAssessmentResultsInput) SetMaxRecords(v int64) *DescribeReplicationTaskAssessmentResultsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeReplicationTaskAssessmentResultsInput) SetReplicationTaskArn(v string) *DescribeReplicationTaskAssessmentResultsInput {
	s.ReplicationTaskArn = &v
	return s
}

type DescribeReplicationTaskAssessmentResultsOutput struct {
	_ struct{} `type:"structure"`

	// - The Amazon S3 bucket where the task assessment report is located.
	BucketName *string `type:"string"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The task assessment report.
	ReplicationTaskAssessmentResults []*ReplicationTaskAssessmentResult `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationTaskAssessmentResultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTaskAssessmentResultsOutput) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *DescribeReplicationTaskAssessmentResultsOutput) SetBucketName(v string) *DescribeReplicationTaskAssessmentResultsOutput {
	s.BucketName = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskAssessmentResultsOutput) SetMarker(v string) *DescribeReplicationTaskAssessmentResultsOutput {
	s.Marker = &v
	return s
}

// SetReplicationTaskAssessmentResults sets the ReplicationTaskAssessmentResults field's value.
func (s *DescribeReplicationTaskAssessmentResultsOutput) SetReplicationTaskAssessmentResults(v []*ReplicationTaskAssessmentResult) *DescribeReplicationTaskAssessmentResultsOutput {
	s.ReplicationTaskAssessmentResults = v
	return s
}

type DescribeReplicationTaskAssessmentRunsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the premigration assessment runs described in the form
	// of key-value pairs.
	//
	// Valid filter names: replication-task-assessment-run-arn, replication-task-arn,
	// replication-instance-arn, status
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationTaskAssessmentRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTaskAssessmentRunsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationTaskAssessmentRunsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationTaskAssessmentRunsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationTaskAssessmentRunsInput) SetFilters(v []*Filter) *DescribeReplicationTaskAssessmentRunsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskAssessmentRunsInput) SetMarker(v string) *DescribeReplicationTaskAssessmentRunsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTaskAssessmentRunsInput) SetMaxRecords(v int64) *DescribeReplicationTaskAssessmentRunsInput {
	s.MaxRecords = &v
	return s
}

type DescribeReplicationTaskAssessmentRunsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token returned for you to pass to a subsequent request. If you
	// pass this token as the Marker value in a subsequent request, the response
	// includes only records beyond the marker, up to the value specified in the
	// request by MaxRecords.
	Marker *string `type:"string"`

	// One or more premigration assessment runs as specified by Filters.
	ReplicationTaskAssessmentRuns []*ReplicationTaskAssessmentRun `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationTaskAssessmentRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTaskAssessmentRunsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskAssessmentRunsOutput) SetMarker(v string) *DescribeReplicationTaskAssessmentRunsOutput {
	s.Marker = &v
	return s
}

// SetReplicationTaskAssessmentRuns sets the ReplicationTaskAssessmentRuns field's value.
func (s *DescribeReplicationTaskAssessmentRunsOutput) SetReplicationTaskAssessmentRuns(v []*ReplicationTaskAssessmentRun) *DescribeReplicationTaskAssessmentRunsOutput {
	s.ReplicationTaskAssessmentRuns = v
	return s
}

type DescribeReplicationTaskIndividualAssessmentsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to the individual assessments described in the form of key-value
	// pairs.
	//
	// Valid filter names: replication-task-assessment-run-arn, replication-task-arn,
	// status
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeReplicationTaskIndividualAssessmentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTaskIndividualAssessmentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationTaskIndividualAssessmentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationTaskIndividualAssessmentsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationTaskIndividualAssessmentsInput) SetFilters(v []*Filter) *DescribeReplicationTaskIndividualAssessmentsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskIndividualAssessmentsInput) SetMarker(v string) *DescribeReplicationTaskIndividualAssessmentsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTaskIndividualAssessmentsInput) SetMaxRecords(v int64) *DescribeReplicationTaskIndividualAssessmentsInput {
	s.MaxRecords = &v
	return s
}

type DescribeReplicationTaskIndividualAssessmentsOutput struct {
	_ struct{} `type:"structure"`

	// A pagination token returned for you to pass to a subsequent request. If you
	// pass this token as the Marker value in a subsequent request, the response
	// includes only records beyond the marker, up to the value specified in the
	// request by MaxRecords.
	Marker *string `type:"string"`

	// One or more individual assessments as specified by Filters.
	ReplicationTaskIndividualAssessments []*ReplicationTaskIndividualAssessment `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationTaskIndividualAssessmentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTaskIndividualAssessmentsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTaskIndividualAssessmentsOutput) SetMarker(v string) *DescribeReplicationTaskIndividualAssessmentsOutput {
	s.Marker = &v
	return s
}

// SetReplicationTaskIndividualAssessments sets the ReplicationTaskIndividualAssessments field's value.
func (s *DescribeReplicationTaskIndividualAssessmentsOutput) SetReplicationTaskIndividualAssessments(v []*ReplicationTaskIndividualAssessment) *DescribeReplicationTaskIndividualAssessmentsOutput {
	s.ReplicationTaskIndividualAssessments = v
	return s
}

type DescribeReplicationTasksInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to replication tasks.
	//
	// Valid filter names: replication-task-arn | replication-task-id | migration-type
	// | endpoint-arn | replication-instance-arn
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// An option to set to avoid returning information about settings. Use this
	// to reduce overhead when setting information is too large. To use this option,
	// choose true; otherwise, choose false (the default).
	WithoutSettings *bool `type:"boolean"`
}

// String returns the string representation
func (s DescribeReplicationTasksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTasksInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReplicationTasksInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeReplicationTasksInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeReplicationTasksInput) SetFilters(v []*Filter) *DescribeReplicationTasksInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTasksInput) SetMarker(v string) *DescribeReplicationTasksInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeReplicationTasksInput) SetMaxRecords(v int64) *DescribeReplicationTasksInput {
	s.MaxRecords = &v
	return s
}

// SetWithoutSettings sets the WithoutSettings field's value.
func (s *DescribeReplicationTasksInput) SetWithoutSettings(v bool) *DescribeReplicationTasksInput {
	s.WithoutSettings = &v
	return s
}

type DescribeReplicationTasksOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// A description of the replication tasks.
	ReplicationTasks []*ReplicationTask `type:"list"`
}

// String returns the string representation
func (s DescribeReplicationTasksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeReplicationTasksOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeReplicationTasksOutput) SetMarker(v string) *DescribeReplicationTasksOutput {
	s.Marker = &v
	return s
}

// SetReplicationTasks sets the ReplicationTasks field's value.
func (s *DescribeReplicationTasksOutput) SetReplicationTasks(v []*ReplicationTask) *DescribeReplicationTasksOutput {
	s.ReplicationTasks = v
	return s
}

type DescribeSchemasInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`
}

// String returns the string representation
func (s DescribeSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSchemasInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *DescribeSchemasInput) SetEndpointArn(v string) *DescribeSchemasInput {
	s.EndpointArn = &v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeSchemasInput) SetMarker(v string) *DescribeSchemasInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeSchemasInput) SetMaxRecords(v int64) *DescribeSchemasInput {
	s.MaxRecords = &v
	return s
}

type DescribeSchemasOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The described schema.
	Schemas []*string `type:"list"`
}

// String returns the string representation
func (s DescribeSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSchemasOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeSchemasOutput) SetMarker(v string) *DescribeSchemasOutput {
	s.Marker = &v
	return s
}

// SetSchemas sets the Schemas field's value.
func (s *DescribeSchemasOutput) SetSchemas(v []*string) *DescribeSchemasOutput {
	s.Schemas = v
	return s
}

type DescribeTableStatisticsInput struct {
	_ struct{} `type:"structure"`

	// Filters applied to table statistics.
	//
	// Valid filter names: schema-name | table-name | table-state
	//
	// A combination of filters creates an AND condition where each record matches
	// all specified filters.
	Filters []*Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 500.
	MaxRecords *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) of the replication task.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTableStatisticsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableStatisticsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTableStatisticsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTableStatisticsInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *DescribeTableStatisticsInput) SetFilters(v []*Filter) *DescribeTableStatisticsInput {
	s.Filters = v
	return s
}

// SetMarker sets the Marker field's value.
func (s *DescribeTableStatisticsInput) SetMarker(v string) *DescribeTableStatisticsInput {
	s.Marker = &v
	return s
}

// SetMaxRecords sets the MaxRecords field's value.
func (s *DescribeTableStatisticsInput) SetMaxRecords(v int64) *DescribeTableStatisticsInput {
	s.MaxRecords = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeTableStatisticsInput) SetReplicationTaskArn(v string) *DescribeTableStatisticsInput {
	s.ReplicationTaskArn = &v
	return s
}

type DescribeTableStatisticsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The table statistics.
	TableStatistics []*TableStatistics `type:"list"`
}

// String returns the string representation
func (s DescribeTableStatisticsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTableStatisticsOutput) GoString() string {
	return s.String()
}

// SetMarker sets the Marker field's value.
func (s *DescribeTableStatisticsOutput) SetMarker(v string) *DescribeTableStatisticsOutput {
	s.Marker = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *DescribeTableStatisticsOutput) SetReplicationTaskArn(v string) *DescribeTableStatisticsOutput {
	s.ReplicationTaskArn = &v
	return s
}

// SetTableStatistics sets the TableStatistics field's value.
func (s *DescribeTableStatisticsOutput) SetTableStatistics(v []*TableStatistics) *DescribeTableStatisticsOutput {
	s.TableStatistics = v
	return s
}

// The settings in JSON format for the DMS Transfer type source endpoint.
type DmsTransferSettings struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket to use.
	BucketName *string `type:"string"`

	// The IAM role that has permission to access the Amazon S3 bucket. When specified
	// as part of request syntax, such as for the CreateEndpoint and ModifyEndpoint
	// actions, the role must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`
}

// String returns the string representation
func (s DmsTransferSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DmsTransferSettings) GoString() string {
	return s.String()
}

// SetBucketName sets the BucketName field's value.
func (s *DmsTransferSettings) SetBucketName(v string) *DmsTransferSettings {
	s.BucketName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *DmsTransferSettings) SetServiceAccessRoleArn(v string) *DmsTransferSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// Provides information that defines a DocumentDB endpoint.
type DocDbSettings struct {
	_ struct{} `type:"structure"`

	// The database name on the DocumentDB source endpoint.
	DatabaseName *string `type:"string"`

	// Indicates the number of documents to preview to determine the document organization.
	// Use this setting when NestingLevel is set to "one".
	//
	// Must be a positive value greater than 0. Default value is 1000.
	DocsToInvestigate *int64 `type:"integer"`

	// Specifies the document ID. Use this setting when NestingLevel is set to "none".
	//
	// Default value is "false".
	ExtractDocId *bool `type:"boolean"`

	// The KMS key identifier that is used to encrypt the content on the replication
	// instance. If you don't specify a value for the KmsKeyId parameter, then DMS
	// uses your default encryption key. KMS creates the default encryption key
	// for your account. Your account has a different default encryption key for
	// each Region.
	KmsKeyId *string `type:"string"`

	// Specifies either document or table mode.
	//
	// Default value is "none". Specify "none" to use document mode. Specify "one"
	// to use table mode.
	NestingLevel *string `type:"string" enum:"NestingLevelValue"`

	// The password for the user account you use to access the DocumentDB source
	// endpoint.
	Password *string `type:"string" sensitive:"true"`

	// The port value for the DocumentDB source endpoint.
	Port *int64 `type:"integer"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the DocumentDB endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the DocumentDB endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// The name of the server on the DocumentDB source endpoint.
	ServerName *string `type:"string"`

	// The user name you use to access the DocumentDB source endpoint.
	Username *string `type:"string"`
}

// String returns the string representation
func (s DocDbSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocDbSettings) GoString() string {
	return s.String()
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *DocDbSettings) SetDatabaseName(v string) *DocDbSettings {
	s.DatabaseName = &v
	return s
}

// SetDocsToInvestigate sets the DocsToInvestigate field's value.
func (s *DocDbSettings) SetDocsToInvestigate(v int64) *DocDbSettings {
	s.DocsToInvestigate = &v
	return s
}

// SetExtractDocId sets the ExtractDocId field's value.
func (s *DocDbSettings) SetExtractDocId(v bool) *DocDbSettings {
	s.ExtractDocId = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *DocDbSettings) SetKmsKeyId(v string) *DocDbSettings {
	s.KmsKeyId = &v
	return s
}

// SetNestingLevel sets the NestingLevel field's value.
func (s *DocDbSettings) SetNestingLevel(v string) *DocDbSettings {
	s.NestingLevel = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *DocDbSettings) SetPassword(v string) *DocDbSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *DocDbSettings) SetPort(v int64) *DocDbSettings {
	s.Port = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *DocDbSettings) SetSecretsManagerAccessRoleArn(v string) *DocDbSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *DocDbSettings) SetSecretsManagerSecretId(v string) *DocDbSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *DocDbSettings) SetServerName(v string) *DocDbSettings {
	s.ServerName = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *DocDbSettings) SetUsername(v string) *DocDbSettings {
	s.Username = &v
	return s
}

// Provides the Amazon Resource Name (ARN) of the Identity and Access Management
// (IAM) role used to define an Amazon DynamoDB target endpoint.
type DynamoDbSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) used by the service to access the IAM role.
	// The role must allow the iam:PassRole action.
	//
	// ServiceAccessRoleArn is a required field
	ServiceAccessRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DynamoDbSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DynamoDbSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DynamoDbSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DynamoDbSettings"}
	if s.ServiceAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *DynamoDbSettings) SetServiceAccessRoleArn(v string) *DynamoDbSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// Provides information that defines an Elasticsearch endpoint.
type ElasticsearchSettings struct {
	_ struct{} `type:"structure"`

	// The endpoint for the Elasticsearch cluster. DMS uses HTTPS if a transport
	// protocol (http/https) is not specified.
	//
	// EndpointUri is a required field
	EndpointUri *string `type:"string" required:"true"`

	// The maximum number of seconds for which DMS retries failed API requests to
	// the Elasticsearch cluster.
	ErrorRetryDuration *int64 `type:"integer"`

	// The maximum percentage of records that can fail to be written before a full
	// load operation stops.
	//
	// To avoid early failure, this counter is only effective after 1000 records
	// are transferred. Elasticsearch also has the concept of error monitoring during
	// the last 10 minutes of an Observation Window. If transfer of all records
	// fail in the last 10 minutes, the full load operation stops.
	FullLoadErrorPercentage *int64 `type:"integer"`

	// The Amazon Resource Name (ARN) used by the service to access the IAM role.
	// The role must allow the iam:PassRole action.
	//
	// ServiceAccessRoleArn is a required field
	ServiceAccessRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ElasticsearchSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ElasticsearchSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ElasticsearchSettings"}
	if s.EndpointUri == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointUri"))
	}
	if s.ServiceAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointUri sets the EndpointUri field's value.
func (s *ElasticsearchSettings) SetEndpointUri(v string) *ElasticsearchSettings {
	s.EndpointUri = &v
	return s
}

// SetErrorRetryDuration sets the ErrorRetryDuration field's value.
func (s *ElasticsearchSettings) SetErrorRetryDuration(v int64) *ElasticsearchSettings {
	s.ErrorRetryDuration = &v
	return s
}

// SetFullLoadErrorPercentage sets the FullLoadErrorPercentage field's value.
func (s *ElasticsearchSettings) SetFullLoadErrorPercentage(v int64) *ElasticsearchSettings {
	s.FullLoadErrorPercentage = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *ElasticsearchSettings) SetServiceAccessRoleArn(v string) *ElasticsearchSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// Describes an endpoint of a database instance in response to operations such
// as the following:
//
//    * CreateEndpoint
//
//    * DescribeEndpoint
//
//    * ModifyEndpoint
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) used for SSL connection to the endpoint.
	CertificateArn *string `type:"string"`

	// The name of the database at the endpoint.
	DatabaseName *string `type:"string"`

	// The settings in JSON format for the DMS transfer type of source endpoint.
	//
	// Possible settings include the following:
	//
	//    * ServiceAccessRoleArn - The IAM role that has permission to access the
	//    Amazon S3 bucket. The role must allow the iam:PassRole action.
	//
	//    * BucketName - The name of the S3 bucket to use.
	//
	// Shorthand syntax for these settings is as follows: ServiceAccessRoleArn=string,BucketName=string,
	//
	// JSON syntax for these settings is as follows: { "ServiceAccessRoleArn": "string",
	// "BucketName": "string"}
	DmsTransferSettings *DmsTransferSettings `type:"structure"`

	// Provides information that defines a DocumentDB endpoint.
	DocDbSettings *DocDbSettings `type:"structure"`

	// The settings for the DynamoDB target endpoint. For more information, see
	// the DynamoDBSettings structure.
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// The settings for the Elasticsearch source endpoint. For more information,
	// see the ElasticsearchSettings structure.
	ElasticsearchSettings *ElasticsearchSettings `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The database endpoint identifier. Identifiers must begin with a letter and
	// must contain only ASCII letters, digits, and hyphens. They can't end with
	// a hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The type of endpoint. Valid values are source and target.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The expanded name for the engine name. For example, if the EngineName parameter
	// is "aurora," this value would be "Amazon Aurora MySQL."
	EngineDisplayName *string `type:"string"`

	// The database engine name. Valid values, depending on the EndpointType, include
	// "mysql", "oracle", "postgres", "mariadb", "aurora", "aurora-postgresql",
	// "redshift", "s3", "db2", "azuredb", "sybase", "dynamodb", "mongodb", "kinesis",
	// "kafka", "elasticsearch", "documentdb", "sqlserver", and "neptune".
	EngineName *string `type:"string"`

	// Value returned by a call to CreateEndpoint that can be used for cross-account
	// validation. Use it on a subsequent call to CreateEndpoint to create the endpoint
	// with a cross-account.
	ExternalId *string `type:"string"`

	// The external table definition.
	ExternalTableDefinition *string `type:"string"`

	// Additional connection attributes used to connect to the endpoint.
	ExtraConnectionAttributes *string `type:"string"`

	// The settings for the IBM Db2 LUW source endpoint. For more information, see
	// the IBMDb2Settings structure.
	IBMDb2Settings *IBMDb2Settings `type:"structure"`

	// The settings for the Apache Kafka target endpoint. For more information,
	// see the KafkaSettings structure.
	KafkaSettings *KafkaSettings `type:"structure"`

	// The settings for the Amazon Kinesis target endpoint. For more information,
	// see the KinesisSettings structure.
	KinesisSettings *KinesisSettings `type:"structure"`

	// An KMS key identifier that is used to encrypt the connection parameters for
	// the endpoint.
	//
	// If you don't specify a value for the KmsKeyId parameter, then DMS uses your
	// default encryption key.
	//
	// KMS creates the default encryption key for your account. Your account has
	// a different default encryption key for each Region.
	KmsKeyId *string `type:"string"`

	// The settings for the Microsoft SQL Server source and target endpoint. For
	// more information, see the MicrosoftSQLServerSettings structure.
	MicrosoftSQLServerSettings *MicrosoftSQLServerSettings `type:"structure"`

	// The settings for the MongoDB source endpoint. For more information, see the
	// MongoDbSettings structure.
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// The settings for the MySQL source and target endpoint. For more information,
	// see the MySQLSettings structure.
	MySQLSettings *MySQLSettings `type:"structure"`

	// The settings for the Amazon Neptune target endpoint. For more information,
	// see the NeptuneSettings structure.
	NeptuneSettings *NeptuneSettings `type:"structure"`

	// The settings for the Oracle source and target endpoint. For more information,
	// see the OracleSettings structure.
	OracleSettings *OracleSettings `type:"structure"`

	// The port value used to access the endpoint.
	Port *int64 `type:"integer"`

	// The settings for the PostgreSQL source and target endpoint. For more information,
	// see the PostgreSQLSettings structure.
	PostgreSQLSettings *PostgreSQLSettings `type:"structure"`

	// Settings for the Amazon Redshift endpoint.
	RedshiftSettings *RedshiftSettings `type:"structure"`

	// The settings for the S3 target endpoint. For more information, see the S3Settings
	// structure.
	S3Settings *S3Settings `type:"structure"`

	// The name of the server at the endpoint.
	ServerName *string `type:"string"`

	// The Amazon Resource Name (ARN) used by the service to access the IAM role.
	// The role must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`

	// The SSL mode used to connect to the endpoint. The default value is none.
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// The status of the endpoint.
	Status *string `type:"string"`

	// The settings for the SAP ASE source and target endpoint. For more information,
	// see the SybaseSettings structure.
	SybaseSettings *SybaseSettings `type:"structure"`

	// The user name used to connect to the endpoint.
	Username *string `type:"string"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *Endpoint) SetCertificateArn(v string) *Endpoint {
	s.CertificateArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *Endpoint) SetDatabaseName(v string) *Endpoint {
	s.DatabaseName = &v
	return s
}

// SetDmsTransferSettings sets the DmsTransferSettings field's value.
func (s *Endpoint) SetDmsTransferSettings(v *DmsTransferSettings) *Endpoint {
	s.DmsTransferSettings = v
	return s
}

// SetDocDbSettings sets the DocDbSettings field's value.
func (s *Endpoint) SetDocDbSettings(v *DocDbSettings) *Endpoint {
	s.DocDbSettings = v
	return s
}

// SetDynamoDbSettings sets the DynamoDbSettings field's value.
func (s *Endpoint) SetDynamoDbSettings(v *DynamoDbSettings) *Endpoint {
	s.DynamoDbSettings = v
	return s
}

// SetElasticsearchSettings sets the ElasticsearchSettings field's value.
func (s *Endpoint) SetElasticsearchSettings(v *ElasticsearchSettings) *Endpoint {
	s.ElasticsearchSettings = v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *Endpoint) SetEndpointArn(v string) *Endpoint {
	s.EndpointArn = &v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *Endpoint) SetEndpointIdentifier(v string) *Endpoint {
	s.EndpointIdentifier = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *Endpoint) SetEndpointType(v string) *Endpoint {
	s.EndpointType = &v
	return s
}

// SetEngineDisplayName sets the EngineDisplayName field's value.
func (s *Endpoint) SetEngineDisplayName(v string) *Endpoint {
	s.EngineDisplayName = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *Endpoint) SetEngineName(v string) *Endpoint {
	s.EngineName = &v
	return s
}

// SetExternalId sets the ExternalId field's value.
func (s *Endpoint) SetExternalId(v string) *Endpoint {
	s.ExternalId = &v
	return s
}

// SetExternalTableDefinition sets the ExternalTableDefinition field's value.
func (s *Endpoint) SetExternalTableDefinition(v string) *Endpoint {
	s.ExternalTableDefinition = &v
	return s
}

// SetExtraConnectionAttributes sets the ExtraConnectionAttributes field's value.
func (s *Endpoint) SetExtraConnectionAttributes(v string) *Endpoint {
	s.ExtraConnectionAttributes = &v
	return s
}

// SetIBMDb2Settings sets the IBMDb2Settings field's value.
func (s *Endpoint) SetIBMDb2Settings(v *IBMDb2Settings) *Endpoint {
	s.IBMDb2Settings = v
	return s
}

// SetKafkaSettings sets the KafkaSettings field's value.
func (s *Endpoint) SetKafkaSettings(v *KafkaSettings) *Endpoint {
	s.KafkaSettings = v
	return s
}

// SetKinesisSettings sets the KinesisSettings field's value.
func (s *Endpoint) SetKinesisSettings(v *KinesisSettings) *Endpoint {
	s.KinesisSettings = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Endpoint) SetKmsKeyId(v string) *Endpoint {
	s.KmsKeyId = &v
	return s
}

// SetMicrosoftSQLServerSettings sets the MicrosoftSQLServerSettings field's value.
func (s *Endpoint) SetMicrosoftSQLServerSettings(v *MicrosoftSQLServerSettings) *Endpoint {
	s.MicrosoftSQLServerSettings = v
	return s
}

// SetMongoDbSettings sets the MongoDbSettings field's value.
func (s *Endpoint) SetMongoDbSettings(v *MongoDbSettings) *Endpoint {
	s.MongoDbSettings = v
	return s
}

// SetMySQLSettings sets the MySQLSettings field's value.
func (s *Endpoint) SetMySQLSettings(v *MySQLSettings) *Endpoint {
	s.MySQLSettings = v
	return s
}

// SetNeptuneSettings sets the NeptuneSettings field's value.
func (s *Endpoint) SetNeptuneSettings(v *NeptuneSettings) *Endpoint {
	s.NeptuneSettings = v
	return s
}

// SetOracleSettings sets the OracleSettings field's value.
func (s *Endpoint) SetOracleSettings(v *OracleSettings) *Endpoint {
	s.OracleSettings = v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// SetPostgreSQLSettings sets the PostgreSQLSettings field's value.
func (s *Endpoint) SetPostgreSQLSettings(v *PostgreSQLSettings) *Endpoint {
	s.PostgreSQLSettings = v
	return s
}

// SetRedshiftSettings sets the RedshiftSettings field's value.
func (s *Endpoint) SetRedshiftSettings(v *RedshiftSettings) *Endpoint {
	s.RedshiftSettings = v
	return s
}

// SetS3Settings sets the S3Settings field's value.
func (s *Endpoint) SetS3Settings(v *S3Settings) *Endpoint {
	s.S3Settings = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *Endpoint) SetServerName(v string) *Endpoint {
	s.ServerName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *Endpoint) SetServiceAccessRoleArn(v string) *Endpoint {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetSslMode sets the SslMode field's value.
func (s *Endpoint) SetSslMode(v string) *Endpoint {
	s.SslMode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Endpoint) SetStatus(v string) *Endpoint {
	s.Status = &v
	return s
}

// SetSybaseSettings sets the SybaseSettings field's value.
func (s *Endpoint) SetSybaseSettings(v *SybaseSettings) *Endpoint {
	s.SybaseSettings = v
	return s
}

// SetUsername sets the Username field's value.
func (s *Endpoint) SetUsername(v string) *Endpoint {
	s.Username = &v
	return s
}

// Endpoint settings.
type EndpointSetting struct {
	_ struct{} `type:"structure"`

	// The relevance or validity of an endpoint setting for an engine name and its
	// endpoint type.
	Applicability *string `type:"string"`

	// The default value of the endpoint setting if no value is specified using
	// CreateEndpoint or ModifyEndpoint.
	DefaultValue *string `type:"string"`

	// Enumerated values to use for this endpoint.
	EnumValues []*string `type:"list"`

	// The maximum value of an endpoint setting that is of type int.
	IntValueMax *int64 `type:"integer"`

	// The minimum value of an endpoint setting that is of type int.
	IntValueMin *int64 `type:"integer"`

	// The name that you want to give the endpoint settings.
	Name *string `type:"string"`

	// A value that marks this endpoint setting as sensitive.
	Sensitive *bool `type:"boolean"`

	// The type of endpoint. Valid values are source and target.
	Type *string `type:"string" enum:"EndpointSettingTypeValue"`

	// The unit of measure for this endpoint setting.
	Units *string `type:"string"`
}

// String returns the string representation
func (s EndpointSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EndpointSetting) GoString() string {
	return s.String()
}

// SetApplicability sets the Applicability field's value.
func (s *EndpointSetting) SetApplicability(v string) *EndpointSetting {
	s.Applicability = &v
	return s
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *EndpointSetting) SetDefaultValue(v string) *EndpointSetting {
	s.DefaultValue = &v
	return s
}

// SetEnumValues sets the EnumValues field's value.
func (s *EndpointSetting) SetEnumValues(v []*string) *EndpointSetting {
	s.EnumValues = v
	return s
}

// SetIntValueMax sets the IntValueMax field's value.
func (s *EndpointSetting) SetIntValueMax(v int64) *EndpointSetting {
	s.IntValueMax = &v
	return s
}

// SetIntValueMin sets the IntValueMin field's value.
func (s *EndpointSetting) SetIntValueMin(v int64) *EndpointSetting {
	s.IntValueMin = &v
	return s
}

// SetName sets the Name field's value.
func (s *EndpointSetting) SetName(v string) *EndpointSetting {
	s.Name = &v
	return s
}

// SetSensitive sets the Sensitive field's value.
func (s *EndpointSetting) SetSensitive(v bool) *EndpointSetting {
	s.Sensitive = &v
	return s
}

// SetType sets the Type field's value.
func (s *EndpointSetting) SetType(v string) *EndpointSetting {
	s.Type = &v
	return s
}

// SetUnits sets the Units field's value.
func (s *EndpointSetting) SetUnits(v string) *EndpointSetting {
	s.Units = &v
	return s
}

// Describes an identifiable significant activity that affects a replication
// instance or task. This object can provide the message, the available event
// categories, the date and source of the event, and the DMS resource type.
type Event struct {
	_ struct{} `type:"structure"`

	// The date of the event.
	Date *time.Time `type:"timestamp"`

	// The event categories available for the specified source type.
	EventCategories []*string `type:"list"`

	// The event message.
	Message *string `type:"string"`

	// The identifier of an event source.
	SourceIdentifier *string `type:"string"`

	// The type of DMS resource that generates events.
	//
	// Valid values: replication-instance | endpoint | replication-task
	SourceType *string `type:"string" enum:"SourceType"`
}

// String returns the string representation
func (s Event) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Event) GoString() string {
	return s.String()
}

// SetDate sets the Date field's value.
func (s *Event) SetDate(v time.Time) *Event {
	s.Date = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *Event) SetEventCategories(v []*string) *Event {
	s.EventCategories = v
	return s
}

// SetMessage sets the Message field's value.
func (s *Event) SetMessage(v string) *Event {
	s.Message = &v
	return s
}

// SetSourceIdentifier sets the SourceIdentifier field's value.
func (s *Event) SetSourceIdentifier(v string) *Event {
	s.SourceIdentifier = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *Event) SetSourceType(v string) *Event {
	s.SourceType = &v
	return s
}

// Lists categories of events subscribed to, and generated by, the applicable
// DMS resource type. This data type appears in response to the DescribeEventCategories
// (https://docs.aws.amazon.com/dms/latest/APIReference/API_EventCategoryGroup.html)
// action.
type EventCategoryGroup struct {
	_ struct{} `type:"structure"`

	// A list of event categories from a source type that you've chosen.
	EventCategories []*string `type:"list"`

	// The type of DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-server | security-group
	// | replication-task
	SourceType *string `type:"string"`
}

// String returns the string representation
func (s EventCategoryGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventCategoryGroup) GoString() string {
	return s.String()
}

// SetEventCategories sets the EventCategories field's value.
func (s *EventCategoryGroup) SetEventCategories(v []*string) *EventCategoryGroup {
	s.EventCategories = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventCategoryGroup) SetSourceType(v string) *EventCategoryGroup {
	s.SourceType = &v
	return s
}

// Describes an event notification subscription created by the CreateEventSubscription
// operation.
type EventSubscription struct {
	_ struct{} `type:"structure"`

	// The DMS event notification subscription Id.
	CustSubscriptionId *string `type:"string"`

	// The Amazon Web Services customer account associated with the DMS event notification
	// subscription.
	CustomerAwsId *string `type:"string"`

	// Boolean value that indicates if the event subscription is enabled.
	Enabled *bool `type:"boolean"`

	// A lists of event categories.
	EventCategoriesList []*string `type:"list"`

	// The topic ARN of the DMS event notification subscription.
	SnsTopicArn *string `type:"string"`

	// A list of source Ids for the event subscription.
	SourceIdsList []*string `type:"list"`

	// The type of DMS resource that generates events.
	//
	// Valid values: replication-instance | replication-server | security-group
	// | replication-task
	SourceType *string `type:"string"`

	// The status of the DMS event notification subscription.
	//
	// Constraints:
	//
	// Can be one of the following: creating | modifying | deleting | active | no-permission
	// | topic-not-exist
	//
	// The status "no-permission" indicates that DMS no longer has permission to
	// post to the SNS topic. The status "topic-not-exist" indicates that the topic
	// was deleted after the subscription was created.
	Status *string `type:"string"`

	// The time the DMS event notification subscription was created.
	SubscriptionCreationTime *string `type:"string"`
}

// String returns the string representation
func (s EventSubscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSubscription) GoString() string {
	return s.String()
}

// SetCustSubscriptionId sets the CustSubscriptionId field's value.
func (s *EventSubscription) SetCustSubscriptionId(v string) *EventSubscription {
	s.CustSubscriptionId = &v
	return s
}

// SetCustomerAwsId sets the CustomerAwsId field's value.
func (s *EventSubscription) SetCustomerAwsId(v string) *EventSubscription {
	s.CustomerAwsId = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *EventSubscription) SetEnabled(v bool) *EventSubscription {
	s.Enabled = &v
	return s
}

// SetEventCategoriesList sets the EventCategoriesList field's value.
func (s *EventSubscription) SetEventCategoriesList(v []*string) *EventSubscription {
	s.EventCategoriesList = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *EventSubscription) SetSnsTopicArn(v string) *EventSubscription {
	s.SnsTopicArn = &v
	return s
}

// SetSourceIdsList sets the SourceIdsList field's value.
func (s *EventSubscription) SetSourceIdsList(v []*string) *EventSubscription {
	s.SourceIdsList = v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *EventSubscription) SetSourceType(v string) *EventSubscription {
	s.SourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *EventSubscription) SetStatus(v string) *EventSubscription {
	s.Status = &v
	return s
}

// SetSubscriptionCreationTime sets the SubscriptionCreationTime field's value.
func (s *EventSubscription) SetSubscriptionCreationTime(v string) *EventSubscription {
	s.SubscriptionCreationTime = &v
	return s
}

// Identifies the name and value of a filter object. This filter is used to
// limit the number and type of DMS objects that are returned for a particular
// Describe* call or similar operation. Filters are used as an optional parameter
// for certain API operations.
type Filter struct {
	_ struct{} `type:"structure"`

	// The name of the filter as specified for a Describe* or similar operation.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The filter value, which can specify one or more values used to narrow the
	// returned results.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s Filter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Filter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Filter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Filter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *Filter) SetName(v string) *Filter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *Filter) SetValues(v []*string) *Filter {
	s.Values = v
	return s
}

// Provides information that defines an IBM Db2 LUW endpoint.
type IBMDb2Settings struct {
	_ struct{} `type:"structure"`

	// For ongoing replication (CDC), use CurrentLSN to specify a log sequence number
	// (LSN) where you want the replication to start.
	CurrentLsn *string `type:"string"`

	// Database name for the endpoint.
	DatabaseName *string `type:"string"`

	// Maximum number of bytes per read, as a NUMBER value. The default is 64 KB.
	MaxKBytesPerRead *int64 `type:"integer"`

	// Endpoint connection password.
	Password *string `type:"string" sensitive:"true"`

	// Endpoint TCP port. The default value is 50000.
	Port *int64 `type:"integer"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the Db2 LUW endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the Db2 LUW endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// Fully qualified domain name of the endpoint.
	ServerName *string `type:"string"`

	// Enables ongoing replication (CDC) as a BOOLEAN value. The default is true.
	SetDataCaptureChanges *bool `type:"boolean"`

	// Endpoint connection user name.
	Username *string `type:"string"`
}

// String returns the string representation
func (s IBMDb2Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IBMDb2Settings) GoString() string {
	return s.String()
}

// SetCurrentLsn sets the CurrentLsn field's value.
func (s *IBMDb2Settings) SetCurrentLsn(v string) *IBMDb2Settings {
	s.CurrentLsn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *IBMDb2Settings) SetDatabaseName(v string) *IBMDb2Settings {
	s.DatabaseName = &v
	return s
}

// SetMaxKBytesPerRead sets the MaxKBytesPerRead field's value.
func (s *IBMDb2Settings) SetMaxKBytesPerRead(v int64) *IBMDb2Settings {
	s.MaxKBytesPerRead = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *IBMDb2Settings) SetPassword(v string) *IBMDb2Settings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *IBMDb2Settings) SetPort(v int64) *IBMDb2Settings {
	s.Port = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *IBMDb2Settings) SetSecretsManagerAccessRoleArn(v string) *IBMDb2Settings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *IBMDb2Settings) SetSecretsManagerSecretId(v string) *IBMDb2Settings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *IBMDb2Settings) SetServerName(v string) *IBMDb2Settings {
	s.ServerName = &v
	return s
}

// SetSetDataCaptureChanges sets the SetDataCaptureChanges field's value.
func (s *IBMDb2Settings) SetSetDataCaptureChanges(v bool) *IBMDb2Settings {
	s.SetDataCaptureChanges = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *IBMDb2Settings) SetUsername(v string) *IBMDb2Settings {
	s.Username = &v
	return s
}

type ImportCertificateInput struct {
	_ struct{} `type:"structure"`

	// A customer-assigned name for the certificate. Identifiers must begin with
	// a letter and must contain only ASCII letters, digits, and hyphens. They can't
	// end with a hyphen or contain two consecutive hyphens.
	//
	// CertificateIdentifier is a required field
	CertificateIdentifier *string `type:"string" required:"true"`

	// The contents of a .pem file, which contains an X.509 certificate.
	CertificatePem *string `type:"string" sensitive:"true"`

	// The location of an imported Oracle Wallet certificate for use with SSL. Provide
	// the name of a .sso file using the fileb:// prefix. You can't provide the
	// certificate inline.
	//
	// CertificateWallet is automatically base64 encoded/decoded by the SDK.
	CertificateWallet []byte `type:"blob"`

	// The tags associated with the certificate.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ImportCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportCertificateInput"}
	if s.CertificateIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("CertificateIdentifier"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateIdentifier sets the CertificateIdentifier field's value.
func (s *ImportCertificateInput) SetCertificateIdentifier(v string) *ImportCertificateInput {
	s.CertificateIdentifier = &v
	return s
}

// SetCertificatePem sets the CertificatePem field's value.
func (s *ImportCertificateInput) SetCertificatePem(v string) *ImportCertificateInput {
	s.CertificatePem = &v
	return s
}

// SetCertificateWallet sets the CertificateWallet field's value.
func (s *ImportCertificateInput) SetCertificateWallet(v []byte) *ImportCertificateInput {
	s.CertificateWallet = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportCertificateInput) SetTags(v []*Tag) *ImportCertificateInput {
	s.Tags = v
	return s
}

type ImportCertificateOutput struct {
	_ struct{} `type:"structure"`

	// The certificate to be uploaded.
	Certificate *Certificate `type:"structure"`
}

// String returns the string representation
func (s ImportCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ImportCertificateOutput) GoString() string {
	return s.String()
}

// SetCertificate sets the Certificate field's value.
func (s *ImportCertificateOutput) SetCertificate(v *Certificate) *ImportCertificateOutput {
	s.Certificate = v
	return s
}

// There are not enough resources allocated to the database migration.
type InsufficientResourceCapacityFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InsufficientResourceCapacityFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InsufficientResourceCapacityFault) GoString() string {
	return s.String()
}

func newErrorInsufficientResourceCapacityFault(v protocol.ResponseMetadata) error {
	return &InsufficientResourceCapacityFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientResourceCapacityFault) Code() string {
	return "InsufficientResourceCapacityFault"
}

// Message returns the exception's message.
func (s *InsufficientResourceCapacityFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientResourceCapacityFault) OrigErr() error {
	return nil
}

func (s *InsufficientResourceCapacityFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientResourceCapacityFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientResourceCapacityFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The certificate was not valid.
type InvalidCertificateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidCertificateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidCertificateFault) GoString() string {
	return s.String()
}

func newErrorInvalidCertificateFault(v protocol.ResponseMetadata) error {
	return &InvalidCertificateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidCertificateFault) Code() string {
	return "InvalidCertificateFault"
}

// Message returns the exception's message.
func (s *InvalidCertificateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidCertificateFault) OrigErr() error {
	return nil
}

func (s *InvalidCertificateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidCertificateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidCertificateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource is in a state that prevents it from being used for database
// migration.
type InvalidResourceStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidResourceStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidResourceStateFault) GoString() string {
	return s.String()
}

func newErrorInvalidResourceStateFault(v protocol.ResponseMetadata) error {
	return &InvalidResourceStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceStateFault) Code() string {
	return "InvalidResourceStateFault"
}

// Message returns the exception's message.
func (s *InvalidResourceStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceStateFault) OrigErr() error {
	return nil
}

func (s *InvalidResourceStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The subnet provided is invalid.
type InvalidSubnet struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidSubnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidSubnet) GoString() string {
	return s.String()
}

func newErrorInvalidSubnet(v protocol.ResponseMetadata) error {
	return &InvalidSubnet{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidSubnet) Code() string {
	return "InvalidSubnet"
}

// Message returns the exception's message.
func (s *InvalidSubnet) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidSubnet) OrigErr() error {
	return nil
}

func (s *InvalidSubnet) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidSubnet) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidSubnet) RequestID() string {
	return s.RespMetadata.RequestID
}

// The ciphertext references a key that doesn't exist or that the DMS account
// doesn't have access to.
type KMSAccessDeniedFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s KMSAccessDeniedFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSAccessDeniedFault) GoString() string {
	return s.String()
}

func newErrorKMSAccessDeniedFault(v protocol.ResponseMetadata) error {
	return &KMSAccessDeniedFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSAccessDeniedFault) Code() string {
	return "KMSAccessDeniedFault"
}

// Message returns the exception's message.
func (s *KMSAccessDeniedFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSAccessDeniedFault) OrigErr() error {
	return nil
}

func (s *KMSAccessDeniedFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSAccessDeniedFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSAccessDeniedFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified master key (CMK) isn't enabled.
type KMSDisabledFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s KMSDisabledFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSDisabledFault) GoString() string {
	return s.String()
}

func newErrorKMSDisabledFault(v protocol.ResponseMetadata) error {
	return &KMSDisabledFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSDisabledFault) Code() string {
	return "KMSDisabledFault"
}

// Message returns the exception's message.
func (s *KMSDisabledFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSDisabledFault) OrigErr() error {
	return nil
}

func (s *KMSDisabledFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSDisabledFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSDisabledFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// An Key Management Service (KMS) error is preventing access to KMS.
type KMSFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s KMSFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSFault) GoString() string {
	return s.String()
}

func newErrorKMSFault(v protocol.ResponseMetadata) error {
	return &KMSFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSFault) Code() string {
	return "KMSFault"
}

// Message returns the exception's message.
func (s *KMSFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSFault) OrigErr() error {
	return nil
}

func (s *KMSFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The state of the specified KMS resource isn't valid for this request.
type KMSInvalidStateFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s KMSInvalidStateFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSInvalidStateFault) GoString() string {
	return s.String()
}

func newErrorKMSInvalidStateFault(v protocol.ResponseMetadata) error {
	return &KMSInvalidStateFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSInvalidStateFault) Code() string {
	return "KMSInvalidStateFault"
}

// Message returns the exception's message.
func (s *KMSInvalidStateFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSInvalidStateFault) OrigErr() error {
	return nil
}

func (s *KMSInvalidStateFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSInvalidStateFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSInvalidStateFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// DMS cannot access the KMS key.
type KMSKeyNotAccessibleFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s KMSKeyNotAccessibleFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSKeyNotAccessibleFault) GoString() string {
	return s.String()
}

func newErrorKMSKeyNotAccessibleFault(v protocol.ResponseMetadata) error {
	return &KMSKeyNotAccessibleFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSKeyNotAccessibleFault) Code() string {
	return "KMSKeyNotAccessibleFault"
}

// Message returns the exception's message.
func (s *KMSKeyNotAccessibleFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSKeyNotAccessibleFault) OrigErr() error {
	return nil
}

func (s *KMSKeyNotAccessibleFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSKeyNotAccessibleFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSKeyNotAccessibleFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified KMS entity or resource can't be found.
type KMSNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s KMSNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSNotFoundFault) GoString() string {
	return s.String()
}

func newErrorKMSNotFoundFault(v protocol.ResponseMetadata) error {
	return &KMSNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSNotFoundFault) Code() string {
	return "KMSNotFoundFault"
}

// Message returns the exception's message.
func (s *KMSNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSNotFoundFault) OrigErr() error {
	return nil
}

func (s *KMSNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// This request triggered KMS request throttling.
type KMSThrottlingFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s KMSThrottlingFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KMSThrottlingFault) GoString() string {
	return s.String()
}

func newErrorKMSThrottlingFault(v protocol.ResponseMetadata) error {
	return &KMSThrottlingFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *KMSThrottlingFault) Code() string {
	return "KMSThrottlingFault"
}

// Message returns the exception's message.
func (s *KMSThrottlingFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *KMSThrottlingFault) OrigErr() error {
	return nil
}

func (s *KMSThrottlingFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *KMSThrottlingFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *KMSThrottlingFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information that describes an Apache Kafka endpoint. This information
// includes the output format of records applied to the endpoint and details
// of transaction and control table data information.
type KafkaSettings struct {
	_ struct{} `type:"structure"`

	// A comma-separated list of one or more broker locations in your Kafka cluster
	// that host your Kafka instance. Specify each broker location in the form broker-hostname-or-ip:port
	// . For example, "ec2-12-345-678-901.compute-1.amazonaws.com:2345". For more
	// information and examples of specifying a list of broker locations, see Using
	// Apache Kafka as a target for Database Migration Service (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html)
	// in the Database Migration Service User Guide.
	Broker *string `type:"string"`

	// Shows detailed control information for table definition, column definition,
	// and table and column changes in the Kafka message output. The default is
	// false.
	IncludeControlDetails *bool `type:"boolean"`

	// Include NULL and empty columns for records migrated to the endpoint. The
	// default is false.
	IncludeNullAndEmpty *bool `type:"boolean"`

	// Shows the partition value within the Kafka message output unless the partition
	// type is schema-table-type. The default is false.
	IncludePartitionValue *bool `type:"boolean"`

	// Includes any data definition language (DDL) operations that change the table
	// in the control data, such as rename-table, drop-table, add-column, drop-column,
	// and rename-column. The default is false.
	IncludeTableAlterOperations *bool `type:"boolean"`

	// Provides detailed transaction information from the source database. This
	// information includes a commit timestamp, a log position, and values for transaction_id,
	// previous transaction_id, and transaction_record_id (the record offset within
	// a transaction). The default is false.
	IncludeTransactionDetails *bool `type:"boolean"`

	// The output format for the records created on the endpoint. The message format
	// is JSON (default) or JSON_UNFORMATTED (a single line with no tab).
	MessageFormat *string `type:"string" enum:"MessageFormatValue"`

	// The maximum size in bytes for records created on the endpoint The default
	// is 1,000,000.
	MessageMaxBytes *int64 `type:"integer"`

	// If this attribute is Y, it allows hexadecimal values that don't have the
	// 0x prefix when migrated to a Kafka target. If this attribute is N, all hexadecimal
	// values include this prefix when migrated to Kafka.
	NoHexPrefix *bool `type:"boolean"`

	// Prefixes schema and table names to partition values, when the partition type
	// is primary-key-type. Doing this increases data distribution among Kafka partitions.
	// For example, suppose that a SysBench schema has thousands of tables and each
	// table has only limited range for a primary key. In this case, the same primary
	// key is sent from thousands of tables to the same partition, which causes
	// throttling. The default is false.
	PartitionIncludeSchemaTable *bool `type:"boolean"`

	// The secure password you created when you first set up your MSK cluster to
	// validate a client identity and make an encrypted connection between server
	// and client using SASL-SSL authentication.
	SaslPassword *string `type:"string" sensitive:"true"`

	// The secure user name you created when you first set up your MSK cluster to
	// validate a client identity and make an encrypted connection between server
	// and client using SASL-SSL authentication.
	SaslUsername *string `type:"string"`

	// Set secure connection to a Kafka target endpoint using Transport Layer Security
	// (TLS). Options include ssl-encryption, ssl-authentication, and sasl-ssl.
	// sasl-ssl requires SaslUsername and SaslPassword.
	SecurityProtocol *string `type:"string" enum:"KafkaSecurityProtocol"`

	// The Amazon Resource Name (ARN) for the private Certification Authority (CA)
	// cert that DMS uses to securely connect to your Kafka target endpoint.
	SslCaCertificateArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the client certificate used to securely
	// connect to a Kafka target endpoint.
	SslClientCertificateArn *string `type:"string"`

	// The Amazon Resource Name (ARN) for the client private key used to securely
	// connect to a Kafka target endpoint.
	SslClientKeyArn *string `type:"string"`

	// The password for the client private key used to securely connect to a Kafka
	// target endpoint.
	SslClientKeyPassword *string `type:"string" sensitive:"true"`

	// The topic to which you migrate the data. If you don't specify a topic, DMS
	// specifies "kafka-default-topic" as the migration topic.
	Topic *string `type:"string"`
}

// String returns the string representation
func (s KafkaSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KafkaSettings) GoString() string {
	return s.String()
}

// SetBroker sets the Broker field's value.
func (s *KafkaSettings) SetBroker(v string) *KafkaSettings {
	s.Broker = &v
	return s
}

// SetIncludeControlDetails sets the IncludeControlDetails field's value.
func (s *KafkaSettings) SetIncludeControlDetails(v bool) *KafkaSettings {
	s.IncludeControlDetails = &v
	return s
}

// SetIncludeNullAndEmpty sets the IncludeNullAndEmpty field's value.
func (s *KafkaSettings) SetIncludeNullAndEmpty(v bool) *KafkaSettings {
	s.IncludeNullAndEmpty = &v
	return s
}

// SetIncludePartitionValue sets the IncludePartitionValue field's value.
func (s *KafkaSettings) SetIncludePartitionValue(v bool) *KafkaSettings {
	s.IncludePartitionValue = &v
	return s
}

// SetIncludeTableAlterOperations sets the IncludeTableAlterOperations field's value.
func (s *KafkaSettings) SetIncludeTableAlterOperations(v bool) *KafkaSettings {
	s.IncludeTableAlterOperations = &v
	return s
}

// SetIncludeTransactionDetails sets the IncludeTransactionDetails field's value.
func (s *KafkaSettings) SetIncludeTransactionDetails(v bool) *KafkaSettings {
	s.IncludeTransactionDetails = &v
	return s
}

// SetMessageFormat sets the MessageFormat field's value.
func (s *KafkaSettings) SetMessageFormat(v string) *KafkaSettings {
	s.MessageFormat = &v
	return s
}

// SetMessageMaxBytes sets the MessageMaxBytes field's value.
func (s *KafkaSettings) SetMessageMaxBytes(v int64) *KafkaSettings {
	s.MessageMaxBytes = &v
	return s
}

// SetNoHexPrefix sets the NoHexPrefix field's value.
func (s *KafkaSettings) SetNoHexPrefix(v bool) *KafkaSettings {
	s.NoHexPrefix = &v
	return s
}

// SetPartitionIncludeSchemaTable sets the PartitionIncludeSchemaTable field's value.
func (s *KafkaSettings) SetPartitionIncludeSchemaTable(v bool) *KafkaSettings {
	s.PartitionIncludeSchemaTable = &v
	return s
}

// SetSaslPassword sets the SaslPassword field's value.
func (s *KafkaSettings) SetSaslPassword(v string) *KafkaSettings {
	s.SaslPassword = &v
	return s
}

// SetSaslUsername sets the SaslUsername field's value.
func (s *KafkaSettings) SetSaslUsername(v string) *KafkaSettings {
	s.SaslUsername = &v
	return s
}

// SetSecurityProtocol sets the SecurityProtocol field's value.
func (s *KafkaSettings) SetSecurityProtocol(v string) *KafkaSettings {
	s.SecurityProtocol = &v
	return s
}

// SetSslCaCertificateArn sets the SslCaCertificateArn field's value.
func (s *KafkaSettings) SetSslCaCertificateArn(v string) *KafkaSettings {
	s.SslCaCertificateArn = &v
	return s
}

// SetSslClientCertificateArn sets the SslClientCertificateArn field's value.
func (s *KafkaSettings) SetSslClientCertificateArn(v string) *KafkaSettings {
	s.SslClientCertificateArn = &v
	return s
}

// SetSslClientKeyArn sets the SslClientKeyArn field's value.
func (s *KafkaSettings) SetSslClientKeyArn(v string) *KafkaSettings {
	s.SslClientKeyArn = &v
	return s
}

// SetSslClientKeyPassword sets the SslClientKeyPassword field's value.
func (s *KafkaSettings) SetSslClientKeyPassword(v string) *KafkaSettings {
	s.SslClientKeyPassword = &v
	return s
}

// SetTopic sets the Topic field's value.
func (s *KafkaSettings) SetTopic(v string) *KafkaSettings {
	s.Topic = &v
	return s
}

// Provides information that describes an Amazon Kinesis Data Stream endpoint.
// This information includes the output format of records applied to the endpoint
// and details of transaction and control table data information.
type KinesisSettings struct {
	_ struct{} `type:"structure"`

	// Shows detailed control information for table definition, column definition,
	// and table and column changes in the Kinesis message output. The default is
	// false.
	IncludeControlDetails *bool `type:"boolean"`

	// Include NULL and empty columns for records migrated to the endpoint. The
	// default is false.
	IncludeNullAndEmpty *bool `type:"boolean"`

	// Shows the partition value within the Kinesis message output, unless the partition
	// type is schema-table-type. The default is false.
	IncludePartitionValue *bool `type:"boolean"`

	// Includes any data definition language (DDL) operations that change the table
	// in the control data, such as rename-table, drop-table, add-column, drop-column,
	// and rename-column. The default is false.
	IncludeTableAlterOperations *bool `type:"boolean"`

	// Provides detailed transaction information from the source database. This
	// information includes a commit timestamp, a log position, and values for transaction_id,
	// previous transaction_id, and transaction_record_id (the record offset within
	// a transaction). The default is false.
	IncludeTransactionDetails *bool `type:"boolean"`

	// The output format for the records created on the endpoint. The message format
	// is JSON (default) or JSON_UNFORMATTED (a single line with no tab).
	MessageFormat *string `type:"string" enum:"MessageFormatValue"`

	// If this attribute is Y, it allows hexadecimal values that don't have the
	// 0x prefix when migrated to a Kinesis target. If this attribute is N, all
	// hexadecimal values include this prefix when migrated to Kinesis.
	NoHexPrefix *bool `type:"boolean"`

	// Prefixes schema and table names to partition values, when the partition type
	// is primary-key-type. Doing this increases data distribution among Kinesis
	// shards. For example, suppose that a SysBench schema has thousands of tables
	// and each table has only limited range for a primary key. In this case, the
	// same primary key is sent from thousands of tables to the same shard, which
	// causes throttling. The default is false.
	PartitionIncludeSchemaTable *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) for the IAM role that DMS uses to write to
	// the Kinesis data stream. The role must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`

	// The Amazon Resource Name (ARN) for the Amazon Kinesis Data Streams endpoint.
	StreamArn *string `type:"string"`
}

// String returns the string representation
func (s KinesisSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KinesisSettings) GoString() string {
	return s.String()
}

// SetIncludeControlDetails sets the IncludeControlDetails field's value.
func (s *KinesisSettings) SetIncludeControlDetails(v bool) *KinesisSettings {
	s.IncludeControlDetails = &v
	return s
}

// SetIncludeNullAndEmpty sets the IncludeNullAndEmpty field's value.
func (s *KinesisSettings) SetIncludeNullAndEmpty(v bool) *KinesisSettings {
	s.IncludeNullAndEmpty = &v
	return s
}

// SetIncludePartitionValue sets the IncludePartitionValue field's value.
func (s *KinesisSettings) SetIncludePartitionValue(v bool) *KinesisSettings {
	s.IncludePartitionValue = &v
	return s
}

// SetIncludeTableAlterOperations sets the IncludeTableAlterOperations field's value.
func (s *KinesisSettings) SetIncludeTableAlterOperations(v bool) *KinesisSettings {
	s.IncludeTableAlterOperations = &v
	return s
}

// SetIncludeTransactionDetails sets the IncludeTransactionDetails field's value.
func (s *KinesisSettings) SetIncludeTransactionDetails(v bool) *KinesisSettings {
	s.IncludeTransactionDetails = &v
	return s
}

// SetMessageFormat sets the MessageFormat field's value.
func (s *KinesisSettings) SetMessageFormat(v string) *KinesisSettings {
	s.MessageFormat = &v
	return s
}

// SetNoHexPrefix sets the NoHexPrefix field's value.
func (s *KinesisSettings) SetNoHexPrefix(v bool) *KinesisSettings {
	s.NoHexPrefix = &v
	return s
}

// SetPartitionIncludeSchemaTable sets the PartitionIncludeSchemaTable field's value.
func (s *KinesisSettings) SetPartitionIncludeSchemaTable(v bool) *KinesisSettings {
	s.PartitionIncludeSchemaTable = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *KinesisSettings) SetServiceAccessRoleArn(v string) *KinesisSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetStreamArn sets the StreamArn field's value.
func (s *KinesisSettings) SetStreamArn(v string) *KinesisSettings {
	s.StreamArn = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the DMS resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tags for the resource.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsForResourceOutput) SetTagList(v []*Tag) *ListTagsForResourceOutput {
	s.TagList = v
	return s
}

// Provides information that defines a Microsoft SQL Server endpoint.
type MicrosoftSQLServerSettings struct {
	_ struct{} `type:"structure"`

	// The maximum size of the packets (in bytes) used to transfer data using BCP.
	BcpPacketSize *int64 `type:"integer"`

	// Specifies a file group for the DMS internal tables. When the replication
	// task starts, all the internal DMS control tables (awsdms_ apply_exception,
	// awsdms_apply, awsdms_changes) are created for the specified file group.
	ControlTablesFileGroup *string `type:"string"`

	// Database name for the endpoint.
	DatabaseName *string `type:"string"`

	// Endpoint connection password.
	Password *string `type:"string" sensitive:"true"`

	// Endpoint TCP port.
	Port *int64 `type:"integer"`

	// Cleans and recreates table metadata information on the replication instance
	// when a mismatch occurs. An example is a situation where running an alter
	// DDL statement on a table might result in different information about the
	// table cached in the replication instance.
	QuerySingleAlwaysOnNode *bool `type:"boolean"`

	// When this attribute is set to Y, DMS only reads changes from transaction
	// log backups and doesn't read from the active transaction log file during
	// ongoing replication. Setting this parameter to Y enables you to control active
	// transaction log file growth during full load and ongoing replication tasks.
	// However, it can add some source latency to ongoing replication.
	ReadBackupOnly *bool `type:"boolean"`

	// Use this attribute to minimize the need to access the backup log and enable
	// DMS to prevent truncation using one of the following two methods.
	//
	// Start transactions in the database: This is the default method. When this
	// method is used, DMS prevents TLOG truncation by mimicking a transaction in
	// the database. As long as such a transaction is open, changes that appear
	// after the transaction started aren't truncated. If you need Microsoft Replication
	// to be enabled in your database, then you must choose this method.
	//
	// Exclusively use sp_repldone within a single task: When this method is used,
	// DMS reads the changes and then uses sp_repldone to mark the TLOG transactions
	// as ready for truncation. Although this method doesn't involve any transactional
	// activities, it can only be used when Microsoft Replication isn't running.
	// Also, when using this method, only one DMS task can access the database at
	// any given time. Therefore, if you need to run parallel DMS tasks against
	// the same database, use the default method.
	SafeguardPolicy *string `type:"string" enum:"SafeguardPolicy"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the SQL Server endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the SQL Server endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// Fully qualified domain name of the endpoint.
	ServerName *string `type:"string"`

	// Use this to attribute to transfer data for full-load operations using BCP.
	// When the target table contains an identity column that does not exist in
	// the source table, you must disable the use BCP for loading table option.
	UseBcpFullLoad *bool `type:"boolean"`

	// When this attribute is set to Y, DMS processes third-party transaction log
	// backups if they are created in native format.
	UseThirdPartyBackupDevice *bool `type:"boolean"`

	// Endpoint connection user name.
	Username *string `type:"string"`
}

// String returns the string representation
func (s MicrosoftSQLServerSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MicrosoftSQLServerSettings) GoString() string {
	return s.String()
}

// SetBcpPacketSize sets the BcpPacketSize field's value.
func (s *MicrosoftSQLServerSettings) SetBcpPacketSize(v int64) *MicrosoftSQLServerSettings {
	s.BcpPacketSize = &v
	return s
}

// SetControlTablesFileGroup sets the ControlTablesFileGroup field's value.
func (s *MicrosoftSQLServerSettings) SetControlTablesFileGroup(v string) *MicrosoftSQLServerSettings {
	s.ControlTablesFileGroup = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *MicrosoftSQLServerSettings) SetDatabaseName(v string) *MicrosoftSQLServerSettings {
	s.DatabaseName = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *MicrosoftSQLServerSettings) SetPassword(v string) *MicrosoftSQLServerSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *MicrosoftSQLServerSettings) SetPort(v int64) *MicrosoftSQLServerSettings {
	s.Port = &v
	return s
}

// SetQuerySingleAlwaysOnNode sets the QuerySingleAlwaysOnNode field's value.
func (s *MicrosoftSQLServerSettings) SetQuerySingleAlwaysOnNode(v bool) *MicrosoftSQLServerSettings {
	s.QuerySingleAlwaysOnNode = &v
	return s
}

// SetReadBackupOnly sets the ReadBackupOnly field's value.
func (s *MicrosoftSQLServerSettings) SetReadBackupOnly(v bool) *MicrosoftSQLServerSettings {
	s.ReadBackupOnly = &v
	return s
}

// SetSafeguardPolicy sets the SafeguardPolicy field's value.
func (s *MicrosoftSQLServerSettings) SetSafeguardPolicy(v string) *MicrosoftSQLServerSettings {
	s.SafeguardPolicy = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *MicrosoftSQLServerSettings) SetSecretsManagerAccessRoleArn(v string) *MicrosoftSQLServerSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *MicrosoftSQLServerSettings) SetSecretsManagerSecretId(v string) *MicrosoftSQLServerSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *MicrosoftSQLServerSettings) SetServerName(v string) *MicrosoftSQLServerSettings {
	s.ServerName = &v
	return s
}

// SetUseBcpFullLoad sets the UseBcpFullLoad field's value.
func (s *MicrosoftSQLServerSettings) SetUseBcpFullLoad(v bool) *MicrosoftSQLServerSettings {
	s.UseBcpFullLoad = &v
	return s
}

// SetUseThirdPartyBackupDevice sets the UseThirdPartyBackupDevice field's value.
func (s *MicrosoftSQLServerSettings) SetUseThirdPartyBackupDevice(v bool) *MicrosoftSQLServerSettings {
	s.UseThirdPartyBackupDevice = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *MicrosoftSQLServerSettings) SetUsername(v string) *MicrosoftSQLServerSettings {
	s.Username = &v
	return s
}

type ModifyEndpointInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the certificate used for SSL connection.
	CertificateArn *string `type:"string"`

	// The name of the endpoint database. For a MySQL source or target endpoint,
	// do not specify DatabaseName.
	DatabaseName *string `type:"string"`

	// The settings in JSON format for the DMS transfer type of source endpoint.
	//
	// Attributes include the following:
	//
	//    * serviceAccessRoleArn - The Identity and Access Management (IAM) role
	//    that has permission to access the Amazon S3 bucket. The role must allow
	//    the iam:PassRole action.
	//
	//    * BucketName - The name of the S3 bucket to use.
	//
	// Shorthand syntax for these settings is as follows: ServiceAccessRoleArn=string
	// ,BucketName=string
	//
	// JSON syntax for these settings is as follows: { "ServiceAccessRoleArn": "string",
	// "BucketName": "string"}
	DmsTransferSettings *DmsTransferSettings `type:"structure"`

	// Settings in JSON format for the source DocumentDB endpoint. For more information
	// about the available settings, see the configuration properties section in
	// Using DocumentDB as a Target for Database Migration Service (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DocumentDB.html)
	// in the Database Migration Service User Guide.
	DocDbSettings *DocDbSettings `type:"structure"`

	// Settings in JSON format for the target Amazon DynamoDB endpoint. For information
	// about other available settings, see Using Object Mapping to Migrate Data
	// to DynamoDB (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.DynamoDB.html#CHAP_Target.DynamoDB.ObjectMapping)
	// in the Database Migration Service User Guide.
	DynamoDbSettings *DynamoDbSettings `type:"structure"`

	// Settings in JSON format for the target Elasticsearch endpoint. For more information
	// about the available settings, see Extra Connection Attributes When Using
	// Elasticsearch as a Target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Elasticsearch.html#CHAP_Target.Elasticsearch.Configuration)
	// in the Database Migration Service User Guide.
	ElasticsearchSettings *ElasticsearchSettings `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The database endpoint identifier. Identifiers must begin with a letter and
	// must contain only ASCII letters, digits, and hyphens. They can't end with
	// a hyphen or contain two consecutive hyphens.
	EndpointIdentifier *string `type:"string"`

	// The type of endpoint. Valid values are source and target.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The type of engine for the endpoint. Valid values, depending on the EndpointType,
	// include "mysql", "oracle", "postgres", "mariadb", "aurora", "aurora-postgresql",
	// "redshift", "s3", "db2", "azuredb", "sybase", "dynamodb", "mongodb", "kinesis",
	// "kafka", "elasticsearch", "documentdb", "sqlserver", and "neptune".
	EngineName *string `type:"string"`

	// If this attribute is Y, the current call to ModifyEndpoint replaces all existing
	// endpoint settings with the exact settings that you specify in this call.
	// If this attribute is N, the current call to ModifyEndpoint does two things:
	//
	//    * It replaces any endpoint settings that already exist with new values,
	//    for settings with the same names.
	//
	//    * It creates new endpoint settings that you specify in the call, for settings
	//    with different names.
	//
	// For example, if you call create-endpoint ... --endpoint-settings '{"a":1}'
	// ..., the endpoint has the following endpoint settings: '{"a":1}'. If you
	// then call modify-endpoint ... --endpoint-settings '{"b":2}' ... for the same
	// endpoint, the endpoint has the following settings: '{"a":1,"b":2}'.
	//
	// However, suppose that you follow this with a call to modify-endpoint ...
	// --endpoint-settings '{"b":2}' --exact-settings ... for that same endpoint
	// again. Then the endpoint has the following settings: '{"b":2}'. All existing
	// settings are replaced with the exact settings that you specify.
	ExactSettings *bool `type:"boolean"`

	// The external table definition.
	ExternalTableDefinition *string `type:"string"`

	// Additional attributes associated with the connection. To reset this parameter,
	// pass the empty string ("") as an argument.
	ExtraConnectionAttributes *string `type:"string"`

	// Settings in JSON format for the source IBM Db2 LUW endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// Db2 LUW as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.DB2.html#CHAP_Source.DB2.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	IBMDb2Settings *IBMDb2Settings `type:"structure"`

	// Settings in JSON format for the target Apache Kafka endpoint. For more information
	// about the available settings, see Using object mapping to migrate data to
	// a Kafka topic (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kafka.html#CHAP_Target.Kafka.ObjectMapping)
	// in the Database Migration Service User Guide.
	KafkaSettings *KafkaSettings `type:"structure"`

	// Settings in JSON format for the target endpoint for Amazon Kinesis Data Streams.
	// For more information about the available settings, see Using object mapping
	// to migrate data to a Kinesis data stream (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Kinesis.html#CHAP_Target.Kinesis.ObjectMapping)
	// in the Database Migration Service User Guide.
	KinesisSettings *KinesisSettings `type:"structure"`

	// Settings in JSON format for the source and target Microsoft SQL Server endpoint.
	// For information about other available settings, see Extra connection attributes
	// when using SQL Server as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SQLServer.html#CHAP_Source.SQLServer.ConnectionAttrib)
	// and Extra connection attributes when using SQL Server as a target for DMS
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SQLServer.html#CHAP_Target.SQLServer.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	MicrosoftSQLServerSettings *MicrosoftSQLServerSettings `type:"structure"`

	// Settings in JSON format for the source MongoDB endpoint. For more information
	// about the available settings, see the configuration properties section in
	// Endpoint configuration settings when using MongoDB as a source for Database
	// Migration Service (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MongoDB.html#CHAP_Source.MongoDB.Configuration)
	// in the Database Migration Service User Guide.
	MongoDbSettings *MongoDbSettings `type:"structure"`

	// Settings in JSON format for the source and target MySQL endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// MySQL as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.MySQL.html#CHAP_Source.MySQL.ConnectionAttrib)
	// and Extra connection attributes when using a MySQL-compatible database as
	// a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.MySQL.html#CHAP_Target.MySQL.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	MySQLSettings *MySQLSettings `type:"structure"`

	// Settings in JSON format for the target Amazon Neptune endpoint. For more
	// information about the available settings, see Specifying graph-mapping rules
	// using Gremlin and R2RML for Amazon Neptune as a target (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.EndpointSettings)
	// in the Database Migration Service User Guide.
	NeptuneSettings *NeptuneSettings `type:"structure"`

	// Settings in JSON format for the source and target Oracle endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// Oracle as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.ConnectionAttrib)
	// and Extra connection attributes when using Oracle as a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Oracle.html#CHAP_Target.Oracle.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	OracleSettings *OracleSettings `type:"structure"`

	// The password to be used to login to the endpoint database.
	Password *string `type:"string" sensitive:"true"`

	// The port used by the endpoint database.
	Port *int64 `type:"integer"`

	// Settings in JSON format for the source and target PostgreSQL endpoint. For
	// information about other available settings, see Extra connection attributes
	// when using PostgreSQL as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib)
	// and Extra connection attributes when using PostgreSQL as a target for DMS
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.PostgreSQL.html#CHAP_Target.PostgreSQL.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	PostgreSQLSettings *PostgreSQLSettings `type:"structure"`

	// Provides information that defines an Amazon Redshift endpoint.
	RedshiftSettings *RedshiftSettings `type:"structure"`

	// Settings in JSON format for the target Amazon S3 endpoint. For more information
	// about the available settings, see Extra Connection Attributes When Using
	// Amazon S3 as a Target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring)
	// in the Database Migration Service User Guide.
	S3Settings *S3Settings `type:"structure"`

	// The name of the server where the endpoint database resides.
	ServerName *string `type:"string"`

	// The Amazon Resource Name (ARN) for the IAM role you want to use to modify
	// the endpoint. The role must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`

	// The SSL mode used to connect to the endpoint. The default value is none.
	SslMode *string `type:"string" enum:"DmsSslModeValue"`

	// Settings in JSON format for the source and target SAP ASE endpoint. For information
	// about other available settings, see Extra connection attributes when using
	// SAP ASE as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.SAP.html#CHAP_Source.SAP.ConnectionAttrib)
	// and Extra connection attributes when using SAP ASE as a target for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.SAP.html#CHAP_Target.SAP.ConnectionAttrib)
	// in the Database Migration Service User Guide.
	SybaseSettings *SybaseSettings `type:"structure"`

	// The user name to be used to login to the endpoint database.
	Username *string `type:"string"`
}

// String returns the string representation
func (s ModifyEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyEndpointInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.DynamoDbSettings != nil {
		if err := s.DynamoDbSettings.Validate(); err != nil {
			invalidParams.AddNested("DynamoDbSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.ElasticsearchSettings != nil {
		if err := s.ElasticsearchSettings.Validate(); err != nil {
			invalidParams.AddNested("ElasticsearchSettings", err.(request.ErrInvalidParams))
		}
	}
	if s.NeptuneSettings != nil {
		if err := s.NeptuneSettings.Validate(); err != nil {
			invalidParams.AddNested("NeptuneSettings", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *ModifyEndpointInput) SetCertificateArn(v string) *ModifyEndpointInput {
	s.CertificateArn = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *ModifyEndpointInput) SetDatabaseName(v string) *ModifyEndpointInput {
	s.DatabaseName = &v
	return s
}

// SetDmsTransferSettings sets the DmsTransferSettings field's value.
func (s *ModifyEndpointInput) SetDmsTransferSettings(v *DmsTransferSettings) *ModifyEndpointInput {
	s.DmsTransferSettings = v
	return s
}

// SetDocDbSettings sets the DocDbSettings field's value.
func (s *ModifyEndpointInput) SetDocDbSettings(v *DocDbSettings) *ModifyEndpointInput {
	s.DocDbSettings = v
	return s
}

// SetDynamoDbSettings sets the DynamoDbSettings field's value.
func (s *ModifyEndpointInput) SetDynamoDbSettings(v *DynamoDbSettings) *ModifyEndpointInput {
	s.DynamoDbSettings = v
	return s
}

// SetElasticsearchSettings sets the ElasticsearchSettings field's value.
func (s *ModifyEndpointInput) SetElasticsearchSettings(v *ElasticsearchSettings) *ModifyEndpointInput {
	s.ElasticsearchSettings = v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *ModifyEndpointInput) SetEndpointArn(v string) *ModifyEndpointInput {
	s.EndpointArn = &v
	return s
}

// SetEndpointIdentifier sets the EndpointIdentifier field's value.
func (s *ModifyEndpointInput) SetEndpointIdentifier(v string) *ModifyEndpointInput {
	s.EndpointIdentifier = &v
	return s
}

// SetEndpointType sets the EndpointType field's value.
func (s *ModifyEndpointInput) SetEndpointType(v string) *ModifyEndpointInput {
	s.EndpointType = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *ModifyEndpointInput) SetEngineName(v string) *ModifyEndpointInput {
	s.EngineName = &v
	return s
}

// SetExactSettings sets the ExactSettings field's value.
func (s *ModifyEndpointInput) SetExactSettings(v bool) *ModifyEndpointInput {
	s.ExactSettings = &v
	return s
}

// SetExternalTableDefinition sets the ExternalTableDefinition field's value.
func (s *ModifyEndpointInput) SetExternalTableDefinition(v string) *ModifyEndpointInput {
	s.ExternalTableDefinition = &v
	return s
}

// SetExtraConnectionAttributes sets the ExtraConnectionAttributes field's value.
func (s *ModifyEndpointInput) SetExtraConnectionAttributes(v string) *ModifyEndpointInput {
	s.ExtraConnectionAttributes = &v
	return s
}

// SetIBMDb2Settings sets the IBMDb2Settings field's value.
func (s *ModifyEndpointInput) SetIBMDb2Settings(v *IBMDb2Settings) *ModifyEndpointInput {
	s.IBMDb2Settings = v
	return s
}

// SetKafkaSettings sets the KafkaSettings field's value.
func (s *ModifyEndpointInput) SetKafkaSettings(v *KafkaSettings) *ModifyEndpointInput {
	s.KafkaSettings = v
	return s
}

// SetKinesisSettings sets the KinesisSettings field's value.
func (s *ModifyEndpointInput) SetKinesisSettings(v *KinesisSettings) *ModifyEndpointInput {
	s.KinesisSettings = v
	return s
}

// SetMicrosoftSQLServerSettings sets the MicrosoftSQLServerSettings field's value.
func (s *ModifyEndpointInput) SetMicrosoftSQLServerSettings(v *MicrosoftSQLServerSettings) *ModifyEndpointInput {
	s.MicrosoftSQLServerSettings = v
	return s
}

// SetMongoDbSettings sets the MongoDbSettings field's value.
func (s *ModifyEndpointInput) SetMongoDbSettings(v *MongoDbSettings) *ModifyEndpointInput {
	s.MongoDbSettings = v
	return s
}

// SetMySQLSettings sets the MySQLSettings field's value.
func (s *ModifyEndpointInput) SetMySQLSettings(v *MySQLSettings) *ModifyEndpointInput {
	s.MySQLSettings = v
	return s
}

// SetNeptuneSettings sets the NeptuneSettings field's value.
func (s *ModifyEndpointInput) SetNeptuneSettings(v *NeptuneSettings) *ModifyEndpointInput {
	s.NeptuneSettings = v
	return s
}

// SetOracleSettings sets the OracleSettings field's value.
func (s *ModifyEndpointInput) SetOracleSettings(v *OracleSettings) *ModifyEndpointInput {
	s.OracleSettings = v
	return s
}

// SetPassword sets the Password field's value.
func (s *ModifyEndpointInput) SetPassword(v string) *ModifyEndpointInput {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ModifyEndpointInput) SetPort(v int64) *ModifyEndpointInput {
	s.Port = &v
	return s
}

// SetPostgreSQLSettings sets the PostgreSQLSettings field's value.
func (s *ModifyEndpointInput) SetPostgreSQLSettings(v *PostgreSQLSettings) *ModifyEndpointInput {
	s.PostgreSQLSettings = v
	return s
}

// SetRedshiftSettings sets the RedshiftSettings field's value.
func (s *ModifyEndpointInput) SetRedshiftSettings(v *RedshiftSettings) *ModifyEndpointInput {
	s.RedshiftSettings = v
	return s
}

// SetS3Settings sets the S3Settings field's value.
func (s *ModifyEndpointInput) SetS3Settings(v *S3Settings) *ModifyEndpointInput {
	s.S3Settings = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *ModifyEndpointInput) SetServerName(v string) *ModifyEndpointInput {
	s.ServerName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *ModifyEndpointInput) SetServiceAccessRoleArn(v string) *ModifyEndpointInput {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetSslMode sets the SslMode field's value.
func (s *ModifyEndpointInput) SetSslMode(v string) *ModifyEndpointInput {
	s.SslMode = &v
	return s
}

// SetSybaseSettings sets the SybaseSettings field's value.
func (s *ModifyEndpointInput) SetSybaseSettings(v *SybaseSettings) *ModifyEndpointInput {
	s.SybaseSettings = v
	return s
}

// SetUsername sets the Username field's value.
func (s *ModifyEndpointInput) SetUsername(v string) *ModifyEndpointInput {
	s.Username = &v
	return s
}

type ModifyEndpointOutput struct {
	_ struct{} `type:"structure"`

	// The modified endpoint.
	Endpoint *Endpoint `type:"structure"`
}

// String returns the string representation
func (s ModifyEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEndpointOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *ModifyEndpointOutput) SetEndpoint(v *Endpoint) *ModifyEndpointOutput {
	s.Endpoint = v
	return s
}

type ModifyEventSubscriptionInput struct {
	_ struct{} `type:"structure"`

	// A Boolean value; set to true to activate the subscription.
	Enabled *bool `type:"boolean"`

	// A list of event categories for a source type that you want to subscribe to.
	// Use the DescribeEventCategories action to see a list of event categories.
	EventCategories []*string `type:"list"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic created for event
	// notification. The ARN is created by Amazon SNS when you create a topic and
	// subscribe to it.
	SnsTopicArn *string `type:"string"`

	// The type of DMS resource that generates the events you want to subscribe
	// to.
	//
	// Valid values: replication-instance | replication-task
	SourceType *string `type:"string"`

	// The name of the DMS event notification subscription to be modified.
	//
	// SubscriptionName is a required field
	SubscriptionName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyEventSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyEventSubscriptionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyEventSubscriptionInput"}
	if s.SubscriptionName == nil {
		invalidParams.Add(request.NewErrParamRequired("SubscriptionName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *ModifyEventSubscriptionInput) SetEnabled(v bool) *ModifyEventSubscriptionInput {
	s.Enabled = &v
	return s
}

// SetEventCategories sets the EventCategories field's value.
func (s *ModifyEventSubscriptionInput) SetEventCategories(v []*string) *ModifyEventSubscriptionInput {
	s.EventCategories = v
	return s
}

// SetSnsTopicArn sets the SnsTopicArn field's value.
func (s *ModifyEventSubscriptionInput) SetSnsTopicArn(v string) *ModifyEventSubscriptionInput {
	s.SnsTopicArn = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *ModifyEventSubscriptionInput) SetSourceType(v string) *ModifyEventSubscriptionInput {
	s.SourceType = &v
	return s
}

// SetSubscriptionName sets the SubscriptionName field's value.
func (s *ModifyEventSubscriptionInput) SetSubscriptionName(v string) *ModifyEventSubscriptionInput {
	s.SubscriptionName = &v
	return s
}

type ModifyEventSubscriptionOutput struct {
	_ struct{} `type:"structure"`

	// The modified event subscription.
	EventSubscription *EventSubscription `type:"structure"`
}

// String returns the string representation
func (s ModifyEventSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyEventSubscriptionOutput) GoString() string {
	return s.String()
}

// SetEventSubscription sets the EventSubscription field's value.
func (s *ModifyEventSubscriptionOutput) SetEventSubscription(v *EventSubscription) *ModifyEventSubscriptionOutput {
	s.EventSubscription = v
	return s
}

type ModifyReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) to be allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Indicates that major version upgrades are allowed. Changing this parameter
	// does not result in an outage, and the change is asynchronously applied as
	// soon as possible.
	//
	// This parameter must be set to true when specifying a value for the EngineVersion
	// parameter that is a different major version than the replication instance's
	// current version.
	AllowMajorVersionUpgrade *bool `type:"boolean"`

	// Indicates whether the changes should be applied immediately or during the
	// next maintenance window.
	ApplyImmediately *bool `type:"boolean"`

	// A value that indicates that minor version upgrades are applied automatically
	// to the replication instance during the maintenance window. Changing this
	// parameter doesn't result in an outage, except in the case described following.
	// The change is asynchronously applied as soon as possible.
	//
	// An outage does result if these factors apply:
	//
	//    * This parameter is set to true during the maintenance window.
	//
	//    * A newer minor version is available.
	//
	//    * DMS has enabled automatic patching for the given engine version.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The engine version number of the replication instance.
	//
	// When modifying a major engine version of an instance, also set AllowMajorVersionUpgrade
	// to true.
	EngineVersion *string `type:"string"`

	// Specifies whether the replication instance is a Multi-AZ deployment. You
	// can't set the AvailabilityZone parameter if the Multi-AZ parameter is set
	// to true.
	MultiAZ *bool `type:"boolean"`

	// The weekly time range (in UTC) during which system maintenance can occur,
	// which might result in an outage. Changing this parameter does not result
	// in an outage, except in the following situation, and the change is asynchronously
	// applied as soon as possible. If moving this window to the current time, there
	// must be at least 30 minutes between the current time and end of the window
	// to ensure pending changes are applied.
	//
	// Default: Uses existing setting
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// Valid Days: Mon | Tue | Wed | Thu | Fri | Sat | Sun
	//
	// Constraints: Must be at least 30 minutes
	PreferredMaintenanceWindow *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`

	// The compute and memory capacity of the replication instance as defined for
	// the specified replication instance class. For example to specify the instance
	// class dms.c4.large, set this parameter to "dms.c4.large".
	//
	// For more information on the settings and capacities for the available replication
	// instance classes, see Selecting the right DMS replication instance for your
	// migration (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth).
	ReplicationInstanceClass *string `type:"string"`

	// The replication instance identifier. This parameter is stored as a lowercase
	// string.
	ReplicationInstanceIdentifier *string `type:"string"`

	// Specifies the VPC security group to be used with the replication instance.
	// The VPC security group must work with the VPC containing the replication
	// instance.
	VpcSecurityGroupIds []*string `type:"list"`
}

// String returns the string representation
func (s ModifyReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReplicationInstanceInput"}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *ModifyReplicationInstanceInput) SetAllocatedStorage(v int64) *ModifyReplicationInstanceInput {
	s.AllocatedStorage = &v
	return s
}

// SetAllowMajorVersionUpgrade sets the AllowMajorVersionUpgrade field's value.
func (s *ModifyReplicationInstanceInput) SetAllowMajorVersionUpgrade(v bool) *ModifyReplicationInstanceInput {
	s.AllowMajorVersionUpgrade = &v
	return s
}

// SetApplyImmediately sets the ApplyImmediately field's value.
func (s *ModifyReplicationInstanceInput) SetApplyImmediately(v bool) *ModifyReplicationInstanceInput {
	s.ApplyImmediately = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *ModifyReplicationInstanceInput) SetAutoMinorVersionUpgrade(v bool) *ModifyReplicationInstanceInput {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ModifyReplicationInstanceInput) SetEngineVersion(v string) *ModifyReplicationInstanceInput {
	s.EngineVersion = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ModifyReplicationInstanceInput) SetMultiAZ(v bool) *ModifyReplicationInstanceInput {
	s.MultiAZ = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ModifyReplicationInstanceInput) SetPreferredMaintenanceWindow(v string) *ModifyReplicationInstanceInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *ModifyReplicationInstanceInput) SetReplicationInstanceArn(v string) *ModifyReplicationInstanceInput {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *ModifyReplicationInstanceInput) SetReplicationInstanceClass(v string) *ModifyReplicationInstanceInput {
	s.ReplicationInstanceClass = &v
	return s
}

// SetReplicationInstanceIdentifier sets the ReplicationInstanceIdentifier field's value.
func (s *ModifyReplicationInstanceInput) SetReplicationInstanceIdentifier(v string) *ModifyReplicationInstanceInput {
	s.ReplicationInstanceIdentifier = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *ModifyReplicationInstanceInput) SetVpcSecurityGroupIds(v []*string) *ModifyReplicationInstanceInput {
	s.VpcSecurityGroupIds = v
	return s
}

type ModifyReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The modified replication instance.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetReplicationInstance sets the ReplicationInstance field's value.
func (s *ModifyReplicationInstanceOutput) SetReplicationInstance(v *ReplicationInstance) *ModifyReplicationInstanceOutput {
	s.ReplicationInstance = v
	return s
}

type ModifyReplicationSubnetGroupInput struct {
	_ struct{} `type:"structure"`

	// A description for the replication instance subnet group.
	ReplicationSubnetGroupDescription *string `type:"string"`

	// The name of the replication instance subnet group.
	//
	// ReplicationSubnetGroupIdentifier is a required field
	ReplicationSubnetGroupIdentifier *string `type:"string" required:"true"`

	// A list of subnet IDs.
	//
	// SubnetIds is a required field
	SubnetIds []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ModifyReplicationSubnetGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationSubnetGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationSubnetGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReplicationSubnetGroupInput"}
	if s.ReplicationSubnetGroupIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationSubnetGroupIdentifier"))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationSubnetGroupDescription sets the ReplicationSubnetGroupDescription field's value.
func (s *ModifyReplicationSubnetGroupInput) SetReplicationSubnetGroupDescription(v string) *ModifyReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupDescription = &v
	return s
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *ModifyReplicationSubnetGroupInput) SetReplicationSubnetGroupIdentifier(v string) *ModifyReplicationSubnetGroupInput {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *ModifyReplicationSubnetGroupInput) SetSubnetIds(v []*string) *ModifyReplicationSubnetGroupInput {
	s.SubnetIds = v
	return s
}

type ModifyReplicationSubnetGroupOutput struct {
	_ struct{} `type:"structure"`

	// The modified replication subnet group.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationSubnetGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationSubnetGroupOutput) GoString() string {
	return s.String()
}

// SetReplicationSubnetGroup sets the ReplicationSubnetGroup field's value.
func (s *ModifyReplicationSubnetGroupOutput) SetReplicationSubnetGroup(v *ReplicationSubnetGroup) *ModifyReplicationSubnetGroupOutput {
	s.ReplicationSubnetGroup = v
	return s
}

type ModifyReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// Indicates when you want a change data capture (CDC) operation to start. Use
	// either CdcStartPosition or CdcStartTime to specify when you want a CDC operation
	// to start. Specifying both values results in an error.
	//
	// The value can be in date, checkpoint, or LSN/SCN format.
	//
	// Date Example: --cdc-start-position “2018-03-08T12:12:12”
	//
	// Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
	//
	// LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
	//
	// When you use this task setting with a source PostgreSQL database, a logical
	// replication slot should already be created and associated with the source
	// endpoint. You can verify this by setting the slotName extra connection attribute
	// to the name of this logical replication slot. For more information, see Extra
	// Connection Attributes When Using PostgreSQL as a Source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib).
	CdcStartPosition *string `type:"string"`

	// Indicates the start time for a change data capture (CDC) operation. Use either
	// CdcStartTime or CdcStartPosition to specify when you want a CDC operation
	// to start. Specifying both values results in an error.
	//
	// Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
	CdcStartTime *time.Time `type:"timestamp"`

	// Indicates when you want a change data capture (CDC) operation to stop. The
	// value can be either server time or commit time.
	//
	// Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
	//
	// Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12
	// “
	CdcStopPosition *string `type:"string"`

	// The migration type. Valid values: full-load | cdc | full-load-and-cdc
	MigrationType *string `type:"string" enum:"MigrationTypeValue"`

	// The Amazon Resource Name (ARN) of the replication task.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`

	// The replication task identifier.
	//
	// Constraints:
	//
	//    * Must contain 1-255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	ReplicationTaskIdentifier *string `type:"string"`

	// JSON file that contains settings for the task, such as task metadata settings.
	ReplicationTaskSettings *string `type:"string"`

	// When using the CLI or boto3, provide the path of the JSON file that contains
	// the table mappings. Precede the path with file://. For example, --table-mappings
	// file://mappingfile.json. When working with the DMS API, provide the JSON
	// as the parameter value.
	TableMappings *string `type:"string"`

	// Supplemental information that the task requires to migrate the data for certain
	// source and target endpoints. For more information, see Specifying Supplemental
	// Data for Task Settings (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
	// in the Database Migration Service User Guide.
	TaskData *string `type:"string"`
}

// String returns the string representation
func (s ModifyReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCdcStartPosition sets the CdcStartPosition field's value.
func (s *ModifyReplicationTaskInput) SetCdcStartPosition(v string) *ModifyReplicationTaskInput {
	s.CdcStartPosition = &v
	return s
}

// SetCdcStartTime sets the CdcStartTime field's value.
func (s *ModifyReplicationTaskInput) SetCdcStartTime(v time.Time) *ModifyReplicationTaskInput {
	s.CdcStartTime = &v
	return s
}

// SetCdcStopPosition sets the CdcStopPosition field's value.
func (s *ModifyReplicationTaskInput) SetCdcStopPosition(v string) *ModifyReplicationTaskInput {
	s.CdcStopPosition = &v
	return s
}

// SetMigrationType sets the MigrationType field's value.
func (s *ModifyReplicationTaskInput) SetMigrationType(v string) *ModifyReplicationTaskInput {
	s.MigrationType = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ModifyReplicationTaskInput) SetReplicationTaskArn(v string) *ModifyReplicationTaskInput {
	s.ReplicationTaskArn = &v
	return s
}

// SetReplicationTaskIdentifier sets the ReplicationTaskIdentifier field's value.
func (s *ModifyReplicationTaskInput) SetReplicationTaskIdentifier(v string) *ModifyReplicationTaskInput {
	s.ReplicationTaskIdentifier = &v
	return s
}

// SetReplicationTaskSettings sets the ReplicationTaskSettings field's value.
func (s *ModifyReplicationTaskInput) SetReplicationTaskSettings(v string) *ModifyReplicationTaskInput {
	s.ReplicationTaskSettings = &v
	return s
}

// SetTableMappings sets the TableMappings field's value.
func (s *ModifyReplicationTaskInput) SetTableMappings(v string) *ModifyReplicationTaskInput {
	s.TableMappings = &v
	return s
}

// SetTaskData sets the TaskData field's value.
func (s *ModifyReplicationTaskInput) SetTaskData(v string) *ModifyReplicationTaskInput {
	s.TaskData = &v
	return s
}

type ModifyReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task that was modified.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s ModifyReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *ModifyReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *ModifyReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

// Provides information that defines a MongoDB endpoint.
type MongoDbSettings struct {
	_ struct{} `type:"structure"`

	// The authentication mechanism you use to access the MongoDB source endpoint.
	//
	// For the default value, in MongoDB version 2.x, "default" is "mongodb_cr".
	// For MongoDB version 3.x or later, "default" is "scram_sha_1". This setting
	// isn't used when AuthType is set to "no".
	AuthMechanism *string `type:"string" enum:"AuthMechanismValue"`

	// The MongoDB database name. This setting isn't used when AuthType is set to
	// "no".
	//
	// The default is "admin".
	AuthSource *string `type:"string"`

	// The authentication type you use to access the MongoDB source endpoint.
	//
	// When when set to "no", user name and password parameters are not used and
	// can be empty.
	AuthType *string `type:"string" enum:"AuthTypeValue"`

	// The database name on the MongoDB source endpoint.
	DatabaseName *string `type:"string"`

	// Indicates the number of documents to preview to determine the document organization.
	// Use this setting when NestingLevel is set to "one".
	//
	// Must be a positive value greater than 0. Default value is 1000.
	DocsToInvestigate *string `type:"string"`

	// Specifies the document ID. Use this setting when NestingLevel is set to "none".
	//
	// Default value is "false".
	ExtractDocId *string `type:"string"`

	// The KMS key identifier that is used to encrypt the content on the replication
	// instance. If you don't specify a value for the KmsKeyId parameter, then DMS
	// uses your default encryption key. KMS creates the default encryption key
	// for your account. Your account has a different default encryption key for
	// each Region.
	KmsKeyId *string `type:"string"`

	// Specifies either document or table mode.
	//
	// Default value is "none". Specify "none" to use document mode. Specify "one"
	// to use table mode.
	NestingLevel *string `type:"string" enum:"NestingLevelValue"`

	// The password for the user account you use to access the MongoDB source endpoint.
	Password *string `type:"string" sensitive:"true"`

	// The port value for the MongoDB source endpoint.
	Port *int64 `type:"integer"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the MongoDB endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the MongoDB endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// The name of the server on the MongoDB source endpoint.
	ServerName *string `type:"string"`

	// The user name you use to access the MongoDB source endpoint.
	Username *string `type:"string"`
}

// String returns the string representation
func (s MongoDbSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MongoDbSettings) GoString() string {
	return s.String()
}

// SetAuthMechanism sets the AuthMechanism field's value.
func (s *MongoDbSettings) SetAuthMechanism(v string) *MongoDbSettings {
	s.AuthMechanism = &v
	return s
}

// SetAuthSource sets the AuthSource field's value.
func (s *MongoDbSettings) SetAuthSource(v string) *MongoDbSettings {
	s.AuthSource = &v
	return s
}

// SetAuthType sets the AuthType field's value.
func (s *MongoDbSettings) SetAuthType(v string) *MongoDbSettings {
	s.AuthType = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *MongoDbSettings) SetDatabaseName(v string) *MongoDbSettings {
	s.DatabaseName = &v
	return s
}

// SetDocsToInvestigate sets the DocsToInvestigate field's value.
func (s *MongoDbSettings) SetDocsToInvestigate(v string) *MongoDbSettings {
	s.DocsToInvestigate = &v
	return s
}

// SetExtractDocId sets the ExtractDocId field's value.
func (s *MongoDbSettings) SetExtractDocId(v string) *MongoDbSettings {
	s.ExtractDocId = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *MongoDbSettings) SetKmsKeyId(v string) *MongoDbSettings {
	s.KmsKeyId = &v
	return s
}

// SetNestingLevel sets the NestingLevel field's value.
func (s *MongoDbSettings) SetNestingLevel(v string) *MongoDbSettings {
	s.NestingLevel = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *MongoDbSettings) SetPassword(v string) *MongoDbSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *MongoDbSettings) SetPort(v int64) *MongoDbSettings {
	s.Port = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *MongoDbSettings) SetSecretsManagerAccessRoleArn(v string) *MongoDbSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *MongoDbSettings) SetSecretsManagerSecretId(v string) *MongoDbSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *MongoDbSettings) SetServerName(v string) *MongoDbSettings {
	s.ServerName = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *MongoDbSettings) SetUsername(v string) *MongoDbSettings {
	s.Username = &v
	return s
}

type MoveReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the task that you want to move.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`

	// The ARN of the replication instance where you want to move the task to.
	//
	// TargetReplicationInstanceArn is a required field
	TargetReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s MoveReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MoveReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MoveReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MoveReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}
	if s.TargetReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *MoveReplicationTaskInput) SetReplicationTaskArn(v string) *MoveReplicationTaskInput {
	s.ReplicationTaskArn = &v
	return s
}

// SetTargetReplicationInstanceArn sets the TargetReplicationInstanceArn field's value.
func (s *MoveReplicationTaskInput) SetTargetReplicationInstanceArn(v string) *MoveReplicationTaskInput {
	s.TargetReplicationInstanceArn = &v
	return s
}

type MoveReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task that was moved.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s MoveReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MoveReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *MoveReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *MoveReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

// Provides information that defines a MySQL endpoint.
type MySQLSettings struct {
	_ struct{} `type:"structure"`

	// Specifies a script to run immediately after DMS connects to the endpoint.
	// The migration task continues running regardless if the SQL statement succeeds
	// or fails.
	//
	// For this parameter, provide the code of the script itself, not the name of
	// a file containing the script.
	AfterConnectScript *string `type:"string"`

	// Adjusts the behavior of DMS when migrating from an SQL Server source database
	// that is hosted as part of an Always On availability group cluster. If you
	// need DMS to poll all the nodes in the Always On cluster for transaction backups,
	// set this attribute to false.
	CleanSourceMetadataOnMismatch *bool `type:"boolean"`

	// Database name for the endpoint. For a MySQL source or target endpoint, don't
	// explicitly specify the database using the DatabaseName request parameter
	// on either the CreateEndpoint or ModifyEndpoint API call. Specifying DatabaseName
	// when you create or modify a MySQL endpoint replicates all the task tables
	// to this single database. For MySQL endpoints, you specify the database only
	// when you specify the schema in the table-mapping rules of the DMS task.
	DatabaseName *string `type:"string"`

	// Specifies how often to check the binary log for new changes/events when the
	// database is idle.
	//
	// Example: eventsPollInterval=5;
	//
	// In the example, DMS checks for changes in the binary logs every five seconds.
	EventsPollInterval *int64 `type:"integer"`

	// Specifies the maximum size (in KB) of any .csv file used to transfer data
	// to a MySQL-compatible database.
	//
	// Example: maxFileSize=512
	MaxFileSize *int64 `type:"integer"`

	// Improves performance when loading data into the MySQL-compatible target database.
	// Specifies how many threads to use to load the data into the MySQL-compatible
	// target database. Setting a large number of threads can have an adverse effect
	// on database performance, because a separate connection is required for each
	// thread.
	//
	// Example: parallelLoadThreads=1
	ParallelLoadThreads *int64 `type:"integer"`

	// Endpoint connection password.
	Password *string `type:"string" sensitive:"true"`

	// Endpoint TCP port.
	Port *int64 `type:"integer"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the MySQL endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the MySQL endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// Fully qualified domain name of the endpoint.
	ServerName *string `type:"string"`

	// Specifies the time zone for the source MySQL database.
	//
	// Example: serverTimezone=US/Pacific;
	//
	// Note: Do not enclose time zones in single quotes.
	ServerTimezone *string `type:"string"`

	// Specifies where to migrate source tables on the target, either to a single
	// database or multiple databases.
	//
	// Example: targetDbType=MULTIPLE_DATABASES
	TargetDbType *string `type:"string" enum:"TargetDbType"`

	// Endpoint connection user name.
	Username *string `type:"string"`
}

// String returns the string representation
func (s MySQLSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MySQLSettings) GoString() string {
	return s.String()
}

// SetAfterConnectScript sets the AfterConnectScript field's value.
func (s *MySQLSettings) SetAfterConnectScript(v string) *MySQLSettings {
	s.AfterConnectScript = &v
	return s
}

// SetCleanSourceMetadataOnMismatch sets the CleanSourceMetadataOnMismatch field's value.
func (s *MySQLSettings) SetCleanSourceMetadataOnMismatch(v bool) *MySQLSettings {
	s.CleanSourceMetadataOnMismatch = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *MySQLSettings) SetDatabaseName(v string) *MySQLSettings {
	s.DatabaseName = &v
	return s
}

// SetEventsPollInterval sets the EventsPollInterval field's value.
func (s *MySQLSettings) SetEventsPollInterval(v int64) *MySQLSettings {
	s.EventsPollInterval = &v
	return s
}

// SetMaxFileSize sets the MaxFileSize field's value.
func (s *MySQLSettings) SetMaxFileSize(v int64) *MySQLSettings {
	s.MaxFileSize = &v
	return s
}

// SetParallelLoadThreads sets the ParallelLoadThreads field's value.
func (s *MySQLSettings) SetParallelLoadThreads(v int64) *MySQLSettings {
	s.ParallelLoadThreads = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *MySQLSettings) SetPassword(v string) *MySQLSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *MySQLSettings) SetPort(v int64) *MySQLSettings {
	s.Port = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *MySQLSettings) SetSecretsManagerAccessRoleArn(v string) *MySQLSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *MySQLSettings) SetSecretsManagerSecretId(v string) *MySQLSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *MySQLSettings) SetServerName(v string) *MySQLSettings {
	s.ServerName = &v
	return s
}

// SetServerTimezone sets the ServerTimezone field's value.
func (s *MySQLSettings) SetServerTimezone(v string) *MySQLSettings {
	s.ServerTimezone = &v
	return s
}

// SetTargetDbType sets the TargetDbType field's value.
func (s *MySQLSettings) SetTargetDbType(v string) *MySQLSettings {
	s.TargetDbType = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *MySQLSettings) SetUsername(v string) *MySQLSettings {
	s.Username = &v
	return s
}

// Provides information that defines an Amazon Neptune endpoint.
type NeptuneSettings struct {
	_ struct{} `type:"structure"`

	// The number of milliseconds for DMS to wait to retry a bulk-load of migrated
	// graph data to the Neptune target database before raising an error. The default
	// is 250.
	ErrorRetryDuration *int64 `type:"integer"`

	// If you want Identity and Access Management (IAM) authorization enabled for
	// this endpoint, set this parameter to true. Then attach the appropriate IAM
	// policy document to your service role specified by ServiceAccessRoleArn. The
	// default is false.
	IamAuthEnabled *bool `type:"boolean"`

	// The maximum size in kilobytes of migrated graph data stored in a .csv file
	// before DMS bulk-loads the data to the Neptune target database. The default
	// is 1,048,576 KB. If the bulk load is successful, DMS clears the bucket, ready
	// to store the next batch of migrated graph data.
	MaxFileSize *int64 `type:"integer"`

	// The number of times for DMS to retry a bulk load of migrated graph data to
	// the Neptune target database before raising an error. The default is 5.
	MaxRetryCount *int64 `type:"integer"`

	// A folder path where you want DMS to store migrated graph data in the S3 bucket
	// specified by S3BucketName
	//
	// S3BucketFolder is a required field
	S3BucketFolder *string `type:"string" required:"true"`

	// The name of the Amazon S3 bucket where DMS can temporarily store migrated
	// graph data in .csv files before bulk-loading it to the Neptune target database.
	// DMS maps the SQL source data to graph data before storing it in these .csv
	// files.
	//
	// S3BucketName is a required field
	S3BucketName *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the service role that you created for the
	// Neptune target endpoint. The role must allow the iam:PassRole action. For
	// more information, see Creating an IAM Service Role for Accessing Amazon Neptune
	// as a Target (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.Neptune.html#CHAP_Target.Neptune.ServiceRole)
	// in the Database Migration Service User Guide.
	ServiceAccessRoleArn *string `type:"string"`
}

// String returns the string representation
func (s NeptuneSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NeptuneSettings) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NeptuneSettings) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NeptuneSettings"}
	if s.S3BucketFolder == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketFolder"))
	}
	if s.S3BucketName == nil {
		invalidParams.Add(request.NewErrParamRequired("S3BucketName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetErrorRetryDuration sets the ErrorRetryDuration field's value.
func (s *NeptuneSettings) SetErrorRetryDuration(v int64) *NeptuneSettings {
	s.ErrorRetryDuration = &v
	return s
}

// SetIamAuthEnabled sets the IamAuthEnabled field's value.
func (s *NeptuneSettings) SetIamAuthEnabled(v bool) *NeptuneSettings {
	s.IamAuthEnabled = &v
	return s
}

// SetMaxFileSize sets the MaxFileSize field's value.
func (s *NeptuneSettings) SetMaxFileSize(v int64) *NeptuneSettings {
	s.MaxFileSize = &v
	return s
}

// SetMaxRetryCount sets the MaxRetryCount field's value.
func (s *NeptuneSettings) SetMaxRetryCount(v int64) *NeptuneSettings {
	s.MaxRetryCount = &v
	return s
}

// SetS3BucketFolder sets the S3BucketFolder field's value.
func (s *NeptuneSettings) SetS3BucketFolder(v string) *NeptuneSettings {
	s.S3BucketFolder = &v
	return s
}

// SetS3BucketName sets the S3BucketName field's value.
func (s *NeptuneSettings) SetS3BucketName(v string) *NeptuneSettings {
	s.S3BucketName = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *NeptuneSettings) SetServiceAccessRoleArn(v string) *NeptuneSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// Provides information that defines an Oracle endpoint.
type OracleSettings struct {
	_ struct{} `type:"structure"`

	// Set this attribute to false in order to use the Binary Reader to capture
	// change data for an Amazon RDS for Oracle as the source. This tells the DMS
	// instance to not access redo logs through any specified path prefix replacement
	// using direct file access.
	AccessAlternateDirectly *bool `type:"boolean"`

	// Set this attribute to set up table-level supplemental logging for the Oracle
	// database. This attribute enables PRIMARY KEY supplemental logging on all
	// tables selected for a migration task.
	//
	// If you use this option, you still need to enable database-level supplemental
	// logging.
	AddSupplementalLogging *bool `type:"boolean"`

	// Set this attribute with ArchivedLogDestId in a primary/ standby setup. This
	// attribute is useful in the case of a switchover. In this case, DMS needs
	// to know which destination to get archive redo logs from to read changes.
	// This need arises because the previous primary instance is now a standby instance
	// after switchover.
	//
	// Although DMS supports the use of the Oracle RESETLOGS option to open the
	// database, never use RESETLOGS unless necessary. For additional information
	// about RESETLOGS, see RMAN Data Repair Concepts (https://docs.oracle.com/en/database/oracle/oracle-database/19/bradv/rman-data-repair-concepts.html#GUID-1805CCF7-4AF2-482D-B65A-998192F89C2B)
	// in the Oracle Database Backup and Recovery User's Guide.
	AdditionalArchivedLogDestId *int64 `type:"integer"`

	// Set this attribute to true to enable replication of Oracle tables containing
	// columns that are nested tables or defined types.
	AllowSelectNestedTables *bool `type:"boolean"`

	// Specifies the ID of the destination for the archived redo logs. This value
	// should be the same as a number in the dest_id column of the v$archived_log
	// view. If you work with an additional redo log destination, use the AdditionalArchivedLogDestId
	// option to specify the additional destination ID. Doing this improves performance
	// by ensuring that the correct logs are accessed from the outset.
	ArchivedLogDestId *int64 `type:"integer"`

	// When this field is set to Y, DMS only accesses the archived redo logs. If
	// the archived redo logs are stored on Oracle ASM only, the DMS user account
	// needs to be granted ASM privileges.
	ArchivedLogsOnly *bool `type:"boolean"`

	// For an Oracle source endpoint, your Oracle Automatic Storage Management (ASM)
	// password. You can set this value from the asm_user_password value. You set
	// this value as part of the comma-separated value that you set to the Password
	// request parameter when you create the endpoint to access transaction logs
	// using Binary Reader. For more information, see Configuration for change data
	// capture (CDC) on an Oracle source database (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration).
	AsmPassword *string `type:"string" sensitive:"true"`

	// For an Oracle source endpoint, your ASM server address. You can set this
	// value from the asm_server value. You set asm_server as part of the extra
	// connection attribute string to access an Oracle server with Binary Reader
	// that uses ASM. For more information, see Configuration for change data capture
	// (CDC) on an Oracle source database (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration).
	AsmServer *string `type:"string"`

	// For an Oracle source endpoint, your ASM user name. You can set this value
	// from the asm_user value. You set asm_user as part of the extra connection
	// attribute string to access an Oracle server with Binary Reader that uses
	// ASM. For more information, see Configuration for change data capture (CDC)
	// on an Oracle source database (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC.Configuration).
	AsmUser *string `type:"string"`

	// Specifies whether the length of a character column is in bytes or in characters.
	// To indicate that the character column length is in characters, set this attribute
	// to CHAR. Otherwise, the character column length is in bytes.
	//
	// Example: charLengthSemantics=CHAR;
	CharLengthSemantics *string `type:"string" enum:"CharLengthSemantics"`

	// Database name for the endpoint.
	DatabaseName *string `type:"string"`

	// When set to true, this attribute helps to increase the commit rate on the
	// Oracle target database by writing directly to tables and not writing a trail
	// to database logs.
	DirectPathNoLog *bool `type:"boolean"`

	// When set to true, this attribute specifies a parallel load when useDirectPathFullLoad
	// is set to Y. This attribute also only applies when you use the DMS parallel
	// load feature. Note that the target table cannot have any constraints or indexes.
	DirectPathParallelLoad *bool `type:"boolean"`

	// Set this attribute to enable homogenous tablespace replication and create
	// existing tables or indexes under the same tablespace on the target.
	EnableHomogenousTablespace *bool `type:"boolean"`

	// When set to true, this attribute causes a task to fail if the actual size
	// of an LOB column is greater than the specified LobMaxSize.
	//
	// If a task is set to limited LOB mode and this option is set to true, the
	// task fails instead of truncating the LOB data.
	FailTasksOnLobTruncation *bool `type:"boolean"`

	// Specifies the number scale. You can select a scale up to 38, or you can select
	// FLOAT. By default, the NUMBER data type is converted to precision 38, scale
	// 10.
	//
	// Example: numberDataTypeScale=12
	NumberDatatypeScale *int64 `type:"integer"`

	// Set this string attribute to the required value in order to use the Binary
	// Reader to capture change data for an Amazon RDS for Oracle as the source.
	// This value specifies the default Oracle root used to access the redo logs.
	OraclePathPrefix *string `type:"string"`

	// Set this attribute to change the number of threads that DMS configures to
	// perform a change data capture (CDC) load using Oracle Automatic Storage Management
	// (ASM). You can specify an integer value between 2 (the default) and 8 (the
	// maximum). Use this attribute together with the readAheadBlocks attribute.
	ParallelAsmReadThreads *int64 `type:"integer"`

	// Endpoint connection password.
	Password *string `type:"string" sensitive:"true"`

	// Endpoint TCP port.
	Port *int64 `type:"integer"`

	// Set this attribute to change the number of read-ahead blocks that DMS configures
	// to perform a change data capture (CDC) load using Oracle Automatic Storage
	// Management (ASM). You can specify an integer value between 1000 (the default)
	// and 200,000 (the maximum).
	ReadAheadBlocks *int64 `type:"integer"`

	// When set to true, this attribute supports tablespace replication.
	ReadTableSpaceName *bool `type:"boolean"`

	// Set this attribute to true in order to use the Binary Reader to capture change
	// data for an Amazon RDS for Oracle as the source. This setting tells DMS instance
	// to replace the default Oracle root with the specified usePathPrefix setting
	// to access the redo logs.
	ReplacePathPrefix *bool `type:"boolean"`

	// Specifies the number of seconds that the system waits before resending a
	// query.
	//
	// Example: retryInterval=6;
	RetryInterval *int64 `type:"integer"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the Oracle endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// Required only if your Oracle endpoint uses Advanced Storage Manager (ASM).
	// The full ARN of the IAM role that specifies DMS as the trusted entity and
	// grants the required permissions to access the SecretsManagerOracleAsmSecret.
	// This SecretsManagerOracleAsmSecret has the secret value that allows access
	// to the Oracle ASM of the endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerOracleAsmSecretId.
	// Or you can specify clear-text values for AsmUserName, AsmPassword, and AsmServerName.
	// You can't specify both. For more information on creating this SecretsManagerOracleAsmSecret
	// and the SecretsManagerOracleAsmAccessRoleArn and SecretsManagerOracleAsmSecretId
	// required to access it, see Using secrets to access Database Migration Service
	// resources (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerOracleAsmAccessRoleArn *string `type:"string"`

	// Required only if your Oracle endpoint uses Advanced Storage Manager (ASM).
	// The full ARN, partial ARN, or friendly name of the SecretsManagerOracleAsmSecret
	// that contains the Oracle ASM connection details for the Oracle endpoint.
	SecretsManagerOracleAsmSecretId *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the Oracle endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// For an Oracle source endpoint, the transparent data encryption (TDE) password
	// required by AWM DMS to access Oracle redo logs encrypted by TDE using Binary
	// Reader. It is also the TDE_Password part of the comma-separated value you
	// set to the Password request parameter when you create the endpoint. The SecurityDbEncryptian
	// setting is related to this SecurityDbEncryptionName setting. For more information,
	// see Supported encryption methods for using Oracle as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption)
	// in the Database Migration Service User Guide.
	SecurityDbEncryption *string `type:"string" sensitive:"true"`

	// For an Oracle source endpoint, the name of a key used for the transparent
	// data encryption (TDE) of the columns and tablespaces in an Oracle source
	// database that is encrypted using TDE. The key value is the value of the SecurityDbEncryption
	// setting. For more information on setting the key name value of SecurityDbEncryptionName,
	// see the information and example for setting the securityDbEncryptionName
	// extra connection attribute in Supported encryption methods for using Oracle
	// as a source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.Encryption)
	// in the Database Migration Service User Guide.
	SecurityDbEncryptionName *string `type:"string"`

	// Fully qualified domain name of the endpoint.
	ServerName *string `type:"string"`

	// Use this attribute to convert SDO_GEOMETRY to GEOJSON format. By default,
	// DMS calls the SDO2GEOJSON custom function if present and accessible. Or you
	// can create your own custom function that mimics the operation of SDOGEOJSON
	// and set SpatialDataOptionToGeoJsonFunctionName to call it instead.
	SpatialDataOptionToGeoJsonFunctionName *string `type:"string"`

	// Use this attribute to specify a time in minutes for the delay in standby
	// sync. If the source is an Oracle Active Data Guard standby database, use
	// this attribute to specify the time lag between primary and standby databases.
	//
	// In DMS, you can create an Oracle CDC task that uses an Active Data Guard
	// standby instance as a source for replicating ongoing changes. Doing this
	// eliminates the need to connect to an active database that might be in production.
	StandbyDelayTime *int64 `type:"integer"`

	// Set this attribute to true in order to use the Binary Reader to capture change
	// data for an Amazon RDS for Oracle as the source. This tells the DMS instance
	// to use any specified prefix replacement to access all online redo logs.
	UseAlternateFolderForOnline *bool `type:"boolean"`

	// Set this attribute to Y to capture change data using the Binary Reader utility.
	// Set UseLogminerReader to N to set this attribute to Y. To use Binary Reader
	// with Amazon RDS for Oracle as the source, you set additional attributes.
	// For more information about using this setting with Oracle Automatic Storage
	// Management (ASM), see Using Oracle LogMiner or DMS Binary Reader for CDC
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC).
	UseBFile *bool `type:"boolean"`

	// Set this attribute to Y to have DMS use a direct path full load. Specify
	// this value to use the direct path protocol in the Oracle Call Interface (OCI).
	// By using this OCI protocol, you can bulk-load Oracle target tables during
	// a full load.
	UseDirectPathFullLoad *bool `type:"boolean"`

	// Set this attribute to Y to capture change data using the Oracle LogMiner
	// utility (the default). Set this attribute to N if you want to access the
	// redo logs as a binary file. When you set UseLogminerReader to N, also set
	// UseBfile to Y. For more information on this setting and using Oracle ASM,
	// see Using Oracle LogMiner or DMS Binary Reader for CDC (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.Oracle.html#CHAP_Source.Oracle.CDC)
	// in the DMS User Guide.
	UseLogminerReader *bool `type:"boolean"`

	// Set this string attribute to the required value in order to use the Binary
	// Reader to capture change data for an Amazon RDS for Oracle as the source.
	// This value specifies the path prefix used to replace the default Oracle root
	// to access the redo logs.
	UsePathPrefix *string `type:"string"`

	// Endpoint connection user name.
	Username *string `type:"string"`
}

// String returns the string representation
func (s OracleSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OracleSettings) GoString() string {
	return s.String()
}

// SetAccessAlternateDirectly sets the AccessAlternateDirectly field's value.
func (s *OracleSettings) SetAccessAlternateDirectly(v bool) *OracleSettings {
	s.AccessAlternateDirectly = &v
	return s
}

// SetAddSupplementalLogging sets the AddSupplementalLogging field's value.
func (s *OracleSettings) SetAddSupplementalLogging(v bool) *OracleSettings {
	s.AddSupplementalLogging = &v
	return s
}

// SetAdditionalArchivedLogDestId sets the AdditionalArchivedLogDestId field's value.
func (s *OracleSettings) SetAdditionalArchivedLogDestId(v int64) *OracleSettings {
	s.AdditionalArchivedLogDestId = &v
	return s
}

// SetAllowSelectNestedTables sets the AllowSelectNestedTables field's value.
func (s *OracleSettings) SetAllowSelectNestedTables(v bool) *OracleSettings {
	s.AllowSelectNestedTables = &v
	return s
}

// SetArchivedLogDestId sets the ArchivedLogDestId field's value.
func (s *OracleSettings) SetArchivedLogDestId(v int64) *OracleSettings {
	s.ArchivedLogDestId = &v
	return s
}

// SetArchivedLogsOnly sets the ArchivedLogsOnly field's value.
func (s *OracleSettings) SetArchivedLogsOnly(v bool) *OracleSettings {
	s.ArchivedLogsOnly = &v
	return s
}

// SetAsmPassword sets the AsmPassword field's value.
func (s *OracleSettings) SetAsmPassword(v string) *OracleSettings {
	s.AsmPassword = &v
	return s
}

// SetAsmServer sets the AsmServer field's value.
func (s *OracleSettings) SetAsmServer(v string) *OracleSettings {
	s.AsmServer = &v
	return s
}

// SetAsmUser sets the AsmUser field's value.
func (s *OracleSettings) SetAsmUser(v string) *OracleSettings {
	s.AsmUser = &v
	return s
}

// SetCharLengthSemantics sets the CharLengthSemantics field's value.
func (s *OracleSettings) SetCharLengthSemantics(v string) *OracleSettings {
	s.CharLengthSemantics = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *OracleSettings) SetDatabaseName(v string) *OracleSettings {
	s.DatabaseName = &v
	return s
}

// SetDirectPathNoLog sets the DirectPathNoLog field's value.
func (s *OracleSettings) SetDirectPathNoLog(v bool) *OracleSettings {
	s.DirectPathNoLog = &v
	return s
}

// SetDirectPathParallelLoad sets the DirectPathParallelLoad field's value.
func (s *OracleSettings) SetDirectPathParallelLoad(v bool) *OracleSettings {
	s.DirectPathParallelLoad = &v
	return s
}

// SetEnableHomogenousTablespace sets the EnableHomogenousTablespace field's value.
func (s *OracleSettings) SetEnableHomogenousTablespace(v bool) *OracleSettings {
	s.EnableHomogenousTablespace = &v
	return s
}

// SetFailTasksOnLobTruncation sets the FailTasksOnLobTruncation field's value.
func (s *OracleSettings) SetFailTasksOnLobTruncation(v bool) *OracleSettings {
	s.FailTasksOnLobTruncation = &v
	return s
}

// SetNumberDatatypeScale sets the NumberDatatypeScale field's value.
func (s *OracleSettings) SetNumberDatatypeScale(v int64) *OracleSettings {
	s.NumberDatatypeScale = &v
	return s
}

// SetOraclePathPrefix sets the OraclePathPrefix field's value.
func (s *OracleSettings) SetOraclePathPrefix(v string) *OracleSettings {
	s.OraclePathPrefix = &v
	return s
}

// SetParallelAsmReadThreads sets the ParallelAsmReadThreads field's value.
func (s *OracleSettings) SetParallelAsmReadThreads(v int64) *OracleSettings {
	s.ParallelAsmReadThreads = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *OracleSettings) SetPassword(v string) *OracleSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *OracleSettings) SetPort(v int64) *OracleSettings {
	s.Port = &v
	return s
}

// SetReadAheadBlocks sets the ReadAheadBlocks field's value.
func (s *OracleSettings) SetReadAheadBlocks(v int64) *OracleSettings {
	s.ReadAheadBlocks = &v
	return s
}

// SetReadTableSpaceName sets the ReadTableSpaceName field's value.
func (s *OracleSettings) SetReadTableSpaceName(v bool) *OracleSettings {
	s.ReadTableSpaceName = &v
	return s
}

// SetReplacePathPrefix sets the ReplacePathPrefix field's value.
func (s *OracleSettings) SetReplacePathPrefix(v bool) *OracleSettings {
	s.ReplacePathPrefix = &v
	return s
}

// SetRetryInterval sets the RetryInterval field's value.
func (s *OracleSettings) SetRetryInterval(v int64) *OracleSettings {
	s.RetryInterval = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *OracleSettings) SetSecretsManagerAccessRoleArn(v string) *OracleSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerOracleAsmAccessRoleArn sets the SecretsManagerOracleAsmAccessRoleArn field's value.
func (s *OracleSettings) SetSecretsManagerOracleAsmAccessRoleArn(v string) *OracleSettings {
	s.SecretsManagerOracleAsmAccessRoleArn = &v
	return s
}

// SetSecretsManagerOracleAsmSecretId sets the SecretsManagerOracleAsmSecretId field's value.
func (s *OracleSettings) SetSecretsManagerOracleAsmSecretId(v string) *OracleSettings {
	s.SecretsManagerOracleAsmSecretId = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *OracleSettings) SetSecretsManagerSecretId(v string) *OracleSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetSecurityDbEncryption sets the SecurityDbEncryption field's value.
func (s *OracleSettings) SetSecurityDbEncryption(v string) *OracleSettings {
	s.SecurityDbEncryption = &v
	return s
}

// SetSecurityDbEncryptionName sets the SecurityDbEncryptionName field's value.
func (s *OracleSettings) SetSecurityDbEncryptionName(v string) *OracleSettings {
	s.SecurityDbEncryptionName = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *OracleSettings) SetServerName(v string) *OracleSettings {
	s.ServerName = &v
	return s
}

// SetSpatialDataOptionToGeoJsonFunctionName sets the SpatialDataOptionToGeoJsonFunctionName field's value.
func (s *OracleSettings) SetSpatialDataOptionToGeoJsonFunctionName(v string) *OracleSettings {
	s.SpatialDataOptionToGeoJsonFunctionName = &v
	return s
}

// SetStandbyDelayTime sets the StandbyDelayTime field's value.
func (s *OracleSettings) SetStandbyDelayTime(v int64) *OracleSettings {
	s.StandbyDelayTime = &v
	return s
}

// SetUseAlternateFolderForOnline sets the UseAlternateFolderForOnline field's value.
func (s *OracleSettings) SetUseAlternateFolderForOnline(v bool) *OracleSettings {
	s.UseAlternateFolderForOnline = &v
	return s
}

// SetUseBFile sets the UseBFile field's value.
func (s *OracleSettings) SetUseBFile(v bool) *OracleSettings {
	s.UseBFile = &v
	return s
}

// SetUseDirectPathFullLoad sets the UseDirectPathFullLoad field's value.
func (s *OracleSettings) SetUseDirectPathFullLoad(v bool) *OracleSettings {
	s.UseDirectPathFullLoad = &v
	return s
}

// SetUseLogminerReader sets the UseLogminerReader field's value.
func (s *OracleSettings) SetUseLogminerReader(v bool) *OracleSettings {
	s.UseLogminerReader = &v
	return s
}

// SetUsePathPrefix sets the UsePathPrefix field's value.
func (s *OracleSettings) SetUsePathPrefix(v string) *OracleSettings {
	s.UsePathPrefix = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *OracleSettings) SetUsername(v string) *OracleSettings {
	s.Username = &v
	return s
}

// In response to the DescribeOrderableReplicationInstances operation, this
// object describes an available replication instance. This description includes
// the replication instance's type, engine version, and allocated storage.
type OrderableReplicationInstance struct {
	_ struct{} `type:"structure"`

	// List of Availability Zones for this replication instance.
	AvailabilityZones []*string `type:"list"`

	// The default amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	DefaultAllocatedStorage *int64 `type:"integer"`

	// The version of the replication engine.
	EngineVersion *string `type:"string"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	IncludedAllocatedStorage *int64 `type:"integer"`

	// The minimum amount of storage (in gigabytes) that can be allocated for the
	// replication instance.
	MaxAllocatedStorage *int64 `type:"integer"`

	// The minimum amount of storage (in gigabytes) that can be allocated for the
	// replication instance.
	MinAllocatedStorage *int64 `type:"integer"`

	// The value returned when the specified EngineVersion of the replication instance
	// is in Beta or test mode. This indicates some features might not work as expected.
	//
	// DMS supports the ReleaseStatus parameter in versions 3.1.4 and later.
	ReleaseStatus *string `type:"string" enum:"ReleaseStatusValues"`

	// The compute and memory capacity of the replication instance as defined for
	// the specified replication instance class. For example to specify the instance
	// class dms.c4.large, set this parameter to "dms.c4.large".
	//
	// For more information on the settings and capacities for the available replication
	// instance classes, see Selecting the right DMS replication instance for your
	// migration (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth).
	ReplicationInstanceClass *string `type:"string"`

	// The type of storage used by the replication instance.
	StorageType *string `type:"string"`
}

// String returns the string representation
func (s OrderableReplicationInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OrderableReplicationInstance) GoString() string {
	return s.String()
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *OrderableReplicationInstance) SetAvailabilityZones(v []*string) *OrderableReplicationInstance {
	s.AvailabilityZones = v
	return s
}

// SetDefaultAllocatedStorage sets the DefaultAllocatedStorage field's value.
func (s *OrderableReplicationInstance) SetDefaultAllocatedStorage(v int64) *OrderableReplicationInstance {
	s.DefaultAllocatedStorage = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *OrderableReplicationInstance) SetEngineVersion(v string) *OrderableReplicationInstance {
	s.EngineVersion = &v
	return s
}

// SetIncludedAllocatedStorage sets the IncludedAllocatedStorage field's value.
func (s *OrderableReplicationInstance) SetIncludedAllocatedStorage(v int64) *OrderableReplicationInstance {
	s.IncludedAllocatedStorage = &v
	return s
}

// SetMaxAllocatedStorage sets the MaxAllocatedStorage field's value.
func (s *OrderableReplicationInstance) SetMaxAllocatedStorage(v int64) *OrderableReplicationInstance {
	s.MaxAllocatedStorage = &v
	return s
}

// SetMinAllocatedStorage sets the MinAllocatedStorage field's value.
func (s *OrderableReplicationInstance) SetMinAllocatedStorage(v int64) *OrderableReplicationInstance {
	s.MinAllocatedStorage = &v
	return s
}

// SetReleaseStatus sets the ReleaseStatus field's value.
func (s *OrderableReplicationInstance) SetReleaseStatus(v string) *OrderableReplicationInstance {
	s.ReleaseStatus = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *OrderableReplicationInstance) SetReplicationInstanceClass(v string) *OrderableReplicationInstance {
	s.ReplicationInstanceClass = &v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *OrderableReplicationInstance) SetStorageType(v string) *OrderableReplicationInstance {
	s.StorageType = &v
	return s
}

// Describes a maintenance action pending for an DMS resource, including when
// and how it will be applied. This data type is a response element to the DescribePendingMaintenanceActions
// operation.
type PendingMaintenanceAction struct {
	_ struct{} `type:"structure"`

	// The type of pending maintenance action that is available for the resource.
	Action *string `type:"string"`

	// The date of the maintenance window when the action is to be applied. The
	// maintenance action is applied to the resource during its first maintenance
	// window after this date. If this date is specified, any next-maintenance opt-in
	// requests are ignored.
	AutoAppliedAfterDate *time.Time `type:"timestamp"`

	// The effective date when the pending maintenance action will be applied to
	// the resource. This date takes into account opt-in requests received from
	// the ApplyPendingMaintenanceAction API operation, and also the AutoAppliedAfterDate
	// and ForcedApplyDate parameter values. This value is blank if an opt-in request
	// has not been received and nothing has been specified for AutoAppliedAfterDate
	// or ForcedApplyDate.
	CurrentApplyDate *time.Time `type:"timestamp"`

	// A description providing more detail about the maintenance action.
	Description *string `type:"string"`

	// The date when the maintenance action will be automatically applied. The maintenance
	// action is applied to the resource on this date regardless of the maintenance
	// window for the resource. If this date is specified, any immediate opt-in
	// requests are ignored.
	ForcedApplyDate *time.Time `type:"timestamp"`

	// The type of opt-in request that has been received for the resource.
	OptInStatus *string `type:"string"`
}

// String returns the string representation
func (s PendingMaintenanceAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PendingMaintenanceAction) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *PendingMaintenanceAction) SetAction(v string) *PendingMaintenanceAction {
	s.Action = &v
	return s
}

// SetAutoAppliedAfterDate sets the AutoAppliedAfterDate field's value.
func (s *PendingMaintenanceAction) SetAutoAppliedAfterDate(v time.Time) *PendingMaintenanceAction {
	s.AutoAppliedAfterDate = &v
	return s
}

// SetCurrentApplyDate sets the CurrentApplyDate field's value.
func (s *PendingMaintenanceAction) SetCurrentApplyDate(v time.Time) *PendingMaintenanceAction {
	s.CurrentApplyDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PendingMaintenanceAction) SetDescription(v string) *PendingMaintenanceAction {
	s.Description = &v
	return s
}

// SetForcedApplyDate sets the ForcedApplyDate field's value.
func (s *PendingMaintenanceAction) SetForcedApplyDate(v time.Time) *PendingMaintenanceAction {
	s.ForcedApplyDate = &v
	return s
}

// SetOptInStatus sets the OptInStatus field's value.
func (s *PendingMaintenanceAction) SetOptInStatus(v string) *PendingMaintenanceAction {
	s.OptInStatus = &v
	return s
}

// Provides information that defines a PostgreSQL endpoint.
type PostgreSQLSettings struct {
	_ struct{} `type:"structure"`

	// For use with change data capture (CDC) only, this attribute has DMS bypass
	// foreign keys and user triggers to reduce the time it takes to bulk load data.
	//
	// Example: afterConnectScript=SET session_replication_role='replica'
	AfterConnectScript *string `type:"string"`

	// To capture DDL events, DMS creates various artifacts in the PostgreSQL database
	// when the task starts. You can later remove these artifacts.
	//
	// If this value is set to N, you don't have to create tables or triggers on
	// the source database.
	CaptureDdls *bool `type:"boolean"`

	// Database name for the endpoint.
	DatabaseName *string `type:"string"`

	// The schema in which the operational DDL database artifacts are created.
	//
	// Example: ddlArtifactsSchema=xyzddlschema;
	DdlArtifactsSchema *string `type:"string"`

	// Sets the client statement timeout for the PostgreSQL instance, in seconds.
	// The default value is 60 seconds.
	//
	// Example: executeTimeout=100;
	ExecuteTimeout *int64 `type:"integer"`

	// When set to true, this value causes a task to fail if the actual size of
	// a LOB column is greater than the specified LobMaxSize.
	//
	// If task is set to Limited LOB mode and this option is set to true, the task
	// fails instead of truncating the LOB data.
	FailTasksOnLobTruncation *bool `type:"boolean"`

	// If this attribute is set to true, the write-ahead log (WAL) heartbeat keeps
	// restart_lsn moving and prevents storage full scenarios. The WAL heartbeat
	// mimics a dummy transaction, so that idle logical replication slots don't
	// hold onto old WAL logs that result in storage full situations on the source.
	HeartbeatEnable *bool `type:"boolean"`

	// Sets the WAL heartbeat frequency (in minutes).
	HeartbeatFrequency *int64 `type:"integer"`

	// Sets the schema in which the heartbeat artifacts are created.
	HeartbeatSchema *string `type:"string"`

	// Specifies the maximum size (in KB) of any .csv file used to transfer data
	// to PostgreSQL.
	//
	// Example: maxFileSize=512
	MaxFileSize *int64 `type:"integer"`

	// Endpoint connection password.
	Password *string `type:"string" sensitive:"true"`

	// Specifies the plugin to use to create a replication slot.
	PluginName *string `type:"string" enum:"PluginNameValue"`

	// Endpoint TCP port.
	Port *int64 `type:"integer"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the PostgreSQL endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the PostgreSQL endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// Fully qualified domain name of the endpoint.
	ServerName *string `type:"string"`

	// Sets the name of a previously created logical replication slot for a CDC
	// load of the PostgreSQL source instance.
	//
	// When used with the DMS API CdcStartPosition request parameter, this attribute
	// also enables using native CDC start points.
	SlotName *string `type:"string"`

	// Endpoint connection user name.
	Username *string `type:"string"`
}

// String returns the string representation
func (s PostgreSQLSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PostgreSQLSettings) GoString() string {
	return s.String()
}

// SetAfterConnectScript sets the AfterConnectScript field's value.
func (s *PostgreSQLSettings) SetAfterConnectScript(v string) *PostgreSQLSettings {
	s.AfterConnectScript = &v
	return s
}

// SetCaptureDdls sets the CaptureDdls field's value.
func (s *PostgreSQLSettings) SetCaptureDdls(v bool) *PostgreSQLSettings {
	s.CaptureDdls = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *PostgreSQLSettings) SetDatabaseName(v string) *PostgreSQLSettings {
	s.DatabaseName = &v
	return s
}

// SetDdlArtifactsSchema sets the DdlArtifactsSchema field's value.
func (s *PostgreSQLSettings) SetDdlArtifactsSchema(v string) *PostgreSQLSettings {
	s.DdlArtifactsSchema = &v
	return s
}

// SetExecuteTimeout sets the ExecuteTimeout field's value.
func (s *PostgreSQLSettings) SetExecuteTimeout(v int64) *PostgreSQLSettings {
	s.ExecuteTimeout = &v
	return s
}

// SetFailTasksOnLobTruncation sets the FailTasksOnLobTruncation field's value.
func (s *PostgreSQLSettings) SetFailTasksOnLobTruncation(v bool) *PostgreSQLSettings {
	s.FailTasksOnLobTruncation = &v
	return s
}

// SetHeartbeatEnable sets the HeartbeatEnable field's value.
func (s *PostgreSQLSettings) SetHeartbeatEnable(v bool) *PostgreSQLSettings {
	s.HeartbeatEnable = &v
	return s
}

// SetHeartbeatFrequency sets the HeartbeatFrequency field's value.
func (s *PostgreSQLSettings) SetHeartbeatFrequency(v int64) *PostgreSQLSettings {
	s.HeartbeatFrequency = &v
	return s
}

// SetHeartbeatSchema sets the HeartbeatSchema field's value.
func (s *PostgreSQLSettings) SetHeartbeatSchema(v string) *PostgreSQLSettings {
	s.HeartbeatSchema = &v
	return s
}

// SetMaxFileSize sets the MaxFileSize field's value.
func (s *PostgreSQLSettings) SetMaxFileSize(v int64) *PostgreSQLSettings {
	s.MaxFileSize = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *PostgreSQLSettings) SetPassword(v string) *PostgreSQLSettings {
	s.Password = &v
	return s
}

// SetPluginName sets the PluginName field's value.
func (s *PostgreSQLSettings) SetPluginName(v string) *PostgreSQLSettings {
	s.PluginName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *PostgreSQLSettings) SetPort(v int64) *PostgreSQLSettings {
	s.Port = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *PostgreSQLSettings) SetSecretsManagerAccessRoleArn(v string) *PostgreSQLSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *PostgreSQLSettings) SetSecretsManagerSecretId(v string) *PostgreSQLSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *PostgreSQLSettings) SetServerName(v string) *PostgreSQLSettings {
	s.ServerName = &v
	return s
}

// SetSlotName sets the SlotName field's value.
func (s *PostgreSQLSettings) SetSlotName(v string) *PostgreSQLSettings {
	s.SlotName = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *PostgreSQLSettings) SetUsername(v string) *PostgreSQLSettings {
	s.Username = &v
	return s
}

type RebootReplicationInstanceInput struct {
	_ struct{} `type:"structure"`

	// If this parameter is true, the reboot is conducted through a Multi-AZ failover.
	// (If the instance isn't configured for Multi-AZ, then you can't specify true.)
	ForceFailover *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RebootReplicationInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootReplicationInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootReplicationInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootReplicationInstanceInput"}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetForceFailover sets the ForceFailover field's value.
func (s *RebootReplicationInstanceInput) SetForceFailover(v bool) *RebootReplicationInstanceInput {
	s.ForceFailover = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *RebootReplicationInstanceInput) SetReplicationInstanceArn(v string) *RebootReplicationInstanceInput {
	s.ReplicationInstanceArn = &v
	return s
}

type RebootReplicationInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The replication instance that is being rebooted.
	ReplicationInstance *ReplicationInstance `type:"structure"`
}

// String returns the string representation
func (s RebootReplicationInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RebootReplicationInstanceOutput) GoString() string {
	return s.String()
}

// SetReplicationInstance sets the ReplicationInstance field's value.
func (s *RebootReplicationInstanceOutput) SetReplicationInstance(v *ReplicationInstance) *RebootReplicationInstanceOutput {
	s.ReplicationInstance = v
	return s
}

// Provides information that defines an Amazon Redshift endpoint.
type RedshiftSettings struct {
	_ struct{} `type:"structure"`

	// A value that indicates to allow any date format, including invalid formats
	// such as 00/00/00 00:00:00, to be loaded without generating an error. You
	// can choose true or false (the default).
	//
	// This parameter applies only to TIMESTAMP and DATE columns. Always use ACCEPTANYDATE
	// with the DATEFORMAT parameter. If the date format for the data doesn't match
	// the DATEFORMAT specification, Amazon Redshift inserts a NULL value into that
	// field.
	AcceptAnyDate *bool `type:"boolean"`

	// Code to run after connecting. This parameter should contain the code itself,
	// not the name of a file containing the code.
	AfterConnectScript *string `type:"string"`

	// An S3 folder where the comma-separated-value (.csv) files are stored before
	// being uploaded to the target Redshift cluster.
	//
	// For full load mode, DMS converts source records into .csv files and loads
	// them to the BucketFolder/TableID path. DMS uses the Redshift COPY command
	// to upload the .csv files to the target table. The files are deleted once
	// the COPY operation has finished. For more information, see COPY (https://docs.aws.amazon.com/redshift/latest/dg/r_COPY.html)
	// in the Amazon Redshift Database Developer Guide.
	//
	// For change-data-capture (CDC) mode, DMS creates a NetChanges table, and loads
	// the .csv files to this BucketFolder/NetChangesTableID path.
	BucketFolder *string `type:"string"`

	// The name of the intermediate S3 bucket used to store .csv files before uploading
	// data to Redshift.
	BucketName *string `type:"string"`

	// If Amazon Redshift is configured to support case sensitive schema names,
	// set CaseSensitiveNames to true. The default is false.
	CaseSensitiveNames *bool `type:"boolean"`

	// If you set CompUpdate to true Amazon Redshift applies automatic compression
	// if the table is empty. This applies even if the table columns already have
	// encodings other than RAW. If you set CompUpdate to false, automatic compression
	// is disabled and existing column encodings aren't changed. The default is
	// true.
	CompUpdate *bool `type:"boolean"`

	// A value that sets the amount of time to wait (in milliseconds) before timing
	// out, beginning from when you initially establish a connection.
	ConnectionTimeout *int64 `type:"integer"`

	// The name of the Amazon Redshift data warehouse (service) that you are working
	// with.
	DatabaseName *string `type:"string"`

	// The date format that you are using. Valid values are auto (case-sensitive),
	// your date format string enclosed in quotes, or NULL. If this parameter is
	// left unset (NULL), it defaults to a format of 'YYYY-MM-DD'. Using auto recognizes
	// most strings, even some that aren't supported when you use a date format
	// string.
	//
	// If your date and time values use formats different from each other, set this
	// to auto.
	DateFormat *string `type:"string"`

	// A value that specifies whether DMS should migrate empty CHAR and VARCHAR
	// fields as NULL. A value of true sets empty CHAR and VARCHAR fields to null.
	// The default is false.
	EmptyAsNull *bool `type:"boolean"`

	// The type of server-side encryption that you want to use for your data. This
	// encryption type is part of the endpoint settings or the extra connections
	// attributes for Amazon S3. You can choose either SSE_S3 (the default) or SSE_KMS.
	//
	// For the ModifyEndpoint operation, you can change the existing value of the
	// EncryptionMode parameter from SSE_KMS to SSE_S3. But you can’t change the
	// existing value from SSE_S3 to SSE_KMS.
	//
	// To use SSE_S3, create an Identity and Access Management (IAM) role with a
	// policy that allows "arn:aws:s3:::*" to use the following actions: "s3:PutObject",
	// "s3:ListBucket"
	EncryptionMode *string `type:"string" enum:"EncryptionModeValue"`

	// This setting is only valid for a full-load migration task. Set ExplicitIds
	// to true to have tables with IDENTITY columns override their auto-generated
	// values with explicit values loaded from the source data files used to populate
	// the tables. The default is false.
	ExplicitIds *bool `type:"boolean"`

	// The number of threads used to upload a single file. This parameter accepts
	// a value from 1 through 64. It defaults to 10.
	//
	// The number of parallel streams used to upload a single .csv file to an S3
	// bucket using S3 Multipart Upload. For more information, see Multipart upload
	// overview (https://docs.aws.amazon.com/AmazonS3/latest/dev/mpuoverview.html).
	//
	// FileTransferUploadStreams accepts a value from 1 through 64. It defaults
	// to 10.
	FileTransferUploadStreams *int64 `type:"integer"`

	// The amount of time to wait (in milliseconds) before timing out of operations
	// performed by DMS on a Redshift cluster, such as Redshift COPY, INSERT, DELETE,
	// and UPDATE.
	LoadTimeout *int64 `type:"integer"`

	// The maximum size (in KB) of any .csv file used to load data on an S3 bucket
	// and transfer data to Amazon Redshift. It defaults to 1048576KB (1 GB).
	MaxFileSize *int64 `type:"integer"`

	// The password for the user named in the username property.
	Password *string `type:"string" sensitive:"true"`

	// The port number for Amazon Redshift. The default value is 5439.
	Port *int64 `type:"integer"`

	// A value that specifies to remove surrounding quotation marks from strings
	// in the incoming data. All characters within the quotation marks, including
	// delimiters, are retained. Choose true to remove quotation marks. The default
	// is false.
	RemoveQuotes *bool `type:"boolean"`

	// A value that specifies to replaces the invalid characters specified in ReplaceInvalidChars,
	// substituting the specified characters instead. The default is "?".
	ReplaceChars *string `type:"string"`

	// A list of characters that you want to replace. Use with ReplaceChars.
	ReplaceInvalidChars *string `type:"string"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the Amazon Redshift endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the Amazon Redshift endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// The name of the Amazon Redshift cluster you are using.
	ServerName *string `type:"string"`

	// The KMS key ID. If you are using SSE_KMS for the EncryptionMode, provide
	// this key ID. The key that you use needs an attached policy that enables IAM
	// user permissions and allows use of the key.
	ServerSideEncryptionKmsKeyId *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role that has access to the Amazon
	// Redshift service. The role must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`

	// The time format that you want to use. Valid values are auto (case-sensitive),
	// 'timeformat_string', 'epochsecs', or 'epochmillisecs'. It defaults to 10.
	// Using auto recognizes most strings, even some that aren't supported when
	// you use a time format string.
	//
	// If your date and time values use formats different from each other, set this
	// parameter to auto.
	TimeFormat *string `type:"string"`

	// A value that specifies to remove the trailing white space characters from
	// a VARCHAR string. This parameter applies only to columns with a VARCHAR data
	// type. Choose true to remove unneeded white space. The default is false.
	TrimBlanks *bool `type:"boolean"`

	// A value that specifies to truncate data in columns to the appropriate number
	// of characters, so that the data fits in the column. This parameter applies
	// only to columns with a VARCHAR or CHAR data type, and rows with a size of
	// 4 MB or less. Choose true to truncate data. The default is false.
	TruncateColumns *bool `type:"boolean"`

	// An Amazon Redshift user name for a registered user.
	Username *string `type:"string"`

	// The size (in KB) of the in-memory file write buffer used when generating
	// .csv files on the local disk at the DMS replication instance. The default
	// value is 1000 (buffer size is 1000KB).
	WriteBufferSize *int64 `type:"integer"`
}

// String returns the string representation
func (s RedshiftSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RedshiftSettings) GoString() string {
	return s.String()
}

// SetAcceptAnyDate sets the AcceptAnyDate field's value.
func (s *RedshiftSettings) SetAcceptAnyDate(v bool) *RedshiftSettings {
	s.AcceptAnyDate = &v
	return s
}

// SetAfterConnectScript sets the AfterConnectScript field's value.
func (s *RedshiftSettings) SetAfterConnectScript(v string) *RedshiftSettings {
	s.AfterConnectScript = &v
	return s
}

// SetBucketFolder sets the BucketFolder field's value.
func (s *RedshiftSettings) SetBucketFolder(v string) *RedshiftSettings {
	s.BucketFolder = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *RedshiftSettings) SetBucketName(v string) *RedshiftSettings {
	s.BucketName = &v
	return s
}

// SetCaseSensitiveNames sets the CaseSensitiveNames field's value.
func (s *RedshiftSettings) SetCaseSensitiveNames(v bool) *RedshiftSettings {
	s.CaseSensitiveNames = &v
	return s
}

// SetCompUpdate sets the CompUpdate field's value.
func (s *RedshiftSettings) SetCompUpdate(v bool) *RedshiftSettings {
	s.CompUpdate = &v
	return s
}

// SetConnectionTimeout sets the ConnectionTimeout field's value.
func (s *RedshiftSettings) SetConnectionTimeout(v int64) *RedshiftSettings {
	s.ConnectionTimeout = &v
	return s
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *RedshiftSettings) SetDatabaseName(v string) *RedshiftSettings {
	s.DatabaseName = &v
	return s
}

// SetDateFormat sets the DateFormat field's value.
func (s *RedshiftSettings) SetDateFormat(v string) *RedshiftSettings {
	s.DateFormat = &v
	return s
}

// SetEmptyAsNull sets the EmptyAsNull field's value.
func (s *RedshiftSettings) SetEmptyAsNull(v bool) *RedshiftSettings {
	s.EmptyAsNull = &v
	return s
}

// SetEncryptionMode sets the EncryptionMode field's value.
func (s *RedshiftSettings) SetEncryptionMode(v string) *RedshiftSettings {
	s.EncryptionMode = &v
	return s
}

// SetExplicitIds sets the ExplicitIds field's value.
func (s *RedshiftSettings) SetExplicitIds(v bool) *RedshiftSettings {
	s.ExplicitIds = &v
	return s
}

// SetFileTransferUploadStreams sets the FileTransferUploadStreams field's value.
func (s *RedshiftSettings) SetFileTransferUploadStreams(v int64) *RedshiftSettings {
	s.FileTransferUploadStreams = &v
	return s
}

// SetLoadTimeout sets the LoadTimeout field's value.
func (s *RedshiftSettings) SetLoadTimeout(v int64) *RedshiftSettings {
	s.LoadTimeout = &v
	return s
}

// SetMaxFileSize sets the MaxFileSize field's value.
func (s *RedshiftSettings) SetMaxFileSize(v int64) *RedshiftSettings {
	s.MaxFileSize = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *RedshiftSettings) SetPassword(v string) *RedshiftSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *RedshiftSettings) SetPort(v int64) *RedshiftSettings {
	s.Port = &v
	return s
}

// SetRemoveQuotes sets the RemoveQuotes field's value.
func (s *RedshiftSettings) SetRemoveQuotes(v bool) *RedshiftSettings {
	s.RemoveQuotes = &v
	return s
}

// SetReplaceChars sets the ReplaceChars field's value.
func (s *RedshiftSettings) SetReplaceChars(v string) *RedshiftSettings {
	s.ReplaceChars = &v
	return s
}

// SetReplaceInvalidChars sets the ReplaceInvalidChars field's value.
func (s *RedshiftSettings) SetReplaceInvalidChars(v string) *RedshiftSettings {
	s.ReplaceInvalidChars = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *RedshiftSettings) SetSecretsManagerAccessRoleArn(v string) *RedshiftSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *RedshiftSettings) SetSecretsManagerSecretId(v string) *RedshiftSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *RedshiftSettings) SetServerName(v string) *RedshiftSettings {
	s.ServerName = &v
	return s
}

// SetServerSideEncryptionKmsKeyId sets the ServerSideEncryptionKmsKeyId field's value.
func (s *RedshiftSettings) SetServerSideEncryptionKmsKeyId(v string) *RedshiftSettings {
	s.ServerSideEncryptionKmsKeyId = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *RedshiftSettings) SetServiceAccessRoleArn(v string) *RedshiftSettings {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetTimeFormat sets the TimeFormat field's value.
func (s *RedshiftSettings) SetTimeFormat(v string) *RedshiftSettings {
	s.TimeFormat = &v
	return s
}

// SetTrimBlanks sets the TrimBlanks field's value.
func (s *RedshiftSettings) SetTrimBlanks(v bool) *RedshiftSettings {
	s.TrimBlanks = &v
	return s
}

// SetTruncateColumns sets the TruncateColumns field's value.
func (s *RedshiftSettings) SetTruncateColumns(v bool) *RedshiftSettings {
	s.TruncateColumns = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *RedshiftSettings) SetUsername(v string) *RedshiftSettings {
	s.Username = &v
	return s
}

// SetWriteBufferSize sets the WriteBufferSize field's value.
func (s *RedshiftSettings) SetWriteBufferSize(v int64) *RedshiftSettings {
	s.WriteBufferSize = &v
	return s
}

type RefreshSchemasInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RefreshSchemasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshSchemasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RefreshSchemasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RefreshSchemasInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *RefreshSchemasInput) SetEndpointArn(v string) *RefreshSchemasInput {
	s.EndpointArn = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *RefreshSchemasInput) SetReplicationInstanceArn(v string) *RefreshSchemasInput {
	s.ReplicationInstanceArn = &v
	return s
}

type RefreshSchemasOutput struct {
	_ struct{} `type:"structure"`

	// The status of the refreshed schema.
	RefreshSchemasStatus *RefreshSchemasStatus `type:"structure"`
}

// String returns the string representation
func (s RefreshSchemasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshSchemasOutput) GoString() string {
	return s.String()
}

// SetRefreshSchemasStatus sets the RefreshSchemasStatus field's value.
func (s *RefreshSchemasOutput) SetRefreshSchemasStatus(v *RefreshSchemasStatus) *RefreshSchemasOutput {
	s.RefreshSchemasStatus = v
	return s
}

// Provides information that describes status of a schema at an endpoint specified
// by the DescribeRefreshSchemaStatus operation.
type RefreshSchemasStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	EndpointArn *string `type:"string"`

	// The last failure message for the schema.
	LastFailureMessage *string `type:"string"`

	// The date the schema was last refreshed.
	LastRefreshDate *time.Time `type:"timestamp"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The status of the schema.
	Status *string `type:"string" enum:"RefreshSchemasStatusTypeValue"`
}

// String returns the string representation
func (s RefreshSchemasStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RefreshSchemasStatus) GoString() string {
	return s.String()
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *RefreshSchemasStatus) SetEndpointArn(v string) *RefreshSchemasStatus {
	s.EndpointArn = &v
	return s
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *RefreshSchemasStatus) SetLastFailureMessage(v string) *RefreshSchemasStatus {
	s.LastFailureMessage = &v
	return s
}

// SetLastRefreshDate sets the LastRefreshDate field's value.
func (s *RefreshSchemasStatus) SetLastRefreshDate(v time.Time) *RefreshSchemasStatus {
	s.LastRefreshDate = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *RefreshSchemasStatus) SetReplicationInstanceArn(v string) *RefreshSchemasStatus {
	s.ReplicationInstanceArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RefreshSchemasStatus) SetStatus(v string) *RefreshSchemasStatus {
	s.Status = &v
	return s
}

type ReloadTablesInput struct {
	_ struct{} `type:"structure"`

	// Options for reload. Specify data-reload to reload the data and re-validate
	// it if validation is enabled. Specify validate-only to re-validate the table.
	// This option applies only when validation is enabled for the task.
	//
	// Valid values: data-reload, validate-only
	//
	// Default value is data-reload.
	ReloadOption *string `type:"string" enum:"ReloadOptionValue"`

	// The Amazon Resource Name (ARN) of the replication task.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`

	// The name and schema of the table to be reloaded.
	//
	// TablesToReload is a required field
	TablesToReload []*TableToReload `type:"list" required:"true"`
}

// String returns the string representation
func (s ReloadTablesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReloadTablesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ReloadTablesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ReloadTablesInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}
	if s.TablesToReload == nil {
		invalidParams.Add(request.NewErrParamRequired("TablesToReload"))
	}
	if s.TablesToReload != nil {
		for i, v := range s.TablesToReload {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TablesToReload", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReloadOption sets the ReloadOption field's value.
func (s *ReloadTablesInput) SetReloadOption(v string) *ReloadTablesInput {
	s.ReloadOption = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ReloadTablesInput) SetReplicationTaskArn(v string) *ReloadTablesInput {
	s.ReplicationTaskArn = &v
	return s
}

// SetTablesToReload sets the TablesToReload field's value.
func (s *ReloadTablesInput) SetTablesToReload(v []*TableToReload) *ReloadTablesInput {
	s.TablesToReload = v
	return s
}

type ReloadTablesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`
}

// String returns the string representation
func (s ReloadTablesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReloadTablesOutput) GoString() string {
	return s.String()
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ReloadTablesOutput) SetReplicationTaskArn(v string) *ReloadTablesOutput {
	s.ReplicationTaskArn = &v
	return s
}

// Removes one or more tags from an DMS resource.
type RemoveTagsFromResourceInput struct {
	_ struct{} `type:"structure"`

	// An DMS resource from which you want to remove tag(s). The value for this
	// parameter is an Amazon Resource Name (ARN).
	//
	// ResourceArn is a required field
	ResourceArn *string `type:"string" required:"true"`

	// The tag key (name) of the tag to be removed.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsFromResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsFromResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsFromResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *RemoveTagsFromResourceInput) SetResourceArn(v string) *RemoveTagsFromResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsFromResourceInput) SetTagKeys(v []*string) *RemoveTagsFromResourceInput {
	s.TagKeys = v
	return s
}

type RemoveTagsFromResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromResourceOutput) GoString() string {
	return s.String()
}

// Provides information that defines a replication instance.
type ReplicationInstance struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// Boolean value indicating if minor version upgrades will be automatically
	// applied to the instance.
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Availability Zone for the instance.
	AvailabilityZone *string `type:"string"`

	// The DNS name servers supported for the replication instance to access your
	// on-premise source or target database.
	DnsNameServers *string `type:"string"`

	// The engine version number of the replication instance.
	//
	// If an engine version number is not specified when a replication instance
	// is created, the default is the latest engine version available.
	//
	// When modifying a major engine version of an instance, also set AllowMajorVersionUpgrade
	// to true.
	EngineVersion *string `type:"string"`

	// The expiration date of the free replication instance that is part of the
	// Free DMS program.
	FreeUntil *time.Time `type:"timestamp"`

	// The time the replication instance was created.
	InstanceCreateTime *time.Time `type:"timestamp"`

	// An KMS key identifier that is used to encrypt the data on the replication
	// instance.
	//
	// If you don't specify a value for the KmsKeyId parameter, then DMS uses your
	// default encryption key.
	//
	// KMS creates the default encryption key for your account. Your account has
	// a different default encryption key for each Region.
	KmsKeyId *string `type:"string"`

	// Specifies whether the replication instance is a Multi-AZ deployment. You
	// can't set the AvailabilityZone parameter if the Multi-AZ parameter is set
	// to true.
	MultiAZ *bool `type:"boolean"`

	// The pending modification values.
	PendingModifiedValues *ReplicationPendingModifiedValues `type:"structure"`

	// The maintenance window times for the replication instance. Any pending upgrades
	// to the replication instance are performed during this time.
	PreferredMaintenanceWindow *string `type:"string"`

	// Specifies the accessibility options for the replication instance. A value
	// of true represents an instance with a public IP address. A value of false
	// represents an instance with a private IP address. The default value is true.
	PubliclyAccessible *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The compute and memory capacity of the replication instance as defined for
	// the specified replication instance class. It is a required parameter, although
	// a default value is pre-selected in the DMS console.
	//
	// For more information on the settings and capacities for the available replication
	// instance classes, see Selecting the right DMS replication instance for your
	// migration (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth).
	ReplicationInstanceClass *string `type:"string"`

	// The replication instance identifier is a required parameter. This parameter
	// is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain 1-63 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: myrepinstance
	ReplicationInstanceIdentifier *string `type:"string"`

	// The private IP address of the replication instance.
	//
	// Deprecated: ReplicationInstancePrivateIpAddress has been deprecated
	ReplicationInstancePrivateIpAddress *string `deprecated:"true" type:"string"`

	// One or more private IP addresses for the replication instance.
	ReplicationInstancePrivateIpAddresses []*string `type:"list"`

	// The public IP address of the replication instance.
	//
	// Deprecated: ReplicationInstancePublicIpAddress has been deprecated
	ReplicationInstancePublicIpAddress *string `deprecated:"true" type:"string"`

	// One or more public IP addresses for the replication instance.
	ReplicationInstancePublicIpAddresses []*string `type:"list"`

	// The status of the replication instance. The possible return values include:
	//
	//    * "available"
	//
	//    * "creating"
	//
	//    * "deleted"
	//
	//    * "deleting"
	//
	//    * "failed"
	//
	//    * "modifying"
	//
	//    * "upgrading"
	//
	//    * "rebooting"
	//
	//    * "resetting-master-credentials"
	//
	//    * "storage-full"
	//
	//    * "incompatible-credentials"
	//
	//    * "incompatible-network"
	//
	//    * "maintenance"
	ReplicationInstanceStatus *string `type:"string"`

	// The subnet group for the replication instance.
	ReplicationSubnetGroup *ReplicationSubnetGroup `type:"structure"`

	// The Availability Zone of the standby replication instance in a Multi-AZ deployment.
	SecondaryAvailabilityZone *string `type:"string"`

	// The VPC security group for the instance.
	VpcSecurityGroups []*VpcSecurityGroupMembership `type:"list"`
}

// String returns the string representation
func (s ReplicationInstance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationInstance) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *ReplicationInstance) SetAllocatedStorage(v int64) *ReplicationInstance {
	s.AllocatedStorage = &v
	return s
}

// SetAutoMinorVersionUpgrade sets the AutoMinorVersionUpgrade field's value.
func (s *ReplicationInstance) SetAutoMinorVersionUpgrade(v bool) *ReplicationInstance {
	s.AutoMinorVersionUpgrade = &v
	return s
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *ReplicationInstance) SetAvailabilityZone(v string) *ReplicationInstance {
	s.AvailabilityZone = &v
	return s
}

// SetDnsNameServers sets the DnsNameServers field's value.
func (s *ReplicationInstance) SetDnsNameServers(v string) *ReplicationInstance {
	s.DnsNameServers = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ReplicationInstance) SetEngineVersion(v string) *ReplicationInstance {
	s.EngineVersion = &v
	return s
}

// SetFreeUntil sets the FreeUntil field's value.
func (s *ReplicationInstance) SetFreeUntil(v time.Time) *ReplicationInstance {
	s.FreeUntil = &v
	return s
}

// SetInstanceCreateTime sets the InstanceCreateTime field's value.
func (s *ReplicationInstance) SetInstanceCreateTime(v time.Time) *ReplicationInstance {
	s.InstanceCreateTime = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *ReplicationInstance) SetKmsKeyId(v string) *ReplicationInstance {
	s.KmsKeyId = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ReplicationInstance) SetMultiAZ(v bool) *ReplicationInstance {
	s.MultiAZ = &v
	return s
}

// SetPendingModifiedValues sets the PendingModifiedValues field's value.
func (s *ReplicationInstance) SetPendingModifiedValues(v *ReplicationPendingModifiedValues) *ReplicationInstance {
	s.PendingModifiedValues = v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *ReplicationInstance) SetPreferredMaintenanceWindow(v string) *ReplicationInstance {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *ReplicationInstance) SetPubliclyAccessible(v bool) *ReplicationInstance {
	s.PubliclyAccessible = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *ReplicationInstance) SetReplicationInstanceArn(v string) *ReplicationInstance {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *ReplicationInstance) SetReplicationInstanceClass(v string) *ReplicationInstance {
	s.ReplicationInstanceClass = &v
	return s
}

// SetReplicationInstanceIdentifier sets the ReplicationInstanceIdentifier field's value.
func (s *ReplicationInstance) SetReplicationInstanceIdentifier(v string) *ReplicationInstance {
	s.ReplicationInstanceIdentifier = &v
	return s
}

// SetReplicationInstancePrivateIpAddress sets the ReplicationInstancePrivateIpAddress field's value.
func (s *ReplicationInstance) SetReplicationInstancePrivateIpAddress(v string) *ReplicationInstance {
	s.ReplicationInstancePrivateIpAddress = &v
	return s
}

// SetReplicationInstancePrivateIpAddresses sets the ReplicationInstancePrivateIpAddresses field's value.
func (s *ReplicationInstance) SetReplicationInstancePrivateIpAddresses(v []*string) *ReplicationInstance {
	s.ReplicationInstancePrivateIpAddresses = v
	return s
}

// SetReplicationInstancePublicIpAddress sets the ReplicationInstancePublicIpAddress field's value.
func (s *ReplicationInstance) SetReplicationInstancePublicIpAddress(v string) *ReplicationInstance {
	s.ReplicationInstancePublicIpAddress = &v
	return s
}

// SetReplicationInstancePublicIpAddresses sets the ReplicationInstancePublicIpAddresses field's value.
func (s *ReplicationInstance) SetReplicationInstancePublicIpAddresses(v []*string) *ReplicationInstance {
	s.ReplicationInstancePublicIpAddresses = v
	return s
}

// SetReplicationInstanceStatus sets the ReplicationInstanceStatus field's value.
func (s *ReplicationInstance) SetReplicationInstanceStatus(v string) *ReplicationInstance {
	s.ReplicationInstanceStatus = &v
	return s
}

// SetReplicationSubnetGroup sets the ReplicationSubnetGroup field's value.
func (s *ReplicationInstance) SetReplicationSubnetGroup(v *ReplicationSubnetGroup) *ReplicationInstance {
	s.ReplicationSubnetGroup = v
	return s
}

// SetSecondaryAvailabilityZone sets the SecondaryAvailabilityZone field's value.
func (s *ReplicationInstance) SetSecondaryAvailabilityZone(v string) *ReplicationInstance {
	s.SecondaryAvailabilityZone = &v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *ReplicationInstance) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *ReplicationInstance {
	s.VpcSecurityGroups = v
	return s
}

// Contains metadata for a replication instance task log.
type ReplicationInstanceTaskLog struct {
	_ struct{} `type:"structure"`

	// The size, in bytes, of the replication task log.
	ReplicationInstanceTaskLogSize *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The name of the replication task.
	ReplicationTaskName *string `type:"string"`
}

// String returns the string representation
func (s ReplicationInstanceTaskLog) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationInstanceTaskLog) GoString() string {
	return s.String()
}

// SetReplicationInstanceTaskLogSize sets the ReplicationInstanceTaskLogSize field's value.
func (s *ReplicationInstanceTaskLog) SetReplicationInstanceTaskLogSize(v int64) *ReplicationInstanceTaskLog {
	s.ReplicationInstanceTaskLogSize = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ReplicationInstanceTaskLog) SetReplicationTaskArn(v string) *ReplicationInstanceTaskLog {
	s.ReplicationTaskArn = &v
	return s
}

// SetReplicationTaskName sets the ReplicationTaskName field's value.
func (s *ReplicationInstanceTaskLog) SetReplicationTaskName(v string) *ReplicationInstanceTaskLog {
	s.ReplicationTaskName = &v
	return s
}

// Provides information about the values of pending modifications to a replication
// instance. This data type is an object of the ReplicationInstance (https://docs.aws.amazon.com/dms/latest/APIReference/API_ReplicationInstance.html)
// user-defined data type.
type ReplicationPendingModifiedValues struct {
	_ struct{} `type:"structure"`

	// The amount of storage (in gigabytes) that is allocated for the replication
	// instance.
	AllocatedStorage *int64 `type:"integer"`

	// The engine version number of the replication instance.
	EngineVersion *string `type:"string"`

	// Specifies whether the replication instance is a Multi-AZ deployment. You
	// can't set the AvailabilityZone parameter if the Multi-AZ parameter is set
	// to true.
	MultiAZ *bool `type:"boolean"`

	// The compute and memory capacity of the replication instance as defined for
	// the specified replication instance class.
	//
	// For more information on the settings and capacities for the available replication
	// instance classes, see Selecting the right DMS replication instance for your
	// migration (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_ReplicationInstance.html#CHAP_ReplicationInstance.InDepth).
	ReplicationInstanceClass *string `type:"string"`
}

// String returns the string representation
func (s ReplicationPendingModifiedValues) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationPendingModifiedValues) GoString() string {
	return s.String()
}

// SetAllocatedStorage sets the AllocatedStorage field's value.
func (s *ReplicationPendingModifiedValues) SetAllocatedStorage(v int64) *ReplicationPendingModifiedValues {
	s.AllocatedStorage = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *ReplicationPendingModifiedValues) SetEngineVersion(v string) *ReplicationPendingModifiedValues {
	s.EngineVersion = &v
	return s
}

// SetMultiAZ sets the MultiAZ field's value.
func (s *ReplicationPendingModifiedValues) SetMultiAZ(v bool) *ReplicationPendingModifiedValues {
	s.MultiAZ = &v
	return s
}

// SetReplicationInstanceClass sets the ReplicationInstanceClass field's value.
func (s *ReplicationPendingModifiedValues) SetReplicationInstanceClass(v string) *ReplicationPendingModifiedValues {
	s.ReplicationInstanceClass = &v
	return s
}

// Describes a subnet group in response to a request by the DescribeReplicationSubnetGroups
// operation.
type ReplicationSubnetGroup struct {
	_ struct{} `type:"structure"`

	// A description for the replication subnet group.
	ReplicationSubnetGroupDescription *string `type:"string"`

	// The identifier of the replication instance subnet group.
	ReplicationSubnetGroupIdentifier *string `type:"string"`

	// The status of the subnet group.
	SubnetGroupStatus *string `type:"string"`

	// The subnets that are in the subnet group.
	Subnets []*Subnet `type:"list"`

	// The ID of the VPC.
	VpcId *string `type:"string"`
}

// String returns the string representation
func (s ReplicationSubnetGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationSubnetGroup) GoString() string {
	return s.String()
}

// SetReplicationSubnetGroupDescription sets the ReplicationSubnetGroupDescription field's value.
func (s *ReplicationSubnetGroup) SetReplicationSubnetGroupDescription(v string) *ReplicationSubnetGroup {
	s.ReplicationSubnetGroupDescription = &v
	return s
}

// SetReplicationSubnetGroupIdentifier sets the ReplicationSubnetGroupIdentifier field's value.
func (s *ReplicationSubnetGroup) SetReplicationSubnetGroupIdentifier(v string) *ReplicationSubnetGroup {
	s.ReplicationSubnetGroupIdentifier = &v
	return s
}

// SetSubnetGroupStatus sets the SubnetGroupStatus field's value.
func (s *ReplicationSubnetGroup) SetSubnetGroupStatus(v string) *ReplicationSubnetGroup {
	s.SubnetGroupStatus = &v
	return s
}

// SetSubnets sets the Subnets field's value.
func (s *ReplicationSubnetGroup) SetSubnets(v []*Subnet) *ReplicationSubnetGroup {
	s.Subnets = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ReplicationSubnetGroup) SetVpcId(v string) *ReplicationSubnetGroup {
	s.VpcId = &v
	return s
}

// The replication subnet group does not cover enough Availability Zones (AZs).
// Edit the replication subnet group and add more AZs.
type ReplicationSubnetGroupDoesNotCoverEnoughAZs struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ReplicationSubnetGroupDoesNotCoverEnoughAZs) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationSubnetGroupDoesNotCoverEnoughAZs) GoString() string {
	return s.String()
}

func newErrorReplicationSubnetGroupDoesNotCoverEnoughAZs(v protocol.ResponseMetadata) error {
	return &ReplicationSubnetGroupDoesNotCoverEnoughAZs{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ReplicationSubnetGroupDoesNotCoverEnoughAZs) Code() string {
	return "ReplicationSubnetGroupDoesNotCoverEnoughAZs"
}

// Message returns the exception's message.
func (s *ReplicationSubnetGroupDoesNotCoverEnoughAZs) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ReplicationSubnetGroupDoesNotCoverEnoughAZs) OrigErr() error {
	return nil
}

func (s *ReplicationSubnetGroupDoesNotCoverEnoughAZs) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ReplicationSubnetGroupDoesNotCoverEnoughAZs) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ReplicationSubnetGroupDoesNotCoverEnoughAZs) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information that describes a replication task created by the CreateReplicationTask
// operation.
type ReplicationTask struct {
	_ struct{} `type:"structure"`

	// Indicates when you want a change data capture (CDC) operation to start. Use
	// either CdcStartPosition or CdcStartTime to specify when you want the CDC
	// operation to start. Specifying both values results in an error.
	//
	// The value can be in date, checkpoint, or LSN/SCN format.
	//
	// Date Example: --cdc-start-position “2018-03-08T12:12:12”
	//
	// Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
	//
	// LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
	CdcStartPosition *string `type:"string"`

	// Indicates when you want a change data capture (CDC) operation to stop. The
	// value can be either server time or commit time.
	//
	// Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
	//
	// Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12
	// “
	CdcStopPosition *string `type:"string"`

	// The last error (failure) message generated for the replication task.
	LastFailureMessage *string `type:"string"`

	// The type of migration.
	MigrationType *string `type:"string" enum:"MigrationTypeValue"`

	// Indicates the last checkpoint that occurred during a change data capture
	// (CDC) operation. You can provide this value to the CdcStartPosition parameter
	// to start a CDC operation that begins at that checkpoint.
	RecoveryCheckpoint *string `type:"string"`

	// The ARN of the replication instance.
	ReplicationInstanceArn *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The date the replication task was created.
	ReplicationTaskCreationDate *time.Time `type:"timestamp"`

	// The user-assigned replication task identifier or name.
	//
	// Constraints:
	//
	//    * Must contain 1-255 alphanumeric characters or hyphens.
	//
	//    * First character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	ReplicationTaskIdentifier *string `type:"string"`

	// The settings for the replication task.
	ReplicationTaskSettings *string `type:"string"`

	// The date the replication task is scheduled to start.
	ReplicationTaskStartDate *time.Time `type:"timestamp"`

	// The statistics for the task, including elapsed time, tables loaded, and table
	// errors.
	ReplicationTaskStats *ReplicationTaskStats `type:"structure"`

	// The Amazon Resource Name (ARN) that uniquely identifies the endpoint.
	SourceEndpointArn *string `type:"string"`

	// The status of the replication task. This response parameter can return one
	// of the following values:
	//
	//    * "moving" – The task is being moved in response to running the MoveReplicationTask
	//    (https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html)
	//    operation.
	//
	//    * "creating" – The task is being created in response to running the
	//    CreateReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_CreateReplicationTask.html)
	//    operation.
	//
	//    * "deleting" – The task is being deleted in response to running the
	//    DeleteReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html)
	//    operation.
	//
	//    * "failed" – The task failed to successfully complete the database migration
	//    in response to running the StartReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html)
	//    operation.
	//
	//    * "failed-move" – The task failed to move in response to running the
	//    MoveReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html)
	//    operation.
	//
	//    * "modifying" – The task definition is being modified in response to
	//    running the ModifyReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_ModifyReplicationTask.html)
	//    operation.
	//
	//    * "ready" – The task is in a ready state where it can respond to other
	//    task operations, such as StartReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html)
	//    or DeleteReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_DeleteReplicationTask.html).
	//
	//    * "running" – The task is performing a database migration in response
	//    to running the StartReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html)
	//    operation.
	//
	//    * "starting" – The task is preparing to perform a database migration
	//    in response to running the StartReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html)
	//    operation.
	//
	//    * "stopped" – The task has stopped in response to running the StopReplicationTask
	//    (https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html)
	//    operation.
	//
	//    * "stopping" – The task is preparing to stop in response to running
	//    the StopReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_StopReplicationTask.html)
	//    operation.
	//
	//    * "testing" – The database migration specified for this task is being
	//    tested in response to running either the StartReplicationTaskAssessmentRun
	//    (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html)
	//    or the StartReplicationTaskAssessment (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html)
	//    operation. StartReplicationTaskAssessmentRun (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html)
	//    is an improved premigration task assessment operation. The StartReplicationTaskAssessment
	//    (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessment.html)
	//    operation assesses data type compatibility only between the source and
	//    target database of a given migration task. In contrast, StartReplicationTaskAssessmentRun
	//    (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTaskAssessmentRun.html)
	//    enables you to specify a variety of premigration task assessments in addition
	//    to data type compatibility. These assessments include ones for the validity
	//    of primary key definitions and likely issues with database migration performance,
	//    among others.
	Status *string `type:"string"`

	// The reason the replication task was stopped. This response parameter can
	// return one of the following values:
	//
	//    * "STOP_REASON_FULL_LOAD_COMPLETED" – Full-load migration completed.
	//
	//    * "STOP_REASON_CACHED_CHANGES_APPLIED" – Change data capture (CDC) load
	//    completed.
	//
	//    * "STOP_REASON_CACHED_CHANGES_NOT_APPLIED" – In a full-load and CDC
	//    migration, the full load stopped as specified before starting the CDC
	//    migration.
	//
	//    * "STOP_REASON_SERVER_TIME" – The migration stopped at the specified
	//    server time.
	StopReason *string `type:"string"`

	// Table mappings specified in the task.
	TableMappings *string `type:"string"`

	// The ARN that uniquely identifies the endpoint.
	TargetEndpointArn *string `type:"string"`

	// The ARN of the replication instance to which this task is moved in response
	// to running the MoveReplicationTask (https://docs.aws.amazon.com/dms/latest/APIReference/API_MoveReplicationTask.html)
	// operation. Otherwise, this response parameter isn't a member of the ReplicationTask
	// object.
	TargetReplicationInstanceArn *string `type:"string"`

	// Supplemental information that the task requires to migrate the data for certain
	// source and target endpoints. For more information, see Specifying Supplemental
	// Data for Task Settings (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Tasks.TaskData.html)
	// in the Database Migration Service User Guide.
	TaskData *string `type:"string"`
}

// String returns the string representation
func (s ReplicationTask) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTask) GoString() string {
	return s.String()
}

// SetCdcStartPosition sets the CdcStartPosition field's value.
func (s *ReplicationTask) SetCdcStartPosition(v string) *ReplicationTask {
	s.CdcStartPosition = &v
	return s
}

// SetCdcStopPosition sets the CdcStopPosition field's value.
func (s *ReplicationTask) SetCdcStopPosition(v string) *ReplicationTask {
	s.CdcStopPosition = &v
	return s
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *ReplicationTask) SetLastFailureMessage(v string) *ReplicationTask {
	s.LastFailureMessage = &v
	return s
}

// SetMigrationType sets the MigrationType field's value.
func (s *ReplicationTask) SetMigrationType(v string) *ReplicationTask {
	s.MigrationType = &v
	return s
}

// SetRecoveryCheckpoint sets the RecoveryCheckpoint field's value.
func (s *ReplicationTask) SetRecoveryCheckpoint(v string) *ReplicationTask {
	s.RecoveryCheckpoint = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *ReplicationTask) SetReplicationInstanceArn(v string) *ReplicationTask {
	s.ReplicationInstanceArn = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ReplicationTask) SetReplicationTaskArn(v string) *ReplicationTask {
	s.ReplicationTaskArn = &v
	return s
}

// SetReplicationTaskCreationDate sets the ReplicationTaskCreationDate field's value.
func (s *ReplicationTask) SetReplicationTaskCreationDate(v time.Time) *ReplicationTask {
	s.ReplicationTaskCreationDate = &v
	return s
}

// SetReplicationTaskIdentifier sets the ReplicationTaskIdentifier field's value.
func (s *ReplicationTask) SetReplicationTaskIdentifier(v string) *ReplicationTask {
	s.ReplicationTaskIdentifier = &v
	return s
}

// SetReplicationTaskSettings sets the ReplicationTaskSettings field's value.
func (s *ReplicationTask) SetReplicationTaskSettings(v string) *ReplicationTask {
	s.ReplicationTaskSettings = &v
	return s
}

// SetReplicationTaskStartDate sets the ReplicationTaskStartDate field's value.
func (s *ReplicationTask) SetReplicationTaskStartDate(v time.Time) *ReplicationTask {
	s.ReplicationTaskStartDate = &v
	return s
}

// SetReplicationTaskStats sets the ReplicationTaskStats field's value.
func (s *ReplicationTask) SetReplicationTaskStats(v *ReplicationTaskStats) *ReplicationTask {
	s.ReplicationTaskStats = v
	return s
}

// SetSourceEndpointArn sets the SourceEndpointArn field's value.
func (s *ReplicationTask) SetSourceEndpointArn(v string) *ReplicationTask {
	s.SourceEndpointArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplicationTask) SetStatus(v string) *ReplicationTask {
	s.Status = &v
	return s
}

// SetStopReason sets the StopReason field's value.
func (s *ReplicationTask) SetStopReason(v string) *ReplicationTask {
	s.StopReason = &v
	return s
}

// SetTableMappings sets the TableMappings field's value.
func (s *ReplicationTask) SetTableMappings(v string) *ReplicationTask {
	s.TableMappings = &v
	return s
}

// SetTargetEndpointArn sets the TargetEndpointArn field's value.
func (s *ReplicationTask) SetTargetEndpointArn(v string) *ReplicationTask {
	s.TargetEndpointArn = &v
	return s
}

// SetTargetReplicationInstanceArn sets the TargetReplicationInstanceArn field's value.
func (s *ReplicationTask) SetTargetReplicationInstanceArn(v string) *ReplicationTask {
	s.TargetReplicationInstanceArn = &v
	return s
}

// SetTaskData sets the TaskData field's value.
func (s *ReplicationTask) SetTaskData(v string) *ReplicationTask {
	s.TaskData = &v
	return s
}

// The task assessment report in JSON format.
type ReplicationTaskAssessmentResult struct {
	_ struct{} `type:"structure"`

	// The task assessment results in JSON format.
	//
	// The response object only contains this field if you provide DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn
	// in the request.
	AssessmentResults *string `type:"string"`

	// The file containing the results of the task assessment.
	AssessmentResultsFile *string `type:"string"`

	// The status of the task assessment.
	AssessmentStatus *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task.
	ReplicationTaskArn *string `type:"string"`

	// The replication task identifier of the task on which the task assessment
	// was run.
	ReplicationTaskIdentifier *string `type:"string"`

	// The date the task assessment was completed.
	ReplicationTaskLastAssessmentDate *time.Time `type:"timestamp"`

	// The URL of the S3 object containing the task assessment results.
	//
	// The response object only contains this field if you provide DescribeReplicationTaskAssessmentResultsMessage$ReplicationTaskArn
	// in the request.
	S3ObjectUrl *string `type:"string"`
}

// String returns the string representation
func (s ReplicationTaskAssessmentResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTaskAssessmentResult) GoString() string {
	return s.String()
}

// SetAssessmentResults sets the AssessmentResults field's value.
func (s *ReplicationTaskAssessmentResult) SetAssessmentResults(v string) *ReplicationTaskAssessmentResult {
	s.AssessmentResults = &v
	return s
}

// SetAssessmentResultsFile sets the AssessmentResultsFile field's value.
func (s *ReplicationTaskAssessmentResult) SetAssessmentResultsFile(v string) *ReplicationTaskAssessmentResult {
	s.AssessmentResultsFile = &v
	return s
}

// SetAssessmentStatus sets the AssessmentStatus field's value.
func (s *ReplicationTaskAssessmentResult) SetAssessmentStatus(v string) *ReplicationTaskAssessmentResult {
	s.AssessmentStatus = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ReplicationTaskAssessmentResult) SetReplicationTaskArn(v string) *ReplicationTaskAssessmentResult {
	s.ReplicationTaskArn = &v
	return s
}

// SetReplicationTaskIdentifier sets the ReplicationTaskIdentifier field's value.
func (s *ReplicationTaskAssessmentResult) SetReplicationTaskIdentifier(v string) *ReplicationTaskAssessmentResult {
	s.ReplicationTaskIdentifier = &v
	return s
}

// SetReplicationTaskLastAssessmentDate sets the ReplicationTaskLastAssessmentDate field's value.
func (s *ReplicationTaskAssessmentResult) SetReplicationTaskLastAssessmentDate(v time.Time) *ReplicationTaskAssessmentResult {
	s.ReplicationTaskLastAssessmentDate = &v
	return s
}

// SetS3ObjectUrl sets the S3ObjectUrl field's value.
func (s *ReplicationTaskAssessmentResult) SetS3ObjectUrl(v string) *ReplicationTaskAssessmentResult {
	s.S3ObjectUrl = &v
	return s
}

// Provides information that describes a premigration assessment run that you
// have started using the StartReplicationTaskAssessmentRun operation.
//
// Some of the information appears based on other operations that can return
// the ReplicationTaskAssessmentRun object.
type ReplicationTaskAssessmentRun struct {
	_ struct{} `type:"structure"`

	// Indication of the completion progress for the individual assessments specified
	// to run.
	AssessmentProgress *ReplicationTaskAssessmentRunProgress `type:"structure"`

	// Unique name of the assessment run.
	AssessmentRunName *string `type:"string"`

	// Last message generated by an individual assessment failure.
	LastFailureMessage *string `type:"string"`

	// ARN of the migration task associated with this premigration assessment run.
	ReplicationTaskArn *string `type:"string"`

	// Amazon Resource Name (ARN) of this assessment run.
	ReplicationTaskAssessmentRunArn *string `type:"string"`

	// Date on which the assessment run was created using the StartReplicationTaskAssessmentRun
	// operation.
	ReplicationTaskAssessmentRunCreationDate *time.Time `type:"timestamp"`

	// Encryption mode used to encrypt the assessment run results.
	ResultEncryptionMode *string `type:"string"`

	// ARN of the KMS encryption key used to encrypt the assessment run results.
	ResultKmsKeyArn *string `type:"string"`

	// Amazon S3 bucket where DMS stores the results of this assessment run.
	ResultLocationBucket *string `type:"string"`

	// Folder in an Amazon S3 bucket where DMS stores the results of this assessment
	// run.
	ResultLocationFolder *string `type:"string"`

	// ARN of the service role used to start the assessment run using the StartReplicationTaskAssessmentRun
	// operation. The role must allow the iam:PassRole action.
	ServiceAccessRoleArn *string `type:"string"`

	// Assessment run status.
	//
	// This status can have one of the following values:
	//
	//    * "cancelling" – The assessment run was canceled by the CancelReplicationTaskAssessmentRun
	//    operation.
	//
	//    * "deleting" – The assessment run was deleted by the DeleteReplicationTaskAssessmentRun
	//    operation.
	//
	//    * "failed" – At least one individual assessment completed with a failed
	//    status.
	//
	//    * "error-provisioning" – An internal error occurred while resources
	//    were provisioned (during provisioning status).
	//
	//    * "error-executing" – An internal error occurred while individual assessments
	//    ran (during running status).
	//
	//    * "invalid state" – The assessment run is in an unknown state.
	//
	//    * "passed" – All individual assessments have completed, and none has
	//    a failed status.
	//
	//    * "provisioning" – Resources required to run individual assessments
	//    are being provisioned.
	//
	//    * "running" – Individual assessments are being run.
	//
	//    * "starting" – The assessment run is starting, but resources are not
	//    yet being provisioned for individual assessments.
	Status *string `type:"string"`
}

// String returns the string representation
func (s ReplicationTaskAssessmentRun) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTaskAssessmentRun) GoString() string {
	return s.String()
}

// SetAssessmentProgress sets the AssessmentProgress field's value.
func (s *ReplicationTaskAssessmentRun) SetAssessmentProgress(v *ReplicationTaskAssessmentRunProgress) *ReplicationTaskAssessmentRun {
	s.AssessmentProgress = v
	return s
}

// SetAssessmentRunName sets the AssessmentRunName field's value.
func (s *ReplicationTaskAssessmentRun) SetAssessmentRunName(v string) *ReplicationTaskAssessmentRun {
	s.AssessmentRunName = &v
	return s
}

// SetLastFailureMessage sets the LastFailureMessage field's value.
func (s *ReplicationTaskAssessmentRun) SetLastFailureMessage(v string) *ReplicationTaskAssessmentRun {
	s.LastFailureMessage = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *ReplicationTaskAssessmentRun) SetReplicationTaskArn(v string) *ReplicationTaskAssessmentRun {
	s.ReplicationTaskArn = &v
	return s
}

// SetReplicationTaskAssessmentRunArn sets the ReplicationTaskAssessmentRunArn field's value.
func (s *ReplicationTaskAssessmentRun) SetReplicationTaskAssessmentRunArn(v string) *ReplicationTaskAssessmentRun {
	s.ReplicationTaskAssessmentRunArn = &v
	return s
}

// SetReplicationTaskAssessmentRunCreationDate sets the ReplicationTaskAssessmentRunCreationDate field's value.
func (s *ReplicationTaskAssessmentRun) SetReplicationTaskAssessmentRunCreationDate(v time.Time) *ReplicationTaskAssessmentRun {
	s.ReplicationTaskAssessmentRunCreationDate = &v
	return s
}

// SetResultEncryptionMode sets the ResultEncryptionMode field's value.
func (s *ReplicationTaskAssessmentRun) SetResultEncryptionMode(v string) *ReplicationTaskAssessmentRun {
	s.ResultEncryptionMode = &v
	return s
}

// SetResultKmsKeyArn sets the ResultKmsKeyArn field's value.
func (s *ReplicationTaskAssessmentRun) SetResultKmsKeyArn(v string) *ReplicationTaskAssessmentRun {
	s.ResultKmsKeyArn = &v
	return s
}

// SetResultLocationBucket sets the ResultLocationBucket field's value.
func (s *ReplicationTaskAssessmentRun) SetResultLocationBucket(v string) *ReplicationTaskAssessmentRun {
	s.ResultLocationBucket = &v
	return s
}

// SetResultLocationFolder sets the ResultLocationFolder field's value.
func (s *ReplicationTaskAssessmentRun) SetResultLocationFolder(v string) *ReplicationTaskAssessmentRun {
	s.ResultLocationFolder = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *ReplicationTaskAssessmentRun) SetServiceAccessRoleArn(v string) *ReplicationTaskAssessmentRun {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplicationTaskAssessmentRun) SetStatus(v string) *ReplicationTaskAssessmentRun {
	s.Status = &v
	return s
}

// The progress values reported by the AssessmentProgress response element.
type ReplicationTaskAssessmentRunProgress struct {
	_ struct{} `type:"structure"`

	// The number of individual assessments that have completed, successfully or
	// not.
	IndividualAssessmentCompletedCount *int64 `type:"integer"`

	// The number of individual assessments that are specified to run.
	IndividualAssessmentCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ReplicationTaskAssessmentRunProgress) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTaskAssessmentRunProgress) GoString() string {
	return s.String()
}

// SetIndividualAssessmentCompletedCount sets the IndividualAssessmentCompletedCount field's value.
func (s *ReplicationTaskAssessmentRunProgress) SetIndividualAssessmentCompletedCount(v int64) *ReplicationTaskAssessmentRunProgress {
	s.IndividualAssessmentCompletedCount = &v
	return s
}

// SetIndividualAssessmentCount sets the IndividualAssessmentCount field's value.
func (s *ReplicationTaskAssessmentRunProgress) SetIndividualAssessmentCount(v int64) *ReplicationTaskAssessmentRunProgress {
	s.IndividualAssessmentCount = &v
	return s
}

// Provides information that describes an individual assessment from a premigration
// assessment run.
type ReplicationTaskIndividualAssessment struct {
	_ struct{} `type:"structure"`

	// Name of this individual assessment.
	IndividualAssessmentName *string `type:"string"`

	// ARN of the premigration assessment run that is created to run this individual
	// assessment.
	ReplicationTaskAssessmentRunArn *string `type:"string"`

	// Amazon Resource Name (ARN) of this individual assessment.
	ReplicationTaskIndividualAssessmentArn *string `type:"string"`

	// Date when this individual assessment was started as part of running the StartReplicationTaskAssessmentRun
	// operation.
	ReplicationTaskIndividualAssessmentStartDate *time.Time `type:"timestamp"`

	// Individual assessment status.
	//
	// This status can have one of the following values:
	//
	//    * "cancelled"
	//
	//    * "error"
	//
	//    * "failed"
	//
	//    * "passed"
	//
	//    * "pending"
	//
	//    * "running"
	Status *string `type:"string"`
}

// String returns the string representation
func (s ReplicationTaskIndividualAssessment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTaskIndividualAssessment) GoString() string {
	return s.String()
}

// SetIndividualAssessmentName sets the IndividualAssessmentName field's value.
func (s *ReplicationTaskIndividualAssessment) SetIndividualAssessmentName(v string) *ReplicationTaskIndividualAssessment {
	s.IndividualAssessmentName = &v
	return s
}

// SetReplicationTaskAssessmentRunArn sets the ReplicationTaskAssessmentRunArn field's value.
func (s *ReplicationTaskIndividualAssessment) SetReplicationTaskAssessmentRunArn(v string) *ReplicationTaskIndividualAssessment {
	s.ReplicationTaskAssessmentRunArn = &v
	return s
}

// SetReplicationTaskIndividualAssessmentArn sets the ReplicationTaskIndividualAssessmentArn field's value.
func (s *ReplicationTaskIndividualAssessment) SetReplicationTaskIndividualAssessmentArn(v string) *ReplicationTaskIndividualAssessment {
	s.ReplicationTaskIndividualAssessmentArn = &v
	return s
}

// SetReplicationTaskIndividualAssessmentStartDate sets the ReplicationTaskIndividualAssessmentStartDate field's value.
func (s *ReplicationTaskIndividualAssessment) SetReplicationTaskIndividualAssessmentStartDate(v time.Time) *ReplicationTaskIndividualAssessment {
	s.ReplicationTaskIndividualAssessmentStartDate = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ReplicationTaskIndividualAssessment) SetStatus(v string) *ReplicationTaskIndividualAssessment {
	s.Status = &v
	return s
}

// In response to a request by the DescribeReplicationTasks operation, this
// object provides a collection of statistics about a replication task.
type ReplicationTaskStats struct {
	_ struct{} `type:"structure"`

	// The elapsed time of the task, in milliseconds.
	ElapsedTimeMillis *int64 `type:"long"`

	// The date the replication task was started either with a fresh start or a
	// target reload.
	FreshStartDate *time.Time `type:"timestamp"`

	// The date the replication task full load was completed.
	FullLoadFinishDate *time.Time `type:"timestamp"`

	// The percent complete for the full load migration task.
	FullLoadProgressPercent *int64 `type:"integer"`

	// The date the replication task full load was started.
	FullLoadStartDate *time.Time `type:"timestamp"`

	// The date the replication task was started either with a fresh start or a
	// resume. For more information, see StartReplicationTaskType (https://docs.aws.amazon.com/dms/latest/APIReference/API_StartReplicationTask.html#DMS-StartReplicationTask-request-StartReplicationTaskType).
	StartDate *time.Time `type:"timestamp"`

	// The date the replication task was stopped.
	StopDate *time.Time `type:"timestamp"`

	// The number of errors that have occurred during this task.
	TablesErrored *int64 `type:"integer"`

	// The number of tables loaded for this task.
	TablesLoaded *int64 `type:"integer"`

	// The number of tables currently loading for this task.
	TablesLoading *int64 `type:"integer"`

	// The number of tables queued for this task.
	TablesQueued *int64 `type:"integer"`
}

// String returns the string representation
func (s ReplicationTaskStats) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReplicationTaskStats) GoString() string {
	return s.String()
}

// SetElapsedTimeMillis sets the ElapsedTimeMillis field's value.
func (s *ReplicationTaskStats) SetElapsedTimeMillis(v int64) *ReplicationTaskStats {
	s.ElapsedTimeMillis = &v
	return s
}

// SetFreshStartDate sets the FreshStartDate field's value.
func (s *ReplicationTaskStats) SetFreshStartDate(v time.Time) *ReplicationTaskStats {
	s.FreshStartDate = &v
	return s
}

// SetFullLoadFinishDate sets the FullLoadFinishDate field's value.
func (s *ReplicationTaskStats) SetFullLoadFinishDate(v time.Time) *ReplicationTaskStats {
	s.FullLoadFinishDate = &v
	return s
}

// SetFullLoadProgressPercent sets the FullLoadProgressPercent field's value.
func (s *ReplicationTaskStats) SetFullLoadProgressPercent(v int64) *ReplicationTaskStats {
	s.FullLoadProgressPercent = &v
	return s
}

// SetFullLoadStartDate sets the FullLoadStartDate field's value.
func (s *ReplicationTaskStats) SetFullLoadStartDate(v time.Time) *ReplicationTaskStats {
	s.FullLoadStartDate = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *ReplicationTaskStats) SetStartDate(v time.Time) *ReplicationTaskStats {
	s.StartDate = &v
	return s
}

// SetStopDate sets the StopDate field's value.
func (s *ReplicationTaskStats) SetStopDate(v time.Time) *ReplicationTaskStats {
	s.StopDate = &v
	return s
}

// SetTablesErrored sets the TablesErrored field's value.
func (s *ReplicationTaskStats) SetTablesErrored(v int64) *ReplicationTaskStats {
	s.TablesErrored = &v
	return s
}

// SetTablesLoaded sets the TablesLoaded field's value.
func (s *ReplicationTaskStats) SetTablesLoaded(v int64) *ReplicationTaskStats {
	s.TablesLoaded = &v
	return s
}

// SetTablesLoading sets the TablesLoading field's value.
func (s *ReplicationTaskStats) SetTablesLoading(v int64) *ReplicationTaskStats {
	s.TablesLoading = &v
	return s
}

// SetTablesQueued sets the TablesQueued field's value.
func (s *ReplicationTaskStats) SetTablesQueued(v int64) *ReplicationTaskStats {
	s.TablesQueued = &v
	return s
}

// The resource you are attempting to create already exists.
type ResourceAlreadyExistsFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	ResourceArn *string `locationName:"resourceArn" type:"string"`
}

// String returns the string representation
func (s ResourceAlreadyExistsFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAlreadyExistsFault) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsFault(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsFault) Code() string {
	return "ResourceAlreadyExistsFault"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsFault) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsFault) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource could not be found.
type ResourceNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundFault) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundFault(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundFault) Code() string {
	return "ResourceNotFoundFault"
}

// Message returns the exception's message.
func (s *ResourceNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundFault) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Identifies an DMS resource and any pending actions for it.
type ResourcePendingMaintenanceActions struct {
	_ struct{} `type:"structure"`

	// Detailed information about the pending maintenance action.
	PendingMaintenanceActionDetails []*PendingMaintenanceAction `type:"list"`

	// The Amazon Resource Name (ARN) of the DMS resource that the pending maintenance
	// action applies to. For information about creating an ARN, see Constructing
	// an Amazon Resource Name (ARN) for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Introduction.AWS.ARN.html)
	// in the DMS documentation.
	ResourceIdentifier *string `type:"string"`
}

// String returns the string representation
func (s ResourcePendingMaintenanceActions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePendingMaintenanceActions) GoString() string {
	return s.String()
}

// SetPendingMaintenanceActionDetails sets the PendingMaintenanceActionDetails field's value.
func (s *ResourcePendingMaintenanceActions) SetPendingMaintenanceActionDetails(v []*PendingMaintenanceAction) *ResourcePendingMaintenanceActions {
	s.PendingMaintenanceActionDetails = v
	return s
}

// SetResourceIdentifier sets the ResourceIdentifier field's value.
func (s *ResourcePendingMaintenanceActions) SetResourceIdentifier(v string) *ResourcePendingMaintenanceActions {
	s.ResourceIdentifier = &v
	return s
}

// The quota for this resource quota has been exceeded.
type ResourceQuotaExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ResourceQuotaExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceQuotaExceededFault) GoString() string {
	return s.String()
}

func newErrorResourceQuotaExceededFault(v protocol.ResponseMetadata) error {
	return &ResourceQuotaExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceQuotaExceededFault) Code() string {
	return "ResourceQuotaExceededFault"
}

// Message returns the exception's message.
func (s *ResourceQuotaExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceQuotaExceededFault) OrigErr() error {
	return nil
}

func (s *ResourceQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceQuotaExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceQuotaExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Insufficient privileges are preventing access to an Amazon S3 object.
type S3AccessDeniedFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s S3AccessDeniedFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3AccessDeniedFault) GoString() string {
	return s.String()
}

func newErrorS3AccessDeniedFault(v protocol.ResponseMetadata) error {
	return &S3AccessDeniedFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *S3AccessDeniedFault) Code() string {
	return "S3AccessDeniedFault"
}

// Message returns the exception's message.
func (s *S3AccessDeniedFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *S3AccessDeniedFault) OrigErr() error {
	return nil
}

func (s *S3AccessDeniedFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *S3AccessDeniedFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *S3AccessDeniedFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// A specified Amazon S3 bucket, bucket folder, or other object can't be found.
type S3ResourceNotFoundFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s S3ResourceNotFoundFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ResourceNotFoundFault) GoString() string {
	return s.String()
}

func newErrorS3ResourceNotFoundFault(v protocol.ResponseMetadata) error {
	return &S3ResourceNotFoundFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *S3ResourceNotFoundFault) Code() string {
	return "S3ResourceNotFoundFault"
}

// Message returns the exception's message.
func (s *S3ResourceNotFoundFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *S3ResourceNotFoundFault) OrigErr() error {
	return nil
}

func (s *S3ResourceNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *S3ResourceNotFoundFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *S3ResourceNotFoundFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Settings for exporting data to Amazon S3.
type S3Settings struct {
	_ struct{} `type:"structure"`

	// An optional parameter to set a folder name in the S3 bucket. If provided,
	// tables are created in the path bucketFolder/schema_name/table_name/. If this
	// parameter isn't specified, then the path used is schema_name/table_name/.
	BucketFolder *string `type:"string"`

	// The name of the S3 bucket.
	BucketName *string `type:"string"`

	// A value that enables a change data capture (CDC) load to write INSERT and
	// UPDATE operations to .csv or .parquet (columnar storage) output files. The
	// default setting is false, but when CdcInsertsAndUpdates is set to true or
	// y, only INSERTs and UPDATEs from the source database are migrated to the
	// .csv or .parquet file.
	//
	// For .csv file format only, how these INSERTs and UPDATEs are recorded depends
	// on the value of the IncludeOpForFullLoad parameter. If IncludeOpForFullLoad
	// is set to true, the first field of every CDC record is set to either I or
	// U to indicate INSERT and UPDATE operations at the source. But if IncludeOpForFullLoad
	// is set to false, CDC records are written without an indication of INSERT
	// or UPDATE operations at the source. For more information about how these
	// settings work together, see Indicating Source DB Operations in Migrated S3
	// Data (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps)
	// in the Database Migration Service User Guide..
	//
	// DMS supports the use of the CdcInsertsAndUpdates parameter in versions 3.3.1
	// and later.
	//
	// CdcInsertsOnly and CdcInsertsAndUpdates can't both be set to true for the
	// same endpoint. Set either CdcInsertsOnly or CdcInsertsAndUpdates to true
	// for the same endpoint, but not both.
	CdcInsertsAndUpdates *bool `type:"boolean"`

	// A value that enables a change data capture (CDC) load to write only INSERT
	// operations to .csv or columnar storage (.parquet) output files. By default
	// (the false setting), the first field in a .csv or .parquet record contains
	// the letter I (INSERT), U (UPDATE), or D (DELETE). These values indicate whether
	// the row was inserted, updated, or deleted at the source database for a CDC
	// load to the target.
	//
	// If CdcInsertsOnly is set to true or y, only INSERTs from the source database
	// are migrated to the .csv or .parquet file. For .csv format only, how these
	// INSERTs are recorded depends on the value of IncludeOpForFullLoad. If IncludeOpForFullLoad
	// is set to true, the first field of every CDC record is set to I to indicate
	// the INSERT operation at the source. If IncludeOpForFullLoad is set to false,
	// every CDC record is written without a first field to indicate the INSERT
	// operation at the source. For more information about how these settings work
	// together, see Indicating Source DB Operations in Migrated S3 Data (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps)
	// in the Database Migration Service User Guide..
	//
	// DMS supports the interaction described preceding between the CdcInsertsOnly
	// and IncludeOpForFullLoad parameters in versions 3.1.4 and later.
	//
	// CdcInsertsOnly and CdcInsertsAndUpdates can't both be set to true for the
	// same endpoint. Set either CdcInsertsOnly or CdcInsertsAndUpdates to true
	// for the same endpoint, but not both.
	CdcInsertsOnly *bool `type:"boolean"`

	// Specifies the folder path of CDC files. For an S3 source, this setting is
	// required if a task captures change data; otherwise, it's optional. If CdcPath
	// is set, DMS reads CDC files from this path and replicates the data changes
	// to the target endpoint. For an S3 target if you set PreserveTransactions
	// (https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-PreserveTransactions)
	// to true, DMS verifies that you have set this parameter to a folder path on
	// your S3 target where DMS can save the transaction order for the CDC load.
	// DMS creates this CDC folder path in either your S3 target working directory
	// or the S3 target location specified by BucketFolder (https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketFolder)
	// and BucketName (https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-BucketName).
	//
	// For example, if you specify CdcPath as MyChangedData, and you specify BucketName
	// as MyTargetBucket but do not specify BucketFolder, DMS creates the CDC folder
	// path following: MyTargetBucket/MyChangedData.
	//
	// If you specify the same CdcPath, and you specify BucketName as MyTargetBucket
	// and BucketFolder as MyTargetData, DMS creates the CDC folder path following:
	// MyTargetBucket/MyTargetData/MyChangedData.
	//
	// For more information on CDC including transaction order on an S3 target,
	// see Capturing data changes (CDC) including transaction order on the S3 target
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath).
	//
	// This setting is supported in DMS versions 3.4.2 and later.
	CdcPath *string `type:"string"`

	// An optional parameter to use GZIP to compress the target files. Set to GZIP
	// to compress the target files. Either set this parameter to NONE (the default)
	// or don't use it to leave the files uncompressed. This parameter applies to
	// both .csv and .parquet file formats.
	CompressionType *string `type:"string" enum:"CompressionTypeValue"`

	// The delimiter used to separate columns in the .csv file for both source and
	// target. The default is a comma.
	CsvDelimiter *string `type:"string"`

	// This setting only applies if your Amazon S3 output files during a change
	// data capture (CDC) load are written in .csv format. If UseCsvNoSupValue (https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-UseCsvNoSupValue)
	// is set to true, specify a string value that you want DMS to use for all columns
	// not included in the supplemental log. If you do not specify a string value,
	// DMS uses the null value for these columns regardless of the UseCsvNoSupValue
	// setting.
	//
	// This setting is supported in DMS versions 3.4.1 and later.
	CsvNoSupValue *string `type:"string"`

	// The delimiter used to separate rows in the .csv file for both source and
	// target. The default is a carriage return (\n).
	CsvRowDelimiter *string `type:"string"`

	// The format of the data that you want to use for output. You can choose one
	// of the following:
	//
	//    * csv : This is a row-based file format with comma-separated values (.csv).
	//
	//    * parquet : Apache Parquet (.parquet) is a columnar storage file format
	//    that features efficient compression and provides faster query response.
	DataFormat *string `type:"string" enum:"DataFormatValue"`

	// The size of one data page in bytes. This parameter defaults to 1024 * 1024
	// bytes (1 MiB). This number is used for .parquet file format only.
	DataPageSize *int64 `type:"integer"`

	// Specifies a date separating delimiter to use during folder partitioning.
	// The default value is SLASH. Use this parameter when DatePartitionedEnabled
	// is set to true.
	DatePartitionDelimiter *string `type:"string" enum:"DatePartitionDelimiterValue"`

	// When set to true, this parameter partitions S3 bucket folders based on transaction
	// commit dates. The default value is false. For more information about date-based
	// folder partitioning, see Using date-based folder partitioning (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.DatePartitioning).
	DatePartitionEnabled *bool `type:"boolean"`

	// Identifies the sequence of the date format to use during folder partitioning.
	// The default value is YYYYMMDD. Use this parameter when DatePartitionedEnabled
	// is set to true.
	DatePartitionSequence *string `type:"string" enum:"DatePartitionSequenceValue"`

	// The maximum size of an encoded dictionary page of a column. If the dictionary
	// page exceeds this, this column is stored using an encoding type of PLAIN.
	// This parameter defaults to 1024 * 1024 bytes (1 MiB), the maximum size of
	// a dictionary page before it reverts to PLAIN encoding. This size is used
	// for .parquet file format only.
	DictPageSizeLimit *int64 `type:"integer"`

	// A value that enables statistics for Parquet pages and row groups. Choose
	// true to enable statistics, false to disable. Statistics include NULL, DISTINCT,
	// MAX, and MIN values. This parameter defaults to true. This value is used
	// for .parquet file format only.
	EnableStatistics *bool `type:"boolean"`

	// The type of encoding you are using:
	//
	//    * RLE_DICTIONARY uses a combination of bit-packing and run-length encoding
	//    to store repeated values more efficiently. This is the default.
	//
	//    * PLAIN doesn't use encoding at all. Values are stored as they are.
	//
	//    * PLAIN_DICTIONARY builds a dictionary of the values encountered in a
	//    given column. The dictionary is stored in a dictionary page for each column
	//    chunk.
	EncodingType *string `type:"string" enum:"EncodingTypeValue"`

	// The type of server-side encryption that you want to use for your data. This
	// encryption type is part of the endpoint settings or the extra connections
	// attributes for Amazon S3. You can choose either SSE_S3 (the default) or SSE_KMS.
	//
	// For the ModifyEndpoint operation, you can change the existing value of the
	// EncryptionMode parameter from SSE_KMS to SSE_S3. But you can’t change the
	// existing value from SSE_S3 to SSE_KMS.
	//
	// To use SSE_S3, you need an Identity and Access Management (IAM) role with
	// permission to allow "arn:aws:s3:::dms-*" to use the following actions:
	//
	//    * s3:CreateBucket
	//
	//    * s3:ListBucket
	//
	//    * s3:DeleteBucket
	//
	//    * s3:GetBucketLocation
	//
	//    * s3:GetObject
	//
	//    * s3:PutObject
	//
	//    * s3:DeleteObject
	//
	//    * s3:GetObjectVersion
	//
	//    * s3:GetBucketPolicy
	//
	//    * s3:PutBucketPolicy
	//
	//    * s3:DeleteBucketPolicy
	EncryptionMode *string `type:"string" enum:"EncryptionModeValue"`

	// Specifies how tables are defined in the S3 source files only.
	ExternalTableDefinition *string `type:"string"`

	// A value that enables a full load to write INSERT operations to the comma-separated
	// value (.csv) output files only to indicate how the rows were added to the
	// source database.
	//
	// DMS supports the IncludeOpForFullLoad parameter in versions 3.1.4 and later.
	//
	// For full load, records can only be inserted. By default (the false setting),
	// no information is recorded in these output files for a full load to indicate
	// that the rows were inserted at the source database. If IncludeOpForFullLoad
	// is set to true or y, the INSERT is recorded as an I annotation in the first
	// field of the .csv file. This allows the format of your target records from
	// a full load to be consistent with the target records from a CDC load.
	//
	// This setting works together with the CdcInsertsOnly and the CdcInsertsAndUpdates
	// parameters for output to .csv files only. For more information about how
	// these settings work together, see Indicating Source DB Operations in Migrated
	// S3 Data (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.Configuring.InsertOps)
	// in the Database Migration Service User Guide..
	IncludeOpForFullLoad *bool `type:"boolean"`

	// A value that specifies the precision of any TIMESTAMP column values that
	// are written to an Amazon S3 object file in .parquet format.
	//
	// DMS supports the ParquetTimestampInMillisecond parameter in versions 3.1.4
	// and later.
	//
	// When ParquetTimestampInMillisecond is set to true or y, DMS writes all TIMESTAMP
	// columns in a .parquet formatted file with millisecond precision. Otherwise,
	// DMS writes them with microsecond precision.
	//
	// Currently, Amazon Athena and Glue can handle only millisecond precision for
	// TIMESTAMP values. Set this parameter to true for S3 endpoint object files
	// that are .parquet formatted only if you plan to query or process the data
	// with Athena or Glue.
	//
	// DMS writes any TIMESTAMP column values written to an S3 file in .csv format
	// with microsecond precision.
	//
	// Setting ParquetTimestampInMillisecond has no effect on the string format
	// of the timestamp column value that is inserted by setting the TimestampColumnName
	// parameter.
	ParquetTimestampInMillisecond *bool `type:"boolean"`

	// The version of the Apache Parquet format that you want to use: parquet_1_0
	// (the default) or parquet_2_0.
	ParquetVersion *string `type:"string" enum:"ParquetVersionValue"`

	// If set to true, DMS saves the transaction order for a change data capture
	// (CDC) load on the Amazon S3 target specified by CdcPath (https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CdcPath).
	// For more information, see Capturing data changes (CDC) including transaction
	// order on the S3 target (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Target.S3.html#CHAP_Target.S3.EndpointSettings.CdcPath).
	//
	// This setting is supported in DMS versions 3.4.2 and later.
	PreserveTransactions *bool `type:"boolean"`

	// The number of rows in a row group. A smaller row group size provides faster
	// reads. But as the number of row groups grows, the slower writes become. This
	// parameter defaults to 10,000 rows. This number is used for .parquet file
	// format only.
	//
	// If you choose a value larger than the maximum, RowGroupLength is set to the
	// max row group length in bytes (64 * 1024 * 1024).
	RowGroupLength *int64 `type:"integer"`

	// If you are using SSE_KMS for the EncryptionMode, provide the KMS key ID.
	// The key that you use needs an attached policy that enables Identity and Access
	// Management (IAM) user permissions and allows use of the key.
	//
	// Here is a CLI example: aws dms create-endpoint --endpoint-identifier value
	// --endpoint-type target --engine-name s3 --s3-settings ServiceAccessRoleArn=value,BucketFolder=value,BucketName=value,EncryptionMode=SSE_KMS,ServerSideEncryptionKmsKeyId=value
	ServerSideEncryptionKmsKeyId *string `type:"string"`

	// The Amazon Resource Name (ARN) used by the service to access the IAM role.
	// The role must allow the iam:PassRole action. It is a required parameter that
	// enables DMS to write and read objects from an S3 bucket.
	ServiceAccessRoleArn *string `type:"string"`

	// A value that when nonblank causes DMS to add a column with timestamp information
	// to the endpoint data for an Amazon S3 target.
	//
	// DMS supports the TimestampColumnName parameter in versions 3.1.4 and later.
	//
	// DMS includes an additional STRING column in the .csv or .parquet object files
	// of your migrated data when you set TimestampColumnName to a nonblank value.
	//
	// For a full load, each row of this timestamp column contains a timestamp for
	// when the data was transferred from the source to the target by DMS.
	//
	// For a change data capture (CDC) load, each row of the timestamp column contains
	// the timestamp for the commit of that row in the source database.
	//
	// The string format for this timestamp column value is yyyy-MM-dd HH:mm:ss.SSSSSS.
	// By default, the precision of this value is in microseconds. For a CDC load,
	// the rounding of the precision depends on the commit timestamp supported by
	// DMS for the source database.
	//
	// When the AddColumnName parameter is set to true, DMS also includes a name
	// for the timestamp column that you set with TimestampColumnName.
	TimestampColumnName *string `type:"string"`

	// This setting applies if the S3 output files during a change data capture
	// (CDC) load are written in .csv format. If set to true for columns not included
	// in the supplemental log, DMS uses the value specified by CsvNoSupValue (https://docs.aws.amazon.com/dms/latest/APIReference/API_S3Settings.html#DMS-Type-S3Settings-CsvNoSupValue).
	// If not set or set to false, DMS uses the null value for these columns.
	//
	// This setting is supported in DMS versions 3.4.1 and later.
	UseCsvNoSupValue *bool `type:"boolean"`
}

// String returns the string representation
func (s S3Settings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Settings) GoString() string {
	return s.String()
}

// SetBucketFolder sets the BucketFolder field's value.
func (s *S3Settings) SetBucketFolder(v string) *S3Settings {
	s.BucketFolder = &v
	return s
}

// SetBucketName sets the BucketName field's value.
func (s *S3Settings) SetBucketName(v string) *S3Settings {
	s.BucketName = &v
	return s
}

// SetCdcInsertsAndUpdates sets the CdcInsertsAndUpdates field's value.
func (s *S3Settings) SetCdcInsertsAndUpdates(v bool) *S3Settings {
	s.CdcInsertsAndUpdates = &v
	return s
}

// SetCdcInsertsOnly sets the CdcInsertsOnly field's value.
func (s *S3Settings) SetCdcInsertsOnly(v bool) *S3Settings {
	s.CdcInsertsOnly = &v
	return s
}

// SetCdcPath sets the CdcPath field's value.
func (s *S3Settings) SetCdcPath(v string) *S3Settings {
	s.CdcPath = &v
	return s
}

// SetCompressionType sets the CompressionType field's value.
func (s *S3Settings) SetCompressionType(v string) *S3Settings {
	s.CompressionType = &v
	return s
}

// SetCsvDelimiter sets the CsvDelimiter field's value.
func (s *S3Settings) SetCsvDelimiter(v string) *S3Settings {
	s.CsvDelimiter = &v
	return s
}

// SetCsvNoSupValue sets the CsvNoSupValue field's value.
func (s *S3Settings) SetCsvNoSupValue(v string) *S3Settings {
	s.CsvNoSupValue = &v
	return s
}

// SetCsvRowDelimiter sets the CsvRowDelimiter field's value.
func (s *S3Settings) SetCsvRowDelimiter(v string) *S3Settings {
	s.CsvRowDelimiter = &v
	return s
}

// SetDataFormat sets the DataFormat field's value.
func (s *S3Settings) SetDataFormat(v string) *S3Settings {
	s.DataFormat = &v
	return s
}

// SetDataPageSize sets the DataPageSize field's value.
func (s *S3Settings) SetDataPageSize(v int64) *S3Settings {
	s.DataPageSize = &v
	return s
}

// SetDatePartitionDelimiter sets the DatePartitionDelimiter field's value.
func (s *S3Settings) SetDatePartitionDelimiter(v string) *S3Settings {
	s.DatePartitionDelimiter = &v
	return s
}

// SetDatePartitionEnabled sets the DatePartitionEnabled field's value.
func (s *S3Settings) SetDatePartitionEnabled(v bool) *S3Settings {
	s.DatePartitionEnabled = &v
	return s
}

// SetDatePartitionSequence sets the DatePartitionSequence field's value.
func (s *S3Settings) SetDatePartitionSequence(v string) *S3Settings {
	s.DatePartitionSequence = &v
	return s
}

// SetDictPageSizeLimit sets the DictPageSizeLimit field's value.
func (s *S3Settings) SetDictPageSizeLimit(v int64) *S3Settings {
	s.DictPageSizeLimit = &v
	return s
}

// SetEnableStatistics sets the EnableStatistics field's value.
func (s *S3Settings) SetEnableStatistics(v bool) *S3Settings {
	s.EnableStatistics = &v
	return s
}

// SetEncodingType sets the EncodingType field's value.
func (s *S3Settings) SetEncodingType(v string) *S3Settings {
	s.EncodingType = &v
	return s
}

// SetEncryptionMode sets the EncryptionMode field's value.
func (s *S3Settings) SetEncryptionMode(v string) *S3Settings {
	s.EncryptionMode = &v
	return s
}

// SetExternalTableDefinition sets the ExternalTableDefinition field's value.
func (s *S3Settings) SetExternalTableDefinition(v string) *S3Settings {
	s.ExternalTableDefinition = &v
	return s
}

// SetIncludeOpForFullLoad sets the IncludeOpForFullLoad field's value.
func (s *S3Settings) SetIncludeOpForFullLoad(v bool) *S3Settings {
	s.IncludeOpForFullLoad = &v
	return s
}

// SetParquetTimestampInMillisecond sets the ParquetTimestampInMillisecond field's value.
func (s *S3Settings) SetParquetTimestampInMillisecond(v bool) *S3Settings {
	s.ParquetTimestampInMillisecond = &v
	return s
}

// SetParquetVersion sets the ParquetVersion field's value.
func (s *S3Settings) SetParquetVersion(v string) *S3Settings {
	s.ParquetVersion = &v
	return s
}

// SetPreserveTransactions sets the PreserveTransactions field's value.
func (s *S3Settings) SetPreserveTransactions(v bool) *S3Settings {
	s.PreserveTransactions = &v
	return s
}

// SetRowGroupLength sets the RowGroupLength field's value.
func (s *S3Settings) SetRowGroupLength(v int64) *S3Settings {
	s.RowGroupLength = &v
	return s
}

// SetServerSideEncryptionKmsKeyId sets the ServerSideEncryptionKmsKeyId field's value.
func (s *S3Settings) SetServerSideEncryptionKmsKeyId(v string) *S3Settings {
	s.ServerSideEncryptionKmsKeyId = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *S3Settings) SetServiceAccessRoleArn(v string) *S3Settings {
	s.ServiceAccessRoleArn = &v
	return s
}

// SetTimestampColumnName sets the TimestampColumnName field's value.
func (s *S3Settings) SetTimestampColumnName(v string) *S3Settings {
	s.TimestampColumnName = &v
	return s
}

// SetUseCsvNoSupValue sets the UseCsvNoSupValue field's value.
func (s *S3Settings) SetUseCsvNoSupValue(v bool) *S3Settings {
	s.UseCsvNoSupValue = &v
	return s
}

// The SNS topic is invalid.
type SNSInvalidTopicFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s SNSInvalidTopicFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SNSInvalidTopicFault) GoString() string {
	return s.String()
}

func newErrorSNSInvalidTopicFault(v protocol.ResponseMetadata) error {
	return &SNSInvalidTopicFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SNSInvalidTopicFault) Code() string {
	return "SNSInvalidTopicFault"
}

// Message returns the exception's message.
func (s *SNSInvalidTopicFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SNSInvalidTopicFault) OrigErr() error {
	return nil
}

func (s *SNSInvalidTopicFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SNSInvalidTopicFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SNSInvalidTopicFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// You are not authorized for the SNS subscription.
type SNSNoAuthorizationFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s SNSNoAuthorizationFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SNSNoAuthorizationFault) GoString() string {
	return s.String()
}

func newErrorSNSNoAuthorizationFault(v protocol.ResponseMetadata) error {
	return &SNSNoAuthorizationFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SNSNoAuthorizationFault) Code() string {
	return "SNSNoAuthorizationFault"
}

// Message returns the exception's message.
func (s *SNSNoAuthorizationFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SNSNoAuthorizationFault) OrigErr() error {
	return nil
}

func (s *SNSNoAuthorizationFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SNSNoAuthorizationFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SNSNoAuthorizationFault) RequestID() string {
	return s.RespMetadata.RequestID
}

type StartReplicationTaskAssessmentInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the replication task.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartReplicationTaskAssessmentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskAssessmentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReplicationTaskAssessmentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReplicationTaskAssessmentInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *StartReplicationTaskAssessmentInput) SetReplicationTaskArn(v string) *StartReplicationTaskAssessmentInput {
	s.ReplicationTaskArn = &v
	return s
}

type StartReplicationTaskAssessmentOutput struct {
	_ struct{} `type:"structure"`

	// The assessed replication task.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s StartReplicationTaskAssessmentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskAssessmentOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *StartReplicationTaskAssessmentOutput) SetReplicationTask(v *ReplicationTask) *StartReplicationTaskAssessmentOutput {
	s.ReplicationTask = v
	return s
}

type StartReplicationTaskAssessmentRunInput struct {
	_ struct{} `type:"structure"`

	// Unique name to identify the assessment run.
	//
	// AssessmentRunName is a required field
	AssessmentRunName *string `type:"string" required:"true"`

	// Space-separated list of names for specific individual assessments that you
	// want to exclude. These names come from the default list of individual assessments
	// that DMS supports for the associated migration task. This task is specified
	// by ReplicationTaskArn.
	//
	// You can't set a value for Exclude if you also set a value for IncludeOnly
	// in the API operation.
	//
	// To identify the names of the default individual assessments that DMS supports
	// for the associated migration task, run the DescribeApplicableIndividualAssessments
	// operation using its own ReplicationTaskArn request parameter.
	Exclude []*string `type:"list"`

	// Space-separated list of names for specific individual assessments that you
	// want to include. These names come from the default list of individual assessments
	// that DMS supports for the associated migration task. This task is specified
	// by ReplicationTaskArn.
	//
	// You can't set a value for IncludeOnly if you also set a value for Exclude
	// in the API operation.
	//
	// To identify the names of the default individual assessments that DMS supports
	// for the associated migration task, run the DescribeApplicableIndividualAssessments
	// operation using its own ReplicationTaskArn request parameter.
	IncludeOnly []*string `type:"list"`

	// Amazon Resource Name (ARN) of the migration task associated with the premigration
	// assessment run that you want to start.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`

	// Encryption mode that you can specify to encrypt the results of this assessment
	// run. If you don't specify this request parameter, DMS stores the assessment
	// run results without encryption. You can specify one of the options following:
	//
	//    * "SSE_S3" – The server-side encryption provided as a default by Amazon
	//    S3.
	//
	//    * "SSE_KMS" – Key Management Service (KMS) encryption. This encryption
	//    can use either a custom KMS encryption key that you specify or the default
	//    KMS encryption key that DMS provides.
	ResultEncryptionMode *string `type:"string"`

	// ARN of a custom KMS encryption key that you specify when you set ResultEncryptionMode
	// to "SSE_KMS".
	ResultKmsKeyArn *string `type:"string"`

	// Amazon S3 bucket where you want DMS to store the results of this assessment
	// run.
	//
	// ResultLocationBucket is a required field
	ResultLocationBucket *string `type:"string" required:"true"`

	// Folder within an Amazon S3 bucket where you want DMS to store the results
	// of this assessment run.
	ResultLocationFolder *string `type:"string"`

	// ARN of the service role needed to start the assessment run. The role must
	// allow the iam:PassRole action.
	//
	// ServiceAccessRoleArn is a required field
	ServiceAccessRoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StartReplicationTaskAssessmentRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskAssessmentRunInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReplicationTaskAssessmentRunInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReplicationTaskAssessmentRunInput"}
	if s.AssessmentRunName == nil {
		invalidParams.Add(request.NewErrParamRequired("AssessmentRunName"))
	}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}
	if s.ResultLocationBucket == nil {
		invalidParams.Add(request.NewErrParamRequired("ResultLocationBucket"))
	}
	if s.ServiceAccessRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceAccessRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssessmentRunName sets the AssessmentRunName field's value.
func (s *StartReplicationTaskAssessmentRunInput) SetAssessmentRunName(v string) *StartReplicationTaskAssessmentRunInput {
	s.AssessmentRunName = &v
	return s
}

// SetExclude sets the Exclude field's value.
func (s *StartReplicationTaskAssessmentRunInput) SetExclude(v []*string) *StartReplicationTaskAssessmentRunInput {
	s.Exclude = v
	return s
}

// SetIncludeOnly sets the IncludeOnly field's value.
func (s *StartReplicationTaskAssessmentRunInput) SetIncludeOnly(v []*string) *StartReplicationTaskAssessmentRunInput {
	s.IncludeOnly = v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *StartReplicationTaskAssessmentRunInput) SetReplicationTaskArn(v string) *StartReplicationTaskAssessmentRunInput {
	s.ReplicationTaskArn = &v
	return s
}

// SetResultEncryptionMode sets the ResultEncryptionMode field's value.
func (s *StartReplicationTaskAssessmentRunInput) SetResultEncryptionMode(v string) *StartReplicationTaskAssessmentRunInput {
	s.ResultEncryptionMode = &v
	return s
}

// SetResultKmsKeyArn sets the ResultKmsKeyArn field's value.
func (s *StartReplicationTaskAssessmentRunInput) SetResultKmsKeyArn(v string) *StartReplicationTaskAssessmentRunInput {
	s.ResultKmsKeyArn = &v
	return s
}

// SetResultLocationBucket sets the ResultLocationBucket field's value.
func (s *StartReplicationTaskAssessmentRunInput) SetResultLocationBucket(v string) *StartReplicationTaskAssessmentRunInput {
	s.ResultLocationBucket = &v
	return s
}

// SetResultLocationFolder sets the ResultLocationFolder field's value.
func (s *StartReplicationTaskAssessmentRunInput) SetResultLocationFolder(v string) *StartReplicationTaskAssessmentRunInput {
	s.ResultLocationFolder = &v
	return s
}

// SetServiceAccessRoleArn sets the ServiceAccessRoleArn field's value.
func (s *StartReplicationTaskAssessmentRunInput) SetServiceAccessRoleArn(v string) *StartReplicationTaskAssessmentRunInput {
	s.ServiceAccessRoleArn = &v
	return s
}

type StartReplicationTaskAssessmentRunOutput struct {
	_ struct{} `type:"structure"`

	// The premigration assessment run that was started.
	ReplicationTaskAssessmentRun *ReplicationTaskAssessmentRun `type:"structure"`
}

// String returns the string representation
func (s StartReplicationTaskAssessmentRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskAssessmentRunOutput) GoString() string {
	return s.String()
}

// SetReplicationTaskAssessmentRun sets the ReplicationTaskAssessmentRun field's value.
func (s *StartReplicationTaskAssessmentRunOutput) SetReplicationTaskAssessmentRun(v *ReplicationTaskAssessmentRun) *StartReplicationTaskAssessmentRunOutput {
	s.ReplicationTaskAssessmentRun = v
	return s
}

type StartReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// Indicates when you want a change data capture (CDC) operation to start. Use
	// either CdcStartPosition or CdcStartTime to specify when you want a CDC operation
	// to start. Specifying both values results in an error.
	//
	// The value can be in date, checkpoint, or LSN/SCN format.
	//
	// Date Example: --cdc-start-position “2018-03-08T12:12:12”
	//
	// Checkpoint Example: --cdc-start-position "checkpoint:V1#27#mysql-bin-changelog.157832:1975:-1:2002:677883278264080:mysql-bin-changelog.157832:1876#0#0#*#0#93"
	//
	// LSN Example: --cdc-start-position “mysql-bin-changelog.000024:373”
	//
	// When you use this task setting with a source PostgreSQL database, a logical
	// replication slot should already be created and associated with the source
	// endpoint. You can verify this by setting the slotName extra connection attribute
	// to the name of this logical replication slot. For more information, see Extra
	// Connection Attributes When Using PostgreSQL as a Source for DMS (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Source.PostgreSQL.html#CHAP_Source.PostgreSQL.ConnectionAttrib).
	CdcStartPosition *string `type:"string"`

	// Indicates the start time for a change data capture (CDC) operation. Use either
	// CdcStartTime or CdcStartPosition to specify when you want a CDC operation
	// to start. Specifying both values results in an error.
	//
	// Timestamp Example: --cdc-start-time “2018-03-08T12:12:12”
	CdcStartTime *time.Time `type:"timestamp"`

	// Indicates when you want a change data capture (CDC) operation to stop. The
	// value can be either server time or commit time.
	//
	// Server time example: --cdc-stop-position “server_time:2018-02-09T12:12:12”
	//
	// Commit time example: --cdc-stop-position “commit_time: 2018-02-09T12:12:12
	// “
	CdcStopPosition *string `type:"string"`

	// The Amazon Resource Name (ARN) of the replication task to be started.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`

	// A type of replication task.
	//
	// StartReplicationTaskType is a required field
	StartReplicationTaskType *string `type:"string" required:"true" enum:"StartReplicationTaskTypeValue"`
}

// String returns the string representation
func (s StartReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}
	if s.StartReplicationTaskType == nil {
		invalidParams.Add(request.NewErrParamRequired("StartReplicationTaskType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCdcStartPosition sets the CdcStartPosition field's value.
func (s *StartReplicationTaskInput) SetCdcStartPosition(v string) *StartReplicationTaskInput {
	s.CdcStartPosition = &v
	return s
}

// SetCdcStartTime sets the CdcStartTime field's value.
func (s *StartReplicationTaskInput) SetCdcStartTime(v time.Time) *StartReplicationTaskInput {
	s.CdcStartTime = &v
	return s
}

// SetCdcStopPosition sets the CdcStopPosition field's value.
func (s *StartReplicationTaskInput) SetCdcStopPosition(v string) *StartReplicationTaskInput {
	s.CdcStopPosition = &v
	return s
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *StartReplicationTaskInput) SetReplicationTaskArn(v string) *StartReplicationTaskInput {
	s.ReplicationTaskArn = &v
	return s
}

// SetStartReplicationTaskType sets the StartReplicationTaskType field's value.
func (s *StartReplicationTaskInput) SetStartReplicationTaskType(v string) *StartReplicationTaskInput {
	s.StartReplicationTaskType = &v
	return s
}

type StartReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task started.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s StartReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *StartReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *StartReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

type StopReplicationTaskInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name(ARN) of the replication task to be stopped.
	//
	// ReplicationTaskArn is a required field
	ReplicationTaskArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s StopReplicationTaskInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopReplicationTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopReplicationTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopReplicationTaskInput"}
	if s.ReplicationTaskArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationTaskArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetReplicationTaskArn sets the ReplicationTaskArn field's value.
func (s *StopReplicationTaskInput) SetReplicationTaskArn(v string) *StopReplicationTaskInput {
	s.ReplicationTaskArn = &v
	return s
}

type StopReplicationTaskOutput struct {
	_ struct{} `type:"structure"`

	// The replication task stopped.
	ReplicationTask *ReplicationTask `type:"structure"`
}

// String returns the string representation
func (s StopReplicationTaskOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StopReplicationTaskOutput) GoString() string {
	return s.String()
}

// SetReplicationTask sets the ReplicationTask field's value.
func (s *StopReplicationTaskOutput) SetReplicationTask(v *ReplicationTask) *StopReplicationTaskOutput {
	s.ReplicationTask = v
	return s
}

// The storage quota has been exceeded.
type StorageQuotaExceededFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s StorageQuotaExceededFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageQuotaExceededFault) GoString() string {
	return s.String()
}

func newErrorStorageQuotaExceededFault(v protocol.ResponseMetadata) error {
	return &StorageQuotaExceededFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *StorageQuotaExceededFault) Code() string {
	return "StorageQuotaExceededFault"
}

// Message returns the exception's message.
func (s *StorageQuotaExceededFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *StorageQuotaExceededFault) OrigErr() error {
	return nil
}

func (s *StorageQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *StorageQuotaExceededFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *StorageQuotaExceededFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// In response to a request by the DescribeReplicationSubnetGroups operation,
// this object identifies a subnet by its given Availability Zone, subnet identifier,
// and status.
type Subnet struct {
	_ struct{} `type:"structure"`

	// The Availability Zone of the subnet.
	SubnetAvailabilityZone *AvailabilityZone `type:"structure"`

	// The subnet identifier.
	SubnetIdentifier *string `type:"string"`

	// The status of the subnet.
	SubnetStatus *string `type:"string"`
}

// String returns the string representation
func (s Subnet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subnet) GoString() string {
	return s.String()
}

// SetSubnetAvailabilityZone sets the SubnetAvailabilityZone field's value.
func (s *Subnet) SetSubnetAvailabilityZone(v *AvailabilityZone) *Subnet {
	s.SubnetAvailabilityZone = v
	return s
}

// SetSubnetIdentifier sets the SubnetIdentifier field's value.
func (s *Subnet) SetSubnetIdentifier(v string) *Subnet {
	s.SubnetIdentifier = &v
	return s
}

// SetSubnetStatus sets the SubnetStatus field's value.
func (s *Subnet) SetSubnetStatus(v string) *Subnet {
	s.SubnetStatus = &v
	return s
}

// The specified subnet is already in use.
type SubnetAlreadyInUse struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s SubnetAlreadyInUse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubnetAlreadyInUse) GoString() string {
	return s.String()
}

func newErrorSubnetAlreadyInUse(v protocol.ResponseMetadata) error {
	return &SubnetAlreadyInUse{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *SubnetAlreadyInUse) Code() string {
	return "SubnetAlreadyInUse"
}

// Message returns the exception's message.
func (s *SubnetAlreadyInUse) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *SubnetAlreadyInUse) OrigErr() error {
	return nil
}

func (s *SubnetAlreadyInUse) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *SubnetAlreadyInUse) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *SubnetAlreadyInUse) RequestID() string {
	return s.RespMetadata.RequestID
}

// Provides information about types of supported endpoints in response to a
// request by the DescribeEndpointTypes operation. This information includes
// the type of endpoint, the database engine name, and whether change data capture
// (CDC) is supported.
type SupportedEndpointType struct {
	_ struct{} `type:"structure"`

	// The type of endpoint. Valid values are source and target.
	EndpointType *string `type:"string" enum:"ReplicationEndpointTypeValue"`

	// The expanded name for the engine name. For example, if the EngineName parameter
	// is "aurora," this value would be "Amazon Aurora MySQL."
	EngineDisplayName *string `type:"string"`

	// The database engine name. Valid values, depending on the EndpointType, include
	// "mysql", "oracle", "postgres", "mariadb", "aurora", "aurora-postgresql",
	// "redshift", "s3", "db2", "azuredb", "sybase", "dynamodb", "mongodb", "kinesis",
	// "kafka", "elasticsearch", "documentdb", "sqlserver", and "neptune".
	EngineName *string `type:"string"`

	// The earliest DMS engine version that supports this endpoint engine. Note
	// that endpoint engines released with DMS versions earlier than 3.1.1 do not
	// return a value for this parameter.
	ReplicationInstanceEngineMinimumVersion *string `type:"string"`

	// Indicates if change data capture (CDC) is supported.
	SupportsCDC *bool `type:"boolean"`
}

// String returns the string representation
func (s SupportedEndpointType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SupportedEndpointType) GoString() string {
	return s.String()
}

// SetEndpointType sets the EndpointType field's value.
func (s *SupportedEndpointType) SetEndpointType(v string) *SupportedEndpointType {
	s.EndpointType = &v
	return s
}

// SetEngineDisplayName sets the EngineDisplayName field's value.
func (s *SupportedEndpointType) SetEngineDisplayName(v string) *SupportedEndpointType {
	s.EngineDisplayName = &v
	return s
}

// SetEngineName sets the EngineName field's value.
func (s *SupportedEndpointType) SetEngineName(v string) *SupportedEndpointType {
	s.EngineName = &v
	return s
}

// SetReplicationInstanceEngineMinimumVersion sets the ReplicationInstanceEngineMinimumVersion field's value.
func (s *SupportedEndpointType) SetReplicationInstanceEngineMinimumVersion(v string) *SupportedEndpointType {
	s.ReplicationInstanceEngineMinimumVersion = &v
	return s
}

// SetSupportsCDC sets the SupportsCDC field's value.
func (s *SupportedEndpointType) SetSupportsCDC(v bool) *SupportedEndpointType {
	s.SupportsCDC = &v
	return s
}

// Provides information that defines a SAP ASE endpoint.
type SybaseSettings struct {
	_ struct{} `type:"structure"`

	// Database name for the endpoint.
	DatabaseName *string `type:"string"`

	// Endpoint connection password.
	Password *string `type:"string" sensitive:"true"`

	// Endpoint TCP port.
	Port *int64 `type:"integer"`

	// The full Amazon Resource Name (ARN) of the IAM role that specifies DMS as
	// the trusted entity and grants the required permissions to access the value
	// in SecretsManagerSecret. The role must allow the iam:PassRole action. SecretsManagerSecret
	// has the value of the Amazon Web Services Secrets Manager secret that allows
	// access to the SAP ASE endpoint.
	//
	// You can specify one of two sets of values for these permissions. You can
	// specify the values for this setting and SecretsManagerSecretId. Or you can
	// specify clear-text values for UserName, Password, ServerName, and Port. You
	// can't specify both. For more information on creating this SecretsManagerSecret
	// and the SecretsManagerAccessRoleArn and SecretsManagerSecretId required to
	// access it, see Using secrets to access Database Migration Service resources
	// (https://docs.aws.amazon.com/dms/latest/userguide/CHAP_Security.html#security-iam-secretsmanager)
	// in the Database Migration Service User Guide.
	SecretsManagerAccessRoleArn *string `type:"string"`

	// The full ARN, partial ARN, or friendly name of the SecretsManagerSecret that
	// contains the SAP SAE endpoint connection details.
	SecretsManagerSecretId *string `type:"string"`

	// Fully qualified domain name of the endpoint.
	ServerName *string `type:"string"`

	// Endpoint connection user name.
	Username *string `type:"string"`
}

// String returns the string representation
func (s SybaseSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SybaseSettings) GoString() string {
	return s.String()
}

// SetDatabaseName sets the DatabaseName field's value.
func (s *SybaseSettings) SetDatabaseName(v string) *SybaseSettings {
	s.DatabaseName = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *SybaseSettings) SetPassword(v string) *SybaseSettings {
	s.Password = &v
	return s
}

// SetPort sets the Port field's value.
func (s *SybaseSettings) SetPort(v int64) *SybaseSettings {
	s.Port = &v
	return s
}

// SetSecretsManagerAccessRoleArn sets the SecretsManagerAccessRoleArn field's value.
func (s *SybaseSettings) SetSecretsManagerAccessRoleArn(v string) *SybaseSettings {
	s.SecretsManagerAccessRoleArn = &v
	return s
}

// SetSecretsManagerSecretId sets the SecretsManagerSecretId field's value.
func (s *SybaseSettings) SetSecretsManagerSecretId(v string) *SybaseSettings {
	s.SecretsManagerSecretId = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *SybaseSettings) SetServerName(v string) *SybaseSettings {
	s.ServerName = &v
	return s
}

// SetUsername sets the Username field's value.
func (s *SybaseSettings) SetUsername(v string) *SybaseSettings {
	s.Username = &v
	return s
}

// Provides a collection of table statistics in response to a request by the
// DescribeTableStatistics operation.
type TableStatistics struct {
	_ struct{} `type:"structure"`

	// The data definition language (DDL) used to build and modify the structure
	// of your tables.
	Ddls *int64 `type:"long"`

	// The number of delete actions performed on a table.
	Deletes *int64 `type:"long"`

	// The number of rows that failed conditional checks during the full load operation
	// (valid only for migrations where DynamoDB is the target).
	FullLoadCondtnlChkFailedRows *int64 `type:"long"`

	// The time when the full load operation completed.
	FullLoadEndTime *time.Time `type:"timestamp"`

	// The number of rows that failed to load during the full load operation (valid
	// only for migrations where DynamoDB is the target).
	FullLoadErrorRows *int64 `type:"long"`

	// A value that indicates if the table was reloaded (true) or loaded as part
	// of a new full load operation (false).
	FullLoadReloaded *bool `type:"boolean"`

	// The number of rows added during the full load operation.
	FullLoadRows *int64 `type:"long"`

	// The time when the full load operation started.
	FullLoadStartTime *time.Time `type:"timestamp"`

	// The number of insert actions performed on a table.
	Inserts *int64 `type:"long"`

	// The last time a table was updated.
	LastUpdateTime *time.Time `type:"timestamp"`

	// The schema name.
	SchemaName *string `type:"string"`

	// The name of the table.
	TableName *string `type:"string"`

	// The state of the tables described.
	//
	// Valid states: Table does not exist | Before load | Full load | Table completed
	// | Table cancelled | Table error | Table all | Table updates | Table is being
	// reloaded
	TableState *string `type:"string"`

	// The number of update actions performed on a table.
	Updates *int64 `type:"long"`

	// The number of records that failed validation.
	ValidationFailedRecords *int64 `type:"long"`

	// The number of records that have yet to be validated.
	ValidationPendingRecords *int64 `type:"long"`

	// The validation state of the table.
	//
	// This parameter can have the following values:
	//
	//    * Not enabled – Validation isn't enabled for the table in the migration
	//    task.
	//
	//    * Pending records – Some records in the table are waiting for validation.
	//
	//    * Mismatched records – Some records in the table don't match between
	//    the source and target.
	//
	//    * Suspended records – Some records in the table couldn't be validated.
	//
	//    * No primary key –The table couldn't be validated because it has no
	//    primary key.
	//
	//    * Table error – The table wasn't validated because it's in an error
	//    state and some data wasn't migrated.
	//
	//    * Validated – All rows in the table are validated. If the table is updated,
	//    the status can change from Validated.
	//
	//    * Error – The table couldn't be validated because of an unexpected error.
	//
	//    * Pending validation – The table is waiting validation.
	//
	//    * Preparing table – Preparing the table enabled in the migration task
	//    for validation.
	//
	//    * Pending revalidation – All rows in the table are pending validation
	//    after the table was updated.
	ValidationState *string `type:"string"`

	// Additional details about the state of validation.
	ValidationStateDetails *string `type:"string"`

	// The number of records that couldn't be validated.
	ValidationSuspendedRecords *int64 `type:"long"`
}

// String returns the string representation
func (s TableStatistics) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableStatistics) GoString() string {
	return s.String()
}

// SetDdls sets the Ddls field's value.
func (s *TableStatistics) SetDdls(v int64) *TableStatistics {
	s.Ddls = &v
	return s
}

// SetDeletes sets the Deletes field's value.
func (s *TableStatistics) SetDeletes(v int64) *TableStatistics {
	s.Deletes = &v
	return s
}

// SetFullLoadCondtnlChkFailedRows sets the FullLoadCondtnlChkFailedRows field's value.
func (s *TableStatistics) SetFullLoadCondtnlChkFailedRows(v int64) *TableStatistics {
	s.FullLoadCondtnlChkFailedRows = &v
	return s
}

// SetFullLoadEndTime sets the FullLoadEndTime field's value.
func (s *TableStatistics) SetFullLoadEndTime(v time.Time) *TableStatistics {
	s.FullLoadEndTime = &v
	return s
}

// SetFullLoadErrorRows sets the FullLoadErrorRows field's value.
func (s *TableStatistics) SetFullLoadErrorRows(v int64) *TableStatistics {
	s.FullLoadErrorRows = &v
	return s
}

// SetFullLoadReloaded sets the FullLoadReloaded field's value.
func (s *TableStatistics) SetFullLoadReloaded(v bool) *TableStatistics {
	s.FullLoadReloaded = &v
	return s
}

// SetFullLoadRows sets the FullLoadRows field's value.
func (s *TableStatistics) SetFullLoadRows(v int64) *TableStatistics {
	s.FullLoadRows = &v
	return s
}

// SetFullLoadStartTime sets the FullLoadStartTime field's value.
func (s *TableStatistics) SetFullLoadStartTime(v time.Time) *TableStatistics {
	s.FullLoadStartTime = &v
	return s
}

// SetInserts sets the Inserts field's value.
func (s *TableStatistics) SetInserts(v int64) *TableStatistics {
	s.Inserts = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *TableStatistics) SetLastUpdateTime(v time.Time) *TableStatistics {
	s.LastUpdateTime = &v
	return s
}

// SetSchemaName sets the SchemaName field's value.
func (s *TableStatistics) SetSchemaName(v string) *TableStatistics {
	s.SchemaName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TableStatistics) SetTableName(v string) *TableStatistics {
	s.TableName = &v
	return s
}

// SetTableState sets the TableState field's value.
func (s *TableStatistics) SetTableState(v string) *TableStatistics {
	s.TableState = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *TableStatistics) SetUpdates(v int64) *TableStatistics {
	s.Updates = &v
	return s
}

// SetValidationFailedRecords sets the ValidationFailedRecords field's value.
func (s *TableStatistics) SetValidationFailedRecords(v int64) *TableStatistics {
	s.ValidationFailedRecords = &v
	return s
}

// SetValidationPendingRecords sets the ValidationPendingRecords field's value.
func (s *TableStatistics) SetValidationPendingRecords(v int64) *TableStatistics {
	s.ValidationPendingRecords = &v
	return s
}

// SetValidationState sets the ValidationState field's value.
func (s *TableStatistics) SetValidationState(v string) *TableStatistics {
	s.ValidationState = &v
	return s
}

// SetValidationStateDetails sets the ValidationStateDetails field's value.
func (s *TableStatistics) SetValidationStateDetails(v string) *TableStatistics {
	s.ValidationStateDetails = &v
	return s
}

// SetValidationSuspendedRecords sets the ValidationSuspendedRecords field's value.
func (s *TableStatistics) SetValidationSuspendedRecords(v int64) *TableStatistics {
	s.ValidationSuspendedRecords = &v
	return s
}

// Provides the name of the schema and table to be reloaded.
type TableToReload struct {
	_ struct{} `type:"structure"`

	// The schema name of the table to be reloaded.
	//
	// SchemaName is a required field
	SchemaName *string `type:"string" required:"true"`

	// The table name of the table to be reloaded.
	//
	// TableName is a required field
	TableName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TableToReload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TableToReload) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TableToReload) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TableToReload"}
	if s.SchemaName == nil {
		invalidParams.Add(request.NewErrParamRequired("SchemaName"))
	}
	if s.TableName == nil {
		invalidParams.Add(request.NewErrParamRequired("TableName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSchemaName sets the SchemaName field's value.
func (s *TableToReload) SetSchemaName(v string) *TableToReload {
	s.SchemaName = &v
	return s
}

// SetTableName sets the TableName field's value.
func (s *TableToReload) SetTableName(v string) *TableToReload {
	s.TableName = &v
	return s
}

// A user-defined key-value pair that describes metadata added to an DMS resource
// and that is used by operations such as the following:
//
//    * AddTagsToResource
//
//    * ListTagsForResource
//
//    * RemoveTagsFromResource
type Tag struct {
	_ struct{} `type:"structure"`

	// A key is the required name of the tag. The string value can be 1-128 Unicode
	// characters in length and can't be prefixed with "aws:" or "dms:". The string
	// can only contain only the set of Unicode letters, digits, white-space, '_',
	// '.', '/', '=', '+', '-' (Java regular expressions: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Key *string `type:"string"`

	// A value is the optional value of the tag. The string value can be 1-256 Unicode
	// characters in length and can't be prefixed with "aws:" or "dms:". The string
	// can only contain only the set of Unicode letters, digits, white-space, '_',
	// '.', '/', '=', '+', '-' (Java regular expressions: "^([\\p{L}\\p{Z}\\p{N}_.:/=+\\-]*)$").
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TestConnectionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) string that uniquely identifies the endpoint.
	//
	// EndpointArn is a required field
	EndpointArn *string `type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the replication instance.
	//
	// ReplicationInstanceArn is a required field
	ReplicationInstanceArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s TestConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestConnectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestConnectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestConnectionInput"}
	if s.EndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointArn"))
	}
	if s.ReplicationInstanceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ReplicationInstanceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *TestConnectionInput) SetEndpointArn(v string) *TestConnectionInput {
	s.EndpointArn = &v
	return s
}

// SetReplicationInstanceArn sets the ReplicationInstanceArn field's value.
func (s *TestConnectionInput) SetReplicationInstanceArn(v string) *TestConnectionInput {
	s.ReplicationInstanceArn = &v
	return s
}

type TestConnectionOutput struct {
	_ struct{} `type:"structure"`

	// The connection tested.
	Connection *Connection `type:"structure"`
}

// String returns the string representation
func (s TestConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TestConnectionOutput) GoString() string {
	return s.String()
}

// SetConnection sets the Connection field's value.
func (s *TestConnectionOutput) SetConnection(v *Connection) *TestConnectionOutput {
	s.Connection = v
	return s
}

// An upgrade dependency is preventing the database migration.
type UpgradeDependencyFailureFault struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s UpgradeDependencyFailureFault) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpgradeDependencyFailureFault) GoString() string {
	return s.String()
}

func newErrorUpgradeDependencyFailureFault(v protocol.ResponseMetadata) error {
	return &UpgradeDependencyFailureFault{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UpgradeDependencyFailureFault) Code() string {
	return "UpgradeDependencyFailureFault"
}

// Message returns the exception's message.
func (s *UpgradeDependencyFailureFault) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UpgradeDependencyFailureFault) OrigErr() error {
	return nil
}

func (s *UpgradeDependencyFailureFault) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UpgradeDependencyFailureFault) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UpgradeDependencyFailureFault) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the status of a security group associated with the virtual private
// cloud (VPC) hosting your replication and DB instances.
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `type:"string"`

	// The VPC security group ID.
	VpcSecurityGroupId *string `type:"string"`
}

// String returns the string representation
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VpcSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VpcSecurityGroupMembership) SetStatus(v string) *VpcSecurityGroupMembership {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *VpcSecurityGroupMembership) SetVpcSecurityGroupId(v string) *VpcSecurityGroupMembership {
	s.VpcSecurityGroupId = &v
	return s
}

const (
	// AuthMechanismValueDefault is a AuthMechanismValue enum value
	AuthMechanismValueDefault = "default"

	// AuthMechanismValueMongodbCr is a AuthMechanismValue enum value
	AuthMechanismValueMongodbCr = "mongodb_cr"

	// AuthMechanismValueScramSha1 is a AuthMechanismValue enum value
	AuthMechanismValueScramSha1 = "scram_sha_1"
)

// AuthMechanismValue_Values returns all elements of the AuthMechanismValue enum
func AuthMechanismValue_Values() []string {
	return []string{
		AuthMechanismValueDefault,
		AuthMechanismValueMongodbCr,
		AuthMechanismValueScramSha1,
	}
}

const (
	// AuthTypeValueNo is a AuthTypeValue enum value
	AuthTypeValueNo = "no"

	// AuthTypeValuePassword is a AuthTypeValue enum value
	AuthTypeValuePassword = "password"
)

// AuthTypeValue_Values returns all elements of the AuthTypeValue enum
func AuthTypeValue_Values() []string {
	return []string{
		AuthTypeValueNo,
		AuthTypeValuePassword,
	}
}

const (
	// CharLengthSemanticsDefault is a CharLengthSemantics enum value
	CharLengthSemanticsDefault = "default"

	// CharLengthSemanticsChar is a CharLengthSemantics enum value
	CharLengthSemanticsChar = "char"

	// CharLengthSemanticsByte is a CharLengthSemantics enum value
	CharLengthSemanticsByte = "byte"
)

// CharLengthSemantics_Values returns all elements of the CharLengthSemantics enum
func CharLengthSemantics_Values() []string {
	return []string{
		CharLengthSemanticsDefault,
		CharLengthSemanticsChar,
		CharLengthSemanticsByte,
	}
}

const (
	// CompressionTypeValueNone is a CompressionTypeValue enum value
	CompressionTypeValueNone = "none"

	// CompressionTypeValueGzip is a CompressionTypeValue enum value
	CompressionTypeValueGzip = "gzip"
)

// CompressionTypeValue_Values returns all elements of the CompressionTypeValue enum
func CompressionTypeValue_Values() []string {
	return []string{
		CompressionTypeValueNone,
		CompressionTypeValueGzip,
	}
}

const (
	// DataFormatValueCsv is a DataFormatValue enum value
	DataFormatValueCsv = "csv"

	// DataFormatValueParquet is a DataFormatValue enum value
	DataFormatValueParquet = "parquet"
)

// DataFormatValue_Values returns all elements of the DataFormatValue enum
func DataFormatValue_Values() []string {
	return []string{
		DataFormatValueCsv,
		DataFormatValueParquet,
	}
}

const (
	// DatePartitionDelimiterValueSlash is a DatePartitionDelimiterValue enum value
	DatePartitionDelimiterValueSlash = "SLASH"

	// DatePartitionDelimiterValueUnderscore is a DatePartitionDelimiterValue enum value
	DatePartitionDelimiterValueUnderscore = "UNDERSCORE"

	// DatePartitionDelimiterValueDash is a DatePartitionDelimiterValue enum value
	DatePartitionDelimiterValueDash = "DASH"

	// DatePartitionDelimiterValueNone is a DatePartitionDelimiterValue enum value
	DatePartitionDelimiterValueNone = "NONE"
)

// DatePartitionDelimiterValue_Values returns all elements of the DatePartitionDelimiterValue enum
func DatePartitionDelimiterValue_Values() []string {
	return []string{
		DatePartitionDelimiterValueSlash,
		DatePartitionDelimiterValueUnderscore,
		DatePartitionDelimiterValueDash,
		DatePartitionDelimiterValueNone,
	}
}

const (
	// DatePartitionSequenceValueYyyymmdd is a DatePartitionSequenceValue enum value
	DatePartitionSequenceValueYyyymmdd = "YYYYMMDD"

	// DatePartitionSequenceValueYyyymmddhh is a DatePartitionSequenceValue enum value
	DatePartitionSequenceValueYyyymmddhh = "YYYYMMDDHH"

	// DatePartitionSequenceValueYyyymm is a DatePartitionSequenceValue enum value
	DatePartitionSequenceValueYyyymm = "YYYYMM"

	// DatePartitionSequenceValueMmyyyydd is a DatePartitionSequenceValue enum value
	DatePartitionSequenceValueMmyyyydd = "MMYYYYDD"

	// DatePartitionSequenceValueDdmmyyyy is a DatePartitionSequenceValue enum value
	DatePartitionSequenceValueDdmmyyyy = "DDMMYYYY"
)

// DatePartitionSequenceValue_Values returns all elements of the DatePartitionSequenceValue enum
func DatePartitionSequenceValue_Values() []string {
	return []string{
		DatePartitionSequenceValueYyyymmdd,
		DatePartitionSequenceValueYyyymmddhh,
		DatePartitionSequenceValueYyyymm,
		DatePartitionSequenceValueMmyyyydd,
		DatePartitionSequenceValueDdmmyyyy,
	}
}

const (
	// DmsSslModeValueNone is a DmsSslModeValue enum value
	DmsSslModeValueNone = "none"

	// DmsSslModeValueRequire is a DmsSslModeValue enum value
	DmsSslModeValueRequire = "require"

	// DmsSslModeValueVerifyCa is a DmsSslModeValue enum value
	DmsSslModeValueVerifyCa = "verify-ca"

	// DmsSslModeValueVerifyFull is a DmsSslModeValue enum value
	DmsSslModeValueVerifyFull = "verify-full"
)

// DmsSslModeValue_Values returns all elements of the DmsSslModeValue enum
func DmsSslModeValue_Values() []string {
	return []string{
		DmsSslModeValueNone,
		DmsSslModeValueRequire,
		DmsSslModeValueVerifyCa,
		DmsSslModeValueVerifyFull,
	}
}

const (
	// EncodingTypeValuePlain is a EncodingTypeValue enum value
	EncodingTypeValuePlain = "plain"

	// EncodingTypeValuePlainDictionary is a EncodingTypeValue enum value
	EncodingTypeValuePlainDictionary = "plain-dictionary"

	// EncodingTypeValueRleDictionary is a EncodingTypeValue enum value
	EncodingTypeValueRleDictionary = "rle-dictionary"
)

// EncodingTypeValue_Values returns all elements of the EncodingTypeValue enum
func EncodingTypeValue_Values() []string {
	return []string{
		EncodingTypeValuePlain,
		EncodingTypeValuePlainDictionary,
		EncodingTypeValueRleDictionary,
	}
}

const (
	// EncryptionModeValueSseS3 is a EncryptionModeValue enum value
	EncryptionModeValueSseS3 = "sse-s3"

	// EncryptionModeValueSseKms is a EncryptionModeValue enum value
	EncryptionModeValueSseKms = "sse-kms"
)

// EncryptionModeValue_Values returns all elements of the EncryptionModeValue enum
func EncryptionModeValue_Values() []string {
	return []string{
		EncryptionModeValueSseS3,
		EncryptionModeValueSseKms,
	}
}

const (
	// EndpointSettingTypeValueString is a EndpointSettingTypeValue enum value
	EndpointSettingTypeValueString = "string"

	// EndpointSettingTypeValueBoolean is a EndpointSettingTypeValue enum value
	EndpointSettingTypeValueBoolean = "boolean"

	// EndpointSettingTypeValueInteger is a EndpointSettingTypeValue enum value
	EndpointSettingTypeValueInteger = "integer"

	// EndpointSettingTypeValueEnum is a EndpointSettingTypeValue enum value
	EndpointSettingTypeValueEnum = "enum"
)

// EndpointSettingTypeValue_Values returns all elements of the EndpointSettingTypeValue enum
func EndpointSettingTypeValue_Values() []string {
	return []string{
		EndpointSettingTypeValueString,
		EndpointSettingTypeValueBoolean,
		EndpointSettingTypeValueInteger,
		EndpointSettingTypeValueEnum,
	}
}

const (
	// KafkaSecurityProtocolPlaintext is a KafkaSecurityProtocol enum value
	KafkaSecurityProtocolPlaintext = "plaintext"

	// KafkaSecurityProtocolSslAuthentication is a KafkaSecurityProtocol enum value
	KafkaSecurityProtocolSslAuthentication = "ssl-authentication"

	// KafkaSecurityProtocolSslEncryption is a KafkaSecurityProtocol enum value
	KafkaSecurityProtocolSslEncryption = "ssl-encryption"

	// KafkaSecurityProtocolSaslSsl is a KafkaSecurityProtocol enum value
	KafkaSecurityProtocolSaslSsl = "sasl-ssl"
)

// KafkaSecurityProtocol_Values returns all elements of the KafkaSecurityProtocol enum
func KafkaSecurityProtocol_Values() []string {
	return []string{
		KafkaSecurityProtocolPlaintext,
		KafkaSecurityProtocolSslAuthentication,
		KafkaSecurityProtocolSslEncryption,
		KafkaSecurityProtocolSaslSsl,
	}
}

const (
	// MessageFormatValueJson is a MessageFormatValue enum value
	MessageFormatValueJson = "json"

	// MessageFormatValueJsonUnformatted is a MessageFormatValue enum value
	MessageFormatValueJsonUnformatted = "json-unformatted"
)

// MessageFormatValue_Values returns all elements of the MessageFormatValue enum
func MessageFormatValue_Values() []string {
	return []string{
		MessageFormatValueJson,
		MessageFormatValueJsonUnformatted,
	}
}

const (
	// MigrationTypeValueFullLoad is a MigrationTypeValue enum value
	MigrationTypeValueFullLoad = "full-load"

	// MigrationTypeValueCdc is a MigrationTypeValue enum value
	MigrationTypeValueCdc = "cdc"

	// MigrationTypeValueFullLoadAndCdc is a MigrationTypeValue enum value
	MigrationTypeValueFullLoadAndCdc = "full-load-and-cdc"
)

// MigrationTypeValue_Values returns all elements of the MigrationTypeValue enum
func MigrationTypeValue_Values() []string {
	return []string{
		MigrationTypeValueFullLoad,
		MigrationTypeValueCdc,
		MigrationTypeValueFullLoadAndCdc,
	}
}

const (
	// NestingLevelValueNone is a NestingLevelValue enum value
	NestingLevelValueNone = "none"

	// NestingLevelValueOne is a NestingLevelValue enum value
	NestingLevelValueOne = "one"
)

// NestingLevelValue_Values returns all elements of the NestingLevelValue enum
func NestingLevelValue_Values() []string {
	return []string{
		NestingLevelValueNone,
		NestingLevelValueOne,
	}
}

const (
	// ParquetVersionValueParquet10 is a ParquetVersionValue enum value
	ParquetVersionValueParquet10 = "parquet-1-0"

	// ParquetVersionValueParquet20 is a ParquetVersionValue enum value
	ParquetVersionValueParquet20 = "parquet-2-0"
)

// ParquetVersionValue_Values returns all elements of the ParquetVersionValue enum
func ParquetVersionValue_Values() []string {
	return []string{
		ParquetVersionValueParquet10,
		ParquetVersionValueParquet20,
	}
}

const (
	// PluginNameValueNoPreference is a PluginNameValue enum value
	PluginNameValueNoPreference = "no-preference"

	// PluginNameValueTestDecoding is a PluginNameValue enum value
	PluginNameValueTestDecoding = "test-decoding"

	// PluginNameValuePglogical is a PluginNameValue enum value
	PluginNameValuePglogical = "pglogical"
)

// PluginNameValue_Values returns all elements of the PluginNameValue enum
func PluginNameValue_Values() []string {
	return []string{
		PluginNameValueNoPreference,
		PluginNameValueTestDecoding,
		PluginNameValuePglogical,
	}
}

const (
	// RefreshSchemasStatusTypeValueSuccessful is a RefreshSchemasStatusTypeValue enum value
	RefreshSchemasStatusTypeValueSuccessful = "successful"

	// RefreshSchemasStatusTypeValueFailed is a RefreshSchemasStatusTypeValue enum value
	RefreshSchemasStatusTypeValueFailed = "failed"

	// RefreshSchemasStatusTypeValueRefreshing is a RefreshSchemasStatusTypeValue enum value
	RefreshSchemasStatusTypeValueRefreshing = "refreshing"
)

// RefreshSchemasStatusTypeValue_Values returns all elements of the RefreshSchemasStatusTypeValue enum
func RefreshSchemasStatusTypeValue_Values() []string {
	return []string{
		RefreshSchemasStatusTypeValueSuccessful,
		RefreshSchemasStatusTypeValueFailed,
		RefreshSchemasStatusTypeValueRefreshing,
	}
}

const (
	// ReleaseStatusValuesBeta is a ReleaseStatusValues enum value
	ReleaseStatusValuesBeta = "beta"
)

// ReleaseStatusValues_Values returns all elements of the ReleaseStatusValues enum
func ReleaseStatusValues_Values() []string {
	return []string{
		ReleaseStatusValuesBeta,
	}
}

const (
	// ReloadOptionValueDataReload is a ReloadOptionValue enum value
	ReloadOptionValueDataReload = "data-reload"

	// ReloadOptionValueValidateOnly is a ReloadOptionValue enum value
	ReloadOptionValueValidateOnly = "validate-only"
)

// ReloadOptionValue_Values returns all elements of the ReloadOptionValue enum
func ReloadOptionValue_Values() []string {
	return []string{
		ReloadOptionValueDataReload,
		ReloadOptionValueValidateOnly,
	}
}

const (
	// ReplicationEndpointTypeValueSource is a ReplicationEndpointTypeValue enum value
	ReplicationEndpointTypeValueSource = "source"

	// ReplicationEndpointTypeValueTarget is a ReplicationEndpointTypeValue enum value
	ReplicationEndpointTypeValueTarget = "target"
)

// ReplicationEndpointTypeValue_Values returns all elements of the ReplicationEndpointTypeValue enum
func ReplicationEndpointTypeValue_Values() []string {
	return []string{
		ReplicationEndpointTypeValueSource,
		ReplicationEndpointTypeValueTarget,
	}
}

const (
	// SafeguardPolicyRelyOnSqlServerReplicationAgent is a SafeguardPolicy enum value
	SafeguardPolicyRelyOnSqlServerReplicationAgent = "rely-on-sql-server-replication-agent"

	// SafeguardPolicyExclusiveAutomaticTruncation is a SafeguardPolicy enum value
	SafeguardPolicyExclusiveAutomaticTruncation = "exclusive-automatic-truncation"

	// SafeguardPolicySharedAutomaticTruncation is a SafeguardPolicy enum value
	SafeguardPolicySharedAutomaticTruncation = "shared-automatic-truncation"
)

// SafeguardPolicy_Values returns all elements of the SafeguardPolicy enum
func SafeguardPolicy_Values() []string {
	return []string{
		SafeguardPolicyRelyOnSqlServerReplicationAgent,
		SafeguardPolicyExclusiveAutomaticTruncation,
		SafeguardPolicySharedAutomaticTruncation,
	}
}

const (
	// SourceTypeReplicationInstance is a SourceType enum value
	SourceTypeReplicationInstance = "replication-instance"
)

// SourceType_Values returns all elements of the SourceType enum
func SourceType_Values() []string {
	return []string{
		SourceTypeReplicationInstance,
	}
}

const (
	// StartReplicationTaskTypeValueStartReplication is a StartReplicationTaskTypeValue enum value
	StartReplicationTaskTypeValueStartReplication = "start-replication"

	// StartReplicationTaskTypeValueResumeProcessing is a StartReplicationTaskTypeValue enum value
	StartReplicationTaskTypeValueResumeProcessing = "resume-processing"

	// StartReplicationTaskTypeValueReloadTarget is a StartReplicationTaskTypeValue enum value
	StartReplicationTaskTypeValueReloadTarget = "reload-target"
)

// StartReplicationTaskTypeValue_Values returns all elements of the StartReplicationTaskTypeValue enum
func StartReplicationTaskTypeValue_Values() []string {
	return []string{
		StartReplicationTaskTypeValueStartReplication,
		StartReplicationTaskTypeValueResumeProcessing,
		StartReplicationTaskTypeValueReloadTarget,
	}
}

const (
	// TargetDbTypeSpecificDatabase is a TargetDbType enum value
	TargetDbTypeSpecificDatabase = "specific-database"

	// TargetDbTypeMultipleDatabases is a TargetDbType enum value
	TargetDbTypeMultipleDatabases = "multiple-databases"
)

// TargetDbType_Values returns all elements of the TargetDbType enum
func TargetDbType_Values() []string {
	return []string{
		TargetDbTypeSpecificDatabase,
		TargetDbTypeMultipleDatabases,
	}
}
