// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicediscovery

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateHttpNamespace = "CreateHttpNamespace"

// CreateHttpNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateHttpNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHttpNamespace for more information on using the CreateHttpNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateHttpNamespaceRequest method.
//    req, resp := client.CreateHttpNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateHttpNamespace
func (c *ServiceDiscovery) CreateHttpNamespaceRequest(input *CreateHttpNamespaceInput) (req *request.Request, output *CreateHttpNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreateHttpNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateHttpNamespaceInput{}
	}

	output = &CreateHttpNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHttpNamespace API operation for AWS Cloud Map.
//
// Creates an HTTP namespace. Service instances that you register using an HTTP
// namespace can be discovered using a DiscoverInstances request but can't be
// discovered using DNS.
//
// For the current quota on the number of namespaces that you can create using
// the same AWS account, see AWS Cloud Map quotas (https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
// in the AWS Cloud Map Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation CreateHttpNamespace for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * NamespaceAlreadyExists
//   The namespace that you're trying to create already exists.
//
//   * ResourceLimitExceeded
//   The resource can't be created because you've reached the quota on the number
//   of resources.
//
//   * DuplicateRequest
//   The operation is already in progress.
//
//   * TooManyTagsException
//   The list of tags on the resource is over the quota. The maximum number of
//   tags that can be applied to a resource is 50.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateHttpNamespace
func (c *ServiceDiscovery) CreateHttpNamespace(input *CreateHttpNamespaceInput) (*CreateHttpNamespaceOutput, error) {
	req, out := c.CreateHttpNamespaceRequest(input)
	return out, req.Send()
}

// CreateHttpNamespaceWithContext is the same as CreateHttpNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHttpNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) CreateHttpNamespaceWithContext(ctx aws.Context, input *CreateHttpNamespaceInput, opts ...request.Option) (*CreateHttpNamespaceOutput, error) {
	req, out := c.CreateHttpNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePrivateDnsNamespace = "CreatePrivateDnsNamespace"

// CreatePrivateDnsNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePrivateDnsNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePrivateDnsNamespace for more information on using the CreatePrivateDnsNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePrivateDnsNamespaceRequest method.
//    req, resp := client.CreatePrivateDnsNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespace
func (c *ServiceDiscovery) CreatePrivateDnsNamespaceRequest(input *CreatePrivateDnsNamespaceInput) (req *request.Request, output *CreatePrivateDnsNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreatePrivateDnsNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePrivateDnsNamespaceInput{}
	}

	output = &CreatePrivateDnsNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePrivateDnsNamespace API operation for AWS Cloud Map.
//
// Creates a private namespace based on DNS, which will be visible only inside
// a specified Amazon VPC. The namespace defines your service naming scheme.
// For example, if you name your namespace example.com and name your service
// backend, the resulting DNS name for the service will be backend.example.com.
// For the current quota on the number of namespaces that you can create using
// the same AWS account, see AWS Cloud Map Limits (https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
// in the AWS Cloud Map Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation CreatePrivateDnsNamespace for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * NamespaceAlreadyExists
//   The namespace that you're trying to create already exists.
//
//   * ResourceLimitExceeded
//   The resource can't be created because you've reached the quota on the number
//   of resources.
//
//   * DuplicateRequest
//   The operation is already in progress.
//
//   * TooManyTagsException
//   The list of tags on the resource is over the quota. The maximum number of
//   tags that can be applied to a resource is 50.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespace
func (c *ServiceDiscovery) CreatePrivateDnsNamespace(input *CreatePrivateDnsNamespaceInput) (*CreatePrivateDnsNamespaceOutput, error) {
	req, out := c.CreatePrivateDnsNamespaceRequest(input)
	return out, req.Send()
}

// CreatePrivateDnsNamespaceWithContext is the same as CreatePrivateDnsNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePrivateDnsNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) CreatePrivateDnsNamespaceWithContext(ctx aws.Context, input *CreatePrivateDnsNamespaceInput, opts ...request.Option) (*CreatePrivateDnsNamespaceOutput, error) {
	req, out := c.CreatePrivateDnsNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePublicDnsNamespace = "CreatePublicDnsNamespace"

// CreatePublicDnsNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreatePublicDnsNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreatePublicDnsNamespace for more information on using the CreatePublicDnsNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreatePublicDnsNamespaceRequest method.
//    req, resp := client.CreatePublicDnsNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespace
func (c *ServiceDiscovery) CreatePublicDnsNamespaceRequest(input *CreatePublicDnsNamespaceInput) (req *request.Request, output *CreatePublicDnsNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreatePublicDnsNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePublicDnsNamespaceInput{}
	}

	output = &CreatePublicDnsNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreatePublicDnsNamespace API operation for AWS Cloud Map.
//
// Creates a public namespace based on DNS, which will be visible on the internet.
// The namespace defines your service naming scheme. For example, if you name
// your namespace example.com and name your service backend, the resulting DNS
// name for the service will be backend.example.com. For the current quota on
// the number of namespaces that you can create using the same AWS account,
// see AWS Cloud Map Limits (https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
// in the AWS Cloud Map Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation CreatePublicDnsNamespace for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * NamespaceAlreadyExists
//   The namespace that you're trying to create already exists.
//
//   * ResourceLimitExceeded
//   The resource can't be created because you've reached the quota on the number
//   of resources.
//
//   * DuplicateRequest
//   The operation is already in progress.
//
//   * TooManyTagsException
//   The list of tags on the resource is over the quota. The maximum number of
//   tags that can be applied to a resource is 50.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespace
func (c *ServiceDiscovery) CreatePublicDnsNamespace(input *CreatePublicDnsNamespaceInput) (*CreatePublicDnsNamespaceOutput, error) {
	req, out := c.CreatePublicDnsNamespaceRequest(input)
	return out, req.Send()
}

// CreatePublicDnsNamespaceWithContext is the same as CreatePublicDnsNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePublicDnsNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) CreatePublicDnsNamespaceWithContext(ctx aws.Context, input *CreatePublicDnsNamespaceInput, opts ...request.Option) (*CreatePublicDnsNamespaceOutput, error) {
	req, out := c.CreatePublicDnsNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateService = "CreateService"

// CreateServiceRequest generates a "aws/request.Request" representing the
// client's request for the CreateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateService for more information on using the CreateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateServiceRequest method.
//    req, resp := client.CreateServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateService
func (c *ServiceDiscovery) CreateServiceRequest(input *CreateServiceInput) (req *request.Request, output *CreateServiceOutput) {
	op := &request.Operation{
		Name:       opCreateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceInput{}
	}

	output = &CreateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateService API operation for AWS Cloud Map.
//
// Creates a service, which defines the configuration for the following entities:
//
//    * For public and private DNS namespaces, one of the following combinations
//    of DNS records in Amazon Route 53: A AAAA A and AAAA SRV CNAME
//
//    * Optionally, a health check
//
// After you create the service, you can submit a RegisterInstance (https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html)
// request, and AWS Cloud Map uses the values in the configuration to create
// the specified entities.
//
// For the current quota on the number of instances that you can register using
// the same namespace and using the same service, see AWS Cloud Map Limits (https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
// in the AWS Cloud Map Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation CreateService for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * ResourceLimitExceeded
//   The resource can't be created because you've reached the quota on the number
//   of resources.
//
//   * NamespaceNotFound
//   No namespace exists with the specified ID.
//
//   * ServiceAlreadyExists
//   The service can't be created because a service with the same name already
//   exists.
//
//   * TooManyTagsException
//   The list of tags on the resource is over the quota. The maximum number of
//   tags that can be applied to a resource is 50.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateService
func (c *ServiceDiscovery) CreateService(input *CreateServiceInput) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	return out, req.Send()
}

// CreateServiceWithContext is the same as CreateService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) CreateServiceWithContext(ctx aws.Context, input *CreateServiceInput, opts ...request.Option) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNamespace = "DeleteNamespace"

// DeleteNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNamespace for more information on using the DeleteNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteNamespaceRequest method.
//    req, resp := client.DeleteNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteNamespace
func (c *ServiceDiscovery) DeleteNamespaceRequest(input *DeleteNamespaceInput) (req *request.Request, output *DeleteNamespaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNamespaceInput{}
	}

	output = &DeleteNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNamespace API operation for AWS Cloud Map.
//
// Deletes a namespace from the current account. If the namespace still contains
// one or more services, the request fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation DeleteNamespace for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * NamespaceNotFound
//   No namespace exists with the specified ID.
//
//   * ResourceInUse
//   The specified resource can't be deleted because it contains other resources.
//   For example, you can't delete a service that contains any instances.
//
//   * DuplicateRequest
//   The operation is already in progress.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteNamespace
func (c *ServiceDiscovery) DeleteNamespace(input *DeleteNamespaceInput) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	return out, req.Send()
}

// DeleteNamespaceWithContext is the same as DeleteNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) DeleteNamespaceWithContext(ctx aws.Context, input *DeleteNamespaceInput, opts ...request.Option) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteService = "DeleteService"

// DeleteServiceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteService for more information on using the DeleteService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServiceRequest method.
//    req, resp := client.DeleteServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteService
func (c *ServiceDiscovery) DeleteServiceRequest(input *DeleteServiceInput) (req *request.Request, output *DeleteServiceOutput) {
	op := &request.Operation{
		Name:       opDeleteService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServiceInput{}
	}

	output = &DeleteServiceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteService API operation for AWS Cloud Map.
//
// Deletes a specified service. If the service still contains one or more registered
// instances, the request fails.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation DeleteService for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * ServiceNotFound
//   No service exists with the specified ID.
//
//   * ResourceInUse
//   The specified resource can't be deleted because it contains other resources.
//   For example, you can't delete a service that contains any instances.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteService
func (c *ServiceDiscovery) DeleteService(input *DeleteServiceInput) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	return out, req.Send()
}

// DeleteServiceWithContext is the same as DeleteService with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) DeleteServiceWithContext(ctx aws.Context, input *DeleteServiceInput, opts ...request.Option) (*DeleteServiceOutput, error) {
	req, out := c.DeleteServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterInstance = "DeregisterInstance"

// DeregisterInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterInstance for more information on using the DeregisterInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterInstanceRequest method.
//    req, resp := client.DeregisterInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeregisterInstance
func (c *ServiceDiscovery) DeregisterInstanceRequest(input *DeregisterInstanceInput) (req *request.Request, output *DeregisterInstanceOutput) {
	op := &request.Operation{
		Name:       opDeregisterInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterInstanceInput{}
	}

	output = &DeregisterInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeregisterInstance API operation for AWS Cloud Map.
//
// Deletes the Amazon Route 53 DNS records and health check, if any, that AWS
// Cloud Map created for the specified instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation DeregisterInstance for usage and error information.
//
// Returned Error Types:
//   * DuplicateRequest
//   The operation is already in progress.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * InstanceNotFound
//   No instance exists with the specified ID, or the instance was recently registered,
//   and information about the instance hasn't propagated yet.
//
//   * ResourceInUse
//   The specified resource can't be deleted because it contains other resources.
//   For example, you can't delete a service that contains any instances.
//
//   * ServiceNotFound
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeregisterInstance
func (c *ServiceDiscovery) DeregisterInstance(input *DeregisterInstanceInput) (*DeregisterInstanceOutput, error) {
	req, out := c.DeregisterInstanceRequest(input)
	return out, req.Send()
}

// DeregisterInstanceWithContext is the same as DeregisterInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) DeregisterInstanceWithContext(ctx aws.Context, input *DeregisterInstanceInput, opts ...request.Option) (*DeregisterInstanceOutput, error) {
	req, out := c.DeregisterInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDiscoverInstances = "DiscoverInstances"

// DiscoverInstancesRequest generates a "aws/request.Request" representing the
// client's request for the DiscoverInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DiscoverInstances for more information on using the DiscoverInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DiscoverInstancesRequest method.
//    req, resp := client.DiscoverInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DiscoverInstances
func (c *ServiceDiscovery) DiscoverInstancesRequest(input *DiscoverInstancesInput) (req *request.Request, output *DiscoverInstancesOutput) {
	op := &request.Operation{
		Name:       opDiscoverInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DiscoverInstancesInput{}
	}

	output = &DiscoverInstancesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Build.PushBackNamed(protocol.NewHostPrefixHandler("data-", nil))
	req.Handlers.Build.PushBackNamed(protocol.ValidateEndpointHostHandler)
	return
}

// DiscoverInstances API operation for AWS Cloud Map.
//
// Discovers registered instances for a specified namespace and service. You
// can use DiscoverInstances to discover instances for any type of namespace.
// For public and private DNS namespaces, you can also use DNS queries to discover
// instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation DiscoverInstances for usage and error information.
//
// Returned Error Types:
//   * ServiceNotFound
//   No service exists with the specified ID.
//
//   * NamespaceNotFound
//   No namespace exists with the specified ID.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * RequestLimitExceeded
//   The operation can't be completed because you've reached the quota for the
//   number of requests. For more information, see AWS Cloud Map API request throttling
//   quota (https://docs.aws.amazon.com/cloud-map/latest/dg/throttling.html) in
//   the AWS Cloud Map Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DiscoverInstances
func (c *ServiceDiscovery) DiscoverInstances(input *DiscoverInstancesInput) (*DiscoverInstancesOutput, error) {
	req, out := c.DiscoverInstancesRequest(input)
	return out, req.Send()
}

// DiscoverInstancesWithContext is the same as DiscoverInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DiscoverInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) DiscoverInstancesWithContext(ctx aws.Context, input *DiscoverInstancesInput, opts ...request.Option) (*DiscoverInstancesOutput, error) {
	req, out := c.DiscoverInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstance = "GetInstance"

// GetInstanceRequest generates a "aws/request.Request" representing the
// client's request for the GetInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstance for more information on using the GetInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstanceRequest method.
//    req, resp := client.GetInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstance
func (c *ServiceDiscovery) GetInstanceRequest(input *GetInstanceInput) (req *request.Request, output *GetInstanceOutput) {
	op := &request.Operation{
		Name:       opGetInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetInstanceInput{}
	}

	output = &GetInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstance API operation for AWS Cloud Map.
//
// Gets information about a specified instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation GetInstance for usage and error information.
//
// Returned Error Types:
//   * InstanceNotFound
//   No instance exists with the specified ID, or the instance was recently registered,
//   and information about the instance hasn't propagated yet.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * ServiceNotFound
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstance
func (c *ServiceDiscovery) GetInstance(input *GetInstanceInput) (*GetInstanceOutput, error) {
	req, out := c.GetInstanceRequest(input)
	return out, req.Send()
}

// GetInstanceWithContext is the same as GetInstance with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetInstanceWithContext(ctx aws.Context, input *GetInstanceInput, opts ...request.Option) (*GetInstanceOutput, error) {
	req, out := c.GetInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetInstancesHealthStatus = "GetInstancesHealthStatus"

// GetInstancesHealthStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetInstancesHealthStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetInstancesHealthStatus for more information on using the GetInstancesHealthStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetInstancesHealthStatusRequest method.
//    req, resp := client.GetInstancesHealthStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatus
func (c *ServiceDiscovery) GetInstancesHealthStatusRequest(input *GetInstancesHealthStatusInput) (req *request.Request, output *GetInstancesHealthStatusOutput) {
	op := &request.Operation{
		Name:       opGetInstancesHealthStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetInstancesHealthStatusInput{}
	}

	output = &GetInstancesHealthStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetInstancesHealthStatus API operation for AWS Cloud Map.
//
// Gets the current health status (Healthy, Unhealthy, or Unknown) of one or
// more instances that are associated with a specified service.
//
// There is a brief delay between when you register an instance and when the
// health status for the instance is available.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation GetInstancesHealthStatus for usage and error information.
//
// Returned Error Types:
//   * InstanceNotFound
//   No instance exists with the specified ID, or the instance was recently registered,
//   and information about the instance hasn't propagated yet.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * ServiceNotFound
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatus
func (c *ServiceDiscovery) GetInstancesHealthStatus(input *GetInstancesHealthStatusInput) (*GetInstancesHealthStatusOutput, error) {
	req, out := c.GetInstancesHealthStatusRequest(input)
	return out, req.Send()
}

// GetInstancesHealthStatusWithContext is the same as GetInstancesHealthStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetInstancesHealthStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetInstancesHealthStatusWithContext(ctx aws.Context, input *GetInstancesHealthStatusInput, opts ...request.Option) (*GetInstancesHealthStatusOutput, error) {
	req, out := c.GetInstancesHealthStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetInstancesHealthStatusPages iterates over the pages of a GetInstancesHealthStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetInstancesHealthStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetInstancesHealthStatus operation.
//    pageNum := 0
//    err := client.GetInstancesHealthStatusPages(params,
//        func(page *servicediscovery.GetInstancesHealthStatusOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceDiscovery) GetInstancesHealthStatusPages(input *GetInstancesHealthStatusInput, fn func(*GetInstancesHealthStatusOutput, bool) bool) error {
	return c.GetInstancesHealthStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetInstancesHealthStatusPagesWithContext same as GetInstancesHealthStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetInstancesHealthStatusPagesWithContext(ctx aws.Context, input *GetInstancesHealthStatusInput, fn func(*GetInstancesHealthStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetInstancesHealthStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetInstancesHealthStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetInstancesHealthStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetNamespace = "GetNamespace"

// GetNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the GetNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNamespace for more information on using the GetNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetNamespaceRequest method.
//    req, resp := client.GetNamespaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetNamespace
func (c *ServiceDiscovery) GetNamespaceRequest(input *GetNamespaceInput) (req *request.Request, output *GetNamespaceOutput) {
	op := &request.Operation{
		Name:       opGetNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNamespaceInput{}
	}

	output = &GetNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNamespace API operation for AWS Cloud Map.
//
// Gets information about a namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation GetNamespace for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * NamespaceNotFound
//   No namespace exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetNamespace
func (c *ServiceDiscovery) GetNamespace(input *GetNamespaceInput) (*GetNamespaceOutput, error) {
	req, out := c.GetNamespaceRequest(input)
	return out, req.Send()
}

// GetNamespaceWithContext is the same as GetNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See GetNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetNamespaceWithContext(ctx aws.Context, input *GetNamespaceInput, opts ...request.Option) (*GetNamespaceOutput, error) {
	req, out := c.GetNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOperation = "GetOperation"

// GetOperationRequest generates a "aws/request.Request" representing the
// client's request for the GetOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOperation for more information on using the GetOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOperationRequest method.
//    req, resp := client.GetOperationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperation
func (c *ServiceDiscovery) GetOperationRequest(input *GetOperationInput) (req *request.Request, output *GetOperationOutput) {
	op := &request.Operation{
		Name:       opGetOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetOperationInput{}
	}

	output = &GetOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOperation API operation for AWS Cloud Map.
//
// Gets information about any operation that returns an operation ID in the
// response, such as a CreateService request.
//
// To get a list of operations that match specified criteria, see ListOperations
// (https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation GetOperation for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * OperationNotFound
//   No operation exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperation
func (c *ServiceDiscovery) GetOperation(input *GetOperationInput) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	return out, req.Send()
}

// GetOperationWithContext is the same as GetOperation with the addition of
// the ability to pass a context and additional request options.
//
// See GetOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetOperationWithContext(ctx aws.Context, input *GetOperationInput, opts ...request.Option) (*GetOperationOutput, error) {
	req, out := c.GetOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetService = "GetService"

// GetServiceRequest generates a "aws/request.Request" representing the
// client's request for the GetService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetService for more information on using the GetService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetServiceRequest method.
//    req, resp := client.GetServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetService
func (c *ServiceDiscovery) GetServiceRequest(input *GetServiceInput) (req *request.Request, output *GetServiceOutput) {
	op := &request.Operation{
		Name:       opGetService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceInput{}
	}

	output = &GetServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetService API operation for AWS Cloud Map.
//
// Gets the settings for a specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation GetService for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * ServiceNotFound
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetService
func (c *ServiceDiscovery) GetService(input *GetServiceInput) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	return out, req.Send()
}

// GetServiceWithContext is the same as GetService with the addition of
// the ability to pass a context and additional request options.
//
// See GetService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) GetServiceWithContext(ctx aws.Context, input *GetServiceInput, opts ...request.Option) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListInstances = "ListInstances"

// ListInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstances for more information on using the ListInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListInstancesRequest method.
//    req, resp := client.ListInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstances
func (c *ServiceDiscovery) ListInstancesRequest(input *ListInstancesInput) (req *request.Request, output *ListInstancesOutput) {
	op := &request.Operation{
		Name:       opListInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	output = &ListInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstances API operation for AWS Cloud Map.
//
// Lists summary information about the instances that you registered by using
// a specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation ListInstances for usage and error information.
//
// Returned Error Types:
//   * ServiceNotFound
//   No service exists with the specified ID.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstances
func (c *ServiceDiscovery) ListInstances(input *ListInstancesInput) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	return out, req.Send()
}

// ListInstancesWithContext is the same as ListInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListInstancesWithContext(ctx aws.Context, input *ListInstancesInput, opts ...request.Option) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstancesPages iterates over the pages of a ListInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListInstances operation.
//    pageNum := 0
//    err := client.ListInstancesPages(params,
//        func(page *servicediscovery.ListInstancesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceDiscovery) ListInstancesPages(input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool) error {
	return c.ListInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstancesPagesWithContext same as ListInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListInstancesPagesWithContext(ctx aws.Context, input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNamespaces = "ListNamespaces"

// ListNamespacesRequest generates a "aws/request.Request" representing the
// client's request for the ListNamespaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNamespaces for more information on using the ListNamespaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListNamespacesRequest method.
//    req, resp := client.ListNamespacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces
func (c *ServiceDiscovery) ListNamespacesRequest(input *ListNamespacesInput) (req *request.Request, output *ListNamespacesOutput) {
	op := &request.Operation{
		Name:       opListNamespaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNamespacesInput{}
	}

	output = &ListNamespacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNamespaces API operation for AWS Cloud Map.
//
// Lists summary information about the namespaces that were created by the current
// AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation ListNamespaces for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces
func (c *ServiceDiscovery) ListNamespaces(input *ListNamespacesInput) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	return out, req.Send()
}

// ListNamespacesWithContext is the same as ListNamespaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamespaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListNamespacesWithContext(ctx aws.Context, input *ListNamespacesInput, opts ...request.Option) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNamespacesPages iterates over the pages of a ListNamespaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNamespaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListNamespaces operation.
//    pageNum := 0
//    err := client.ListNamespacesPages(params,
//        func(page *servicediscovery.ListNamespacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceDiscovery) ListNamespacesPages(input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool) error {
	return c.ListNamespacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNamespacesPagesWithContext same as ListNamespacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListNamespacesPagesWithContext(ctx aws.Context, input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNamespacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNamespacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNamespacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListOperations = "ListOperations"

// ListOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOperations for more information on using the ListOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOperationsRequest method.
//    req, resp := client.ListOperationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations
func (c *ServiceDiscovery) ListOperationsRequest(input *ListOperationsInput) (req *request.Request, output *ListOperationsOutput) {
	op := &request.Operation{
		Name:       opListOperations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOperationsInput{}
	}

	output = &ListOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOperations API operation for AWS Cloud Map.
//
// Lists operations that match the criteria that you specify.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation ListOperations for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations
func (c *ServiceDiscovery) ListOperations(input *ListOperationsInput) (*ListOperationsOutput, error) {
	req, out := c.ListOperationsRequest(input)
	return out, req.Send()
}

// ListOperationsWithContext is the same as ListOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListOperationsWithContext(ctx aws.Context, input *ListOperationsInput, opts ...request.Option) (*ListOperationsOutput, error) {
	req, out := c.ListOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOperationsPages iterates over the pages of a ListOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOperations operation.
//    pageNum := 0
//    err := client.ListOperationsPages(params,
//        func(page *servicediscovery.ListOperationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceDiscovery) ListOperationsPages(input *ListOperationsInput, fn func(*ListOperationsOutput, bool) bool) error {
	return c.ListOperationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOperationsPagesWithContext same as ListOperationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListOperationsPagesWithContext(ctx aws.Context, input *ListOperationsInput, fn func(*ListOperationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOperationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOperationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOperationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListServices = "ListServices"

// ListServicesRequest generates a "aws/request.Request" representing the
// client's request for the ListServices operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListServices for more information on using the ListServices
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListServicesRequest method.
//    req, resp := client.ListServicesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices
func (c *ServiceDiscovery) ListServicesRequest(input *ListServicesInput) (req *request.Request, output *ListServicesOutput) {
	op := &request.Operation{
		Name:       opListServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListServicesInput{}
	}

	output = &ListServicesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListServices API operation for AWS Cloud Map.
//
// Lists summary information for all the services that are associated with one
// or more specified namespaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation ListServices for usage and error information.
//
// Returned Error Types:
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices
func (c *ServiceDiscovery) ListServices(input *ListServicesInput) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	return out, req.Send()
}

// ListServicesWithContext is the same as ListServices with the addition of
// the ability to pass a context and additional request options.
//
// See ListServices for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListServicesWithContext(ctx aws.Context, input *ListServicesInput, opts ...request.Option) (*ListServicesOutput, error) {
	req, out := c.ListServicesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListServicesPages iterates over the pages of a ListServices operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListServices method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListServices operation.
//    pageNum := 0
//    err := client.ListServicesPages(params,
//        func(page *servicediscovery.ListServicesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *ServiceDiscovery) ListServicesPages(input *ListServicesInput, fn func(*ListServicesOutput, bool) bool) error {
	return c.ListServicesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListServicesPagesWithContext same as ListServicesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListServicesPagesWithContext(ctx aws.Context, input *ListServicesInput, fn func(*ListServicesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListServicesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListServicesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListServicesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListTagsForResource
func (c *ServiceDiscovery) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Cloud Map.
//
// Lists tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The operation can't be completed because the resource was not found.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListTagsForResource
func (c *ServiceDiscovery) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterInstance = "RegisterInstance"

// RegisterInstanceRequest generates a "aws/request.Request" representing the
// client's request for the RegisterInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterInstance for more information on using the RegisterInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterInstanceRequest method.
//    req, resp := client.RegisterInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstance
func (c *ServiceDiscovery) RegisterInstanceRequest(input *RegisterInstanceInput) (req *request.Request, output *RegisterInstanceOutput) {
	op := &request.Operation{
		Name:       opRegisterInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterInstanceInput{}
	}

	output = &RegisterInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RegisterInstance API operation for AWS Cloud Map.
//
// Creates or updates one or more records and, optionally, creates a health
// check based on the settings in a specified service. When you submit a RegisterInstance
// request, the following occurs:
//
//    * For each DNS record that you define in the service that is specified
//    by ServiceId, a record is created or updated in the hosted zone that is
//    associated with the corresponding namespace.
//
//    * If the service includes HealthCheckConfig, a health check is created
//    based on the settings in the health check configuration.
//
//    * The health check, if any, is associated with each of the new or updated
//    records.
//
// One RegisterInstance request must complete before you can submit another
// request and specify the same service ID and instance ID.
//
// For more information, see CreateService (https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html).
//
// When AWS Cloud Map receives a DNS query for the specified DNS name, it returns
// the applicable value:
//
//    * If the health check is healthy: returns all the records
//
//    * If the health check is unhealthy: returns the applicable value for the
//    last healthy instance
//
//    * If you didn't specify a health check configuration: returns all the
//    records
//
// For the current quota on the number of instances that you can register using
// the same namespace and using the same service, see AWS Cloud Map Limits (https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html)
// in the AWS Cloud Map Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation RegisterInstance for usage and error information.
//
// Returned Error Types:
//   * DuplicateRequest
//   The operation is already in progress.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * ResourceInUse
//   The specified resource can't be deleted because it contains other resources.
//   For example, you can't delete a service that contains any instances.
//
//   * ResourceLimitExceeded
//   The resource can't be created because you've reached the quota on the number
//   of resources.
//
//   * ServiceNotFound
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstance
func (c *ServiceDiscovery) RegisterInstance(input *RegisterInstanceInput) (*RegisterInstanceOutput, error) {
	req, out := c.RegisterInstanceRequest(input)
	return out, req.Send()
}

// RegisterInstanceWithContext is the same as RegisterInstance with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) RegisterInstanceWithContext(ctx aws.Context, input *RegisterInstanceInput, opts ...request.Option) (*RegisterInstanceOutput, error) {
	req, out := c.RegisterInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/TagResource
func (c *ServiceDiscovery) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Cloud Map.
//
// Adds one or more tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The operation can't be completed because the resource was not found.
//
//   * TooManyTagsException
//   The list of tags on the resource is over the quota. The maximum number of
//   tags that can be applied to a resource is 50.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/TagResource
func (c *ServiceDiscovery) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UntagResource
func (c *ServiceDiscovery) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Cloud Map.
//
// Removes one or more tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The operation can't be completed because the resource was not found.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UntagResource
func (c *ServiceDiscovery) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInstanceCustomHealthStatus = "UpdateInstanceCustomHealthStatus"

// UpdateInstanceCustomHealthStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInstanceCustomHealthStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInstanceCustomHealthStatus for more information on using the UpdateInstanceCustomHealthStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateInstanceCustomHealthStatusRequest method.
//    req, resp := client.UpdateInstanceCustomHealthStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateInstanceCustomHealthStatus
func (c *ServiceDiscovery) UpdateInstanceCustomHealthStatusRequest(input *UpdateInstanceCustomHealthStatusInput) (req *request.Request, output *UpdateInstanceCustomHealthStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateInstanceCustomHealthStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateInstanceCustomHealthStatusInput{}
	}

	output = &UpdateInstanceCustomHealthStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInstanceCustomHealthStatus API operation for AWS Cloud Map.
//
// Submits a request to change the health status of a custom health check to
// healthy or unhealthy.
//
// You can use UpdateInstanceCustomHealthStatus to change the status only for
// custom health checks, which you define using HealthCheckCustomConfig when
// you create a service. You can't use it to change the status for Route 53
// health checks, which you define using HealthCheckConfig.
//
// For more information, see HealthCheckCustomConfig (https://docs.aws.amazon.com/cloud-map/latest/api/API_HealthCheckCustomConfig.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation UpdateInstanceCustomHealthStatus for usage and error information.
//
// Returned Error Types:
//   * InstanceNotFound
//   No instance exists with the specified ID, or the instance was recently registered,
//   and information about the instance hasn't propagated yet.
//
//   * ServiceNotFound
//   No service exists with the specified ID.
//
//   * CustomHealthNotFound
//   The health check for the instance that is specified by ServiceId and InstanceId
//   is not a custom health check.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateInstanceCustomHealthStatus
func (c *ServiceDiscovery) UpdateInstanceCustomHealthStatus(input *UpdateInstanceCustomHealthStatusInput) (*UpdateInstanceCustomHealthStatusOutput, error) {
	req, out := c.UpdateInstanceCustomHealthStatusRequest(input)
	return out, req.Send()
}

// UpdateInstanceCustomHealthStatusWithContext is the same as UpdateInstanceCustomHealthStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInstanceCustomHealthStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) UpdateInstanceCustomHealthStatusWithContext(ctx aws.Context, input *UpdateInstanceCustomHealthStatusInput, opts ...request.Option) (*UpdateInstanceCustomHealthStatusOutput, error) {
	req, out := c.UpdateInstanceCustomHealthStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateService = "UpdateService"

// UpdateServiceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateService operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateService for more information on using the UpdateService
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServiceRequest method.
//    req, resp := client.UpdateServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateService
func (c *ServiceDiscovery) UpdateServiceRequest(input *UpdateServiceInput) (req *request.Request, output *UpdateServiceOutput) {
	op := &request.Operation{
		Name:       opUpdateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServiceInput{}
	}

	output = &UpdateServiceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateService API operation for AWS Cloud Map.
//
// Submits a request to perform the following operations:
//
//    * Update the TTL setting for existing DnsRecords configurations
//
//    * Add, update, or delete HealthCheckConfig for a specified service You
//    can't add, update, or delete a HealthCheckCustomConfig configuration.
//
// For public and private DNS namespaces, note the following:
//
//    * If you omit any existing DnsRecords or HealthCheckConfig configurations
//    from an UpdateService request, the configurations are deleted from the
//    service.
//
//    * If you omit an existing HealthCheckCustomConfig configuration from an
//    UpdateService request, the configuration is not deleted from the service.
//
// When you update settings for a service, AWS Cloud Map also updates the corresponding
// settings in all the records and health checks that were created by using
// the specified service.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Cloud Map's
// API operation UpdateService for usage and error information.
//
// Returned Error Types:
//   * DuplicateRequest
//   The operation is already in progress.
//
//   * InvalidInput
//   One or more specified values aren't valid. For example, a required value
//   might be missing, a numeric value might be outside the allowed range, or
//   a string value might exceed length constraints.
//
//   * ServiceNotFound
//   No service exists with the specified ID.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateService
func (c *ServiceDiscovery) UpdateService(input *UpdateServiceInput) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	return out, req.Send()
}

// UpdateServiceWithContext is the same as UpdateService with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ServiceDiscovery) UpdateServiceWithContext(ctx aws.Context, input *UpdateServiceInput, opts ...request.Option) (*UpdateServiceOutput, error) {
	req, out := c.UpdateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateHttpNamespaceInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed CreateHttpNamespace
	// requests to be retried without the risk of executing the operation twice.
	// CreatorRequestId can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// A description for the namespace.
	Description *string `type:"string"`

	// The name that you want to assign to this namespace.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The tags to add to the namespace. Each tag consists of a key and an optional
	// value, both of which you define. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreateHttpNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHttpNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHttpNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHttpNamespaceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateHttpNamespaceInput) SetCreatorRequestId(v string) *CreateHttpNamespaceInput {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateHttpNamespaceInput) SetDescription(v string) *CreateHttpNamespaceInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateHttpNamespaceInput) SetName(v string) *CreateHttpNamespaceInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateHttpNamespaceInput) SetTags(v []*Tag) *CreateHttpNamespaceInput {
	s.Tags = v
	return s
}

type CreateHttpNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation (https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html).
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s CreateHttpNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHttpNamespaceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *CreateHttpNamespaceOutput) SetOperationId(v string) *CreateHttpNamespaceOutput {
	s.OperationId = &v
	return s
}

type CreatePrivateDnsNamespaceInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed CreatePrivateDnsNamespace
	// requests to be retried without the risk of executing the operation twice.
	// CreatorRequestId can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// A description for the namespace.
	Description *string `type:"string"`

	// The name that you want to assign to this namespace. When you create a private
	// DNS namespace, AWS Cloud Map automatically creates an Amazon Route 53 private
	// hosted zone that has the same name as the namespace.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The tags to add to the namespace. Each tag consists of a key and an optional
	// value, both of which you define. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags []*Tag `type:"list"`

	// The ID of the Amazon VPC that you want to associate the namespace with.
	//
	// Vpc is a required field
	Vpc *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreatePrivateDnsNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePrivateDnsNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePrivateDnsNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePrivateDnsNamespaceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Vpc == nil {
		invalidParams.Add(request.NewErrParamRequired("Vpc"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreatePrivateDnsNamespaceInput) SetCreatorRequestId(v string) *CreatePrivateDnsNamespaceInput {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePrivateDnsNamespaceInput) SetDescription(v string) *CreatePrivateDnsNamespaceInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePrivateDnsNamespaceInput) SetName(v string) *CreatePrivateDnsNamespaceInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePrivateDnsNamespaceInput) SetTags(v []*Tag) *CreatePrivateDnsNamespaceInput {
	s.Tags = v
	return s
}

// SetVpc sets the Vpc field's value.
func (s *CreatePrivateDnsNamespaceInput) SetVpc(v string) *CreatePrivateDnsNamespaceInput {
	s.Vpc = &v
	return s
}

type CreatePrivateDnsNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation (https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html).
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s CreatePrivateDnsNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePrivateDnsNamespaceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *CreatePrivateDnsNamespaceOutput) SetOperationId(v string) *CreatePrivateDnsNamespaceOutput {
	s.OperationId = &v
	return s
}

type CreatePublicDnsNamespaceInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed CreatePublicDnsNamespace
	// requests to be retried without the risk of executing the operation twice.
	// CreatorRequestId can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// A description for the namespace.
	Description *string `type:"string"`

	// The name that you want to assign to this namespace.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The tags to add to the namespace. Each tag consists of a key and an optional
	// value, both of which you define. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s CreatePublicDnsNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicDnsNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePublicDnsNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePublicDnsNamespaceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreatePublicDnsNamespaceInput) SetCreatorRequestId(v string) *CreatePublicDnsNamespaceInput {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreatePublicDnsNamespaceInput) SetDescription(v string) *CreatePublicDnsNamespaceInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreatePublicDnsNamespaceInput) SetName(v string) *CreatePublicDnsNamespaceInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreatePublicDnsNamespaceInput) SetTags(v []*Tag) *CreatePublicDnsNamespaceInput {
	s.Tags = v
	return s
}

type CreatePublicDnsNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation (https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html).
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s CreatePublicDnsNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicDnsNamespaceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *CreatePublicDnsNamespaceOutput) SetOperationId(v string) *CreatePublicDnsNamespaceOutput {
	s.OperationId = &v
	return s
}

type CreateServiceInput struct {
	_ struct{} `type:"structure"`

	// A unique string that identifies the request and that allows failed CreateService
	// requests to be retried without the risk of executing the operation twice.
	// CreatorRequestId can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// A description for the service.
	Description *string `type:"string"`

	// A complex type that contains information about the Amazon Route 53 records
	// that you want AWS Cloud Map to create when you register an instance.
	DnsConfig *DnsConfig `type:"structure"`

	// Public DNS and HTTP namespaces only. A complex type that contains settings
	// for an optional Route 53 health check. If you specify settings for a health
	// check, AWS Cloud Map associates the health check with all the Route 53 DNS
	// records that you specify in DnsConfig.
	//
	// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
	// or HealthCheckConfig but not both.
	//
	// For information about the charges for health checks, see AWS Cloud Map Pricing
	// (http://aws.amazon.com/cloud-map/pricing/).
	HealthCheckConfig *HealthCheckConfig `type:"structure"`

	// A complex type that contains information about an optional custom health
	// check.
	//
	// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
	// or HealthCheckConfig but not both.
	//
	// You can't add, update, or delete a HealthCheckCustomConfig configuration
	// from an existing service.
	HealthCheckCustomConfig *HealthCheckCustomConfig `type:"structure"`

	// The name that you want to assign to the service.
	//
	// If you want AWS Cloud Map to create an SRV record when you register an instance,
	// and if you're using a system that requires a specific SRV format, such as
	// HAProxy (http://www.haproxy.org/), specify the following for Name:
	//
	//    * Start the name with an underscore (_), such as _exampleservice
	//
	//    * End the name with ._protocol, such as ._tcp
	//
	// When you register an instance, AWS Cloud Map creates an SRV record and assigns
	// a name to the record by concatenating the service name and the namespace
	// name, for example:
	//
	// _exampleservice._tcp.example.com
	//
	// For a single DNS namespace, you cannot create two services with names that
	// differ only by case (such as EXAMPLE and example). Otherwise, these services
	// will have the same DNS name. However, you can create multiple HTTP services
	// with names that differ only by case because HTTP services are case sensitive.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The ID of the namespace that you want to use to create the service.
	NamespaceId *string `type:"string"`

	// The tags to add to the service. Each tag consists of a key and an optional
	// value, both of which you define. Tag keys can have a maximum character length
	// of 128 characters, and tag values can have a maximum length of 256 characters.
	Tags []*Tag `type:"list"`

	// If present, specifies that the service instances are only discoverable using
	// the DiscoverInstances API operation. No DNS records will be registered for
	// the service instances. The only valid value is HTTP.
	Type *string `type:"string" enum:"ServiceTypeOption"`
}

// String returns the string representation
func (s CreateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.DnsConfig != nil {
		if err := s.DnsConfig.Validate(); err != nil {
			invalidParams.AddNested("DnsConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HealthCheckConfig != nil {
		if err := s.HealthCheckConfig.Validate(); err != nil {
			invalidParams.AddNested("HealthCheckConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HealthCheckCustomConfig != nil {
		if err := s.HealthCheckCustomConfig.Validate(); err != nil {
			invalidParams.AddNested("HealthCheckCustomConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *CreateServiceInput) SetCreatorRequestId(v string) *CreateServiceInput {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateServiceInput) SetDescription(v string) *CreateServiceInput {
	s.Description = &v
	return s
}

// SetDnsConfig sets the DnsConfig field's value.
func (s *CreateServiceInput) SetDnsConfig(v *DnsConfig) *CreateServiceInput {
	s.DnsConfig = v
	return s
}

// SetHealthCheckConfig sets the HealthCheckConfig field's value.
func (s *CreateServiceInput) SetHealthCheckConfig(v *HealthCheckConfig) *CreateServiceInput {
	s.HealthCheckConfig = v
	return s
}

// SetHealthCheckCustomConfig sets the HealthCheckCustomConfig field's value.
func (s *CreateServiceInput) SetHealthCheckCustomConfig(v *HealthCheckCustomConfig) *CreateServiceInput {
	s.HealthCheckCustomConfig = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateServiceInput) SetName(v string) *CreateServiceInput {
	s.Name = &v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *CreateServiceInput) SetNamespaceId(v string) *CreateServiceInput {
	s.NamespaceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateServiceInput) SetTags(v []*Tag) *CreateServiceInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateServiceInput) SetType(v string) *CreateServiceInput {
	s.Type = &v
	return s
}

type CreateServiceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the new service.
	Service *Service `type:"structure"`
}

// String returns the string representation
func (s CreateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *CreateServiceOutput) SetService(v *Service) *CreateServiceOutput {
	s.Service = v
	return s
}

// The health check for the instance that is specified by ServiceId and InstanceId
// is not a custom health check.
type CustomHealthNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s CustomHealthNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomHealthNotFound) GoString() string {
	return s.String()
}

func newErrorCustomHealthNotFound(v protocol.ResponseMetadata) error {
	return &CustomHealthNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *CustomHealthNotFound) Code() string {
	return "CustomHealthNotFound"
}

// Message returns the exception's message.
func (s *CustomHealthNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *CustomHealthNotFound) OrigErr() error {
	return nil
}

func (s *CustomHealthNotFound) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *CustomHealthNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *CustomHealthNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

type DeleteNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the namespace that you want to delete.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNamespaceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteNamespaceInput) SetId(v string) *DeleteNamespaceInput {
	s.Id = &v
	return s
}

type DeleteNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation (https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html).
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s DeleteNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteNamespaceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *DeleteNamespaceOutput) SetOperationId(v string) *DeleteNamespaceOutput {
	s.OperationId = &v
	return s
}

type DeleteServiceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the service that you want to delete.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServiceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *DeleteServiceInput) SetId(v string) *DeleteServiceInput {
	s.Id = &v
	return s
}

type DeleteServiceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServiceOutput) GoString() string {
	return s.String()
}

type DeregisterInstanceInput struct {
	_ struct{} `type:"structure"`

	// The value that you specified for Id in the RegisterInstance (https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html)
	// request.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The ID of the service that the instance is associated with.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeregisterInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DeregisterInstanceInput) SetInstanceId(v string) *DeregisterInstanceInput {
	s.InstanceId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *DeregisterInstanceInput) SetServiceId(v string) *DeregisterInstanceInput {
	s.ServiceId = &v
	return s
}

type DeregisterInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// For more information, see GetOperation (https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html).
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s DeregisterInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeregisterInstanceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *DeregisterInstanceOutput) SetOperationId(v string) *DeregisterInstanceOutput {
	s.OperationId = &v
	return s
}

type DiscoverInstancesInput struct {
	_ struct{} `type:"structure"`

	// The health status of the instances that you want to discover.
	HealthStatus *string `type:"string" enum:"HealthStatusFilter"`

	// The maximum number of instances that you want AWS Cloud Map to return in
	// the response to a DiscoverInstances request. If you don't specify a value
	// for MaxResults, AWS Cloud Map returns up to 100 instances.
	MaxResults *int64 `min:"1" type:"integer"`

	// The name of the namespace that you specified when you registered the instance.
	//
	// NamespaceName is a required field
	NamespaceName *string `type:"string" required:"true"`

	// Opportunistic filters to scope the results based on custom attributes. If
	// there are instances that match both the filters specified in both the QueryParameters
	// parameter and this parameter, they are returned. Otherwise, these filters
	// are ignored and only instances that match the filters specified in the QueryParameters
	// parameter are returned.
	OptionalParameters map[string]*string `type:"map"`

	// Filters to scope the results based on custom attributes for the instance.
	// For example, {version=v1, az=1a}. Only instances that match all the specified
	// key-value pairs will be returned.
	QueryParameters map[string]*string `type:"map"`

	// The name of the service that you specified when you registered the instance.
	//
	// ServiceName is a required field
	ServiceName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DiscoverInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiscoverInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DiscoverInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DiscoverInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *DiscoverInstancesInput) SetHealthStatus(v string) *DiscoverInstancesInput {
	s.HealthStatus = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DiscoverInstancesInput) SetMaxResults(v int64) *DiscoverInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *DiscoverInstancesInput) SetNamespaceName(v string) *DiscoverInstancesInput {
	s.NamespaceName = &v
	return s
}

// SetOptionalParameters sets the OptionalParameters field's value.
func (s *DiscoverInstancesInput) SetOptionalParameters(v map[string]*string) *DiscoverInstancesInput {
	s.OptionalParameters = v
	return s
}

// SetQueryParameters sets the QueryParameters field's value.
func (s *DiscoverInstancesInput) SetQueryParameters(v map[string]*string) *DiscoverInstancesInput {
	s.QueryParameters = v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *DiscoverInstancesInput) SetServiceName(v string) *DiscoverInstancesInput {
	s.ServiceName = &v
	return s
}

type DiscoverInstancesOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains one HttpInstanceSummary for each registered
	// instance.
	Instances []*HttpInstanceSummary `type:"list"`
}

// String returns the string representation
func (s DiscoverInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DiscoverInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DiscoverInstancesOutput) SetInstances(v []*HttpInstanceSummary) *DiscoverInstancesOutput {
	s.Instances = v
	return s
}

// A complex type that contains information about the Amazon Route 53 DNS records
// that you want AWS Cloud Map to create when you register an instance.
type DnsConfig struct {
	_ struct{} `type:"structure"`

	// An array that contains one DnsRecord object for each Route 53 DNS record
	// that you want AWS Cloud Map to create when you register an instance.
	//
	// DnsRecords is a required field
	DnsRecords []*DnsRecord `type:"list" required:"true"`

	// The ID of the namespace to use for DNS configuration.
	//
	// Deprecated: Top level attribute in request should be used to reference namespace-id
	NamespaceId *string `deprecated:"true" type:"string"`

	// The routing policy that you want to apply to all Route 53 DNS records that
	// AWS Cloud Map creates when you register an instance and specify this service.
	//
	// If you want to use this service to register instances that create alias records,
	// specify WEIGHTED for the routing policy.
	//
	// You can specify the following values:
	//
	// MULTIVALUE
	//
	// If you define a health check for the service and the health check is healthy,
	// Route 53 returns the applicable value for up to eight instances.
	//
	// For example, suppose the service includes configurations for one A record
	// and a health check, and you use the service to register 10 instances. Route
	// 53 responds to DNS queries with IP addresses for up to eight healthy instances.
	// If fewer than eight instances are healthy, Route 53 responds to every DNS
	// query with the IP addresses for all of the healthy instances.
	//
	// If you don't define a health check for the service, Route 53 assumes that
	// all instances are healthy and returns the values for up to eight instances.
	//
	// For more information about the multivalue routing policy, see Multivalue
	// Answer Routing (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-multivalue)
	// in the Route 53 Developer Guide.
	//
	// WEIGHTED
	//
	// Route 53 returns the applicable value from one randomly selected instance
	// from among the instances that you registered using the same service. Currently,
	// all records have the same weight, so you can't route more or less traffic
	// to any instances.
	//
	// For example, suppose the service includes configurations for one A record
	// and a health check, and you use the service to register 10 instances. Route
	// 53 responds to DNS queries with the IP address for one randomly selected
	// instance from among the healthy instances. If no instances are healthy, Route
	// 53 responds to DNS queries as if all of the instances were healthy.
	//
	// If you don't define a health check for the service, Route 53 assumes that
	// all instances are healthy and returns the applicable value for one randomly
	// selected instance.
	//
	// For more information about the weighted routing policy, see Weighted Routing
	// (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/routing-policy.html#routing-policy-weighted)
	// in the Route 53 Developer Guide.
	RoutingPolicy *string `type:"string" enum:"RoutingPolicy"`
}

// String returns the string representation
func (s DnsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DnsConfig"}
	if s.DnsRecords == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsRecords"))
	}
	if s.DnsRecords != nil {
		for i, v := range s.DnsRecords {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DnsRecords", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDnsRecords sets the DnsRecords field's value.
func (s *DnsConfig) SetDnsRecords(v []*DnsRecord) *DnsConfig {
	s.DnsRecords = v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *DnsConfig) SetNamespaceId(v string) *DnsConfig {
	s.NamespaceId = &v
	return s
}

// SetRoutingPolicy sets the RoutingPolicy field's value.
func (s *DnsConfig) SetRoutingPolicy(v string) *DnsConfig {
	s.RoutingPolicy = &v
	return s
}

// A complex type that contains information about changes to the Route 53 DNS
// records that AWS Cloud Map creates when you register an instance.
type DnsConfigChange struct {
	_ struct{} `type:"structure"`

	// An array that contains one DnsRecord object for each Route 53 record that
	// you want AWS Cloud Map to create when you register an instance.
	//
	// DnsRecords is a required field
	DnsRecords []*DnsRecord `type:"list" required:"true"`
}

// String returns the string representation
func (s DnsConfigChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsConfigChange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsConfigChange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DnsConfigChange"}
	if s.DnsRecords == nil {
		invalidParams.Add(request.NewErrParamRequired("DnsRecords"))
	}
	if s.DnsRecords != nil {
		for i, v := range s.DnsRecords {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DnsRecords", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDnsRecords sets the DnsRecords field's value.
func (s *DnsConfigChange) SetDnsRecords(v []*DnsRecord) *DnsConfigChange {
	s.DnsRecords = v
	return s
}

// A complex type that contains the ID for the Route 53 hosted zone that AWS
// Cloud Map creates when you create a namespace.
type DnsProperties struct {
	_ struct{} `type:"structure"`

	// The ID for the Route 53 hosted zone that AWS Cloud Map creates when you create
	// a namespace.
	HostedZoneId *string `type:"string"`
}

// String returns the string representation
func (s DnsProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsProperties) GoString() string {
	return s.String()
}

// SetHostedZoneId sets the HostedZoneId field's value.
func (s *DnsProperties) SetHostedZoneId(v string) *DnsProperties {
	s.HostedZoneId = &v
	return s
}

// A complex type that contains information about the Route 53 DNS records that
// you want AWS Cloud Map to create when you register an instance.
type DnsRecord struct {
	_ struct{} `type:"structure"`

	// The amount of time, in seconds, that you want DNS resolvers to cache the
	// settings for this record.
	//
	// Alias records don't include a TTL because Route 53 uses the TTL for the AWS
	// resource that an alias record routes traffic to. If you include the AWS_ALIAS_DNS_NAME
	// attribute when you submit a RegisterInstance (https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html)
	// request, the TTL value is ignored. Always specify a TTL for the service;
	// you can use a service to register instances that create either alias or non-alias
	// records.
	//
	// TTL is a required field
	TTL *int64 `type:"long" required:"true"`

	// The type of the resource, which indicates the type of value that Route 53
	// returns in response to DNS queries. You can specify values for Type in the
	// following combinations:
	//
	//    * A
	//
	//    * AAAA
	//
	//    * A and AAAA
	//
	//    * SRV
	//
	//    * CNAME
	//
	// If you want AWS Cloud Map to create a Route 53 alias record when you register
	// an instance, specify A or AAAA for Type.
	//
	// You specify other settings, such as the IP address for A and AAAA records,
	// when you register an instance. For more information, see RegisterInstance
	// (https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html).
	//
	// The following values are supported:
	//
	// A
	//
	// Route 53 returns the IP address of the resource in IPv4 format, such as 192.0.2.44.
	//
	// AAAA
	//
	// Route 53 returns the IP address of the resource in IPv6 format, such as 2001:0db8:85a3:0000:0000:abcd:0001:2345.
	//
	// CNAME
	//
	// Route 53 returns the domain name of the resource, such as www.example.com.
	// Note the following:
	//
	//    * You specify the domain name that you want to route traffic to when you
	//    register an instance. For more information, see Attributes (https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html#cloudmap-RegisterInstance-request-Attributes)
	//    in the topic RegisterInstance (https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html).
	//
	//    * You must specify WEIGHTED for the value of RoutingPolicy.
	//
	//    * You can't specify both CNAME for Type and settings for HealthCheckConfig.
	//    If you do, the request will fail with an InvalidInput error.
	//
	// SRV
	//
	// Route 53 returns the value for an SRV record. The value for an SRV record
	// uses the following values:
	//
	// priority weight port service-hostname
	//
	// Note the following about the values:
	//
	//    * The values of priority and weight are both set to 1 and can't be changed.
	//
	//    * The value of port comes from the value that you specify for the AWS_INSTANCE_PORT
	//    attribute when you submit a RegisterInstance (https://docs.aws.amazon.com/cloud-map/latest/api/API_RegisterInstance.html)
	//    request.
	//
	//    * The value of service-hostname is a concatenation of the following values:
	//    The value that you specify for InstanceId when you register an instance.
	//    The name of the service. The name of the namespace. For example, if the
	//    value of InstanceId is test, the name of the service is backend, and the
	//    name of the namespace is example.com, the value of service-hostname is:
	//    test.backend.example.com
	//
	// If you specify settings for an SRV record, note the following:
	//
	//    * If you specify values for AWS_INSTANCE_IPV4, AWS_INSTANCE_IPV6, or both
	//    in the RegisterInstance request, AWS Cloud Map automatically creates A
	//    and/or AAAA records that have the same name as the value of service-hostname
	//    in the SRV record. You can ignore these records.
	//
	//    * If you're using a system that requires a specific SRV format, such as
	//    HAProxy, see the Name (https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html#cloudmap-CreateService-request-Name)
	//    element in the documentation about CreateService for information about
	//    how to specify the correct name format.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"RecordType"`
}

// String returns the string representation
func (s DnsRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DnsRecord) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DnsRecord) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DnsRecord"}
	if s.TTL == nil {
		invalidParams.Add(request.NewErrParamRequired("TTL"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTTL sets the TTL field's value.
func (s *DnsRecord) SetTTL(v int64) *DnsRecord {
	s.TTL = &v
	return s
}

// SetType sets the Type field's value.
func (s *DnsRecord) SetType(v string) *DnsRecord {
	s.Type = &v
	return s
}

// The operation is already in progress.
type DuplicateRequest struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The ID of the operation that is already in progress.
	DuplicateOperationId *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s DuplicateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DuplicateRequest) GoString() string {
	return s.String()
}

func newErrorDuplicateRequest(v protocol.ResponseMetadata) error {
	return &DuplicateRequest{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateRequest) Code() string {
	return "DuplicateRequest"
}

// Message returns the exception's message.
func (s *DuplicateRequest) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateRequest) OrigErr() error {
	return nil
}

func (s *DuplicateRequest) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateRequest) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateRequest) RequestID() string {
	return s.RespMetadata.RequestID
}

type GetInstanceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance that you want to get information about.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The ID of the service that the instance is associated with.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *GetInstanceInput) SetInstanceId(v string) *GetInstanceInput {
	s.InstanceId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *GetInstanceInput) SetServiceId(v string) *GetInstanceInput {
	s.ServiceId = &v
	return s
}

type GetInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about a specified instance.
	Instance *Instance `type:"structure"`
}

// String returns the string representation
func (s GetInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstanceOutput) GoString() string {
	return s.String()
}

// SetInstance sets the Instance field's value.
func (s *GetInstanceOutput) SetInstance(v *Instance) *GetInstanceOutput {
	s.Instance = v
	return s
}

type GetInstancesHealthStatusInput struct {
	_ struct{} `type:"structure"`

	// An array that contains the IDs of all the instances that you want to get
	// the health status for.
	//
	// If you omit Instances, AWS Cloud Map returns the health status for all the
	// instances that are associated with the specified service.
	//
	// To get the IDs for the instances that you've registered by using a specified
	// service, submit a ListInstances (https://docs.aws.amazon.com/cloud-map/latest/api/API_ListInstances.html)
	// request.
	Instances []*string `min:"1" type:"list"`

	// The maximum number of instances that you want AWS Cloud Map to return in
	// the response to a GetInstancesHealthStatus request. If you don't specify
	// a value for MaxResults, AWS Cloud Map returns up to 100 instances.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first GetInstancesHealthStatus request, omit this value.
	//
	// If more than MaxResults instances match the specified criteria, you can submit
	// another GetInstancesHealthStatus request to get the next group of results.
	// Specify the value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`

	// The ID of the service that the instance is associated with.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetInstancesHealthStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancesHealthStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetInstancesHealthStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetInstancesHealthStatusInput"}
	if s.Instances != nil && len(s.Instances) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Instances", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstances sets the Instances field's value.
func (s *GetInstancesHealthStatusInput) SetInstances(v []*string) *GetInstancesHealthStatusInput {
	s.Instances = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetInstancesHealthStatusInput) SetMaxResults(v int64) *GetInstancesHealthStatusInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetInstancesHealthStatusInput) SetNextToken(v string) *GetInstancesHealthStatusInput {
	s.NextToken = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *GetInstancesHealthStatusInput) SetServiceId(v string) *GetInstancesHealthStatusInput {
	s.ServiceId = &v
	return s
}

type GetInstancesHealthStatusOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults instances match the specified criteria, you can submit
	// another GetInstancesHealthStatus request to get the next group of results.
	// Specify the value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`

	// A complex type that contains the IDs and the health status of the instances
	// that you specified in the GetInstancesHealthStatus request.
	Status map[string]*string `type:"map"`
}

// String returns the string representation
func (s GetInstancesHealthStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetInstancesHealthStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *GetInstancesHealthStatusOutput) SetNextToken(v string) *GetInstancesHealthStatusOutput {
	s.NextToken = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetInstancesHealthStatusOutput) SetStatus(v map[string]*string) *GetInstancesHealthStatusOutput {
	s.Status = v
	return s
}

type GetNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the namespace that you want to get information about.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNamespaceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetNamespaceInput) SetId(v string) *GetNamespaceInput {
	s.Id = &v
	return s
}

type GetNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the specified namespace.
	Namespace *Namespace `type:"structure"`
}

// String returns the string representation
func (s GetNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetNamespaceOutput) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *GetNamespaceOutput) SetNamespace(v *Namespace) *GetNamespaceOutput {
	s.Namespace = v
	return s
}

type GetOperationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the operation that you want to get more information about.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOperationInput"}
	if s.OperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("OperationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOperationId sets the OperationId field's value.
func (s *GetOperationInput) SetOperationId(v string) *GetOperationInput {
	s.OperationId = &v
	return s
}

type GetOperationOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the operation.
	Operation *Operation `type:"structure"`
}

// String returns the string representation
func (s GetOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOperationOutput) GoString() string {
	return s.String()
}

// SetOperation sets the Operation field's value.
func (s *GetOperationOutput) SetOperation(v *Operation) *GetOperationOutput {
	s.Operation = v
	return s
}

type GetServiceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the service that you want to get settings for.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetServiceInput) SetId(v string) *GetServiceInput {
	s.Id = &v
	return s
}

type GetServiceOutput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains information about the service.
	Service *Service `type:"structure"`
}

// String returns the string representation
func (s GetServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceOutput) GoString() string {
	return s.String()
}

// SetService sets the Service field's value.
func (s *GetServiceOutput) SetService(v *Service) *GetServiceOutput {
	s.Service = v
	return s
}

// Public DNS and HTTP namespaces only. A complex type that contains settings
// for an optional health check. If you specify settings for a health check,
// AWS Cloud Map associates the health check with the records that you specify
// in DnsConfig.
//
// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
// or HealthCheckConfig but not both.
//
// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
// For information about pricing for health checks, see Amazon Route 53 Pricing
// (http://aws.amazon.com/route53/pricing/).
//
// Note the following about configuring health checks.
//
//  A and AAAA records
//
// If DnsConfig includes configurations for both A and AAAA records, AWS Cloud
// Map creates a health check that uses the IPv4 address to check the health
// of the resource. If the endpoint that is specified by the IPv4 address is
// unhealthy, Route 53 considers both the A and AAAA records to be unhealthy.
//
//  CNAME records
//
// You can't specify settings for HealthCheckConfig when the DNSConfig includes
// CNAME for the value of Type. If you do, the CreateService request will fail
// with an InvalidInput error.
//
// Request interval
//
// A Route 53 health checker in each health-checking region sends a health check
// request to an endpoint every 30 seconds. On average, your endpoint receives
// a health check request about every two seconds. However, health checkers
// don't coordinate with one another, so you'll sometimes see several requests
// per second followed by a few seconds with no health checks at all.
//
// Health checking regions
//
// Health checkers perform checks from all Route 53 health-checking regions.
// For a list of the current regions, see Regions (https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions).
//
// Alias records
//
// When you register an instance, if you include the AWS_ALIAS_DNS_NAME attribute,
// AWS Cloud Map creates a Route 53 alias record. Note the following:
//
//    * Route 53 automatically sets EvaluateTargetHealth to true for alias records.
//    When EvaluateTargetHealth is true, the alias record inherits the health
//    of the referenced AWS resource. such as an ELB load balancer. For more
//    information, see EvaluateTargetHealth (https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-EvaluateTargetHealth).
//
//    * If you include HealthCheckConfig and then use the service to register
//    an instance that creates an alias record, Route 53 doesn't create the
//    health check.
//
// Charges for health checks
//
// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
// For information about pricing for health checks, see Amazon Route 53 Pricing
// (http://aws.amazon.com/route53/pricing/).
type HealthCheckConfig struct {
	_ struct{} `type:"structure"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa. For more information, see How Route 53 Determines
	// Whether an Endpoint Is Healthy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Route 53 Developer Guide.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// The path that you want Route 53 to request when performing health checks.
	// The path can be any value for which your endpoint will return an HTTP status
	// code of 2xx or 3xx when the endpoint is healthy, such as the file /docs/route53-health-check.html.
	// Route 53 automatically adds the DNS name for the service. If you don't specify
	// a value for ResourcePath, the default value is /.
	//
	// If you specify TCP for Type, you must not specify a value for ResourcePath.
	ResourcePath *string `type:"string"`

	// The type of health check that you want to create, which indicates how Route
	// 53 determines whether an endpoint is healthy.
	//
	// You can't change the value of Type after you create a health check.
	//
	// You can create the following types of health checks:
	//
	//    * HTTP: Route 53 tries to establish a TCP connection. If successful, Route
	//    53 submits an HTTP request and waits for an HTTP status code of 200 or
	//    greater and less than 400.
	//
	//    * HTTPS: Route 53 tries to establish a TCP connection. If successful,
	//    Route 53 submits an HTTPS request and waits for an HTTP status code of
	//    200 or greater and less than 400. If you specify HTTPS for the value of
	//    Type, the endpoint must support TLS v1.0 or later.
	//
	//    * TCP: Route 53 tries to establish a TCP connection. If you specify TCP
	//    for Type, don't specify a value for ResourcePath.
	//
	// For more information, see How Route 53 Determines Whether an Endpoint Is
	// Healthy (https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html)
	// in the Route 53 Developer Guide.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"HealthCheckType"`
}

// String returns the string representation
func (s HealthCheckConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckConfig"}
	if s.FailureThreshold != nil && *s.FailureThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FailureThreshold", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *HealthCheckConfig) SetFailureThreshold(v int64) *HealthCheckConfig {
	s.FailureThreshold = &v
	return s
}

// SetResourcePath sets the ResourcePath field's value.
func (s *HealthCheckConfig) SetResourcePath(v string) *HealthCheckConfig {
	s.ResourcePath = &v
	return s
}

// SetType sets the Type field's value.
func (s *HealthCheckConfig) SetType(v string) *HealthCheckConfig {
	s.Type = &v
	return s
}

// A complex type that contains information about an optional custom health
// check. A custom health check, which requires that you use a third-party health
// checker to evaluate the health of your resources, is useful in the following
// circumstances:
//
//    * You can't use a health check that is defined by HealthCheckConfig because
//    the resource isn't available over the internet. For example, you can use
//    a custom health check when the instance is in an Amazon VPC. (To check
//    the health of resources in a VPC, the health checker must also be in the
//    VPC.)
//
//    * You want to use a third-party health checker regardless of where your
//    resources are.
//
// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
// or HealthCheckConfig but not both.
//
// To change the status of a custom health check, submit an UpdateInstanceCustomHealthStatus
// request. AWS Cloud Map doesn't monitor the status of the resource, it just
// keeps a record of the status specified in the most recent UpdateInstanceCustomHealthStatus
// request.
//
// Here's how custom health checks work:
//
// You create a service and specify a value for FailureThreshold.
//
// The failure threshold indicates the number of 30-second intervals you want
// AWS Cloud Map to wait between the time that your application sends an UpdateInstanceCustomHealthStatus
// (https://docs.aws.amazon.com/cloud-map/latest/api/API_UpdateInstanceCustomHealthStatus.html)
// request and the time that AWS Cloud Map stops routing internet traffic to
// the corresponding resource.
//
// You register an instance.
//
// You configure a third-party health checker to monitor the resource that is
// associated with the new instance.
//
// AWS Cloud Map doesn't check the health of the resource directly.
//
// The third-party health-checker determines that the resource is unhealthy
// and notifies your application.
//
// Your application submits an UpdateInstanceCustomHealthStatus request.
//
// AWS Cloud Map waits for (FailureThreshold x 30) seconds.
//
// If another UpdateInstanceCustomHealthStatus request doesn't arrive during
// that time to change the status back to healthy, AWS Cloud Map stops routing
// traffic to the resource.
type HealthCheckCustomConfig struct {
	_ struct{} `type:"structure"`

	//
	// This parameter has been deprecated and is always set to 1. AWS Cloud Map
	// waits for approximately 30 seconds after receiving an UpdateInstanceCustomHealthStatus
	// request before changing the status of the service instance.
	//
	// The number of 30-second intervals that you want AWS Cloud Map to wait after
	// receiving an UpdateInstanceCustomHealthStatus request before it changes the
	// health status of a service instance.
	//
	// Sending a second or subsequent UpdateInstanceCustomHealthStatus request with
	// the same value before 30 seconds has passed doesn't accelerate the change.
	// AWS Cloud Map still waits 30 seconds after the first request to make the
	// change.
	//
	// Deprecated: Configurable FailureThreshold of HealthCheckCustomConfig is deprecated.  It will always have value 1.
	FailureThreshold *int64 `min:"1" deprecated:"true" type:"integer"`
}

// String returns the string representation
func (s HealthCheckCustomConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckCustomConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HealthCheckCustomConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HealthCheckCustomConfig"}
	if s.FailureThreshold != nil && *s.FailureThreshold < 1 {
		invalidParams.Add(request.NewErrParamMinValue("FailureThreshold", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFailureThreshold sets the FailureThreshold field's value.
func (s *HealthCheckCustomConfig) SetFailureThreshold(v int64) *HealthCheckCustomConfig {
	s.FailureThreshold = &v
	return s
}

// In a response to a DiscoverInstances (https://docs.aws.amazon.com/cloud-map/latest/api/API_DiscoverInstances.html)
// request, HttpInstanceSummary contains information about one instance that
// matches the values that you specified in the request.
type HttpInstanceSummary struct {
	_ struct{} `type:"structure"`

	// If you included any attributes when you registered the instance, the values
	// of those attributes.
	Attributes map[string]*string `type:"map"`

	// If you configured health checking in the service, the current health status
	// of the service instance.
	HealthStatus *string `type:"string" enum:"HealthStatus"`

	// The ID of an instance that matches the values that you specified in the request.
	InstanceId *string `type:"string"`

	// The name of the namespace that you specified when you registered the instance.
	NamespaceName *string `type:"string"`

	// The name of the service that you specified when you registered the instance.
	ServiceName *string `type:"string"`
}

// String returns the string representation
func (s HttpInstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpInstanceSummary) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *HttpInstanceSummary) SetAttributes(v map[string]*string) *HttpInstanceSummary {
	s.Attributes = v
	return s
}

// SetHealthStatus sets the HealthStatus field's value.
func (s *HttpInstanceSummary) SetHealthStatus(v string) *HttpInstanceSummary {
	s.HealthStatus = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *HttpInstanceSummary) SetInstanceId(v string) *HttpInstanceSummary {
	s.InstanceId = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *HttpInstanceSummary) SetNamespaceName(v string) *HttpInstanceSummary {
	s.NamespaceName = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *HttpInstanceSummary) SetServiceName(v string) *HttpInstanceSummary {
	s.ServiceName = &v
	return s
}

// A complex type that contains the name of an HTTP namespace.
type HttpProperties struct {
	_ struct{} `type:"structure"`

	// The name of an HTTP namespace.
	HttpName *string `type:"string"`
}

// String returns the string representation
func (s HttpProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpProperties) GoString() string {
	return s.String()
}

// SetHttpName sets the HttpName field's value.
func (s *HttpProperties) SetHttpName(v string) *HttpProperties {
	s.HttpName = &v
	return s
}

// A complex type that contains information about an instance that AWS Cloud
// Map creates when you submit a RegisterInstance request.
type Instance struct {
	_ struct{} `type:"structure"`

	// A string map that contains the following information for the service that
	// you specify in ServiceId:
	//
	//    * The attributes that apply to the records that are defined in the service.
	//
	//    * For each attribute, the applicable value.
	//
	// Supported attribute keys include the following:
	//
	// AWS_ALIAS_DNS_NAME
	//
	// If you want AWS Cloud Map to create a Route 53 alias record that routes traffic
	// to an Elastic Load Balancing load balancer, specify the DNS name that is
	// associated with the load balancer. For information about how to get the DNS
	// name, see "DNSName" in the topic AliasTarget (https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html).
	//
	// Note the following:
	//
	//    * The configuration for the service that is specified by ServiceId must
	//    include settings for an A record, an AAAA record, or both.
	//
	//    * In the service that is specified by ServiceId, the value of RoutingPolicy
	//    must be WEIGHTED.
	//
	//    * If the service that is specified by ServiceId includes HealthCheckConfig
	//    settings, AWS Cloud Map will create the health check, but it won't associate
	//    the health check with the alias record.
	//
	//    * Auto naming currently doesn't support creating alias records that route
	//    traffic to AWS resources other than ELB load balancers.
	//
	//    * If you specify a value for AWS_ALIAS_DNS_NAME, don't specify values
	//    for any of the AWS_INSTANCE attributes.
	//
	// AWS_EC2_INSTANCE_ID
	//
	// HTTP namespaces only. The Amazon EC2 instance ID for the instance. The AWS_INSTANCE_IPV4
	// attribute contains the primary private IPv4 address.
	//
	// AWS_INSTANCE_CNAME
	//
	// If the service configuration includes a CNAME record, the domain name that
	// you want Route 53 to return in response to DNS queries, for example, example.com.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an CNAME record.
	//
	// AWS_INSTANCE_IPV4
	//
	// If the service configuration includes an A record, the IPv4 address that
	// you want Route 53 to return in response to DNS queries, for example, 192.0.2.44.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an A record. If the service includes settings for an SRV record, you
	// must specify a value for AWS_INSTANCE_IPV4, AWS_INSTANCE_IPV6, or both.
	//
	// AWS_INSTANCE_IPV6
	//
	// If the service configuration includes an AAAA record, the IPv6 address that
	// you want Route 53 to return in response to DNS queries, for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an AAAA record. If the service includes settings for an SRV record, you
	// must specify a value for AWS_INSTANCE_IPV4, AWS_INSTANCE_IPV6, or both.
	//
	// AWS_INSTANCE_PORT
	//
	// If the service includes an SRV record, the value that you want Route 53 to
	// return for the port.
	//
	// If the service includes HealthCheckConfig, the port on the endpoint that
	// you want Route 53 to send requests to.
	//
	// This value is required if you specified settings for an SRV record or a Route
	// 53 health check when you created the service.
	Attributes map[string]*string `type:"map"`

	// A unique string that identifies the request and that allows failed RegisterInstance
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CreatorRequestId string every time you submit a RegisterInstance
	// request if you're registering additional instances for the same namespace
	// and service. CreatorRequestId can be any unique string, for example, a date/time
	// stamp.
	CreatorRequestId *string `type:"string"`

	// An identifier that you want to associate with the instance. Note the following:
	//
	//    * If the service that is specified by ServiceId includes settings for
	//    an SRV record, the value of InstanceId is automatically included as part
	//    of the value for the SRV record. For more information, see DnsRecord >
	//    Type (https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type).
	//
	//    * You can use this value to update an existing instance.
	//
	//    * To register a new instance, you must specify a value that is unique
	//    among instances that you register by using the same service.
	//
	//    * If you specify an existing InstanceId and ServiceId, AWS Cloud Map updates
	//    the existing DNS records. If there's also an existing health check, AWS
	//    Cloud Map deletes the old health check and creates a new one. The health
	//    check isn't deleted immediately, so it will still appear for a while if
	//    you submit a ListHealthChecks request, for example.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *Instance) SetAttributes(v map[string]*string) *Instance {
	s.Attributes = v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *Instance) SetCreatorRequestId(v string) *Instance {
	s.CreatorRequestId = &v
	return s
}

// SetId sets the Id field's value.
func (s *Instance) SetId(v string) *Instance {
	s.Id = &v
	return s
}

// No instance exists with the specified ID, or the instance was recently registered,
// and information about the instance hasn't propagated yet.
type InstanceNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InstanceNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceNotFound) GoString() string {
	return s.String()
}

func newErrorInstanceNotFound(v protocol.ResponseMetadata) error {
	return &InstanceNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InstanceNotFound) Code() string {
	return "InstanceNotFound"
}

// Message returns the exception's message.
func (s *InstanceNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InstanceNotFound) OrigErr() error {
	return nil
}

func (s *InstanceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InstanceNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InstanceNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type that contains information about the instances that you registered
// by using a specified service.
type InstanceSummary struct {
	_ struct{} `type:"structure"`

	// A string map that contains the following information:
	//
	//    * The attributes that are associate with the instance.
	//
	//    * For each attribute, the applicable value.
	//
	// Supported attribute keys include the following:
	//
	//    * AWS_ALIAS_DNS_NAME: For an alias record that routes traffic to an Elastic
	//    Load Balancing load balancer, the DNS name that is associated with the
	//    load balancer.
	//
	//    * AWS_EC2_INSTANCE_ID: (HTTP namespaces only) The Amazon EC2 instance
	//    ID for the instance. When the AWS_EC2_INSTANCE_ID attribute is specified,
	//    then the AWS_INSTANCE_IPV4 attribute contains the primary private IPv4
	//    address.
	//
	//    * AWS_INSTANCE_CNAME: For a CNAME record, the domain name that Route 53
	//    returns in response to DNS queries, for example, example.com.
	//
	//    * AWS_INSTANCE_IPV4: For an A record, the IPv4 address that Route 53 returns
	//    in response to DNS queries, for example, 192.0.2.44.
	//
	//    * AWS_INSTANCE_IPV6: For an AAAA record, the IPv6 address that Route 53
	//    returns in response to DNS queries, for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345.
	//
	//    * AWS_INSTANCE_PORT: For an SRV record, the value that Route 53 returns
	//    for the port. In addition, if the service includes HealthCheckConfig,
	//    the port on the endpoint that Route 53 sends requests to.
	Attributes map[string]*string `type:"map"`

	// The ID for an instance that you created by using a specified service.
	Id *string `type:"string"`
}

// String returns the string representation
func (s InstanceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceSummary) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *InstanceSummary) SetAttributes(v map[string]*string) *InstanceSummary {
	s.Attributes = v
	return s
}

// SetId sets the Id field's value.
func (s *InstanceSummary) SetId(v string) *InstanceSummary {
	s.Id = &v
	return s
}

// One or more specified values aren't valid. For example, a required value
// might be missing, a numeric value might be outside the allowed range, or
// a string value might exceed length constraints.
type InvalidInput struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s InvalidInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidInput) GoString() string {
	return s.String()
}

func newErrorInvalidInput(v protocol.ResponseMetadata) error {
	return &InvalidInput{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidInput) Code() string {
	return "InvalidInput"
}

// Message returns the exception's message.
func (s *InvalidInput) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidInput) OrigErr() error {
	return nil
}

func (s *InvalidInput) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidInput) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidInput) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListInstancesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of instances that you want AWS Cloud Map to return in
	// the response to a ListInstances request. If you don't specify a value for
	// MaxResults, AWS Cloud Map returns up to 100 instances.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListInstances request, omit this value.
	//
	// If more than MaxResults instances match the specified criteria, you can submit
	// another ListInstances request to get the next group of results. Specify the
	// value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`

	// The ID of the service that you want to list instances for.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ListInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListInstancesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListInstancesInput) SetMaxResults(v int64) *ListInstancesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstancesInput) SetNextToken(v string) *ListInstancesInput {
	s.NextToken = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *ListInstancesInput) SetServiceId(v string) *ListInstancesInput {
	s.ServiceId = &v
	return s
}

type ListInstancesOutput struct {
	_ struct{} `type:"structure"`

	// Summary information about the instances that are associated with the specified
	// service.
	Instances []*InstanceSummary `type:"list"`

	// If more than MaxResults instances match the specified criteria, you can submit
	// another ListInstances request to get the next group of results. Specify the
	// value of NextToken from the previous response in the next request.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *ListInstancesOutput) SetInstances(v []*InstanceSummary) *ListInstancesOutput {
	s.Instances = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListInstancesOutput) SetNextToken(v string) *ListInstancesOutput {
	s.NextToken = &v
	return s
}

type ListNamespacesInput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains specifications for the namespaces that you want
	// to list.
	//
	// If you specify more than one filter, a namespace must match all filters to
	// be returned by ListNamespaces.
	Filters []*NamespaceFilter `type:"list"`

	// The maximum number of namespaces that you want AWS Cloud Map to return in
	// the response to a ListNamespaces request. If you don't specify a value for
	// MaxResults, AWS Cloud Map returns up to 100 namespaces.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListNamespaces request, omit this value.
	//
	// If the response contains NextToken, submit another ListNamespaces request
	// to get the next group of results. Specify the value of NextToken from the
	// previous response in the next request.
	//
	// AWS Cloud Map gets MaxResults namespaces and then filters them based on the
	// specified criteria. It's possible that no namespaces in the first MaxResults
	// namespaces matched the specified criteria but that subsequent groups of MaxResults
	// namespaces do contain namespaces that match the criteria.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListNamespacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamespacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNamespacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNamespacesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListNamespacesInput) SetFilters(v []*NamespaceFilter) *ListNamespacesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNamespacesInput) SetMaxResults(v int64) *ListNamespacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamespacesInput) SetNextToken(v string) *ListNamespacesInput {
	s.NextToken = &v
	return s
}

type ListNamespacesOutput struct {
	_ struct{} `type:"structure"`

	// An array that contains one NamespaceSummary object for each namespace that
	// matches the specified filter criteria.
	Namespaces []*NamespaceSummary `type:"list"`

	// If the response contains NextToken, submit another ListNamespaces request
	// to get the next group of results. Specify the value of NextToken from the
	// previous response in the next request.
	//
	// AWS Cloud Map gets MaxResults namespaces and then filters them based on the
	// specified criteria. It's possible that no namespaces in the first MaxResults
	// namespaces matched the specified criteria but that subsequent groups of MaxResults
	// namespaces do contain namespaces that match the criteria.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListNamespacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListNamespacesOutput) GoString() string {
	return s.String()
}

// SetNamespaces sets the Namespaces field's value.
func (s *ListNamespacesOutput) SetNamespaces(v []*NamespaceSummary) *ListNamespacesOutput {
	s.Namespaces = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamespacesOutput) SetNextToken(v string) *ListNamespacesOutput {
	s.NextToken = &v
	return s
}

type ListOperationsInput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains specifications for the operations that you want
	// to list, for example, operations that you started between a specified start
	// date and end date.
	//
	// If you specify more than one filter, an operation must match all filters
	// to be returned by ListOperations.
	Filters []*OperationFilter `type:"list"`

	// The maximum number of items that you want AWS Cloud Map to return in the
	// response to a ListOperations request. If you don't specify a value for MaxResults,
	// AWS Cloud Map returns up to 100 operations.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListOperations request, omit this value.
	//
	// If the response contains NextToken, submit another ListOperations request
	// to get the next group of results. Specify the value of NextToken from the
	// previous response in the next request.
	//
	// AWS Cloud Map gets MaxResults operations and then filters them based on the
	// specified criteria. It's possible that no operations in the first MaxResults
	// operations matched the specified criteria but that subsequent groups of MaxResults
	// operations do contain operations that match the criteria.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListOperationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOperationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOperationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOperationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListOperationsInput) SetFilters(v []*OperationFilter) *ListOperationsInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOperationsInput) SetMaxResults(v int64) *ListOperationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOperationsInput) SetNextToken(v string) *ListOperationsInput {
	s.NextToken = &v
	return s
}

type ListOperationsOutput struct {
	_ struct{} `type:"structure"`

	// If the response contains NextToken, submit another ListOperations request
	// to get the next group of results. Specify the value of NextToken from the
	// previous response in the next request.
	//
	// AWS Cloud Map gets MaxResults operations and then filters them based on the
	// specified criteria. It's possible that no operations in the first MaxResults
	// operations matched the specified criteria but that subsequent groups of MaxResults
	// operations do contain operations that match the criteria.
	NextToken *string `type:"string"`

	// Summary information about the operations that match the specified criteria.
	Operations []*OperationSummary `type:"list"`
}

// String returns the string representation
func (s ListOperationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOperationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOperationsOutput) SetNextToken(v string) *ListOperationsOutput {
	s.NextToken = &v
	return s
}

// SetOperations sets the Operations field's value.
func (s *ListOperationsOutput) SetOperations(v []*OperationSummary) *ListOperationsOutput {
	s.Operations = v
	return s
}

type ListServicesInput struct {
	_ struct{} `type:"structure"`

	// A complex type that contains specifications for the namespaces that you want
	// to list services for.
	//
	// If you specify more than one filter, an operation must match all filters
	// to be returned by ListServices.
	Filters []*ServiceFilter `type:"list"`

	// The maximum number of services that you want AWS Cloud Map to return in the
	// response to a ListServices request. If you don't specify a value for MaxResults,
	// AWS Cloud Map returns up to 100 services.
	MaxResults *int64 `min:"1" type:"integer"`

	// For the first ListServices request, omit this value.
	//
	// If the response contains NextToken, submit another ListServices request to
	// get the next group of results. Specify the value of NextToken from the previous
	// response in the next request.
	//
	// AWS Cloud Map gets MaxResults services and then filters them based on the
	// specified criteria. It's possible that no services in the first MaxResults
	// services matched the specified criteria but that subsequent groups of MaxResults
	// services do contain services that match the criteria.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListServicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServicesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListServicesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListServicesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilters sets the Filters field's value.
func (s *ListServicesInput) SetFilters(v []*ServiceFilter) *ListServicesInput {
	s.Filters = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListServicesInput) SetMaxResults(v int64) *ListServicesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesInput) SetNextToken(v string) *ListServicesInput {
	s.NextToken = &v
	return s
}

type ListServicesOutput struct {
	_ struct{} `type:"structure"`

	// If the response contains NextToken, submit another ListServices request to
	// get the next group of results. Specify the value of NextToken from the previous
	// response in the next request.
	//
	// AWS Cloud Map gets MaxResults services and then filters them based on the
	// specified criteria. It's possible that no services in the first MaxResults
	// services matched the specified criteria but that subsequent groups of MaxResults
	// services do contain services that match the criteria.
	NextToken *string `type:"string"`

	// An array that contains one ServiceSummary object for each service that matches
	// the specified filter criteria.
	Services []*ServiceSummary `type:"list"`
}

// String returns the string representation
func (s ListServicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListServicesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListServicesOutput) SetNextToken(v string) *ListServicesOutput {
	s.NextToken = &v
	return s
}

// SetServices sets the Services field's value.
func (s *ListServicesOutput) SetServices(v []*ServiceSummary) *ListServicesOutput {
	s.Services = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to retrieve
	// tags for.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags that are assigned to the resource.
	Tags []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A complex type that contains information about a specified namespace.
type Namespace struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the namespace
	// when you create it.
	Arn *string `type:"string"`

	// The date that the namespace was created, in Unix date/time format and Coordinated
	// Universal Time (UTC). The value of CreateDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreateDate *time.Time `type:"timestamp"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of executing an operation twice.
	CreatorRequestId *string `type:"string"`

	// The description that you specify for the namespace when you create it.
	Description *string `type:"string"`

	// The ID of a namespace.
	Id *string `type:"string"`

	// The name of the namespace, such as example.com.
	Name *string `type:"string"`

	// A complex type that contains information that's specific to the type of the
	// namespace.
	Properties *NamespaceProperties `type:"structure"`

	// The number of services that are associated with the namespace.
	ServiceCount *int64 `type:"integer"`

	// The type of the namespace. The methods for discovering instances depends
	// on the value that you specify:
	//
	//    * HTTP: Instances can be discovered only programmatically, using the AWS
	//    Cloud Map DiscoverInstances API.
	//
	//    * DNS_PUBLIC: Instances can be discovered using public DNS queries and
	//    using the DiscoverInstances API.
	//
	//    * DNS_PRIVATE: Instances can be discovered using DNS queries in VPCs and
	//    using the DiscoverInstances API.
	Type *string `type:"string" enum:"NamespaceType"`
}

// String returns the string representation
func (s Namespace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Namespace) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Namespace) SetArn(v string) *Namespace {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Namespace) SetCreateDate(v time.Time) *Namespace {
	s.CreateDate = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *Namespace) SetCreatorRequestId(v string) *Namespace {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Namespace) SetDescription(v string) *Namespace {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Namespace) SetId(v string) *Namespace {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Namespace) SetName(v string) *Namespace {
	s.Name = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *Namespace) SetProperties(v *NamespaceProperties) *Namespace {
	s.Properties = v
	return s
}

// SetServiceCount sets the ServiceCount field's value.
func (s *Namespace) SetServiceCount(v int64) *Namespace {
	s.ServiceCount = &v
	return s
}

// SetType sets the Type field's value.
func (s *Namespace) SetType(v string) *Namespace {
	s.Type = &v
	return s
}

// The namespace that you're trying to create already exists.
type NamespaceAlreadyExists struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The CreatorRequestId that was used to create the namespace.
	CreatorRequestId *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the existing namespace.
	NamespaceId *string `type:"string"`
}

// String returns the string representation
func (s NamespaceAlreadyExists) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamespaceAlreadyExists) GoString() string {
	return s.String()
}

func newErrorNamespaceAlreadyExists(v protocol.ResponseMetadata) error {
	return &NamespaceAlreadyExists{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NamespaceAlreadyExists) Code() string {
	return "NamespaceAlreadyExists"
}

// Message returns the exception's message.
func (s *NamespaceAlreadyExists) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NamespaceAlreadyExists) OrigErr() error {
	return nil
}

func (s *NamespaceAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NamespaceAlreadyExists) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NamespaceAlreadyExists) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type that identifies the namespaces that you want to list. You
// can choose to list public or private namespaces.
type NamespaceFilter struct {
	_ struct{} `type:"structure"`

	// The operator that you want to use to determine whether ListNamespaces returns
	// a namespace. Valid values for condition include:
	//
	//    * EQ: When you specify EQ for the condition, you can choose to list only
	//    public namespaces or private namespaces, but not both. EQ is the default
	//    condition and can be omitted.
	//
	//    * IN: When you specify IN for the condition, you can choose to list public
	//    namespaces, private namespaces, or both.
	//
	//    * BETWEEN: Not applicable
	Condition *string `type:"string" enum:"FilterCondition"`

	// Specify TYPE.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"NamespaceFilterName"`

	// If you specify EQ for Condition, specify either DNS_PUBLIC or DNS_PRIVATE.
	//
	// If you specify IN for Condition, you can specify DNS_PUBLIC, DNS_PRIVATE,
	// or both.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s NamespaceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamespaceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NamespaceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NamespaceFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *NamespaceFilter) SetCondition(v string) *NamespaceFilter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *NamespaceFilter) SetName(v string) *NamespaceFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *NamespaceFilter) SetValues(v []*string) *NamespaceFilter {
	s.Values = v
	return s
}

// No namespace exists with the specified ID.
type NamespaceNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s NamespaceNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamespaceNotFound) GoString() string {
	return s.String()
}

func newErrorNamespaceNotFound(v protocol.ResponseMetadata) error {
	return &NamespaceNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NamespaceNotFound) Code() string {
	return "NamespaceNotFound"
}

// Message returns the exception's message.
func (s *NamespaceNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NamespaceNotFound) OrigErr() error {
	return nil
}

func (s *NamespaceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NamespaceNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NamespaceNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type that contains information that is specific to the namespace
// type.
type NamespaceProperties struct {
	_ struct{} `type:"structure"`

	// A complex type that contains the ID for the Route 53 hosted zone that AWS
	// Cloud Map creates when you create a namespace.
	DnsProperties *DnsProperties `type:"structure"`

	// A complex type that contains the name of an HTTP namespace.
	HttpProperties *HttpProperties `type:"structure"`
}

// String returns the string representation
func (s NamespaceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamespaceProperties) GoString() string {
	return s.String()
}

// SetDnsProperties sets the DnsProperties field's value.
func (s *NamespaceProperties) SetDnsProperties(v *DnsProperties) *NamespaceProperties {
	s.DnsProperties = v
	return s
}

// SetHttpProperties sets the HttpProperties field's value.
func (s *NamespaceProperties) SetHttpProperties(v *HttpProperties) *NamespaceProperties {
	s.HttpProperties = v
	return s
}

// A complex type that contains information about a namespace.
type NamespaceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the namespace
	// when you create it.
	Arn *string `type:"string"`

	// The date and time that the namespace was created.
	CreateDate *time.Time `type:"timestamp"`

	// A description for the namespace.
	Description *string `type:"string"`

	// The ID of the namespace.
	Id *string `type:"string"`

	// The name of the namespace. When you create a namespace, AWS Cloud Map automatically
	// creates a Route 53 hosted zone that has the same name as the namespace.
	Name *string `type:"string"`

	// A complex type that contains information that is specific to the namespace
	// type.
	Properties *NamespaceProperties `type:"structure"`

	// The number of services that were created using the namespace.
	ServiceCount *int64 `type:"integer"`

	// The type of the namespace, either public or private.
	Type *string `type:"string" enum:"NamespaceType"`
}

// String returns the string representation
func (s NamespaceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NamespaceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *NamespaceSummary) SetArn(v string) *NamespaceSummary {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *NamespaceSummary) SetCreateDate(v time.Time) *NamespaceSummary {
	s.CreateDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *NamespaceSummary) SetDescription(v string) *NamespaceSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *NamespaceSummary) SetId(v string) *NamespaceSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *NamespaceSummary) SetName(v string) *NamespaceSummary {
	s.Name = &v
	return s
}

// SetProperties sets the Properties field's value.
func (s *NamespaceSummary) SetProperties(v *NamespaceProperties) *NamespaceSummary {
	s.Properties = v
	return s
}

// SetServiceCount sets the ServiceCount field's value.
func (s *NamespaceSummary) SetServiceCount(v int64) *NamespaceSummary {
	s.ServiceCount = &v
	return s
}

// SetType sets the Type field's value.
func (s *NamespaceSummary) SetType(v string) *NamespaceSummary {
	s.Type = &v
	return s
}

// A complex type that contains information about a specified operation.
type Operation struct {
	_ struct{} `type:"structure"`

	// The date and time that the request was submitted, in Unix date/time format
	// and Coordinated Universal Time (UTC). The value of CreateDate is accurate
	// to milliseconds. For example, the value 1516925490.087 represents Friday,
	// January 26, 2018 12:11:30.087 AM.
	CreateDate *time.Time `type:"timestamp"`

	// The code associated with ErrorMessage. Values for ErrorCode include the following:
	//
	//    * ACCESS_DENIED
	//
	//    * CANNOT_CREATE_HOSTED_ZONE
	//
	//    * EXPIRED_TOKEN
	//
	//    * HOSTED_ZONE_NOT_FOUND
	//
	//    * INTERNAL_FAILURE
	//
	//    * INVALID_CHANGE_BATCH
	//
	//    * THROTTLED_REQUEST
	ErrorCode *string `type:"string"`

	// If the value of Status is FAIL, the reason that the operation failed.
	ErrorMessage *string `type:"string"`

	// The ID of the operation that you want to get information about.
	Id *string `type:"string"`

	// The status of the operation. Values include the following:
	//
	//    * SUBMITTED: This is the initial state immediately after you submit a
	//    request.
	//
	//    * PENDING: AWS Cloud Map is performing the operation.
	//
	//    * SUCCESS: The operation succeeded.
	//
	//    * FAIL: The operation failed. For the failure reason, see ErrorMessage.
	Status *string `type:"string" enum:"OperationStatus"`

	// The name of the target entity that is associated with the operation:
	//
	//    * NAMESPACE: The namespace ID is returned in the ResourceId property.
	//
	//    * SERVICE: The service ID is returned in the ResourceId property.
	//
	//    * INSTANCE: The instance ID is returned in the ResourceId property.
	Targets map[string]*string `type:"map"`

	// The name of the operation that is associated with the specified ID.
	Type *string `type:"string" enum:"OperationType"`

	// The date and time that the value of Status changed to the current value,
	// in Unix date/time format and Coordinated Universal Time (UTC). The value
	// of UpdateDate is accurate to milliseconds. For example, the value 1516925490.087
	// represents Friday, January 26, 2018 12:11:30.087 AM.
	UpdateDate *time.Time `type:"timestamp"`
}

// String returns the string representation
func (s Operation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Operation) GoString() string {
	return s.String()
}

// SetCreateDate sets the CreateDate field's value.
func (s *Operation) SetCreateDate(v time.Time) *Operation {
	s.CreateDate = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Operation) SetErrorCode(v string) *Operation {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *Operation) SetErrorMessage(v string) *Operation {
	s.ErrorMessage = &v
	return s
}

// SetId sets the Id field's value.
func (s *Operation) SetId(v string) *Operation {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Operation) SetStatus(v string) *Operation {
	s.Status = &v
	return s
}

// SetTargets sets the Targets field's value.
func (s *Operation) SetTargets(v map[string]*string) *Operation {
	s.Targets = v
	return s
}

// SetType sets the Type field's value.
func (s *Operation) SetType(v string) *Operation {
	s.Type = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *Operation) SetUpdateDate(v time.Time) *Operation {
	s.UpdateDate = &v
	return s
}

// A complex type that lets you select the operations that you want to list.
type OperationFilter struct {
	_ struct{} `type:"structure"`

	// The operator that you want to use to determine whether an operation matches
	// the specified value. Valid values for condition include:
	//
	//    * EQ: When you specify EQ for the condition, you can specify only one
	//    value. EQ is supported for NAMESPACE_ID, SERVICE_ID, STATUS, and TYPE.
	//    EQ is the default condition and can be omitted.
	//
	//    * IN: When you specify IN for the condition, you can specify a list of
	//    one or more values. IN is supported for STATUS and TYPE. An operation
	//    must match one of the specified values to be returned in the response.
	//
	//    * BETWEEN: Specify a start date and an end date in Unix date/time format
	//    and Coordinated Universal Time (UTC). The start date must be the first
	//    value. BETWEEN is supported for UPDATE_DATE.
	Condition *string `type:"string" enum:"FilterCondition"`

	// Specify the operations that you want to get:
	//
	//    * NAMESPACE_ID: Gets operations related to specified namespaces.
	//
	//    * SERVICE_ID: Gets operations related to specified services.
	//
	//    * STATUS: Gets operations based on the status of the operations: SUBMITTED,
	//    PENDING, SUCCEED, or FAIL.
	//
	//    * TYPE: Gets specified types of operation.
	//
	//    * UPDATE_DATE: Gets operations that changed status during a specified
	//    date/time range.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"OperationFilterName"`

	// Specify values that are applicable to the value that you specify for Name:
	//
	//    * NAMESPACE_ID: Specify one namespace ID.
	//
	//    * SERVICE_ID: Specify one service ID.
	//
	//    * STATUS: Specify one or more statuses: SUBMITTED, PENDING, SUCCEED, or
	//    FAIL.
	//
	//    * TYPE: Specify one or more of the following types: CREATE_NAMESPACE,
	//    DELETE_NAMESPACE, UPDATE_SERVICE, REGISTER_INSTANCE, or DEREGISTER_INSTANCE.
	//
	//    * UPDATE_DATE: Specify a start date and an end date in Unix date/time
	//    format and Coordinated Universal Time (UTC). The start date must be the
	//    first value.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s OperationFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OperationFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OperationFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *OperationFilter) SetCondition(v string) *OperationFilter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *OperationFilter) SetName(v string) *OperationFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *OperationFilter) SetValues(v []*string) *OperationFilter {
	s.Values = v
	return s
}

// No operation exists with the specified ID.
type OperationNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s OperationNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationNotFound) GoString() string {
	return s.String()
}

func newErrorOperationNotFound(v protocol.ResponseMetadata) error {
	return &OperationNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationNotFound) Code() string {
	return "OperationNotFound"
}

// Message returns the exception's message.
func (s *OperationNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationNotFound) OrigErr() error {
	return nil
}

func (s *OperationNotFound) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type that contains information about an operation that matches
// the criteria that you specified in a ListOperations (https://docs.aws.amazon.com/cloud-map/latest/api/API_ListOperations.html)
// request.
type OperationSummary struct {
	_ struct{} `type:"structure"`

	// The ID for an operation.
	Id *string `type:"string"`

	// The status of the operation. Values include the following:
	//
	//    * SUBMITTED: This is the initial state immediately after you submit a
	//    request.
	//
	//    * PENDING: AWS Cloud Map is performing the operation.
	//
	//    * SUCCESS: The operation succeeded.
	//
	//    * FAIL: The operation failed. For the failure reason, see ErrorMessage.
	Status *string `type:"string" enum:"OperationStatus"`
}

// String returns the string representation
func (s OperationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationSummary) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *OperationSummary) SetId(v string) *OperationSummary {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *OperationSummary) SetStatus(v string) *OperationSummary {
	s.Status = &v
	return s
}

type RegisterInstanceInput struct {
	_ struct{} `type:"structure"`

	// A string map that contains the following information for the service that
	// you specify in ServiceId:
	//
	//    * The attributes that apply to the records that are defined in the service.
	//
	//    * For each attribute, the applicable value.
	//
	// Supported attribute keys include the following:
	//
	// AWS_ALIAS_DNS_NAME
	//
	// If you want AWS Cloud Map to create an Amazon Route 53 alias record that
	// routes traffic to an Elastic Load Balancing load balancer, specify the DNS
	// name that is associated with the load balancer. For information about how
	// to get the DNS name, see "DNSName" in the topic AliasTarget (https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html)
	// in the Route 53 API Reference.
	//
	// Note the following:
	//
	//    * The configuration for the service that is specified by ServiceId must
	//    include settings for an A record, an AAAA record, or both.
	//
	//    * In the service that is specified by ServiceId, the value of RoutingPolicy
	//    must be WEIGHTED.
	//
	//    * If the service that is specified by ServiceId includes HealthCheckConfig
	//    settings, AWS Cloud Map will create the Route 53 health check, but it
	//    won't associate the health check with the alias record.
	//
	//    * Auto naming currently doesn't support creating alias records that route
	//    traffic to AWS resources other than Elastic Load Balancing load balancers.
	//
	//    * If you specify a value for AWS_ALIAS_DNS_NAME, don't specify values
	//    for any of the AWS_INSTANCE attributes.
	//
	// AWS_EC2_INSTANCE_ID
	//
	// HTTP namespaces only. The Amazon EC2 instance ID for the instance. If the
	// AWS_EC2_INSTANCE_ID attribute is specified, then the only other attribute
	// that can be specified is AWS_INIT_HEALTH_STATUS. When the AWS_EC2_INSTANCE_ID
	// attribute is specified, then the AWS_INSTANCE_IPV4 attribute will be filled
	// out with the primary private IPv4 address.
	//
	// AWS_INIT_HEALTH_STATUS
	//
	// If the service configuration includes HealthCheckCustomConfig, you can optionally
	// use AWS_INIT_HEALTH_STATUS to specify the initial status of the custom health
	// check, HEALTHY or UNHEALTHY. If you don't specify a value for AWS_INIT_HEALTH_STATUS,
	// the initial status is HEALTHY.
	//
	// AWS_INSTANCE_CNAME
	//
	// If the service configuration includes a CNAME record, the domain name that
	// you want Route 53 to return in response to DNS queries, for example, example.com.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an CNAME record.
	//
	// AWS_INSTANCE_IPV4
	//
	// If the service configuration includes an A record, the IPv4 address that
	// you want Route 53 to return in response to DNS queries, for example, 192.0.2.44.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an A record. If the service includes settings for an SRV record, you
	// must specify a value for AWS_INSTANCE_IPV4, AWS_INSTANCE_IPV6, or both.
	//
	// AWS_INSTANCE_IPV6
	//
	// If the service configuration includes an AAAA record, the IPv6 address that
	// you want Route 53 to return in response to DNS queries, for example, 2001:0db8:85a3:0000:0000:abcd:0001:2345.
	//
	// This value is required if the service specified by ServiceId includes settings
	// for an AAAA record. If the service includes settings for an SRV record, you
	// must specify a value for AWS_INSTANCE_IPV4, AWS_INSTANCE_IPV6, or both.
	//
	// AWS_INSTANCE_PORT
	//
	// If the service includes an SRV record, the value that you want Route 53 to
	// return for the port.
	//
	// If the service includes HealthCheckConfig, the port on the endpoint that
	// you want Route 53 to send requests to.
	//
	// This value is required if you specified settings for an SRV record or a Route
	// 53 health check when you created the service.
	//
	// Custom attributes
	//
	// You can add up to 30 custom attributes. For each key-value pair, the maximum
	// length of the attribute name is 255 characters, and the maximum length of
	// the attribute value is 1,024 characters. The total size of all provided attributes
	// (sum of all keys and values) must not exceed 5,000 characters.
	//
	// Attributes is a required field
	Attributes map[string]*string `type:"map" required:"true"`

	// A unique string that identifies the request and that allows failed RegisterInstance
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CreatorRequestId string every time you submit a RegisterInstance
	// request if you're registering additional instances for the same namespace
	// and service. CreatorRequestId can be any unique string, for example, a date/time
	// stamp.
	CreatorRequestId *string `type:"string" idempotencyToken:"true"`

	// An identifier that you want to associate with the instance. Note the following:
	//
	//    * If the service that is specified by ServiceId includes settings for
	//    an SRV record, the value of InstanceId is automatically included as part
	//    of the value for the SRV record. For more information, see DnsRecord >
	//    Type (https://docs.aws.amazon.com/cloud-map/latest/api/API_DnsRecord.html#cloudmap-Type-DnsRecord-Type).
	//
	//    * You can use this value to update an existing instance.
	//
	//    * To register a new instance, you must specify a value that is unique
	//    among instances that you register by using the same service.
	//
	//    * If you specify an existing InstanceId and ServiceId, AWS Cloud Map updates
	//    the existing DNS records, if any. If there's also an existing health check,
	//    AWS Cloud Map deletes the old health check and creates a new one. The
	//    health check isn't deleted immediately, so it will still appear for a
	//    while if you submit a ListHealthChecks request, for example.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The ID of the service that you want to use for settings for the instance.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterInstanceInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *RegisterInstanceInput) SetAttributes(v map[string]*string) *RegisterInstanceInput {
	s.Attributes = v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *RegisterInstanceInput) SetCreatorRequestId(v string) *RegisterInstanceInput {
	s.CreatorRequestId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *RegisterInstanceInput) SetInstanceId(v string) *RegisterInstanceInput {
	s.InstanceId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *RegisterInstanceInput) SetServiceId(v string) *RegisterInstanceInput {
	s.ServiceId = &v
	return s
}

type RegisterInstanceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation (https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html).
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s RegisterInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegisterInstanceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *RegisterInstanceOutput) SetOperationId(v string) *RegisterInstanceOutput {
	s.OperationId = &v
	return s
}

// The operation can't be completed because you've reached the quota for the
// number of requests. For more information, see AWS Cloud Map API request throttling
// quota (https://docs.aws.amazon.com/cloud-map/latest/dg/throttling.html) in
// the AWS Cloud Map Developer Guide.
type RequestLimitExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s RequestLimitExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestLimitExceeded) GoString() string {
	return s.String()
}

func newErrorRequestLimitExceeded(v protocol.ResponseMetadata) error {
	return &RequestLimitExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *RequestLimitExceeded) Code() string {
	return "RequestLimitExceeded"
}

// Message returns the exception's message.
func (s *RequestLimitExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *RequestLimitExceeded) OrigErr() error {
	return nil
}

func (s *RequestLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *RequestLimitExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *RequestLimitExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource can't be deleted because it contains other resources.
// For example, you can't delete a service that contains any instances.
type ResourceInUse struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceInUse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceInUse) GoString() string {
	return s.String()
}

func newErrorResourceInUse(v protocol.ResponseMetadata) error {
	return &ResourceInUse{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceInUse) Code() string {
	return "ResourceInUse"
}

// Message returns the exception's message.
func (s *ResourceInUse) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceInUse) OrigErr() error {
	return nil
}

func (s *ResourceInUse) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceInUse) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceInUse) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource can't be created because you've reached the quota on the number
// of resources.
type ResourceLimitExceeded struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceLimitExceeded) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceLimitExceeded) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceeded(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceeded{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceeded) Code() string {
	return "ResourceLimitExceeded"
}

// Message returns the exception's message.
func (s *ResourceLimitExceeded) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceeded) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceeded) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceeded) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceeded) RequestID() string {
	return s.RespMetadata.RequestID
}

// The operation can't be completed because the resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type that contains information about the specified service.
type Service struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the service
	// when you create it.
	Arn *string `type:"string"`

	// The date and time that the service was created, in Unix format and Coordinated
	// Universal Time (UTC). The value of CreateDate is accurate to milliseconds.
	// For example, the value 1516925490.087 represents Friday, January 26, 2018
	// 12:11:30.087 AM.
	CreateDate *time.Time `type:"timestamp"`

	// A unique string that identifies the request and that allows failed requests
	// to be retried without the risk of executing the operation twice. CreatorRequestId
	// can be any unique string, for example, a date/time stamp.
	CreatorRequestId *string `type:"string"`

	// The description of the service.
	Description *string `type:"string"`

	// A complex type that contains information about the Route 53 DNS records that
	// you want AWS Cloud Map to create when you register an instance.
	DnsConfig *DnsConfig `type:"structure"`

	// Public DNS and HTTP namespaces only. A complex type that contains settings
	// for an optional health check. If you specify settings for a health check,
	// AWS Cloud Map associates the health check with the records that you specify
	// in DnsConfig.
	//
	// For information about the charges for health checks, see Amazon Route 53
	// Pricing (http://aws.amazon.com/route53/pricing/).
	HealthCheckConfig *HealthCheckConfig `type:"structure"`

	// A complex type that contains information about an optional custom health
	// check.
	//
	// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
	// or HealthCheckConfig but not both.
	HealthCheckCustomConfig *HealthCheckCustomConfig `type:"structure"`

	// The ID that AWS Cloud Map assigned to the service when you created it.
	Id *string `type:"string"`

	// The number of instances that are currently associated with the service. Instances
	// that were previously associated with the service but that have been deleted
	// are not included in the count. The count might not reflect pending registrations
	// and deregistrations.
	InstanceCount *int64 `type:"integer"`

	// The name of the service.
	Name *string `type:"string"`

	// The ID of the namespace that was used to create the service.
	NamespaceId *string `type:"string"`

	// Describes the systems that can be used to discover the service instances.
	//
	// DNS_HTTP
	//
	// The service instances can be discovered using either DNS queries or the DiscoverInstances
	// API operation.
	//
	// HTTP
	//
	// The service instances can only be discovered using the DiscoverInstances
	// API operation.
	//
	// DNS
	//
	// Reserved.
	Type *string `type:"string" enum:"ServiceType"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Service) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Service) SetArn(v string) *Service {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *Service) SetCreateDate(v time.Time) *Service {
	s.CreateDate = &v
	return s
}

// SetCreatorRequestId sets the CreatorRequestId field's value.
func (s *Service) SetCreatorRequestId(v string) *Service {
	s.CreatorRequestId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Service) SetDescription(v string) *Service {
	s.Description = &v
	return s
}

// SetDnsConfig sets the DnsConfig field's value.
func (s *Service) SetDnsConfig(v *DnsConfig) *Service {
	s.DnsConfig = v
	return s
}

// SetHealthCheckConfig sets the HealthCheckConfig field's value.
func (s *Service) SetHealthCheckConfig(v *HealthCheckConfig) *Service {
	s.HealthCheckConfig = v
	return s
}

// SetHealthCheckCustomConfig sets the HealthCheckCustomConfig field's value.
func (s *Service) SetHealthCheckCustomConfig(v *HealthCheckCustomConfig) *Service {
	s.HealthCheckCustomConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *Service) SetId(v string) *Service {
	s.Id = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *Service) SetInstanceCount(v int64) *Service {
	s.InstanceCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *Service) SetName(v string) *Service {
	s.Name = &v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *Service) SetNamespaceId(v string) *Service {
	s.NamespaceId = &v
	return s
}

// SetType sets the Type field's value.
func (s *Service) SetType(v string) *Service {
	s.Type = &v
	return s
}

// The service can't be created because a service with the same name already
// exists.
type ServiceAlreadyExists struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The CreatorRequestId that was used to create the service.
	CreatorRequestId *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`

	// The ID of the existing service.
	ServiceId *string `type:"string"`
}

// String returns the string representation
func (s ServiceAlreadyExists) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceAlreadyExists) GoString() string {
	return s.String()
}

func newErrorServiceAlreadyExists(v protocol.ResponseMetadata) error {
	return &ServiceAlreadyExists{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceAlreadyExists) Code() string {
	return "ServiceAlreadyExists"
}

// Message returns the exception's message.
func (s *ServiceAlreadyExists) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceAlreadyExists) OrigErr() error {
	return nil
}

func (s *ServiceAlreadyExists) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceAlreadyExists) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceAlreadyExists) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type that contains changes to an existing service.
type ServiceChange struct {
	_ struct{} `type:"structure"`

	// A description for the service.
	Description *string `type:"string"`

	// A complex type that contains information about the Route 53 DNS records that
	// you want AWS Cloud Map to create when you register an instance.
	DnsConfig *DnsConfigChange `type:"structure"`

	// Public DNS and HTTP namespaces only. A complex type that contains settings
	// for an optional health check. If you specify settings for a health check,
	// AWS Cloud Map associates the health check with the records that you specify
	// in DnsConfig.
	//
	// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
	// or HealthCheckConfig but not both.
	//
	// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
	// For information about pricing for health checks, see Amazon Route 53 Pricing
	// (http://aws.amazon.com/route53/pricing/).
	//
	// Note the following about configuring health checks.
	//
	//  A and AAAA records
	//
	// If DnsConfig includes configurations for both A and AAAA records, AWS Cloud
	// Map creates a health check that uses the IPv4 address to check the health
	// of the resource. If the endpoint that is specified by the IPv4 address is
	// unhealthy, Route 53 considers both the A and AAAA records to be unhealthy.
	//
	//  CNAME records
	//
	// You can't specify settings for HealthCheckConfig when the DNSConfig includes
	// CNAME for the value of Type. If you do, the CreateService request will fail
	// with an InvalidInput error.
	//
	// Request interval
	//
	// A Route 53 health checker in each health-checking region sends a health check
	// request to an endpoint every 30 seconds. On average, your endpoint receives
	// a health check request about every two seconds. However, health checkers
	// don't coordinate with one another, so you'll sometimes see several requests
	// per second followed by a few seconds with no health checks at all.
	//
	// Health checking regions
	//
	// Health checkers perform checks from all Route 53 health-checking regions.
	// For a list of the current regions, see Regions (https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions).
	//
	// Alias records
	//
	// When you register an instance, if you include the AWS_ALIAS_DNS_NAME attribute,
	// AWS Cloud Map creates a Route 53 alias record. Note the following:
	//
	//    * Route 53 automatically sets EvaluateTargetHealth to true for alias records.
	//    When EvaluateTargetHealth is true, the alias record inherits the health
	//    of the referenced AWS resource. such as an ELB load balancer. For more
	//    information, see EvaluateTargetHealth (https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-EvaluateTargetHealth).
	//
	//    * If you include HealthCheckConfig and then use the service to register
	//    an instance that creates an alias record, Route 53 doesn't create the
	//    health check.
	//
	// Charges for health checks
	//
	// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
	// For information about pricing for health checks, see Amazon Route 53 Pricing
	// (http://aws.amazon.com/route53/pricing/).
	HealthCheckConfig *HealthCheckConfig `type:"structure"`
}

// String returns the string representation
func (s ServiceChange) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceChange) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceChange) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceChange"}
	if s.DnsConfig != nil {
		if err := s.DnsConfig.Validate(); err != nil {
			invalidParams.AddNested("DnsConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.HealthCheckConfig != nil {
		if err := s.HealthCheckConfig.Validate(); err != nil {
			invalidParams.AddNested("HealthCheckConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *ServiceChange) SetDescription(v string) *ServiceChange {
	s.Description = &v
	return s
}

// SetDnsConfig sets the DnsConfig field's value.
func (s *ServiceChange) SetDnsConfig(v *DnsConfigChange) *ServiceChange {
	s.DnsConfig = v
	return s
}

// SetHealthCheckConfig sets the HealthCheckConfig field's value.
func (s *ServiceChange) SetHealthCheckConfig(v *HealthCheckConfig) *ServiceChange {
	s.HealthCheckConfig = v
	return s
}

// A complex type that lets you specify the namespaces that you want to list
// services for.
type ServiceFilter struct {
	_ struct{} `type:"structure"`

	// The operator that you want to use to determine whether a service is returned
	// by ListServices. Valid values for Condition include the following:
	//
	//    * EQ: When you specify EQ, specify one namespace ID for Values. EQ is
	//    the default condition and can be omitted.
	//
	//    * IN: When you specify IN, specify a list of the IDs for the namespaces
	//    that you want ListServices to return a list of services for.
	//
	//    * BETWEEN: Not applicable.
	Condition *string `type:"string" enum:"FilterCondition"`

	// Specify NAMESPACE_ID.
	//
	// Name is a required field
	Name *string `type:"string" required:"true" enum:"ServiceFilterName"`

	// The values that are applicable to the value that you specify for Condition
	// to filter the list of services.
	//
	// Values is a required field
	Values []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s ServiceFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ServiceFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ServiceFilter"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Values == nil {
		invalidParams.Add(request.NewErrParamRequired("Values"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCondition sets the Condition field's value.
func (s *ServiceFilter) SetCondition(v string) *ServiceFilter {
	s.Condition = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceFilter) SetName(v string) *ServiceFilter {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *ServiceFilter) SetValues(v []*string) *ServiceFilter {
	s.Values = v
	return s
}

// No service exists with the specified ID.
type ServiceNotFound struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation
func (s ServiceNotFound) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceNotFound) GoString() string {
	return s.String()
}

func newErrorServiceNotFound(v protocol.ResponseMetadata) error {
	return &ServiceNotFound{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceNotFound) Code() string {
	return "ServiceNotFound"
}

// Message returns the exception's message.
func (s *ServiceNotFound) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceNotFound) OrigErr() error {
	return nil
}

func (s *ServiceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceNotFound) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceNotFound) RequestID() string {
	return s.RespMetadata.RequestID
}

// A complex type that contains information about a specified service.
type ServiceSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that AWS Cloud Map assigns to the service
	// when you create it.
	Arn *string `type:"string"`

	// The date and time that the service was created.
	CreateDate *time.Time `type:"timestamp"`

	// The description that you specify when you create the service.
	Description *string `type:"string"`

	// A complex type that contains information about the Amazon Route 53 DNS records
	// that you want AWS Cloud Map to create when you register an instance.
	DnsConfig *DnsConfig `type:"structure"`

	// Public DNS and HTTP namespaces only. A complex type that contains settings
	// for an optional health check. If you specify settings for a health check,
	// AWS Cloud Map associates the health check with the records that you specify
	// in DnsConfig.
	//
	// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
	// or HealthCheckConfig but not both.
	//
	// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
	// For information about pricing for health checks, see Amazon Route 53 Pricing
	// (http://aws.amazon.com/route53/pricing/).
	//
	// Note the following about configuring health checks.
	//
	//  A and AAAA records
	//
	// If DnsConfig includes configurations for both A and AAAA records, AWS Cloud
	// Map creates a health check that uses the IPv4 address to check the health
	// of the resource. If the endpoint that is specified by the IPv4 address is
	// unhealthy, Route 53 considers both the A and AAAA records to be unhealthy.
	//
	//  CNAME records
	//
	// You can't specify settings for HealthCheckConfig when the DNSConfig includes
	// CNAME for the value of Type. If you do, the CreateService request will fail
	// with an InvalidInput error.
	//
	// Request interval
	//
	// A Route 53 health checker in each health-checking region sends a health check
	// request to an endpoint every 30 seconds. On average, your endpoint receives
	// a health check request about every two seconds. However, health checkers
	// don't coordinate with one another, so you'll sometimes see several requests
	// per second followed by a few seconds with no health checks at all.
	//
	// Health checking regions
	//
	// Health checkers perform checks from all Route 53 health-checking regions.
	// For a list of the current regions, see Regions (https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions).
	//
	// Alias records
	//
	// When you register an instance, if you include the AWS_ALIAS_DNS_NAME attribute,
	// AWS Cloud Map creates a Route 53 alias record. Note the following:
	//
	//    * Route 53 automatically sets EvaluateTargetHealth to true for alias records.
	//    When EvaluateTargetHealth is true, the alias record inherits the health
	//    of the referenced AWS resource. such as an ELB load balancer. For more
	//    information, see EvaluateTargetHealth (https://docs.aws.amazon.com/Route53/latest/APIReference/API_AliasTarget.html#Route53-Type-AliasTarget-EvaluateTargetHealth).
	//
	//    * If you include HealthCheckConfig and then use the service to register
	//    an instance that creates an alias record, Route 53 doesn't create the
	//    health check.
	//
	// Charges for health checks
	//
	// Health checks are basic Route 53 health checks that monitor an AWS endpoint.
	// For information about pricing for health checks, see Amazon Route 53 Pricing
	// (http://aws.amazon.com/route53/pricing/).
	HealthCheckConfig *HealthCheckConfig `type:"structure"`

	// A complex type that contains information about an optional custom health
	// check. A custom health check, which requires that you use a third-party health
	// checker to evaluate the health of your resources, is useful in the following
	// circumstances:
	//
	//    * You can't use a health check that is defined by HealthCheckConfig because
	//    the resource isn't available over the internet. For example, you can use
	//    a custom health check when the instance is in an Amazon VPC. (To check
	//    the health of resources in a VPC, the health checker must also be in the
	//    VPC.)
	//
	//    * You want to use a third-party health checker regardless of where your
	//    resources are.
	//
	// If you specify a health check configuration, you can specify either HealthCheckCustomConfig
	// or HealthCheckConfig but not both.
	//
	// To change the status of a custom health check, submit an UpdateInstanceCustomHealthStatus
	// request. AWS Cloud Map doesn't monitor the status of the resource, it just
	// keeps a record of the status specified in the most recent UpdateInstanceCustomHealthStatus
	// request.
	//
	// Here's how custom health checks work:
	//
	// You create a service and specify a value for FailureThreshold.
	//
	// The failure threshold indicates the number of 30-second intervals you want
	// AWS Cloud Map to wait between the time that your application sends an UpdateInstanceCustomHealthStatus
	// (https://docs.aws.amazon.com/cloud-map/latest/api/API_UpdateInstanceCustomHealthStatus.html)
	// request and the time that AWS Cloud Map stops routing internet traffic to
	// the corresponding resource.
	//
	// You register an instance.
	//
	// You configure a third-party health checker to monitor the resource that is
	// associated with the new instance.
	//
	// AWS Cloud Map doesn't check the health of the resource directly.
	//
	// The third-party health-checker determines that the resource is unhealthy
	// and notifies your application.
	//
	// Your application submits an UpdateInstanceCustomHealthStatus request.
	//
	// AWS Cloud Map waits for (FailureThreshold x 30) seconds.
	//
	// If another UpdateInstanceCustomHealthStatus request doesn't arrive during
	// that time to change the status back to healthy, AWS Cloud Map stops routing
	// traffic to the resource.
	HealthCheckCustomConfig *HealthCheckCustomConfig `type:"structure"`

	// The ID that AWS Cloud Map assigned to the service when you created it.
	Id *string `type:"string"`

	// The number of instances that are currently associated with the service. Instances
	// that were previously associated with the service but that have been deleted
	// are not included in the count. The count might not reflect pending registrations
	// and deregistrations.
	InstanceCount *int64 `type:"integer"`

	// The name of the service.
	Name *string `type:"string"`

	// Describes the systems that can be used to discover the service instances.
	//
	// DNS_HTTP
	//
	// The service instances can be discovered using either DNS queries or the DiscoverInstances
	// API operation.
	//
	// HTTP
	//
	// The service instances can only be discovered using the DiscoverInstances
	// API operation.
	//
	// DNS
	//
	// Reserved.
	Type *string `type:"string" enum:"ServiceType"`
}

// String returns the string representation
func (s ServiceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ServiceSummary) SetArn(v string) *ServiceSummary {
	s.Arn = &v
	return s
}

// SetCreateDate sets the CreateDate field's value.
func (s *ServiceSummary) SetCreateDate(v time.Time) *ServiceSummary {
	s.CreateDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ServiceSummary) SetDescription(v string) *ServiceSummary {
	s.Description = &v
	return s
}

// SetDnsConfig sets the DnsConfig field's value.
func (s *ServiceSummary) SetDnsConfig(v *DnsConfig) *ServiceSummary {
	s.DnsConfig = v
	return s
}

// SetHealthCheckConfig sets the HealthCheckConfig field's value.
func (s *ServiceSummary) SetHealthCheckConfig(v *HealthCheckConfig) *ServiceSummary {
	s.HealthCheckConfig = v
	return s
}

// SetHealthCheckCustomConfig sets the HealthCheckCustomConfig field's value.
func (s *ServiceSummary) SetHealthCheckCustomConfig(v *HealthCheckCustomConfig) *ServiceSummary {
	s.HealthCheckCustomConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *ServiceSummary) SetId(v string) *ServiceSummary {
	s.Id = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ServiceSummary) SetInstanceCount(v int64) *ServiceSummary {
	s.InstanceCount = &v
	return s
}

// SetName sets the Name field's value.
func (s *ServiceSummary) SetName(v string) *ServiceSummary {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *ServiceSummary) SetType(v string) *ServiceSummary {
	s.Type = &v
	return s
}

// A custom key-value pair associated with a resource.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key identifier, or name, of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The string value associated with the key of the tag. You can set the value
	// of a tag to an empty string, but you can't set the value of a tag to null.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to retrieve
	// tags for.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tags to add to the specified resource. Specifying the tag key is required.
	// You can set the value of a tag to an empty string, but you can't set the
	// value of a tag to null.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The list of tags on the resource is over the quota. The maximum number of
// tags that can be applied to a resource is 50.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The name of the resource.
	ResourceName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource that you want to retrieve
	// tags for.
	//
	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// The tag keys to remove from the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateInstanceCustomHealthStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the instance that you want to change the health status for.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`

	// The ID of the service that includes the configuration for the custom health
	// check that you want to change the status for.
	//
	// ServiceId is a required field
	ServiceId *string `type:"string" required:"true"`

	// The new status of the instance, HEALTHY or UNHEALTHY.
	//
	// Status is a required field
	Status *string `type:"string" required:"true" enum:"CustomHealthStatus"`
}

// String returns the string representation
func (s UpdateInstanceCustomHealthStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInstanceCustomHealthStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateInstanceCustomHealthStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateInstanceCustomHealthStatusInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.ServiceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceId"))
	}
	if s.Status == nil {
		invalidParams.Add(request.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *UpdateInstanceCustomHealthStatusInput) SetInstanceId(v string) *UpdateInstanceCustomHealthStatusInput {
	s.InstanceId = &v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *UpdateInstanceCustomHealthStatusInput) SetServiceId(v string) *UpdateInstanceCustomHealthStatusInput {
	s.ServiceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *UpdateInstanceCustomHealthStatusInput) SetStatus(v string) *UpdateInstanceCustomHealthStatusInput {
	s.Status = &v
	return s
}

type UpdateInstanceCustomHealthStatusOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateInstanceCustomHealthStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateInstanceCustomHealthStatusOutput) GoString() string {
	return s.String()
}

type UpdateServiceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the service that you want to update.
	//
	// Id is a required field
	Id *string `type:"string" required:"true"`

	// A complex type that contains the new settings for the service.
	//
	// Service is a required field
	Service *ServiceChange `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateServiceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServiceInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Service == nil {
		invalidParams.Add(request.NewErrParamRequired("Service"))
	}
	if s.Service != nil {
		if err := s.Service.Validate(); err != nil {
			invalidParams.AddNested("Service", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *UpdateServiceInput) SetId(v string) *UpdateServiceInput {
	s.Id = &v
	return s
}

// SetService sets the Service field's value.
func (s *UpdateServiceInput) SetService(v *ServiceChange) *UpdateServiceInput {
	s.Service = v
	return s
}

type UpdateServiceOutput struct {
	_ struct{} `type:"structure"`

	// A value that you can use to determine whether the request completed successfully.
	// To get the status of the operation, see GetOperation (https://docs.aws.amazon.com/cloud-map/latest/api/API_GetOperation.html).
	OperationId *string `type:"string"`
}

// String returns the string representation
func (s UpdateServiceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServiceOutput) GoString() string {
	return s.String()
}

// SetOperationId sets the OperationId field's value.
func (s *UpdateServiceOutput) SetOperationId(v string) *UpdateServiceOutput {
	s.OperationId = &v
	return s
}

const (
	// CustomHealthStatusHealthy is a CustomHealthStatus enum value
	CustomHealthStatusHealthy = "HEALTHY"

	// CustomHealthStatusUnhealthy is a CustomHealthStatus enum value
	CustomHealthStatusUnhealthy = "UNHEALTHY"
)

// CustomHealthStatus_Values returns all elements of the CustomHealthStatus enum
func CustomHealthStatus_Values() []string {
	return []string{
		CustomHealthStatusHealthy,
		CustomHealthStatusUnhealthy,
	}
}

const (
	// FilterConditionEq is a FilterCondition enum value
	FilterConditionEq = "EQ"

	// FilterConditionIn is a FilterCondition enum value
	FilterConditionIn = "IN"

	// FilterConditionBetween is a FilterCondition enum value
	FilterConditionBetween = "BETWEEN"
)

// FilterCondition_Values returns all elements of the FilterCondition enum
func FilterCondition_Values() []string {
	return []string{
		FilterConditionEq,
		FilterConditionIn,
		FilterConditionBetween,
	}
}

const (
	// HealthCheckTypeHttp is a HealthCheckType enum value
	HealthCheckTypeHttp = "HTTP"

	// HealthCheckTypeHttps is a HealthCheckType enum value
	HealthCheckTypeHttps = "HTTPS"

	// HealthCheckTypeTcp is a HealthCheckType enum value
	HealthCheckTypeTcp = "TCP"
)

// HealthCheckType_Values returns all elements of the HealthCheckType enum
func HealthCheckType_Values() []string {
	return []string{
		HealthCheckTypeHttp,
		HealthCheckTypeHttps,
		HealthCheckTypeTcp,
	}
}

const (
	// HealthStatusHealthy is a HealthStatus enum value
	HealthStatusHealthy = "HEALTHY"

	// HealthStatusUnhealthy is a HealthStatus enum value
	HealthStatusUnhealthy = "UNHEALTHY"

	// HealthStatusUnknown is a HealthStatus enum value
	HealthStatusUnknown = "UNKNOWN"
)

// HealthStatus_Values returns all elements of the HealthStatus enum
func HealthStatus_Values() []string {
	return []string{
		HealthStatusHealthy,
		HealthStatusUnhealthy,
		HealthStatusUnknown,
	}
}

const (
	// HealthStatusFilterHealthy is a HealthStatusFilter enum value
	HealthStatusFilterHealthy = "HEALTHY"

	// HealthStatusFilterUnhealthy is a HealthStatusFilter enum value
	HealthStatusFilterUnhealthy = "UNHEALTHY"

	// HealthStatusFilterAll is a HealthStatusFilter enum value
	HealthStatusFilterAll = "ALL"
)

// HealthStatusFilter_Values returns all elements of the HealthStatusFilter enum
func HealthStatusFilter_Values() []string {
	return []string{
		HealthStatusFilterHealthy,
		HealthStatusFilterUnhealthy,
		HealthStatusFilterAll,
	}
}

const (
	// NamespaceFilterNameType is a NamespaceFilterName enum value
	NamespaceFilterNameType = "TYPE"
)

// NamespaceFilterName_Values returns all elements of the NamespaceFilterName enum
func NamespaceFilterName_Values() []string {
	return []string{
		NamespaceFilterNameType,
	}
}

const (
	// NamespaceTypeDnsPublic is a NamespaceType enum value
	NamespaceTypeDnsPublic = "DNS_PUBLIC"

	// NamespaceTypeDnsPrivate is a NamespaceType enum value
	NamespaceTypeDnsPrivate = "DNS_PRIVATE"

	// NamespaceTypeHttp is a NamespaceType enum value
	NamespaceTypeHttp = "HTTP"
)

// NamespaceType_Values returns all elements of the NamespaceType enum
func NamespaceType_Values() []string {
	return []string{
		NamespaceTypeDnsPublic,
		NamespaceTypeDnsPrivate,
		NamespaceTypeHttp,
	}
}

const (
	// OperationFilterNameNamespaceId is a OperationFilterName enum value
	OperationFilterNameNamespaceId = "NAMESPACE_ID"

	// OperationFilterNameServiceId is a OperationFilterName enum value
	OperationFilterNameServiceId = "SERVICE_ID"

	// OperationFilterNameStatus is a OperationFilterName enum value
	OperationFilterNameStatus = "STATUS"

	// OperationFilterNameType is a OperationFilterName enum value
	OperationFilterNameType = "TYPE"

	// OperationFilterNameUpdateDate is a OperationFilterName enum value
	OperationFilterNameUpdateDate = "UPDATE_DATE"
)

// OperationFilterName_Values returns all elements of the OperationFilterName enum
func OperationFilterName_Values() []string {
	return []string{
		OperationFilterNameNamespaceId,
		OperationFilterNameServiceId,
		OperationFilterNameStatus,
		OperationFilterNameType,
		OperationFilterNameUpdateDate,
	}
}

const (
	// OperationStatusSubmitted is a OperationStatus enum value
	OperationStatusSubmitted = "SUBMITTED"

	// OperationStatusPending is a OperationStatus enum value
	OperationStatusPending = "PENDING"

	// OperationStatusSuccess is a OperationStatus enum value
	OperationStatusSuccess = "SUCCESS"

	// OperationStatusFail is a OperationStatus enum value
	OperationStatusFail = "FAIL"
)

// OperationStatus_Values returns all elements of the OperationStatus enum
func OperationStatus_Values() []string {
	return []string{
		OperationStatusSubmitted,
		OperationStatusPending,
		OperationStatusSuccess,
		OperationStatusFail,
	}
}

const (
	// OperationTargetTypeNamespace is a OperationTargetType enum value
	OperationTargetTypeNamespace = "NAMESPACE"

	// OperationTargetTypeService is a OperationTargetType enum value
	OperationTargetTypeService = "SERVICE"

	// OperationTargetTypeInstance is a OperationTargetType enum value
	OperationTargetTypeInstance = "INSTANCE"
)

// OperationTargetType_Values returns all elements of the OperationTargetType enum
func OperationTargetType_Values() []string {
	return []string{
		OperationTargetTypeNamespace,
		OperationTargetTypeService,
		OperationTargetTypeInstance,
	}
}

const (
	// OperationTypeCreateNamespace is a OperationType enum value
	OperationTypeCreateNamespace = "CREATE_NAMESPACE"

	// OperationTypeDeleteNamespace is a OperationType enum value
	OperationTypeDeleteNamespace = "DELETE_NAMESPACE"

	// OperationTypeUpdateService is a OperationType enum value
	OperationTypeUpdateService = "UPDATE_SERVICE"

	// OperationTypeRegisterInstance is a OperationType enum value
	OperationTypeRegisterInstance = "REGISTER_INSTANCE"

	// OperationTypeDeregisterInstance is a OperationType enum value
	OperationTypeDeregisterInstance = "DEREGISTER_INSTANCE"
)

// OperationType_Values returns all elements of the OperationType enum
func OperationType_Values() []string {
	return []string{
		OperationTypeCreateNamespace,
		OperationTypeDeleteNamespace,
		OperationTypeUpdateService,
		OperationTypeRegisterInstance,
		OperationTypeDeregisterInstance,
	}
}

const (
	// RecordTypeSrv is a RecordType enum value
	RecordTypeSrv = "SRV"

	// RecordTypeA is a RecordType enum value
	RecordTypeA = "A"

	// RecordTypeAaaa is a RecordType enum value
	RecordTypeAaaa = "AAAA"

	// RecordTypeCname is a RecordType enum value
	RecordTypeCname = "CNAME"
)

// RecordType_Values returns all elements of the RecordType enum
func RecordType_Values() []string {
	return []string{
		RecordTypeSrv,
		RecordTypeA,
		RecordTypeAaaa,
		RecordTypeCname,
	}
}

const (
	// RoutingPolicyMultivalue is a RoutingPolicy enum value
	RoutingPolicyMultivalue = "MULTIVALUE"

	// RoutingPolicyWeighted is a RoutingPolicy enum value
	RoutingPolicyWeighted = "WEIGHTED"
)

// RoutingPolicy_Values returns all elements of the RoutingPolicy enum
func RoutingPolicy_Values() []string {
	return []string{
		RoutingPolicyMultivalue,
		RoutingPolicyWeighted,
	}
}

const (
	// ServiceFilterNameNamespaceId is a ServiceFilterName enum value
	ServiceFilterNameNamespaceId = "NAMESPACE_ID"
)

// ServiceFilterName_Values returns all elements of the ServiceFilterName enum
func ServiceFilterName_Values() []string {
	return []string{
		ServiceFilterNameNamespaceId,
	}
}

const (
	// ServiceTypeHttp is a ServiceType enum value
	ServiceTypeHttp = "HTTP"

	// ServiceTypeDnsHttp is a ServiceType enum value
	ServiceTypeDnsHttp = "DNS_HTTP"

	// ServiceTypeDns is a ServiceType enum value
	ServiceTypeDns = "DNS"
)

// ServiceType_Values returns all elements of the ServiceType enum
func ServiceType_Values() []string {
	return []string{
		ServiceTypeHttp,
		ServiceTypeDnsHttp,
		ServiceTypeDns,
	}
}

const (
	// ServiceTypeOptionHttp is a ServiceTypeOption enum value
	ServiceTypeOptionHttp = "HTTP"
)

// ServiceTypeOption_Values returns all elements of the ServiceTypeOption enum
func ServiceTypeOption_Values() []string {
	return []string{
		ServiceTypeOptionHttp,
	}
}
