// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package pinpointemailiface provides an interface to enable mocking the Amazon Pinpoint Email Service service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package pinpointemailiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/pinpointemail"
)

// PinpointEmailAPI provides an interface to enable mocking the
// pinpointemail.PinpointEmail service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Pinpoint Email Service.
//    func myFunc(svc pinpointemailiface.PinpointEmailAPI) bool {
//        // Make svc.CreateConfigurationSet request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := pinpointemail.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockPinpointEmailClient struct {
//        pinpointemailiface.PinpointEmailAPI
//    }
//    func (m *mockPinpointEmailClient) CreateConfigurationSet(input *pinpointemail.CreateConfigurationSetInput) (*pinpointemail.CreateConfigurationSetOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockPinpointEmailClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type PinpointEmailAPI interface {
	CreateConfigurationSet(*pinpointemail.CreateConfigurationSetInput) (*pinpointemail.CreateConfigurationSetOutput, error)
	CreateConfigurationSetWithContext(aws.Context, *pinpointemail.CreateConfigurationSetInput, ...request.Option) (*pinpointemail.CreateConfigurationSetOutput, error)
	CreateConfigurationSetRequest(*pinpointemail.CreateConfigurationSetInput) (*request.Request, *pinpointemail.CreateConfigurationSetOutput)

	CreateConfigurationSetEventDestination(*pinpointemail.CreateConfigurationSetEventDestinationInput) (*pinpointemail.CreateConfigurationSetEventDestinationOutput, error)
	CreateConfigurationSetEventDestinationWithContext(aws.Context, *pinpointemail.CreateConfigurationSetEventDestinationInput, ...request.Option) (*pinpointemail.CreateConfigurationSetEventDestinationOutput, error)
	CreateConfigurationSetEventDestinationRequest(*pinpointemail.CreateConfigurationSetEventDestinationInput) (*request.Request, *pinpointemail.CreateConfigurationSetEventDestinationOutput)

	CreateDedicatedIpPool(*pinpointemail.CreateDedicatedIpPoolInput) (*pinpointemail.CreateDedicatedIpPoolOutput, error)
	CreateDedicatedIpPoolWithContext(aws.Context, *pinpointemail.CreateDedicatedIpPoolInput, ...request.Option) (*pinpointemail.CreateDedicatedIpPoolOutput, error)
	CreateDedicatedIpPoolRequest(*pinpointemail.CreateDedicatedIpPoolInput) (*request.Request, *pinpointemail.CreateDedicatedIpPoolOutput)

	CreateDeliverabilityTestReport(*pinpointemail.CreateDeliverabilityTestReportInput) (*pinpointemail.CreateDeliverabilityTestReportOutput, error)
	CreateDeliverabilityTestReportWithContext(aws.Context, *pinpointemail.CreateDeliverabilityTestReportInput, ...request.Option) (*pinpointemail.CreateDeliverabilityTestReportOutput, error)
	CreateDeliverabilityTestReportRequest(*pinpointemail.CreateDeliverabilityTestReportInput) (*request.Request, *pinpointemail.CreateDeliverabilityTestReportOutput)

	CreateEmailIdentity(*pinpointemail.CreateEmailIdentityInput) (*pinpointemail.CreateEmailIdentityOutput, error)
	CreateEmailIdentityWithContext(aws.Context, *pinpointemail.CreateEmailIdentityInput, ...request.Option) (*pinpointemail.CreateEmailIdentityOutput, error)
	CreateEmailIdentityRequest(*pinpointemail.CreateEmailIdentityInput) (*request.Request, *pinpointemail.CreateEmailIdentityOutput)

	DeleteConfigurationSet(*pinpointemail.DeleteConfigurationSetInput) (*pinpointemail.DeleteConfigurationSetOutput, error)
	DeleteConfigurationSetWithContext(aws.Context, *pinpointemail.DeleteConfigurationSetInput, ...request.Option) (*pinpointemail.DeleteConfigurationSetOutput, error)
	DeleteConfigurationSetRequest(*pinpointemail.DeleteConfigurationSetInput) (*request.Request, *pinpointemail.DeleteConfigurationSetOutput)

	DeleteConfigurationSetEventDestination(*pinpointemail.DeleteConfigurationSetEventDestinationInput) (*pinpointemail.DeleteConfigurationSetEventDestinationOutput, error)
	DeleteConfigurationSetEventDestinationWithContext(aws.Context, *pinpointemail.DeleteConfigurationSetEventDestinationInput, ...request.Option) (*pinpointemail.DeleteConfigurationSetEventDestinationOutput, error)
	DeleteConfigurationSetEventDestinationRequest(*pinpointemail.DeleteConfigurationSetEventDestinationInput) (*request.Request, *pinpointemail.DeleteConfigurationSetEventDestinationOutput)

	DeleteDedicatedIpPool(*pinpointemail.DeleteDedicatedIpPoolInput) (*pinpointemail.DeleteDedicatedIpPoolOutput, error)
	DeleteDedicatedIpPoolWithContext(aws.Context, *pinpointemail.DeleteDedicatedIpPoolInput, ...request.Option) (*pinpointemail.DeleteDedicatedIpPoolOutput, error)
	DeleteDedicatedIpPoolRequest(*pinpointemail.DeleteDedicatedIpPoolInput) (*request.Request, *pinpointemail.DeleteDedicatedIpPoolOutput)

	DeleteEmailIdentity(*pinpointemail.DeleteEmailIdentityInput) (*pinpointemail.DeleteEmailIdentityOutput, error)
	DeleteEmailIdentityWithContext(aws.Context, *pinpointemail.DeleteEmailIdentityInput, ...request.Option) (*pinpointemail.DeleteEmailIdentityOutput, error)
	DeleteEmailIdentityRequest(*pinpointemail.DeleteEmailIdentityInput) (*request.Request, *pinpointemail.DeleteEmailIdentityOutput)

	GetAccount(*pinpointemail.GetAccountInput) (*pinpointemail.GetAccountOutput, error)
	GetAccountWithContext(aws.Context, *pinpointemail.GetAccountInput, ...request.Option) (*pinpointemail.GetAccountOutput, error)
	GetAccountRequest(*pinpointemail.GetAccountInput) (*request.Request, *pinpointemail.GetAccountOutput)

	GetBlacklistReports(*pinpointemail.GetBlacklistReportsInput) (*pinpointemail.GetBlacklistReportsOutput, error)
	GetBlacklistReportsWithContext(aws.Context, *pinpointemail.GetBlacklistReportsInput, ...request.Option) (*pinpointemail.GetBlacklistReportsOutput, error)
	GetBlacklistReportsRequest(*pinpointemail.GetBlacklistReportsInput) (*request.Request, *pinpointemail.GetBlacklistReportsOutput)

	GetConfigurationSet(*pinpointemail.GetConfigurationSetInput) (*pinpointemail.GetConfigurationSetOutput, error)
	GetConfigurationSetWithContext(aws.Context, *pinpointemail.GetConfigurationSetInput, ...request.Option) (*pinpointemail.GetConfigurationSetOutput, error)
	GetConfigurationSetRequest(*pinpointemail.GetConfigurationSetInput) (*request.Request, *pinpointemail.GetConfigurationSetOutput)

	GetConfigurationSetEventDestinations(*pinpointemail.GetConfigurationSetEventDestinationsInput) (*pinpointemail.GetConfigurationSetEventDestinationsOutput, error)
	GetConfigurationSetEventDestinationsWithContext(aws.Context, *pinpointemail.GetConfigurationSetEventDestinationsInput, ...request.Option) (*pinpointemail.GetConfigurationSetEventDestinationsOutput, error)
	GetConfigurationSetEventDestinationsRequest(*pinpointemail.GetConfigurationSetEventDestinationsInput) (*request.Request, *pinpointemail.GetConfigurationSetEventDestinationsOutput)

	GetDedicatedIp(*pinpointemail.GetDedicatedIpInput) (*pinpointemail.GetDedicatedIpOutput, error)
	GetDedicatedIpWithContext(aws.Context, *pinpointemail.GetDedicatedIpInput, ...request.Option) (*pinpointemail.GetDedicatedIpOutput, error)
	GetDedicatedIpRequest(*pinpointemail.GetDedicatedIpInput) (*request.Request, *pinpointemail.GetDedicatedIpOutput)

	GetDedicatedIps(*pinpointemail.GetDedicatedIpsInput) (*pinpointemail.GetDedicatedIpsOutput, error)
	GetDedicatedIpsWithContext(aws.Context, *pinpointemail.GetDedicatedIpsInput, ...request.Option) (*pinpointemail.GetDedicatedIpsOutput, error)
	GetDedicatedIpsRequest(*pinpointemail.GetDedicatedIpsInput) (*request.Request, *pinpointemail.GetDedicatedIpsOutput)

	GetDedicatedIpsPages(*pinpointemail.GetDedicatedIpsInput, func(*pinpointemail.GetDedicatedIpsOutput, bool) bool) error
	GetDedicatedIpsPagesWithContext(aws.Context, *pinpointemail.GetDedicatedIpsInput, func(*pinpointemail.GetDedicatedIpsOutput, bool) bool, ...request.Option) error

	GetDeliverabilityDashboardOptions(*pinpointemail.GetDeliverabilityDashboardOptionsInput) (*pinpointemail.GetDeliverabilityDashboardOptionsOutput, error)
	GetDeliverabilityDashboardOptionsWithContext(aws.Context, *pinpointemail.GetDeliverabilityDashboardOptionsInput, ...request.Option) (*pinpointemail.GetDeliverabilityDashboardOptionsOutput, error)
	GetDeliverabilityDashboardOptionsRequest(*pinpointemail.GetDeliverabilityDashboardOptionsInput) (*request.Request, *pinpointemail.GetDeliverabilityDashboardOptionsOutput)

	GetDeliverabilityTestReport(*pinpointemail.GetDeliverabilityTestReportInput) (*pinpointemail.GetDeliverabilityTestReportOutput, error)
	GetDeliverabilityTestReportWithContext(aws.Context, *pinpointemail.GetDeliverabilityTestReportInput, ...request.Option) (*pinpointemail.GetDeliverabilityTestReportOutput, error)
	GetDeliverabilityTestReportRequest(*pinpointemail.GetDeliverabilityTestReportInput) (*request.Request, *pinpointemail.GetDeliverabilityTestReportOutput)

	GetDomainDeliverabilityCampaign(*pinpointemail.GetDomainDeliverabilityCampaignInput) (*pinpointemail.GetDomainDeliverabilityCampaignOutput, error)
	GetDomainDeliverabilityCampaignWithContext(aws.Context, *pinpointemail.GetDomainDeliverabilityCampaignInput, ...request.Option) (*pinpointemail.GetDomainDeliverabilityCampaignOutput, error)
	GetDomainDeliverabilityCampaignRequest(*pinpointemail.GetDomainDeliverabilityCampaignInput) (*request.Request, *pinpointemail.GetDomainDeliverabilityCampaignOutput)

	GetDomainStatisticsReport(*pinpointemail.GetDomainStatisticsReportInput) (*pinpointemail.GetDomainStatisticsReportOutput, error)
	GetDomainStatisticsReportWithContext(aws.Context, *pinpointemail.GetDomainStatisticsReportInput, ...request.Option) (*pinpointemail.GetDomainStatisticsReportOutput, error)
	GetDomainStatisticsReportRequest(*pinpointemail.GetDomainStatisticsReportInput) (*request.Request, *pinpointemail.GetDomainStatisticsReportOutput)

	GetEmailIdentity(*pinpointemail.GetEmailIdentityInput) (*pinpointemail.GetEmailIdentityOutput, error)
	GetEmailIdentityWithContext(aws.Context, *pinpointemail.GetEmailIdentityInput, ...request.Option) (*pinpointemail.GetEmailIdentityOutput, error)
	GetEmailIdentityRequest(*pinpointemail.GetEmailIdentityInput) (*request.Request, *pinpointemail.GetEmailIdentityOutput)

	ListConfigurationSets(*pinpointemail.ListConfigurationSetsInput) (*pinpointemail.ListConfigurationSetsOutput, error)
	ListConfigurationSetsWithContext(aws.Context, *pinpointemail.ListConfigurationSetsInput, ...request.Option) (*pinpointemail.ListConfigurationSetsOutput, error)
	ListConfigurationSetsRequest(*pinpointemail.ListConfigurationSetsInput) (*request.Request, *pinpointemail.ListConfigurationSetsOutput)

	ListConfigurationSetsPages(*pinpointemail.ListConfigurationSetsInput, func(*pinpointemail.ListConfigurationSetsOutput, bool) bool) error
	ListConfigurationSetsPagesWithContext(aws.Context, *pinpointemail.ListConfigurationSetsInput, func(*pinpointemail.ListConfigurationSetsOutput, bool) bool, ...request.Option) error

	ListDedicatedIpPools(*pinpointemail.ListDedicatedIpPoolsInput) (*pinpointemail.ListDedicatedIpPoolsOutput, error)
	ListDedicatedIpPoolsWithContext(aws.Context, *pinpointemail.ListDedicatedIpPoolsInput, ...request.Option) (*pinpointemail.ListDedicatedIpPoolsOutput, error)
	ListDedicatedIpPoolsRequest(*pinpointemail.ListDedicatedIpPoolsInput) (*request.Request, *pinpointemail.ListDedicatedIpPoolsOutput)

	ListDedicatedIpPoolsPages(*pinpointemail.ListDedicatedIpPoolsInput, func(*pinpointemail.ListDedicatedIpPoolsOutput, bool) bool) error
	ListDedicatedIpPoolsPagesWithContext(aws.Context, *pinpointemail.ListDedicatedIpPoolsInput, func(*pinpointemail.ListDedicatedIpPoolsOutput, bool) bool, ...request.Option) error

	ListDeliverabilityTestReports(*pinpointemail.ListDeliverabilityTestReportsInput) (*pinpointemail.ListDeliverabilityTestReportsOutput, error)
	ListDeliverabilityTestReportsWithContext(aws.Context, *pinpointemail.ListDeliverabilityTestReportsInput, ...request.Option) (*pinpointemail.ListDeliverabilityTestReportsOutput, error)
	ListDeliverabilityTestReportsRequest(*pinpointemail.ListDeliverabilityTestReportsInput) (*request.Request, *pinpointemail.ListDeliverabilityTestReportsOutput)

	ListDeliverabilityTestReportsPages(*pinpointemail.ListDeliverabilityTestReportsInput, func(*pinpointemail.ListDeliverabilityTestReportsOutput, bool) bool) error
	ListDeliverabilityTestReportsPagesWithContext(aws.Context, *pinpointemail.ListDeliverabilityTestReportsInput, func(*pinpointemail.ListDeliverabilityTestReportsOutput, bool) bool, ...request.Option) error

	ListDomainDeliverabilityCampaigns(*pinpointemail.ListDomainDeliverabilityCampaignsInput) (*pinpointemail.ListDomainDeliverabilityCampaignsOutput, error)
	ListDomainDeliverabilityCampaignsWithContext(aws.Context, *pinpointemail.ListDomainDeliverabilityCampaignsInput, ...request.Option) (*pinpointemail.ListDomainDeliverabilityCampaignsOutput, error)
	ListDomainDeliverabilityCampaignsRequest(*pinpointemail.ListDomainDeliverabilityCampaignsInput) (*request.Request, *pinpointemail.ListDomainDeliverabilityCampaignsOutput)

	ListDomainDeliverabilityCampaignsPages(*pinpointemail.ListDomainDeliverabilityCampaignsInput, func(*pinpointemail.ListDomainDeliverabilityCampaignsOutput, bool) bool) error
	ListDomainDeliverabilityCampaignsPagesWithContext(aws.Context, *pinpointemail.ListDomainDeliverabilityCampaignsInput, func(*pinpointemail.ListDomainDeliverabilityCampaignsOutput, bool) bool, ...request.Option) error

	ListEmailIdentities(*pinpointemail.ListEmailIdentitiesInput) (*pinpointemail.ListEmailIdentitiesOutput, error)
	ListEmailIdentitiesWithContext(aws.Context, *pinpointemail.ListEmailIdentitiesInput, ...request.Option) (*pinpointemail.ListEmailIdentitiesOutput, error)
	ListEmailIdentitiesRequest(*pinpointemail.ListEmailIdentitiesInput) (*request.Request, *pinpointemail.ListEmailIdentitiesOutput)

	ListEmailIdentitiesPages(*pinpointemail.ListEmailIdentitiesInput, func(*pinpointemail.ListEmailIdentitiesOutput, bool) bool) error
	ListEmailIdentitiesPagesWithContext(aws.Context, *pinpointemail.ListEmailIdentitiesInput, func(*pinpointemail.ListEmailIdentitiesOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*pinpointemail.ListTagsForResourceInput) (*pinpointemail.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *pinpointemail.ListTagsForResourceInput, ...request.Option) (*pinpointemail.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*pinpointemail.ListTagsForResourceInput) (*request.Request, *pinpointemail.ListTagsForResourceOutput)

	PutAccountDedicatedIpWarmupAttributes(*pinpointemail.PutAccountDedicatedIpWarmupAttributesInput) (*pinpointemail.PutAccountDedicatedIpWarmupAttributesOutput, error)
	PutAccountDedicatedIpWarmupAttributesWithContext(aws.Context, *pinpointemail.PutAccountDedicatedIpWarmupAttributesInput, ...request.Option) (*pinpointemail.PutAccountDedicatedIpWarmupAttributesOutput, error)
	PutAccountDedicatedIpWarmupAttributesRequest(*pinpointemail.PutAccountDedicatedIpWarmupAttributesInput) (*request.Request, *pinpointemail.PutAccountDedicatedIpWarmupAttributesOutput)

	PutAccountSendingAttributes(*pinpointemail.PutAccountSendingAttributesInput) (*pinpointemail.PutAccountSendingAttributesOutput, error)
	PutAccountSendingAttributesWithContext(aws.Context, *pinpointemail.PutAccountSendingAttributesInput, ...request.Option) (*pinpointemail.PutAccountSendingAttributesOutput, error)
	PutAccountSendingAttributesRequest(*pinpointemail.PutAccountSendingAttributesInput) (*request.Request, *pinpointemail.PutAccountSendingAttributesOutput)

	PutConfigurationSetDeliveryOptions(*pinpointemail.PutConfigurationSetDeliveryOptionsInput) (*pinpointemail.PutConfigurationSetDeliveryOptionsOutput, error)
	PutConfigurationSetDeliveryOptionsWithContext(aws.Context, *pinpointemail.PutConfigurationSetDeliveryOptionsInput, ...request.Option) (*pinpointemail.PutConfigurationSetDeliveryOptionsOutput, error)
	PutConfigurationSetDeliveryOptionsRequest(*pinpointemail.PutConfigurationSetDeliveryOptionsInput) (*request.Request, *pinpointemail.PutConfigurationSetDeliveryOptionsOutput)

	PutConfigurationSetReputationOptions(*pinpointemail.PutConfigurationSetReputationOptionsInput) (*pinpointemail.PutConfigurationSetReputationOptionsOutput, error)
	PutConfigurationSetReputationOptionsWithContext(aws.Context, *pinpointemail.PutConfigurationSetReputationOptionsInput, ...request.Option) (*pinpointemail.PutConfigurationSetReputationOptionsOutput, error)
	PutConfigurationSetReputationOptionsRequest(*pinpointemail.PutConfigurationSetReputationOptionsInput) (*request.Request, *pinpointemail.PutConfigurationSetReputationOptionsOutput)

	PutConfigurationSetSendingOptions(*pinpointemail.PutConfigurationSetSendingOptionsInput) (*pinpointemail.PutConfigurationSetSendingOptionsOutput, error)
	PutConfigurationSetSendingOptionsWithContext(aws.Context, *pinpointemail.PutConfigurationSetSendingOptionsInput, ...request.Option) (*pinpointemail.PutConfigurationSetSendingOptionsOutput, error)
	PutConfigurationSetSendingOptionsRequest(*pinpointemail.PutConfigurationSetSendingOptionsInput) (*request.Request, *pinpointemail.PutConfigurationSetSendingOptionsOutput)

	PutConfigurationSetTrackingOptions(*pinpointemail.PutConfigurationSetTrackingOptionsInput) (*pinpointemail.PutConfigurationSetTrackingOptionsOutput, error)
	PutConfigurationSetTrackingOptionsWithContext(aws.Context, *pinpointemail.PutConfigurationSetTrackingOptionsInput, ...request.Option) (*pinpointemail.PutConfigurationSetTrackingOptionsOutput, error)
	PutConfigurationSetTrackingOptionsRequest(*pinpointemail.PutConfigurationSetTrackingOptionsInput) (*request.Request, *pinpointemail.PutConfigurationSetTrackingOptionsOutput)

	PutDedicatedIpInPool(*pinpointemail.PutDedicatedIpInPoolInput) (*pinpointemail.PutDedicatedIpInPoolOutput, error)
	PutDedicatedIpInPoolWithContext(aws.Context, *pinpointemail.PutDedicatedIpInPoolInput, ...request.Option) (*pinpointemail.PutDedicatedIpInPoolOutput, error)
	PutDedicatedIpInPoolRequest(*pinpointemail.PutDedicatedIpInPoolInput) (*request.Request, *pinpointemail.PutDedicatedIpInPoolOutput)

	PutDedicatedIpWarmupAttributes(*pinpointemail.PutDedicatedIpWarmupAttributesInput) (*pinpointemail.PutDedicatedIpWarmupAttributesOutput, error)
	PutDedicatedIpWarmupAttributesWithContext(aws.Context, *pinpointemail.PutDedicatedIpWarmupAttributesInput, ...request.Option) (*pinpointemail.PutDedicatedIpWarmupAttributesOutput, error)
	PutDedicatedIpWarmupAttributesRequest(*pinpointemail.PutDedicatedIpWarmupAttributesInput) (*request.Request, *pinpointemail.PutDedicatedIpWarmupAttributesOutput)

	PutDeliverabilityDashboardOption(*pinpointemail.PutDeliverabilityDashboardOptionInput) (*pinpointemail.PutDeliverabilityDashboardOptionOutput, error)
	PutDeliverabilityDashboardOptionWithContext(aws.Context, *pinpointemail.PutDeliverabilityDashboardOptionInput, ...request.Option) (*pinpointemail.PutDeliverabilityDashboardOptionOutput, error)
	PutDeliverabilityDashboardOptionRequest(*pinpointemail.PutDeliverabilityDashboardOptionInput) (*request.Request, *pinpointemail.PutDeliverabilityDashboardOptionOutput)

	PutEmailIdentityDkimAttributes(*pinpointemail.PutEmailIdentityDkimAttributesInput) (*pinpointemail.PutEmailIdentityDkimAttributesOutput, error)
	PutEmailIdentityDkimAttributesWithContext(aws.Context, *pinpointemail.PutEmailIdentityDkimAttributesInput, ...request.Option) (*pinpointemail.PutEmailIdentityDkimAttributesOutput, error)
	PutEmailIdentityDkimAttributesRequest(*pinpointemail.PutEmailIdentityDkimAttributesInput) (*request.Request, *pinpointemail.PutEmailIdentityDkimAttributesOutput)

	PutEmailIdentityFeedbackAttributes(*pinpointemail.PutEmailIdentityFeedbackAttributesInput) (*pinpointemail.PutEmailIdentityFeedbackAttributesOutput, error)
	PutEmailIdentityFeedbackAttributesWithContext(aws.Context, *pinpointemail.PutEmailIdentityFeedbackAttributesInput, ...request.Option) (*pinpointemail.PutEmailIdentityFeedbackAttributesOutput, error)
	PutEmailIdentityFeedbackAttributesRequest(*pinpointemail.PutEmailIdentityFeedbackAttributesInput) (*request.Request, *pinpointemail.PutEmailIdentityFeedbackAttributesOutput)

	PutEmailIdentityMailFromAttributes(*pinpointemail.PutEmailIdentityMailFromAttributesInput) (*pinpointemail.PutEmailIdentityMailFromAttributesOutput, error)
	PutEmailIdentityMailFromAttributesWithContext(aws.Context, *pinpointemail.PutEmailIdentityMailFromAttributesInput, ...request.Option) (*pinpointemail.PutEmailIdentityMailFromAttributesOutput, error)
	PutEmailIdentityMailFromAttributesRequest(*pinpointemail.PutEmailIdentityMailFromAttributesInput) (*request.Request, *pinpointemail.PutEmailIdentityMailFromAttributesOutput)

	SendEmail(*pinpointemail.SendEmailInput) (*pinpointemail.SendEmailOutput, error)
	SendEmailWithContext(aws.Context, *pinpointemail.SendEmailInput, ...request.Option) (*pinpointemail.SendEmailOutput, error)
	SendEmailRequest(*pinpointemail.SendEmailInput) (*request.Request, *pinpointemail.SendEmailOutput)

	TagResource(*pinpointemail.TagResourceInput) (*pinpointemail.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *pinpointemail.TagResourceInput, ...request.Option) (*pinpointemail.TagResourceOutput, error)
	TagResourceRequest(*pinpointemail.TagResourceInput) (*request.Request, *pinpointemail.TagResourceOutput)

	UntagResource(*pinpointemail.UntagResourceInput) (*pinpointemail.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *pinpointemail.UntagResourceInput, ...request.Option) (*pinpointemail.UntagResourceOutput, error)
	UntagResourceRequest(*pinpointemail.UntagResourceInput) (*request.Request, *pinpointemail.UntagResourceOutput)

	UpdateConfigurationSetEventDestination(*pinpointemail.UpdateConfigurationSetEventDestinationInput) (*pinpointemail.UpdateConfigurationSetEventDestinationOutput, error)
	UpdateConfigurationSetEventDestinationWithContext(aws.Context, *pinpointemail.UpdateConfigurationSetEventDestinationInput, ...request.Option) (*pinpointemail.UpdateConfigurationSetEventDestinationOutput, error)
	UpdateConfigurationSetEventDestinationRequest(*pinpointemail.UpdateConfigurationSetEventDestinationInput) (*request.Request, *pinpointemail.UpdateConfigurationSetEventDestinationOutput)
}

var _ PinpointEmailAPI = (*pinpointemail.PinpointEmail)(nil)
