// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package workspaces_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/workspaces"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleWorkSpaces_CreateWorkspaces() {
	svc := workspaces.New(nil)

	params := &workspaces.CreateWorkspacesInput{
		Workspaces: []*workspaces.WorkspaceRequest{ // Required
			{ // Required
				BundleId:    aws.String("BundleId"),    // Required
				DirectoryId: aws.String("DirectoryId"), // Required
				UserName:    aws.String("UserName"),    // Required
			},
			// More values...
		},
	}
	resp, err := svc.CreateWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_DescribeWorkspaceBundles() {
	svc := workspaces.New(nil)

	params := &workspaces.DescribeWorkspaceBundlesInput{
		BundleIds: []*string{
			aws.String("BundleId"), // Required
			// More values...
		},
		NextToken: aws.String("PaginationToken"),
		Owner:     aws.String("BundleOwner"),
	}
	resp, err := svc.DescribeWorkspaceBundles(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_DescribeWorkspaceDirectories() {
	svc := workspaces.New(nil)

	params := &workspaces.DescribeWorkspaceDirectoriesInput{
		DirectoryIds: []*string{
			aws.String("DirectoryId"), // Required
			// More values...
		},
		NextToken: aws.String("PaginationToken"),
	}
	resp, err := svc.DescribeWorkspaceDirectories(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_DescribeWorkspaces() {
	svc := workspaces.New(nil)

	params := &workspaces.DescribeWorkspacesInput{
		BundleId:    aws.String("BundleId"),
		DirectoryId: aws.String("DirectoryId"),
		Limit:       aws.Int64(1),
		NextToken:   aws.String("PaginationToken"),
		UserName:    aws.String("UserName"),
		WorkspaceIds: []*string{
			aws.String("WorkspaceId"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_RebootWorkspaces() {
	svc := workspaces.New(nil)

	params := &workspaces.RebootWorkspacesInput{
		RebootWorkspaceRequests: []*workspaces.RebootRequest{ // Required
			{ // Required
				WorkspaceId: aws.String("WorkspaceId"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.RebootWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_RebuildWorkspaces() {
	svc := workspaces.New(nil)

	params := &workspaces.RebuildWorkspacesInput{
		RebuildWorkspaceRequests: []*workspaces.RebuildRequest{ // Required
			{ // Required
				WorkspaceId: aws.String("WorkspaceId"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.RebuildWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleWorkSpaces_TerminateWorkspaces() {
	svc := workspaces.New(nil)

	params := &workspaces.TerminateWorkspacesInput{
		TerminateWorkspaceRequests: []*workspaces.TerminateRequest{ // Required
			{ // Required
				WorkspaceId: aws.String("WorkspaceId"), // Required
			},
			// More values...
		},
	}
	resp, err := svc.TerminateWorkspaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
