// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package sts provides a client for AWS Security Token Service.
package sts

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssumeRole = "AssumeRole"

// AssumeRoleRequest generates a request for the AssumeRole operation.
func (c *STS) AssumeRoleRequest(input *AssumeRoleInput) (req *request.Request, output *AssumeRoleOutput) {
	op := &request.Operation{
		Name:       opAssumeRole,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssumeRoleInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssumeRoleOutput{}
	req.Data = output
	return
}

// Returns a set of temporary security credentials (consisting of an access
// key ID, a secret access key, and a security token) that you can use to access
// AWS resources that you might not normally have access to. Typically, you
// use AssumeRole for cross-account access or federation.
//
// Important: You cannot call AssumeRole by using AWS account credentials;
// access will be denied. You must use IAM user credentials or temporary security
// credentials to call AssumeRole.
//
// For cross-account access, imagine that you own multiple accounts and need
// to access resources in each account. You could create long-term credentials
// in each account to access those resources. However, managing all those credentials
// and remembering which one can access which account can be time consuming.
// Instead, you can create one set of long-term credentials in one account and
// then use temporary security credentials to access all the other accounts
// by assuming roles in those accounts. For more information about roles, see
// IAM Roles (Delegation and Federation) (http://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html)
// in Using IAM.
//
// For federation, you can, for example, grant single sign-on access to the
// AWS Management Console. If you already have an identity and authentication
// system in your corporate network, you don't have to recreate user identities
// in AWS in order to grant those user identities access to AWS. Instead, after
// a user has been authenticated, you call AssumeRole (and specify the role
// with the appropriate permissions) to get temporary security credentials for
// that user. With those temporary security credentials, you construct a sign-in
// URL that users can use to access the console. For more information, see Scenarios
// for Granting Temporary Access (http://docs.aws.amazon.com/STS/latest/UsingSTS/STSUseCases.html)
// in Using Temporary Security Credentials.
//
// The temporary security credentials are valid for the duration that you specified
// when calling AssumeRole, which can be from 900 seconds (15 minutes) to 3600
// seconds (1 hour). The default is 1 hour.
//
// Optionally, you can pass an IAM access policy to this operation. If you
// choose not to pass a policy, the temporary security credentials that are
// returned by the operation have the permissions that are defined in the access
// policy of the role that is being assumed. If you pass a policy to this operation,
// the temporary security credentials that are returned by the operation have
// the permissions that are allowed by both the access policy of the role that
// is being assumed, and the policy that you pass. This gives you a way to further
// restrict the permissions for the resulting temporary security credentials.
// You cannot use the passed policy to grant permissions that are in excess
// of those allowed by the access policy of the role that is being assumed.
// For more information, see Permissions for AssumeRole, AssumeRoleWithSAML,
// and AssumeRoleWithWebIdentity (http://docs.aws.amazon.com/STS/latest/UsingSTS/permissions-assume-role.html)
// in Using Temporary Security Credentials.
//
// To assume a role, your AWS account must be trusted by the role. The trust
// relationship is defined in the role's trust policy when the role is created.
// You must also have a policy that allows you to call sts:AssumeRole.
//
//  Using MFA with AssumeRole
//
// You can optionally include multi-factor authentication (MFA) information
// when you call AssumeRole. This is useful for cross-account scenarios in which
// you want to make sure that the user who is assuming the role has been authenticated
// using an AWS MFA device. In that scenario, the trust policy of the role being
// assumed includes a condition that tests for MFA authentication; if the caller
// does not include valid MFA information, the request to assume the role is
// denied. The condition in a trust policy that tests for MFA authentication
// might look like the following example.
//
//  "Condition": {"Bool": {"aws:MultiFactorAuthPresent": true}}
//
// For more information, see Configuring MFA-Protected API Access (http://docs.aws.amazon.com/IAM/latest/UserGuide/MFAProtectedAPI.html)
// in Using IAM guide.
//
// To use MFA with AssumeRole, you pass values for the SerialNumber and TokenCode
// parameters. The SerialNumber value identifies the user's hardware or virtual
// MFA device. The TokenCode is the time-based one-time password (TOTP) that
// the MFA devices produces.
func (c *STS) AssumeRole(input *AssumeRoleInput) (*AssumeRoleOutput, error) {
	req, out := c.AssumeRoleRequest(input)
	err := req.Send()
	return out, err
}

const opAssumeRoleWithSAML = "AssumeRoleWithSAML"

// AssumeRoleWithSAMLRequest generates a request for the AssumeRoleWithSAML operation.
func (c *STS) AssumeRoleWithSAMLRequest(input *AssumeRoleWithSAMLInput) (req *request.Request, output *AssumeRoleWithSAMLOutput) {
	op := &request.Operation{
		Name:       opAssumeRoleWithSAML,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssumeRoleWithSAMLInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssumeRoleWithSAMLOutput{}
	req.Data = output
	return
}

// Returns a set of temporary security credentials for users who have been authenticated
// via a SAML authentication response. This operation provides a mechanism for
// tying an enterprise identity store or directory to role-based AWS access
// without user-specific credentials or configuration.
//
// The temporary security credentials returned by this operation consist of
// an access key ID, a secret access key, and a security token. Applications
// can use these temporary security credentials to sign calls to AWS services.
// The credentials are valid for the duration that you specified when calling
// AssumeRoleWithSAML, which can be up to 3600 seconds (1 hour) or until the
// time specified in the SAML authentication response's SessionNotOnOrAfter
// value, whichever is shorter.
//
// The maximum duration for a session is 1 hour, and the minimum duration is
// 15 minutes, even if values outside this range are specified.  Optionally,
// you can pass an IAM access policy to this operation. If you choose not to
// pass a policy, the temporary security credentials that are returned by the
// operation have the permissions that are defined in the access policy of the
// role that is being assumed. If you pass a policy to this operation, the temporary
// security credentials that are returned by the operation have the permissions
// that are allowed by both the access policy of the role that is being assumed,
// and the policy that you pass. This gives you a way to further restrict the
// permissions for the resulting temporary security credentials. You cannot
// use the passed policy to grant permissions that are in excess of those allowed
// by the access policy of the role that is being assumed. For more information,
// see Permissions for AssumeRoleWithSAML (http://docs.aws.amazon.com/STS/latest/UsingSTS/permissions-assume-role.html)
// in Using Temporary Security Credentials.
//
// Before your application can call AssumeRoleWithSAML, you must configure
// your SAML identity provider (IdP) to issue the claims required by AWS. Additionally,
// you must use AWS Identity and Access Management (IAM) to create a SAML provider
// entity in your AWS account that represents your identity provider, and create
// an IAM role that specifies this SAML provider in its trust policy.
//
// Calling AssumeRoleWithSAML does not require the use of AWS security credentials.
// The identity of the caller is validated by using keys in the metadata document
// that is uploaded for the SAML provider entity for your identity provider.
//
// For more information, see the following resources:
//
//   Creating Temporary Security Credentials for SAML Federation (http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingSAML.html).
//   SAML Providers (http://docs.aws.amazon.com/IAM/latest/UserGuide/idp-managing-identityproviders.html)
// in Using IAM.   Configuring a Relying Party and Claims (http://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html)
// in Using IAM.   Creating a Role for SAML-Based Federation (http://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml.html)
// in Using IAM.
func (c *STS) AssumeRoleWithSAML(input *AssumeRoleWithSAMLInput) (*AssumeRoleWithSAMLOutput, error) {
	req, out := c.AssumeRoleWithSAMLRequest(input)
	err := req.Send()
	return out, err
}

const opAssumeRoleWithWebIdentity = "AssumeRoleWithWebIdentity"

// AssumeRoleWithWebIdentityRequest generates a request for the AssumeRoleWithWebIdentity operation.
func (c *STS) AssumeRoleWithWebIdentityRequest(input *AssumeRoleWithWebIdentityInput) (req *request.Request, output *AssumeRoleWithWebIdentityOutput) {
	op := &request.Operation{
		Name:       opAssumeRoleWithWebIdentity,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssumeRoleWithWebIdentityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssumeRoleWithWebIdentityOutput{}
	req.Data = output
	return
}

// Returns a set of temporary security credentials for users who have been authenticated
// in a mobile or web application with a web identity provider, such as Amazon
// Cognito, Login with Amazon, Facebook, Google, or any OpenID Connect-compatible
// identity provider.
//
//  For mobile applications, we recommend that you use Amazon Cognito. You
// can use Amazon Cognito with the AWS SDK for iOS (http://aws.amazon.com/sdkforios/)
// and the AWS SDK for Android (http://aws.amazon.com/sdkforandroid/) to uniquely
// identify a user and supply the user with a consistent identity throughout
// the lifetime of an application.
//
// To learn more about Amazon Cognito, see Amazon Cognito Overview (http://docs.aws.amazon.com/mobile/sdkforandroid/developerguide/cognito-auth.html#d0e840)
// in the AWS SDK for Android Developer Guide guide and Amazon Cognito Overview
// (http://docs.aws.amazon.com/mobile/sdkforios/developerguide/cognito-auth.html#d0e664)
// in the AWS SDK for iOS Developer Guide.
//
//  Calling AssumeRoleWithWebIdentity does not require the use of AWS security
// credentials. Therefore, you can distribute an application (for example, on
// mobile devices) that requests temporary security credentials without including
// long-term AWS credentials in the application, and without deploying server-based
// proxy services that use long-term AWS credentials. Instead, the identity
// of the caller is validated by using a token from the web identity provider.
//
// The temporary security credentials returned by this API consist of an access
// key ID, a secret access key, and a security token. Applications can use these
// temporary security credentials to sign calls to AWS service APIs. The credentials
// are valid for the duration that you specified when calling AssumeRoleWithWebIdentity,
// which can be from 900 seconds (15 minutes) to 3600 seconds (1 hour). By default,
// the temporary security credentials are valid for 1 hour.
//
// Optionally, you can pass an IAM access policy to this operation. If you
// choose not to pass a policy, the temporary security credentials that are
// returned by the operation have the permissions that are defined in the access
// policy of the role that is being assumed. If you pass a policy to this operation,
// the temporary security credentials that are returned by the operation have
// the permissions that are allowed by both the access policy of the role that
// is being assumed, and the policy that you pass. This gives you a way to further
// restrict the permissions for the resulting temporary security credentials.
// You cannot use the passed policy to grant permissions that are in excess
// of those allowed by the access policy of the role that is being assumed.
// For more information, see Permissions for AssumeRoleWithWebIdentity (http://docs.aws.amazon.com/STS/latest/UsingSTS/permissions-assume-role.html).
//
// Before your application can call AssumeRoleWithWebIdentity, you must have
// an identity token from a supported identity provider and create a role that
// the application can assume. The role that your application assumes must trust
// the identity provider that is associated with the identity token. In other
// words, the identity provider must be specified in the role's trust policy.
//
// For more information about how to use web identity federation and the AssumeRoleWithWebIdentity
// API, see the following resources:
//
//    Creating a Mobile Application with Third-Party Sign-In (http://docs.aws.amazon.com/STS/latest/UsingSTS/STSUseCases.html#MobileApplication-KnownProvider)
// and  Creating Temporary Security Credentials for Mobile Apps Using Third-Party
// Identity Providers (http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingWIF.html).
//    Web Identity Federation Playground (https://web-identity-federation-playground.s3.amazonaws.com/index.html).
// This interactive website lets you walk through the process of authenticating
// via Login with Amazon, Facebook, or Google, getting temporary security credentials,
// and then using those credentials to make a request to AWS.   AWS SDK for
// iOS (http://aws.amazon.com/sdkforios/) and AWS SDK for Android (http://aws.amazon.com/sdkforandroid/).
// These toolkits contain sample apps that show how to invoke the identity providers,
// and then how to use the information from these providers to get and use temporary
// security credentials.   Web Identity Federation with Mobile Applications
// (http://aws.amazon.com/articles/4617974389850313). This article discusses
// web identity federation and shows an example of how to use web identity federation
// to get access to content in Amazon S3.
func (c *STS) AssumeRoleWithWebIdentity(input *AssumeRoleWithWebIdentityInput) (*AssumeRoleWithWebIdentityOutput, error) {
	req, out := c.AssumeRoleWithWebIdentityRequest(input)
	err := req.Send()
	return out, err
}

const opDecodeAuthorizationMessage = "DecodeAuthorizationMessage"

// DecodeAuthorizationMessageRequest generates a request for the DecodeAuthorizationMessage operation.
func (c *STS) DecodeAuthorizationMessageRequest(input *DecodeAuthorizationMessageInput) (req *request.Request, output *DecodeAuthorizationMessageOutput) {
	op := &request.Operation{
		Name:       opDecodeAuthorizationMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DecodeAuthorizationMessageInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DecodeAuthorizationMessageOutput{}
	req.Data = output
	return
}

// Decodes additional information about the authorization status of a request
// from an encoded message returned in response to an AWS request.
//
// For example, if a user is not authorized to perform an action that he or
// she has requested, the request returns a Client.UnauthorizedOperation response
// (an HTTP 403 response). Some AWS actions additionally return an encoded message
// that can provide details about this authorization failure.
//
//  Only certain AWS actions return an encoded authorization message. The documentation
// for an individual action indicates whether that action returns an encoded
// message in addition to returning an HTTP code.  The message is encoded because
// the details of the authorization status can constitute privileged information
// that the user who requested the action should not see. To decode an authorization
// status message, a user must be granted permissions via an IAM policy to request
// the DecodeAuthorizationMessage (sts:DecodeAuthorizationMessage) action.
//
// The decoded message includes the following type of information:
//
//  Whether the request was denied due to an explicit deny or due to the absence
// of an explicit allow. For more information, see Determining Whether a Request
// is Allowed or Denied (http://docs.aws.amazon.com/IAM/latest/UserGuide/AccessPolicyLanguage_EvaluationLogic.html#policy-eval-denyallow)
// in Using IAM.  The principal who made the request. The requested action.
// The requested resource. The values of condition keys in the context of the
// user's request.
func (c *STS) DecodeAuthorizationMessage(input *DecodeAuthorizationMessageInput) (*DecodeAuthorizationMessageOutput, error) {
	req, out := c.DecodeAuthorizationMessageRequest(input)
	err := req.Send()
	return out, err
}

const opGetFederationToken = "GetFederationToken"

// GetFederationTokenRequest generates a request for the GetFederationToken operation.
func (c *STS) GetFederationTokenRequest(input *GetFederationTokenInput) (req *request.Request, output *GetFederationTokenOutput) {
	op := &request.Operation{
		Name:       opGetFederationToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetFederationTokenInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetFederationTokenOutput{}
	req.Data = output
	return
}

// Returns a set of temporary security credentials (consisting of an access
// key ID, a secret access key, and a security token) for a federated user.
// A typical use is in a proxy application that gets temporary security credentials
// on behalf of distributed applications inside a corporate network. Because
// you must call the GetFederationToken action using the long-term security
// credentials of an IAM user, this call is appropriate in contexts where those
// credentials can be safely stored, usually in a server-based application.
//
//   If you are creating a mobile-based or browser-based app that can authenticate
// users using a web identity provider like Login with Amazon, Facebook, Google,
// or an OpenID Connect-compatible identity provider, we recommend that you
// use Amazon Cognito (http://aws.amazon.com/cognito/) or AssumeRoleWithWebIdentity.
// For more information, see Creating Temporary Security Credentials for Mobile
// Apps Using Identity Providers (http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingWIF.html).
//
//  The GetFederationToken action must be called by using the long-term AWS
// security credentials of an IAM user. You can also call GetFederationToken
// using the security credentials of an AWS account (root), but this is not
// recommended. Instead, we recommend that you create an IAM user for the purpose
// of the proxy application and then attach a policy to the IAM user that limits
// federated users to only the actions and resources they need access to. For
// more information, see IAM Best Practices (http://docs.aws.amazon.com/IAM/latest/UserGuide/IAMBestPractices.html)
// in Using IAM.
//
// The temporary security credentials that are obtained by using the long-term
// credentials of an IAM user are valid for the specified duration, between
// 900 seconds (15 minutes) and 129600 seconds (36 hours). Temporary credentials
// that are obtained by using AWS account (root) credentials have a maximum
// duration of 3600 seconds (1 hour)
//
//  Permissions
//
// The permissions for the temporary security credentials returned by GetFederationToken
// are determined by a combination of the following:
//
//  The policy or policies that are attached to the IAM user whose credentials
// are used to call GetFederationToken. The policy that is passed as a parameter
// in the call.  The passed policy is attached to the temporary security credentials
// that result from the GetFederationToken API call--that is, to the federated
// user. When the federated user makes an AWS request, AWS evaluates the policy
// attached to the federated user in combination with the policy or policies
// attached to the IAM user whose credentials were used to call GetFederationToken.
// AWS allows the federated user's request only when both the federated user
// and the IAM user are explicitly allowed to perform the requested action.
// The passed policy cannot grant more permissions than those that are defined
// in the IAM user policy.
//
// A typical use case is that the permissions of the IAM user whose credentials
// are used to call GetFederationToken are designed to allow access to all the
// actions and resources that any federated user will need. Then, for individual
// users, you pass a policy to the operation that scopes down the permissions
// to a level that's appropriate to that individual user, using a policy that
// allows only a subset of permissions that are granted to the IAM user.
//
// If you do not pass a policy, the resulting temporary security credentials
// have no effective permissions. The only exception is when the temporary security
// credentials are used to access a resource that has a resource-based policy
// that specifically allows the federated user to access the resource.
//
// For more information about how permissions work, see Permissions for GetFederationToken
// (http://docs.aws.amazon.com/STS/latest/UsingSTS/permissions-get-federation-token.html).
// For information about using GetFederationToken to create temporary security
// credentials, see Creating Temporary Credentials to Enable Access for Federated
// Users (http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingFedTokens.html).
func (c *STS) GetFederationToken(input *GetFederationTokenInput) (*GetFederationTokenOutput, error) {
	req, out := c.GetFederationTokenRequest(input)
	err := req.Send()
	return out, err
}

const opGetSessionToken = "GetSessionToken"

// GetSessionTokenRequest generates a request for the GetSessionToken operation.
func (c *STS) GetSessionTokenRequest(input *GetSessionTokenInput) (req *request.Request, output *GetSessionTokenOutput) {
	op := &request.Operation{
		Name:       opGetSessionToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSessionTokenInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSessionTokenOutput{}
	req.Data = output
	return
}

// Returns a set of temporary credentials for an AWS account or IAM user. The
// credentials consist of an access key ID, a secret access key, and a security
// token. Typically, you use GetSessionToken if you want to use MFA to protect
// programmatic calls to specific AWS APIs like Amazon EC2 StopInstances. MFA-enabled
// IAM users would need to call GetSessionToken and submit an MFA code that
// is associated with their MFA device. Using the temporary security credentials
// that are returned from the call, IAM users can then make programmatic calls
// to APIs that require MFA authentication.
//
// The GetSessionToken action must be called by using the long-term AWS security
// credentials of the AWS account or an IAM user. Credentials that are created
// by IAM users are valid for the duration that you specify, between 900 seconds
// (15 minutes) and 129600 seconds (36 hours); credentials that are created
// by using account credentials have a maximum duration of 3600 seconds (1 hour).
//
//  We recommend that you do not call GetSessionToken with root account credentials.
// Instead, follow our best practices (http://docs.aws.amazon.com/IAM/latest/UserGuide/IAMBestPractices.html#create-iam-users)
// by creating one or more IAM users, giving them the necessary permissions,
// and using IAM users for everyday interaction with AWS.
//
//  The permissions associated with the temporary security credentials returned
// by GetSessionToken are based on the permissions associated with account or
// IAM user whose credentials are used to call the action. If GetSessionToken
// is called using root account credentials, the temporary credentials have
// root account permissions. Similarly, if GetSessionToken is called using the
// credentials of an IAM user, the temporary credentials have the same permissions
// as the IAM user.
//
// For more information about using GetSessionToken to create temporary credentials,
// go to Creating Temporary Credentials to Enable Access for IAM Users (http://docs.aws.amazon.com/STS/latest/UsingSTS/CreatingSessionTokens.html"
// target="_blank).
func (c *STS) GetSessionToken(input *GetSessionTokenInput) (*GetSessionTokenOutput, error) {
	req, out := c.GetSessionTokenRequest(input)
	err := req.Send()
	return out, err
}

type AssumeRoleInput struct {
	// The duration, in seconds, of the role session. The value can range from 900
	// seconds (15 minutes) to 3600 seconds (1 hour). By default, the value is set
	// to 3600 seconds.
	DurationSeconds *int64 `min:"900" type:"integer"`

	// A unique identifier that is used by third parties when assuming roles in
	// their customers' accounts. For each role that the third party can assume,
	// they should instruct their customers to ensure the role's trust policy checks
	// for the external ID that the third party generated. Each time the third party
	// assumes the role, they should pass the customer's external ID. The external
	// ID is useful in order to help third parties bind a role to the customer who
	// created it. For more information about the external ID, see How to Use External
	// ID When Granting Access to Your AWS Resources (http://docs.aws.amazon.com/STS/latest/UsingSTS/sts-delegating-externalid.html)
	// in Using Temporary Security Credentials.
	ExternalId *string `min:"2" type:"string"`

	// An IAM policy in JSON format.
	//
	// This parameter is optional. If you pass a policy, the temporary security
	// credentials that are returned by the operation have the permissions that
	// are allowed by both (the intersection of) the access policy of the role that
	// is being assumed, and the policy that you pass. This gives you a way to further
	// restrict the permissions for the resulting temporary security credentials.
	// You cannot use the passed policy to grant permissions that are in excess
	// of those allowed by the access policy of the role that is being assumed.
	// For more information, see Permissions for AssumeRole, AssumeRoleWithSAML,
	// and AssumeRoleWithWebIdentity (http://docs.aws.amazon.com/STS/latest/UsingSTS/permissions-assume-role.html)
	// in Using Temporary Security Credentials.
	//
	// The policy plain text must be 2048 bytes or shorter. However, an internal
	// conversion compresses it into a packed binary format with a separate limit.
	// The PackedPolicySize response element indicates by percentage how close to
	// the upper size limit the policy is, with 100% equaling the maximum allowed
	// size.
	Policy *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the role to assume.
	RoleArn *string `min:"20" type:"string" required:"true"`

	// An identifier for the assumed role session.
	//
	// Use the role session name to uniquely identity a session when the same role
	// is assumed by different principals or for different reasons. In cross-account
	// scenarios, the role session name is visible to, and can be logged by the
	// account that owns the role. The role session name is also used in the ARN
	// of the assumed role principal. This means that subsequent cross-account API
	// requests using the temporary security credentials will expose the role session
	// name to the external account in their CloudTrail logs.
	RoleSessionName *string `min:"2" type:"string" required:"true"`

	// The identification number of the MFA device that is associated with the user
	// who is making the AssumeRole call. Specify this value if the trust policy
	// of the role being assumed includes a condition that requires MFA authentication.
	// The value is either the serial number for a hardware device (such as GAHT12345678)
	// or an Amazon Resource Name (ARN) for a virtual device (such as arn:aws:iam::123456789012:mfa/user).
	SerialNumber *string `min:"9" type:"string"`

	// The value provided by the MFA device, if the trust policy of the role being
	// assumed requires MFA (that is, if the policy includes a condition that tests
	// for MFA). If the role being assumed requires MFA and if the TokenCode value
	// is missing or expired, the AssumeRole call returns an "access denied" error.
	TokenCode *string `min:"6" type:"string"`

	metadataAssumeRoleInput `json:"-" xml:"-"`
}

type metadataAssumeRoleInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssumeRoleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssumeRoleInput) GoString() string {
	return s.String()
}

// Contains the response to a successful AssumeRole request, including temporary
// AWS credentials that can be used to make AWS requests.
type AssumeRoleOutput struct {
	// The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers
	// that you can use to refer to the resulting temporary security credentials.
	// For example, you can reference these credentials as a principal in a resource-based
	// policy by using the ARN or assumed role ID. The ARN and ID include the RoleSessionName
	// that you specified when you called AssumeRole.
	AssumedRoleUser *AssumedRoleUser `type:"structure"`

	// The temporary security credentials, which include an access key ID, a secret
	// access key, and a security (or session) token.
	Credentials *Credentials `type:"structure"`

	// A percentage value that indicates the size of the policy in packed form.
	// The service rejects any policy with a packed size greater than 100 percent,
	// which means the policy exceeded the allowed space.
	PackedPolicySize *int64 `type:"integer"`

	metadataAssumeRoleOutput `json:"-" xml:"-"`
}

type metadataAssumeRoleOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssumeRoleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssumeRoleOutput) GoString() string {
	return s.String()
}

type AssumeRoleWithSAMLInput struct {
	// The duration, in seconds, of the role session. The value can range from 900
	// seconds (15 minutes) to 3600 seconds (1 hour). By default, the value is set
	// to 3600 seconds. An expiration can also be specified in the SAML authentication
	// response's SessionNotOnOrAfter value. The actual expiration time is whichever
	// value is shorter.
	//
	// The maximum duration for a session is 1 hour, and the minimum duration is
	// 15 minutes, even if values outside this range are specified.
	DurationSeconds *int64 `min:"900" type:"integer"`

	// An IAM policy in JSON format.
	//
	// The policy parameter is optional. If you pass a policy, the temporary security
	// credentials that are returned by the operation have the permissions that
	// are allowed by both the access policy of the role that is being assumed,
	// and the policy that you pass. This gives you a way to further restrict the
	// permissions for the resulting temporary security credentials. You cannot
	// use the passed policy to grant permissions that are in excess of those allowed
	// by the access policy of the role that is being assumed. For more information,
	// see Permissions for AssumeRoleWithSAML (http://docs.aws.amazon.com/STS/latest/UsingSTS/permissions-assume-role.html)
	// in Using Temporary Security Credentials.
	//
	// The policy plain text must be 2048 bytes or shorter. However, an internal
	// conversion compresses it into a packed binary format with a separate limit.
	// The PackedPolicySize response element indicates by percentage how close to
	// the upper size limit the policy is, with 100% equaling the maximum allowed
	// size.
	Policy *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the SAML provider in IAM that describes
	// the IdP.
	PrincipalArn *string `min:"20" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the role that the caller is assuming.
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The base-64 encoded SAML authentication response provided by the IdP.
	//
	// For more information, see Configuring a Relying Party and Adding Claims
	// (http://docs.aws.amazon.com/IAM/latest/UserGuide/create-role-saml-IdP-tasks.html)
	// in the Using IAM guide.
	SAMLAssertion *string `min:"4" type:"string" required:"true"`

	metadataAssumeRoleWithSAMLInput `json:"-" xml:"-"`
}

type metadataAssumeRoleWithSAMLInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssumeRoleWithSAMLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssumeRoleWithSAMLInput) GoString() string {
	return s.String()
}

// Contains the response to a successful AssumeRoleWithSAML request, including
// temporary AWS credentials that can be used to make AWS requests.
type AssumeRoleWithSAMLOutput struct {
	// The identifiers for the temporary security credentials that the operation
	// returns.
	AssumedRoleUser *AssumedRoleUser `type:"structure"`

	// The value of the Recipient attribute of the SubjectConfirmationData element
	// of the SAML assertion.
	Audience *string `type:"string"`

	// AWS credentials for API authentication.
	Credentials *Credentials `type:"structure"`

	// The value of the Issuer element of the SAML assertion.
	Issuer *string `type:"string"`

	// A hash value based on the concatenation of the Issuer response value, the
	// AWS account ID, and the friendly name (the last part of the ARN) of the SAML
	// provider in IAM. The combination of NameQualifier and Subject can be used
	// to uniquely identify a federated user.
	//
	// The following pseudocode shows how the hash value is calculated:
	//
	//  BASE64 ( SHA1 ( "https://example.com/saml" + "123456789012" + "/MySAMLIdP"
	// ) )
	NameQualifier *string `type:"string"`

	// A percentage value that indicates the size of the policy in packed form.
	// The service rejects any policy with a packed size greater than 100 percent,
	// which means the policy exceeded the allowed space.
	PackedPolicySize *int64 `type:"integer"`

	// The value of the NameID element in the Subject element of the SAML assertion.
	Subject *string `type:"string"`

	// The format of the name ID, as defined by the Format attribute in the NameID
	// element of the SAML assertion. Typical examples of the format are transient
	// or persistent.
	//
	//  If the format includes the prefix urn:oasis:names:tc:SAML:2.0:nameid-format,
	// that prefix is removed. For example, urn:oasis:names:tc:SAML:2.0:nameid-format:transient
	// is returned as transient. If the format includes any other prefix, the format
	// is returned with no modifications.
	SubjectType *string `type:"string"`

	metadataAssumeRoleWithSAMLOutput `json:"-" xml:"-"`
}

type metadataAssumeRoleWithSAMLOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssumeRoleWithSAMLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssumeRoleWithSAMLOutput) GoString() string {
	return s.String()
}

type AssumeRoleWithWebIdentityInput struct {
	// The duration, in seconds, of the role session. The value can range from 900
	// seconds (15 minutes) to 3600 seconds (1 hour). By default, the value is set
	// to 3600 seconds.
	DurationSeconds *int64 `min:"900" type:"integer"`

	// An IAM policy in JSON format.
	//
	// The policy parameter is optional. If you pass a policy, the temporary security
	// credentials that are returned by the operation have the permissions that
	// are allowed by both the access policy of the role that is being assumed,
	// and the policy that you pass. This gives you a way to further restrict the
	// permissions for the resulting temporary security credentials. You cannot
	// use the passed policy to grant permissions that are in excess of those allowed
	// by the access policy of the role that is being assumed. For more information,
	// see Permissions for AssumeRoleWithWebIdentity (http://docs.aws.amazon.com/STS/latest/UsingSTS/permissions-assume-role.html).
	//
	// The policy plain text must be 2048 bytes or shorter. However, an internal
	// conversion compresses it into a packed binary format with a separate limit.
	// The PackedPolicySize response element indicates by percentage how close to
	// the upper size limit the policy is, with 100% equaling the maximum allowed
	// size.
	Policy *string `min:"1" type:"string"`

	// The fully qualified host component of the domain name of the identity provider.
	//
	// Specify this value only for OAuth 2.0 access tokens. Currently www.amazon.com
	// and graph.facebook.com are the only supported identity providers for OAuth
	// 2.0 access tokens. Do not include URL schemes and port numbers.
	//
	// Do not specify this value for OpenID Connect ID tokens.
	ProviderId *string `min:"4" type:"string"`

	// The Amazon Resource Name (ARN) of the role that the caller is assuming.
	RoleArn *string `min:"20" type:"string" required:"true"`

	// An identifier for the assumed role session. Typically, you pass the name
	// or identifier that is associated with the user who is using your application.
	// That way, the temporary security credentials that your application will use
	// are associated with that user. This session name is included as part of the
	// ARN and assumed role ID in the AssumedRoleUser response element.
	RoleSessionName *string `min:"2" type:"string" required:"true"`

	// The OAuth 2.0 access token or OpenID Connect ID token that is provided by
	// the identity provider. Your application must get this token by authenticating
	// the user who is using your application with a web identity provider before
	// the application makes an AssumeRoleWithWebIdentity call.
	WebIdentityToken *string `min:"4" type:"string" required:"true"`

	metadataAssumeRoleWithWebIdentityInput `json:"-" xml:"-"`
}

type metadataAssumeRoleWithWebIdentityInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssumeRoleWithWebIdentityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssumeRoleWithWebIdentityInput) GoString() string {
	return s.String()
}

// Contains the response to a successful AssumeRoleWithWebIdentity request,
// including temporary AWS credentials that can be used to make AWS requests.
type AssumeRoleWithWebIdentityOutput struct {
	// The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers
	// that you can use to refer to the resulting temporary security credentials.
	// For example, you can reference these credentials as a principal in a resource-based
	// policy by using the ARN or assumed role ID. The ARN and ID include the RoleSessionName
	// that you specified when you called AssumeRole.
	AssumedRoleUser *AssumedRoleUser `type:"structure"`

	// The intended audience (also known as client ID) of the web identity token.
	// This is traditionally the client identifier issued to the application that
	// requested the web identity token.
	Audience *string `type:"string"`

	// The temporary security credentials, which include an access key ID, a secret
	// access key, and a security token.
	Credentials *Credentials `type:"structure"`

	// A percentage value that indicates the size of the policy in packed form.
	// The service rejects any policy with a packed size greater than 100 percent,
	// which means the policy exceeded the allowed space.
	PackedPolicySize *int64 `type:"integer"`

	// The issuing authority of the web identity token presented. For OpenID Connect
	// ID Tokens this contains the value of the iss field. For OAuth 2.0 access
	// tokens, this contains the value of the ProviderId parameter that was passed
	// in the AssumeRoleWithWebIdentity request.
	Provider *string `type:"string"`

	// The unique user identifier that is returned by the identity provider. This
	// identifier is associated with the WebIdentityToken that was submitted with
	// the AssumeRoleWithWebIdentity call. The identifier is typically unique to
	// the user and the application that acquired the WebIdentityToken (pairwise
	// identifier). For OpenID Connect ID tokens, this field contains the value
	// returned by the identity provider as the token's sub (Subject) claim.
	SubjectFromWebIdentityToken *string `min:"6" type:"string"`

	metadataAssumeRoleWithWebIdentityOutput `json:"-" xml:"-"`
}

type metadataAssumeRoleWithWebIdentityOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssumeRoleWithWebIdentityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssumeRoleWithWebIdentityOutput) GoString() string {
	return s.String()
}

// The identifiers for the temporary security credentials that the operation
// returns.
type AssumedRoleUser struct {
	// The ARN of the temporary security credentials that are returned from the
	// AssumeRole action. For more information about ARNs and how to use them in
	// policies, see IAM Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in Using IAM.
	Arn *string `min:"20" type:"string" required:"true"`

	// A unique identifier that contains the role ID and the role session name of
	// the role that is being assumed. The role ID is generated by AWS when the
	// role is created.
	AssumedRoleId *string `min:"2" type:"string" required:"true"`

	metadataAssumedRoleUser `json:"-" xml:"-"`
}

type metadataAssumedRoleUser struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssumedRoleUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssumedRoleUser) GoString() string {
	return s.String()
}

// AWS credentials for API authentication.
type Credentials struct {
	// The access key ID that identifies the temporary security credentials.
	AccessKeyId *string `min:"16" type:"string" required:"true"`

	// The date on which the current credentials expire.
	Expiration *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The secret access key that can be used to sign requests.
	SecretAccessKey *string `type:"string" required:"true"`

	// The token that users must pass to the service API to use the temporary credentials.
	SessionToken *string `type:"string" required:"true"`

	metadataCredentials `json:"-" xml:"-"`
}

type metadataCredentials struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Credentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Credentials) GoString() string {
	return s.String()
}

type DecodeAuthorizationMessageInput struct {
	// The encoded message that was returned with the response.
	EncodedMessage *string `min:"1" type:"string" required:"true"`

	metadataDecodeAuthorizationMessageInput `json:"-" xml:"-"`
}

type metadataDecodeAuthorizationMessageInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DecodeAuthorizationMessageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecodeAuthorizationMessageInput) GoString() string {
	return s.String()
}

// A document that contains additional information about the authorization status
// of a request from an encoded message that is returned in response to an AWS
// request.
type DecodeAuthorizationMessageOutput struct {
	// An XML document that contains the decoded message. For more information,
	// see DecodeAuthorizationMessage.
	DecodedMessage *string `type:"string"`

	metadataDecodeAuthorizationMessageOutput `json:"-" xml:"-"`
}

type metadataDecodeAuthorizationMessageOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DecodeAuthorizationMessageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DecodeAuthorizationMessageOutput) GoString() string {
	return s.String()
}

// Identifiers for the federated user that is associated with the credentials.
type FederatedUser struct {
	// The ARN that specifies the federated user that is associated with the credentials.
	// For more information about ARNs and how to use them in policies, see IAM
	// Identifiers (http://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
	// in Using IAM.
	Arn *string `min:"20" type:"string" required:"true"`

	// The string that identifies the federated user associated with the credentials,
	// similar to the unique ID of an IAM user.
	FederatedUserId *string `min:"2" type:"string" required:"true"`

	metadataFederatedUser `json:"-" xml:"-"`
}

type metadataFederatedUser struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s FederatedUser) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FederatedUser) GoString() string {
	return s.String()
}

type GetFederationTokenInput struct {
	// The duration, in seconds, that the session should last. Acceptable durations
	// for federation sessions range from 900 seconds (15 minutes) to 129600 seconds
	// (36 hours), with 43200 seconds (12 hours) as the default. Sessions obtained
	// using AWS account (root) credentials are restricted to a maximum of 3600
	// seconds (one hour). If the specified duration is longer than one hour, the
	// session obtained by using AWS account (root) credentials defaults to one
	// hour.
	DurationSeconds *int64 `min:"900" type:"integer"`

	// The name of the federated user. The name is used as an identifier for the
	// temporary security credentials (such as Bob). For example, you can reference
	// the federated user name in a resource-based policy, such as in an Amazon
	// S3 bucket policy.
	Name *string `min:"2" type:"string" required:"true"`

	// An IAM policy in JSON format that is passed with the GetFederationToken call
	// and evaluated along with the policy or policies that are attached to the
	// IAM user whose credentials are used to call GetFederationToken. The passed
	// policy is used to scope down the permissions that are available to the IAM
	// user, by allowing only a subset of the permissions that are granted to the
	// IAM user. The passed policy cannot grant more permissions than those granted
	// to the IAM user. The final permissions for the federated user are the most
	// restrictive set based on the intersection of the passed policy and the IAM
	// user policy.
	//
	// If you do not pass a policy, the resulting temporary security credentials
	// have no effective permissions. The only exception is when the temporary security
	// credentials are used to access a resource that has a resource-based policy
	// that specifically allows the federated user to access the resource.
	//
	// The policy plain text must be 2048 bytes or shorter. However, an internal
	// conversion compresses it into a packed binary format with a separate limit.
	// The PackedPolicySize response element indicates by percentage how close to
	// the upper size limit the policy is, with 100% equaling the maximum allowed
	// size.  For more information about how permissions work, see Permissions for
	// GetFederationToken (http://docs.aws.amazon.com/STS/latest/UsingSTS/permissions-get-federation-token.html).
	Policy *string `min:"1" type:"string"`

	metadataGetFederationTokenInput `json:"-" xml:"-"`
}

type metadataGetFederationTokenInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetFederationTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFederationTokenInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetFederationToken request, including
// temporary AWS credentials that can be used to make AWS requests.
type GetFederationTokenOutput struct {
	// Credentials for the service API authentication.
	Credentials *Credentials `type:"structure"`

	// Identifiers for the federated user associated with the credentials (such
	// as arn:aws:sts::123456789012:federated-user/Bob or 123456789012:Bob). You
	// can use the federated user's ARN in your resource-based policies, such as
	// an Amazon S3 bucket policy.
	FederatedUser *FederatedUser `type:"structure"`

	// A percentage value indicating the size of the policy in packed form. The
	// service rejects policies for which the packed size is greater than 100 percent
	// of the allowed value.
	PackedPolicySize *int64 `type:"integer"`

	metadataGetFederationTokenOutput `json:"-" xml:"-"`
}

type metadataGetFederationTokenOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetFederationTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFederationTokenOutput) GoString() string {
	return s.String()
}

type GetSessionTokenInput struct {
	// The duration, in seconds, that the credentials should remain valid. Acceptable
	// durations for IAM user sessions range from 900 seconds (15 minutes) to 129600
	// seconds (36 hours), with 43200 seconds (12 hours) as the default. Sessions
	// for AWS account owners are restricted to a maximum of 3600 seconds (one hour).
	// If the duration is longer than one hour, the session for AWS account owners
	// defaults to one hour.
	DurationSeconds *int64 `min:"900" type:"integer"`

	// The identification number of the MFA device that is associated with the IAM
	// user who is making the GetSessionToken call. Specify this value if the IAM
	// user has a policy that requires MFA authentication. The value is either the
	// serial number for a hardware device (such as GAHT12345678) or an Amazon Resource
	// Name (ARN) for a virtual device (such as arn:aws:iam::123456789012:mfa/user).
	// You can find the device for an IAM user by going to the AWS Management Console
	// and viewing the user's security credentials.
	SerialNumber *string `min:"9" type:"string"`

	// The value provided by the MFA device, if MFA is required. If any policy requires
	// the IAM user to submit an MFA code, specify this value. If MFA authentication
	// is required, and the user does not provide a code when requesting a set of
	// temporary security credentials, the user will receive an "access denied"
	// response when requesting resources that require MFA authentication.
	TokenCode *string `min:"6" type:"string"`

	metadataGetSessionTokenInput `json:"-" xml:"-"`
}

type metadataGetSessionTokenInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSessionTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSessionTokenInput) GoString() string {
	return s.String()
}

// Contains the response to a successful GetSessionToken request, including
// temporary AWS credentials that can be used to make AWS requests.
type GetSessionTokenOutput struct {
	// The session credentials for API authentication.
	Credentials *Credentials `type:"structure"`

	metadataGetSessionTokenOutput `json:"-" xml:"-"`
}

type metadataGetSessionTokenOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSessionTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSessionTokenOutput) GoString() string {
	return s.String()
}
