// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package sns provides a client for Amazon Simple Notification Service.
package sns

import (
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddPermission = "AddPermission"

// AddPermissionRequest generates a request for the AddPermission operation.
func (c *SNS) AddPermissionRequest(input *AddPermissionInput) (req *request.Request, output *AddPermissionOutput) {
	op := &request.Operation{
		Name:       opAddPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddPermissionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddPermissionOutput{}
	req.Data = output
	return
}

// Adds a statement to a topic's access control policy, granting access for
// the specified AWS accounts to the specified actions.
func (c *SNS) AddPermission(input *AddPermissionInput) (*AddPermissionOutput, error) {
	req, out := c.AddPermissionRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmSubscription = "ConfirmSubscription"

// ConfirmSubscriptionRequest generates a request for the ConfirmSubscription operation.
func (c *SNS) ConfirmSubscriptionRequest(input *ConfirmSubscriptionInput) (req *request.Request, output *ConfirmSubscriptionOutput) {
	op := &request.Operation{
		Name:       opConfirmSubscription,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmSubscriptionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConfirmSubscriptionOutput{}
	req.Data = output
	return
}

// Verifies an endpoint owner's intent to receive messages by validating the
// token sent to the endpoint by an earlier Subscribe action. If the token is
// valid, the action creates a new subscription and returns its Amazon Resource
// Name (ARN). This call requires an AWS signature only when the AuthenticateOnUnsubscribe
// flag is set to "true".
func (c *SNS) ConfirmSubscription(input *ConfirmSubscriptionInput) (*ConfirmSubscriptionOutput, error) {
	req, out := c.ConfirmSubscriptionRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePlatformApplication = "CreatePlatformApplication"

// CreatePlatformApplicationRequest generates a request for the CreatePlatformApplication operation.
func (c *SNS) CreatePlatformApplicationRequest(input *CreatePlatformApplicationInput) (req *request.Request, output *CreatePlatformApplicationOutput) {
	op := &request.Operation{
		Name:       opCreatePlatformApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlatformApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePlatformApplicationOutput{}
	req.Data = output
	return
}

// Creates a platform application object for one of the supported push notification
// services, such as APNS and GCM, to which devices and mobile apps may register.
// You must specify PlatformPrincipal and PlatformCredential attributes when
// using the CreatePlatformApplication action. The PlatformPrincipal is received
// from the notification service. For APNS/APNS_SANDBOX, PlatformPrincipal is
// "SSL certificate". For GCM, PlatformPrincipal is not applicable. For ADM,
// PlatformPrincipal is "client id". The PlatformCredential is also received
// from the notification service. For APNS/APNS_SANDBOX, PlatformCredential
// is "private key". For GCM, PlatformCredential is "API key". For ADM, PlatformCredential
// is "client secret". The PlatformApplicationArn that is returned when using
// CreatePlatformApplication is then used as an attribute for the CreatePlatformEndpoint
// action. For more information, see Using Amazon SNS Mobile Push Notifications
// (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
func (c *SNS) CreatePlatformApplication(input *CreatePlatformApplicationInput) (*CreatePlatformApplicationOutput, error) {
	req, out := c.CreatePlatformApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePlatformEndpoint = "CreatePlatformEndpoint"

// CreatePlatformEndpointRequest generates a request for the CreatePlatformEndpoint operation.
func (c *SNS) CreatePlatformEndpointRequest(input *CreatePlatformEndpointInput) (req *request.Request, output *CreatePlatformEndpointOutput) {
	op := &request.Operation{
		Name:       opCreatePlatformEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePlatformEndpointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePlatformEndpointOutput{}
	req.Data = output
	return
}

// Creates an endpoint for a device and mobile app on one of the supported push
// notification services, such as GCM and APNS. CreatePlatformEndpoint requires
// the PlatformApplicationArn that is returned from CreatePlatformApplication.
// The EndpointArn that is returned when using CreatePlatformEndpoint can then
// be used by the Publish action to send a message to a mobile app or by the
// Subscribe action for subscription to a topic. The CreatePlatformEndpoint
// action is idempotent, so if the requester already owns an endpoint with the
// same device token and attributes, that endpoint's ARN is returned without
// creating a new endpoint. For more information, see Using Amazon SNS Mobile
// Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
//
// When using CreatePlatformEndpoint with Baidu, two attributes must be provided:
// ChannelId and UserId. The token field must also contain the ChannelId. For
// more information, see Creating an Amazon SNS Endpoint for Baidu (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePushBaiduEndpoint.html).
func (c *SNS) CreatePlatformEndpoint(input *CreatePlatformEndpointInput) (*CreatePlatformEndpointOutput, error) {
	req, out := c.CreatePlatformEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opCreateTopic = "CreateTopic"

// CreateTopicRequest generates a request for the CreateTopic operation.
func (c *SNS) CreateTopicRequest(input *CreateTopicInput) (req *request.Request, output *CreateTopicOutput) {
	op := &request.Operation{
		Name:       opCreateTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTopicInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateTopicOutput{}
	req.Data = output
	return
}

// Creates a topic to which notifications can be published. Users can create
// at most 3000 topics. For more information, see http://aws.amazon.com/sns
// (http://aws.amazon.com/sns/). This action is idempotent, so if the requester
// already owns a topic with the specified name, that topic's ARN is returned
// without creating a new topic.
func (c *SNS) CreateTopic(input *CreateTopicInput) (*CreateTopicOutput, error) {
	req, out := c.CreateTopicRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEndpoint = "DeleteEndpoint"

// DeleteEndpointRequest generates a request for the DeleteEndpoint operation.
func (c *SNS) DeleteEndpointRequest(input *DeleteEndpointInput) (req *request.Request, output *DeleteEndpointOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteEndpointOutput{}
	req.Data = output
	return
}

// Deletes the endpoint from Amazon SNS. This action is idempotent. For more
// information, see Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
func (c *SNS) DeleteEndpoint(input *DeleteEndpointInput) (*DeleteEndpointOutput, error) {
	req, out := c.DeleteEndpointRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePlatformApplication = "DeletePlatformApplication"

// DeletePlatformApplicationRequest generates a request for the DeletePlatformApplication operation.
func (c *SNS) DeletePlatformApplicationRequest(input *DeletePlatformApplicationInput) (req *request.Request, output *DeletePlatformApplicationOutput) {
	op := &request.Operation{
		Name:       opDeletePlatformApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePlatformApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeletePlatformApplicationOutput{}
	req.Data = output
	return
}

// Deletes a platform application object for one of the supported push notification
// services, such as APNS and GCM. For more information, see Using Amazon SNS
// Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
func (c *SNS) DeletePlatformApplication(input *DeletePlatformApplicationInput) (*DeletePlatformApplicationOutput, error) {
	req, out := c.DeletePlatformApplicationRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteTopic = "DeleteTopic"

// DeleteTopicRequest generates a request for the DeleteTopic operation.
func (c *SNS) DeleteTopicRequest(input *DeleteTopicInput) (req *request.Request, output *DeleteTopicOutput) {
	op := &request.Operation{
		Name:       opDeleteTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTopicInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteTopicOutput{}
	req.Data = output
	return
}

// Deletes a topic and all its subscriptions. Deleting a topic might prevent
// some messages previously sent to the topic from being delivered to subscribers.
// This action is idempotent, so deleting a topic that does not exist does not
// result in an error.
func (c *SNS) DeleteTopic(input *DeleteTopicInput) (*DeleteTopicOutput, error) {
	req, out := c.DeleteTopicRequest(input)
	err := req.Send()
	return out, err
}

const opGetEndpointAttributes = "GetEndpointAttributes"

// GetEndpointAttributesRequest generates a request for the GetEndpointAttributes operation.
func (c *SNS) GetEndpointAttributesRequest(input *GetEndpointAttributesInput) (req *request.Request, output *GetEndpointAttributesOutput) {
	op := &request.Operation{
		Name:       opGetEndpointAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEndpointAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetEndpointAttributesOutput{}
	req.Data = output
	return
}

// Retrieves the endpoint attributes for a device on one of the supported push
// notification services, such as GCM and APNS. For more information, see Using
// Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
func (c *SNS) GetEndpointAttributes(input *GetEndpointAttributesInput) (*GetEndpointAttributesOutput, error) {
	req, out := c.GetEndpointAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetPlatformApplicationAttributes = "GetPlatformApplicationAttributes"

// GetPlatformApplicationAttributesRequest generates a request for the GetPlatformApplicationAttributes operation.
func (c *SNS) GetPlatformApplicationAttributesRequest(input *GetPlatformApplicationAttributesInput) (req *request.Request, output *GetPlatformApplicationAttributesOutput) {
	op := &request.Operation{
		Name:       opGetPlatformApplicationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPlatformApplicationAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPlatformApplicationAttributesOutput{}
	req.Data = output
	return
}

// Retrieves the attributes of the platform application object for the supported
// push notification services, such as APNS and GCM. For more information, see
// Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
func (c *SNS) GetPlatformApplicationAttributes(input *GetPlatformApplicationAttributesInput) (*GetPlatformApplicationAttributesOutput, error) {
	req, out := c.GetPlatformApplicationAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetSubscriptionAttributes = "GetSubscriptionAttributes"

// GetSubscriptionAttributesRequest generates a request for the GetSubscriptionAttributes operation.
func (c *SNS) GetSubscriptionAttributesRequest(input *GetSubscriptionAttributesInput) (req *request.Request, output *GetSubscriptionAttributesOutput) {
	op := &request.Operation{
		Name:       opGetSubscriptionAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSubscriptionAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSubscriptionAttributesOutput{}
	req.Data = output
	return
}

// Returns all of the properties of a subscription.
func (c *SNS) GetSubscriptionAttributes(input *GetSubscriptionAttributesInput) (*GetSubscriptionAttributesOutput, error) {
	req, out := c.GetSubscriptionAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opGetTopicAttributes = "GetTopicAttributes"

// GetTopicAttributesRequest generates a request for the GetTopicAttributes operation.
func (c *SNS) GetTopicAttributesRequest(input *GetTopicAttributesInput) (req *request.Request, output *GetTopicAttributesOutput) {
	op := &request.Operation{
		Name:       opGetTopicAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTopicAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTopicAttributesOutput{}
	req.Data = output
	return
}

// Returns all of the properties of a topic. Topic properties returned might
// differ based on the authorization of the user.
func (c *SNS) GetTopicAttributes(input *GetTopicAttributesInput) (*GetTopicAttributesOutput, error) {
	req, out := c.GetTopicAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opListEndpointsByPlatformApplication = "ListEndpointsByPlatformApplication"

// ListEndpointsByPlatformApplicationRequest generates a request for the ListEndpointsByPlatformApplication operation.
func (c *SNS) ListEndpointsByPlatformApplicationRequest(input *ListEndpointsByPlatformApplicationInput) (req *request.Request, output *ListEndpointsByPlatformApplicationOutput) {
	op := &request.Operation{
		Name:       opListEndpointsByPlatformApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointsByPlatformApplicationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListEndpointsByPlatformApplicationOutput{}
	req.Data = output
	return
}

// Lists the endpoints and endpoint attributes for devices in a supported push
// notification service, such as GCM and APNS. The results for ListEndpointsByPlatformApplication
// are paginated and return a limited list of endpoints, up to 100. If additional
// records are available after the first page results, then a NextToken string
// will be returned. To receive the next page, you call ListEndpointsByPlatformApplication
// again using the NextToken string received from the previous call. When there
// are no more records to return, NextToken will be null. For more information,
// see Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
func (c *SNS) ListEndpointsByPlatformApplication(input *ListEndpointsByPlatformApplicationInput) (*ListEndpointsByPlatformApplicationOutput, error) {
	req, out := c.ListEndpointsByPlatformApplicationRequest(input)
	err := req.Send()
	return out, err
}

func (c *SNS) ListEndpointsByPlatformApplicationPages(input *ListEndpointsByPlatformApplicationInput, fn func(p *ListEndpointsByPlatformApplicationOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListEndpointsByPlatformApplicationRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListEndpointsByPlatformApplicationOutput), lastPage)
	})
}

const opListPlatformApplications = "ListPlatformApplications"

// ListPlatformApplicationsRequest generates a request for the ListPlatformApplications operation.
func (c *SNS) ListPlatformApplicationsRequest(input *ListPlatformApplicationsInput) (req *request.Request, output *ListPlatformApplicationsOutput) {
	op := &request.Operation{
		Name:       opListPlatformApplications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPlatformApplicationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPlatformApplicationsOutput{}
	req.Data = output
	return
}

// Lists the platform application objects for the supported push notification
// services, such as APNS and GCM. The results for ListPlatformApplications
// are paginated and return a limited list of applications, up to 100. If additional
// records are available after the first page results, then a NextToken string
// will be returned. To receive the next page, you call ListPlatformApplications
// using the NextToken string received from the previous call. When there are
// no more records to return, NextToken will be null. For more information,
// see Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
func (c *SNS) ListPlatformApplications(input *ListPlatformApplicationsInput) (*ListPlatformApplicationsOutput, error) {
	req, out := c.ListPlatformApplicationsRequest(input)
	err := req.Send()
	return out, err
}

func (c *SNS) ListPlatformApplicationsPages(input *ListPlatformApplicationsInput, fn func(p *ListPlatformApplicationsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPlatformApplicationsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPlatformApplicationsOutput), lastPage)
	})
}

const opListSubscriptions = "ListSubscriptions"

// ListSubscriptionsRequest generates a request for the ListSubscriptions operation.
func (c *SNS) ListSubscriptionsRequest(input *ListSubscriptionsInput) (req *request.Request, output *ListSubscriptionsOutput) {
	op := &request.Operation{
		Name:       opListSubscriptions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscriptionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListSubscriptionsOutput{}
	req.Data = output
	return
}

// Returns a list of the requester's subscriptions. Each call returns a limited
// list of subscriptions, up to 100. If there are more subscriptions, a NextToken
// is also returned. Use the NextToken parameter in a new ListSubscriptions
// call to get further results.
func (c *SNS) ListSubscriptions(input *ListSubscriptionsInput) (*ListSubscriptionsOutput, error) {
	req, out := c.ListSubscriptionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *SNS) ListSubscriptionsPages(input *ListSubscriptionsInput, fn func(p *ListSubscriptionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSubscriptionsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSubscriptionsOutput), lastPage)
	})
}

const opListSubscriptionsByTopic = "ListSubscriptionsByTopic"

// ListSubscriptionsByTopicRequest generates a request for the ListSubscriptionsByTopic operation.
func (c *SNS) ListSubscriptionsByTopicRequest(input *ListSubscriptionsByTopicInput) (req *request.Request, output *ListSubscriptionsByTopicOutput) {
	op := &request.Operation{
		Name:       opListSubscriptionsByTopic,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSubscriptionsByTopicInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListSubscriptionsByTopicOutput{}
	req.Data = output
	return
}

// Returns a list of the subscriptions to a specific topic. Each call returns
// a limited list of subscriptions, up to 100. If there are more subscriptions,
// a NextToken is also returned. Use the NextToken parameter in a new ListSubscriptionsByTopic
// call to get further results.
func (c *SNS) ListSubscriptionsByTopic(input *ListSubscriptionsByTopicInput) (*ListSubscriptionsByTopicOutput, error) {
	req, out := c.ListSubscriptionsByTopicRequest(input)
	err := req.Send()
	return out, err
}

func (c *SNS) ListSubscriptionsByTopicPages(input *ListSubscriptionsByTopicInput, fn func(p *ListSubscriptionsByTopicOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSubscriptionsByTopicRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSubscriptionsByTopicOutput), lastPage)
	})
}

const opListTopics = "ListTopics"

// ListTopicsRequest generates a request for the ListTopics operation.
func (c *SNS) ListTopicsRequest(input *ListTopicsInput) (req *request.Request, output *ListTopicsOutput) {
	op := &request.Operation{
		Name:       opListTopics,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTopicsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTopicsOutput{}
	req.Data = output
	return
}

// Returns a list of the requester's topics. Each call returns a limited list
// of topics, up to 100. If there are more topics, a NextToken is also returned.
// Use the NextToken parameter in a new ListTopics call to get further results.
func (c *SNS) ListTopics(input *ListTopicsInput) (*ListTopicsOutput, error) {
	req, out := c.ListTopicsRequest(input)
	err := req.Send()
	return out, err
}

func (c *SNS) ListTopicsPages(input *ListTopicsInput, fn func(p *ListTopicsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListTopicsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListTopicsOutput), lastPage)
	})
}

const opPublish = "Publish"

// PublishRequest generates a request for the Publish operation.
func (c *SNS) PublishRequest(input *PublishInput) (req *request.Request, output *PublishOutput) {
	op := &request.Operation{
		Name:       opPublish,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PublishInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PublishOutput{}
	req.Data = output
	return
}

// Sends a message to all of a topic's subscribed endpoints. When a messageId
// is returned, the message has been saved and Amazon SNS will attempt to deliver
// it to the topic's subscribers shortly. The format of the outgoing message
// to each subscribed endpoint depends on the notification protocol selected.
//
// To use the Publish action for sending a message to a mobile endpoint, such
// as an app on a Kindle device or mobile phone, you must specify the EndpointArn.
// The EndpointArn is returned when making a call with the CreatePlatformEndpoint
// action. The second example below shows a request and response for publishing
// to a mobile endpoint.
func (c *SNS) Publish(input *PublishInput) (*PublishOutput, error) {
	req, out := c.PublishRequest(input)
	err := req.Send()
	return out, err
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest generates a request for the RemovePermission operation.
func (c *SNS) RemovePermissionRequest(input *RemovePermissionInput) (req *request.Request, output *RemovePermissionOutput) {
	op := &request.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemovePermissionOutput{}
	req.Data = output
	return
}

// Removes a statement from a topic's access control policy.
func (c *SNS) RemovePermission(input *RemovePermissionInput) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	err := req.Send()
	return out, err
}

const opSetEndpointAttributes = "SetEndpointAttributes"

// SetEndpointAttributesRequest generates a request for the SetEndpointAttributes operation.
func (c *SNS) SetEndpointAttributesRequest(input *SetEndpointAttributesInput) (req *request.Request, output *SetEndpointAttributesOutput) {
	op := &request.Operation{
		Name:       opSetEndpointAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetEndpointAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetEndpointAttributesOutput{}
	req.Data = output
	return
}

// Sets the attributes for an endpoint for a device on one of the supported
// push notification services, such as GCM and APNS. For more information, see
// Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
func (c *SNS) SetEndpointAttributes(input *SetEndpointAttributesInput) (*SetEndpointAttributesOutput, error) {
	req, out := c.SetEndpointAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opSetPlatformApplicationAttributes = "SetPlatformApplicationAttributes"

// SetPlatformApplicationAttributesRequest generates a request for the SetPlatformApplicationAttributes operation.
func (c *SNS) SetPlatformApplicationAttributesRequest(input *SetPlatformApplicationAttributesInput) (req *request.Request, output *SetPlatformApplicationAttributesOutput) {
	op := &request.Operation{
		Name:       opSetPlatformApplicationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetPlatformApplicationAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetPlatformApplicationAttributesOutput{}
	req.Data = output
	return
}

// Sets the attributes of the platform application object for the supported
// push notification services, such as APNS and GCM. For more information, see
// Using Amazon SNS Mobile Push Notifications (http://docs.aws.amazon.com/sns/latest/dg/SNSMobilePush.html).
func (c *SNS) SetPlatformApplicationAttributes(input *SetPlatformApplicationAttributesInput) (*SetPlatformApplicationAttributesOutput, error) {
	req, out := c.SetPlatformApplicationAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opSetSubscriptionAttributes = "SetSubscriptionAttributes"

// SetSubscriptionAttributesRequest generates a request for the SetSubscriptionAttributes operation.
func (c *SNS) SetSubscriptionAttributesRequest(input *SetSubscriptionAttributesInput) (req *request.Request, output *SetSubscriptionAttributesOutput) {
	op := &request.Operation{
		Name:       opSetSubscriptionAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetSubscriptionAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetSubscriptionAttributesOutput{}
	req.Data = output
	return
}

// Allows a subscription owner to set an attribute of the topic to a new value.
func (c *SNS) SetSubscriptionAttributes(input *SetSubscriptionAttributesInput) (*SetSubscriptionAttributesOutput, error) {
	req, out := c.SetSubscriptionAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opSetTopicAttributes = "SetTopicAttributes"

// SetTopicAttributesRequest generates a request for the SetTopicAttributes operation.
func (c *SNS) SetTopicAttributesRequest(input *SetTopicAttributesInput) (req *request.Request, output *SetTopicAttributesOutput) {
	op := &request.Operation{
		Name:       opSetTopicAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTopicAttributesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetTopicAttributesOutput{}
	req.Data = output
	return
}

// Allows a topic owner to set an attribute of the topic to a new value.
func (c *SNS) SetTopicAttributes(input *SetTopicAttributesInput) (*SetTopicAttributesOutput, error) {
	req, out := c.SetTopicAttributesRequest(input)
	err := req.Send()
	return out, err
}

const opSubscribe = "Subscribe"

// SubscribeRequest generates a request for the Subscribe operation.
func (c *SNS) SubscribeRequest(input *SubscribeInput) (req *request.Request, output *SubscribeOutput) {
	op := &request.Operation{
		Name:       opSubscribe,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SubscribeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SubscribeOutput{}
	req.Data = output
	return
}

// Prepares to subscribe an endpoint by sending the endpoint a confirmation
// message. To actually create a subscription, the endpoint owner must call
// the ConfirmSubscription action with the token from the confirmation message.
// Confirmation tokens are valid for three days.
func (c *SNS) Subscribe(input *SubscribeInput) (*SubscribeOutput, error) {
	req, out := c.SubscribeRequest(input)
	err := req.Send()
	return out, err
}

const opUnsubscribe = "Unsubscribe"

// UnsubscribeRequest generates a request for the Unsubscribe operation.
func (c *SNS) UnsubscribeRequest(input *UnsubscribeInput) (req *request.Request, output *UnsubscribeOutput) {
	op := &request.Operation{
		Name:       opUnsubscribe,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UnsubscribeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UnsubscribeOutput{}
	req.Data = output
	return
}

// Deletes a subscription. If the subscription requires authentication for deletion,
// only the owner of the subscription or the topic's owner can unsubscribe,
// and an AWS signature is required. If the Unsubscribe call does not require
// authentication and the requester is not the subscription owner, a final cancellation
// message is delivered to the endpoint, so that the endpoint owner can easily
// resubscribe to the topic if the Unsubscribe request was unintended.
func (c *SNS) Unsubscribe(input *UnsubscribeInput) (*UnsubscribeOutput, error) {
	req, out := c.UnsubscribeRequest(input)
	err := req.Send()
	return out, err
}

type AddPermissionInput struct {
	// The AWS account IDs of the users (principals) who will be given access to
	// the specified actions. The users must have AWS accounts, but do not need
	// to be signed up for this service.
	AWSAccountId []*string `type:"list" required:"true"`

	// The action you want to allow for the specified principal(s).
	//
	// Valid values: any Amazon SNS action name.
	ActionName []*string `type:"list" required:"true"`

	// A unique identifier for the new policy statement.
	Label *string `type:"string" required:"true"`

	// The ARN of the topic whose access control policy you wish to modify.
	TopicArn *string `type:"string" required:"true"`

	metadataAddPermissionInput `json:"-" xml:"-"`
}

type metadataAddPermissionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionInput) GoString() string {
	return s.String()
}

type AddPermissionOutput struct {
	metadataAddPermissionOutput `json:"-" xml:"-"`
}

type metadataAddPermissionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionOutput) GoString() string {
	return s.String()
}

// Input for ConfirmSubscription action.
type ConfirmSubscriptionInput struct {
	// Disallows unauthenticated unsubscribes of the subscription. If the value
	// of this parameter is true and the request has an AWS signature, then only
	// the topic owner and the subscription owner can unsubscribe the endpoint.
	// The unsubscribe action requires AWS authentication.
	AuthenticateOnUnsubscribe *string `type:"string"`

	// Short-lived token sent to an endpoint during the Subscribe action.
	Token *string `type:"string" required:"true"`

	// The ARN of the topic for which you wish to confirm a subscription.
	TopicArn *string `type:"string" required:"true"`

	metadataConfirmSubscriptionInput `json:"-" xml:"-"`
}

type metadataConfirmSubscriptionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfirmSubscriptionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmSubscriptionInput) GoString() string {
	return s.String()
}

// Response for ConfirmSubscriptions action.
type ConfirmSubscriptionOutput struct {
	// The ARN of the created subscription.
	SubscriptionArn *string `type:"string"`

	metadataConfirmSubscriptionOutput `json:"-" xml:"-"`
}

type metadataConfirmSubscriptionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfirmSubscriptionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmSubscriptionOutput) GoString() string {
	return s.String()
}

// Input for CreatePlatformApplication action.
type CreatePlatformApplicationInput struct {
	// For a list of attributes, see SetPlatformApplicationAttributes (http://docs.aws.amazon.com/sns/latest/api/API_SetPlatformApplicationAttributes.html)
	Attributes map[string]*string `type:"map" required:"true"`

	// Application names must be made up of only uppercase and lowercase ASCII letters,
	// numbers, underscores, hyphens, and periods, and must be between 1 and 256
	// characters long.
	Name *string `type:"string" required:"true"`

	// The following platforms are supported: ADM (Amazon Device Messaging), APNS
	// (Apple Push Notification Service), APNS_SANDBOX, and GCM (Google Cloud Messaging).
	Platform *string `type:"string" required:"true"`

	metadataCreatePlatformApplicationInput `json:"-" xml:"-"`
}

type metadataCreatePlatformApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreatePlatformApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlatformApplicationInput) GoString() string {
	return s.String()
}

// Response from CreatePlatformApplication action.
type CreatePlatformApplicationOutput struct {
	// PlatformApplicationArn is returned.
	PlatformApplicationArn *string `type:"string"`

	metadataCreatePlatformApplicationOutput `json:"-" xml:"-"`
}

type metadataCreatePlatformApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreatePlatformApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlatformApplicationOutput) GoString() string {
	return s.String()
}

// Input for CreatePlatformEndpoint action.
type CreatePlatformEndpointInput struct {
	// For a list of attributes, see SetEndpointAttributes (http://docs.aws.amazon.com/sns/latest/api/API_SetEndpointAttributes.html).
	Attributes map[string]*string `type:"map"`

	// Arbitrary user data to associate with the endpoint. Amazon SNS does not use
	// this data. The data must be in UTF-8 format and less than 2KB.
	CustomUserData *string `type:"string"`

	// PlatformApplicationArn returned from CreatePlatformApplication is used to
	// create a an endpoint.
	PlatformApplicationArn *string `type:"string" required:"true"`

	// Unique identifier created by the notification service for an app on a device.
	// The specific name for Token will vary, depending on which notification service
	// is being used. For example, when using APNS as the notification service,
	// you need the device token. Alternatively, when using GCM or ADM, the device
	// token equivalent is called the registration ID.
	Token *string `type:"string" required:"true"`

	metadataCreatePlatformEndpointInput `json:"-" xml:"-"`
}

type metadataCreatePlatformEndpointInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreatePlatformEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlatformEndpointInput) GoString() string {
	return s.String()
}

// Response from CreateEndpoint action.
type CreatePlatformEndpointOutput struct {
	// EndpointArn returned from CreateEndpoint action.
	EndpointArn *string `type:"string"`

	metadataCreatePlatformEndpointOutput `json:"-" xml:"-"`
}

type metadataCreatePlatformEndpointOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreatePlatformEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePlatformEndpointOutput) GoString() string {
	return s.String()
}

// Input for CreateTopic action.
type CreateTopicInput struct {
	// The name of the topic you want to create.
	//
	// Constraints: Topic names must be made up of only uppercase and lowercase
	// ASCII letters, numbers, underscores, and hyphens, and must be between 1 and
	// 256 characters long.
	Name *string `type:"string" required:"true"`

	metadataCreateTopicInput `json:"-" xml:"-"`
}

type metadataCreateTopicInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicInput) GoString() string {
	return s.String()
}

// Response from CreateTopic action.
type CreateTopicOutput struct {
	// The Amazon Resource Name (ARN) assigned to the created topic.
	TopicArn *string `type:"string"`

	metadataCreateTopicOutput `json:"-" xml:"-"`
}

type metadataCreateTopicOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTopicOutput) GoString() string {
	return s.String()
}

// Input for DeleteEndpoint action.
type DeleteEndpointInput struct {
	// EndpointArn of endpoint to delete.
	EndpointArn *string `type:"string" required:"true"`

	metadataDeleteEndpointInput `json:"-" xml:"-"`
}

type metadataDeleteEndpointInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointInput) GoString() string {
	return s.String()
}

type DeleteEndpointOutput struct {
	metadataDeleteEndpointOutput `json:"-" xml:"-"`
}

type metadataDeleteEndpointOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteEndpointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEndpointOutput) GoString() string {
	return s.String()
}

// Input for DeletePlatformApplication action.
type DeletePlatformApplicationInput struct {
	// PlatformApplicationArn of platform application object to delete.
	PlatformApplicationArn *string `type:"string" required:"true"`

	metadataDeletePlatformApplicationInput `json:"-" xml:"-"`
}

type metadataDeletePlatformApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeletePlatformApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlatformApplicationInput) GoString() string {
	return s.String()
}

type DeletePlatformApplicationOutput struct {
	metadataDeletePlatformApplicationOutput `json:"-" xml:"-"`
}

type metadataDeletePlatformApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeletePlatformApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePlatformApplicationOutput) GoString() string {
	return s.String()
}

type DeleteTopicInput struct {
	// The ARN of the topic you want to delete.
	TopicArn *string `type:"string" required:"true"`

	metadataDeleteTopicInput `json:"-" xml:"-"`
}

type metadataDeleteTopicInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicInput) GoString() string {
	return s.String()
}

type DeleteTopicOutput struct {
	metadataDeleteTopicOutput `json:"-" xml:"-"`
}

type metadataDeleteTopicOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteTopicOutput) GoString() string {
	return s.String()
}

// Endpoint for mobile app and device.
type Endpoint struct {
	// Attributes for endpoint.
	Attributes map[string]*string `type:"map"`

	// EndpointArn for mobile app and device.
	EndpointArn *string `type:"string"`

	metadataEndpoint `json:"-" xml:"-"`
}

type metadataEndpoint struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Endpoint) GoString() string {
	return s.String()
}

// Input for GetEndpointAttributes action.
type GetEndpointAttributesInput struct {
	// EndpointArn for GetEndpointAttributes input.
	EndpointArn *string `type:"string" required:"true"`

	metadataGetEndpointAttributesInput `json:"-" xml:"-"`
}

type metadataGetEndpointAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetEndpointAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointAttributesInput) GoString() string {
	return s.String()
}

// Response from GetEndpointAttributes of the EndpointArn.
type GetEndpointAttributesOutput struct {
	// Attributes include the following:
	//
	//   CustomUserData -- arbitrary user data to associate with the endpoint.
	// Amazon SNS does not use this data. The data must be in UTF-8 format and less
	// than 2KB.  Enabled -- flag that enables/disables delivery to the endpoint.
	// Amazon SNS will set this to false when a notification service indicates to
	// Amazon SNS that the endpoint is invalid. Users can set it back to true, typically
	// after updating Token.  Token -- device token, also referred to as a registration
	// id, for an app and mobile device. This is returned from the notification
	// service when an app and mobile device are registered with the notification
	// service.
	Attributes map[string]*string `type:"map"`

	metadataGetEndpointAttributesOutput `json:"-" xml:"-"`
}

type metadataGetEndpointAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetEndpointAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEndpointAttributesOutput) GoString() string {
	return s.String()
}

// Input for GetPlatformApplicationAttributes action.
type GetPlatformApplicationAttributesInput struct {
	// PlatformApplicationArn for GetPlatformApplicationAttributesInput.
	PlatformApplicationArn *string `type:"string" required:"true"`

	metadataGetPlatformApplicationAttributesInput `json:"-" xml:"-"`
}

type metadataGetPlatformApplicationAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetPlatformApplicationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPlatformApplicationAttributesInput) GoString() string {
	return s.String()
}

// Response for GetPlatformApplicationAttributes action.
type GetPlatformApplicationAttributesOutput struct {
	// Attributes include the following:
	//
	//   EventEndpointCreated -- Topic ARN to which EndpointCreated event notifications
	// should be sent.  EventEndpointDeleted -- Topic ARN to which EndpointDeleted
	// event notifications should be sent.  EventEndpointUpdated -- Topic ARN to
	// which EndpointUpdate event notifications should be sent.  EventDeliveryFailure
	// -- Topic ARN to which DeliveryFailure event notifications should be sent
	// upon Direct Publish delivery failure (permanent) to one of the application's
	// endpoints.
	Attributes map[string]*string `type:"map"`

	metadataGetPlatformApplicationAttributesOutput `json:"-" xml:"-"`
}

type metadataGetPlatformApplicationAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetPlatformApplicationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPlatformApplicationAttributesOutput) GoString() string {
	return s.String()
}

// Input for GetSubscriptionAttributes.
type GetSubscriptionAttributesInput struct {
	// The ARN of the subscription whose properties you want to get.
	SubscriptionArn *string `type:"string" required:"true"`

	metadataGetSubscriptionAttributesInput `json:"-" xml:"-"`
}

type metadataGetSubscriptionAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSubscriptionAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionAttributesInput) GoString() string {
	return s.String()
}

// Response for GetSubscriptionAttributes action.
type GetSubscriptionAttributesOutput struct {
	// A map of the subscription's attributes. Attributes in this map include the
	// following:
	//
	//   SubscriptionArn -- the subscription's ARN  TopicArn -- the topic ARN that
	// the subscription is associated with  Owner -- the AWS account ID of the subscription's
	// owner  ConfirmationWasAuthenticated -- true if the subscription confirmation
	// request was authenticated  DeliveryPolicy -- the JSON serialization of the
	// subscription's delivery policy  EffectiveDeliveryPolicy -- the JSON serialization
	// of the effective delivery policy that takes into account the topic delivery
	// policy and account system defaults
	Attributes map[string]*string `type:"map"`

	metadataGetSubscriptionAttributesOutput `json:"-" xml:"-"`
}

type metadataGetSubscriptionAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSubscriptionAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSubscriptionAttributesOutput) GoString() string {
	return s.String()
}

// Input for GetTopicAttributes action.
type GetTopicAttributesInput struct {
	// The ARN of the topic whose properties you want to get.
	TopicArn *string `type:"string" required:"true"`

	metadataGetTopicAttributesInput `json:"-" xml:"-"`
}

type metadataGetTopicAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetTopicAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTopicAttributesInput) GoString() string {
	return s.String()
}

// Response for GetTopicAttributes action.
type GetTopicAttributesOutput struct {
	// A map of the topic's attributes. Attributes in this map include the following:
	//
	//   TopicArn -- the topic's ARN  Owner -- the AWS account ID of the topic's
	// owner  Policy -- the JSON serialization of the topic's access control policy
	//  DisplayName -- the human-readable name used in the "From" field for notifications
	// to email and email-json endpoints  SubscriptionsPending -- the number of
	// subscriptions pending confirmation on this topic  SubscriptionsConfirmed
	// -- the number of confirmed subscriptions on this topic  SubscriptionsDeleted
	// -- the number of deleted subscriptions on this topic  DeliveryPolicy -- the
	// JSON serialization of the topic's delivery policy  EffectiveDeliveryPolicy
	// -- the JSON serialization of the effective delivery policy that takes into
	// account system defaults
	Attributes map[string]*string `type:"map"`

	metadataGetTopicAttributesOutput `json:"-" xml:"-"`
}

type metadataGetTopicAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetTopicAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTopicAttributesOutput) GoString() string {
	return s.String()
}

// Input for ListEndpointsByPlatformApplication action.
type ListEndpointsByPlatformApplicationInput struct {
	// NextToken string is used when calling ListEndpointsByPlatformApplication
	// action to retrieve additional records that are available after the first
	// page results.
	NextToken *string `type:"string"`

	// PlatformApplicationArn for ListEndpointsByPlatformApplicationInput action.
	PlatformApplicationArn *string `type:"string" required:"true"`

	metadataListEndpointsByPlatformApplicationInput `json:"-" xml:"-"`
}

type metadataListEndpointsByPlatformApplicationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListEndpointsByPlatformApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointsByPlatformApplicationInput) GoString() string {
	return s.String()
}

// Response for ListEndpointsByPlatformApplication action.
type ListEndpointsByPlatformApplicationOutput struct {
	// Endpoints returned for ListEndpointsByPlatformApplication action.
	Endpoints []*Endpoint `type:"list"`

	// NextToken string is returned when calling ListEndpointsByPlatformApplication
	// action if additional records are available after the first page results.
	NextToken *string `type:"string"`

	metadataListEndpointsByPlatformApplicationOutput `json:"-" xml:"-"`
}

type metadataListEndpointsByPlatformApplicationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListEndpointsByPlatformApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEndpointsByPlatformApplicationOutput) GoString() string {
	return s.String()
}

// Input for ListPlatformApplications action.
type ListPlatformApplicationsInput struct {
	// NextToken string is used when calling ListPlatformApplications action to
	// retrieve additional records that are available after the first page results.
	NextToken *string `type:"string"`

	metadataListPlatformApplicationsInput `json:"-" xml:"-"`
}

type metadataListPlatformApplicationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListPlatformApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlatformApplicationsInput) GoString() string {
	return s.String()
}

// Response for ListPlatformApplications action.
type ListPlatformApplicationsOutput struct {
	// NextToken string is returned when calling ListPlatformApplications action
	// if additional records are available after the first page results.
	NextToken *string `type:"string"`

	// Platform applications returned when calling ListPlatformApplications action.
	PlatformApplications []*PlatformApplication `type:"list"`

	metadataListPlatformApplicationsOutput `json:"-" xml:"-"`
}

type metadataListPlatformApplicationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListPlatformApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPlatformApplicationsOutput) GoString() string {
	return s.String()
}

// Input for ListSubscriptionsByTopic action.
type ListSubscriptionsByTopicInput struct {
	// Token returned by the previous ListSubscriptionsByTopic request.
	NextToken *string `type:"string"`

	// The ARN of the topic for which you wish to find subscriptions.
	TopicArn *string `type:"string" required:"true"`

	metadataListSubscriptionsByTopicInput `json:"-" xml:"-"`
}

type metadataListSubscriptionsByTopicInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListSubscriptionsByTopicInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionsByTopicInput) GoString() string {
	return s.String()
}

// Response for ListSubscriptionsByTopic action.
type ListSubscriptionsByTopicOutput struct {
	// Token to pass along to the next ListSubscriptionsByTopic request. This element
	// is returned if there are more subscriptions to retrieve.
	NextToken *string `type:"string"`

	// A list of subscriptions.
	Subscriptions []*Subscription `type:"list"`

	metadataListSubscriptionsByTopicOutput `json:"-" xml:"-"`
}

type metadataListSubscriptionsByTopicOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListSubscriptionsByTopicOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionsByTopicOutput) GoString() string {
	return s.String()
}

// Input for ListSubscriptions action.
type ListSubscriptionsInput struct {
	// Token returned by the previous ListSubscriptions request.
	NextToken *string `type:"string"`

	metadataListSubscriptionsInput `json:"-" xml:"-"`
}

type metadataListSubscriptionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListSubscriptionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionsInput) GoString() string {
	return s.String()
}

// Response for ListSubscriptions action
type ListSubscriptionsOutput struct {
	// Token to pass along to the next ListSubscriptions request. This element is
	// returned if there are more subscriptions to retrieve.
	NextToken *string `type:"string"`

	// A list of subscriptions.
	Subscriptions []*Subscription `type:"list"`

	metadataListSubscriptionsOutput `json:"-" xml:"-"`
}

type metadataListSubscriptionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListSubscriptionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscriptionsOutput) GoString() string {
	return s.String()
}

type ListTopicsInput struct {
	// Token returned by the previous ListTopics request.
	NextToken *string `type:"string"`

	metadataListTopicsInput `json:"-" xml:"-"`
}

type metadataListTopicsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTopicsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicsInput) GoString() string {
	return s.String()
}

// Response for ListTopics action.
type ListTopicsOutput struct {
	// Token to pass along to the next ListTopics request. This element is returned
	// if there are additional topics to retrieve.
	NextToken *string `type:"string"`

	// A list of topic ARNs.
	Topics []*Topic `type:"list"`

	metadataListTopicsOutput `json:"-" xml:"-"`
}

type metadataListTopicsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTopicsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTopicsOutput) GoString() string {
	return s.String()
}

// The user-specified message attribute value. For string data types, the value
// attribute has the same restrictions on the content as the message body. For
// more information, see Publish (http://docs.aws.amazon.com/sns/latest/api/API_Publish.html).
//
// Name, type, and value must not be empty or null. In addition, the message
// body should not be empty or null. All parts of the message attribute, including
// name, type, and value, are included in the message size restriction, which
// is currently 256 KB (262,144 bytes). For more information, see Using Amazon
// SNS Message Attributes (http://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html).
type MessageAttributeValue struct {
	// Binary type attributes can store any binary data, for example, compressed
	// data, encrypted data, or images.
	BinaryValue []byte `type:"blob"`

	// Amazon SNS supports the following logical data types: String, Number, and
	// Binary. For more information, see Message Attribute Data Types (http://docs.aws.amazon.com/sns/latest/dg/SNSMessageAttributes.html#SNSMessageAttributes.DataTypes).
	DataType *string `type:"string" required:"true"`

	// Strings are Unicode with UTF8 binary encoding. For a list of code values,
	// see http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters (http://en.wikipedia.org/wiki/ASCII#ASCII_printable_characters).
	StringValue *string `type:"string"`

	metadataMessageAttributeValue `json:"-" xml:"-"`
}

type metadataMessageAttributeValue struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s MessageAttributeValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s MessageAttributeValue) GoString() string {
	return s.String()
}

// Platform application object.
type PlatformApplication struct {
	// Attributes for platform application object.
	Attributes map[string]*string `type:"map"`

	// PlatformApplicationArn for platform application object.
	PlatformApplicationArn *string `type:"string"`

	metadataPlatformApplication `json:"-" xml:"-"`
}

type metadataPlatformApplication struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PlatformApplication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlatformApplication) GoString() string {
	return s.String()
}

// Input for Publish action.
type PublishInput struct {
	// The message you want to send to the topic.
	//
	// If you want to send the same message to all transport protocols, include
	// the text of the message as a String value.
	//
	// If you want to send different messages for each transport protocol, set
	// the value of the MessageStructure parameter to json and use a JSON object
	// for the Message parameter. See the Examples section for the format of the
	// JSON object.
	//
	// Constraints: Messages must be UTF-8 encoded strings at most 256 KB in size
	// (262144 bytes, not 262144 characters).
	//
	// JSON-specific constraints:  Keys in the JSON object that correspond to supported
	// transport protocols must have simple JSON string values.  The values will
	// be parsed (unescaped) before they are used in outgoing messages. Outbound
	// notifications are JSON encoded (meaning that the characters will be reescaped
	// for sending). Values have a minimum length of 0 (the empty string, "", is
	// allowed). Values have a maximum length bounded by the overall message size
	// (so, including multiple protocols may limit message sizes). Non-string values
	// will cause the key to be ignored. Keys that do not correspond to supported
	// transport protocols are ignored. Duplicate keys are not allowed. Failure
	// to parse or validate any key or value in the message will cause the Publish
	// call to return an error (no partial delivery).
	Message *string `type:"string" required:"true"`

	// Message attributes for Publish action.
	MessageAttributes map[string]*MessageAttributeValue `locationNameKey:"Name" locationNameValue:"Value" type:"map"`

	// Set MessageStructure to json if you want to send a different message for
	// each protocol. For example, using one publish action, you can send a short
	// message to your SMS subscribers and a longer message to your email subscribers.
	// If you set MessageStructure to json, the value of the Message parameter must:
	//
	//  be a syntactically valid JSON object; and contain at least a top-level
	// JSON key of "default" with a value that is a string.   You can define other
	// top-level keys that define the message you want to send to a specific transport
	// protocol (e.g., "http").
	//
	// For information about sending different messages for each protocol using
	// the AWS Management Console, go to Create Different Messages for Each Protocol
	// (http://docs.aws.amazon.com/sns/latest/gsg/Publish.html#sns-message-formatting-by-protocol)
	// in the Amazon Simple Notification Service Getting Started Guide.
	//
	// Valid value: json
	MessageStructure *string `type:"string"`

	// Optional parameter to be used as the "Subject" line when the message is delivered
	// to email endpoints. This field will also be included, if present, in the
	// standard JSON messages delivered to other endpoints.
	//
	// Constraints: Subjects must be ASCII text that begins with a letter, number,
	// or punctuation mark; must not include line breaks or control characters;
	// and must be less than 100 characters long.
	Subject *string `type:"string"`

	// Either TopicArn or EndpointArn, but not both.
	TargetArn *string `type:"string"`

	// The topic you want to publish to.
	TopicArn *string `type:"string"`

	metadataPublishInput `json:"-" xml:"-"`
}

type metadataPublishInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PublishInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishInput) GoString() string {
	return s.String()
}

// Response for Publish action.
type PublishOutput struct {
	// Unique identifier assigned to the published message.
	//
	// Length Constraint: Maximum 100 characters
	MessageId *string `type:"string"`

	metadataPublishOutput `json:"-" xml:"-"`
}

type metadataPublishOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PublishOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PublishOutput) GoString() string {
	return s.String()
}

// Input for RemovePermission action.
type RemovePermissionInput struct {
	// The unique label of the statement you want to remove.
	Label *string `type:"string" required:"true"`

	// The ARN of the topic whose access control policy you wish to modify.
	TopicArn *string `type:"string" required:"true"`

	metadataRemovePermissionInput `json:"-" xml:"-"`
}

type metadataRemovePermissionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

type RemovePermissionOutput struct {
	metadataRemovePermissionOutput `json:"-" xml:"-"`
}

type metadataRemovePermissionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

// Input for SetEndpointAttributes action.
type SetEndpointAttributesInput struct {
	// A map of the endpoint attributes. Attributes in this map include the following:
	//
	//   CustomUserData -- arbitrary user data to associate with the endpoint.
	// Amazon SNS does not use this data. The data must be in UTF-8 format and less
	// than 2KB.  Enabled -- flag that enables/disables delivery to the endpoint.
	// Amazon SNS will set this to false when a notification service indicates to
	// Amazon SNS that the endpoint is invalid. Users can set it back to true, typically
	// after updating Token.  Token -- device token, also referred to as a registration
	// id, for an app and mobile device. This is returned from the notification
	// service when an app and mobile device are registered with the notification
	// service.
	Attributes map[string]*string `type:"map" required:"true"`

	// EndpointArn used for SetEndpointAttributes action.
	EndpointArn *string `type:"string" required:"true"`

	metadataSetEndpointAttributesInput `json:"-" xml:"-"`
}

type metadataSetEndpointAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetEndpointAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetEndpointAttributesInput) GoString() string {
	return s.String()
}

type SetEndpointAttributesOutput struct {
	metadataSetEndpointAttributesOutput `json:"-" xml:"-"`
}

type metadataSetEndpointAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetEndpointAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetEndpointAttributesOutput) GoString() string {
	return s.String()
}

// Input for SetPlatformApplicationAttributes action.
type SetPlatformApplicationAttributesInput struct {
	// A map of the platform application attributes. Attributes in this map include
	// the following:
	//
	//   PlatformCredential -- The credential received from the notification service.
	// For APNS/APNS_SANDBOX, PlatformCredential is "private key". For GCM, PlatformCredential
	// is "API key". For ADM, PlatformCredential is "client secret".  PlatformPrincipal
	// -- The principal received from the notification service. For APNS/APNS_SANDBOX,
	// PlatformPrincipal is "SSL certificate". For GCM, PlatformPrincipal is not
	// applicable. For ADM, PlatformPrincipal is "client id".  EventEndpointCreated
	// -- Topic ARN to which EndpointCreated event notifications should be sent.
	//  EventEndpointDeleted -- Topic ARN to which EndpointDeleted event notifications
	// should be sent.  EventEndpointUpdated -- Topic ARN to which EndpointUpdate
	// event notifications should be sent.  EventDeliveryFailure -- Topic ARN to
	// which DeliveryFailure event notifications should be sent upon Direct Publish
	// delivery failure (permanent) to one of the application's endpoints.
	Attributes map[string]*string `type:"map" required:"true"`

	// PlatformApplicationArn for SetPlatformApplicationAttributes action.
	PlatformApplicationArn *string `type:"string" required:"true"`

	metadataSetPlatformApplicationAttributesInput `json:"-" xml:"-"`
}

type metadataSetPlatformApplicationAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetPlatformApplicationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetPlatformApplicationAttributesInput) GoString() string {
	return s.String()
}

type SetPlatformApplicationAttributesOutput struct {
	metadataSetPlatformApplicationAttributesOutput `json:"-" xml:"-"`
}

type metadataSetPlatformApplicationAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetPlatformApplicationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetPlatformApplicationAttributesOutput) GoString() string {
	return s.String()
}

// Input for SetSubscriptionAttributes action.
type SetSubscriptionAttributesInput struct {
	// The name of the attribute you want to set. Only a subset of the subscriptions
	// attributes are mutable.
	//
	// Valid values: DeliveryPolicy | RawMessageDelivery
	AttributeName *string `type:"string" required:"true"`

	// The new value for the attribute in JSON format.
	AttributeValue *string `type:"string"`

	// The ARN of the subscription to modify.
	SubscriptionArn *string `type:"string" required:"true"`

	metadataSetSubscriptionAttributesInput `json:"-" xml:"-"`
}

type metadataSetSubscriptionAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetSubscriptionAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSubscriptionAttributesInput) GoString() string {
	return s.String()
}

type SetSubscriptionAttributesOutput struct {
	metadataSetSubscriptionAttributesOutput `json:"-" xml:"-"`
}

type metadataSetSubscriptionAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetSubscriptionAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetSubscriptionAttributesOutput) GoString() string {
	return s.String()
}

// Input for SetTopicAttributes action.
type SetTopicAttributesInput struct {
	// The name of the attribute you want to set. Only a subset of the topic's attributes
	// are mutable.
	//
	// Valid values: Policy | DisplayName | DeliveryPolicy
	AttributeName *string `type:"string" required:"true"`

	// The new value for the attribute.
	AttributeValue *string `type:"string"`

	// The ARN of the topic to modify.
	TopicArn *string `type:"string" required:"true"`

	metadataSetTopicAttributesInput `json:"-" xml:"-"`
}

type metadataSetTopicAttributesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetTopicAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTopicAttributesInput) GoString() string {
	return s.String()
}

type SetTopicAttributesOutput struct {
	metadataSetTopicAttributesOutput `json:"-" xml:"-"`
}

type metadataSetTopicAttributesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetTopicAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTopicAttributesOutput) GoString() string {
	return s.String()
}

// Input for Subscribe action.
type SubscribeInput struct {
	// The endpoint that you want to receive notifications. Endpoints vary by protocol:
	//
	//  For the http protocol, the endpoint is an URL beginning with "http://"
	// For the https protocol, the endpoint is a URL beginning with "https://" For
	// the email protocol, the endpoint is an email address For the email-json protocol,
	// the endpoint is an email address For the sms protocol, the endpoint is a
	// phone number of an SMS-enabled device For the sqs protocol, the endpoint
	// is the ARN of an Amazon SQS queue For the application protocol, the endpoint
	// is the EndpointArn of a mobile app and device.
	Endpoint *string `type:"string"`

	// The protocol you want to use. Supported protocols include:
	//
	//   http -- delivery of JSON-encoded message via HTTP POST  https -- delivery
	// of JSON-encoded message via HTTPS POST  email -- delivery of message via
	// SMTP  email-json -- delivery of JSON-encoded message via SMTP  sms -- delivery
	// of message via SMS  sqs -- delivery of JSON-encoded message to an Amazon
	// SQS queue  application -- delivery of JSON-encoded message to an EndpointArn
	// for a mobile app and device.
	Protocol *string `type:"string" required:"true"`

	// The ARN of the topic you want to subscribe to.
	TopicArn *string `type:"string" required:"true"`

	metadataSubscribeInput `json:"-" xml:"-"`
}

type metadataSubscribeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SubscribeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscribeInput) GoString() string {
	return s.String()
}

// Response for Subscribe action.
type SubscribeOutput struct {
	// The ARN of the subscription, if the service was able to create a subscription
	// immediately (without requiring endpoint owner confirmation).
	SubscriptionArn *string `type:"string"`

	metadataSubscribeOutput `json:"-" xml:"-"`
}

type metadataSubscribeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SubscribeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscribeOutput) GoString() string {
	return s.String()
}

// A wrapper type for the attributes of an Amazon SNS subscription.
type Subscription struct {
	// The subscription's endpoint (format depends on the protocol).
	Endpoint *string `type:"string"`

	// The subscription's owner.
	Owner *string `type:"string"`

	// The subscription's protocol.
	Protocol *string `type:"string"`

	// The subscription's ARN.
	SubscriptionArn *string `type:"string"`

	// The ARN of the subscription's topic.
	TopicArn *string `type:"string"`

	metadataSubscription `json:"-" xml:"-"`
}

type metadataSubscription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Subscription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Subscription) GoString() string {
	return s.String()
}

// A wrapper type for the topic's Amazon Resource Name (ARN). To retrieve a
// topic's attributes, use GetTopicAttributes.
type Topic struct {
	// The topic's ARN.
	TopicArn *string `type:"string"`

	metadataTopic `json:"-" xml:"-"`
}

type metadataTopic struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Topic) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Topic) GoString() string {
	return s.String()
}

// Input for Unsubscribe action.
type UnsubscribeInput struct {
	// The ARN of the subscription to be deleted.
	SubscriptionArn *string `type:"string" required:"true"`

	metadataUnsubscribeInput `json:"-" xml:"-"`
}

type metadataUnsubscribeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UnsubscribeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsubscribeInput) GoString() string {
	return s.String()
}

type UnsubscribeOutput struct {
	metadataUnsubscribeOutput `json:"-" xml:"-"`
}

type metadataUnsubscribeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UnsubscribeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UnsubscribeOutput) GoString() string {
	return s.String()
}
