// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package route53 provides a client for Amazon Route 53.
package route53

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAssociateVPCWithHostedZone = "AssociateVPCWithHostedZone"

// AssociateVPCWithHostedZoneRequest generates a request for the AssociateVPCWithHostedZone operation.
func (c *Route53) AssociateVPCWithHostedZoneRequest(input *AssociateVPCWithHostedZoneInput) (req *request.Request, output *AssociateVPCWithHostedZoneOutput) {
	op := &request.Operation{
		Name:       opAssociateVPCWithHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/associatevpc",
	}

	if input == nil {
		input = &AssociateVPCWithHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AssociateVPCWithHostedZoneOutput{}
	req.Data = output
	return
}

// This action associates a VPC with an hosted zone.
//
//  To associate a VPC with an hosted zone, send a POST request to the 2013-04-01/hostedzone/hosted
// zone ID/associatevpc resource. The request body must include an XML document
// with a AssociateVPCWithHostedZoneRequest element. The response returns the
// AssociateVPCWithHostedZoneResponse element that contains ChangeInfo for you
// to track the progress of the AssociateVPCWithHostedZoneRequest you made.
// See GetChange operation for how to track the progress of your change.
func (c *Route53) AssociateVPCWithHostedZone(input *AssociateVPCWithHostedZoneInput) (*AssociateVPCWithHostedZoneOutput, error) {
	req, out := c.AssociateVPCWithHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opChangeResourceRecordSets = "ChangeResourceRecordSets"

// ChangeResourceRecordSetsRequest generates a request for the ChangeResourceRecordSets operation.
func (c *Route53) ChangeResourceRecordSetsRequest(input *ChangeResourceRecordSetsInput) (req *request.Request, output *ChangeResourceRecordSetsOutput) {
	op := &request.Operation{
		Name:       opChangeResourceRecordSets,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrset/",
	}

	if input == nil {
		input = &ChangeResourceRecordSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ChangeResourceRecordSetsOutput{}
	req.Data = output
	return
}

// Use this action to create or change your authoritative DNS information. To
// use this action, send a POST request to the 2013-04-01/hostedzone/hosted
// Zone ID/rrset resource. The request body must include an XML document with
// a ChangeResourceRecordSetsRequest element.
//
// Changes are a list of change items and are considered transactional. For
// more information on transactional changes, also known as change batches,
// see Creating, Changing, and Deleting Resource Record Sets Using the Route
// 53 API (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/RRSchanges.html#RRSchanges_API)
// in the Amazon Route 53 Developer Guide.
//
// Due to the nature of transactional changes, you cannot delete the same resource
// record set more than once in a single change batch. If you attempt to delete
// the same change batch more than once, Route 53 returns an InvalidChangeBatch
// error. In response to a ChangeResourceRecordSets request, your DNS data is
// changed on all Route 53 DNS servers. Initially, the status of a change is
// PENDING. This means the change has not yet propagated to all the authoritative
// Route 53 DNS servers. When the change is propagated to all hosts, the change
// returns a status of INSYNC.
//
// Note the following limitations on a ChangeResourceRecordSets request:
//
// - A request cannot contain more than 100 Change elements.
//
// - A request cannot contain more than 1000 ResourceRecord elements.
//
// The sum of the number of characters (including spaces) in all Value elements
// in a request cannot exceed 32,000 characters.
func (c *Route53) ChangeResourceRecordSets(input *ChangeResourceRecordSetsInput) (*ChangeResourceRecordSetsOutput, error) {
	req, out := c.ChangeResourceRecordSetsRequest(input)
	err := req.Send()
	return out, err
}

const opChangeTagsForResource = "ChangeTagsForResource"

// ChangeTagsForResourceRequest generates a request for the ChangeTagsForResource operation.
func (c *Route53) ChangeTagsForResourceRequest(input *ChangeTagsForResourceInput) (req *request.Request, output *ChangeTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opChangeTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}/{ResourceId}",
	}

	if input == nil {
		input = &ChangeTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ChangeTagsForResourceOutput{}
	req.Data = output
	return
}

func (c *Route53) ChangeTagsForResource(input *ChangeTagsForResourceInput) (*ChangeTagsForResourceOutput, error) {
	req, out := c.ChangeTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHealthCheck = "CreateHealthCheck"

// CreateHealthCheckRequest generates a request for the CreateHealthCheck operation.
func (c *Route53) CreateHealthCheckRequest(input *CreateHealthCheckInput) (req *request.Request, output *CreateHealthCheckOutput) {
	op := &request.Operation{
		Name:       opCreateHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/healthcheck",
	}

	if input == nil {
		input = &CreateHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHealthCheckOutput{}
	req.Data = output
	return
}

// This action creates a new health check.
//
//  To create a new health check, send a POST request to the 2013-04-01/healthcheck
// resource. The request body must include an XML document with a CreateHealthCheckRequest
// element. The response returns the CreateHealthCheckResponse element that
// contains metadata about the health check.
func (c *Route53) CreateHealthCheck(input *CreateHealthCheckInput) (*CreateHealthCheckOutput, error) {
	req, out := c.CreateHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opCreateHostedZone = "CreateHostedZone"

// CreateHostedZoneRequest generates a request for the CreateHostedZone operation.
func (c *Route53) CreateHostedZoneRequest(input *CreateHostedZoneInput) (req *request.Request, output *CreateHostedZoneOutput) {
	op := &request.Operation{
		Name:       opCreateHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone",
	}

	if input == nil {
		input = &CreateHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateHostedZoneOutput{}
	req.Data = output
	return
}

// This action creates a new hosted zone.
//
// To create a new hosted zone, send a POST request to the 2013-04-01/hostedzone
// resource. The request body must include an XML document with a CreateHostedZoneRequest
// element. The response returns the CreateHostedZoneResponse element that contains
// metadata about the hosted zone.
//
// Route 53 automatically creates a default SOA record and four NS records
// for the zone. The NS records in the hosted zone are the name servers you
// give your registrar to delegate your domain to. For more information about
// SOA and NS records, see NS and SOA Records that Route 53 Creates for a Hosted
// Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/SOA-NSrecords.html)
// in the Amazon Route 53 Developer Guide.
//
// When you create a zone, its initial status is PENDING. This means that it
// is not yet available on all DNS servers. The status of the zone changes to
// INSYNC when the NS and SOA records are available on all Route 53 DNS servers.
//
// When trying to create a hosted zone using a reusable delegation set, you
// could specify an optional DelegationSetId, and Route53 would assign those
// 4 NS records for the zone, instead of alloting a new one.
func (c *Route53) CreateHostedZone(input *CreateHostedZoneInput) (*CreateHostedZoneOutput, error) {
	req, out := c.CreateHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opCreateReusableDelegationSet = "CreateReusableDelegationSet"

// CreateReusableDelegationSetRequest generates a request for the CreateReusableDelegationSet operation.
func (c *Route53) CreateReusableDelegationSetRequest(input *CreateReusableDelegationSetInput) (req *request.Request, output *CreateReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opCreateReusableDelegationSet,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/delegationset",
	}

	if input == nil {
		input = &CreateReusableDelegationSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateReusableDelegationSetOutput{}
	req.Data = output
	return
}

// This action creates a reusable delegationSet.
//
//  To create a new reusable delegationSet, send a POST request to the 2013-04-01/delegationset
// resource. The request body must include an XML document with a CreateReusableDelegationSetRequest
// element. The response returns the CreateReusableDelegationSetResponse element
// that contains metadata about the delegationSet.
//
//  If the optional parameter HostedZoneId is specified, it marks the delegationSet
// associated with that particular hosted zone as reusable.
func (c *Route53) CreateReusableDelegationSet(input *CreateReusableDelegationSetInput) (*CreateReusableDelegationSetOutput, error) {
	req, out := c.CreateReusableDelegationSetRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHealthCheck = "DeleteHealthCheck"

// DeleteHealthCheckRequest generates a request for the DeleteHealthCheck operation.
func (c *Route53) DeleteHealthCheckRequest(input *DeleteHealthCheckInput) (req *request.Request, output *DeleteHealthCheckOutput) {
	op := &request.Operation{
		Name:       opDeleteHealthCheck,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &DeleteHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteHealthCheckOutput{}
	req.Data = output
	return
}

// This action deletes a health check. To delete a health check, send a DELETE
// request to the 2013-04-01/healthcheck/health check ID resource.
//
//  You can delete a health check only if there are no resource record sets
// associated with this health check. If resource record sets are associated
// with this health check, you must disassociate them before you can delete
// your health check. If you try to delete a health check that is associated
// with resource record sets, Route 53 will deny your request with a HealthCheckInUse
// error. For information about disassociating the records from your health
// check, see ChangeResourceRecordSets.
func (c *Route53) DeleteHealthCheck(input *DeleteHealthCheckInput) (*DeleteHealthCheckOutput, error) {
	req, out := c.DeleteHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteHostedZone = "DeleteHostedZone"

// DeleteHostedZoneRequest generates a request for the DeleteHostedZone operation.
func (c *Route53) DeleteHostedZoneRequest(input *DeleteHostedZoneInput) (req *request.Request, output *DeleteHostedZoneOutput) {
	op := &request.Operation{
		Name:       opDeleteHostedZone,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &DeleteHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteHostedZoneOutput{}
	req.Data = output
	return
}

// This action deletes a hosted zone. To delete a hosted zone, send a DELETE
// request to the 2013-04-01/hostedzone/hosted zone ID resource.
//
// For more information about deleting a hosted zone, see Deleting a Hosted
// Zone (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DeleteHostedZone.html)
// in the Amazon Route 53 Developer Guide.
//
//  You can delete a hosted zone only if there are no resource record sets
// other than the default SOA record and NS resource record sets. If your hosted
// zone contains other resource record sets, you must delete them before you
// can delete your hosted zone. If you try to delete a hosted zone that contains
// other resource record sets, Route 53 will deny your request with a HostedZoneNotEmpty
// error. For information about deleting records from your hosted zone, see
// ChangeResourceRecordSets.
func (c *Route53) DeleteHostedZone(input *DeleteHostedZoneInput) (*DeleteHostedZoneOutput, error) {
	req, out := c.DeleteHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteReusableDelegationSet = "DeleteReusableDelegationSet"

// DeleteReusableDelegationSetRequest generates a request for the DeleteReusableDelegationSet operation.
func (c *Route53) DeleteReusableDelegationSetRequest(input *DeleteReusableDelegationSetInput) (req *request.Request, output *DeleteReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opDeleteReusableDelegationSet,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2013-04-01/delegationset/{Id}",
	}

	if input == nil {
		input = &DeleteReusableDelegationSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteReusableDelegationSetOutput{}
	req.Data = output
	return
}

// This action deletes a reusable delegation set. To delete a reusable delegation
// set, send a DELETE request to the 2013-04-01/delegationset/delegation set
// ID resource.
//
//  You can delete a reusable delegation set only if there are no associated
// hosted zones. If your reusable delegation set contains associated hosted
// zones, you must delete them before you can delete your reusable delegation
// set. If you try to delete a reusable delegation set that contains associated
// hosted zones, Route 53 will deny your request with a DelegationSetInUse error.
func (c *Route53) DeleteReusableDelegationSet(input *DeleteReusableDelegationSetInput) (*DeleteReusableDelegationSetOutput, error) {
	req, out := c.DeleteReusableDelegationSetRequest(input)
	err := req.Send()
	return out, err
}

const opDisassociateVPCFromHostedZone = "DisassociateVPCFromHostedZone"

// DisassociateVPCFromHostedZoneRequest generates a request for the DisassociateVPCFromHostedZone operation.
func (c *Route53) DisassociateVPCFromHostedZoneRequest(input *DisassociateVPCFromHostedZoneInput) (req *request.Request, output *DisassociateVPCFromHostedZoneOutput) {
	op := &request.Operation{
		Name:       opDisassociateVPCFromHostedZone,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/disassociatevpc",
	}

	if input == nil {
		input = &DisassociateVPCFromHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisassociateVPCFromHostedZoneOutput{}
	req.Data = output
	return
}

// This action disassociates a VPC from an hosted zone.
//
//  To disassociate a VPC to a hosted zone, send a POST request to the 2013-04-01/hostedzone/hosted
// zone ID/disassociatevpc resource. The request body must include an XML document
// with a DisassociateVPCFromHostedZoneRequest element. The response returns
// the DisassociateVPCFromHostedZoneResponse element that contains ChangeInfo
// for you to track the progress of the DisassociateVPCFromHostedZoneRequest
// you made. See GetChange operation for how to track the progress of your change.
func (c *Route53) DisassociateVPCFromHostedZone(input *DisassociateVPCFromHostedZoneInput) (*DisassociateVPCFromHostedZoneOutput, error) {
	req, out := c.DisassociateVPCFromHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opGetChange = "GetChange"

// GetChangeRequest generates a request for the GetChange operation.
func (c *Route53) GetChangeRequest(input *GetChangeInput) (req *request.Request, output *GetChangeOutput) {
	op := &request.Operation{
		Name:       opGetChange,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/change/{Id}",
	}

	if input == nil {
		input = &GetChangeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetChangeOutput{}
	req.Data = output
	return
}

// This action returns the current status of a change batch request. The status
// is one of the following values:
//
// - PENDING indicates that the changes in this request have not replicated
// to all Route 53 DNS servers. This is the initial status of all change batch
// requests.
//
// - INSYNC indicates that the changes have replicated to all Amazon Route
// 53 DNS servers.
func (c *Route53) GetChange(input *GetChangeInput) (*GetChangeOutput, error) {
	req, out := c.GetChangeRequest(input)
	err := req.Send()
	return out, err
}

const opGetCheckerIpRanges = "GetCheckerIpRanges"

// GetCheckerIpRangesRequest generates a request for the GetCheckerIpRanges operation.
func (c *Route53) GetCheckerIpRangesRequest(input *GetCheckerIpRangesInput) (req *request.Request, output *GetCheckerIpRangesOutput) {
	op := &request.Operation{
		Name:       opGetCheckerIpRanges,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/checkeripranges",
	}

	if input == nil {
		input = &GetCheckerIpRangesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetCheckerIpRangesOutput{}
	req.Data = output
	return
}

// To retrieve a list of the IP ranges used by Amazon Route 53 health checkers
// to check the health of your resources, send a GET request to the 2013-04-01/checkeripranges
// resource. You can use these IP addresses to configure router and firewall
// rules to allow health checkers to check the health of your resources.
func (c *Route53) GetCheckerIpRanges(input *GetCheckerIpRangesInput) (*GetCheckerIpRangesOutput, error) {
	req, out := c.GetCheckerIpRangesRequest(input)
	err := req.Send()
	return out, err
}

const opGetGeoLocation = "GetGeoLocation"

// GetGeoLocationRequest generates a request for the GetGeoLocation operation.
func (c *Route53) GetGeoLocationRequest(input *GetGeoLocationInput) (req *request.Request, output *GetGeoLocationOutput) {
	op := &request.Operation{
		Name:       opGetGeoLocation,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/geolocation",
	}

	if input == nil {
		input = &GetGeoLocationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetGeoLocationOutput{}
	req.Data = output
	return
}

// To retrieve a single geo location, send a GET request to the 2013-04-01/geolocation
// resource with one of these options: continentcode | countrycode | countrycode
// and subdivisioncode.
func (c *Route53) GetGeoLocation(input *GetGeoLocationInput) (*GetGeoLocationOutput, error) {
	req, out := c.GetGeoLocationRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheck = "GetHealthCheck"

// GetHealthCheckRequest generates a request for the GetHealthCheck operation.
func (c *Route53) GetHealthCheckRequest(input *GetHealthCheckInput) (req *request.Request, output *GetHealthCheckOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheck,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &GetHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckOutput{}
	req.Data = output
	return
}

// To retrieve the health check, send a GET request to the 2013-04-01/healthcheck/health
// check ID resource.
func (c *Route53) GetHealthCheck(input *GetHealthCheckInput) (*GetHealthCheckOutput, error) {
	req, out := c.GetHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheckCount = "GetHealthCheckCount"

// GetHealthCheckCountRequest generates a request for the GetHealthCheckCount operation.
func (c *Route53) GetHealthCheckCountRequest(input *GetHealthCheckCountInput) (req *request.Request, output *GetHealthCheckCountOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheckcount",
	}

	if input == nil {
		input = &GetHealthCheckCountInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckCountOutput{}
	req.Data = output
	return
}

// To retrieve a count of all your health checks, send a GET request to the
// 2013-04-01/healthcheckcount resource.
func (c *Route53) GetHealthCheckCount(input *GetHealthCheckCountInput) (*GetHealthCheckCountOutput, error) {
	req, out := c.GetHealthCheckCountRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheckLastFailureReason = "GetHealthCheckLastFailureReason"

// GetHealthCheckLastFailureReasonRequest generates a request for the GetHealthCheckLastFailureReason operation.
func (c *Route53) GetHealthCheckLastFailureReasonRequest(input *GetHealthCheckLastFailureReasonInput) (req *request.Request, output *GetHealthCheckLastFailureReasonOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckLastFailureReason,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}/lastfailurereason",
	}

	if input == nil {
		input = &GetHealthCheckLastFailureReasonInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckLastFailureReasonOutput{}
	req.Data = output
	return
}

// If you want to learn why a health check is currently failing or why it failed
// most recently (if at all), you can get the failure reason for the most recent
// failure. Send a GET request to the 2013-04-01/healthcheck/health check ID/lastfailurereason
// resource.
func (c *Route53) GetHealthCheckLastFailureReason(input *GetHealthCheckLastFailureReasonInput) (*GetHealthCheckLastFailureReasonOutput, error) {
	req, out := c.GetHealthCheckLastFailureReasonRequest(input)
	err := req.Send()
	return out, err
}

const opGetHealthCheckStatus = "GetHealthCheckStatus"

// GetHealthCheckStatusRequest generates a request for the GetHealthCheckStatus operation.
func (c *Route53) GetHealthCheckStatusRequest(input *GetHealthCheckStatusInput) (req *request.Request, output *GetHealthCheckStatusOutput) {
	op := &request.Operation{
		Name:       opGetHealthCheckStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}/status",
	}

	if input == nil {
		input = &GetHealthCheckStatusInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHealthCheckStatusOutput{}
	req.Data = output
	return
}

// To retrieve the health check status, send a GET request to the 2013-04-01/healthcheck/health
// check ID/status resource. You can use this call to get a health check's current
// status.
func (c *Route53) GetHealthCheckStatus(input *GetHealthCheckStatusInput) (*GetHealthCheckStatusOutput, error) {
	req, out := c.GetHealthCheckStatusRequest(input)
	err := req.Send()
	return out, err
}

const opGetHostedZone = "GetHostedZone"

// GetHostedZoneRequest generates a request for the GetHostedZone operation.
func (c *Route53) GetHostedZoneRequest(input *GetHostedZoneInput) (req *request.Request, output *GetHostedZoneOutput) {
	op := &request.Operation{
		Name:       opGetHostedZone,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &GetHostedZoneInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHostedZoneOutput{}
	req.Data = output
	return
}

// To retrieve the delegation set for a hosted zone, send a GET request to the
// 2013-04-01/hostedzone/hosted zone ID resource. The delegation set is the
// four Route 53 name servers that were assigned to the hosted zone when you
// created it.
func (c *Route53) GetHostedZone(input *GetHostedZoneInput) (*GetHostedZoneOutput, error) {
	req, out := c.GetHostedZoneRequest(input)
	err := req.Send()
	return out, err
}

const opGetHostedZoneCount = "GetHostedZoneCount"

// GetHostedZoneCountRequest generates a request for the GetHostedZoneCount operation.
func (c *Route53) GetHostedZoneCountRequest(input *GetHostedZoneCountInput) (req *request.Request, output *GetHostedZoneCountOutput) {
	op := &request.Operation{
		Name:       opGetHostedZoneCount,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonecount",
	}

	if input == nil {
		input = &GetHostedZoneCountInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetHostedZoneCountOutput{}
	req.Data = output
	return
}

// To retrieve a count of all your hosted zones, send a GET request to the 2013-04-01/hostedzonecount
// resource.
func (c *Route53) GetHostedZoneCount(input *GetHostedZoneCountInput) (*GetHostedZoneCountOutput, error) {
	req, out := c.GetHostedZoneCountRequest(input)
	err := req.Send()
	return out, err
}

const opGetReusableDelegationSet = "GetReusableDelegationSet"

// GetReusableDelegationSetRequest generates a request for the GetReusableDelegationSet operation.
func (c *Route53) GetReusableDelegationSetRequest(input *GetReusableDelegationSetInput) (req *request.Request, output *GetReusableDelegationSetOutput) {
	op := &request.Operation{
		Name:       opGetReusableDelegationSet,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/delegationset/{Id}",
	}

	if input == nil {
		input = &GetReusableDelegationSetInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetReusableDelegationSetOutput{}
	req.Data = output
	return
}

// To retrieve the reusable delegation set, send a GET request to the 2013-04-01/delegationset/delegation
// set ID resource.
func (c *Route53) GetReusableDelegationSet(input *GetReusableDelegationSetInput) (*GetReusableDelegationSetOutput, error) {
	req, out := c.GetReusableDelegationSetRequest(input)
	err := req.Send()
	return out, err
}

const opListGeoLocations = "ListGeoLocations"

// ListGeoLocationsRequest generates a request for the ListGeoLocations operation.
func (c *Route53) ListGeoLocationsRequest(input *ListGeoLocationsInput) (req *request.Request, output *ListGeoLocationsOutput) {
	op := &request.Operation{
		Name:       opListGeoLocations,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/geolocations",
	}

	if input == nil {
		input = &ListGeoLocationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListGeoLocationsOutput{}
	req.Data = output
	return
}

// To retrieve a list of supported geo locations, send a GET request to the
// 2013-04-01/geolocations resource. The response to this request includes a
// GeoLocationDetailsList element with zero, one, or multiple GeoLocationDetails
// child elements. The list is sorted by country code, and then subdivision
// code, followed by continents at the end of the list.
//
//  By default, the list of geo locations is displayed on a single page. You
// can control the length of the page that is displayed by using the MaxItems
// parameter. If the list is truncated, IsTruncated will be set to true and
// a combination of NextContinentCode, NextCountryCode, NextSubdivisionCode
// will be populated. You can pass these as parameters to StartContinentCode,
// StartCountryCode, StartSubdivisionCode to control the geo location that the
// list begins with.
func (c *Route53) ListGeoLocations(input *ListGeoLocationsInput) (*ListGeoLocationsOutput, error) {
	req, out := c.ListGeoLocationsRequest(input)
	err := req.Send()
	return out, err
}

const opListHealthChecks = "ListHealthChecks"

// ListHealthChecksRequest generates a request for the ListHealthChecks operation.
func (c *Route53) ListHealthChecksRequest(input *ListHealthChecksInput) (req *request.Request, output *ListHealthChecksOutput) {
	op := &request.Operation{
		Name:       opListHealthChecks,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/healthcheck",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListHealthChecksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHealthChecksOutput{}
	req.Data = output
	return
}

// To retrieve a list of your health checks, send a GET request to the 2013-04-01/healthcheck
// resource. The response to this request includes a HealthChecks element with
// zero, one, or multiple HealthCheck child elements. By default, the list of
// health checks is displayed on a single page. You can control the length of
// the page that is displayed by using the MaxItems parameter. You can use the
// Marker parameter to control the health check that the list begins with.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
func (c *Route53) ListHealthChecks(input *ListHealthChecksInput) (*ListHealthChecksOutput, error) {
	req, out := c.ListHealthChecksRequest(input)
	err := req.Send()
	return out, err
}

func (c *Route53) ListHealthChecksPages(input *ListHealthChecksInput, fn func(p *ListHealthChecksOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListHealthChecksRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListHealthChecksOutput), lastPage)
	})
}

const opListHostedZones = "ListHostedZones"

// ListHostedZonesRequest generates a request for the ListHostedZones operation.
func (c *Route53) ListHostedZonesRequest(input *ListHostedZonesInput) (req *request.Request, output *ListHostedZonesOutput) {
	op := &request.Operation{
		Name:       opListHostedZones,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListHostedZonesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHostedZonesOutput{}
	req.Data = output
	return
}

// To retrieve a list of your hosted zones, send a GET request to the 2013-04-01/hostedzone
// resource. The response to this request includes a HostedZones element with
// zero, one, or multiple HostedZone child elements. By default, the list of
// hosted zones is displayed on a single page. You can control the length of
// the page that is displayed by using the MaxItems parameter. You can use the
// Marker parameter to control the hosted zone that the list begins with.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
func (c *Route53) ListHostedZones(input *ListHostedZonesInput) (*ListHostedZonesOutput, error) {
	req, out := c.ListHostedZonesRequest(input)
	err := req.Send()
	return out, err
}

func (c *Route53) ListHostedZonesPages(input *ListHostedZonesInput, fn func(p *ListHostedZonesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListHostedZonesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListHostedZonesOutput), lastPage)
	})
}

const opListHostedZonesByName = "ListHostedZonesByName"

// ListHostedZonesByNameRequest generates a request for the ListHostedZonesByName operation.
func (c *Route53) ListHostedZonesByNameRequest(input *ListHostedZonesByNameInput) (req *request.Request, output *ListHostedZonesByNameOutput) {
	op := &request.Operation{
		Name:       opListHostedZonesByName,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzonesbyname",
	}

	if input == nil {
		input = &ListHostedZonesByNameInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListHostedZonesByNameOutput{}
	req.Data = output
	return
}

// To retrieve a list of your hosted zones in lexicographic order, send a GET
// request to the 2013-04-01/hostedzonesbyname resource. The response to this
// request includes a HostedZones element with zero or more HostedZone child
// elements lexicographically ordered by DNS name. By default, the list of hosted
// zones is displayed on a single page. You can control the length of the page
// that is displayed by using the MaxItems parameter. You can use the DNSName
// and HostedZoneId parameters to control the hosted zone that the list begins
// with.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
func (c *Route53) ListHostedZonesByName(input *ListHostedZonesByNameInput) (*ListHostedZonesByNameOutput, error) {
	req, out := c.ListHostedZonesByNameRequest(input)
	err := req.Send()
	return out, err
}

const opListResourceRecordSets = "ListResourceRecordSets"

// ListResourceRecordSetsRequest generates a request for the ListResourceRecordSets operation.
func (c *Route53) ListResourceRecordSetsRequest(input *ListResourceRecordSetsInput) (req *request.Request, output *ListResourceRecordSetsOutput) {
	op := &request.Operation{
		Name:       opListResourceRecordSets,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}/rrset",
		Paginator: &request.Paginator{
			InputTokens:     []string{"StartRecordName", "StartRecordType", "StartRecordIdentifier"},
			OutputTokens:    []string{"NextRecordName", "NextRecordType", "NextRecordIdentifier"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListResourceRecordSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListResourceRecordSetsOutput{}
	req.Data = output
	return
}

// Imagine all the resource record sets in a zone listed out in front of you.
// Imagine them sorted lexicographically first by DNS name (with the labels
// reversed, like "com.amazon.www" for example), and secondarily, lexicographically
// by record type. This operation retrieves at most MaxItems resource record
// sets from this list, in order, starting at a position specified by the Name
// and Type arguments:
//
//  If both Name and Type are omitted, this means start the results at the
// first RRSET in the HostedZone. If Name is specified but Type is omitted,
// this means start the results at the first RRSET in the list whose name is
// greater than or equal to Name.  If both Name and Type are specified, this
// means start the results at the first RRSET in the list whose name is greater
// than or equal to Name and whose type is greater than or equal to Type. It
// is an error to specify the Type but not the Name.  Use ListResourceRecordSets
// to retrieve a single known record set by specifying the record set's name
// and type, and setting MaxItems = 1
//
// To retrieve all the records in a HostedZone, first pause any processes making
// calls to ChangeResourceRecordSets. Initially call ListResourceRecordSets
// without a Name and Type to get the first page of record sets. For subsequent
// calls, set Name and Type to the NextName and NextType values returned by
// the previous response.
//
// In the presence of concurrent ChangeResourceRecordSets calls, there is no
// consistency of results across calls to ListResourceRecordSets. The only way
// to get a consistent multi-page snapshot of all RRSETs in a zone is to stop
// making changes while pagination is in progress.
//
// However, the results from ListResourceRecordSets are consistent within a
// page. If MakeChange calls are taking place concurrently, the result of each
// one will either be completely visible in your results or not at all. You
// will not see partial changes, or changes that do not ultimately succeed.
// (This follows from the fact that MakeChange is atomic)
//
// The results from ListResourceRecordSets are strongly consistent with ChangeResourceRecordSets.
// To be precise, if a single process makes a call to ChangeResourceRecordSets
// and receives a successful response, the effects of that change will be visible
// in a subsequent call to ListResourceRecordSets by that process.
func (c *Route53) ListResourceRecordSets(input *ListResourceRecordSetsInput) (*ListResourceRecordSetsOutput, error) {
	req, out := c.ListResourceRecordSetsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Route53) ListResourceRecordSetsPages(input *ListResourceRecordSetsInput, fn func(p *ListResourceRecordSetsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListResourceRecordSetsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListResourceRecordSetsOutput), lastPage)
	})
}

const opListReusableDelegationSets = "ListReusableDelegationSets"

// ListReusableDelegationSetsRequest generates a request for the ListReusableDelegationSets operation.
func (c *Route53) ListReusableDelegationSetsRequest(input *ListReusableDelegationSetsInput) (req *request.Request, output *ListReusableDelegationSetsOutput) {
	op := &request.Operation{
		Name:       opListReusableDelegationSets,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/delegationset",
	}

	if input == nil {
		input = &ListReusableDelegationSetsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListReusableDelegationSetsOutput{}
	req.Data = output
	return
}

// To retrieve a list of your reusable delegation sets, send a GET request to
// the 2013-04-01/delegationset resource. The response to this request includes
// a DelegationSets element with zero, one, or multiple DelegationSet child
// elements. By default, the list of delegation sets is displayed on a single
// page. You can control the length of the page that is displayed by using the
// MaxItems parameter. You can use the Marker parameter to control the delegation
// set that the list begins with.
//
//  Amazon Route 53 returns a maximum of 100 items. If you set MaxItems to
// a value greater than 100, Amazon Route 53 returns only the first 100.
func (c *Route53) ListReusableDelegationSets(input *ListReusableDelegationSetsInput) (*ListReusableDelegationSetsOutput, error) {
	req, out := c.ListReusableDelegationSetsRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a request for the ListTagsForResource operation.
func (c *Route53) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}/{ResourceId}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourceOutput{}
	req.Data = output
	return
}

func (c *Route53) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	err := req.Send()
	return out, err
}

const opListTagsForResources = "ListTagsForResources"

// ListTagsForResourcesRequest generates a request for the ListTagsForResources operation.
func (c *Route53) ListTagsForResourcesRequest(input *ListTagsForResourcesInput) (req *request.Request, output *ListTagsForResourcesOutput) {
	op := &request.Operation{
		Name:       opListTagsForResources,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/tags/{ResourceType}",
	}

	if input == nil {
		input = &ListTagsForResourcesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForResourcesOutput{}
	req.Data = output
	return
}

func (c *Route53) ListTagsForResources(input *ListTagsForResourcesInput) (*ListTagsForResourcesOutput, error) {
	req, out := c.ListTagsForResourcesRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateHealthCheck = "UpdateHealthCheck"

// UpdateHealthCheckRequest generates a request for the UpdateHealthCheck operation.
func (c *Route53) UpdateHealthCheckRequest(input *UpdateHealthCheckInput) (req *request.Request, output *UpdateHealthCheckOutput) {
	op := &request.Operation{
		Name:       opUpdateHealthCheck,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/healthcheck/{HealthCheckId}",
	}

	if input == nil {
		input = &UpdateHealthCheckInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateHealthCheckOutput{}
	req.Data = output
	return
}

// This action updates an existing health check.
//
//  To update a health check, send a POST request to the 2013-04-01/healthcheck/health
// check ID resource. The request body must include an XML document with an
// UpdateHealthCheckRequest element. The response returns an UpdateHealthCheckResponse
// element, which contains metadata about the health check.
func (c *Route53) UpdateHealthCheck(input *UpdateHealthCheckInput) (*UpdateHealthCheckOutput, error) {
	req, out := c.UpdateHealthCheckRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateHostedZoneComment = "UpdateHostedZoneComment"

// UpdateHostedZoneCommentRequest generates a request for the UpdateHostedZoneComment operation.
func (c *Route53) UpdateHostedZoneCommentRequest(input *UpdateHostedZoneCommentInput) (req *request.Request, output *UpdateHostedZoneCommentOutput) {
	op := &request.Operation{
		Name:       opUpdateHostedZoneComment,
		HTTPMethod: "POST",
		HTTPPath:   "/2013-04-01/hostedzone/{Id}",
	}

	if input == nil {
		input = &UpdateHostedZoneCommentInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateHostedZoneCommentOutput{}
	req.Data = output
	return
}

// To update the hosted zone comment, send a POST request to the 2013-04-01/hostedzone/hosted
// zone ID resource. The request body must include an XML document with a UpdateHostedZoneCommentRequest
// element. The response to this request includes the modified HostedZone element.
//
//  The comment can have a maximum length of 256 characters.
func (c *Route53) UpdateHostedZoneComment(input *UpdateHostedZoneCommentInput) (*UpdateHostedZoneCommentOutput, error) {
	req, out := c.UpdateHostedZoneCommentRequest(input)
	err := req.Send()
	return out, err
}

// Alias resource record sets only: Information about the domain to which you
// are redirecting traffic.
//
// For more information and an example, see Creating Alias Resource Record
// Sets (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/CreatingAliasRRSets.html)
// in the Amazon Route 53 Developer Guide
//
// .
type AliasTarget struct {
	// Alias resource record sets only: The external DNS name associated with the
	// AWS Resource.
	//
	// For more information and an example, see Creating Alias Resource Record
	// Sets (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/CreatingAliasRRSets.html)
	// in the Amazon Route 53 Developer Guide
	//
	// .
	DNSName *string `type:"string" required:"true"`

	// Alias resource record sets only: A boolean value that indicates whether this
	// Resource Record Set should respect the health status of any health checks
	// associated with the ALIAS target record which it is linked to.
	//
	// For more information and an example, see Creating Alias Resource Record
	// Sets (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/CreatingAliasRRSets.html)
	// in the Amazon Route 53 Developer Guide
	//
	// .
	EvaluateTargetHealth *bool `type:"boolean" required:"true"`

	// Alias resource record sets only: The value of the hosted zone ID for the
	// AWS resource.
	//
	// For more information and an example, see Creating Alias Resource Record
	// Sets (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/CreatingAliasRRSets.html)
	// in the Amazon Route 53 Developer Guide
	//
	// .
	HostedZoneId *string `type:"string" required:"true"`

	metadataAliasTarget `json:"-" xml:"-"`
}

type metadataAliasTarget struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AliasTarget) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AliasTarget) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to associate a
// VPC with an hosted zone.
type AssociateVPCWithHostedZoneInput struct {
	// Optional: Any comments you want to include about a AssociateVPCWithHostedZoneRequest.
	Comment *string `type:"string"`

	// The ID of the hosted zone you want to associate your VPC with.
	//
	// Note that you cannot associate a VPC with a hosted zone that doesn't have
	// an existing VPC association.
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The VPC that you want your hosted zone to be associated with.
	VPC *VPC `type:"structure" required:"true"`

	metadataAssociateVPCWithHostedZoneInput `json:"-" xml:"-"`
}

type metadataAssociateVPCWithHostedZoneInput struct {
	SDKShapeTraits bool `locationName:"AssociateVPCWithHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`
}

// String returns the string representation
func (s AssociateVPCWithHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVPCWithHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type containing the response information for the request.
type AssociateVPCWithHostedZoneOutput struct {
	// A complex type that contains the ID, the status, and the date and time of
	// your AssociateVPCWithHostedZoneRequest.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`

	metadataAssociateVPCWithHostedZoneOutput `json:"-" xml:"-"`
}

type metadataAssociateVPCWithHostedZoneOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AssociateVPCWithHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateVPCWithHostedZoneOutput) GoString() string {
	return s.String()
}

// A complex type that contains the information for each change in a change
// batch request.
type Change struct {
	// The action to perform.
	//
	// Valid values: CREATE | DELETE | UPSERT
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Information about the resource record set to create or delete.
	ResourceRecordSet *ResourceRecordSet `type:"structure" required:"true"`

	metadataChange `json:"-" xml:"-"`
}

type metadataChange struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Change) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Change) GoString() string {
	return s.String()
}

// A complex type that contains an optional comment and the changes that you
// want to make with a change batch request.
type ChangeBatch struct {
	// A complex type that contains one Change element for each resource record
	// set that you want to create or delete.
	Changes []*Change `locationNameList:"Change" min:"1" type:"list" required:"true"`

	// Optional: Any comments you want to include about a change batch request.
	Comment *string `type:"string"`

	metadataChangeBatch `json:"-" xml:"-"`
}

type metadataChangeBatch struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ChangeBatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeBatch) GoString() string {
	return s.String()
}

// A complex type that describes change information about changes made to your
// hosted zone.
//
// This element contains an ID that you use when performing a GetChange action
// to get detailed information about the change.
type ChangeInfo struct {
	// A complex type that describes change information about changes made to your
	// hosted zone.
	//
	// This element contains an ID that you use when performing a GetChange action
	// to get detailed information about the change.
	Comment *string `type:"string"`

	// The ID of the request. Use this ID to track when the change has completed
	// across all Amazon Route 53 DNS servers.
	Id *string `type:"string" required:"true"`

	// The current state of the request. PENDING indicates that this request has
	// not yet been applied to all Amazon Route 53 DNS servers.
	//
	// Valid Values: PENDING | INSYNC
	Status *string `type:"string" required:"true" enum:"ChangeStatus"`

	// The date and time the change was submitted, in the format YYYY-MM-DDThh:mm:ssZ,
	// as specified in the ISO 8601 standard (for example, 2009-11-19T19:37:58Z).
	// The Z after the time indicates that the time is listed in Coordinated Universal
	// Time (UTC), which is synonymous with Greenwich Mean Time in this context.
	SubmittedAt *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	metadataChangeInfo `json:"-" xml:"-"`
}

type metadataChangeInfo struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ChangeInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeInfo) GoString() string {
	return s.String()
}

// A complex type that contains a change batch.
type ChangeResourceRecordSetsInput struct {
	// A complex type that contains an optional comment and the Changes element.
	ChangeBatch *ChangeBatch `type:"structure" required:"true"`

	// The ID of the hosted zone that contains the resource record sets that you
	// want to change.
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	metadataChangeResourceRecordSetsInput `json:"-" xml:"-"`
}

type metadataChangeResourceRecordSetsInput struct {
	SDKShapeTraits bool `locationName:"ChangeResourceRecordSetsRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`
}

// String returns the string representation
func (s ChangeResourceRecordSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeResourceRecordSetsInput) GoString() string {
	return s.String()
}

// A complex type containing the response for the request.
type ChangeResourceRecordSetsOutput struct {
	// A complex type that contains information about changes made to your hosted
	// zone.
	//
	// This element contains an ID that you use when performing a GetChange action
	// to get detailed information about the change.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`

	metadataChangeResourceRecordSetsOutput `json:"-" xml:"-"`
}

type metadataChangeResourceRecordSetsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ChangeResourceRecordSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeResourceRecordSetsOutput) GoString() string {
	return s.String()
}

// A complex type containing information about a request to add, change, or
// delete the tags that are associated with a resource.
type ChangeTagsForResourceInput struct {
	// A complex type that contains a list of Tag elements. Each Tag element identifies
	// a tag that you want to add or update for the specified resource.
	AddTags []*Tag `locationNameList:"Tag" min:"1" type:"list"`

	// A list of Tag keys that you want to remove from the specified resource.
	RemoveTagKeys []*string `locationNameList:"Key" min:"1" type:"list"`

	// The ID of the resource for which you want to add, change, or delete tags.
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	// - The resource type for health checks is healthcheck.
	//
	// - The resource type for hosted zones is hostedzone.
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`

	metadataChangeTagsForResourceInput `json:"-" xml:"-"`
}

type metadataChangeTagsForResourceInput struct {
	SDKShapeTraits bool `locationName:"ChangeTagsForResourceRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`
}

// String returns the string representation
func (s ChangeTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeTagsForResourceInput) GoString() string {
	return s.String()
}

// Empty response for the request.
type ChangeTagsForResourceOutput struct {
	metadataChangeTagsForResourceOutput `json:"-" xml:"-"`
}

type metadataChangeTagsForResourceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ChangeTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ChangeTagsForResourceOutput) GoString() string {
	return s.String()
}

// >A complex type that contains information about the request to create a health
// check.
type CreateHealthCheckInput struct {
	// A unique string that identifies the request and that allows failed CreateHealthCheck
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CallerReference string every time you create a health
	// check. CallerReference can be any unique string; you might choose to use
	// a string that identifies your project.
	//
	// Valid characters are any Unicode code points that are legal in an XML 1.0
	// document. The UTF-8 encoding of the value must be less than 128 bytes.
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains health check configuration.
	HealthCheckConfig *HealthCheckConfig `type:"structure" required:"true"`

	metadataCreateHealthCheckInput `json:"-" xml:"-"`
}

type metadataCreateHealthCheckInput struct {
	SDKShapeTraits bool `locationName:"CreateHealthCheckRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`
}

// String returns the string representation
func (s CreateHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHealthCheckInput) GoString() string {
	return s.String()
}

// A complex type containing the response information for the new health check.
type CreateHealthCheckOutput struct {
	// A complex type that contains identifying information about the health check.
	HealthCheck *HealthCheck `type:"structure" required:"true"`

	// The unique URL representing the new health check.
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	metadataCreateHealthCheckOutput `json:"-" xml:"-"`
}

type metadataCreateHealthCheckOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to create a hosted
// zone.
type CreateHostedZoneInput struct {
	// A unique string that identifies the request and that allows failed CreateHostedZone
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CallerReference string every time you create a hosted
	// zone. CallerReference can be any unique string; you might choose to use a
	// string that identifies your project, such as DNSMigration_01.
	//
	// Valid characters are any Unicode code points that are legal in an XML 1.0
	// document. The UTF-8 encoding of the value must be less than 128 bytes.
	CallerReference *string `min:"1" type:"string" required:"true"`

	// The delegation set id of the reusable delgation set whose NS records you
	// want to assign to the new hosted zone.
	DelegationSetId *string `type:"string"`

	// A complex type that contains an optional comment about your hosted zone.
	HostedZoneConfig *HostedZoneConfig `type:"structure"`

	// The name of the domain. This must be a fully-specified domain, for example,
	// www.example.com. The trailing dot is optional; Route 53 assumes that the
	// domain name is fully qualified. This means that Route 53 treats www.example.com
	// (without a trailing dot) and www.example.com. (with a trailing dot) as identical.
	//
	// This is the name you have registered with your DNS registrar. You should
	// ask your registrar to change the authoritative name servers for your domain
	// to the set of NameServers elements returned in DelegationSet.
	Name *string `type:"string" required:"true"`

	// The VPC that you want your hosted zone to be associated with. By providing
	// this parameter, your newly created hosted cannot be resolved anywhere other
	// than the given VPC.
	VPC *VPC `type:"structure"`

	metadataCreateHostedZoneInput `json:"-" xml:"-"`
}

type metadataCreateHostedZoneInput struct {
	SDKShapeTraits bool `locationName:"CreateHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`
}

// String returns the string representation
func (s CreateHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type containing the response information for the new hosted zone.
type CreateHostedZoneOutput struct {
	// A complex type that contains information about the request to create a hosted
	// zone. This includes an ID that you use when you call the GetChange action
	// to get the current status of the change request.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`

	// A complex type that contains name server information.
	DelegationSet *DelegationSet `type:"structure" required:"true"`

	// A complex type that contains identifying information about the hosted zone.
	HostedZone *HostedZone `type:"structure" required:"true"`

	// The unique URL representing the new hosted zone.
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	VPC *VPC `type:"structure"`

	metadataCreateHostedZoneOutput `json:"-" xml:"-"`
}

type metadataCreateHostedZoneOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateHostedZoneOutput) GoString() string {
	return s.String()
}

type CreateReusableDelegationSetInput struct {
	// A unique string that identifies the request and that allows failed CreateReusableDelegationSet
	// requests to be retried without the risk of executing the operation twice.
	// You must use a unique CallerReference string every time you create a reusable
	// delegation set. CallerReference can be any unique string; you might choose
	// to use a string that identifies your project, such as DNSMigration_01.
	//
	// Valid characters are any Unicode code points that are legal in an XML 1.0
	// document. The UTF-8 encoding of the value must be less than 128 bytes.
	CallerReference *string `min:"1" type:"string" required:"true"`

	// The ID of the hosted zone whose delegation set you want to mark as reusable.
	// It is an optional parameter.
	HostedZoneId *string `type:"string"`

	metadataCreateReusableDelegationSetInput `json:"-" xml:"-"`
}

type metadataCreateReusableDelegationSetInput struct {
	SDKShapeTraits bool `locationName:"CreateReusableDelegationSetRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`
}

// String returns the string representation
func (s CreateReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReusableDelegationSetInput) GoString() string {
	return s.String()
}

type CreateReusableDelegationSetOutput struct {
	// A complex type that contains name server information.
	DelegationSet *DelegationSet `type:"structure" required:"true"`

	// The unique URL representing the new reusbale delegation set.
	Location *string `location:"header" locationName:"Location" type:"string" required:"true"`

	metadataCreateReusableDelegationSetOutput `json:"-" xml:"-"`
}

type metadataCreateReusableDelegationSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// A complex type that contains name server information.
type DelegationSet struct {
	CallerReference *string `min:"1" type:"string"`

	Id *string `type:"string"`

	// A complex type that contains the authoritative name servers for the hosted
	// zone. Use the method provided by your domain registrar to add an NS record
	// to your domain for each NameServer that is assigned to your hosted zone.
	NameServers []*string `locationNameList:"NameServer" min:"1" type:"list" required:"true"`

	metadataDelegationSet `json:"-" xml:"-"`
}

type metadataDelegationSet struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DelegationSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DelegationSet) GoString() string {
	return s.String()
}

// A complex type containing the request information for delete health check.
type DeleteHealthCheckInput struct {
	// The ID of the health check to delete.
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`

	metadataDeleteHealthCheckInput `json:"-" xml:"-"`
}

type metadataDeleteHealthCheckInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHealthCheckInput) GoString() string {
	return s.String()
}

// Empty response for the request.
type DeleteHealthCheckOutput struct {
	metadataDeleteHealthCheckOutput `json:"-" xml:"-"`
}

type metadataDeleteHealthCheckOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the hosted zone that you want
// to delete.
type DeleteHostedZoneInput struct {
	// The ID of the hosted zone you want to delete.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	metadataDeleteHostedZoneInput `json:"-" xml:"-"`
}

type metadataDeleteHostedZoneInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type containing the response information for the request.
type DeleteHostedZoneOutput struct {
	// A complex type that contains the ID, the status, and the date and time of
	// your delete request.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`

	metadataDeleteHostedZoneOutput `json:"-" xml:"-"`
}

type metadataDeleteHostedZoneOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteHostedZoneOutput) GoString() string {
	return s.String()
}

// A complex type containing the information for the delete request.
type DeleteReusableDelegationSetInput struct {
	// The ID of the reusable delegation set you want to delete.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	metadataDeleteReusableDelegationSetInput `json:"-" xml:"-"`
}

type metadataDeleteReusableDelegationSetInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReusableDelegationSetInput) GoString() string {
	return s.String()
}

// Empty response for the request.
type DeleteReusableDelegationSetOutput struct {
	metadataDeleteReusableDelegationSetOutput `json:"-" xml:"-"`
}

type metadataDeleteReusableDelegationSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to disassociate
// a VPC from an hosted zone.
type DisassociateVPCFromHostedZoneInput struct {
	// Optional: Any comments you want to include about a DisassociateVPCFromHostedZoneRequest.
	Comment *string `type:"string"`

	// The ID of the hosted zone you want to disassociate your VPC from.
	//
	// Note that you cannot disassociate the last VPC from a hosted zone.
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The VPC that you want your hosted zone to be disassociated from.
	VPC *VPC `type:"structure" required:"true"`

	metadataDisassociateVPCFromHostedZoneInput `json:"-" xml:"-"`
}

type metadataDisassociateVPCFromHostedZoneInput struct {
	SDKShapeTraits bool `locationName:"DisassociateVPCFromHostedZoneRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`
}

// String returns the string representation
func (s DisassociateVPCFromHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateVPCFromHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type containing the response information for the request.
type DisassociateVPCFromHostedZoneOutput struct {
	// A complex type that contains the ID, the status, and the date and time of
	// your DisassociateVPCFromHostedZoneRequest.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`

	metadataDisassociateVPCFromHostedZoneOutput `json:"-" xml:"-"`
}

type metadataDisassociateVPCFromHostedZoneOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisassociateVPCFromHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateVPCFromHostedZoneOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about a geo location.
type GeoLocation struct {
	// The code for a continent geo location. Note: only continent locations have
	// a continent code.
	//
	// Valid values: AF | AN | AS | EU | OC | NA | SA
	//
	// Constraint: Specifying ContinentCode with either CountryCode or SubdivisionCode
	// returns an InvalidInput error.
	ContinentCode *string `min:"2" type:"string"`

	// The code for a country geo location. The default location uses '*' for the
	// country code and will match all locations that are not matched by a geo location.
	//
	// The default geo location uses a * for the country code. All other country
	// codes follow the ISO 3166 two-character code.
	CountryCode *string `min:"1" type:"string"`

	// The code for a country's subdivision (e.g., a province of Canada). A subdivision
	// code is only valid with the appropriate country code.
	//
	// Constraint: Specifying SubdivisionCode without CountryCode returns an InvalidInput
	// error.
	SubdivisionCode *string `min:"1" type:"string"`

	metadataGeoLocation `json:"-" xml:"-"`
}

type metadataGeoLocation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GeoLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoLocation) GoString() string {
	return s.String()
}

// A complex type that contains information about a GeoLocation.
type GeoLocationDetails struct {
	// The code for a continent geo location. Note: only continent locations have
	// a continent code.
	ContinentCode *string `min:"2" type:"string"`

	// The name of the continent. This element is only present if ContinentCode
	// is also present.
	ContinentName *string `min:"1" type:"string"`

	// The code for a country geo location. The default location uses '*' for the
	// country code and will match all locations that are not matched by a geo location.
	//
	// The default geo location uses a * for the country code. All other country
	// codes follow the ISO 3166 two-character code.
	CountryCode *string `min:"1" type:"string"`

	// The name of the country. This element is only present if CountryCode is also
	// present.
	CountryName *string `min:"1" type:"string"`

	// The code for a country's subdivision (e.g., a province of Canada). A subdivision
	// code is only valid with the appropriate country code.
	SubdivisionCode *string `min:"1" type:"string"`

	// The name of the subdivision. This element is only present if SubdivisionCode
	// is also present.
	SubdivisionName *string `min:"1" type:"string"`

	metadataGeoLocationDetails `json:"-" xml:"-"`
}

type metadataGeoLocationDetails struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GeoLocationDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoLocationDetails) GoString() string {
	return s.String()
}

// The input for a GetChange request.
type GetChangeInput struct {
	// The ID of the change batch request. The value that you specify here is the
	// value that ChangeResourceRecordSets returned in the Id element when you submitted
	// the request.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	metadataGetChangeInput `json:"-" xml:"-"`
}

type metadataGetChangeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetChangeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeInput) GoString() string {
	return s.String()
}

// A complex type that contains the ChangeInfo element.
type GetChangeOutput struct {
	// A complex type that contains information about the specified change batch,
	// including the change batch ID, the status of the change, and the date and
	// time of the request.
	ChangeInfo *ChangeInfo `type:"structure" required:"true"`

	metadataGetChangeOutput `json:"-" xml:"-"`
}

type metadataGetChangeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetChangeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeOutput) GoString() string {
	return s.String()
}

// Empty request.
type GetCheckerIpRangesInput struct {
	metadataGetCheckerIpRangesInput `json:"-" xml:"-"`
}

type metadataGetCheckerIpRangesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetCheckerIpRangesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCheckerIpRangesInput) GoString() string {
	return s.String()
}

// A complex type that contains the CheckerIpRanges element.
type GetCheckerIpRangesOutput struct {
	// A complex type that contains sorted list of IP ranges in CIDR format for
	// Amazon Route 53 health checkers.
	CheckerIpRanges []*string `type:"list" required:"true"`

	metadataGetCheckerIpRangesOutput `json:"-" xml:"-"`
}

type metadataGetCheckerIpRangesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetCheckerIpRangesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetCheckerIpRangesOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to get a geo location.
type GetGeoLocationInput struct {
	// The code for a continent geo location. Note: only continent locations have
	// a continent code.
	//
	// Valid values: AF | AN | AS | EU | OC | NA | SA
	//
	// Constraint: Specifying ContinentCode with either CountryCode or SubdivisionCode
	// returns an InvalidInput error.
	ContinentCode *string `location:"querystring" locationName:"continentcode" min:"2" type:"string"`

	// The code for a country geo location. The default location uses '*' for the
	// country code and will match all locations that are not matched by a geo location.
	//
	// The default geo location uses a * for the country code. All other country
	// codes follow the ISO 3166 two-character code.
	CountryCode *string `location:"querystring" locationName:"countrycode" min:"1" type:"string"`

	// The code for a country's subdivision (e.g., a province of Canada). A subdivision
	// code is only valid with the appropriate country code.
	//
	// Constraint: Specifying SubdivisionCode without CountryCode returns an InvalidInput
	// error.
	SubdivisionCode *string `location:"querystring" locationName:"subdivisioncode" min:"1" type:"string"`

	metadataGetGeoLocationInput `json:"-" xml:"-"`
}

type metadataGetGeoLocationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetGeoLocationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeoLocationInput) GoString() string {
	return s.String()
}

// A complex type containing information about the specified geo location.
type GetGeoLocationOutput struct {
	// A complex type that contains the information about the specified geo location.
	GeoLocationDetails *GeoLocationDetails `type:"structure" required:"true"`

	metadataGetGeoLocationOutput `json:"-" xml:"-"`
}

type metadataGetGeoLocationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetGeoLocationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeoLocationOutput) GoString() string {
	return s.String()
}

// To retrieve a count of all your health checks, send a GET request to the
// 2013-04-01/healthcheckcount resource.
type GetHealthCheckCountInput struct {
	metadataGetHealthCheckCountInput `json:"-" xml:"-"`
}

type metadataGetHealthCheckCountInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckCountInput) GoString() string {
	return s.String()
}

// A complex type that contains the count of health checks associated with the
// current AWS account.
type GetHealthCheckCountOutput struct {
	// The number of health checks associated with the current AWS account.
	HealthCheckCount *int64 `type:"long" required:"true"`

	metadataGetHealthCheckCountOutput `json:"-" xml:"-"`
}

type metadataGetHealthCheckCountOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckCountOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to get a health
// check.
type GetHealthCheckInput struct {
	// The ID of the health check to retrieve.
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`

	metadataGetHealthCheckInput `json:"-" xml:"-"`
}

type metadataGetHealthCheckInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to get the most
// recent failure reason for a health check.
type GetHealthCheckLastFailureReasonInput struct {
	// The ID of the health check for which you want to retrieve the reason for
	// the most recent failure.
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`

	metadataGetHealthCheckLastFailureReasonInput `json:"-" xml:"-"`
}

type metadataGetHealthCheckLastFailureReasonInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckLastFailureReasonInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckLastFailureReasonInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the most recent failure for
// the specified health check.
type GetHealthCheckLastFailureReasonOutput struct {
	// A list that contains one HealthCheckObservation element for each Route 53
	// health checker.
	HealthCheckObservations []*HealthCheckObservation `locationNameList:"HealthCheckObservation" type:"list" required:"true"`

	metadataGetHealthCheckLastFailureReasonOutput `json:"-" xml:"-"`
}

type metadataGetHealthCheckLastFailureReasonOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckLastFailureReasonOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckLastFailureReasonOutput) GoString() string {
	return s.String()
}

// A complex type containing information about the specified health check.
type GetHealthCheckOutput struct {
	// A complex type that contains the information about the specified health check.
	HealthCheck *HealthCheck `type:"structure" required:"true"`

	metadataGetHealthCheckOutput `json:"-" xml:"-"`
}

type metadataGetHealthCheckOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to get health
// check status for a health check.
type GetHealthCheckStatusInput struct {
	// The ID of the health check for which you want to retrieve the most recent
	// status.
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`

	metadataGetHealthCheckStatusInput `json:"-" xml:"-"`
}

type metadataGetHealthCheckStatusInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckStatusInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the status of the specified
// health check.
type GetHealthCheckStatusOutput struct {
	// A list that contains one HealthCheckObservation element for each Route 53
	// health checker.
	HealthCheckObservations []*HealthCheckObservation `locationNameList:"HealthCheckObservation" type:"list" required:"true"`

	metadataGetHealthCheckStatusOutput `json:"-" xml:"-"`
}

type metadataGetHealthCheckStatusOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHealthCheckStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHealthCheckStatusOutput) GoString() string {
	return s.String()
}

// To retrieve a count of all your hosted zones, send a GET request to the 2013-04-01/hostedzonecount
// resource.
type GetHostedZoneCountInput struct {
	metadataGetHostedZoneCountInput `json:"-" xml:"-"`
}

type metadataGetHostedZoneCountInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHostedZoneCountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneCountInput) GoString() string {
	return s.String()
}

// A complex type that contains the count of hosted zones associated with the
// current AWS account.
type GetHostedZoneCountOutput struct {
	// The number of hosted zones associated with the current AWS account.
	HostedZoneCount *int64 `type:"long" required:"true"`

	metadataGetHostedZoneCountOutput `json:"-" xml:"-"`
}

type metadataGetHostedZoneCountOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHostedZoneCountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneCountOutput) GoString() string {
	return s.String()
}

// The input for a GetHostedZone request.
type GetHostedZoneInput struct {
	// The ID of the hosted zone for which you want to get a list of the name servers
	// in the delegation set.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	metadataGetHostedZoneInput `json:"-" xml:"-"`
}

type metadataGetHostedZoneInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHostedZoneInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneInput) GoString() string {
	return s.String()
}

// A complex type containing information about the specified hosted zone.
type GetHostedZoneOutput struct {
	// A complex type that contains information about the name servers for the specified
	// hosted zone.
	DelegationSet *DelegationSet `type:"structure"`

	// A complex type that contains the information about the specified hosted zone.
	HostedZone *HostedZone `type:"structure" required:"true"`

	// A complex type that contains information about VPCs associated with the specified
	// hosted zone.
	VPCs []*VPC `locationNameList:"VPC" min:"1" type:"list"`

	metadataGetHostedZoneOutput `json:"-" xml:"-"`
}

type metadataGetHostedZoneOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetHostedZoneOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetHostedZoneOutput) GoString() string {
	return s.String()
}

// The input for a GetReusableDelegationSet request.
type GetReusableDelegationSetInput struct {
	// The ID of the reusable delegation set for which you want to get a list of
	// the name server.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	metadataGetReusableDelegationSetInput `json:"-" xml:"-"`
}

type metadataGetReusableDelegationSetInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetReusableDelegationSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReusableDelegationSetInput) GoString() string {
	return s.String()
}

// A complex type containing information about the specified reusable delegation
// set.
type GetReusableDelegationSetOutput struct {
	// A complex type that contains the information about the nameservers for the
	// specified delegation set ID.
	DelegationSet *DelegationSet `type:"structure" required:"true"`

	metadataGetReusableDelegationSetOutput `json:"-" xml:"-"`
}

type metadataGetReusableDelegationSetOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetReusableDelegationSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetReusableDelegationSetOutput) GoString() string {
	return s.String()
}

// A complex type that contains identifying information about the health check.
type HealthCheck struct {
	// A unique string that identifies the request to create the health check.
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains the health check configuration.
	HealthCheckConfig *HealthCheckConfig `type:"structure" required:"true"`

	// The version of the health check. You can optionally pass this value in a
	// call to UpdateHealthCheck to prevent overwriting another change to the health
	// check.
	HealthCheckVersion *int64 `min:"1" type:"long" required:"true"`

	// The ID of the specified health check.
	Id *string `type:"string" required:"true"`

	metadataHealthCheck `json:"-" xml:"-"`
}

type metadataHealthCheck struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s HealthCheck) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheck) GoString() string {
	return s.String()
}

// A complex type that contains the health check configuration.
type HealthCheckConfig struct {
	// For a specified parent health check, a list of HealthCheckId values for the
	// associated child health checks.
	ChildHealthChecks []*string `locationNameList:"ChildHealthCheck" type:"list"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa.
	//
	// Valid values are integers between 1 and 10. For more information, see "How
	// Amazon Route 53 Determines Whether an Endpoint Is Healthy" in the Amazon
	// Route 53 Developer Guide.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// Fully qualified domain name of the instance to be health checked.
	FullyQualifiedDomainName *string `type:"string"`

	// The minimum number of child health checks that must be healthy for Route
	// 53 to consider the parent health check to be healthy. Valid values are integers
	// between 0 and 256, inclusive.
	HealthThreshold *int64 `type:"integer"`

	// IP Address of the instance being checked.
	IPAddress *string `type:"string"`

	// A boolean value that indicates whether the status of health check should
	// be inverted. For example, if a health check is healthy but Inverted is True,
	// then Route 53 considers the health check to be unhealthy.
	Inverted *bool `type:"boolean"`

	// A Boolean value that indicates whether you want Route 53 to measure the latency
	// between health checkers in multiple AWS regions and your endpoint and to
	// display CloudWatch latency graphs in the Route 53 console.
	MeasureLatency *bool `type:"boolean"`

	// Port on which connection will be opened to the instance to health check.
	// For HTTP and HTTP_STR_MATCH this defaults to 80 if the port is not specified.
	// For HTTPS and HTTPS_STR_MATCH this defaults to 443 if the port is not specified.
	Port *int64 `min:"1" type:"integer"`

	// The number of seconds between the time that Route 53 gets a response from
	// your endpoint and the time that it sends the next health-check request.
	//
	// Each Route 53 health checker makes requests at this interval. Valid values
	// are 10 and 30. The default value is 30.
	RequestInterval *int64 `min:"10" type:"integer"`

	// Path to ping on the instance to check the health. Required for HTTP, HTTPS,
	// HTTP_STR_MATCH, and HTTPS_STR_MATCH health checks, HTTP request is issued
	// to the instance on the given port and path.
	ResourcePath *string `type:"string"`

	// A string to search for in the body of a health check response. Required for
	// HTTP_STR_MATCH and HTTPS_STR_MATCH health checks.
	SearchString *string `type:"string"`

	// The type of health check to be performed. Currently supported types are TCP,
	// HTTP, HTTPS, HTTP_STR_MATCH, and HTTPS_STR_MATCH.
	Type *string `type:"string" required:"true" enum:"HealthCheckType"`

	metadataHealthCheckConfig `json:"-" xml:"-"`
}

type metadataHealthCheckConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s HealthCheckConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckConfig) GoString() string {
	return s.String()
}

// A complex type that contains the IP address of a Route 53 health checker
// and the reason for the health check status.
type HealthCheckObservation struct {
	// The IP address of the Route 53 health checker that performed the health check.
	IPAddress *string `type:"string"`

	// A complex type that contains information about the health check status for
	// the current observation.
	StatusReport *StatusReport `type:"structure"`

	metadataHealthCheckObservation `json:"-" xml:"-"`
}

type metadataHealthCheckObservation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s HealthCheckObservation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HealthCheckObservation) GoString() string {
	return s.String()
}

// A complex type that contain information about the specified hosted zone.
type HostedZone struct {
	// A unique string that identifies the request to create the hosted zone.
	CallerReference *string `min:"1" type:"string" required:"true"`

	// A complex type that contains the Comment element.
	Config *HostedZoneConfig `type:"structure"`

	// The ID of the specified hosted zone.
	Id *string `type:"string" required:"true"`

	// The name of the domain. This must be a fully-specified domain, for example,
	// www.example.com. The trailing dot is optional; Route 53 assumes that the
	// domain name is fully qualified. This means that Route 53 treats www.example.com
	// (without a trailing dot) and www.example.com. (with a trailing dot) as identical.
	//
	// This is the name you have registered with your DNS registrar. You should
	// ask your registrar to change the authoritative name servers for your domain
	// to the set of NameServers elements returned in DelegationSet.
	Name *string `type:"string" required:"true"`

	// Total number of resource record sets in the hosted zone.
	ResourceRecordSetCount *int64 `type:"long"`

	metadataHostedZone `json:"-" xml:"-"`
}

type metadataHostedZone struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s HostedZone) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZone) GoString() string {
	return s.String()
}

// A complex type that contains an optional comment about your hosted zone.
// If you don't want to specify a comment, you can omit the HostedZoneConfig
// and Comment elements from the XML document.
type HostedZoneConfig struct {
	// An optional comment about your hosted zone. If you don't want to specify
	// a comment, you can omit the HostedZoneConfig and Comment elements from the
	// XML document.
	Comment *string `type:"string"`

	// A value that indicates whether this is a private hosted zone. The value is
	// returned in the response; do not specify it in the request.
	PrivateZone *bool `type:"boolean"`

	metadataHostedZoneConfig `json:"-" xml:"-"`
}

type metadataHostedZoneConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s HostedZoneConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HostedZoneConfig) GoString() string {
	return s.String()
}

// The input for a ListGeoLocations request.
type ListGeoLocationsInput struct {
	// The maximum number of geo locations you want in the response body.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// The first continent code in the lexicographic ordering of geo locations that
	// you want the ListGeoLocations request to list. For non-continent geo locations,
	// this should be null.
	//
	// Valid values: AF | AN | AS | EU | OC | NA | SA
	//
	// Constraint: Specifying ContinentCode with either CountryCode or SubdivisionCode
	// returns an InvalidInput error.
	StartContinentCode *string `location:"querystring" locationName:"startcontinentcode" min:"2" type:"string"`

	// The first country code in the lexicographic ordering of geo locations that
	// you want the ListGeoLocations request to list.
	//
	// The default geo location uses a * for the country code. All other country
	// codes follow the ISO 3166 two-character code.
	StartCountryCode *string `location:"querystring" locationName:"startcountrycode" min:"1" type:"string"`

	// The first subdivision code in the lexicographic ordering of geo locations
	// that you want the ListGeoLocations request to list.
	//
	// Constraint: Specifying SubdivisionCode without CountryCode returns an InvalidInput
	// error.
	StartSubdivisionCode *string `location:"querystring" locationName:"startsubdivisioncode" min:"1" type:"string"`

	metadataListGeoLocationsInput `json:"-" xml:"-"`
}

type metadataListGeoLocationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListGeoLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeoLocationsInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the geo locations that are
// returned by the request and information about the response.
type ListGeoLocationsOutput struct {
	// A complex type that contains information about the geo locations that are
	// returned by the request.
	GeoLocationDetailsList []*GeoLocationDetails `locationNameList:"GeoLocationDetails" type:"list" required:"true"`

	// A flag that indicates whether there are more geo locations to be listed.
	// If your results were truncated, you can make a follow-up request for the
	// next page of results by using the values included in the ListGeoLocationsResponse$NextContinentCode,
	// ListGeoLocationsResponse$NextCountryCode and ListGeoLocationsResponse$NextSubdivisionCode
	// elements.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The maximum number of records you requested. The maximum value of MaxItems
	// is 100.
	MaxItems *string `type:"string" required:"true"`

	// If the results were truncated, the continent code of the next geo location
	// in the list. This element is present only if ListGeoLocationsResponse$IsTruncated
	// is true and the next geo location to list is a continent location.
	NextContinentCode *string `min:"2" type:"string"`

	// If the results were truncated, the country code of the next geo location
	// in the list. This element is present only if ListGeoLocationsResponse$IsTruncated
	// is true and the next geo location to list is not a continent location.
	NextCountryCode *string `min:"1" type:"string"`

	// If the results were truncated, the subdivision code of the next geo location
	// in the list. This element is present only if ListGeoLocationsResponse$IsTruncated
	// is true and the next geo location has a subdivision.
	NextSubdivisionCode *string `min:"1" type:"string"`

	metadataListGeoLocationsOutput `json:"-" xml:"-"`
}

type metadataListGeoLocationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListGeoLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeoLocationsOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your health checks, send a GET request to the 2013-04-01/healthcheck
// resource. The response to this request includes a HealthChecks element with
// zero or more HealthCheck child elements. By default, the list of health checks
// is displayed on a single page. You can control the length of the page that
// is displayed by using the MaxItems parameter. You can use the Marker parameter
// to control the health check that the list begins with.
//
//  Route 53 returns a maximum of 100 items. If you set MaxItems to a value
// greater than 100, Route 53 returns only the first 100.
type ListHealthChecksInput struct {
	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Specify the maximum number of health checks to return per page of results.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	metadataListHealthChecksInput `json:"-" xml:"-"`
}

type metadataListHealthChecksInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListHealthChecksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHealthChecksInput) GoString() string {
	return s.String()
}

// A complex type that contains the response for the request.
type ListHealthChecksOutput struct {
	// A complex type that contains information about the health checks associated
	// with the current AWS account.
	HealthChecks []*HealthCheck `locationNameList:"HealthCheck" type:"list" required:"true"`

	// A flag indicating whether there are more health checks to be listed. If your
	// results were truncated, you can make a follow-up request for the next page
	// of results by using the Marker element.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `type:"string" required:"true"`

	// The maximum number of health checks to be included in the response body.
	// If the number of health checks associated with this AWS account exceeds MaxItems,
	// the value of ListHealthChecksResponse$IsTruncated in the response is true.
	// Call ListHealthChecks again and specify the value of ListHealthChecksResponse$NextMarker
	// in the ListHostedZonesRequest$Marker element to get the next page of results.
	MaxItems *string `type:"string" required:"true"`

	// Indicates where to continue listing health checks. If ListHealthChecksResponse$IsTruncated
	// is true, make another request to ListHealthChecks and include the value of
	// the NextMarker element in the Marker element to get the next page of results.
	NextMarker *string `type:"string"`

	metadataListHealthChecksOutput `json:"-" xml:"-"`
}

type metadataListHealthChecksOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListHealthChecksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHealthChecksOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your hosted zones in lexicographic order, send a GET
// request to the 2013-04-01/hostedzonesbyname resource. The response to this
// request includes a HostedZones element with zero or more HostedZone child
// elements lexicographically ordered by DNS name. By default, the list of hosted
// zones is displayed on a single page. You can control the length of the page
// that is displayed by using the MaxItems parameter. You can use the DNSName
// and HostedZoneId parameters to control the hosted zone that the list begins
// with.
//
// For more information about listing hosted zones, see Listing the Hosted
// Zones for an AWS Account (http://docs.amazonwebservices.com/Route53/latest/DeveloperGuide/ListInfoOnHostedZone.html)
// in the Amazon Route 53 Developer Guide.
type ListHostedZonesByNameInput struct {
	// The first name in the lexicographic ordering of domain names that you want
	// the ListHostedZonesByNameRequest request to list.
	//
	// If the request returned more than one page of results, submit another request
	// and specify the value of NextDNSName and NextHostedZoneId from the last response
	// in the DNSName and HostedZoneId parameters to get the next page of results.
	DNSName *string `location:"querystring" locationName:"dnsname" type:"string"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextDNSName and NextHostedZoneId from the last response
	// in the DNSName and HostedZoneId parameters to get the next page of results.
	HostedZoneId *string `location:"querystring" locationName:"hostedzoneid" type:"string"`

	// Specify the maximum number of hosted zones to return per page of results.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	metadataListHostedZonesByNameInput `json:"-" xml:"-"`
}

type metadataListHostedZonesByNameInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListHostedZonesByNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesByNameInput) GoString() string {
	return s.String()
}

// A complex type that contains the response for the request.
type ListHostedZonesByNameOutput struct {
	// The DNSName value sent in the request.
	DNSName *string `type:"string"`

	// The HostedZoneId value sent in the request.
	HostedZoneId *string `type:"string"`

	// A complex type that contains information about the hosted zones associated
	// with the current AWS account.
	HostedZones []*HostedZone `locationNameList:"HostedZone" type:"list" required:"true"`

	// A flag indicating whether there are more hosted zones to be listed. If your
	// results were truncated, you can make a follow-up request for the next page
	// of results by using the NextDNSName and NextHostedZoneId elements.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The maximum number of hosted zones to be included in the response body. If
	// the number of hosted zones associated with this AWS account exceeds MaxItems,
	// the value of ListHostedZonesByNameResponse$IsTruncated in the response is
	// true. Call ListHostedZonesByName again and specify the value of ListHostedZonesByNameResponse$NextDNSName
	// and ListHostedZonesByNameResponse$NextHostedZoneId elements respectively
	// to get the next page of results.
	MaxItems *string `type:"string" required:"true"`

	// If ListHostedZonesByNameResponse$IsTruncated is true, there are more hosted
	// zones associated with the current AWS account. To get the next page of results,
	// make another request to ListHostedZonesByName. Specify the value of ListHostedZonesByNameResponse$NextDNSName
	// in the ListHostedZonesByNameRequest$DNSName element and ListHostedZonesByNameResponse$NextHostedZoneId
	// in the ListHostedZonesByNameRequest$HostedZoneId element.
	NextDNSName *string `type:"string"`

	// If ListHostedZonesByNameResponse$IsTruncated is true, there are more hosted
	// zones associated with the current AWS account. To get the next page of results,
	// make another request to ListHostedZonesByName. Specify the value of ListHostedZonesByNameResponse$NextDNSName
	// in the ListHostedZonesByNameRequest$DNSName element and ListHostedZonesByNameResponse$NextHostedZoneId
	// in the ListHostedZonesByNameRequest$HostedZoneId element.
	NextHostedZoneId *string `type:"string"`

	metadataListHostedZonesByNameOutput `json:"-" xml:"-"`
}

type metadataListHostedZonesByNameOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListHostedZonesByNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesByNameOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your hosted zones, send a GET request to the 2013-04-01/hostedzone
// resource. The response to this request includes a HostedZones element with
// zero or more HostedZone child elements. By default, the list of hosted zones
// is displayed on a single page. You can control the length of the page that
// is displayed by using the MaxItems parameter. You can use the Marker parameter
// to control the hosted zone that the list begins with. For more information
// about listing hosted zones, see Listing the Hosted Zones for an AWS Account
// (http://docs.amazonwebservices.com/Route53/latest/DeveloperGuide/ListInfoOnHostedZone.html)
// in the Amazon Route 53 Developer Guide.
//
//  Route 53 returns a maximum of 100 items. If you set MaxItems to a value
// greater than 100, Route 53 returns only the first 100.
type ListHostedZonesInput struct {
	DelegationSetId *string `location:"querystring" locationName:"delegationsetid" type:"string"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Specify the maximum number of hosted zones to return per page of results.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	metadataListHostedZonesInput `json:"-" xml:"-"`
}

type metadataListHostedZonesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListHostedZonesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesInput) GoString() string {
	return s.String()
}

// A complex type that contains the response for the request.
type ListHostedZonesOutput struct {
	// A complex type that contains information about the hosted zones associated
	// with the current AWS account.
	HostedZones []*HostedZone `locationNameList:"HostedZone" type:"list" required:"true"`

	// A flag indicating whether there are more hosted zones to be listed. If your
	// results were truncated, you can make a follow-up request for the next page
	// of results by using the Marker element.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `type:"string" required:"true"`

	// The maximum number of hosted zones to be included in the response body. If
	// the number of hosted zones associated with this AWS account exceeds MaxItems,
	// the value of ListHostedZonesResponse$IsTruncated in the response is true.
	// Call ListHostedZones again and specify the value of ListHostedZonesResponse$NextMarker
	// in the ListHostedZonesRequest$Marker element to get the next page of results.
	MaxItems *string `type:"string" required:"true"`

	// Indicates where to continue listing hosted zones. If ListHostedZonesResponse$IsTruncated
	// is true, make another request to ListHostedZones and include the value of
	// the NextMarker element in the Marker element to get the next page of results.
	NextMarker *string `type:"string"`

	metadataListHostedZonesOutput `json:"-" xml:"-"`
}

type metadataListHostedZonesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListHostedZonesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListHostedZonesOutput) GoString() string {
	return s.String()
}

// The input for a ListResourceRecordSets request.
type ListResourceRecordSetsInput struct {
	// The ID of the hosted zone that contains the resource record sets that you
	// want to get.
	HostedZoneId *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	// The maximum number of records you want in the response body.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	// Weighted resource record sets only: If results were truncated for a given
	// DNS name and type, specify the value of ListResourceRecordSetsResponse$NextRecordIdentifier
	// from the previous response to get the next resource record set that has the
	// current DNS name and type.
	StartRecordIdentifier *string `location:"querystring" locationName:"identifier" min:"1" type:"string"`

	// The first name in the lexicographic ordering of domain names that you want
	// the ListResourceRecordSets request to list.
	StartRecordName *string `location:"querystring" locationName:"name" type:"string"`

	// The DNS type at which to begin the listing of resource record sets.
	//
	// Valid values: A | AAAA | CNAME | MX | NS | PTR | SOA | SPF | SRV | TXT
	//
	// Values for Weighted Resource Record Sets: A | AAAA | CNAME | TXT
	//
	//  Values for Regional Resource Record Sets: A | AAAA | CNAME | TXT
	//
	// Values for Alias Resource Record Sets: A | AAAA
	//
	// Constraint: Specifying type without specifying name returns an InvalidInput
	// error.
	StartRecordType *string `location:"querystring" locationName:"type" type:"string" enum:"RRType"`

	metadataListResourceRecordSetsInput `json:"-" xml:"-"`
}

type metadataListResourceRecordSetsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListResourceRecordSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceRecordSetsInput) GoString() string {
	return s.String()
}

// A complex type that contains information about the resource record sets that
// are returned by the request and information about the response.
type ListResourceRecordSetsOutput struct {
	// A flag that indicates whether there are more resource record sets to be listed.
	// If your results were truncated, you can make a follow-up request for the
	// next page of results by using the ListResourceRecordSetsResponse$NextRecordName
	// element.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// The maximum number of records you requested. The maximum value of MaxItems
	// is 100.
	MaxItems *string `type:"string" required:"true"`

	// Weighted resource record sets only: If results were truncated for a given
	// DNS name and type, the value of SetIdentifier for the next resource record
	// set that has the current DNS name and type.
	NextRecordIdentifier *string `min:"1" type:"string"`

	// If the results were truncated, the name of the next record in the list. This
	// element is present only if ListResourceRecordSetsResponse$IsTruncated is
	// true.
	NextRecordName *string `type:"string"`

	// If the results were truncated, the type of the next record in the list. This
	// element is present only if ListResourceRecordSetsResponse$IsTruncated is
	// true.
	NextRecordType *string `type:"string" enum:"RRType"`

	// A complex type that contains information about the resource record sets that
	// are returned by the request.
	ResourceRecordSets []*ResourceRecordSet `locationNameList:"ResourceRecordSet" type:"list" required:"true"`

	metadataListResourceRecordSetsOutput `json:"-" xml:"-"`
}

type metadataListResourceRecordSetsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListResourceRecordSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceRecordSetsOutput) GoString() string {
	return s.String()
}

// To retrieve a list of your reusable delegation sets, send a GET request to
// the 2013-04-01/delegationset resource. The response to this request includes
// a DelegationSets element with zero or more DelegationSet child elements.
// By default, the list of reusable delegation sets is displayed on a single
// page. You can control the length of the page that is displayed by using the
// MaxItems parameter. You can use the Marker parameter to control the delegation
// set that the list begins with.
//
//  Route 53 returns a maximum of 100 items. If you set MaxItems to a value
// greater than 100, Route 53 returns only the first 100.
type ListReusableDelegationSetsInput struct {
	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Specify the maximum number of reusable delegation sets to return per page
	// of results.
	MaxItems *string `location:"querystring" locationName:"maxitems" type:"string"`

	metadataListReusableDelegationSetsInput `json:"-" xml:"-"`
}

type metadataListReusableDelegationSetsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListReusableDelegationSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReusableDelegationSetsInput) GoString() string {
	return s.String()
}

// A complex type that contains the response for the request.
type ListReusableDelegationSetsOutput struct {
	// A complex type that contains information about the reusable delegation sets
	// associated with the current AWS account.
	DelegationSets []*DelegationSet `locationNameList:"DelegationSet" type:"list" required:"true"`

	// A flag indicating whether there are more reusable delegation sets to be listed.
	// If your results were truncated, you can make a follow-up request for the
	// next page of results by using the Marker element.
	//
	// Valid Values: true | false
	IsTruncated *bool `type:"boolean" required:"true"`

	// If the request returned more than one page of results, submit another request
	// and specify the value of NextMarker from the last response in the marker
	// parameter to get the next page of results.
	Marker *string `type:"string" required:"true"`

	// The maximum number of reusable delegation sets to be included in the response
	// body. If the number of reusable delegation sets associated with this AWS
	// account exceeds MaxItems, the value of ListReusablDelegationSetsResponse$IsTruncated
	// in the response is true. Call ListReusableDelegationSets again and specify
	// the value of ListReusableDelegationSetsResponse$NextMarker in the ListReusableDelegationSetsRequest$Marker
	// element to get the next page of results.
	MaxItems *string `type:"string" required:"true"`

	// Indicates where to continue listing reusable delegation sets. If ListReusableDelegationSetsResponse$IsTruncated
	// is true, make another request to ListReusableDelegationSets and include the
	// value of the NextMarker element in the Marker element to get the next page
	// of results.
	NextMarker *string `type:"string"`

	metadataListReusableDelegationSetsOutput `json:"-" xml:"-"`
}

type metadataListReusableDelegationSetsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListReusableDelegationSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListReusableDelegationSetsOutput) GoString() string {
	return s.String()
}

// A complex type containing information about a request for a list of the tags
// that are associated with an individual resource.
type ListTagsForResourceInput struct {
	// The ID of the resource for which you want to retrieve tags.
	ResourceId *string `location:"uri" locationName:"ResourceId" type:"string" required:"true"`

	// The type of the resource.
	//
	// - The resource type for health checks is healthcheck.
	//
	// - The resource type for hosted zones is hostedzone.
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`

	metadataListTagsForResourceInput `json:"-" xml:"-"`
}

type metadataListTagsForResourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// A complex type containing tags for the specified resource.
type ListTagsForResourceOutput struct {
	// A ResourceTagSet containing tags associated with the specified resource.
	ResourceTagSet *ResourceTagSet `type:"structure" required:"true"`

	metadataListTagsForResourceOutput `json:"-" xml:"-"`
}

type metadataListTagsForResourceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// A complex type containing information about a request for a list of the tags
// that are associated with up to 10 specified resources.
type ListTagsForResourcesInput struct {
	// A complex type that contains the ResourceId element for each resource for
	// which you want to get a list of tags.
	ResourceIds []*string `locationNameList:"ResourceId" min:"1" type:"list" required:"true"`

	// The type of the resources.
	//
	// - The resource type for health checks is healthcheck.
	//
	// - The resource type for hosted zones is hostedzone.
	ResourceType *string `location:"uri" locationName:"ResourceType" type:"string" required:"true" enum:"TagResourceType"`

	metadataListTagsForResourcesInput `json:"-" xml:"-"`
}

type metadataListTagsForResourcesInput struct {
	SDKShapeTraits bool `locationName:"ListTagsForResourcesRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`
}

// String returns the string representation
func (s ListTagsForResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourcesInput) GoString() string {
	return s.String()
}

// A complex type containing tags for the specified resources.
type ListTagsForResourcesOutput struct {
	// A list of ResourceTagSets containing tags associated with the specified resources.
	ResourceTagSets []*ResourceTagSet `locationNameList:"ResourceTagSet" type:"list" required:"true"`

	metadataListTagsForResourcesOutput `json:"-" xml:"-"`
}

type metadataListTagsForResourcesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTagsForResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourcesOutput) GoString() string {
	return s.String()
}

// A complex type that contains the value of the Value element for the current
// resource record set.
type ResourceRecord struct {
	// The value of the Value element for the current resource record set.
	Value *string `type:"string" required:"true"`

	metadataResourceRecord `json:"-" xml:"-"`
}

type metadataResourceRecord struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ResourceRecord) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceRecord) GoString() string {
	return s.String()
}

// A complex type that contains information about the current resource record
// set.
type ResourceRecordSet struct {
	// Alias resource record sets only: Information about the AWS resource to which
	// you are redirecting traffic.
	AliasTarget *AliasTarget `type:"structure"`

	// Failover resource record sets only: Among resource record sets that have
	// the same combination of DNS name and type, a value that indicates whether
	// the current resource record set is a primary or secondary resource record
	// set. A failover set may contain at most one resource record set marked as
	// primary and one resource record set marked as secondary. A resource record
	// set marked as primary will be returned if any of the following are true:
	// (1) an associated health check is passing, (2) if the resource record set
	// is an alias with the evaluate target health and at least one target resource
	// record set is healthy, (3) both the primary and secondary resource record
	// set are failing health checks or (4) there is no secondary resource record
	// set. A secondary resource record set will be returned if: (1) the primary
	// is failing a health check and either the secondary is passing a health check
	// or has no associated health check, or (2) there is no primary resource record
	// set.
	//
	// Valid values: PRIMARY | SECONDARY
	Failover *string `type:"string" enum:"ResourceRecordSetFailover"`

	// Geo location resource record sets only: Among resource record sets that have
	// the same combination of DNS name and type, a value that specifies the geo
	// location for the current resource record set.
	GeoLocation *GeoLocation `type:"structure"`

	// Health Check resource record sets only, not required for alias resource record
	// sets: An identifier that is used to identify health check associated with
	// the resource record set.
	HealthCheckId *string `type:"string"`

	// The domain name of the current resource record set.
	Name *string `type:"string" required:"true"`

	// Latency-based resource record sets only: Among resource record sets that
	// have the same combination of DNS name and type, a value that specifies the
	// AWS region for the current resource record set.
	Region *string `min:"1" type:"string" enum:"ResourceRecordSetRegion"`

	// A complex type that contains the resource records for the current resource
	// record set.
	ResourceRecords []*ResourceRecord `locationNameList:"ResourceRecord" min:"1" type:"list"`

	// Weighted, Latency, Geo, and Failover resource record sets only: An identifier
	// that differentiates among multiple resource record sets that have the same
	// combination of DNS name and type.
	SetIdentifier *string `min:"1" type:"string"`

	// The cache time to live for the current resource record set.
	TTL *int64 `type:"long"`

	// The type of the current resource record set.
	Type *string `type:"string" required:"true" enum:"RRType"`

	// Weighted resource record sets only: Among resource record sets that have
	// the same combination of DNS name and type, a value that determines what portion
	// of traffic for the current resource record set is routed to the associated
	// location.
	Weight *int64 `type:"long"`

	metadataResourceRecordSet `json:"-" xml:"-"`
}

type metadataResourceRecordSet struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ResourceRecordSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceRecordSet) GoString() string {
	return s.String()
}

// A complex type containing a resource and its associated tags.
type ResourceTagSet struct {
	// The ID for the specified resource.
	ResourceId *string `type:"string"`

	// The type of the resource.
	//
	// - The resource type for health checks is healthcheck.
	//
	// - The resource type for hosted zones is hostedzone.
	ResourceType *string `type:"string" enum:"TagResourceType"`

	// The tags associated with the specified resource.
	Tags []*Tag `locationNameList:"Tag" min:"1" type:"list"`

	metadataResourceTagSet `json:"-" xml:"-"`
}

type metadataResourceTagSet struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ResourceTagSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagSet) GoString() string {
	return s.String()
}

// A complex type that contains information about the health check status for
// the current observation.
type StatusReport struct {
	// The date and time the health check status was observed, in the format YYYY-MM-DDThh:mm:ssZ,
	// as specified in the ISO 8601 standard (for example, 2009-11-19T19:37:58Z).
	// The Z after the time indicates that the time is listed in Coordinated Universal
	// Time (UTC), which is synonymous with Greenwich Mean Time in this context.
	CheckedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The observed health check status.
	Status *string `type:"string"`

	metadataStatusReport `json:"-" xml:"-"`
}

type metadataStatusReport struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StatusReport) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusReport) GoString() string {
	return s.String()
}

// A single tag containing a key and value.
type Tag struct {
	// The key for a Tag.
	Key *string `type:"string"`

	// The value for a Tag.
	Value *string `type:"string"`

	metadataTag `json:"-" xml:"-"`
}

type metadataTag struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// >A complex type that contains information about the request to update a health
// check.
type UpdateHealthCheckInput struct {
	// For a specified parent health check, a list of HealthCheckId values for the
	// associated child health checks.
	//
	// Specify this value only if you want to change it.
	ChildHealthChecks []*string `locationNameList:"ChildHealthCheck" type:"list"`

	// The number of consecutive health checks that an endpoint must pass or fail
	// for Route 53 to change the current status of the endpoint from unhealthy
	// to healthy or vice versa.
	//
	// Valid values are integers between 1 and 10. For more information, see "How
	// Amazon Route 53 Determines Whether an Endpoint Is Healthy" in the Amazon
	// Route 53 Developer Guide.
	//
	// Specify this value only if you want to change it.
	FailureThreshold *int64 `min:"1" type:"integer"`

	// Fully qualified domain name of the instance to be health checked.
	//
	// Specify this value only if you want to change it.
	FullyQualifiedDomainName *string `type:"string"`

	// The ID of the health check to update.
	HealthCheckId *string `location:"uri" locationName:"HealthCheckId" type:"string" required:"true"`

	// Optional. When you specify a health check version, Route 53 compares this
	// value with the current value in the health check, which prevents you from
	// updating the health check when the versions don't match. Using HealthCheckVersion
	// lets you prevent overwriting another change to the health check.
	HealthCheckVersion *int64 `min:"1" type:"long"`

	// The minimum number of child health checks that must be healthy for Route
	// 53 to consider the parent health check to be healthy. Valid values are integers
	// between 0 and 256, inclusive.
	//
	// Specify this value only if you want to change it.
	HealthThreshold *int64 `type:"integer"`

	// The IP address of the resource that you want to check.
	//
	// Specify this value only if you want to change it.
	IPAddress *string `type:"string"`

	// A boolean value that indicates whether the status of health check should
	// be inverted. For example, if a health check is healthy but Inverted is True,
	// then Route 53 considers the health check to be unhealthy.
	//
	// Specify this value only if you want to change it.
	Inverted *bool `type:"boolean"`

	// The port on which you want Route 53 to open a connection to perform health
	// checks.
	//
	// Specify this value only if you want to change it.
	Port *int64 `min:"1" type:"integer"`

	// The path that you want Amazon Route 53 to request when performing health
	// checks. The path can be any value for which your endpoint will return an
	// HTTP status code of 2xx or 3xx when the endpoint is healthy, for example
	// the file /docs/route53-health-check.html.
	//
	// Specify this value only if you want to change it.
	ResourcePath *string `type:"string"`

	// If the value of Type is HTTP_STR_MATCH or HTTP_STR_MATCH, the string that
	// you want Route 53 to search for in the response body from the specified resource.
	// If the string appears in the response body, Route 53 considers the resource
	// healthy.
	//
	// Specify this value only if you want to change it.
	SearchString *string `type:"string"`

	metadataUpdateHealthCheckInput `json:"-" xml:"-"`
}

type metadataUpdateHealthCheckInput struct {
	SDKShapeTraits bool `locationName:"UpdateHealthCheckRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`
}

// String returns the string representation
func (s UpdateHealthCheckInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHealthCheckInput) GoString() string {
	return s.String()
}

type UpdateHealthCheckOutput struct {
	// A complex type that contains identifying information about the health check.
	HealthCheck *HealthCheck `type:"structure" required:"true"`

	metadataUpdateHealthCheckOutput `json:"-" xml:"-"`
}

type metadataUpdateHealthCheckOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateHealthCheckOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHealthCheckOutput) GoString() string {
	return s.String()
}

// A complex type that contains information about the request to update a hosted
// zone comment.
type UpdateHostedZoneCommentInput struct {
	// A comment about your hosted zone.
	Comment *string `type:"string"`

	// The ID of the hosted zone you want to update.
	Id *string `location:"uri" locationName:"Id" type:"string" required:"true"`

	metadataUpdateHostedZoneCommentInput `json:"-" xml:"-"`
}

type metadataUpdateHostedZoneCommentInput struct {
	SDKShapeTraits bool `locationName:"UpdateHostedZoneCommentRequest" type:"structure" xmlURI:"https://route53.amazonaws.com/doc/2013-04-01/"`
}

// String returns the string representation
func (s UpdateHostedZoneCommentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHostedZoneCommentInput) GoString() string {
	return s.String()
}

// A complex type containing information about the specified hosted zone after
// the update.
type UpdateHostedZoneCommentOutput struct {
	// A complex type that contain information about the specified hosted zone.
	HostedZone *HostedZone `type:"structure" required:"true"`

	metadataUpdateHostedZoneCommentOutput `json:"-" xml:"-"`
}

type metadataUpdateHostedZoneCommentOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateHostedZoneCommentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateHostedZoneCommentOutput) GoString() string {
	return s.String()
}

type VPC struct {
	// A VPC ID
	VPCId *string `type:"string"`

	VPCRegion *string `min:"1" type:"string" enum:"VPCRegion"`

	metadataVPC `json:"-" xml:"-"`
}

type metadataVPC struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VPC) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VPC) GoString() string {
	return s.String()
}

const (
	// @enum ChangeAction
	ChangeActionCreate = "CREATE"
	// @enum ChangeAction
	ChangeActionDelete = "DELETE"
	// @enum ChangeAction
	ChangeActionUpsert = "UPSERT"
)

const (
	// @enum ChangeStatus
	ChangeStatusPending = "PENDING"
	// @enum ChangeStatus
	ChangeStatusInsync = "INSYNC"
)

const (
	// @enum HealthCheckType
	HealthCheckTypeHttp = "HTTP"
	// @enum HealthCheckType
	HealthCheckTypeHttps = "HTTPS"
	// @enum HealthCheckType
	HealthCheckTypeHttpStrMatch = "HTTP_STR_MATCH"
	// @enum HealthCheckType
	HealthCheckTypeHttpsStrMatch = "HTTPS_STR_MATCH"
	// @enum HealthCheckType
	HealthCheckTypeTcp = "TCP"
	// @enum HealthCheckType
	HealthCheckTypeCalculated = "CALCULATED"
)

const (
	// @enum RRType
	RRTypeSoa = "SOA"
	// @enum RRType
	RRTypeA = "A"
	// @enum RRType
	RRTypeTxt = "TXT"
	// @enum RRType
	RRTypeNs = "NS"
	// @enum RRType
	RRTypeCname = "CNAME"
	// @enum RRType
	RRTypeMx = "MX"
	// @enum RRType
	RRTypePtr = "PTR"
	// @enum RRType
	RRTypeSrv = "SRV"
	// @enum RRType
	RRTypeSpf = "SPF"
	// @enum RRType
	RRTypeAaaa = "AAAA"
)

const (
	// @enum ResourceRecordSetFailover
	ResourceRecordSetFailoverPrimary = "PRIMARY"
	// @enum ResourceRecordSetFailover
	ResourceRecordSetFailoverSecondary = "SECONDARY"
)

const (
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionUsEast1 = "us-east-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionUsWest1 = "us-west-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionUsWest2 = "us-west-2"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionEuWest1 = "eu-west-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionEuCentral1 = "eu-central-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionApSoutheast1 = "ap-southeast-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionApSoutheast2 = "ap-southeast-2"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionApNortheast1 = "ap-northeast-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionSaEast1 = "sa-east-1"
	// @enum ResourceRecordSetRegion
	ResourceRecordSetRegionCnNorth1 = "cn-north-1"
)

const (
	// @enum TagResourceType
	TagResourceTypeHealthcheck = "healthcheck"
	// @enum TagResourceType
	TagResourceTypeHostedzone = "hostedzone"
)

const (
	// @enum VPCRegion
	VPCRegionUsEast1 = "us-east-1"
	// @enum VPCRegion
	VPCRegionUsWest1 = "us-west-1"
	// @enum VPCRegion
	VPCRegionUsWest2 = "us-west-2"
	// @enum VPCRegion
	VPCRegionEuWest1 = "eu-west-1"
	// @enum VPCRegion
	VPCRegionEuCentral1 = "eu-central-1"
	// @enum VPCRegion
	VPCRegionApSoutheast1 = "ap-southeast-1"
	// @enum VPCRegion
	VPCRegionApSoutheast2 = "ap-southeast-2"
	// @enum VPCRegion
	VPCRegionApNortheast1 = "ap-northeast-1"
	// @enum VPCRegion
	VPCRegionSaEast1 = "sa-east-1"
	// @enum VPCRegion
	VPCRegionCnNorth1 = "cn-north-1"
)
