// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package lambda provides a client for AWS Lambda.
package lambda

import (
	"io"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddPermission = "AddPermission"

// AddPermissionRequest generates a request for the AddPermission operation.
func (c *Lambda) AddPermissionRequest(input *AddPermissionInput) (req *request.Request, output *AddPermissionOutput) {
	op := &request.Operation{
		Name:       opAddPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions/HEAD/policy",
	}

	if input == nil {
		input = &AddPermissionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddPermissionOutput{}
	req.Data = output
	return
}

// Adds a permission to the access policy associated with the specified AWS
// Lambda function. In a "push event" model, the access policy attached to the
// Lambda function grants Amazon S3 or a user application permission for the
// Lambda lambda:Invoke action. For information about the push model, see AWS
// Lambda: How it Works (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html).
// Each Lambda function has one access policy associated with it. You can use
// the AddPermission API to add a permission to the policy. You have one access
// policy but it can have multiple permission statements.
//
// This operation requires permission for the lambda:AddPermission action.
func (c *Lambda) AddPermission(input *AddPermissionInput) (*AddPermissionOutput, error) {
	req, out := c.AddPermissionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateEventSourceMapping = "CreateEventSourceMapping"

// CreateEventSourceMappingRequest generates a request for the CreateEventSourceMapping operation.
func (c *Lambda) CreateEventSourceMappingRequest(input *CreateEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opCreateEventSourceMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
	}

	if input == nil {
		input = &CreateEventSourceMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EventSourceMappingConfiguration{}
	req.Data = output
	return
}

// Identifies a stream as an event source for a Lambda function. It can be either
// an Amazon Kinesis stream or an Amazon DynamoDB stream. AWS Lambda invokes
// the specified function when records are posted to the stream.
//
// This is the pull model, where AWS Lambda invokes the function. For more
// information, go to AWS Lambda: How it Works (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html)
// in the AWS Lambda Developer Guide.
//
// This association between an Amazon Kinesis stream and a Lambda function
// is called the event source mapping. You provide the configuration information
// (for example, which stream to read from and which Lambda function to invoke)
// for the event source mapping in the request body.
//
//  Each event source, such as an Amazon Kinesis or a DynamoDB stream, can
// be associated with multiple AWS Lambda function. A given Lambda function
// can be associated with multiple AWS event sources.
//
// This operation requires permission for the lambda:CreateEventSourceMapping
// action.
func (c *Lambda) CreateEventSourceMapping(input *CreateEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.CreateEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opCreateFunction = "CreateFunction"

// CreateFunctionRequest generates a request for the CreateFunction operation.
func (c *Lambda) CreateFunctionRequest(input *CreateFunctionInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opCreateFunction,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions",
	}

	if input == nil {
		input = &CreateFunctionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FunctionConfiguration{}
	req.Data = output
	return
}

// Creates a new Lambda function. The function metadata is created from the
// request parameters, and the code for the function is provided by a .zip file
// in the request body. If the function name already exists, the operation will
// fail. Note that the function name is case-sensitive.
//
// This operation requires permission for the lambda:CreateFunction action.
func (c *Lambda) CreateFunction(input *CreateFunctionInput) (*FunctionConfiguration, error) {
	req, out := c.CreateFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteEventSourceMapping = "DeleteEventSourceMapping"

// DeleteEventSourceMappingRequest generates a request for the DeleteEventSourceMapping operation.
func (c *Lambda) DeleteEventSourceMappingRequest(input *DeleteEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opDeleteEventSourceMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &DeleteEventSourceMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EventSourceMappingConfiguration{}
	req.Data = output
	return
}

// Removes an event source mapping. This means AWS Lambda will no longer invoke
// the function for events in the associated source.
//
// This operation requires permission for the lambda:DeleteEventSourceMapping
// action.
func (c *Lambda) DeleteEventSourceMapping(input *DeleteEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.DeleteEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteFunction = "DeleteFunction"

// DeleteFunctionRequest generates a request for the DeleteFunction operation.
func (c *Lambda) DeleteFunctionRequest(input *DeleteFunctionInput) (req *request.Request, output *DeleteFunctionOutput) {
	op := &request.Operation{
		Name:       opDeleteFunction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}",
	}

	if input == nil {
		input = &DeleteFunctionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteFunctionOutput{}
	req.Data = output
	return
}

// Deletes the specified Lambda function code and configuration.
//
// When you delete a function the associated access policy is also deleted.
// You will need to delete the event source mappings explicitly.
//
// This operation requires permission for the lambda:DeleteFunction action.
func (c *Lambda) DeleteFunction(input *DeleteFunctionInput) (*DeleteFunctionOutput, error) {
	req, out := c.DeleteFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opGetEventSourceMapping = "GetEventSourceMapping"

// GetEventSourceMappingRequest generates a request for the GetEventSourceMapping operation.
func (c *Lambda) GetEventSourceMappingRequest(input *GetEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opGetEventSourceMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &GetEventSourceMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EventSourceMappingConfiguration{}
	req.Data = output
	return
}

// Returns configuration information for the specified event source mapping
// (see CreateEventSourceMapping).
//
// This operation requires permission for the lambda:GetEventSourceMapping
// action.
func (c *Lambda) GetEventSourceMapping(input *GetEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.GetEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opGetFunction = "GetFunction"

// GetFunctionRequest generates a request for the GetFunction operation.
func (c *Lambda) GetFunctionRequest(input *GetFunctionInput) (req *request.Request, output *GetFunctionOutput) {
	op := &request.Operation{
		Name:       opGetFunction,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions/HEAD",
	}

	if input == nil {
		input = &GetFunctionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetFunctionOutput{}
	req.Data = output
	return
}

// Returns the configuration information of the Lambda function and a presigned
// URL link to the .zip file you uploaded with CreateFunction so you can download
// the .zip file. Note that the URL is valid for up to 10 minutes. The configuration
// information is the same information you provided as parameters when uploading
// the function.
//
// This operation requires permission for the lambda:GetFunction action.
func (c *Lambda) GetFunction(input *GetFunctionInput) (*GetFunctionOutput, error) {
	req, out := c.GetFunctionRequest(input)
	err := req.Send()
	return out, err
}

const opGetFunctionConfiguration = "GetFunctionConfiguration"

// GetFunctionConfigurationRequest generates a request for the GetFunctionConfiguration operation.
func (c *Lambda) GetFunctionConfigurationRequest(input *GetFunctionConfigurationInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opGetFunctionConfiguration,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions/HEAD/configuration",
	}

	if input == nil {
		input = &GetFunctionConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FunctionConfiguration{}
	req.Data = output
	return
}

// Returns the configuration information of the Lambda function. This the same
// information you provided as parameters when uploading the function by using
// CreateFunction.
//
// This operation requires permission for the lambda:GetFunctionConfiguration
// operation.
func (c *Lambda) GetFunctionConfiguration(input *GetFunctionConfigurationInput) (*FunctionConfiguration, error) {
	req, out := c.GetFunctionConfigurationRequest(input)
	err := req.Send()
	return out, err
}

const opGetPolicy = "GetPolicy"

// GetPolicyRequest generates a request for the GetPolicy operation.
func (c *Lambda) GetPolicyRequest(input *GetPolicyInput) (req *request.Request, output *GetPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions/HEAD/policy",
	}

	if input == nil {
		input = &GetPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPolicyOutput{}
	req.Data = output
	return
}

// Returns the access policy, containing a list of permissions granted via the
// AddPermission API, associated with the specified bucket.
//
// You need permission for the lambda:GetPolicy action.
func (c *Lambda) GetPolicy(input *GetPolicyInput) (*GetPolicyOutput, error) {
	req, out := c.GetPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opInvoke = "Invoke"

// InvokeRequest generates a request for the Invoke operation.
func (c *Lambda) InvokeRequest(input *InvokeInput) (req *request.Request, output *InvokeOutput) {
	op := &request.Operation{
		Name:       opInvoke,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/invocations",
	}

	if input == nil {
		input = &InvokeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &InvokeOutput{}
	req.Data = output
	return
}

// Invokes a specified Lambda function.
//
// This operation requires permission for the lambda:InvokeFunction action.
func (c *Lambda) Invoke(input *InvokeInput) (*InvokeOutput, error) {
	req, out := c.InvokeRequest(input)
	err := req.Send()
	return out, err
}

const opInvokeAsync = "InvokeAsync"

// InvokeAsyncRequest generates a request for the InvokeAsync operation.
func (c *Lambda) InvokeAsyncRequest(input *InvokeAsyncInput) (req *request.Request, output *InvokeAsyncOutput) {
	op := &request.Operation{
		Name:       opInvokeAsync,
		HTTPMethod: "POST",
		HTTPPath:   "/2014-11-13/functions/{FunctionName}/invoke-async/",
	}

	if input == nil {
		input = &InvokeAsyncInput{}
	}

	req = c.newRequest(op, input, output)
	output = &InvokeAsyncOutput{}
	req.Data = output
	return
}

// This API is deprecated. We recommend you use Invoke API (see Invoke). Submits
// an invocation request to AWS Lambda. Upon receiving the request, Lambda executes
// the specified function asynchronously. To see the logs generated by the Lambda
// function execution, see the CloudWatch logs console.
//
// This operation requires permission for the lambda:InvokeFunction action.
func (c *Lambda) InvokeAsync(input *InvokeAsyncInput) (*InvokeAsyncOutput, error) {
	req, out := c.InvokeAsyncRequest(input)
	err := req.Send()
	return out, err
}

const opListEventSourceMappings = "ListEventSourceMappings"

// ListEventSourceMappingsRequest generates a request for the ListEventSourceMappings operation.
func (c *Lambda) ListEventSourceMappingsRequest(input *ListEventSourceMappingsInput) (req *request.Request, output *ListEventSourceMappingsOutput) {
	op := &request.Operation{
		Name:       opListEventSourceMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/event-source-mappings/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEventSourceMappingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListEventSourceMappingsOutput{}
	req.Data = output
	return
}

// Returns a list of event source mappings you created using the CreateEventSourceMapping
// (see CreateEventSourceMapping), where you identify a stream as an event source.
// This list does not include Amazon S3 event sources.
//
// For each mapping, the API returns configuration information. You can optionally
// specify filters to retrieve specific event source mappings.
//
// This operation requires permission for the lambda:ListEventSourceMappings
// action.
func (c *Lambda) ListEventSourceMappings(input *ListEventSourceMappingsInput) (*ListEventSourceMappingsOutput, error) {
	req, out := c.ListEventSourceMappingsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Lambda) ListEventSourceMappingsPages(input *ListEventSourceMappingsInput, fn func(p *ListEventSourceMappingsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListEventSourceMappingsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListEventSourceMappingsOutput), lastPage)
	})
}

const opListFunctions = "ListFunctions"

// ListFunctionsRequest generates a request for the ListFunctions operation.
func (c *Lambda) ListFunctionsRequest(input *ListFunctionsInput) (req *request.Request, output *ListFunctionsOutput) {
	op := &request.Operation{
		Name:       opListFunctions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-03-31/functions/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"NextMarker"},
			LimitToken:      "MaxItems",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListFunctionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListFunctionsOutput{}
	req.Data = output
	return
}

// Returns a list of your Lambda functions. For each function, the response
// includes the function configuration information. You must use GetFunction
// to retrieve the code for your function.
//
// This operation requires permission for the lambda:ListFunctions action.
func (c *Lambda) ListFunctions(input *ListFunctionsInput) (*ListFunctionsOutput, error) {
	req, out := c.ListFunctionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Lambda) ListFunctionsPages(input *ListFunctionsInput, fn func(p *ListFunctionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListFunctionsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListFunctionsOutput), lastPage)
	})
}

const opRemovePermission = "RemovePermission"

// RemovePermissionRequest generates a request for the RemovePermission operation.
func (c *Lambda) RemovePermissionRequest(input *RemovePermissionInput) (req *request.Request, output *RemovePermissionOutput) {
	op := &request.Operation{
		Name:       opRemovePermission,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions/HEAD/policy/{StatementId}",
	}

	if input == nil {
		input = &RemovePermissionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemovePermissionOutput{}
	req.Data = output
	return
}

// You can remove individual permissions from an access policy associated with
// a Lambda function by providing a Statement ID.
//
// Note that removal of a permission will cause an active event source to lose
// permission to the function.
//
// You need permission for the lambda:RemovePermission action.
func (c *Lambda) RemovePermission(input *RemovePermissionInput) (*RemovePermissionOutput, error) {
	req, out := c.RemovePermissionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateEventSourceMapping = "UpdateEventSourceMapping"

// UpdateEventSourceMappingRequest generates a request for the UpdateEventSourceMapping operation.
func (c *Lambda) UpdateEventSourceMappingRequest(input *UpdateEventSourceMappingInput) (req *request.Request, output *EventSourceMappingConfiguration) {
	op := &request.Operation{
		Name:       opUpdateEventSourceMapping,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/event-source-mappings/{UUID}",
	}

	if input == nil {
		input = &UpdateEventSourceMappingInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EventSourceMappingConfiguration{}
	req.Data = output
	return
}

// You can update an event source mapping. This is useful if you want to change
// the parameters of the existing mapping without losing your position in the
// stream. You can change which function will receive the stream records, but
// to change the stream itself, you must create a new mapping.
//
// This operation requires permission for the lambda:UpdateEventSourceMapping
// action.
func (c *Lambda) UpdateEventSourceMapping(input *UpdateEventSourceMappingInput) (*EventSourceMappingConfiguration, error) {
	req, out := c.UpdateEventSourceMappingRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateFunctionCode = "UpdateFunctionCode"

// UpdateFunctionCodeRequest generates a request for the UpdateFunctionCode operation.
func (c *Lambda) UpdateFunctionCodeRequest(input *UpdateFunctionCodeInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opUpdateFunctionCode,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions/HEAD/code",
	}

	if input == nil {
		input = &UpdateFunctionCodeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FunctionConfiguration{}
	req.Data = output
	return
}

// Updates the code for the specified Lambda function. This operation must only
// be used on an existing Lambda function and cannot be used to update the function
// configuration.
//
// This operation requires permission for the lambda:UpdateFunctionCode action.
func (c *Lambda) UpdateFunctionCode(input *UpdateFunctionCodeInput) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionCodeRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateFunctionConfiguration = "UpdateFunctionConfiguration"

// UpdateFunctionConfigurationRequest generates a request for the UpdateFunctionConfiguration operation.
func (c *Lambda) UpdateFunctionConfigurationRequest(input *UpdateFunctionConfigurationInput) (req *request.Request, output *FunctionConfiguration) {
	op := &request.Operation{
		Name:       opUpdateFunctionConfiguration,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-03-31/functions/{FunctionName}/versions/HEAD/configuration",
	}

	if input == nil {
		input = &UpdateFunctionConfigurationInput{}
	}

	req = c.newRequest(op, input, output)
	output = &FunctionConfiguration{}
	req.Data = output
	return
}

// Updates the configuration parameters for the specified Lambda function by
// using the values provided in the request. You provide only the parameters
// you want to change. This operation must only be used on an existing Lambda
// function and cannot be used to update the function's code.
//
// This operation requires permission for the lambda:UpdateFunctionConfiguration
// action.
func (c *Lambda) UpdateFunctionConfiguration(input *UpdateFunctionConfigurationInput) (*FunctionConfiguration, error) {
	req, out := c.UpdateFunctionConfigurationRequest(input)
	err := req.Send()
	return out, err
}

type AddPermissionInput struct {
	// The AWS Lambda action you want to allow in this statement. Each Lambda action
	// is a string starting with "lambda:" followed by the API name (see Operations).
	// For example, "lambda:CreateFunction". You can use wildcard ("lambda:*") to
	// grant permission for all AWS Lambda actions.
	Action *string `type:"string" required:"true"`

	// Name of the Lambda function whose access policy you are updating by adding
	// a new permission.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The principal who is getting this permission. It can be Amazon S3 service
	// Principal ("s3.amazonaws.com") if you want Amazon S3 to invoke the function,
	// an AWS account ID if you are granting cross-account permission, or any valid
	// AWS service principal such as "sns.amazonaws.com". For example, you might
	// want to allow a custom application in another AWS account to push events
	// to AWS Lambda by invoking your function.
	Principal *string `type:"string" required:"true"`

	// The AWS account ID (without a hyphen) of the source owner. For example, if
	// the SourceArn identifies a bucket, then this is the bucket owner's account
	// ID. You can use this additional condition to ensure the bucket you specify
	// is owned by a specific account (it is possible the bucket owner deleted the
	// bucket and some other AWS account created the bucket). You can also use this
	// condition to specify all sources (that is, you don't specify the SourceArn)
	// owned by a specific account.
	SourceAccount *string `type:"string"`

	// This is optional; however, when granting Amazon S3 permission to invoke your
	// function, you should specify this field with the bucket Amazon Resource Name
	// (ARN) as its value. This ensures that only events generated from the specified
	// bucket can invoke the function.
	//
	// If you add a permission for the Amazon S3 principal without providing the
	// source ARN, any AWS account that creates a mapping to your function ARN can
	// send events to invoke your Lambda function from Amazon S3.
	SourceArn *string `type:"string"`

	// A unique statement identifier.
	StatementId *string `min:"1" type:"string" required:"true"`

	metadataAddPermissionInput `json:"-" xml:"-"`
}

type metadataAddPermissionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionInput) GoString() string {
	return s.String()
}

type AddPermissionOutput struct {
	// The permission statement you specified in the request. The response returns
	// the same as a string using "\" as an escape character in the JSON.
	Statement *string `type:"string"`

	metadataAddPermissionOutput `json:"-" xml:"-"`
}

type metadataAddPermissionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddPermissionOutput) GoString() string {
	return s.String()
}

type CreateEventSourceMappingInput struct {
	// The largest number of records that AWS Lambda will retrieve from your event
	// source at the time of invoking your function. Your function receives an event
	// with all the retrieved records. The default is 100 records.
	BatchSize *int64 `min:"1" type:"integer"`

	// Indicates whether AWS Lambda should begin polling the event source, the default
	// is not enabled.
	Enabled *bool `type:"boolean"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis or the Amazon DynamoDB
	// stream that is the event source. Any record added to this stream could cause
	// AWS Lambda to invoke your Lambda function, it depends on the BatchSize. AWS
	// Lambda POSTs the Amazon Kinesis event, containing records, to your Lambda
	// function as JSON.
	EventSourceArn *string `type:"string" required:"true"`

	// The Lambda function to invoke when AWS Lambda detects an event on the stream.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The position in the stream where AWS Lambda should start reading. For more
	// information, go to ShardIteratorType (http://docs.aws.amazon.com/kinesis/latest/APIReference/API_GetShardIterator.html#Kinesis-GetShardIterator-request-ShardIteratorType)
	// in the Amazon Kinesis API Reference.
	StartingPosition *string `type:"string" required:"true" enum:"EventSourcePosition"`

	metadataCreateEventSourceMappingInput `json:"-" xml:"-"`
}

type metadataCreateEventSourceMappingInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateEventSourceMappingInput) GoString() string {
	return s.String()
}

type CreateFunctionInput struct {
	// The code for the Lambda function.
	Code *FunctionCode `type:"structure" required:"true"`

	// A short, user-defined function description. Lambda does not use this value.
	// Assign a meaningful description as you see fit.
	Description *string `type:"string"`

	// The name you want to assign to the function you are uploading. You can specify
	// an unqualified function name (for example, "Thumbnail") or you can specify
	// Amazon Resource Name (ARN) of the function (for example, "arn:aws:lambda:us-west-2:account-id:function:ThumbNail").
	// AWS Lambda also allows you to specify only the account ID qualifier (for
	// example, "account-id:Thumbnail"). Note that the length constraint applies
	// only to the ARN. If you specify only the function name, it is limited to
	// 64 character in length. The function names appear in the console and are
	// returned in the ListFunctions API. Function names are used to specify functions
	// to other AWS Lambda APIs, such as Invoke.
	FunctionName *string `min:"1" type:"string" required:"true"`

	// The function within your code that Lambda calls to begin execution. For Node.js,
	// it is the module-name.export value in your function. For Java, it can be
	// package.class-name::handler or package.class-name. For more information,
	// see Lambda Function Handler (Java) (http://docs.aws.amazon.com/lambda/latest/dg/java-programming-model-handler-types.html).
	Handler *string `type:"string" required:"true"`

	// The amount of memory, in MB, your Lambda function is given. Lambda uses this
	// memory size to infer the amount of CPU and memory allocated to your function.
	// Your function use-case determines your CPU and memory requirements. For example,
	// a database operation might need less memory compared to an image processing
	// function. The default value is 128 MB. The value must be a multiple of 64
	// MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda assumes when it
	// executes your function to access any other Amazon Web Services (AWS) resources.
	// For more information, see AWS Lambda: How it Works (http://docs.aws.amazon.com/lambda/latest/dg/lambda-introduction.html)
	Role *string `type:"string" required:"true"`

	// The runtime environment for the Lambda function you are uploading. Currently,
	// Lambda supports "java" and "nodejs" as the runtime.
	Runtime *string `type:"string" required:"true" enum:"Runtime"`

	// The function execution time at which Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	metadataCreateFunctionInput `json:"-" xml:"-"`
}

type metadataCreateFunctionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateFunctionInput) GoString() string {
	return s.String()
}

type DeleteEventSourceMappingInput struct {
	// The event source mapping ID.
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`

	metadataDeleteEventSourceMappingInput `json:"-" xml:"-"`
}

type metadataDeleteEventSourceMappingInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteEventSourceMappingInput) GoString() string {
	return s.String()
}

type DeleteFunctionInput struct {
	// The Lambda function to delete.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	metadataDeleteFunctionInput `json:"-" xml:"-"`
}

type metadataDeleteFunctionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionInput) GoString() string {
	return s.String()
}

type DeleteFunctionOutput struct {
	metadataDeleteFunctionOutput `json:"-" xml:"-"`
}

type metadataDeleteFunctionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteFunctionOutput) GoString() string {
	return s.String()
}

// Describes mapping between an Amazon Kinesis stream and a Lambda function.
type EventSourceMappingConfiguration struct {
	// The largest number of records that AWS Lambda will retrieve from your event
	// source at the time of invoking your function. Your function receives an event
	// with all the retrieved records.
	BatchSize *int64 `min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the Amazon Kinesis stream that is the source
	// of events.
	EventSourceArn *string `type:"string"`

	// The Lambda function to invoke when AWS Lambda detects an event on the stream.
	FunctionArn *string `type:"string"`

	// The UTC time string indicating the last time the event mapping was updated.
	LastModified *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The result of the last AWS Lambda invocation of your Lambda function.
	LastProcessingResult *string `type:"string"`

	// The state of the event source mapping. It can be "Creating", "Enabled", "Disabled",
	// "Enabling", "Disabling", "Updating", or "Deleting".
	State *string `type:"string"`

	// The reason the event source mapping is in its current state. It is either
	// user-requested or an AWS Lambda-initiated state transition.
	StateTransitionReason *string `type:"string"`

	// The AWS Lambda assigned opaque identifier for the mapping.
	UUID *string `type:"string"`

	metadataEventSourceMappingConfiguration `json:"-" xml:"-"`
}

type metadataEventSourceMappingConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EventSourceMappingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EventSourceMappingConfiguration) GoString() string {
	return s.String()
}

// The code for the Lambda function.
type FunctionCode struct {
	// Amazon S3 bucket name where the .zip file containing your deployment package
	// is stored. This bucket must reside in the same AWS region where you are creating
	// the Lambda function.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 object (the deployment package) key name you want to upload.
	S3Key *string `min:"1" type:"string"`

	// The Amazon S3 object (the deployment package) version you want to upload.
	S3ObjectVersion *string `min:"1" type:"string"`

	// A base64-encoded .zip file containing your deployment package. For more information
	// about creating a .zip file, go to Execution Permissions (http://docs.aws.amazon.com/lambda/latest/dg/intro-permission-model.html#lambda-intro-execution-role.html)
	// in the AWS Lambda Developer Guide.
	ZipFile []byte `type:"blob"`

	metadataFunctionCode `json:"-" xml:"-"`
}

type metadataFunctionCode struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s FunctionCode) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCode) GoString() string {
	return s.String()
}

// The object for the Lambda function location.
type FunctionCodeLocation struct {
	// The presigned URL you can use to download the function's .zip file that you
	// previously uploaded. The URL is valid for up to 10 minutes.
	Location *string `type:"string"`

	// The repository from which you can download the function.
	RepositoryType *string `type:"string"`

	metadataFunctionCodeLocation `json:"-" xml:"-"`
}

type metadataFunctionCodeLocation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s FunctionCodeLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionCodeLocation) GoString() string {
	return s.String()
}

// A complex type that describes function metadata.
type FunctionConfiguration struct {
	// The size, in bytes, of the function .zip file you uploaded.
	CodeSize *int64 `type:"long"`

	// The user-provided description.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) assigned to the function.
	FunctionArn *string `type:"string"`

	// The name of the function.
	FunctionName *string `min:"1" type:"string"`

	// The function Lambda calls to begin executing your function.
	Handler *string `type:"string"`

	// The timestamp of the last time you updated the function.
	LastModified *string `type:"string"`

	// The memory size, in MB, you configured for the function. Must be a multiple
	// of 64 MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda assumes when it
	// executes your function to access any other Amazon Web Services (AWS) resources.
	Role *string `type:"string"`

	// The runtime environment for the Lambda function.
	Runtime *string `type:"string" enum:"Runtime"`

	// The function execution time at which Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	metadataFunctionConfiguration `json:"-" xml:"-"`
}

type metadataFunctionConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s FunctionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FunctionConfiguration) GoString() string {
	return s.String()
}

type GetEventSourceMappingInput struct {
	// The AWS Lambda assigned ID of the event source mapping.
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`

	metadataGetEventSourceMappingInput `json:"-" xml:"-"`
}

type metadataGetEventSourceMappingInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetEventSourceMappingInput) GoString() string {
	return s.String()
}

type GetFunctionConfigurationInput struct {
	// The name of the Lambda function for which you want to retrieve the configuration
	// information.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	metadataGetFunctionConfigurationInput `json:"-" xml:"-"`
}

type metadataGetFunctionConfigurationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionConfigurationInput) GoString() string {
	return s.String()
}

type GetFunctionInput struct {
	// The Lambda function name.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	metadataGetFunctionInput `json:"-" xml:"-"`
}

type metadataGetFunctionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionInput) GoString() string {
	return s.String()
}

// This response contains the object for the Lambda function location (see API_FunctionCodeLocation
type GetFunctionOutput struct {
	// The object for the Lambda function location.
	Code *FunctionCodeLocation `type:"structure"`

	// A complex type that describes function metadata.
	Configuration *FunctionConfiguration `type:"structure"`

	metadataGetFunctionOutput `json:"-" xml:"-"`
}

type metadataGetFunctionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetFunctionOutput) GoString() string {
	return s.String()
}

type GetPolicyInput struct {
	// Function name whose access policy you want to retrieve.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	metadataGetPolicyInput `json:"-" xml:"-"`
}

type metadataGetPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyInput) GoString() string {
	return s.String()
}

type GetPolicyOutput struct {
	// The access policy associated with the specified function. The response returns
	// the same as a string using "\" as an escape character in the JSON.
	Policy *string `type:"string"`

	metadataGetPolicyOutput `json:"-" xml:"-"`
}

type metadataGetPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPolicyOutput) GoString() string {
	return s.String()
}

type InvokeAsyncInput struct {
	// The Lambda function name.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// JSON that you want to provide to your Lambda function as input.
	InvokeArgs io.ReadSeeker `type:"blob" required:"true"`

	metadataInvokeAsyncInput `json:"-" xml:"-"`
}

type metadataInvokeAsyncInput struct {
	SDKShapeTraits bool `type:"structure" payload:"InvokeArgs"`
}

// String returns the string representation
func (s InvokeAsyncInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncInput) GoString() string {
	return s.String()
}

// Upon success, it returns empty response. Otherwise, throws an exception.
type InvokeAsyncOutput struct {
	// It will be 202 upon success.
	Status *int64 `location:"statusCode" type:"integer"`

	metadataInvokeAsyncOutput `json:"-" xml:"-"`
}

type metadataInvokeAsyncOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InvokeAsyncOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeAsyncOutput) GoString() string {
	return s.String()
}

type InvokeInput struct {
	// Using the ClientContext you can pass client-specific information to the Lambda
	// function you are invoking. You can then process the client information in
	// your Lambda function as you choose through the context variable. For an example
	// of a ClientContext JSON, go to PutEvents (http://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html)
	// in the Amazon Mobile Analytics API Reference and User Guide.
	//
	// The ClientContext JSON must be base64-encoded.
	ClientContext *string `location:"header" locationName:"X-Amz-Client-Context" type:"string"`

	// The Lambda function name.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// By default, the Invoke API assumes "RequestResponse" invocation type. You
	// can optionally request asynchronous execution by specifying "Event" as the
	// InvocationType. You can also use this parameter to request AWS Lambda to
	// not execute the function but do some verification, such as if the caller
	// is authorized to invoke the function and if the inputs are valid. You request
	// this by specifying "DryRun" as the InvocationType. This is useful in a cross-account
	// scenario when you want to verify access to a function without running it.
	InvocationType *string `location:"header" locationName:"X-Amz-Invocation-Type" type:"string" enum:"InvocationType"`

	// You can set this optional parameter to "Tail" in the request only if you
	// specify the InvocationType parameter with value "RequestResponse". In this
	// case, AWS Lambda returns the base64-encoded last 4 KB of log data produced
	// by your Lambda function in the x-amz-log-results header.
	LogType *string `location:"header" locationName:"X-Amz-Log-Type" type:"string" enum:"LogType"`

	// JSON that you want to provide to your Lambda function as input.
	Payload []byte `type:"blob"`

	metadataInvokeInput `json:"-" xml:"-"`
}

type metadataInvokeInput struct {
	SDKShapeTraits bool `type:"structure" payload:"Payload"`
}

// String returns the string representation
func (s InvokeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeInput) GoString() string {
	return s.String()
}

// Upon success, returns an empty response. Otherwise, throws an exception.
type InvokeOutput struct {
	// Indicates whether an error occurred while executing the Lambda function.
	// If an error occurred this field will have one of two values; Handled or Unhandled.
	// Handled errors are errors that are reported by the function while the Unhandled
	// errors are those detected and reported by AWS Lambda. Unhandled errors include
	// out of memory errors and function timeouts. For information about how to
	// report an Handled error, see Programming Model (http://docs.aws.amazon.com/lambda/latest/dg/programming-model.html).
	FunctionError *string `location:"header" locationName:"X-Amz-Function-Error" type:"string"`

	// It is the base64-encoded logs for the Lambda function invocation. This is
	// present only if the invocation type is "RequestResponse" and the logs were
	// requested.
	LogResult *string `location:"header" locationName:"X-Amz-Log-Result" type:"string"`

	// It is the JSON representation of the object returned by the Lambda function.
	// In This is present only if the invocation type is "RequestResponse".
	//
	// In the event of a function error this field contains a message describing
	// the error. For the Handled errors the Lambda function will report this message.
	// For Unhandled errors AWS Lambda reports the message.
	Payload []byte `type:"blob"`

	// The HTTP status code will be in the 200 range for successful request. For
	// the "RequestResonse" invocation type this status code will be 200. For the
	// "Event" invocation type this status code will be 202. For the "DryRun" invocation
	// type the status code will be 204.
	StatusCode *int64 `location:"statusCode" type:"integer"`

	metadataInvokeOutput `json:"-" xml:"-"`
}

type metadataInvokeOutput struct {
	SDKShapeTraits bool `type:"structure" payload:"Payload"`
}

// String returns the string representation
func (s InvokeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvokeOutput) GoString() string {
	return s.String()
}

type ListEventSourceMappingsInput struct {
	// The Amazon Resource Name (ARN) of the Amazon Kinesis stream.
	EventSourceArn *string `location:"querystring" locationName:"EventSourceArn" type:"string"`

	// The name of the Lambda function.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"querystring" locationName:"FunctionName" min:"1" type:"string"`

	// Optional string. An opaque pagination token returned from a previous ListEventSourceMappings
	// operation. If present, specifies to continue the list from where the returning
	// call left off.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of event sources to return
	// in response. This value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`

	metadataListEventSourceMappingsInput `json:"-" xml:"-"`
}

type metadataListEventSourceMappingsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListEventSourceMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsInput) GoString() string {
	return s.String()
}

// Contains a list of event sources (see API_EventSourceMappingConfiguration)
type ListEventSourceMappingsOutput struct {
	// An array of EventSourceMappingConfiguration objects.
	EventSourceMappings []*EventSourceMappingConfiguration `type:"list"`

	// A string, present if there are more event source mappings.
	NextMarker *string `type:"string"`

	metadataListEventSourceMappingsOutput `json:"-" xml:"-"`
}

type metadataListEventSourceMappingsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListEventSourceMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListEventSourceMappingsOutput) GoString() string {
	return s.String()
}

type ListFunctionsInput struct {
	// Optional string. An opaque pagination token returned from a previous ListFunctions
	// operation. If present, indicates where to continue the listing.
	Marker *string `location:"querystring" locationName:"Marker" type:"string"`

	// Optional integer. Specifies the maximum number of AWS Lambda functions to
	// return in response. This parameter value must be greater than 0.
	MaxItems *int64 `location:"querystring" locationName:"MaxItems" min:"1" type:"integer"`

	metadataListFunctionsInput `json:"-" xml:"-"`
}

type metadataListFunctionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListFunctionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsInput) GoString() string {
	return s.String()
}

// Contains a list of AWS Lambda function configurations (see FunctionConfiguration.
type ListFunctionsOutput struct {
	// A list of Lambda functions.
	Functions []*FunctionConfiguration `type:"list"`

	// A string, present if there are more functions.
	NextMarker *string `type:"string"`

	metadataListFunctionsOutput `json:"-" xml:"-"`
}

type metadataListFunctionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListFunctionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListFunctionsOutput) GoString() string {
	return s.String()
}

type RemovePermissionInput struct {
	// Lambda function whose access policy you want to remove a permission from.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Statement ID of the permission to remove.
	StatementId *string `location:"uri" locationName:"StatementId" min:"1" type:"string" required:"true"`

	metadataRemovePermissionInput `json:"-" xml:"-"`
}

type metadataRemovePermissionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionInput) GoString() string {
	return s.String()
}

type RemovePermissionOutput struct {
	metadataRemovePermissionOutput `json:"-" xml:"-"`
}

type metadataRemovePermissionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemovePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemovePermissionOutput) GoString() string {
	return s.String()
}

type UpdateEventSourceMappingInput struct {
	// The maximum number of stream records that can be sent to your Lambda function
	// for a single invocation.
	BatchSize *int64 `min:"1" type:"integer"`

	// Specifies whether AWS Lambda should actively poll the stream or not. If disabled,
	// AWS Lambda will not poll the stream.
	Enabled *bool `type:"boolean"`

	// The Lambda function to which you want the stream records sent.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `min:"1" type:"string"`

	// The event source mapping identifier.
	UUID *string `location:"uri" locationName:"UUID" type:"string" required:"true"`

	metadataUpdateEventSourceMappingInput `json:"-" xml:"-"`
}

type metadataUpdateEventSourceMappingInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateEventSourceMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateEventSourceMappingInput) GoString() string {
	return s.String()
}

type UpdateFunctionCodeInput struct {
	// The existing Lambda function name whose code you want to replace.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// Amazon S3 bucket name where the .zip file containing your deployment package
	// is stored. This bucket must reside in the same AWS region where you are creating
	// the Lambda function.
	S3Bucket *string `min:"3" type:"string"`

	// The Amazon S3 object (the deployment package) key name you want to upload.
	S3Key *string `min:"1" type:"string"`

	// The Amazon S3 object (the deployment package) version you want to upload.
	S3ObjectVersion *string `min:"1" type:"string"`

	// Based64-encoded .zip file containing your packaged source code.
	ZipFile []byte `type:"blob"`

	metadataUpdateFunctionCodeInput `json:"-" xml:"-"`
}

type metadataUpdateFunctionCodeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionCodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionCodeInput) GoString() string {
	return s.String()
}

type UpdateFunctionConfigurationInput struct {
	// A short user-defined function description. AWS Lambda does not use this value.
	// Assign a meaningful description as you see fit.
	Description *string `type:"string"`

	// The name of the Lambda function.
	//
	//  You can specify an unqualified function name (for example, "Thumbnail")
	// or you can specify Amazon Resource Name (ARN) of the function (for example,
	// "arn:aws:lambda:us-west-2:account-id:function:ThumbNail"). AWS Lambda also
	// allows you to specify only the account ID qualifier (for example, "account-id:Thumbnail").
	// Note that the length constraint applies only to the ARN. If you specify only
	// the function name, it is limited to 64 character in length.
	FunctionName *string `location:"uri" locationName:"FunctionName" min:"1" type:"string" required:"true"`

	// The function that Lambda calls to begin executing your function. For Node.js,
	// it is the module-name.export value in your function.
	Handler *string `type:"string"`

	// The amount of memory, in MB, your Lambda function is given. AWS Lambda uses
	// this memory size to infer the amount of CPU allocated to your function. Your
	// function use-case determines your CPU and memory requirements. For example,
	// a database operation might need less memory compared to an image processing
	// function. The default value is 128 MB. The value must be a multiple of 64
	// MB.
	MemorySize *int64 `min:"128" type:"integer"`

	// The Amazon Resource Name (ARN) of the IAM role that Lambda will assume when
	// it executes your function.
	Role *string `type:"string"`

	// The function execution time at which AWS Lambda should terminate the function.
	// Because the execution time has cost implications, we recommend you set this
	// value based on your expected execution time. The default is 3 seconds.
	Timeout *int64 `min:"1" type:"integer"`

	metadataUpdateFunctionConfigurationInput `json:"-" xml:"-"`
}

type metadataUpdateFunctionConfigurationInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateFunctionConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateFunctionConfigurationInput) GoString() string {
	return s.String()
}

const (
	// @enum EventSourcePosition
	EventSourcePositionTrimHorizon = "TRIM_HORIZON"
	// @enum EventSourcePosition
	EventSourcePositionLatest = "LATEST"
)

const (
	// @enum InvocationType
	InvocationTypeEvent = "Event"
	// @enum InvocationType
	InvocationTypeRequestResponse = "RequestResponse"
	// @enum InvocationType
	InvocationTypeDryRun = "DryRun"
)

const (
	// @enum LogType
	LogTypeNone = "None"
	// @enum LogType
	LogTypeTail = "Tail"
)

const (
	// @enum Runtime
	RuntimeNodejs = "nodejs"
	// @enum Runtime
	RuntimeJava8 = "java8"
)
