// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package glacier provides a client for Amazon Glacier.
package glacier

import (
	"io"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAbortMultipartUpload = "AbortMultipartUpload"

// AbortMultipartUploadRequest generates a request for the AbortMultipartUpload operation.
func (c *Glacier) AbortMultipartUploadRequest(input *AbortMultipartUploadInput) (req *request.Request, output *AbortMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opAbortMultipartUpload,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
	}

	if input == nil {
		input = &AbortMultipartUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AbortMultipartUploadOutput{}
	req.Data = output
	return
}

// This operation aborts a multipart upload identified by the upload ID.
//
// After the Abort Multipart Upload request succeeds, you cannot upload any
// more parts to the multipart upload or complete the multipart upload. Aborting
// a completed upload fails. However, aborting an already-aborted upload will
// succeed, for a short time. For more information about uploading a part and
// completing a multipart upload, see UploadMultipartPart and CompleteMultipartUpload.
//
// This operation is idempotent.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
//  For conceptual information and underlying REST API, go to Working with
// Archives in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
// and Abort Multipart Upload (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) AbortMultipartUpload(input *AbortMultipartUploadInput) (*AbortMultipartUploadOutput, error) {
	req, out := c.AbortMultipartUploadRequest(input)
	err := req.Send()
	return out, err
}

const opAbortVaultLock = "AbortVaultLock"

// AbortVaultLockRequest generates a request for the AbortVaultLock operation.
func (c *Glacier) AbortVaultLockRequest(input *AbortVaultLockInput) (req *request.Request, output *AbortVaultLockOutput) {
	op := &request.Operation{
		Name:       opAbortVaultLock,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/lock-policy",
	}

	if input == nil {
		input = &AbortVaultLockInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AbortVaultLockOutput{}
	req.Data = output
	return
}

// This operation aborts the vault locking process if the vault lock is not
// in the Locked state. If the vault lock is in the Locked state when this operation
// is requested, the operation returns an AccessDeniedException error. Aborting
// the vault locking process removes the vault lock policy from the specified
// vault.
//
// A vault lock is put into the InProgress state by calling InitiateVaultLock.
// A vault lock is put into the Locked state by calling CompleteVaultLock. You
// can get the state of a vault lock by calling GetVaultLock. For more information
// about the vault locking process, see Amazon Glacier Vault Lock (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
// For more information about vault lock policies, see Amazon Glacier Access
// Control with Vault Lock Policies (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html).
//
// This operation is idempotent. You can successfully invoke this operation
// multiple times, if the vault lock is in the InProgress state or if there
// is no policy associated with the vault.
func (c *Glacier) AbortVaultLock(input *AbortVaultLockInput) (*AbortVaultLockOutput, error) {
	req, out := c.AbortVaultLockRequest(input)
	err := req.Send()
	return out, err
}

const opAddTagsToVault = "AddTagsToVault"

// AddTagsToVaultRequest generates a request for the AddTagsToVault operation.
func (c *Glacier) AddTagsToVaultRequest(input *AddTagsToVaultInput) (req *request.Request, output *AddTagsToVaultOutput) {
	op := &request.Operation{
		Name:       opAddTagsToVault,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/tags?operation=add",
	}

	if input == nil {
		input = &AddTagsToVaultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsToVaultOutput{}
	req.Data = output
	return
}

// This operation adds the specified tags to a vault. Each tag is composed of
// a key and a value. Each vault can have up to 10 tags. If your request would
// cause the tag limit for the vault to be exceeded, the operation throws the
// LimitExceededException error. If a tag already exists on the vault under
// a specified key, the existing key value will be overwritten. For more information
// about tags, see Tagging Amazon Glacier Resources (http://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html).
func (c *Glacier) AddTagsToVault(input *AddTagsToVaultInput) (*AddTagsToVaultOutput, error) {
	req, out := c.AddTagsToVaultRequest(input)
	err := req.Send()
	return out, err
}

const opCompleteMultipartUpload = "CompleteMultipartUpload"

// CompleteMultipartUploadRequest generates a request for the CompleteMultipartUpload operation.
func (c *Glacier) CompleteMultipartUploadRequest(input *CompleteMultipartUploadInput) (req *request.Request, output *ArchiveCreationOutput) {
	op := &request.Operation{
		Name:       opCompleteMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
	}

	if input == nil {
		input = &CompleteMultipartUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ArchiveCreationOutput{}
	req.Data = output
	return
}

// You call this operation to inform Amazon Glacier that all the archive parts
// have been uploaded and that Amazon Glacier can now assemble the archive from
// the uploaded parts. After assembling and saving the archive to the vault,
// Amazon Glacier returns the URI path of the newly created archive resource.
// Using the URI path, you can then access the archive. After you upload an
// archive, you should save the archive ID returned to retrieve the archive
// at a later point. You can also get the vault inventory to obtain a list of
// archive IDs in a vault. For more information, see InitiateJob.
//
// In the request, you must include the computed SHA256 tree hash of the entire
// archive you have uploaded. For information about computing a SHA256 tree
// hash, see Computing Checksums (http://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html).
// On the server side, Amazon Glacier also constructs the SHA256 tree hash of
// the assembled archive. If the values match, Amazon Glacier saves the archive
// to the vault; otherwise, it returns an error, and the operation fails. The
// ListParts operation returns a list of parts uploaded for a specific multipart
// upload. It includes checksum information for each uploaded part that can
// be used to debug a bad checksum issue.
//
// Additionally, Amazon Glacier also checks for any missing content ranges
// when assembling the archive, if missing content ranges are found, Amazon
// Glacier returns an error and the operation fails.
//
// Complete Multipart Upload is an idempotent operation. After your first successful
// complete multipart upload, if you call the operation again within a short
// period, the operation will succeed and return the same archive ID. This is
// useful in the event you experience a network issue that causes an aborted
// connection or receive a 500 server error, in which case you can repeat your
// Complete Multipart Upload request and get the same archive ID without creating
// duplicate archives. Note, however, that after the multipart upload completes,
// you cannot call the List Parts operation and the multipart upload will not
// appear in List Multipart Uploads response, even if idempotent complete is
// possible.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
//  For conceptual information and underlying REST API, go to Uploading Large
// Archives in Parts (Multipart Upload) (http://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
// and Complete Multipart Upload (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-complete-upload.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) CompleteMultipartUpload(input *CompleteMultipartUploadInput) (*ArchiveCreationOutput, error) {
	req, out := c.CompleteMultipartUploadRequest(input)
	err := req.Send()
	return out, err
}

const opCompleteVaultLock = "CompleteVaultLock"

// CompleteVaultLockRequest generates a request for the CompleteVaultLock operation.
func (c *Glacier) CompleteVaultLockRequest(input *CompleteVaultLockInput) (req *request.Request, output *CompleteVaultLockOutput) {
	op := &request.Operation{
		Name:       opCompleteVaultLock,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/lock-policy/{lockId}",
	}

	if input == nil {
		input = &CompleteVaultLockInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CompleteVaultLockOutput{}
	req.Data = output
	return
}

// This operation completes the vault locking process by transitioning the vault
// lock from the InProgress state to the Locked state, which causes the vault
// lock policy to become unchangeable. A vault lock is put into the InProgress
// state by calling InitiateVaultLock. You can obtain the state of the vault
// lock by calling GetVaultLock. For more information about the vault locking
// process, Amazon Glacier Vault Lock (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
//
// This operation is idempotent. This request is always successful if the vault
// lock is in the Locked state and the provided lock ID matches the lock ID
// originally used to lock the vault.
//
// If an invalid lock ID is passed in the request when the vault lock is in
// the Locked state, the operation returns an AccessDeniedException error. If
// an invalid lock ID is passed in the request when the vault lock is in the
// InProgress state, the operation throws an InvalidParameter error.
func (c *Glacier) CompleteVaultLock(input *CompleteVaultLockInput) (*CompleteVaultLockOutput, error) {
	req, out := c.CompleteVaultLockRequest(input)
	err := req.Send()
	return out, err
}

const opCreateVault = "CreateVault"

// CreateVaultRequest generates a request for the CreateVault operation.
func (c *Glacier) CreateVaultRequest(input *CreateVaultInput) (req *request.Request, output *CreateVaultOutput) {
	op := &request.Operation{
		Name:       opCreateVault,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/vaults/{vaultName}",
	}

	if input == nil {
		input = &CreateVaultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateVaultOutput{}
	req.Data = output
	return
}

// This operation creates a new vault with the specified name. The name of the
// vault must be unique within a region for an AWS account. You can create up
// to 1,000 vaults per account. If you need to create more vaults, contact Amazon
// Glacier.
//
// You must use the following guidelines when naming a vault.
//
//     Names can be between 1 and 255 characters long.
//
//   Allowed characters are a-z, A-Z, 0-9, '_' (underscore), '-' (hyphen),
// and '.' (period).
//
//    This operation is idempotent.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
//  For conceptual information and underlying REST API, go to Creating a Vault
// in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/creating-vaults.html)
// and Create Vault  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-put.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) CreateVault(input *CreateVaultInput) (*CreateVaultOutput, error) {
	req, out := c.CreateVaultRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteArchive = "DeleteArchive"

// DeleteArchiveRequest generates a request for the DeleteArchive operation.
func (c *Glacier) DeleteArchiveRequest(input *DeleteArchiveInput) (req *request.Request, output *DeleteArchiveOutput) {
	op := &request.Operation{
		Name:       opDeleteArchive,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/archives/{archiveId}",
	}

	if input == nil {
		input = &DeleteArchiveInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteArchiveOutput{}
	req.Data = output
	return
}

// This operation deletes an archive from a vault. Subsequent requests to initiate
// a retrieval of this archive will fail. Archive retrievals that are in progress
// for this archive ID may or may not succeed according to the following scenarios:
//
//  If the archive retrieval job is actively preparing the data for download
// when Amazon Glacier receives the delete archive request, the archival retrieval
// operation might fail.  If the archive retrieval job has successfully prepared
// the archive for download when Amazon Glacier receives the delete archive
// request, you will be able to download the output.   This operation is idempotent.
// Attempting to delete an already-deleted archive does not result in an error.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
//  For conceptual information and underlying REST API, go to Deleting an Archive
// in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-an-archive.html)
// and Delete Archive (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) DeleteArchive(input *DeleteArchiveInput) (*DeleteArchiveOutput, error) {
	req, out := c.DeleteArchiveRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVault = "DeleteVault"

// DeleteVaultRequest generates a request for the DeleteVault operation.
func (c *Glacier) DeleteVaultRequest(input *DeleteVaultInput) (req *request.Request, output *DeleteVaultOutput) {
	op := &request.Operation{
		Name:       opDeleteVault,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}",
	}

	if input == nil {
		input = &DeleteVaultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVaultOutput{}
	req.Data = output
	return
}

// This operation deletes a vault. Amazon Glacier will delete a vault only if
// there are no archives in the vault as of the last inventory and there have
// been no writes to the vault since the last inventory. If either of these
// conditions is not satisfied, the vault deletion fails (that is, the vault
// is not removed) and Amazon Glacier returns an error. You can use DescribeVault
// to return the number of archives in a vault, and you can use Initiate a Job
// (POST jobs) (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html)
// to initiate a new inventory retrieval for a vault. The inventory contains
// the archive IDs you use to delete archives using Delete Archive (DELETE archive)
// (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html).
//
// This operation is idempotent.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
//  For conceptual information and underlying REST API, go to Deleting a Vault
// in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-vaults.html)
// and Delete Vault  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-delete.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) DeleteVault(input *DeleteVaultInput) (*DeleteVaultOutput, error) {
	req, out := c.DeleteVaultRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVaultAccessPolicy = "DeleteVaultAccessPolicy"

// DeleteVaultAccessPolicyRequest generates a request for the DeleteVaultAccessPolicy operation.
func (c *Glacier) DeleteVaultAccessPolicyRequest(input *DeleteVaultAccessPolicyInput) (req *request.Request, output *DeleteVaultAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteVaultAccessPolicy,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/access-policy",
	}

	if input == nil {
		input = &DeleteVaultAccessPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVaultAccessPolicyOutput{}
	req.Data = output
	return
}

// This operation deletes the access policy associated with the specified vault.
// The operation is eventually consistent; that is, it might take some time
// for Amazon Glacier to completely remove the access policy, and you might
// still see the effect of the policy for a short time after you send the delete
// request.
//
// This operation is idempotent. You can invoke delete multiple times, even
// if there is no policy associated with the vault. For more information about
// vault access policies, see Amazon Glacier Access Control with Vault Access
// Policies (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
func (c *Glacier) DeleteVaultAccessPolicy(input *DeleteVaultAccessPolicyInput) (*DeleteVaultAccessPolicyOutput, error) {
	req, out := c.DeleteVaultAccessPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVaultNotifications = "DeleteVaultNotifications"

// DeleteVaultNotificationsRequest generates a request for the DeleteVaultNotifications operation.
func (c *Glacier) DeleteVaultNotificationsRequest(input *DeleteVaultNotificationsInput) (req *request.Request, output *DeleteVaultNotificationsOutput) {
	op := &request.Operation{
		Name:       opDeleteVaultNotifications,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/notification-configuration",
	}

	if input == nil {
		input = &DeleteVaultNotificationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVaultNotificationsOutput{}
	req.Data = output
	return
}

// This operation deletes the notification configuration set for a vault. The
// operation is eventually consistent; that is, it might take some time for
// Amazon Glacier to completely disable the notifications and you might still
// receive some notifications for a short time after you send the delete request.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/latest/dev/using-iam-with-amazon-glacier.html).
//
//  For conceptual information and underlying REST API, go to Configuring Vault
// Notifications in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html)
// and Delete Vault Notification Configuration  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-delete.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) DeleteVaultNotifications(input *DeleteVaultNotificationsInput) (*DeleteVaultNotificationsOutput, error) {
	req, out := c.DeleteVaultNotificationsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeJob = "DescribeJob"

// DescribeJobRequest generates a request for the DescribeJob operation.
func (c *Glacier) DescribeJobRequest(input *DescribeJobInput) (req *request.Request, output *JobDescription) {
	op := &request.Operation{
		Name:       opDescribeJob,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/jobs/{jobId}",
	}

	if input == nil {
		input = &DescribeJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &JobDescription{}
	req.Data = output
	return
}

// This operation returns information about a job you previously initiated,
// including the job initiation date, the user who initiated the job, the job
// status code/message and the Amazon SNS topic to notify after Amazon Glacier
// completes the job. For more information about initiating a job, see InitiateJob.
//
// This operation enables you to check the status of your job. However, it
// is strongly recommended that you set up an Amazon SNS topic and specify it
// in your initiate job request so that Amazon Glacier can notify the topic
// after it completes the job.
//
// A job ID will not expire for at least 24 hours after Amazon Glacier completes
// the job.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
//  For information about the underlying REST API, go to Working with Archives
// in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-describe-job-get.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) DescribeJob(input *DescribeJobInput) (*JobDescription, error) {
	req, out := c.DescribeJobRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVault = "DescribeVault"

// DescribeVaultRequest generates a request for the DescribeVault operation.
func (c *Glacier) DescribeVaultRequest(input *DescribeVaultInput) (req *request.Request, output *DescribeVaultOutput) {
	op := &request.Operation{
		Name:       opDescribeVault,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}",
	}

	if input == nil {
		input = &DescribeVaultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVaultOutput{}
	req.Data = output
	return
}

// This operation returns information about a vault, including the vault's Amazon
// Resource Name (ARN), the date the vault was created, the number of archives
// it contains, and the total size of all the archives in the vault. The number
// of archives and their total size are as of the last inventory generation.
// This means that if you add or remove an archive from a vault, and then immediately
// use Describe Vault, the change in contents will not be immediately reflected.
// If you want to retrieve the latest inventory of the vault, use InitiateJob.
// Amazon Glacier generates vault inventories approximately daily. For more
// information, see Downloading a Vault Inventory in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html).
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, go to Retrieving Vault
// Metadata in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html)
// and Describe Vault  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-get.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) DescribeVault(input *DescribeVaultInput) (*DescribeVaultOutput, error) {
	req, out := c.DescribeVaultRequest(input)
	err := req.Send()
	return out, err
}

const opGetDataRetrievalPolicy = "GetDataRetrievalPolicy"

// GetDataRetrievalPolicyRequest generates a request for the GetDataRetrievalPolicy operation.
func (c *Glacier) GetDataRetrievalPolicyRequest(input *GetDataRetrievalPolicyInput) (req *request.Request, output *GetDataRetrievalPolicyOutput) {
	op := &request.Operation{
		Name:       opGetDataRetrievalPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/policies/data-retrieval",
	}

	if input == nil {
		input = &GetDataRetrievalPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDataRetrievalPolicyOutput{}
	req.Data = output
	return
}

// This operation returns the current data retrieval policy for the account
// and region specified in the GET request. For more information about data
// retrieval policies, see Amazon Glacier Data Retrieval Policies (http://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html).
func (c *Glacier) GetDataRetrievalPolicy(input *GetDataRetrievalPolicyInput) (*GetDataRetrievalPolicyOutput, error) {
	req, out := c.GetDataRetrievalPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetJobOutput = "GetJobOutput"

// GetJobOutputRequest generates a request for the GetJobOutput operation.
func (c *Glacier) GetJobOutputRequest(input *GetJobOutputInput) (req *request.Request, output *GetJobOutputOutput) {
	op := &request.Operation{
		Name:       opGetJobOutput,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/jobs/{jobId}/output",
	}

	if input == nil {
		input = &GetJobOutputInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetJobOutputOutput{}
	req.Data = output
	return
}

// This operation downloads the output of the job you initiated using InitiateJob.
// Depending on the job type you specified when you initiated the job, the output
// will be either the content of an archive or a vault inventory.
//
// A job ID will not expire for at least 24 hours after Amazon Glacier completes
// the job. That is, you can download the job output within the 24 hours period
// after Amazon Glacier completes the job.
//
// If the job output is large, then you can use the Range request header to
// retrieve a portion of the output. This allows you to download the entire
// output in smaller chunks of bytes. For example, suppose you have 1 GB of
// job output you want to download and you decide to download 128 MB chunks
// of data at a time, which is a total of eight Get Job Output requests. You
// use the following process to download the job output:
//
//   Download a 128 MB chunk of output by specifying the appropriate byte range
// using the Range header.
//
//   Along with the data, the response includes a SHA256 tree hash of the payload.
// You compute the checksum of the payload on the client and compare it with
// the checksum you received in the response to ensure you received all the
// expected data.
//
//   Repeat steps 1 and 2 for all the eight 128 MB chunks of output data, each
// time specifying the appropriate byte range.
//
//   After downloading all the parts of the job output, you have a list of
// eight checksum values. Compute the tree hash of these values to find the
// checksum of the entire output. Using the DescribeJob API, obtain job information
// of the job that provided you the output. The response includes the checksum
// of the entire archive stored in Amazon Glacier. You compare this value with
// the checksum you computed to ensure you have downloaded the entire archive
// content with no errors.
//
//   An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and the underlying REST API, go to Downloading
// a Vault Inventory (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html),
// Downloading an Archive (http://docs.aws.amazon.com/amazonglacier/latest/dev/downloading-an-archive.html),
// and Get Job Output  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html)
func (c *Glacier) GetJobOutput(input *GetJobOutputInput) (*GetJobOutputOutput, error) {
	req, out := c.GetJobOutputRequest(input)
	err := req.Send()
	return out, err
}

const opGetVaultAccessPolicy = "GetVaultAccessPolicy"

// GetVaultAccessPolicyRequest generates a request for the GetVaultAccessPolicy operation.
func (c *Glacier) GetVaultAccessPolicyRequest(input *GetVaultAccessPolicyInput) (req *request.Request, output *GetVaultAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opGetVaultAccessPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/access-policy",
	}

	if input == nil {
		input = &GetVaultAccessPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetVaultAccessPolicyOutput{}
	req.Data = output
	return
}

// This operation retrieves the access-policy subresource set on the vault;
// for more information on setting this subresource, see Set Vault Access Policy
// (PUT access-policy) (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html).
// If there is no access policy set on the vault, the operation returns a 404
// Not found error. For more information about vault access policies, see Amazon
// Glacier Access Control with Vault Access Policies (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
func (c *Glacier) GetVaultAccessPolicy(input *GetVaultAccessPolicyInput) (*GetVaultAccessPolicyOutput, error) {
	req, out := c.GetVaultAccessPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetVaultLock = "GetVaultLock"

// GetVaultLockRequest generates a request for the GetVaultLock operation.
func (c *Glacier) GetVaultLockRequest(input *GetVaultLockInput) (req *request.Request, output *GetVaultLockOutput) {
	op := &request.Operation{
		Name:       opGetVaultLock,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/lock-policy",
	}

	if input == nil {
		input = &GetVaultLockInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetVaultLockOutput{}
	req.Data = output
	return
}

// This operation retrieves the following attributes from the lock-policy subresource
// set on the specified vault:   The vault lock policy set on the vault.
//
//   The state of the vault lock, which is either InProgess or Locked.
//
//   When the lock ID expires. The lock ID is used to complete the vault locking
// process.
//
//   When the vault lock was initiated and put into the InProgress state.
//
//    A vault lock is put into the InProgress state by calling InitiateVaultLock.
// A vault lock is put into the Locked state by calling CompleteVaultLock. You
// can abort the vault locking process by calling AbortVaultLock. For more information
// about the vault locking process, Amazon Glacier Vault Lock (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
//
// If there is no vault lock policy set on the vault, the operation returns
// a 404 Not found error. For more information about vault lock policies, Amazon
// Glacier Access Control with Vault Lock Policies (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html).
func (c *Glacier) GetVaultLock(input *GetVaultLockInput) (*GetVaultLockOutput, error) {
	req, out := c.GetVaultLockRequest(input)
	err := req.Send()
	return out, err
}

const opGetVaultNotifications = "GetVaultNotifications"

// GetVaultNotificationsRequest generates a request for the GetVaultNotifications operation.
func (c *Glacier) GetVaultNotificationsRequest(input *GetVaultNotificationsInput) (req *request.Request, output *GetVaultNotificationsOutput) {
	op := &request.Operation{
		Name:       opGetVaultNotifications,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/notification-configuration",
	}

	if input == nil {
		input = &GetVaultNotificationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetVaultNotificationsOutput{}
	req.Data = output
	return
}

// This operation retrieves the notification-configuration subresource of the
// specified vault.
//
// For information about setting a notification configuration on a vault, see
// SetVaultNotifications. If a notification configuration for a vault is not
// set, the operation returns a 404 Not Found error. For more information about
// vault notifications, see Configuring Vault Notifications in Amazon Glacier
// (http://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html).
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, go to Configuring Vault
// Notifications in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html)
// and Get Vault Notification Configuration  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-get.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) GetVaultNotifications(input *GetVaultNotificationsInput) (*GetVaultNotificationsOutput, error) {
	req, out := c.GetVaultNotificationsRequest(input)
	err := req.Send()
	return out, err
}

const opInitiateJob = "InitiateJob"

// InitiateJobRequest generates a request for the InitiateJob operation.
func (c *Glacier) InitiateJobRequest(input *InitiateJobInput) (req *request.Request, output *InitiateJobOutput) {
	op := &request.Operation{
		Name:       opInitiateJob,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/jobs",
	}

	if input == nil {
		input = &InitiateJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &InitiateJobOutput{}
	req.Data = output
	return
}

// This operation initiates a job of the specified type. In this release, you
// can initiate a job to retrieve either an archive or a vault inventory (a
// list of archives in a vault).
//
// Retrieving data from Amazon Glacier is a two-step process:
//
//   Initiate a retrieval job.
//
// A data retrieval policy can cause your initiate retrieval job request to
// fail with a PolicyEnforcedException exception. For more information about
// data retrieval policies, see Amazon Glacier Data Retrieval Policies (http://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html).
// For more information about the PolicyEnforcedException exception, see Error
// Responses (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-error-responses.html).
//
//   After the job completes, download the bytes.
//
//  The retrieval request is executed asynchronously. When you initiate a retrieval
// job, Amazon Glacier creates a job and returns a job ID in the response. When
// Amazon Glacier completes the job, you can get the job output (archive or
// inventory data). For information about getting job output, see GetJobOutput
// operation.
//
// The job must complete before you can get its output. To determine when a
// job is complete, you have the following options:
//
//   Use Amazon SNS Notification You can specify an Amazon Simple Notification
// Service (Amazon SNS) topic to which Amazon Glacier can post a notification
// after the job is completed. You can specify an SNS topic per job request.
// The notification is sent only after Amazon Glacier completes the job. In
// addition to specifying an SNS topic per job request, you can configure vault
// notifications for a vault so that job notifications are always sent. For
// more information, see SetVaultNotifications.
//
//   Get job details You can make a DescribeJob request to obtain job status
// information while a job is in progress. However, it is more efficient to
// use an Amazon SNS notification to determine when a job is complete.
//
//   The information you get via notification is same that you get by calling
// DescribeJob.
//
// If for a specific event, you add both the notification configuration on
// the vault and also specify an SNS topic in your initiate job request, Amazon
// Glacier sends both notifications. For more information, see SetVaultNotifications.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// About the Vault Inventory
//
// Amazon Glacier prepares an inventory for each vault periodically, every
// 24 hours. When you initiate a job for a vault inventory, Amazon Glacier returns
// the last inventory for the vault. The inventory data you get might be up
// to a day or two days old. Also, the initiate inventory job might take some
// time to complete before you can download the vault inventory. So you do not
// want to retrieve a vault inventory for each vault operation. However, in
// some scenarios, you might find the vault inventory useful. For example, when
// you upload an archive, you can provide an archive description but not an
// archive name. Amazon Glacier provides you a unique archive ID, an opaque
// string of characters. So, you might maintain your own database that maps
// archive names to their corresponding Amazon Glacier assigned archive IDs.
// You might find the vault inventory useful in the event you need to reconcile
// information in your database with the actual vault inventory.
//
// Range Inventory Retrieval
//
// You can limit the number of inventory items retrieved by filtering on the
// archive creation date or by setting a limit.
//
// Filtering by Archive Creation Date
//
// You can retrieve inventory items for archives created between StartDate
// and EndDate by specifying values for these parameters in the InitiateJob
// request. Archives created on or after the StartDate and before the EndDate
// will be returned. If you only provide the StartDate without the EndDate,
// you will retrieve the inventory for all archives created on or after the
// StartDate. If you only provide the EndDate without the StartDate, you will
// get back the inventory for all archives created before the EndDate.
//
// Limiting Inventory Items per Retrieval
//
// You can limit the number of inventory items returned by setting the Limit
// parameter in the InitiateJob request. The inventory job output will contain
// inventory items up to the specified Limit. If there are more inventory items
// available, the result is paginated. After a job is complete you can use the
// DescribeJob operation to get a marker that you use in a subsequent InitiateJob
// request. The marker will indicate the starting point to retrieve the next
// set of inventory items. You can page through your entire inventory by repeatedly
// making InitiateJob requests with the marker from the previous DescribeJob
// output, until you get a marker from DescribeJob that returns null, indicating
// that there are no more inventory items available.
//
// You can use the Limit parameter together with the date range parameters.
//
// About Ranged Archive Retrieval
//
//  You can initiate an archive retrieval for the whole archive or a range
// of the archive. In the case of ranged archive retrieval, you specify a byte
// range to return or the whole archive. The range specified must be megabyte
// (MB) aligned, that is the range start value must be divisible by 1 MB and
// range end value plus 1 must be divisible by 1 MB or equal the end of the
// archive. If the ranged archive retrieval is not megabyte aligned, this operation
// returns a 400 response. Furthermore, to ensure you get checksum values for
// data you download using Get Job Output API, the range must be tree hash aligned.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and the underlying REST API, go to Initiate a
// Job (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html)
// and Downloading a Vault Inventory (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html)
func (c *Glacier) InitiateJob(input *InitiateJobInput) (*InitiateJobOutput, error) {
	req, out := c.InitiateJobRequest(input)
	err := req.Send()
	return out, err
}

const opInitiateMultipartUpload = "InitiateMultipartUpload"

// InitiateMultipartUploadRequest generates a request for the InitiateMultipartUpload operation.
func (c *Glacier) InitiateMultipartUploadRequest(input *InitiateMultipartUploadInput) (req *request.Request, output *InitiateMultipartUploadOutput) {
	op := &request.Operation{
		Name:       opInitiateMultipartUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads",
	}

	if input == nil {
		input = &InitiateMultipartUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &InitiateMultipartUploadOutput{}
	req.Data = output
	return
}

// This operation initiates a multipart upload. Amazon Glacier creates a multipart
// upload resource and returns its ID in the response. The multipart upload
// ID is used in subsequent requests to upload parts of an archive (see UploadMultipartPart).
//
// When you initiate a multipart upload, you specify the part size in number
// of bytes. The part size must be a megabyte (1024 KB) multiplied by a power
// of 2-for example, 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608
// (8 MB), and so on. The minimum allowable part size is 1 MB, and the maximum
// is 4 GB.
//
// Every part you upload to this resource (see UploadMultipartPart), except
// the last one, must have the same size. The last one can be the same size
// or smaller. For example, suppose you want to upload a 16.2 MB file. If you
// initiate the multipart upload with a part size of 4 MB, you will upload four
// parts of 4 MB each and one part of 0.2 MB.
//
// You don't need to know the size of the archive when you start a multipart
// upload because Amazon Glacier does not require you to specify the overall
// archive size.
//
// After you complete the multipart upload, Amazon Glacier removes the multipart
// upload resource referenced by the ID. Amazon Glacier also removes the multipart
// upload resource if you cancel the multipart upload or it may be removed if
// there is no activity for a period of 24 hours.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, go to Uploading Large
// Archives in Parts (Multipart Upload) (http://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
// and Initiate Multipart Upload (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-initiate-upload.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) InitiateMultipartUpload(input *InitiateMultipartUploadInput) (*InitiateMultipartUploadOutput, error) {
	req, out := c.InitiateMultipartUploadRequest(input)
	err := req.Send()
	return out, err
}

const opInitiateVaultLock = "InitiateVaultLock"

// InitiateVaultLockRequest generates a request for the InitiateVaultLock operation.
func (c *Glacier) InitiateVaultLockRequest(input *InitiateVaultLockInput) (req *request.Request, output *InitiateVaultLockOutput) {
	op := &request.Operation{
		Name:       opInitiateVaultLock,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/lock-policy",
	}

	if input == nil {
		input = &InitiateVaultLockInput{}
	}

	req = c.newRequest(op, input, output)
	output = &InitiateVaultLockOutput{}
	req.Data = output
	return
}

// This operation initiates the vault locking process by doing the following:
//   Installing a vault lock policy on the specified vault.
//
//   Setting the lock state of vault lock to InProgress.
//
//   Returning a lock ID, which is used to complete the vault locking process.
//
//    You can set one vault lock policy for each vault and this policy can
// be up to 20 KB in size. For more information about vault lock policies, see
// Amazon Glacier Access Control with Vault Lock Policies (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html).
//
// You must complete the vault locking process within 24 hours after the vault
// lock enters the InProgress state. After the 24 hour window ends, the lock
// ID expires, the vault automatically exits the InProgress state, and the vault
// lock policy is removed from the vault. You call CompleteVaultLock to complete
// the vault locking process by setting the state of the vault lock to Locked.
//
// After a vault lock is in the Locked state, you cannot initiate a new vault
// lock for the vault.
//
// You can abort the vault locking process by calling AbortVaultLock. You can
// get the state of the vault lock by calling GetVaultLock. For more information
// about the vault locking process, Amazon Glacier Vault Lock (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
//
// If this operation is called when the vault lock is in the InProgress state,
// the operation returns an AccessDeniedException error. When the vault lock
// is in the InProgress state you must call AbortVaultLock before you can initiate
// a new vault lock policy.
func (c *Glacier) InitiateVaultLock(input *InitiateVaultLockInput) (*InitiateVaultLockOutput, error) {
	req, out := c.InitiateVaultLockRequest(input)
	err := req.Send()
	return out, err
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a request for the ListJobs operation.
func (c *Glacier) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/jobs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListJobsOutput{}
	req.Data = output
	return
}

// This operation lists jobs for a vault, including jobs that are in-progress
// and jobs that have recently finished.
//
// Amazon Glacier retains recently completed jobs for a period before deleting
// them; however, it eventually removes completed jobs. The output of completed
// jobs can be retrieved. Retaining completed jobs for a period of time after
// they have completed enables you to get a job output in the event you miss
// the job completion notification or your first attempt to download it fails.
// For example, suppose you start an archive retrieval job to download an archive.
// After the job completes, you start to download the archive but encounter
// a network error. In this scenario, you can retry and download the archive
// while the job exists.
//
// To retrieve an archive or retrieve a vault inventory from Amazon Glacier,
// you first initiate a job, and after the job completes, you download the data.
// For an archive retrieval, the output is the archive data, and for an inventory
// retrieval, it is the inventory list. The List Job operation returns a list
// of these jobs sorted by job initiation time.
//
// This List Jobs operation supports pagination. By default, this operation
// returns up to 1,000 jobs in the response. You should always check the response
// for a marker at which to continue the list; if there are no more items the
// marker is null. To return a list of jobs that begins at a specific job, set
// the marker request parameter to the value you obtained from a previous List
// Jobs request. You can also limit the number of jobs returned in the response
// by specifying the limit parameter in the request.
//
// Additionally, you can filter the jobs list returned by specifying an optional
// statuscode (InProgress, Succeeded, or Failed) and completed (true, false)
// parameter. The statuscode allows you to specify that only jobs that match
// a specified status are returned. The completed parameter allows you to specify
// that only jobs in a specific completion state are returned.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For the underlying REST API, go to List Jobs  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html)
func (c *Glacier) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Glacier) ListJobsPages(input *ListJobsInput, fn func(p *ListJobsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListJobsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListJobsOutput), lastPage)
	})
}

const opListMultipartUploads = "ListMultipartUploads"

// ListMultipartUploadsRequest generates a request for the ListMultipartUploads operation.
func (c *Glacier) ListMultipartUploadsRequest(input *ListMultipartUploadsInput) (req *request.Request, output *ListMultipartUploadsOutput) {
	op := &request.Operation{
		Name:       opListMultipartUploads,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMultipartUploadsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListMultipartUploadsOutput{}
	req.Data = output
	return
}

// This operation lists in-progress multipart uploads for the specified vault.
// An in-progress multipart upload is a multipart upload that has been initiated
// by an InitiateMultipartUpload request, but has not yet been completed or
// aborted. The list returned in the List Multipart Upload response has no guaranteed
// order.
//
// The List Multipart Uploads operation supports pagination. By default, this
// operation returns up to 1,000 multipart uploads in the response. You should
// always check the response for a marker at which to continue the list; if
// there are no more items the marker is null. To return a list of multipart
// uploads that begins at a specific upload, set the marker request parameter
// to the value you obtained from a previous List Multipart Upload request.
// You can also limit the number of uploads returned in the response by specifying
// the limit parameter in the request.
//
// Note the difference between this operation and listing parts (ListParts).
// The List Multipart Uploads operation lists all multipart uploads for a vault
// and does not require a multipart upload ID. The List Parts operation requires
// a multipart upload ID since parts are associated with a single upload.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and the underlying REST API, go to Working with
// Archives in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
// and List Multipart Uploads  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) ListMultipartUploads(input *ListMultipartUploadsInput) (*ListMultipartUploadsOutput, error) {
	req, out := c.ListMultipartUploadsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Glacier) ListMultipartUploadsPages(input *ListMultipartUploadsInput, fn func(p *ListMultipartUploadsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListMultipartUploadsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListMultipartUploadsOutput), lastPage)
	})
}

const opListParts = "ListParts"

// ListPartsRequest generates a request for the ListParts operation.
func (c *Glacier) ListPartsRequest(input *ListPartsInput) (req *request.Request, output *ListPartsOutput) {
	op := &request.Operation{
		Name:       opListParts,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPartsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPartsOutput{}
	req.Data = output
	return
}

// This operation lists the parts of an archive that have been uploaded in a
// specific multipart upload. You can make this request at any time during an
// in-progress multipart upload before you complete the upload (see CompleteMultipartUpload.
// List Parts returns an error for completed uploads. The list returned in the
// List Parts response is sorted by part range.
//
// The List Parts operation supports pagination. By default, this operation
// returns up to 1,000 uploaded parts in the response. You should always check
// the response for a marker at which to continue the list; if there are no
// more items the marker is null. To return a list of parts that begins at a
// specific part, set the marker request parameter to the value you obtained
// from a previous List Parts request. You can also limit the number of parts
// returned in the response by specifying the limit parameter in the request.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and the underlying REST API, go to Working with
// Archives in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
// and List Parts (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) ListParts(input *ListPartsInput) (*ListPartsOutput, error) {
	req, out := c.ListPartsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Glacier) ListPartsPages(input *ListPartsInput, fn func(p *ListPartsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListPartsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListPartsOutput), lastPage)
	})
}

const opListTagsForVault = "ListTagsForVault"

// ListTagsForVaultRequest generates a request for the ListTagsForVault operation.
func (c *Glacier) ListTagsForVaultRequest(input *ListTagsForVaultInput) (req *request.Request, output *ListTagsForVaultOutput) {
	op := &request.Operation{
		Name:       opListTagsForVault,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/tags",
	}

	if input == nil {
		input = &ListTagsForVaultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTagsForVaultOutput{}
	req.Data = output
	return
}

// This operation lists all the tags attached to a vault. The operation returns
// an empty map if there are no tags. For more information about tags, see Tagging
// Amazon Glacier Resources (http://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html).
func (c *Glacier) ListTagsForVault(input *ListTagsForVaultInput) (*ListTagsForVaultOutput, error) {
	req, out := c.ListTagsForVaultRequest(input)
	err := req.Send()
	return out, err
}

const opListVaults = "ListVaults"

// ListVaultsRequest generates a request for the ListVaults operation.
func (c *Glacier) ListVaultsRequest(input *ListVaultsInput) (req *request.Request, output *ListVaultsOutput) {
	op := &request.Operation{
		Name:       opListVaults,
		HTTPMethod: "GET",
		HTTPPath:   "/{accountId}/vaults",
		Paginator: &request.Paginator{
			InputTokens:     []string{"marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListVaultsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListVaultsOutput{}
	req.Data = output
	return
}

// This operation lists all vaults owned by the calling user's account. The
// list returned in the response is ASCII-sorted by vault name.
//
// By default, this operation returns up to 1,000 items. If there are more
// vaults to list, the response marker field contains the vault Amazon Resource
// Name (ARN) at which to continue the list with a new List Vaults request;
// otherwise, the marker field is null. To return a list of vaults that begins
// at a specific vault, set the marker request parameter to the vault ARN you
// obtained from a previous List Vaults request. You can also limit the number
// of vaults returned in the response by specifying the limit parameter in the
// request.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, go to Retrieving Vault
// Metadata in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html)
// and List Vaults  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) ListVaults(input *ListVaultsInput) (*ListVaultsOutput, error) {
	req, out := c.ListVaultsRequest(input)
	err := req.Send()
	return out, err
}

func (c *Glacier) ListVaultsPages(input *ListVaultsInput, fn func(p *ListVaultsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListVaultsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListVaultsOutput), lastPage)
	})
}

const opRemoveTagsFromVault = "RemoveTagsFromVault"

// RemoveTagsFromVaultRequest generates a request for the RemoveTagsFromVault operation.
func (c *Glacier) RemoveTagsFromVaultRequest(input *RemoveTagsFromVaultInput) (req *request.Request, output *RemoveTagsFromVaultOutput) {
	op := &request.Operation{
		Name:       opRemoveTagsFromVault,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/tags?operation=remove",
	}

	if input == nil {
		input = &RemoveTagsFromVaultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsFromVaultOutput{}
	req.Data = output
	return
}

// This operation removes one or more tags from the set of tags attached to
// a vault. For more information about tags, see Tagging Amazon Glacier Resources
// (http://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html). This
// operation is idempotent. The operation will be successful, even if there
// are no tags attached to the vault.
func (c *Glacier) RemoveTagsFromVault(input *RemoveTagsFromVaultInput) (*RemoveTagsFromVaultOutput, error) {
	req, out := c.RemoveTagsFromVaultRequest(input)
	err := req.Send()
	return out, err
}

const opSetDataRetrievalPolicy = "SetDataRetrievalPolicy"

// SetDataRetrievalPolicyRequest generates a request for the SetDataRetrievalPolicy operation.
func (c *Glacier) SetDataRetrievalPolicyRequest(input *SetDataRetrievalPolicyInput) (req *request.Request, output *SetDataRetrievalPolicyOutput) {
	op := &request.Operation{
		Name:       opSetDataRetrievalPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/policies/data-retrieval",
	}

	if input == nil {
		input = &SetDataRetrievalPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetDataRetrievalPolicyOutput{}
	req.Data = output
	return
}

// This operation sets and then enacts a data retrieval policy in the region
// specified in the PUT request. You can set one policy per region for an AWS
// account. The policy is enacted within a few minutes of a successful PUT operation.
//
// The set policy operation does not affect retrieval jobs that were in progress
// before the policy was enacted. For more information about data retrieval
// policies, see Amazon Glacier Data Retrieval Policies (http://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html).
func (c *Glacier) SetDataRetrievalPolicy(input *SetDataRetrievalPolicyInput) (*SetDataRetrievalPolicyOutput, error) {
	req, out := c.SetDataRetrievalPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opSetVaultAccessPolicy = "SetVaultAccessPolicy"

// SetVaultAccessPolicyRequest generates a request for the SetVaultAccessPolicy operation.
func (c *Glacier) SetVaultAccessPolicyRequest(input *SetVaultAccessPolicyInput) (req *request.Request, output *SetVaultAccessPolicyOutput) {
	op := &request.Operation{
		Name:       opSetVaultAccessPolicy,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/access-policy",
	}

	if input == nil {
		input = &SetVaultAccessPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetVaultAccessPolicyOutput{}
	req.Data = output
	return
}

// This operation configures an access policy for a vault and will overwrite
// an existing policy. To configure a vault access policy, send a PUT request
// to the access-policy subresource of the vault. An access policy is specific
// to a vault and is also called a vault subresource. You can set one access
// policy per vault and the policy can be up to 20 KB in size. For more information
// about vault access policies, see Amazon Glacier Access Control with Vault
// Access Policies (http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
func (c *Glacier) SetVaultAccessPolicy(input *SetVaultAccessPolicyInput) (*SetVaultAccessPolicyOutput, error) {
	req, out := c.SetVaultAccessPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opSetVaultNotifications = "SetVaultNotifications"

// SetVaultNotificationsRequest generates a request for the SetVaultNotifications operation.
func (c *Glacier) SetVaultNotificationsRequest(input *SetVaultNotificationsInput) (req *request.Request, output *SetVaultNotificationsOutput) {
	op := &request.Operation{
		Name:       opSetVaultNotifications,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/notification-configuration",
	}

	if input == nil {
		input = &SetVaultNotificationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetVaultNotificationsOutput{}
	req.Data = output
	return
}

// This operation configures notifications that will be sent when specific events
// happen to a vault. By default, you don't get any notifications.
//
// To configure vault notifications, send a PUT request to the notification-configuration
// subresource of the vault. The request should include a JSON document that
// provides an Amazon SNS topic and specific events for which you want Amazon
// Glacier to send notifications to the topic.
//
// Amazon SNS topics must grant permission to the vault to be allowed to publish
// notifications to the topic. You can configure a vault to publish a notification
// for the following vault events:
//
//   ArchiveRetrievalCompleted This event occurs when a job that was initiated
// for an archive retrieval is completed (InitiateJob). The status of the completed
// job can be "Succeeded" or "Failed". The notification sent to the SNS topic
// is the same output as returned from DescribeJob.   InventoryRetrievalCompleted
// This event occurs when a job that was initiated for an inventory retrieval
// is completed (InitiateJob). The status of the completed job can be "Succeeded"
// or "Failed". The notification sent to the SNS topic is the same output as
// returned from DescribeJob.   An AWS account has full permission to perform
// all operations (actions). However, AWS Identity and Access Management (IAM)
// users don't have any permissions by default. You must grant them explicit
// permission to perform specific actions. For more information, see Access
// Control Using AWS Identity and Access Management (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
// For conceptual information and underlying REST API, go to Configuring Vault
// Notifications in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html)
// and Set Vault Notification Configuration  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-put.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) SetVaultNotifications(input *SetVaultNotificationsInput) (*SetVaultNotificationsOutput, error) {
	req, out := c.SetVaultNotificationsRequest(input)
	err := req.Send()
	return out, err
}

const opUploadArchive = "UploadArchive"

// UploadArchiveRequest generates a request for the UploadArchive operation.
func (c *Glacier) UploadArchiveRequest(input *UploadArchiveInput) (req *request.Request, output *ArchiveCreationOutput) {
	op := &request.Operation{
		Name:       opUploadArchive,
		HTTPMethod: "POST",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/archives",
	}

	if input == nil {
		input = &UploadArchiveInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ArchiveCreationOutput{}
	req.Data = output
	return
}

// This operation adds an archive to a vault. This is a synchronous operation,
// and for a successful upload, your data is durably persisted. Amazon Glacier
// returns the archive ID in the x-amz-archive-id header of the response.
//
// You must use the archive ID to access your data in Amazon Glacier. After
// you upload an archive, you should save the archive ID returned so that you
// can retrieve or delete the archive later. Besides saving the archive ID,
// you can also index it and give it a friendly name to allow for better searching.
// You can also use the optional archive description field to specify how the
// archive is referred to in an external index of archives, such as you might
// create in Amazon DynamoDB. You can also get the vault inventory to obtain
// a list of archive IDs in a vault. For more information, see InitiateJob.
//
// You must provide a SHA256 tree hash of the data you are uploading. For information
// about computing a SHA256 tree hash, see Computing Checksums (http://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html).
//
// You can optionally specify an archive description of up to 1,024 printable
// ASCII characters. You can get the archive description when you either retrieve
// the archive or get the vault inventory. For more information, see InitiateJob.
// Amazon Glacier does not interpret the description in any way. An archive
// description does not need to be unique. You cannot use the description to
// retrieve or sort the archive list.
//
// Archives are immutable. After you upload an archive, you cannot edit the
// archive or its description.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
//  For conceptual information and underlying REST API, go to Uploading an
// Archive in Amazon Glacier (http://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-an-archive.html)
// and Upload Archive (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) UploadArchive(input *UploadArchiveInput) (*ArchiveCreationOutput, error) {
	req, out := c.UploadArchiveRequest(input)
	err := req.Send()
	return out, err
}

const opUploadMultipartPart = "UploadMultipartPart"

// UploadMultipartPartRequest generates a request for the UploadMultipartPart operation.
func (c *Glacier) UploadMultipartPartRequest(input *UploadMultipartPartInput) (req *request.Request, output *UploadMultipartPartOutput) {
	op := &request.Operation{
		Name:       opUploadMultipartPart,
		HTTPMethod: "PUT",
		HTTPPath:   "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
	}

	if input == nil {
		input = &UploadMultipartPartInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UploadMultipartPartOutput{}
	req.Data = output
	return
}

// This operation uploads a part of an archive. You can upload archive parts
// in any order. You can also upload them in parallel. You can upload up to
// 10,000 parts for a multipart upload.
//
// Amazon Glacier rejects your upload part request if any of the following
// conditions is true:
//
//   SHA256 tree hash does not matchTo ensure that part data is not corrupted
// in transmission, you compute a SHA256 tree hash of the part and include it
// in your request. Upon receiving the part data, Amazon Glacier also computes
// a SHA256 tree hash. If these hash values don't match, the operation fails.
// For information about computing a SHA256 tree hash, see Computing Checksums
// (http://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html).
//
//   Part size does not matchThe size of each part except the last must match
// the size specified in the corresponding InitiateMultipartUpload request.
// The size of the last part must be the same size as, or smaller than, the
// specified size.
//
// If you upload a part whose size is smaller than the part size you specified
// in your initiate multipart upload request and that part is not the last part,
// then the upload part request will succeed. However, the subsequent Complete
// Multipart Upload request will fail.
//
//   Range does not alignThe byte range value in the request does not align
// with the part size specified in the corresponding initiate request. For example,
// if you specify a part size of 4194304 bytes (4 MB), then 0 to 4194303 bytes
// (4 MB - 1) and 4194304 (4 MB) to 8388607 (8 MB - 1) are valid part ranges.
// However, if you set a range value of 2 MB to 6 MB, the range does not align
// with the part size and the upload will fail.   This operation is idempotent.
// If you upload the same part multiple times, the data included in the most
// recent request overwrites the previously uploaded data.
//
// An AWS account has full permission to perform all operations (actions).
// However, AWS Identity and Access Management (IAM) users don't have any permissions
// by default. You must grant them explicit permission to perform specific actions.
// For more information, see Access Control Using AWS Identity and Access Management
// (IAM) (http://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
//
//  For conceptual information and underlying REST API, go to Uploading Large
// Archives in Parts (Multipart Upload) (http://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
// and Upload Part  (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html)
// in the Amazon Glacier Developer Guide.
func (c *Glacier) UploadMultipartPart(input *UploadMultipartPartInput) (*UploadMultipartPartOutput, error) {
	req, out := c.UploadMultipartPartRequest(input)
	err := req.Send()
	return out, err
}

// Provides options to abort a multipart upload identified by the upload ID.
//
// For information about the underlying REST API, go to Abort Multipart Upload
// (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html).
// For conceptual information, go to Working with Archives in Amazon Glacier
// (http://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html).
type AbortMultipartUploadInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The upload ID of the multipart upload to delete.
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataAbortMultipartUploadInput `json:"-" xml:"-"`
}

type metadataAbortMultipartUploadInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AbortMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadInput) GoString() string {
	return s.String()
}

type AbortMultipartUploadOutput struct {
	metadataAbortMultipartUploadOutput `json:"-" xml:"-"`
}

type metadataAbortMultipartUploadOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AbortMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortMultipartUploadOutput) GoString() string {
	return s.String()
}

// The input values for AbortVaultLock.
type AbortVaultLockInput struct {
	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single apos-apos (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataAbortVaultLockInput `json:"-" xml:"-"`
}

type metadataAbortVaultLockInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AbortVaultLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortVaultLockInput) GoString() string {
	return s.String()
}

type AbortVaultLockOutput struct {
	metadataAbortVaultLockOutput `json:"-" xml:"-"`
}

type metadataAbortVaultLockOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AbortVaultLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AbortVaultLockOutput) GoString() string {
	return s.String()
}

// The input values for AddTagsToVault.
type AddTagsToVaultInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The tags to add to the vault. Each tag is composed of a key and a value.
	// The value can be an empty string.
	Tags map[string]*string `type:"map"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataAddTagsToVaultInput `json:"-" xml:"-"`
}

type metadataAddTagsToVaultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddTagsToVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToVaultInput) GoString() string {
	return s.String()
}

type AddTagsToVaultOutput struct {
	metadataAddTagsToVaultOutput `json:"-" xml:"-"`
}

type metadataAddTagsToVaultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddTagsToVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsToVaultOutput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
//
// For information about the underlying REST API, go to Upload Archive (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html).
// For conceptual information, go to Working with Archives in Amazon Glacier
// (http://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html).
type ArchiveCreationOutput struct {
	// The ID of the archive. This value is also included as part of the location.
	ArchiveId *string `location:"header" locationName:"x-amz-archive-id" type:"string"`

	// The checksum of the archive computed by Amazon Glacier.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// The relative URI path of the newly added archive resource.
	Location *string `location:"header" locationName:"Location" type:"string"`

	metadataArchiveCreationOutput `json:"-" xml:"-"`
}

type metadataArchiveCreationOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ArchiveCreationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArchiveCreationOutput) GoString() string {
	return s.String()
}

// Provides options to complete a multipart upload operation. This informs Amazon
// Glacier that all the archive parts have been uploaded and Amazon Glacier
// can now assemble the archive from the uploaded parts. After assembling and
// saving the archive to the vault, Amazon Glacier returns the URI path of the
// newly created archive resource.
type CompleteMultipartUploadInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The total size, in bytes, of the entire archive. This value should be the
	// sum of all the sizes of the individual parts that you uploaded.
	ArchiveSize *string `location:"header" locationName:"x-amz-archive-size" type:"string"`

	// The SHA256 tree hash of the entire archive. It is the tree hash of SHA256
	// tree hash of the individual parts. If the value you specify in the request
	// does not match the SHA256 tree hash of the final assembled archive as computed
	// by Amazon Glacier, Amazon Glacier returns an error and the request fails.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// The upload ID of the multipart upload.
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataCompleteMultipartUploadInput `json:"-" xml:"-"`
}

type metadataCompleteMultipartUploadInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CompleteMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteMultipartUploadInput) GoString() string {
	return s.String()
}

// The input values for CompleteVaultLock.
type CompleteVaultLockInput struct {
	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single apos-apos (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The lockId value is the lock ID obtained from a InitiateVaultLock request.
	LockId *string `location:"uri" locationName:"lockId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataCompleteVaultLockInput `json:"-" xml:"-"`
}

type metadataCompleteVaultLockInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CompleteVaultLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteVaultLockInput) GoString() string {
	return s.String()
}

type CompleteVaultLockOutput struct {
	metadataCompleteVaultLockOutput `json:"-" xml:"-"`
}

type metadataCompleteVaultLockOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CompleteVaultLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CompleteVaultLockOutput) GoString() string {
	return s.String()
}

// Provides options to create a vault.
type CreateVaultInput struct {
	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single apos-apos (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataCreateVaultInput `json:"-" xml:"-"`
}

type metadataCreateVaultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVaultInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type CreateVaultOutput struct {
	// The URI of the vault that was created.
	Location *string `location:"header" locationName:"Location" type:"string"`

	metadataCreateVaultOutput `json:"-" xml:"-"`
}

type metadataCreateVaultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateVaultOutput) GoString() string {
	return s.String()
}

// Data retrieval policy.
type DataRetrievalPolicy struct {
	// The policy rule. Although this is a list type, currently there must be only
	// one rule, which contains a Strategy field and optionally a BytesPerHour field.
	Rules []*DataRetrievalRule `type:"list"`

	metadataDataRetrievalPolicy `json:"-" xml:"-"`
}

type metadataDataRetrievalPolicy struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DataRetrievalPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRetrievalPolicy) GoString() string {
	return s.String()
}

// Data retrieval policy rule.
type DataRetrievalRule struct {
	// The maximum number of bytes that can be retrieved in an hour.
	//
	// This field is required only if the value of the Strategy field is BytesPerHour.
	// Your PUT operation will be rejected if the Strategy field is not set to BytesPerHour
	// and you set this field.
	BytesPerHour *int64 `type:"long"`

	// The type of data retrieval policy to set.
	//
	// Valid values: BytesPerHour|FreeTier|None
	Strategy *string `type:"string"`

	metadataDataRetrievalRule `json:"-" xml:"-"`
}

type metadataDataRetrievalRule struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DataRetrievalRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DataRetrievalRule) GoString() string {
	return s.String()
}

// Provides options for deleting an archive from an Amazon Glacier vault.
type DeleteArchiveInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The ID of the archive to delete.
	ArchiveId *string `location:"uri" locationName:"archiveId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataDeleteArchiveInput `json:"-" xml:"-"`
}

type metadataDeleteArchiveInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteArchiveInput) GoString() string {
	return s.String()
}

type DeleteArchiveOutput struct {
	metadataDeleteArchiveOutput `json:"-" xml:"-"`
}

type metadataDeleteArchiveOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteArchiveOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteArchiveOutput) GoString() string {
	return s.String()
}

// DeleteVaultAccessPolicy input.
type DeleteVaultAccessPolicyInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataDeleteVaultAccessPolicyInput `json:"-" xml:"-"`
}

type metadataDeleteVaultAccessPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultAccessPolicyInput) GoString() string {
	return s.String()
}

type DeleteVaultAccessPolicyOutput struct {
	metadataDeleteVaultAccessPolicyOutput `json:"-" xml:"-"`
}

type metadataDeleteVaultAccessPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultAccessPolicyOutput) GoString() string {
	return s.String()
}

// Provides options for deleting a vault from Amazon Glacier.
type DeleteVaultInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataDeleteVaultInput `json:"-" xml:"-"`
}

type metadataDeleteVaultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultInput) GoString() string {
	return s.String()
}

// Provides options for deleting a vault notification configuration from an
// Amazon Glacier vault.
type DeleteVaultNotificationsInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataDeleteVaultNotificationsInput `json:"-" xml:"-"`
}

type metadataDeleteVaultNotificationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVaultNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultNotificationsInput) GoString() string {
	return s.String()
}

type DeleteVaultNotificationsOutput struct {
	metadataDeleteVaultNotificationsOutput `json:"-" xml:"-"`
}

type metadataDeleteVaultNotificationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVaultNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultNotificationsOutput) GoString() string {
	return s.String()
}

type DeleteVaultOutput struct {
	metadataDeleteVaultOutput `json:"-" xml:"-"`
}

type metadataDeleteVaultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVaultOutput) GoString() string {
	return s.String()
}

// Provides options for retrieving a job description.
type DescribeJobInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The ID of the job to describe.
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataDescribeJobInput `json:"-" xml:"-"`
}

type metadataDescribeJobInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobInput) GoString() string {
	return s.String()
}

// Provides options for retrieving metadata for a specific vault in Amazon Glacier.
type DescribeVaultInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataDescribeVaultInput `json:"-" xml:"-"`
}

type metadataDescribeVaultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVaultInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type DescribeVaultOutput struct {
	// The UTC date when the vault was created. A string representation of ISO 8601
	// date format, for example, "2012-03-20T17:03:43.221Z".
	CreationDate *string `type:"string"`

	// The UTC date when Amazon Glacier completed the last vault inventory. A string
	// representation of ISO 8601 date format, for example, "2012-03-20T17:03:43.221Z".
	LastInventoryDate *string `type:"string"`

	// The number of archives in the vault as of the last inventory date. This field
	// will return null if an inventory has not yet run on the vault, for example,
	// if you just created the vault.
	NumberOfArchives *int64 `type:"long"`

	// Total size, in bytes, of the archives in the vault as of the last inventory
	// date. This field will return null if an inventory has not yet run on the
	// vault, for example, if you just created the vault.
	SizeInBytes *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the vault.
	VaultARN *string `type:"string"`

	// The name of the vault.
	VaultName *string `type:"string"`

	metadataDescribeVaultOutput `json:"-" xml:"-"`
}

type metadataDescribeVaultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVaultOutput) GoString() string {
	return s.String()
}

// Input for GetDataRetrievalPolicy.
type GetDataRetrievalPolicyInput struct {
	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single apos-apos (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	metadataGetDataRetrievalPolicyInput `json:"-" xml:"-"`
}

type metadataGetDataRetrievalPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDataRetrievalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataRetrievalPolicyInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to the GetDataRetrievalPolicy request.
type GetDataRetrievalPolicyOutput struct {
	// Contains the returned data retrieval policy in JSON format.
	Policy *DataRetrievalPolicy `type:"structure"`

	metadataGetDataRetrievalPolicyOutput `json:"-" xml:"-"`
}

type metadataGetDataRetrievalPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDataRetrievalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDataRetrievalPolicyOutput) GoString() string {
	return s.String()
}

// Provides options for downloading output of an Amazon Glacier job.
type GetJobOutputInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The job ID whose data is downloaded.
	JobId *string `location:"uri" locationName:"jobId" type:"string" required:"true"`

	// The range of bytes to retrieve from the output. For example, if you want
	// to download the first 1,048,576 bytes, specify "Range: bytes=0-1048575".
	// By default, this operation downloads the entire output.
	Range *string `location:"header" locationName:"Range" type:"string"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataGetJobOutputInput `json:"-" xml:"-"`
}

type metadataGetJobOutputInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetJobOutputInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobOutputInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type GetJobOutputOutput struct {
	// Indicates the range units accepted. For more information, go to RFC2616 (http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html).
	AcceptRanges *string `location:"header" locationName:"Accept-Ranges" type:"string"`

	// The description of an archive.
	ArchiveDescription *string `location:"header" locationName:"x-amz-archive-description" type:"string"`

	// The job data, either archive data or inventory data.
	Body io.ReadCloser `locationName:"body" type:"blob"`

	// The checksum of the data in the response. This header is returned only when
	// retrieving the output for an archive retrieval job. Furthermore, this header
	// appears only under the following conditions:  You get the entire range of
	// the archive. You request a range to return of the archive that starts and
	// ends on a multiple of 1 MB. For example, if you have an 3.1 MB archive and
	// you specify a range to return that starts at 1 MB and ends at 2 MB, then
	// the x-amz-sha256-tree-hash is returned as a response header. You request
	// a range of the archive to return that starts on a multiple of 1 MB and goes
	// to the end of the archive. For example, if you have a 3.1 MB archive and
	// you specify a range that starts at 2 MB and ends at 3.1 MB (the end of the
	// archive), then the x-amz-sha256-tree-hash is returned as a response header.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// The range of bytes returned by Amazon Glacier. If only partial output is
	// downloaded, the response provides the range of bytes Amazon Glacier returned.
	// For example, bytes 0-1048575/8388608 returns the first 1 MB from 8 MB.
	ContentRange *string `location:"header" locationName:"Content-Range" type:"string"`

	// The Content-Type depends on whether the job output is an archive or a vault
	// inventory. For archive data, the Content-Type is application/octet-stream.
	// For vault inventory, if you requested CSV format when you initiated the job,
	// the Content-Type is text/csv. Otherwise, by default, vault inventory is returned
	// as JSON, and the Content-Type is application/json.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`

	// The HTTP response code for a job output request. The value depends on whether
	// a range was specified in the request.
	Status *int64 `location:"statusCode" locationName:"status" type:"integer"`

	metadataGetJobOutputOutput `json:"-" xml:"-"`
}

type metadataGetJobOutputOutput struct {
	SDKShapeTraits bool `type:"structure" payload:"Body"`
}

// String returns the string representation
func (s GetJobOutputOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobOutputOutput) GoString() string {
	return s.String()
}

// Input for GetVaultAccessPolicy.
type GetVaultAccessPolicyInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataGetVaultAccessPolicyInput `json:"-" xml:"-"`
}

type metadataGetVaultAccessPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultAccessPolicyInput) GoString() string {
	return s.String()
}

// Output for GetVaultAccessPolicy.
type GetVaultAccessPolicyOutput struct {
	// Contains the returned vault access policy as a JSON string.
	Policy *VaultAccessPolicy `locationName:"policy" type:"structure"`

	metadataGetVaultAccessPolicyOutput `json:"-" xml:"-"`
}

type metadataGetVaultAccessPolicyOutput struct {
	SDKShapeTraits bool `type:"structure" payload:"Policy"`
}

// String returns the string representation
func (s GetVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultAccessPolicyOutput) GoString() string {
	return s.String()
}

// The input values for GetVaultLock.
type GetVaultLockInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataGetVaultLockInput `json:"-" xml:"-"`
}

type metadataGetVaultLockInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetVaultLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultLockInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type GetVaultLockOutput struct {
	// The UTC date and time at which the vault lock was put into the InProgress
	// state.
	CreationDate *string `type:"string"`

	// The UTC date and time at which the lock ID expires. This value can be null
	// if the vault lock is in a Locked state.
	ExpirationDate *string `type:"string"`

	// The vault lock policy as a JSON string, which uses "\" as an escape character.
	Policy *string `type:"string"`

	// The state of the vault lock. InProgress or Locked.
	State *string `type:"string"`

	metadataGetVaultLockOutput `json:"-" xml:"-"`
}

type metadataGetVaultLockOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetVaultLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultLockOutput) GoString() string {
	return s.String()
}

// Provides options for retrieving the notification configuration set on an
// Amazon Glacier vault.
type GetVaultNotificationsInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataGetVaultNotificationsInput `json:"-" xml:"-"`
}

type metadataGetVaultNotificationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetVaultNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultNotificationsInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type GetVaultNotificationsOutput struct {
	// Returns the notification configuration set on the vault.
	VaultNotificationConfig *VaultNotificationConfig `locationName:"vaultNotificationConfig" type:"structure"`

	metadataGetVaultNotificationsOutput `json:"-" xml:"-"`
}

type metadataGetVaultNotificationsOutput struct {
	SDKShapeTraits bool `type:"structure" payload:"VaultNotificationConfig"`
}

// String returns the string representation
func (s GetVaultNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetVaultNotificationsOutput) GoString() string {
	return s.String()
}

// Provides options for initiating an Amazon Glacier job.
type InitiateJobInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// Provides options for specifying job information.
	JobParameters *JobParameters `locationName:"jobParameters" type:"structure"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataInitiateJobInput `json:"-" xml:"-"`
}

type metadataInitiateJobInput struct {
	SDKShapeTraits bool `type:"structure" payload:"JobParameters"`
}

// String returns the string representation
func (s InitiateJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateJobInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type InitiateJobOutput struct {
	// The ID of the job.
	JobId *string `location:"header" locationName:"x-amz-job-id" type:"string"`

	// The relative URI path of the job.
	Location *string `location:"header" locationName:"Location" type:"string"`

	metadataInitiateJobOutput `json:"-" xml:"-"`
}

type metadataInitiateJobOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InitiateJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateJobOutput) GoString() string {
	return s.String()
}

// Provides options for initiating a multipart upload to an Amazon Glacier vault.
type InitiateMultipartUploadInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The archive description that you are uploading in parts.
	//
	// The part size must be a megabyte (1024 KB) multiplied by a power of 2, for
	// example 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8 MB), and
	// so on. The minimum allowable part size is 1 MB, and the maximum is 4 GB (4096
	// MB).
	ArchiveDescription *string `location:"header" locationName:"x-amz-archive-description" type:"string"`

	// The size of each part except the last, in bytes. The last part can be smaller
	// than this part size.
	PartSize *string `location:"header" locationName:"x-amz-part-size" type:"string"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataInitiateMultipartUploadInput `json:"-" xml:"-"`
}

type metadataInitiateMultipartUploadInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InitiateMultipartUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateMultipartUploadInput) GoString() string {
	return s.String()
}

// The Amazon Glacier response to your request.
type InitiateMultipartUploadOutput struct {
	// The relative URI path of the multipart upload ID Amazon Glacier created.
	Location *string `location:"header" locationName:"Location" type:"string"`

	// The ID of the multipart upload. This value is also included as part of the
	// location.
	UploadId *string `location:"header" locationName:"x-amz-multipart-upload-id" type:"string"`

	metadataInitiateMultipartUploadOutput `json:"-" xml:"-"`
}

type metadataInitiateMultipartUploadOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InitiateMultipartUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateMultipartUploadOutput) GoString() string {
	return s.String()
}

// The input values for InitiateVaultLock.
type InitiateVaultLockInput struct {
	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single apos-apos (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The vault lock policy as a JSON string, which uses "\" as an escape character.
	Policy *VaultLockPolicy `locationName:"policy" type:"structure"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataInitiateVaultLockInput `json:"-" xml:"-"`
}

type metadataInitiateVaultLockInput struct {
	SDKShapeTraits bool `type:"structure" payload:"Policy"`
}

// String returns the string representation
func (s InitiateVaultLockInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateVaultLockInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type InitiateVaultLockOutput struct {
	// The lock ID, which is used to complete the vault locking process.
	LockId *string `location:"header" locationName:"x-amz-lock-id" type:"string"`

	metadataInitiateVaultLockOutput `json:"-" xml:"-"`
}

type metadataInitiateVaultLockOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InitiateVaultLockOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InitiateVaultLockOutput) GoString() string {
	return s.String()
}

// Describes the options for a range inventory retrieval job.
type InventoryRetrievalJobDescription struct {
	// The end of the date range in UTC for vault inventory retrieval that includes
	// archives created before this date. A string representation of ISO 8601 date
	// format, for example, 2013-03-20T17:03:43Z.
	EndDate *string `type:"string"`

	// The output format for the vault inventory list, which is set by the InitiateJob
	// request when initiating a job to retrieve a vault inventory. Valid values
	// are "CSV" and "JSON".
	Format *string `type:"string"`

	// Specifies the maximum number of inventory items returned per vault inventory
	// retrieval request. This limit is set when initiating the job with the a InitiateJob
	// request.
	Limit *string `type:"string"`

	// An opaque string that represents where to continue pagination of the vault
	// inventory retrieval results. You use the marker in a new InitiateJob request
	// to obtain additional inventory items. If there are no more inventory items,
	// this value is null. For more information, see  Range Inventory Retrieval
	// (http://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html#api-initiate-job-post-vault-inventory-list-filtering).
	Marker *string `type:"string"`

	// The start of the date range in UTC for vault inventory retrieval that includes
	// archives created on or after this date. A string representation of ISO 8601
	// date format, for example, 2013-03-20T17:03:43Z.
	StartDate *string `type:"string"`

	metadataInventoryRetrievalJobDescription `json:"-" xml:"-"`
}

type metadataInventoryRetrievalJobDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InventoryRetrievalJobDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryRetrievalJobDescription) GoString() string {
	return s.String()
}

// Provides options for specifying a range inventory retrieval job.
type InventoryRetrievalJobInput struct {
	// The end of the date range in UTC for vault inventory retrieval that includes
	// archives created before this date. A string representation of ISO 8601 date
	// format, for example, 2013-03-20T17:03:43Z.
	EndDate *string `type:"string"`

	// Specifies the maximum number of inventory items returned per vault inventory
	// retrieval request. Valid values are greater than or equal to 1.
	Limit *string `type:"string"`

	// An opaque string that represents where to continue pagination of the vault
	// inventory retrieval results. You use the marker in a new InitiateJob request
	// to obtain additional inventory items. If there are no more inventory items,
	// this value is null.
	Marker *string `type:"string"`

	// The start of the date range in UTC for vault inventory retrieval that includes
	// archives created on or after this date. A string representation of ISO 8601
	// date format, for example, 2013-03-20T17:03:43Z.
	StartDate *string `type:"string"`

	metadataInventoryRetrievalJobInput `json:"-" xml:"-"`
}

type metadataInventoryRetrievalJobInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InventoryRetrievalJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InventoryRetrievalJobInput) GoString() string {
	return s.String()
}

// Describes an Amazon Glacier job.
type JobDescription struct {
	// The job type. It is either ArchiveRetrieval or InventoryRetrieval.
	Action *string `type:"string" enum:"ActionCode"`

	// For an ArchiveRetrieval job, this is the archive ID requested for download.
	// Otherwise, this field is null.
	ArchiveId *string `type:"string"`

	// The SHA256 tree hash of the entire archive for an archive retrieval. For
	// inventory retrieval jobs, this field is null.
	ArchiveSHA256TreeHash *string `type:"string"`

	// For an ArchiveRetrieval job, this is the size in bytes of the archive being
	// requested for download. For the InventoryRetrieval job, the value is null.
	ArchiveSizeInBytes *int64 `type:"long"`

	// The job status. When a job is completed, you get the job's output.
	Completed *bool `type:"boolean"`

	// The UTC time that the archive retrieval request completed. While the job
	// is in progress, the value will be null.
	CompletionDate *string `type:"string"`

	// The UTC date when the job was created. A string representation of ISO 8601
	// date format, for example, "2012-03-20T17:03:43.221Z".
	CreationDate *string `type:"string"`

	// Parameters used for range inventory retrieval.
	InventoryRetrievalParameters *InventoryRetrievalJobDescription `type:"structure"`

	// For an InventoryRetrieval job, this is the size in bytes of the inventory
	// requested for download. For the ArchiveRetrieval job, the value is null.
	InventorySizeInBytes *int64 `type:"long"`

	// The job description you provided when you initiated the job.
	JobDescription *string `type:"string"`

	// An opaque string that identifies an Amazon Glacier job.
	JobId *string `type:"string"`

	// The retrieved byte range for archive retrieval jobs in the form "StartByteValue-EndByteValue"
	// If no range was specified in the archive retrieval, then the whole archive
	// is retrieved and StartByteValue equals 0 and EndByteValue equals the size
	// of the archive minus 1. For inventory retrieval jobs this field is null.
	RetrievalByteRange *string `type:"string"`

	// For an ArchiveRetrieval job, it is the checksum of the archive. Otherwise,
	// the value is null.
	//
	//  The SHA256 tree hash value for the requested range of an archive. If the
	// Initiate a Job request for an archive specified a tree-hash aligned range,
	// then this field returns a value.
	//
	//  For the specific case when the whole archive is retrieved, this value is
	// the same as the ArchiveSHA256TreeHash value.
	//
	//  This field is null in the following situations:  Archive retrieval jobs
	// that specify a range that is not tree-hash aligned.
	//
	//   Archival jobs that specify a range that is equal to the whole archive
	// and the job status is InProgress.
	//
	//   Inventory jobs.
	SHA256TreeHash *string `type:"string"`

	// An Amazon Simple Notification Service (Amazon SNS) topic that receives notification.
	SNSTopic *string `type:"string"`

	// The status code can be InProgress, Succeeded, or Failed, and indicates the
	// status of the job.
	StatusCode *string `type:"string" enum:"StatusCode"`

	// A friendly message that describes the job status.
	StatusMessage *string `type:"string"`

	// The Amazon Resource Name (ARN) of the vault from which the archive retrieval
	// was requested.
	VaultARN *string `type:"string"`

	metadataJobDescription `json:"-" xml:"-"`
}

type metadataJobDescription struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s JobDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobDescription) GoString() string {
	return s.String()
}

// Provides options for defining a job.
type JobParameters struct {
	// The ID of the archive that you want to retrieve. This field is required only
	// if Type is set to archive-retrieval. An error occurs if you specify this
	// request parameter for an inventory retrieval job request.
	ArchiveId *string `type:"string"`

	// The optional description for the job. The description must be less than or
	// equal to 1,024 bytes. The allowable characters are 7-bit ASCII without control
	// codes-specifically, ASCII values 32-126 decimal or 0x20-0x7E hexadecimal.
	Description *string `type:"string"`

	// When initiating a job to retrieve a vault inventory, you can optionally add
	// this parameter to your request to specify the output format. If you are initiating
	// an inventory job and do not specify a Format field, JSON is the default format.
	// Valid values are "CSV" and "JSON".
	Format *string `type:"string"`

	// Input parameters used for range inventory retrieval.
	InventoryRetrievalParameters *InventoryRetrievalJobInput `type:"structure"`

	// The byte range to retrieve for an archive retrieval. in the form "StartByteValue-EndByteValue"
	// If not specified, the whole archive is retrieved. If specified, the byte
	// range must be megabyte (1024*1024) aligned which means that StartByteValue
	// must be divisible by 1 MB and EndByteValue plus 1 must be divisible by 1
	// MB or be the end of the archive specified as the archive byte size value
	// minus 1. If RetrievalByteRange is not megabyte aligned, this operation returns
	// a 400 response.
	//
	// An error occurs if you specify this field for an inventory retrieval job
	// request.
	RetrievalByteRange *string `type:"string"`

	// The Amazon SNS topic ARN to which Amazon Glacier sends a notification when
	// the job is completed and the output is ready for you to download. The specified
	// topic publishes the notification to its subscribers. The SNS topic must exist.
	SNSTopic *string `type:"string"`

	// The job type. You can initiate a job to retrieve an archive or get an inventory
	// of a vault. Valid values are "archive-retrieval" and "inventory-retrieval".
	Type *string `type:"string"`

	metadataJobParameters `json:"-" xml:"-"`
}

type metadataJobParameters struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s JobParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobParameters) GoString() string {
	return s.String()
}

// Provides options for retrieving a job list for an Amazon Glacier vault.
type ListJobsInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// Specifies the state of the jobs to return. You can specify true or false.
	Completed *string `location:"querystring" locationName:"completed" type:"string"`

	// Specifies that the response be limited to the specified number of items or
	// fewer. If not specified, the List Jobs operation returns up to 1,000 jobs.
	Limit *string `location:"querystring" locationName:"limit" type:"string"`

	// An opaque string used for pagination. This value specifies the job at which
	// the listing of jobs should begin. Get the marker value from a previous List
	// Jobs response. You need only include the marker if you are continuing the
	// pagination of results started in a previous List Jobs request.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// Specifies the type of job status to return. You can specify the following
	// values: "InProgress", "Succeeded", or "Failed".
	Statuscode *string `location:"querystring" locationName:"statuscode" type:"string"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataListJobsInput `json:"-" xml:"-"`
}

type metadataListJobsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type ListJobsOutput struct {
	// A list of job objects. Each job object contains metadata describing the job.
	JobList []*JobDescription `type:"list"`

	// An opaque string that represents where to continue pagination of the results.
	// You use this value in a new List Jobs request to obtain more jobs in the
	// list. If there are no more jobs, this value is null.
	Marker *string `type:"string"`

	metadataListJobsOutput `json:"-" xml:"-"`
}

type metadataListJobsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// Provides options for retrieving list of in-progress multipart uploads for
// an Amazon Glacier vault.
type ListMultipartUploadsInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// Specifies the maximum number of uploads returned in the response body. If
	// this value is not specified, the List Uploads operation returns up to 1,000
	// uploads.
	Limit *string `location:"querystring" locationName:"limit" type:"string"`

	// An opaque string used for pagination. This value specifies the upload at
	// which the listing of uploads should begin. Get the marker value from a previous
	// List Uploads response. You need only include the marker if you are continuing
	// the pagination of results started in a previous List Uploads request.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataListMultipartUploadsInput `json:"-" xml:"-"`
}

type metadataListMultipartUploadsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListMultipartUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type ListMultipartUploadsOutput struct {
	// An opaque string that represents where to continue pagination of the results.
	// You use the marker in a new List Multipart Uploads request to obtain more
	// uploads in the list. If there are no more uploads, this value is null.
	Marker *string `type:"string"`

	// A list of in-progress multipart uploads.
	UploadsList []*UploadListElement `type:"list"`

	metadataListMultipartUploadsOutput `json:"-" xml:"-"`
}

type metadataListMultipartUploadsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListMultipartUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListMultipartUploadsOutput) GoString() string {
	return s.String()
}

// Provides options for retrieving a list of parts of an archive that have been
// uploaded in a specific multipart upload.
type ListPartsInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// Specifies the maximum number of parts returned in the response body. If this
	// value is not specified, the List Parts operation returns up to 1,000 uploads.
	Limit *string `location:"querystring" locationName:"limit" type:"string"`

	// An opaque string used for pagination. This value specifies the part at which
	// the listing of parts should begin. Get the marker value from the response
	// of a previous List Parts response. You need only include the marker if you
	// are continuing the pagination of results started in a previous List Parts
	// request.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	// The upload ID of the multipart upload.
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataListPartsInput `json:"-" xml:"-"`
}

type metadataListPartsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListPartsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type ListPartsOutput struct {
	// The description of the archive that was specified in the Initiate Multipart
	// Upload request.
	ArchiveDescription *string `type:"string"`

	// The UTC time at which the multipart upload was initiated.
	CreationDate *string `type:"string"`

	// An opaque string that represents where to continue pagination of the results.
	// You use the marker in a new List Parts request to obtain more jobs in the
	// list. If there are no more parts, this value is null.
	Marker *string `type:"string"`

	// The ID of the upload to which the parts are associated.
	MultipartUploadId *string `type:"string"`

	// The part size in bytes.
	PartSizeInBytes *int64 `type:"long"`

	// A list of the part sizes of the multipart upload.
	Parts []*PartListElement `type:"list"`

	// The Amazon Resource Name (ARN) of the vault to which the multipart upload
	// was initiated.
	VaultARN *string `type:"string"`

	metadataListPartsOutput `json:"-" xml:"-"`
}

type metadataListPartsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPartsOutput) GoString() string {
	return s.String()
}

// The input value for ListTagsForVaultInput.
type ListTagsForVaultInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataListTagsForVaultInput `json:"-" xml:"-"`
}

type metadataListTagsForVaultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTagsForVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForVaultInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type ListTagsForVaultOutput struct {
	// The tags attached to the vault. Each tag is composed of a key and a value.
	Tags map[string]*string `type:"map"`

	metadataListTagsForVaultOutput `json:"-" xml:"-"`
}

type metadataListTagsForVaultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTagsForVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForVaultOutput) GoString() string {
	return s.String()
}

// Provides options to retrieve the vault list owned by the calling user's account.
// The list provides metadata information for each vault.
type ListVaultsInput struct {
	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single apos-apos (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The maximum number of items returned in the response. If you don't specify
	// a value, the List Vaults operation returns up to 1,000 items.
	Limit *string `location:"querystring" locationName:"limit" type:"string"`

	// A string used for pagination. The marker specifies the vault ARN after which
	// the listing of vaults should begin.
	Marker *string `location:"querystring" locationName:"marker" type:"string"`

	metadataListVaultsInput `json:"-" xml:"-"`
}

type metadataListVaultsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVaultsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVaultsInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type ListVaultsOutput struct {
	// The vault ARN at which to continue pagination of the results. You use the
	// marker in another List Vaults request to obtain more vaults in the list.
	Marker *string `type:"string"`

	// List of vaults.
	VaultList []*DescribeVaultOutput `type:"list"`

	metadataListVaultsOutput `json:"-" xml:"-"`
}

type metadataListVaultsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListVaultsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListVaultsOutput) GoString() string {
	return s.String()
}

// A list of the part sizes of the multipart upload.
type PartListElement struct {
	// The byte range of a part, inclusive of the upper value of the range.
	RangeInBytes *string `type:"string"`

	// The SHA256 tree hash value that Amazon Glacier calculated for the part. This
	// field is never null.
	SHA256TreeHash *string `type:"string"`

	metadataPartListElement `json:"-" xml:"-"`
}

type metadataPartListElement struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PartListElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PartListElement) GoString() string {
	return s.String()
}

// The input value for RemoveTagsFromVaultInput.
type RemoveTagsFromVaultInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// A list of tag keys. Each corresponding tag is removed from the vault.
	TagKeys []*string `type:"list"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataRemoveTagsFromVaultInput `json:"-" xml:"-"`
}

type metadataRemoveTagsFromVaultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromVaultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromVaultInput) GoString() string {
	return s.String()
}

type RemoveTagsFromVaultOutput struct {
	metadataRemoveTagsFromVaultOutput `json:"-" xml:"-"`
}

type metadataRemoveTagsFromVaultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsFromVaultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsFromVaultOutput) GoString() string {
	return s.String()
}

// SetDataRetrievalPolicy input.
type SetDataRetrievalPolicyInput struct {
	// The AccountId value is the AWS account ID. This value must match the AWS
	// account ID associated with the credentials used to sign the request. You
	// can either specify an AWS account ID or optionally a single apos-apos (hyphen),
	// in which case Amazon Glacier uses the AWS account ID associated with the
	// credentials used to sign the request. If you specify your account ID, do
	// not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The data retrieval policy in JSON format.
	Policy *DataRetrievalPolicy `type:"structure"`

	metadataSetDataRetrievalPolicyInput `json:"-" xml:"-"`
}

type metadataSetDataRetrievalPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetDataRetrievalPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDataRetrievalPolicyInput) GoString() string {
	return s.String()
}

type SetDataRetrievalPolicyOutput struct {
	metadataSetDataRetrievalPolicyOutput `json:"-" xml:"-"`
}

type metadataSetDataRetrievalPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetDataRetrievalPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetDataRetrievalPolicyOutput) GoString() string {
	return s.String()
}

// SetVaultAccessPolicy input.
type SetVaultAccessPolicyInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The vault access policy as a JSON string.
	Policy *VaultAccessPolicy `locationName:"policy" type:"structure"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataSetVaultAccessPolicyInput `json:"-" xml:"-"`
}

type metadataSetVaultAccessPolicyInput struct {
	SDKShapeTraits bool `type:"structure" payload:"Policy"`
}

// String returns the string representation
func (s SetVaultAccessPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVaultAccessPolicyInput) GoString() string {
	return s.String()
}

type SetVaultAccessPolicyOutput struct {
	metadataSetVaultAccessPolicyOutput `json:"-" xml:"-"`
}

type metadataSetVaultAccessPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetVaultAccessPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVaultAccessPolicyOutput) GoString() string {
	return s.String()
}

// Provides options to configure notifications that will be sent when specific
// events happen to a vault.
type SetVaultNotificationsInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	// Provides options for specifying notification configuration.
	VaultNotificationConfig *VaultNotificationConfig `locationName:"vaultNotificationConfig" type:"structure"`

	metadataSetVaultNotificationsInput `json:"-" xml:"-"`
}

type metadataSetVaultNotificationsInput struct {
	SDKShapeTraits bool `type:"structure" payload:"VaultNotificationConfig"`
}

// String returns the string representation
func (s SetVaultNotificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVaultNotificationsInput) GoString() string {
	return s.String()
}

type SetVaultNotificationsOutput struct {
	metadataSetVaultNotificationsOutput `json:"-" xml:"-"`
}

type metadataSetVaultNotificationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetVaultNotificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVaultNotificationsOutput) GoString() string {
	return s.String()
}

// Provides options to add an archive to a vault.
type UploadArchiveInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The optional description of the archive you are uploading.
	ArchiveDescription *string `location:"header" locationName:"x-amz-archive-description" type:"string"`

	// The data to upload.
	Body io.ReadSeeker `locationName:"body" type:"blob"`

	// The SHA256 tree hash of the data being uploaded.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataUploadArchiveInput `json:"-" xml:"-"`
}

type metadataUploadArchiveInput struct {
	SDKShapeTraits bool `type:"structure" payload:"Body"`
}

// String returns the string representation
func (s UploadArchiveInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadArchiveInput) GoString() string {
	return s.String()
}

// A list of in-progress multipart uploads for a vault.
type UploadListElement struct {
	// The description of the archive that was specified in the Initiate Multipart
	// Upload request.
	ArchiveDescription *string `type:"string"`

	// The UTC time at which the multipart upload was initiated.
	CreationDate *string `type:"string"`

	// The ID of a multipart upload.
	MultipartUploadId *string `type:"string"`

	// The part size, in bytes, specified in the Initiate Multipart Upload request.
	// This is the size of all the parts in the upload except the last part, which
	// may be smaller than this size.
	PartSizeInBytes *int64 `type:"long"`

	// The Amazon Resource Name (ARN) of the vault that contains the archive.
	VaultARN *string `type:"string"`

	metadataUploadListElement `json:"-" xml:"-"`
}

type metadataUploadListElement struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UploadListElement) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadListElement) GoString() string {
	return s.String()
}

// Provides options to upload a part of an archive in a multipart upload operation.
type UploadMultipartPartInput struct {
	// The AccountId value is the AWS account ID of the account that owns the vault.
	// You can either specify an AWS account ID or optionally a single apos-apos
	// (hyphen), in which case Amazon Glacier uses the AWS account ID associated
	// with the credentials used to sign the request. If you use an account ID,
	// do not include any hyphens (apos-apos) in the ID.
	AccountId *string `location:"uri" locationName:"accountId" type:"string" required:"true"`

	// The data to upload.
	Body io.ReadSeeker `locationName:"body" type:"blob"`

	// The SHA256 tree hash of the data being uploaded.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	// Identifies the range of bytes in the assembled archive that will be uploaded
	// in this part. Amazon Glacier uses this information to assemble the archive
	// in the proper sequence. The format of this header follows RFC 2616. An example
	// header is Content-Range:bytes 0-4194303/*.
	Range *string `location:"header" locationName:"Content-Range" type:"string"`

	// The upload ID of the multipart upload.
	UploadId *string `location:"uri" locationName:"uploadId" type:"string" required:"true"`

	// The name of the vault.
	VaultName *string `location:"uri" locationName:"vaultName" type:"string" required:"true"`

	metadataUploadMultipartPartInput `json:"-" xml:"-"`
}

type metadataUploadMultipartPartInput struct {
	SDKShapeTraits bool `type:"structure" payload:"Body"`
}

// String returns the string representation
func (s UploadMultipartPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadMultipartPartInput) GoString() string {
	return s.String()
}

// Contains the Amazon Glacier response to your request.
type UploadMultipartPartOutput struct {
	// The SHA256 tree hash that Amazon Glacier computed for the uploaded part.
	Checksum *string `location:"header" locationName:"x-amz-sha256-tree-hash" type:"string"`

	metadataUploadMultipartPartOutput `json:"-" xml:"-"`
}

type metadataUploadMultipartPartOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UploadMultipartPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadMultipartPartOutput) GoString() string {
	return s.String()
}

// Contains the vault access policy.
type VaultAccessPolicy struct {
	// The vault access policy.
	Policy *string `type:"string"`

	metadataVaultAccessPolicy `json:"-" xml:"-"`
}

type metadataVaultAccessPolicy struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VaultAccessPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VaultAccessPolicy) GoString() string {
	return s.String()
}

// Contains the vault lock policy.
type VaultLockPolicy struct {
	// The vault lock policy.
	Policy *string `type:"string"`

	metadataVaultLockPolicy `json:"-" xml:"-"`
}

type metadataVaultLockPolicy struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VaultLockPolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VaultLockPolicy) GoString() string {
	return s.String()
}

// Represents a vault's notification configuration.
type VaultNotificationConfig struct {
	// A list of one or more events for which Amazon Glacier will send a notification
	// to the specified Amazon SNS topic.
	Events []*string `type:"list"`

	// The Amazon Simple Notification Service (Amazon SNS) topic Amazon Resource
	// Name (ARN).
	SNSTopic *string `type:"string"`

	metadataVaultNotificationConfig `json:"-" xml:"-"`
}

type metadataVaultNotificationConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VaultNotificationConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VaultNotificationConfig) GoString() string {
	return s.String()
}

const (
	// @enum ActionCode
	ActionCodeArchiveRetrieval = "ArchiveRetrieval"
	// @enum ActionCode
	ActionCodeInventoryRetrieval = "InventoryRetrieval"
)

const (
	// @enum StatusCode
	StatusCodeInProgress = "InProgress"
	// @enum StatusCode
	StatusCodeSucceeded = "Succeeded"
	// @enum StatusCode
	StatusCodeFailed = "Failed"
)
