// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package emr provides a client for Amazon Elastic MapReduce.
package emr

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAddInstanceGroups = "AddInstanceGroups"

// AddInstanceGroupsRequest generates a request for the AddInstanceGroups operation.
func (c *EMR) AddInstanceGroupsRequest(input *AddInstanceGroupsInput) (req *request.Request, output *AddInstanceGroupsOutput) {
	op := &request.Operation{
		Name:       opAddInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddInstanceGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddInstanceGroupsOutput{}
	req.Data = output
	return
}

// AddInstanceGroups adds an instance group to a running cluster.
func (c *EMR) AddInstanceGroups(input *AddInstanceGroupsInput) (*AddInstanceGroupsOutput, error) {
	req, out := c.AddInstanceGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opAddJobFlowSteps = "AddJobFlowSteps"

// AddJobFlowStepsRequest generates a request for the AddJobFlowSteps operation.
func (c *EMR) AddJobFlowStepsRequest(input *AddJobFlowStepsInput) (req *request.Request, output *AddJobFlowStepsOutput) {
	op := &request.Operation{
		Name:       opAddJobFlowSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddJobFlowStepsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddJobFlowStepsOutput{}
	req.Data = output
	return
}

// AddJobFlowSteps adds new steps to a running job flow. A maximum of 256 steps
// are allowed in each job flow.
//
// If your job flow is long-running (such as a Hive data warehouse) or complex,
// you may require more than 256 steps to process your data. You can bypass
// the 256-step limitation in various ways, including using the SSH shell to
// connect to the master node and submitting queries directly to the software
// running on the master node, such as Hive and Hadoop. For more information
// on how to do this, go to Add More than 256 Steps to a Job Flow (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/AddMoreThan256Steps.html)
// in the Amazon Elastic MapReduce Developer's Guide.
//
//  A step specifies the location of a JAR file stored either on the master
// node of the job flow or in Amazon S3. Each step is performed by the main
// function of the main class of the JAR file. The main class can be specified
// either in the manifest of the JAR or by using the MainFunction parameter
// of the step.
//
//  Elastic MapReduce executes each step in the order listed. For a step to
// be considered complete, the main function must exit with a zero exit code
// and all Hadoop jobs started while the step was running must have completed
// and run successfully.
//
//  You can only add steps to a job flow that is in one of the following states:
// STARTING, BOOTSTRAPPING, RUNNING, or WAITING.
func (c *EMR) AddJobFlowSteps(input *AddJobFlowStepsInput) (*AddJobFlowStepsOutput, error) {
	req, out := c.AddJobFlowStepsRequest(input)
	err := req.Send()
	return out, err
}

const opAddTags = "AddTags"

// AddTagsRequest generates a request for the AddTags operation.
func (c *EMR) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AddTagsOutput{}
	req.Data = output
	return
}

// Adds tags to an Amazon EMR resource. Tags make it easier to associate clusters
// in various ways, such as grouping clusters to track your Amazon EMR resource
// allocation costs. For more information, see Tagging Amazon EMR Resources
// (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-plan-tags.html).
func (c *EMR) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeCluster = "DescribeCluster"

// DescribeClusterRequest generates a request for the DescribeCluster operation.
func (c *EMR) DescribeClusterRequest(input *DescribeClusterInput) (req *request.Request, output *DescribeClusterOutput) {
	op := &request.Operation{
		Name:       opDescribeCluster,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClusterInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeClusterOutput{}
	req.Data = output
	return
}

// Provides cluster-level details including status, hardware and software configuration,
// VPC settings, and so on. For information about the cluster steps, see ListSteps.
func (c *EMR) DescribeCluster(input *DescribeClusterInput) (*DescribeClusterOutput, error) {
	req, out := c.DescribeClusterRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeJobFlows = "DescribeJobFlows"

// DescribeJobFlowsRequest generates a request for the DescribeJobFlows operation.
func (c *EMR) DescribeJobFlowsRequest(input *DescribeJobFlowsInput) (req *request.Request, output *DescribeJobFlowsOutput) {
	op := &request.Operation{
		Name:       opDescribeJobFlows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeJobFlowsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeJobFlowsOutput{}
	req.Data = output
	return
}

// This API is deprecated and will eventually be removed. We recommend you use
// ListClusters, DescribeCluster, ListSteps, ListInstanceGroups and ListBootstrapActions
// instead.
//
//  DescribeJobFlows returns a list of job flows that match all of the supplied
// parameters. The parameters can include a list of job flow IDs, job flow states,
// and restrictions on job flow creation date and time.
//
//  Regardless of supplied parameters, only job flows created within the last
// two months are returned.
//
//  If no parameters are supplied, then job flows matching either of the following
// criteria are returned:
//
//  Job flows created and completed in the last two weeks  Job flows created
// within the last two months that are in one of the following states: RUNNING,
// WAITING, SHUTTING_DOWN, STARTING    Amazon Elastic MapReduce can return a
// maximum of 512 job flow descriptions.
func (c *EMR) DescribeJobFlows(input *DescribeJobFlowsInput) (*DescribeJobFlowsOutput, error) {
	req, out := c.DescribeJobFlowsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStep = "DescribeStep"

// DescribeStepRequest generates a request for the DescribeStep operation.
func (c *EMR) DescribeStepRequest(input *DescribeStepInput) (req *request.Request, output *DescribeStepOutput) {
	op := &request.Operation{
		Name:       opDescribeStep,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStepInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStepOutput{}
	req.Data = output
	return
}

// Provides more detail about the cluster step.
func (c *EMR) DescribeStep(input *DescribeStepInput) (*DescribeStepOutput, error) {
	req, out := c.DescribeStepRequest(input)
	err := req.Send()
	return out, err
}

const opListBootstrapActions = "ListBootstrapActions"

// ListBootstrapActionsRequest generates a request for the ListBootstrapActions operation.
func (c *EMR) ListBootstrapActionsRequest(input *ListBootstrapActionsInput) (req *request.Request, output *ListBootstrapActionsOutput) {
	op := &request.Operation{
		Name:       opListBootstrapActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBootstrapActionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListBootstrapActionsOutput{}
	req.Data = output
	return
}

// Provides information about the bootstrap actions associated with a cluster.
func (c *EMR) ListBootstrapActions(input *ListBootstrapActionsInput) (*ListBootstrapActionsOutput, error) {
	req, out := c.ListBootstrapActionsRequest(input)
	err := req.Send()
	return out, err
}

func (c *EMR) ListBootstrapActionsPages(input *ListBootstrapActionsInput, fn func(p *ListBootstrapActionsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListBootstrapActionsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListBootstrapActionsOutput), lastPage)
	})
}

const opListClusters = "ListClusters"

// ListClustersRequest generates a request for the ListClusters operation.
func (c *EMR) ListClustersRequest(input *ListClustersInput) (req *request.Request, output *ListClustersOutput) {
	op := &request.Operation{
		Name:       opListClusters,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListClustersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListClustersOutput{}
	req.Data = output
	return
}

// Provides the status of all clusters visible to this AWS account. Allows you
// to filter the list of clusters based on certain criteria; for example, filtering
// by cluster creation date and time or by status. This call returns a maximum
// of 50 clusters per call, but returns a marker to track the paging of the
// cluster list across multiple ListClusters calls.
func (c *EMR) ListClusters(input *ListClustersInput) (*ListClustersOutput, error) {
	req, out := c.ListClustersRequest(input)
	err := req.Send()
	return out, err
}

func (c *EMR) ListClustersPages(input *ListClustersInput, fn func(p *ListClustersOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListClustersRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListClustersOutput), lastPage)
	})
}

const opListInstanceGroups = "ListInstanceGroups"

// ListInstanceGroupsRequest generates a request for the ListInstanceGroups operation.
func (c *EMR) ListInstanceGroupsRequest(input *ListInstanceGroupsInput) (req *request.Request, output *ListInstanceGroupsOutput) {
	op := &request.Operation{
		Name:       opListInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstanceGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListInstanceGroupsOutput{}
	req.Data = output
	return
}

// Provides all available details about the instance groups in a cluster.
func (c *EMR) ListInstanceGroups(input *ListInstanceGroupsInput) (*ListInstanceGroupsOutput, error) {
	req, out := c.ListInstanceGroupsRequest(input)
	err := req.Send()
	return out, err
}

func (c *EMR) ListInstanceGroupsPages(input *ListInstanceGroupsInput, fn func(p *ListInstanceGroupsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListInstanceGroupsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListInstanceGroupsOutput), lastPage)
	})
}

const opListInstances = "ListInstances"

// ListInstancesRequest generates a request for the ListInstances operation.
func (c *EMR) ListInstancesRequest(input *ListInstancesInput) (req *request.Request, output *ListInstancesOutput) {
	op := &request.Operation{
		Name:       opListInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListInstancesOutput{}
	req.Data = output
	return
}

// Provides information about the cluster instances that Amazon EMR provisions
// on behalf of a user when it creates the cluster. For example, this operation
// indicates when the EC2 instances reach the Ready state, when instances become
// available to Amazon EMR to use for jobs, and the IP addresses for cluster
// instances, etc.
func (c *EMR) ListInstances(input *ListInstancesInput) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	err := req.Send()
	return out, err
}

func (c *EMR) ListInstancesPages(input *ListInstancesInput, fn func(p *ListInstancesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListInstancesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListInstancesOutput), lastPage)
	})
}

const opListSteps = "ListSteps"

// ListStepsRequest generates a request for the ListSteps operation.
func (c *EMR) ListStepsRequest(input *ListStepsInput) (req *request.Request, output *ListStepsOutput) {
	op := &request.Operation{
		Name:       opListSteps,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStepsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListStepsOutput{}
	req.Data = output
	return
}

// Provides a list of steps for the cluster.
func (c *EMR) ListSteps(input *ListStepsInput) (*ListStepsOutput, error) {
	req, out := c.ListStepsRequest(input)
	err := req.Send()
	return out, err
}

func (c *EMR) ListStepsPages(input *ListStepsInput, fn func(p *ListStepsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListStepsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListStepsOutput), lastPage)
	})
}

const opModifyInstanceGroups = "ModifyInstanceGroups"

// ModifyInstanceGroupsRequest generates a request for the ModifyInstanceGroups operation.
func (c *EMR) ModifyInstanceGroupsRequest(input *ModifyInstanceGroupsInput) (req *request.Request, output *ModifyInstanceGroupsOutput) {
	op := &request.Operation{
		Name:       opModifyInstanceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceGroupsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ModifyInstanceGroupsOutput{}
	req.Data = output
	return
}

// ModifyInstanceGroups modifies the number of nodes and configuration settings
// of an instance group. The input parameters include the new target instance
// count for the group and the instance group ID. The call will either succeed
// or fail atomically.
func (c *EMR) ModifyInstanceGroups(input *ModifyInstanceGroupsInput) (*ModifyInstanceGroupsOutput, error) {
	req, out := c.ModifyInstanceGroupsRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a request for the RemoveTags operation.
func (c *EMR) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RemoveTagsOutput{}
	req.Data = output
	return
}

// Removes tags from an Amazon EMR resource. Tags make it easier to associate
// clusters in various ways, such as grouping clusters to track your Amazon
// EMR resource allocation costs. For more information, see Tagging Amazon EMR
// Resources (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-plan-tags.html).
//
// The following example removes the stack tag with value Prod from a cluster:
func (c *EMR) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	err := req.Send()
	return out, err
}

const opRunJobFlow = "RunJobFlow"

// RunJobFlowRequest generates a request for the RunJobFlow operation.
func (c *EMR) RunJobFlowRequest(input *RunJobFlowInput) (req *request.Request, output *RunJobFlowOutput) {
	op := &request.Operation{
		Name:       opRunJobFlow,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RunJobFlowInput{}
	}

	req = c.newRequest(op, input, output)
	output = &RunJobFlowOutput{}
	req.Data = output
	return
}

// RunJobFlow creates and starts running a new job flow. The job flow will run
// the steps specified. Once the job flow completes, the cluster is stopped
// and the HDFS partition is lost. To prevent loss of data, configure the last
// step of the job flow to store results in Amazon S3. If the JobFlowInstancesConfig
// KeepJobFlowAliveWhenNoSteps parameter is set to TRUE, the job flow will transition
// to the WAITING state rather than shutting down once the steps have completed.
//
// For additional protection, you can set the JobFlowInstancesConfig TerminationProtected
// parameter to TRUE to lock the job flow and prevent it from being terminated
// by API call, user intervention, or in the event of a job flow error.
//
// A maximum of 256 steps are allowed in each job flow.
//
// If your job flow is long-running (such as a Hive data warehouse) or complex,
// you may require more than 256 steps to process your data. You can bypass
// the 256-step limitation in various ways, including using the SSH shell to
// connect to the master node and submitting queries directly to the software
// running on the master node, such as Hive and Hadoop. For more information
// on how to do this, go to Add More than 256 Steps to a Job Flow (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/AddMoreThan256Steps.html)
// in the Amazon Elastic MapReduce Developer's Guide.
//
// For long running job flows, we recommend that you periodically store your
// results.
func (c *EMR) RunJobFlow(input *RunJobFlowInput) (*RunJobFlowOutput, error) {
	req, out := c.RunJobFlowRequest(input)
	err := req.Send()
	return out, err
}

const opSetTerminationProtection = "SetTerminationProtection"

// SetTerminationProtectionRequest generates a request for the SetTerminationProtection operation.
func (c *EMR) SetTerminationProtectionRequest(input *SetTerminationProtectionInput) (req *request.Request, output *SetTerminationProtectionOutput) {
	op := &request.Operation{
		Name:       opSetTerminationProtection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetTerminationProtectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetTerminationProtectionOutput{}
	req.Data = output
	return
}

// SetTerminationProtection locks a job flow so the Amazon EC2 instances in
// the cluster cannot be terminated by user intervention, an API call, or in
// the event of a job-flow error. The cluster still terminates upon successful
// completion of the job flow. Calling SetTerminationProtection on a job flow
// is analogous to calling the Amazon EC2 DisableAPITermination API on all of
// the EC2 instances in a cluster.
//
//  SetTerminationProtection is used to prevent accidental termination of a
// job flow and to ensure that in the event of an error, the instances will
// persist so you can recover any data stored in their ephemeral instance storage.
//
//  To terminate a job flow that has been locked by setting SetTerminationProtection
// to true, you must first unlock the job flow by a subsequent call to SetTerminationProtection
// in which you set the value to false.
//
//  For more information, go to Protecting a Job Flow from Termination (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/UsingEMR_TerminationProtection.html)
// in the Amazon Elastic MapReduce Developer's Guide.
func (c *EMR) SetTerminationProtection(input *SetTerminationProtectionInput) (*SetTerminationProtectionOutput, error) {
	req, out := c.SetTerminationProtectionRequest(input)
	err := req.Send()
	return out, err
}

const opSetVisibleToAllUsers = "SetVisibleToAllUsers"

// SetVisibleToAllUsersRequest generates a request for the SetVisibleToAllUsers operation.
func (c *EMR) SetVisibleToAllUsersRequest(input *SetVisibleToAllUsersInput) (req *request.Request, output *SetVisibleToAllUsersOutput) {
	op := &request.Operation{
		Name:       opSetVisibleToAllUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetVisibleToAllUsersInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetVisibleToAllUsersOutput{}
	req.Data = output
	return
}

// Sets whether all AWS Identity and Access Management (IAM) users under your
// account can access the specified job flows. This action works on running
// job flows. You can also set the visibility of a job flow when you launch
// it using the VisibleToAllUsers parameter of RunJobFlow. The SetVisibleToAllUsers
// action can be called only by an IAM user who created the job flow or the
// AWS account that owns the job flow.
func (c *EMR) SetVisibleToAllUsers(input *SetVisibleToAllUsersInput) (*SetVisibleToAllUsersOutput, error) {
	req, out := c.SetVisibleToAllUsersRequest(input)
	err := req.Send()
	return out, err
}

const opTerminateJobFlows = "TerminateJobFlows"

// TerminateJobFlowsRequest generates a request for the TerminateJobFlows operation.
func (c *EMR) TerminateJobFlowsRequest(input *TerminateJobFlowsInput) (req *request.Request, output *TerminateJobFlowsOutput) {
	op := &request.Operation{
		Name:       opTerminateJobFlows,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateJobFlowsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &TerminateJobFlowsOutput{}
	req.Data = output
	return
}

// TerminateJobFlows shuts a list of job flows down. When a job flow is shut
// down, any step not yet completed is canceled and the EC2 instances on which
// the job flow is running are stopped. Any log files not already saved are
// uploaded to Amazon S3 if a LogUri was specified when the job flow was created.
//
//  The maximum number of JobFlows allowed is 10. The call to TerminateJobFlows
// is asynchronous. Depending on the configuration of the job flow, it may take
// up to 5-20 minutes for the job flow to completely terminate and release allocated
// resources, such as Amazon EC2 instances.
func (c *EMR) TerminateJobFlows(input *TerminateJobFlowsInput) (*TerminateJobFlowsOutput, error) {
	req, out := c.TerminateJobFlowsRequest(input)
	err := req.Send()
	return out, err
}

// Input to an AddInstanceGroups call.
type AddInstanceGroupsInput struct {
	// Instance Groups to add.
	InstanceGroups []*InstanceGroupConfig `type:"list" required:"true"`

	// Job flow in which to add the instance groups.
	JobFlowId *string `type:"string" required:"true"`

	metadataAddInstanceGroupsInput `json:"-" xml:"-"`
}

type metadataAddInstanceGroupsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddInstanceGroupsInput) GoString() string {
	return s.String()
}

// Output from an AddInstanceGroups call.
type AddInstanceGroupsOutput struct {
	// Instance group IDs of the newly created instance groups.
	InstanceGroupIds []*string `type:"list"`

	// The job flow ID in which the instance groups are added.
	JobFlowId *string `type:"string"`

	metadataAddInstanceGroupsOutput `json:"-" xml:"-"`
}

type metadataAddInstanceGroupsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddInstanceGroupsOutput) GoString() string {
	return s.String()
}

// The input argument to the AddJobFlowSteps operation.
type AddJobFlowStepsInput struct {
	// A string that uniquely identifies the job flow. This identifier is returned
	// by RunJobFlow and can also be obtained from ListClusters.
	JobFlowId *string `type:"string" required:"true"`

	// A list of StepConfig to be executed by the job flow.
	Steps []*StepConfig `type:"list" required:"true"`

	metadataAddJobFlowStepsInput `json:"-" xml:"-"`
}

type metadataAddJobFlowStepsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddJobFlowStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddJobFlowStepsInput) GoString() string {
	return s.String()
}

// The output for the AddJobFlowSteps operation.
type AddJobFlowStepsOutput struct {
	// The identifiers of the list of steps added to the job flow.
	StepIds []*string `type:"list"`

	metadataAddJobFlowStepsOutput `json:"-" xml:"-"`
}

type metadataAddJobFlowStepsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddJobFlowStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddJobFlowStepsOutput) GoString() string {
	return s.String()
}

// This input identifies a cluster and a list of tags to attach.
type AddTagsInput struct {
	// The Amazon EMR resource identifier to which tags will be added. This value
	// must be a cluster identifier.
	ResourceId *string `type:"string" required:"true"`

	// A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
	// Tags are user-defined key/value pairs that consist of a required key string
	// with a maximum of 128 characters, and an optional value string with a maximum
	// of 256 characters.
	Tags []*Tag `type:"list" required:"true"`

	metadataAddTagsInput `json:"-" xml:"-"`
}

type metadataAddTagsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// This output indicates the result of adding tags to a resource.
type AddTagsOutput struct {
	metadataAddTagsOutput `json:"-" xml:"-"`
}

type metadataAddTagsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// An application is any Amazon or third-party software that you can add to
// the cluster. This structure contains a list of strings that indicates the
// software to use with the cluster and accepts a user argument list. Amazon
// EMR accepts and forwards the argument list to the corresponding installation
// script as bootstrap action argument. For more information, see Launch a Job
// Flow on the MapR Distribution for Hadoop (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-mapr.html).
// Currently supported values are:
//
//  "mapr-m3" - launch the job flow using MapR M3 Edition. "mapr-m5" - launch
// the job flow using MapR M5 Edition. "mapr" with the user arguments specifying
// "--edition,m3" or "--edition,m5" - launch the job flow using MapR M3 or M5
// Edition, respectively.  In Amazon EMR releases 4.0 and greater, the only
// accepted parameter is the application name. To pass arguments to applications,
// you supply a configuration for each application.
type Application struct {
	// This option is for advanced users only. This is meta information about third-party
	// applications that third-party vendors use for testing purposes.
	AdditionalInfo map[string]*string `type:"map"`

	// Arguments for Amazon EMR to pass to the application.
	Args []*string `type:"list"`

	// The name of the application.
	Name *string `type:"string"`

	// The version of the application.
	Version *string `type:"string"`

	metadataApplication `json:"-" xml:"-"`
}

type metadataApplication struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Application) GoString() string {
	return s.String()
}

// Configuration of a bootstrap action.
type BootstrapActionConfig struct {
	// The name of the bootstrap action.
	Name *string `type:"string" required:"true"`

	// The script run by the bootstrap action.
	ScriptBootstrapAction *ScriptBootstrapActionConfig `type:"structure" required:"true"`

	metadataBootstrapActionConfig `json:"-" xml:"-"`
}

type metadataBootstrapActionConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BootstrapActionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BootstrapActionConfig) GoString() string {
	return s.String()
}

// Reports the configuration of a bootstrap action in a job flow.
type BootstrapActionDetail struct {
	// A description of the bootstrap action.
	BootstrapActionConfig *BootstrapActionConfig `type:"structure"`

	metadataBootstrapActionDetail `json:"-" xml:"-"`
}

type metadataBootstrapActionDetail struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BootstrapActionDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BootstrapActionDetail) GoString() string {
	return s.String()
}

// The detailed description of the cluster.
type Cluster struct {
	// The applications installed on this cluster.
	Applications []*Application `type:"list"`

	// Specifies whether the cluster should terminate after completing all steps.
	AutoTerminate *bool `type:"boolean"`

	// Amazon EMR releases 4.x or later.
	//
	// The list of Configurations supplied to the EMR cluster.
	Configurations []*Configuration `type:"list"`

	// Provides information about the EC2 instances in a cluster grouped by category.
	// For example, key name, subnet ID, IAM instance profile, and so on.
	Ec2InstanceAttributes *Ec2InstanceAttributes `type:"structure"`

	// The unique identifier for the cluster.
	Id *string `type:"string"`

	// The path to the Amazon S3 location where logs for this cluster are stored.
	LogUri *string `type:"string"`

	// The public DNS name of the master EC2 instance.
	MasterPublicDnsName *string `type:"string"`

	// The name of the cluster.
	Name *string `type:"string"`

	// An approximation of the cost of the job flow, represented in m1.small/hours.
	// This value is incremented one time for every hour an m1.small instance runs.
	// Larger instances are weighted more, so an EC2 instance that is roughly four
	// times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The release label for the Amazon EMR release. For Amazon EMR 3.x and 2.x
	// AMIs, use amiVersion instead instead of ReleaseLabel.
	ReleaseLabel *string `type:"string"`

	// The AMI version requested for this cluster.
	RequestedAmiVersion *string `type:"string"`

	// The AMI version running on this cluster.
	RunningAmiVersion *string `type:"string"`

	// The IAM role that will be assumed by the Amazon EMR service to access AWS
	// resources on your behalf.
	ServiceRole *string `type:"string"`

	// The current status details about the cluster.
	Status *ClusterStatus `type:"structure"`

	// A list of tags associated with a cluster.
	Tags []*Tag `type:"list"`

	// Indicates whether Amazon EMR will lock the cluster to prevent the EC2 instances
	// from being terminated by an API call or user intervention, or in the event
	// of a cluster error.
	TerminationProtected *bool `type:"boolean"`

	// Indicates whether the job flow is visible to all IAM users of the AWS account
	// associated with the job flow. If this value is set to true, all IAM users
	// of that AWS account can view and manage the job flow if they have the proper
	// policy permissions set. If this value is false, only the IAM user that created
	// the cluster can view and manage it. This value can be changed using the SetVisibleToAllUsers
	// action.
	VisibleToAllUsers *bool `type:"boolean"`

	metadataCluster `json:"-" xml:"-"`
}

type metadataCluster struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Cluster) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Cluster) GoString() string {
	return s.String()
}

// The reason that the cluster changed to its current state.
type ClusterStateChangeReason struct {
	// The programmatic code for the state change reason.
	Code *string `type:"string" enum:"ClusterStateChangeReasonCode"`

	// The descriptive message for the state change reason.
	Message *string `type:"string"`

	metadataClusterStateChangeReason `json:"-" xml:"-"`
}

type metadataClusterStateChangeReason struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ClusterStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterStateChangeReason) GoString() string {
	return s.String()
}

// The detailed status of the cluster.
type ClusterStatus struct {
	// The current state of the cluster.
	State *string `type:"string" enum:"ClusterState"`

	// The reason for the cluster status change.
	StateChangeReason *ClusterStateChangeReason `type:"structure"`

	// A timeline that represents the status of a cluster over the lifetime of the
	// cluster.
	Timeline *ClusterTimeline `type:"structure"`

	metadataClusterStatus `json:"-" xml:"-"`
}

type metadataClusterStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ClusterStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterStatus) GoString() string {
	return s.String()
}

// The summary description of the cluster.
type ClusterSummary struct {
	// The unique identifier for the cluster.
	Id *string `type:"string"`

	// The name of the cluster.
	Name *string `type:"string"`

	// An approximation of the cost of the job flow, represented in m1.small/hours.
	// This value is incremented one time for every hour an m1.small instance runs.
	// Larger instances are weighted more, so an EC2 instance that is roughly four
	// times more expensive would result in the normalized instance hours being
	// incremented by four. This result is only an approximation and does not reflect
	// the actual billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The details about the current status of the cluster.
	Status *ClusterStatus `type:"structure"`

	metadataClusterSummary `json:"-" xml:"-"`
}

type metadataClusterSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ClusterSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterSummary) GoString() string {
	return s.String()
}

// Represents the timeline of the cluster's lifecycle.
type ClusterTimeline struct {
	// The creation date and time of the cluster.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the cluster was terminated.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the cluster was ready to execute steps.
	ReadyDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	metadataClusterTimeline `json:"-" xml:"-"`
}

type metadataClusterTimeline struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ClusterTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ClusterTimeline) GoString() string {
	return s.String()
}

// An entity describing an executable that runs on a cluster.
type Command struct {
	// Arguments for Amazon EMR to pass to the command for execution.
	Args []*string `type:"list"`

	// The name of the command.
	Name *string `type:"string"`

	// The Amazon S3 location of the command script.
	ScriptPath *string `type:"string"`

	metadataCommand `json:"-" xml:"-"`
}

type metadataCommand struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Command) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Command) GoString() string {
	return s.String()
}

// Amazon EMR releases 4.x or later.
//
// Specifies a hardware and software configuration of the EMR cluster. This
// includes configurations for applications and software bundled with Amazon
// EMR. The Configuration object is a JSON object which is defined by a classification
// and a set of properties. Configurations can be nested, so a configuration
// may have its own Configuration objects listed.
type Configuration struct {
	// The classification of a configuration. For more information see, Amazon EMR
	// Configurations (http://docs.aws.amazon.com/ElasticMapReduce/latest/API/EmrConfigurations.html).
	Classification *string `type:"string"`

	// A list of configurations you apply to this configuration object.
	Configurations []*Configuration `type:"list"`

	// A set of properties supplied to the Configuration object.
	Properties map[string]*string `type:"map"`

	metadataConfiguration `json:"-" xml:"-"`
}

type metadataConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Configuration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Configuration) GoString() string {
	return s.String()
}

// This input determines which cluster to describe.
type DescribeClusterInput struct {
	// The identifier of the cluster to describe.
	ClusterId *string `type:"string" required:"true"`

	metadataDescribeClusterInput `json:"-" xml:"-"`
}

type metadataDescribeClusterInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeClusterInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterInput) GoString() string {
	return s.String()
}

// This output contains the description of the cluster.
type DescribeClusterOutput struct {
	// This output contains the details for the requested cluster.
	Cluster *Cluster `type:"structure"`

	metadataDescribeClusterOutput `json:"-" xml:"-"`
}

type metadataDescribeClusterOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeClusterOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeClusterOutput) GoString() string {
	return s.String()
}

// The input for the DescribeJobFlows operation.
type DescribeJobFlowsInput struct {
	// Return only job flows created after this date and time.
	CreatedAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Return only job flows created before this date and time.
	CreatedBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Return only job flows whose job flow ID is contained in this list.
	JobFlowIds []*string `type:"list"`

	// Return only job flows whose state is contained in this list.
	JobFlowStates []*string `type:"list"`

	metadataDescribeJobFlowsInput `json:"-" xml:"-"`
}

type metadataDescribeJobFlowsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeJobFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobFlowsInput) GoString() string {
	return s.String()
}

// The output for the DescribeJobFlows operation.
type DescribeJobFlowsOutput struct {
	// A list of job flows matching the parameters supplied.
	JobFlows []*JobFlowDetail `type:"list"`

	metadataDescribeJobFlowsOutput `json:"-" xml:"-"`
}

type metadataDescribeJobFlowsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeJobFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeJobFlowsOutput) GoString() string {
	return s.String()
}

// This input determines which step to describe.
type DescribeStepInput struct {
	// The identifier of the cluster with steps to describe.
	ClusterId *string `type:"string" required:"true"`

	// The identifier of the step to describe.
	StepId *string `type:"string" required:"true"`

	metadataDescribeStepInput `json:"-" xml:"-"`
}

type metadataDescribeStepInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStepInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStepInput) GoString() string {
	return s.String()
}

// This output contains the description of the cluster step.
type DescribeStepOutput struct {
	// The step details for the requested step identifier.
	Step *Step `type:"structure"`

	metadataDescribeStepOutput `json:"-" xml:"-"`
}

type metadataDescribeStepOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStepOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStepOutput) GoString() string {
	return s.String()
}

// Provides information about the EC2 instances in a cluster grouped by category.
// For example, key name, subnet ID, IAM instance profile, and so on.
type Ec2InstanceAttributes struct {
	// A list of additional Amazon EC2 security group IDs for the master node.
	AdditionalMasterSecurityGroups []*string `type:"list"`

	// A list of additional Amazon EC2 security group IDs for the slave nodes.
	AdditionalSlaveSecurityGroups []*string `type:"list"`

	// The Availability Zone in which the cluster will run.
	Ec2AvailabilityZone *string `type:"string"`

	// The name of the Amazon EC2 key pair to use when connecting with SSH into
	// the master node as a user named "hadoop".
	Ec2KeyName *string `type:"string"`

	// To launch the job flow in Amazon VPC, set this parameter to the identifier
	// of the Amazon VPC subnet where you want the job flow to launch. If you do
	// not specify this value, the job flow is launched in the normal AWS cloud,
	// outside of a VPC.
	//
	//  Amazon VPC currently does not support cluster compute quadruple extra large
	// (cc1.4xlarge) instances. Thus, you cannot specify the cc1.4xlarge instance
	// type for nodes of a job flow launched in a VPC.
	Ec2SubnetId *string `type:"string"`

	// The identifier of the Amazon EC2 security group (managed by Amazon Elastic
	// MapReduce) for the master node.
	EmrManagedMasterSecurityGroup *string `type:"string"`

	// The identifier of the Amazon EC2 security group (managed by Amazon Elastic
	// MapReduce) for the slave nodes.
	EmrManagedSlaveSecurityGroup *string `type:"string"`

	// The IAM role that was specified when the job flow was launched. The EC2 instances
	// of the job flow assume this role.
	IamInstanceProfile *string `type:"string"`

	metadataEc2InstanceAttributes `json:"-" xml:"-"`
}

type metadataEc2InstanceAttributes struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Ec2InstanceAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Ec2InstanceAttributes) GoString() string {
	return s.String()
}

// A job flow step consisting of a JAR file whose main function will be executed.
// The main function submits a job for Hadoop to execute and waits for the job
// to finish or fail.
type HadoopJarStepConfig struct {
	// A list of command line arguments passed to the JAR file's main function when
	// executed.
	Args []*string `type:"list"`

	// A path to a JAR file run during the step.
	Jar *string `type:"string" required:"true"`

	// The name of the main class in the specified Java file. If not specified,
	// the JAR file should specify a Main-Class in its manifest file.
	MainClass *string `type:"string"`

	// A list of Java properties that are set when the step runs. You can use these
	// properties to pass key value pairs to your main function.
	Properties []*KeyValue `type:"list"`

	metadataHadoopJarStepConfig `json:"-" xml:"-"`
}

type metadataHadoopJarStepConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s HadoopJarStepConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HadoopJarStepConfig) GoString() string {
	return s.String()
}

// A cluster step consisting of a JAR file whose main function will be executed.
// The main function submits a job for Hadoop to execute and waits for the job
// to finish or fail.
type HadoopStepConfig struct {
	// The list of command line arguments to pass to the JAR file's main function
	// for execution.
	Args []*string `type:"list"`

	// The path to the JAR file that runs during the step.
	Jar *string `type:"string"`

	// The name of the main class in the specified Java file. If not specified,
	// the JAR file should specify a main class in its manifest file.
	MainClass *string `type:"string"`

	// The list of Java properties that are set when the step runs. You can use
	// these properties to pass key value pairs to your main function.
	Properties map[string]*string `type:"map"`

	metadataHadoopStepConfig `json:"-" xml:"-"`
}

type metadataHadoopStepConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s HadoopStepConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HadoopStepConfig) GoString() string {
	return s.String()
}

// Represents an EC2 instance provisioned as part of cluster.
type Instance struct {
	// The unique identifier of the instance in Amazon EC2.
	Ec2InstanceId *string `type:"string"`

	// The unique identifier for the instance in Amazon EMR.
	Id *string `type:"string"`

	// The private DNS name of the instance.
	PrivateDnsName *string `type:"string"`

	// The private IP address of the instance.
	PrivateIpAddress *string `type:"string"`

	// The public DNS name of the instance.
	PublicDnsName *string `type:"string"`

	// The public IP address of the instance.
	PublicIpAddress *string `type:"string"`

	// The current status of the instance.
	Status *InstanceStatus `type:"structure"`

	metadataInstance `json:"-" xml:"-"`
}

type metadataInstance struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Instance) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Instance) GoString() string {
	return s.String()
}

// This entity represents an instance group, which is a group of instances that
// have common purpose. For example, CORE instance group is used for HDFS.
type InstanceGroup struct {
	// The bid price for each EC2 instance in the instance group when launching
	// nodes as Spot Instances, expressed in USD.
	BidPrice *string `type:"string"`

	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for an EMR cluster instance group. You
	// can specify a separate configuration for each instance group (master, core,
	// and task).
	Configurations []*Configuration `type:"list"`

	// The identifier of the instance group.
	Id *string `type:"string"`

	// The type of the instance group. Valid values are MASTER, CORE or TASK.
	InstanceGroupType *string `type:"string" enum:"InstanceGroupType"`

	// The EC2 instance type for all instances in the instance group.
	InstanceType *string `min:"1" type:"string"`

	// The marketplace to provision instances for this group. Valid values are ON_DEMAND
	// or SPOT.
	Market *string `type:"string" enum:"MarketType"`

	// The name of the instance group.
	Name *string `type:"string"`

	// The target number of instances for the instance group.
	RequestedInstanceCount *int64 `type:"integer"`

	// The number of instances currently running in this instance group.
	RunningInstanceCount *int64 `type:"integer"`

	// The current status of the instance group.
	Status *InstanceGroupStatus `type:"structure"`

	metadataInstanceGroup `json:"-" xml:"-"`
}

type metadataInstanceGroup struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroup) GoString() string {
	return s.String()
}

// Configuration defining a new instance group.
type InstanceGroupConfig struct {
	// Bid price for each Amazon EC2 instance in the instance group when launching
	// nodes as Spot Instances, expressed in USD.
	BidPrice *string `type:"string"`

	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for an EMR cluster instance group. You
	// can specify a separate configuration for each instance group (master, core,
	// and task).
	Configurations []*Configuration `type:"list"`

	// Target number of instances for the instance group.
	InstanceCount *int64 `type:"integer" required:"true"`

	// The role of the instance group in the cluster.
	InstanceRole *string `type:"string" required:"true" enum:"InstanceRoleType"`

	// The Amazon EC2 instance type for all instances in the instance group.
	InstanceType *string `min:"1" type:"string" required:"true"`

	// Market type of the Amazon EC2 instances used to create a cluster node.
	Market *string `type:"string" enum:"MarketType"`

	// Friendly name given to the instance group.
	Name *string `type:"string"`

	metadataInstanceGroupConfig `json:"-" xml:"-"`
}

type metadataInstanceGroupConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupConfig) GoString() string {
	return s.String()
}

// Detailed information about an instance group.
type InstanceGroupDetail struct {
	// Bid price for EC2 Instances when launching nodes as Spot Instances, expressed
	// in USD.
	BidPrice *string `type:"string"`

	// The date/time the instance group was created.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The date/time the instance group was terminated.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Unique identifier for the instance group.
	InstanceGroupId *string `type:"string"`

	// Target number of instances to run in the instance group.
	InstanceRequestCount *int64 `type:"integer" required:"true"`

	// Instance group role in the cluster
	InstanceRole *string `type:"string" required:"true" enum:"InstanceRoleType"`

	// Actual count of running instances.
	InstanceRunningCount *int64 `type:"integer" required:"true"`

	// Amazon EC2 Instance type.
	InstanceType *string `min:"1" type:"string" required:"true"`

	// Details regarding the state of the instance group.
	LastStateChangeReason *string `type:"string"`

	// Market type of the Amazon EC2 instances used to create a cluster node.
	Market *string `type:"string" required:"true" enum:"MarketType"`

	// Friendly name for the instance group.
	Name *string `type:"string"`

	// The date/time the instance group was available to the cluster.
	ReadyDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date/time the instance group was started.
	StartDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// State of instance group. The following values are deprecated: STARTING, TERMINATED,
	// and FAILED.
	State *string `type:"string" required:"true" enum:"InstanceGroupState"`

	metadataInstanceGroupDetail `json:"-" xml:"-"`
}

type metadataInstanceGroupDetail struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupDetail) GoString() string {
	return s.String()
}

// Modify an instance group size.
type InstanceGroupModifyConfig struct {
	// The EC2 InstanceIds to terminate. For advanced users only. Once you terminate
	// the instances, the instance group will not return to its original requested
	// size.
	EC2InstanceIdsToTerminate []*string `type:"list"`

	// Target size for the instance group.
	InstanceCount *int64 `type:"integer"`

	// Unique ID of the instance group to expand or shrink.
	InstanceGroupId *string `type:"string" required:"true"`

	metadataInstanceGroupModifyConfig `json:"-" xml:"-"`
}

type metadataInstanceGroupModifyConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupModifyConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupModifyConfig) GoString() string {
	return s.String()
}

// The status change reason details for the instance group.
type InstanceGroupStateChangeReason struct {
	// The programmable code for the state change reason.
	Code *string `type:"string" enum:"InstanceGroupStateChangeReasonCode"`

	// The status change reason description.
	Message *string `type:"string"`

	metadataInstanceGroupStateChangeReason `json:"-" xml:"-"`
}

type metadataInstanceGroupStateChangeReason struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupStateChangeReason) GoString() string {
	return s.String()
}

// The details of the instance group status.
type InstanceGroupStatus struct {
	// The current state of the instance group.
	State *string `type:"string" enum:"InstanceGroupState"`

	// The status change reason details for the instance group.
	StateChangeReason *InstanceGroupStateChangeReason `type:"structure"`

	// The timeline of the instance group status over time.
	Timeline *InstanceGroupTimeline `type:"structure"`

	metadataInstanceGroupStatus `json:"-" xml:"-"`
}

type metadataInstanceGroupStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupStatus) GoString() string {
	return s.String()
}

// The timeline of the instance group lifecycle.
type InstanceGroupTimeline struct {
	// The creation date and time of the instance group.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the instance group terminated.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the instance group became ready to perform tasks.
	ReadyDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	metadataInstanceGroupTimeline `json:"-" xml:"-"`
}

type metadataInstanceGroupTimeline struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceGroupTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceGroupTimeline) GoString() string {
	return s.String()
}

// The details of the status change reason for the instance.
type InstanceStateChangeReason struct {
	// The programmable code for the state change reason.
	Code *string `type:"string" enum:"InstanceStateChangeReasonCode"`

	// The status change reason description.
	Message *string `type:"string"`

	metadataInstanceStateChangeReason `json:"-" xml:"-"`
}

type metadataInstanceStateChangeReason struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStateChangeReason) GoString() string {
	return s.String()
}

// The instance status details.
type InstanceStatus struct {
	// The current state of the instance.
	State *string `type:"string" enum:"InstanceState"`

	// The details of the status change reason for the instance.
	StateChangeReason *InstanceStateChangeReason `type:"structure"`

	// The timeline of the instance status over time.
	Timeline *InstanceTimeline `type:"structure"`

	metadataInstanceStatus `json:"-" xml:"-"`
}

type metadataInstanceStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceStatus) GoString() string {
	return s.String()
}

// The timeline of the instance lifecycle.
type InstanceTimeline struct {
	// The creation date and time of the instance.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the instance was terminated.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the instance was ready to perform tasks.
	ReadyDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	metadataInstanceTimeline `json:"-" xml:"-"`
}

type metadataInstanceTimeline struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InstanceTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceTimeline) GoString() string {
	return s.String()
}

// A description of a job flow.
type JobFlowDetail struct {
	// The version of the AMI used to initialize Amazon EC2 instances in the job
	// flow. For a list of AMI versions currently supported by Amazon ElasticMapReduce,
	// go to AMI Versions Supported in Elastic MapReduce (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/EnvironmentConfig_AMIVersion.html#ami-versions-supported)
	// in the Amazon Elastic MapReduce Developer Guide.
	AmiVersion *string `type:"string"`

	// A list of the bootstrap actions run by the job flow.
	BootstrapActions []*BootstrapActionDetail `type:"list"`

	// Describes the execution status of the job flow.
	ExecutionStatusDetail *JobFlowExecutionStatusDetail `type:"structure" required:"true"`

	// Describes the Amazon EC2 instances of the job flow.
	Instances *JobFlowInstancesDetail `type:"structure" required:"true"`

	// The job flow identifier.
	JobFlowId *string `type:"string" required:"true"`

	// The IAM role that was specified when the job flow was launched. The EC2 instances
	// of the job flow assume this role.
	JobFlowRole *string `type:"string"`

	// The location in Amazon S3 where log files for the job are stored.
	LogUri *string `type:"string"`

	// The name of the job flow.
	Name *string `type:"string" required:"true"`

	// The IAM role that will be assumed by the Amazon EMR service to access AWS
	// resources on your behalf.
	ServiceRole *string `type:"string"`

	// A list of steps run by the job flow.
	Steps []*StepDetail `type:"list"`

	// A list of strings set by third party software when the job flow is launched.
	// If you are not using third party software to manage the job flow this value
	// is empty.
	SupportedProducts []*string `type:"list"`

	// Specifies whether the job flow is visible to all IAM users of the AWS account
	// associated with the job flow. If this value is set to true, all IAM users
	// of that AWS account can view and (if they have the proper policy permissions
	// set) manage the job flow. If it is set to false, only the IAM user that created
	// the job flow can view and manage it. This value can be changed using the
	// SetVisibleToAllUsers action.
	VisibleToAllUsers *bool `type:"boolean"`

	metadataJobFlowDetail `json:"-" xml:"-"`
}

type metadataJobFlowDetail struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s JobFlowDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowDetail) GoString() string {
	return s.String()
}

// Describes the status of the job flow.
type JobFlowExecutionStatusDetail struct {
	// The creation date and time of the job flow.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The completion date and time of the job flow.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Description of the job flow last changed state.
	LastStateChangeReason *string `type:"string"`

	// The date and time when the job flow was ready to start running bootstrap
	// actions.
	ReadyDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The start date and time of the job flow.
	StartDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The state of the job flow.
	State *string `type:"string" required:"true" enum:"JobFlowExecutionState"`

	metadataJobFlowExecutionStatusDetail `json:"-" xml:"-"`
}

type metadataJobFlowExecutionStatusDetail struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s JobFlowExecutionStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowExecutionStatusDetail) GoString() string {
	return s.String()
}

// A description of the Amazon EC2 instance running the job flow. A valid JobFlowInstancesConfig
// must contain at least InstanceGroups, which is the recommended configuration.
// However, a valid alternative is to have MasterInstanceType, SlaveInstanceType,
// and InstanceCount (all three must be present).
type JobFlowInstancesConfig struct {
	// A list of additional Amazon EC2 security group IDs for the master node.
	AdditionalMasterSecurityGroups []*string `type:"list"`

	// A list of additional Amazon EC2 security group IDs for the slave nodes.
	AdditionalSlaveSecurityGroups []*string `type:"list"`

	// The name of the Amazon EC2 key pair that can be used to ssh to the master
	// node as the user called "hadoop."
	Ec2KeyName *string `type:"string"`

	// To launch the job flow in Amazon Virtual Private Cloud (Amazon VPC), set
	// this parameter to the identifier of the Amazon VPC subnet where you want
	// the job flow to launch. If you do not specify this value, the job flow is
	// launched in the normal Amazon Web Services cloud, outside of an Amazon VPC.
	//
	//  Amazon VPC currently does not support cluster compute quadruple extra large
	// (cc1.4xlarge) instances. Thus you cannot specify the cc1.4xlarge instance
	// type for nodes of a job flow launched in a Amazon VPC.
	Ec2SubnetId *string `type:"string"`

	// The identifier of the Amazon EC2 security group (managed by Amazon ElasticMapReduce)
	// for the master node.
	EmrManagedMasterSecurityGroup *string `type:"string"`

	// The identifier of the Amazon EC2 security group (managed by Amazon ElasticMapReduce)
	// for the slave nodes.
	EmrManagedSlaveSecurityGroup *string `type:"string"`

	// The Hadoop version for the job flow. Valid inputs are "0.18" (deprecated),
	// "0.20" (deprecated), "0.20.205" (deprecated), "1.0.3", "2.2.0", or "2.4.0".
	// If you do not set this value, the default of 0.18 is used, unless the AmiVersion
	// parameter is set in the RunJobFlow call, in which case the default version
	// of Hadoop for that AMI version is used.
	HadoopVersion *string `type:"string"`

	// The number of Amazon EC2 instances used to execute the job flow.
	InstanceCount *int64 `type:"integer"`

	// Configuration for the job flow's instance groups.
	InstanceGroups []*InstanceGroupConfig `type:"list"`

	// Specifies whether the job flow should be kept alive after completing all
	// steps.
	KeepJobFlowAliveWhenNoSteps *bool `type:"boolean"`

	// The EC2 instance type of the master node.
	MasterInstanceType *string `min:"1" type:"string"`

	// The Availability Zone the job flow will run in.
	Placement *PlacementType `type:"structure"`

	// The EC2 instance type of the slave nodes.
	SlaveInstanceType *string `min:"1" type:"string"`

	// Specifies whether to lock the job flow to prevent the Amazon EC2 instances
	// from being terminated by API call, user intervention, or in the event of
	// a job flow error.
	TerminationProtected *bool `type:"boolean"`

	metadataJobFlowInstancesConfig `json:"-" xml:"-"`
}

type metadataJobFlowInstancesConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s JobFlowInstancesConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowInstancesConfig) GoString() string {
	return s.String()
}

// Specify the type of Amazon EC2 instances to run the job flow on.
type JobFlowInstancesDetail struct {
	// The name of an Amazon EC2 key pair that can be used to ssh to the master
	// node of job flow.
	Ec2KeyName *string `type:"string"`

	// For job flows launched within Amazon Virtual Private Cloud, this value specifies
	// the identifier of the subnet where the job flow was launched.
	Ec2SubnetId *string `type:"string"`

	// The Hadoop version for the job flow.
	HadoopVersion *string `type:"string"`

	// The number of Amazon EC2 instances in the cluster. If the value is 1, the
	// same instance serves as both the master and slave node. If the value is greater
	// than 1, one instance is the master node and all others are slave nodes.
	InstanceCount *int64 `type:"integer" required:"true"`

	// Details about the job flow's instance groups.
	InstanceGroups []*InstanceGroupDetail `type:"list"`

	// Specifies whether the job flow should terminate after completing all steps.
	KeepJobFlowAliveWhenNoSteps *bool `type:"boolean"`

	// The Amazon EC2 instance identifier of the master node.
	MasterInstanceId *string `type:"string"`

	// The Amazon EC2 master node instance type.
	MasterInstanceType *string `min:"1" type:"string" required:"true"`

	// The DNS name of the master node.
	MasterPublicDnsName *string `type:"string"`

	// An approximation of the cost of the job flow, represented in m1.small/hours.
	// This value is incremented once for every hour an m1.small runs. Larger instances
	// are weighted more, so an Amazon EC2 instance that is roughly four times more
	// expensive would result in the normalized instance hours being incremented
	// by four. This result is only an approximation and does not reflect the actual
	// billing rate.
	NormalizedInstanceHours *int64 `type:"integer"`

	// The Amazon EC2 Availability Zone for the job flow.
	Placement *PlacementType `type:"structure"`

	// The Amazon EC2 slave node instance type.
	SlaveInstanceType *string `min:"1" type:"string" required:"true"`

	// Specifies whether the Amazon EC2 instances in the cluster are protected from
	// termination by API calls, user intervention, or in the event of a job flow
	// error.
	TerminationProtected *bool `type:"boolean"`

	metadataJobFlowInstancesDetail `json:"-" xml:"-"`
}

type metadataJobFlowInstancesDetail struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s JobFlowInstancesDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobFlowInstancesDetail) GoString() string {
	return s.String()
}

// A key value pair.
type KeyValue struct {
	// The unique identifier of a key value pair.
	Key *string `type:"string"`

	// The value part of the identified key.
	Value *string `type:"string"`

	metadataKeyValue `json:"-" xml:"-"`
}

type metadataKeyValue struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s KeyValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s KeyValue) GoString() string {
	return s.String()
}

// This input determines which bootstrap actions to retrieve.
type ListBootstrapActionsInput struct {
	// The cluster identifier for the bootstrap actions to list .
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve .
	Marker *string `type:"string"`

	metadataListBootstrapActionsInput `json:"-" xml:"-"`
}

type metadataListBootstrapActionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListBootstrapActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBootstrapActionsInput) GoString() string {
	return s.String()
}

// This output contains the boostrap actions detail .
type ListBootstrapActionsOutput struct {
	// The bootstrap actions associated with the cluster .
	BootstrapActions []*Command `type:"list"`

	// The pagination token that indicates the next set of results to retrieve .
	Marker *string `type:"string"`

	metadataListBootstrapActionsOutput `json:"-" xml:"-"`
}

type metadataListBootstrapActionsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListBootstrapActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListBootstrapActionsOutput) GoString() string {
	return s.String()
}

// This input determines how the ListClusters action filters the list of clusters
// that it returns.
type ListClustersInput struct {
	// The cluster state filters to apply when listing clusters.
	ClusterStates []*string `type:"list"`

	// The creation date and time beginning value filter for listing clusters .
	CreatedAfter *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The creation date and time end value filter for listing clusters .
	CreatedBefore *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	metadataListClustersInput `json:"-" xml:"-"`
}

type metadataListClustersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListClustersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersInput) GoString() string {
	return s.String()
}

// This contains a ClusterSummaryList with the cluster details; for example,
// the cluster IDs, names, and status.
type ListClustersOutput struct {
	// The list of clusters for the account based on the given filters.
	Clusters []*ClusterSummary `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	metadataListClustersOutput `json:"-" xml:"-"`
}

type metadataListClustersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListClustersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListClustersOutput) GoString() string {
	return s.String()
}

// This input determines which instance groups to retrieve.
type ListInstanceGroupsInput struct {
	// The identifier of the cluster for which to list the instance groups.
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	metadataListInstanceGroupsInput `json:"-" xml:"-"`
}

type metadataListInstanceGroupsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceGroupsInput) GoString() string {
	return s.String()
}

// This input determines which instance groups to retrieve.
type ListInstanceGroupsOutput struct {
	// The list of instance groups for the cluster and given filters.
	InstanceGroups []*InstanceGroup `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	metadataListInstanceGroupsOutput `json:"-" xml:"-"`
}

type metadataListInstanceGroupsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstanceGroupsOutput) GoString() string {
	return s.String()
}

// This input determines which instances to list.
type ListInstancesInput struct {
	// The identifier of the cluster for which to list the instances.
	ClusterId *string `type:"string" required:"true"`

	// The identifier of the instance group for which to list the instances.
	InstanceGroupId *string `type:"string"`

	// The type of instance group for which to list the instances.
	InstanceGroupTypes []*string `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	metadataListInstancesInput `json:"-" xml:"-"`
}

type metadataListInstancesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListInstancesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesInput) GoString() string {
	return s.String()
}

// This output contains the list of instances.
type ListInstancesOutput struct {
	// The list of instances for the cluster and given filters.
	Instances []*Instance `type:"list"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	metadataListInstancesOutput `json:"-" xml:"-"`
}

type metadataListInstancesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListInstancesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListInstancesOutput) GoString() string {
	return s.String()
}

// This input determines which steps to list.
type ListStepsInput struct {
	// The identifier of the cluster for which to list the steps.
	ClusterId *string `type:"string" required:"true"`

	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	// The filter to limit the step list based on the identifier of the steps.
	StepIds []*string `type:"list"`

	// The filter to limit the step list based on certain states.
	StepStates []*string `type:"list"`

	metadataListStepsInput `json:"-" xml:"-"`
}

type metadataListStepsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListStepsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStepsInput) GoString() string {
	return s.String()
}

// This output contains the list of steps.
type ListStepsOutput struct {
	// The pagination token that indicates the next set of results to retrieve.
	Marker *string `type:"string"`

	// The filtered list of steps for the cluster.
	Steps []*StepSummary `type:"list"`

	metadataListStepsOutput `json:"-" xml:"-"`
}

type metadataListStepsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListStepsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStepsOutput) GoString() string {
	return s.String()
}

// Change the size of some instance groups.
type ModifyInstanceGroupsInput struct {
	// Instance groups to change.
	InstanceGroups []*InstanceGroupModifyConfig `type:"list"`

	metadataModifyInstanceGroupsInput `json:"-" xml:"-"`
}

type metadataModifyInstanceGroupsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyInstanceGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstanceGroupsInput) GoString() string {
	return s.String()
}

type ModifyInstanceGroupsOutput struct {
	metadataModifyInstanceGroupsOutput `json:"-" xml:"-"`
}

type metadataModifyInstanceGroupsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ModifyInstanceGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ModifyInstanceGroupsOutput) GoString() string {
	return s.String()
}

// The Amazon EC2 location for the job flow.
type PlacementType struct {
	// The Amazon EC2 Availability Zone for the job flow.
	AvailabilityZone *string `type:"string" required:"true"`

	metadataPlacementType `json:"-" xml:"-"`
}

type metadataPlacementType struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PlacementType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementType) GoString() string {
	return s.String()
}

// This input identifies a cluster and a list of tags to remove.
type RemoveTagsInput struct {
	// The Amazon EMR resource identifier from which tags will be removed. This
	// value must be a cluster identifier.
	ResourceId *string `type:"string" required:"true"`

	// A list of tag keys to remove from a resource.
	TagKeys []*string `type:"list" required:"true"`

	metadataRemoveTagsInput `json:"-" xml:"-"`
}

type metadataRemoveTagsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// This output indicates the result of removing tags from a resource.
type RemoveTagsOutput struct {
	metadataRemoveTagsOutput `json:"-" xml:"-"`
}

type metadataRemoveTagsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Input to the RunJobFlow operation.
type RunJobFlowInput struct {
	// A JSON string for selecting additional features.
	AdditionalInfo *string `type:"string"`

	// For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and greater,
	// use ReleaseLabel.
	//
	// The version of the Amazon Machine Image (AMI) to use when launching Amazon
	// EC2 instances in the job flow. The following values are valid:
	//
	//  The version number of the AMI to use, for example, "2.0."  If the AMI supports
	// multiple versions of Hadoop (for example, AMI 1.0 supports both Hadoop 0.18
	// and 0.20) you can use the JobFlowInstancesConfig HadoopVersion parameter
	// to modify the version of Hadoop from the defaults shown above.
	//
	// For details about the AMI versions currently supported by Amazon Elastic
	// MapReduce, go to AMI Versions Supported in Elastic MapReduce (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/EnvironmentConfig_AMIVersion.html#ami-versions-supported)
	// in the Amazon Elastic MapReduce Developer's Guide.
	AmiVersion *string `type:"string"`

	// Amazon EMR releases 4.x or later.
	//
	// A list of applications for the cluster. Valid values are: "Hadoop", "Hive",
	// "Mahout", "Pig", and "Spark." They are case insensitive.
	Applications []*Application `type:"list"`

	// A list of bootstrap actions that will be run before Hadoop is started on
	// the cluster nodes.
	BootstrapActions []*BootstrapActionConfig `type:"list"`

	// Amazon EMR releases 4.x or later.
	//
	// The list of configurations supplied for the EMR cluster you are creating.
	Configurations []*Configuration `type:"list"`

	// A specification of the number and type of Amazon EC2 instances on which to
	// run the job flow.
	Instances *JobFlowInstancesConfig `type:"structure" required:"true"`

	// An IAM role for the job flow. The EC2 instances of the job flow assume this
	// role. The default role is EMRJobflowDefault. In order to use the default
	// role, you must have already created it using the CLI.
	JobFlowRole *string `type:"string"`

	// The location in Amazon S3 to write the log files of the job flow. If a value
	// is not provided, logs are not created.
	LogUri *string `type:"string"`

	// The name of the job flow.
	Name *string `type:"string" required:"true"`

	// For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and greater,
	// use Applications.
	//
	// A list of strings that indicates third-party software to use with the job
	// flow that accepts a user argument list. EMR accepts and forwards the argument
	// list to the corresponding installation script as bootstrap action arguments.
	// For more information, see Launch a Job Flow on the MapR Distribution for
	// Hadoop (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-mapr.html).
	// Currently supported values are:
	//
	//  "mapr-m3" - launch the cluster using MapR M3 Edition. "mapr-m5" - launch
	// the cluster using MapR M5 Edition. "mapr" with the user arguments specifying
	// "--edition,m3" or "--edition,m5" - launch the job flow using MapR M3 or M5
	// Edition respectively. "mapr-m7" - launch the cluster using MapR M7 Edition.
	// "hunk" - launch the cluster with the Hunk Big Data Analtics Platform. "hue"-
	// launch the cluster with Hue installed. "spark" - launch the cluster with
	// Apache Spark installed. "ganglia" - launch the cluster with the Ganglia Monitoring
	// System installed.
	NewSupportedProducts []*SupportedProductConfig `type:"list"`

	// Amazon EMR releases 4.x or later.
	//
	// The release label for the Amazon EMR release. For Amazon EMR 3.x and 2.x
	// AMIs, use amiVersion instead instead of ReleaseLabel.
	ReleaseLabel *string `type:"string"`

	// The IAM role that will be assumed by the Amazon EMR service to access AWS
	// resources on your behalf.
	ServiceRole *string `type:"string"`

	// A list of steps to be executed by the job flow.
	Steps []*StepConfig `type:"list"`

	// For Amazon EMR releases 3.x and 2.x. For Amazon EMR releases 4.x and greater,
	// use Applications.
	//
	// A list of strings that indicates third-party software to use with the job
	// flow. For more information, go to Use Third Party Applications with Amazon
	// EMR (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-supported-products.html).
	// Currently supported values are:
	//
	//  "mapr-m3" - launch the job flow using MapR M3 Edition. "mapr-m5" - launch
	// the job flow using MapR M5 Edition.
	SupportedProducts []*string `type:"list"`

	// A list of tags to associate with a cluster and propagate to Amazon EC2 instances.
	Tags []*Tag `type:"list"`

	// Whether the job flow is visible to all IAM users of the AWS account associated
	// with the job flow. If this value is set to true, all IAM users of that AWS
	// account can view and (if they have the proper policy permissions set) manage
	// the job flow. If it is set to false, only the IAM user that created the job
	// flow can view and manage it.
	VisibleToAllUsers *bool `type:"boolean"`

	metadataRunJobFlowInput `json:"-" xml:"-"`
}

type metadataRunJobFlowInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RunJobFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunJobFlowInput) GoString() string {
	return s.String()
}

// The result of the RunJobFlow operation.
type RunJobFlowOutput struct {
	// An unique identifier for the job flow.
	JobFlowId *string `type:"string"`

	metadataRunJobFlowOutput `json:"-" xml:"-"`
}

type metadataRunJobFlowOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RunJobFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RunJobFlowOutput) GoString() string {
	return s.String()
}

// Configuration of the script to run during a bootstrap action.
type ScriptBootstrapActionConfig struct {
	// A list of command line arguments to pass to the bootstrap action script.
	Args []*string `type:"list"`

	// Location of the script to run during a bootstrap action. Can be either a
	// location in Amazon S3 or on a local file system.
	Path *string `type:"string" required:"true"`

	metadataScriptBootstrapActionConfig `json:"-" xml:"-"`
}

type metadataScriptBootstrapActionConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ScriptBootstrapActionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScriptBootstrapActionConfig) GoString() string {
	return s.String()
}

// The input argument to the TerminationProtection operation.
type SetTerminationProtectionInput struct {
	// A list of strings that uniquely identify the job flows to protect. This identifier
	// is returned by RunJobFlow and can also be obtained from DescribeJobFlows
	// .
	JobFlowIds []*string `type:"list" required:"true"`

	// A Boolean that indicates whether to protect the job flow and prevent the
	// Amazon EC2 instances in the cluster from shutting down due to API calls,
	// user intervention, or job-flow error.
	TerminationProtected *bool `type:"boolean" required:"true"`

	metadataSetTerminationProtectionInput `json:"-" xml:"-"`
}

type metadataSetTerminationProtectionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetTerminationProtectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTerminationProtectionInput) GoString() string {
	return s.String()
}

type SetTerminationProtectionOutput struct {
	metadataSetTerminationProtectionOutput `json:"-" xml:"-"`
}

type metadataSetTerminationProtectionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetTerminationProtectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetTerminationProtectionOutput) GoString() string {
	return s.String()
}

// The input to the SetVisibleToAllUsers action.
type SetVisibleToAllUsersInput struct {
	// Identifiers of the job flows to receive the new visibility setting.
	JobFlowIds []*string `type:"list" required:"true"`

	// Whether the specified job flows are visible to all IAM users of the AWS account
	// associated with the job flow. If this value is set to True, all IAM users
	// of that AWS account can view and, if they have the proper IAM policy permissions
	// set, manage the job flows. If it is set to False, only the IAM user that
	// created a job flow can view and manage it.
	VisibleToAllUsers *bool `type:"boolean" required:"true"`

	metadataSetVisibleToAllUsersInput `json:"-" xml:"-"`
}

type metadataSetVisibleToAllUsersInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetVisibleToAllUsersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVisibleToAllUsersInput) GoString() string {
	return s.String()
}

type SetVisibleToAllUsersOutput struct {
	metadataSetVisibleToAllUsersOutput `json:"-" xml:"-"`
}

type metadataSetVisibleToAllUsersOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetVisibleToAllUsersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetVisibleToAllUsersOutput) GoString() string {
	return s.String()
}

// This represents a step in a cluster.
type Step struct {
	// This specifies what action to take when the cluster step fails. Possible
	// values are TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE.
	ActionOnFailure *string `type:"string" enum:"ActionOnFailure"`

	// The Hadoop job configuration of the cluster step.
	Config *HadoopStepConfig `type:"structure"`

	// The identifier of the cluster step.
	Id *string `type:"string"`

	// The name of the cluster step.
	Name *string `type:"string"`

	// The current execution status details of the cluster step.
	Status *StepStatus `type:"structure"`

	metadataStep `json:"-" xml:"-"`
}

type metadataStep struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Step) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Step) GoString() string {
	return s.String()
}

// Specification of a job flow step.
type StepConfig struct {
	// The action to take if the job flow step fails.
	ActionOnFailure *string `type:"string" enum:"ActionOnFailure"`

	// The JAR file used for the job flow step.
	HadoopJarStep *HadoopJarStepConfig `type:"structure" required:"true"`

	// The name of the job flow step.
	Name *string `type:"string" required:"true"`

	metadataStepConfig `json:"-" xml:"-"`
}

type metadataStepConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StepConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepConfig) GoString() string {
	return s.String()
}

// Combines the execution state and configuration of a step.
type StepDetail struct {
	// The description of the step status.
	ExecutionStatusDetail *StepExecutionStatusDetail `type:"structure" required:"true"`

	// The step configuration.
	StepConfig *StepConfig `type:"structure" required:"true"`

	metadataStepDetail `json:"-" xml:"-"`
}

type metadataStepDetail struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StepDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepDetail) GoString() string {
	return s.String()
}

// The execution state of a step.
type StepExecutionStatusDetail struct {
	// The creation date and time of the step.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// The completion date and time of the step.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// A description of the step's current state.
	LastStateChangeReason *string `type:"string"`

	// The start date and time of the step.
	StartDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The state of the job flow step.
	State *string `type:"string" required:"true" enum:"StepExecutionState"`

	metadataStepExecutionStatusDetail `json:"-" xml:"-"`
}

type metadataStepExecutionStatusDetail struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StepExecutionStatusDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepExecutionStatusDetail) GoString() string {
	return s.String()
}

// The details of the step state change reason.
type StepStateChangeReason struct {
	// The programmable code for the state change reason. Note: Currently, the service
	// provides no code for the state change.
	Code *string `type:"string" enum:"StepStateChangeReasonCode"`

	// The descriptive message for the state change reason.
	Message *string `type:"string"`

	metadataStepStateChangeReason `json:"-" xml:"-"`
}

type metadataStepStateChangeReason struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StepStateChangeReason) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepStateChangeReason) GoString() string {
	return s.String()
}

// The execution status details of the cluster step.
type StepStatus struct {
	// The execution state of the cluster step.
	State *string `type:"string" enum:"StepState"`

	// The reason for the step execution status change.
	StateChangeReason *StepStateChangeReason `type:"structure"`

	// The timeline of the cluster step status over time.
	Timeline *StepTimeline `type:"structure"`

	metadataStepStatus `json:"-" xml:"-"`
}

type metadataStepStatus struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StepStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepStatus) GoString() string {
	return s.String()
}

// The summary of the cluster step.
type StepSummary struct {
	// This specifies what action to take when the cluster step fails. Possible
	// values are TERMINATE_CLUSTER, CANCEL_AND_WAIT, and CONTINUE.
	ActionOnFailure *string `type:"string" enum:"ActionOnFailure"`

	// The Hadoop job configuration of the cluster step.
	Config *HadoopStepConfig `type:"structure"`

	// The identifier of the cluster step.
	Id *string `type:"string"`

	// The name of the cluster step.
	Name *string `type:"string"`

	// The current execution status details of the cluster step.
	Status *StepStatus `type:"structure"`

	metadataStepSummary `json:"-" xml:"-"`
}

type metadataStepSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StepSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepSummary) GoString() string {
	return s.String()
}

// The timeline of the cluster step lifecycle.
type StepTimeline struct {
	// The date and time when the cluster step was created.
	CreationDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the cluster step execution completed or failed.
	EndDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The date and time when the cluster step execution started.
	StartDateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	metadataStepTimeline `json:"-" xml:"-"`
}

type metadataStepTimeline struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StepTimeline) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StepTimeline) GoString() string {
	return s.String()
}

// The list of supported product configurations which allow user-supplied arguments.
// EMR accepts these arguments and forwards them to the corresponding installation
// script as bootstrap action arguments.
type SupportedProductConfig struct {
	// The list of user-supplied arguments.
	Args []*string `type:"list"`

	// The name of the product configuration.
	Name *string `type:"string"`

	metadataSupportedProductConfig `json:"-" xml:"-"`
}

type metadataSupportedProductConfig struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SupportedProductConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SupportedProductConfig) GoString() string {
	return s.String()
}

// A key/value pair containing user-defined metadata that you can associate
// with an Amazon EMR resource. Tags make it easier to associate clusters in
// various ways, such as grouping clu\ sters to track your Amazon EMR resource
// allocation costs. For more information, see Tagging Amazon EMR Resources
// (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-plan-tags.html).
type Tag struct {
	// A user-defined key, which is the minimum required information for a valid
	// tag. For more information, see Tagging Amazon EMR Resources (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-plan-tags.html).
	Key *string `type:"string"`

	// A user-defined value, which is optional in a tag. For more information, see
	// Tagging Amazon EMR Resources (http://docs.aws.amazon.com/ElasticMapReduce/latest/DeveloperGuide/emr-plan-tags.html).
	Value *string `type:"string"`

	metadataTag `json:"-" xml:"-"`
}

type metadataTag struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Input to the TerminateJobFlows operation.
type TerminateJobFlowsInput struct {
	// A list of job flows to be shutdown.
	JobFlowIds []*string `type:"list" required:"true"`

	metadataTerminateJobFlowsInput `json:"-" xml:"-"`
}

type metadataTerminateJobFlowsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TerminateJobFlowsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateJobFlowsInput) GoString() string {
	return s.String()
}

type TerminateJobFlowsOutput struct {
	metadataTerminateJobFlowsOutput `json:"-" xml:"-"`
}

type metadataTerminateJobFlowsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TerminateJobFlowsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TerminateJobFlowsOutput) GoString() string {
	return s.String()
}

const (
	// @enum ActionOnFailure
	ActionOnFailureTerminateJobFlow = "TERMINATE_JOB_FLOW"
	// @enum ActionOnFailure
	ActionOnFailureTerminateCluster = "TERMINATE_CLUSTER"
	// @enum ActionOnFailure
	ActionOnFailureCancelAndWait = "CANCEL_AND_WAIT"
	// @enum ActionOnFailure
	ActionOnFailureContinue = "CONTINUE"
)

const (
	// @enum ClusterState
	ClusterStateStarting = "STARTING"
	// @enum ClusterState
	ClusterStateBootstrapping = "BOOTSTRAPPING"
	// @enum ClusterState
	ClusterStateRunning = "RUNNING"
	// @enum ClusterState
	ClusterStateWaiting = "WAITING"
	// @enum ClusterState
	ClusterStateTerminating = "TERMINATING"
	// @enum ClusterState
	ClusterStateTerminated = "TERMINATED"
	// @enum ClusterState
	ClusterStateTerminatedWithErrors = "TERMINATED_WITH_ERRORS"
)

const (
	// @enum ClusterStateChangeReasonCode
	ClusterStateChangeReasonCodeInternalError = "INTERNAL_ERROR"
	// @enum ClusterStateChangeReasonCode
	ClusterStateChangeReasonCodeValidationError = "VALIDATION_ERROR"
	// @enum ClusterStateChangeReasonCode
	ClusterStateChangeReasonCodeInstanceFailure = "INSTANCE_FAILURE"
	// @enum ClusterStateChangeReasonCode
	ClusterStateChangeReasonCodeBootstrapFailure = "BOOTSTRAP_FAILURE"
	// @enum ClusterStateChangeReasonCode
	ClusterStateChangeReasonCodeUserRequest = "USER_REQUEST"
	// @enum ClusterStateChangeReasonCode
	ClusterStateChangeReasonCodeStepFailure = "STEP_FAILURE"
	// @enum ClusterStateChangeReasonCode
	ClusterStateChangeReasonCodeAllStepsCompleted = "ALL_STEPS_COMPLETED"
)

const (
	// @enum InstanceGroupState
	InstanceGroupStateProvisioning = "PROVISIONING"
	// @enum InstanceGroupState
	InstanceGroupStateBootstrapping = "BOOTSTRAPPING"
	// @enum InstanceGroupState
	InstanceGroupStateRunning = "RUNNING"
	// @enum InstanceGroupState
	InstanceGroupStateResizing = "RESIZING"
	// @enum InstanceGroupState
	InstanceGroupStateSuspended = "SUSPENDED"
	// @enum InstanceGroupState
	InstanceGroupStateTerminating = "TERMINATING"
	// @enum InstanceGroupState
	InstanceGroupStateTerminated = "TERMINATED"
	// @enum InstanceGroupState
	InstanceGroupStateArrested = "ARRESTED"
	// @enum InstanceGroupState
	InstanceGroupStateShuttingDown = "SHUTTING_DOWN"
	// @enum InstanceGroupState
	InstanceGroupStateEnded = "ENDED"
)

const (
	// @enum InstanceGroupStateChangeReasonCode
	InstanceGroupStateChangeReasonCodeInternalError = "INTERNAL_ERROR"
	// @enum InstanceGroupStateChangeReasonCode
	InstanceGroupStateChangeReasonCodeValidationError = "VALIDATION_ERROR"
	// @enum InstanceGroupStateChangeReasonCode
	InstanceGroupStateChangeReasonCodeInstanceFailure = "INSTANCE_FAILURE"
	// @enum InstanceGroupStateChangeReasonCode
	InstanceGroupStateChangeReasonCodeClusterTerminated = "CLUSTER_TERMINATED"
)

const (
	// @enum InstanceGroupType
	InstanceGroupTypeMaster = "MASTER"
	// @enum InstanceGroupType
	InstanceGroupTypeCore = "CORE"
	// @enum InstanceGroupType
	InstanceGroupTypeTask = "TASK"
)

const (
	// @enum InstanceRoleType
	InstanceRoleTypeMaster = "MASTER"
	// @enum InstanceRoleType
	InstanceRoleTypeCore = "CORE"
	// @enum InstanceRoleType
	InstanceRoleTypeTask = "TASK"
)

const (
	// @enum InstanceState
	InstanceStateAwaitingFulfillment = "AWAITING_FULFILLMENT"
	// @enum InstanceState
	InstanceStateProvisioning = "PROVISIONING"
	// @enum InstanceState
	InstanceStateBootstrapping = "BOOTSTRAPPING"
	// @enum InstanceState
	InstanceStateRunning = "RUNNING"
	// @enum InstanceState
	InstanceStateTerminated = "TERMINATED"
)

const (
	// @enum InstanceStateChangeReasonCode
	InstanceStateChangeReasonCodeInternalError = "INTERNAL_ERROR"
	// @enum InstanceStateChangeReasonCode
	InstanceStateChangeReasonCodeValidationError = "VALIDATION_ERROR"
	// @enum InstanceStateChangeReasonCode
	InstanceStateChangeReasonCodeInstanceFailure = "INSTANCE_FAILURE"
	// @enum InstanceStateChangeReasonCode
	InstanceStateChangeReasonCodeBootstrapFailure = "BOOTSTRAP_FAILURE"
	// @enum InstanceStateChangeReasonCode
	InstanceStateChangeReasonCodeClusterTerminated = "CLUSTER_TERMINATED"
)

// The type of instance.
//
//   A small instance
//
//   A large instance
const (
	// @enum JobFlowExecutionState
	JobFlowExecutionStateStarting = "STARTING"
	// @enum JobFlowExecutionState
	JobFlowExecutionStateBootstrapping = "BOOTSTRAPPING"
	// @enum JobFlowExecutionState
	JobFlowExecutionStateRunning = "RUNNING"
	// @enum JobFlowExecutionState
	JobFlowExecutionStateWaiting = "WAITING"
	// @enum JobFlowExecutionState
	JobFlowExecutionStateShuttingDown = "SHUTTING_DOWN"
	// @enum JobFlowExecutionState
	JobFlowExecutionStateTerminated = "TERMINATED"
	// @enum JobFlowExecutionState
	JobFlowExecutionStateCompleted = "COMPLETED"
	// @enum JobFlowExecutionState
	JobFlowExecutionStateFailed = "FAILED"
)

const (
	// @enum MarketType
	MarketTypeOnDemand = "ON_DEMAND"
	// @enum MarketType
	MarketTypeSpot = "SPOT"
)

const (
	// @enum StepExecutionState
	StepExecutionStatePending = "PENDING"
	// @enum StepExecutionState
	StepExecutionStateRunning = "RUNNING"
	// @enum StepExecutionState
	StepExecutionStateContinue = "CONTINUE"
	// @enum StepExecutionState
	StepExecutionStateCompleted = "COMPLETED"
	// @enum StepExecutionState
	StepExecutionStateCancelled = "CANCELLED"
	// @enum StepExecutionState
	StepExecutionStateFailed = "FAILED"
	// @enum StepExecutionState
	StepExecutionStateInterrupted = "INTERRUPTED"
)

const (
	// @enum StepState
	StepStatePending = "PENDING"
	// @enum StepState
	StepStateRunning = "RUNNING"
	// @enum StepState
	StepStateCompleted = "COMPLETED"
	// @enum StepState
	StepStateCancelled = "CANCELLED"
	// @enum StepState
	StepStateFailed = "FAILED"
	// @enum StepState
	StepStateInterrupted = "INTERRUPTED"
)

const (
	// @enum StepStateChangeReasonCode
	StepStateChangeReasonCodeNone = "NONE"
)
