// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package directconnect provides a client for AWS Direct Connect.
package directconnect

import (
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAllocateConnectionOnInterconnect = "AllocateConnectionOnInterconnect"

// AllocateConnectionOnInterconnectRequest generates a request for the AllocateConnectionOnInterconnect operation.
func (c *DirectConnect) AllocateConnectionOnInterconnectRequest(input *AllocateConnectionOnInterconnectInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opAllocateConnectionOnInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateConnectionOnInterconnectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Connection{}
	req.Data = output
	return
}

// Creates a hosted connection on an interconnect.
//
// Allocates a VLAN number and a specified amount of bandwidth for use by a
// hosted connection on the given interconnect.
func (c *DirectConnect) AllocateConnectionOnInterconnect(input *AllocateConnectionOnInterconnectInput) (*Connection, error) {
	req, out := c.AllocateConnectionOnInterconnectRequest(input)
	err := req.Send()
	return out, err
}

const opAllocatePrivateVirtualInterface = "AllocatePrivateVirtualInterface"

// AllocatePrivateVirtualInterfaceRequest generates a request for the AllocatePrivateVirtualInterface operation.
func (c *DirectConnect) AllocatePrivateVirtualInterfaceRequest(input *AllocatePrivateVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opAllocatePrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocatePrivateVirtualInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VirtualInterface{}
	req.Data = output
	return
}

// Provisions a private virtual interface to be owned by a different customer.
//
// The owner of a connection calls this function to provision a private virtual
// interface which will be owned by another AWS customer.
//
// Virtual interfaces created using this function must be confirmed by the
// virtual interface owner by calling ConfirmPrivateVirtualInterface. Until
// this step has been completed, the virtual interface will be in 'Confirming'
// state, and will not be available for handling traffic.
func (c *DirectConnect) AllocatePrivateVirtualInterface(input *AllocatePrivateVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.AllocatePrivateVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opAllocatePublicVirtualInterface = "AllocatePublicVirtualInterface"

// AllocatePublicVirtualInterfaceRequest generates a request for the AllocatePublicVirtualInterface operation.
func (c *DirectConnect) AllocatePublicVirtualInterfaceRequest(input *AllocatePublicVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opAllocatePublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocatePublicVirtualInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VirtualInterface{}
	req.Data = output
	return
}

// Provisions a public virtual interface to be owned by a different customer.
//
// The owner of a connection calls this function to provision a public virtual
// interface which will be owned by another AWS customer.
//
// Virtual interfaces created using this function must be confirmed by the
// virtual interface owner by calling ConfirmPublicVirtualInterface. Until this
// step has been completed, the virtual interface will be in 'Confirming' state,
// and will not be available for handling traffic.
func (c *DirectConnect) AllocatePublicVirtualInterface(input *AllocatePublicVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.AllocatePublicVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmConnection = "ConfirmConnection"

// ConfirmConnectionRequest generates a request for the ConfirmConnection operation.
func (c *DirectConnect) ConfirmConnectionRequest(input *ConfirmConnectionInput) (req *request.Request, output *ConfirmConnectionOutput) {
	op := &request.Operation{
		Name:       opConfirmConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmConnectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConfirmConnectionOutput{}
	req.Data = output
	return
}

// Confirm the creation of a hosted connection on an interconnect.
//
// Upon creation, the hosted connection is initially in the 'Ordering' state,
// and will remain in this state until the owner calls ConfirmConnection to
// confirm creation of the hosted connection.
func (c *DirectConnect) ConfirmConnection(input *ConfirmConnectionInput) (*ConfirmConnectionOutput, error) {
	req, out := c.ConfirmConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmPrivateVirtualInterface = "ConfirmPrivateVirtualInterface"

// ConfirmPrivateVirtualInterfaceRequest generates a request for the ConfirmPrivateVirtualInterface operation.
func (c *DirectConnect) ConfirmPrivateVirtualInterfaceRequest(input *ConfirmPrivateVirtualInterfaceInput) (req *request.Request, output *ConfirmPrivateVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opConfirmPrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmPrivateVirtualInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConfirmPrivateVirtualInterfaceOutput{}
	req.Data = output
	return
}

// Accept ownership of a private virtual interface created by another customer.
//
// After the virtual interface owner calls this function, the virtual interface
// will be created and attached to the given virtual private gateway, and will
// be available for handling traffic.
func (c *DirectConnect) ConfirmPrivateVirtualInterface(input *ConfirmPrivateVirtualInterfaceInput) (*ConfirmPrivateVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPrivateVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opConfirmPublicVirtualInterface = "ConfirmPublicVirtualInterface"

// ConfirmPublicVirtualInterfaceRequest generates a request for the ConfirmPublicVirtualInterface operation.
func (c *DirectConnect) ConfirmPublicVirtualInterfaceRequest(input *ConfirmPublicVirtualInterfaceInput) (req *request.Request, output *ConfirmPublicVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opConfirmPublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConfirmPublicVirtualInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ConfirmPublicVirtualInterfaceOutput{}
	req.Data = output
	return
}

// Accept ownership of a public virtual interface created by another customer.
//
// After the virtual interface owner calls this function, the specified virtual
// interface will be created and made available for handling traffic.
func (c *DirectConnect) ConfirmPublicVirtualInterface(input *ConfirmPublicVirtualInterfaceInput) (*ConfirmPublicVirtualInterfaceOutput, error) {
	req, out := c.ConfirmPublicVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opCreateConnection = "CreateConnection"

// CreateConnectionRequest generates a request for the CreateConnection operation.
func (c *DirectConnect) CreateConnectionRequest(input *CreateConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opCreateConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Connection{}
	req.Data = output
	return
}

// Creates a new connection between the customer network and a specific AWS
// Direct Connect location.
//
// A connection links your internal network to an AWS Direct Connect location
// over a standard 1 gigabit or 10 gigabit Ethernet fiber-optic cable. One end
// of the cable is connected to your router, the other to an AWS Direct Connect
// router. An AWS Direct Connect location provides access to Amazon Web Services
// in the region it is associated with. You can establish connections with AWS
// Direct Connect locations in multiple regions, but a connection in one region
// does not provide connectivity to other regions.
func (c *DirectConnect) CreateConnection(input *CreateConnectionInput) (*Connection, error) {
	req, out := c.CreateConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opCreateInterconnect = "CreateInterconnect"

// CreateInterconnectRequest generates a request for the CreateInterconnect operation.
func (c *DirectConnect) CreateInterconnectRequest(input *CreateInterconnectInput) (req *request.Request, output *Interconnect) {
	op := &request.Operation{
		Name:       opCreateInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInterconnectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Interconnect{}
	req.Data = output
	return
}

// Creates a new interconnect between a AWS Direct Connect partner's network
// and a specific AWS Direct Connect location.
//
// An interconnect is a connection which is capable of hosting other connections.
// The AWS Direct Connect partner can use an interconnect to provide sub-1Gbps
// AWS Direct Connect service to tier 2 customers who do not have their own
// connections. Like a standard connection, an interconnect links the AWS Direct
// Connect partner's network to an AWS Direct Connect location over a standard
// 1 Gbps or 10 Gbps Ethernet fiber-optic cable. One end is connected to the
// partner's router, the other to an AWS Direct Connect router.
//
// For each end customer, the AWS Direct Connect partner provisions a connection
// on their interconnect by calling AllocateConnectionOnInterconnect. The end
// customer can then connect to AWS resources by creating a virtual interface
// on their connection, using the VLAN assigned to them by the AWS Direct Connect
// partner.
func (c *DirectConnect) CreateInterconnect(input *CreateInterconnectInput) (*Interconnect, error) {
	req, out := c.CreateInterconnectRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePrivateVirtualInterface = "CreatePrivateVirtualInterface"

// CreatePrivateVirtualInterfaceRequest generates a request for the CreatePrivateVirtualInterface operation.
func (c *DirectConnect) CreatePrivateVirtualInterfaceRequest(input *CreatePrivateVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opCreatePrivateVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePrivateVirtualInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VirtualInterface{}
	req.Data = output
	return
}

// Creates a new private virtual interface. A virtual interface is the VLAN
// that transports AWS Direct Connect traffic. A private virtual interface supports
// sending traffic to a single virtual private cloud (VPC).
func (c *DirectConnect) CreatePrivateVirtualInterface(input *CreatePrivateVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.CreatePrivateVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePublicVirtualInterface = "CreatePublicVirtualInterface"

// CreatePublicVirtualInterfaceRequest generates a request for the CreatePublicVirtualInterface operation.
func (c *DirectConnect) CreatePublicVirtualInterfaceRequest(input *CreatePublicVirtualInterfaceInput) (req *request.Request, output *VirtualInterface) {
	op := &request.Operation{
		Name:       opCreatePublicVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePublicVirtualInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &VirtualInterface{}
	req.Data = output
	return
}

// Creates a new public virtual interface. A virtual interface is the VLAN that
// transports AWS Direct Connect traffic. A public virtual interface supports
// sending traffic to public services of AWS such as Amazon Simple Storage Service
// (Amazon S3).
func (c *DirectConnect) CreatePublicVirtualInterface(input *CreatePublicVirtualInterfaceInput) (*VirtualInterface, error) {
	req, out := c.CreatePublicVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteConnection = "DeleteConnection"

// DeleteConnectionRequest generates a request for the DeleteConnection operation.
func (c *DirectConnect) DeleteConnectionRequest(input *DeleteConnectionInput) (req *request.Request, output *Connection) {
	op := &request.Operation{
		Name:       opDeleteConnection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Connection{}
	req.Data = output
	return
}

// Deletes the connection.
//
// Deleting a connection only stops the AWS Direct Connect port hour and data
// transfer charges. You need to cancel separately with the providers any services
// or charges for cross-connects or network circuits that connect you to the
// AWS Direct Connect location.
func (c *DirectConnect) DeleteConnection(input *DeleteConnectionInput) (*Connection, error) {
	req, out := c.DeleteConnectionRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteInterconnect = "DeleteInterconnect"

// DeleteInterconnectRequest generates a request for the DeleteInterconnect operation.
func (c *DirectConnect) DeleteInterconnectRequest(input *DeleteInterconnectInput) (req *request.Request, output *DeleteInterconnectOutput) {
	op := &request.Operation{
		Name:       opDeleteInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteInterconnectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteInterconnectOutput{}
	req.Data = output
	return
}

// Deletes the specified interconnect.
func (c *DirectConnect) DeleteInterconnect(input *DeleteInterconnectInput) (*DeleteInterconnectOutput, error) {
	req, out := c.DeleteInterconnectRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteVirtualInterface = "DeleteVirtualInterface"

// DeleteVirtualInterfaceRequest generates a request for the DeleteVirtualInterface operation.
func (c *DirectConnect) DeleteVirtualInterfaceRequest(input *DeleteVirtualInterfaceInput) (req *request.Request, output *DeleteVirtualInterfaceOutput) {
	op := &request.Operation{
		Name:       opDeleteVirtualInterface,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteVirtualInterfaceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteVirtualInterfaceOutput{}
	req.Data = output
	return
}

// Deletes a virtual interface.
func (c *DirectConnect) DeleteVirtualInterface(input *DeleteVirtualInterfaceInput) (*DeleteVirtualInterfaceOutput, error) {
	req, out := c.DeleteVirtualInterfaceRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConnections = "DescribeConnections"

// DescribeConnectionsRequest generates a request for the DescribeConnections operation.
func (c *DirectConnect) DescribeConnectionsRequest(input *DescribeConnectionsInput) (req *request.Request, output *Connections) {
	op := &request.Operation{
		Name:       opDescribeConnections,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Connections{}
	req.Data = output
	return
}

// Displays all connections in this region.
//
// If a connection ID is provided, the call returns only that particular connection.
func (c *DirectConnect) DescribeConnections(input *DescribeConnectionsInput) (*Connections, error) {
	req, out := c.DescribeConnectionsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeConnectionsOnInterconnect = "DescribeConnectionsOnInterconnect"

// DescribeConnectionsOnInterconnectRequest generates a request for the DescribeConnectionsOnInterconnect operation.
func (c *DirectConnect) DescribeConnectionsOnInterconnectRequest(input *DescribeConnectionsOnInterconnectInput) (req *request.Request, output *Connections) {
	op := &request.Operation{
		Name:       opDescribeConnectionsOnInterconnect,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionsOnInterconnectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &Connections{}
	req.Data = output
	return
}

// Return a list of connections that have been provisioned on the given interconnect.
func (c *DirectConnect) DescribeConnectionsOnInterconnect(input *DescribeConnectionsOnInterconnectInput) (*Connections, error) {
	req, out := c.DescribeConnectionsOnInterconnectRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeInterconnects = "DescribeInterconnects"

// DescribeInterconnectsRequest generates a request for the DescribeInterconnects operation.
func (c *DirectConnect) DescribeInterconnectsRequest(input *DescribeInterconnectsInput) (req *request.Request, output *DescribeInterconnectsOutput) {
	op := &request.Operation{
		Name:       opDescribeInterconnects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInterconnectsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeInterconnectsOutput{}
	req.Data = output
	return
}

// Returns a list of interconnects owned by the AWS account.
//
// If an interconnect ID is provided, it will only return this particular interconnect.
func (c *DirectConnect) DescribeInterconnects(input *DescribeInterconnectsInput) (*DescribeInterconnectsOutput, error) {
	req, out := c.DescribeInterconnectsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeLocations = "DescribeLocations"

// DescribeLocationsRequest generates a request for the DescribeLocations operation.
func (c *DirectConnect) DescribeLocationsRequest(input *DescribeLocationsInput) (req *request.Request, output *DescribeLocationsOutput) {
	op := &request.Operation{
		Name:       opDescribeLocations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeLocationsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeLocationsOutput{}
	req.Data = output
	return
}

// Returns the list of AWS Direct Connect locations in the current AWS region.
// These are the locations that may be selected when calling CreateConnection
// or CreateInterconnect.
func (c *DirectConnect) DescribeLocations(input *DescribeLocationsInput) (*DescribeLocationsOutput, error) {
	req, out := c.DescribeLocationsRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVirtualGateways = "DescribeVirtualGateways"

// DescribeVirtualGatewaysRequest generates a request for the DescribeVirtualGateways operation.
func (c *DirectConnect) DescribeVirtualGatewaysRequest(input *DescribeVirtualGatewaysInput) (req *request.Request, output *DescribeVirtualGatewaysOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualGateways,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVirtualGatewaysInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVirtualGatewaysOutput{}
	req.Data = output
	return
}

// Returns a list of virtual private gateways owned by the AWS account.
//
// You can create one or more AWS Direct Connect private virtual interfaces
// linking to a virtual private gateway. A virtual private gateway can be managed
// via Amazon Virtual Private Cloud (VPC) console or the EC2 CreateVpnGateway
// (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-CreateVpnGateway.html)
// action.
func (c *DirectConnect) DescribeVirtualGateways(input *DescribeVirtualGatewaysInput) (*DescribeVirtualGatewaysOutput, error) {
	req, out := c.DescribeVirtualGatewaysRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeVirtualInterfaces = "DescribeVirtualInterfaces"

// DescribeVirtualInterfacesRequest generates a request for the DescribeVirtualInterfaces operation.
func (c *DirectConnect) DescribeVirtualInterfacesRequest(input *DescribeVirtualInterfacesInput) (req *request.Request, output *DescribeVirtualInterfacesOutput) {
	op := &request.Operation{
		Name:       opDescribeVirtualInterfaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVirtualInterfacesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeVirtualInterfacesOutput{}
	req.Data = output
	return
}

// Displays all virtual interfaces for an AWS account. Virtual interfaces deleted
// fewer than 15 minutes before DescribeVirtualInterfaces is called are also
// returned. If a connection ID is included then only virtual interfaces associated
// with this connection will be returned. If a virtual interface ID is included
// then only a single virtual interface will be returned.
//
// A virtual interface (VLAN) transmits the traffic between the AWS Direct
// Connect location and the customer.
//
// If a connection ID is provided, only virtual interfaces provisioned on the
// specified connection will be returned. If a virtual interface ID is provided,
// only this particular virtual interface will be returned.
func (c *DirectConnect) DescribeVirtualInterfaces(input *DescribeVirtualInterfacesInput) (*DescribeVirtualInterfacesOutput, error) {
	req, out := c.DescribeVirtualInterfacesRequest(input)
	err := req.Send()
	return out, err
}

// Container for the parameters to the AllocateConnectionOnInterconnect operation.
type AllocateConnectionOnInterconnectInput struct {
	// Bandwidth of the connection.
	//
	// Example: "500Mbps"
	//
	// Default: None
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// Name of the provisioned connection.
	//
	// Example: "500M Connection to AWS"
	//
	// Default: None
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// ID of the interconnect on which the connection will be provisioned.
	//
	// Example: dxcon-456abc78
	//
	// Default: None
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`

	// Numeric account Id of the customer for whom the connection will be provisioned.
	//
	// Example: 123443215678
	//
	// Default: None
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`

	// The dedicated VLAN provisioned to the connection.
	//
	// Example: 101
	//
	// Default: None
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`

	metadataAllocateConnectionOnInterconnectInput `json:"-" xml:"-"`
}

type metadataAllocateConnectionOnInterconnectInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AllocateConnectionOnInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateConnectionOnInterconnectInput) GoString() string {
	return s.String()
}

// Container for the parameters to the AllocatePrivateVirtualInterface operation.
type AllocatePrivateVirtualInterfaceInput struct {
	// The connection ID on which the private virtual interface is provisioned.
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the private virtual interface to be provisioned.
	//
	// Default: None
	NewPrivateVirtualInterfaceAllocation *NewPrivateVirtualInterfaceAllocation `locationName:"newPrivateVirtualInterfaceAllocation" type:"structure" required:"true"`

	// The AWS account that will own the new private virtual interface.
	//
	// Default: None
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`

	metadataAllocatePrivateVirtualInterfaceInput `json:"-" xml:"-"`
}

type metadataAllocatePrivateVirtualInterfaceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AllocatePrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocatePrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Container for the parameters to the AllocatePublicVirtualInterface operation.
type AllocatePublicVirtualInterfaceInput struct {
	// The connection ID on which the public virtual interface is provisioned.
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the public virtual interface to be provisioned.
	//
	// Default: None
	NewPublicVirtualInterfaceAllocation *NewPublicVirtualInterfaceAllocation `locationName:"newPublicVirtualInterfaceAllocation" type:"structure" required:"true"`

	// The AWS account that will own the new public virtual interface.
	//
	// Default: None
	OwnerAccount *string `locationName:"ownerAccount" type:"string" required:"true"`

	metadataAllocatePublicVirtualInterfaceInput `json:"-" xml:"-"`
}

type metadataAllocatePublicVirtualInterfaceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AllocatePublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocatePublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Container for the parameters to the ConfirmConnection operation.
type ConfirmConnectionInput struct {
	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	metadataConfirmConnectionInput `json:"-" xml:"-"`
}

type metadataConfirmConnectionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfirmConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmConnectionInput) GoString() string {
	return s.String()
}

// The response received when ConfirmConnection is called.
type ConfirmConnectionOutput struct {
	// State of the connection.   Ordering: The initial state of a hosted connection
	// provisioned on an interconnect. The connection stays in the ordering state
	// until the owner of the hosted connection confirms or declines the connection
	// order.  Requested: The initial state of a standard connection. The connection
	// stays in the requested state until the Letter of Authorization (LOA) is sent
	// to the customer.  Pending: The connection has been approved, and is being
	// initialized.  Available: The network link is up, and the connection is ready
	// for use.  Down: The network link is down.  Deleted: The connection has been
	// deleted.  Rejected: A hosted connection in the 'Ordering' state will enter
	// the 'Rejected' state if it is deleted by the end customer.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"ConnectionState"`

	metadataConfirmConnectionOutput `json:"-" xml:"-"`
}

type metadataConfirmConnectionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfirmConnectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmConnectionOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the ConfirmPrivateVirtualInterface operation.
type ConfirmPrivateVirtualInterfaceInput struct {
	// ID of the virtual private gateway that will be attached to the virtual interface.
	//
	//  A virtual private gateway can be managed via the Amazon Virtual Private
	// Cloud (VPC) console or the EC2 CreateVpnGateway (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-CreateVpnGateway.html)
	// action.
	//
	// Default: None
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string" required:"true"`

	// ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`

	metadataConfirmPrivateVirtualInterfaceInput `json:"-" xml:"-"`
}

type metadataConfirmPrivateVirtualInterfaceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfirmPrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// The response received when ConfirmPrivateVirtualInterface is called.
type ConfirmPrivateVirtualInterfaceOutput struct {
	// State of the virtual interface.   Confirming: The creation of the virtual
	// interface is pending confirmation from the virtual interface owner. If the
	// owner of the virtual interface is different from the owner of the connection
	// on which it is provisioned, then the virtual interface will remain in this
	// state until it is confirmed by the virtual interface owner.  Verifying: This
	// state only applies to public virtual interfaces. Each public virtual interface
	// needs validation before the virtual interface can be created.  Pending: A
	// virtual interface is in this state from the time that it is created until
	// the virtual interface is ready to forward traffic.  Available: A virtual
	// interface that is able to forward traffic.  Deleting: A virtual interface
	// is in this state immediately after calling DeleteVirtualInterface until it
	// can no longer forward traffic.  Deleted: A virtual interface that cannot
	// forward traffic.  Rejected: The virtual interface owner has declined creation
	// of the virtual interface. If a virtual interface in the 'Confirming' state
	// is deleted by the virtual interface owner, the virtual interface will enter
	// the 'Rejected' state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`

	metadataConfirmPrivateVirtualInterfaceOutput `json:"-" xml:"-"`
}

type metadataConfirmPrivateVirtualInterfaceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfirmPrivateVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPrivateVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the ConfirmPublicVirtualInterface operation.
type ConfirmPublicVirtualInterfaceInput struct {
	// ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`

	metadataConfirmPublicVirtualInterfaceInput `json:"-" xml:"-"`
}

type metadataConfirmPublicVirtualInterfaceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfirmPublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// The response received when ConfirmPublicVirtualInterface is called.
type ConfirmPublicVirtualInterfaceOutput struct {
	// State of the virtual interface.   Confirming: The creation of the virtual
	// interface is pending confirmation from the virtual interface owner. If the
	// owner of the virtual interface is different from the owner of the connection
	// on which it is provisioned, then the virtual interface will remain in this
	// state until it is confirmed by the virtual interface owner.  Verifying: This
	// state only applies to public virtual interfaces. Each public virtual interface
	// needs validation before the virtual interface can be created.  Pending: A
	// virtual interface is in this state from the time that it is created until
	// the virtual interface is ready to forward traffic.  Available: A virtual
	// interface that is able to forward traffic.  Deleting: A virtual interface
	// is in this state immediately after calling DeleteVirtualInterface until it
	// can no longer forward traffic.  Deleted: A virtual interface that cannot
	// forward traffic.  Rejected: The virtual interface owner has declined creation
	// of the virtual interface. If a virtual interface in the 'Confirming' state
	// is deleted by the virtual interface owner, the virtual interface will enter
	// the 'Rejected' state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`

	metadataConfirmPublicVirtualInterfaceOutput `json:"-" xml:"-"`
}

type metadataConfirmPublicVirtualInterfaceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ConfirmPublicVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfirmPublicVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// A connection represents the physical network connection between the AWS Direct
// Connect location and the customer.
type Connection struct {
	// Bandwidth of the connection.
	//
	// Example: 1Gbps (for regular connections), or 500Mbps (for hosted connections)
	//
	// Default: None
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The name of the connection.
	//
	// Example: "My Connection to AWS"
	//
	// Default: None
	ConnectionName *string `locationName:"connectionName" type:"string"`

	// State of the connection.   Ordering: The initial state of a hosted connection
	// provisioned on an interconnect. The connection stays in the ordering state
	// until the owner of the hosted connection confirms or declines the connection
	// order.  Requested: The initial state of a standard connection. The connection
	// stays in the requested state until the Letter of Authorization (LOA) is sent
	// to the customer.  Pending: The connection has been approved, and is being
	// initialized.  Available: The network link is up, and the connection is ready
	// for use.  Down: The network link is down.  Deleted: The connection has been
	// deleted.  Rejected: A hosted connection in the 'Ordering' state will enter
	// the 'Rejected' state if it is deleted by the end customer.
	ConnectionState *string `locationName:"connectionState" type:"string" enum:"ConnectionState"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string"`

	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	PartnerName *string `locationName:"partnerName" type:"string"`

	// The AWS region where the connection is located.
	//
	// Example: us-east-1
	//
	// Default: None
	Region *string `locationName:"region" type:"string"`

	// The VLAN ID.
	//
	// Example: 101
	Vlan *int64 `locationName:"vlan" type:"integer"`

	metadataConnection `json:"-" xml:"-"`
}

type metadataConnection struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Connection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connection) GoString() string {
	return s.String()
}

// A structure containing a list of connections.
type Connections struct {
	// A list of connections.
	Connections []*Connection `locationName:"connections" type:"list"`

	metadataConnections `json:"-" xml:"-"`
}

type metadataConnections struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Connections) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Connections) GoString() string {
	return s.String()
}

// Container for the parameters to the CreateConnection operation.
type CreateConnectionInput struct {
	// Bandwidth of the connection.
	//
	// Example: 1Gbps
	//
	// Default: None
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The name of the connection.
	//
	// Example: "My Connection to AWS"
	//
	// Default: None
	ConnectionName *string `locationName:"connectionName" type:"string" required:"true"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string" required:"true"`

	metadataCreateConnectionInput `json:"-" xml:"-"`
}

type metadataCreateConnectionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateConnectionInput) GoString() string {
	return s.String()
}

// Container for the parameters to the CreateInterconnect operation.
type CreateInterconnectInput struct {
	// The port bandwidth
	//
	// Example: 1Gbps
	//
	// Default: None
	//
	// Available values: 1Gbps,10Gbps
	Bandwidth *string `locationName:"bandwidth" type:"string" required:"true"`

	// The name of the interconnect.
	//
	// Example: "1G Interconnect to AWS"
	//
	// Default: None
	InterconnectName *string `locationName:"interconnectName" type:"string" required:"true"`

	// Where the interconnect is located
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string" required:"true"`

	metadataCreateInterconnectInput `json:"-" xml:"-"`
}

type metadataCreateInterconnectInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInterconnectInput) GoString() string {
	return s.String()
}

// Container for the parameters to the CreatePrivateVirtualInterface operation.
type CreatePrivateVirtualInterfaceInput struct {
	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the private virtual interface to be created.
	//
	// Default: None
	NewPrivateVirtualInterface *NewPrivateVirtualInterface `locationName:"newPrivateVirtualInterface" type:"structure" required:"true"`

	metadataCreatePrivateVirtualInterfaceInput `json:"-" xml:"-"`
}

type metadataCreatePrivateVirtualInterfaceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreatePrivateVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePrivateVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Container for the parameters to the CreatePublicVirtualInterface operation.
type CreatePublicVirtualInterfaceInput struct {
	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	// Detailed information for the public virtual interface to be created.
	//
	// Default: None
	NewPublicVirtualInterface *NewPublicVirtualInterface `locationName:"newPublicVirtualInterface" type:"structure" required:"true"`

	metadataCreatePublicVirtualInterfaceInput `json:"-" xml:"-"`
}

type metadataCreatePublicVirtualInterfaceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreatePublicVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePublicVirtualInterfaceInput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteConnection operation.
type DeleteConnectionInput struct {
	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string" required:"true"`

	metadataDeleteConnectionInput `json:"-" xml:"-"`
}

type metadataDeleteConnectionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteConnectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteConnectionInput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteInterconnect operation.
type DeleteInterconnectInput struct {
	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`

	metadataDeleteInterconnectInput `json:"-" xml:"-"`
}

type metadataDeleteInterconnectInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInterconnectInput) GoString() string {
	return s.String()
}

// The response received when DeleteInterconnect is called.
type DeleteInterconnectOutput struct {
	// State of the interconnect.   Requested: The initial state of an interconnect.
	// The interconnect stays in the requested state until the Letter of Authorization
	// (LOA) is sent to the customer.  Pending: The interconnect has been approved,
	// and is being initialized.  Available: The network link is up, and the interconnect
	// is ready for use.  Down: The network link is down.  Deleted: The interconnect
	// has been deleted.
	InterconnectState *string `locationName:"interconnectState" type:"string" enum:"InterconnectState"`

	metadataDeleteInterconnectOutput `json:"-" xml:"-"`
}

type metadataDeleteInterconnectOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteInterconnectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteInterconnectOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DeleteVirtualInterface operation.
type DeleteVirtualInterfaceInput struct {
	// ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string" required:"true"`

	metadataDeleteVirtualInterfaceInput `json:"-" xml:"-"`
}

type metadataDeleteVirtualInterfaceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVirtualInterfaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualInterfaceInput) GoString() string {
	return s.String()
}

// The response received when DeleteVirtualInterface is called.
type DeleteVirtualInterfaceOutput struct {
	// State of the virtual interface.   Confirming: The creation of the virtual
	// interface is pending confirmation from the virtual interface owner. If the
	// owner of the virtual interface is different from the owner of the connection
	// on which it is provisioned, then the virtual interface will remain in this
	// state until it is confirmed by the virtual interface owner.  Verifying: This
	// state only applies to public virtual interfaces. Each public virtual interface
	// needs validation before the virtual interface can be created.  Pending: A
	// virtual interface is in this state from the time that it is created until
	// the virtual interface is ready to forward traffic.  Available: A virtual
	// interface that is able to forward traffic.  Deleting: A virtual interface
	// is in this state immediately after calling DeleteVirtualInterface until it
	// can no longer forward traffic.  Deleted: A virtual interface that cannot
	// forward traffic.  Rejected: The virtual interface owner has declined creation
	// of the virtual interface. If a virtual interface in the 'Confirming' state
	// is deleted by the virtual interface owner, the virtual interface will enter
	// the 'Rejected' state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`

	metadataDeleteVirtualInterfaceOutput `json:"-" xml:"-"`
}

type metadataDeleteVirtualInterfaceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteVirtualInterfaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteVirtualInterfaceOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeConnections operation.
type DescribeConnectionsInput struct {
	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	metadataDescribeConnectionsInput `json:"-" xml:"-"`
}

type metadataDescribeConnectionsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeConnectionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsInput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeConnectionsOnInterconnect operation.
type DescribeConnectionsOnInterconnectInput struct {
	// ID of the interconnect on which a list of connection is provisioned.
	//
	// Example: dxcon-abc123
	//
	// Default: None
	InterconnectId *string `locationName:"interconnectId" type:"string" required:"true"`

	metadataDescribeConnectionsOnInterconnectInput `json:"-" xml:"-"`
}

type metadataDescribeConnectionsOnInterconnectInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeConnectionsOnInterconnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeConnectionsOnInterconnectInput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeInterconnects operation.
type DescribeInterconnectsInput struct {
	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	InterconnectId *string `locationName:"interconnectId" type:"string"`

	metadataDescribeInterconnectsInput `json:"-" xml:"-"`
}

type metadataDescribeInterconnectsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeInterconnectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectsInput) GoString() string {
	return s.String()
}

// A structure containing a list of interconnects.
type DescribeInterconnectsOutput struct {
	// A list of interconnects.
	Interconnects []*Interconnect `locationName:"interconnects" type:"list"`

	metadataDescribeInterconnectsOutput `json:"-" xml:"-"`
}

type metadataDescribeInterconnectsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeInterconnectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInterconnectsOutput) GoString() string {
	return s.String()
}

type DescribeLocationsInput struct {
	metadataDescribeLocationsInput `json:"-" xml:"-"`
}

type metadataDescribeLocationsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeLocationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationsInput) GoString() string {
	return s.String()
}

type DescribeLocationsOutput struct {
	Locations []*Location `locationName:"locations" type:"list"`

	metadataDescribeLocationsOutput `json:"-" xml:"-"`
}

type metadataDescribeLocationsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeLocationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeLocationsOutput) GoString() string {
	return s.String()
}

type DescribeVirtualGatewaysInput struct {
	metadataDescribeVirtualGatewaysInput `json:"-" xml:"-"`
}

type metadataDescribeVirtualGatewaysInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeVirtualGatewaysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualGatewaysInput) GoString() string {
	return s.String()
}

// A structure containing a list of virtual private gateways.
type DescribeVirtualGatewaysOutput struct {
	// A list of virtual private gateways.
	VirtualGateways []*VirtualGateway `locationName:"virtualGateways" type:"list"`

	metadataDescribeVirtualGatewaysOutput `json:"-" xml:"-"`
}

type metadataDescribeVirtualGatewaysOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeVirtualGatewaysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualGatewaysOutput) GoString() string {
	return s.String()
}

// Container for the parameters to the DescribeVirtualInterfaces operation.
type DescribeVirtualInterfacesInput struct {
	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`

	metadataDescribeVirtualInterfacesInput `json:"-" xml:"-"`
}

type metadataDescribeVirtualInterfacesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeVirtualInterfacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualInterfacesInput) GoString() string {
	return s.String()
}

// A structure containing a list of virtual interfaces.
type DescribeVirtualInterfacesOutput struct {
	// A list of virtual interfaces.
	VirtualInterfaces []*VirtualInterface `locationName:"virtualInterfaces" type:"list"`

	metadataDescribeVirtualInterfacesOutput `json:"-" xml:"-"`
}

type metadataDescribeVirtualInterfacesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeVirtualInterfacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeVirtualInterfacesOutput) GoString() string {
	return s.String()
}

// An interconnect is a connection that can host other connections.
//
// Like a standard AWS Direct Connect connection, an interconnect represents
// the physical connection between an AWS Direct Connect partner's network and
// a specific Direct Connect location. An AWS Direct Connect partner who owns
// an interconnect can provision hosted connections on the interconnect for
// their end customers, thereby providing the end customers with connectivity
// to AWS services.
//
// The resources of the interconnect, including bandwidth and VLAN numbers,
// are shared by all of the hosted connections on the interconnect, and the
// owner of the interconnect determines how these resources are assigned.
type Interconnect struct {
	// Bandwidth of the connection.
	//
	// Example: 1Gbps
	//
	// Default: None
	Bandwidth *string `locationName:"bandwidth" type:"string"`

	// The ID of the interconnect.
	//
	// Example: dxcon-abc123
	InterconnectId *string `locationName:"interconnectId" type:"string"`

	// The name of the interconnect.
	//
	// Example: "1G Interconnect to AWS"
	InterconnectName *string `locationName:"interconnectName" type:"string"`

	// State of the interconnect.   Requested: The initial state of an interconnect.
	// The interconnect stays in the requested state until the Letter of Authorization
	// (LOA) is sent to the customer.  Pending: The interconnect has been approved,
	// and is being initialized.  Available: The network link is up, and the interconnect
	// is ready for use.  Down: The network link is down.  Deleted: The interconnect
	// has been deleted.
	InterconnectState *string `locationName:"interconnectState" type:"string" enum:"InterconnectState"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string"`

	// The AWS region where the connection is located.
	//
	// Example: us-east-1
	//
	// Default: None
	Region *string `locationName:"region" type:"string"`

	metadataInterconnect `json:"-" xml:"-"`
}

type metadataInterconnect struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Interconnect) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Interconnect) GoString() string {
	return s.String()
}

// An AWS Direct Connect location where connections and interconnects can be
// requested.
type Location struct {
	// The code used to indicate the AWS Direct Connect location.
	LocationCode *string `locationName:"locationCode" type:"string"`

	// The name of the AWS Direct Connect location. The name includes the colocation
	// partner name and the physical site of the lit building.
	LocationName *string `locationName:"locationName" type:"string"`

	metadataLocation `json:"-" xml:"-"`
}

type metadataLocation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Location) GoString() string {
	return s.String()
}

// A structure containing information about a new private virtual interface.
type NewPrivateVirtualInterface struct {
	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The ID of the virtual private gateway to a VPC. This only applies to private
	// virtual interfaces.
	//
	// Example: vgw-123er56
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string" required:"true"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`

	metadataNewPrivateVirtualInterface `json:"-" xml:"-"`
}

type metadataNewPrivateVirtualInterface struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s NewPrivateVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPrivateVirtualInterface) GoString() string {
	return s.String()
}

// A structure containing information about a private virtual interface that
// will be provisioned on a connection.
type NewPrivateVirtualInterfaceAllocation struct {
	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`

	metadataNewPrivateVirtualInterfaceAllocation `json:"-" xml:"-"`
}

type metadataNewPrivateVirtualInterfaceAllocation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s NewPrivateVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPrivateVirtualInterfaceAllocation) GoString() string {
	return s.String()
}

// A structure containing information about a new public virtual interface.
type NewPublicVirtualInterface struct {
	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30
	AmazonAddress *string `locationName:"amazonAddress" type:"string" required:"true"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30
	CustomerAddress *string `locationName:"customerAddress" type:"string" required:"true"`

	// A list of routes to be advertised to the AWS network in this region (public
	// virtual interface) or your VPC (private virtual interface).
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list" required:"true"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`

	metadataNewPublicVirtualInterface `json:"-" xml:"-"`
}

type metadataNewPublicVirtualInterface struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s NewPublicVirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPublicVirtualInterface) GoString() string {
	return s.String()
}

// A structure containing information about a public virtual interface that
// will be provisioned on a connection.
type NewPublicVirtualInterfaceAllocation struct {
	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30
	AmazonAddress *string `locationName:"amazonAddress" type:"string" required:"true"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer" required:"true"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30
	CustomerAddress *string `locationName:"customerAddress" type:"string" required:"true"`

	// A list of routes to be advertised to the AWS network in this region (public
	// virtual interface) or your VPC (private virtual interface).
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list" required:"true"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string" required:"true"`

	// The VLAN ID.
	//
	// Example: 101
	Vlan *int64 `locationName:"vlan" type:"integer" required:"true"`

	metadataNewPublicVirtualInterfaceAllocation `json:"-" xml:"-"`
}

type metadataNewPublicVirtualInterfaceAllocation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s NewPublicVirtualInterfaceAllocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NewPublicVirtualInterfaceAllocation) GoString() string {
	return s.String()
}

// A route filter prefix that the customer can advertise through Border Gateway
// Protocol (BGP) over a public virtual interface.
type RouteFilterPrefix struct {
	// CIDR notation for the advertised route. Multiple routes are separated by
	// commas.
	//
	// Example: 10.10.10.0/24,10.10.11.0/24
	Cidr *string `locationName:"cidr" type:"string"`

	metadataRouteFilterPrefix `json:"-" xml:"-"`
}

type metadataRouteFilterPrefix struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s RouteFilterPrefix) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RouteFilterPrefix) GoString() string {
	return s.String()
}

// You can create one or more AWS Direct Connect private virtual interfaces
// linking to your virtual private gateway.
//
// Virtual private gateways can be managed using the Amazon Virtual Private
// Cloud (Amazon VPC) console or the Amazon EC2 CreateVpnGateway action (http://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-CreateVpnGateway.html).
type VirtualGateway struct {
	// The ID of the virtual private gateway to a VPC. This only applies to private
	// virtual interfaces.
	//
	// Example: vgw-123er56
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// State of the virtual private gateway.   Pending: This is the initial state
	// after calling CreateVpnGateway.  Available: Ready for use by a private virtual
	// interface.  Deleting: This is the initial state after calling DeleteVpnGateway.
	//  Deleted: In this state, a private virtual interface is unable to send traffic
	// over this gateway.
	VirtualGatewayState *string `locationName:"virtualGatewayState" type:"string"`

	metadataVirtualGateway `json:"-" xml:"-"`
}

type metadataVirtualGateway struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VirtualGateway) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualGateway) GoString() string {
	return s.String()
}

// A virtual interface (VLAN) transmits the traffic between the AWS Direct Connect
// location and the customer.
type VirtualInterface struct {
	// IP address assigned to the Amazon interface.
	//
	// Example: 192.168.1.1/30
	AmazonAddress *string `locationName:"amazonAddress" type:"string"`

	// Autonomous system (AS) number for Border Gateway Protocol (BGP) configuration.
	//
	// Example: 65000
	Asn *int64 `locationName:"asn" type:"integer"`

	// Authentication key for BGP configuration.
	//
	// Example: asdf34example
	AuthKey *string `locationName:"authKey" type:"string"`

	// ID of the connection.
	//
	// Example: dxcon-fg5678gh
	//
	// Default: None
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// IP address assigned to the customer interface.
	//
	// Example: 192.168.1.2/30
	CustomerAddress *string `locationName:"customerAddress" type:"string"`

	// Information for generating the customer router configuration.
	CustomerRouterConfig *string `locationName:"customerRouterConfig" type:"string"`

	// Where the connection is located.
	//
	// Example: EqSV5
	//
	// Default: None
	Location *string `locationName:"location" type:"string"`

	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// A list of routes to be advertised to the AWS network in this region (public
	// virtual interface) or your VPC (private virtual interface).
	RouteFilterPrefixes []*RouteFilterPrefix `locationName:"routeFilterPrefixes" type:"list"`

	// The ID of the virtual private gateway to a VPC. This only applies to private
	// virtual interfaces.
	//
	// Example: vgw-123er56
	VirtualGatewayId *string `locationName:"virtualGatewayId" type:"string"`

	// ID of the virtual interface.
	//
	// Example: dxvif-123dfg56
	//
	// Default: None
	VirtualInterfaceId *string `locationName:"virtualInterfaceId" type:"string"`

	// The name of the virtual interface assigned by the customer.
	//
	// Example: "My VPC"
	VirtualInterfaceName *string `locationName:"virtualInterfaceName" type:"string"`

	// State of the virtual interface.   Confirming: The creation of the virtual
	// interface is pending confirmation from the virtual interface owner. If the
	// owner of the virtual interface is different from the owner of the connection
	// on which it is provisioned, then the virtual interface will remain in this
	// state until it is confirmed by the virtual interface owner.  Verifying: This
	// state only applies to public virtual interfaces. Each public virtual interface
	// needs validation before the virtual interface can be created.  Pending: A
	// virtual interface is in this state from the time that it is created until
	// the virtual interface is ready to forward traffic.  Available: A virtual
	// interface that is able to forward traffic.  Deleting: A virtual interface
	// is in this state immediately after calling DeleteVirtualInterface until it
	// can no longer forward traffic.  Deleted: A virtual interface that cannot
	// forward traffic.  Rejected: The virtual interface owner has declined creation
	// of the virtual interface. If a virtual interface in the 'Confirming' state
	// is deleted by the virtual interface owner, the virtual interface will enter
	// the 'Rejected' state.
	VirtualInterfaceState *string `locationName:"virtualInterfaceState" type:"string" enum:"VirtualInterfaceState"`

	// The type of virtual interface.
	//
	// Example: private (Amazon VPC) or public (Amazon S3, Amazon DynamoDB, and
	// so on.)
	VirtualInterfaceType *string `locationName:"virtualInterfaceType" type:"string"`

	// The VLAN ID.
	//
	// Example: 101
	Vlan *int64 `locationName:"vlan" type:"integer"`

	metadataVirtualInterface `json:"-" xml:"-"`
}

type metadataVirtualInterface struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s VirtualInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s VirtualInterface) GoString() string {
	return s.String()
}

// State of the connection.   Ordering: The initial state of a hosted connection
// provisioned on an interconnect. The connection stays in the ordering state
// until the owner of the hosted connection confirms or declines the connection
// order.  Requested: The initial state of a standard connection. The connection
// stays in the requested state until the Letter of Authorization (LOA) is sent
// to the customer.  Pending: The connection has been approved, and is being
// initialized.  Available: The network link is up, and the connection is ready
// for use.  Down: The network link is down.  Deleted: The connection has been
// deleted.  Rejected: A hosted connection in the 'Ordering' state will enter
// the 'Rejected' state if it is deleted by the end customer.
const (
	// @enum ConnectionState
	ConnectionStateOrdering = "ordering"
	// @enum ConnectionState
	ConnectionStateRequested = "requested"
	// @enum ConnectionState
	ConnectionStatePending = "pending"
	// @enum ConnectionState
	ConnectionStateAvailable = "available"
	// @enum ConnectionState
	ConnectionStateDown = "down"
	// @enum ConnectionState
	ConnectionStateDeleting = "deleting"
	// @enum ConnectionState
	ConnectionStateDeleted = "deleted"
	// @enum ConnectionState
	ConnectionStateRejected = "rejected"
)

// State of the interconnect.   Requested: The initial state of an interconnect.
// The interconnect stays in the requested state until the Letter of Authorization
// (LOA) is sent to the customer.  Pending: The interconnect has been approved,
// and is being initialized.  Available: The network link is up, and the interconnect
// is ready for use.  Down: The network link is down.  Deleted: The interconnect
// has been deleted.
const (
	// @enum InterconnectState
	InterconnectStateRequested = "requested"
	// @enum InterconnectState
	InterconnectStatePending = "pending"
	// @enum InterconnectState
	InterconnectStateAvailable = "available"
	// @enum InterconnectState
	InterconnectStateDown = "down"
	// @enum InterconnectState
	InterconnectStateDeleting = "deleting"
	// @enum InterconnectState
	InterconnectStateDeleted = "deleted"
)

// State of the virtual interface.   Confirming: The creation of the virtual
// interface is pending confirmation from the virtual interface owner. If the
// owner of the virtual interface is different from the owner of the connection
// on which it is provisioned, then the virtual interface will remain in this
// state until it is confirmed by the virtual interface owner.  Verifying: This
// state only applies to public virtual interfaces. Each public virtual interface
// needs validation before the virtual interface can be created.  Pending: A
// virtual interface is in this state from the time that it is created until
// the virtual interface is ready to forward traffic.  Available: A virtual
// interface that is able to forward traffic.  Deleting: A virtual interface
// is in this state immediately after calling DeleteVirtualInterface until it
// can no longer forward traffic.  Deleted: A virtual interface that cannot
// forward traffic.  Rejected: The virtual interface owner has declined creation
// of the virtual interface. If a virtual interface in the 'Confirming' state
// is deleted by the virtual interface owner, the virtual interface will enter
// the 'Rejected' state.
const (
	// @enum VirtualInterfaceState
	VirtualInterfaceStateConfirming = "confirming"
	// @enum VirtualInterfaceState
	VirtualInterfaceStateVerifying = "verifying"
	// @enum VirtualInterfaceState
	VirtualInterfaceStatePending = "pending"
	// @enum VirtualInterfaceState
	VirtualInterfaceStateAvailable = "available"
	// @enum VirtualInterfaceState
	VirtualInterfaceStateDeleting = "deleting"
	// @enum VirtualInterfaceState
	VirtualInterfaceStateDeleted = "deleted"
	// @enum VirtualInterfaceState
	VirtualInterfaceStateRejected = "rejected"
)
