// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package devicefarm provides a client for AWS Device Farm.
package devicefarm

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCreateDevicePool = "CreateDevicePool"

// CreateDevicePoolRequest generates a request for the CreateDevicePool operation.
func (c *DeviceFarm) CreateDevicePoolRequest(input *CreateDevicePoolInput) (req *request.Request, output *CreateDevicePoolOutput) {
	op := &request.Operation{
		Name:       opCreateDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDevicePoolInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateDevicePoolOutput{}
	req.Data = output
	return
}

// Creates a device pool.
func (c *DeviceFarm) CreateDevicePool(input *CreateDevicePoolInput) (*CreateDevicePoolOutput, error) {
	req, out := c.CreateDevicePoolRequest(input)
	err := req.Send()
	return out, err
}

const opCreateProject = "CreateProject"

// CreateProjectRequest generates a request for the CreateProject operation.
func (c *DeviceFarm) CreateProjectRequest(input *CreateProjectInput) (req *request.Request, output *CreateProjectOutput) {
	op := &request.Operation{
		Name:       opCreateProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateProjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateProjectOutput{}
	req.Data = output
	return
}

// Creates a new project.
func (c *DeviceFarm) CreateProject(input *CreateProjectInput) (*CreateProjectOutput, error) {
	req, out := c.CreateProjectRequest(input)
	err := req.Send()
	return out, err
}

const opCreateUpload = "CreateUpload"

// CreateUploadRequest generates a request for the CreateUpload operation.
func (c *DeviceFarm) CreateUploadRequest(input *CreateUploadInput) (req *request.Request, output *CreateUploadOutput) {
	op := &request.Operation{
		Name:       opCreateUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateUploadOutput{}
	req.Data = output
	return
}

// Uploads an app or test scripts.
func (c *DeviceFarm) CreateUpload(input *CreateUploadInput) (*CreateUploadOutput, error) {
	req, out := c.CreateUploadRequest(input)
	err := req.Send()
	return out, err
}

const opGetAccountSettings = "GetAccountSettings"

// GetAccountSettingsRequest generates a request for the GetAccountSettings operation.
func (c *DeviceFarm) GetAccountSettingsRequest(input *GetAccountSettingsInput) (req *request.Request, output *GetAccountSettingsOutput) {
	op := &request.Operation{
		Name:       opGetAccountSettings,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAccountSettingsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetAccountSettingsOutput{}
	req.Data = output
	return
}

// Returns the number of unmetered iOS and/or unmetered Android devices that
// have been purchased by the account.
func (c *DeviceFarm) GetAccountSettings(input *GetAccountSettingsInput) (*GetAccountSettingsOutput, error) {
	req, out := c.GetAccountSettingsRequest(input)
	err := req.Send()
	return out, err
}

const opGetDevice = "GetDevice"

// GetDeviceRequest generates a request for the GetDevice operation.
func (c *DeviceFarm) GetDeviceRequest(input *GetDeviceInput) (req *request.Request, output *GetDeviceOutput) {
	op := &request.Operation{
		Name:       opGetDevice,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDeviceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDeviceOutput{}
	req.Data = output
	return
}

// Gets information about a unique device type.
func (c *DeviceFarm) GetDevice(input *GetDeviceInput) (*GetDeviceOutput, error) {
	req, out := c.GetDeviceRequest(input)
	err := req.Send()
	return out, err
}

const opGetDevicePool = "GetDevicePool"

// GetDevicePoolRequest generates a request for the GetDevicePool operation.
func (c *DeviceFarm) GetDevicePoolRequest(input *GetDevicePoolInput) (req *request.Request, output *GetDevicePoolOutput) {
	op := &request.Operation{
		Name:       opGetDevicePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDevicePoolInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDevicePoolOutput{}
	req.Data = output
	return
}

// Gets information about a device pool.
func (c *DeviceFarm) GetDevicePool(input *GetDevicePoolInput) (*GetDevicePoolOutput, error) {
	req, out := c.GetDevicePoolRequest(input)
	err := req.Send()
	return out, err
}

const opGetDevicePoolCompatibility = "GetDevicePoolCompatibility"

// GetDevicePoolCompatibilityRequest generates a request for the GetDevicePoolCompatibility operation.
func (c *DeviceFarm) GetDevicePoolCompatibilityRequest(input *GetDevicePoolCompatibilityInput) (req *request.Request, output *GetDevicePoolCompatibilityOutput) {
	op := &request.Operation{
		Name:       opGetDevicePoolCompatibility,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDevicePoolCompatibilityInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetDevicePoolCompatibilityOutput{}
	req.Data = output
	return
}

// Gets information about compatibility with a device pool.
func (c *DeviceFarm) GetDevicePoolCompatibility(input *GetDevicePoolCompatibilityInput) (*GetDevicePoolCompatibilityOutput, error) {
	req, out := c.GetDevicePoolCompatibilityRequest(input)
	err := req.Send()
	return out, err
}

const opGetJob = "GetJob"

// GetJobRequest generates a request for the GetJob operation.
func (c *DeviceFarm) GetJobRequest(input *GetJobInput) (req *request.Request, output *GetJobOutput) {
	op := &request.Operation{
		Name:       opGetJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetJobOutput{}
	req.Data = output
	return
}

// Gets information about a job.
func (c *DeviceFarm) GetJob(input *GetJobInput) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	err := req.Send()
	return out, err
}

const opGetProject = "GetProject"

// GetProjectRequest generates a request for the GetProject operation.
func (c *DeviceFarm) GetProjectRequest(input *GetProjectInput) (req *request.Request, output *GetProjectOutput) {
	op := &request.Operation{
		Name:       opGetProject,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetProjectInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetProjectOutput{}
	req.Data = output
	return
}

// Gets information about a project.
func (c *DeviceFarm) GetProject(input *GetProjectInput) (*GetProjectOutput, error) {
	req, out := c.GetProjectRequest(input)
	err := req.Send()
	return out, err
}

const opGetRun = "GetRun"

// GetRunRequest generates a request for the GetRun operation.
func (c *DeviceFarm) GetRunRequest(input *GetRunInput) (req *request.Request, output *GetRunOutput) {
	op := &request.Operation{
		Name:       opGetRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRunInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetRunOutput{}
	req.Data = output
	return
}

// Gets information about a run.
func (c *DeviceFarm) GetRun(input *GetRunInput) (*GetRunOutput, error) {
	req, out := c.GetRunRequest(input)
	err := req.Send()
	return out, err
}

const opGetSuite = "GetSuite"

// GetSuiteRequest generates a request for the GetSuite operation.
func (c *DeviceFarm) GetSuiteRequest(input *GetSuiteInput) (req *request.Request, output *GetSuiteOutput) {
	op := &request.Operation{
		Name:       opGetSuite,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSuiteInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetSuiteOutput{}
	req.Data = output
	return
}

// Gets information about a suite.
func (c *DeviceFarm) GetSuite(input *GetSuiteInput) (*GetSuiteOutput, error) {
	req, out := c.GetSuiteRequest(input)
	err := req.Send()
	return out, err
}

const opGetTest = "GetTest"

// GetTestRequest generates a request for the GetTest operation.
func (c *DeviceFarm) GetTestRequest(input *GetTestInput) (req *request.Request, output *GetTestOutput) {
	op := &request.Operation{
		Name:       opGetTest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTestInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTestOutput{}
	req.Data = output
	return
}

// Gets information about a test.
func (c *DeviceFarm) GetTest(input *GetTestInput) (*GetTestOutput, error) {
	req, out := c.GetTestRequest(input)
	err := req.Send()
	return out, err
}

const opGetUpload = "GetUpload"

// GetUploadRequest generates a request for the GetUpload operation.
func (c *DeviceFarm) GetUploadRequest(input *GetUploadInput) (req *request.Request, output *GetUploadOutput) {
	op := &request.Operation{
		Name:       opGetUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUploadInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetUploadOutput{}
	req.Data = output
	return
}

// Gets information about an upload.
func (c *DeviceFarm) GetUpload(input *GetUploadInput) (*GetUploadOutput, error) {
	req, out := c.GetUploadRequest(input)
	err := req.Send()
	return out, err
}

const opListArtifacts = "ListArtifacts"

// ListArtifactsRequest generates a request for the ListArtifacts operation.
func (c *DeviceFarm) ListArtifactsRequest(input *ListArtifactsInput) (req *request.Request, output *ListArtifactsOutput) {
	op := &request.Operation{
		Name:       opListArtifacts,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListArtifactsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListArtifactsOutput{}
	req.Data = output
	return
}

// Gets information about artifacts.
func (c *DeviceFarm) ListArtifacts(input *ListArtifactsInput) (*ListArtifactsOutput, error) {
	req, out := c.ListArtifactsRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListArtifactsPages(input *ListArtifactsInput, fn func(p *ListArtifactsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListArtifactsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListArtifactsOutput), lastPage)
	})
}

const opListDevicePools = "ListDevicePools"

// ListDevicePoolsRequest generates a request for the ListDevicePools operation.
func (c *DeviceFarm) ListDevicePoolsRequest(input *ListDevicePoolsInput) (req *request.Request, output *ListDevicePoolsOutput) {
	op := &request.Operation{
		Name:       opListDevicePools,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicePoolsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDevicePoolsOutput{}
	req.Data = output
	return
}

// Gets information about device pools.
func (c *DeviceFarm) ListDevicePools(input *ListDevicePoolsInput) (*ListDevicePoolsOutput, error) {
	req, out := c.ListDevicePoolsRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListDevicePoolsPages(input *ListDevicePoolsInput, fn func(p *ListDevicePoolsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDevicePoolsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDevicePoolsOutput), lastPage)
	})
}

const opListDevices = "ListDevices"

// ListDevicesRequest generates a request for the ListDevices operation.
func (c *DeviceFarm) ListDevicesRequest(input *ListDevicesInput) (req *request.Request, output *ListDevicesOutput) {
	op := &request.Operation{
		Name:       opListDevices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDevicesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListDevicesOutput{}
	req.Data = output
	return
}

// Gets information about unique device types.
func (c *DeviceFarm) ListDevices(input *ListDevicesInput) (*ListDevicesOutput, error) {
	req, out := c.ListDevicesRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListDevicesPages(input *ListDevicesInput, fn func(p *ListDevicesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListDevicesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListDevicesOutput), lastPage)
	})
}

const opListJobs = "ListJobs"

// ListJobsRequest generates a request for the ListJobs operation.
func (c *DeviceFarm) ListJobsRequest(input *ListJobsInput) (req *request.Request, output *ListJobsOutput) {
	op := &request.Operation{
		Name:       opListJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListJobsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListJobsOutput{}
	req.Data = output
	return
}

// Gets information about jobs.
func (c *DeviceFarm) ListJobs(input *ListJobsInput) (*ListJobsOutput, error) {
	req, out := c.ListJobsRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListJobsPages(input *ListJobsInput, fn func(p *ListJobsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListJobsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListJobsOutput), lastPage)
	})
}

const opListProjects = "ListProjects"

// ListProjectsRequest generates a request for the ListProjects operation.
func (c *DeviceFarm) ListProjectsRequest(input *ListProjectsInput) (req *request.Request, output *ListProjectsOutput) {
	op := &request.Operation{
		Name:       opListProjects,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProjectsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListProjectsOutput{}
	req.Data = output
	return
}

// Gets information about projects.
func (c *DeviceFarm) ListProjects(input *ListProjectsInput) (*ListProjectsOutput, error) {
	req, out := c.ListProjectsRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListProjectsPages(input *ListProjectsInput, fn func(p *ListProjectsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListProjectsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListProjectsOutput), lastPage)
	})
}

const opListRuns = "ListRuns"

// ListRunsRequest generates a request for the ListRuns operation.
func (c *DeviceFarm) ListRunsRequest(input *ListRunsInput) (req *request.Request, output *ListRunsOutput) {
	op := &request.Operation{
		Name:       opListRuns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRunsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListRunsOutput{}
	req.Data = output
	return
}

// Gets information about runs.
func (c *DeviceFarm) ListRuns(input *ListRunsInput) (*ListRunsOutput, error) {
	req, out := c.ListRunsRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListRunsPages(input *ListRunsInput, fn func(p *ListRunsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListRunsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListRunsOutput), lastPage)
	})
}

const opListSamples = "ListSamples"

// ListSamplesRequest generates a request for the ListSamples operation.
func (c *DeviceFarm) ListSamplesRequest(input *ListSamplesInput) (req *request.Request, output *ListSamplesOutput) {
	op := &request.Operation{
		Name:       opListSamples,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSamplesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListSamplesOutput{}
	req.Data = output
	return
}

// Gets information about samples.
func (c *DeviceFarm) ListSamples(input *ListSamplesInput) (*ListSamplesOutput, error) {
	req, out := c.ListSamplesRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListSamplesPages(input *ListSamplesInput, fn func(p *ListSamplesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSamplesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSamplesOutput), lastPage)
	})
}

const opListSuites = "ListSuites"

// ListSuitesRequest generates a request for the ListSuites operation.
func (c *DeviceFarm) ListSuitesRequest(input *ListSuitesInput) (req *request.Request, output *ListSuitesOutput) {
	op := &request.Operation{
		Name:       opListSuites,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSuitesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListSuitesOutput{}
	req.Data = output
	return
}

// Gets information about suites.
func (c *DeviceFarm) ListSuites(input *ListSuitesInput) (*ListSuitesOutput, error) {
	req, out := c.ListSuitesRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListSuitesPages(input *ListSuitesInput, fn func(p *ListSuitesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListSuitesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListSuitesOutput), lastPage)
	})
}

const opListTests = "ListTests"

// ListTestsRequest generates a request for the ListTests operation.
func (c *DeviceFarm) ListTestsRequest(input *ListTestsInput) (req *request.Request, output *ListTestsOutput) {
	op := &request.Operation{
		Name:       opListTests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTestsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListTestsOutput{}
	req.Data = output
	return
}

// Gets information about tests.
func (c *DeviceFarm) ListTests(input *ListTestsInput) (*ListTestsOutput, error) {
	req, out := c.ListTestsRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListTestsPages(input *ListTestsInput, fn func(p *ListTestsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListTestsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListTestsOutput), lastPage)
	})
}

const opListUniqueProblems = "ListUniqueProblems"

// ListUniqueProblemsRequest generates a request for the ListUniqueProblems operation.
func (c *DeviceFarm) ListUniqueProblemsRequest(input *ListUniqueProblemsInput) (req *request.Request, output *ListUniqueProblemsOutput) {
	op := &request.Operation{
		Name:       opListUniqueProblems,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUniqueProblemsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListUniqueProblemsOutput{}
	req.Data = output
	return
}

// Gets information about unique problems.
func (c *DeviceFarm) ListUniqueProblems(input *ListUniqueProblemsInput) (*ListUniqueProblemsOutput, error) {
	req, out := c.ListUniqueProblemsRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListUniqueProblemsPages(input *ListUniqueProblemsInput, fn func(p *ListUniqueProblemsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListUniqueProblemsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListUniqueProblemsOutput), lastPage)
	})
}

const opListUploads = "ListUploads"

// ListUploadsRequest generates a request for the ListUploads operation.
func (c *DeviceFarm) ListUploadsRequest(input *ListUploadsInput) (req *request.Request, output *ListUploadsOutput) {
	op := &request.Operation{
		Name:       opListUploads,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUploadsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListUploadsOutput{}
	req.Data = output
	return
}

// Gets information about uploads.
func (c *DeviceFarm) ListUploads(input *ListUploadsInput) (*ListUploadsOutput, error) {
	req, out := c.ListUploadsRequest(input)
	err := req.Send()
	return out, err
}

func (c *DeviceFarm) ListUploadsPages(input *ListUploadsInput, fn func(p *ListUploadsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListUploadsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListUploadsOutput), lastPage)
	})
}

const opScheduleRun = "ScheduleRun"

// ScheduleRunRequest generates a request for the ScheduleRun operation.
func (c *DeviceFarm) ScheduleRunRequest(input *ScheduleRunInput) (req *request.Request, output *ScheduleRunOutput) {
	op := &request.Operation{
		Name:       opScheduleRun,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScheduleRunInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ScheduleRunOutput{}
	req.Data = output
	return
}

// Schedules a run.
func (c *DeviceFarm) ScheduleRun(input *ScheduleRunInput) (*ScheduleRunOutput, error) {
	req, out := c.ScheduleRunRequest(input)
	err := req.Send()
	return out, err
}

// A container for account-level settings within AWS Device Farm.
type AccountSettings struct {
	// The AWS account number specified in the AccountSettings container.
	AwsAccountNumber *string `locationName:"awsAccountNumber" min:"2" type:"string"`

	// Returns the unmetered devices you have purchased.
	UnmeteredDevices map[string]*int64 `locationName:"unmeteredDevices" type:"map"`

	metadataAccountSettings `json:"-" xml:"-"`
}

type metadataAccountSettings struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AccountSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountSettings) GoString() string {
	return s.String()
}

// Represents the output of a test. Examples of artifacts include logs and screenshots.
type Artifact struct {
	// The artifact's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The artifact's file extension.
	Extension *string `locationName:"extension" type:"string"`

	// The artifact's name.
	Name *string `locationName:"name" type:"string"`

	// The artifact's type.
	//
	// Allowed values include the following:
	//
	//  APPIUM_JAVA_OUTPUT: The Appium Java output type.
	//
	// APPIUM_JAVA_XML_OUTPUT: The Appium Java XML output type.
	//
	// APPIUM_SERVER_OUTPUT: The Appium server output type.
	//
	// AUTOMATION_OUTPUT: The automation output type.
	//
	// CALABASH_JSON_OUTPUT: The Calabash JSON output type.
	//
	// CALABASH_JAVA_XML_OUTPUT: The Calabash Java XML output type.
	//
	// CALABASH_PRETTY_OUTPUT: The Calabash pretty output type.
	//
	// CALABASH_STANDARD_OUTPUT: The Calabash standard output type.
	//
	// DEVICE_LOG: The device log type.
	//
	// EXERCISER_MONKEY_OUTPUT: For Android, the artifact (log) generated by an
	// Android fuzz test.
	//
	// INSTRUMENTATION_OUTPUT: The instrumentation type.
	//
	// MESSAGE_LOG: The message log type.
	//
	// RESULT_LOG: The result log type.
	//
	// SCREENSHOT: The screenshot type.
	//
	// SERVICE_LOG: The service log type.
	//
	// UNKNOWN: An unknown type.
	Type *string `locationName:"type" type:"string" enum:"ArtifactType"`

	// The pre-signed Amazon S3 URL that can be used with a corresponding GET request
	// to download the artifact's file.
	Url *string `locationName:"url" type:"string"`

	metadataArtifact `json:"-" xml:"-"`
}

type metadataArtifact struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Artifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Artifact) GoString() string {
	return s.String()
}

// Represents the amount of CPU that an app is using on a physical device.
//
// Note that this does not represent system-wide CPU usage.
type CPU struct {
	// The CPU's architecture, for example x86 or ARM.
	Architecture *string `locationName:"architecture" type:"string"`

	// The clock speed of the device's CPU, expressed in hertz (Hz). For example,
	// a 1.2 GHz CPU is expressed as 1200000000.
	Clock *float64 `locationName:"clock" type:"double"`

	// The CPU's frequency.
	Frequency *string `locationName:"frequency" type:"string"`

	metadataCPU `json:"-" xml:"-"`
}

type metadataCPU struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CPU) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CPU) GoString() string {
	return s.String()
}

// Represents entity counters.
type Counters struct {
	// The number of errored entities.
	Errored *int64 `locationName:"errored" type:"integer"`

	// The number of failed entities.
	Failed *int64 `locationName:"failed" type:"integer"`

	// The number of passed entities.
	Passed *int64 `locationName:"passed" type:"integer"`

	// The number of skipped entities.
	Skipped *int64 `locationName:"skipped" type:"integer"`

	// The number of stopped entities.
	Stopped *int64 `locationName:"stopped" type:"integer"`

	// The total number of entities.
	Total *int64 `locationName:"total" type:"integer"`

	// The number of warned entities.
	Warned *int64 `locationName:"warned" type:"integer"`

	metadataCounters `json:"-" xml:"-"`
}

type metadataCounters struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Counters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Counters) GoString() string {
	return s.String()
}

// Represents a request to the create device pool operation.
type CreateDevicePoolInput struct {
	// The device pool's description.
	Description *string `locationName:"description" type:"string"`

	// The device pool's name.
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the project for the device pool.
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// The device pool's rules.
	Rules []*Rule `locationName:"rules" type:"list" required:"true"`

	metadataCreateDevicePoolInput `json:"-" xml:"-"`
}

type metadataCreateDevicePoolInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDevicePoolInput) GoString() string {
	return s.String()
}

// Represents the result of a create device pool request.
type CreateDevicePoolOutput struct {
	// The newly created device pool.
	DevicePool *DevicePool `locationName:"devicePool" type:"structure"`

	metadataCreateDevicePoolOutput `json:"-" xml:"-"`
}

type metadataCreateDevicePoolOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateDevicePoolOutput) GoString() string {
	return s.String()
}

// Represents a request to the create project operation.
type CreateProjectInput struct {
	// The project's name.
	Name *string `locationName:"name" type:"string" required:"true"`

	metadataCreateProjectInput `json:"-" xml:"-"`
}

type metadataCreateProjectInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectInput) GoString() string {
	return s.String()
}

// Represents the result of a create project request.
type CreateProjectOutput struct {
	// The newly created project.
	Project *Project `locationName:"project" type:"structure"`

	metadataCreateProjectOutput `json:"-" xml:"-"`
}

type metadataCreateProjectOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateProjectOutput) GoString() string {
	return s.String()
}

// Represents a request to the create upload operation.
type CreateUploadInput struct {
	// The upload's content type (for example, "application/octet-stream").
	ContentType *string `locationName:"contentType" type:"string"`

	// The upload's file name.
	Name *string `locationName:"name" type:"string" required:"true"`

	// The ARN of the project for the upload.
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// The upload's upload type.
	//
	// Must be one of the following values:
	//
	//  ANDROID_APP: An Android upload.
	//
	// IOS_APP: An iOS upload.
	//
	// EXTERNAL_DATA: An external data upload.
	//
	// APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
	//
	// APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
	//
	// CALABASH_TEST_PACKAGE: A Calabash test package upload.
	//
	// INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
	//
	// UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
	//
	// XCTEST_TEST_PACKAGE: An XCode test package upload.
	Type *string `locationName:"type" type:"string" required:"true" enum:"UploadType"`

	metadataCreateUploadInput `json:"-" xml:"-"`
}

type metadataCreateUploadInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUploadInput) GoString() string {
	return s.String()
}

// Represents the result of a create upload request.
type CreateUploadOutput struct {
	// The newly created upload.
	Upload *Upload `locationName:"upload" type:"structure"`

	metadataCreateUploadOutput `json:"-" xml:"-"`
}

type metadataCreateUploadOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUploadOutput) GoString() string {
	return s.String()
}

// Represents a device type that an app is tested against.
type Device struct {
	// The device's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The device's carrier.
	Carrier *string `locationName:"carrier" type:"string"`

	// Information about the device's CPU.
	Cpu *CPU `locationName:"cpu" type:"structure"`

	// The device's form factor.
	//
	// Allowed values include:
	//
	//  PHONE: The phone form factor.
	//
	// TABLET: The tablet form factor.
	FormFactor *string `locationName:"formFactor" type:"string" enum:"DeviceFormFactor"`

	// The device's heap size, expressed in bytes.
	HeapSize *int64 `locationName:"heapSize" type:"long"`

	// The device's image name.
	Image *string `locationName:"image" type:"string"`

	// The device's manufacturer name.
	Manufacturer *string `locationName:"manufacturer" type:"string"`

	// The device's total memory size, expressed in bytes.
	Memory *int64 `locationName:"memory" type:"long"`

	// The device's model name.
	Model *string `locationName:"model" type:"string"`

	// The device's display name.
	Name *string `locationName:"name" type:"string"`

	// The device's operating system type.
	Os *string `locationName:"os" type:"string"`

	// The device's platform.
	//
	// Allowed values include:
	//
	//  ANDROID: The Android platform.
	//
	// IOS: The iOS platform.
	Platform *string `locationName:"platform" type:"string" enum:"DevicePlatform"`

	// The device's radio.
	Radio *string `locationName:"radio" type:"string"`

	// Represents the screen resolution of a device in height and width, expressed
	// in pixels.
	Resolution *Resolution `locationName:"resolution" type:"structure"`

	metadataDevice `json:"-" xml:"-"`
}

type metadataDevice struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Device) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Device) GoString() string {
	return s.String()
}

// Represents a collection of device types.
type DevicePool struct {
	// The device pool's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The device pool's description.
	Description *string `locationName:"description" type:"string"`

	// The device pool's name.
	Name *string `locationName:"name" type:"string"`

	// Information about the device pool's rules.
	Rules []*Rule `locationName:"rules" type:"list"`

	// The device pool's type.
	//
	// Allowed values include:
	//
	//  CURATED: A device pool that is created and managed by AWS Device Farm.
	//
	// PRIVATE: A device pool that is created and managed by the device pool developer.
	Type *string `locationName:"type" type:"string" enum:"DevicePoolType"`

	metadataDevicePool `json:"-" xml:"-"`
}

type metadataDevicePool struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DevicePool) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DevicePool) GoString() string {
	return s.String()
}

// Represents a device pool compatibility result.
type DevicePoolCompatibilityResult struct {
	// Whether the result was compatible with the device pool.
	Compatible *bool `locationName:"compatible" type:"boolean"`

	// Represents a device type that an app is tested against.
	Device *Device `locationName:"device" type:"structure"`

	// Information about the compatibility.
	IncompatibilityMessages []*IncompatibilityMessage `locationName:"incompatibilityMessages" type:"list"`

	metadataDevicePoolCompatibilityResult `json:"-" xml:"-"`
}

type metadataDevicePoolCompatibilityResult struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DevicePoolCompatibilityResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DevicePoolCompatibilityResult) GoString() string {
	return s.String()
}

type GetAccountSettingsInput struct {
	metadataGetAccountSettingsInput `json:"-" xml:"-"`
}

type metadataGetAccountSettingsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsInput) GoString() string {
	return s.String()
}

type GetAccountSettingsOutput struct {
	// A container for account-level settings within AWS Device Farm.
	AccountSettings *AccountSettings `locationName:"accountSettings" type:"structure"`

	metadataGetAccountSettingsOutput `json:"-" xml:"-"`
}

type metadataGetAccountSettingsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetAccountSettingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetAccountSettingsOutput) GoString() string {
	return s.String()
}

// Represents a request to the get device request.
type GetDeviceInput struct {
	// The device type's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	metadataGetDeviceInput `json:"-" xml:"-"`
}

type metadataGetDeviceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDeviceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceInput) GoString() string {
	return s.String()
}

// Represents the result of a get device request.
type GetDeviceOutput struct {
	// Represents a device type that an app is tested against.
	Device *Device `locationName:"device" type:"structure"`

	metadataGetDeviceOutput `json:"-" xml:"-"`
}

type metadataGetDeviceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDeviceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDeviceOutput) GoString() string {
	return s.String()
}

// Represents a request to the get device pool compatibility operation.
type GetDevicePoolCompatibilityInput struct {
	// The ARN of the app that is associated with the specified device pool.
	AppArn *string `locationName:"appArn" min:"32" type:"string" required:"true"`

	// The device pool's ARN.
	DevicePoolArn *string `locationName:"devicePoolArn" min:"32" type:"string" required:"true"`

	// The test type for the specified device pool.
	//
	// Allowed values include the following:
	//
	//  BUILTIN_FUZZ: The built-in fuzz type.
	//
	// BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android
	// app, interacting with it and capturing screenshots at the same time.
	//
	// APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	// APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	// CALABASH: The Calabash type.
	//
	// INSTRUMENTATION: The Instrumentation type.
	//
	// UIAUTOMATION: The uiautomation type.
	//
	// UIAUTOMATOR: The uiautomator type.
	//
	// XCTEST: The XCode test type.
	TestType *string `locationName:"testType" type:"string" enum:"TestType"`

	metadataGetDevicePoolCompatibilityInput `json:"-" xml:"-"`
}

type metadataGetDevicePoolCompatibilityInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDevicePoolCompatibilityInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePoolCompatibilityInput) GoString() string {
	return s.String()
}

// Represents the result of describe device pool compatibility request.
type GetDevicePoolCompatibilityOutput struct {
	// Information about compatible devices.
	CompatibleDevices []*DevicePoolCompatibilityResult `locationName:"compatibleDevices" type:"list"`

	// Information about incompatible devices.
	IncompatibleDevices []*DevicePoolCompatibilityResult `locationName:"incompatibleDevices" type:"list"`

	metadataGetDevicePoolCompatibilityOutput `json:"-" xml:"-"`
}

type metadataGetDevicePoolCompatibilityOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDevicePoolCompatibilityOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePoolCompatibilityOutput) GoString() string {
	return s.String()
}

// Represents a request to the get device pool operation.
type GetDevicePoolInput struct {
	// The device pool's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	metadataGetDevicePoolInput `json:"-" xml:"-"`
}

type metadataGetDevicePoolInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDevicePoolInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePoolInput) GoString() string {
	return s.String()
}

// Represents the result of a get device pool request.
type GetDevicePoolOutput struct {
	// Represents a collection of device types.
	DevicePool *DevicePool `locationName:"devicePool" type:"structure"`

	metadataGetDevicePoolOutput `json:"-" xml:"-"`
}

type metadataGetDevicePoolOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetDevicePoolOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDevicePoolOutput) GoString() string {
	return s.String()
}

// Represents a request to the get job operation.
type GetJobInput struct {
	// The job's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	metadataGetJobInput `json:"-" xml:"-"`
}

type metadataGetJobInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobInput) GoString() string {
	return s.String()
}

// Represents the result of a get job request.
type GetJobOutput struct {
	// Represents a device.
	Job *Job `locationName:"job" type:"structure"`

	metadataGetJobOutput `json:"-" xml:"-"`
}

type metadataGetJobOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobOutput) GoString() string {
	return s.String()
}

// Represents a request to the get project operation.
type GetProjectInput struct {
	// The project's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	metadataGetProjectInput `json:"-" xml:"-"`
}

type metadataGetProjectInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetProjectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProjectInput) GoString() string {
	return s.String()
}

// Represents the result of a get project request.
type GetProjectOutput struct {
	// Represents an operating-system neutral workspace for running and managing
	// tests.
	Project *Project `locationName:"project" type:"structure"`

	metadataGetProjectOutput `json:"-" xml:"-"`
}

type metadataGetProjectOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetProjectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetProjectOutput) GoString() string {
	return s.String()
}

// Represents a request to the get run operation.
type GetRunInput struct {
	// The run's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	metadataGetRunInput `json:"-" xml:"-"`
}

type metadataGetRunInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRunInput) GoString() string {
	return s.String()
}

// Represents the result of a get run request.
type GetRunOutput struct {
	// Represents an app on a set of devices with a specific test and configuration.
	Run *Run `locationName:"run" type:"structure"`

	metadataGetRunOutput `json:"-" xml:"-"`
}

type metadataGetRunOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRunOutput) GoString() string {
	return s.String()
}

// Represents a request to the get suite operation.
type GetSuiteInput struct {
	// The suite's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	metadataGetSuiteInput `json:"-" xml:"-"`
}

type metadataGetSuiteInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSuiteInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSuiteInput) GoString() string {
	return s.String()
}

// Represents the result of a get suite request.
type GetSuiteOutput struct {
	// Represents a collection of one or more tests.
	Suite *Suite `locationName:"suite" type:"structure"`

	metadataGetSuiteOutput `json:"-" xml:"-"`
}

type metadataGetSuiteOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetSuiteOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSuiteOutput) GoString() string {
	return s.String()
}

// Represents a request to the get test operation.
type GetTestInput struct {
	// The test's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	metadataGetTestInput `json:"-" xml:"-"`
}

type metadataGetTestInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetTestInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTestInput) GoString() string {
	return s.String()
}

// Represents the result of a get test request.
type GetTestOutput struct {
	// Represents a condition that is evaluated.
	Test *Test `locationName:"test" type:"structure"`

	metadataGetTestOutput `json:"-" xml:"-"`
}

type metadataGetTestOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetTestOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTestOutput) GoString() string {
	return s.String()
}

// Represents a request to the get upload operation.
type GetUploadInput struct {
	// The upload's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	metadataGetUploadInput `json:"-" xml:"-"`
}

type metadataGetUploadInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetUploadInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUploadInput) GoString() string {
	return s.String()
}

// Represents the result of a get upload request.
type GetUploadOutput struct {
	// An app or a set of one or more tests to upload or that have been uploaded.
	Upload *Upload `locationName:"upload" type:"structure"`

	metadataGetUploadOutput `json:"-" xml:"-"`
}

type metadataGetUploadOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetUploadOutput) GoString() string {
	return s.String()
}

// Represents information about incompatibility.
type IncompatibilityMessage struct {
	// A message about the incompatibility.
	Message *string `locationName:"message" type:"string"`

	// The type of incompatibility.
	//
	// Allowed values include:
	//
	//  ARN: The ARN.
	//
	// FORM_FACTOR: The form factor (for example, phone or tablet).
	//
	// MANUFACTURER: The manufacturer.
	//
	// PLATFORM: The platform (for example, Android or iOS).
	Type *string `locationName:"type" type:"string" enum:"DeviceAttribute"`

	metadataIncompatibilityMessage `json:"-" xml:"-"`
}

type metadataIncompatibilityMessage struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s IncompatibilityMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IncompatibilityMessage) GoString() string {
	return s.String()
}

// Represents a device.
type Job struct {
	// The job's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The job's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the job was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// Represents a device type that an app is tested against.
	Device *Device `locationName:"device" type:"structure"`

	// A message about the job's result.
	Message *string `locationName:"message" type:"string"`

	// The job's name.
	Name *string `locationName:"name" type:"string"`

	// The job's result.
	//
	// Allowed values include:
	//
	//  ERRORED: An error condition.
	//
	// FAILED: A failed condition.
	//
	// SKIPPED: A skipped condition.
	//
	// STOPPED: A stopped condition.
	//
	// PASSED: A passing condition.
	//
	// PENDING: A pending condition.
	//
	// WARNED: A warning condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The job's start time.
	Started *time.Time `locationName:"started" type:"timestamp" timestampFormat:"unix"`

	// The job's status.
	//
	// Allowed values include:
	//
	//  COMPLETED: A completed status.
	//
	// PENDING: A pending status.
	//
	// PROCESSING: A processing status.
	//
	// RUNNING: A running status.
	//
	// SCHEDULING: A scheduling status.
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The job's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp" timestampFormat:"unix"`

	// The job's type.
	//
	// Allowed values include the following:
	//
	//  BUILTIN_FUZZ: The built-in fuzz type.
	//
	// BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android
	// app, interacting with it and capturing screenshots at the same time.
	//
	// APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	// APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	// CALABASH: The Calabash type.
	//
	// INSTRUMENTATION: The Instrumentation type.
	//
	// UIAUTOMATION: The uiautomation type.
	//
	// UIAUTOMATOR: The uiautomator type.
	//
	// XCTEST: The XCode test type.
	Type *string `locationName:"type" type:"string" enum:"TestType"`

	metadataJob `json:"-" xml:"-"`
}

type metadataJob struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Job) GoString() string {
	return s.String()
}

// Represents a request to the list artifacts operation.
type ListArtifactsInput struct {
	// The Run, Job, Suite, or Test ARN.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The artifacts' type.
	//
	// Allowed values include:
	//
	//  FILE: The artifacts are files. LOG: The artifacts are logs. SCREENSHOT:
	// The artifacts are screenshots.
	Type *string `locationName:"type" type:"string" required:"true" enum:"ArtifactCategory"`

	metadataListArtifactsInput `json:"-" xml:"-"`
}

type metadataListArtifactsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListArtifactsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListArtifactsInput) GoString() string {
	return s.String()
}

// Represents the result of a list artifacts operation.
type ListArtifactsOutput struct {
	// Information about the artifacts.
	Artifacts []*Artifact `locationName:"artifacts" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListArtifactsOutput `json:"-" xml:"-"`
}

type metadataListArtifactsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListArtifactsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListArtifactsOutput) GoString() string {
	return s.String()
}

// Represents the result of a list device pools request.
type ListDevicePoolsInput struct {
	// The project ARN.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// The device pools' type.
	//
	// Allowed values include:
	//
	//  CURATED: A device pool that is created and managed by AWS Device Farm.
	//
	// PRIVATE: A device pool that is created and managed by the device pool developer.
	Type *string `locationName:"type" type:"string" enum:"DevicePoolType"`

	metadataListDevicePoolsInput `json:"-" xml:"-"`
}

type metadataListDevicePoolsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDevicePoolsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicePoolsInput) GoString() string {
	return s.String()
}

// Represents the result of a list device pools request.
type ListDevicePoolsOutput struct {
	// Information about the device pools.
	DevicePools []*DevicePool `locationName:"devicePools" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListDevicePoolsOutput `json:"-" xml:"-"`
}

type metadataListDevicePoolsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDevicePoolsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicePoolsOutput) GoString() string {
	return s.String()
}

// Represents the result of a list devices request.
type ListDevicesInput struct {
	// The device types' ARNs.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListDevicesInput `json:"-" xml:"-"`
}

type metadataListDevicesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDevicesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesInput) GoString() string {
	return s.String()
}

// Represents the result of a list devices operation.
type ListDevicesOutput struct {
	// Information about the devices.
	Devices []*Device `locationName:"devices" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListDevicesOutput `json:"-" xml:"-"`
}

type metadataListDevicesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListDevicesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevicesOutput) GoString() string {
	return s.String()
}

// Represents a request to the list jobs operation.
type ListJobsInput struct {
	// The jobs' ARNs.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListJobsInput `json:"-" xml:"-"`
}

type metadataListJobsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsInput) GoString() string {
	return s.String()
}

// Represents the result of a list jobs request.
type ListJobsOutput struct {
	// Information about the jobs.
	Jobs []*Job `locationName:"jobs" type:"list"`

	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListJobsOutput `json:"-" xml:"-"`
}

type metadataListJobsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListJobsOutput) GoString() string {
	return s.String()
}

// Represents a request to the list projects operation.
type ListProjectsInput struct {
	// The projects' ARNs.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListProjectsInput `json:"-" xml:"-"`
}

type metadataListProjectsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListProjectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsInput) GoString() string {
	return s.String()
}

// Represents the result of a list projects request.
type ListProjectsOutput struct {
	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the projects.
	Projects []*Project `locationName:"projects" type:"list"`

	metadataListProjectsOutput `json:"-" xml:"-"`
}

type metadataListProjectsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListProjectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListProjectsOutput) GoString() string {
	return s.String()
}

// Represents a request to the list runs operation.
type ListRunsInput struct {
	// The runs' ARNs.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListRunsInput `json:"-" xml:"-"`
}

type metadataListRunsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListRunsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRunsInput) GoString() string {
	return s.String()
}

// Represents the result of a list runs request.
type ListRunsOutput struct {
	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the runs.
	Runs []*Run `locationName:"runs" type:"list"`

	metadataListRunsOutput `json:"-" xml:"-"`
}

type metadataListRunsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListRunsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRunsOutput) GoString() string {
	return s.String()
}

// Represents a request to the list samples operation.
type ListSamplesInput struct {
	// The samples' ARNs.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListSamplesInput `json:"-" xml:"-"`
}

type metadataListSamplesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListSamplesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSamplesInput) GoString() string {
	return s.String()
}

// Represents the result of a list samples request.
type ListSamplesOutput struct {
	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the samples.
	Samples []*Sample `locationName:"samples" type:"list"`

	metadataListSamplesOutput `json:"-" xml:"-"`
}

type metadataListSamplesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListSamplesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSamplesOutput) GoString() string {
	return s.String()
}

// Represents a request to the list suites operation.
type ListSuitesInput struct {
	// The suites' ARNs.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListSuitesInput `json:"-" xml:"-"`
}

type metadataListSuitesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListSuitesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSuitesInput) GoString() string {
	return s.String()
}

// Represents the result of a list suites request.
type ListSuitesOutput struct {
	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the suites.
	Suites []*Suite `locationName:"suites" type:"list"`

	metadataListSuitesOutput `json:"-" xml:"-"`
}

type metadataListSuitesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListSuitesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSuitesOutput) GoString() string {
	return s.String()
}

// Represents a request to the list tests operation.
type ListTestsInput struct {
	// The tests' ARNs.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListTestsInput `json:"-" xml:"-"`
}

type metadataListTestsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTestsInput) GoString() string {
	return s.String()
}

// Represents the result of a list tests request.
type ListTestsOutput struct {
	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the tests.
	Tests []*Test `locationName:"tests" type:"list"`

	metadataListTestsOutput `json:"-" xml:"-"`
}

type metadataListTestsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListTestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTestsOutput) GoString() string {
	return s.String()
}

// Represents a request to the list unique problems operation.
type ListUniqueProblemsInput struct {
	// The unique problems' ARNs.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListUniqueProblemsInput `json:"-" xml:"-"`
}

type metadataListUniqueProblemsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListUniqueProblemsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUniqueProblemsInput) GoString() string {
	return s.String()
}

// Represents the result of a list unique problems request.
type ListUniqueProblemsOutput struct {
	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the unique problems.
	//
	// Allowed values include:
	//
	//  ERRORED: An error condition.
	//
	// FAILED: A failed condition.
	//
	// SKIPPED: A skipped condition.
	//
	// STOPPED: A stopped condition.
	//
	// PASSED: A passing condition.
	//
	// PENDING: A pending condition.
	//
	// WARNED: A warning condition.
	UniqueProblems map[string][]*UniqueProblem `locationName:"uniqueProblems" type:"map"`

	metadataListUniqueProblemsOutput `json:"-" xml:"-"`
}

type metadataListUniqueProblemsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListUniqueProblemsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUniqueProblemsOutput) GoString() string {
	return s.String()
}

// Represents a request to the list uploads operation.
type ListUploadsInput struct {
	// The uploads' ARNs.
	Arn *string `locationName:"arn" min:"32" type:"string" required:"true"`

	// An identifier that was returned from the previous call to this operation,
	// which can be used to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	metadataListUploadsInput `json:"-" xml:"-"`
}

type metadataListUploadsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListUploadsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUploadsInput) GoString() string {
	return s.String()
}

// Represents the result of a list uploads request.
type ListUploadsOutput struct {
	// If the number of items that are returned is significantly large, this is
	// an identifier that is also returned, which can be used in a subsequent call
	// to this operation to return the next set of items in the list.
	NextToken *string `locationName:"nextToken" min:"4" type:"string"`

	// Information about the uploads.
	Uploads []*Upload `locationName:"uploads" type:"list"`

	metadataListUploadsOutput `json:"-" xml:"-"`
}

type metadataListUploadsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListUploadsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListUploadsOutput) GoString() string {
	return s.String()
}

// Represents a latitude and longitude pair, expressed in geographic coordinate
// system degrees (for example 47.6204, -122.3491).
//
// Elevation is currently not supported.
type Location struct {
	// The latitude.
	Latitude *float64 `locationName:"latitude" type:"double" required:"true"`

	// The longitude.
	Longitude *float64 `locationName:"longitude" type:"double" required:"true"`

	metadataLocation `json:"-" xml:"-"`
}

type metadataLocation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Location) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Location) GoString() string {
	return s.String()
}

// Represents a specific warning or failure.
type Problem struct {
	// Information about the associated device.
	Device *Device `locationName:"device" type:"structure"`

	// Information about the associated job.
	Job *ProblemDetail `locationName:"job" type:"structure"`

	// A message about the problem's result.
	Message *string `locationName:"message" type:"string"`

	// The problem's result.
	//
	// Allowed values include:
	//
	//  ERRORED: An error condition.
	//
	// FAILED: A failed condition.
	//
	// SKIPPED: A skipped condition.
	//
	// STOPPED: A stopped condition.
	//
	// PASSED: A passing condition.
	//
	// PENDING: A pending condition.
	//
	// WARNED: A warning condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// Information about the associated run.
	Run *ProblemDetail `locationName:"run" type:"structure"`

	// Information about the associated suite.
	Suite *ProblemDetail `locationName:"suite" type:"structure"`

	// Information about the associated test.
	Test *ProblemDetail `locationName:"test" type:"structure"`

	metadataProblem `json:"-" xml:"-"`
}

type metadataProblem struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Problem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Problem) GoString() string {
	return s.String()
}

// Information about a problem detail.
type ProblemDetail struct {
	// The problem detail's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The problem detail's name.
	Name *string `locationName:"name" type:"string"`

	metadataProblemDetail `json:"-" xml:"-"`
}

type metadataProblemDetail struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ProblemDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ProblemDetail) GoString() string {
	return s.String()
}

// Represents an operating-system neutral workspace for running and managing
// tests.
type Project struct {
	// The project's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// When the project was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// The project's name.
	Name *string `locationName:"name" type:"string"`

	metadataProject `json:"-" xml:"-"`
}

type metadataProject struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Project) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Project) GoString() string {
	return s.String()
}

// Represents the set of radios and their states on a device. Examples of radios
// include Wi-Fi, GPS, Bluetooth, and NFC.
type Radios struct {
	// True if Bluetooth is enabled at the beginning of the test; otherwise, false.
	Bluetooth *bool `locationName:"bluetooth" type:"boolean"`

	// True if GPS is enabled at the beginning of the test; otherwise, false.
	Gps *bool `locationName:"gps" type:"boolean"`

	// True if NFC is enabled at the beginning of the test; otherwise, false.
	Nfc *bool `locationName:"nfc" type:"boolean"`

	// True if Wi-Fi is enabled at the beginning of the test; otherwise, false.
	Wifi *bool `locationName:"wifi" type:"boolean"`

	metadataRadios `json:"-" xml:"-"`
}

type metadataRadios struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Radios) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Radios) GoString() string {
	return s.String()
}

// Represents the screen resolution of a device in height and width, expressed
// in pixels.
type Resolution struct {
	// The screen resolution's height, expressed in pixels.
	Height *int64 `locationName:"height" type:"integer"`

	// The screen resolution's width, expressed in pixels.
	Width *int64 `locationName:"width" type:"integer"`

	metadataResolution `json:"-" xml:"-"`
}

type metadataResolution struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Resolution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Resolution) GoString() string {
	return s.String()
}

// Represents a condition for a device pool.
type Rule struct {
	// The rule's attribute.
	//
	// Allowed values include:
	//
	//  ARN: The ARN.
	//
	// FORM_FACTOR: The form factor (for example, phone or tablet).
	//
	// MANUFACTURER: The manufacturer.
	//
	// PLATFORM: The platform (for example, Android or iOS).
	Attribute *string `locationName:"attribute" type:"string" enum:"DeviceAttribute"`

	// The rule's operator.
	//
	//  EQUALS: The equals operator.
	//
	// GREATER_THAN: The greater-than operator.
	//
	// IN: The in operator.
	//
	// LESS_THAN: The less-than operator.
	//
	// NOT_IN: The not-in operator.
	Operator *string `locationName:"operator" type:"string" enum:"RuleOperator"`

	// The rule's value.
	Value *string `locationName:"value" type:"string"`

	metadataRule `json:"-" xml:"-"`
}

type metadataRule struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// Represents an app on a set of devices with a specific test and configuration.
type Run struct {
	// The run's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// Specifies the billing method for a test run: metered or unmetered. If the
	// parameter is not specified, the default value is unmetered.
	BillingMethod *string `locationName:"billingMethod" type:"string" enum:"BillingMethod"`

	// The total number of completed jobs.
	CompletedJobs *int64 `locationName:"completedJobs" type:"integer"`

	// The run's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the run was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// A message about the run's result.
	Message *string `locationName:"message" type:"string"`

	// The run's name.
	Name *string `locationName:"name" type:"string"`

	// The run's platform.
	//
	// Allowed values include:
	//
	//  ANDROID: The Android platform.
	//
	// IOS: The iOS platform.
	Platform *string `locationName:"platform" type:"string" enum:"DevicePlatform"`

	// The run's result.
	//
	// Allowed values include:
	//
	//  ERRORED: An error condition.
	//
	// FAILED: A failed condition.
	//
	// SKIPPED: A skipped condition.
	//
	// STOPPED: A stopped condition.
	//
	// PASSED: A passing condition.
	//
	// PENDING: A pending condition.
	//
	// WARNED: A warning condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The run's start time.
	Started *time.Time `locationName:"started" type:"timestamp" timestampFormat:"unix"`

	// The run's status.
	//
	// Allowed values include:
	//
	//  COMPLETED: A completed status.
	//
	// PENDING: A pending status.
	//
	// PROCESSING: A processing status.
	//
	// RUNNING: A running status.
	//
	// SCHEDULING: A scheduling status.
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The run's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp" timestampFormat:"unix"`

	// The total number of jobs for the run.
	TotalJobs *int64 `locationName:"totalJobs" type:"integer"`

	// The run's type.
	//
	// Must be one of the following values:
	//
	//  BUILTIN_FUZZ: The built-in fuzz type.
	//
	// BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android
	// app, interacting with it and capturing screenshots at the same time.
	//
	// APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	// APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	// CALABASH: The Calabash type.
	//
	// INSTRUMENTATION: The Instrumentation type.
	//
	// UIAUTOMATION: The uiautomation type.
	//
	// UIAUTOMATOR: The uiautomator type.
	//
	// XCTEST: The XCode test type.
	Type *string `locationName:"type" type:"string" enum:"TestType"`

	metadataRun `json:"-" xml:"-"`
}

type metadataRun struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Run) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Run) GoString() string {
	return s.String()
}

// Represents a sample of performance data.
type Sample struct {
	// The sample's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The sample's type.
	//
	// Must be one of the following values:
	//
	//  CPU: A CPU sample type. This is expressed as the app processing CPU time
	// (including child processes) as reported by process, as a percentage.
	//
	// MEMORY: A memory usage sample type. This is expressed as the total proportional
	// set size of an app process, in kilobytes.
	//
	// NATIVE_AVG_DRAWTIME
	//
	// NATIVE_FPS
	//
	// NATIVE_FRAMES
	//
	// NATIVE_MAX_DRAWTIME
	//
	// NATIVE_MIN_DRAWTIME
	//
	// OPENGL_AVG_DRAWTIME
	//
	// OPENGL_FPS
	//
	// OPENGL_FRAMES
	//
	// OPENGL_MAX_DRAWTIME
	//
	// OPENGL_MIN_DRAWTIME
	//
	// RX
	//
	// RX_RATE: The total number of bytes per second (TCP and UDP) that are sent,
	// by app process.
	//
	// THREADS: A threads sample type. This is expressed as the total number of
	// threads per app process.
	//
	// TX
	//
	// TX_RATE: The total number of bytes per second (TCP and UDP) that are received,
	// by app process.
	Type *string `locationName:"type" type:"string" enum:"SampleType"`

	// The pre-signed Amazon S3 URL that can be used with a corresponding GET request
	// to download the sample's file.
	Url *string `locationName:"url" type:"string"`

	metadataSample `json:"-" xml:"-"`
}

type metadataSample struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Sample) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Sample) GoString() string {
	return s.String()
}

// Represents the settings for a run. Includes things like location, radio states,
// auxiliary apps, and network profiles.
type ScheduleRunConfiguration struct {
	// A list of auxiliary apps for the run.
	AuxiliaryApps []*string `locationName:"auxiliaryApps" type:"list"`

	// Specifies the billing method for a test run: metered or unmetered. If the
	// parameter is not specified, the default value is unmetered.
	BillingMethod *string `locationName:"billingMethod" type:"string" enum:"BillingMethod"`

	// The ARN of the extra data for the run. The extra data is a .zip file that
	// AWS Device Farm will extract to external data for Android or the app's sandbox
	// for iOS.
	ExtraDataPackageArn *string `locationName:"extraDataPackageArn" min:"32" type:"string"`

	// Information about the locale that is used for the run.
	Locale *string `locationName:"locale" type:"string"`

	// Information about the location that is used for the run.
	Location *Location `locationName:"location" type:"structure"`

	// Reserved for internal use.
	NetworkProfileArn *string `locationName:"networkProfileArn" min:"32" type:"string"`

	// Information about the radio states for the run.
	Radios *Radios `locationName:"radios" type:"structure"`

	metadataScheduleRunConfiguration `json:"-" xml:"-"`
}

type metadataScheduleRunConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ScheduleRunConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleRunConfiguration) GoString() string {
	return s.String()
}

// Represents a request to the schedule run operation.
type ScheduleRunInput struct {
	// The ARN of the app to schedule a run.
	AppArn *string `locationName:"appArn" min:"32" type:"string" required:"true"`

	// Information about the settings for the run to be scheduled.
	Configuration *ScheduleRunConfiguration `locationName:"configuration" type:"structure"`

	// The ARN of the device pool for the run to be scheduled.
	DevicePoolArn *string `locationName:"devicePoolArn" min:"32" type:"string" required:"true"`

	// The name for the run to be scheduled.
	Name *string `locationName:"name" type:"string"`

	// The ARN of the project for the run to be scheduled.
	ProjectArn *string `locationName:"projectArn" min:"32" type:"string" required:"true"`

	// Information about the test for the run to be scheduled.
	Test *ScheduleRunTest `locationName:"test" type:"structure" required:"true"`

	metadataScheduleRunInput `json:"-" xml:"-"`
}

type metadataScheduleRunInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ScheduleRunInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleRunInput) GoString() string {
	return s.String()
}

// Represents the result of a schedule run request.
type ScheduleRunOutput struct {
	// Information about the scheduled run.
	Run *Run `locationName:"run" type:"structure"`

	metadataScheduleRunOutput `json:"-" xml:"-"`
}

type metadataScheduleRunOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ScheduleRunOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleRunOutput) GoString() string {
	return s.String()
}

// Represents additional test settings.
type ScheduleRunTest struct {
	// The test's filter.
	Filter *string `locationName:"filter" type:"string"`

	// The test's parameters, such as test framework parameters and fixture settings.
	Parameters map[string]*string `locationName:"parameters" type:"map"`

	// The ARN of the uploaded test that will be run.
	TestPackageArn *string `locationName:"testPackageArn" min:"32" type:"string"`

	// The test's type.
	//
	// Must be one of the following values:
	//
	//  BUILTIN_FUZZ: The built-in fuzz type.
	//
	// BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android
	// app, interacting with it and capturing screenshots at the same time.
	//
	// APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	// APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	// CALABASH: The Calabash type.
	//
	// INSTRUMENTATION: The Instrumentation type.
	//
	// UIAUTOMATION: The uiautomation type.
	//
	// UIAUTOMATOR: The uiautomator type.
	//
	// XCTEST: The XCode test type.
	Type *string `locationName:"type" type:"string" required:"true" enum:"TestType"`

	metadataScheduleRunTest `json:"-" xml:"-"`
}

type metadataScheduleRunTest struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ScheduleRunTest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleRunTest) GoString() string {
	return s.String()
}

// Represents a collection of one or more tests.
type Suite struct {
	// The suite's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The suite's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the suite was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// A message about the suite's result.
	Message *string `locationName:"message" type:"string"`

	// The suite's name.
	Name *string `locationName:"name" type:"string"`

	// The suite's result.
	//
	// Allowed values include:
	//
	//  ERRORED: An error condition.
	//
	// FAILED: A failed condition.
	//
	// SKIPPED: A skipped condition.
	//
	// STOPPED: A stopped condition.
	//
	// PASSED: A passing condition.
	//
	// PENDING: A pending condition.
	//
	// WARNED: A warning condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The suite's start time.
	Started *time.Time `locationName:"started" type:"timestamp" timestampFormat:"unix"`

	// The suite's status.
	//
	// Allowed values include:
	//
	//  COMPLETED: A completed status.
	//
	// PENDING: A pending status.
	//
	// PROCESSING: A processing status.
	//
	// RUNNING: A running status.
	//
	// SCHEDULING: A scheduling status.
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The suite's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp" timestampFormat:"unix"`

	// The suite's type.
	//
	// Must be one of the following values:
	//
	//  BUILTIN_FUZZ: The built-in fuzz type.
	//
	// BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android
	// app, interacting with it and capturing screenshots at the same time.
	//
	// APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	// APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	// CALABASH: The Calabash type.
	//
	// INSTRUMENTATION: The Instrumentation type.
	//
	// UIAUTOMATION: The uiautomation type.
	//
	// UIAUTOMATOR: The uiautomator type.
	//
	// XCTEST: The XCode test type.
	Type *string `locationName:"type" type:"string" enum:"TestType"`

	metadataSuite `json:"-" xml:"-"`
}

type metadataSuite struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Suite) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Suite) GoString() string {
	return s.String()
}

// Represents a condition that is evaluated.
type Test struct {
	// The test's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The test's result counters.
	Counters *Counters `locationName:"counters" type:"structure"`

	// When the test was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// A message about the test's result.
	Message *string `locationName:"message" type:"string"`

	// The test's name.
	Name *string `locationName:"name" type:"string"`

	// The test's result.
	//
	// Allowed values include:
	//
	//  ERRORED: An error condition.
	//
	// FAILED: A failed condition.
	//
	// SKIPPED: A skipped condition.
	//
	// STOPPED: A stopped condition.
	//
	// PASSED: A passing condition.
	//
	// PENDING: A pending condition.
	//
	// WARNED: A warning condition.
	Result *string `locationName:"result" type:"string" enum:"ExecutionResult"`

	// The test's start time.
	Started *time.Time `locationName:"started" type:"timestamp" timestampFormat:"unix"`

	// The test's status.
	//
	// Allowed values include:
	//
	//  COMPLETED: A completed status.
	//
	// PENDING: A pending status.
	//
	// PROCESSING: A processing status.
	//
	// RUNNING: A running status.
	//
	// SCHEDULING: A scheduling status.
	Status *string `locationName:"status" type:"string" enum:"ExecutionStatus"`

	// The test's stop time.
	Stopped *time.Time `locationName:"stopped" type:"timestamp" timestampFormat:"unix"`

	// The test's type.
	//
	// Must be one of the following values:
	//
	//  BUILTIN_FUZZ: The built-in fuzz type.
	//
	// BUILTIN_EXPLORER: For Android, an app explorer that will traverse an Android
	// app, interacting with it and capturing screenshots at the same time.
	//
	// APPIUM_JAVA_JUNIT: The Appium Java JUnit type.
	//
	// APPIUM_JAVA_TESTNG: The Appium Java TestNG type.
	//
	// CALABASH: The Calabash type.
	//
	// INSTRUMENTATION: The Instrumentation type.
	//
	// UIAUTOMATION: The uiautomation type.
	//
	// UIAUTOMATOR: The uiautomator type.
	//
	// XCTEST: The XCode test type.
	Type *string `locationName:"type" type:"string" enum:"TestType"`

	metadataTest `json:"-" xml:"-"`
}

type metadataTest struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Test) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Test) GoString() string {
	return s.String()
}

// A collection of one or more problems, grouped by their result.
type UniqueProblem struct {
	// A message about the unique problems' result.
	Message *string `locationName:"message" type:"string"`

	// Information about the problems.
	Problems []*Problem `locationName:"problems" type:"list"`

	metadataUniqueProblem `json:"-" xml:"-"`
}

type metadataUniqueProblem struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UniqueProblem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UniqueProblem) GoString() string {
	return s.String()
}

// An app or a set of one or more tests to upload or that have been uploaded.
type Upload struct {
	// The upload's ARN.
	Arn *string `locationName:"arn" min:"32" type:"string"`

	// The upload's content type (for example, "application/octet-stream").
	ContentType *string `locationName:"contentType" type:"string"`

	// When the upload was created.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// A message about the upload's result.
	Message *string `locationName:"message" type:"string"`

	// The upload's metadata. For example, for Android, this contains information
	// that is parsed from the manifest and is displayed in the AWS Device Farm
	// console after the associated app is uploaded.
	Metadata *string `locationName:"metadata" type:"string"`

	// The upload's file name.
	Name *string `locationName:"name" type:"string"`

	// The upload's status.
	//
	// Must be one of the following values:
	//
	//  FAILED: A failed status.
	//
	// INITIALIZED: An initialized status.
	//
	// PROCESSING: A processing status.
	//
	// SUCCEEDED: A succeeded status.
	Status *string `locationName:"status" type:"string" enum:"UploadStatus"`

	// The upload's type.
	//
	// Must be one of the following values:
	//
	//  ANDROID_APP: An Android upload.
	//
	// IOS_APP: An iOS upload.
	//
	// EXTERNAL_DATA: An external data upload.
	//
	// APPIUM_JAVA_JUNIT_TEST_PACKAGE: An Appium Java JUnit test package upload.
	//
	// APPIUM_JAVA_TESTNG_TEST_PACKAGE: An Appium Java TestNG test package upload.
	//
	// CALABASH_TEST_PACKAGE: A Calabash test package upload.
	//
	// INSTRUMENTATION_TEST_PACKAGE: An instrumentation upload.
	//
	// UIAUTOMATOR_TEST_PACKAGE: A uiautomator test package upload.
	//
	// XCTEST_TEST_PACKAGE: An XCode test package upload.
	Type *string `locationName:"type" type:"string" enum:"UploadType"`

	// The pre-signed Amazon S3 URL that was used to store a file through a corresponding
	// PUT request.
	Url *string `locationName:"url" type:"string"`

	metadataUpload `json:"-" xml:"-"`
}

type metadataUpload struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Upload) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Upload) GoString() string {
	return s.String()
}

const (
	// @enum ArtifactCategory
	ArtifactCategoryScreenshot = "SCREENSHOT"
	// @enum ArtifactCategory
	ArtifactCategoryFile = "FILE"
	// @enum ArtifactCategory
	ArtifactCategoryLog = "LOG"
)

const (
	// @enum ArtifactType
	ArtifactTypeUnknown = "UNKNOWN"
	// @enum ArtifactType
	ArtifactTypeScreenshot = "SCREENSHOT"
	// @enum ArtifactType
	ArtifactTypeDeviceLog = "DEVICE_LOG"
	// @enum ArtifactType
	ArtifactTypeMessageLog = "MESSAGE_LOG"
	// @enum ArtifactType
	ArtifactTypeResultLog = "RESULT_LOG"
	// @enum ArtifactType
	ArtifactTypeServiceLog = "SERVICE_LOG"
	// @enum ArtifactType
	ArtifactTypeInstrumentationOutput = "INSTRUMENTATION_OUTPUT"
	// @enum ArtifactType
	ArtifactTypeExerciserMonkeyOutput = "EXERCISER_MONKEY_OUTPUT"
	// @enum ArtifactType
	ArtifactTypeCalabashJsonOutput = "CALABASH_JSON_OUTPUT"
	// @enum ArtifactType
	ArtifactTypeCalabashPrettyOutput = "CALABASH_PRETTY_OUTPUT"
	// @enum ArtifactType
	ArtifactTypeCalabashStandardOutput = "CALABASH_STANDARD_OUTPUT"
	// @enum ArtifactType
	ArtifactTypeCalabashJavaXmlOutput = "CALABASH_JAVA_XML_OUTPUT"
	// @enum ArtifactType
	ArtifactTypeAutomationOutput = "AUTOMATION_OUTPUT"
	// @enum ArtifactType
	ArtifactTypeAppiumServerOutput = "APPIUM_SERVER_OUTPUT"
	// @enum ArtifactType
	ArtifactTypeAppiumJavaOutput = "APPIUM_JAVA_OUTPUT"
	// @enum ArtifactType
	ArtifactTypeAppiumJavaXmlOutput = "APPIUM_JAVA_XML_OUTPUT"
)

const (
	// @enum BillingMethod
	BillingMethodMetered = "METERED"
	// @enum BillingMethod
	BillingMethodUnmetered = "UNMETERED"
)

const (
	// @enum DeviceAttribute
	DeviceAttributeArn = "ARN"
	// @enum DeviceAttribute
	DeviceAttributePlatform = "PLATFORM"
	// @enum DeviceAttribute
	DeviceAttributeFormFactor = "FORM_FACTOR"
	// @enum DeviceAttribute
	DeviceAttributeManufacturer = "MANUFACTURER"
)

const (
	// @enum DeviceFormFactor
	DeviceFormFactorPhone = "PHONE"
	// @enum DeviceFormFactor
	DeviceFormFactorTablet = "TABLET"
)

const (
	// @enum DevicePlatform
	DevicePlatformAndroid = "ANDROID"
	// @enum DevicePlatform
	DevicePlatformIos = "IOS"
)

const (
	// @enum DevicePoolType
	DevicePoolTypeCurated = "CURATED"
	// @enum DevicePoolType
	DevicePoolTypePrivate = "PRIVATE"
)

const (
	// @enum ExecutionResult
	ExecutionResultPending = "PENDING"
	// @enum ExecutionResult
	ExecutionResultPassed = "PASSED"
	// @enum ExecutionResult
	ExecutionResultWarned = "WARNED"
	// @enum ExecutionResult
	ExecutionResultFailed = "FAILED"
	// @enum ExecutionResult
	ExecutionResultSkipped = "SKIPPED"
	// @enum ExecutionResult
	ExecutionResultErrored = "ERRORED"
	// @enum ExecutionResult
	ExecutionResultStopped = "STOPPED"
)

const (
	// @enum ExecutionStatus
	ExecutionStatusPending = "PENDING"
	// @enum ExecutionStatus
	ExecutionStatusProcessing = "PROCESSING"
	// @enum ExecutionStatus
	ExecutionStatusScheduling = "SCHEDULING"
	// @enum ExecutionStatus
	ExecutionStatusRunning = "RUNNING"
	// @enum ExecutionStatus
	ExecutionStatusCompleted = "COMPLETED"
)

const (
	// @enum RuleOperator
	RuleOperatorEquals = "EQUALS"
	// @enum RuleOperator
	RuleOperatorLessThan = "LESS_THAN"
	// @enum RuleOperator
	RuleOperatorGreaterThan = "GREATER_THAN"
	// @enum RuleOperator
	RuleOperatorIn = "IN"
	// @enum RuleOperator
	RuleOperatorNotIn = "NOT_IN"
)

const (
	// @enum SampleType
	SampleTypeCpu = "CPU"
	// @enum SampleType
	SampleTypeMemory = "MEMORY"
	// @enum SampleType
	SampleTypeThreads = "THREADS"
	// @enum SampleType
	SampleTypeRxRate = "RX_RATE"
	// @enum SampleType
	SampleTypeTxRate = "TX_RATE"
	// @enum SampleType
	SampleTypeRx = "RX"
	// @enum SampleType
	SampleTypeTx = "TX"
	// @enum SampleType
	SampleTypeNativeFrames = "NATIVE_FRAMES"
	// @enum SampleType
	SampleTypeNativeFps = "NATIVE_FPS"
	// @enum SampleType
	SampleTypeNativeMinDrawtime = "NATIVE_MIN_DRAWTIME"
	// @enum SampleType
	SampleTypeNativeAvgDrawtime = "NATIVE_AVG_DRAWTIME"
	// @enum SampleType
	SampleTypeNativeMaxDrawtime = "NATIVE_MAX_DRAWTIME"
	// @enum SampleType
	SampleTypeOpenglFrames = "OPENGL_FRAMES"
	// @enum SampleType
	SampleTypeOpenglFps = "OPENGL_FPS"
	// @enum SampleType
	SampleTypeOpenglMinDrawtime = "OPENGL_MIN_DRAWTIME"
	// @enum SampleType
	SampleTypeOpenglAvgDrawtime = "OPENGL_AVG_DRAWTIME"
	// @enum SampleType
	SampleTypeOpenglMaxDrawtime = "OPENGL_MAX_DRAWTIME"
)

const (
	// @enum TestType
	TestTypeBuiltinFuzz = "BUILTIN_FUZZ"
	// @enum TestType
	TestTypeBuiltinExplorer = "BUILTIN_EXPLORER"
	// @enum TestType
	TestTypeAppiumJavaJunit = "APPIUM_JAVA_JUNIT"
	// @enum TestType
	TestTypeAppiumJavaTestng = "APPIUM_JAVA_TESTNG"
	// @enum TestType
	TestTypeCalabash = "CALABASH"
	// @enum TestType
	TestTypeInstrumentation = "INSTRUMENTATION"
	// @enum TestType
	TestTypeUiautomation = "UIAUTOMATION"
	// @enum TestType
	TestTypeUiautomator = "UIAUTOMATOR"
	// @enum TestType
	TestTypeXctest = "XCTEST"
)

const (
	// @enum UploadStatus
	UploadStatusInitialized = "INITIALIZED"
	// @enum UploadStatus
	UploadStatusProcessing = "PROCESSING"
	// @enum UploadStatus
	UploadStatusSucceeded = "SUCCEEDED"
	// @enum UploadStatus
	UploadStatusFailed = "FAILED"
)

const (
	// @enum UploadType
	UploadTypeAndroidApp = "ANDROID_APP"
	// @enum UploadType
	UploadTypeIosApp = "IOS_APP"
	// @enum UploadType
	UploadTypeExternalData = "EXTERNAL_DATA"
	// @enum UploadType
	UploadTypeAppiumJavaJunitTestPackage = "APPIUM_JAVA_JUNIT_TEST_PACKAGE"
	// @enum UploadType
	UploadTypeAppiumJavaTestngTestPackage = "APPIUM_JAVA_TESTNG_TEST_PACKAGE"
	// @enum UploadType
	UploadTypeCalabashTestPackage = "CALABASH_TEST_PACKAGE"
	// @enum UploadType
	UploadTypeInstrumentationTestPackage = "INSTRUMENTATION_TEST_PACKAGE"
	// @enum UploadType
	UploadTypeUiautomationTestPackage = "UIAUTOMATION_TEST_PACKAGE"
	// @enum UploadType
	UploadTypeUiautomatorTestPackage = "UIAUTOMATOR_TEST_PACKAGE"
	// @enum UploadType
	UploadTypeXctestTestPackage = "XCTEST_TEST_PACKAGE"
)
