// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package cognitosync

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/defaults"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/aws/service"
	"github.com/aws/aws-sdk-go/aws/service/serviceinfo"
	"github.com/aws/aws-sdk-go/internal/protocol/restjson"
	"github.com/aws/aws-sdk-go/internal/signer/v4"
)

// Amazon Cognito Sync provides an AWS service and client library that enable
// cross-device syncing of application-related user data. High-level client
// libraries are available for both iOS and Android. You can use these libraries
// to persist data locally so that it's available even if the device is offline.
// Developer credentials don't need to be stored on the mobile device to access
// the service. You can use Amazon Cognito to obtain a normalized user ID and
// credentials. User data is persisted in a dataset that can store up to 1 MB
// of key-value pairs, and you can have up to 20 datasets per user identity.
//
// With Amazon Cognito Sync, the data stored for each identity is accessible
// only to credentials assigned to that identity. In order to use the Cognito
// Sync service, you need to make API calls using credentials retrieved with
// Amazon Cognito Identity service (http://docs.aws.amazon.com/cognitoidentity/latest/APIReference/Welcome.html).
//
// If you want to use Cognito Sync in an Android or iOS application, you will
// probably want to make API calls via the AWS Mobile SDK. To learn more, see
// the Developer Guide for Android (http://docs.aws.amazon.com/mobile/sdkforandroid/developerguide/cognito-sync.html)
// and the Developer Guide for iOS (http://docs.aws.amazon.com/mobile/sdkforios/developerguide/cognito-sync.html).
type CognitoSync struct {
	*service.Service
}

// Used for custom service initialization logic
var initService func(*service.Service)

// Used for custom request initialization logic
var initRequest func(*request.Request)

// New returns a new CognitoSync client.
func New(config *aws.Config) *CognitoSync {
	service := &service.Service{
		ServiceInfo: serviceinfo.ServiceInfo{
			Config:      defaults.DefaultConfig.Merge(config),
			ServiceName: "cognito-sync",
			APIVersion:  "2014-06-30",
		},
	}
	service.Initialize()

	// Handlers
	service.Handlers.Sign.PushBack(v4.Sign)
	service.Handlers.Build.PushBack(restjson.Build)
	service.Handlers.Unmarshal.PushBack(restjson.Unmarshal)
	service.Handlers.UnmarshalMeta.PushBack(restjson.UnmarshalMeta)
	service.Handlers.UnmarshalError.PushBack(restjson.UnmarshalError)

	// Run custom service initialization if present
	if initService != nil {
		initService(service)
	}

	return &CognitoSync{service}
}

// newRequest creates a new request for a CognitoSync operation and runs any
// custom request initialization.
func (c *CognitoSync) newRequest(op *request.Operation, params, data interface{}) *request.Request {
	req := c.NewRequest(op, params, data)

	// Run custom request initialization if present
	if initRequest != nil {
		initRequest(req)
	}

	return req
}
