// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package codepipeline provides a client for AWS CodePipeline.
package codepipeline

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAcknowledgeJob = "AcknowledgeJob"

// AcknowledgeJobRequest generates a request for the AcknowledgeJob operation.
func (c *CodePipeline) AcknowledgeJobRequest(input *AcknowledgeJobInput) (req *request.Request, output *AcknowledgeJobOutput) {
	op := &request.Operation{
		Name:       opAcknowledgeJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcknowledgeJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AcknowledgeJobOutput{}
	req.Data = output
	return
}

// Returns information about a specified job and whether that job has been received
// by the job worker. Only used for custom actions.
func (c *CodePipeline) AcknowledgeJob(input *AcknowledgeJobInput) (*AcknowledgeJobOutput, error) {
	req, out := c.AcknowledgeJobRequest(input)
	err := req.Send()
	return out, err
}

const opAcknowledgeThirdPartyJob = "AcknowledgeThirdPartyJob"

// AcknowledgeThirdPartyJobRequest generates a request for the AcknowledgeThirdPartyJob operation.
func (c *CodePipeline) AcknowledgeThirdPartyJobRequest(input *AcknowledgeThirdPartyJobInput) (req *request.Request, output *AcknowledgeThirdPartyJobOutput) {
	op := &request.Operation{
		Name:       opAcknowledgeThirdPartyJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcknowledgeThirdPartyJobInput{}
	}

	req = c.newRequest(op, input, output)
	output = &AcknowledgeThirdPartyJobOutput{}
	req.Data = output
	return
}

// Confirms a job worker has received the specified job. Only used for partner
// actions.
func (c *CodePipeline) AcknowledgeThirdPartyJob(input *AcknowledgeThirdPartyJobInput) (*AcknowledgeThirdPartyJobOutput, error) {
	req, out := c.AcknowledgeThirdPartyJobRequest(input)
	err := req.Send()
	return out, err
}

const opCreateCustomActionType = "CreateCustomActionType"

// CreateCustomActionTypeRequest generates a request for the CreateCustomActionType operation.
func (c *CodePipeline) CreateCustomActionTypeRequest(input *CreateCustomActionTypeInput) (req *request.Request, output *CreateCustomActionTypeOutput) {
	op := &request.Operation{
		Name:       opCreateCustomActionType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomActionTypeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateCustomActionTypeOutput{}
	req.Data = output
	return
}

// Creates a new custom action that can be used in all pipelines associated
// with the AWS account. Only used for custom actions.
func (c *CodePipeline) CreateCustomActionType(input *CreateCustomActionTypeInput) (*CreateCustomActionTypeOutput, error) {
	req, out := c.CreateCustomActionTypeRequest(input)
	err := req.Send()
	return out, err
}

const opCreatePipeline = "CreatePipeline"

// CreatePipelineRequest generates a request for the CreatePipeline operation.
func (c *CodePipeline) CreatePipelineRequest(input *CreatePipelineInput) (req *request.Request, output *CreatePipelineOutput) {
	op := &request.Operation{
		Name:       opCreatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePipelineInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreatePipelineOutput{}
	req.Data = output
	return
}

// Creates a pipeline.
func (c *CodePipeline) CreatePipeline(input *CreatePipelineInput) (*CreatePipelineOutput, error) {
	req, out := c.CreatePipelineRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteCustomActionType = "DeleteCustomActionType"

// DeleteCustomActionTypeRequest generates a request for the DeleteCustomActionType operation.
func (c *CodePipeline) DeleteCustomActionTypeRequest(input *DeleteCustomActionTypeInput) (req *request.Request, output *DeleteCustomActionTypeOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomActionType,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomActionTypeInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteCustomActionTypeOutput{}
	req.Data = output
	return
}

// Marks a custom action as deleted. PollForJobs for the custom action will
// fail after the action is marked for deletion. Only used for custom actions.
//
// You cannot recreate a custom action after it has been deleted unless you
// increase the version number of the action.
func (c *CodePipeline) DeleteCustomActionType(input *DeleteCustomActionTypeInput) (*DeleteCustomActionTypeOutput, error) {
	req, out := c.DeleteCustomActionTypeRequest(input)
	err := req.Send()
	return out, err
}

const opDeletePipeline = "DeletePipeline"

// DeletePipelineRequest generates a request for the DeletePipeline operation.
func (c *CodePipeline) DeletePipelineRequest(input *DeletePipelineInput) (req *request.Request, output *DeletePipelineOutput) {
	op := &request.Operation{
		Name:       opDeletePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePipelineInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeletePipelineOutput{}
	req.Data = output
	return
}

// Deletes the specified pipeline.
func (c *CodePipeline) DeletePipeline(input *DeletePipelineInput) (*DeletePipelineOutput, error) {
	req, out := c.DeletePipelineRequest(input)
	err := req.Send()
	return out, err
}

const opDisableStageTransition = "DisableStageTransition"

// DisableStageTransitionRequest generates a request for the DisableStageTransition operation.
func (c *CodePipeline) DisableStageTransitionRequest(input *DisableStageTransitionInput) (req *request.Request, output *DisableStageTransitionOutput) {
	op := &request.Operation{
		Name:       opDisableStageTransition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisableStageTransitionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DisableStageTransitionOutput{}
	req.Data = output
	return
}

// Prevents artifacts in a pipeline from transitioning to the next stage in
// the pipeline.
func (c *CodePipeline) DisableStageTransition(input *DisableStageTransitionInput) (*DisableStageTransitionOutput, error) {
	req, out := c.DisableStageTransitionRequest(input)
	err := req.Send()
	return out, err
}

const opEnableStageTransition = "EnableStageTransition"

// EnableStageTransitionRequest generates a request for the EnableStageTransition operation.
func (c *CodePipeline) EnableStageTransitionRequest(input *EnableStageTransitionInput) (req *request.Request, output *EnableStageTransitionOutput) {
	op := &request.Operation{
		Name:       opEnableStageTransition,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EnableStageTransitionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EnableStageTransitionOutput{}
	req.Data = output
	return
}

// Enables artifacts in a pipeline to transition to a stage in a pipeline.
func (c *CodePipeline) EnableStageTransition(input *EnableStageTransitionInput) (*EnableStageTransitionOutput, error) {
	req, out := c.EnableStageTransitionRequest(input)
	err := req.Send()
	return out, err
}

const opGetJobDetails = "GetJobDetails"

// GetJobDetailsRequest generates a request for the GetJobDetails operation.
func (c *CodePipeline) GetJobDetailsRequest(input *GetJobDetailsInput) (req *request.Request, output *GetJobDetailsOutput) {
	op := &request.Operation{
		Name:       opGetJobDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobDetailsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetJobDetailsOutput{}
	req.Data = output
	return
}

// Returns information about a job. Only used for custom actions.
//
// When this API is called, AWS CodePipeline returns temporary credentials
// for the Amazon S3 bucket used to store artifacts for the pipeline, if the
// action requires access to that Amazon S3 bucket for input or output artifacts.
// Additionally, this API returns any secret values defined for the action.
func (c *CodePipeline) GetJobDetails(input *GetJobDetailsInput) (*GetJobDetailsOutput, error) {
	req, out := c.GetJobDetailsRequest(input)
	err := req.Send()
	return out, err
}

const opGetPipeline = "GetPipeline"

// GetPipelineRequest generates a request for the GetPipeline operation.
func (c *CodePipeline) GetPipelineRequest(input *GetPipelineInput) (req *request.Request, output *GetPipelineOutput) {
	op := &request.Operation{
		Name:       opGetPipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPipelineInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPipelineOutput{}
	req.Data = output
	return
}

// Returns the metadata, structure, stages, and actions of a pipeline. Can be
// used to return the entire structure of a pipeline in JSON format, which can
// then be modified and used to update the pipeline structure with UpdatePipeline.
func (c *CodePipeline) GetPipeline(input *GetPipelineInput) (*GetPipelineOutput, error) {
	req, out := c.GetPipelineRequest(input)
	err := req.Send()
	return out, err
}

const opGetPipelineState = "GetPipelineState"

// GetPipelineStateRequest generates a request for the GetPipelineState operation.
func (c *CodePipeline) GetPipelineStateRequest(input *GetPipelineStateInput) (req *request.Request, output *GetPipelineStateOutput) {
	op := &request.Operation{
		Name:       opGetPipelineState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPipelineStateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetPipelineStateOutput{}
	req.Data = output
	return
}

// Returns information about the state of a pipeline, including the stages,
// actions, and details about the last run of the pipeline.
func (c *CodePipeline) GetPipelineState(input *GetPipelineStateInput) (*GetPipelineStateOutput, error) {
	req, out := c.GetPipelineStateRequest(input)
	err := req.Send()
	return out, err
}

const opGetThirdPartyJobDetails = "GetThirdPartyJobDetails"

// GetThirdPartyJobDetailsRequest generates a request for the GetThirdPartyJobDetails operation.
func (c *CodePipeline) GetThirdPartyJobDetailsRequest(input *GetThirdPartyJobDetailsInput) (req *request.Request, output *GetThirdPartyJobDetailsOutput) {
	op := &request.Operation{
		Name:       opGetThirdPartyJobDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetThirdPartyJobDetailsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetThirdPartyJobDetailsOutput{}
	req.Data = output
	return
}

// Requests the details of a job for a third party action. Only used for partner
// actions.
//
// When this API is called, AWS CodePipeline returns temporary credentials
// for the Amazon S3 bucket used to store artifacts for the pipeline, if the
// action requires access to that Amazon S3 bucket for input or output artifacts.
// Additionally, this API returns any secret values defined for the action.
func (c *CodePipeline) GetThirdPartyJobDetails(input *GetThirdPartyJobDetailsInput) (*GetThirdPartyJobDetailsOutput, error) {
	req, out := c.GetThirdPartyJobDetailsRequest(input)
	err := req.Send()
	return out, err
}

const opListActionTypes = "ListActionTypes"

// ListActionTypesRequest generates a request for the ListActionTypes operation.
func (c *CodePipeline) ListActionTypesRequest(input *ListActionTypesInput) (req *request.Request, output *ListActionTypesOutput) {
	op := &request.Operation{
		Name:       opListActionTypes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListActionTypesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListActionTypesOutput{}
	req.Data = output
	return
}

// Gets a summary of all AWS CodePipeline action types associated with your
// account.
func (c *CodePipeline) ListActionTypes(input *ListActionTypesInput) (*ListActionTypesOutput, error) {
	req, out := c.ListActionTypesRequest(input)
	err := req.Send()
	return out, err
}

const opListPipelines = "ListPipelines"

// ListPipelinesRequest generates a request for the ListPipelines operation.
func (c *CodePipeline) ListPipelinesRequest(input *ListPipelinesInput) (req *request.Request, output *ListPipelinesOutput) {
	op := &request.Operation{
		Name:       opListPipelines,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPipelinesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListPipelinesOutput{}
	req.Data = output
	return
}

// Gets a summary of all of the pipelines associated with your account.
func (c *CodePipeline) ListPipelines(input *ListPipelinesInput) (*ListPipelinesOutput, error) {
	req, out := c.ListPipelinesRequest(input)
	err := req.Send()
	return out, err
}

const opPollForJobs = "PollForJobs"

// PollForJobsRequest generates a request for the PollForJobs operation.
func (c *CodePipeline) PollForJobsRequest(input *PollForJobsInput) (req *request.Request, output *PollForJobsOutput) {
	op := &request.Operation{
		Name:       opPollForJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForJobsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PollForJobsOutput{}
	req.Data = output
	return
}

// Returns information about any jobs for AWS CodePipeline to act upon.
//
// When this API is called, AWS CodePipeline returns temporary credentials
// for the Amazon S3 bucket used to store artifacts for the pipeline, if the
// action requires access to that Amazon S3 bucket for input or output artifacts.
// Additionally, this API returns any secret values defined for the action.
func (c *CodePipeline) PollForJobs(input *PollForJobsInput) (*PollForJobsOutput, error) {
	req, out := c.PollForJobsRequest(input)
	err := req.Send()
	return out, err
}

const opPollForThirdPartyJobs = "PollForThirdPartyJobs"

// PollForThirdPartyJobsRequest generates a request for the PollForThirdPartyJobs operation.
func (c *CodePipeline) PollForThirdPartyJobsRequest(input *PollForThirdPartyJobsInput) (req *request.Request, output *PollForThirdPartyJobsOutput) {
	op := &request.Operation{
		Name:       opPollForThirdPartyJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PollForThirdPartyJobsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PollForThirdPartyJobsOutput{}
	req.Data = output
	return
}

// Determines whether there are any third party jobs for a job worker to act
// on. Only used for partner actions.
//
// When this API is called, AWS CodePipeline returns temporary credentials
// for the Amazon S3 bucket used to store artifacts for the pipeline, if the
// action requires access to that Amazon S3 bucket for input or output artifacts.
func (c *CodePipeline) PollForThirdPartyJobs(input *PollForThirdPartyJobsInput) (*PollForThirdPartyJobsOutput, error) {
	req, out := c.PollForThirdPartyJobsRequest(input)
	err := req.Send()
	return out, err
}

const opPutActionRevision = "PutActionRevision"

// PutActionRevisionRequest generates a request for the PutActionRevision operation.
func (c *CodePipeline) PutActionRevisionRequest(input *PutActionRevisionInput) (req *request.Request, output *PutActionRevisionOutput) {
	op := &request.Operation{
		Name:       opPutActionRevision,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutActionRevisionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutActionRevisionOutput{}
	req.Data = output
	return
}

// Provides information to AWS CodePipeline about new revisions to a source.
func (c *CodePipeline) PutActionRevision(input *PutActionRevisionInput) (*PutActionRevisionOutput, error) {
	req, out := c.PutActionRevisionRequest(input)
	err := req.Send()
	return out, err
}

const opPutJobFailureResult = "PutJobFailureResult"

// PutJobFailureResultRequest generates a request for the PutJobFailureResult operation.
func (c *CodePipeline) PutJobFailureResultRequest(input *PutJobFailureResultInput) (req *request.Request, output *PutJobFailureResultOutput) {
	op := &request.Operation{
		Name:       opPutJobFailureResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutJobFailureResultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutJobFailureResultOutput{}
	req.Data = output
	return
}

// Represents the failure of a job as returned to the pipeline by a job worker.
// Only used for custom actions.
func (c *CodePipeline) PutJobFailureResult(input *PutJobFailureResultInput) (*PutJobFailureResultOutput, error) {
	req, out := c.PutJobFailureResultRequest(input)
	err := req.Send()
	return out, err
}

const opPutJobSuccessResult = "PutJobSuccessResult"

// PutJobSuccessResultRequest generates a request for the PutJobSuccessResult operation.
func (c *CodePipeline) PutJobSuccessResultRequest(input *PutJobSuccessResultInput) (req *request.Request, output *PutJobSuccessResultOutput) {
	op := &request.Operation{
		Name:       opPutJobSuccessResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutJobSuccessResultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutJobSuccessResultOutput{}
	req.Data = output
	return
}

// Represents the success of a job as returned to the pipeline by a job worker.
// Only used for custom actions.
func (c *CodePipeline) PutJobSuccessResult(input *PutJobSuccessResultInput) (*PutJobSuccessResultOutput, error) {
	req, out := c.PutJobSuccessResultRequest(input)
	err := req.Send()
	return out, err
}

const opPutThirdPartyJobFailureResult = "PutThirdPartyJobFailureResult"

// PutThirdPartyJobFailureResultRequest generates a request for the PutThirdPartyJobFailureResult operation.
func (c *CodePipeline) PutThirdPartyJobFailureResultRequest(input *PutThirdPartyJobFailureResultInput) (req *request.Request, output *PutThirdPartyJobFailureResultOutput) {
	op := &request.Operation{
		Name:       opPutThirdPartyJobFailureResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutThirdPartyJobFailureResultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutThirdPartyJobFailureResultOutput{}
	req.Data = output
	return
}

// Represents the failure of a third party job as returned to the pipeline by
// a job worker. Only used for partner actions.
func (c *CodePipeline) PutThirdPartyJobFailureResult(input *PutThirdPartyJobFailureResultInput) (*PutThirdPartyJobFailureResultOutput, error) {
	req, out := c.PutThirdPartyJobFailureResultRequest(input)
	err := req.Send()
	return out, err
}

const opPutThirdPartyJobSuccessResult = "PutThirdPartyJobSuccessResult"

// PutThirdPartyJobSuccessResultRequest generates a request for the PutThirdPartyJobSuccessResult operation.
func (c *CodePipeline) PutThirdPartyJobSuccessResultRequest(input *PutThirdPartyJobSuccessResultInput) (req *request.Request, output *PutThirdPartyJobSuccessResultOutput) {
	op := &request.Operation{
		Name:       opPutThirdPartyJobSuccessResult,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutThirdPartyJobSuccessResultInput{}
	}

	req = c.newRequest(op, input, output)
	output = &PutThirdPartyJobSuccessResultOutput{}
	req.Data = output
	return
}

// Represents the success of a third party job as returned to the pipeline by
// a job worker. Only used for partner actions.
func (c *CodePipeline) PutThirdPartyJobSuccessResult(input *PutThirdPartyJobSuccessResultInput) (*PutThirdPartyJobSuccessResultOutput, error) {
	req, out := c.PutThirdPartyJobSuccessResultRequest(input)
	err := req.Send()
	return out, err
}

const opStartPipelineExecution = "StartPipelineExecution"

// StartPipelineExecutionRequest generates a request for the StartPipelineExecution operation.
func (c *CodePipeline) StartPipelineExecutionRequest(input *StartPipelineExecutionInput) (req *request.Request, output *StartPipelineExecutionOutput) {
	op := &request.Operation{
		Name:       opStartPipelineExecution,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartPipelineExecutionInput{}
	}

	req = c.newRequest(op, input, output)
	output = &StartPipelineExecutionOutput{}
	req.Data = output
	return
}

// Starts the specified pipeline. Specifically, it begins processing the latest
// commit to the source location specified as part of the pipeline.
func (c *CodePipeline) StartPipelineExecution(input *StartPipelineExecutionInput) (*StartPipelineExecutionOutput, error) {
	req, out := c.StartPipelineExecutionRequest(input)
	err := req.Send()
	return out, err
}

const opUpdatePipeline = "UpdatePipeline"

// UpdatePipelineRequest generates a request for the UpdatePipeline operation.
func (c *CodePipeline) UpdatePipelineRequest(input *UpdatePipelineInput) (req *request.Request, output *UpdatePipelineOutput) {
	op := &request.Operation{
		Name:       opUpdatePipeline,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdatePipelineInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdatePipelineOutput{}
	req.Data = output
	return
}

// Updates a specified pipeline with edits or changes to its structure. Use
// a JSON file with the pipeline structure in conjunction with UpdatePipeline
// to provide the full structure of the pipeline. Updating the pipeline increases
// the version number of the pipeline by 1.
func (c *CodePipeline) UpdatePipeline(input *UpdatePipelineInput) (*UpdatePipelineOutput, error) {
	req, out := c.UpdatePipelineRequest(input)
	err := req.Send()
	return out, err
}

// Represents an AWS session credentials object. These credentials are temporary
// credentials that are issued by AWS Secure Token Service (STS). They can be
// used to access input and output artifacts in the Amazon S3 bucket used to
// store artifact for the pipeline in AWS CodePipeline.
type AWSSessionCredentials struct {
	// The access key for the session.
	AccessKeyId *string `locationName:"accessKeyId" type:"string" required:"true"`

	// The secret access key for the session.
	SecretAccessKey *string `locationName:"secretAccessKey" type:"string" required:"true"`

	// The token for the session.
	SessionToken *string `locationName:"sessionToken" type:"string" required:"true"`

	metadataAWSSessionCredentials `json:"-" xml:"-"`
}

type metadataAWSSessionCredentials struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AWSSessionCredentials) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AWSSessionCredentials) GoString() string {
	return s.String()
}

// Represents the input of an acknowledge job action.
type AcknowledgeJobInput struct {
	// The unique system-generated ID of the job for which you want to confirm receipt.
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. This number must be returned
	// in the response.
	Nonce *string `locationName:"nonce" type:"string" required:"true"`

	metadataAcknowledgeJobInput `json:"-" xml:"-"`
}

type metadataAcknowledgeJobInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AcknowledgeJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeJobInput) GoString() string {
	return s.String()
}

// Represents the output of an acknowledge job action.
type AcknowledgeJobOutput struct {
	// Whether the job worker has received the specified job.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`

	metadataAcknowledgeJobOutput `json:"-" xml:"-"`
}

type metadataAcknowledgeJobOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AcknowledgeJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeJobOutput) GoString() string {
	return s.String()
}

// Represents the input of an acknowledge third party job action.
type AcknowledgeThirdPartyJobInput struct {
	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	ClientToken *string `locationName:"clientToken" type:"string" required:"true"`

	// The unique system-generated ID of the job.
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. This number must be returned
	// in the response.
	Nonce *string `locationName:"nonce" type:"string" required:"true"`

	metadataAcknowledgeThirdPartyJobInput `json:"-" xml:"-"`
}

type metadataAcknowledgeThirdPartyJobInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AcknowledgeThirdPartyJobInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeThirdPartyJobInput) GoString() string {
	return s.String()
}

// Represents the output of an acknowledge third party job action.
type AcknowledgeThirdPartyJobOutput struct {
	// The status information for the third party job, if any.
	Status *string `locationName:"status" type:"string" enum:"JobStatus"`

	metadataAcknowledgeThirdPartyJobOutput `json:"-" xml:"-"`
}

type metadataAcknowledgeThirdPartyJobOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s AcknowledgeThirdPartyJobOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AcknowledgeThirdPartyJobOutput) GoString() string {
	return s.String()
}

// Represents information about an action configuration.
type ActionConfiguration struct {
	// The configuration data for the action.
	Configuration map[string]*string `locationName:"configuration" type:"map"`

	metadataActionConfiguration `json:"-" xml:"-"`
}

type metadataActionConfiguration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionConfiguration) GoString() string {
	return s.String()
}

// Represents information about an action configuration property.
type ActionConfigurationProperty struct {
	// The description of the action configuration property that will be displayed
	// to users.
	Description *string `locationName:"description" min:"1" type:"string"`

	// Whether the configuration property is a key.
	Key *bool `locationName:"key" type:"boolean" required:"true"`

	// The name of the action configuration property.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Indicates that the proprety will be used in conjunction with PollForJobs.
	// When creating a custom action, an action can have up to one queryable property.
	// If it has one, that property must be both required and not secret.
	//
	// If you create a pipeline with a custom action type, and that custom action
	// contains a queryable property, the value for that configuration property
	// is subject to additional restrictions. The value must be less than or equal
	// to twenty (20) characters. The value can contain only alphanumeric characters,
	// underscores, and hyphens.
	Queryable *bool `locationName:"queryable" type:"boolean"`

	// Whether the configuration property is a required value.
	Required *bool `locationName:"required" type:"boolean" required:"true"`

	// Whether the configuration property is secret. Secrets are hidden from all
	// calls except for GetJobDetails, GetThirdPartyJobDetails, PollForJobs, and
	// PollForThirdPartyJobs.
	//
	// When updating a pipeline, passing * * * * * without changing any other values
	// of the action will preserve the prior value of the secret.
	Secret *bool `locationName:"secret" type:"boolean" required:"true"`

	// The type of the configuration property.
	Type *string `locationName:"type" type:"string" enum:"ActionConfigurationPropertyType"`

	metadataActionConfigurationProperty `json:"-" xml:"-"`
}

type metadataActionConfigurationProperty struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActionConfigurationProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionConfigurationProperty) GoString() string {
	return s.String()
}

// Represents the context of an action within the stage of a pipeline to a job
// worker.
type ActionContext struct {
	// The name of the action within the context of a job.
	Name *string `locationName:"name" min:"1" type:"string"`

	metadataActionContext `json:"-" xml:"-"`
}

type metadataActionContext struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActionContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionContext) GoString() string {
	return s.String()
}

// Represents information about an action declaration.
type ActionDeclaration struct {
	// The configuration information for the action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The action declaration's configuration.
	Configuration map[string]*string `locationName:"configuration" type:"map"`

	// The name or ID of the artifact consumed by the action, such as a test or
	// build artifact.
	InputArtifacts []*InputArtifact `locationName:"inputArtifacts" type:"list"`

	// The action declaration's name.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The name or ID of the result of the action declaration, such as a test or
	// build artifact.
	OutputArtifacts []*OutputArtifact `locationName:"outputArtifacts" type:"list"`

	// The ARN of the IAM service role that will perform the declared action. This
	// is assumed through the roleArn for the pipeline.
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The order in which actions are run.
	RunOrder *int64 `locationName:"runOrder" min:"1" type:"integer"`

	metadataActionDeclaration `json:"-" xml:"-"`
}

type metadataActionDeclaration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActionDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionDeclaration) GoString() string {
	return s.String()
}

// Represents information about how an action runs.
type ActionExecution struct {
	// The details of an error returned by a URL external to AWS.
	ErrorDetails *ErrorDetails `locationName:"errorDetails" type:"structure"`

	// The external ID of the run of the action.
	ExternalExecutionId *string `locationName:"externalExecutionId" type:"string"`

	// The URL of a resource external to AWS that will be used when running the
	// action, for example an external repository URL.
	ExternalExecutionUrl *string `locationName:"externalExecutionUrl" min:"1" type:"string"`

	// The last status change of the action.
	LastStatusChange *time.Time `locationName:"lastStatusChange" type:"timestamp" timestampFormat:"unix"`

	// A percentage of completeness of the action as it runs.
	PercentComplete *int64 `locationName:"percentComplete" type:"integer"`

	// The status of the action, or for a completed action, the last status of the
	// action.
	Status *string `locationName:"status" type:"string" enum:"ActionExecutionStatus"`

	// A summary of the run of the action.
	Summary *string `locationName:"summary" type:"string"`

	metadataActionExecution `json:"-" xml:"-"`
}

type metadataActionExecution struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActionExecution) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionExecution) GoString() string {
	return s.String()
}

// Represents information about the version (or revision) of an action.
type ActionRevision struct {
	// The date and time when the most recent version of the action was created,
	// in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix" required:"true"`

	// The unique identifier of the change that set the state to this revision,
	// for example a deployment ID or timestamp.
	RevisionChangeId *string `locationName:"revisionChangeId" type:"string"`

	// The system-generated unique ID that identifies the revision number of the
	// action.
	RevisionId *string `locationName:"revisionId" type:"string" required:"true"`

	metadataActionRevision `json:"-" xml:"-"`
}

type metadataActionRevision struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActionRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionRevision) GoString() string {
	return s.String()
}

// Represents information about the state of an action.
type ActionState struct {
	// The name of the action.
	ActionName *string `locationName:"actionName" min:"1" type:"string"`

	// Represents information about the version (or revision) of an action.
	CurrentRevision *ActionRevision `locationName:"currentRevision" type:"structure"`

	// A URL link for more information about the state of the action, such as a
	// deployment group details page.
	EntityUrl *string `locationName:"entityUrl" min:"1" type:"string"`

	// Represents information about how an action runs.
	LatestExecution *ActionExecution `locationName:"latestExecution" type:"structure"`

	// A URL link for more information about the revision, such as a commit details
	// page.
	RevisionUrl *string `locationName:"revisionUrl" min:"1" type:"string"`

	metadataActionState `json:"-" xml:"-"`
}

type metadataActionState struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionState) GoString() string {
	return s.String()
}

// Returns information about the details of an action type.
type ActionType struct {
	// The configuration properties for the action type.
	ActionConfigurationProperties []*ActionConfigurationProperty `locationName:"actionConfigurationProperties" type:"list"`

	// Represents information about an action type.
	Id *ActionTypeId `locationName:"id" type:"structure" required:"true"`

	// The details of the input artifact for the action, such as its commit ID.
	InputArtifactDetails *ArtifactDetails `locationName:"inputArtifactDetails" type:"structure" required:"true"`

	// The details of the output artifact of the action, such as its commit ID.
	OutputArtifactDetails *ArtifactDetails `locationName:"outputArtifactDetails" type:"structure" required:"true"`

	// The settings for the action type.
	Settings *ActionTypeSettings `locationName:"settings" type:"structure"`

	metadataActionType `json:"-" xml:"-"`
}

type metadataActionType struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActionType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionType) GoString() string {
	return s.String()
}

// Represents information about an action type.
type ActionTypeId struct {
	// A category defines what kind of action can be taken in the stage, and constrains
	// the provider type for the action. Valid categories are limited to one of
	// the values below.
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The creator of the action being called.
	Owner *string `locationName:"owner" type:"string" required:"true" enum:"ActionOwner"`

	// The provider of the service being called by the action. Valid providers are
	// determined by the action category. For example, an action in the Deploy category
	// type might have a provider of AWS CodeDeploy, which would be specified as
	// CodeDeploy.
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// A string that identifies the action type.
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`

	metadataActionTypeId `json:"-" xml:"-"`
}

type metadataActionTypeId struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActionTypeId) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionTypeId) GoString() string {
	return s.String()
}

// Returns information about the settings for an action type.
type ActionTypeSettings struct {
	// The URL returned to the AWS CodePipeline console that provides a deep link
	// to the resources of the external system, such as the configuration page for
	// an AWS CodeDeploy deployment group. This link is provided as part of the
	// action display within the pipeline.
	EntityUrlTemplate *string `locationName:"entityUrlTemplate" min:"1" type:"string"`

	// The URL returned to the AWS CodePipeline console that contains a link to
	// the top-level landing page for the external system, such as console page
	// for AWS CodeDeploy. This link is shown on the pipeline view page in the AWS
	// CodePipeline console and provides a link to the execution entity of the external
	// action.
	ExecutionUrlTemplate *string `locationName:"executionUrlTemplate" min:"1" type:"string"`

	// The URL returned to the AWS CodePipeline console that contains a link to
	// the page where customers can update or change the configuration of the external
	// action.
	RevisionUrlTemplate *string `locationName:"revisionUrlTemplate" min:"1" type:"string"`

	// The URL of a sign-up page where users can sign up for an external service
	// and perform initial configuration of the action provided by that service.
	ThirdPartyConfigurationUrl *string `locationName:"thirdPartyConfigurationUrl" min:"1" type:"string"`

	metadataActionTypeSettings `json:"-" xml:"-"`
}

type metadataActionTypeSettings struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ActionTypeSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActionTypeSettings) GoString() string {
	return s.String()
}

// Represents information about an artifact that will be worked upon by actions
// in the pipeline.
type Artifact struct {
	// The location of an artifact.
	Location *ArtifactLocation `locationName:"location" type:"structure"`

	// The artifact's name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The artifact's revision ID. Depending on the type of object, this could be
	// a commit ID (GitHub) or a revision ID (Amazon S3).
	Revision *string `locationName:"revision" type:"string"`

	metadataArtifact `json:"-" xml:"-"`
}

type metadataArtifact struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Artifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Artifact) GoString() string {
	return s.String()
}

// Returns information about the details of an artifact.
type ArtifactDetails struct {
	// The maximum number of artifacts allowed for the action type.
	MaximumCount *int64 `locationName:"maximumCount" type:"integer" required:"true"`

	// The minimum number of artifacts allowed for the action type.
	MinimumCount *int64 `locationName:"minimumCount" type:"integer" required:"true"`

	metadataArtifactDetails `json:"-" xml:"-"`
}

type metadataArtifactDetails struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ArtifactDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArtifactDetails) GoString() string {
	return s.String()
}

// Represents information about the location of an artifact.
type ArtifactLocation struct {
	// The Amazon S3 bucket that contains the artifact.
	S3Location *S3ArtifactLocation `locationName:"s3Location" type:"structure"`

	// The type of artifact in the location.
	Type *string `locationName:"type" type:"string" enum:"ArtifactLocationType"`

	metadataArtifactLocation `json:"-" xml:"-"`
}

type metadataArtifactLocation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ArtifactLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArtifactLocation) GoString() string {
	return s.String()
}

// The Amazon S3 location where artifacts are stored for the pipeline. If this
// Amazon S3 bucket is created manually, it must meet the requirements for AWS
// CodePipeline. For more information, see the Concepts.
type ArtifactStore struct {
	// The AWS Key Management Service (AWS KMS) key used to encrypt the data in
	// the artifact store. If this is undefined, the default key for Amazon S3 is
	// used.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The location for storing the artifacts for a pipeline, such as an S3 bucket
	// or folder.
	Location *string `locationName:"location" min:"3" type:"string" required:"true"`

	// The type of the artifact store, such as S3.
	Type *string `locationName:"type" type:"string" required:"true" enum:"ArtifactStoreType"`

	metadataArtifactStore `json:"-" xml:"-"`
}

type metadataArtifactStore struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ArtifactStore) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ArtifactStore) GoString() string {
	return s.String()
}

// Represents information about a gate declaration.
type BlockerDeclaration struct {
	// The name of the gate declaration.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The type of the gate declaration.
	Type *string `locationName:"type" type:"string" required:"true" enum:"BlockerType"`

	metadataBlockerDeclaration `json:"-" xml:"-"`
}

type metadataBlockerDeclaration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s BlockerDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BlockerDeclaration) GoString() string {
	return s.String()
}

// Represents the input of a create custom action operation.
type CreateCustomActionTypeInput struct {
	// The category of the custom action, such as a source action or a build action.
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The configuration properties for the custom action.
	ConfigurationProperties []*ActionConfigurationProperty `locationName:"configurationProperties" type:"list"`

	// Returns information about the details of an artifact.
	InputArtifactDetails *ArtifactDetails `locationName:"inputArtifactDetails" type:"structure" required:"true"`

	// Returns information about the details of an artifact.
	OutputArtifactDetails *ArtifactDetails `locationName:"outputArtifactDetails" type:"structure" required:"true"`

	// The provider of the service used in the custom action, such as AWS CodeDeploy.
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// Returns information about the settings for an action type.
	Settings *ActionTypeSettings `locationName:"settings" type:"structure"`

	// The version number of the custom action.
	//
	// A newly-created custom action is always assigned a version number of 1.
	// This is required.
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`

	metadataCreateCustomActionTypeInput `json:"-" xml:"-"`
}

type metadataCreateCustomActionTypeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCustomActionTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomActionTypeInput) GoString() string {
	return s.String()
}

// Represents the output of a create custom action operation.
type CreateCustomActionTypeOutput struct {
	// Returns information about the details of an action type.
	ActionType *ActionType `locationName:"actionType" type:"structure" required:"true"`

	metadataCreateCustomActionTypeOutput `json:"-" xml:"-"`
}

type metadataCreateCustomActionTypeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateCustomActionTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateCustomActionTypeOutput) GoString() string {
	return s.String()
}

// Represents the input of a create pipeline action.
type CreatePipelineInput struct {
	// Represents the structure of actions and stages to be performed in the pipeline.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure" required:"true"`

	metadataCreatePipelineInput `json:"-" xml:"-"`
}

type metadataCreatePipelineInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePipelineInput) GoString() string {
	return s.String()
}

// Represents the output of a create pipeline action.
type CreatePipelineOutput struct {
	// Represents the structure of actions and stages to be performed in the pipeline.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure"`

	metadataCreatePipelineOutput `json:"-" xml:"-"`
}

type metadataCreatePipelineOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePipelineOutput) GoString() string {
	return s.String()
}

// Represents information about a current revision.
type CurrentRevision struct {
	// The change identifier for the current revision.
	ChangeIdentifier *string `locationName:"changeIdentifier" type:"string" required:"true"`

	// The revision ID of the current version of an artifact.
	Revision *string `locationName:"revision" type:"string" required:"true"`

	metadataCurrentRevision `json:"-" xml:"-"`
}

type metadataCurrentRevision struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CurrentRevision) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CurrentRevision) GoString() string {
	return s.String()
}

// Represents the input of a delete custom action operation. The custom action
// will be marked as deleted.
type DeleteCustomActionTypeInput struct {
	// The category of the custom action that you want to delete, such as source
	// or deploy.
	Category *string `locationName:"category" type:"string" required:"true" enum:"ActionCategory"`

	// The provider of the service used in the custom action, such as AWS CodeDeploy.
	Provider *string `locationName:"provider" min:"1" type:"string" required:"true"`

	// The version of the custom action to delete.
	Version *string `locationName:"version" min:"1" type:"string" required:"true"`

	metadataDeleteCustomActionTypeInput `json:"-" xml:"-"`
}

type metadataDeleteCustomActionTypeInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteCustomActionTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomActionTypeInput) GoString() string {
	return s.String()
}

type DeleteCustomActionTypeOutput struct {
	metadataDeleteCustomActionTypeOutput `json:"-" xml:"-"`
}

type metadataDeleteCustomActionTypeOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteCustomActionTypeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteCustomActionTypeOutput) GoString() string {
	return s.String()
}

// Represents the input of a delete pipeline action.
type DeletePipelineInput struct {
	// The name of the pipeline to be deleted.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	metadataDeletePipelineInput `json:"-" xml:"-"`
}

type metadataDeletePipelineInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeletePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePipelineInput) GoString() string {
	return s.String()
}

type DeletePipelineOutput struct {
	metadataDeletePipelineOutput `json:"-" xml:"-"`
}

type metadataDeletePipelineOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeletePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePipelineOutput) GoString() string {
	return s.String()
}

// Represents the input of a disable stage transition input action.
type DisableStageTransitionInput struct {
	// The name of the pipeline in which you want to disable the flow of artifacts
	// from one stage to another.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The reason given to the user why a stage is disabled, such as waiting for
	// manual approval or manual tests. This message is displayed in the pipeline
	// console UI.
	Reason *string `locationName:"reason" min:"1" type:"string" required:"true"`

	// The name of the stage where you want to disable the inbound or outbound transition
	// of artifacts.
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// Specifies whether artifacts will be prevented from transitioning into the
	// stage and being processed by the actions in that stage (inbound), or prevented
	// from transitioning from the stage after they have been processed by the actions
	// in that stage (outbound).
	TransitionType *string `locationName:"transitionType" type:"string" required:"true" enum:"StageTransitionType"`

	metadataDisableStageTransitionInput `json:"-" xml:"-"`
}

type metadataDisableStageTransitionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableStageTransitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableStageTransitionInput) GoString() string {
	return s.String()
}

type DisableStageTransitionOutput struct {
	metadataDisableStageTransitionOutput `json:"-" xml:"-"`
}

type metadataDisableStageTransitionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DisableStageTransitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisableStageTransitionOutput) GoString() string {
	return s.String()
}

// Represents the input of an enable stage transition action.
type EnableStageTransitionInput struct {
	// The name of the pipeline in which you want to enable the flow of artifacts
	// from one stage to another.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The name of the stage where you want to enable the transition of artifacts,
	// either into the stage (inbound) or from that stage to the next stage (outbound).
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	// Specifies whether artifacts will be allowed to enter the stage and be processed
	// by the actions in that stage (inbound) or whether already-processed artifacts
	// will be allowed to transition to the next stage (outbound).
	TransitionType *string `locationName:"transitionType" type:"string" required:"true" enum:"StageTransitionType"`

	metadataEnableStageTransitionInput `json:"-" xml:"-"`
}

type metadataEnableStageTransitionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnableStageTransitionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableStageTransitionInput) GoString() string {
	return s.String()
}

type EnableStageTransitionOutput struct {
	metadataEnableStageTransitionOutput `json:"-" xml:"-"`
}

type metadataEnableStageTransitionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EnableStageTransitionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EnableStageTransitionOutput) GoString() string {
	return s.String()
}

// Represents information about the AWS Key Management Service (AWS KMS) key
// used to encrypt data in the artifact store.
type EncryptionKey struct {
	// The ID of the AWS KMS key.
	Id *string `locationName:"id" min:"1" type:"string" required:"true"`

	// The type of AWS KMS key, such as a customer master key.
	Type *string `locationName:"type" type:"string" required:"true" enum:"EncryptionKeyType"`

	metadataEncryptionKey `json:"-" xml:"-"`
}

type metadataEncryptionKey struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EncryptionKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EncryptionKey) GoString() string {
	return s.String()
}

// Represents information about an error in AWS CodePipeline.
type ErrorDetails struct {
	// The system ID or error number code of the error.
	Code *string `locationName:"code" type:"string"`

	// The text of the error message.
	Message *string `locationName:"message" type:"string"`

	metadataErrorDetails `json:"-" xml:"-"`
}

type metadataErrorDetails struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ErrorDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorDetails) GoString() string {
	return s.String()
}

// The details of the actions taken and results produced on an artifact as it
// passes through stages in the pipeline.
type ExecutionDetails struct {
	// The system-generated unique ID of this action used to identify this job worker
	// in any external systems, such as AWS CodeDeploy.
	ExternalExecutionId *string `locationName:"externalExecutionId" type:"string"`

	// The percentage of work completed on the action, represented on a scale of
	// zero to one hundred percent.
	PercentComplete *int64 `locationName:"percentComplete" type:"integer"`

	// The summary of the current status of the actions.
	Summary *string `locationName:"summary" type:"string"`

	metadataExecutionDetails `json:"-" xml:"-"`
}

type metadataExecutionDetails struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ExecutionDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExecutionDetails) GoString() string {
	return s.String()
}

// Represents information about failure details.
type FailureDetails struct {
	// The external ID of the run of the action that failed.
	ExternalExecutionId *string `locationName:"externalExecutionId" type:"string"`

	// The message about the failure.
	Message *string `locationName:"message" type:"string" required:"true"`

	// The type of the failure.
	Type *string `locationName:"type" type:"string" required:"true" enum:"FailureType"`

	metadataFailureDetails `json:"-" xml:"-"`
}

type metadataFailureDetails struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s FailureDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FailureDetails) GoString() string {
	return s.String()
}

// Represents the input of a get job details action.
type GetJobDetailsInput struct {
	// The unique system-generated ID for the job.
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	metadataGetJobDetailsInput `json:"-" xml:"-"`
}

type metadataGetJobDetailsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetJobDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobDetailsInput) GoString() string {
	return s.String()
}

// Represents the output of a get job details action.
type GetJobDetailsOutput struct {
	// The details of the job.
	//
	//  If AWSSessionCredentials is used, a long-running job can call GetJobDetails
	// again to obtain new credentials.
	JobDetails *JobDetails `locationName:"jobDetails" type:"structure"`

	metadataGetJobDetailsOutput `json:"-" xml:"-"`
}

type metadataGetJobDetailsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetJobDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobDetailsOutput) GoString() string {
	return s.String()
}

// Represents the input of a get pipeline action.
type GetPipelineInput struct {
	// The name of the pipeline for which you want to get information. Pipeline
	// names must be unique under an Amazon Web Services (AWS) user account.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The version number of the pipeline. If you do not specify a version, defaults
	// to the most current version.
	Version *int64 `locationName:"version" min:"1" type:"integer"`

	metadataGetPipelineInput `json:"-" xml:"-"`
}

type metadataGetPipelineInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetPipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineInput) GoString() string {
	return s.String()
}

// Represents the output of a get pipeline action.
type GetPipelineOutput struct {
	// Represents the structure of actions and stages to be performed in the pipeline.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure"`

	metadataGetPipelineOutput `json:"-" xml:"-"`
}

type metadataGetPipelineOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetPipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineOutput) GoString() string {
	return s.String()
}

// Represents the input of a get pipeline state action.
type GetPipelineStateInput struct {
	// The name of the pipeline about which you want to get information.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	metadataGetPipelineStateInput `json:"-" xml:"-"`
}

type metadataGetPipelineStateInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetPipelineStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineStateInput) GoString() string {
	return s.String()
}

// Represents the output of a get pipeline state action.
type GetPipelineStateOutput struct {
	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// The name of the pipeline for which you want to get the state.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// The version number of the pipeline.
	//
	// A newly-created pipeline is always assigned a version number of 1.
	PipelineVersion *int64 `locationName:"pipelineVersion" min:"1" type:"integer"`

	// A list of the pipeline stage output information, including stage name, state,
	// most recent run details, whether the stage is disabled, and other data.
	StageStates []*StageState `locationName:"stageStates" type:"list"`

	// The date and time the pipeline was last updated, in timestamp format.
	Updated *time.Time `locationName:"updated" type:"timestamp" timestampFormat:"unix"`

	metadataGetPipelineStateOutput `json:"-" xml:"-"`
}

type metadataGetPipelineStateOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetPipelineStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPipelineStateOutput) GoString() string {
	return s.String()
}

// Represents the input of a get third party job details action.
type GetThirdPartyJobDetailsInput struct {
	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	ClientToken *string `locationName:"clientToken" type:"string" required:"true"`

	// The unique system-generated ID used for identifying the job.
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	metadataGetThirdPartyJobDetailsInput `json:"-" xml:"-"`
}

type metadataGetThirdPartyJobDetailsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetThirdPartyJobDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetThirdPartyJobDetailsInput) GoString() string {
	return s.String()
}

// Represents the output of a get third party job details action.
type GetThirdPartyJobDetailsOutput struct {
	// The details of the job, including any protected values defined for the job.
	JobDetails *ThirdPartyJobDetails `locationName:"jobDetails" type:"structure"`

	metadataGetThirdPartyJobDetailsOutput `json:"-" xml:"-"`
}

type metadataGetThirdPartyJobDetailsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetThirdPartyJobDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetThirdPartyJobDetailsOutput) GoString() string {
	return s.String()
}

// Represents information about an artifact to be worked on, such as a test
// or build artifact.
type InputArtifact struct {
	// The name of the artifact to be worked on, for example, "My App".
	//
	// The input artifact of an action must exactly match the output artifact declared
	// in a preceding action, but the input artifact does not have to be the next
	// action in strict sequence from the action that provided the output artifact.
	// Actions in parallel can declare different output artifacts, which are in
	// turn consumed by different following actions.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	metadataInputArtifact `json:"-" xml:"-"`
}

type metadataInputArtifact struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s InputArtifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InputArtifact) GoString() string {
	return s.String()
}

// Represents information about a job.
type Job struct {
	// The ID of the AWS account to use when performing the job.
	AccountId *string `locationName:"accountId" type:"string"`

	// Additional data about a job.
	Data *JobData `locationName:"data" type:"structure"`

	// The unique system-generated ID of the job.
	Id *string `locationName:"id" type:"string"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. This number must be returned
	// in the response.
	Nonce *string `locationName:"nonce" type:"string"`

	metadataJob `json:"-" xml:"-"`
}

type metadataJob struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Job) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Job) GoString() string {
	return s.String()
}

// Represents additional information about a job required for a job worker to
// complete the job.
type JobData struct {
	// Represents information about an action configuration.
	ActionConfiguration *ActionConfiguration `locationName:"actionConfiguration" type:"structure"`

	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure"`

	// Represents an AWS session credentials object. These credentials are temporary
	// credentials that are issued by AWS Secure Token Service (STS). They can be
	// used to access input and output artifacts in the Amazon S3 bucket used to
	// store artifact for the pipeline in AWS CodePipeline.
	ArtifactCredentials *AWSSessionCredentials `locationName:"artifactCredentials" type:"structure"`

	// A system-generated token, such as a AWS CodeDeploy deployment ID, that a
	// job requires in order to continue the job asynchronously.
	ContinuationToken *string `locationName:"continuationToken" type:"string"`

	// Represents information about the AWS Key Management Service (AWS KMS) key
	// used to encrypt data in the artifact store.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The artifact supplied to the job.
	InputArtifacts []*Artifact `locationName:"inputArtifacts" type:"list"`

	// The output of the job.
	OutputArtifacts []*Artifact `locationName:"outputArtifacts" type:"list"`

	// Represents information about a pipeline to a job worker.
	PipelineContext *PipelineContext `locationName:"pipelineContext" type:"structure"`

	metadataJobData `json:"-" xml:"-"`
}

type metadataJobData struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s JobData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobData) GoString() string {
	return s.String()
}

// Represents information about the details of a job.
type JobDetails struct {
	// The AWS account ID associated with the job.
	AccountId *string `locationName:"accountId" type:"string"`

	// Represents additional information about a job required for a job worker to
	// complete the job.
	Data *JobData `locationName:"data" type:"structure"`

	// The unique system-generated ID of the job.
	Id *string `locationName:"id" type:"string"`

	metadataJobDetails `json:"-" xml:"-"`
}

type metadataJobDetails struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s JobDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s JobDetails) GoString() string {
	return s.String()
}

// Represents the input of a list action types action.
type ListActionTypesInput struct {
	// Filters the list of action types to those created by a specified entity.
	ActionOwnerFilter *string `locationName:"actionOwnerFilter" type:"string" enum:"ActionOwner"`

	// An identifier that was returned from the previous list action types call,
	// which can be used to return the next set of action types in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListActionTypesInput `json:"-" xml:"-"`
}

type metadataListActionTypesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListActionTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActionTypesInput) GoString() string {
	return s.String()
}

// Represents the output of a list action types action.
type ListActionTypesOutput struct {
	// Provides details of the action types.
	ActionTypes []*ActionType `locationName:"actionTypes" type:"list" required:"true"`

	// If the amount of returned information is significantly large, an identifier
	// is also returned which can be used in a subsequent list action types call
	// to return the next set of action types in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListActionTypesOutput `json:"-" xml:"-"`
}

type metadataListActionTypesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListActionTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActionTypesOutput) GoString() string {
	return s.String()
}

// Represents the input of a list pipelines action.
type ListPipelinesInput struct {
	// An identifier that was returned from the previous list pipelines call, which
	// can be used to return the next set of pipelines in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	metadataListPipelinesInput `json:"-" xml:"-"`
}

type metadataListPipelinesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListPipelinesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelinesInput) GoString() string {
	return s.String()
}

// Represents the output of a list pipelines action.
type ListPipelinesOutput struct {
	// If the amount of returned information is significantly large, an identifier
	// is also returned which can be used in a subsequent list pipelines call to
	// return the next set of pipelines in the list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of pipelines.
	Pipelines []*PipelineSummary `locationName:"pipelines" type:"list"`

	metadataListPipelinesOutput `json:"-" xml:"-"`
}

type metadataListPipelinesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListPipelinesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPipelinesOutput) GoString() string {
	return s.String()
}

// Represents information about the output of an action.
type OutputArtifact struct {
	// The name of the output of an artifact, such as "My App".
	//
	// The input artifact of an action must exactly match the output artifact declared
	// in a preceding action, but the input artifact does not have to be the next
	// action in strict sequence from the action that provided the output artifact.
	// Actions in parallel can declare different output artifacts, which are in
	// turn consumed by different following actions.
	//
	// Output artifact names must be unique within a pipeline.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	metadataOutputArtifact `json:"-" xml:"-"`
}

type metadataOutputArtifact struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s OutputArtifact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OutputArtifact) GoString() string {
	return s.String()
}

// Represents information about a pipeline to a job worker.
type PipelineContext struct {
	// Represents the context of an action within the stage of a pipeline to a job
	// worker.
	Action *ActionContext `locationName:"action" type:"structure"`

	// The name of the pipeline. This is a user-specified value. Pipeline names
	// must be unique across all pipeline names under an Amazon Web Services account.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string"`

	// The stage of the pipeline.
	Stage *StageContext `locationName:"stage" type:"structure"`

	metadataPipelineContext `json:"-" xml:"-"`
}

type metadataPipelineContext struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PipelineContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineContext) GoString() string {
	return s.String()
}

// Represents the structure of actions and stages to be performed in the pipeline.
type PipelineDeclaration struct {
	// The Amazon S3 location where artifacts are stored for the pipeline. If this
	// Amazon S3 bucket is created manually, it must meet the requirements for AWS
	// CodePipeline. For more information, see the Concepts.
	ArtifactStore *ArtifactStore `locationName:"artifactStore" type:"structure" required:"true"`

	// The name of the action to be performed.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) for AWS CodePipeline to use to either perform
	// actions with no actionRoleArn, or to use to assume roles for actions with
	// an actionRoleArn.
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The stage in which to perform the action.
	Stages []*StageDeclaration `locationName:"stages" type:"list" required:"true"`

	// The version number of the pipeline. A new pipeline always has a version number
	// of 1. This number is automatically incremented when a pipeline is updated.
	Version *int64 `locationName:"version" min:"1" type:"integer"`

	metadataPipelineDeclaration `json:"-" xml:"-"`
}

type metadataPipelineDeclaration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PipelineDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineDeclaration) GoString() string {
	return s.String()
}

// Returns a summary of a pipeline.
type PipelineSummary struct {
	// The date and time the pipeline was created, in timestamp format.
	Created *time.Time `locationName:"created" type:"timestamp" timestampFormat:"unix"`

	// The name of the pipeline.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The date and time of the last update to the pipeline, in timestamp format.
	Updated *time.Time `locationName:"updated" type:"timestamp" timestampFormat:"unix"`

	// The version number of the pipeline.
	Version *int64 `locationName:"version" min:"1" type:"integer"`

	metadataPipelineSummary `json:"-" xml:"-"`
}

type metadataPipelineSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PipelineSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PipelineSummary) GoString() string {
	return s.String()
}

// Represents the input of a poll for jobs action.
type PollForJobsInput struct {
	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The maximum number of jobs to return in a poll for jobs call.
	MaxBatchSize *int64 `locationName:"maxBatchSize" min:"1" type:"integer"`

	// A map of property names and values. For an action type with no queryable
	// properties, this value must be null or an empty map. For an action type with
	// a queryable property, you must supply that property as a key in the map.
	// Only jobs whose action configuration matches the mapped value will be returned.
	QueryParam map[string]*string `locationName:"queryParam" type:"map"`

	metadataPollForJobsInput `json:"-" xml:"-"`
}

type metadataPollForJobsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PollForJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForJobsInput) GoString() string {
	return s.String()
}

// Represents the output of a poll for jobs action.
type PollForJobsOutput struct {
	// Information about the jobs to take action on.
	Jobs []*Job `locationName:"jobs" type:"list"`

	metadataPollForJobsOutput `json:"-" xml:"-"`
}

type metadataPollForJobsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PollForJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForJobsOutput) GoString() string {
	return s.String()
}

// Represents the input of a poll for third party jobs action.
type PollForThirdPartyJobsInput struct {
	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure" required:"true"`

	// The maximum number of jobs to return in a poll for jobs call.
	MaxBatchSize *int64 `locationName:"maxBatchSize" min:"1" type:"integer"`

	metadataPollForThirdPartyJobsInput `json:"-" xml:"-"`
}

type metadataPollForThirdPartyJobsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PollForThirdPartyJobsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForThirdPartyJobsInput) GoString() string {
	return s.String()
}

// Represents the output of a poll for third party jobs action.
type PollForThirdPartyJobsOutput struct {
	// Information about the jobs to take action on.
	Jobs []*ThirdPartyJob `locationName:"jobs" type:"list"`

	metadataPollForThirdPartyJobsOutput `json:"-" xml:"-"`
}

type metadataPollForThirdPartyJobsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PollForThirdPartyJobsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PollForThirdPartyJobsOutput) GoString() string {
	return s.String()
}

// Represents the input of a put action revision action.
type PutActionRevisionInput struct {
	// The name of the action that will process the revision.
	ActionName *string `locationName:"actionName" min:"1" type:"string" required:"true"`

	// Represents information about the version (or revision) of an action.
	ActionRevision *ActionRevision `locationName:"actionRevision" type:"structure" required:"true"`

	// The name of the pipeline that will start processing the revision to the source.
	PipelineName *string `locationName:"pipelineName" min:"1" type:"string" required:"true"`

	// The name of the stage that contains the action that will act upon the revision.
	StageName *string `locationName:"stageName" min:"1" type:"string" required:"true"`

	metadataPutActionRevisionInput `json:"-" xml:"-"`
}

type metadataPutActionRevisionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutActionRevisionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutActionRevisionInput) GoString() string {
	return s.String()
}

// Represents the output of a put action revision action.
type PutActionRevisionOutput struct {
	// The new revision number or ID for the revision after the action completes.
	NewRevision *bool `locationName:"newRevision" type:"boolean"`

	// The ID of the current workflow state of the pipeline.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	metadataPutActionRevisionOutput `json:"-" xml:"-"`
}

type metadataPutActionRevisionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutActionRevisionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutActionRevisionOutput) GoString() string {
	return s.String()
}

// Represents the input of a put job failure result action.
type PutJobFailureResultInput struct {
	// The details about the failure of a job.
	FailureDetails *FailureDetails `locationName:"failureDetails" type:"structure" required:"true"`

	// The unique system-generated ID of the job that failed. This is the same ID
	// returned from PollForJobs.
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	metadataPutJobFailureResultInput `json:"-" xml:"-"`
}

type metadataPutJobFailureResultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutJobFailureResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobFailureResultInput) GoString() string {
	return s.String()
}

type PutJobFailureResultOutput struct {
	metadataPutJobFailureResultOutput `json:"-" xml:"-"`
}

type metadataPutJobFailureResultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutJobFailureResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobFailureResultOutput) GoString() string {
	return s.String()
}

// Represents the input of a put job success result action.
type PutJobSuccessResultInput struct {
	// A system-generated token, such as a AWS CodeDeploy deployment ID, that the
	// successful job used to complete a job asynchronously.
	ContinuationToken *string `locationName:"continuationToken" type:"string"`

	// The ID of the current revision of the artifact successfully worked upon by
	// the job.
	CurrentRevision *CurrentRevision `locationName:"currentRevision" type:"structure"`

	// The execution details of the successful job, such as the actions taken by
	// the job worker.
	ExecutionDetails *ExecutionDetails `locationName:"executionDetails" type:"structure"`

	// The unique system-generated ID of the job that succeeded. This is the same
	// ID returned from PollForJobs.
	JobId *string `locationName:"jobId" type:"string" required:"true"`

	metadataPutJobSuccessResultInput `json:"-" xml:"-"`
}

type metadataPutJobSuccessResultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutJobSuccessResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobSuccessResultInput) GoString() string {
	return s.String()
}

type PutJobSuccessResultOutput struct {
	metadataPutJobSuccessResultOutput `json:"-" xml:"-"`
}

type metadataPutJobSuccessResultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutJobSuccessResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutJobSuccessResultOutput) GoString() string {
	return s.String()
}

// Represents the input of a third party job failure result action.
type PutThirdPartyJobFailureResultInput struct {
	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	ClientToken *string `locationName:"clientToken" type:"string" required:"true"`

	// Represents information about failure details.
	FailureDetails *FailureDetails `locationName:"failureDetails" type:"structure" required:"true"`

	// The ID of the job that failed. This is the same ID returned from PollForThirdPartyJobs.
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	metadataPutThirdPartyJobFailureResultInput `json:"-" xml:"-"`
}

type metadataPutThirdPartyJobFailureResultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutThirdPartyJobFailureResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutThirdPartyJobFailureResultInput) GoString() string {
	return s.String()
}

type PutThirdPartyJobFailureResultOutput struct {
	metadataPutThirdPartyJobFailureResultOutput `json:"-" xml:"-"`
}

type metadataPutThirdPartyJobFailureResultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutThirdPartyJobFailureResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutThirdPartyJobFailureResultOutput) GoString() string {
	return s.String()
}

// Represents the input of a put third party job success result action.
type PutThirdPartyJobSuccessResultInput struct {
	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	ClientToken *string `locationName:"clientToken" type:"string" required:"true"`

	// A system-generated token, such as a AWS CodeDeploy deployment ID, that a
	// job uses in order to continue the job asynchronously.
	ContinuationToken *string `locationName:"continuationToken" type:"string"`

	// Represents information about a current revision.
	CurrentRevision *CurrentRevision `locationName:"currentRevision" type:"structure"`

	// The details of the actions taken and results produced on an artifact as it
	// passes through stages in the pipeline.
	ExecutionDetails *ExecutionDetails `locationName:"executionDetails" type:"structure"`

	// The ID of the job that successfully completed. This is the same ID returned
	// from PollForThirdPartyJobs.
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	metadataPutThirdPartyJobSuccessResultInput `json:"-" xml:"-"`
}

type metadataPutThirdPartyJobSuccessResultInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutThirdPartyJobSuccessResultInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutThirdPartyJobSuccessResultInput) GoString() string {
	return s.String()
}

type PutThirdPartyJobSuccessResultOutput struct {
	metadataPutThirdPartyJobSuccessResultOutput `json:"-" xml:"-"`
}

type metadataPutThirdPartyJobSuccessResultOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s PutThirdPartyJobSuccessResultOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutThirdPartyJobSuccessResultOutput) GoString() string {
	return s.String()
}

// The location of the Amazon S3 bucket that contains a revision.
type S3ArtifactLocation struct {
	// The name of the Amazon S3 bucket.
	BucketName *string `locationName:"bucketName" type:"string" required:"true"`

	// The key of the object in the Amazon S3 bucket, which uniquely identifies
	// the object in the bucket.
	ObjectKey *string `locationName:"objectKey" type:"string" required:"true"`

	metadataS3ArtifactLocation `json:"-" xml:"-"`
}

type metadataS3ArtifactLocation struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s S3ArtifactLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3ArtifactLocation) GoString() string {
	return s.String()
}

// Represents information about a stage to a job worker.
type StageContext struct {
	// The name of the stage.
	Name *string `locationName:"name" min:"1" type:"string"`

	metadataStageContext `json:"-" xml:"-"`
}

type metadataStageContext struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StageContext) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StageContext) GoString() string {
	return s.String()
}

// Represents information about a stage and its definition.
type StageDeclaration struct {
	// The actions included in a stage.
	Actions []*ActionDeclaration `locationName:"actions" type:"list" required:"true"`

	// The gates included in a stage.
	Blockers []*BlockerDeclaration `locationName:"blockers" type:"list"`

	// The name of the stage.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	metadataStageDeclaration `json:"-" xml:"-"`
}

type metadataStageDeclaration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StageDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StageDeclaration) GoString() string {
	return s.String()
}

// Represents information about the state of the stage.
type StageState struct {
	// The state of the stage.
	ActionStates []*ActionState `locationName:"actionStates" type:"list"`

	// The state of the inbound transition, which is either enabled or disabled.
	InboundTransitionState *TransitionState `locationName:"inboundTransitionState" type:"structure"`

	// The name of the stage.
	StageName *string `locationName:"stageName" min:"1" type:"string"`

	metadataStageState `json:"-" xml:"-"`
}

type metadataStageState struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StageState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StageState) GoString() string {
	return s.String()
}

// Represents the input of a start pipeline execution action.
type StartPipelineExecutionInput struct {
	// The name of the pipeline to start.
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	metadataStartPipelineExecutionInput `json:"-" xml:"-"`
}

type metadataStartPipelineExecutionInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StartPipelineExecutionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPipelineExecutionInput) GoString() string {
	return s.String()
}

// Represents the output of a start pipeline execution action.
type StartPipelineExecutionOutput struct {
	// The unique system-generated ID of the pipeline that was started.
	PipelineExecutionId *string `locationName:"pipelineExecutionId" type:"string"`

	metadataStartPipelineExecutionOutput `json:"-" xml:"-"`
}

type metadataStartPipelineExecutionOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StartPipelineExecutionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartPipelineExecutionOutput) GoString() string {
	return s.String()
}

// A response to a PollForThirdPartyJobs request returned by AWS CodePipeline
// when there is a job to be worked upon by a partner action.
type ThirdPartyJob struct {
	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	ClientId *string `locationName:"clientId" type:"string"`

	// The identifier used to identify the job in AWS CodePipeline.
	JobId *string `locationName:"jobId" type:"string"`

	metadataThirdPartyJob `json:"-" xml:"-"`
}

type metadataThirdPartyJob struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ThirdPartyJob) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThirdPartyJob) GoString() string {
	return s.String()
}

// Represents information about the job data for a partner action.
type ThirdPartyJobData struct {
	// Represents information about an action configuration.
	ActionConfiguration *ActionConfiguration `locationName:"actionConfiguration" type:"structure"`

	// Represents information about an action type.
	ActionTypeId *ActionTypeId `locationName:"actionTypeId" type:"structure"`

	// Represents an AWS session credentials object. These credentials are temporary
	// credentials that are issued by AWS Secure Token Service (STS). They can be
	// used to access input and output artifacts in the Amazon S3 bucket used to
	// store artifact for the pipeline in AWS CodePipeline.
	ArtifactCredentials *AWSSessionCredentials `locationName:"artifactCredentials" type:"structure"`

	// A system-generated token, such as a AWS CodeDeploy deployment ID, that a
	// job requires in order to continue the job asynchronously.
	ContinuationToken *string `locationName:"continuationToken" type:"string"`

	// The AWS Key Management Service (AWS KMS) key used to encrypt and decrypt
	// data in the artifact store for the pipeline.
	EncryptionKey *EncryptionKey `locationName:"encryptionKey" type:"structure"`

	// The name of the artifact that will be worked upon by the action, if any.
	// This name might be system-generated, such as "MyApp", or might be defined
	// by the user when the action is created. The input artifact name must match
	// the name of an output artifact generated by an action in an earlier action
	// or stage of the pipeline.
	InputArtifacts []*Artifact `locationName:"inputArtifacts" type:"list"`

	// The name of the artifact that will be the result of the action, if any. This
	// name might be system-generated, such as "MyBuiltApp", or might be defined
	// by the user when the action is created.
	OutputArtifacts []*Artifact `locationName:"outputArtifacts" type:"list"`

	// Represents information about a pipeline to a job worker.
	PipelineContext *PipelineContext `locationName:"pipelineContext" type:"structure"`

	metadataThirdPartyJobData `json:"-" xml:"-"`
}

type metadataThirdPartyJobData struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ThirdPartyJobData) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThirdPartyJobData) GoString() string {
	return s.String()
}

// The details of a job sent in response to a GetThirdPartyJobDetails request.
type ThirdPartyJobDetails struct {
	// The data to be returned by the third party job worker.
	Data *ThirdPartyJobData `locationName:"data" type:"structure"`

	// The identifier used to identify the job details in AWS CodePipeline.
	Id *string `locationName:"id" min:"1" type:"string"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. This number must be returned
	// in the response.
	Nonce *string `locationName:"nonce" type:"string"`

	metadataThirdPartyJobDetails `json:"-" xml:"-"`
}

type metadataThirdPartyJobDetails struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ThirdPartyJobDetails) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ThirdPartyJobDetails) GoString() string {
	return s.String()
}

// Represents information about the state of transitions between one stage and
// another stage.
type TransitionState struct {
	// The user-specified reason why the transition between two stages of a pipeline
	// was disabled.
	DisabledReason *string `locationName:"disabledReason" min:"1" type:"string"`

	// Whether the transition between stages is enabled (true) or disabled (false).
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The timestamp when the transition state was last changed.
	LastChangedAt *time.Time `locationName:"lastChangedAt" type:"timestamp" timestampFormat:"unix"`

	// The ID of the user who last changed the transition state.
	LastChangedBy *string `locationName:"lastChangedBy" type:"string"`

	metadataTransitionState `json:"-" xml:"-"`
}

type metadataTransitionState struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TransitionState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TransitionState) GoString() string {
	return s.String()
}

// Represents the input of an update pipeline action.
type UpdatePipelineInput struct {
	// The name of the pipeline to be updated.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure" required:"true"`

	metadataUpdatePipelineInput `json:"-" xml:"-"`
}

type metadataUpdatePipelineInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdatePipelineInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineInput) GoString() string {
	return s.String()
}

// Represents the output of an update pipeline action.
type UpdatePipelineOutput struct {
	// The structure of the updated pipeline.
	Pipeline *PipelineDeclaration `locationName:"pipeline" type:"structure"`

	metadataUpdatePipelineOutput `json:"-" xml:"-"`
}

type metadataUpdatePipelineOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdatePipelineOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdatePipelineOutput) GoString() string {
	return s.String()
}

const (
	// @enum ActionCategory
	ActionCategorySource = "Source"
	// @enum ActionCategory
	ActionCategoryBuild = "Build"
	// @enum ActionCategory
	ActionCategoryDeploy = "Deploy"
	// @enum ActionCategory
	ActionCategoryTest = "Test"
	// @enum ActionCategory
	ActionCategoryInvoke = "Invoke"
)

const (
	// @enum ActionConfigurationPropertyType
	ActionConfigurationPropertyTypeString = "String"
	// @enum ActionConfigurationPropertyType
	ActionConfigurationPropertyTypeNumber = "Number"
	// @enum ActionConfigurationPropertyType
	ActionConfigurationPropertyTypeBoolean = "Boolean"
)

const (
	// @enum ActionExecutionStatus
	ActionExecutionStatusInProgress = "InProgress"
	// @enum ActionExecutionStatus
	ActionExecutionStatusSucceeded = "Succeeded"
	// @enum ActionExecutionStatus
	ActionExecutionStatusFailed = "Failed"
)

const (
	// @enum ActionOwner
	ActionOwnerAws = "AWS"
	// @enum ActionOwner
	ActionOwnerThirdParty = "ThirdParty"
	// @enum ActionOwner
	ActionOwnerCustom = "Custom"
)

const (
	// @enum ArtifactLocationType
	ArtifactLocationTypeS3 = "S3"
)

const (
	// @enum ArtifactStoreType
	ArtifactStoreTypeS3 = "S3"
)

const (
	// @enum BlockerType
	BlockerTypeSchedule = "Schedule"
)

const (
	// @enum EncryptionKeyType
	EncryptionKeyTypeKms = "KMS"
)

const (
	// @enum FailureType
	FailureTypeJobFailed = "JobFailed"
	// @enum FailureType
	FailureTypeConfigurationError = "ConfigurationError"
	// @enum FailureType
	FailureTypePermissionError = "PermissionError"
	// @enum FailureType
	FailureTypeRevisionOutOfSync = "RevisionOutOfSync"
	// @enum FailureType
	FailureTypeRevisionUnavailable = "RevisionUnavailable"
	// @enum FailureType
	FailureTypeSystemUnavailable = "SystemUnavailable"
)

const (
	// @enum JobStatus
	JobStatusCreated = "Created"
	// @enum JobStatus
	JobStatusQueued = "Queued"
	// @enum JobStatus
	JobStatusDispatched = "Dispatched"
	// @enum JobStatus
	JobStatusInProgress = "InProgress"
	// @enum JobStatus
	JobStatusTimedOut = "TimedOut"
	// @enum JobStatus
	JobStatusSucceeded = "Succeeded"
	// @enum JobStatus
	JobStatusFailed = "Failed"
)

const (
	// @enum StageTransitionType
	StageTransitionTypeInbound = "Inbound"
	// @enum StageTransitionType
	StageTransitionTypeOutbound = "Outbound"
)
