// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package cloudformation provides a client for AWS CloudFormation.
package cloudformation

import (
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opCancelUpdateStack = "CancelUpdateStack"

// CancelUpdateStackRequest generates a request for the CancelUpdateStack operation.
func (c *CloudFormation) CancelUpdateStackRequest(input *CancelUpdateStackInput) (req *request.Request, output *CancelUpdateStackOutput) {
	op := &request.Operation{
		Name:       opCancelUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CancelUpdateStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CancelUpdateStackOutput{}
	req.Data = output
	return
}

// Cancels an update on the specified stack. If the call completes successfully,
// the stack will roll back the update and revert to the previous stack configuration.
//
// Only stacks that are in the UPDATE_IN_PROGRESS state can be canceled.
func (c *CloudFormation) CancelUpdateStack(input *CancelUpdateStackInput) (*CancelUpdateStackOutput, error) {
	req, out := c.CancelUpdateStackRequest(input)
	err := req.Send()
	return out, err
}

const opCreateStack = "CreateStack"

// CreateStackRequest generates a request for the CreateStack operation.
func (c *CloudFormation) CreateStackRequest(input *CreateStackInput) (req *request.Request, output *CreateStackOutput) {
	op := &request.Operation{
		Name:       opCreateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &CreateStackOutput{}
	req.Data = output
	return
}

// Creates a stack as specified in the template. After the call completes successfully,
// the stack creation starts. You can check the status of the stack via the
// DescribeStacks API.
func (c *CloudFormation) CreateStack(input *CreateStackInput) (*CreateStackOutput, error) {
	req, out := c.CreateStackRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteStack = "DeleteStack"

// DeleteStackRequest generates a request for the DeleteStack operation.
func (c *CloudFormation) DeleteStackRequest(input *DeleteStackInput) (req *request.Request, output *DeleteStackOutput) {
	op := &request.Operation{
		Name:       opDeleteStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DeleteStackOutput{}
	req.Data = output
	return
}

// Deletes a specified stack. Once the call completes successfully, stack deletion
// starts. Deleted stacks do not show up in the DescribeStacks API if the deletion
// has been completed successfully.
func (c *CloudFormation) DeleteStack(input *DeleteStackInput) (*DeleteStackOutput, error) {
	req, out := c.DeleteStackRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStackEvents = "DescribeStackEvents"

// DescribeStackEventsRequest generates a request for the DescribeStackEvents operation.
func (c *CloudFormation) DescribeStackEventsRequest(input *DescribeStackEventsInput) (req *request.Request, output *DescribeStackEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeStackEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStackEventsInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStackEventsOutput{}
	req.Data = output
	return
}

// Returns all stack related events for a specified stack. For more information
// about a stack's event history, go to Stacks (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/concept-stack.html)
// in the AWS CloudFormation User Guide.
//
// You can list events for stacks that have failed to create or have been deleted
// by specifying the unique stack identifier (stack ID).
func (c *CloudFormation) DescribeStackEvents(input *DescribeStackEventsInput) (*DescribeStackEventsOutput, error) {
	req, out := c.DescribeStackEventsRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFormation) DescribeStackEventsPages(input *DescribeStackEventsInput, fn func(p *DescribeStackEventsOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeStackEventsRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeStackEventsOutput), lastPage)
	})
}

const opDescribeStackResource = "DescribeStackResource"

// DescribeStackResourceRequest generates a request for the DescribeStackResource operation.
func (c *CloudFormation) DescribeStackResourceRequest(input *DescribeStackResourceInput) (req *request.Request, output *DescribeStackResourceOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStackResourceOutput{}
	req.Data = output
	return
}

// Returns a description of the specified resource in the specified stack.
//
// For deleted stacks, DescribeStackResource returns resource information for
// up to 90 days after the stack has been deleted.
func (c *CloudFormation) DescribeStackResource(input *DescribeStackResourceInput) (*DescribeStackResourceOutput, error) {
	req, out := c.DescribeStackResourceRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStackResources = "DescribeStackResources"

// DescribeStackResourcesRequest generates a request for the DescribeStackResources operation.
func (c *CloudFormation) DescribeStackResourcesRequest(input *DescribeStackResourcesInput) (req *request.Request, output *DescribeStackResourcesOutput) {
	op := &request.Operation{
		Name:       opDescribeStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeStackResourcesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStackResourcesOutput{}
	req.Data = output
	return
}

// Returns AWS resource descriptions for running and deleted stacks. If StackName
// is specified, all the associated resources that are part of the stack are
// returned. If PhysicalResourceId is specified, the associated resources of
// the stack that the resource belongs to are returned.
//
// Only the first 100 resources will be returned. If your stack has more resources
// than this, you should use ListStackResources instead. For deleted stacks,
// DescribeStackResources returns resource information for up to 90 days after
// the stack has been deleted.
//
// You must specify either StackName or PhysicalResourceId, but not both. In
// addition, you can specify LogicalResourceId to filter the returned result.
// For more information about resources, the LogicalResourceId and PhysicalResourceId,
// go to the AWS CloudFormation User Guide (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide).
//
// A ValidationError is returned if you specify both StackName and PhysicalResourceId
// in the same request.
func (c *CloudFormation) DescribeStackResources(input *DescribeStackResourcesInput) (*DescribeStackResourcesOutput, error) {
	req, out := c.DescribeStackResourcesRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeStacks = "DescribeStacks"

// DescribeStacksRequest generates a request for the DescribeStacks operation.
func (c *CloudFormation) DescribeStacksRequest(input *DescribeStacksInput) (req *request.Request, output *DescribeStacksOutput) {
	op := &request.Operation{
		Name:       opDescribeStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeStacksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &DescribeStacksOutput{}
	req.Data = output
	return
}

// Returns the description for the specified stack; if no stack name was specified,
// then it returns the description for all the stacks created.
func (c *CloudFormation) DescribeStacks(input *DescribeStacksInput) (*DescribeStacksOutput, error) {
	req, out := c.DescribeStacksRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFormation) DescribeStacksPages(input *DescribeStacksInput, fn func(p *DescribeStacksOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.DescribeStacksRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*DescribeStacksOutput), lastPage)
	})
}

const opEstimateTemplateCost = "EstimateTemplateCost"

// EstimateTemplateCostRequest generates a request for the EstimateTemplateCost operation.
func (c *CloudFormation) EstimateTemplateCostRequest(input *EstimateTemplateCostInput) (req *request.Request, output *EstimateTemplateCostOutput) {
	op := &request.Operation{
		Name:       opEstimateTemplateCost,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &EstimateTemplateCostInput{}
	}

	req = c.newRequest(op, input, output)
	output = &EstimateTemplateCostOutput{}
	req.Data = output
	return
}

// Returns the estimated monthly cost of a template. The return value is an
// AWS Simple Monthly Calculator URL with a query string that describes the
// resources required to run the template.
func (c *CloudFormation) EstimateTemplateCost(input *EstimateTemplateCostInput) (*EstimateTemplateCostOutput, error) {
	req, out := c.EstimateTemplateCostRequest(input)
	err := req.Send()
	return out, err
}

const opGetStackPolicy = "GetStackPolicy"

// GetStackPolicyRequest generates a request for the GetStackPolicy operation.
func (c *CloudFormation) GetStackPolicyRequest(input *GetStackPolicyInput) (req *request.Request, output *GetStackPolicyOutput) {
	op := &request.Operation{
		Name:       opGetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetStackPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetStackPolicyOutput{}
	req.Data = output
	return
}

// Returns the stack policy for a specified stack. If a stack doesn't have a
// policy, a null value is returned.
func (c *CloudFormation) GetStackPolicy(input *GetStackPolicyInput) (*GetStackPolicyOutput, error) {
	req, out := c.GetStackPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opGetTemplate = "GetTemplate"

// GetTemplateRequest generates a request for the GetTemplate operation.
func (c *CloudFormation) GetTemplateRequest(input *GetTemplateInput) (req *request.Request, output *GetTemplateOutput) {
	op := &request.Operation{
		Name:       opGetTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTemplateOutput{}
	req.Data = output
	return
}

// Returns the template body for a specified stack. You can get the template
// for running or deleted stacks.
//
// For deleted stacks, GetTemplate returns the template for up to 90 days after
// the stack has been deleted.
//
//  If the template does not exist, a ValidationError is returned.
func (c *CloudFormation) GetTemplate(input *GetTemplateInput) (*GetTemplateOutput, error) {
	req, out := c.GetTemplateRequest(input)
	err := req.Send()
	return out, err
}

const opGetTemplateSummary = "GetTemplateSummary"

// GetTemplateSummaryRequest generates a request for the GetTemplateSummary operation.
func (c *CloudFormation) GetTemplateSummaryRequest(input *GetTemplateSummaryInput) (req *request.Request, output *GetTemplateSummaryOutput) {
	op := &request.Operation{
		Name:       opGetTemplateSummary,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTemplateSummaryInput{}
	}

	req = c.newRequest(op, input, output)
	output = &GetTemplateSummaryOutput{}
	req.Data = output
	return
}

// Returns information about a new or existing template. The GetTemplateSummary
// action is useful for viewing parameter information, such as default parameter
// values and parameter types, before you create or update a stack.
//
// You can use the GetTemplateSummary action when you submit a template, or
// you can get template information for a running or deleted stack.
//
// For deleted stacks, GetTemplateSummary returns the template information
// for up to 90 days after the stack has been deleted. If the template does
// not exist, a ValidationError is returned.
func (c *CloudFormation) GetTemplateSummary(input *GetTemplateSummaryInput) (*GetTemplateSummaryOutput, error) {
	req, out := c.GetTemplateSummaryRequest(input)
	err := req.Send()
	return out, err
}

const opListStackResources = "ListStackResources"

// ListStackResourcesRequest generates a request for the ListStackResources operation.
func (c *CloudFormation) ListStackResourcesRequest(input *ListStackResourcesInput) (req *request.Request, output *ListStackResourcesOutput) {
	op := &request.Operation{
		Name:       opListStackResources,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStackResourcesInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListStackResourcesOutput{}
	req.Data = output
	return
}

// Returns descriptions of all resources of the specified stack.
//
// For deleted stacks, ListStackResources returns resource information for
// up to 90 days after the stack has been deleted.
func (c *CloudFormation) ListStackResources(input *ListStackResourcesInput) (*ListStackResourcesOutput, error) {
	req, out := c.ListStackResourcesRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFormation) ListStackResourcesPages(input *ListStackResourcesInput, fn func(p *ListStackResourcesOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListStackResourcesRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListStackResourcesOutput), lastPage)
	})
}

const opListStacks = "ListStacks"

// ListStacksRequest generates a request for the ListStacks operation.
func (c *CloudFormation) ListStacksRequest(input *ListStacksInput) (req *request.Request, output *ListStacksOutput) {
	op := &request.Operation{
		Name:       opListStacks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListStacksInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ListStacksOutput{}
	req.Data = output
	return
}

// Returns the summary information for stacks whose status matches the specified
// StackStatusFilter. Summary information for stacks that have been deleted
// is kept for 90 days after the stack is deleted. If no StackStatusFilter is
// specified, summary information for all stacks is returned (including existing
// stacks and stacks that have been deleted).
func (c *CloudFormation) ListStacks(input *ListStacksInput) (*ListStacksOutput, error) {
	req, out := c.ListStacksRequest(input)
	err := req.Send()
	return out, err
}

func (c *CloudFormation) ListStacksPages(input *ListStacksInput, fn func(p *ListStacksOutput, lastPage bool) (shouldContinue bool)) error {
	page, _ := c.ListStacksRequest(input)
	return page.EachPage(func(p interface{}, lastPage bool) bool {
		return fn(p.(*ListStacksOutput), lastPage)
	})
}

const opSetStackPolicy = "SetStackPolicy"

// SetStackPolicyRequest generates a request for the SetStackPolicy operation.
func (c *CloudFormation) SetStackPolicyRequest(input *SetStackPolicyInput) (req *request.Request, output *SetStackPolicyOutput) {
	op := &request.Operation{
		Name:       opSetStackPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetStackPolicyInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SetStackPolicyOutput{}
	req.Data = output
	return
}

// Sets a stack policy for a specified stack.
func (c *CloudFormation) SetStackPolicy(input *SetStackPolicyInput) (*SetStackPolicyOutput, error) {
	req, out := c.SetStackPolicyRequest(input)
	err := req.Send()
	return out, err
}

const opSignalResource = "SignalResource"

// SignalResourceRequest generates a request for the SignalResource operation.
func (c *CloudFormation) SignalResourceRequest(input *SignalResourceInput) (req *request.Request, output *SignalResourceOutput) {
	op := &request.Operation{
		Name:       opSignalResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SignalResourceInput{}
	}

	req = c.newRequest(op, input, output)
	output = &SignalResourceOutput{}
	req.Data = output
	return
}

// Sends a signal to the specified resource with a success or failure status.
// You can use the SignalResource API in conjunction with a creation policy
// or update policy. AWS CloudFormation doesn't proceed with a stack creation
// or update until resources receive the required number of signals or the timeout
// period is exceeded. The SignalResource API is useful in cases where you want
// to send signals from anywhere other than an Amazon EC2 instance.
func (c *CloudFormation) SignalResource(input *SignalResourceInput) (*SignalResourceOutput, error) {
	req, out := c.SignalResourceRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateStack = "UpdateStack"

// UpdateStackRequest generates a request for the UpdateStack operation.
func (c *CloudFormation) UpdateStackRequest(input *UpdateStackInput) (req *request.Request, output *UpdateStackOutput) {
	op := &request.Operation{
		Name:       opUpdateStack,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateStackInput{}
	}

	req = c.newRequest(op, input, output)
	output = &UpdateStackOutput{}
	req.Data = output
	return
}

// Updates a stack as specified in the template. After the call completes successfully,
// the stack update starts. You can check the status of the stack via the DescribeStacks
// action.
//
// To get a copy of the template for an existing stack, you can use the GetTemplate
// action.
//
// Tags that were associated with this stack during creation time will still
// be associated with the stack after an UpdateStack operation.
//
// For more information about creating an update template, updating a stack,
// and monitoring the progress of the update, see Updating a Stack (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks.html).
func (c *CloudFormation) UpdateStack(input *UpdateStackInput) (*UpdateStackOutput, error) {
	req, out := c.UpdateStackRequest(input)
	err := req.Send()
	return out, err
}

const opValidateTemplate = "ValidateTemplate"

// ValidateTemplateRequest generates a request for the ValidateTemplate operation.
func (c *CloudFormation) ValidateTemplateRequest(input *ValidateTemplateInput) (req *request.Request, output *ValidateTemplateOutput) {
	op := &request.Operation{
		Name:       opValidateTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ValidateTemplateInput{}
	}

	req = c.newRequest(op, input, output)
	output = &ValidateTemplateOutput{}
	req.Data = output
	return
}

// Validates a specified template.
func (c *CloudFormation) ValidateTemplate(input *ValidateTemplateInput) (*ValidateTemplateOutput, error) {
	req, out := c.ValidateTemplateRequest(input)
	err := req.Send()
	return out, err
}

// The input for CancelUpdateStack action.
type CancelUpdateStackInput struct {
	// The name or the unique stack ID that is associated with the stack.
	StackName *string `type:"string" required:"true"`

	metadataCancelUpdateStackInput `json:"-" xml:"-"`
}

type metadataCancelUpdateStackInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CancelUpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelUpdateStackInput) GoString() string {
	return s.String()
}

type CancelUpdateStackOutput struct {
	metadataCancelUpdateStackOutput `json:"-" xml:"-"`
}

type metadataCancelUpdateStackOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CancelUpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CancelUpdateStackOutput) GoString() string {
	return s.String()
}

// The input for CreateStack action.
type CreateStackInput struct {
	// A list of capabilities that you must specify before AWS CloudFormation can
	// create or update certain stacks. Some stack templates might include resources
	// that can affect permissions in your AWS account. For those stacks, you must
	// explicitly acknowledge their capabilities by specifying this parameter.
	//
	// Currently, the only valid value is CAPABILITY_IAM, which is required for
	// the following resources:  AWS::IAM::AccessKey (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html),
	//  AWS::IAM::Group (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	//  AWS::IAM::InstanceProfile (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	//  AWS::IAM::Policy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html),
	//  AWS::IAM::Role (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html),
	//  AWS::IAM::User (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html),
	// and  AWS::IAM::UserToGroupAddition (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html).
	// If your stack template contains these resources, we recommend that you review
	// any permissions associated with them. If you don't specify this parameter,
	// this action returns an InsufficientCapabilities error.
	Capabilities []*string `type:"list"`

	// Set to true to disable rollback of the stack if stack creation failed. You
	// can specify either DisableRollback or OnFailure, but not both.
	//
	// Default: false
	DisableRollback *bool `type:"boolean"`

	// The Simple Notification Service (SNS) topic ARNs to publish stack related
	// events. You can find your SNS topic ARNs using the SNS console (http://console.aws.amazon.com/sns)
	// or your Command Line Interface (CLI).
	NotificationARNs []*string `type:"list"`

	// Determines what action will be taken if stack creation fails. This must be
	// one of: DO_NOTHING, ROLLBACK, or DELETE. You can specify either OnFailure
	// or DisableRollback, but not both.
	//
	// Default: ROLLBACK
	OnFailure *string `type:"string" enum:"OnFailure"`

	// A list of Parameter structures that specify input parameters for the stack.
	Parameters []*Parameter `type:"list"`

	// The name that is associated with the stack. The name must be unique in the
	// region in which you are creating the stack.
	//
	// A stack name can contain only alphanumeric characters (case sensitive) and
	// hyphens. It must start with an alphabetic character and cannot be longer
	// than 255 characters.
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to
	// Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (max size: 16KB) located in an S3 bucket in the same region as the stack.
	// You can specify either the StackPolicyBody or the StackPolicyURL parameter,
	// but not both.
	StackPolicyURL *string `min:"1" type:"string"`

	// A set of user-defined Tags to associate with this stack, represented by key/value
	// pairs. Tags defined for the stack are propagated to EC2 resources that are
	// created as part of the stack. A maximum number of 10 tags can be specified.
	Tags []*Tag `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) located in an S3 bucket in the same region as the
	// stack. For more information, go to the Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`

	// The amount of time that can pass before the stack status becomes CREATE_FAILED;
	// if DisableRollback is not set or is set to false, the stack will be rolled
	// back.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`

	metadataCreateStackInput `json:"-" xml:"-"`
}

type metadataCreateStackInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackInput) GoString() string {
	return s.String()
}

// The output for a CreateStack action.
type CreateStackOutput struct {
	// Unique identifier of the stack.
	StackId *string `type:"string"`

	metadataCreateStackOutput `json:"-" xml:"-"`
}

type metadataCreateStackOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s CreateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateStackOutput) GoString() string {
	return s.String()
}

// The input for DeleteStack action.
type DeleteStackInput struct {
	// The name or the unique stack ID that is associated with the stack.
	StackName *string `type:"string" required:"true"`

	metadataDeleteStackInput `json:"-" xml:"-"`
}

type metadataDeleteStackInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackInput) GoString() string {
	return s.String()
}

type DeleteStackOutput struct {
	metadataDeleteStackOutput `json:"-" xml:"-"`
}

type metadataDeleteStackOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DeleteStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteStackOutput) GoString() string {
	return s.String()
}

// The input for DescribeStackEvents action.
type DescribeStackEventsInput struct {
	// String that identifies the start of the next list of events, if there is
	// one.
	//
	// Default: There is no default value.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	StackName *string `type:"string"`

	metadataDescribeStackEventsInput `json:"-" xml:"-"`
}

type metadataDescribeStackEventsInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStackEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackEventsInput) GoString() string {
	return s.String()
}

// The output for a DescribeStackEvents action.
type DescribeStackEventsOutput struct {
	// String that identifies the start of the next list of events, if there is
	// one.
	NextToken *string `min:"1" type:"string"`

	// A list of StackEvents structures.
	StackEvents []*StackEvent `type:"list"`

	metadataDescribeStackEventsOutput `json:"-" xml:"-"`
}

type metadataDescribeStackEventsOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStackEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackEventsOutput) GoString() string {
	return s.String()
}

// The input for DescribeStackResource action.
type DescribeStackResourceInput struct {
	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	StackName *string `type:"string" required:"true"`

	metadataDescribeStackResourceInput `json:"-" xml:"-"`
}

type metadataDescribeStackResourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStackResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceInput) GoString() string {
	return s.String()
}

// The output for a DescribeStackResource action.
type DescribeStackResourceOutput struct {
	// A StackResourceDetail structure containing the description of the specified
	// resource in the specified stack.
	StackResourceDetail *StackResourceDetail `type:"structure"`

	metadataDescribeStackResourceOutput `json:"-" xml:"-"`
}

type metadataDescribeStackResourceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStackResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourceOutput) GoString() string {
	return s.String()
}

// The input for DescribeStackResources action.
type DescribeStackResourcesInput struct {
	// The logical name of the resource as specified in the template.
	//
	// Default: There is no default value.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	//
	// For example, for an Amazon Elastic Compute Cloud (EC2) instance, PhysicalResourceId
	// corresponds to the InstanceId. You can pass the EC2 InstanceId to DescribeStackResources
	// to find which stack the instance belongs to and what other resources are
	// part of the stack.
	//
	// Required: Conditional. If you do not specify PhysicalResourceId, you must
	// specify StackName.
	//
	// Default: There is no default value.
	PhysicalResourceId *string `type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	//
	// Required: Conditional. If you do not specify StackName, you must specify
	// PhysicalResourceId.
	StackName *string `type:"string"`

	metadataDescribeStackResourcesInput `json:"-" xml:"-"`
}

type metadataDescribeStackResourcesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourcesInput) GoString() string {
	return s.String()
}

// The output for a DescribeStackResources action.
type DescribeStackResourcesOutput struct {
	// A list of StackResource structures.
	StackResources []*StackResource `type:"list"`

	metadataDescribeStackResourcesOutput `json:"-" xml:"-"`
}

type metadataDescribeStackResourcesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStackResourcesOutput) GoString() string {
	return s.String()
}

// The input for DescribeStacks action.
type DescribeStacksInput struct {
	// String that identifies the start of the next list of stacks, if there is
	// one.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	StackName *string `type:"string"`

	metadataDescribeStacksInput `json:"-" xml:"-"`
}

type metadataDescribeStacksInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksInput) GoString() string {
	return s.String()
}

// The output for a DescribeStacks action.
type DescribeStacksOutput struct {
	// String that identifies the start of the next list of stacks, if there is
	// one.
	NextToken *string `min:"1" type:"string"`

	// A list of stack structures.
	Stacks []*Stack `type:"list"`

	metadataDescribeStacksOutput `json:"-" xml:"-"`
}

type metadataDescribeStacksOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s DescribeStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeStacksOutput) GoString() string {
	return s.String()
}

type EstimateTemplateCostInput struct {
	// A list of Parameter structures that specify input parameters.
	Parameters []*Parameter `type:"list"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// Conditional: You must pass TemplateBody or TemplateURL. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// located in an S3 bucket in the same region as the stack. For more information,
	// go to Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`

	metadataEstimateTemplateCostInput `json:"-" xml:"-"`
}

type metadataEstimateTemplateCostInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EstimateTemplateCostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimateTemplateCostInput) GoString() string {
	return s.String()
}

// The output for a EstimateTemplateCost action.
type EstimateTemplateCostOutput struct {
	// An AWS Simple Monthly Calculator URL with a query string that describes the
	// resources required to run the template.
	Url *string `type:"string"`

	metadataEstimateTemplateCostOutput `json:"-" xml:"-"`
}

type metadataEstimateTemplateCostOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s EstimateTemplateCostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EstimateTemplateCostOutput) GoString() string {
	return s.String()
}

// The input for the GetStackPolicy action.
type GetStackPolicyInput struct {
	// The name or unique stack ID that is associated with the stack whose policy
	// you want to get.
	StackName *string `type:"string" required:"true"`

	metadataGetStackPolicyInput `json:"-" xml:"-"`
}

type metadataGetStackPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStackPolicyInput) GoString() string {
	return s.String()
}

// The output for the GetStackPolicy action.
type GetStackPolicyOutput struct {
	// Structure containing the stack policy body. (For more information, go to
	//  Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide.)
	StackPolicyBody *string `min:"1" type:"string"`

	metadataGetStackPolicyOutput `json:"-" xml:"-"`
}

type metadataGetStackPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetStackPolicyOutput) GoString() string {
	return s.String()
}

// The input for a GetTemplate action.
type GetTemplateInput struct {
	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	StackName *string `type:"string" required:"true"`

	metadataGetTemplateInput `json:"-" xml:"-"`
}

type metadataGetTemplateInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateInput) GoString() string {
	return s.String()
}

// The output for GetTemplate action.
type GetTemplateOutput struct {
	// Structure containing the template body. (For more information, go to Template
	// Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	TemplateBody *string `min:"1" type:"string"`

	metadataGetTemplateOutput `json:"-" xml:"-"`
}

type metadataGetTemplateOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateOutput) GoString() string {
	return s.String()
}

// The input for the GetTemplateSummary action.
type GetTemplateSummaryInput struct {
	// The name or the stack ID that is associated with the stack, which are not
	// always interchangeable. For running stacks, you can specify either the stack's
	// name or its unique stack ID. For deleted stack, you must specify the unique
	// stack ID.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// TemplateBody, or TemplateURL.
	StackName *string `min:"1" type:"string"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information about templates, see
	// Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// TemplateBody, or TemplateURL.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) located in an Amazon S3 bucket. For more information
	// about templates, see Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify only one of the following parameters: StackName,
	// TemplateBody, or TemplateURL.
	TemplateURL *string `min:"1" type:"string"`

	metadataGetTemplateSummaryInput `json:"-" xml:"-"`
}

type metadataGetTemplateSummaryInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetTemplateSummaryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateSummaryInput) GoString() string {
	return s.String()
}

// The output for the GetTemplateSummary action.
type GetTemplateSummaryOutput struct {
	// The capabilities found within the template. Currently, AWS CloudFormation
	// supports only the CAPABILITY_IAM capability. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM value for this parameter when
	// you use the CreateStack or UpdateStack actions with your template; otherwise,
	// those actions return an InsufficientCapabilities error.
	Capabilities []*string `type:"list"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// The value that is defined in the Description property of the template.
	Description *string `type:"string"`

	// The value that is defined for the Metadata property of the template.
	Metadata *string `type:"string"`

	// A list of parameter declarations that describe various properties for each
	// parameter.
	Parameters []*ParameterDeclaration `type:"list"`

	// The AWS template format version, which identifies the capabilities of the
	// template.
	Version *string `type:"string"`

	metadataGetTemplateSummaryOutput `json:"-" xml:"-"`
}

type metadataGetTemplateSummaryOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s GetTemplateSummaryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetTemplateSummaryOutput) GoString() string {
	return s.String()
}

// The input for the ListStackResource action.
type ListStackResourcesInput struct {
	// String that identifies the start of the next list of stack resource summaries,
	// if there is one.
	//
	// Default: There is no default value.
	NextToken *string `min:"1" type:"string"`

	// The name or the unique stack ID that is associated with the stack, which
	// are not always interchangeable:
	//
	//  Running stacks: You can specify either the stack's name or its unique stack
	// ID. Deleted stacks: You must specify the unique stack ID.  Default: There
	// is no default value.
	StackName *string `type:"string" required:"true"`

	metadataListStackResourcesInput `json:"-" xml:"-"`
}

type metadataListStackResourcesInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListStackResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackResourcesInput) GoString() string {
	return s.String()
}

// The output for a ListStackResources action.
type ListStackResourcesOutput struct {
	// String that identifies the start of the next list of stack resources, if
	// there is one.
	NextToken *string `min:"1" type:"string"`

	// A list of StackResourceSummary structures.
	StackResourceSummaries []*StackResourceSummary `type:"list"`

	metadataListStackResourcesOutput `json:"-" xml:"-"`
}

type metadataListStackResourcesOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListStackResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStackResourcesOutput) GoString() string {
	return s.String()
}

// The input for ListStacks action.
type ListStacksInput struct {
	// String that identifies the start of the next list of stacks, if there is
	// one.
	//
	// Default: There is no default value.
	NextToken *string `min:"1" type:"string"`

	// Stack status to use as a filter. Specify one or more stack status codes to
	// list only stacks with the specified status codes. For a complete list of
	// stack status codes, see the StackStatus parameter of the Stack data type.
	StackStatusFilter []*string `type:"list"`

	metadataListStacksInput `json:"-" xml:"-"`
}

type metadataListStacksInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListStacksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStacksInput) GoString() string {
	return s.String()
}

// The output for ListStacks action.
type ListStacksOutput struct {
	// String that identifies the start of the next list of stacks, if there is
	// one.
	NextToken *string `min:"1" type:"string"`

	// A list of StackSummary structures containing information about the specified
	// stacks.
	StackSummaries []*StackSummary `type:"list"`

	metadataListStacksOutput `json:"-" xml:"-"`
}

type metadataListStacksOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ListStacksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListStacksOutput) GoString() string {
	return s.String()
}

// The Output data type.
type Output struct {
	// User defined description associated with the output.
	Description *string `type:"string"`

	// The key associated with the output.
	OutputKey *string `type:"string"`

	// The value associated with the output.
	OutputValue *string `type:"string"`

	metadataOutput `json:"-" xml:"-"`
}

type metadataOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Output) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Output) GoString() string {
	return s.String()
}

// The Parameter data type.
type Parameter struct {
	// The key associated with the parameter. If you don't specify a key and value
	// for a particular parameter, AWS CloudFormation uses the default value that
	// is specified in your template.
	ParameterKey *string `type:"string"`

	// The value associated with the parameter.
	ParameterValue *string `type:"string"`

	// During a stack update, use the existing parameter value that the stack is
	// using for a given parameter key. If you specify true, do not specify a parameter
	// value.
	UsePreviousValue *bool `type:"boolean"`

	metadataParameter `json:"-" xml:"-"`
}

type metadataParameter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Parameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Parameter) GoString() string {
	return s.String()
}

// A set of criteria that AWS CloudFormation uses to validate parameter values.
// Although other constraints might be defined in the stack template, AWS CloudFormation
// returns only the AllowedValues property.
type ParameterConstraints struct {
	// A list of values that are permitted for a parameter.
	AllowedValues []*string `type:"list"`

	metadataParameterConstraints `json:"-" xml:"-"`
}

type metadataParameterConstraints struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ParameterConstraints) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterConstraints) GoString() string {
	return s.String()
}

// The ParameterDeclaration data type.
type ParameterDeclaration struct {
	// The default value of the parameter.
	DefaultValue *string `type:"string"`

	// The description that is associate with the parameter.
	Description *string `type:"string"`

	// Flag that indicates whether the parameter value is shown as plain text in
	// logs and in the AWS Management Console.
	NoEcho *bool `type:"boolean"`

	// The criteria that AWS CloudFormation uses to validate parameter values.
	ParameterConstraints *ParameterConstraints `type:"structure"`

	// The name that is associated with the parameter.
	ParameterKey *string `type:"string"`

	// The type of parameter.
	ParameterType *string `type:"string"`

	metadataParameterDeclaration `json:"-" xml:"-"`
}

type metadataParameterDeclaration struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ParameterDeclaration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ParameterDeclaration) GoString() string {
	return s.String()
}

// The input for the SetStackPolicy action.
type SetStackPolicyInput struct {
	// The name or unique stack ID that you want to associate a policy with.
	StackName *string `type:"string" required:"true"`

	// Structure containing the stack policy body. For more information, go to
	// Prevent Updates to Stack Resources (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/protect-stack-resources.html)
	// in the AWS CloudFormation User Guide. You can specify either the StackPolicyBody
	// or the StackPolicyURL parameter, but not both.
	StackPolicyBody *string `min:"1" type:"string"`

	// Location of a file containing the stack policy. The URL must point to a policy
	// (max size: 16KB) located in an S3 bucket in the same region as the stack.
	// You can specify either the StackPolicyBody or the StackPolicyURL parameter,
	// but not both.
	StackPolicyURL *string `min:"1" type:"string"`

	metadataSetStackPolicyInput `json:"-" xml:"-"`
}

type metadataSetStackPolicyInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetStackPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStackPolicyInput) GoString() string {
	return s.String()
}

type SetStackPolicyOutput struct {
	metadataSetStackPolicyOutput `json:"-" xml:"-"`
}

type metadataSetStackPolicyOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SetStackPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SetStackPolicyOutput) GoString() string {
	return s.String()
}

// The input for the SignalResource action.
type SignalResourceInput struct {
	// The logical ID of the resource that you want to signal. The logical ID is
	// the name of the resource that given in the template.
	LogicalResourceId *string `type:"string" required:"true"`

	// The stack name or unique stack ID that includes the resource that you want
	// to signal.
	StackName *string `min:"1" type:"string" required:"true"`

	// The status of the signal, which is either success or failure. A failure signal
	// causes AWS CloudFormation to immediately fail the stack creation or update.
	Status *string `type:"string" required:"true" enum:"ResourceSignalStatus"`

	// A unique ID of the signal. When you signal Amazon EC2 instances or Auto Scaling
	// groups, specify the instance ID that you are signaling as the unique ID.
	// If you send multiple signals to a single resource (such as signaling a wait
	// condition), each signal requires a different unique ID.
	UniqueId *string `min:"1" type:"string" required:"true"`

	metadataSignalResourceInput `json:"-" xml:"-"`
}

type metadataSignalResourceInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SignalResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalResourceInput) GoString() string {
	return s.String()
}

type SignalResourceOutput struct {
	metadataSignalResourceOutput `json:"-" xml:"-"`
}

type metadataSignalResourceOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s SignalResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SignalResourceOutput) GoString() string {
	return s.String()
}

// The Stack data type.
type Stack struct {
	// The capabilities allowed in the stack.
	Capabilities []*string `type:"list"`

	// Time at which the stack was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// User defined description associated with the stack.
	Description *string `type:"string"`

	// Boolean to enable or disable rollback on stack creation failures:
	//
	//    true: disable rollback  false: enable rollback
	DisableRollback *bool `type:"boolean"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// SNS topic ARNs to which stack related events are published.
	NotificationARNs []*string `type:"list"`

	// A list of output structures.
	Outputs []*Output `type:"list"`

	// A list of Parameter structures.
	Parameters []*Parameter `type:"list"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string" required:"true"`

	// Current status of the stack.
	StackStatus *string `type:"string" required:"true" enum:"StackStatus"`

	// Success/failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// A list of Tags that specify cost allocation information for the stack.
	Tags []*Tag `type:"list"`

	// The amount of time within which stack creation should complete.
	TimeoutInMinutes *int64 `min:"1" type:"integer"`

	metadataStack `json:"-" xml:"-"`
}

type metadataStack struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Stack) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Stack) GoString() string {
	return s.String()
}

// The StackEvent data type.
type StackEvent struct {
	// The unique ID of this event.
	EventId *string `type:"string" required:"true"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string"`

	// The name or unique identifier associated with the physical instance of the
	// resource.
	PhysicalResourceId *string `type:"string"`

	// BLOB of the properties used to create the resource.
	ResourceProperties *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `type:"string"`

	// The unique ID name of the instance of the stack.
	StackId *string `type:"string" required:"true"`

	// The name associated with a stack.
	StackName *string `type:"string" required:"true"`

	// Time the status was updated.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	metadataStackEvent `json:"-" xml:"-"`
}

type metadataStackEvent struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StackEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackEvent) GoString() string {
	return s.String()
}

// The StackResource data type.
type StackResource struct {
	// User defined description associated with the resource.
	Description *string `type:"string"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`

	// Time the status was updated.
	Timestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	metadataStackResource `json:"-" xml:"-"`
}

type metadataStackResource struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StackResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResource) GoString() string {
	return s.String()
}

// Contains detailed information about the specified stack resource.
type StackResourceDetail struct {
	// User defined description associated with the resource.
	Description *string `type:"string"`

	// Time the status was updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string" required:"true"`

	// The JSON format content of the Metadata attribute declared for the resource.
	// For more information, see Metadata Attribute (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-metadata.html)
	// in the AWS CloudFormation User Guide.
	Metadata *string `type:"string"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of a resource supported by AWS CloudFormation.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. ((For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `type:"string" required:"true"`

	// Unique identifier of the stack.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string"`

	metadataStackResourceDetail `json:"-" xml:"-"`
}

type metadataStackResourceDetail struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StackResourceDetail) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceDetail) GoString() string {
	return s.String()
}

// Contains high-level information about the specified stack resource.
type StackResourceSummary struct {
	// Time the status was updated.
	LastUpdatedTimestamp *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The logical name of the resource specified in the template.
	LogicalResourceId *string `type:"string" required:"true"`

	// The name or unique identifier that corresponds to a physical instance ID
	// of the resource.
	PhysicalResourceId *string `type:"string"`

	// Current status of the resource.
	ResourceStatus *string `type:"string" required:"true" enum:"ResourceStatus"`

	// Success/failure message associated with the resource.
	ResourceStatusReason *string `type:"string"`

	// Type of resource. (For more information, go to  AWS Resource Types Reference
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
	// in the AWS CloudFormation User Guide.)
	ResourceType *string `type:"string" required:"true"`

	metadataStackResourceSummary `json:"-" xml:"-"`
}

type metadataStackResourceSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StackResourceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackResourceSummary) GoString() string {
	return s.String()
}

// The StackSummary Data Type
type StackSummary struct {
	// The time the stack was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"iso8601" required:"true"`

	// The time the stack was deleted.
	DeletionTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The time the stack was last updated. This field will only be returned if
	// the stack has been updated at least once.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// Unique stack identifier.
	StackId *string `type:"string"`

	// The name associated with the stack.
	StackName *string `type:"string" required:"true"`

	// The current status of the stack.
	StackStatus *string `type:"string" required:"true" enum:"StackStatus"`

	// Success/Failure message associated with the stack status.
	StackStatusReason *string `type:"string"`

	// The template description of the template used to create the stack.
	TemplateDescription *string `type:"string"`

	metadataStackSummary `json:"-" xml:"-"`
}

type metadataStackSummary struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s StackSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StackSummary) GoString() string {
	return s.String()
}

// The Tag type is used by CreateStack in the Tags parameter. It allows you
// to specify a key/value pair that can be used to store information related
// to cost allocation for an AWS CloudFormation stack.
type Tag struct {
	// Required. A string used to identify this tag. You can specify a maximum of
	// 128 characters for a tag key. Tags owned by Amazon Web Services (AWS) have
	// the reserved prefix: aws:.
	Key *string `type:"string"`

	// Required. A string containing the value for this tag. You can specify a maximum
	// of 256 characters for a tag value.
	Value *string `type:"string"`

	metadataTag `json:"-" xml:"-"`
}

type metadataTag struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// The TemplateParameter data type.
type TemplateParameter struct {
	// The default value associated with the parameter.
	DefaultValue *string `type:"string"`

	// User defined description associated with the parameter.
	Description *string `type:"string"`

	// Flag indicating whether the parameter should be displayed as plain text in
	// logs and UIs.
	NoEcho *bool `type:"boolean"`

	// The name associated with the parameter.
	ParameterKey *string `type:"string"`

	metadataTemplateParameter `json:"-" xml:"-"`
}

type metadataTemplateParameter struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s TemplateParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TemplateParameter) GoString() string {
	return s.String()
}

// The input for UpdateStack action.
type UpdateStackInput struct {
	// A list of capabilities that you must specify before AWS CloudFormation can
	// create or update certain stacks. Some stack templates might include resources
	// that can affect permissions in your AWS account. For those stacks, you must
	// explicitly acknowledge their capabilities by specifying this parameter. Currently,
	// the only valid value is CAPABILITY_IAM, which is required for the following
	// resources:  AWS::IAM::AccessKey (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-accesskey.html),
	//  AWS::IAM::Group (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-group.html),
	//  AWS::IAM::InstanceProfile (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-instanceprofile.html),
	//  AWS::IAM::Policy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-policy.html),
	//  AWS::IAM::Role (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iam-role.html),
	//  AWS::IAM::User (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-user.html),
	// and  AWS::IAM::UserToGroupAddition (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iam-addusertogroup.html).
	// If your stack template contains these resources, we recommend that you review
	// any permissions associated with them. If you don't specify this parameter,
	// this action returns an InsufficientCapabilities error.
	Capabilities []*string `type:"list"`

	// Update the ARNs for the Amazon SNS topics that are associated with the stack.
	NotificationARNs []*string `type:"list"`

	// A list of Parameter structures that specify input parameters for the stack.
	// For more information, see the Parameter (http://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_Parameter.html)
	// data type.
	Parameters []*Parameter `type:"list"`

	// The name or unique stack ID of the stack to update.
	StackName *string `type:"string" required:"true"`

	// Structure containing a new stack policy body. You can specify either the
	// StackPolicyBody or the StackPolicyURL parameter, but not both.
	//
	// You might update the stack policy, for example, in order to protect a new
	// resource that you created during a stack update. If you do not specify a
	// stack policy, the current policy that is associated with the stack is unchanged.
	StackPolicyBody *string `min:"1" type:"string"`

	// Structure containing the temporary overriding stack policy body. You can
	// specify either the StackPolicyDuringUpdateBody or the StackPolicyDuringUpdateURL
	// parameter, but not both.
	//
	// If you want to update protected resources, specify a temporary overriding
	// stack policy during this update. If you do not specify a stack policy, the
	// current policy that is associated with the stack will be used.
	StackPolicyDuringUpdateBody *string `min:"1" type:"string"`

	// Location of a file containing the temporary overriding stack policy. The
	// URL must point to a policy (max size: 16KB) located in an S3 bucket in the
	// same region as the stack. You can specify either the StackPolicyDuringUpdateBody
	// or the StackPolicyDuringUpdateURL parameter, but not both.
	//
	// If you want to update protected resources, specify a temporary overriding
	// stack policy during this update. If you do not specify a stack policy, the
	// current policy that is associated with the stack will be used.
	StackPolicyDuringUpdateURL *string `min:"1" type:"string"`

	// Location of a file containing the updated stack policy. The URL must point
	// to a policy (max size: 16KB) located in an S3 bucket in the same region as
	// the stack. You can specify either the StackPolicyBody or the StackPolicyURL
	// parameter, but not both.
	//
	// You might update the stack policy, for example, in order to protect a new
	// resource that you created during a stack update. If you do not specify a
	// stack policy, the current policy that is associated with the stack is unchanged.
	StackPolicyURL *string `min:"1" type:"string"`

	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. (For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.)
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// located in an S3 bucket in the same region as the stack. For more information,
	// go to Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must specify either the TemplateBody or the TemplateURL
	// parameter, but not both.
	TemplateURL *string `min:"1" type:"string"`

	// Reuse the existing template that is associated with the stack that you are
	// updating.
	UsePreviousTemplate *bool `type:"boolean"`

	metadataUpdateStackInput `json:"-" xml:"-"`
}

type metadataUpdateStackInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateStackInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackInput) GoString() string {
	return s.String()
}

// The output for a UpdateStack action.
type UpdateStackOutput struct {
	// Unique identifier of the stack.
	StackId *string `type:"string"`

	metadataUpdateStackOutput `json:"-" xml:"-"`
}

type metadataUpdateStackOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s UpdateStackOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateStackOutput) GoString() string {
	return s.String()
}

// The input for ValidateTemplate action.
type ValidateTemplateInput struct {
	// Structure containing the template body with a minimum length of 1 byte and
	// a maximum length of 51,200 bytes. For more information, go to Template Anatomy
	// (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateBody *string `min:"1" type:"string"`

	// Location of file containing the template body. The URL must point to a template
	// (max size: 460,800 bytes) located in an S3 bucket in the same region as the
	// stack. For more information, go to Template Anatomy (http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/template-anatomy.html)
	// in the AWS CloudFormation User Guide.
	//
	// Conditional: You must pass TemplateURL or TemplateBody. If both are passed,
	// only TemplateBody is used.
	TemplateURL *string `min:"1" type:"string"`

	metadataValidateTemplateInput `json:"-" xml:"-"`
}

type metadataValidateTemplateInput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ValidateTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateTemplateInput) GoString() string {
	return s.String()
}

// The output for ValidateTemplate action.
type ValidateTemplateOutput struct {
	// The capabilities found within the template. Currently, AWS CloudFormation
	// supports only the CAPABILITY_IAM capability. If your template contains IAM
	// resources, you must specify the CAPABILITY_IAM value for this parameter when
	// you use the CreateStack or UpdateStack actions with your template; otherwise,
	// those actions return an InsufficientCapabilities error.
	Capabilities []*string `type:"list"`

	// The list of resources that generated the values in the Capabilities response
	// element.
	CapabilitiesReason *string `type:"string"`

	// The description found within the template.
	Description *string `type:"string"`

	// A list of TemplateParameter structures.
	Parameters []*TemplateParameter `type:"list"`

	metadataValidateTemplateOutput `json:"-" xml:"-"`
}

type metadataValidateTemplateOutput struct {
	SDKShapeTraits bool `type:"structure"`
}

// String returns the string representation
func (s ValidateTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidateTemplateOutput) GoString() string {
	return s.String()
}

const (
	// @enum Capability
	CapabilityCapabilityIam = "CAPABILITY_IAM"
)

const (
	// @enum OnFailure
	OnFailureDoNothing = "DO_NOTHING"
	// @enum OnFailure
	OnFailureRollback = "ROLLBACK"
	// @enum OnFailure
	OnFailureDelete = "DELETE"
)

const (
	// @enum ResourceSignalStatus
	ResourceSignalStatusSuccess = "SUCCESS"
	// @enum ResourceSignalStatus
	ResourceSignalStatusFailure = "FAILURE"
)

const (
	// @enum ResourceStatus
	ResourceStatusCreateInProgress = "CREATE_IN_PROGRESS"
	// @enum ResourceStatus
	ResourceStatusCreateFailed = "CREATE_FAILED"
	// @enum ResourceStatus
	ResourceStatusCreateComplete = "CREATE_COMPLETE"
	// @enum ResourceStatus
	ResourceStatusDeleteInProgress = "DELETE_IN_PROGRESS"
	// @enum ResourceStatus
	ResourceStatusDeleteFailed = "DELETE_FAILED"
	// @enum ResourceStatus
	ResourceStatusDeleteComplete = "DELETE_COMPLETE"
	// @enum ResourceStatus
	ResourceStatusDeleteSkipped = "DELETE_SKIPPED"
	// @enum ResourceStatus
	ResourceStatusUpdateInProgress = "UPDATE_IN_PROGRESS"
	// @enum ResourceStatus
	ResourceStatusUpdateFailed = "UPDATE_FAILED"
	// @enum ResourceStatus
	ResourceStatusUpdateComplete = "UPDATE_COMPLETE"
)

const (
	// @enum StackStatus
	StackStatusCreateInProgress = "CREATE_IN_PROGRESS"
	// @enum StackStatus
	StackStatusCreateFailed = "CREATE_FAILED"
	// @enum StackStatus
	StackStatusCreateComplete = "CREATE_COMPLETE"
	// @enum StackStatus
	StackStatusRollbackInProgress = "ROLLBACK_IN_PROGRESS"
	// @enum StackStatus
	StackStatusRollbackFailed = "ROLLBACK_FAILED"
	// @enum StackStatus
	StackStatusRollbackComplete = "ROLLBACK_COMPLETE"
	// @enum StackStatus
	StackStatusDeleteInProgress = "DELETE_IN_PROGRESS"
	// @enum StackStatus
	StackStatusDeleteFailed = "DELETE_FAILED"
	// @enum StackStatus
	StackStatusDeleteComplete = "DELETE_COMPLETE"
	// @enum StackStatus
	StackStatusUpdateInProgress = "UPDATE_IN_PROGRESS"
	// @enum StackStatus
	StackStatusUpdateCompleteCleanupInProgress = "UPDATE_COMPLETE_CLEANUP_IN_PROGRESS"
	// @enum StackStatus
	StackStatusUpdateComplete = "UPDATE_COMPLETE"
	// @enum StackStatus
	StackStatusUpdateRollbackInProgress = "UPDATE_ROLLBACK_IN_PROGRESS"
	// @enum StackStatus
	StackStatusUpdateRollbackFailed = "UPDATE_ROLLBACK_FAILED"
	// @enum StackStatus
	StackStatusUpdateRollbackCompleteCleanupInProgress = "UPDATE_ROLLBACK_COMPLETE_CLEANUP_IN_PROGRESS"
	// @enum StackStatus
	StackStatusUpdateRollbackComplete = "UPDATE_ROLLBACK_COMPLETE"
)
