// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns history for a Security Hub finding in the last 90 days. The history
// includes changes made to any fields in the Amazon Web Services Security Finding
// Format (ASFF).
func (c *Client) GetFindingHistory(ctx context.Context, params *GetFindingHistoryInput, optFns ...func(*Options)) (*GetFindingHistoryOutput, error) {
	if params == nil {
		params = &GetFindingHistoryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFindingHistory", params, optFns, c.addOperationGetFindingHistoryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFindingHistoryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFindingHistoryInput struct {

	// Identifies which finding to get the finding history for.
	//
	// This member is required.
	FindingIdentifier *types.AwsSecurityFindingIdentifier

	// An ISO 8601-formatted timestamp that indicates the end time of the requested
	// finding history. A correctly formatted example is 2020-05-21T20:16:34.724Z . The
	// value cannot contain spaces, and date and time should be separated by T . For
	// more information, see RFC 3339 section 5.6, Internet Date/Time Format (https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
	// . If you provide values for both StartTime and EndTime , Security Hub returns
	// finding history for the specified time period. If you provide a value for
	// StartTime but not for EndTime , Security Hub returns finding history from the
	// StartTime to the time at which the API is called. If you provide a value for
	// EndTime but not for StartTime , Security Hub returns finding history from the
	// CreatedAt (https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt)
	// timestamp of the finding to the EndTime . If you provide neither StartTime nor
	// EndTime , Security Hub returns finding history from the CreatedAt timestamp of
	// the finding to the time at which the API is called. In all of these scenarios,
	// the response is limited to 100 results, and the maximum time period is limited
	// to 90 days.
	EndTime *time.Time

	// The maximum number of results to be returned. If you don’t provide it, Security
	// Hub returns up to 100 results of finding history.
	MaxResults *int32

	// A token for pagination purposes. Provide NULL as the initial value. In
	// subsequent requests, provide the token included in the response to get up to an
	// additional 100 results of finding history. If you don’t provide NextToken ,
	// Security Hub returns up to 100 results of finding history for each request.
	NextToken *string

	// An ISO 8601-formatted timestamp that indicates the start time of the requested
	// finding history. A correctly formatted example is 2020-05-21T20:16:34.724Z . The
	// value cannot contain spaces, and date and time should be separated by T . For
	// more information, see RFC 3339 section 5.6, Internet Date/Time Format (https://www.rfc-editor.org/rfc/rfc3339#section-5.6)
	// . If you provide values for both StartTime and EndTime , Security Hub returns
	// finding history for the specified time period. If you provide a value for
	// StartTime but not for EndTime , Security Hub returns finding history from the
	// StartTime to the time at which the API is called. If you provide a value for
	// EndTime but not for StartTime , Security Hub returns finding history from the
	// CreatedAt (https://docs.aws.amazon.com/securityhub/1.0/APIReference/API_AwsSecurityFindingFilters.html#securityhub-Type-AwsSecurityFindingFilters-CreatedAt)
	// timestamp of the finding to the EndTime . If you provide neither StartTime nor
	// EndTime , Security Hub returns finding history from the CreatedAt timestamp of
	// the finding to the time at which the API is called. In all of these scenarios,
	// the response is limited to 100 results, and the maximum time period is limited
	// to 90 days.
	StartTime *time.Time

	noSmithyDocumentSerde
}

type GetFindingHistoryOutput struct {

	// A token for pagination purposes. Provide this token in the subsequent request
	// to GetFindingsHistory to get up to an additional 100 results of history for the
	// same finding that you specified in your initial request.
	NextToken *string

	// A list of events that altered the specified finding during the specified time
	// period.
	Records []types.FindingHistoryRecord

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFindingHistoryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFindingHistory{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFindingHistory{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFindingHistory"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetFindingHistoryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFindingHistory(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// GetFindingHistoryAPIClient is a client that implements the GetFindingHistory
// operation.
type GetFindingHistoryAPIClient interface {
	GetFindingHistory(context.Context, *GetFindingHistoryInput, ...func(*Options)) (*GetFindingHistoryOutput, error)
}

var _ GetFindingHistoryAPIClient = (*Client)(nil)

// GetFindingHistoryPaginatorOptions is the paginator options for GetFindingHistory
type GetFindingHistoryPaginatorOptions struct {
	// The maximum number of results to be returned. If you don’t provide it, Security
	// Hub returns up to 100 results of finding history.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetFindingHistoryPaginator is a paginator for GetFindingHistory
type GetFindingHistoryPaginator struct {
	options   GetFindingHistoryPaginatorOptions
	client    GetFindingHistoryAPIClient
	params    *GetFindingHistoryInput
	nextToken *string
	firstPage bool
}

// NewGetFindingHistoryPaginator returns a new GetFindingHistoryPaginator
func NewGetFindingHistoryPaginator(client GetFindingHistoryAPIClient, params *GetFindingHistoryInput, optFns ...func(*GetFindingHistoryPaginatorOptions)) *GetFindingHistoryPaginator {
	if params == nil {
		params = &GetFindingHistoryInput{}
	}

	options := GetFindingHistoryPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetFindingHistoryPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetFindingHistoryPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetFindingHistory page.
func (p *GetFindingHistoryPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetFindingHistoryOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetFindingHistory(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetFindingHistory(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFindingHistory",
	}
}
