// Code generated by smithy-go-codegen DO NOT EDIT.

package qbusiness

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/document"
	internaldocument "github.com/aws/aws-sdk-go-v2/service/qbusiness/internal/document"
	"github.com/aws/aws-sdk-go-v2/service/qbusiness/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpBatchDeleteDocument struct {
}

func (*awsRestjson1_serializeOpBatchDeleteDocument) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDeleteDocument) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDeleteDocumentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/documents/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchDeleteDocumentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDeleteDocumentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDeleteDocumentInput(v *BatchDeleteDocumentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDeleteDocumentInput(v *BatchDeleteDocumentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceSyncId != nil {
		ok := object.Key("dataSourceSyncId")
		ok.String(*v.DataSourceSyncId)
	}

	if v.Documents != nil {
		ok := object.Key("documents")
		if err := awsRestjson1_serializeDocumentDeleteDocuments(v.Documents, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchPutDocument struct {
}

func (*awsRestjson1_serializeOpBatchPutDocument) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchPutDocument) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchPutDocumentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/documents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchPutDocumentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchPutDocumentInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchPutDocumentInput(v *BatchPutDocumentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchPutDocumentInput(v *BatchPutDocumentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceSyncId != nil {
		ok := object.Key("dataSourceSyncId")
		ok.String(*v.DataSourceSyncId)
	}

	if v.Documents != nil {
		ok := object.Key("documents")
		if err := awsRestjson1_serializeDocumentDocuments(v.Documents, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpChatSync struct {
}

func (*awsRestjson1_serializeOpChatSync) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpChatSync) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ChatSyncInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations?sync")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsChatSyncInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentChatSyncInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsChatSyncInput(v *ChatSyncInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.UserGroups != nil {
		for i := range v.UserGroups {
			encoder.AddQuery("userGroups").String(v.UserGroups[i])
		}
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentChatSyncInput(v *ChatSyncInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionExecution != nil {
		ok := object.Key("actionExecution")
		if err := awsRestjson1_serializeDocumentActionExecution(v.ActionExecution, ok); err != nil {
			return err
		}
	}

	if v.Attachments != nil {
		ok := object.Key("attachments")
		if err := awsRestjson1_serializeDocumentAttachmentsInput(v.Attachments, ok); err != nil {
			return err
		}
	}

	if v.AttributeFilter != nil {
		ok := object.Key("attributeFilter")
		if err := awsRestjson1_serializeDocumentAttributeFilter(v.AttributeFilter, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.ConversationId != nil {
		ok := object.Key("conversationId")
		ok.String(*v.ConversationId)
	}

	if v.ParentMessageId != nil {
		ok := object.Key("parentMessageId")
		ok.String(*v.ParentMessageId)
	}

	if v.UserMessage != nil {
		ok := object.Key("userMessage")
		ok.String(*v.UserMessage)
	}

	return nil
}

type awsRestjson1_serializeOpCreateApplication struct {
}

func (*awsRestjson1_serializeOpCreateApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateApplicationInput(v *CreateApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateApplicationInput(v *CreateApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachmentsConfiguration != nil {
		ok := object.Key("attachmentsConfiguration")
		if err := awsRestjson1_serializeDocumentAttachmentsConfiguration(v.AttachmentsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("encryptionConfiguration")
		if err := awsRestjson1_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDataSource struct {
}

func (*awsRestjson1_serializeOpCreateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDataSourceInput(v *CreateDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDataSourceInput(v *CreateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentDataSourceConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.DocumentEnrichmentConfiguration != nil {
		ok := object.Key("documentEnrichmentConfiguration")
		if err := awsRestjson1_serializeDocumentDocumentEnrichmentConfiguration(v.DocumentEnrichmentConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SyncSchedule != nil {
		ok := object.Key("syncSchedule")
		ok.String(*v.SyncSchedule)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("vpcConfiguration")
		if err := awsRestjson1_serializeDocumentDataSourceVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateIndex struct {
}

func (*awsRestjson1_serializeOpCreateIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIndexInput(v *CreateIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIndexInput(v *CreateIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityConfiguration != nil {
		ok := object.Key("capacityConfiguration")
		if err := awsRestjson1_serializeDocumentIndexCapacityConfiguration(v.CapacityConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreatePlugin struct {
}

func (*awsRestjson1_serializeOpCreatePlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreatePlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreatePluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreatePluginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreatePluginInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreatePluginInput(v *CreatePluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreatePluginInput(v *CreatePluginInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthConfiguration != nil {
		ok := object.Key("authConfiguration")
		if err := awsRestjson1_serializeDocumentPluginAuthConfiguration(v.AuthConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.ServerUrl != nil {
		ok := object.Key("serverUrl")
		ok.String(*v.ServerUrl)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateRetriever struct {
}

func (*awsRestjson1_serializeOpCreateRetriever) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateRetriever) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRetrieverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/retrievers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateRetrieverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateRetrieverInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateRetrieverInput(v *CreateRetrieverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateRetrieverInput(v *CreateRetrieverInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentRetrieverConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpCreateUser struct {
}

func (*awsRestjson1_serializeOpCreateUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/users")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateUserInput(v *CreateUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateUserInput(v *CreateUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if v.UserAliases != nil {
		ok := object.Key("userAliases")
		if err := awsRestjson1_serializeDocumentUserAliases(v.UserAliases, ok); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		ok := object.Key("userId")
		ok.String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpCreateWebExperience struct {
}

func (*awsRestjson1_serializeOpCreateWebExperience) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWebExperience) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWebExperienceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateWebExperienceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWebExperienceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWebExperienceInput(v *CreateWebExperienceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWebExperienceInput(v *CreateWebExperienceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if len(v.SamplePromptsControlMode) > 0 {
		ok := object.Key("samplePromptsControlMode")
		ok.String(string(v.SamplePromptsControlMode))
	}

	if v.Subtitle != nil {
		ok := object.Key("subtitle")
		ok.String(*v.Subtitle)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	if v.WelcomeMessage != nil {
		ok := object.Key("welcomeMessage")
		ok.String(*v.WelcomeMessage)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteApplication struct {
}

func (*awsRestjson1_serializeOpDeleteApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteApplicationInput(v *DeleteApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteChatControlsConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteChatControlsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteChatControlsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteChatControlsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatcontrols")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteChatControlsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteChatControlsConfigurationInput(v *DeleteChatControlsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConversation struct {
}

func (*awsRestjson1_serializeOpDeleteConversation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConversation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConversationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations/{conversationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConversationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConversationInput(v *DeleteConversationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ConversationId == nil || len(*v.ConversationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member conversationId must not be empty")}
	}
	if v.ConversationId != nil {
		if err := encoder.SetURI("conversationId").String(*v.ConversationId); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDataSource struct {
}

func (*awsRestjson1_serializeOpDeleteDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDataSourceInput(v *DeleteDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteGroup struct {
}

func (*awsRestjson1_serializeOpDeleteGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/groups/{groupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteGroupInput(v *DeleteGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		encoder.SetQuery("dataSourceId").String(*v.DataSourceId)
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member groupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("groupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteIndex struct {
}

func (*awsRestjson1_serializeOpDeleteIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteIndexInput(v *DeleteIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeletePlugin struct {
}

func (*awsRestjson1_serializeOpDeletePlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeletePlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins/{pluginId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeletePluginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeletePluginInput(v *DeletePluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PluginId == nil || len(*v.PluginId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pluginId must not be empty")}
	}
	if v.PluginId != nil {
		if err := encoder.SetURI("pluginId").String(*v.PluginId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteRetriever struct {
}

func (*awsRestjson1_serializeOpDeleteRetriever) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteRetriever) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRetrieverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/retrievers/{retrieverId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteRetrieverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteRetrieverInput(v *DeleteRetrieverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.RetrieverId == nil || len(*v.RetrieverId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member retrieverId must not be empty")}
	}
	if v.RetrieverId != nil {
		if err := encoder.SetURI("retrieverId").String(*v.RetrieverId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteUser struct {
}

func (*awsRestjson1_serializeOpDeleteUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/users/{userId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteUserInput(v *DeleteUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member userId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("userId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWebExperience struct {
}

func (*awsRestjson1_serializeOpDeleteWebExperience) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWebExperience) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWebExperienceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences/{webExperienceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWebExperienceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWebExperienceInput(v *DeleteWebExperienceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.WebExperienceId == nil || len(*v.WebExperienceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member webExperienceId must not be empty")}
	}
	if v.WebExperienceId != nil {
		if err := encoder.SetURI("webExperienceId").String(*v.WebExperienceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetApplication struct {
}

func (*awsRestjson1_serializeOpGetApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetApplicationInput(v *GetApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetChatControlsConfiguration struct {
}

func (*awsRestjson1_serializeOpGetChatControlsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetChatControlsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetChatControlsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatcontrols")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetChatControlsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetChatControlsConfigurationInput(v *GetChatControlsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetDataSource struct {
}

func (*awsRestjson1_serializeOpGetDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDataSourceInput(v *GetDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetGroup struct {
}

func (*awsRestjson1_serializeOpGetGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/groups/{groupName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetGroupInput(v *GetGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		encoder.SetQuery("dataSourceId").String(*v.DataSourceId)
	}

	if v.GroupName == nil || len(*v.GroupName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member groupName must not be empty")}
	}
	if v.GroupName != nil {
		if err := encoder.SetURI("groupName").String(*v.GroupName); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetIndex struct {
}

func (*awsRestjson1_serializeOpGetIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIndexInput(v *GetIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPlugin struct {
}

func (*awsRestjson1_serializeOpGetPlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins/{pluginId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPluginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPluginInput(v *GetPluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PluginId == nil || len(*v.PluginId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pluginId must not be empty")}
	}
	if v.PluginId != nil {
		if err := encoder.SetURI("pluginId").String(*v.PluginId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetRetriever struct {
}

func (*awsRestjson1_serializeOpGetRetriever) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetRetriever) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetRetrieverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/retrievers/{retrieverId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetRetrieverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetRetrieverInput(v *GetRetrieverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.RetrieverId == nil || len(*v.RetrieverId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member retrieverId must not be empty")}
	}
	if v.RetrieverId != nil {
		if err := encoder.SetURI("retrieverId").String(*v.RetrieverId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetUser struct {
}

func (*awsRestjson1_serializeOpGetUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/users/{userId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetUserInput(v *GetUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member userId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("userId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetWebExperience struct {
}

func (*awsRestjson1_serializeOpGetWebExperience) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetWebExperience) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWebExperienceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences/{webExperienceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetWebExperienceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetWebExperienceInput(v *GetWebExperienceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.WebExperienceId == nil || len(*v.WebExperienceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member webExperienceId must not be empty")}
	}
	if v.WebExperienceId != nil {
		if err := encoder.SetURI("webExperienceId").String(*v.WebExperienceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListApplications struct {
}

func (*awsRestjson1_serializeOpListApplications) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListApplications) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListApplicationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListApplicationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListApplicationsInput(v *ListApplicationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListConversations struct {
}

func (*awsRestjson1_serializeOpListConversations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConversations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConversationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConversationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConversationsInput(v *ListConversationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpListDataSources struct {
}

func (*awsRestjson1_serializeOpListDataSources) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataSources) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataSourcesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataSourcesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataSourcesInput(v *ListDataSourcesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListDataSourceSyncJobs struct {
}

func (*awsRestjson1_serializeOpListDataSourceSyncJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDataSourceSyncJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDataSourceSyncJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}/syncjobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDataSourceSyncJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDataSourceSyncJobsInput(v *ListDataSourceSyncJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.EndTime != nil {
		encoder.SetQuery("endTime").String(smithytime.FormatDateTime(*v.EndTime))
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.StartTime != nil {
		encoder.SetQuery("startTime").String(smithytime.FormatDateTime(*v.StartTime))
	}

	if len(v.StatusFilter) > 0 {
		encoder.SetQuery("syncStatus").String(string(v.StatusFilter))
	}

	return nil
}

type awsRestjson1_serializeOpListDocuments struct {
}

func (*awsRestjson1_serializeOpListDocuments) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDocuments) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDocumentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/index/{indexId}/documents")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDocumentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDocumentsInput(v *ListDocumentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceIds != nil {
		for i := range v.DataSourceIds {
			encoder.AddQuery("dataSourceIds").String(v.DataSourceIds[i])
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListGroups struct {
}

func (*awsRestjson1_serializeOpListGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListGroupsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListGroupsInput(v *ListGroupsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId != nil {
		encoder.SetQuery("dataSourceId").String(*v.DataSourceId)
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.UpdatedEarlierThan != nil {
		encoder.SetQuery("updatedEarlierThan").String(smithytime.FormatDateTime(*v.UpdatedEarlierThan))
	}

	return nil
}

type awsRestjson1_serializeOpListIndices struct {
}

func (*awsRestjson1_serializeOpListIndices) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIndices) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIndicesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIndicesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIndicesInput(v *ListIndicesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListMessages struct {
}

func (*awsRestjson1_serializeOpListMessages) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListMessages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMessagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations/{conversationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListMessagesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListMessagesInput(v *ListMessagesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ConversationId == nil || len(*v.ConversationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member conversationId must not be empty")}
	}
	if v.ConversationId != nil {
		if err := encoder.SetURI("conversationId").String(*v.ConversationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

type awsRestjson1_serializeOpListPlugins struct {
}

func (*awsRestjson1_serializeOpListPlugins) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListPlugins) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListPluginsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListPluginsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListPluginsInput(v *ListPluginsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListRetrievers struct {
}

func (*awsRestjson1_serializeOpListRetrievers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListRetrievers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRetrieversInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/retrievers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListRetrieversInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListRetrieversInput(v *ListRetrieversInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceARN}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceARN == nil || len(*v.ResourceARN) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceARN must not be empty")}
	}
	if v.ResourceARN != nil {
		if err := encoder.SetURI("resourceARN").String(*v.ResourceARN); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListWebExperiences struct {
}

func (*awsRestjson1_serializeOpListWebExperiences) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWebExperiences) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWebExperiencesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListWebExperiencesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWebExperiencesInput(v *ListWebExperiencesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpPutFeedback struct {
}

func (*awsRestjson1_serializeOpPutFeedback) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutFeedback) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutFeedbackInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/conversations/{conversationId}/messages/{messageId}/feedback")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutFeedbackInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutFeedbackInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutFeedbackInput(v *PutFeedbackInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.ConversationId == nil || len(*v.ConversationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member conversationId must not be empty")}
	}
	if v.ConversationId != nil {
		if err := encoder.SetURI("conversationId").String(*v.ConversationId); err != nil {
			return err
		}
	}

	if v.MessageId == nil || len(*v.MessageId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member messageId must not be empty")}
	}
	if v.MessageId != nil {
		if err := encoder.SetURI("messageId").String(*v.MessageId); err != nil {
			return err
		}
	}

	if v.UserId != nil {
		encoder.SetQuery("userId").String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutFeedbackInput(v *PutFeedbackInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MessageCopiedAt != nil {
		ok := object.Key("messageCopiedAt")
		ok.Double(smithytime.FormatEpochSeconds(*v.MessageCopiedAt))
	}

	if v.MessageUsefulness != nil {
		ok := object.Key("messageUsefulness")
		if err := awsRestjson1_serializeDocumentMessageUsefulnessFeedback(v.MessageUsefulness, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutGroup struct {
}

func (*awsRestjson1_serializeOpPutGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/groups")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutGroupInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutGroupInput(v *PutGroupInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutGroupInput(v *PutGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceId != nil {
		ok := object.Key("dataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.GroupMembers != nil {
		ok := object.Key("groupMembers")
		if err := awsRestjson1_serializeDocumentGroupMembers(v.GroupMembers, ok); err != nil {
			return err
		}
	}

	if v.GroupName != nil {
		ok := object.Key("groupName")
		ok.String(*v.GroupName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

type awsRestjson1_serializeOpStartDataSourceSyncJob struct {
}

func (*awsRestjson1_serializeOpStartDataSourceSyncJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStartDataSourceSyncJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartDataSourceSyncJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}/startsync")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStartDataSourceSyncJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStartDataSourceSyncJobInput(v *StartDataSourceSyncJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpStopDataSourceSyncJob struct {
}

func (*awsRestjson1_serializeOpStopDataSourceSyncJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpStopDataSourceSyncJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopDataSourceSyncJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}/stopsync")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsStopDataSourceSyncJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsStopDataSourceSyncJobInput(v *StopDataSourceSyncJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceARN}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceARN == nil || len(*v.ResourceARN) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceARN must not be empty")}
	}
	if v.ResourceARN != nil {
		if err := encoder.SetURI("resourceARN").String(*v.ResourceARN); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{resourceARN}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceARN == nil || len(*v.ResourceARN) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceARN must not be empty")}
	}
	if v.ResourceARN != nil {
		if err := encoder.SetURI("resourceARN").String(*v.ResourceARN); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateApplication struct {
}

func (*awsRestjson1_serializeOpUpdateApplication) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateApplication) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateApplicationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateApplicationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateApplicationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateApplicationInput(v *UpdateApplicationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateApplicationInput(v *UpdateApplicationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttachmentsConfiguration != nil {
		ok := object.Key("attachmentsConfiguration")
		if err := awsRestjson1_serializeDocumentAttachmentsConfiguration(v.AttachmentsConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateChatControlsConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateChatControlsConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateChatControlsConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateChatControlsConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/chatcontrols")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateChatControlsConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateChatControlsConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateChatControlsConfigurationInput(v *UpdateChatControlsConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateChatControlsConfigurationInput(v *UpdateChatControlsConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockedPhrasesConfigurationUpdate != nil {
		ok := object.Key("blockedPhrasesConfigurationUpdate")
		if err := awsRestjson1_serializeDocumentBlockedPhrasesConfigurationUpdate(v.BlockedPhrasesConfigurationUpdate, ok); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		ok := object.Key("clientToken")
		ok.String(*v.ClientToken)
	}

	if len(v.ResponseScope) > 0 {
		ok := object.Key("responseScope")
		ok.String(string(v.ResponseScope))
	}

	if v.TopicConfigurationsToCreateOrUpdate != nil {
		ok := object.Key("topicConfigurationsToCreateOrUpdate")
		if err := awsRestjson1_serializeDocumentTopicConfigurations(v.TopicConfigurationsToCreateOrUpdate, ok); err != nil {
			return err
		}
	}

	if v.TopicConfigurationsToDelete != nil {
		ok := object.Key("topicConfigurationsToDelete")
		if err := awsRestjson1_serializeDocumentTopicConfigurations(v.TopicConfigurationsToDelete, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDataSource struct {
}

func (*awsRestjson1_serializeOpUpdateDataSource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDataSource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDataSourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}/datasources/{dataSourceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDataSourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDataSourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDataSourceInput(v *UpdateDataSourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.DataSourceId == nil || len(*v.DataSourceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member dataSourceId must not be empty")}
	}
	if v.DataSourceId != nil {
		if err := encoder.SetURI("dataSourceId").String(*v.DataSourceId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDataSourceInput(v *UpdateDataSourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentDataSourceConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.DocumentEnrichmentConfiguration != nil {
		ok := object.Key("documentEnrichmentConfiguration")
		if err := awsRestjson1_serializeDocumentDocumentEnrichmentConfiguration(v.DocumentEnrichmentConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SyncSchedule != nil {
		ok := object.Key("syncSchedule")
		ok.String(*v.SyncSchedule)
	}

	if v.VpcConfiguration != nil {
		ok := object.Key("vpcConfiguration")
		if err := awsRestjson1_serializeDocumentDataSourceVpcConfiguration(v.VpcConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateIndex struct {
}

func (*awsRestjson1_serializeOpUpdateIndex) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateIndex) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateIndexInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/indices/{indexId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateIndexInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateIndexInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateIndexInput(v *UpdateIndexInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.IndexId == nil || len(*v.IndexId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member indexId must not be empty")}
	}
	if v.IndexId != nil {
		if err := encoder.SetURI("indexId").String(*v.IndexId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateIndexInput(v *UpdateIndexInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CapacityConfiguration != nil {
		ok := object.Key("capacityConfiguration")
		if err := awsRestjson1_serializeDocumentIndexCapacityConfiguration(v.CapacityConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.DocumentAttributeConfigurations != nil {
		ok := object.Key("documentAttributeConfigurations")
		if err := awsRestjson1_serializeDocumentDocumentAttributeConfigurations(v.DocumentAttributeConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdatePlugin struct {
}

func (*awsRestjson1_serializeOpUpdatePlugin) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdatePlugin) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdatePluginInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/plugins/{pluginId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdatePluginInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdatePluginInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdatePluginInput(v *UpdatePluginInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.PluginId == nil || len(*v.PluginId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member pluginId must not be empty")}
	}
	if v.PluginId != nil {
		if err := encoder.SetURI("pluginId").String(*v.PluginId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdatePluginInput(v *UpdatePluginInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthConfiguration != nil {
		ok := object.Key("authConfiguration")
		if err := awsRestjson1_serializeDocumentPluginAuthConfiguration(v.AuthConfiguration, ok); err != nil {
			return err
		}
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.ServerUrl != nil {
		ok := object.Key("serverUrl")
		ok.String(*v.ServerUrl)
	}

	if len(v.State) > 0 {
		ok := object.Key("state")
		ok.String(string(v.State))
	}

	return nil
}

type awsRestjson1_serializeOpUpdateRetriever struct {
}

func (*awsRestjson1_serializeOpUpdateRetriever) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateRetriever) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRetrieverInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/retrievers/{retrieverId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateRetrieverInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateRetrieverInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateRetrieverInput(v *UpdateRetrieverInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.RetrieverId == nil || len(*v.RetrieverId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member retrieverId must not be empty")}
	}
	if v.RetrieverId != nil {
		if err := encoder.SetURI("retrieverId").String(*v.RetrieverId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateRetrieverInput(v *UpdateRetrieverInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentRetrieverConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.DisplayName != nil {
		ok := object.Key("displayName")
		ok.String(*v.DisplayName)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateUser struct {
}

func (*awsRestjson1_serializeOpUpdateUser) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateUser) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateUserInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/users/{userId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateUserInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateUserInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateUserInput(v *UpdateUserInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.UserId == nil || len(*v.UserId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member userId must not be empty")}
	}
	if v.UserId != nil {
		if err := encoder.SetURI("userId").String(*v.UserId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateUserInput(v *UpdateUserInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserAliasesToDelete != nil {
		ok := object.Key("userAliasesToDelete")
		if err := awsRestjson1_serializeDocumentUserAliases(v.UserAliasesToDelete, ok); err != nil {
			return err
		}
	}

	if v.UserAliasesToUpdate != nil {
		ok := object.Key("userAliasesToUpdate")
		if err := awsRestjson1_serializeDocumentUserAliases(v.UserAliasesToUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateWebExperience struct {
}

func (*awsRestjson1_serializeOpUpdateWebExperience) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateWebExperience) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWebExperienceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/applications/{applicationId}/experiences/{webExperienceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateWebExperienceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateWebExperienceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateWebExperienceInput(v *UpdateWebExperienceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ApplicationId == nil || len(*v.ApplicationId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member applicationId must not be empty")}
	}
	if v.ApplicationId != nil {
		if err := encoder.SetURI("applicationId").String(*v.ApplicationId); err != nil {
			return err
		}
	}

	if v.WebExperienceId == nil || len(*v.WebExperienceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member webExperienceId must not be empty")}
	}
	if v.WebExperienceId != nil {
		if err := encoder.SetURI("webExperienceId").String(*v.WebExperienceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateWebExperienceInput(v *UpdateWebExperienceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AuthenticationConfiguration != nil {
		ok := object.Key("authenticationConfiguration")
		if err := awsRestjson1_serializeDocumentWebExperienceAuthConfiguration(v.AuthenticationConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.SamplePromptsControlMode) > 0 {
		ok := object.Key("samplePromptsControlMode")
		ok.String(string(v.SamplePromptsControlMode))
	}

	if v.Subtitle != nil {
		ok := object.Key("subtitle")
		ok.String(*v.Subtitle)
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	if v.WelcomeMessage != nil {
		ok := object.Key("welcomeMessage")
		ok.String(*v.WelcomeMessage)
	}

	return nil
}

func awsRestjson1_serializeDocumentAccessConfiguration(v *types.AccessConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessControls != nil {
		ok := object.Key("accessControls")
		if err := awsRestjson1_serializeDocumentAccessControls(v.AccessControls, ok); err != nil {
			return err
		}
	}

	if len(v.MemberRelation) > 0 {
		ok := object.Key("memberRelation")
		ok.String(string(v.MemberRelation))
	}

	return nil
}

func awsRestjson1_serializeDocumentAccessControl(v *types.AccessControl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.MemberRelation) > 0 {
		ok := object.Key("memberRelation")
		ok.String(string(v.MemberRelation))
	}

	if v.Principals != nil {
		ok := object.Key("principals")
		if err := awsRestjson1_serializeDocumentPrincipals(v.Principals, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAccessControls(v []types.AccessControl, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAccessControl(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentActionExecution(v *types.ActionExecution, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Payload != nil {
		ok := object.Key("payload")
		if err := awsRestjson1_serializeDocumentActionExecutionPayload(v.Payload, ok); err != nil {
			return err
		}
	}

	if v.PayloadFieldNameSeparator != nil {
		ok := object.Key("payloadFieldNameSeparator")
		ok.String(*v.PayloadFieldNameSeparator)
	}

	if v.PluginId != nil {
		ok := object.Key("pluginId")
		ok.String(*v.PluginId)
	}

	return nil
}

func awsRestjson1_serializeDocumentActionExecutionPayload(v map[string]types.ActionExecutionPayloadField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentActionExecutionPayloadField(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentActionExecutionPayloadField(v *types.ActionExecutionPayloadField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentActionPayloadFieldValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentActionPayloadFieldValue(v document.Interface, value smithyjson.Value) error {
	if v == nil {
		return nil
	}
	if !internaldocument.IsInterface(v) {
		return fmt.Errorf("%T is not a compatible document type", v)
	}
	db, err := v.MarshalSmithyDocument()
	if err != nil {
		return err
	}
	value.Write(db)
	return nil
}

func awsRestjson1_serializeDocumentAttachmentInput(v *types.AttachmentInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Data != nil {
		ok := object.Key("data")
		ok.Base64EncodeBytes(v.Data)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentAttachmentsConfiguration(v *types.AttachmentsConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AttachmentsControlMode) > 0 {
		ok := object.Key("attachmentsControlMode")
		ok.String(string(v.AttachmentsControlMode))
	}

	return nil
}

func awsRestjson1_serializeDocumentAttachmentsInput(v []types.AttachmentInput, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAttachmentInput(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAttributeFilter(v *types.AttributeFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AndAllFilters != nil {
		ok := object.Key("andAllFilters")
		if err := awsRestjson1_serializeDocumentAttributeFilters(v.AndAllFilters, ok); err != nil {
			return err
		}
	}

	if v.ContainsAll != nil {
		ok := object.Key("containsAll")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.ContainsAll, ok); err != nil {
			return err
		}
	}

	if v.ContainsAny != nil {
		ok := object.Key("containsAny")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.ContainsAny, ok); err != nil {
			return err
		}
	}

	if v.EqualsTo != nil {
		ok := object.Key("equalsTo")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.EqualsTo, ok); err != nil {
			return err
		}
	}

	if v.GreaterThan != nil {
		ok := object.Key("greaterThan")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.GreaterThan, ok); err != nil {
			return err
		}
	}

	if v.GreaterThanOrEquals != nil {
		ok := object.Key("greaterThanOrEquals")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.GreaterThanOrEquals, ok); err != nil {
			return err
		}
	}

	if v.LessThan != nil {
		ok := object.Key("lessThan")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.LessThan, ok); err != nil {
			return err
		}
	}

	if v.LessThanOrEquals != nil {
		ok := object.Key("lessThanOrEquals")
		if err := awsRestjson1_serializeDocumentDocumentAttribute(v.LessThanOrEquals, ok); err != nil {
			return err
		}
	}

	if v.NotFilter != nil {
		ok := object.Key("notFilter")
		if err := awsRestjson1_serializeDocumentAttributeFilter(v.NotFilter, ok); err != nil {
			return err
		}
	}

	if v.OrAllFilters != nil {
		ok := object.Key("orAllFilters")
		if err := awsRestjson1_serializeDocumentAttributeFilters(v.OrAllFilters, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributeFilters(v []types.AttributeFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAttributeFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentBasicAuthConfiguration(v *types.BasicAuthConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretArn != nil {
		ok := object.Key("secretArn")
		ok.String(*v.SecretArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentBlockedPhrases(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentBlockedPhrasesConfigurationUpdate(v *types.BlockedPhrasesConfigurationUpdate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BlockedPhrasesToCreateOrUpdate != nil {
		ok := object.Key("blockedPhrasesToCreateOrUpdate")
		if err := awsRestjson1_serializeDocumentBlockedPhrases(v.BlockedPhrasesToCreateOrUpdate, ok); err != nil {
			return err
		}
	}

	if v.BlockedPhrasesToDelete != nil {
		ok := object.Key("blockedPhrasesToDelete")
		if err := awsRestjson1_serializeDocumentBlockedPhrases(v.BlockedPhrasesToDelete, ok); err != nil {
			return err
		}
	}

	if v.SystemMessageOverride != nil {
		ok := object.Key("systemMessageOverride")
		ok.String(*v.SystemMessageOverride)
	}

	return nil
}

func awsRestjson1_serializeDocumentContentBlockerRule(v *types.ContentBlockerRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SystemMessageOverride != nil {
		ok := object.Key("systemMessageOverride")
		ok.String(*v.SystemMessageOverride)
	}

	return nil
}

func awsRestjson1_serializeDocumentContentRetrievalRule(v *types.ContentRetrievalRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EligibleDataSources != nil {
		ok := object.Key("eligibleDataSources")
		if err := awsRestjson1_serializeDocumentEligibleDataSources(v.EligibleDataSources, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataSourceConfiguration(v document.Interface, value smithyjson.Value) error {
	if v == nil {
		return nil
	}
	if !internaldocument.IsInterface(v) {
		return fmt.Errorf("%T is not a compatible document type", v)
	}
	db, err := v.MarshalSmithyDocument()
	if err != nil {
		return err
	}
	value.Write(db)
	return nil
}

func awsRestjson1_serializeDocumentDataSourceVpcConfiguration(v *types.DataSourceVpcConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocumentSecurityGroupIds(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocumentSubnetIds(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDateAttributeBoostingConfiguration(v *types.DateAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoostingDurationInSeconds != nil {
		ok := object.Key("boostingDurationInSeconds")
		ok.Long(*v.BoostingDurationInSeconds)
	}

	if len(v.BoostingLevel) > 0 {
		ok := object.Key("boostingLevel")
		ok.String(string(v.BoostingLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentDeleteDocument(v *types.DeleteDocument, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DocumentId != nil {
		ok := object.Key("documentId")
		ok.String(*v.DocumentId)
	}

	return nil
}

func awsRestjson1_serializeDocumentDeleteDocuments(v []types.DeleteDocument, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDeleteDocument(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDocument(v *types.Document, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccessConfiguration != nil {
		ok := object.Key("accessConfiguration")
		if err := awsRestjson1_serializeDocumentAccessConfiguration(v.AccessConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Attributes != nil {
		ok := object.Key("attributes")
		if err := awsRestjson1_serializeDocumentDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.Content != nil {
		ok := object.Key("content")
		if err := awsRestjson1_serializeDocumentDocumentContent(v.Content, ok); err != nil {
			return err
		}
	}

	if len(v.ContentType) > 0 {
		ok := object.Key("contentType")
		ok.String(string(v.ContentType))
	}

	if v.DocumentEnrichmentConfiguration != nil {
		ok := object.Key("documentEnrichmentConfiguration")
		if err := awsRestjson1_serializeDocumentDocumentEnrichmentConfiguration(v.DocumentEnrichmentConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.Title != nil {
		ok := object.Key("title")
		ok.String(*v.Title)
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentAttribute(v *types.DocumentAttribute, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentDocumentAttributeValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeBoostingConfiguration(v types.DocumentAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DocumentAttributeBoostingConfigurationMemberDateConfiguration:
		av := object.Key("dateConfiguration")
		if err := awsRestjson1_serializeDocumentDateAttributeBoostingConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.DocumentAttributeBoostingConfigurationMemberNumberConfiguration:
		av := object.Key("numberConfiguration")
		if err := awsRestjson1_serializeDocumentNumberAttributeBoostingConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.DocumentAttributeBoostingConfigurationMemberStringConfiguration:
		av := object.Key("stringConfiguration")
		if err := awsRestjson1_serializeDocumentStringAttributeBoostingConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.DocumentAttributeBoostingConfigurationMemberStringListConfiguration:
		av := object.Key("stringListConfiguration")
		if err := awsRestjson1_serializeDocumentStringListAttributeBoostingConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeBoostingOverrideMap(v map[string]types.DocumentAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentDocumentAttributeBoostingConfiguration(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeCondition(v *types.DocumentAttributeCondition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if len(v.Operator) > 0 {
		ok := object.Key("operator")
		ok.String(string(v.Operator))
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentDocumentAttributeValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeConfiguration(v *types.DocumentAttributeConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if len(v.Search) > 0 {
		ok := object.Key("search")
		ok.String(string(v.Search))
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeConfigurations(v []types.DocumentAttributeConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDocumentAttributeConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributes(v []types.DocumentAttribute, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDocumentAttribute(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeStringListValue(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeTarget(v *types.DocumentAttributeTarget, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.AttributeValueOperator) > 0 {
		ok := object.Key("attributeValueOperator")
		ok.String(string(v.AttributeValueOperator))
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentDocumentAttributeValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocumentAttributeValue(v types.DocumentAttributeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DocumentAttributeValueMemberDateValue:
		av := object.Key("dateValue")
		av.Double(smithytime.FormatEpochSeconds(uv.Value))

	case *types.DocumentAttributeValueMemberLongValue:
		av := object.Key("longValue")
		av.Long(uv.Value)

	case *types.DocumentAttributeValueMemberStringListValue:
		av := object.Key("stringListValue")
		if err := awsRestjson1_serializeDocumentDocumentAttributeStringListValue(uv.Value, av); err != nil {
			return err
		}

	case *types.DocumentAttributeValueMemberStringValue:
		av := object.Key("stringValue")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentContent(v types.DocumentContent, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.DocumentContentMemberBlob:
		av := object.Key("blob")
		av.Base64EncodeBytes(uv.Value)

	case *types.DocumentContentMemberS3:
		av := object.Key("s3")
		if err := awsRestjson1_serializeDocumentS3(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentDocumentEnrichmentConfiguration(v *types.DocumentEnrichmentConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InlineConfigurations != nil {
		ok := object.Key("inlineConfigurations")
		if err := awsRestjson1_serializeDocumentInlineDocumentEnrichmentConfigurations(v.InlineConfigurations, ok); err != nil {
			return err
		}
	}

	if v.PostExtractionHookConfiguration != nil {
		ok := object.Key("postExtractionHookConfiguration")
		if err := awsRestjson1_serializeDocumentHookConfiguration(v.PostExtractionHookConfiguration, ok); err != nil {
			return err
		}
	}

	if v.PreExtractionHookConfiguration != nil {
		ok := object.Key("preExtractionHookConfiguration")
		if err := awsRestjson1_serializeDocumentHookConfiguration(v.PreExtractionHookConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDocuments(v []types.Document, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDocument(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEligibleDataSource(v *types.EligibleDataSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceId != nil {
		ok := object.Key("dataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.IndexId != nil {
		ok := object.Key("indexId")
		ok.String(*v.IndexId)
	}

	return nil
}

func awsRestjson1_serializeDocumentEligibleDataSources(v []types.EligibleDataSource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentEligibleDataSource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEncryptionConfiguration(v *types.EncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KmsKeyId != nil {
		ok := object.Key("kmsKeyId")
		ok.String(*v.KmsKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentExampleChatMessages(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentGroupMembers(v *types.GroupMembers, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MemberGroups != nil {
		ok := object.Key("memberGroups")
		if err := awsRestjson1_serializeDocumentMemberGroups(v.MemberGroups, ok); err != nil {
			return err
		}
	}

	if v.MemberUsers != nil {
		ok := object.Key("memberUsers")
		if err := awsRestjson1_serializeDocumentMemberUsers(v.MemberUsers, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentHookConfiguration(v *types.HookConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.InvocationCondition != nil {
		ok := object.Key("invocationCondition")
		if err := awsRestjson1_serializeDocumentDocumentAttributeCondition(v.InvocationCondition, ok); err != nil {
			return err
		}
	}

	if v.LambdaArn != nil {
		ok := object.Key("lambdaArn")
		ok.String(*v.LambdaArn)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.S3BucketName != nil {
		ok := object.Key("s3BucketName")
		ok.String(*v.S3BucketName)
	}

	return nil
}

func awsRestjson1_serializeDocumentIndexCapacityConfiguration(v *types.IndexCapacityConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Units != nil {
		ok := object.Key("units")
		ok.Integer(*v.Units)
	}

	return nil
}

func awsRestjson1_serializeDocumentInlineDocumentEnrichmentConfiguration(v *types.InlineDocumentEnrichmentConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Condition != nil {
		ok := object.Key("condition")
		if err := awsRestjson1_serializeDocumentDocumentAttributeCondition(v.Condition, ok); err != nil {
			return err
		}
	}

	if len(v.DocumentContentOperator) > 0 {
		ok := object.Key("documentContentOperator")
		ok.String(string(v.DocumentContentOperator))
	}

	if v.Target != nil {
		ok := object.Key("target")
		if err := awsRestjson1_serializeDocumentDocumentAttributeTarget(v.Target, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentInlineDocumentEnrichmentConfigurations(v []types.InlineDocumentEnrichmentConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentInlineDocumentEnrichmentConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentKendraIndexConfiguration(v *types.KendraIndexConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IndexId != nil {
		ok := object.Key("indexId")
		ok.String(*v.IndexId)
	}

	return nil
}

func awsRestjson1_serializeDocumentMemberGroup(v *types.MemberGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GroupName != nil {
		ok := object.Key("groupName")
		ok.String(*v.GroupName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsRestjson1_serializeDocumentMemberGroups(v []types.MemberGroup, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMemberGroup(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMemberUser(v *types.MemberUser, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.UserId != nil {
		ok := object.Key("userId")
		ok.String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeDocumentMemberUsers(v []types.MemberUser, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentMemberUser(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMessageUsefulnessFeedback(v *types.MessageUsefulnessFeedback, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Comment != nil {
		ok := object.Key("comment")
		ok.String(*v.Comment)
	}

	if len(v.Reason) > 0 {
		ok := object.Key("reason")
		ok.String(string(v.Reason))
	}

	if v.SubmittedAt != nil {
		ok := object.Key("submittedAt")
		ok.Double(smithytime.FormatEpochSeconds(*v.SubmittedAt))
	}

	if len(v.Usefulness) > 0 {
		ok := object.Key("usefulness")
		ok.String(string(v.Usefulness))
	}

	return nil
}

func awsRestjson1_serializeDocumentNativeIndexConfiguration(v *types.NativeIndexConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BoostingOverride != nil {
		ok := object.Key("boostingOverride")
		if err := awsRestjson1_serializeDocumentDocumentAttributeBoostingOverrideMap(v.BoostingOverride, ok); err != nil {
			return err
		}
	}

	if v.IndexId != nil {
		ok := object.Key("indexId")
		ok.String(*v.IndexId)
	}

	return nil
}

func awsRestjson1_serializeDocumentNumberAttributeBoostingConfiguration(v *types.NumberAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BoostingLevel) > 0 {
		ok := object.Key("boostingLevel")
		ok.String(string(v.BoostingLevel))
	}

	if len(v.BoostingType) > 0 {
		ok := object.Key("boostingType")
		ok.String(string(v.BoostingType))
	}

	return nil
}

func awsRestjson1_serializeDocumentOAuth2ClientCredentialConfiguration(v *types.OAuth2ClientCredentialConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.SecretArn != nil {
		ok := object.Key("secretArn")
		ok.String(*v.SecretArn)
	}

	return nil
}

func awsRestjson1_serializeDocumentPluginAuthConfiguration(v types.PluginAuthConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PluginAuthConfigurationMemberBasicAuthConfiguration:
		av := object.Key("basicAuthConfiguration")
		if err := awsRestjson1_serializeDocumentBasicAuthConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.PluginAuthConfigurationMemberOAuth2ClientCredentialConfiguration:
		av := object.Key("oAuth2ClientCredentialConfiguration")
		if err := awsRestjson1_serializeDocumentOAuth2ClientCredentialConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentPrincipal(v types.Principal, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.PrincipalMemberGroup:
		av := object.Key("group")
		if err := awsRestjson1_serializeDocumentPrincipalGroup(&uv.Value, av); err != nil {
			return err
		}

	case *types.PrincipalMemberUser:
		av := object.Key("user")
		if err := awsRestjson1_serializeDocumentPrincipalUser(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentPrincipalGroup(v *types.PrincipalGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Access) > 0 {
		ok := object.Key("access")
		ok.String(string(v.Access))
	}

	if len(v.MembershipType) > 0 {
		ok := object.Key("membershipType")
		ok.String(string(v.MembershipType))
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	return nil
}

func awsRestjson1_serializeDocumentPrincipals(v []types.Principal, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentPrincipal(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPrincipalUser(v *types.PrincipalUser, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Access) > 0 {
		ok := object.Key("access")
		ok.String(string(v.Access))
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if len(v.MembershipType) > 0 {
		ok := object.Key("membershipType")
		ok.String(string(v.MembershipType))
	}

	return nil
}

func awsRestjson1_serializeDocumentRetrieverConfiguration(v types.RetrieverConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RetrieverConfigurationMemberKendraIndexConfiguration:
		av := object.Key("kendraIndexConfiguration")
		if err := awsRestjson1_serializeDocumentKendraIndexConfiguration(&uv.Value, av); err != nil {
			return err
		}

	case *types.RetrieverConfigurationMemberNativeIndexConfiguration:
		av := object.Key("nativeIndexConfiguration")
		if err := awsRestjson1_serializeDocumentNativeIndexConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRule(v *types.Rule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExcludedUsersAndGroups != nil {
		ok := object.Key("excludedUsersAndGroups")
		if err := awsRestjson1_serializeDocumentUsersAndGroups(v.ExcludedUsersAndGroups, ok); err != nil {
			return err
		}
	}

	if v.IncludedUsersAndGroups != nil {
		ok := object.Key("includedUsersAndGroups")
		if err := awsRestjson1_serializeDocumentUsersAndGroups(v.IncludedUsersAndGroups, ok); err != nil {
			return err
		}
	}

	if v.RuleConfiguration != nil {
		ok := object.Key("ruleConfiguration")
		if err := awsRestjson1_serializeDocumentRuleConfiguration(v.RuleConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.RuleType) > 0 {
		ok := object.Key("ruleType")
		ok.String(string(v.RuleType))
	}

	return nil
}

func awsRestjson1_serializeDocumentRuleConfiguration(v types.RuleConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.RuleConfigurationMemberContentBlockerRule:
		av := object.Key("contentBlockerRule")
		if err := awsRestjson1_serializeDocumentContentBlockerRule(&uv.Value, av); err != nil {
			return err
		}

	case *types.RuleConfigurationMemberContentRetrievalRule:
		av := object.Key("contentRetrievalRule")
		if err := awsRestjson1_serializeDocumentContentRetrievalRule(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentRules(v []types.Rule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentS3(v *types.S3, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	return nil
}

func awsRestjson1_serializeDocumentSamlConfiguration(v *types.SamlConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MetadataXML != nil {
		ok := object.Key("metadataXML")
		ok.String(*v.MetadataXML)
	}

	if v.RoleArn != nil {
		ok := object.Key("roleArn")
		ok.String(*v.RoleArn)
	}

	if v.UserGroupAttribute != nil {
		ok := object.Key("userGroupAttribute")
		ok.String(*v.UserGroupAttribute)
	}

	if v.UserIdAttribute != nil {
		ok := object.Key("userIdAttribute")
		ok.String(*v.UserIdAttribute)
	}

	return nil
}

func awsRestjson1_serializeDocumentSecurityGroupIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentStringAttributeBoostingConfiguration(v *types.StringAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AttributeValueBoosting != nil {
		ok := object.Key("attributeValueBoosting")
		if err := awsRestjson1_serializeDocumentStringAttributeValueBoosting(v.AttributeValueBoosting, ok); err != nil {
			return err
		}
	}

	if len(v.BoostingLevel) > 0 {
		ok := object.Key("boostingLevel")
		ok.String(string(v.BoostingLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentStringAttributeValueBoosting(v map[string]types.StringAttributeValueBoostingLevel, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(string(v[key]))
	}
	return nil
}

func awsRestjson1_serializeDocumentStringListAttributeBoostingConfiguration(v *types.StringListAttributeBoostingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BoostingLevel) > 0 {
		ok := object.Key("boostingLevel")
		ok.String(string(v.BoostingLevel))
	}

	return nil
}

func awsRestjson1_serializeDocumentSubnetIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentTags(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTopicConfiguration(v *types.TopicConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExampleChatMessages != nil {
		ok := object.Key("exampleChatMessages")
		if err := awsRestjson1_serializeDocumentExampleChatMessages(v.ExampleChatMessages, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Rules != nil {
		ok := object.Key("rules")
		if err := awsRestjson1_serializeDocumentRules(v.Rules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTopicConfigurations(v []types.TopicConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTopicConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUserAlias(v *types.UserAlias, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataSourceId != nil {
		ok := object.Key("dataSourceId")
		ok.String(*v.DataSourceId)
	}

	if v.IndexId != nil {
		ok := object.Key("indexId")
		ok.String(*v.IndexId)
	}

	if v.UserId != nil {
		ok := object.Key("userId")
		ok.String(*v.UserId)
	}

	return nil
}

func awsRestjson1_serializeDocumentUserAliases(v []types.UserAlias, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentUserAlias(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUserGroups(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentUserIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentUsersAndGroups(v *types.UsersAndGroups, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.UserGroups != nil {
		ok := object.Key("userGroups")
		if err := awsRestjson1_serializeDocumentUserGroups(v.UserGroups, ok); err != nil {
			return err
		}
	}

	if v.UserIds != nil {
		ok := object.Key("userIds")
		if err := awsRestjson1_serializeDocumentUserIds(v.UserIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentWebExperienceAuthConfiguration(v types.WebExperienceAuthConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.WebExperienceAuthConfigurationMemberSamlConfiguration:
		av := object.Key("samlConfiguration")
		if err := awsRestjson1_serializeDocumentSamlConfiguration(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}
