// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptography

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptography/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson10_serializeOpCreateAlias struct {
}

func (*awsAwsjson10_serializeOpCreateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.CreateAlias")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateKey struct {
}

func (*awsAwsjson10_serializeOpCreateKey) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.CreateKey")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteAlias struct {
}

func (*awsAwsjson10_serializeOpDeleteAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.DeleteAlias")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteKey struct {
}

func (*awsAwsjson10_serializeOpDeleteKey) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.DeleteKey")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpExportKey struct {
}

func (*awsAwsjson10_serializeOpExportKey) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpExportKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.ExportKey")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentExportKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetAlias struct {
}

func (*awsAwsjson10_serializeOpGetAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.GetAlias")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetKey struct {
}

func (*awsAwsjson10_serializeOpGetKey) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.GetKey")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetParametersForExport struct {
}

func (*awsAwsjson10_serializeOpGetParametersForExport) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetParametersForExport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetParametersForExportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.GetParametersForExport")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetParametersForExportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetParametersForImport struct {
}

func (*awsAwsjson10_serializeOpGetParametersForImport) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetParametersForImport) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetParametersForImportInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.GetParametersForImport")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetParametersForImportInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpGetPublicKeyCertificate struct {
}

func (*awsAwsjson10_serializeOpGetPublicKeyCertificate) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpGetPublicKeyCertificate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPublicKeyCertificateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.GetPublicKeyCertificate")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentGetPublicKeyCertificateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpImportKey struct {
}

func (*awsAwsjson10_serializeOpImportKey) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpImportKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ImportKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.ImportKey")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentImportKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListAliases struct {
}

func (*awsAwsjson10_serializeOpListAliases) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListAliases) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAliasesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.ListAliases")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListAliasesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListKeys struct {
}

func (*awsAwsjson10_serializeOpListKeys) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListKeys) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListKeysInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.ListKeys")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListKeysInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListTagsForResource struct {
}

func (*awsAwsjson10_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpRestoreKey struct {
}

func (*awsAwsjson10_serializeOpRestoreKey) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpRestoreKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RestoreKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.RestoreKey")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentRestoreKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpStartKeyUsage struct {
}

func (*awsAwsjson10_serializeOpStartKeyUsage) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpStartKeyUsage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StartKeyUsageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.StartKeyUsage")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentStartKeyUsageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpStopKeyUsage struct {
}

func (*awsAwsjson10_serializeOpStopKeyUsage) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpStopKeyUsage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*StopKeyUsageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.StopKeyUsage")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentStopKeyUsageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpTagResource struct {
}

func (*awsAwsjson10_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUntagResource struct {
}

func (*awsAwsjson10_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateAlias struct {
}

func (*awsAwsjson10_serializeOpUpdateAlias) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateAlias) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateAliasInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("PaymentCryptographyControlPlane.UpdateAlias")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateAliasInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson10_serializeDocumentExportAttributes(v *types.ExportAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExportDukptInitialKey != nil {
		ok := object.Key("ExportDukptInitialKey")
		if err := awsAwsjson10_serializeDocumentExportDukptInitialKey(v.ExportDukptInitialKey, ok); err != nil {
			return err
		}
	}

	if len(v.KeyCheckValueAlgorithm) > 0 {
		ok := object.Key("KeyCheckValueAlgorithm")
		ok.String(string(v.KeyCheckValueAlgorithm))
	}

	return nil
}

func awsAwsjson10_serializeDocumentExportDukptInitialKey(v *types.ExportDukptInitialKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeySerialNumber != nil {
		ok := object.Key("KeySerialNumber")
		ok.String(*v.KeySerialNumber)
	}

	return nil
}

func awsAwsjson10_serializeDocumentExportKeyCryptogram(v *types.ExportKeyCryptogram, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityPublicKeyIdentifier != nil {
		ok := object.Key("CertificateAuthorityPublicKeyIdentifier")
		ok.String(*v.CertificateAuthorityPublicKeyIdentifier)
	}

	if v.WrappingKeyCertificate != nil {
		ok := object.Key("WrappingKeyCertificate")
		ok.String(*v.WrappingKeyCertificate)
	}

	if len(v.WrappingSpec) > 0 {
		ok := object.Key("WrappingSpec")
		ok.String(string(v.WrappingSpec))
	}

	return nil
}

func awsAwsjson10_serializeDocumentExportKeyMaterial(v types.ExportKeyMaterial, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ExportKeyMaterialMemberKeyCryptogram:
		av := object.Key("KeyCryptogram")
		if err := awsAwsjson10_serializeDocumentExportKeyCryptogram(&uv.Value, av); err != nil {
			return err
		}

	case *types.ExportKeyMaterialMemberTr31KeyBlock:
		av := object.Key("Tr31KeyBlock")
		if err := awsAwsjson10_serializeDocumentExportTr31KeyBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ExportKeyMaterialMemberTr34KeyBlock:
		av := object.Key("Tr34KeyBlock")
		if err := awsAwsjson10_serializeDocumentExportTr34KeyBlock(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentExportTr31KeyBlock(v *types.ExportTr31KeyBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WrappingKeyIdentifier != nil {
		ok := object.Key("WrappingKeyIdentifier")
		ok.String(*v.WrappingKeyIdentifier)
	}

	return nil
}

func awsAwsjson10_serializeDocumentExportTr34KeyBlock(v *types.ExportTr34KeyBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityPublicKeyIdentifier != nil {
		ok := object.Key("CertificateAuthorityPublicKeyIdentifier")
		ok.String(*v.CertificateAuthorityPublicKeyIdentifier)
	}

	if v.ExportToken != nil {
		ok := object.Key("ExportToken")
		ok.String(*v.ExportToken)
	}

	if len(v.KeyBlockFormat) > 0 {
		ok := object.Key("KeyBlockFormat")
		ok.String(string(v.KeyBlockFormat))
	}

	if v.RandomNonce != nil {
		ok := object.Key("RandomNonce")
		ok.String(*v.RandomNonce)
	}

	if v.WrappingKeyCertificate != nil {
		ok := object.Key("WrappingKeyCertificate")
		ok.String(*v.WrappingKeyCertificate)
	}

	return nil
}

func awsAwsjson10_serializeDocumentImportKeyCryptogram(v *types.ImportKeyCryptogram, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Exportable != nil {
		ok := object.Key("Exportable")
		ok.Boolean(*v.Exportable)
	}

	if v.ImportToken != nil {
		ok := object.Key("ImportToken")
		ok.String(*v.ImportToken)
	}

	if v.KeyAttributes != nil {
		ok := object.Key("KeyAttributes")
		if err := awsAwsjson10_serializeDocumentKeyAttributes(v.KeyAttributes, ok); err != nil {
			return err
		}
	}

	if v.WrappedKeyCryptogram != nil {
		ok := object.Key("WrappedKeyCryptogram")
		ok.String(*v.WrappedKeyCryptogram)
	}

	if len(v.WrappingSpec) > 0 {
		ok := object.Key("WrappingSpec")
		ok.String(string(v.WrappingSpec))
	}

	return nil
}

func awsAwsjson10_serializeDocumentImportKeyMaterial(v types.ImportKeyMaterial, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ImportKeyMaterialMemberKeyCryptogram:
		av := object.Key("KeyCryptogram")
		if err := awsAwsjson10_serializeDocumentImportKeyCryptogram(&uv.Value, av); err != nil {
			return err
		}

	case *types.ImportKeyMaterialMemberRootCertificatePublicKey:
		av := object.Key("RootCertificatePublicKey")
		if err := awsAwsjson10_serializeDocumentRootCertificatePublicKey(&uv.Value, av); err != nil {
			return err
		}

	case *types.ImportKeyMaterialMemberTr31KeyBlock:
		av := object.Key("Tr31KeyBlock")
		if err := awsAwsjson10_serializeDocumentImportTr31KeyBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ImportKeyMaterialMemberTr34KeyBlock:
		av := object.Key("Tr34KeyBlock")
		if err := awsAwsjson10_serializeDocumentImportTr34KeyBlock(&uv.Value, av); err != nil {
			return err
		}

	case *types.ImportKeyMaterialMemberTrustedCertificatePublicKey:
		av := object.Key("TrustedCertificatePublicKey")
		if err := awsAwsjson10_serializeDocumentTrustedCertificatePublicKey(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsAwsjson10_serializeDocumentImportTr31KeyBlock(v *types.ImportTr31KeyBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WrappedKeyBlock != nil {
		ok := object.Key("WrappedKeyBlock")
		ok.String(*v.WrappedKeyBlock)
	}

	if v.WrappingKeyIdentifier != nil {
		ok := object.Key("WrappingKeyIdentifier")
		ok.String(*v.WrappingKeyIdentifier)
	}

	return nil
}

func awsAwsjson10_serializeDocumentImportTr34KeyBlock(v *types.ImportTr34KeyBlock, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityPublicKeyIdentifier != nil {
		ok := object.Key("CertificateAuthorityPublicKeyIdentifier")
		ok.String(*v.CertificateAuthorityPublicKeyIdentifier)
	}

	if v.ImportToken != nil {
		ok := object.Key("ImportToken")
		ok.String(*v.ImportToken)
	}

	if len(v.KeyBlockFormat) > 0 {
		ok := object.Key("KeyBlockFormat")
		ok.String(string(v.KeyBlockFormat))
	}

	if v.RandomNonce != nil {
		ok := object.Key("RandomNonce")
		ok.String(*v.RandomNonce)
	}

	if v.SigningKeyCertificate != nil {
		ok := object.Key("SigningKeyCertificate")
		ok.String(*v.SigningKeyCertificate)
	}

	if v.WrappedKeyBlock != nil {
		ok := object.Key("WrappedKeyBlock")
		ok.String(*v.WrappedKeyBlock)
	}

	return nil
}

func awsAwsjson10_serializeDocumentKeyAttributes(v *types.KeyAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.KeyAlgorithm) > 0 {
		ok := object.Key("KeyAlgorithm")
		ok.String(string(v.KeyAlgorithm))
	}

	if len(v.KeyClass) > 0 {
		ok := object.Key("KeyClass")
		ok.String(string(v.KeyClass))
	}

	if v.KeyModesOfUse != nil {
		ok := object.Key("KeyModesOfUse")
		if err := awsAwsjson10_serializeDocumentKeyModesOfUse(v.KeyModesOfUse, ok); err != nil {
			return err
		}
	}

	if len(v.KeyUsage) > 0 {
		ok := object.Key("KeyUsage")
		ok.String(string(v.KeyUsage))
	}

	return nil
}

func awsAwsjson10_serializeDocumentKeyModesOfUse(v *types.KeyModesOfUse, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Decrypt {
		ok := object.Key("Decrypt")
		ok.Boolean(v.Decrypt)
	}

	if v.DeriveKey {
		ok := object.Key("DeriveKey")
		ok.Boolean(v.DeriveKey)
	}

	if v.Encrypt {
		ok := object.Key("Encrypt")
		ok.Boolean(v.Encrypt)
	}

	if v.Generate {
		ok := object.Key("Generate")
		ok.Boolean(v.Generate)
	}

	if v.NoRestrictions {
		ok := object.Key("NoRestrictions")
		ok.Boolean(v.NoRestrictions)
	}

	if v.Sign {
		ok := object.Key("Sign")
		ok.Boolean(v.Sign)
	}

	if v.Unwrap {
		ok := object.Key("Unwrap")
		ok.Boolean(v.Unwrap)
	}

	if v.Verify {
		ok := object.Key("Verify")
		ok.Boolean(v.Verify)
	}

	if v.Wrap {
		ok := object.Key("Wrap")
		ok.Boolean(v.Wrap)
	}

	return nil
}

func awsAwsjson10_serializeDocumentRootCertificatePublicKey(v *types.RootCertificatePublicKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyAttributes != nil {
		ok := object.Key("KeyAttributes")
		if err := awsAwsjson10_serializeDocumentKeyAttributes(v.KeyAttributes, ok); err != nil {
			return err
		}
	}

	if v.PublicKeyCertificate != nil {
		ok := object.Key("PublicKeyCertificate")
		ok.String(*v.PublicKeyCertificate)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTagKeys(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentTags(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentTrustedCertificatePublicKey(v *types.TrustedCertificatePublicKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityPublicKeyIdentifier != nil {
		ok := object.Key("CertificateAuthorityPublicKeyIdentifier")
		ok.String(*v.CertificateAuthorityPublicKeyIdentifier)
	}

	if v.KeyAttributes != nil {
		ok := object.Key("KeyAttributes")
		if err := awsAwsjson10_serializeDocumentKeyAttributes(v.KeyAttributes, ok); err != nil {
			return err
		}
	}

	if v.PublicKeyCertificate != nil {
		ok := object.Key("PublicKeyCertificate")
		ok.String(*v.PublicKeyCertificate)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateAliasInput(v *CreateAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasName != nil {
		ok := object.Key("AliasName")
		ok.String(*v.AliasName)
	}

	if v.KeyArn != nil {
		ok := object.Key("KeyArn")
		ok.String(*v.KeyArn)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateKeyInput(v *CreateKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.Exportable != nil {
		ok := object.Key("Exportable")
		ok.Boolean(*v.Exportable)
	}

	if v.KeyAttributes != nil {
		ok := object.Key("KeyAttributes")
		if err := awsAwsjson10_serializeDocumentKeyAttributes(v.KeyAttributes, ok); err != nil {
			return err
		}
	}

	if len(v.KeyCheckValueAlgorithm) > 0 {
		ok := object.Key("KeyCheckValueAlgorithm")
		ok.String(string(v.KeyCheckValueAlgorithm))
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteAliasInput(v *DeleteAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasName != nil {
		ok := object.Key("AliasName")
		ok.String(*v.AliasName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteKeyInput(v *DeleteKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeleteKeyInDays != nil {
		ok := object.Key("DeleteKeyInDays")
		ok.Integer(*v.DeleteKeyInDays)
	}

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentExportKeyInput(v *ExportKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ExportAttributes != nil {
		ok := object.Key("ExportAttributes")
		if err := awsAwsjson10_serializeDocumentExportAttributes(v.ExportAttributes, ok); err != nil {
			return err
		}
	}

	if v.ExportKeyIdentifier != nil {
		ok := object.Key("ExportKeyIdentifier")
		ok.String(*v.ExportKeyIdentifier)
	}

	if v.KeyMaterial != nil {
		ok := object.Key("KeyMaterial")
		if err := awsAwsjson10_serializeDocumentExportKeyMaterial(v.KeyMaterial, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetAliasInput(v *GetAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasName != nil {
		ok := object.Key("AliasName")
		ok.String(*v.AliasName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetKeyInput(v *GetKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetParametersForExportInput(v *GetParametersForExportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.KeyMaterialType) > 0 {
		ok := object.Key("KeyMaterialType")
		ok.String(string(v.KeyMaterialType))
	}

	if len(v.SigningKeyAlgorithm) > 0 {
		ok := object.Key("SigningKeyAlgorithm")
		ok.String(string(v.SigningKeyAlgorithm))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetParametersForImportInput(v *GetParametersForImportInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.KeyMaterialType) > 0 {
		ok := object.Key("KeyMaterialType")
		ok.String(string(v.KeyMaterialType))
	}

	if len(v.WrappingKeyAlgorithm) > 0 {
		ok := object.Key("WrappingKeyAlgorithm")
		ok.String(string(v.WrappingKeyAlgorithm))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentGetPublicKeyCertificateInput(v *GetPublicKeyCertificateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentImportKeyInput(v *ImportKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if len(v.KeyCheckValueAlgorithm) > 0 {
		ok := object.Key("KeyCheckValueAlgorithm")
		ok.String(string(v.KeyCheckValueAlgorithm))
	}

	if v.KeyMaterial != nil {
		ok := object.Key("KeyMaterial")
		if err := awsAwsjson10_serializeDocumentImportKeyMaterial(v.KeyMaterial, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListAliasesInput(v *ListAliasesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListKeysInput(v *ListKeysInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.KeyState) > 0 {
		ok := object.Key("KeyState")
		ok.String(string(v.KeyState))
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentRestoreKeyInput(v *RestoreKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentStartKeyUsageInput(v *StartKeyUsageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentStopKeyUsageInput(v *StopKeyUsageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyIdentifier != nil {
		ok := object.Key("KeyIdentifier")
		ok.String(*v.KeyIdentifier)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson10_serializeDocumentTagKeys(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateAliasInput(v *UpdateAliasInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AliasName != nil {
		ok := object.Key("AliasName")
		ok.String(*v.AliasName)
	}

	if v.KeyArn != nil {
		ok := object.Key("KeyArn")
		ok.String(*v.KeyArn)
	}

	return nil
}
